CREATE TABLE DWENTITIES(
        ID RAW(16),
        PARENTID RAW(16) NULL,
        REFERENCEID RAW(16) NULL,
        CREATEDBY RAW(16) NULL,
        CHANGEDBY RAW(16) NULL,
        CREATED DATE NULL,
        CHANGED DATE NULL,
        NAME NVARCHAR2(2000) NULL,
        DATAMODELNAME NVARCHAR2(256) NOT NULL,
        SCHEMENAME NVARCHAR2(256) NULL,
        STATE NVARCHAR2(2000) NULL,
        STATENAME NVARCHAR2(2000) NULL,
        EXTENSIONS CLOB NULL,
        CONSTRAINT PK_DWENTITIES PRIMARY KEY (ID) USING INDEX STORAGE ( INITIAL 64K NEXT 1M MAXEXTENTS UNLIMITED ),
        CONSTRAINT DWENTITIES_EXTENSIONS_JSON CHECK (EXTENSIONS IS JSON))
LOGGING;

CREATE INDEX IX_DWENTITIES_DATAMODELNAME ON DWENTITIES (DATAMODELNAME)
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  TABLESPACE USERS;
  
CREATE INDEX IX_DWENTITIES_PARENTID ON DWENTITIES (PARENTID);
CREATE INDEX IX_DWENTITIES_REFERENCEID ON DWENTITIES (REFERENCEID);

CREATE OR REPLACE PACKAGE DWKIT AS

    FUNCTION UPDATE_JSON_NUMBER(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN NUMBER) RETURN VARCHAR2;
    FUNCTION UPDATE_JSON_NVARCHAR2(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN VARCHAR2) RETURN VARCHAR2;
    FUNCTION UPDATE_JSON_CHAR(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN CHAR) RETURN VARCHAR2;
    FUNCTION UPDATE_JSON_BLOB(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN BLOB) RETURN VARCHAR2;
    FUNCTION UPDATE_JSON_RAW(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN RAW) RETURN VARCHAR2;
    FUNCTION UPDATE_JSON_DATE(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN DATE) RETURN VARCHAR2;
    FUNCTION UPDATE_JSON_FLOAT(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN FLOAT) RETURN VARCHAR2;
    FUNCTION GET_SEQUENCE(CODE IN VARCHAR2) RETURN NUMBER;


END DWKIT;
/

CREATE OR REPLACE PACKAGE BODY DWKIT AS

    FUNCTION UPDATE_JSON_NUMBER(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN NUMBER)
        RETURN VARCHAR2 AS
        jo JSON_OBJECT_T;
    BEGIN
        jo := JSON_OBJECT_T(JSON_DOC);
        jo.put(parameter_name, new_value);
        RETURN jo.to_string();
    END UPDATE_JSON_NUMBER;

        FUNCTION UPDATE_JSON_FLOAT(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN FLOAT)
        RETURN VARCHAR2 AS
        jo JSON_OBJECT_T;
    BEGIN
        jo := JSON_OBJECT_T(JSON_DOC);
        jo.put(parameter_name, new_value);
        RETURN jo.to_string();
    END UPDATE_JSON_FLOAT;

    FUNCTION UPDATE_JSON_NVARCHAR2(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN VARCHAR2)
        RETURN VARCHAR2 AS
        jo JSON_OBJECT_T;
    BEGIN
        jo := JSON_OBJECT_T(JSON_DOC);
        jo.put(parameter_name, new_value);
        RETURN jo.to_string();
    END UPDATE_JSON_NVARCHAR2;


   FUNCTION UPDATE_JSON_CHAR(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN CHAR)
        RETURN VARCHAR2 AS
        jo JSON_OBJECT_T;
    BEGIN
        jo := JSON_OBJECT_T(JSON_DOC);
        jo.put(parameter_name, new_value);
        RETURN jo.to_string();
    END UPDATE_JSON_CHAR;

    FUNCTION UPDATE_JSON_DATE(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN DATE)
        RETURN VARCHAR2 AS
        jo JSON_OBJECT_T;
    BEGIN
        jo := JSON_OBJECT_T(JSON_DOC);
        jo.put(parameter_name, new_value);
        RETURN jo.to_string();
    END UPDATE_JSON_DATE;

    FUNCTION UPDATE_JSON_RAW(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN RAW)
        RETURN VARCHAR2 AS
        jo JSON_OBJECT_T;
    BEGIN
        jo := JSON_OBJECT_T(JSON_DOC);
        jo.put(parameter_name, RAWTOHEX(new_value));
        RETURN jo.to_string();
    END UPDATE_JSON_RAW;

    FUNCTION UPDATE_JSON_BLOB(JSON_DOC IN VARCHAR2, parameter_name IN VARCHAR2, new_value IN BLOB)
        RETURN VARCHAR2 AS
        jo JSON_OBJECT_T;
    BEGIN
        jo := JSON_OBJECT_T(JSON_DOC);
        jo.put(parameter_name, RAWTOHEX(new_value));
        RETURN jo.to_string();
    END UPDATE_JSON_BLOB;

    FUNCTION GET_SEQUENCE(CODE IN VARCHAR2)
        RETURN NUMBER AS
        res NUMBER;
        is_exist PLS_INTEGER;
        PRAGMA AUTONOMOUS_TRANSACTION;
    BEGIN
        SELECT COUNT(1) INTO is_exist FROM DWAPPSETTINGS WHERE NAME = CODE AND ROWNUM = 1;
        IF (is_exist = 0)
        THEN
            INSERT INTO DWAPPSETTINGS(NAME, VALUE, GROUPNAME, PARAMNAME) VALUES(Code, 1, 'DataSequence', Code);
        END IF;
        SELECT CAST (VALUE as number) INTO res FROM DWAPPSETTINGS WHERE NAME = CODE;
        UPDATE DWAPPSETTINGS SET VALUE = res + 1 WHERE NAME = CODE;
        COMMIT;
        Return res;
    END GET_SEQUENCE;

END DWKIT;
