# DWKit

DWKit is a .NET BPM system made with simplicity and flexibility in mind. DWKit allows you to model, automate and execute mission-critical
business processes, whatever industry you're operating in.

A ready-made BPM solution is often not enough to satisfy your business requirements. Be it the need to ensure regulatory compliance or to
build custom logic that goes beyond what the system has to offer, we believe that making the source code open is the way to go.

Hence, we made DWKit's source code available to our customers so that they can alter whatever it is that will make their business more
efficient.

## Features

- Drag-&-drop form builder
- Designer of workflow
- User Interface on React (JSX)
- Role-based access control
- Admin panel
- Support MSSQL/PosgreSQL/Oracle databases
- Works fine on Windows/Linux/MacOSX

## Screenshots

| [![](https://raw.githubusercontent.com/optimajet/DWKit/master/Resources/dwkit_sample.png "Demo")](https://demo.dwkit.com) | [![](https://raw.githubusercontent.com/optimajet/DWKit/master/Resources/designer.png "Form builder")](https://demo.dwkit.com/admin?apanel=forms&aid=DocumentEdit) | [![](https://raw.githubusercontent.com/optimajet/DWKit/master/Resources/workflow.png "Workflow")](https://demo.dwkit.com/admin?apanel=workflow&aid=VacationRequest) |
|---------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------|

## Development

- [.NET 8](https://dotnet.microsoft.com/en-us/download/dotnet/8.0)
- [Visual Studio](https://visualstudio.microsoft.com/downloads/)
- [JetBrains Rider](https://www.jetbrains.com/rider/download/)

## Samples

- Starter Pack
- Vacation Request

## Information

- **Official website** - https://dwkit.com
- **Documentation** - https://dwkit.com/documentation

- **Demo** - https://dwkit.com/demo/
- **Admin panel** - https://demo.dwkit.com/admin</a><br/>
- **Form Builder** - https://demo.dwkit.com/admin?apanel=forms&aid=DocumentEdit
- **Workflow Designer** - https://demo.dwkit.com/admin?apanel=workflow&aid=VacationRequest

For technical questions, please contact [support@optimajet.com](mailto:support@optimajet.com).

For commercial use, please contact [sales@optimajet.com](mailto:sales@optimajet.com).

## Free limits (development use only)

- Instances: 1
- Users: 20
- Forms: 20
- Workflow: 1 schema

## System requirements

- OS Windows/Linux/macOS
- CPU 1 core 1 Ghz
- RAM 1 Gb
- HDD/SSD 5 Gb
- [.NET 8](https://dotnet.microsoft.com/en-us/download/dotnet/8.0)
