/**
 * Copyright (c) 2022 - present TinyUI Authors.
 * Copyright (c) 2022 - present Huawei Cloud Computing Technologies Co., Ltd.
 *
 * Use of this source code is governed by an MIT-style license.
 *
 * THE OPEN SOURCE SOFTWARE IN THIS PRODUCT IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
 * BUT WITHOUT ANY WARRANTY, WITHOUT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
 * A PARTICULAR PURPOSE. SEE THE APPLICABLE LICENSES FOR MORE DETAILS.
 *
 */
import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';
import { TiTipModule } from '@opentiny/ng-tip';
import { TiDominatorComponent } from './TiDominatorComponent';
import { TiTagModule } from '@opentiny/ng-tag';
import { TiIconModule } from '@opentiny/ng-icon';
import { TiLocaleModule, TiLocale } from '@opentiny/ng-locale';
import { locales } from './i18n';

/**
 * @ignore
 */
@NgModule({
  imports: [CommonModule, FormsModule, TiIconModule, TiTipModule, TiLocaleModule, TiTagModule],
  exports: [TiDominatorComponent],
  declarations: [TiDominatorComponent]
})
export class TiDominatorModule {
  constructor() {
    TiLocale.setTiWords(locales);
  }
}
export { TiDominatorComponent } from './TiDominatorComponent';
