## iD Editor Privacy Policy

iD Editor is an open source OpenStreetMap editor. You are not required to use iD in order to use or edit OpenStreetMap, and the OpenStreetMap Foundation does not operate iD. You can learn more about OpenStreetMap and the OpenStreetMap Foundation at [https://www.openstreetmap.org/about](https://www.openstreetmap.org/about) and [https://wiki.osmfoundation.org/wiki/Main_Page](https://wiki.osmfoundation.org/wiki/Main_Page). You can learn more about the iD Editor project and its maintainers at [https://github.com/openstreetmap/iD](https://github.com/openstreetmap/iD).

### Source code and website ([http://ideditor.com/](http://ideditor.com/))

If you choose to interact with the project GitHub page or website hosted by GitHub, you do so in accordance with [GitHub’s Privacy Policy](https://help.github.com/en/articles/github-privacy-statement). If you choose to interact with the pre-release version of iD at [http://preview.ideditor.com/release](http://preview.ideditor.com/release) or [http://preview.ideditor.com/master](http://preview.ideditor.com/master), that use is governed by [AWS’s privacy policy](https://aws.amazon.com/privacy/). If you choose any other communications medium to contact the maintainers of iD, that use is governed by the policies of those respective mediums. See [https://github.com/openstreetmap/iD](https://github.com/openstreetmap/iD) for more information. iD may use any feedback you provide.

### Cookies

iD use cookies, website logs and other similar data and technologies (i) to preserve information so you will not have to re-enter or re-encounter it during your visit or on subsequent visits; (ii) to maintain sessions for authenticated users; (iii) to monitor metrics about iD use such as the number of visitors and most used features; (iv) for internal diagnostic and analytic purposes (v) to improve the editor and related features, and (vi) to provide information to you about iD, editing, or OpenStreetMap. We have a legitimate interest in improving and informing you about iD, and certain data collection is necessary in order for iD to function. You may delete cookies from your computer, and most browsers provide the option to block cookies. However, if you block cookies, portions of iD may not work as intended. For example, you must be logged into your OpenStreetMap account in order to edit OpenStreetMap.

### Logging into OpenStreetMap

In order to make edits using iD, you must be logged into your OpenStreetMap account. You may do so via the OpenStreetMap website or a number of third-party login services. That use is governed by the respective privacy policies of the login method you choose.

### Changeset information

When you use iD to edit OpenStreetMap, iD uses the OpenStreetMap API to contribute edits. For quality control purposes, along with the information typically recorded for an OpenStreetMap edit, iD automatically adds tags to each changeset submitted with iD which identifies the changeset as one made with iD and information that indicates the user’s level of experience with iD editor and/or its walkthrough. See [here](https://github.com/openstreetmap/iD/blob/release/modules/ui/commit.js) for details. The [OSMF privacy policy](https://wiki.osmfoundation.org/wiki/Privacy_Policy) governs the use of this data in the OpenStreetMap database.

### Editor experience tags

Details on that are [here](https://github.com/openstreetmap/iD/blob/release/modules/ui/commit.js).

### Background imagery and other third party services

If you use background or streetside imagery to aid your edits, your browser must fetch information and images from a third-party imagery host. That use is governed by the respective privacy policies of each imagery host. The [Editor Layer Index](https://github.com/osmlab/editor-layer-index) and [iD Editor GitHub code](https://github.com/openstreetmap/iD/blob/release/modules/ui/map_data.js) provides detailed information as to imagery layer available in iD. In addition, you may use third party services to assist your editing or check for errors. See [here](https://github.com/openstreetmap/iD/tree/release/modules/services) for details. If you do not wish to interact with these third parties, do not use these features.

iD requires that your browser fetch some resources from the [JSDelivr](https://www.jsdelivr.com/) content delivery network (CDN). This usage is governed by the cdn.jsdelivr.net privacy policy located at [https://www.jsdelivr.com/terms/privacy-policy-jsdelivr-net](https://www.jsdelivr.com/terms/privacy-policy-jsdelivr-net).

### Name Suggestion Index

The Name Suggestion Index is a feature in iD to aid users in consistently and accurately identifying the brand names of companies on the map. The NSI optionally fetches information and brand logos hosted on third party websites, including WikiData, Wikimedia Commons, and the brands’ respective Facebook and Twitter accounts. That use is governed by their respective privacy policies, including [https://foundation.wikimedia.org/wiki/Privacy_policy](https://foundation.wikimedia.org/wiki/Privacy_policy); [https://twitter.com/en/privacy](https://twitter.com/en/privacy); [https://www.facebook.com/about/privacy](https://www.facebook.com/about/privacy). Specific information about the information and images fetched for each brand may be found at [https://nsi.guide/](https://nsi.guide/). If you do not wish to interact with these third parties, you can deselect this feature in the User Preferences -> Privacy section.

### Contact

If you believe that we hold information that would allow us to correct, amend, or delete inaccurate information about you or if you believe that information about you has been processed in violation of this privacy policy or applicable law, please email us at privacy@ideditor.org.

### Changelog

* _2020-Dec-02_ - Add information about the JSDelivr CDN integration.
* _2020-Apr-07_ - Update the iD GitHub repository file links to point to the `release` branch instead of the `master` branch.
* _2019-Dec-17_ - Initial version.
