/*
 * Copyright 2024 the original author or authors.
 * <p>
 * Licensed under the Moderne Source Available License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://docs.moderne.io/licensing/moderne-source-available-license
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.openrewrite.staticanalysis.kotlin;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.staticanalysis.NeedBraces;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;

import static org.openrewrite.kotlin.Assertions.kotlin;

class NeedBracesTest implements RewriteTest {

    @Override
    public void defaults(RecipeSpec spec) {
        spec.recipe(new NeedBraces());
    }

    @Disabled("AutoFormat needs to be updated to support Kotlin")
    @Test
    void addBracesForIfBranch() {
        rewriteRun(
          //language=kotlin
          kotlin(
            """
              fun getSymbol(num : Int) : String {
                  if (num > 0) return "+"

                  return "-"
              }
              """,
            """
              fun getSymbol(num : Int) : String {
                  if (num > 0) {
                      return "+"
                  }

                  return "-"
              }
              """
          )
        );
    }

    @Test
    void doNotChangeForArguments() {
        rewriteRun(
          //language=kotlin
          kotlin(
            """
              fun run(foo: String, bar: String) {}
              var x = run( if (true) "" else "",
                  if (true) "" else "")
              """
          )
        );
    }
}
