/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.xuper.crypto.bip39;

import com.baidu.xuper.crypto.bip39.PBKDF2SHA512;
import com.baidu.xuper.crypto.bip39.WordList;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MnemonicCode {
    private final WordList wordList;

    public MnemonicCode(WordList wordList) {
        this.wordList = wordList;
    }

    public String createMnemonic(byte[] entropy) {
        List<String> words = this.genMnemonic(entropy);
        String mnemonic = "";
        for (int i = 0; i < words.size(); ++i) {
            mnemonic = mnemonic + words.get(i);
            if (i == words.size() - 1) continue;
            mnemonic = mnemonic + " ";
        }
        return mnemonic;
    }

    public byte[] getEntropyFromMnemonic(String[] mnemonic) {
        byte[] addChecksumEntropyBytes;
        byte[] newEntropyWithChecksumBytes;
        if (!this.checkMnemonic(mnemonic)) {
            throw new RuntimeException("checkMnemonic failed");
        }
        int mnemonicBitSize = mnemonic.length * 11;
        int checksumBitSize = mnemonicBitSize % 32;
        BigInteger b = new BigInteger("0");
        for (String word : mnemonic) {
            byte[] wordBytes = new byte[2];
            int index = this.wordList.getIndex(word);
            int ss = index >> 8;
            wordBytes[0] = (byte)ss;
            wordBytes[1] = (byte)index;
            b = b.multiply(new BigInteger("2048"));
            b = b.or(new BigInteger(wordBytes));
        }
        BigInteger two = new BigInteger("2");
        BigInteger checksumModulo = two.pow(checksumBitSize);
        BigInteger entropy = b.divide(checksumModulo);
        int entropyByteSize = (mnemonicBitSize - checksumBitSize) / 8;
        int fullByteSize = entropyByteSize + 1;
        byte[] entropyBytes = this.bytesPad(this.toByteArray(entropy), entropyByteSize);
        byte[] entropyWithChecksumBytes = this.bytesPad(this.toByteArray(b), fullByteSize);
        if (!Arrays.equals(entropyWithChecksumBytes, newEntropyWithChecksumBytes = this.bytesPad(addChecksumEntropyBytes = this.addChecksum(entropyBytes), fullByteSize))) {
            throw new RuntimeException("The checksum within the Mnemonic sentence incorrect.");
        }
        return this.toByteArray(entropy);
    }

    public int getCryptographyFromMnemonic(String[] mnemonic) {
        byte[] entropy = this.getEntropyFromMnemonic(mnemonic);
        byte[] tagByte = new byte[1];
        System.arraycopy(entropy, entropy.length - 1, tagByte, 0, 1);
        BigInteger tagInt = new BigInteger(1, tagByte);
        tagInt = tagInt.divide(new BigInteger("16"));
        BigInteger cryptographyInt = tagInt.and(new BigInteger("15"));
        byte[] cryptographyByte = this.toByteArray(cryptographyInt);
        if (cryptographyByte.length == 0) {
            throw new RuntimeException("invalid cryptographyByte length");
        }
        return cryptographyByte[0];
    }

    public static byte[] toSeed(String words, String passphrase) {
        String salt = "mnemonic" + passphrase;
        return PBKDF2SHA512.derive(words, salt, 2048, 40);
    }

    private byte[] addChecksum(byte[] data) {
        byte[] hashByte = this.hash(data);
        byte firstChecksumByte = hashByte[1];
        int checksumBitLength = data.length / 4;
        BigInteger dataBigInt = new BigInteger(1, data);
        for (int i = 0; i < checksumBitLength; ++i) {
            dataBigInt = dataBigInt.multiply(new BigInteger("2"));
            if ((firstChecksumByte & 1 << 7 - i) <= 0) continue;
            dataBigInt = dataBigInt.or(BigInteger.ONE);
        }
        return this.toByteArray(dataBigInt);
    }

    private byte[] bytesPad(byte[] data, int length) {
        if (length == data.length) {
            return data;
        }
        byte[] result = new byte[length];
        System.arraycopy(data, 0, result, 1, data.length);
        return result;
    }

    private byte[] toByteArray(BigInteger bi) {
        byte[] array = bi.toByteArray();
        if (array[0] == 0) {
            byte[] tmp = new byte[array.length - 1];
            System.arraycopy(array, 1, tmp, 0, tmp.length);
            array = tmp;
        }
        return array;
    }

    private boolean checkMnemonic(String[] mnemonic) {
        List<String> validLength = Arrays.asList("12", "15", "18", "21", "24");
        if (!validLength.contains(String.valueOf(mnemonic.length))) {
            return false;
        }
        for (String s : mnemonic) {
            if (this.wordList.has(s)) continue;
            return false;
        }
        return true;
    }

    private List<String> genMnemonic(byte[] entropy) {
        int entropyBitLength = entropy.length * 8;
        this.validateEntropyBitSize(entropyBitLength);
        int checksumBitLength = entropyBitLength / 32;
        int sentenceLength = (entropyBitLength + checksumBitLength) / 11;
        byte[] entropyWithChecksum = this.addChecksum(entropy);
        BigInteger entropyInt = new BigInteger(1, entropyWithChecksum);
        String[] words = new String[sentenceLength];
        BigInteger word = new BigInteger("0");
        for (int i = sentenceLength - 1; i >= 0; --i) {
            word = entropyInt.and(new BigInteger("2047"));
            entropyInt = entropyInt.divide(new BigInteger("2048"));
            byte[] wordBytes = this.bytesPad(this.toByteArray(word), 2);
            int ii = this.byteBE2Int(wordBytes);
            words[i] = this.wordList.getWord(ii);
        }
        return new ArrayList<String>(Arrays.asList(words));
    }

    private int byteBE2Int(byte[] bytes) {
        int result;
        if (bytes.length == 1) {
            result = bytes[0] & 0xFF;
        } else {
            result = bytes[0] & 0xFF;
            result = result << 8 | bytes[1] & 0xFF;
        }
        return result;
    }

    private void validateEntropyBitSize(int bitSize) {
        if (bitSize % 32 != 0 || bitSize < 128 || bitSize > 256) {
            throw new RuntimeException("invalid bitSize");
        }
    }

    private byte[] hash(byte[] data) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return messageDigest.digest(data);
    }
}

