/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.xuper.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class Config {
    private static Config singletonConfig;
    private static String confFilePath;
    private static InputStream confFileInputStream;
    private String endorseServiceHost;
    private ComplianceCheck complianceCheck;
    private String minNewChainAmount;
    private String crypto;

    private Config() {
    }

    public static void setConfigPath(String path) throws FileNotFoundException {
        confFilePath = path;
        Config.setConfigInputStream(new FileInputStream(path));
    }

    public static void setConfigInputStream(InputStream inputStream) {
        confFileInputStream = inputStream;
    }

    public static boolean hasConfigFile() {
        return confFilePath != null || confFileInputStream != null;
    }

    public static Config getInstance() {
        if (singletonConfig != null) {
            return singletonConfig;
        }
        if (Config.hasConfigFile()) {
            try {
                singletonConfig = Config.getConfigFromYaml();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            singletonConfig = Config.getDefaultConfig();
        }
        return singletonConfig;
    }

    private static Config getConfigFromYaml() throws Exception {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(Config.class));
        return (Config)yaml.load(confFileInputStream != null ? confFileInputStream : new FileInputStream(new File(confFilePath)));
    }

    private static Config getDefaultConfig() {
        singletonConfig = new Config();
        Config.singletonConfig.minNewChainAmount = "100";
        Config.singletonConfig.crypto = "xchain";
        Config.singletonConfig.endorseServiceHost = "";
        ComplianceCheck c = new ComplianceCheck();
        c.isNeedComplianceCheck = false;
        c.isNeedComplianceCheckFee = false;
        c.complianceCheckEndorseServiceFee = 10;
        c.complianceCheckEndorseServiceFeeAddr = "XBbhR82cB6PvaLJs3D4uB9f12bhmKkHeX";
        c.complianceCheckEndorseServiceAddr = "TYyA3y8wdFZyzExtcbRNVd7ZZ2XXcfjdw";
        Config.singletonConfig.complianceCheck = c;
        return singletonConfig;
    }

    public String getEndorseServiceHost() {
        return this.endorseServiceHost;
    }

    public ComplianceCheck getComplianceCheck() {
        return this.complianceCheck;
    }

    public String getMinNewChainAmount() {
        return this.minNewChainAmount;
    }

    public String getCrypto() {
        return this.crypto;
    }

    public void setEndorseServiceHost(String endorseServiceHost) {
        this.endorseServiceHost = endorseServiceHost;
    }

    public void setComplianceCheck(ComplianceCheck complianceCheck) {
        this.complianceCheck = complianceCheck;
    }

    public void setMinNewChainAmount(String minNewChainAmount) {
        this.minNewChainAmount = minNewChainAmount;
    }

    public void setCrypto(String crypto) {
        this.crypto = crypto;
    }

    public static class ComplianceCheck {
        private boolean isNeedComplianceCheck;
        private boolean isNeedComplianceCheckFee;
        private int complianceCheckEndorseServiceFee;
        private String complianceCheckEndorseServiceFeeAddr;
        private String complianceCheckEndorseServiceAddr;

        public boolean getIsNeedComplianceCheck() {
            return this.isNeedComplianceCheck;
        }

        public boolean getIsNeedComplianceCheckFee() {
            return this.isNeedComplianceCheckFee;
        }

        public int getComplianceCheckEndorseServiceFee() {
            return this.complianceCheckEndorseServiceFee;
        }

        public String getComplianceCheckEndorseServiceFeeAddr() {
            return this.complianceCheckEndorseServiceFeeAddr;
        }

        public String getComplianceCheckEndorseServiceAddr() {
            return this.complianceCheckEndorseServiceAddr;
        }

        public void setIsNeedComplianceCheck(boolean needComplianceCheck) {
            this.isNeedComplianceCheck = needComplianceCheck;
        }

        public void setIsNeedComplianceCheckFee(boolean needComplianceCheckFee) {
            this.isNeedComplianceCheckFee = needComplianceCheckFee;
        }

        public void setComplianceCheckEndorseServiceFee(int complianceCheckEndorseServiceFee) {
            this.complianceCheckEndorseServiceFee = complianceCheckEndorseServiceFee;
        }

        public void setComplianceCheckEndorseServiceFeeAddr(String complianceCheckEndorseServiceFeeAddr) {
            this.complianceCheckEndorseServiceFeeAddr = complianceCheckEndorseServiceFeeAddr;
        }

        public void setComplianceCheckEndorseServiceAddr(String complianceCheckEndorseServiceAddr) {
            this.complianceCheckEndorseServiceAddr = complianceCheckEndorseServiceAddr;
        }
    }
}

