/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.xuper.api;

import com.baidu.xuper.api.Account;
import com.baidu.xuper.api.Common;
import com.baidu.xuper.api.Proposal;
import com.baidu.xuper.api.Transaction;
import com.baidu.xuper.api.XendorserClient;
import com.baidu.xuper.config.Config;
import com.baidu.xuper.pb.XchainGrpc;
import com.baidu.xuper.pb.XchainOuterClass;
import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.encoders.Hex;

public class XuperClient {
    private final ManagedChannel channel;
    private final XchainGrpc.XchainBlockingStub blockingClient;
    private final XendorserClient xendorserClient;
    private String chainName = "xuper";
    private final String evmContract = "evm";
    private final String xkernelModule = "xkernel";
    private final String evmJSONEncoded = "jsonEncoded";
    private final String evmJSONEncodedTrue = "true";
    private final String argsInput = "input";
    private final String xkernelDeployMethod = "Deploy";
    private final String xkernelNewAccountMethod = "NewAccount";
    private final String argAccountName = "account_name";
    private final String argContractName = "contract_name";
    private final String argContractCode = "contract_code";
    private final String argContractDesc = "contract_desc";
    private final String argInitArgs = "init_args";
    private final String argContractAbi = "contract_abi";

    public XuperClient(String target) {
        this(target, 0x400000);
    }

    public XuperClient(String target, Integer maxInboundMessageSize) {
        this(ManagedChannelBuilder.forTarget((String)target).maxInboundMessageSize(maxInboundMessageSize.intValue()).usePlaintext().build());
    }

    private XuperClient(ManagedChannel channel) {
        this.channel = channel;
        this.blockingClient = XchainGrpc.newBlockingStub((Channel)channel);
        this.xendorserClient = Config.hasConfigFile() ? new XendorserClient(Config.getInstance().getEndorseServiceHost()) : null;
    }

    public void close() {
        this.channel.shutdown();
        if (this.xendorserClient != null) {
            this.xendorserClient.close();
        }
    }

    public XuperClient setChainName(String name) {
        this.chainName = name;
        return this;
    }

    XchainGrpc.XchainBlockingStub getBlockingClient() {
        return this.blockingClient;
    }

    public XendorserClient getXendorserClient() {
        return this.xendorserClient;
    }

    public Transaction transfer(Account from, String to, BigInteger amount, String fee) {
        return this.transfer(from, to, amount, fee, null);
    }

    public Transaction transfer(Account from, String to, BigInteger amount, String fee, String desc) {
        Proposal p = new Proposal().setChainName(this.chainName).setFee(fee);
        if (desc != null && !desc.equals("")) {
            p.setDesc(desc);
        }
        if (Config.getInstance().getComplianceCheck().getIsNeedComplianceCheck()) {
            p.addAuthRequire(Config.getInstance().getComplianceCheck().getComplianceCheckEndorseServiceAddr());
        }
        p.setInitiator(from);
        return p.transfer(to, amount).build(this).sign().send(this);
    }

    public Transaction invokeContract(Account from, String module, String contract, String method, Map<String, byte[]> args) {
        Proposal p = new Proposal().setChainName(this.chainName);
        if (Config.getInstance().getComplianceCheck().getIsNeedComplianceCheck()) {
            p.addAuthRequire(Config.getInstance().getComplianceCheck().getComplianceCheckEndorseServiceAddr());
        }
        p.setInitiator(from);
        return p.invokeContract(module, contract, method, args).build(this).sign().send(this);
    }

    public Transaction queryContract(Account from, String module, String contract, String method, Map<String, byte[]> args) {
        return new Proposal().setChainName(this.chainName).setInitiator(from).addAuthRequire(Config.getInstance().getComplianceCheck().getComplianceCheckEndorseServiceAddr()).invokeContract(module, contract, method, args).preExec(this);
    }

    public Transaction deployWasmContract(Account from, byte[] code, String contract, String runtime, Map<String, byte[]> initArgs) {
        return this.deployContract(from, code, contract, runtime, initArgs, "wasm");
    }

    public Transaction deployNativeContract(Account from, byte[] code, String contract, String runtime, Map<String, byte[]> initArgs) {
        return this.deployContract(from, code, contract, runtime, initArgs, "native");
    }

    private Transaction deployContract(Account from, byte[] code, String contract, String runtime, Map<String, byte[]> initArgs, String contractType) {
        if (from.getContractAccount().isEmpty()) {
            throw new RuntimeException("deploy contract must use contract account");
        }
        if (contractType.isEmpty()) {
            contractType = "wasm";
        }
        XchainOuterClass.WasmCodeDesc desc = XchainOuterClass.WasmCodeDesc.newBuilder().setRuntime(runtime).setContractType(contractType).build();
        Gson gson = new Gson();
        byte[] initArgsJson = gson.toJson(initArgs).getBytes();
        HashMap<String, byte[]> args = new HashMap<String, byte[]>();
        args.put("account_name", from.getContractAccount().getBytes());
        args.put("contract_name", contract.getBytes());
        args.put("contract_code", code);
        args.put("contract_desc", desc.toByteArray());
        args.put("init_args", initArgsJson);
        return this.invokeContract(from, "xkernel", "", "Deploy", args);
    }

    public Transaction createContractAccount(Account from, String accountName) {
        String desc = "{\"aksWeight\": {\"" + from.getAddress() + "\": 1.0}, \"pm\": {\"acceptValue\": 1.0, \"rule\": 1}}";
        HashMap<String, byte[]> args = new HashMap<String, byte[]>();
        args.put("account_name", accountName.getBytes());
        args.put("acl", desc.getBytes());
        return this.invokeContract(from, "xkernel", "", "NewAccount", args);
    }

    public BigInteger getBalance(String account) {
        XchainOuterClass.AddressStatus request = XchainOuterClass.AddressStatus.newBuilder().setHeader(Common.newHeader()).setAddress(account).addBcs(XchainOuterClass.TokenDetail.newBuilder().setBcname(this.chainName).build()).build();
        XchainOuterClass.AddressStatus response = this.blockingClient.getBalance(request);
        for (int i = 0; i < response.getBcsCount(); ++i) {
            if (!response.getBcs(i).getBcname().equals(this.chainName)) continue;
            return new BigInteger(response.getBcs(i).getBalance());
        }
        Common.checkResponseHeader(response.getHeader(), "query balance");
        return BigInteger.valueOf(0L);
    }

    public BalDetails[] getBalanceDetails(String account) {
        XchainOuterClass.AddressBalanceStatus request = XchainOuterClass.AddressBalanceStatus.newBuilder().setHeader(Common.newHeader()).setAddress(account).addTfds(XchainOuterClass.TokenFrozenDetails.newBuilder().setBcname(this.chainName).build()).build();
        XchainOuterClass.AddressBalanceStatus response = this.blockingClient.getBalanceDetail(request);
        XchainOuterClass.TokenFrozenDetails tfds = response.getTfds(0);
        BalDetails[] balDetails = new BalDetails[tfds.getTfdCount()];
        for (int i = 0; i < tfds.getTfdCount(); ++i) {
            XchainOuterClass.TokenFrozenDetail tfd = tfds.getTfd(i);
            balDetails[i] = new BalDetails(tfd.getBalance(), tfd.getIsFrozen());
        }
        return balDetails;
    }

    public XchainOuterClass.Transaction queryTx(String txid) {
        XchainOuterClass.TxStatus request = XchainOuterClass.TxStatus.newBuilder().setHeader(Common.newHeader()).setBcname(this.chainName).setTxid(ByteString.copyFrom((byte[])Hex.decode((String)txid))).build();
        XchainOuterClass.TxStatus response = this.blockingClient.queryTx(request);
        Common.checkResponseHeader(response.getHeader(), "query transaction");
        return response.getTx();
    }

    public XchainOuterClass.InternalBlock queryBlock(String blockid) {
        XchainOuterClass.BlockID request = XchainOuterClass.BlockID.newBuilder().setHeader(Common.newHeader()).setBcname(this.chainName).setBlockid(ByteString.copyFrom((byte[])Hex.decode((String)blockid))).setNeedContent(true).build();
        XchainOuterClass.Block response = this.blockingClient.getBlock(request);
        Common.checkResponseHeader(response.getHeader(), "query transaction");
        return response.getBlock();
    }

    public XchainOuterClass.SystemsStatus getSystemStatus() {
        XchainOuterClass.CommonIn request = XchainOuterClass.CommonIn.newBuilder().setHeader(Common.newHeader()).build();
        XchainOuterClass.SystemsStatusReply response = this.blockingClient.getSystemStatus(request);
        Common.checkResponseHeader(response.getHeader(), "query system status");
        return response.getSystemsStatus();
    }

    public XchainOuterClass.BCStatus getBlockchainStatus(String chainName) {
        XchainOuterClass.BCStatus request = XchainOuterClass.BCStatus.newBuilder().setHeader(Common.newHeader()).setBcname(chainName).build();
        XchainOuterClass.BCStatus bcs = this.blockingClient.getBlockChainStatus(request);
        Common.checkResponseHeader(bcs.getHeader(), "query blockchain status");
        return bcs;
    }

    public Transaction deployEVMContract(Account from, byte[] bin, byte[] abi, String contract, Map<String, String> initArgs) {
        if (from.getContractAccount().isEmpty()) {
            throw new RuntimeException("deploy contract must use contract account");
        }
        XchainOuterClass.WasmCodeDesc desc = XchainOuterClass.WasmCodeDesc.newBuilder().setContractType("evm").build();
        Map<String, byte[]> evmArgs = this.convertToXuper3EVMArgs(initArgs);
        Gson gson = new Gson();
        byte[] initArgsJson = gson.toJson(evmArgs).getBytes();
        HashMap<String, byte[]> args = new HashMap<String, byte[]>();
        args.put("account_name", from.getContractAccount().getBytes());
        args.put("contract_name", contract.getBytes());
        args.put("contract_code", bin);
        args.put("contract_desc", desc.toByteArray());
        args.put("init_args", initArgsJson);
        args.put("contract_abi", abi);
        return this.invokeContract(from, "xkernel", "", "Deploy", args);
    }

    public Transaction queryEVMContract(Account from, String contract, String method, Map<String, String> args) {
        Map<String, byte[]> evmArgs = this.convertToXuper3EVMArgs(args);
        return new Proposal().setChainName(this.chainName).setInitiator(from).addAuthRequire(Config.getInstance().getComplianceCheck().getComplianceCheckEndorseServiceAddr()).invokeContract("evm", contract, method, evmArgs).preExec(this);
    }

    public Transaction invokeEVMContract(Account from, String contract, String method, Map<String, String> args, BigInteger amount) {
        Proposal p = new Proposal().setChainName(this.chainName);
        if (Config.getInstance().getComplianceCheck().getIsNeedComplianceCheck()) {
            p.addAuthRequire(Config.getInstance().getComplianceCheck().getComplianceCheckEndorseServiceAddr());
        }
        p.setInitiator(from);
        Map<String, byte[]> evmArgs = this.convertToXuper3EVMArgs(args);
        if (amount == null || amount.compareTo(BigInteger.ZERO) == 0) {
            return p.invokeContract("evm", contract, method, evmArgs).build(this).sign().send(this);
        }
        return p.transfer(contract, amount).invokeContract("evm", contract, method, evmArgs).build(this).sign().send(this);
    }

    private Map<String, byte[]> convertToXuper3EVMArgs(Map<String, String> initArgs) {
        HashMap<String, String> args = new HashMap<String, String>();
        if (initArgs != null) {
            for (Map.Entry<String, String> entry : initArgs.entrySet()) {
                args.put(entry.getKey(), entry.getValue());
            }
        }
        Gson gson = new Gson();
        byte[] initArgsJson = gson.toJson(args).getBytes();
        HashMap<String, byte[]> evmArgs = new HashMap<String, byte[]>();
        evmArgs.put("input", initArgsJson);
        evmArgs.put("jsonEncoded", "true".getBytes());
        return evmArgs;
    }

    public static class BalDetails {
        private String balance;
        private Boolean isFrozen;

        BalDetails(String bal, Boolean f) {
            this.balance = bal;
            this.isFrozen = f;
        }

        public String getBalance() {
            return this.balance;
        }

        public Boolean getFrozen() {
            return this.isFrozen;
        }

        public void setBalance(String balance) {
            this.balance = balance;
        }

        public void setFrozen(Boolean frozen) {
            this.isFrozen = frozen;
        }
    }
}

