/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.xuper.api;

import com.baidu.xuper.crypto.Hash;
import com.baidu.xuper.pb.XchainOuterClass;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.ByteString;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.bouncycastle.util.encoders.Base64;

class TxEncoder {
    private static final Gson gson = new GsonBuilder().serializeNulls().registerTypeHierarchyAdapter(ByteString.class, (Object)new PbByteStringAdapter()).disableHtmlEscaping().create();
    private StringBuilder buffer = new StringBuilder();

    TxEncoder() {
    }

    static byte[] makeTxDigest(XchainOuterClass.Transaction tx) {
        TxEncoder enc = new TxEncoder();
        return Hash.doubleSha256(enc.encodeTx(tx, false));
    }

    static byte[] makeTxID(XchainOuterClass.Transaction tx) {
        TxEncoder enc = new TxEncoder();
        return Hash.doubleSha256(enc.encodeTx(tx, true));
    }

    private void encode(Object obj) {
        String s = gson.toJson(obj);
        this.buffer.append(s);
        this.buffer.append("\n");
    }

    private void encode(ByteString bs) {
        if (bs == null) {
            String s = gson.toJson(null);
            this.buffer.append(s);
            this.buffer.append("\n");
            return;
        }
        if (!bs.isEmpty()) {
            this.encode(Base64.toBase64String((byte[])bs.toByteArray()));
        }
    }

    byte[] encodeTx(XchainOuterClass.Transaction tx, boolean needSign) {
        for (XchainOuterClass.TxInput input : tx.getTxInputsList()) {
            this.encode(input.getRefTxid());
            this.encode(input.getRefOffset());
            this.encode(input.getFromAddr());
            this.encode(input.getAmount());
            this.encode(input.getFrozenHeight());
        }
        Object[] txOutputs = new Object[tx.getTxOutputsCount()];
        for (int i = 0; i < tx.getTxOutputsCount(); ++i) {
            txOutputs[i] = TxOutputBean.create(tx.getTxOutputs(i));
        }
        if (txOutputs.length > 0) {
            this.encode(txOutputs);
        } else {
            this.encode(null);
        }
        this.encode(tx.getDesc());
        this.encode(tx.getNonce());
        this.encode(tx.getTimestamp());
        this.encode(tx.getVersion());
        for (XchainOuterClass.TxInputExt input : tx.getTxInputsExtList()) {
            this.encode(input.getBucket());
            this.encode(input.getKey());
            this.encode(input.getRefTxid());
            this.encode(input.getRefOffset());
        }
        for (XchainOuterClass.TxOutputExt output : tx.getTxOutputsExtList()) {
            this.encode(output.getBucket());
            this.encode(output.getKey());
            this.encode(output.getValue());
        }
        Object[] invokes = null;
        if (tx.getContractRequestsCount() != 0) {
            invokes = new Object[tx.getContractRequestsCount()];
            for (int i = 0; i < tx.getContractRequestsCount(); ++i) {
                invokes[i] = InvokeRequestBean.create(tx.getContractRequests(i));
            }
        }
        this.encode(invokes);
        this.encode(tx.getInitiator());
        if (tx.getAuthRequireCount() > 0) {
            this.encode(tx.getAuthRequireList().toArray());
        } else {
            this.encode((Object)null);
        }
        if (needSign) {
            int i;
            Object[] sigs = null;
            if (tx.getInitiatorSignsCount() != 0) {
                sigs = new Object[tx.getInitiatorSignsCount()];
            }
            for (i = 0; i < tx.getInitiatorSignsCount(); ++i) {
                sigs[i] = SignatureInfoBean.create(tx.getInitiatorSigns(i));
            }
            this.encode(sigs);
            sigs = null;
            if (tx.getAuthRequireSignsCount() != 0) {
                sigs = new Object[tx.getAuthRequireSignsCount()];
            }
            for (i = 0; i < tx.getAuthRequireSignsCount(); ++i) {
                sigs[i] = SignatureInfoBean.create(tx.getAuthRequireSigns(i));
            }
            this.encode(sigs);
            if (tx.hasXuperSign()) {
                this.encode(tx.getXuperSign());
            }
        }
        this.encode(tx.getCoinbase());
        this.encode(tx.getAutogen());
        return this.buffer.toString().getBytes();
    }

    private static class SignatureInfoBean {
        private SignatureInfoBean() {
        }

        static Object create(XchainOuterClass.SignatureInfo pb) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            if (!pb.getPublicKey().isEmpty()) {
                m.put("PublicKey", pb.getPublicKey());
            }
            if (!pb.getSign().isEmpty()) {
                m.put("Sign", (String)pb.getSign());
            }
            return m;
        }
    }

    private static class ResourceLimitBean {
        private ResourceLimitBean() {
        }

        static Object create(XchainOuterClass.ResourceLimit pb) {
            LinkedHashMap<String, Number> m = new LinkedHashMap<String, Number>();
            if (pb.getType().getNumber() != 0) {
                m.put("type", pb.getType().getNumber());
            }
            if (pb.getLimit() != 0L) {
                m.put("limit", pb.getLimit());
            }
            return m;
        }
    }

    private static class InvokeRequestBean {
        private InvokeRequestBean() {
        }

        static Object create(XchainOuterClass.InvokeRequest pb) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            if (!pb.getMethodName().isEmpty()) {
                m.put("module_name", pb.getModuleName());
            }
            if (!pb.getContractName().isEmpty()) {
                m.put("contract_name", pb.getContractName());
            }
            if (!pb.getMethodName().isEmpty()) {
                m.put("method_name", pb.getMethodName());
            }
            if (pb.getArgsCount() != 0) {
                TreeMap<String, ByteString> margs = new TreeMap<String, ByteString>();
                for (Map.Entry<String, ByteString> entry : pb.getArgsMap().entrySet()) {
                    margs.put(entry.getKey(), entry.getValue());
                }
                m.put("args", margs);
            }
            if (pb.getResourceLimitsCount() != 0) {
                Object[] resource_limits = new Object[pb.getResourceLimitsCount()];
                for (int i = 0; i < pb.getResourceLimitsCount(); ++i) {
                    resource_limits[i] = ResourceLimitBean.create(pb.getResourceLimits(i));
                }
                m.put("resource_limits", resource_limits);
            }
            if (!pb.getAmount().isEmpty()) {
                m.put("amount", pb.getAmount());
            }
            return m;
        }
    }

    private static class TxOutputBean {
        private TxOutputBean() {
        }

        static Object create(XchainOuterClass.TxOutput pb) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            if (!pb.getAmount().isEmpty()) {
                m.put("amount", pb.getAmount());
            }
            if (!pb.getToAddr().isEmpty()) {
                m.put("to_addr", pb.getToAddr());
            }
            if (pb.getFrozenHeight() != 0L) {
                m.put("frozen_height", pb.getFrozenHeight());
            }
            return m;
        }
    }

    private static class PbByteStringAdapter
    implements JsonSerializer<ByteString> {
        private PbByteStringAdapter() {
        }

        public JsonElement serialize(ByteString src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.toBase64String((byte[])src.toByteArray()));
        }
    }
}

