/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.xuper.api;

import com.baidu.xuper.crypto.Base58;
import com.baidu.xuper.crypto.ECKeyPair;
import com.baidu.xuper.crypto.Hash;
import com.baidu.xuper.crypto.account.ECDSAAccount;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;

public class Account {
    private final ECKeyPair ecKeyPair;
    private final String address;
    private String contractAccount;
    private String mnemonic;

    private Account(ECKeyPair ecKeyPair, String address) {
        this.ecKeyPair = ecKeyPair;
        this.address = address;
    }

    private Account(ECKeyPair ecKeyPair, String address, String mnemonic) {
        this.ecKeyPair = ecKeyPair;
        this.address = address;
        this.mnemonic = mnemonic;
    }

    public static Account create(InputStream inputStream) {
        privatePubKey json;
        Gson gson = new Gson();
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, Charset.forName("UTF-8")));
            json = (privatePubKey)gson.fromJson(reader, privatePubKey.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (json.D == null) {
            throw new RuntimeException("invalid private.key file");
        }
        return Account.create(ECKeyPair.create(json.D));
    }

    public static Account create(String keyPath) {
        try {
            String privateKeyPath = Paths.get(keyPath, "private.key").toString();
            File privateKeyFile = new File(privateKeyPath);
            return Account.create(new FileInputStream(privateKeyFile));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Account create(ECKeyPair keyPair) {
        byte[] pubkey = keyPair.getPublicKey().getEncoded(false);
        byte[] hash = Hash.ripeMD128(Hash.sha256(pubkey));
        String address = Base58.encodeChecked(1, hash);
        return new Account(keyPair, address);
    }

    public static Account create() {
        return Account.create(ECKeyPair.create());
    }

    public static Account create(int strength, int language) {
        ECDSAAccount ecdsaAccount = new ECDSAAccount();
        ecdsaAccount.createAccountWithMnemonic(strength, language);
        return new Account(ecdsaAccount.ecKeyPair, ecdsaAccount.address, ecdsaAccount.mnemonic);
    }

    public static Account retrieve(String mnemonic, int language) {
        ECDSAAccount ecdsaAccount = new ECDSAAccount();
        ecdsaAccount.createByMnemonic(mnemonic, language);
        return new Account(ecdsaAccount.ecKeyPair, ecdsaAccount.address, ecdsaAccount.mnemonic);
    }

    public static Account createAndSave(String path, String passwd, int strength, int language) {
        ECDSAAccount ecdsaAccount = new ECDSAAccount();
        ecdsaAccount.createAccountWithMnemonic(strength, language);
        ecdsaAccount.saveToFile(path, passwd);
        return new Account(ecdsaAccount.ecKeyPair, ecdsaAccount.address, ecdsaAccount.mnemonic);
    }

    public static Account getAccountFromFile(String path, String passwd) {
        byte[] p = ECDSAAccount.getBinaryECDSAPrivateKey(path, passwd);
        Gson gson = new Gson();
        privatePubKey json = (privatePubKey)gson.fromJson(new String(p), privatePubKey.class);
        if (json.D == null) {
            throw new RuntimeException("invalid private.key file");
        }
        return Account.create(ECKeyPair.create(json.D));
    }

    public static Account getAccountFromPlainFile(String path) {
        try {
            byte[] address = Files.readAllBytes(Paths.get(path + "/address", new String[0]));
            byte[] pubKey = Files.readAllBytes(Paths.get(path + "/public.key", new String[0]));
            byte[] privKey = Files.readAllBytes(Paths.get(path + "/private.key", new String[0]));
            Gson gson = new Gson();
            privatePubKey json = (privatePubKey)gson.fromJson(new String(privKey), privatePubKey.class);
            if (json.D == null) {
                throw new RuntimeException("invalid private.key file");
            }
            Account a = Account.create(ECKeyPair.create(json.D));
            if (!a.getAKAddress().equals(new String(address))) {
                throw new RuntimeException("address and private key not match.");
            }
            if (!a.getKeyPair().getJSONPublicKey().equals(new String(pubKey))) {
                throw new RuntimeException("public key and private key not match.");
            }
            return a;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String hexEncodeUpperToString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        int len = bytes.length;
        for (int index = 0; index <= len - 1; ++index) {
            String invalue1 = Integer.toHexString(bytes[index] >> 4 & 0xF);
            String intValue2 = Integer.toHexString(bytes[index] & 0xF);
            result.append(invalue1);
            result.append(intValue2);
        }
        return result.toString().toUpperCase(Locale.ROOT);
    }

    public static String xchainAKToEVMAddress(String akAddress) throws Exception {
        if (akAddress == null) {
            throw new RuntimeException("akAddress is null");
        }
        byte[] rawAddr = Base58.decode(akAddress);
        if (rawAddr.length < 21) {
            throw new RuntimeException("bad address");
        }
        byte[] ripemd160Hash = Arrays.copyOfRange(rawAddr, 1, 21);
        return Account.hexEncodeUpperToString(ripemd160Hash);
    }

    public ECKeyPair getKeyPair() {
        return this.ecKeyPair;
    }

    public String getAddress() {
        if (this.contractAccount != null) {
            return this.contractAccount;
        }
        return this.address;
    }

    public String getAKAddress() {
        return this.address;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getContractAccount() {
        return this.contractAccount;
    }

    public void setContractAccount(String name) {
        this.contractAccount = name;
    }

    public String getAuthRequireId() {
        if (this.contractAccount != null) {
            return this.contractAccount + "/" + this.address;
        }
        return this.address;
    }

    class privatePubKey {
        String CurvName;
        BigInteger D;
        BigInteger X;
        BigInteger Y;

        privatePubKey() {
        }
    }
}

