/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.xuper.crypto;

import com.baidu.xuper.crypto.Ecc;
import com.google.gson.Gson;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class ECKeyPair {
    private static final SecureRandom secureRandom = new SecureRandom();
    private final BigInteger privateKey;
    private final ECPoint publicKey;
    private final String jsonPublicKey;
    private final String jsonPrivateKey;

    private ECKeyPair(BigInteger privateKey, ECPoint publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.jsonPublicKey = ECKeyPair.createJSONPublicKey(publicKey);
        this.jsonPrivateKey = ECKeyPair.createJSONPrivateKey(privateKey, publicKey);
    }

    public static ECKeyPair create(BigInteger privateKey) {
        ECPoint q = Ecc.domain.getG().multiply(privateKey);
        ECPublicKeyParameters params = new ECPublicKeyParameters(q, Ecc.domain);
        return new ECKeyPair(privateKey, params.getQ());
    }

    private static String createJSONPublicKey(ECPoint publicKey) {
        BigInteger x = publicKey.getAffineXCoord().toBigInteger();
        BigInteger y = publicKey.getAffineYCoord().toBigInteger();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("Curvname", "P-256");
        m.put("X", x);
        m.put("Y", y);
        Gson gson = new Gson();
        return gson.toJson(m);
    }

    public static ECKeyPair create() {
        return ECKeyPair.create(secureRandom);
    }

    public static ECKeyPair create(byte[] seed) {
        BigInteger k = new BigInteger(1, seed);
        BigInteger n = Ecc.domain.getN().subtract(BigInteger.ONE);
        k = k.mod(n);
        k = k.add(BigInteger.ONE);
        ECPrivateKeyParameters p = new ECPrivateKeyParameters(k, Ecc.domain);
        return ECKeyPair.create(p.getD());
    }

    public static ECKeyPair create(SecureRandom secureRandom) {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(Ecc.domain, secureRandom);
        generator.init((KeyGenerationParameters)keygenParams);
        AsymmetricCipherKeyPair keypair = generator.generateKeyPair();
        ECPrivateKeyParameters privParams = (ECPrivateKeyParameters)keypair.getPrivate();
        ECPublicKeyParameters pubParams = (ECPublicKeyParameters)keypair.getPublic();
        return ECKeyPair.create(privParams.getD());
    }

    public String getJSONPublicKey() {
        return this.jsonPublicKey;
    }

    public String getJSONPrivateKey() {
        return this.jsonPrivateKey;
    }

    private static String createJSONPrivateKey(BigInteger privateKey, ECPoint publicKey) {
        BigInteger x = publicKey.getAffineXCoord().toBigInteger();
        BigInteger y = publicKey.getAffineYCoord().toBigInteger();
        BigInteger d = privateKey;
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("Curvname", "P-256");
        m.put("X", x);
        m.put("Y", y);
        m.put("D", d);
        Gson gson = new Gson();
        return gson.toJson(m);
    }

    public ECPoint getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    public byte[] sign(byte[] hash) throws Exception {
        return Ecc.sign(hash, this.privateKey);
    }
}

