"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RevokeTokenRequest = void 0;
/**
 * Represents a revoke token request.
 * For more information look at:
 * https://tools.ietf.org/html/rfc7009#section-2.1
 */
var RevokeTokenRequest = /** @class */ (function () {
    function RevokeTokenRequest(request) {
        this.token = request.token;
        this.tokenTypeHint = request.token_type_hint;
        this.clientId = request.client_id;
        this.clientSecret = request.client_secret;
    }
    /**
     * Serializes a TokenRequest to a JavaScript object.
     */
    RevokeTokenRequest.prototype.toJson = function () {
        var json = { token: this.token };
        if (this.tokenTypeHint) {
            json['token_type_hint'] = this.tokenTypeHint;
        }
        if (this.clientId) {
            json['client_id'] = this.clientId;
        }
        if (this.clientSecret) {
            json['client_secret'] = this.clientSecret;
        }
        return json;
    };
    RevokeTokenRequest.prototype.toStringMap = function () {
        var json = this.toJson();
        // :(
        return json;
    };
    return RevokeTokenRequest;
}());
exports.RevokeTokenRequest = RevokeTokenRequest;
//# sourceMappingURL=data:application/json;base64,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