CREATE SCHEMA IF NOT EXISTS qfield_test;

DROP TABLE IF EXISTS qfield_test.test_points;

CREATE TABLE qfield_test.test_points (
    id integer NOT NULL,
    geom public.geometry(Point,4326),
    name text
);

ALTER TABLE qfield_test.test_points ADD PRIMARY KEY (id);

CREATE SEQUENCE qfield_test.test_points_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER SEQUENCE qfield_test.test_points_id_seq OWNED BY qfield_test.test_points.id;

ALTER TABLE ONLY qfield_test.test_points ALTER COLUMN id SET DEFAULT nextval('qfield_test.test_points_id_seq'::regclass);

COPY qfield_test.test_points (id, geom, name) FROM stdin;
1	0101000020E6100000CDB9972975581B4027AFA1BC86724740	Lac de Neuchatel
2	0101000020E61000000C1BCA6B28AF1C40628466AD788A4740	Lac de Bienne
3	0101000020E6100000EACB943AAC322140B178AA89E1A34740	Zurichisee
4	0101000020E61000006AE01DB9346E2240B9E2A926868F4740	Walensee
5	0101000020E6100000A90BBEFD60FE2040CC226B6DD67C4740	Vierwaldstattersee
6	0101000020E61000008F07CDA26E4F20407CB885D650924740	Sempachersee
7	0101000020E610000029E3BDB2E88420406EE5865BA8994740	Baldeggersee
8	0101000020E61000005BA49E08E36D20406E93011278A44740	Hallwilersee
9	0101000020E61000005B2AE83529F72040BE6CC7B1D9914740	Zugersee
10	0101000020E6100000223C01274ED71E4036C1C32304594740	Thunersee
11	0101000020E610000049C5D94EB2E11F400883154A315D4740	Brienzersee
\.
