/***************************************************************************
  localfilesimageprovider.cpp - LocalFilesImageProvider

 ---------------------
 begin                : 18.05.2022
 copyright            : (C) 2022 by Mathieu Pellerin
 email                : mathieu at opengis dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "projectsimageprovider.h"

#include <QFileInfo>

ProjectsImageProvider::ProjectsImageProvider()
  : QQuickImageProvider( Pixmap )
{
}

QImage ProjectsImageProvider::requestImage( const QString &id, QSize *size, const QSize &requestedSize )
{
  // the id is passed on as an encoded URL string which needs decoding
  const QString path = QUrl::fromPercentEncoding( id.toUtf8() );
  const QString previewPath = QStringLiteral( "%1.png" ).arg( path );

  if ( QFileInfo::exists( previewPath ) )
    return QImage( previewPath );

  // Fallback to jpg generated by older QField versions
  const QString previewPathJpg = QStringLiteral( "%1.jpg" ).arg( path );
  if ( QFileInfo::exists( previewPathJpg ) )
    return QImage( previewPathJpg );

  return QImage();
}
