[![Read the Docs](https://img.shields.io/badge/Read-the%20Docs-green.svg)](https://docs.qfield.org/)
[![Discussions](https://img.shields.io/github/discussions/opengisch/qfield?label=Discussions)](https://github.com/opengisch/QField/discussions)
[![Sponsor](https://img.shields.io/static/v1?label=Support&message=%E2%9D%A4)](https://github.com/sponsors/opengisch)
[![Contribute](https://img.shields.io/static/v1?label=Contribute&message=💪)](#contribute)
[![Release](https://img.shields.io/github/release/opengisch/QField.svg?label=Release)](https://github.com/opengisch/QField/releases)
[![OpenSSF Best Practices](https://www.bestpractices.dev/projects/8392/badge)](https://www.bestpractices.dev/projects/8392)


# QField for QGIS

A simplified touch optimized interface for QGIS in the field.

[![QField](https://i0.wp.com/www.opengis.ch/wp-content/uploads/2022/11/QField_App-Medienmitteilung_AppAward2022.jpg?w=1024&ssl=1)](https://qfield.org)

## Get it

Check the [documentation](https://docs.qfield.org/)

### Android

[![Get it on Google Play](https://qfield.org/images/play_store.png)](https://play.google.com/store/apps/details?id=ch.opengis.qfield)

### iOS

[![Get it on App Store](https://qfield.org/images/app_store.png)](https://apps.apple.com/app/qfield-for-qgis/id1531726814)

### Windows

[![Get it on Microsoft Store](https://qfield.org/images/download_windows.png)](https://apps.microsoft.com/detail/xp99h3bcx4bw7f)

### Linux

<a href="https://qfield.org/get_latest?platform=linux" target="_blank">Download the latest Linux version</a>.

### MacOS

<a href="https://qfield.org/get_latest?platform=macos" target="_blank">Download the latest MacOS version</a>.


## Verify Authenticity of the App (Android only)

SHA-256 hash of signing certificate:

```5a7dd946a4b700c081a5bd375dbc8f0d11aa89d53832567ce5b8a92088e0e898```

Use the following command to verify the hash of the signing certificate:

```apksigner verify --print-certs [filename.apk] | grep "5a7dd946a4b700c081a5bd375dbc8f0d11aa89d53832567ce5b8a92088e0e898"```


## Contribute

QField is an open source project, licensed under the terms of the GPLv2 or later. This means that it is free to use and modify and will stay like that.

We are very happy if this app helps you to get your job done or in whatever creative way you may use it.

If you found it useful, we will be even happier if you could give something back. A couple of things you can do are

 * Rate the app [★★★★★](https://play.google.com/store/apps/details?id=ch.opengis.qfield&hl=en#details-reviews)
 * [Tweet about it](https://twitter.com/share?text=Looking%20for%20a%20good%20tool%20for%20field%20work%20in%20GIS?%20Check%20out%20%23QField!)
 * Write about your experience (please [let us know](mailto:info@opengis.ch)!)
 * [Help with the documentation](https://github.com/opengisch/QField-docs#documentation-process)
 * [Translate the documentation](https://github.com/opengisch/QField-docs#translation-process) or [the app](https://www.transifex.com/opengisch/qfield-for-qgis/)
 * [Sponsor a feature](https://docs.qfield.org/get-started/sponsor/)
 * And just drop by to say thank you or have a beer with us next time you meet OPENGIS.ch at a conference

## Get master (unstable) version
We automatically publish the latest master build to a [dedicated channel on the playstore](https://play.google.com/store/apps/details?id=ch.opengis.qfield_dev). You'll need to [join the beta program](https://play.google.com/apps/testing/ch.opengis.qfield_dev) to start getting the latest version.

Please remember that this is the latest development build and is not meant for production.

## Development

For development information, refer to the dedicated [developer documentation](doc/dev.md).
