# Contributing to QField

QField is an open-source project and we appreciate contributions very much. If you are a developer or not, there are multiple ways you can contribute to the project. Go directly to the section [New features, enhancements and bug fixes](#new-features-enhancements-and-bug-fixes) if you are a developer.

## Bug reporting and bug verification

You can help us by submitting bug reports or verification of bugs in the [QField issue tracker](https://github.com/opengisch/QField/issues).

## Documentation

Join the documentation effort about QField. Add, improve or translate the QField documentation in your language.
Check [QField-docs repository](https://github.com/opengisch/QField-docs#qfield-documentation) for more information.

## Translations

Please help translate QField to your language. Community efforts already made QField available in multiple languages. However, translations are an ongoing effort with the fast pace development of QField, so regularly check your language. Learn more [how to become a translator on Transifex](https://docs.transifex.com/getting-started-1/translators#joining-a-translation-team).

## New features, enhancements and bug fixes

If you wish to contribute patches you should:

1. Fork the [QField repository](https://github.com/opengisch/QField).
2. Read the [developer docs](https://github.com/opengisch/QField/blob/master/doc/dev.md) how to make QField running on your development machine.
3. Commit to your own fork of the QField repository.
4. Create a pull request to the [QField repository](https://github.com/opengisch/QField/pulls).

The development team can then review your contribution and commit it upstream as appropriate.

If you commit a new feature, add [FEATURE] to your commit message AND give a clear description of the new feature.

## Other ways to contribute

You can find more information on how to contribute to the whole QField ecosystem on [our website](https://docs.qfield.org/get-started/contribute/#development).
