/**
 * Copyright 2015 Joshua Cain
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.semper.reformanda.syndication.rss.itunes;

public class ItunesCategoryNames {
	
	public static final String comedy = "Comedy";
	public static final String kidsAndFamily = "Kids & Family";
	public static final String music = "Music";
	public static final String newsAndPolitics = "News & Politics";
	public static final String tvAndFilm = "TV & Film";
	
	public static class Arts {
		public static final String design = "Design";
		public static final String fashionAndBeauty = "Fashion & Beauty";
		public static final String food = "Food";
		public static final String literatur = "Literature";
		public static final String performingArts = "Performing Arts";
		public static final String visualArts = "Visual Arts";
		
		public static String value() {
			return "Arts";
		}
	}
	
	public static class Business {
		public static final String businessNews = "Business News";
		public static final String careers = "Careers";
		public static final String investing = "Investing";
		public static final String managementAndMarketing = "Management & Marketing";
		public static final String shopping = "Shopping";
		
		public static String value() {
			return "Business";
		}
	}
	
	public static class Education {
		public static final String educationTechnology = "Educational Technology";
		public static final String higherEducation = "Higher Education";
		public static final String k12 = "K-12";
		public static final String languageCourses = "Language Courses";
		public static final String training = "Training";
		public static final String gamesAndHobbies = "Games & Hobbies";
		public static final String automotive = "Automotive";
		public static final String aviation = "Aviation";
		public static final String hobbies = "Hobbies";
		public static final String otherGame = "Other Games";
		public static final String videoGames = "Video Games";
		
		public static String value() {
			return "Education";
		}
	}
	
	public static class GovernmentAndOrganizations {
		public static final String local = "Local";
		public static final String national = "National";
		public static final String nonProfit = "Non-Profit";
		public static final String regional = "Regional";
		
		public static String value() {
			return "Government & Organizations";
		}
	}
	
	public static class Health {
		public static final String alternativeHealth = "Alternative Health";
		public static final String fitnessAndNutrition = "Fitness & Nutrition";
		public static final String selfHelp = "Self-Help";
		public static final String sexuality = "Sexuality";
		
		public static String value() {
			return "Health";
		}
	}
	
	public static class ReligionAndSpirituality {
		public static final String buddhism = "Buddhism";
		public static final String christianity = "Christianity";
		public static final String hinduism = "Hinduism";
		public static final String islam = "Islam";
		public static final String judaism = "Judaism";
		public static final String other = "Other";
		public static final String spirituality = "Spirituality";
		
		public static String value() {
			return "Religion & Spirituality";
		}
	}
	
	public static class ScienceAndMedicine {
		public static final String medicine = "Medicine";
		public static final String naturalSciences = "Natural Sciences";
		public static final String socialSciences = "Social Sciences";
		
		public static String value() {
			return "Science & Medicine";
		}
	}
	
	public static class SocietyAndCulture {
		public static final String history = "History";
		public static final String personalJournals = "Personal Journals";
		public static final String philosophy = "Philosophy";
		public static final String placesAndTravel = "Places & Travel";
		
		public static String value() {
			return "Society & Culture";
		}
	}
	
	public static class SportsAndRecreation {
		public static final String amateur = "Amateur";
		public static final String collegeAndHighSchool = "College & High School";
		public static final String outdoor = "Outdoor";
		public static final String professional = "Professional";
		
		public static String value() {
			return "Sports & Recreation";
		}
	}
	
	public static class Technology {
		public static final String gadgets = "Gadgets";
		public static final String techNews = "Tech News";
		public static final String podcasting = "Podcasting";
		public static final String softwareHowTo = "Software How-To";
		
		public static String value() {
			return "Technology";
		}
	}
}