/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.lang.reflect.Type;
import java.util.LinkedList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    long fixedHandle;
    long redrawWindow;
    long enableWindow;
    long provider;
    int drawCount;
    int backgroundAlpha = 255;
    long enterNotifyEventId;
    long dragGesture;
    long zoomGesture;
    long rotateGesture;
    long panGesture;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    Region region;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    Control labelRelation;
    String cssBackground;
    String cssForeground = " ";
    LinkedList<Event> dragDetectionQueue;
    static Callback enterNotifyEventFunc;
    static int enterNotifyEventSignalId;
    static int GTK_POINTER_WINDOW;
    static int SWT_GRAB_WIDGET;
    static Callback gestureZoom;
    static Callback gestureRotation;
    static Callback gestureSwipe;
    static Callback gestureBegin;
    static Callback gestureEnd;

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget(0);
    }

    void connectPaint() {
        long l = this.paintHandle();
        int n = 2;
        OS.gtk_widget_add_events(l, n);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[18], 0, this.display.getClosure(19), false);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[18], 0, this.display.getClosure(18), true);
    }

    Font defaultFont() {
        return this.display.getSystemFont();
    }

    @Override
    void deregister() {
        long l;
        super.deregister();
        if (this.fixedHandle != 0L) {
            this.display.removeWidget(this.fixedHandle);
        }
        if ((l = this.imHandle()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    void drawBackground(Control control, long l, long l2, int n, int n2, int n3, int n4) {
        this.drawBackground(control, l, 0L, l2, n, n2, n3, n4);
    }

    void drawBackground(Control control, long l, long l2, long l3, int n, int n2, int n3, int n4) {
        if (OS.USE_CAIRO) {
            long l4;
            long l5 = l4 = l2 != 0L ? l2 : OS.gdk_cairo_create(l);
            if (l4 == 0L) {
                this.error(2);
            }
            if (l3 != 0L) {
                OS.gdk_cairo_region(l4, l3);
                Cairo.cairo_clip(l4);
            }
            if (control.backgroundImage != null) {
                Point point = this.display.mapInPixels(this, control, 0, 0);
                Cairo.cairo_translate(l4, -point.x, -point.y);
                n += point.x;
                n2 += point.y;
                long l6 = Cairo.cairo_pattern_create_for_surface(control.backgroundImage.surface);
                if (l6 == 0L) {
                    this.error(2);
                }
                Cairo.cairo_pattern_set_extend(l6, 1);
                if ((this.style & 0x8000000) != 0) {
                    double[] dArray = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    Cairo.cairo_pattern_set_matrix(l6, dArray);
                }
                Cairo.cairo_set_source(l4, l6);
                Cairo.cairo_pattern_destroy(l6);
            } else {
                GdkColor gdkColor = control.getBackgroundColor();
                GdkRGBA gdkRGBA = this.display.toGdkRGBA(gdkColor);
                Cairo.cairo_set_source_rgba(l4, gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, gdkRGBA.alpha);
            }
            Cairo.cairo_rectangle(l4, n, n2, n3, n4);
            Cairo.cairo_fill(l4);
            if (l4 != l2) {
                Cairo.cairo_destroy(l4);
            }
            return;
        }
        long l7 = OS.gdk_gc_new(l);
        if (l3 != 0L) {
            OS.gdk_gc_set_clip_region(l7, l3);
        }
        if (control.backgroundImage != null) {
            Point point = this.display.mapInPixels(this, control, 0, 0);
            OS.gdk_gc_set_fill(l7, 1);
            OS.gdk_gc_set_ts_origin(l7, -point.x, -point.y);
            OS.gdk_gc_set_tile(l7, control.backgroundImage.pixmap);
            OS.gdk_draw_rectangle(l, l7, 1, n, n2, n3, n4);
        } else {
            GdkColor gdkColor = control.getBackgroundColor();
            OS.gdk_gc_set_foreground(l7, gdkColor);
            OS.gdk_draw_rectangle(l, l7, 1, n, n2, n3, n4);
        }
        OS.g_object_unref(l7);
    }

    boolean drawGripper(GC gC, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        long l = this.paintHandle();
        long l2 = this.gtk_widget_get_window(l);
        if (l2 == 0L) {
            return false;
        }
        int n6 = n5 = bl ? 0 : 1;
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n3 - n;
        }
        if (OS.GTK3) {
            long l3 = OS.gtk_widget_get_style_context(l);
            OS.gtk_style_context_save(l3);
            OS.gtk_style_context_add_class(l3, OS.GTK_STYLE_CLASS_PANE_SEPARATOR);
            OS.gtk_style_context_set_state(l3, 0L);
            OS.gtk_render_handle(l3, gC.handle, n, n2, n3, n4);
            OS.gtk_style_context_restore(l3);
        } else {
            OS.gtk_paint_handle(OS.gtk_widget_get_style(l), l2, 0, 2, null, l, new byte[1], n, n2, n3, n4, n5);
        }
        return true;
    }

    void drawWidget(GC gC) {
    }

    void enableWidget(boolean bl) {
        OS.gtk_widget_set_sensitive(this.handle, bl);
    }

    long enterExitHandle() {
        return this.eventHandle();
    }

    long eventHandle() {
        return this.handle;
    }

    long eventWindow() {
        long l = this.eventHandle();
        OS.gtk_widget_realize(l);
        return this.gtk_widget_get_window(l);
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        long l = shell.vboxHandle;
        OS.gtk_widget_set_can_focus(l, true);
        OS.gtk_widget_grab_focus(l);
        if (this.isDisposed()) {
            return;
        }
        OS.gtk_widget_set_can_focus(l, false);
    }

    void fixStyle() {
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void fixStyle(long l) {
        long l2;
        if ((this.state & 0x2000) != 0) {
            return;
        }
        if ((this.state & 0x10000) == 0) {
            return;
        }
        if (!OS.GTK3 && (l2 = this.parent.childStyle()) != 0L) {
            GdkColor gdkColor = new GdkColor();
            OS.gtk_style_get_bg(l2, 0, gdkColor);
            this.setBackgroundColor(gdkColor);
        }
    }

    long focusHandle() {
        return this.handle;
    }

    long fontHandle() {
        return this.handle;
    }

    long gestureHandle() {
        return this.handle;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public int getTextDirection() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    @Override
    void hookEvents() {
        long l = this.focusHandle();
        int n = 19456;
        OS.gtk_widget_add_events(l, n);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[38], 0, this.display.getClosure(38), false);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[46], 0, this.display.getClosure(46), false);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[27], 0, this.display.getClosure(27), false);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[28], 0, this.display.getClosure(28), false);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[20], 0, this.display.getClosure(20), false);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[21], 0, this.display.getClosure(21), false);
        OS.g_signal_connect_closure_by_id(l, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        long l2 = this.eventHandle();
        int n2 = 10486532;
        OS.gtk_widget_add_events(l2, n2);
        OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[4], 0, this.display.getClosure(4), false);
        OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[33], 0, this.display.getClosure(33), false);
        OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[43], 0, this.display.getClosure(43), false);
        long l3 = this.enterExitHandle();
        int n3 = 12288;
        OS.gtk_widget_add_events(l3, n3);
        OS.g_signal_connect_closure_by_id(l3, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        OS.g_signal_connect_closure_by_id(l3, this.display.signalIds[29], 0, this.display.getClosure(29), false);
        this.setZoomGesture();
        this.setDragGesture();
        this.setRotateGesture();
        long l4 = this.fixedHandle != 0L ? this.fixedHandle : l2;
        OS.g_signal_connect_closure_by_id(l4, this.display.signalIds[2], 0, this.display.getClosure(3), true);
        OS.g_signal_connect_closure_by_id(l4, this.display.signalIds[4], 0, this.display.getClosure(5), true);
        OS.g_signal_connect_closure_by_id(l4, this.display.signalIds[33], 0, this.display.getClosure(34), true);
        OS.g_signal_connect_closure_by_id(l2, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        if (l != l2) {
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        this.connectPaint();
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[40], 0, this.display.getClosure(40), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[56], 0, this.display.getClosure(56), false);
        long l5 = this.imHandle();
        if (l5 != 0L) {
            OS.g_signal_connect_closure(l5, OS.commit, this.display.getClosure(9), false);
            OS.g_signal_connect_closure(l5, OS.preedit_changed, this.display.getClosure(39), false);
        }
        OS.g_signal_connect_closure_by_id(this.paintHandle(), this.display.signalIds[48], 0, this.display.getClosure(48), false);
        long l6 = this.topHandle();
        OS.g_signal_connect_closure_by_id(l6, this.display.signalIds[30], 0, this.display.getClosure(30), true);
        if (enterNotifyEventFunc == null && OS.GTK3 && OS.GTK_VERSION < OS.VERSION(3, 11, 9)) {
            enterNotifyEventFunc = new Callback(Control.class, "enterNotifyEventProc", 4);
            if (enterNotifyEventFunc.getAddress() == 0L) {
                SWT.error(3);
            }
            enterNotifyEventSignalId = OS.g_signal_lookup(OS.enter_notify_event, OS.GTK_TYPE_WIDGET());
            byte[] byArray = Converter.wcsToMbcs("gtk-pointer-window", true);
            GTK_POINTER_WINDOW = OS.g_quark_from_string(byArray);
            byArray = Converter.wcsToMbcs("swt-grab-widget", true);
            SWT_GRAB_WIDGET = OS.g_quark_from_string(byArray);
        }
    }

    boolean hooksPaint() {
        return this.hooks(9) || this.filters(9);
    }

    @Override
    long hoverProc(long l) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.gdk_window_get_device_position(0L, nArray, nArray2, nArray3);
        this.sendMouseEvent(32, 0, 0, nArray[0], nArray2[0], false, nArray3[0]);
        return 0L;
    }

    @Override
    long topHandle() {
        if (this.fixedHandle != 0L) {
            return this.fixedHandle;
        }
        return super.topHandle();
    }

    long paintHandle() {
        long l = this.topHandle();
        long l2 = this.handle;
        while (l2 != l && !OS.gtk_widget_get_has_window(l2)) {
            l2 = OS.gtk_widget_get_parent(l2);
        }
        return l2;
    }

    @Override
    long paintWindow() {
        long l = this.paintHandle();
        OS.gtk_widget_realize(l);
        return this.gtk_widget_get_window(l);
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        long l = this.topHandle();
        OS.gtk_widget_realize(l);
        if (OS.GTK3) {
            OS.gtk_widget_draw(l, gC.handle);
            return true;
        }
        long l2 = this.gtk_widget_get_window(l);
        GCData gCData = gC.getGCData();
        OS.gdk_window_process_updates(l2, true);
        long l3 = gCData.drawable;
        if (l3 == 0L) {
            l3 = OS.gdk_get_default_root_window();
        }
        this.printWidget(gC, l3, OS.gdk_drawable_get_depth(l3), 0, 0);
        return true;
    }

    void printWidget(GC gC, long l, int n, int n2, int n3) {
        boolean bl = (this.state & 0x40) != 0;
        this.state &= 0xFFFFFFBF;
        long l2 = this.topHandle();
        long l3 = this.gtk_widget_get_window(l2);
        this.printWindow(true, this, gC, l, n, l3, n2, n3);
        if (bl) {
            this.state |= 0x40;
        }
    }

    void printWindow(boolean bl, Control control, GC gC, long l, int n, long l2, int n2, int n3) {
        long l3;
        long l4;
        Object object;
        if (OS.gdk_drawable_get_depth(l2) != n) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gdk_window_get_size(l2, nArray, nArray2);
        gdkRectangle.width = nArray[0];
        gdkRectangle.height = nArray2[0];
        OS.gdk_window_begin_paint_rect(l2, gdkRectangle);
        long[] lArray = new long[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.gdk_window_get_internal_paint_info(l2, lArray, nArray3, nArray4);
        long[] lArray2 = new long[1];
        OS.gdk_window_get_user_data(l2, lArray2);
        if (lArray2[0] != 0L) {
            long l5 = OS.gdk_event_new(2);
            GdkEventExpose gdkEventExpose = new GdkEventExpose();
            gdkEventExpose.type = 2;
            gdkEventExpose.window = OS.g_object_ref(l2);
            gdkEventExpose.area_width = gdkRectangle.width;
            gdkEventExpose.area_height = gdkRectangle.height;
            gdkEventExpose.region = OS.gdk_region_rectangle(gdkRectangle);
            OS.memmove(l5, gdkEventExpose, (long)GdkEventExpose.sizeof);
            OS.gtk_widget_send_expose(lArray2[0], l5);
            OS.gdk_event_free(l5);
        }
        int n4 = nArray3[0];
        int n5 = nArray4[0];
        int n6 = n2;
        int n7 = n3;
        int n8 = nArray[0];
        int n9 = nArray2[0];
        if (!bl) {
            object = new int[1];
            int[] nArray5 = new int[1];
            OS.gdk_window_get_position(l2, object, nArray5);
            long l6 = OS.gdk_window_get_parent(l2);
            int[] nArray6 = new int[1];
            int[] nArray7 = new int[1];
            this.gdk_window_get_size(l6, nArray6, nArray7);
            n4 = nArray3[0] - object[0];
            n5 = nArray4[0] - nArray5[0];
            n6 = n2 - object[0];
            n7 = n3 - nArray5[0];
            n8 = Math.min(object[0] + nArray[0], nArray6[0]);
            n9 = Math.min(nArray5[0] + nArray2[0], nArray7[0]);
        }
        object = gC.getGCData();
        long l7 = object.cairo;
        if (l7 != 0L) {
            l4 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
            long l8 = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            l3 = OS.GDK_PIXMAP_XID(lArray[0]);
            long l9 = Cairo.cairo_xlib_surface_create(l4, l3, l8, nArray[0], nArray2[0]);
            if (l9 == 0L) {
                this.error(2);
            }
            Cairo.cairo_save(l7);
            Cairo.cairo_rectangle(l7, n6, n7, n8, n9);
            Cairo.cairo_clip(l7);
            Cairo.cairo_translate(l7, n6, n7);
            long l10 = Cairo.cairo_pattern_create_for_surface(l9);
            if (l10 == 0L) {
                this.error(2);
            }
            Cairo.cairo_pattern_set_filter(l10, 2);
            Cairo.cairo_set_source(l7, l10);
            if (object.alpha != 255) {
                Cairo.cairo_paint_with_alpha(l7, (float)object.alpha / 255.0f);
            } else {
                Cairo.cairo_paint(l7);
            }
            Cairo.cairo_restore(l7);
            Cairo.cairo_pattern_destroy(l10);
            Cairo.cairo_surface_destroy(l9);
        } else {
            OS.gdk_draw_drawable(l, gC.handle, lArray[0], n4, n5, n6, n7, n8, n9);
        }
        OS.gdk_window_end_paint(l2);
        l4 = OS.gdk_window_get_children(l2);
        if (l4 != 0L) {
            long l11 = l4;
            while (l11 != 0L) {
                l3 = OS.g_list_data(l11);
                if (OS.gdk_window_is_visible(l3)) {
                    Widget widget;
                    long[] lArray3 = new long[1];
                    OS.gdk_window_get_user_data(l3, lArray3);
                    if (lArray3[0] != 0L && ((widget = this.display.findWidget(lArray3[0])) == null || widget == control)) {
                        int[] nArray8 = new int[1];
                        int[] nArray9 = new int[1];
                        OS.gdk_window_get_position(l3, nArray8, nArray9);
                        this.printWindow(false, control, gC, l, n, l3, n2 + nArray8[0], n3 + nArray9[0]);
                    }
                }
                l11 = OS.g_list_next(l11);
            }
            OS.g_list_free(l4);
        }
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    Point computeSizeInPixels(int n, int n2) {
        return this.computeSizeInPixels(n, n2, true);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n;
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFF7FFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0 || this.backgroundAlpha == 0) {
                if (n == 1 || this.backgroundAlpha == 0) {
                    Control control = this;
                    do {
                        if ((control.state & 0x10000) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x8000;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkForeground() {
        if (OS.GTK_VERSION < OS.VERSION(3, 16, 0)) {
            this.setForegroundColor(this.topHandle(), this.display.COLOR_WIDGET_FOREGROUND);
        }
    }

    void checkBorder() {
        if (this.getBorderWidthInPixels() == 0) {
            this.style &= 0xFFFFF7FF;
        }
    }

    void checkMirrored() {
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
        }
    }

    long childStyle() {
        return this.parent.childStyle();
    }

    @Override
    void createWidget(int n) {
        this.state |= 0x800000;
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.checkBackground();
        this.checkForeground();
        if ((this.state & 0x8000) != 0) {
            this.setParentBackground();
        }
        this.checkBuffered();
        this.showWidget();
        this.setInitialBounds();
        this.setZOrder(null, false, false);
        this.setRelations();
        this.checkMirrored();
        this.checkBorder();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        n = DPIUtil.autoScaleUp(n);
        n2 = DPIUtil.autoScaleUp(n2);
        return DPIUtil.autoScaleDown(this.computeSizeInPixels(n, n2, bl));
    }

    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        return this.computeNativeSize(this.handle, n, n2, bl);
    }

    Point computeNativeSize(long l, int n, int n2, boolean bl) {
        int n3 = n;
        int n4 = n2;
        if (OS.GTK3) {
            if (n == -1 && n2 == -1) {
                GtkRequisition gtkRequisition = new GtkRequisition();
                OS.gtk_widget_get_preferred_size(l, null, gtkRequisition);
                n3 = gtkRequisition.width;
                n4 = gtkRequisition.height;
            } else if (n == -1 || n2 == -1) {
                int[] nArray = new int[1];
                if (n == -1) {
                    OS.gtk_widget_get_preferred_width_for_height(l, n4, null, nArray);
                    n3 = nArray[0];
                } else {
                    OS.gtk_widget_get_preferred_height_for_width(l, n3, null, nArray);
                    n4 = nArray[0];
                }
            }
            return new Point(n3, n4);
        }
        if (n == -1 && n2 == -1) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_size_request(l, gtkRequisition);
            n3 = OS.GTK_WIDGET_REQUISITION_WIDTH(l);
            n4 = OS.GTK_WIDGET_REQUISITION_HEIGHT(l);
        } else if (n == -1 || n2 == -1) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_widget_get_size_request(l, nArray, nArray2);
            OS.gtk_widget_set_size_request(l, n, n2);
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_size_request(l, gtkRequisition);
            OS.gtk_widget_set_size_request(l, nArray[0], nArray2[0]);
            n3 = n == -1 ? gtkRequisition.width : n;
            n4 = n2 == -1 ? gtkRequisition.height : n2;
        }
        return new Point(n3, n4);
    }

    void forceResize() {
        long l = this.topHandle();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(l, gtkRequisition);
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        OS.gtk_widget_size_allocate(l, gtkAllocation);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        return this._getAccessible();
    }

    Accessible _getAccessible() {
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int n;
        this.checkWidget();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        return new Rectangle(n2, n3, n4, n);
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(rectangle);
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    void setBoundsInPixels(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n, n2, n3, n4));
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    void setBoundsInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true);
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    @Override
    void modifyStyle(long l, long l2) {
        super.modifyStyle(l, l2);
        if (this.region != null) {
            OS.gdk_window_shape_combine_region(this.gtk_widget_get_window(this.topHandle()), this.region.handle, 0, 0);
        }
    }

    void moveHandle(int n, int n2) {
        long l = this.topHandle();
        long l2 = this.parent.parentingHandle();
        if (OS.GTK3) {
            OS.swt_fixed_move(l2, l, n, n2);
        } else {
            boolean bl = OS.gtk_widget_get_visible(l2);
            this.gtk_widget_set_visible(l2, false);
            OS.gtk_fixed_move(l2, l, n, n2);
            this.gtk_widget_set_visible(l2, bl);
        }
    }

    void resizeHandle(int n, int n2) {
        long l = this.topHandle();
        if (OS.GTK3) {
            OS.swt_fixed_resize(OS.gtk_widget_get_parent(l), l, n, n2);
            if (l != this.handle) {
                Point point = this.resizeCalculationsGTK3(this.handle, n, n2);
                n = point.x;
                n2 = point.y;
                OS.swt_fixed_resize(OS.gtk_widget_get_parent(this.handle), this.handle, n, n2);
            }
        } else {
            OS.gtk_widget_set_size_request(l, n, n2);
            if (l != this.handle) {
                OS.gtk_widget_set_size_request(this.handle, n, n2);
            }
        }
    }

    Point resizeCalculationsGTK3(long l, int n, int n2) {
        Point point = new Point(n, n2);
        if (OS.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            OS.gtk_widget_get_preferred_size(l, gtkRequisition, null);
            point.x = n - (gtkRequisition.width - n) < 0 ? gtkRequisition.width : n;
            point.y = n2 - (gtkRequisition.height - n2) < 0 ? gtkRequisition.height : n2;
        }
        return point;
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        n3 = Math.min(n3, Short.MAX_VALUE);
        n4 = Math.min(n4, Short.MAX_VALUE);
        long l = this.topHandle();
        boolean bl3 = bl;
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        if ((this.parent.style & 0x8000000) != 0) {
            n8 = this.parent.getClientWidth();
            n7 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            n6 = n8 - n7 - gtkAllocation.x;
            if (bl) {
                bl3 &= n != n6;
                n = n8 - (bl2 ? n3 : n7) - n;
            } else {
                bl = true;
                n = n8 - (bl2 ? n3 : n7) - n6;
                n2 = gtkAllocation.y;
            }
        }
        n8 = 1;
        n7 = 1;
        if (bl) {
            n6 = gtkAllocation.x;
            n5 = gtkAllocation.y;
            int n9 = n8 = n == n6 && n2 == n5 ? 1 : 0;
            if (n8 == 0) {
                if (this.enableWindow != 0L) {
                    OS.gdk_window_move(this.enableWindow, n, n2);
                }
                this.moveHandle(n, n2);
            }
        }
        n6 = 0;
        if (bl2) {
            n5 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            int n10 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
            int n11 = n7 = n3 == n5 && n4 == n10 ? 1 : 0;
            if (n7 == 0 && (this.style & 0x8000000) != 0) {
                n6 = this.getClientWidth();
            }
            if (n7 == 0 && (n3 != 0 || n4 != 0)) {
                int n12 = Math.max(1, n3);
                int n13 = Math.max(1, n4);
                if (this.redrawWindow != 0L) {
                    OS.gdk_window_resize(this.redrawWindow, n12, n13);
                }
                if (this.enableWindow != 0L) {
                    OS.gdk_window_resize(this.enableWindow, n12, n13);
                }
                this.resizeHandle(n12, n13);
            }
        }
        if (n8 == 0 || n7 == 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_size_request(l, gtkRequisition);
            if (bl) {
                gtkAllocation.x = n;
                gtkAllocation.y = n2;
            }
            if (bl2) {
                gtkAllocation.width = n3;
                gtkAllocation.height = n4;
            }
            if (OS.GTK_VERSION >= OS.VERSION(3, 8, 0) && !OS.gtk_widget_get_visible(l)) {
                OS.gtk_widget_show(l);
                this.gtk_widget_get_preferred_size(l, gtkRequisition);
                OS.gtk_widget_size_allocate(l, gtkAllocation);
                OS.gtk_widget_hide(l);
            } else {
                OS.gtk_widget_size_allocate(l, gtkAllocation);
            }
        }
        if (n7 == 0) {
            this.state = n3 == 0 ? this.state | 0x200 : this.state & 0xFFFFFDFF;
            int n14 = this.state = n4 == 0 ? this.state | 0x400 : this.state & 0xFFFFFBFF;
            if ((this.state & 0x600) != 0) {
                if (this.enableWindow != 0L) {
                    OS.gdk_window_hide(this.enableWindow);
                }
                OS.gtk_widget_hide(l);
            } else if ((this.state & 0x800) == 0) {
                if (this.enableWindow != 0L) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
                OS.gtk_widget_show(l);
            }
            if ((this.style & 0x8000000) != 0) {
                this.moveChildren(n6);
            }
        }
        int n15 = 0;
        if (bl && n8 == 0) {
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            if (bl3) {
                this.sendEvent(10);
            }
            n15 |= 0x80;
        }
        if (bl2 && n7 == 0) {
            this.sendEvent(11);
            n15 |= 0x100;
        }
        return n15;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        this.checkWidget();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.y;
        if ((this.parent.style & 0x8000000) != 0) {
            int n3 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            n = this.parent.getClientWidth() - n3 - n;
        }
        return new Point(n, n2);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    void setLocationInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    void setLocationInPixels(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false);
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.checkWidget();
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        int n = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n2 = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        return new Point(n, n2);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    void setSizeInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        long l = this.gtk_widget_get_window(this.topHandle());
        long l2 = region == null ? 0L : region.handle;
        OS.gdk_window_shape_combine_region(l, l2, 0, 0);
        this.region = region;
    }

    void setRelations() {
        Widget widget;
        long l;
        long l2 = this.parent.parentingHandle();
        long l3 = OS.gtk_container_get_children(l2);
        if (l3 == 0L) {
            return;
        }
        int n = OS.g_list_length(l3);
        if (n > 1 && (l = OS.g_list_nth_data(l3, n - 2)) != 0L && (widget = this.display.getWidget(l)) != null && widget != this && widget instanceof Control) {
            Control control = (Control)widget;
            control.addRelation(this);
        }
        OS.g_list_free(l3);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        Point point = DPIUtil.autoScaleUp(new Point(n, n2));
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    void setSizeInPixels(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true);
    }

    @Override
    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isFocusHandle(long l) {
        return l == this.focusHandle();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, true, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            if (this == control) {
                return;
            }
        }
        this.setZOrder(control, false, true);
    }

    void moveChildren(int n) {
    }

    public void pack() {
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.setSize(this.computeSize(-1, -1, bl));
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        long l = this.eventWindow();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l, nArray, nArray2);
        n -= DPIUtil.autoScaleDown(nArray[0]);
        n2 -= DPIUtil.autoScaleDown(nArray2[0]);
        if ((this.style & 0x8000000) != 0) {
            n = DPIUtil.autoScaleDown(this.getClientWidth()) - n;
        }
        return new Point(n, n2);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        long l = this.eventWindow();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l, nArray, nArray2);
        if ((this.style & 0x8000000) != 0) {
            n = DPIUtil.autoScaleDown(this.getClientWidth()) - n;
        }
        return new Point(n += DPIUtil.autoScaleDown(nArray[0]), n2 += DPIUtil.autoScaleDown(nArray2[0]));
    }

    Point toDisplayInPixels(int n, int n2) {
        this.checkWidget();
        long l = this.eventWindow();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(l, nArray, nArray2);
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n;
        }
        return new Point(n += nArray[0], n2 += nArray2[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    Point toDisplayInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplayInPixels(point.x, point.y);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(gestureListener);
        this.addListener(48, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(touchListener);
        this.addListener(47, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeGestureListener(GestureListener gestureListener) {
        this.checkWidget();
        if (gestureListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(48, gestureListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        if (this.labelRelation != null) {
            this._getAccessible().removeRelation(9, this.labelRelation._getAccessible());
            this.labelRelation = null;
        }
    }

    public void removeTouchListener(TouchListener touchListener) {
        this.checkWidget();
        if (touchListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(47, touchListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 || n2 != 1) {
            return false;
        }
        if (!this.dragDetect(n4, n5, false, true, null)) {
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3 = false;
        if (!OS.isX11()) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            if (!OS.gtk_gesture_drag_get_start_point(this.dragGesture, dArray3, dArray4)) return false;
            OS.gtk_gesture_drag_get_offset(this.dragGesture, dArray, dArray2);
            if (!OS.gtk_drag_check_threshold(this.handle, (int)dArray3[0], (int)dArray4[0], (int)dArray3[0] + (int)dArray[0], (int)dArray4[0] + (int)dArray2[0])) return bl3;
            return true;
        }
        boolean bl4 = false;
        Point point = null;
        Point point2 = null;
        if (OS.GTK3) {
            point = this.display.getCursorLocationInPixels();
        }
        while (!bl4) {
            long l = 0L;
            long l2 = System.currentTimeMillis() + 500L;
            this.display.sendPreExternalEventDispatchEvent();
            while (System.currentTimeMillis() < l2 && (l = OS.gdk_event_get()) == 0L) {
                if (OS.GTK3) {
                    point2 = this.display.getCursorLocationInPixels();
                    bl3 = OS.gtk_drag_check_threshold(this.handle, point.x, point.y, point2.x, point2.y);
                    if (!bl3) continue;
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            this.display.sendPostExternalEventDispatchEvent();
            if (bl3) {
                return true;
            }
            if (l == 0L) {
                return bl2;
            }
            switch (OS.GDK_EVENT_TYPE(l)) {
                case 3: {
                    GdkEventMotion gdkEventMotion = new GdkEventMotion();
                    OS.memmove(gdkEventMotion, l, (long)GdkEventMotion.sizeof);
                    if ((gdkEventMotion.state & 0x100) != 0) {
                        if (OS.gtk_drag_check_threshold(this.handle, n, n2, (int)gdkEventMotion.x, (int)gdkEventMotion.y)) {
                            bl3 = true;
                            bl4 = true;
                        }
                    } else {
                        bl4 = true;
                    }
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    this.gdk_window_get_device_position(gdkEventMotion.window, nArray, nArray2, null);
                    break;
                }
                case 8: 
                case 9: {
                    GdkEventKey gdkEventKey = new GdkEventKey();
                    OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
                    if (gdkEventKey.keyval != 65307) break;
                    bl4 = true;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    OS.gdk_event_put(l);
                    bl4 = true;
                    break;
                }
                default: {
                    OS.gtk_main_do_event(l);
                }
            }
            OS.gdk_event_free(l);
        }
        return bl3;
    }

    boolean filterKey(int n, long l) {
        long l2 = this.imHandle();
        if (l2 != 0L) {
            return OS.gtk_im_context_filter_keypress(l2, l);
        }
        return false;
    }

    Control findBackgroundControl() {
        if (((this.state & 0x2000) != 0 || this.backgroundImage != null) && this.backgroundAlpha > 0) {
            return this;
        }
        return this.parent != null && (this.state & 0x8000) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    @Override
    long fixedMapProc(long l) {
        OS.gtk_widget_set_mapped(l, true);
        long l2 = OS.gtk_container_get_children(l);
        if (l2 != 0L) {
            long l3 = l2;
            while (l3 != 0L) {
                long l4 = OS.g_list_data(l3);
                if (OS.gtk_widget_get_visible(l4) && OS.gtk_widget_get_child_visible(l4) && !OS.gtk_widget_get_mapped(l4)) {
                    OS.gtk_widget_map(l4);
                }
                l3 = OS.g_list_next(l3);
            }
            OS.g_list_free(l2);
        }
        if (OS.gtk_widget_get_has_window(l)) {
            OS.gdk_window_show_unraised(this.gtk_widget_get_window(l));
        }
        return 0L;
    }

    void fixModal(long l, long l2) {
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Shell shell = this.getShell();
        shell.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        shell.bringToTop(false);
        return this.forceFocus(this.focusHandle());
    }

    boolean forceFocus(long l) {
        if (OS.gtk_widget_has_focus(l)) {
            return true;
        }
        OS.gtk_widget_realize(l);
        OS.gtk_widget_grab_focus(l);
        if (this.isDisposed()) {
            return false;
        }
        Shell shell = this.getShell();
        long l2 = shell.shellHandle;
        long l3 = OS.gtk_window_get_focus(l2);
        while (l3 != 0L) {
            if (l3 == l) {
                this.display.ignoreFocus = false;
                return true;
            }
            Widget widget = this.display.getWidget(l3);
            if (widget != null && widget instanceof Control) {
                return widget == this;
            }
            l3 = OS.gtk_widget_get_parent(l3);
        }
        return false;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.backgroundAlpha == 0) {
            Color color = Color.gtk_new(this.display, this.getBackgroundColor(), 0);
            return color;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.gtk_new(this.display, control.getBackgroundColor(), this.backgroundAlpha);
    }

    GdkColor getBackgroundColor() {
        return this.getBgColor();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    GdkColor getContextBackground() {
        long l = this.fontHandle();
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (this.provider != 0L) {
                return this.display.gtk_css_parse_background(this.provider, null);
            }
            return this.display.COLOR_WIDGET_BACKGROUND;
        }
        long l2 = OS.gtk_widget_get_style_context(l);
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.gtk_style_context_get_background_color(l2, 0, gdkRGBA);
        if (gdkRGBA.alpha == 0.0) {
            return this.display.COLOR_WIDGET_BACKGROUND;
        }
        return this.display.toGdkColor(gdkRGBA);
    }

    GdkColor getContextColor() {
        long l = this.fontHandle();
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            return this.display.gtk_css_parse_foreground(this.provider, null);
        }
        long l2 = OS.gtk_widget_get_style_context(l);
        GdkRGBA gdkRGBA = new GdkRGBA();
        gdkRGBA = this.display.styleContextGetColor(l2, 0, gdkRGBA);
        return this.display.toGdkColor(gdkRGBA);
    }

    GdkColor getBgColor() {
        if (OS.GTK3) {
            return this.getContextBackground();
        }
        long l = this.fontHandle();
        OS.gtk_widget_realize(l);
        GdkColor gdkColor = new GdkColor();
        long l2 = OS.gtk_widget_get_style(l);
        if (l2 != 0L) {
            OS.gtk_style_get_bg(l2, 0, gdkColor);
        }
        return gdkColor;
    }

    GdkColor getBaseColor() {
        if (OS.GTK3) {
            return this.getContextBackground();
        }
        long l = this.fontHandle();
        OS.gtk_widget_realize(l);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_base(OS.gtk_widget_get_style(l), 0, gdkColor);
        return gdkColor;
    }

    public int getBorderWidth() {
        return DPIUtil.autoScaleDown(this.getBorderWidthInPixels());
    }

    int getBorderWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    int getClientWidth() {
        if (this.handle == 0L || (this.state & 0x200) != 0) {
            return 0;
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
        return gtkAllocation.width;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x800000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    long getFontDescription() {
        long l = this.fontHandle();
        if (OS.GTK3) {
            long l2 = OS.gtk_widget_get_style_context(l);
            if (OS.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                return OS.gtk_style_context_get_font(l2, 0);
            }
            return OS.gtk_style_context_get_font(l2, OS.gtk_widget_get_state_flags(l));
        }
        OS.gtk_widget_realize(l);
        return OS.gtk_style_get_font_desc(OS.gtk_widget_get_style(l));
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.gtk_new(this.display, this.getForegroundColor());
    }

    GdkColor getForegroundColor() {
        return this.getFgColor();
    }

    GdkColor getFgColor() {
        if (OS.GTK3) {
            return this.getContextColor();
        }
        long l = this.fontHandle();
        OS.gtk_widget_realize(l);
        GdkColor gdkColor = new GdkColor();
        long l2 = OS.gtk_widget_get_style(l);
        if (l2 != 0L) {
            OS.gtk_style_get_fg(l2, 0, gdkColor);
        }
        return gdkColor;
    }

    Point getIMCaretPos() {
        return new Point(0, 0);
    }

    GdkColor getTextColor() {
        if (OS.GTK3) {
            return this.getContextColor();
        }
        long l = this.fontHandle();
        OS.gtk_widget_realize(l);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_text(OS.gtk_widget_get_style(l), 0, gdkColor);
        return gdkColor;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        long l = OS.gdk_screen_get_default();
        if (l != 0L) {
            int n = OS.gdk_screen_get_monitor_at_window(l, this.paintWindow());
            Monitor[] monitorArray = this.display.getMonitors();
            if (n >= 0 && n < monitorArray.length) {
                return monitorArray[n];
            }
        }
        return this.display.getPrimaryMonitor();
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this._getShell();
    }

    Shell _getShell() {
        return this.parent._getShell();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getTouchEnabled() {
        this.checkWidget();
        return false;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x800) == 0;
    }

    Point getThickness(long l) {
        if (OS.GTK3) {
            int n = 0;
            int n2 = 0;
            GtkBorder gtkBorder = new GtkBorder();
            long l2 = OS.gtk_widget_get_style_context(l);
            if (OS.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                OS.gtk_style_context_get_padding(l2, 0, gtkBorder);
            } else {
                OS.gtk_style_context_get_padding(l2, OS.gtk_widget_get_state_flags(l), gtkBorder);
            }
            OS.gtk_style_context_save(l2);
            OS.gtk_style_context_add_class(l2, OS.GTK_STYLE_CLASS_FRAME);
            n += gtkBorder.left;
            n2 += gtkBorder.top;
            if (OS.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                OS.gtk_style_context_get_border(l2, 0, gtkBorder);
            } else {
                OS.gtk_style_context_get_border(l2, OS.gtk_widget_get_state_flags(l), gtkBorder);
            }
            OS.gtk_style_context_restore(l2);
            return new Point(n += gtkBorder.left, n2 += gtkBorder.top);
        }
        long l3 = OS.gtk_widget_get_style(l);
        return new Point(OS.gtk_style_get_xthickness(l3), OS.gtk_style_get_ythickness(l3));
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        return this.gtk_button_press_event(l, l2, true);
    }

    long gtk_button_press_event(long l, long l2, boolean bl) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        if (gdkEventButton.type == 6) {
            return 0L;
        }
        Shell shell = this._getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        long l3 = 0L;
        if (gdkEventButton.type == 4) {
            boolean bl2 = false;
            this.display.clickCount = 1;
            long l4 = OS.gdk_event_peek();
            if (l4 != 0L) {
                int n = OS.GDK_EVENT_TYPE(l4);
                if (n == 5) {
                    this.display.clickCount = 2;
                }
                if (n == 6) {
                    this.display.clickCount = 3;
                }
                OS.gdk_event_free(l4);
            }
            if (OS.isX11() && (this.state & 0x800000) != 0 && this.hooks(29) && gdkEventButton.button == 1) {
                boolean[] blArray = new boolean[1];
                if (this.dragDetect((int)gdkEventButton.x, (int)gdkEventButton.y, true, true, blArray)) {
                    bl2 = true;
                    if (blArray[0]) {
                        l3 = 1L;
                    }
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (bl && !this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                l3 = 1L;
            }
            if (this.isDisposed()) {
                return 1L;
            }
            if (OS.isX11() && bl2) {
                Point point = DPIUtil.autoScaleDown(new Point((int)gdkEventButton.x, (int)gdkEventButton.y));
                this.sendDragEvent(gdkEventButton.button, gdkEventButton.state, point.x, point.y, false);
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if ((this.state & 0x20) != 0 && gdkEventButton.button == 3 && this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root)) {
                l3 = 1L;
            }
        } else {
            this.display.clickCount = 2;
            long l5 = l3 = this.sendMouseEvent(8, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state) ? 0L : 1L;
            if (this.isDisposed()) {
                return 1L;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this, 3);
        }
        return l3;
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
        return this.sendMouseEvent(4, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state) ? 0L : 1L;
    }

    @Override
    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        int n = OS.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(byArray);
        this.sendIMKeyEvent(1, null, cArray);
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long l, long l2) {
        byte[] byArray = null;
        if (this.toolTipText != null && this.toolTipText.length() != 0) {
            char[] cArray = this.fixMnemonic(this.toolTipText, false);
            byArray = Converter.wcsToMbcs(cArray, true);
        }
        long l3 = this.getShell().handle;
        OS.gtk_widget_set_tooltip_text(l3, byArray);
        if (this.display.currentControl == this) {
            return 0L;
        }
        GdkEventCrossing gdkEventCrossing = new GdkEventCrossing();
        OS.memmove(gdkEventCrossing, l2, (long)GdkEventCrossing.sizeof);
        if (gdkEventCrossing.subwindow != 0L && this.checkSubwindow()) {
            return 0L;
        }
        if (gdkEventCrossing.mode != 0 && gdkEventCrossing.mode != 2) {
            return 0L;
        }
        if ((gdkEventCrossing.state & 0x700) != 0) {
            return 0L;
        }
        if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
            this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
            this.display.currentControl.sendMouseEvent(7, 0, gdkEventCrossing.time, gdkEventCrossing.x_root, gdkEventCrossing.y_root, false, gdkEventCrossing.state);
        }
        if (!this.isDisposed()) {
            this.display.currentControl = this;
            return this.sendMouseEvent(6, 0, gdkEventCrossing.time, gdkEventCrossing.x_root, gdkEventCrossing.y_root, false, gdkEventCrossing.state) ? 0L : 1L;
        }
        return 0L;
    }

    boolean checkSubwindow() {
        return false;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l2, (long)GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                if (l != this.eventHandle() || (this.state & 0x20) != 0) break;
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, l2, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
            case 12: {
                if (!this.isFocusHandle(l)) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                Display display = this.display;
                if (gdkEventFocus.in != 0) {
                    if (display.ignoreFocus) {
                        display.ignoreFocus = false;
                        break;
                    }
                } else {
                    display.ignoreFocus = false;
                    long l3 = OS.gtk_grab_get_current();
                    if (l3 != 0L && OS.G_OBJECT_TYPE(l3) == OS.GTK_TYPE_MENU()) {
                        display.ignoreFocus = true;
                        break;
                    }
                }
                this.sendFocusEvent(gdkEventFocus.in != 0 ? 15 : 16);
                break;
            }
        }
        return 0L;
    }

    @Override
    long gtk_draw(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_cairo_get_clip_rectangle(l2, gdkRectangle);
        Event event = new Event();
        event.count = 1;
        Rectangle rectangle = DPIUtil.autoScaleDown(new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height));
        if ((this.style & 0x8000000) != 0) {
            rectangle.x = DPIUtil.autoScaleDown(this.getClientWidth()) - rectangle.width - rectangle.x;
        }
        event.setBounds(rectangle);
        GCData gCData = new GCData();
        if (OS.GTK_VERSION <= OS.VERSION(3, 9, 0)) {
            gCData.cairo = l2;
        }
        GC gC = event.gc = GC.gtk_new(this, gCData);
        gC.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.drawWidget(gC);
        this.sendEvent(9, event);
        gC.dispose();
        event.gc = null;
        return 0L;
    }

    @Override
    long gtk_expose_event(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        GdkEventExpose gdkEventExpose = new GdkEventExpose();
        OS.memmove(gdkEventExpose, l2, (long)GdkEventExpose.sizeof);
        Event event = new Event();
        event.count = gdkEventExpose.count;
        Rectangle rectangle = new Rectangle(gdkEventExpose.area_x, gdkEventExpose.area_y, gdkEventExpose.area_width, gdkEventExpose.area_height);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.width - event.x;
        }
        GCData gCData = new GCData();
        gCData.damageRgn = gdkEventExpose.region;
        GC gC = event.gc = GC.gtk_new(this, gCData);
        this.drawWidget(gC);
        this.sendEvent(9, event);
        gC.dispose();
        event.gc = null;
        return 0L;
    }

    @Override
    long gtk_focus(long l, long l2) {
        return 1L;
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        if (this.handle != 0L) {
            long l3;
            Control control = this.display.imControl;
            if (control != this && control != null && !control.isDisposed() && (l3 = control.imHandle()) != 0L) {
                OS.gtk_im_context_reset(l3);
            }
            if ((this.hooks(1) || this.hooks(2)) && (l3 = this.imHandle()) != 0L) {
                OS.gtk_im_context_focus_in(l3);
            }
        }
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        long l3;
        if (this.handle != 0L && (this.hooks(1) || this.hooks(2)) && (l3 = this.imHandle()) != 0L) {
            OS.gtk_im_context_focus_out(l3);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        if (!this.hasFocus()) {
            if (this.display.getActiveShell() == null) {
                GdkEventKey gdkEventKey = new GdkEventKey();
                OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
                if (this.filterKey(gdkEventKey.keyval, l2)) {
                    return 1L;
                }
            }
            return 0L;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        if (this.translateMnemonic(gdkEventKey.keyval, gdkEventKey)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.filterKey(gdkEventKey.keyval, l2)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.translateTraversal(gdkEventKey)) {
            return 1L;
        }
        if (this.isDisposed()) {
            return 0L;
        }
        return super.gtk_key_press_event(l, l2);
    }

    @Override
    long gtk_key_release_event(long l, long l2) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long l3 = this.imHandle();
        if (l3 != 0L && OS.gtk_im_context_filter_keypress(l3, l2)) {
            return 1L;
        }
        return super.gtk_key_release_event(l, l2);
    }

    @Override
    long gtk_leave_notify_event(long l, long l2) {
        if (this.display.currentControl != this) {
            return 0L;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        int n = 0;
        if (this.sendLeaveNotify() || this.display.getCursorControl() == null) {
            GdkEventCrossing gdkEventCrossing = new GdkEventCrossing();
            OS.memmove(gdkEventCrossing, l2, (long)GdkEventCrossing.sizeof);
            if (gdkEventCrossing.mode != 0 && gdkEventCrossing.mode != 2) {
                return 0L;
            }
            if ((gdkEventCrossing.state & 0x700) != 0) {
                return 0L;
            }
            n = this.sendMouseEvent(7, 0, gdkEventCrossing.time, gdkEventCrossing.x_root, gdkEventCrossing.y_root, false, gdkEventCrossing.state) ? 0 : 1;
            this.display.currentControl = null;
        }
        return n;
    }

    @Override
    long gtk_mnemonic_activate(long l, long l2) {
        int n = 0;
        long l3 = OS.gtk_get_current_event();
        if (l3 != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l3, (long)GdkEventKey.sizeof);
            if (gdkEventKey.type == 8) {
                long l4;
                Control control = this.display.getFocusControl();
                long l5 = l4 = control != null ? control.focusHandle() : 0L;
                if (l4 != 0L) {
                    this.display.mnemonicControl = this;
                    OS.gtk_widget_event(l4, l3);
                    this.display.mnemonicControl = null;
                }
                n = 1;
            }
            OS.gdk_event_free(l3);
        }
        return n;
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        Object object;
        int n;
        GdkEventMotion gdkEventMotion = new GdkEventMotion();
        OS.memmove(gdkEventMotion, l2, (long)GdkEventMotion.sizeof);
        if (!OS.isX11()) {
            Object object2;
            boolean bl = false;
            if ((this.state & 0x800000) != 0 && this.hooks(29) && this.dragDetect((int)gdkEventMotion.x, (int)gdkEventMotion.y, true, true, (boolean[])(object2 = new boolean[1]))) {
                bl = true;
                if (object2[0]) {
                    n = 1;
                }
                if (this.isDisposed()) {
                    return 1L;
                }
            }
            if (bl) {
                OS.gtk_event_controller_handle_event(this.dragGesture, l2);
                object2 = new GdkEventButton();
                OS.memmove((GdkEventButton)object2, l2, (long)GdkEventButton.sizeof);
                if (object2.type == 6) {
                    return 0L;
                }
                Point point = DPIUtil.autoScaleDown(new Point((int)object2.x, (int)object2.y));
                if (this.sendDragEvent(object2.button, object2.state, point.x, point.y, false)) {
                    return 1L;
                }
            }
        }
        if (this == this.display.currentControl && (this.hooks(32) || this.filters(32))) {
            this.display.addMouseHoverTimeout(this.handle);
        }
        double d = gdkEventMotion.x_root;
        double d2 = gdkEventMotion.y_root;
        int n2 = gdkEventMotion.state;
        if (gdkEventMotion.is_hint != 0) {
            object = new int[1];
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l3 = this.eventWindow();
            this.gdk_window_get_device_position(l3, (int[])object, nArray, nArray2);
            d = object[0];
            d2 = nArray[0];
            n2 = nArray2[0];
        }
        if (OS.GTK3 && this != this.display.currentControl) {
            if (this.display.currentControl != null && !this.display.currentControl.isDisposed()) {
                this.display.removeMouseHoverTimeout(this.display.currentControl.handle);
                object = this.display.mapInPixels(this, this.display.currentControl, (int)d, (int)d2);
                this.display.currentControl.sendMouseEvent(7, 0, gdkEventMotion.time, object.x, object.y, gdkEventMotion.is_hint != 0, n2);
            }
            if (!this.isDisposed()) {
                this.display.currentControl = this;
                this.sendMouseEvent(6, 0, gdkEventMotion.time, d, d2, gdkEventMotion.is_hint != 0, n2);
            }
        }
        n = this.sendMouseEvent(5, 0, gdkEventMotion.time, d, d2, gdkEventMotion.is_hint != 0, n2) ? 0 : 1;
        return n;
    }

    @Override
    long gtk_popup_menu(long l) {
        if (!this.hasFocus()) {
            return 0L;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gdk_window_get_device_position(0L, nArray, nArray2, null);
        return this.showMenu(nArray[0], nArray2[0], 1) ? 1L : 0L;
    }

    @Override
    long gtk_preedit_changed(long l) {
        this.display.showIMWindow(this);
        return 0L;
    }

    @Override
    long gtk_realize(long l) {
        long l2 = this.imHandle();
        if (l2 != 0L) {
            long l3 = this.gtk_widget_get_window(this.paintHandle());
            OS.gtk_im_context_set_client_window(l2, l3);
        }
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    long gtk_scroll_event(long l, long l2) {
        GdkEventScroll gdkEventScroll = new GdkEventScroll();
        OS.memmove(gdkEventScroll, l2, (long)GdkEventScroll.sizeof);
        switch (gdkEventScroll.direction) {
            case 0: {
                return this.sendMouseEvent(37, 0, 3, 1, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0L : 1L;
            }
            case 1: {
                return this.sendMouseEvent(37, 0, -3, 1, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0L : 1L;
            }
            case 2: {
                return this.sendMouseEvent(38, 0, 3, 0, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0L : 1L;
            }
            case 3: {
                return this.sendMouseEvent(38, 0, -3, 0, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0L : 1L;
            }
            case 4: {
                long l3 = 0L;
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                if (OS.gdk_event_get_scroll_deltas(l2, dArray, dArray2)) {
                    if (dArray[0] != 0.0) {
                        l3 = this.sendMouseEvent(38, 0, (int)(-3.0 * dArray[0]), 0, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0 : 1;
                    }
                    if (dArray2[0] != 0.0) {
                        l3 = this.sendMouseEvent(37, 0, (int)(-3.0 * dArray2[0]), 1, true, gdkEventScroll.time, gdkEventScroll.x_root, gdkEventScroll.y_root, false, gdkEventScroll.state) ? 0 : 1;
                    }
                }
                return l3;
            }
        }
        return 0L;
    }

    @Override
    long gtk_show_help(long l, long l2) {
        if (!this.hasFocus()) {
            return 0L;
        }
        return this.sendHelpEvent(l2) ? 1L : 0L;
    }

    @Override
    long gtk_style_set(long l, long l2) {
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
        }
        return 0L;
    }

    @Override
    long gtk_unrealize(long l) {
        long l2 = this.imHandle();
        if (l2 != 0L) {
            OS.gtk_im_context_set_client_window(l2, 0L);
        }
        return 0L;
    }

    void gtk_widget_size_request(long l, GtkRequisition gtkRequisition) {
        this.gtk_widget_get_preferred_size(l, gtkRequisition);
    }

    @Override
    public long internal_new_GC(GCData gCData) {
        long l;
        this.checkWidget();
        long l2 = this.paintWindow();
        if (l2 == 0L) {
            this.error(2);
        }
        if ((l = gCData.cairo) != 0L) {
            Cairo.cairo_reference(l);
        } else {
            l = OS.USE_CAIRO ? OS.gdk_cairo_create(l2) : OS.gdk_gc_new(l2);
        }
        if (l == 0L) {
            this.error(2);
        }
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= this.style & (n | 0x8000000);
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.drawable = l2;
            gCData.device = this.display;
            gCData.foreground = this.getForegroundColor();
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            gCData.background = control.getBackgroundColor();
            gCData.font = this.font != null ? this.font : this.defaultFont();
        }
        return l;
    }

    long imHandle() {
        return 0L;
    }

    @Override
    public void internal_dispose_GC(long l, GCData gCData) {
        this.checkWidget();
        long l2 = l;
        if (OS.USE_CAIRO) {
            Cairo.cairo_destroy(l2);
        } else {
            OS.g_object_unref(l2);
        }
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSizeInPixels();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return true;
            }
        }
        if (((n = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (n & 0x18) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            for (n = 0; n < controlArray.length; ++n) {
                if (controlArray[n] != this) continue;
                return false;
            }
        }
        return ((n = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c) {
        return false;
    }

    boolean mnemonicMatch(char c) {
        return false;
    }

    @Override
    void register() {
        long l;
        super.register();
        if (this.fixedHandle != 0L) {
            this.display.addWidget(this.fixedHandle, this);
        }
        if ((l = this.imHandle()) != 0L) {
            this.display.addWidget(l, this);
        }
    }

    public void requestLayout() {
        this.getShell().layout(new Control[]{this}, 4);
    }

    public void redraw() {
        this.checkWidget();
        this.redraw(false);
    }

    void redraw(boolean bl) {
        if (!OS.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        this.redrawWidget(0, 0, 0, 0, true, bl, false);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        Rectangle rectangle = DPIUtil.autoScaleUp(new Rectangle(n, n2, n3, n4));
        this.redrawInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    void redrawInPixels(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (!OS.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            n = this.getClientWidth() - n3 - n;
        }
        this.redrawWidget(n, n2, n3, n4, false, bl, false);
    }

    void redrawChildren() {
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if (!OS.gtk_widget_get_realized(this.handle)) {
            return;
        }
        long l = this.paintWindow();
        GdkRectangle gdkRectangle = new GdkRectangle();
        if (bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.gdk_window_get_size(l, nArray, nArray2);
            gdkRectangle.width = nArray[0];
            gdkRectangle.height = nArray2[0];
        } else {
            gdkRectangle.x = n;
            gdkRectangle.y = n2;
            gdkRectangle.width = Math.max(0, n3);
            gdkRectangle.height = Math.max(0, n4);
        }
        OS.gdk_window_invalidate_rect(l, gdkRectangle, bl2);
    }

    @Override
    void release(boolean bl) {
        Control control = null;
        Control control2 = null;
        if (bl && this.parent != null) {
            int n;
            Control[] controlArray = this.parent._getChildren();
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (n > 0) {
                control2 = controlArray[n - 1];
            }
            if (n + 1 < controlArray.length) {
                control = controlArray[n + 1];
                control.removeRelation();
            }
            this.removeRelation();
        }
        super.release(bl);
        if (bl && control2 != null && control != null) {
            control2.addRelation(control);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.fixedHandle = 0L;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        this.parent.removeControl(this);
    }

    @Override
    void releaseWidget() {
        boolean bl = this.display.getFocusControl() == this;
        super.releaseWidget();
        if (bl) {
            this.fixFocus(this);
        }
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
        }
        this.display.removeMouseHoverTimeout(this.handle);
        long l = this.imHandle();
        if (l != 0L) {
            OS.gtk_im_context_reset(l);
            OS.gtk_im_context_set_client_window(l, 0L);
        }
        if (this.enableWindow != 0L) {
            OS.gdk_window_set_user_data(this.enableWindow, 0L);
            OS.gdk_window_destroy(this.enableWindow);
            this.enableWindow = 0L;
        }
        this.redrawWindow = 0L;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.toolTipText = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
    }

    void restackWindow(long l, long l2, boolean bl) {
        OS.gdk_window_restack(l, l2, bl);
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4, boolean bl) {
        Event event = new Event();
        event.button = n;
        Rectangle rectangle = new Rectangle(n3, n4, 0, 0);
        event.setBounds(rectangle);
        if ((this.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event.x;
        }
        if (bl) {
            event.stateMask = n2;
        } else {
            this.setInputState(event, n2);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int n) {
        Shell shell = this._getShell();
        Display display = this.display;
        display.focusControl = this;
        display.focusEvent = n;
        this.sendEvent(n);
        display.focusControl = null;
        display.focusEvent = 0;
        if (!shell.isDisposed()) {
            switch (n) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.activeShell) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendGestureEvent(int n, int n2, int n3, int n4, double d) {
        switch (n2) {
            case 8: {
                return this.sendGestureEvent(n, n2, n3, n4, d, 0, 0, 0.0);
            }
            case 32: {
                return this.sendGestureEvent(n, n2, n3, n4, 0.0, 0, 0, d);
            }
            case 2: {
                return this.sendGestureEvent(n, n2, n3, n4, 0.0, 0, 0, d);
            }
            case 4: {
                return this.sendGestureEvent(n, n2, 0, 0, 0.0, 0, 0, 0.0);
            }
        }
        return false;
    }

    boolean sendGestureEvent(int n, int n2, int n3, int n4, double d, double d2) {
        if (n2 == 16) {
            return this.sendGestureEvent(n, n2, n3, n4, 0.0, (int)d, (int)d2, 0.0);
        }
        return false;
    }

    boolean sendGestureEvent(int n, int n2, int n3, int n4, double d, int n5, int n6, double d2) {
        Event event = new Event();
        event.stateMask = n;
        event.detail = n2;
        event.x = n3;
        event.y = n4;
        switch (n2) {
            case 8: {
                event.rotation = d;
                break;
            }
            case 32: {
                event.magnification = d2;
                break;
            }
            case 16: {
                event.xDirection = n5;
                event.yDirection = n6;
                break;
            }
        }
        this.postEvent(48, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendHelpEvent(long l) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return true;
            }
            control = control.parent;
        }
        return false;
    }

    boolean sendLeaveNotify() {
        return false;
    }

    boolean sendMouseEvent(int n, int n2, int n3, double d, double d2, boolean bl, int n4) {
        return this.sendMouseEvent(n, n2, 0, 0, false, n3, d, d2, bl, n4);
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, boolean bl, int n5, double d, double d2, boolean bl2, int n6) {
        Object object;
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        Event event2 = new Event();
        event2.time = n5;
        event2.button = n2;
        event2.detail = n4;
        event2.count = n3;
        if (bl2) {
            object = new Rectangle((int)d, (int)d2, 0, 0);
            event2.setBounds(DPIUtil.autoScaleDown((Rectangle)object));
        } else {
            long l = this.eventWindow();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_window_get_origin(l, nArray, nArray2);
            Rectangle rectangle = new Rectangle((int)d - nArray[0], (int)d2 - nArray2[0], 0, 0);
            event2.setBounds(DPIUtil.autoScaleDown(rectangle));
        }
        if ((this.style & 0x8000000) != 0) {
            event2.x = DPIUtil.autoScaleDown(this.getClientWidth()) - event2.x;
        }
        this.setInputState(event2, n6);
        event2.data = new Boolean(bl);
        if (!OS.isX11()) {
            if (n == 3) {
                this.dragDetectionQueue = new LinkedList();
                this.dragDetectionQueue.add(event2);
                return true;
            }
            if (this.dragDetectionQueue != null) {
                switch (n) {
                    case 5: {
                        if (this.dragDetect(event2.x, event2.y, false, true, null)) {
                            object = this.dragDetectionQueue.getFirst();
                            ((Event)object).data = new Boolean(true);
                            this.dragDetectionQueue = null;
                            this.sendOrPost(3, (Event)object);
                            break;
                        }
                        this.dragDetectionQueue.add(event2);
                        break;
                    }
                    case 4: {
                        boolean bl3 = bl ? true : (Boolean)this.dragDetectionQueue.getFirst().data;
                        this.dragDetectionQueue.forEach(event -> {
                            event.data = new Boolean(bl3);
                        });
                        this.sendOrPost(3, this.dragDetectionQueue.removeFirst());
                        this.dragDetectionQueue.forEach(event -> this.sendOrPost(5, (Event)event));
                        this.dragDetectionQueue = null;
                    }
                }
            }
        }
        return this.sendOrPost(n, event2);
    }

    private boolean sendOrPost(int n, Event event) {
        assert (event.data != null) : "event.data should have been a Boolean, but received null";
        boolean bl = (Boolean)event.data;
        event.data = null;
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        return event.doit;
    }

    void gtk_widget_set_align(long l, int n, int n2) {
        OS.gtk_widget_set_halign(l, n);
        OS.gtk_widget_set_valign(l, n2);
    }

    void gtk_label_set_align(long l, float f, float f2) {
        OS.gtk_label_set_xalign(l, f);
        OS.gtk_label_set_yalign(l, f2);
    }

    void setBackground() {
        if ((this.state & 0x2000) == 0 && this.backgroundImage == null) {
            if ((this.state & 0x8000) != 0) {
                this.setParentBackground();
            } else {
                this.setWidgetBackground();
            }
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this._setBackground(color);
        if (color != null) {
            this.updateBackgroundMode();
        }
    }

    private void _setBackground(Color color) {
        if ((this.state & 0x2000) == 0 && color == null) {
            return;
        }
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            gdkColor = color.handle;
            this.backgroundAlpha = color.getAlpha();
        }
        boolean bl = false;
        if (OS.GTK3) {
            bl = true;
        } else if (gdkColor == null) {
            long l = OS.gtk_widget_get_modifier_style(this.handle);
            bl = (OS.gtk_rc_style_get_color_flags(l, 0) & 2) != 0;
        } else {
            GdkColor gdkColor2 = this.getBackgroundColor();
            boolean bl2 = bl = gdkColor2.pixel != gdkColor.pixel;
        }
        if (bl) {
            this.state = color == null ? (this.state &= 0xFFFFDFFF) : (this.state |= 0x2000);
            this.setBackgroundColor(gdkColor);
            this.redrawChildren();
        }
    }

    void setBackgroundColor(long l, long l2, GdkRGBA gdkRGBA) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            String string;
            String string2 = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? this.display.gtk_widget_class_get_css_name(l2) : this.display.gtk_widget_get_name(l2);
            this.cssBackground = string = string2 + " {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA) + ";}";
            String string3 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
            this.gtk_css_provider_load_from_css(l, string3);
        } else {
            OS.gtk_widget_override_background_color(l2, 0, gdkRGBA);
        }
    }

    void setBackgroundColorGradient(long l, long l2, GdkRGBA gdkRGBA) {
        String string;
        String string2 = "* {\n";
        if (gdkRGBA != null) {
            string = this.display.gtk_rgba_to_css_string(gdkRGBA);
            string2 = string2 + "background-image: -gtk-gradient (linear, 0 0, 0 1, color-stop(0, " + string + "), color-stop(1, " + string + "));\n";
        }
        this.cssBackground = string2 = string2 + "}\n";
        string = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string);
    }

    void gtk_css_provider_load_from_css(long l, String string) {
        if (this.provider == 0L) {
            this.provider = OS.gtk_css_provider_new();
            OS.gtk_style_context_add_provider(l, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        OS.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(string, true), -1L, null);
    }

    void setBackgroundColor(long l, GdkColor gdkColor) {
        if (OS.GTK3) {
            GdkRGBA gdkRGBA = null;
            double d = 1.0;
            if (gdkColor == null) {
                if ((this.state & 0x8000) != 0) {
                    d = 0.0;
                    Control control = this.findBackgroundControl();
                    if (control == null) {
                        control = this;
                    }
                    gdkColor = control.getBackgroundColor();
                }
            } else {
                d = this.backgroundAlpha;
            }
            if (gdkColor != null) {
                gdkRGBA = this.display.toGdkRGBA(gdkColor);
                gdkRGBA.alpha = d / 255.0;
            }
            long l2 = OS.gtk_widget_get_style_context(l);
            this.setBackgroundColor(l2, l, gdkRGBA);
            OS.gtk_style_context_invalidate(l2);
            return;
        }
        int n = 0;
        long l3 = OS.gtk_widget_get_modifier_style(l);
        long l4 = OS.gtk_rc_style_get_bg_pixmap_name(l3, n);
        if (l4 != 0L) {
            OS.g_free(l4);
        }
        l4 = 0L;
        String string = null;
        int n2 = OS.gtk_rc_style_get_color_flags(l3, n);
        if (gdkColor != null) {
            n2 |= 2;
            string = "<none>";
        } else {
            n2 &= 0xFFFFFFFD;
            if (this.backgroundImage == null && (this.state & 0x8000) != 0) {
                string = "<parent>";
            }
        }
        if (string != null) {
            byte[] byArray = Converter.wcsToMbcs(string, true);
            l4 = OS.g_malloc(byArray.length);
            OS.memmove(l4, byArray, (long)byArray.length);
        }
        OS.gtk_rc_style_set_bg_pixmap_name(l3, n, l4);
        OS.gtk_rc_style_set_bg(l3, n, gdkColor);
        OS.gtk_rc_style_set_color_flags(l3, n, n2);
        this.modifyStyle(l, l3);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        this.setBackgroundColor(this.handle, gdkColor);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image == this.backgroundImage && this.backgroundAlpha > 0) {
            return;
        }
        this.backgroundAlpha = 255;
        this.backgroundImage = image;
        if (this.backgroundImage != null) {
            this.setBackgroundPixmap(this.backgroundImage);
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        } else {
            this.setWidgetBackground();
        }
        this.redrawChildren();
    }

    void setBackgroundPixmap(Image image) {
        long l = this.gtk_widget_get_window(this.paintHandle());
        if (l != 0L) {
            if (image.pixmap != 0L) {
                OS.gdk_window_set_back_pixmap(l, image.pixmap, false);
            } else if (image.surface != 0L && OS.GTK3) {
                long l2 = Cairo.cairo_pattern_create_for_surface(image.surface);
                if (l2 == 0L) {
                    SWT.error(2);
                }
                Cairo.cairo_pattern_set_extend(l2, 1);
                OS.gdk_window_set_background_pattern(l, l2);
                Cairo.cairo_pattern_destroy(l2);
            }
        }
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        this.setCursor(cursor != null ? cursor.handle : 0L);
    }

    void setCursor(long l) {
        long l2 = this.eventWindow();
        if (l2 != 0L) {
            OS.gdk_window_set_cursor(l2, l);
            if (!OS.isX11()) {
                OS.gdk_flush();
            } else {
                long l3 = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                OS.XFlush(l3);
            }
        }
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x800000) : (this.state &= 0xFF7FFFFF);
    }

    static long enterNotifyEventProc(long l, long l2, long l3, long l4) {
        long l5;
        long l6;
        long l7 = OS.g_value_peek_pointer(l3);
        long l8 = OS.g_object_get_qdata(l7, GTK_POINTER_WINDOW);
        if (l8 != 0L && (l6 = OS.g_list_data(l5 = OS.g_hash_table_get_values(l8))) == l4) {
            OS.g_object_set_qdata(l6, SWT_GRAB_WIDGET, l7);
        }
        return 1L;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == bl) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        if (bl) {
            if (this.enableWindow != 0L) {
                this.cleanupEnableWindow();
            }
        } else {
            OS.gtk_widget_realize(this.handle);
            long l = this.parent.eventHandle();
            long l2 = this.parent.eventWindow();
            long l3 = this.topHandle();
            GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
            GtkAllocation gtkAllocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(l3, gtkAllocation);
            gdkWindowAttr.x = gtkAllocation.x;
            gdkWindowAttr.y = gtkAllocation.y;
            gdkWindowAttr.width = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
            gdkWindowAttr.height = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
            gdkWindowAttr.event_mask = -32769;
            gdkWindowAttr.wclass = 1;
            gdkWindowAttr.window_type = 2;
            this.enableWindow = OS.gdk_window_new(l2, gdkWindowAttr, 12);
            if (this.enableWindow != 0L) {
                if (enterNotifyEventFunc != null) {
                    this.enterNotifyEventId = OS.g_signal_add_emission_hook(enterNotifyEventSignalId, 0, enterNotifyEventFunc.getAddress(), this.enableWindow, 0L);
                }
                OS.gdk_window_set_user_data(this.enableWindow, l);
                this.restackWindow(this.enableWindow, this.gtk_widget_get_window(l3), true);
                if (OS.gtk_widget_get_visible(l3)) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    void cleanupEnableWindow() {
        if (enterNotifyEventFunc != null) {
            if (this.enterNotifyEventId > 0L) {
                OS.g_signal_remove_emission_hook(enterNotifyEventSignalId, this.enterNotifyEventId);
            }
            this.enterNotifyEventId = 0L;
            long l = OS.g_object_get_qdata(this.enableWindow, SWT_GRAB_WIDGET);
            if (l != 0L) {
                OS.g_object_set_qdata(l, GTK_POINTER_WINDOW, 0L);
                OS.g_object_set_qdata(this.enableWindow, SWT_GRAB_WIDGET, 0L);
            }
        }
        OS.gdk_window_set_user_data(this.enableWindow, 0L);
        OS.gdk_window_destroy(this.enableWindow);
        this.enableWindow = 0L;
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        long l;
        this.checkWidget();
        if ((this.state & 0x4000) == 0 && font == null) {
            return;
        }
        this.font = font;
        if (font == null) {
            l = this.defaultFont().handle;
        } else {
            if (font.isDisposed()) {
                this.error(5);
            }
            l = font.handle;
        }
        this.state = font == null ? (this.state &= 0xFFFFBFFF) : (this.state |= 0x4000);
        this.setFontDescription(l);
    }

    void setFontDescription(long l) {
        this.setFontDescription(this.handle, l);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if ((this.state & 0x1000) == 0 && color == null) {
            return;
        }
        GdkColor gdkColor = null;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            gdkColor = color.handle;
        }
        boolean bl = false;
        if (OS.GTK3) {
            bl = !this.getForeground().equals(color);
        } else if (gdkColor == null) {
            long l = OS.gtk_widget_get_modifier_style(this.handle);
            bl = (OS.gtk_rc_style_get_color_flags(l, 0) & 1) != 0;
        } else {
            GdkColor gdkColor2 = this.getForegroundColor();
            boolean bl2 = bl = gdkColor2.pixel != gdkColor.pixel;
        }
        if (bl) {
            this.state = color == null ? (this.state &= 0xFFFFEFFF) : (this.state |= 0x1000);
            this.setForegroundColor(gdkColor);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        GdkRGBA gdkRGBA = null;
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (gdkColor != null) {
                gdkRGBA = this.display.toGdkRGBA(gdkColor);
            }
            this.setForegroundColor(this.handle, gdkRGBA);
        } else {
            this.setForegroundColor(this.handle, gdkColor);
        }
    }

    void setForegroundColor(long l, GdkRGBA gdkRGBA) {
        String string;
        GdkRGBA gdkRGBA2 = new GdkRGBA();
        if (gdkRGBA != null) {
            gdkRGBA2 = gdkRGBA;
        } else {
            GdkColor gdkColor = this.display.COLOR_WIDGET_FOREGROUND;
            gdkRGBA2 = this.display.toGdkRGBA(gdkColor);
        }
        long l2 = OS.gtk_widget_get_style_context(l);
        String string2 = this.display.gtk_rgba_to_css_string(gdkRGBA2);
        String string3 = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? this.display.gtk_widget_class_get_css_name(l) : this.display.gtk_widget_get_name(l);
        GdkRGBA gdkRGBA3 = this.display.toGdkRGBA(this.getDisplay().COLOR_LIST_SELECTION_TEXT);
        String string4 = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? " selection" : ":selected";
        this.cssForeground = string = "* {color: " + string2 + ";}\n" + string3 + string4 + " {color: " + this.display.gtk_rgba_to_css_string(gdkRGBA3) + ";}";
        String string5 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(l2, string5);
    }

    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            long l = this.topHandle();
            GtkAllocation gtkAllocation = new GtkAllocation();
            gtkAllocation.x = (this.parent.style & 0x8000000) != 0 ? this.parent.getClientWidth() : 0;
            gtkAllocation.y = 0;
            if (OS.GTK3) {
                OS.gtk_widget_set_visible(l, true);
            }
            OS.gtk_widget_set_allocation(l, gtkAllocation);
        } else {
            this.resizeHandle(1, 1);
            this.forceResize();
        }
    }

    private void setDragGesture() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.dragGesture = OS.gtk_gesture_drag_new(this.handle);
            OS.gtk_event_controller_set_propagation_phase(this.dragGesture, 2);
            OS.gtk_gesture_single_set_button(this.dragGesture, 0);
            OS.g_signal_connect(this.dragGesture, OS.begin, gestureBegin.getAddress(), this.handle);
            OS.g_signal_connect(this.dragGesture, OS.end, gestureEnd.getAddress(), this.handle);
            return;
        }
    }

    private void setRotateGesture() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.rotateGesture = OS.gtk_gesture_rotate_new(this.handle);
            OS.gtk_event_controller_set_propagation_phase(this.rotateGesture, 2);
            OS.g_signal_connect(this.rotateGesture, OS.angle_changed, gestureRotation.getAddress(), this.handle);
            OS.g_signal_connect(this.rotateGesture, OS.begin, gestureBegin.getAddress(), this.handle);
            OS.g_signal_connect(this.rotateGesture, OS.end, gestureEnd.getAddress(), this.handle);
            return;
        }
    }

    private void setZoomGesture() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.zoomGesture = OS.gtk_gesture_zoom_new(this.handle);
            OS.gtk_event_controller_set_propagation_phase(this.zoomGesture, 2);
            OS.g_signal_connect(this.zoomGesture, OS.scale_changed, gestureZoom.getAddress(), this.handle);
            OS.g_signal_connect(this.zoomGesture, OS.begin, gestureBegin.getAddress(), this.handle);
            OS.g_signal_connect(this.zoomGesture, OS.end, gestureEnd.getAddress(), this.handle);
            return;
        }
    }

    static Control getControl(long l) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return null;
        }
        return (Control)widget;
    }

    static void rotateProc(long l, double d, double d2, long l2) {
        if (OS.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            OS.gtk_get_current_event_state(nArray);
            OS.gtk_gesture_get_point(l, OS.gtk_gesture_get_last_updated_sequence(l), dArray, dArray2);
            double d3 = -(OS.gtk_gesture_rotate_get_angle_delta(l) * 100.0);
            Control control = Control.getControl(l2);
            control.sendGestureEvent(nArray[0], 8, (int)dArray[0], (int)dArray2[0], d3);
        }
    }

    static void magnifyProc(long l, double d, long l2) {
        if (OS.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            OS.gtk_get_current_event_state(nArray);
            OS.gtk_gesture_get_point(l, OS.gtk_gesture_get_last_updated_sequence(l), dArray, dArray2);
            double d2 = OS.gtk_gesture_zoom_get_scale_delta(l);
            Control control = Control.getControl(l2);
            control.sendGestureEvent(nArray[0], 32, (int)dArray[0], (int)dArray2[0], d2);
        }
    }

    static void swipeProc(long l, double d, double d2, long l2) {
        double[] dArray;
        double[] dArray2;
        if (OS.gtk_gesture_is_recognized(l) && OS.gtk_gesture_swipe_get_velocity(l, dArray2 = new double[1], dArray = new double[1])) {
            int[] nArray = new int[1];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[1];
            OS.gtk_get_current_event_state(nArray);
            OS.gtk_gesture_get_point(l, OS.gtk_gesture_get_last_updated_sequence(l), dArray3, dArray4);
            Control control = Control.getControl(l2);
            control.sendGestureEvent(nArray[0], 16, (int)dArray3[0], (int)dArray4[0], dArray2[0], dArray[0]);
        }
    }

    static void gestureBeginProc(long l, long l2, long l3) {
        if (OS.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            OS.gtk_get_current_event_state(nArray);
            OS.gtk_gesture_get_point(l, l2, dArray, dArray2);
            Control control = Control.getControl(l3);
            control.sendGestureEvent(nArray[0], 2, (int)dArray[0], (int)dArray2[0], 0.0);
        }
    }

    static void gestureEndProc(long l, long l2, long l3) {
        if (OS.gtk_gesture_is_recognized(l)) {
            int[] nArray = new int[1];
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            OS.gtk_get_current_event_state(nArray);
            OS.gtk_gesture_get_point(l, OS.gtk_gesture_get_last_updated_sequence(l), dArray, dArray2);
            Control control = Control.getControl(l3);
            control.sendGestureEvent(nArray[0], 4, (int)dArray[0], (int)dArray2[0], 0.0);
        }
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    @Override
    void setOrientation(boolean bl) {
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                OS.gtk_widget_set_direction(this.handle, n);
            }
            if (this.fixedHandle != 0L) {
                OS.gtk_widget_set_direction(this.fixedHandle, n);
            }
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= ~n2;
        this.style |= n & n2;
        this.setOrientation(false);
        this.style &= 0xF7FFFFFF;
        this.checkMirrored();
    }

    public boolean setParent(Composite composite) {
        int n;
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            this.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        OS.gtk_widget_realize(composite.handle);
        long l = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        if ((composite.style & 0x8000000) != 0) {
            n2 = composite.getClientWidth() - n4 - n2;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        Menu[] menuArray = shell2.findMenus(this);
        if (shell2 != shell || decorations2 != decorations) {
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
            decorations.fixAccelGroup();
            decorations2.fixAccelGroup();
        }
        long l2 = composite.parentingHandle();
        OS.gtk_widget_reparent(l, l2);
        if (OS.GTK3) {
            OS.swt_fixed_move(l2, l, n2, n3);
        } else {
            OS.gtk_fixed_move(l2, l, n2, n3);
        }
        this.resizeHandle(n4, n);
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(l, gtkRequisition);
        gtkAllocation.x = n2;
        gtkAllocation.y = n3;
        gtkAllocation.width = n4;
        gtkAllocation.height = n;
        OS.gtk_widget_size_allocate(l, gtkAllocation);
        this.parent = composite;
        this.setZOrder(null, false, true);
        this.reskin(1);
        return true;
    }

    void setParentBackground() {
        this.setBackgroundColor(this.handle, null);
        if (this.fixedHandle != 0L) {
            this.setBackgroundColor(this.fixedHandle, null);
        }
    }

    void setParentWindow(long l) {
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0 && this.redrawWindow != 0L) {
                long l = this.paintWindow();
                OS.gdk_window_hide(this.redrawWindow);
                OS.gdk_window_destroy(this.redrawWindow);
                OS.gdk_window_set_events(l, OS.gtk_widget_get_events(this.paintHandle()));
                this.redrawWindow = 0L;
            }
        } else if (this.drawCount++ == 0 && OS.gtk_widget_get_realized(this.handle)) {
            long l = this.paintWindow();
            Rectangle rectangle = this.getBoundsInPixels();
            GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
            gdkWindowAttr.width = rectangle.width;
            gdkWindowAttr.height = rectangle.height;
            gdkWindowAttr.event_mask = 2;
            gdkWindowAttr.window_type = 2;
            this.redrawWindow = OS.gdk_window_new(l, gdkWindowAttr, 0);
            if (this.redrawWindow != 0L) {
                int n = 13308;
                OS.gdk_window_set_events(l, OS.gdk_window_get_events(l) & ~n);
                if (OS.GTK3) {
                    OS.gdk_window_set_background_pattern(this.redrawWindow, 0L);
                } else {
                    OS.gdk_window_set_back_pixmap(this.redrawWindow, 0L, false);
                }
                OS.gdk_window_show(this.redrawWindow);
            }
        }
    }

    @Override
    boolean setTabItemFocus(boolean bl) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setTextDirection(int n) {
        this.checkWidget();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.setToolTipText(this._getShell(), string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String string) {
        if (this.display.currentControl == this) {
            shell.setToolTipText(shell.handle, this.eventHandle(), string);
        }
    }

    public void setTouchEnabled(boolean bl) {
        this.checkWidget();
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x800) == 0 == bl) {
            return;
        }
        long l = this.topHandle();
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.state &= 0xFFFFF7FF;
            if ((this.state & 0x600) == 0) {
                if (this.enableWindow != 0L) {
                    OS.gdk_window_show_unraised(this.enableWindow);
                }
                OS.gtk_widget_show(l);
            }
        } else {
            Control control = null;
            boolean bl2 = false;
            if (this.display.focusEvent != 16) {
                control = this.display.getFocusControl();
                bl2 = this.isFocusAncestor(control);
            }
            this.state |= 0x800;
            if (bl2) {
                if (OS.GTK3) {
                    OS.gtk_widget_set_can_focus(l, false);
                } else {
                    this.gtk_widget_set_visible(l, false);
                }
                this.fixFocus(control);
                if (this.isDisposed()) {
                    return;
                }
                if (OS.GTK3) {
                    OS.gtk_widget_set_can_focus(l, true);
                } else {
                    this.gtk_widget_set_visible(l, true);
                }
            }
            OS.gtk_widget_hide(l);
            if (this.isDisposed()) {
                return;
            }
            if (this.enableWindow != 0L) {
                OS.gdk_window_hide(this.enableWindow);
            }
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean bl, boolean bl2) {
        this.setZOrder(control, bl, bl2, true);
    }

    void setZOrder(Control control, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = 0;
        int n3 = -1;
        Control[] controlArray = null;
        if (bl2) {
            controlArray = this.parent._getChildren();
            for (n = 0; n < controlArray.length && controlArray[n] != this; ++n) {
            }
            if (control != null) {
                while (n2 < controlArray.length && controlArray[n2] != control) {
                    ++n2;
                }
            }
            this.removeRelation();
            if (n + 1 < controlArray.length) {
                n3 = n + 1;
                controlArray[n3].removeRelation();
            }
            if (control != null) {
                if (bl) {
                    control.removeRelation();
                } else if (n2 + 1 < controlArray.length) {
                    controlArray[n2 + 1].removeRelation();
                }
            }
        }
        long l = this.topHandle();
        long l2 = control != null ? control.topHandle() : 0L;
        long l3 = this.gtk_widget_get_window(l);
        if (l3 != 0L) {
            long l4;
            long l5 = 0L;
            if (control != null) {
                l5 = bl && control.enableWindow != 0L ? this.enableWindow : OS.gtk_widget_get_window(l2);
            }
            long l6 = l4 = bl3 ? this.parent.redrawWindow : 0L;
            if (!OS.GDK_WINDOWING_X11() || l5 == 0L && (!bl || l4 == 0L)) {
                if (bl) {
                    OS.gdk_window_raise(l3);
                    if (l4 != 0L) {
                        OS.gdk_window_raise(l4);
                    }
                    if (this.enableWindow != 0L) {
                        OS.gdk_window_raise(this.enableWindow);
                    }
                } else {
                    if (this.enableWindow != 0L) {
                        OS.gdk_window_lower(this.enableWindow);
                    }
                    OS.gdk_window_lower(l3);
                }
            } else {
                long l7 = l5 != 0L ? l5 : l4;
                boolean bl4 = bl;
                if (l4 != 0L && l5 == 0L) {
                    bl4 = false;
                }
                this.restackWindow(l3, l7, bl4);
                if (this.enableWindow != 0L) {
                    this.restackWindow(this.enableWindow, l3, true);
                }
            }
        }
        if (bl3) {
            if (bl) {
                this.parent.moveAbove(l, l2);
            } else {
                this.parent.moveBelow(l, l2);
            }
        }
        if (!bl && bl3) {
            this.parent.fixZOrder();
        }
        if (bl2) {
            n = control != null ? (bl ? n2 - (n < n2 ? 1 : 0) : n2 + (n2 < n ? 1 : 0)) : (bl ? 0 : controlArray.length - 1);
            controlArray = this.parent._getChildren();
            if (0 < n) {
                controlArray[n - 1].addRelation(this);
            }
            if (n + 1 < controlArray.length) {
                this.addRelation(controlArray[n + 1]);
            }
            if (n3 != -1) {
                if (n3 <= n) {
                    --n3;
                }
                if (0 < n3 && n3 != n && n3 != n + 1) {
                    controlArray[n3 - 1].addRelation(controlArray[n3]);
                }
            }
        }
    }

    void setWidgetBackground() {
        GdkColor gdkColor;
        GdkColor gdkColor2 = gdkColor = (this.state & 0x2000) != 0 ? this.getBackgroundColor() : null;
        if (this.fixedHandle != 0L) {
            this.setBackgroundColor(this.fixedHandle, gdkColor);
        }
        this.setBackgroundColor(this.handle, gdkColor);
    }

    boolean showMenu(int n, int n2) {
        return this.showMenu(n, n2, 0);
    }

    boolean showMenu(int n, int n2, int n3) {
        Event event = new Event();
        Rectangle rectangle = new Rectangle(n, n2, 0, 0);
        event.setBounds(DPIUtil.autoScaleDown(rectangle));
        event.detail = n3;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return false;
        }
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            boolean bl = this.hooks(1) || this.hooks(2);
            this.menu.createIMMenu(bl ? this.imHandle() : 0L);
            Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
            if (rectangle2.x != n || rectangle2.y != n2) {
                this.menu.setLocationInPixels(rectangle2.x, rectangle2.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void showWidget() {
        this.state |= 0x600;
        long l = this.topHandle();
        long l2 = this.parent.parentingHandle();
        this.parent.setParentWindow(l);
        OS.gtk_container_add(l2, l);
        if (this.handle != 0L && this.handle != l) {
            OS.gtk_widget_show(this.handle);
        }
        if ((this.state & 0x600) == 0 && this.fixedHandle != 0L) {
            OS.gtk_widget_show(this.fixedHandle);
        }
        if (this.fixedHandle != 0L) {
            this.fixStyle(this.fixedHandle);
        }
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (nArray[k] > nArray[k + i]) continue;
                    int n2 = nArray[k];
                    nArray[k] = nArray[k + i];
                    nArray[k + i] = n2;
                }
            }
        }
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    public boolean traverse(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(n, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int n, KeyEvent keyEvent) {
        this.checkWidget();
        if (keyEvent == null) {
            this.error(4);
        }
        return this.traverse(n, keyEvent.character, keyEvent.keyCode, keyEvent.keyLocation, keyEvent.stateMask, keyEvent.doit);
    }

    boolean traverse(int n, char c, int n2, int n3, int n4, boolean bl) {
        if (n == 0) {
            switch (n2) {
                case 27: {
                    n = 2;
                    bl = true;
                    break;
                }
                case 13: {
                    n = 4;
                    bl = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    n = 64;
                    bl = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 9: {
                    n = (n4 & 0x20000) != 0 ? 8 : 16;
                    bl = true;
                    break;
                }
                case 0x1000006: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 512;
                    bl = true;
                    break;
                }
                case 0x1000005: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 256;
                    bl = true;
                    break;
                }
                default: {
                    if (c == '\u0000' || (n4 & 0x50000) != 65536) break;
                    n = 128;
                    bl = true;
                }
            }
        }
        Event event = new Event();
        event.character = c;
        event.detail = n;
        event.doit = bl;
        event.keyCode = n2;
        event.keyLocation = n3;
        event.stateMask = n4;
        Shell shell = this.getShell();
        boolean bl2 = false;
        switch (n) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                bl2 = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl2 && control != null);
        return false;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this == this.display.mnemonicControl || this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(int n, GdkEventKey gdkEventKey) {
        Decorations decorations;
        long l = OS.gdk_keyval_to_unicode(n);
        if (l < 32L) {
            return false;
        }
        if (gdkEventKey.state == 0) {
            int n2 = this.traversalCode(n, gdkEventKey);
            if ((n2 & 0x80) == 0) {
                return false;
            }
        } else {
            Shell shell = this._getShell();
            int n3 = 13;
            if ((gdkEventKey.state & n3) != OS.gtk_window_get_mnemonic_modifier(shell.shellHandle)) {
                return false;
            }
        }
        if ((decorations = this.menuShell()).isVisible() && decorations.isEnabled()) {
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, gdkEventKey)) {
                return this.translateMnemonic(event, null) || decorations.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = 0;
        int n2 = gdkEventKey.keyval;
        int n3 = this.traversalCode(n2, gdkEventKey);
        boolean bl = false;
        switch (n2) {
            case 65307: {
                bl = true;
                n = 2;
                break;
            }
            case 65293: 
            case 65421: {
                bl = true;
                n = 4;
                break;
            }
            case 65056: 
            case 65289: {
                boolean bl2 = (gdkEventKey.state & 1) == 0;
                n = bl2 ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean bl2;
                boolean bl3 = bl2 = n2 == 65364 || n2 == 65363;
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (n2 == 65361 || n2 == 65363)) {
                    bl2 = !bl2;
                }
                n = bl2 ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                bl = true;
                if ((gdkEventKey.state & 4) == 0) {
                    return false;
                }
                n = n2 == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (n3 & n) != 0;
        event.detail = n;
        event.time = gdkEventKey.time;
        if (!this.setKeyState(event, gdkEventKey)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl && control != null);
        return false;
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        int n2 = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            n2 |= 2;
        }
        return n2;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        int n;
        int n2;
        Control control = this.computeTabRoot();
        Widget widget = this.computeTabGroup();
        Widget[] widgetArray = control.computeTabList();
        int n3 = widgetArray.length;
        for (n2 = 0; n2 < n3 && widgetArray[n2] != widget; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Widget widget2 = widgetArray[n2];
            if (widget2.isDisposed() || !widget2.setTabGroupFocus(bl)) continue;
            return true;
        }
        if (widget.isDisposed()) {
            return false;
        }
        return widget.setTabGroupFocus(bl);
    }

    boolean traverseItem(boolean bl) {
        int n;
        int n2;
        Control[] controlArray = this.parent._getChildren();
        int n3 = controlArray.length;
        for (n2 = 0; n2 < n3 && controlArray[n2] != this; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus(bl)) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseMnemonic(char c) {
        return this.mnemonicHit(c);
    }

    public void update() {
        this.checkWidget();
        this.update(false, true);
    }

    void update(boolean bl, boolean bl2) {
        if (!OS.gtk_widget_get_visible(this.topHandle())) {
            return;
        }
        if (!OS.gtk_widget_get_realized(this.handle)) {
            return;
        }
        long l = this.paintWindow();
        if (bl2) {
            this.display.flushExposes(l, bl);
        }
        if (OS.GTK_VERSION < OS.VERSION(3, 16, 0)) {
            OS.gdk_window_process_updates(l, bl);
        }
        OS.gdk_flush();
    }

    void updateBackgroundMode() {
        int n = this.state & 0x8000;
        this.checkBackground();
        if (n != (this.state & 0x8000)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean bl) {
    }

    @Override
    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 19: {
                long l4;
                Object object;
                boolean bl;
                if ((this.state & 0x40) != 0 || !OS.USE_CAIRO) break;
                Control control = this.findBackgroundControl();
                boolean bl2 = bl = control != null && control.backgroundImage != null;
                if (OS.GTK3 && !bl && (this.state & 2) != 0) {
                    object = new GdkRGBA();
                    l4 = OS.gtk_widget_get_style_context(l);
                    if (OS.GTK_VERSION < OS.VERSION(3, 18, 0)) {
                        OS.gtk_style_context_get_background_color(l4, 0, (GdkRGBA)object);
                    } else {
                        OS.gtk_style_context_get_background_color(l4, OS.gtk_widget_get_state_flags(l), (GdkRGBA)object);
                    }
                    boolean bl3 = bl = ((GdkRGBA)object).alpha == 0.0;
                }
                if (!bl) break;
                if (OS.GTK3) {
                    long l5;
                    long l6 = l2;
                    GdkRectangle gdkRectangle = new GdkRectangle();
                    OS.gdk_cairo_get_clip_rectangle(l6, gdkRectangle);
                    if (control == null) {
                        control = this;
                    }
                    if ((l5 = OS.gtk_widget_get_window(l)) != 0L) {
                        this.drawBackground(control, l5, 0L, 0L, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                        break;
                    }
                    this.drawBackground(control, 0L, l6, 0L, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
                    break;
                }
                object = new GdkEventExpose();
                OS.memmove((GdkEventExpose)object, l2, (long)GdkEventExpose.sizeof);
                l4 = this.paintWindow();
                long l7 = ((GdkEventExpose)object).window;
                if (l7 != l4) break;
                this.drawBackground(control, l7, ((GdkEventExpose)object).region, ((GdkEventExpose)object).area_x, ((GdkEventExpose)object).area_y, ((GdkEventExpose)object).area_width, ((GdkEventExpose)object).area_height);
            }
        }
        return super.windowProc(l, l2, l3);
    }

    Point getWindowOrigin() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l = this.eventWindow();
        OS.gdk_window_get_origin(l, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    static {
        gestureZoom = new Callback(Control.class, "magnifyProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Long.TYPE});
        if (gestureZoom.getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureRotation = new Callback(Control.class, "rotateProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureSwipe = new Callback(Control.class, "swipeProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureBegin = new Callback(Control.class, "gestureBeginProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((gestureEnd = new Callback(Control.class, "gestureEndProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE})).getAddress() == 0L) {
            SWT.error(3);
        }
    }
}

