/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkEditableTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTableIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkValueIface;
import org.eclipse.swt.internal.gtk.GInterfaceInfo;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    static final Map<LONG, Accessible> Accessibles = new HashMap<LONG, Accessible>(9);
    static final Map<LONG, LONG> Factories = new HashMap<LONG, LONG>(9);
    static final String SWT_TYPE_PREFIX = "SWTAccessible";
    static final String CHILD_TYPENAME = "Child";
    static final String FACTORY_TYPENAME = "SWTFactory";
    static final int[] actionRoles = new int[]{44, 46, 30, 12, 43, 45, 62, 52, 1027, 1073};
    static final int[] editableTextRoles = new int[]{42, 46, 1054, 15};
    static final int[] hypertextRoles = new int[]{42, 30, 1054};
    static final int[] selectionRoles = new int[]{33, 60, 24, 35};
    static final int[] textRoles = new int[]{46, 30, 41, 42, 23, 1054, 15};
    static final int[] tableRoles = new int[]{24, 35};
    static final int[] valueRoles = new int[]{3, 52, 48};
    static final Callback AtkActionCB_do_action = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_do_action", 2);
    static final Callback AtkActionCB_get_n_actions = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_n_actions", 1);
    static final Callback AtkActionCB_get_description = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_description", 2);
    static final Callback AtkActionCB_get_keybinding = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_keybinding", 2);
    static final Callback AtkActionCB_get_name = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_name", 2);
    static final Callback AtkComponentCB_get_extents = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_extents", 6);
    static final Callback AtkComponentCB_get_position = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_position", 4);
    static final Callback AtkComponentCB_get_size = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_size", 4);
    static final Callback AtkComponentCB_ref_accessible_at_point = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_ref_accessible_at_point", 4);
    static final Callback AtkEditableTextCB_set_run_attributes = AccessibleFactory.newCallback(AccessibleObject.class, "atkEditableText_set_run_attributes", 4);
    static final Callback AtkEditableTextCB_set_text_contents = AccessibleFactory.newCallback(AccessibleObject.class, "atkEditableText_set_text_contents", 2);
    static final Callback AtkEditableTextCB_insert_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkEditableText_insert_text", 4);
    static final Callback AtkEditableTextCB_copy_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkEditableText_copy_text", 3);
    static final Callback AtkEditableTextCB_cut_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkEditableText_cut_text", 3);
    static final Callback AtkEditableTextCB_delete_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkEditableText_delete_text", 3);
    static final Callback AtkEditableTextCB_paste_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkEditableText_paste_text", 2);
    static final Callback AtkHypertextCB_get_link = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_link", 2);
    static final Callback AtkHypertextCB_get_n_links = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_n_links", 1);
    static final Callback AtkHypertextCB_get_link_index = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_link_index", 2);
    static final Callback AtkObjectCB_get_description;
    static final Callback AtkObjectCB_get_index_in_parent;
    static final Callback AtkObjectCB_get_n_children;
    static final Callback AtkObjectCB_get_name;
    static final Callback AtkObjectCB_get_parent;
    static final Callback AtkObjectCB_get_role;
    static final Callback AtkObjectCB_ref_child;
    static final Callback AtkObjectCB_ref_state_set;
    static final Callback AtkObjectCB_get_attributes;
    static final Callback AtkSelectionCB_is_child_selected;
    static final Callback AtkSelectionCB_ref_selection;
    static final Callback AtkTableCB_ref_at;
    static final Callback AtkTableCB_get_index_at;
    static final Callback AtkTableCB_get_column_at_index;
    static final Callback AtkTableCB_get_row_at_index;
    static final Callback AtkTableCB_get_n_columns;
    static final Callback AtkTableCB_get_n_rows;
    static final Callback AtkTableCB_get_column_extent_at;
    static final Callback AtkTableCB_get_row_extent_at;
    static final Callback AtkTableCB_get_summary;
    static final Callback AtkTableCB_get_caption;
    static final Callback AtkTableCB_get_column_description;
    static final Callback AtkTableCB_get_row_description;
    static final Callback AtkTableCB_get_column_header;
    static final Callback AtkTableCB_get_row_header;
    static final Callback AtkTableCB_get_selected_columns;
    static final Callback AtkTableCB_get_selected_rows;
    static final Callback AtkTableCB_is_column_selected;
    static final Callback AtkTableCB_is_row_selected;
    static final Callback AtkTableCB_is_selected;
    static final Callback AtkTableCB_add_column_selection;
    static final Callback AtkTableCB_add_row_selection;
    static final Callback AtkTableCB_remove_column_selection;
    static final Callback AtkTableCB_remove_row_selection;
    static final Callback AtkTextCB_get_character_extents;
    static final Callback AtkTextCB_get_range_extents;
    static final Callback AtkTextCB_get_run_attributes;
    static final Callback AtkTextCB_get_offset_at_point;
    static final Callback AtkTextCB_add_selection;
    static final Callback AtkTextCB_remove_selection;
    static final Callback AtkTextCB_set_selection;
    static final Callback AtkTextCB_get_caret_offset;
    static final Callback AtkTextCB_set_caret_offset;
    static final Callback AtkTextCB_get_n_selections;
    static final Callback AtkTextCB_get_selection;
    static final Callback AtkTextCB_get_text;
    static final Callback AtkTextCB_get_text_after_offset;
    static final Callback AtkTextCB_get_text_at_offset;
    static final Callback AtkTextCB_get_text_before_offset;
    static final Callback AtkTextCB_get_character_at_offset;
    static final Callback AtkTextCB_get_character_count;
    static final Callback AtkTextCB_get_bounded_ranges;
    static final Callback AtkValueCB_get_current_value;
    static final Callback AtkValueCB_get_maximum_value;
    static final Callback AtkValueCB_get_minimum_value;
    static final Callback AtkValueCB_set_current_value;
    static final Callback GObjectClass_finalize;
    static final Callback AtkObjectFactoryCB_create_accessible;
    static final Callback InitActionIfaceCB;
    static final Callback InitComponentIfaceCB;
    static final Callback InitEditableTextIfaceCB;
    static final Callback InitHypertextIfaceCB;
    static final Callback GTypeInfo_base_init_type;
    static final Callback InitSelectionIfaceCB;
    static final Callback InitTableIfaceCB;
    static final Callback InitTextIfaceCB;
    static final Callback InitValueIfaceCB;
    static final Callback GTypeInfo_base_init_factory;
    static final long ActionIfaceDefinition;
    static final long ComponentIfaceDefinition;
    static final long EditableTextIfaceDefinition;
    static final long HypertextIfaceDefinition;
    static final long SelectionIfaceDefinition;
    static final long TableIfaceDefinition;
    static final long TextIfaceDefinition;
    static final long ValueIfaceDefinition;

    AccessibleFactory() {
    }

    private static Callback newCallback(Object object, String string, int n) {
        Callback callback = new Callback(object, string, n);
        if (callback.getAddress() == 0L) {
            SWT.error(3);
        }
        return callback;
    }

    static String getTypeName(long l) {
        long l2 = OS.g_type_name(l);
        int n = OS.strlen(l2);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        return new String(Converter.mbcsToWcs(byArray));
    }

    static long getParentType(long l) {
        LONG lONG = null;
        while (l != 0L && (lONG = Factories.get(new LONG(l))) == null) {
            l = OS.g_type_parent(l);
        }
        if (lONG == null) {
            return 0L;
        }
        return lONG.value;
    }

    static long atkObjectFactory_create_accessible(long l) {
        AccessibleObject accessibleObject;
        Accessible accessible = Accessibles.get(new LONG(l));
        if (accessible == null) {
            long l2 = OS.g_object_new(AccessibleFactory.getParentType(OS.G_OBJECT_TYPE(l)), 0L);
            ATK.atk_object_initialize(l2, l);
            return l2;
        }
        if (accessible.accessibleObject != null) {
            return accessible.accessibleObject.handle;
        }
        long l3 = OS.G_OBJECT_TYPE(l);
        long l4 = AccessibleFactory.getParentType(l3);
        if (l4 == 0L) {
            l4 = ATK.GTK_TYPE_ACCESSIBLE();
        }
        long l5 = AccessibleFactory.getType(AccessibleFactory.getTypeName(l3), accessible, l4, -1);
        accessible.accessibleObject = accessibleObject = new AccessibleObject(l5, l, accessible, false);
        accessible.addRelations();
        return accessibleObject.handle;
    }

    static AccessibleObject createChildAccessible(Accessible accessible, int n) {
        long l = AccessibleFactory.getType(CHILD_TYPENAME, accessible, ATK.GTK_TYPE_ACCESSIBLE(), n);
        return new AccessibleObject(l, 0L, accessible, true);
    }

    static void createAccessible(Accessible accessible) {
        long l = accessible.getControlHandle();
        OS.gtk_widget_get_accessible(l);
    }

    static long getType(String string, Accessible accessible, long l, int n) {
        byte[] byArray;
        long l2;
        int n2;
        int n3;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessible);
        accessibleControlEvent.childID = n;
        List<AccessibleControlListener> list = accessible.accessibleControlListeners;
        int n4 = n3 = list == null ? 0 : list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            AccessibleControlListener accessibleControlListener = list.get(n2);
            accessibleControlListener.getRole(accessibleControlEvent);
        }
        n2 = 0;
        n3 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (accessibleControlEvent.detail != 0) {
            int n10;
            for (n10 = 0; n10 < actionRoles.length; ++n10) {
                if (accessibleControlEvent.detail != actionRoles[n10]) continue;
                n2 = 1;
                break;
            }
            for (n10 = 0; n10 < editableTextRoles.length; ++n10) {
                if (accessibleControlEvent.detail != editableTextRoles[n10]) continue;
                n3 = 1;
                break;
            }
            for (n10 = 0; n10 < hypertextRoles.length; ++n10) {
                if (accessibleControlEvent.detail != hypertextRoles[n10]) continue;
                n5 = 1;
                break;
            }
            for (n10 = 0; n10 < selectionRoles.length; ++n10) {
                if (accessibleControlEvent.detail != selectionRoles[n10]) continue;
                n6 = 1;
                break;
            }
            for (n10 = 0; n10 < tableRoles.length; ++n10) {
                if (accessibleControlEvent.detail != tableRoles[n10]) continue;
                n7 = 1;
                break;
            }
            for (n10 = 0; n10 < textRoles.length; ++n10) {
                if (accessibleControlEvent.detail != textRoles[n10]) continue;
                n8 = 1;
                break;
            }
            for (n10 = 0; n10 < valueRoles.length; ++n10) {
                if (accessibleControlEvent.detail != valueRoles[n10]) continue;
                n9 = 1;
                break;
            }
        } else {
            n9 = 1;
            n8 = 1;
            n7 = 1;
            n6 = 1;
            n5 = 1;
            n3 = 1;
            n2 = 1;
        }
        String string2 = SWT_TYPE_PREFIX + string;
        if (n2 != 0) {
            string2 = string2 + "Action";
        }
        if (n3 != 0) {
            string2 = string2 + "EditableText";
        }
        if (n5 != 0) {
            string2 = string2 + "Hypertext";
        }
        if (n6 != 0) {
            string2 = string2 + "Selection";
        }
        if (n7 != 0) {
            string2 = string2 + "Table";
        }
        if (n8 != 0) {
            string2 = string2 + "Text";
        }
        if (n9 != 0) {
            string2 = string2 + "Value";
        }
        if ((l2 = OS.g_type_from_name(byArray = Converter.wcsToMbcs(string2, true))) == 0L) {
            if (AccessibleObject.DEBUG) {
                AccessibleObject.print("-->New Type=" + string2);
            }
            long l3 = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(l, l3);
            GTypeQuery gTypeQuery = new GTypeQuery();
            OS.memmove(gTypeQuery, l3, (long)GTypeQuery.sizeof);
            OS.g_free(l3);
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.base_init = GTypeInfo_base_init_type.getAddress();
            gTypeInfo.class_size = (short)gTypeQuery.class_size;
            gTypeInfo.instance_size = (short)gTypeQuery.instance_size;
            long l4 = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(l4, gTypeInfo, GTypeInfo.sizeof);
            l2 = OS.g_type_register_static(l, byArray, l4, 0);
            OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_COMPONENT(), ComponentIfaceDefinition);
            if (n2 != 0) {
                OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_ACTION(), ActionIfaceDefinition);
            }
            if (n3 != 0) {
                OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_EDITABLE_TEXT(), EditableTextIfaceDefinition);
            }
            if (n5 != 0) {
                OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_HYPERTEXT(), HypertextIfaceDefinition);
            }
            if (n6 != 0) {
                OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_SELECTION(), SelectionIfaceDefinition);
            }
            if (n7 != 0) {
                OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_TABLE(), TableIfaceDefinition);
            }
            if (n8 != 0) {
                OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_TEXT(), TextIfaceDefinition);
            }
            if (n9 != 0) {
                OS.g_type_add_interface_static(l2, ATK.ATK_TYPE_VALUE(), ValueIfaceDefinition);
            }
        }
        return l2;
    }

    static long gTypeInfo_base_init_factory(long l) {
        AtkObjectFactoryClass atkObjectFactoryClass = new AtkObjectFactoryClass();
        ATK.memmove(atkObjectFactoryClass, l);
        atkObjectFactoryClass.create_accessible = AtkObjectFactoryCB_create_accessible.getAddress();
        ATK.memmove(l, atkObjectFactoryClass);
        return 0L;
    }

    static long gTypeInfo_base_init_type(long l) {
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, l);
        atkObjectClass.get_name = AtkObjectCB_get_name.getAddress();
        atkObjectClass.get_description = AtkObjectCB_get_description.getAddress();
        atkObjectClass.get_n_children = AtkObjectCB_get_n_children.getAddress();
        atkObjectClass.get_role = AtkObjectCB_get_role.getAddress();
        atkObjectClass.get_parent = AtkObjectCB_get_parent.getAddress();
        atkObjectClass.ref_state_set = AtkObjectCB_ref_state_set.getAddress();
        atkObjectClass.get_index_in_parent = AtkObjectCB_get_index_in_parent.getAddress();
        atkObjectClass.ref_child = AtkObjectCB_ref_child.getAddress();
        atkObjectClass.get_attributes = AtkObjectCB_get_attributes.getAddress();
        long l2 = OS.G_OBJECT_CLASS(l);
        GObjectClass gObjectClass = new GObjectClass();
        OS.memmove(gObjectClass, l2);
        gObjectClass.finalize = GObjectClass_finalize.getAddress();
        OS.memmove(l2, gObjectClass);
        ATK.memmove(l, atkObjectClass);
        return 0L;
    }

    static long initActionIfaceCB(long l) {
        AtkActionIface atkActionIface = new AtkActionIface();
        ATK.memmove(atkActionIface, l);
        atkActionIface.do_action = AtkActionCB_do_action.getAddress();
        atkActionIface.get_n_actions = AtkActionCB_get_n_actions.getAddress();
        atkActionIface.get_description = AtkActionCB_get_description.getAddress();
        atkActionIface.get_keybinding = AtkActionCB_get_keybinding.getAddress();
        atkActionIface.get_name = AtkActionCB_get_name.getAddress();
        ATK.memmove(l, atkActionIface);
        return 0L;
    }

    static long initComponentIfaceCB(long l) {
        AtkComponentIface atkComponentIface = new AtkComponentIface();
        ATK.memmove(atkComponentIface, l);
        atkComponentIface.get_extents = AtkComponentCB_get_extents.getAddress();
        atkComponentIface.get_position = AtkComponentCB_get_position.getAddress();
        atkComponentIface.get_size = AtkComponentCB_get_size.getAddress();
        atkComponentIface.ref_accessible_at_point = AtkComponentCB_ref_accessible_at_point.getAddress();
        ATK.memmove(l, atkComponentIface);
        return 0L;
    }

    static long initEditableTextIfaceCB(long l) {
        AtkEditableTextIface atkEditableTextIface = new AtkEditableTextIface();
        ATK.memmove(atkEditableTextIface, l);
        atkEditableTextIface.set_run_attributes = AtkEditableTextCB_set_run_attributes.getAddress();
        atkEditableTextIface.set_text_contents = AtkEditableTextCB_set_text_contents.getAddress();
        atkEditableTextIface.insert_text = AtkEditableTextCB_insert_text.getAddress();
        atkEditableTextIface.copy_text = AtkEditableTextCB_copy_text.getAddress();
        atkEditableTextIface.cut_text = AtkEditableTextCB_cut_text.getAddress();
        atkEditableTextIface.delete_text = AtkEditableTextCB_delete_text.getAddress();
        atkEditableTextIface.paste_text = AtkEditableTextCB_paste_text.getAddress();
        ATK.memmove(l, atkEditableTextIface);
        return 0L;
    }

    static long initHypertextIfaceCB(long l) {
        AtkHypertextIface atkHypertextIface = new AtkHypertextIface();
        ATK.memmove(atkHypertextIface, l);
        atkHypertextIface.get_link = AtkHypertextCB_get_link.getAddress();
        atkHypertextIface.get_link_index = AtkHypertextCB_get_link_index.getAddress();
        atkHypertextIface.get_n_links = AtkHypertextCB_get_n_links.getAddress();
        ATK.memmove(l, atkHypertextIface);
        return 0L;
    }

    static long initSelectionIfaceCB(long l) {
        AtkSelectionIface atkSelectionIface = new AtkSelectionIface();
        ATK.memmove(atkSelectionIface, l);
        atkSelectionIface.is_child_selected = AtkSelectionCB_is_child_selected.getAddress();
        atkSelectionIface.ref_selection = AtkSelectionCB_ref_selection.getAddress();
        ATK.memmove(l, atkSelectionIface);
        return 0L;
    }

    static long initTableIfaceCB(long l) {
        AtkTableIface atkTableIface = new AtkTableIface();
        ATK.memmove(atkTableIface, l);
        atkTableIface.ref_at = AtkTableCB_ref_at.getAddress();
        atkTableIface.get_index_at = AtkTableCB_get_index_at.getAddress();
        atkTableIface.get_column_at_index = AtkTableCB_get_column_at_index.getAddress();
        atkTableIface.get_row_at_index = AtkTableCB_get_row_at_index.getAddress();
        atkTableIface.get_n_columns = AtkTableCB_get_n_columns.getAddress();
        atkTableIface.get_n_rows = AtkTableCB_get_n_rows.getAddress();
        atkTableIface.get_column_extent_at = AtkTableCB_get_column_extent_at.getAddress();
        atkTableIface.get_row_extent_at = AtkTableCB_get_row_extent_at.getAddress();
        atkTableIface.get_caption = AtkTableCB_get_caption.getAddress();
        atkTableIface.get_summary = AtkTableCB_get_summary.getAddress();
        atkTableIface.get_column_description = AtkTableCB_get_column_description.getAddress();
        atkTableIface.get_row_description = AtkTableCB_get_row_description.getAddress();
        atkTableIface.get_column_header = AtkTableCB_get_column_header.getAddress();
        atkTableIface.get_row_header = AtkTableCB_get_row_header.getAddress();
        atkTableIface.get_selected_columns = AtkTableCB_get_selected_columns.getAddress();
        atkTableIface.get_selected_rows = AtkTableCB_get_selected_rows.getAddress();
        atkTableIface.is_column_selected = AtkTableCB_is_column_selected.getAddress();
        atkTableIface.is_row_selected = AtkTableCB_is_row_selected.getAddress();
        atkTableIface.is_selected = AtkTableCB_is_selected.getAddress();
        atkTableIface.add_column_selection = AtkTableCB_add_column_selection.getAddress();
        atkTableIface.add_row_selection = AtkTableCB_add_row_selection.getAddress();
        atkTableIface.remove_column_selection = AtkTableCB_remove_column_selection.getAddress();
        atkTableIface.remove_row_selection = AtkTableCB_remove_row_selection.getAddress();
        ATK.memmove(l, atkTableIface);
        return 0L;
    }

    static long initTextIfaceCB(long l) {
        AtkTextIface atkTextIface = new AtkTextIface();
        ATK.memmove(atkTextIface, l);
        atkTextIface.get_range_extents = AtkTextCB_get_range_extents.getAddress();
        atkTextIface.get_character_extents = AtkTextCB_get_character_extents.getAddress();
        atkTextIface.get_run_attributes = AtkTextCB_get_run_attributes.getAddress();
        atkTextIface.get_offset_at_point = AtkTextCB_get_offset_at_point.getAddress();
        atkTextIface.add_selection = AtkTextCB_add_selection.getAddress();
        atkTextIface.remove_selection = AtkTextCB_remove_selection.getAddress();
        atkTextIface.set_selection = AtkTextCB_set_selection.getAddress();
        atkTextIface.get_caret_offset = AtkTextCB_get_caret_offset.getAddress();
        atkTextIface.set_caret_offset = AtkTextCB_set_caret_offset.getAddress();
        atkTextIface.get_character_at_offset = AtkTextCB_get_character_at_offset.getAddress();
        atkTextIface.get_character_count = AtkTextCB_get_character_count.getAddress();
        atkTextIface.get_n_selections = AtkTextCB_get_n_selections.getAddress();
        atkTextIface.get_selection = AtkTextCB_get_selection.getAddress();
        atkTextIface.get_text = AtkTextCB_get_text.getAddress();
        atkTextIface.get_text_after_offset = AtkTextCB_get_text_after_offset.getAddress();
        atkTextIface.get_text_at_offset = AtkTextCB_get_text_at_offset.getAddress();
        atkTextIface.get_text_before_offset = AtkTextCB_get_text_before_offset.getAddress();
        atkTextIface.get_bounded_ranges = AtkTextCB_get_bounded_ranges.getAddress();
        ATK.memmove(l, atkTextIface);
        return 0L;
    }

    static long initValueIfaceCB(long l) {
        AtkValueIface atkValueIface = new AtkValueIface();
        ATK.memmove(atkValueIface, l);
        atkValueIface.get_current_value = AtkValueCB_get_current_value.getAddress();
        atkValueIface.get_maximum_value = AtkValueCB_get_maximum_value.getAddress();
        atkValueIface.get_minimum_value = AtkValueCB_get_minimum_value.getAddress();
        atkValueIface.set_current_value = AtkValueCB_set_current_value.getAddress();
        ATK.memmove(l, atkValueIface);
        return 0L;
    }

    static void registerAccessible(Accessible accessible) {
        long l = accessible.getControlHandle();
        long l2 = OS.G_OBJECT_TYPE(l);
        long l3 = ATK.atk_get_default_registry();
        long l4 = ATK.atk_registry_get_factory(l3, l2);
        if (ATK.ATK_IS_NO_OP_OBJECT_FACTORY(l4)) {
            return;
        }
        String string = FACTORY_TYPENAME + AccessibleFactory.getTypeName(l2);
        byte[] byArray = Converter.wcsToMbcs(string, true);
        if (OS.g_type_from_name(byArray) == 0L) {
            if (AccessibleObject.DEBUG) {
                AccessibleObject.print("-->New Factory=" + string);
            }
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.base_init = GTypeInfo_base_init_factory.getAddress();
            gTypeInfo.class_size = (short)ATK.AtkObjectFactoryClass_sizeof();
            gTypeInfo.instance_size = (short)ATK.AtkObjectFactory_sizeof();
            long l5 = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(l5, gTypeInfo, GTypeInfo.sizeof);
            long l6 = OS.g_type_register_static(ATK.ATK_TYPE_OBJECT_FACTORY(), byArray, l5, 0);
            long l7 = ATK.atk_object_factory_get_accessible_type(l4);
            ATK.atk_registry_set_factory_type(l3, l2, l6);
            Factories.put(new LONG(l2), new LONG(l7));
        }
        if (AccessibleObject.DEBUG) {
            AccessibleObject.print("-->Register=" + accessible.control + " " + l);
        }
        Accessibles.put(new LONG(l), accessible);
    }

    static void unregisterAccessible(Accessible accessible) {
        long l = accessible.getControlHandle();
        Accessibles.remove(new LONG(l));
        if (AccessibleObject.DEBUG) {
            AccessibleObject.print("-->Deregister=" + accessible.control + " " + l);
        }
    }

    static {
        AtkObjectCB_get_name = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_name", 1);
        AtkObjectCB_get_description = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_description", 1);
        AtkObjectCB_get_n_children = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_n_children", 1);
        AtkObjectCB_get_role = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_role", 1);
        AtkObjectCB_get_parent = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_parent", 1);
        AtkObjectCB_ref_state_set = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_ref_state_set", 1);
        AtkObjectCB_get_index_in_parent = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_index_in_parent", 1);
        AtkObjectCB_ref_child = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_ref_child", 2);
        AtkObjectCB_get_attributes = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_attributes", 1);
        AtkSelectionCB_is_child_selected = AccessibleFactory.newCallback(AccessibleObject.class, "atkSelection_is_child_selected", 2);
        AtkSelectionCB_ref_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkSelection_ref_selection", 2);
        AtkTableCB_ref_at = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_ref_at", 3);
        AtkTableCB_get_index_at = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_index_at", 3);
        AtkTableCB_get_column_at_index = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_column_at_index", 2);
        AtkTableCB_get_row_at_index = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_row_at_index", 2);
        AtkTableCB_get_n_columns = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_n_columns", 1);
        AtkTableCB_get_n_rows = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_n_rows", 1);
        AtkTableCB_get_column_extent_at = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_column_extent_at", 3);
        AtkTableCB_get_row_extent_at = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_row_extent_at", 3);
        AtkTableCB_get_caption = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_caption", 1);
        AtkTableCB_get_summary = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_summary", 1);
        AtkTableCB_get_column_description = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_column_description", 2);
        AtkTableCB_get_row_description = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_row_description", 2);
        AtkTableCB_get_column_header = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_column_header", 2);
        AtkTableCB_get_row_header = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_row_header", 2);
        AtkTableCB_get_selected_columns = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_selected_columns", 2);
        AtkTableCB_get_selected_rows = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_get_selected_rows", 2);
        AtkTableCB_is_column_selected = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_is_column_selected", 2);
        AtkTableCB_is_row_selected = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_is_row_selected", 2);
        AtkTableCB_is_selected = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_is_selected", 3);
        AtkTableCB_add_column_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_add_column_selection", 2);
        AtkTableCB_add_row_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_add_row_selection", 2);
        AtkTableCB_remove_column_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_remove_column_selection", 2);
        AtkTableCB_remove_row_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkTable_remove_row_selection", 2);
        AtkTextCB_get_character_extents = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_character_extents", 7);
        AtkTextCB_get_range_extents = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_range_extents", 5);
        AtkTextCB_get_run_attributes = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_run_attributes", 4);
        AtkTextCB_get_offset_at_point = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_offset_at_point", 4);
        AtkTextCB_add_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_add_selection", 3);
        AtkTextCB_remove_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_remove_selection", 2);
        AtkTextCB_set_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_set_selection", 4);
        AtkTextCB_get_caret_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_caret_offset", 1);
        AtkTextCB_set_caret_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_set_caret_offset", 2);
        AtkTextCB_get_n_selections = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_n_selections", 1);
        AtkTextCB_get_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_selection", 4);
        AtkTextCB_get_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text", 3);
        AtkTextCB_get_text_after_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_after_offset", 5);
        AtkTextCB_get_text_at_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_at_offset", 5);
        AtkTextCB_get_text_before_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_before_offset", 5);
        AtkTextCB_get_character_at_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_character_at_offset", 2);
        AtkTextCB_get_character_count = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_character_count", 1);
        AtkTextCB_get_bounded_ranges = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_bounded_ranges", 5);
        AtkValueCB_get_current_value = AccessibleFactory.newCallback(AccessibleObject.class, "atkValue_get_current_value", 2);
        AtkValueCB_get_maximum_value = AccessibleFactory.newCallback(AccessibleObject.class, "atkValue_get_maximum_value", 2);
        AtkValueCB_get_minimum_value = AccessibleFactory.newCallback(AccessibleObject.class, "atkValue_get_minimum_value", 2);
        AtkValueCB_set_current_value = AccessibleFactory.newCallback(AccessibleObject.class, "atkValue_set_current_value", 2);
        GObjectClass_finalize = AccessibleFactory.newCallback(AccessibleObject.class, "gObjectClass_finalize", 1);
        GTypeInfo_base_init_type = AccessibleFactory.newCallback(AccessibleFactory.class, "gTypeInfo_base_init_type", 1);
        GTypeInfo_base_init_factory = AccessibleFactory.newCallback(AccessibleFactory.class, "gTypeInfo_base_init_factory", 1);
        AtkObjectFactoryCB_create_accessible = AccessibleFactory.newCallback(AccessibleFactory.class, "atkObjectFactory_create_accessible", 1);
        InitActionIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initActionIfaceCB", 1);
        GInterfaceInfo gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitActionIfaceCB.getAddress();
        ActionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ActionIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitComponentIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initComponentIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitComponentIfaceCB.getAddress();
        ComponentIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ComponentIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitEditableTextIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initEditableTextIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitEditableTextIfaceCB.getAddress();
        EditableTextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(EditableTextIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitHypertextIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initHypertextIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitHypertextIfaceCB.getAddress();
        HypertextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(HypertextIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitSelectionIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initSelectionIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitSelectionIfaceCB.getAddress();
        SelectionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(SelectionIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitTableIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initTableIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitTableIfaceCB.getAddress();
        TableIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TableIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitTextIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initTextIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitTextIfaceCB.getAddress();
        TextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TextIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
        InitValueIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initValueIfaceCB", 1);
        gInterfaceInfo = new GInterfaceInfo();
        gInterfaceInfo.interface_init = InitValueIfaceCB.getAddress();
        ValueIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ValueIfaceDefinition, gInterfaceInfo, GInterfaceInfo.sizeof);
    }
}

