/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static final String RUN_AWT_INVOKE_LATER_KEY = "org.eclipse.swt.internal.runAWTInvokeLater";
    static final String JDK16_FRAME = "apple.awt.CEmbeddedFrame";
    static final String JDK17_FRAME = "sun.lwawt.macosx.CViewEmbeddedFrame";
    static boolean loaded;
    static boolean swingInitialized;

    static final native long getAWTHandle(Canvas var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite composite) {
        Object object;
        Frame[] frameArray;
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        final long l = composite.view.id;
        final Class[] classArray = new Class[1];
        try {
            Object object2 = frameArray = embeddedFrameClass != null ? embeddedFrameClass : JDK16_FRAME;
            classArray[0] = embeddedFrameClass == null ? Class.forName((String)frameArray, true, ClassLoader.getSystemClassLoader()) : Class.forName((String)frameArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                classArray[0] = Class.forName(JDK17_FRAME);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                SWT.error(20, classNotFoundException2);
            }
        }
        catch (Throwable throwable) {
            SWT.error(1, throwable, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        frameArray = new Frame[1];
        final Throwable[] throwableArray = new Throwable[1];
        Runnable runnable = new Runnable(){
            boolean run;

            @Override
            public void run() {
                if (this.run) {
                    return;
                }
                this.run = true;
                Constructor constructor = null;
                try {
                    constructor = classArray[0].getConstructor(Long.TYPE);
                    frameArray[0] = (Frame)constructor.newInstance(new Long(l));
                    frameArray[0].addNotify();
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
            }
        };
        if (EventQueue.isDispatchThread() || composite.getDisplay().getSyncThread() != null) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
            object = composite.getDisplay();
            while (frameArray[0] == null && throwableArray[0] == null) {
                ((Display)object).setData(RUN_AWT_INVOKE_LATER_KEY, new Boolean(true));
                Boolean bl = (Boolean)((Display)object).getData(RUN_AWT_INVOKE_LATER_KEY);
                if (bl == null || bl.booleanValue()) continue;
                runnable.run();
            }
        }
        if (throwableArray[0] != null) {
            SWT.error(20, throwableArray[0]);
        }
        object = frameArray[0];
        final boolean bl = JDK17_FRAME.equals(object.getClass().getName());
        composite.setData(EMBEDDED_FRAME_KEY, object);
        final Listener listener = new Listener((Frame)object){
            final /* synthetic */ Frame val$frame;
            {
                this.val$frame = frame;
            }

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                val$frame.dispatchEvent(new WindowEvent(val$frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                val$frame.dispatchEvent(new WindowEvent(val$frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = composite.getShell();
        shell.addListener(20, listener);
        shell.addListener(19, listener);
        Display display = composite.getDisplay();
        display.addListener(12, new Listener((Frame)object, display){
            final /* synthetic */ Frame val$frame;
            final /* synthetic */ Display val$display;
            {
                this.val$frame = frame;
                this.val$display = display;
            }

            @Override
            public void handleEvent(Event event) {
                while (this.val$frame.isDisplayable() && !this.val$display.isDisposed()) {
                    if (this.val$display.readAndDispatch()) continue;
                    this.val$display.sleep();
                }
                if (!this.val$display.isDisposed()) {
                    this.val$display.removeListener(12, this);
                }
            }
        });
        Listener listener2 = new Listener((Frame)object){
            final /* synthetic */ Frame val$frame;
            {
                this.val$frame = frame;
            }

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Shell shell = composite.getShell();
                        shell.removeListener(20, listener);
                        shell.removeListener(19, listener);
                        if (bl) {
                            shell.removeListener(26, this);
                            shell.removeListener(27, this);
                        }
                        composite.setVisible(false);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    val$frame.dispose();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 26: {
                        if (!composite.isFocusControl()) {
                            return;
                        }
                    }
                    case 15: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)val$frame, Boolean.TRUE);
                                    }
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        });
                        break;
                    }
                    case 16: 
                    case 27: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)val$frame, Boolean.FALSE);
                                    }
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }
        };
        composite.addListener(15, listener2);
        if (bl) {
            composite.addListener(16, listener2);
            shell.addListener(26, listener2);
            shell.addListener(27, listener2);
        } else {
            composite.addListener(27, listener2);
        }
        composite.addListener(12, listener2);
        display.asyncExec(new Runnable((Frame)object){
            final /* synthetic */ Frame val$frame;
            {
                this.val$frame = frame;
            }

            @Override
            public void run() {
                if (composite.isDisposed()) {
                    return;
                }
                final Rectangle rectangle = composite.getClientArea();
                if (bl) {
                    try {
                        Method method = this.val$frame.getClass().getMethod("validateWithBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                        if (method != null) {
                            method.invoke((Object)this.val$frame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            val$frame.setSize(rectangle.width, rectangle.height);
                            val$frame.validate();
                            val$frame.setVisible(false);
                            val$frame.setVisible(true);
                        }
                    });
                }
            }
        });
        return object;
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.cocoa_new(display, l);
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (shell.isDisposed()) {
                            return;
                        }
                        Dimension dimension = canvas.getSize();
                        shell.setSize(dimension.width, dimension.height);
                    }
                });
            }
        };
        canvas.addComponentListener(componentAdapter);
        shell.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                canvas.removeComponentListener(componentAdapter);
            }
        });
        shell.setVisible(true);
        return shell;
    }

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
        System.setProperty("apple.awt.usingSWT", "true");
    }
}

