## What is Open Template Hub?

---

Open Template Hub is an Open Source First Organization that aims minimizing the effort while building a new software business.

### What does Open Template Hub provides to community?

We, as Open Template Hub contributors, keep developing new functionalities and capabilities every week. You can create your microservices or create your mobile and web applications which are integrated with those microservices, that means you can create your own business ground up through Open Template Hub extremely fast.

Let's assume you have a new software business idea. Once you start implementation, you will need several common capabilities like authentication, payment, file storage, analytics, business logic and in the end, you will need a web and mobile applications which are integrated with those capabilities, each and every time you have a new idea. Open Template Hub gives you that power to create and make them alive just in a couple of minutes!

### You can create your microservices using Server Generator

Server Generator provides you the capability to generate many types of microservices with just one command.

These are the service types you are able to generate for now:

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/server/auth-server-logo.min.png" alt="auth-server-template" width="80"/>

### Auth Server

Auth Server Template is a generic open source authentication server that has simple yet powerful design to connect your business with all OAuth 2.0 and OAuth supporting third party companies (like Google, Facebook, Twitter or LinkedIn). It also supports basic username password authentication system.

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/server/payment-server-logo.min.png" alt="payment-server-template" width="80"/>

### Payment Server

Payment Server Template is a generic open source payment server that has simple yet powerful design to connect your business with third party payment solution provider companies (like Stripe or Coinbase).

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/server/file-storage-server-logo.min.png" alt="file-storage-server-template" width="80"/>

### File Storage Server

File Storage Server Template is a generic open source file storage server that has simple yet powerful design to connect your business with third party file storage provider companies (like AWS S3).

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/server/mail-server-logo.min.png" alt="mail-server-template" width="80"/>

### Mail Server

Mail Server Template is a generic open source mail server that has simple yet powerful design to connect your business with third party email service providers (like Gmail, Yahoo or Outlook).

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/server/analytics-server-logo.min.png" alt="analytics-server-template" width="80"/>

### Analytics Server

Analytics Server Template is a generic open source analytics server that has simple yet powerful design to connect your business with third party analytics service providers (like Google Analytics or Matomo).

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/server/business-logic-server-logo.min.png" alt="business-logic-server-template" width="80"/>

### Business Logic Server

Business Logic Server Template is a generic open source server that encodes the real-world business rules that determine how data can be created, stored, and changed. It saves you from rewriting boilerplate code. It works best with other Open Template Hub products.

You can easily generate these servers, and deploy wherever you want; Heroku, GCP, Azure, AWS and so on. If you prefer our paid plans you can also have prepared GitHub Actions for many CI/CD ops once you deploy your repository to GitHub, Postman test suites and attached to automated runs on GitHub Actions as well, stress tests and a lot of DevOps stuff are covered in these templates.

### You can create your user interfaces using UI Generator

Application Generator provides you the capability to generate many types of applications with just one command.

These are the application types you are able to generate for now:

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/ui/web-ui-logo.min.png" alt="company-profile-ui-template" width="80"/>

### Company Profile UI

Company Profile UI Template is modern, responsive and customisable company profile ui template for your business. It contains reusable components, theme color and design support along with dark theme support.

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/ui/web-ui-logo.min.png" alt="web-ui-template" width="80"/>

### Web UI

Web UI Template is modern, responsive and customisable web ui template for your business. It contains reusable components, theme color and design support along with dark theme support.

<img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/min/logo/ui/mobile-ui-logo.min.png" alt="mobile-ui-template" width="80"/>

### Mobile UI

Mobile UI Template is modern, responsive and customisable mobile ui template for your business. It contains reusable components, theme color and design support along with dark theme support.

You will have lots of components, screens and API calls are covered for authentication, payment, file storage, analytics, basic user profiles and controllers integrated with services endpoints.

### So, what's next?

We have so many plans to keep enhancing our functionalities, services and increasing external provider support. Implementing stream server for meetings and chat supporting significant providers like Zoom and Google, implementing MQ flow for all our servers, more components for user interfaces with enhancing UX, automated CI flows for builds and tests, automated deployment scripts using Terraform/Terragrunt or using some other proper tech to decrease build time of your business from minutes to second.

### Last Words..

We have thousands of downloads / usages for our generators, packages, libraries and templates. However, we still do not have any external contribution to our repositories. We believe we are doing a GOOD job here, but if we want to have a GREAT job, then everyone knows that it needs the community. Please feel free to use our code and show support however you want if you like it.

Thank you so much for all of your support.

If you have any question about Open Template Hub, please ask without hesitation: [info@opentemplatehub.com](mailto:info@opentemplatehub.com)
