import { BRAND } from '../brand/brand.data';

export const NAVIGATIONS = {

  // Landing layout
  root: {
    url: '',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  notFound: {
    url: 'not-found',
    title: 'Not Found - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.notFound.description:: Not Found`,
    keywords: [ BRAND.name, 'oth', 'not found' ],
  },
  maintenance: {
    url: 'maintenance',
    title: 'Maintenance - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.maintenance.description:: Maintanence`,
    keywords: [ BRAND.name, 'oth', 'maintanence' ],
  },
  signupSuccess: {
    url: 'signup-success',
    title: 'Sign Up Success - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.signupSuccess.description:: Sign Up Success`,
    keywords: [ BRAND.name, 'oth', 'Sign Up Success' ],
  },
  verifyAccount: {
    url: 'verify-account',
    title: 'Verify Account - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.verifyAccount.description:: Verify Account`,
    keywords: [ BRAND.name, 'oth', 'Verify Account' ],
  },
  cookiePolicy: {
    url: 'cookie-policy',
    title: 'Cookie Policy - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.cookiePolicy.description:: Cookie Policy`,
    keywords: [ BRAND.name, 'oth', 'Cookie Policy' ],
  },
  privacyPolicy: {
    url: 'privacy-policy',
    title: 'Privacy Policy - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.privacyPolicy.description:: Privacy Policy`,
    keywords: [ BRAND.name, 'oth', 'Privacy Policy' ],
  },
  terms: {
    url: 'terms',
    title: 'Terms - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.terms.description:: Terms and Services`,
    keywords: [ BRAND.name, 'oth', 'Terms and Services' ],
  },
  pricing: {
    url: 'pricing',
    title: 'Pricing - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.pricing.description:: Pricing`,
    keywords: [ BRAND.name, 'oth', 'Pricing' ],
  },
  product: {
    url: 'product',
    title: 'Product - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.product.description:: Product`,
    keywords: [ BRAND.name, 'oth', 'Product' ],
  },
  about: {
    url: 'about',
    title: 'About - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.about.description:: About Us`,
    keywords: [ BRAND.name, 'oth', 'About Us' ],
  },
  signup: {
    url: 'signup',
    title: 'Sign Up - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.signup.description:: Sign Up`,
    keywords: [ BRAND.name, 'oth', 'Sign Up' ],
  },
  login: {
    url: 'login',
    title: 'Login - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.login.description:: Login`,
    keywords: [ BRAND.name, 'oth', 'Login' ],
  },
  twoFactorVerification: {
    url: 'two-factor-authentication',
    titlw: 'Two Factor Verification - ' + BRAND.name,
    description: BRAND.name + 'Two Factor Verification',
    keywords: [ BRAND.name, 'oth', 'Two Factor Authentication' ]
  },
  branding: {
    url: 'branding',
    title: 'Branding - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.branding.description:: Branding`,
    keywords: [ BRAND.name, 'oth', 'Branding' ],
  },
  blog: {
    url: 'blog',
    title: 'Blog - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.blog.description:: Blog`,
    keywords: [ BRAND.name, 'oth', 'Blog' ],
  },
  docs: {
    url: 'docs',
    title: 'Docs - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.docs.description:: Docs`,
    keywords: [ BRAND.name, 'oth', 'Docs' ],
  },
  partners: {
    url: 'partners',
    title: 'Partners - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.partners.description:: Partners`,
    keywords: [ BRAND.name, 'oth', 'Partners' ],
  },
  customers: {
    url: 'customers',
    title: 'Customers - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.customers.description:: Customers`,
    keywords: [ BRAND.name, 'oth', 'Customers' ],
  },
  forgetPassword: {
    url: 'forget-password',
    title: 'Forget Password - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.forgetPassword.description:: Forget Password`,
    keywords: [ BRAND.name, 'oth', 'Forget Password' ],
  },
  resetPassword: {
    url: 'reset-password',
    title: 'Reset Password - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.resetPassword.description:: Reset Password`,
    keywords: [ BRAND.name, 'oth', 'Reset Password' ],
  },
  contactUs: {
    url: 'contact-us',
    title: 'Contact Us - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.contactUs.description:: Contact Us`,
    keywords: [ BRAND.name, 'oth', 'Contact Us' ],
  },
  status: {
    url: 'status',
    title: 'Status - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.status.description:: Status`,
    keywords: [ BRAND.name, 'oth', 'Status' ],
  },
  sitemap: {
    url: 'sitemap',
    title: 'Sitemap - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.sitemap.description:: Sitemap`,
    keywords: [ BRAND.name, 'oth', 'Sitemap' ],
  },
  u: {
    url: 'u',
    title: 'User - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.u.description:: User`,
    keywords: [ BRAND.name, 'oth', 'User' ],
  },
  authServerTemplate: {
    url: 'auth-server-template',
    title: 'Auth Server Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.authServerTemplate.description:: Auth Server Template`,
    keywords: [ BRAND.name, 'oth', 'Auth Server Template' ],
  },
  paymentServerTemplate: {
    url: 'payment-server-template',
    title: 'Payment Server Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.paymentServerTemplate.description:: Payment Server Template`,
    keywords: [ BRAND.name, 'oth', 'Payment Server Template' ],
  },
  fileStorageServerTemplate: {
    url: 'file-storage-server-template',
    title: 'File Storage Server Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.fileStorageServerTemplate.description:: File Storage Server Template`,
    keywords: [ BRAND.name, 'oth', 'File Storage Server Template' ],
  },
  mailServerTemplate: {
    url: 'mail-server-template',
    title: 'Mail Server Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.mailServerTemplate.description:: Mail Server Template`,
    keywords: [ BRAND.name, 'oth', 'Mail Server Template' ],
  },
  analyticsServerTemplate: {
    url: 'analytics-server-template',
    title: 'Analytics Server Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.analyticsServerTemplate.description:: Analytics Server Template`,
    keywords: [ BRAND.name, 'oth', 'Analytics Server Template' ],
  },
  smsServerTemplate: {
    url: 'sms-server-template',
    title: 'SMS Server Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.smsServerTemplate.description:: SMS Server Template`,
    keywords: [ BRAND.name, 'oth', 'SMS Server Template' ],
  },
  businessLogicServerTemplate: {
    url: 'business-logic-server-template',
    title: 'Business Logic Server Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.businessLogicServerTemplate.description:: Business Logic Server Template`,
    keywords: [ BRAND.name, 'oth', 'Business Logic Server Template' ],
  },
  companyProfileUITemplate: {
    url: 'company-profile-ui-template',
    title: 'Company Profile UI Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.companyProfileUITemplate.description:: Company Profile UI Template`,
    keywords: [ BRAND.name, 'oth', 'Company Profile UI Template' ],
  },
  webUITemplate: {
    url: 'web-ui-template',
    title: 'Web UI Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.webUITemplate.description:: Web UI Template`,
    keywords: [ BRAND.name, 'oth', 'Web UI Template' ],
  },
  mobileUITemplate: {
    url: 'mobile-ui-template',
    title: 'Mobile UI Template - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.mobileUITemplate.description:: Mobile UI Template`,
    keywords: [ BRAND.name, 'oth', 'Mobile UI Template' ],
  },
  serverGenerator: {
    url: 'server-generator',
    title: 'Server Generator - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.serverGenerator.description:: Server Generator`,
    keywords: [ BRAND.name, 'oth', 'Server Generator' ],
  },
  uiGenerator: {
    url: 'app-generator',
    title: 'UI Generator - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.uiGenerator.description:: UI Generator`,
    keywords: [ BRAND.name, 'oth', 'UI Generator' ],
  },
  orchestrationServer: {
    url: 'orchestration-server',
    title: 'Orchestration Server - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.orchestrationServer.description:: Orchestration Server`,
    keywords: [ BRAND.name, 'oth', 'Orchestration Server' ],
  },
  softwareConsultancy: {
    url: 'software-consultancy',
    title: 'Software Consultancy - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.softwareConsultancy.description:: Software Consultancy`,
    keywords: [ BRAND.name, 'oth', 'Software Consultancy' ],
  },
  softwareIntegration: {
    url: 'software-integration',
    title: 'Software Integration - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.softwareIntegration.description:: Software Integration`,
    keywords: [ BRAND.name, 'oth', 'Software Integration' ],
  },
  qualityAssurance: {
    url: 'quality-assurance',
    title: 'Quality Assurance - ' + BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.qualityAssurance.description:: Quality Assurance`,
    keywords: [ BRAND.name, 'oth', 'Quality Assurance' ],
  },

  // SplashLayout
  callback: {
    url: 'callback',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  dribbble: {
    url: 'dribbble',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  facebook: {
    url: 'facebook',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  github: {
    url: 'github',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  google: {
    url: 'google',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  linkedin: {
    url: 'linkedin',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  reddit: {
    url: 'reddit',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  twitch: {
    url: 'twitch',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  twitter: {
    url: 'twitter',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  stripe: {
    url: 'stripe',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  coinbase: {
    url: 'coinbase',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  paypal: {
    url: 'paypal',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  external: {
    url: 'external',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },

  // Dashboard Layout
  dashboard: {
    url: 'dashboard',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  myProfile: {
    url: 'my-profile',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  premium: {
    url: 'premium',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  notifications: {
    url: 'notifications',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  users: {
    url: 'users',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ]
  },
  products: {
    url: 'products',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ]
  },
  analytics: {
    url: 'analytics',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ]
  },
  createEvent: {
    url: 'create-event',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  learn: {
    url: 'learn',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  event: {
    url: 'event',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  user: {
    url: 'user',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },

  // Settings Layout
  settings: {
    url: 'settings',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  editTheme: {
    url: 'edit-theme',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  editProfile: {
    url: 'edit-profile',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  editOtherProfile: {
    url: 'edit-other-profile',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  editProduct: {
    url: 'edit-product',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  editSecurity: {
    url: 'edit-security',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },

  // Localization
  english: {
    url: 'en',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  },
  french: {
    url: 'fr',
    title: BRAND.name,
    description: BRAND.name + $localize`:@@navigationData.root.description:: Minimizes your effort while building a new software business with our open source GitHub micro server templates and responsive web UI + mobile UI templates`,
    keywords: [ BRAND.name, 'oth', 'software business', 'open source' ],
  }
};

export const URLS = {
  // Landing layout
  root: '/',
  notFound: '/' + NAVIGATIONS.notFound.url,
  maintenance: '/' + NAVIGATIONS.maintenance.url,
  signupSuccess: '/' + NAVIGATIONS.signupSuccess.url,
  verifyAccount: '/' + NAVIGATIONS.verifyAccount.url,
  cookiePolicy: '/' + NAVIGATIONS.cookiePolicy.url,
  privacyPolicy: '/' + NAVIGATIONS.privacyPolicy.url,
  terms: '/' + NAVIGATIONS.terms.url,
  pricing: '/' + NAVIGATIONS.pricing.url,
  product: '/' + NAVIGATIONS.product.url,
  about: '/' + NAVIGATIONS.about.url,
  signup: '/' + NAVIGATIONS.signup.url,
  login: '/' + NAVIGATIONS.login.url,
  twoFactorVerification: '/' + NAVIGATIONS.twoFactorVerification.url,
  branding: '/' + NAVIGATIONS.branding.url,
  blog: '/' + NAVIGATIONS.blog.url,
  docs: '/' + NAVIGATIONS.docs.url,
  partners: '/' + NAVIGATIONS.partners.url,
  customers: '/' + NAVIGATIONS.customers.url,
  forgetPassword: '/' + NAVIGATIONS.forgetPassword.url,
  resetPassword: '/' + NAVIGATIONS.resetPassword.url,
  contactUs: '/' + NAVIGATIONS.contactUs.url,
  status: '/' + NAVIGATIONS.status.url,
  sitemap: '/' + NAVIGATIONS.sitemap.url,
  u: '/' + NAVIGATIONS.u.url,

  // SplashLayout
  callback: {
    root: '/' + NAVIGATIONS.callback.url,
    dribbble: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.dribbble.url,
    facebook: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.facebook.url,
    github: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.github.url,
    google: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.google.url,
    linkedin: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.linkedin.url,
    reddit: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.reddit.url,
    stripe: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.stripe.url,
    twitch: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.twitch.url,
    twitter: '/' + NAVIGATIONS.callback.url + '/' + NAVIGATIONS.twitter.url,
  },
  external: '/' + NAVIGATIONS.external.url,

  // Dashboard Layout
  dashboard: {
    root: '/' + NAVIGATIONS.dashboard.url,
    myProfile: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.myProfile.url,
    premium: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.premium.url,
    notifications: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.notifications.url,
    users: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.users.url,
    products: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.products.url,
    analytics: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.analytics.url,
    contribute: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.event.url,
    learn: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.learn.url,
    event: '/' + NAVIGATIONS.dashboard.url + '/' + NAVIGATIONS.createEvent.url,
  },
  user: {
    root: '/' + NAVIGATIONS.user.url,
  },

  // Settings Layout
  settings: {
    editTheme: '/' + NAVIGATIONS.settings.url + '/' + NAVIGATIONS.editTheme.url,
    editProfile: '/' + NAVIGATIONS.settings.url + '/' + NAVIGATIONS.editProfile.url,
    editOtherProfile: '/' + NAVIGATIONS.settings.url + '/' + NAVIGATIONS.editOtherProfile.url,
    editProduct: '/' + NAVIGATIONS.settings.url + '/' + NAVIGATIONS.editProduct.url,
    editSecurity: '/' + NAVIGATIONS.settings.url + '/' + NAVIGATIONS.editSecurity.url
  },

  // Languages
  languages: {
    english: '/' + NAVIGATIONS.english.url,
    french: '/' + NAVIGATIONS.french.url
  }
};
