<p align="center">
  <a href="https://opentemplatehub.com">
    <img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/logo/ui/admin-ui-logo.png" alt="Logo" width=200>
  </a>
</p>

<h1 align="center">
Open Template Hub - Admin UI Template v5
</h1>

[![License](https://img.shields.io/github/license/open-template-hub/admin-ui-template?color=43b043&style=for-the-badge)](LICENSE)
[![Issues](https://img.shields.io/github/issues/open-template-hub/admin-ui-template?color=43b043&style=for-the-badge)](https://github.com/open-template-hub/admin-ui-template/issues)
[![PRCLosed](https://img.shields.io/github/issues-pr-closed-raw/open-template-hub/admin-ui-template?color=43b043&style=for-the-badge)](https://github.com/open-template-hub/admin-ui-template/pulls?q=is%3Apr+is%3Aclosed)
[![LastCommit](https://img.shields.io/github/last-commit/open-template-hub/admin-ui-template?color=43b043&style=for-the-badge)](https://github.com/open-template-hub/admin-ui-template/commits/master)
[![Release](https://img.shields.io/github/release/open-template-hub/admin-ui-template?include_prereleases&color=43b043&style=for-the-badge)](https://github.com/open-template-hub/admin-ui-template/releases)
[![Lighthouse](https://img.shields.io/badge/LIGHTHOUSE-report-43b043.svg?style=for-the-badge&logo=lighthouse)](docs/lighthouse)
[![SonarCloud](https://img.shields.io/sonar/quality_gate/open-template-hub_admin-ui-template?server=https%3A%2F%2Fsonarcloud.io&label=Sonar%20Cloud&style=for-the-badge&logo=sonarcloud)](https://sonarcloud.io/dashboard?id=open-template-hub_admin-ui-template)

Admin UI Template is a modern, responsive, and customizable admin UI template for your business. It contains reusable components, theme color, and design support along with dark theme support.

<h3 align="center">
  For demo click the image below ⬇️
</h3>

<p align="center">
  <a href="https://admin.opentemplatehub.com">
    <img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/demo/ui/admin-ui-demo-light.png" alt="Screenshot" width="800px">
  </a>
</p>

## Ways to Begin

### 1. Express Deploy

Deploy this template to Heroku

[![Deploy](https://img.shields.io/badge/Deploy_to-Heroku-7056bf.svg?style=for-the-badge&logo=heroku)](https://heroku.com/deploy?template=https://github.com/open-template-hub/admin-ui-template)

### 2. Start with UI Generator

Create your UI with UI Generator Package

[![NPM](https://img.shields.io/badge/NPM-ui_generator-cb3837.svg?style=for-the-badge&logo=npm)](https://www.npmjs.com/package/@open-template-hub/app-generator)

### 3. GitHub Template

Use this repository as a Template

[![GitHubTemplate](https://img.shields.io/badge/GitHub-Template-24292e.svg?style=for-the-badge&logo=github)](https://github.com/open-template-hub/admin-ui-template/generate)

## Installations

Install **nodejs** and **npm** via **[nodejs.org](https://nodejs.org)**.

Check installed versions of **nodejs** and **npm** via running following commands:

```
node -v
npm -v
```

## WebStorm Configurations

If you imported project into **WebStorm** you will see following run configurations:

### 1. Install

**[install.run.xml](.run/install.run.xml)**

### 2. Build

**[buildLocal.run.xml](.run/buildLocal.run.xml)**

**[buildLocalToStagingApi.run.xml](.run/buildLocalToStagingApi.run.xml)**

**[buildStaging.run.xml](.run/buildStaging.run.xml)**

**[buildProd.run.xml](.run/buildProd.run.xml)**

### 3. Start

**[startLocal.run.xml](.run/startLocal.run.xml)**

**[startLocalFromIPhone.run.xml](.run/startLocalFromIPhone.run.xml)**

**[startLocalToStagingApi.run.xml](.run/startLocalToStagingApi.run.xml)**

**[startLocalFromIPhoneToStagingApi.run.xml](.run/startLocalFromIPhoneToStagingApi.run.xml)**

**[startStaging.run.xml](.run/startStaging.run.xml)**

**[start.run.xml](.run/start.run.xml)**

### 4. Debug

**[debug.run.xml](.run/debug.run.xml)**

### 5. Dependency Management

**[outdated.run.xml](.run/outdated.run.xml)**

**[update.run.xml](.run/update.run.xml)**

<br/>

## Local Deployment and Debug

In order to deploy and debug locally, run following configurations in order:

1. **[install.run.xml](.run/install.run.xml)**
2. **[buildLocal.run.xml](.run/buildLocal.run.xml)**
3. **startLocal**
    1. **[startLocal.run.xml](.run/startLocal.run.xml) (uses local api)**
    2. **[startLocalFromIPhone.run.xml](.run/startLocalFromIPhone.run.xml) (uses local api - accessible from iphone)**
    3. **[startLocalToStagingApi.run.xml](.run/startLocalToStagingApi.run.xml) (uses staging api)**
    4. **[startLocalFromIPhoneToStagingApi.run.xml](.run/startLocalFromIPhoneToStagingApi.run.xml) (uses staging api - accessible from iphone)**
4. **[debug.run.xml](.run/debug.run.xml)**

<br/>

## Environment Variables

If you run **WebStorm**'s **[env.run.xml](.run/env.run.xml)** configuration you will see following variables generated in **.env** file. Set them appropriately.

```applescript
PORT=4202
```

<br/>

Check project's current **nodejs** and **npm** version from **[package.json](package.json)**.

## Brand Color Scale Generator

To be able to generate brand color scales, we are using **[Colllor](http://colllor.com)**.

<br/>

## Favicon Generation

To be able to generate favicon, refer to **[FAVICON_GENERATION.md](docs/FAVICON_GENERATION.md)** file.

<br/>

## Cookie Policy Generation

To be able to generate cookie policy, use **[cookiepolicygenerator](https://www.cookiepolicygenerator.com)** site.

<br/>

## Localization

To be able to generate or update localization, use [updateMessages.run.xml](.run/updateMessages.run.xml).

<br/>

## Outdated

Refer to **[OUTDATED.md](docs/OUTDATED.md)** to see outdated npm packages and update them with your own risk.

<br/>

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/furknyavuz"><img src="https://avatars0.githubusercontent.com/u/2248168?s=460&u=435ef6ade0785a7a135ce56cae751fb3ade1d126&v=4" width="100px;" alt=""/><br /><sub><b>Furkan Yavuz</b></sub></a><br /><a href="https://github.com/open-template-hub/admin-ui-template/issues/created_by/furknyavuz" title="Answering Questions">💬</a> <a href="https://github.com/open-template-hub/admin-ui-template/commits?author=furknyavuz" title="Documentation">📖</a> <a href="https://github.com/open-template-hub/admin-ui-template/pulls?q=is%3Apr+reviewed-by%3Afurknyavuz" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/fatihturker"><img src="https://avatars1.githubusercontent.com/u/2202179?s=460&u=261b1129e7106c067783cb022ab9999aad833bdc&v=4" width="100px;" alt=""/><br /><sub><b>Fatih Turker</b></sub></a><br /><a href="https://github.com/open-template-hub/admin-ui-template/issues/created_by/fatihturker" title="Answering Questions">💬</a> <a href="https://github.com/open-template-hub/admin-ui-template/commits?author=fatihturker" title="Documentation">📖</a> <a href="https://github.com/open-template-hub/admin-ui-template/pulls?q=is%3Apr+reviewed-by%3Afatihturker" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/mertlsarac"><img src="https://avatars1.githubusercontent.com/u/38442589?s=400&u=aa3cda11724fc297a0bfa6beb35c9be81687cf3c&v=4" width="100px;" alt=""/><br /><sub><b>Mert Sarac</b></sub></a><br /><a href="https://github.com/open-template-hub/admin-ui-template/issues/created_by/mertlsarac" title="Answering Questions">💬</a> <a href="https://github.com/open-template-hub/admin-ui-template/commits?author=mertlsarac" title="Documentation">📖</a> <a href="https://github.com/open-template-hub/admin-ui-template/pulls?q=is%3Apr+reviewed-by%3Amertlsarac" title="Reviewed Pull Requests">👀</a></td>
  </tr>
</table>

<!-- markdownlint-enable -->
<!-- prettier-ignore-end -->
<!-- ALL-CONTRIBUTORS-LIST:END -->

## Contributing

Refer to **[CONTRIBUTING.md](https://github.com/open-template-hub/.github/blob/master/docs/CONTRIBUTING.md)** to see how to contribute to Open Template Hub.

<br/>

## Code of Conduct

Refer to **[CODE_OF_CONDUCT.md](https://github.com/open-template-hub/.github/blob/master/docs/CODE_OF_CONDUCT.md)** to see contributor covenant code of conduct.

<br/>

## LICENSE

The source code for this project is released under the [MIT License](LICENSE).


<table align="right"><tr><td><a href="https://opentemplatehub.com"><img src="https://raw.githubusercontent.com/open-template-hub/open-template-hub.github.io/master/assets/logo/brand-logo.png" width="50px" alt="oth"/></a></td><td><b>Open Template Hub © 2023</b></td></tr></table>

