# Copyright (C) 2019-2020 OpenIO SAS, as part of OpenIO SDS
# Copyright (C) 2022-2024 OVH SAS
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 3.0 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library.

"""Command-line interface for OpenIO SDS cluster administration."""


import sys

from oio.cli.common.clientmanager import ClientManager
from oio.cli.common.shell import CommonShell
from oio.common.utils import request_id


class OpenioAdminApp(CommonShell):
    def __init__(self):
        super(OpenioAdminApp, self).__init__("openio.admin")

    def initialize_app(self, argv):
        super(OpenioAdminApp, self).initialize_app(argv)
        # For compatibility with "openio" CLI, we need this.
        options = {
            "namespace": self.options.ns,
            "account_name": self.options.account,
            "oioproxy_url": self.options.oioproxy_url,
            "account_url": self.options.account_url,
            "admin_mode": self.options.admin_mode,
            "is_cli": True,
            "timeout": self.options.timeout,
        }
        self.client_manager = ClientManager(options)

    def request_id(self, prefix="ACLI-"):
        """
        Get an ID for requests generated by this application.
        If the user has specified a request ID, return it.
        Otherwise, generate one with the specified prefix.
        """
        if self.options.request_id:
            return self.options.request_id
        return request_id(prefix)


def main(argv=sys.argv[1:]):
    return OpenioAdminApp().run(argv)
