// @formatter:off
@file:Suppress("RedundantVisibilityModifier")

// Generated by me.him188.ani.utils.bbcode.BBCodeTestGenerator
package me.him188.ani.utils.bbcode

import kotlin.test.Test

public class GenBBNestedContextTest : BBCodeParserTestHelper() {
    @Test
    public fun parse1377236079() {
        BBCode.parse("[b]Hello [i]World![/i][/b]")
        .run {
            assertText(elements.at(0), value="Hello ", bold=true)
            assertText(elements.at(1), value="World!", italic=true, bold=true)
        }
    }

    @Test
    public fun parse1607063481() {
        BBCode.parse("[url=https://example.com]Hello [b][i]World![/i][/b][/url]")
        .run {
            assertText(elements.at(0), value="Hello ", jumpUrl="https://example.com")
            assertText(elements.at(1), value="World!", jumpUrl="https://example.com", italic=true,
                    bold=true)
        }
    }

    @Test
    public fun parse608569134() {
        BBCode.parse("[url=https://example.com]Hello [b][i]World![/i][/b] [b][i]Again![/i][/b][/url]")
        .run {
            assertText(elements.at(0), value="Hello ", jumpUrl="https://example.com")
            assertText(elements.at(1), value="World!", jumpUrl="https://example.com", italic=true,
                    bold=true)
            assertText(elements.at(2), value=" ", jumpUrl="https://example.com")
            assertText(elements.at(3), value="Again!", jumpUrl="https://example.com", italic=true,
                    bold=true)
        }
    }

    @Test
    public fun parse689343298() {
        BBCode.parse("[quote]Hello [b][i]World![/i][/b][/quote]")
        .run {
            assertQuote(elements.at(0)) {
                assertText(elements.at(0), value="Hello ")
                assertText(elements.at(1), value="World!", italic=true, bold=true)
            }
        }
    }

    @Test
    public fun parse822894058() {
        BBCode.parse("[size=1][size=2]Hello World![/size][/size]")
        .run {
            assertText(elements.at(0), value="Hello World!", size=2)
        }
    }

    @Test
    public fun parse2127590386() {
        BBCode.parse("[size=1]Hello[size=2]World[/size]![/size]")
        .run {
            assertText(elements.at(0), value="Hello", size=1)
            assertText(elements.at(1), value="World", size=2)
            assertText(elements.at(2), value="!", size=1)
        }
    }

    @Test
    public fun parse1668662357() {
        BBCode.parse("[size=1]Hello[b][size=2]World[/size]![/b][/size]")
        .run {
            assertText(elements.at(0), value="Hello", size=1)
            assertText(elements.at(1), value="World", size=2, bold=true)
            assertText(elements.at(2), value="!", size=1, bold=true)
        }
    }

    @Test
    public fun parse815976454() {
        BBCode.parse("[color=red][size=1]Hello[b][size=2]World[/size]![/b][/size][/color]")
        .run {
            assertText(elements.at(0), value="Hello", size=1, color="red")
            assertText(elements.at(1), value="World", size=2, color="red", bold=true)
            assertText(elements.at(2), value="!", size=1, color="red", bold=true)
        }
    }
}


// @formatter:on
