/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package me.him188.ani.datasources.bangumi.next.apis

import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.client.engine.HttpClientEngine
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import kotlinx.serialization.json.Json
import kotlinx.serialization.serializer
import me.him188.ani.datasources.bangumi.next.infrastructure.ApiClient
import me.him188.ani.datasources.bangumi.next.infrastructure.HttpResponse
import me.him188.ani.datasources.bangumi.next.infrastructure.RequestConfig
import me.him188.ani.datasources.bangumi.next.infrastructure.RequestMethod
import me.him188.ani.datasources.bangumi.next.infrastructure.map
import me.him188.ani.datasources.bangumi.next.infrastructure.wrap
import me.him188.ani.datasources.bangumi.next.models.BangumiNextBasicReply
import me.him188.ani.datasources.bangumi.next.models.BangumiNextCreateSubjectEpCommentRequest
import me.him188.ani.datasources.bangumi.next.models.BangumiNextCreateSubjectReplyRequest
import me.him188.ani.datasources.bangumi.next.models.BangumiNextCreateSubjectTopic200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextCreateSubjectTopicRequest
import me.him188.ani.datasources.bangumi.next.models.BangumiNextEditSubjectEpCommentRequest
import me.him188.ani.datasources.bangumi.next.models.BangumiNextEditSubjectPostRequest
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectCharacters200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectComments200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectEpisodeComments200ResponseInner
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectEpisodes200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectRecs200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectRelations200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectStaffs200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGetSubjectTopics200Response
import me.him188.ani.datasources.bangumi.next.models.BangumiNextGroupReply
import me.him188.ani.datasources.bangumi.next.models.BangumiNextSubject
import me.him188.ani.datasources.bangumi.next.models.BangumiNextTopicDetail
import me.him188.ani.datasources.bangumi.next.models.BangumiNextUpdateSubjectTopicRequest

open class SubjectBangumiNextApi : ApiClient {

    constructor(
        baseUrl: String = ApiClient.BASE_URL,
        httpClientEngine: HttpClientEngine? = null,
        httpClientConfig: ((HttpClientConfig<*>) -> Unit)? = null,
        jsonSerializer: Json = ApiClient.JSON_DEFAULT
    ) : super(
        baseUrl = baseUrl,
        httpClientEngine = httpClientEngine,
        httpClientConfig = httpClientConfig,
        jsonBlock = jsonSerializer,
    )

    constructor(
        baseUrl: String,
        httpClient: HttpClient
    ) : super(baseUrl = baseUrl, httpClient = httpClient)

    /**
     * 创建条目的剧集吐槽
     * 需要 [turnstile](https://developers.cloudflare.com/turnstile/get-started/client-side-rendering/)  next.bgm.tv 域名对应的 site-key 为 &#x60;0x4AAAAAAABkMYinukE8nzYS&#x60;  dev.bgm38.com 域名使用测试用的 site-key &#x60;1x00000000000000000000AA&#x60;
     * @param episodeID
     * @param bangumiNextCreateSubjectEpCommentRequest
     * @return BangumiNextBasicReply
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun createSubjectEpComment(
        episodeID: kotlin.Int,
        bangumiNextCreateSubjectEpCommentRequest: BangumiNextCreateSubjectEpCommentRequest
    ): HttpResponse<BangumiNextBasicReply> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = bangumiNextCreateSubjectEpCommentRequest

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.POST,
            "/p1/subjects/-/episode/{episodeID}/comments".replace("{" + "episodeID" + "}", "$episodeID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return jsonRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }



    /**
     * 创建条目讨论版回复
     * 需要 [turnstile](https://developers.cloudflare.com/turnstile/get-started/client-side-rendering/)  next.bgm.tv 域名对应的 site-key 为 &#x60;0x4AAAAAAABkMYinukE8nzYS&#x60;  dev.bgm38.com 域名使用测试用的 site-key &#x60;1x00000000000000000000AA&#x60;
     * @param topicID
     * @param bangumiNextCreateSubjectReplyRequest 
     * @return BangumiNextBasicReply
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun createSubjectReply(
        topicID: kotlin.Int,
        bangumiNextCreateSubjectReplyRequest: BangumiNextCreateSubjectReplyRequest
    ): HttpResponse<BangumiNextBasicReply> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = bangumiNextCreateSubjectReplyRequest

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.POST,
            "/p1/subjects/-/topics/{topicID}/replies".replace("{" + "topicID" + "}", "$topicID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return jsonRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 创建条目讨论
     *
     * @param subjectID
     * @param bangumiNextCreateSubjectTopicRequest
     * @return BangumiNextCreateSubjectTopic200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun createSubjectTopic(
        subjectID: kotlin.Int,
        bangumiNextCreateSubjectTopicRequest: BangumiNextCreateSubjectTopicRequest
    ): HttpResponse<BangumiNextCreateSubjectTopic200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = bangumiNextCreateSubjectTopicRequest

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.POST,
            "/p1/subjects/{subjectID}/topics".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return jsonRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }



    /**
     * 删除条目的剧集吐槽
     *
     * @param commentID 
     * @return kotlin.String
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun deleteSubjectEpComment(commentID: kotlin.Int): HttpResponse<kotlin.String> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.DELETE,
            "/p1/subjects/-/episode/-/comments/{commentID}".replace("{" + "commentID" + "}", "$commentID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 删除自己创建的条目讨论版回复
     * 
     * @param postID 
     * @return kotlin.String
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun deleteSubjectPost(postID: kotlin.Int): HttpResponse<kotlin.String> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.DELETE,
            "/p1/subjects/-/posts/{postID}".replace("{" + "postID" + "}", "$postID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 编辑条目的剧集吐槽
     *
     * @param commentID
     * @param bangumiNextEditSubjectEpCommentRequest 
     * @return kotlin.String
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun editSubjectEpComment(
        commentID: kotlin.Int,
        bangumiNextEditSubjectEpCommentRequest: BangumiNextEditSubjectEpCommentRequest
    ): HttpResponse<kotlin.String> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = bangumiNextEditSubjectEpCommentRequest

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.PUT,
            "/p1/subjects/-/episode/-/comments/{commentID}".replace("{" + "commentID" + "}", "$commentID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return jsonRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }



    /**
     * 编辑自己创建的条目讨论版回复
     * 
     * @param postID 
     * @param bangumiNextEditSubjectPostRequest 
     * @return kotlin.String
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun editSubjectPost(
        postID: kotlin.Int,
        bangumiNextEditSubjectPostRequest: BangumiNextEditSubjectPostRequest
    ): HttpResponse<kotlin.String> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = bangumiNextEditSubjectPostRequest

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.PUT,
            "/p1/subjects/-/posts/{postID}".replace("{" + "postID" + "}", "$postID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return jsonRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目
     *
     * @param subjectID
     * @return BangumiNextSubject
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubject(subjectID: kotlin.Int): HttpResponse<BangumiNextSubject> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody =
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目的角色
     *
     * @param subjectID
     * @param type 角色出场类型: 主角，配角，客串 (optional)
     * @param limit max 100 (optional, default to 20)
     * @param offset min 0 (optional, default to 0)
     * @return BangumiNextGetSubjectCharacters200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectCharacters(
        subjectID: kotlin.Int,
        type: kotlin.Int? = null,
        limit: kotlin.Int? = 20,
        offset: kotlin.Int? = 0
    ): HttpResponse<BangumiNextGetSubjectCharacters200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody =
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        type?.apply { localVariableQuery["type"] = listOf("$type") }
        limit?.apply { localVariableQuery["limit"] = listOf("$limit") }
        offset?.apply { localVariableQuery["offset"] = listOf("$offset") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}/characters".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目的吐槽箱
     *
     * @param subjectID
     * @param type 收藏类型 (optional)
     * @param limit max 100 (optional, default to 20)
     * @param offset min 0 (optional, default to 0)
     * @return BangumiNextGetSubjectComments200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectComments(
        subjectID: kotlin.Int,
        type: Int? = null,
        limit: kotlin.Int? = 20,
        offset: kotlin.Int? = 0
    ): HttpResponse<BangumiNextGetSubjectComments200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody =
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        type?.apply { localVariableQuery["type"] = listOf("$type") }
        limit?.apply { localVariableQuery["limit"] = listOf("$limit") }
        offset?.apply { localVariableQuery["offset"] = listOf("$offset") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}/comments".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目的剧集吐槽箱
     * 
     * @param episodeID 
     * @return kotlin.collections.List<BangumiNextGetSubjectEpisodeComments200ResponseInner>
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectEpisodeComments(episodeID: kotlin.Int): HttpResponse<kotlin.collections.List<BangumiNextGetSubjectEpisodeComments200ResponseInner>> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/-/episode/{episodeID}/comments".replace("{" + "episodeID" + "}", "$episodeID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap<GetSubjectEpisodeCommentsResponse>().map { value }
    }

    @Serializable(GetSubjectEpisodeCommentsResponse.Companion::class)
    private class GetSubjectEpisodeCommentsResponse(val value: List<BangumiNextGetSubjectEpisodeComments200ResponseInner>) {
        companion object : KSerializer<GetSubjectEpisodeCommentsResponse> {
            private val serializer: KSerializer<List<BangumiNextGetSubjectEpisodeComments200ResponseInner>> =
                serializer<List<BangumiNextGetSubjectEpisodeComments200ResponseInner>>()
            override val descriptor = serializer.descriptor
            override fun serialize(encoder: Encoder, obj: GetSubjectEpisodeCommentsResponse) =
                serializer.serialize(encoder, obj.value)

            override fun deserialize(decoder: Decoder) =
                GetSubjectEpisodeCommentsResponse(serializer.deserialize(decoder))
        }
    }

    /**
     * 获取条目的剧集
     *
     * @param subjectID
     * @param type 剧集类型 (optional)
     * @param limit max 1000 (optional, default to 100)
     * @param offset min 0 (optional, default to 0)
     * @return BangumiNextGetSubjectEpisodes200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectEpisodes(
        subjectID: kotlin.Int,
        type: Int? = null,
        limit: kotlin.Int? = 100,
        offset: kotlin.Int? = 0
    ): HttpResponse<BangumiNextGetSubjectEpisodes200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody =
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        type?.apply { localVariableQuery["type"] = listOf("$type") }
        limit?.apply { localVariableQuery["limit"] = listOf("$limit") }
        offset?.apply { localVariableQuery["offset"] = listOf("$offset") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}/episodes".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目讨论版回复
     * 
     * @param postID 
     * @return BangumiNextGroupReply
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectPost(postID: kotlin.Int): HttpResponse<BangumiNextGroupReply> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/-/posts/{postID}".replace("{" + "postID" + "}", "$postID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目的推荐
     *
     * @param subjectID
     * @param limit max 10 (optional, default to 10)
     * @param offset min 0 (optional, default to 0)
     * @return BangumiNextGetSubjectRecs200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectRecs(
        subjectID: kotlin.Int,
        limit: kotlin.Int? = 10,
        offset: kotlin.Int? = 0
    ): HttpResponse<BangumiNextGetSubjectRecs200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody =
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        limit?.apply { localVariableQuery["limit"] = listOf("$limit") }
        offset?.apply { localVariableQuery["offset"] = listOf("$offset") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}/recs".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目的关联条目
     *
     * @param subjectID
     * @param type 条目类型 (optional)
     * @param offprint 是否单行本 (optional, default to false)
     * @param limit max 100 (optional, default to 20)
     * @param offset min 0 (optional, default to 0)
     * @return BangumiNextGetSubjectRelations200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectRelations(
        subjectID: kotlin.Int,
        type: Int? = null,
        offprint: kotlin.Boolean? = false,
        limit: kotlin.Int? = 20,
        offset: kotlin.Int? = 0
    ): HttpResponse<BangumiNextGetSubjectRelations200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        type?.apply { localVariableQuery["type"] = listOf("$type") }
        offprint?.apply { localVariableQuery["offprint"] = listOf("$offprint") }
        limit?.apply { localVariableQuery["limit"] = listOf("$limit") }
        offset?.apply { localVariableQuery["offset"] = listOf("$offset") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}/relations".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目的制作人员
     *
     * @param subjectID
     * @param position 人物职位: 监督，原案，脚本,.. (optional)
     * @param limit max 100 (optional, default to 20)
     * @param offset min 0 (optional, default to 0)
     * @return BangumiNextGetSubjectStaffs200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectStaffs(
        subjectID: kotlin.Int,
        position: kotlin.Int? = null,
        limit: kotlin.Int? = 20,
        offset: kotlin.Int? = 0
    ): HttpResponse<BangumiNextGetSubjectStaffs200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        position?.apply { localVariableQuery["position"] = listOf("$position") }
        limit?.apply { localVariableQuery["limit"] = listOf("$limit") }
        offset?.apply { localVariableQuery["offset"] = listOf("$offset") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}/staffs".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目讨论
     *
     * @param topicID
     * @return BangumiNextTopicDetail
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectTopic(topicID: kotlin.Int): HttpResponse<BangumiNextTopicDetail> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody =
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/-/topics/{topicID}".replace("{" + "topicID" + "}", "$topicID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取条目讨论版
     *
     * @param subjectID
     * @param limit max 100 (optional, default to 20)
     * @param offset min 0 (optional, default to 0)
     * @return BangumiNextGetSubjectTopics200Response
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectTopics(
        subjectID: kotlin.Int,
        limit: kotlin.Int? = 20,
        offset: kotlin.Int? = 0
    ): HttpResponse<BangumiNextGetSubjectTopics200Response> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        limit?.apply { localVariableQuery["limit"] = listOf("$limit") }
        offset?.apply { localVariableQuery["offset"] = listOf("$offset") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/p1/subjects/{subjectID}/topics".replace("{" + "subjectID" + "}", "$subjectID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 编辑自己创建的条目讨论
     *
     * @param topicID
     * @param bangumiNextUpdateSubjectTopicRequest
     * @return void
     */
    open suspend fun updateSubjectTopic(
        topicID: kotlin.Int,
        bangumiNextUpdateSubjectTopicRequest: BangumiNextUpdateSubjectTopicRequest
    ): HttpResponse<Unit> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = bangumiNextUpdateSubjectTopicRequest

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.PUT,
            "/p1/subjects/-/topics/{topicID}".replace("{" + "topicID" + "}", "$topicID"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return jsonRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


}
