/*
 * Copyright (C) 2024 OpenAni and contributors.
 *
 * 此源代码的使用受 GNU AFFERO GENERAL PUBLIC LICENSE version 3 许可证的约束, 可以在以下链接找到该许可证.
 * Use of this source code is governed by the GNU AGPLv3 license, which can be found at the following link.
 *
 * https://github.com/open-ani/ani/blob/main/LICENSE
 */

/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package me.him188.ani.client.apis


import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.client.engine.HttpClientEngine
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import kotlinx.serialization.json.Json
import kotlinx.serialization.serializer
import me.him188.ani.client.infrastructure.ApiClient
import me.him188.ani.client.infrastructure.HttpResponse
import me.him188.ani.client.infrastructure.RequestConfig
import me.him188.ani.client.infrastructure.RequestMethod
import me.him188.ani.client.infrastructure.map
import me.him188.ani.client.infrastructure.wrap

open class SubscriptionsAniApi : ApiClient {

    constructor(
        baseUrl: String = ApiClient.BASE_URL,
        httpClientEngine: HttpClientEngine? = null,
        httpClientConfig: ((HttpClientConfig<*>) -> Unit)? = null,
        jsonSerializer: Json = ApiClient.JSON_DEFAULT
    ) : super(
        baseUrl = baseUrl,
        httpClientEngine = httpClientEngine,
        httpClientConfig = httpClientConfig,
        jsonBlock = jsonSerializer,
    )

    constructor(
        baseUrl: String,
        httpClient: HttpClient
    ) : super(baseUrl = baseUrl, httpClient = httpClient)

    /**
     * 获取订阅数据
     * 获取订阅数据
     * @param url 
     * @return kotlin.collections.Map<kotlin.String, kotlin.String>
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubscriptionData(url: kotlin.String): HttpResponse<kotlin.collections.Map<kotlin.String, kotlin.String>> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/v1/subs/proxy".replace("{" + "url" + "}", "$url"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap<GetSubscriptionDataResponse>().map { value }
    }

    @Serializable(GetSubscriptionDataResponse.Companion::class)
    private class GetSubscriptionDataResponse(val value: Map<kotlin.String, kotlin.String>) {
        companion object : KSerializer<GetSubscriptionDataResponse> {
            private val serializer: KSerializer<Map<kotlin.String, kotlin.String>> =
                serializer<Map<String, kotlin.String>>()
            override val descriptor = serializer.descriptor
            override fun serialize(encoder: Encoder, obj: GetSubscriptionDataResponse) =
                serializer.serialize(encoder, obj.value)
            override fun deserialize(decoder: Decoder) = GetSubscriptionDataResponse(serializer.deserialize(decoder))
        }
    }

}
