/*
 * Copyright (C) 2024 OpenAni and contributors.
 *
 * 此源代码的使用受 GNU AFFERO GENERAL PUBLIC LICENSE version 3 许可证的约束, 可以在以下链接找到该许可证.
 * Use of this source code is governed by the GNU AGPLv3 license, which can be found at the following link.
 *
 * https://github.com/open-ani/ani/blob/main/LICENSE
 */

/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package me.him188.ani.client.apis

import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.client.engine.HttpClientEngine
import kotlinx.serialization.json.Json
import me.him188.ani.client.infrastructure.ApiClient
import me.him188.ani.client.infrastructure.HttpResponse
import me.him188.ani.client.infrastructure.RequestConfig
import me.him188.ani.client.infrastructure.RequestMethod
import me.him188.ani.client.infrastructure.toMultiValue
import me.him188.ani.client.infrastructure.wrap
import me.him188.ani.client.models.AniAnimeSchedule
import me.him188.ani.client.models.AniAnimeSeasonIdList
import me.him188.ani.client.models.AniBatchGetSubjectRecurrenceResponse

open class ScheduleAniApi : ApiClient {

    constructor(
        baseUrl: String = ApiClient.BASE_URL,
        httpClientEngine: HttpClientEngine? = null,
        httpClientConfig: ((HttpClientConfig<*>) -> Unit)? = null,
        jsonSerializer: Json = ApiClient.JSON_DEFAULT
    ) : super(
        baseUrl = baseUrl,
        httpClientEngine = httpClientEngine,
        httpClientConfig = httpClientConfig,
        jsonBlock = jsonSerializer,
    )

    constructor(
        baseUrl: String,
        httpClient: HttpClient
    ) : super(baseUrl = baseUrl, httpClient = httpClient)

    /**
     * 获取一个季度的新番时间表
     * 获取一个季度的新番时间表
     * @param seasonId 格式为 \&quot;{年份}q{季度序号}\&quot;. 例如 \&quot;2024q3\&quot;. 季度序号范围为 1..3 (包含), 分别对应春季, 夏季, 秋季, 冬季
     * @return AniAnimeSchedule
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getAnimeSeason(seasonId: kotlin.String): HttpResponse<AniAnimeSchedule> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/v1/schedule/season/{seasonId}".replace("{" + "seasonId" + "}", "$seasonId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 获取新番季度列表
     * 获取新番季度列表
     * @return AniAnimeSeasonIdList
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getAnimeSeasons(): HttpResponse<AniAnimeSeasonIdList> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/v1/schedule/seasons",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 查询一些条目的连载信息
     * 查询一些条目的连载信息
     * @param ids 需要查询的条目 ID 列表, 以英文逗号分隔. (optional)
     * @return AniBatchGetSubjectRecurrenceResponse
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getSubjectRecurrences(ids: kotlin.collections.List<kotlin.Int>? = null): HttpResponse<AniBatchGetSubjectRecurrenceResponse> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        ids?.apply { localVariableQuery["ids"] = toMultiValue(this, "csv") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/v1/schedule/subjects",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


}
