/*
 * Copyright (C) 2024 OpenAni and contributors.
 *
 * 此源代码的使用受 GNU AFFERO GENERAL PUBLIC LICENSE version 3 许可证的约束, 可以在以下链接找到该许可证.
 * Use of this source code is governed by the GNU AGPLv3 license, which can be found at the following link.
 *
 * https://github.com/open-ani/ani/blob/main/LICENSE
 */

/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport",
)

package me.him188.ani.client.apis

import me.him188.ani.client.models.AniDanmakuGetResponse
import me.him188.ani.client.models.AniDanmakuPostRequest

import me.him188.ani.client.infrastructure.*
import io.ktor.client.HttpClient
import io.ktor.client.HttpClientConfig
import io.ktor.client.request.forms.formData
import io.ktor.client.engine.HttpClientEngine
import kotlinx.serialization.json.Json
import io.ktor.http.ParametersBuilder
import kotlinx.serialization.*
import kotlinx.serialization.descriptors.*
import kotlinx.serialization.encoding.*

open class DanmakuAniApi : ApiClient {

    constructor(
        baseUrl: String = ApiClient.BASE_URL,
        httpClientEngine: HttpClientEngine? = null,
        httpClientConfig: ((HttpClientConfig<*>) -> Unit)? = null,
        jsonSerializer: Json = ApiClient.JSON_DEFAULT
    ) : super(
        baseUrl = baseUrl,
        httpClientEngine = httpClientEngine,
        httpClientConfig = httpClientConfig,
        jsonBlock = jsonSerializer,
    )

    constructor(
        baseUrl: String,
        httpClient: HttpClient
    ) : super(baseUrl = baseUrl, httpClient = httpClient)

    /**
     * 获取弹幕
     * 获取某一剧集内的弹幕，可指定某一时间范围及最大获取数量。
     * @param episodeId 剧集 ID
     * @param maxCount 最大弹幕获取数量，默认为 8000 (optional)
     * @param fromTime 过滤范围开始时间，单位为毫秒，默认为 0 (optional)
     * @param toTime 过滤范围结束时间，单位为毫秒，默认为 -1；值为负数时表示不限制结束时间 (optional)
     * @return AniDanmakuGetResponse
     */
    @Suppress("UNCHECKED_CAST")
    open suspend fun getDanmaku(
        episodeId: kotlin.String,
        maxCount: kotlin.Int? = null,
        fromTime: kotlin.Long? = null,
        toTime: kotlin.Long? = null
    ): HttpResponse<AniDanmakuGetResponse> {

        val localVariableAuthNames = listOf<String>()

        val localVariableBody = 
            io.ktor.client.utils.EmptyContent

        val localVariableQuery = mutableMapOf<String, List<String>>()
        maxCount?.apply { localVariableQuery["maxCount"] = listOf("$maxCount") }
        fromTime?.apply { localVariableQuery["fromTime"] = listOf("$fromTime") }
        toTime?.apply { localVariableQuery["toTime"] = listOf("$toTime") }
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.GET,
            "/v1/danmaku/{episodeId}".replace("{" + "episodeId" + "}", "$episodeId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
        )

        return request(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


    /**
     * 发送弹幕
     * 发送一条弹幕至某一剧集，可指定弹幕时间、内容、颜色和内容。需要用户登录。
     * @param episodeId 剧集 ID
     * @param aniDanmakuPostRequest 弹幕信息 (optional)
     * @return void
     */
    open suspend fun postDanmaku(
        episodeId: kotlin.String,
        aniDanmakuPostRequest: AniDanmakuPostRequest? = null
    ): HttpResponse<Unit> {

        val localVariableAuthNames = listOf<String>("auth-jwt")

        val localVariableBody = aniDanmakuPostRequest

        val localVariableQuery = mutableMapOf<String, List<String>>()
        val localVariableHeaders = mutableMapOf<String, String>()

        val localVariableConfig = RequestConfig<kotlin.Any?>(
            RequestMethod.POST,
            "/v1/danmaku/{episodeId}".replace("{" + "episodeId" + "}", "$episodeId"),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
        )

        return jsonRequest(
            localVariableConfig,
            localVariableBody,
            localVariableAuthNames,
        ).wrap()
    }


}
