package me.him188.ani.app.tools

import androidx.compose.ui.graphics.Color

object HtmlColor {
    fun parse(colorCode: String?): Color {
        if (colorCode == null) return Color.Unspecified
        return try {
            if (colorCode.startsWith('#')) {
                val value = colorCode.trim('#').toLong()
                Color(if (value and 0xFF000000 == 0L) value or 0xFF000000 else value)
            } else {
                COLOR_NAME[colorCode.lowercase()]?.let { Color(it.toLong() or 0xFF000000) } ?: Color.Unspecified
            }
        } catch (ex: NumberFormatException) {
            Color.Unspecified
        }
    }

    private val COLOR_NAME = mapOf(
        "aliceblue" to 0xF0F8FF,
        "antiquewhite" to 0xFAEBD7,
        "aqua" to 0x00FFFF,
        "aquamarine" to 0x7FFFD4,
        "azure" to 0xF0FFFF,
        "beige" to 0xF5F5DC,
        "bisque" to 0xFFE4C4,
        "black" to 0x000000,
        "blanchedalmond" to 0xFFEBCD,
        "blue" to 0x0000FF,
        "blueviolet" to 0x8A2BE2,
        "brown" to 0xA52A2A,
        "burlywood" to 0xDEB887,
        "cadetblue" to 0x5F9EA0,
        "chartreuse" to 0x7FFF00,
        "chocolate" to 0xD2691E,
        "coral" to 0xFF7F50,
        "cornflowerblue" to 0x6495ED,
        "cornsilk" to 0xFFF8DC,
        "crimson" to 0xDC143C,
        "cyan" to 0x00FFFF,
        "darkblue" to 0x00008B,
        "darkcyan" to 0x008B8B,
        "darkgoldenrod" to 0xB8860B,
        "darkgray" to 0xA9A9A9,
        "darkgreen" to 0x006400,
        "darkkhaki" to 0xBDB76B,
        "darkmagenta" to 0x8B008B,
        "darkolivegreen" to 0x556B2F,
        "darkorange" to 0xFF8C00,
        "darkorchid" to 0x9932CC,
        "darkred" to 0x8B0000,
        "darksalmon" to 0xE9967A,
        "darkseagreen" to 0x8FBC8F,
        "darkslateblue" to 0x483D8B,
        "darkslategray" to 0x2F4F4F,
        "darkturquoise" to 0x00CED1,
        "darkviolet" to 0x9400D3,
        "deeppink" to 0xFF1493,
        "deepskyblue" to 0x00BFFF,
        "dimgray" to 0x696969,
        "dodgerblue" to 0x1E90FF,
        "firebrick" to 0xB22222,
        "floralwhite" to 0xFFFAF0,
        "forestgreen" to 0x228B22,
        "fuchsia" to 0xFF00FF,
        "gainsboro" to 0xDCDCDC,
        "ghostwhite" to 0xF8F8FF,
        "gold" to 0xFFD700,
        "goldenrod" to 0xDAA520,
        "gray" to 0x808080,
        "green" to 0x008000,
        "greenyellow" to 0xADFF2F,
        "honeydew" to 0xF0FFF0,
        "hotpink" to 0xFF69B4,
        "indianred" to 0xCD5C5C,
        "indigo" to 0x4B0082,
        "ivory" to 0xFFFFF0,
        "khaki" to 0xF0E68C,
        "lavender" to 0xE6E6FA,
        "lavenderblush" to 0xFFF0F5,
        "lawngreen" to 0x7CFC00,
        "lemonchiffon" to 0xFFFACD,
        "lightblue" to 0xADD8E6,
        "lightcoral" to 0xF08080,
        "lightcyan" to 0xE0FFFF,
        "lightgoldenrodyellow" to 0xFAFAD2,
        "lightgray" to 0xD3D3D3,
        "lightgreen" to 0x90EE90,
        "lightpink" to 0xFFB6C1,
        "lightsalmon" to 0xFFA07A,
        "lightseagreen" to 0x20B2AA,
        "lightskyblue" to 0x87CEFA,
        "lightslategray" to 0x778899,
        "lightsteelblue" to 0xB0C4DE,
        "lightyellow" to 0xFFFFE0,
        "lime" to 0x00FF00,
        "limegreen" to 0x32CD32,
        "linen" to 0xFAF0E6,
        "magenta" to 0xFF00FF,
        "maroon" to 0x800000,
        "mediumaquamarine" to 0x66CDAA,
        "mediumblue" to 0x0000CD,
        "mediumorchid" to 0xBA55D3,
        "mediumpurple" to 0x9370DB,
        "mediumseagreen" to 0x3CB371,
        "mediumslateblue" to 0x7B68EE,
        "mediumspringgreen" to 0x00FA9A,
        "mediumturquoise" to 0x48D1CC,
        "mediumvioletred" to 0xC71585,
        "midnightblue" to 0x191970,
        "mintcream" to 0xF5FFFA,
        "mistyrose" to 0xFFE4E1,
        "moccasin" to 0xFFE4B5,
        "navajowhite" to 0xFFDEAD,
        "navy" to 0x000080,
        "oldlace" to 0xFDF5E6,
        "olive" to 0x808000,
        "olivedrab" to 0x6B8E23,
        "orange" to 0xFFA500,
        "orangered" to 0xFF4500,
        "orchid" to 0xDA70D6,
        "palegoldenrod" to 0xEEE8AA,
        "palegreen" to 0x98FB98,
        "paleturquoise" to 0xAFEEEE,
        "palevioletred" to 0xDB7093,
        "papayawhip" to 0xFFEFD5,
        "peachpuff" to 0xFFDAB9,
        "peru" to 0xCD853F,
        "pink" to 0xFFC0CB,
        "plum" to 0xDDA0DD,
        "powderblue" to 0xB0E0E6,
        "purple" to 0x800080,
        "rebeccapurple" to 0x663399,
        "red" to 0xFF0000,
        "rosybrown" to 0xBC8F8F,
        "royalblue" to 0x4169E1,
        "saddlebrown" to 0x8B4513,
        "salmon" to 0xFA8072,
        "sandybrown" to 0xF4A460,
        "seagreen" to 0x2E8B57,
        "seashell" to 0xFFF5EE,
        "sienna" to 0xA0522D,
        "silver" to 0xC0C0C0,
        "skyblue" to 0x87CEEB,
        "slateblue" to 0x6A5ACD,
        "slategray" to 0x708090,
        "snow" to 0xFFFAFA,
        "springgreen" to 0x00FF7F,
        "steelblue" to 0x4682B4,
        "tan" to 0xD2B48C,
        "teal" to 0x008080,
        "thistle" to 0xD8BFD8,
        "tomato" to 0xFF6347,
        "turquoise" to 0x40E0D0,
        "violet" to 0xEE82EE,
        "wheat" to 0xF5DEB3,
        "white" to 0xFFFFFF,
        "whitesmoke" to 0xF5F5F5,
        "yellow" to 0xFFFF00,
        "yellowgreen" to 0x9ACD32,
    )
}