/*
 * Copyright (C) 2024 OpenAni and contributors.
 *
 * 此源代码的使用受 GNU AFFERO GENERAL PUBLIC LICENSE version 3 许可证的约束, 可以在以下链接找到该许可证.
 * Use of this source code is governed by the GNU AGPLv3 license, which can be found at the following link.
 *
 * https://github.com/open-ani/ani/blob/main/LICENSE
 */

package me.him188.ani.app.domain.episode

import me.him188.ani.app.data.repository.episode.EpisodeCollectionRepository
import me.him188.ani.app.domain.usecase.UseCase
import me.him188.ani.datasources.api.topic.UnifiedCollectionType
import org.koin.core.Koin

fun interface GetEpisodeCollectionTypeUseCase : UseCase {
    suspend operator fun invoke(
        episodeId: Int,
        allowNetwork: Boolean,
    ): UnifiedCollectionType?
}

class GetEpisodeCollectionTypeUseCaseImpl(
    koin: Koin,
) : GetEpisodeCollectionTypeUseCase {
    private val episodeCollectionRepository: EpisodeCollectionRepository by koin.inject()
    override suspend fun invoke(episodeId: Int, allowNetwork: Boolean): UnifiedCollectionType? {
        return episodeCollectionRepository.getEpisodeCollectionType(episodeId, allowNetwork)
    }
}