(* ::Title:: *)
(*Geass`*)


(* ::Text::GrayLevel[0.5]:: *)
(* Autogenerated Geass loader file *)


Unprotect[Geass`PackageScope`Private`$TopLevelLoad];
Geass`PackageScope`Private`$TopLevelLoad = MemberQ[$ContextPath, "Global`"];


BeginPackage["Geass`"];


ClearAll[Geass];
Geass::usage = "Geass is a manager head for the Geass package";


(* ::Subsubsection::Closed:: *)
(*$ContextPath*)


System`Private`NewContextPath@
	Join[
		$ContextPath,
		"Geass`" <>
			StringReplace[
				FileNameDrop[#, FileNameDepth@DirectoryName@$InputFileName],
				$PathnameSeparator -> "`"
			]& /@
			Select[
				DirectoryQ@# &&
					StringMatchQ[
						StringReplace[
							FileNameDrop[#, FileNameDepth@DirectoryName@$InputFileName],
							$PathnameSeparator -> "`"
						],
						("$" | WordCharacter)..
					]
					&]@
				FileNames["*",
					FileNameJoin@{
						DirectoryName@$InputFileName,
						"Packages"
					},
					Infinity
				]
	]


(* ::Section:: *)
(* Package Functions *)


Unprotect["`PackageScope`Private`*"];
Begin["`PackageScope`Private`"];
AppendTo[$ContextPath, $Context];


(* ::Subsection:: *)
(*Constants*)


$PackageDirectory::usage = "";
$PackageName::usage = "";
$PackageListing::usage = "The listing of packages";
$PackagePackagesDirectory::usage = "The directory to look for packages under";
$PackageContexts::usage = "The list of contexts exposed to all packages";
$PackageDeclared::usage = "Whether the package has been auto-loaded or not";
$PackageFEHiddenSymbols::usage = "";
$PackageScopedSymbols::usage = "";
$PackageLoadSpecs::usage = "";
$AllowPackageSymbolDefinitions::usage = "";
$AllowPackageRescoping::usage = "";
$AllowPackageRecoloring::usage = "";
$AllowPackageAutocompletions::usage = "";


(* ::Subsubsection::Closed:: *)
(*Begin*)


Begin["`Constants`"];


(* ::Subsubsection::Closed:: *)
(*Naming*)


Geass["Directory"] :=
	$PackageDirectory;
$PackageDirectory =
	DirectoryName@$InputFileName;


Geass["Name"] :=
	$PackageName;
$PackageName =
	"Geass";


(* ::Subsubsection::Closed:: *)
(*Load Specs*)


Geass["LoadingParameters"] := $PackageLoadSpecs
$PackageLoadSpecs =
	Merge[
		{
			With[
				{
					f =
						Append[
							FileNames[
								"LoadInfo." ~~ "m" | "wl",
								FileNameJoin@{$PackageDirectory, "Config"}
							],
							None
						][[1]]
				},
				Replace[
					Quiet[
						Import@f,
						{
							Import::nffil,
							Import::chtype
						}
					],
					Except[KeyValuePattern[{}]] :>
						{}
				]
			],
			With[
				{
					f =
						Append[
							FileNames[
								"LoadInfo." ~~ "m" | "wl",
								FileNameJoin@{$PackageDirectory, "Private", "Config"}
							],
							None
						][[1]]},
				Replace[
					Quiet[
						Import@f,
						{
							Import::nffil,
							Import::chtype
						}
					],
					Except[KeyValuePattern[{}]] :>
						{}
				]
			]
		},
		Last
	];


(* ::Subsubsection::Closed:: *)
(*Loading*)


Geass["PackageListing"] := $PackageListing;
$PackageListing = <||>;
Geass["Contexts"] := $PackageContexts;
If[!ListQ@$PackageContexts,
	$PackageContexts =
		{
			"Geass`",
			"Geass`PackageScope`Private`",
			"Geass`PackageScope`Package`"
		}
];
$PackageDeclared =
	TrueQ[$PackageDeclared];


$PackagePackagesDirectory =
	Replace[
		Lookup[$PackageLoadSpecs, "PackagesDirectory"],
		Except[s_String?(Directory@FileNameJoin@{$PackageDirectory, #}&)] -> "Packages"
	]


(* ::Subsubsection::Closed:: *)
(*Scoping*)


Geass["FEScopedSymbols"] := $PackageFEHiddenSymbols;
$PackageFEHiddenSymbols = {};
Geass["PackageScopedSymbols"] := $PackageScopedSymbols;
$PackageScopedSymbols = {};


(* ::Subsubsection::Closed:: *)
(*Allow flags*)


$AllowPackageSymbolDefinitions =
	Replace[
		Lookup[$PackageLoadSpecs, "PackageSymbolDefinitions"],
		Except[True | False | None] -> True
	];
Geass["AllowRescoping"] := $AllowPackageRescoping;
$AllowPackageRescoping =
	Replace[
		Lookup[$PackageLoadSpecs, "AllowRescoping"],
		Except[True | False] -> $TopLevelLoad
	];
Geass["AllowRecoloring"] := $AllowPackageRecoloring;
$AllowPackageRecoloring =
	Replace[
		Lookup[$PackageLoadSpecs, "AllowRecoloring"],
		Except[True | False] -> $TopLevelLoad
	];
Geass["AllowAutocompletions"] := $AllowPackageAutocompletions;
$AllowPackageAutocompletions =
	Replace[
		Lookup[$PackageLoadSpecs, "AllowAutocompletions"],
		Except[True | False] -> $TopLevelLoad
	];


(* ::Subsubsection::Closed:: *)
(*End*)


End[]
(* ::Subsection:: *)
(*Paths*)


PackageFilePath::usage = "";
PackageFEFile::usage = "";


(* ::Subsubsection::Closed:: *)
(*Begin*)


Begin["`Paths`"]


(* ::Subsubsection::Closed:: *)
(*PackageFilePath*)


PackageFilePath[p__] :=
	FileNameJoin[Flatten@{
		$PackageDirectory,
		p
	}];


(* ::Subsubsection::Closed:: *)
(*PackageFEFile*)


PackageFEFile[p___, f_] :=
	FrontEnd`FileName[
		Evaluate@
			Flatten@{
				$PackageName,
				p
			},
		f
	];


(* ::Subsubsection::Closed:: *)
(*PackagePathSymbol*)


PackagePathSymbol[parts___String, sym_String] :=
	ToExpression[StringRiffle[{$PackageName, parts, sym}, "`"], StandardForm, HoldPattern];
PackagePathSymbol[parts___String, sym_Symbol] :=
	PackagePathSymbol[parts, Evaluate@SymbolName@Unevaluated[sym]];
PackagePathSymbol ~ SetAttributes ~ HoldRest;


(* ::Subsubsection::Closed:: *)
(*End*)


End[]
(* ::Subsection:: *)
(*Loading*)


$PackageFileContexts::usage = "The contexts for files in the package";
$DeclaredPackages::usage = "The set of packages found and declared via the autoloader";
$LoadedPackages::usage = "The set of loaded packages";


PackageExecute::usage = "Executes something with the package contexts exposed";
PackageLoadPackage::usage = "Loads a package via PackageExecute";
PackageLoadDeclare::usage = "Declares a package";


PackageAppLoad::usage = "";
PackageAppGet::usage = "";
PackageAppNeeds::usage = "";


PackageScopeBlock::usage = "";
PackageFERehideSymbols::usage = "Predeclared here...";
PackageDecontext::usage = "";
PackageRecontext::usage = "";


(* ::Subsubsection::Closed:: *)
(*Begin*)


Begin["`Loading`"]


(* ::Subsubsection::Closed:: *)
(*Constants*)


Geass["FileContexts"] := $PackageFileContexts;
If[Not@AssociationQ@$PackageFileContexts,
	$PackageFileContexts =
		<||>
];


Geass["DeclaredPackages"] := $DeclaredPackages;
If[Not@AssociationQ@$DeclaredPackages,
	$DeclaredPackages =
		<||>
];


Geass["LoadedPackages"] := $LoadedPackages;
If[Not@ListQ@$LoadedPackages,
	$LoadedPackages = {}
];


(* ::Subsubsection::Closed:: *)
(*PackageFileContext*)


PackageFileContextPath[f_String?DirectoryQ] :=
	FileNameSplit[FileNameDrop[f, FileNameDepth[$PackageDirectory] + 1]];
PackageFileContextPath[f_String?FileExistsQ] :=
	PackageFileContextPath[DirectoryName@f];


PackageFileContext[f_String?DirectoryQ] :=
	With[{s = PackageFileContextPath[f]},
		StringRiffle[Append[""]@Prepend[s, Geass], "`"]
	];
PackageFileContext[f_String?FileExistsQ] :=
	PackageFileContext[DirectoryName[f]];


(* ::Subsubsection::Closed:: *)
(*PackageExecute*)


PackageExecute[expr_] :=
	Internal`WithLocalSettings[
		Begin[$PackageContexts[[1]]];
		System`Private`NewContextPath@
			Prepend[
				$PackageContexts,
				"System`"
			];,
		expr,
		System`Private`RestoreContextPath[];
		End[];
	];
PackageExecute ~ SetAttributes ~ HoldFirst


(* ::Subsubsection::Closed:: *)
(*PackagePullDeclarations*)


PackagePullDeclarationsAction // Clear
PackagePullDeclarationsAction[
	Hold[
		_Begin | _BeginPackage |
			CompoundExpression[_Begin | _BeginPackage, ___]
	]
] :=
	Throw[Begin];
PackagePullDeclarationsAction[
	p :
		Hold[
			_PackageFEHiddenBlock | _PackageScopeBlock |
				CompoundExpression[
					_PackageFEHiddenBlock | _PackageScopeBlock,
					___]
		]
] /; TrueQ[$AllowPackageRescoping] :=
	(
		ReleaseHold[p];
		Sow[p];
	);
PackagePullDeclarationsAction[e : Except[Hold[Expression]]] :=
	Sow@e;


PackagePullDeclarations[pkgFile_] :=
	pkgFile ->
		Cases[
			Reap[
				With[{f = OpenRead[pkgFile]},
					Catch@
						Do[
							If[
								Length[
									ReadList[
										f,
										PackagePullDeclarationsAction@Hold[Expression],
										1
									]
								] === 0,
								Throw[EndOfFile]
							],
							Infinity
						];
					Close[f]
				]
			][[2, 1]],
			s_Symbol?(
				Function[Null,
					Quiet[Context[#] === $Context],
					HoldAllComplete
				]
			) :>
				HoldPattern[s],
			Infinity
		]


(* ::Subsubsection::Closed:: *)
(*PackageLoadPackage*)


PackageLoadPackage[heldSym_, context_, pkgFile_ -> syms_] :=
	Block[{
		$loadingChain =
			If[ListQ@$loadingChain, $loadingChain, {}],
		$inLoad = TrueQ[$inLoad]
	},
		Internal`WithLocalSettings[
			System`Private`NewContextPath@$ContextPath,
			If[!MemberQ[$loadingChain, pkgFile],
				AppendTo[$loadingChain, pkgFile];
				With[{$$inLoad = $inLoad},
					$inLoad = True;
					If[$AllowPackageRecoloring,
						Internal`SymbolList[False]
					];
					Replace[Thread[syms, HoldPattern],
						Verbatim[HoldPattern][{s__}] :> Clear[s]
					];
					If[Not@MemberQ[$ContextPath, context],
						$ContextPath = Prepend[$ContextPath, context];
					];
					Block[{PackageFEHiddenBlock = Null},
						PackageAppGet[context, pkgFile];
					];
					Unprotect[$LoadedPackages];
					AppendTo[$LoadedPackages, pkgFile];
					Protect[$LoadedPackages];
					If[!$$inLoad && $AllowPackageRecoloring,
						Internal`SymbolList[True]
					];
					ReleaseHold[heldSym]
				]
			],
			System`Private`RestoreContextPath[]
		]
	];


(* ::Subsubsection::Closed:: *)
(*PackageDeclarePackage*)


PackageDeclarePackage[pkgFile_ -> syms_] :=
	With[{c = $Context},
		$DeclaredPackages[pkgFile] = syms;
		$PackageFileContexts[pkgFile] = c;
		Map[
			If[True,
				# := PackageLoadPackage[#, c, pkgFile -> syms]
			]&,
			syms
		]
	];


(* ::Subsubsection::Closed:: *)
(*PackageLoadDeclare*)


PackageLoadDeclare[pkgFile_String] :=
	If[!MemberQ[$LoadedPackages, pkgFile],
		If[!KeyMemberQ[$DeclaredPackages, pkgFile],
			PackageDeclarePackage@
				PackagePullDeclarations[pkgFile]
		],
		PackageAppGet[pkgFile]
	];


(* ::Subsubsection::Closed:: *)
(*PackageAppLoad*)


Geass["Load", args___] :=
	PackageAppLoad[args]


packageAppLoad[dir_, listing_] :=
	With[
		{
			fileNames =
				Select[
					FileNames["*", dir],
					DirectoryQ@# || MatchQ[FileExtension[#], "m" | "wl"]&
				]
		},
		Replace[
			Select[fileNames,
				StringMatchQ[
					ToLowerCase@FileNameTake[#],
					"__pre__." ~~ ("m" | "wl")
				]&
			],
			{f_} :> Get[f]
		];
		PackageAppLoad[
			$PackageListing[listing] =
				Select[fileNames, StringFreeQ["__"]@*FileBaseName]
		];
		Replace[
			Select[fileNames,
				StringMatchQ[
					ToLowerCase@FileNameTake[#],
					"__post__." ~~ ("m" | "wl")
				]&
			],
			{f_} :> Get[f]
		];
	];


PackageAppLoad[dir_String?DirectoryQ] :=
	If[StringMatchQ[FileBaseName@dir, (WordCharacter | "$")..],
		Internal`WithLocalSettings[
			Begin["`" <> FileBaseName[dir] <> "`"],
			AppendTo[$PackageContexts, $Context];
			packageAppLoad[dir, FileNameDrop[dir, FileNameDepth[$PackageDirectory] + 1]],
			End[];
		]
	];
PackageAppLoad[file_String?FileExistsQ] :=
	PackageLoadDeclare[file];
PackageAppLoad[] :=
	PackageExecute@
		packageAppLoad[
			FileNameJoin@{$PackageDirectory, $PackagePackagesDirectory},
			$PackageName
		];
PackageAppLoad ~ SetAttributes ~ Listable;


(* ::Subsubsection::Closed:: *)
(*PackageAppGet*)


Geass["Get", f__] :=
	PackageAppGet[f];
PackageAppGet[f_] :=
	PackageExecute@
		With[{fBase =
			If[FileExistsQ@f,
				f,
				PackageFilePath[$PackagePackagesDirectory, f <> ".m"]
			]
		},
			With[{cont =
				Most@
					FileNameSplit[
						FileNameDrop[fBase,
							FileNameDepth[PackageFilePath[$PackagePackagesDirectory]]
						]
					]},
				If[Length[cont] > 0,
					Begin[StringRiffle[Append[""]@Prepend[""]@cont, "`"]];
					(End[];#)&@Get[fBase],
					Get[fBase]
				]
			]
		];
PackageAppGet[c_, f_] :=
	PackageExecute[
		Begin[c];
		(End[];#)&@
			If[FileExistsQ@f,
				Get@f;,
				Get@PackageFilePath[$PackagePackagesDirectory, f <> ".m"]
			]
	];


(* ::Subsubsection::Closed:: *)
(*PackageAppNeeds*)


Geass["Needs", f___] :=
	PackageAppNeeds[f];


PackageAppNeeds[pkgFile_String?FileExistsQ] :=
	If[!MemberQ[$LoadedPackages, pkgFile],
		If[KeyMemberQ[$DeclaredPackages, pkgFile],
			PackageLoadDeclare[pkgFile],
			Do[PackageLoadDeclare[pkgFile], 2]
		];
	];


PackageAppNeeds[pkg_String] :=
	If[FileExistsQ@PackageFilePath[$PackagePackagesDirectory, pkg <> ".m"],
		PackageAppNeeds[PackageFilePath[$PackagePackagesDirectory, pkg <> ".m"]],
		$Failed
	];


(* ::Subsubsection::Closed:: *)
(*PackageScopeBlock*)


$PackageScopeBlockEvalExpr = TrueQ[$PackageScopeBlockEvalExpr];
PackageScopeBlock[
	e_,
	scope : _String?(StringFreeQ["`"]) : "Package",
	context : _String?(StringEndsQ["`"]) : "`PackageScope`"
] /; TrueQ[$AllowPackageRescoping] :=
	With[{
		newcont =
			If[StringStartsQ[context, "`"],
				"Geass" <> context <> scope <> "`",
				context <> scope <> "`"
			],
		res = If[$PackageScopeBlockEvalExpr, e]
	},
		If[!MemberQ[$PackageContexts, newcont],
			Unprotect[$PackageContexts];
			AppendTo[$PackageContexts, newcont];
		];
		Replace[
			Thread[
				Cases[
					HoldComplete[e],
					sym_Symbol?(
						Function[Null,
							MemberQ[$PackageContexts, Quiet[Context[#]]],
							HoldAllComplete
						]
					) :>
						HoldComplete[sym],
					\[Infinity]
				],
				HoldComplete
			],
			HoldComplete[{s__}] :>
				If[!$PackageDeclared && ListQ@$PackageScopedSymbols,
					$PackageScopedSymbols =
						{
							$PackageScopedSymbols,
							newcont ->
								HoldComplete[s]
						},
					Block[{$AllowPackageRecoloring = True},
						PackageFERehideSymbols[s]
					];
					Map[
						Function[Null,
							Quiet[
								Check[
									Set[Context[#], newcont],
									Remove[#],
									Context::cxdup
								],
								Context::cxdup
							],
							HoldAllComplete
						],
						HoldComplete[s]
					] // ReleaseHold;
				]
		];
		res
	];
PackageScopeBlock[e_, scope_String : "Package"] /; Not@TrueQ[$AllowPackageRescoping] :=
	If[$PackageScopeBlockEvalExpr, e];
PackageScopeBlock ~ SetAttributes ~ HoldFirst;


(* ::Subsubsection::Closed:: *)
(*PackageDecontext*)


PackageDecontext[
	pkgFile_String?(KeyMemberQ[$DeclaredPackages, #]&),
	scope : _String?(StringFreeQ["`"]) : "Package",
	context : _String?(StringEndsQ["`"]) : "`PackageScope`"
] /; TrueQ[$AllowPackageRescoping] :=
	With[{
		names = $DeclaredPackages[pkgFile],
		ctx =
			If[StringStartsQ[context, "`"],
				"Geass" <> context <> scope <> "`",
				context <> scope <> "`"
			]
	},
		Replace[names,
			Verbatim[HoldPattern][s_] :>
				Set[Context[s], ctx],
			1
		]
	];


(* ::Subsubsection::Closed:: *)
(*PackageRecontext*)


PackageRecontext[
	pkgFile_String?(KeyMemberQ[$DeclaredPackages, #]&)
] /; TrueQ[$AllowPackageRescoping] :=
	With[{
		names = $DeclaredPackages[pkgFile],
		ctx = PackageFileContext[pkgFile]
	},
		Replace[names,
			Verbatim[HoldPattern][s_] :>
				Set[Context[s], ctx],
			1
		]
	];


(* ::Subsubsection::Closed:: *)
(*End*)


End[]
(* ::Subsection:: *)
(*Dependencies*)


Geass::nodep = "Couldn't load dependency `` of type ``";
Geass::nodup = "Couldn't update dependency `` of type ``";


PackageExtendContextPath::usage = "";
PackageInstallPackageDependency::usage = "";
PackageLoadPackageDependency::usage = "";
PackageCheckPacletDependency::usage = "";
PackageInstallPacletDependency::usage = "";
PackageLoadPacletDependency::usage = "";
PackageUpdatePacletDependency::usage = "";
PackageLoadResourceDependency::usage = "";


(* ::Subsubsection::Closed:: *)
(*Begin*)


Begin["`Dependencies`"];


(* ::Subsubsection::Closed:: *)
(*PackageExtendContextPath*)


PackageExtendContextPath[cp : {__String}] :=
	(
		Unprotect[$PackageContexts];
		$PackageContexts =
			DeleteCases[
				DeleteDuplicates@
					Join[$PackageContexts, cp],
				"System`" | "Global`"
			];
	(* Should I protect it again? *)
	)


(* ::Subsubsection::Closed:: *)
(*PackageInstallPackageDependency*)


Options[PackageInstallPackageDependency] =
	{
		"Permanent" -> False
	};
PackageInstallPackageDependency[dep_String, ops : OptionsPattern[]] :=
	Block[{retcode, site, path, file, tmp},
		path =
			StringSplit[StringTrim[dep, "`"] <> If[FileExtension[dep] == "", ".m", ""], "`"];
		site =
			Replace[OptionValue["Site"],
				{
					s_String?(
						URLParse[#, "Domain"] === "github.com"&
					) :>
						URLBuild@
							<|
								"Scheme" -> "http",
								"Domain" -> "raw.githubusercontent.com",
								"Path" ->
									Function[If[Length[#] == 2, Append[#, "master"], #]]@
										DeleteCases[""]@URLParse[s, "Path"]
							|>,
					_ ->
						"http://raw.githubusercontent.com/paclets/PackageServer/master/Listing"
				}
			];
		file =
			If[TrueQ@OptionValue["Permanent"],
				FileNameJoin@{$UserBaseDirectory, "Applications", Last@path},
				FileNameJoin@{$TemporaryDirectory, "Applications", Last@path}
			];
		tmp = CreateFile[];
		Monitor[
			retcode = URLDownload[URLBuild[Prepend[site], path], tmp, "StatusCode"],
			Internal`LoadingPanel[
				TemplateApply[
					"Loading package `` from site ``",
					{URLBuild@path, site}
				]
			]
		];
		If[retcode < 300,
			CopyFile[tmp, file,
				OverwriteTarget -> Not@TrueQ@OptionValue["Permanent"]
			];
			DeleteFile[tmp];
			file,
			Message[Geass::nodep, dep, "Package"];
			DeleteFile[tmp];
			$Failed
		]
	];


(* ::Subsubsection::Closed:: *)
(*PackageLoadPackageDependency*)


Options[PackageLoadPackageDependency] =
	Options[PackageInstallPackageDependency];
PackageLoadPackageDependency[dep_String, ops : OptionsPattern[]] :=
	Internal`WithLocalSettings[
		BeginPackage[dep];,
		If[Quiet@Check[Needs[dep], $Failed] === $Failed &&
			Quiet@Check[
				Get[FileNameJoin @@
					StringSplit[
						StringTrim[dep, "`"] <> If[FileExtension[dep] == "", ".m", ""],
						"`"
					]
				],
				$Failed] === $Failed,
			Replace[PackageInstallPacletDependency[dep, ops],
				f : _String | _File :> Get[f]
			]
		];
		PackageExtendContextPath@
			Select[$Packages, StringStartsQ[dep]];,
		EndPackage[];
	]


(* ::Subsubsection::Closed:: *)
(*PackageCheckPacletDependency*)


PackageCheckPacletDependency[dep_] :=
	Length@PacletManager`PacletFind[StringDelete[dep, "`"]] > 0


(* ::Subsubsection::Closed:: *)
(*PackageInstallPacletDependency*)


Options[PackageInstallPacletDependency] =
	Options[PacletManager`PacletInstall];
PackageInstallPacletDependency[
	deps : {__String?(
		StringMatchQ[
			(LetterCharacter | "_" | "`") ~~ (WordCharacter | "_" | "`")..
		]
	)},
	ops : OptionsPattern[]
] :=
	Block[{site, pacs, pac},
		pacs =
			StringDelete[deps, "`"];
		site =
			Replace[OptionValue["Site"],
				{
					s_String?(
						URLParse[#, "Domain"] === "github.com"&
					) :>
						URLBuild@
							<|
								"Scheme" -> "http",
								"Domain" -> "raw.githubusercontent.com",
								"Path" ->
									Function[If[Length[#] == 2, Append[#, "master"], #]]@
										DeleteCases[""]@URLParse[s, "Path"]
							|>,
					None ->
						Automatic,
					_ ->
						"http://raw.githubusercontent.com/paclets/PacletServer/master"
				}
			];
		pac = First@pacs;
		Monitor[
			MapThread[
				Check[
					PacletManager`PacletInstall[
						pac = #,
						"Site" -> site,
						ops
					],
					Message[Geass::nodep, #2, "Paclet"];
					$Failed
				]&,
				{
					pacs,
					deps
				}
			],
			Internal`LoadingPanel[
				TemplateApply[
					"Loading paclet `` from site ``",
					{pac, site}
				]
			]
		]
	]


PackageInstallPacletDependency[
	dep : _String?(
		StringMatchQ[
			(LetterCharacter | "_" | "`") ~~ (WordCharacter | "_" | "`")..
		]
	),
	ops : OptionsPattern[]
] := First@PackageInstallPacletDependency[{dep}, ops]


(* ::Subsubsection::Closed:: *)
(*PackageLoadPacletDependency*)


Options[PackageLoadPacletDependency] =
	Join[
		Options[PackageInstallPacletDependency],
		{
			"Update" -> False
		}
	];
PackageLoadPacletDependency[dep_String?(StringEndsQ["`"]), ops : OptionsPattern[]] :=
	Internal`WithLocalSettings[
		System`Private`NewContextPath[{dep, "System`"}];,
		If[PackageCheckPacletDependency[dep],
			If[TrueQ@OptionValue["Update"],
				PackageUpdatePacletDependency[dep,
					"Sites" -> Replace[OptionValue["Site"], s_String :> {s}]
				]
			],
			PackageInstallPacletDependency[dep, ops]
		];
		Needs[dep];
		PackageExtendContextPath@
			Select[$Packages,
				StringStartsQ[#, dep] && StringFreeQ[#, "`Private`"]&
			];,
		System`Private`RestoreContextPath[];
	]


(* ::Subsubsection::Closed:: *)
(*PackageUpdatePacletDependency*)


Options[PackageUpdatePacletDependency] =
	{
		"Sites" -> Automatic
	};
PackageUpdatePacletDependency[
	deps : {__String?(StringMatchQ[(LetterCharacter | "_") ~~ (WordCharacter | "_")..])},
	ops : OptionsPattern[]
] :=
	Block[
		{
			added = <||>,
			ps = PacletManager`PacletSites[],
			pac
		},
		Replace[
			Replace[OptionValue["Sites"],
				Automatic :> "http://raw.githubusercontent.com/paclets/PacletServer/master"
			],
			{
				s_String :>
					If[!MemberQ[ps, PacletManager`PacletSite[s, ___]],
						added[s] = True
					],
				p : PacletManager`PacletSite[__] :>
					If[!MemberQ[ps, p],
						added[p] = True
					]
			},
			1
		];
		pac = StringDelete[deps[[1]], "`"];
		Internal`WithLocalSettings[
			KeyMap[PacletManager`PacletSiteAdd, added],
			Monitor[
				MapThread[
					Check[
						PacletManager`PacletCheckUpdate[pac = #],
						Message[Geass::nodup, #2, "Paclet"];
						$Failed
					]&,
					{
						StringDelete[deps, "`"],
						deps
					}
				],
				Internal`LoadingPanel[
					"Updating paclet ``" ~ TemplateApply ~ pac
				]
			],
			KeyMap[PacletManager`PacletSiteRemove, added]
		]
	];


PackageUpdatePacletDependency[
	dep : _String?(StringMatchQ[(LetterCharacter | "_") ~~ (WordCharacter | "_")..]),
	ops : OptionsPattern[]
] :=
	First@PackageUpdatePacletDependency[{dep}, ops]


(* ::Subsubsection::Closed:: *)
(*PackageLoadResourceDependency*)


(* ::Text:: *)
(*Nothing I've implemented yet, but could be very useful for installing resources for a paclet*)


(* ::Subsubsection:: *)
(*End*)


End[]
(* ::Subsection:: *)
(*Exceptions*)


$PackageExceptionTag::usage = "";
PackageExceptionBlock::usage = "";


PackageThrowException::usage = "";
PackageCatchException::usage = "";
PackageCatchExceptionCallback::usage = "";


PackageThrowMessage::usage = "";
PackageCatchMessage::usage = "";


PackageFailureException::usage = "";
PackageRaiseException::usage = "";


(* ::Subsubsection::Closed:: *)
(*Begin*)


Begin["`Exceptions`Private`"]


(* ::Subsubsection::Closed:: *)
(*PackageThrowException*)


PackageThrowException[value : Except[_Failure], tag : _String : "Failure"] :=
	Throw[value, $PackageName <> tag];
PackageThrowException[f_Failure] :=
	Throw[f, f[[1]]];


(* ::Subsubsection::Closed:: *)
(*PackageCatchException*)


$PackageCatchCallback = (#&);


PackageCatchExceptionHandler[tag_] :=
	$PackageCatchCallback;


PackageCatchException[
	expr : Except[_String],
	tag : _String : "Failure",
	callback_ : Automatic
] :=
	Catch[expr,
		$PackageName <> tag,
		Replace[callback, Automatic :> PackageCatchExceptionHandler[tag]]
	];
PackageCatchException[tag_String, callback_ : Automatic] :=
	Function[Null,
		PackageCatchException[#, tag, callback],
		HoldFirst
	];
PackageCatchException ~ SetAttributes ~ HoldFirst


(* ::Subsubsection::Closed:: *)
(*PackageThrowMessage*)


$PackageErrorMessage =
	"Geass encountered exception ``";


Options[PackageThrowMessage] =
	{
		"MessageParameters" :> {}
	};
PackageThrowMessage[
	msg_MessageName,
	body : _?StringQ,
	ops : OptionsPattern[]
] :=
	(
		Set[msg, body];
		Message[msg, Sequence @@ OptionValue["MessageParameters"]]
	);
PackageThrowMessage[
	tag_?StringQ,
	body_String,
	ops : OptionsPattern[]
] :=
	PackageThrowMessage[
		MessageName[Geass, tag],
		body,
		ops
	];
PackageThrowMessage[
	tag_?StringQ
] :=
	PackageThrowMessage[
		MessageName[Geass, tag],
		$PackageErrorMessage,
		"MessageParameters" -> {tag}
	];
PackageThrowMessage ~ SetAttributes ~ HoldAll


(* ::Subsubsection::Closed:: *)
(*PackageCatchMessage*)


$PackageCatchMessageMessage =
	"Check caught exceptions ``";


$PackageCatchMessageCallback =
	Function[
		PackageRaiseException[
			"Check",
			$PackageCatchMessageMessage,
			"MessageParameters" -> Thread[HoldForm[$MessageList]]
		]
	];


PackageCatchMessage[
	expr_,
	failexpr_ : Automatic,
	msg : {___String} : {}
] :=
	Replace[
		Thread[Map[Hold[MessageName[Geass, #]]&, msg], Hold],
		{
			{} :>
				Check[expr,
					Replace[failexpr, {Automatic :> $PackageCatchMessageCallback[]}]
				],
			Hold[msgs_] :>
				Check[expr,
					Replace[failexpr, {Automatic :> $PackageCatchMessageCallback[]}],
					msgs
				],
			_ :>
				Replace[failexpr, {Automatic :> $PackageCatchMessageCallback[]}]
		}
	];
PackageCatchMessage ~ SetAttributes ~ HoldAll;


(* ::Subsubsection::Closed:: *)
(*PackageFailureException*)


Options[PackageFailureException] =
	Options[PackageThrowMessage];
PackageFailureException[
	msg_MessageName,
	body_?StringQ,
	ops : OptionsPattern[]
] :=
	Replace[
		OptionValue[Automatic, Automatic, "MessageParameters", Hold],
		Hold[params_] :>
			Failure[
				$PackageName <> Hold[msg][[1, 2]],
				<|
					"MessageTemplate" :>
						msg,
					"MessageParameters" :>
						params
				|>
			]
	];
PackageFailureException[
	tag : _?StringQ : "Exception",
	body_?StringQ,
	ops : OptionsPattern[]
] :=
	(
		Set[MessageName[Geass, tag], body];
		PackageFailureException[
			MessageName[Geass, tag],
			body,
			ops
		]
	);
PackageFailureException ~ SetAttributes ~ HoldFirst


(* ::Subsubsection::Closed:: *)
(*PackageRaiseException*)


PackageRaiseException // Clear;
Options[PackageRaiseException] =
	Options[PackageFailureException]
PackageRaiseException[
	msg_MessageName,
	body_?StringQ,
	ops : OptionsPattern[]
] :=
	(
		PackageThrowMessage[msg, body,
			Evaluate@FilterRules[{ops}, Options[PackageThrowMessage]]
		];
		PackageThrowException[
			PackageFailureException[msg, body, ops]
		]
	);
PackageRaiseException[
	tag_?StringQ,
	body_?StringQ,
	ops : OptionsPattern[]
] :=
	PackageRaiseException[
		MessageName[Geass, tag],
		body,
		ops
	];
PackageRaiseException[
	tag : _?(StringQ[#] && StringMatchQ[#, WordCharacter..]&),
	ops : OptionsPattern[]
] :=
	PackageRaiseException[
		tag,
		$PackageErrorMessage,
		{
			ops,
			"MessageParameters" -> {tag}
		}
	];
PackageRaiseException[
	Optional[Automatic, Automatic],
	body : _?StringQ,
	ops : OptionsPattern[]
] :=
	PackageRaiseException[
		Evaluate@$PackageExceptionTag,
		body,
		ops
	];
PackageRaiseException[
	tag : Automatic | _String,
	body_String,
	args : __?(Not@*OptionQ)
] :=
	PackageRaiseException[tag, body, "MessageParameters" -> {args}];
PackageRaiseException ~ SetAttributes ~ HoldFirst


(* ::Subsubsection::Closed:: *)
(*PackageExceptionBlock*)


$PackageExceptionStack = {};
Protect[$PackageExceptionStack];


$PackageExceptionTag = "Failure";


PackageExceptionBlock // Clear
(*PackageExceptionBlock/:
  HoldPattern[
    SetDelayed[lhs_, 
      peb:PackageExceptionBlock[_, _String]
      ]
    ]:=
  SetDelayed[lhs,
    Block[{$PackageExceptionBlockResult},
      $PackageExceptionBlockResult=peb;
      peb/;!FailureQ@peb
      ]
    ];*)
PackageExceptionBlock[
	expr_,
	tag : _String
] :=
	Block[
		{
			$PackageExceptionTag = tag,
			$PackageExceptionStack =
				Append[$PackageExceptionStack, tag],
			result
		},
		result = PackageCatchException[expr, tag, #&];
		If[MatchQ[result, Failure[_String?(StringEndsQ[tag]), _]] &&
			MemberQ[Most@$PackageExceptionStack, tag],
			PackageThrowException[result]
		];
		result(*/;!FailureQ@result*)
	];
PackageExceptionBlock[tag_String] :=
	Function[Null, PackageExceptionBlock[#, tag], HoldFirst];
PackageExceptionBlock[Optional[Automatic, Automatic]] :=
	Function[Null, PackageExceptionBlock[#, $PackageExceptionTag], HoldFirst];
PackageExceptionBlock ~ SetAttributes ~ HoldFirst;


(* ::Subsubsection::Closed:: *)
(*End*)


End[]
(* ::Subsection:: *)
(*Autocompletion*)


PackageAddAutocompletions::usage = "";


(* ::Subsubsection::Closed:: *)
(*Begin*)


Begin["`Autocomplete`"];


(* ::Subsubsection::Closed:: *)
(*Formats*)


$PackageAutoCompletionFormats =
	Alternatives @@ Join @@ {
		Range[0, 9],
		{
			_String?(FileExtension[#] === "trie"&),
			{
				_String | (Alternatives @@ Range[0, 9]) | {__String},
				(("URI" | "DependsOnArgument") -> _)...
			},
			{
				_String | (Alternatives @@ Range[0, 9]) | {__String},
				(("URI" | "DependsOnArgument") -> _)...,
				(_String | (Alternatives @@ Range[0, 9]) | {__String})
			},
			{
				__String
			}
		},
		{
			"codingNoteFontCom",
			"ConvertersPath",
			"ExternalDataCharacterEncoding",
			"MenuListCellTags",
			"MenuListConvertFormatTypes",
			"MenuListDisplayAsFormatTypes",
			"MenuListFonts",
			"MenuListGlobalEvaluators",
			"MenuListHelpWindows",
			"MenuListNotebookEvaluators",
			"MenuListNotebooksMenu",
			"MenuListPackageWindows",
			"MenuListPalettesMenu",
			"MenuListPaletteWindows",
			"MenuListPlayerWindows",
			"MenuListPrintingStyleEnvironments",
			"MenuListQuitEvaluators",
			"MenuListScreenStyleEnvironments",
			"MenuListStartEvaluators",
			"MenuListStyleDefinitions",
			"MenuListStyles",
			"MenuListStylesheetWindows",
			"MenuListTextWindows",
			"MenuListWindows",
			"PrintingStyleEnvironment",
			"ScreenStyleEnvironment",
			"Style"
		}
	};


(* ::Subsubsection::Closed:: *)
(*AddAutocompletions Base*)


PackageAddAutocompletions[pats : {(_String -> {$PackageAutoCompletionFormats..})..}] /;
	TrueQ[$AllowPackageAutocompletions] :=
	If[$Notebooks &&
		Internal`CachedSystemInformation["FrontEnd", "VersionNumber"] > 10.0,
		FrontEndExecute@FrontEnd`Value@
			Map[
				FEPrivate`AddSpecialArgCompletion[#]&,
				pats
			],
		$Failed
	];
PackageAddAutocompletions[pat : (_String -> {$PackageAutoCompletionFormats..})] /;
	TrueQ[$AllowPackageAutocompletions] :=
	PackageAddAutocompletions[{pat}];


(* ::Subsubsection::Closed:: *)
(*AddAutocompletions Helpers*)


$PackageAutocompletionAliases =
	{
		"None" | None | Normal -> 0,
		"AbsoluteFileName" | AbsoluteFileName -> 2,
		"FileName" | File | FileName -> 3,
		"Color" | RGBColor | Hue | XYZColor -> 4,
		"Package" | Package -> 7,
		"Directory" | Directory -> 8,
		"Interpreter" | Interpreter -> 9,
		"Notebook" | Notebook -> "MenuListNotebooksMenu",
		"StyleSheet" -> "MenuListStylesheetMenu",
		"Palette" -> "MenuListPalettesMenu",
		"Evaluator" | Evaluator -> "MenuListGlobalEvaluators",
		"FontFamily" | FontFamily -> "MenuListFonts",
		"CellTag" | CellTags -> "MenuListCellTags",
		"FormatType" | FormatType -> "MenuListDisplayAsFormatTypes",
		"ConvertFormatType" -> "MenuListConvertFormatTypes",
		"DisplayAsFormatType" -> "MenuListDisplayAsFormatTypes",
		"GlobalEvaluator" -> "MenuListGlobalEvaluators",
		"HelpWindow" -> "MenuListHelpWindows",
		"NotebookEvaluator" -> "MenuListNotebookEvaluators",
		"PrintingStyleEnvironment" | PrintingStyleEnvironment ->
			"PrintingStyleEnvironment",
		"ScreenStyleEnvironment" | ScreenStyleEnvironment ->
			ScreenStyleEnvironment,
		"QuitEvaluator" -> "MenuListQuitEvaluators",
		"StartEvaluator" -> "MenuListStartEvaluators",
		"StyleDefinitions" | StyleDefinitions ->
			"MenuListStyleDefinitions",
		"CharacterEncoding" | CharacterEncoding |
			ExternalDataCharacterEncoding ->
			"ExternalDataCharacterEncoding",
		"Style" | Style -> "Style",
		"Window" -> "MenuListWindows"
	};


(* ::Subsubsection::Closed:: *)
(*AddAutocompletions Convenience*)


$PackageAutocompletionTable = {
	f : $PackageAutoCompletionFormats :> f,
	Sequence @@ $PackageAutocompletionAliases,
	s_String :> {s}
};


PackageAddAutocompletions[o : {__Rule}] /; (
	TrueQ[$AllowPackageAutocompletions] && !TrueQ@$recursionProtect
) :=
	Block[{$recursionProtect = True},
		Replace[
			PackageAddAutocompletions@
				Replace[o,
					(s_ -> v_) :>
						(Replace[s, _Symbol :> SymbolName[s]] ->
							Replace[
								Flatten[{v}, 1],
								$PackageAutocompletionTable,
								1
							]),
					1
				],
			_PackageAddAutocompletions -> $Failed
		]
	];
PackageAddAutocompletions[s : Except[_List], v_] /; TrueQ[$AllowPackageAutocompletions] :=
	PackageAddAutocompletions[{s -> v}];
PackageAddAutocompletions[l_, v_] /; TrueQ[$AllowPackageAutocompletions] :=
	PackageAddAutocompletions@
		Flatten@{
			Quiet@
				Check[
					Thread[l -> v],
					Map[l -> #&, v]
				]
		};


(*PackageAddAutocompletions[PackageAddAutocompletions,
  {None,
    Join[
      Replace[Keys[$PackageAutocompletionAliases],
        Verbatim[Alternatives][s_,___]:>s,
        1
        ],
      {FileName,AbsoluteFileName}/.$PackageAutocompletionAliases
      ]
    }
  ]*)


(* ::Subsubsection::Closed:: *)
(* PackageSetAutocompletionData *)


PackageSetAutocompletionData[] :=
	If[DirectoryQ@
		FileNameJoin@{
			$PackageDirectory,
			"Resources",
			"FunctionalFrequency"
		},
		CurrentValue[
			$FrontEndSession,
			{PrivatePaths, "AutoCompletionData"}
		] =
			DeleteDuplicates@
				Append[
					CurrentValue[
						$FrontEndSession,
						{PrivatePaths, "AutoCompletionData"}
					],
					FileNameJoin@{
						$PackageDirectory,
						"Resources",
						"FunctionalFrequency"
					}
				]
	];


(* ::Subsubsection::Closed:: *)
(*End*)


End[]
(* ::Subsection:: *)
(*FrontEnd*)


PackageFEHiddenBlock::usage = "";
PackageFEUnhideSymbols::usage = "";
PackageFERehideSymbols::usage = "";
PackageFEUnhidePackage::usage = "";
PackageFERehidePackage::usage = "";


(* ::Subsubsection::Closed:: *)
(*Begin*)


Begin["`FrontEnd`"]


(* ::Subsubsection::Closed:: *)
(*PackageFEInstallStylesheets *)


PackageFEInstallStylesheets[] :=
	With[{
		base =
			FileNameJoin@{
				$PackageDirectory,
				"FrontEnd",
				"StyleSheets",
				$PackageName
			},
		target =
			FileNameJoin@{
				$UserBaseDirectory,
				"SystemFiles",
				"FrontEnd",
				"StyleSheets",
				$PackageName}
	},
		If[DirectoryQ@base,
			Do[
				Quiet@
					CreateFile[
						FileNameJoin@{
							target,
							FileNameDrop[f, FileNameDepth[base]]
						},
						CreateIntermediateDirectories -> True
					];
				CopyFile[f,
					FileNameJoin@{
						target,
						FileNameDrop[f, FileNameDepth[base]]
					},
					OverwriteTarget -> True],
				{f, FileNames["*.nb", base, \[Infinity]]}
			]
		]
	];


(* ::Subsubsection::Closed:: *)
(*PackageFEInstallPalettes *)


PackageFEInstallPalettes[] :=
	With[{
		base =
			FileNameJoin@{
				$PackageDirectory,
				"FrontEnd",
				"Palettes",
				$PackageName
			},
		target =
			FileNameJoin@{
				$UserBaseDirectory,
				"SystemFiles",
				"FrontEnd",
				"Palettes",
				$PackageName}
	},
		If[DirectoryQ@base,
			Do[
				Quiet@
					CreateFile[
						FileNameJoin@{
							target,
							FileNameDrop[f, FileNameDepth[base]]
						},
						CreateIntermediateDirectories -> True
					];
				CopyFile[f,
					FileNameJoin@{
						target,
						FileNameDrop[f, FileNameDepth[base]]
					},
					OverwriteTarget -> True],
				{f, FileNames["*.nb", base, \[Infinity]]}
			]
		]
	];


(* ::Subsubsection::Closed:: *)
(*PackageFEHiddenBlock*)


$PackageFEHideExprSymbols = TrueQ[$PackageFEHideExprSymbols];
$PackageFEHideEvalExpr = TrueQ[$PackageFEHideEvalExpr];
PackageFEHiddenBlock[expr_,
	hide : True | False | Automatic : Automatic,
	eval : True | False | Automatic : Automatic
] /; TrueQ[$AllowPackageRecoloring] :=
	If[!$PackageDeclared && ListQ@$PackageFEHiddenSymbols,
		With[{
			s =
				Cases[
					HoldComplete[expr],
					sym_Symbol?(
						Function[Null,
							MemberQ[$PackageContexts, Quiet[Context[#]]],
							HoldAllComplete
						]
					) :>
						HoldPattern[sym],
					\[Infinity]
				]
		},
			$PackageFEHiddenSymbols =
				{
					$PackageFEHiddenSymbols,
					s
				}
		],
		Block[{feBlockReturn},
			Internal`SymbolList[False];
			feBlockReturn = If[Replace[eval, Automatic :> $PackageFEHideEvalExpr], expr];
			If[Replace[hide, Automatic :> $PackageFEHideExprSymbols],
				With[{
					s =
						Cases[
							HoldComplete[expr],
							sym_Symbol?(
								Function[Null,
									MemberQ[$PackageContexts, Quiet[Context[#]]],
									HoldAllComplete
								]
							) :>
								HoldPattern[sym],
							\[Infinity]
						]
				},
					Replace[Thread[s, HoldPattern],
						Verbatim[HoldPattern][{sym__}] :>
							PackageFERehideSymbols[sym]
					]
				]
			];
			Internal`SymbolList[True];
			feBlockReturn
		]
	];
PackageFEHiddenBlock[expr_,
	hide : True | False | Automatic : Automatic,
	eval : True | False | Automatic : Automatic
] /; Not@TrueQ[$AllowPackageRecoloring] :=
	If[eval, expr];
PackageFEHiddenBlock ~ SetAttributes ~ HoldFirst


(* ::Subsubsection::Closed:: *)
(*PackageFEUnhideSymbols*)


PackageFEUnhideSymbols[syms__Symbol,
	cpath : {__String} | Automatic : Automatic,
	mode : "Update" | "Set" : "Update"
] /; TrueQ[$AllowPackageRecoloring] :=
	With[{stuff =
		Map[
			Function[Null,
				{Context@#, SymbolName@Unevaluated@#},
				HoldAllComplete],
			HoldComplete[syms]
		] // Apply[List]
	},
		KeyValueMap[
			FrontEndExecute@
				If[mode === "Update",
					FrontEnd`UpdateKernelSymbolContexts,
					FrontEnd`SetKernelSymbolContexts
				][
					#,
					Replace[cpath, Automatic -> $ContextPath],
					{{#, {}, {}, #2, {}}}
				]&,
			GroupBy[stuff, First -> Last]
		];
	];
PackageFEUnhideSymbols[names_String,
	mode : "Update" | "Set" : "Update"] /; TrueQ[$AllowPackageRecoloring] :=
	Replace[
		Thread[ToExpression[Names@names, StandardForm, Hold], Hold],
		Hold[{s__}] :> PackageFEUnhideSymbols[s, mode]
	];
PackageFEUnhideSymbols ~ SetAttributes ~ HoldAllComplete;


(* ::Subsubsection::Closed:: *)
(*PackageFERehideSymbols*)


PackageFERehideSymbols[syms__Symbol,
	cpath : {__String} | Automatic : Automatic,
	mode : "Update" | "Set" : "Update"] /; TrueQ[$AllowPackageRecoloring] :=
	With[{stuff =
		Map[
			Function[Null,
				{Context@#, SymbolName@Unevaluated@#},
				HoldAllComplete],
			HoldComplete[syms]
		] // Apply[List]
	},
		KeyValueMap[
			FrontEndExecute@
				If[mode === "Update",
					FrontEnd`UpdateKernelSymbolContexts,
					FrontEnd`SetKernelSymbolContexts
				][
					#,
					Replace[cpath,
						Automatic -> $ContextPath
					],
					{{#, {}, #2, {}, {}}}
				]&,
			GroupBy[stuff, First -> Last]
		];
	];
PackageFERehideSymbols[names_String,
	mode : "Update" | "Set" : "Update"] /; TrueQ[$AllowPackageRecoloring] :=
	Replace[
		Thread[ToExpression[Names@names, StandardForm, Hold], Hold],
		Hold[{s__}] :> PackageFERehideSymbols[s, mode]
	];
PackageFERehideSymbols ~ SetAttributes ~ HoldAllComplete;


(* ::Subsubsection::Closed:: *)
(*PackageFEUnhidePackage*)


PackageFEUnhidePackage[
	package_String?FileExistsQ,
	a___
] /; TrueQ[$AllowPackageRecoloring] :=
	Replace[Thread[Lookup[$DeclaredPackages, package, {}], HoldPattern],
		Verbatim[HoldPattern][{syms__}] :>
			PackageFEUnhideSymbols[syms, a]
	];
PackageFEUnhidePackage[spec : _String | _List, a___] /; TrueQ[$AllowPackageRecoloring] :=
	PackageFEUnhidePackage[PackageFilePath@Flatten@{"Packages", spec}, a];


(* ::Subsubsection::Closed:: *)
(*PackageFERehidePackage*)


PackageFERehidePackage[
	package_String?FileExistsQ,
	a___
] /; TrueQ[$AllowPackageRecoloring] :=
	Replace[Thread[Lookup[$DeclaredPackages, package, {}], HoldPattern],
		Verbatim[HoldPattern][{syms__}] :>
			PackageFERehideSymbols[syms, a]
	];
PackageFERehidePackage[spec : _String | _List, a___] /; TrueQ[$AllowPackageRecoloring] :=
	PackageFERehidePackage[PackageFilePath@Flatten@{"Packages", spec}, a];


(* ::Subsubsection::Closed:: *)
(*End*)


End[]


(* ::Subsection:: *)
(*Post-Processing*)


PackagePostProcessPrepSpecs::usage = "";
PackagePrepPackageSymbol::usage = "";
PackagePostProcessExposePackages::usage = "";
PackagePostProcessRehidePackages::usage = "";
PackagePostProcessDecontextPackages::usage = "";
PackagePostProcessContextPathReassign::usage = "";
PackageAttachMainAutocomplete::usage = "";
PackagePreemptShadowing::usage = "";


Begin["`PostProcess`"];


(* ::Subsubsection::Closed:: *)
(*PrepFileName*)


PackagePostProcessFileNamePrep[fn_] :=
	Replace[
		FileNameSplit@
			FileNameDrop[fn,
				FileNameDepth@
					PackageFilePath["Packages"]
			], {
		{f_} :>
			f | fn | StringTrim[f, ".m" | ".wl"],
		{p__, f_} :>
			FileNameJoin@{p, f} | fn | {p, StringTrim[f, ".m" | ".wl"]}
	}]


(* ::Subsubsection::Closed:: *)
(*PrepSpecs*)


PackagePostProcessPrepSpecs[] :=
	(
		Unprotect[
			$PackagePreloadedPackages,
			$PackageHiddenPackages,
			$PackageHiddenContexts,
			$PackageExposedContexts,
			$PackageDecontextedPackages
		];
		Replace[
			$PackageLoadSpecs,
			specs : {__Rule} | _Association :>
				CompoundExpression[
					$PackagePreloadedPackages =
						Replace[
							Lookup[specs, "PreLoad"],
							Except[{__String}] -> {}
						],
					$PackageHiddenPackages =
						Replace[
							Lookup[specs, "FEHidden"],
							Except[{__String}] -> {}
						],
					$PackageDecontextedPackages =
						Replace[
							Lookup[specs, "PackageScope"],
							Except[{__String}] -> {}
						],
					$PackageExposedContexts =
						Replace[
							Lookup[specs, "ExposedContexts"],
							Except[{__String}] -> {}
						]
				]
		]
	);


(* ::Subsubsection::Closed:: *)
(*ExposePackages*)


PackagePostProcessExposePackages[] /; TrueQ[$AllowPackageRecoloring] :=
	(
		PackageAppGet /@
			$PackagePreloadedPackages;
		With[{
			syms =
				If[
					!MemberQ[$PackageHiddenPackages,
						PackagePostProcessFileNamePrep[#]
					],
					$DeclaredPackages[#],
					{}
				]& /@ Keys@$DeclaredPackages // Flatten
		},
			Replace[
				Thread[
					If[ListQ@$PackageFEHiddenSymbols,
						DeleteCases[syms,
							Alternatives @@
								(Verbatim[HoldPattern] /@ Flatten@$PackageFEHiddenSymbols)
						],
						syms
					],
					HoldPattern],
				Verbatim[HoldPattern][{s__}] :>
					PackageFEUnhideSymbols[s]
			]
		]
	)




(* ::Subsubsection::Closed:: *)
(*Rehide Packages*)


PackagePostProcessRehidePackages[] /; TrueQ[$AllowPackageRecoloring] :=
	If[
		MemberQ[$PackageHiddenPackages,
			PackagePostProcessFileNamePrep[#]
		],
		PackageFERehidePackage@#
	]& /@ Keys@$DeclaredPackages


(* ::Subsubsection::Closed:: *)
(*Decontext*)


PackagePostProcessDecontextPackages[] /; TrueQ[$AllowPackageRecoloring] :=
	(
		If[
			MemberQ[$PackageDecontextedPackages,
				PackagePostProcessFileNamePrep[#]
			],
			PackageFERehidePackage@#;
			PackageDecontext@#
		]& /@ Keys@$DeclaredPackages;
		If[ListQ@$PackageScopedSymbols,
			KeyValueMap[
				With[{newcont = #},
					Replace[Join @@ #2,
						HoldComplete[s__] :>
							(
								PackageFERehideSymbols[s];
								Map[
									Function[Null,
										Quiet[
											Check[
												Set[Context[#], newcont],
												Remove[#],
												Context::cxdup
											],
											Context::cxdup
										],
										HoldAllComplete
									],
									HoldComplete[s]
								] // ReleaseHold;
							)
					]
				]&,
				GroupBy[Flatten@$PackageScopedSymbols, First -> Last]
			];
		]
	)




(* ::Subsubsection::Closed:: *)
(*ContextPathReassign*)


PackagePostProcessContextPathReassign[] :=
	With[{cp = $ContextPath},
		If[MemberQ[cp],
			"Geass`",
			$ContextPath =
				Join[
					Replace[
						Flatten@{$PackageExposedContexts},
						Except[_String?(StringEndsQ["`"])] -> Nothing,
						1
					],
					$ContextPath
				];
			If[TrueQ[$AllowPackageRecoloring],
				FrontEnd`Private`GetUpdatedSymbolContexts[]
			];
		]
	]


(* ::Subsubsection::Closed:: *)
(*AttachMainAutocomplete*)


PackageAttachMainAutocomplete[] :=
	PackageAddAutocompletions[Geass,
		Table[
			Replace[{} -> None]@
				Cases[
					DownValues[Geass],
					Nest[
						Insert[#, _, {1, 1, 1}]&,
						(HoldPattern[Verbatim[HoldPattern]][
							Geass[s_String, ___]
						] :> _),
						n - 1
					] :> s,
					Infinity
				],
			{n, 5}
		]
	];


(* ::Subsubsection::Closed:: *)
(*PreventShadowing*)


PackagePreemptShadowing[] :=
	Replace[
		Hold[{m___}] :>
			Off[m]
	]@
		Thread[
			ToExpression[
				Map[# <> "$"&, Names["`PackageScope`Private`*"]
				],
				StandardForm,
				Function[Null,
					Hold[MessageName[#, "shdw"]],
					HoldAllComplete
				]
			],
			Hold
		]


(* ::Subsubsection::Closed:: *)
(*PackagePrepPackageSymbol*)


PackagePrepPackageSymbol[] :=
	Switch[$AllowPackageSymbolDefinitions,
		None,
		Remove[Geass],
		False,
		Clear[Geass],
		_,
		PackageAttachMainAutocomplete[]
	]


End[];


(* ::Subsection:: *)
(*End*)


$ContextPath = DeleteCases[$ContextPath, $Context];
End[];


(* ::Section:: *)
(* Load *)


If[`PackageScope`Private`$AllowPackageRecoloring,
	Internal`SymbolList[False]
];


(* ::Subsubsection::Closed:: *)
(*Basic Load*)


`PackageScope`Private`$loadAbort = False;
CheckAbort[
	`PackageScope`Private`PackageAppLoad[];
	`PackageScope`Private`$PackageFEHideExprSymbols = True;
	`PackageScope`Private`$PackageFEHideEvalExpr = True;
	`PackageScope`Private`$PackageScopeBlockEvalExpr = True;
	`PackageScope`Private`$PackageDeclared = True;,
	`PackageScope`Private`$loadAbort = True;
	EndPackage[];
];
Protect["`PackageScope`Private`*"];
Unprotect[`PackageScope`Private`$loadAbort];


(* ::Subsubsection::Closed:: *)
(*Post-Process*)


If[!`PackageScope`Private`$loadAbort,
	`PackageScope`Private`PackagePostProcessPrepSpecs[];
	`PackageScope`Private`PackagePrepPackageSymbol[];
	`PackageScope`Private`PackagePostProcessExposePackages[];
	`PackageScope`Private`PackagePostProcessRehidePackages[];
	`PackageScope`Private`PackagePostProcessDecontextPackages[];
]


Unprotect[`PackageScope`Private`$PackageFEHiddenSymbols];
Clear[`PackageScope`Private`$PackageFEHiddenSymbols];
Unprotect[`PackageScope`Private`$PackageScopedSymbols];
Clear[`PackageScope`Private`$PackageScopedSymbols];


(* Hide `PackageScope`Private` shadowing *)
`PackageScope`Private`PackagePreemptShadowing[]


(* ::Subsubsection:: *)
(*EndPackage / Reset $ContextPath*)


System`Private`RestoreContextPath[]
EndPackage[];


If[
	(Clear@Geass`PackageScope`Private`$loadAbort;!#)&@
		Geass`PackageScope`Private`$loadAbort,
	Unprotect[Geass`PackageScope`Private`$LoadCompleted];
	Geass`PackageScope`Private`$LoadCompleted = True;
	Geass`PackageScope`Private`PackagePostProcessContextPathReassign[]
]