# awesome-machine-learning [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

❤️ Support my apps ❤️ 

- [Push Hero - pure Swift native macOS application to test push notifications](https://onmyway133.com/pushhero)
- [PastePal - Pasteboard, note and shortcut manager](https://onmyway133.com/pastepal)
- [Quick Check - smart todo manager](https://onmyway133.com/quickcheck)
- [Alias - App and file shortcut manager](https://onmyway133.com/alias)
- [My other apps](https://onmyway133.com/apps/)

❤️❤️😇😍🤘❤️❤️

I like to explore machine learning, but don't want the to dive into other platforms, like Python or Javascript, to understand some frameworks, or TensorFlow. Luckily, at WWDC 2017, Apple introduces Core ML, Vision, ARKit, which makes working with machine learning so much easier. With all the pre-trained models, we can build great things. It's good to feel the outcome first, then try to explore advanced topics and underlying mechanisms 🤖

This will curates things mostly related to Core ML, and Swift. There are related things in other platforms if you want to get some references

## Table of contents

- [Core ML](#core-ml)
- [TensorFlow](#tensorflow)
- [Keras](#keras)
- [Turi Create](#turi-create)
- [Machine Learning](#machine-learning)
- [Misc](#misc)

## Core ML

### Models :rocket:

- [Awesome-CoreML-Models](https://github.com/likedan/Awesome-CoreML-Models) Largest list of models for Core ML (for iOS 11+)
- [caffe](https://github.com/BVLC/caffe) Caffe: a fast open framework for deep learning. http://caffe.berkeleyvision.org/
- [deep-learning-models](https://github.com/fchollet/deep-learning-models) Keras code and weights files for popular deep learning models.
- [tensorflow models](https://github.com/tensorflow/models) Models built with TensorFlow
- [libSVM](https://www.csie.ntu.edu.tw/~cjlin/libsvm/) A Library for Support Vector Machines
- [scikit-learn](http://scikit-learn.org/) Machine Learning in Python
- [xgboost](https://github.com/dmlc/xgboost) Scalable, Portable and Distributed Gradient Boosting (GBDT, GBRT or GBM) Library, for Python, R, Java, Scala, C++ and more. Runs on single machine, Hadoop, Spark, Flink and DataFlow
- [Keras-Classification-Models](https://github.com/titu1994/Keras-Classification-Models) Collection of Keras models used for classification
- [MobileNet-Caffe](https://github.com/shicai/MobileNet-Caffe) Caffe Implementation of Google's MobileNets
- [ModelZoo](https://github.com/cocoa-ai/ModelZoo) A central GitHub repository for sharing Core ML models 
- [StyleArt](https://github.com/ileafsolutions/StyleArt) Style Art library process images using COREML with a set of pre trained machine learning models and convert them to Art style
- [models](https://github.com/Sarasra/models) Models and examples built with TensorFlow
- [Core ML Store](https://coreml.store/)

### Tools

- [coremltools](https://pypi.python.org/pypi/coremltools) coremltools in a python package for creating, examining, and testing models in the .mlmodel format
- [torch2coreml](https://github.com/prisma-ai/torch2coreml) This tool helps convert Torch7 models into Apple CoreML 
- [turicreate](https://github.com/apple/turicreate) Turi Create simplifies the development of custom machine learning models.
- [Netron](https://github.com/lutzroeder/Netron) Viewer for neural network and machine learning models
- [onnx-coreml](https://github.com/onnx/onnx-coreml) ONNX to CoreML Converter
- [tf-coreml](https://github.com/tf-coreml/tf-coreml) TensorFlow to CoreML Converter
- [tensorwatch](https://github.com/microsoft/tensorwatch) Debugging and visualization tool for machine learning and data science

### Posts

- [Swift Tutorial: Native Machine Learning and Machine Vision in iOS 11](https://hackernoon.com/swift-tutorial-native-machine-learning-and-machine-vision-in-ios-11-11e1e88aa397)
- [How to train your own model for CoreML](http://reza.codes/2017-07-29/how-to-train-your-own-dataset-for-coreml/)
- [Smart Gesture Recognition in iOS 11 with Core ML and TensorFlow](https://hackernoon.com/smart-gesture-recognition-in-ios-11-with-core-ml-and-tensorflow-1a0a92c99c51)
- [DIY Prisma app with CoreML](https://blog.prismalabs.ai/diy-prisma-app-with-coreml-6b4994cc99e1) :rocket:
- [Using scikit-learn and CoreML to Create a Music Recommendation Engine](https://www.agnosticdev.com/blog-entry/python/using-scikit-learn-and-coreml-create-music-recommendation-engine)
- [Building Not Hotdog with Turi Create and Core ML — in an afternoon](https://heartbeat.fritz.ai/building-not-hotdog-with-turi-create-and-core-ml-in-an-afternoon-a87fd1967d10)
- [Build a Taylor Swift detector with the TensorFlow Object Detection API, ML Engine, and Swift](https://towardsdatascience.com/build-a-taylor-swift-detector-with-the-tensorflow-object-detection-api-ml-engine-and-swift-82707f5b4a56)
- [Leveraging Machine Learning in iOS For Improved Accessibility](https://medium.com/buffer-engineering/leveraging-machine-learning-in-ios-for-improved-accessibility-fc7796c5326f)
- [IBM Watson Services for Core ML Tutorial](https://www.raywenderlich.com/190191/ibm-watson-services-for-core-ml-tutorial)
- [Beginning Machine Learning with Keras & Core ML](https://www.raywenderlich.com/181760/beginning-machine-learning-keras-core-ml)
- [Detecting Whisky brands with Core ML and IBM Watson services](https://martinmitrevski.com/2018/04/14/detecting-whisky-brands-with-core-ml-and-ibm-watson-services/)
- [Detecting Avengers superheroes in your iOS app with IBM Watson and CoreML](https://medium.com/flawless-app-stories/detecting-avengers-superheroes-in-your-ios-app-with-ibm-watson-and-coreml-fe38e493a4d1)
- [Machine Learning](https://developer.apple.com/machine-learning/) Build more intelligent apps with machine learning.
- [Apple Machine Learning Journal](https://machinelearning.apple.com/)
- [Introducing Core ML](https://developer.apple.com/videos/play/wwdc2017/703/)
- [Core ML in depth](https://developer.apple.com/videos/play/wwdc2017/710/)
- [Core ML and Vision: Machine Learning in iOS 11 Tutorial](https://www.raywenderlich.com/164213/coreml-and-vision-machine-learning-in-ios-11-tutorial)
- [iOS 11: Machine Learning for everyone](http://machinethink.net/blog/ios-11-machine-learning-for-everyone/)
- [Everything a Swift Dev Ever Wanted to Know About Machine Learning](https://news.realm.io/news/swift-developer-on-machine-learning-try-swift-2017-gallagher/)
- [Bringing machine learning to your iOS apps](https://news.realm.io/news/altconf-2017-meghan-kane-bringing-machine-learning-to-your-ios-apps/)
- [Pros and cons of iOS machine learning APIs](http://machinethink.net/blog/machine-learning-apis/) :rocket:
- [Core ML: Machine Learning for iOS](https://www.udacity.com/course/core-ml--ud1038) :rocket:
- [Bootstrapping the Machine Learning Training Process](https://www.youtube.com/watch?v=ugiPfm8ICZo)
- [Detecting Pneumonia in an iOS App with Create ML](https://heartbeat.fritz.ai/detecting-pneumonia-in-an-ios-app-with-create-ml-5cff2a60a3d)
- [How to fine-tune ResNet in Keras and use it in an iOS App via Core ML](https://heartbeat.fritz.ai/how-to-fine-tune-resnet-in-keras-and-use-it-in-an-ios-app-via-core-ml-ee7fd84c1b26)
- [Five Common Data Quality Gotchas in Machine Learning and How to Detect Them Quickly](https://doordash.engineering/2022/09/27/five-common-data-quality-gotchas-in-machine-learning-and-how-to-detect-them-quickly/)

### Repos

- [Core-ML-Sample](https://github.com/yulingtianxia/Core-ML-Sample) A Demo using Core ML Framework
- [UnsplashExplorer-CoreML](https://github.com/ahmetws/UnsplashExplorer-CoreML) Core ML demo app with Unsplash API
- [MNIST_DRAW](https://github.com/hwchong/MNIST_DRAW) This is a sample project demonstrating the use of Keras (Tensorflow) for the training of a MNIST model for handwriting recognition using CoreML on iOS 11 for inference.
- [CocoaAI](https://github.com/cocoa-ai/CocoaAI) The Cocoa Artificial Intelligence Lab :rocket:
- [complex-gestures-demo](https://github.com/mitochrome/complex-gestures-demo) A demonstration of using machine learning to recognize 13 complex gestures in an iOS app
 - [Core-ML-Car-Recognition](https://github.com/likedan/Core-ML-Car-Recognition) A Car Recognition Framework for CoreML
 - [CoreML-in-ARKit](https://github.com/hanleyweng/CoreML-in-ARKit) Simple project to detect objects and display 3D labels above them in AR. This serves as a basic template for an ARKit project to use CoreML
 - [trainer-mac](https://github.com/mortenjust/trainer-mac) Trains a model, then generates a complete Xcode project that uses it - no code necessary
 - [GestureAI-CoreML-iOS](https://github.com/akimach/GestureAI-CoreML-iOS) Hand-gesture recognition on iOS app using CoreML
 - [visual-recognition-coreml](https://github.com/watson-developer-cloud/visual-recognition-coreml) Classify images offline using Watson Visual Recognition and Core ML
 
## TensorFlow

### Posts

- [Open Source TensorFlow Models (Google I/O '17)](https://www.youtube.com/watch?v=9ziVGkt8Gg4)
- [Swift for TensorFlow](https://www.youtube.com/watch?v=Yze693W4MaU)
- [Get started with TensorFlow high-level APIs (Google I/O '18)](https://www.youtube.com/watch?v=tjsHSIG8I08&list=PLOU2XLYxmsIInFRc3M44HUTQc3b_YJ4-Y&index=37)
- [Getting started with TensorFlow on iOS](http://machinethink.net/blog/tensorflow-on-ios/)
- [Introducing TensorFlow.js: Machine Learning in Javascript](https://medium.com/tensorflow/introducing-tensorflow-js-machine-learning-in-javascript-bf3eab376db)
- [TensorFlow for JavaScript (Google I/O '18)](https://www.youtube.com/watch?v=OmofOvMApTU)
- [Colab](https://colab.research.google.com) Colaboratory is a Google research project created to help disseminate machine learning education and research
- [Use TensorFlow and BNNS to Add Machine Learning to your Mac or iOS App](https://www.bignerdranch.com/blog/use-tensorflow-and-bnns-to-add-machine-learning-to-your-mac-or-ios-app/)

### Repos

- [workshops](https://github.com/tensorflow/workshops) A few exercises for use at events Google IO 2018

### Courses

- [Machine Learning Crash Course with TensorFlow APIs](https://developers.google.com/machine-learning/crash-course/)
- [Deep Learning with Python by Francois Chollet](https://www.amazon.com/Deep-Learning-Python-Francois-Chollet/dp/1617294438)
- [Learn from ML experts at Google](https://ai.google/education)

## Keras

### Posts

- [Running Keras models on iOS with CoreML](https://www.pyimagesearch.com/2018/04/23/running-keras-models-on-ios-with-coreml/)
- [Keras and Convolutional Neural Networks (CNNs)](https://www.pyimagesearch.com/2018/04/16/keras-and-convolutional-neural-networks-cnns/)
- [Keras Tutorial : Transfer Learning using pre-trained models]()https://www.learnopencv.com/keras-tutorial-transfer-learning-using-pre-trained-models/

## Turi Create

### Posts

- [Building Not Hotdog with Turi Create and Core ML — in an afternoon](https://hackernoon.com/building-not-hotdog-with-turi-create-and-core-ml-in-an-afternoon-231b14738edf)
- [Natural Language Processing on iOS with Turi Create](https://www.raywenderlich.com/185515/natural-language-processing-on-ios-with-turi-create)
- [Machine Learning in iOS: Turi Create and CoreML](https://medium.com/flawless-app-stories/machine-learning-in-ios-turi-create-and-coreml-5ddce0dc8e26)
- [A Guide to Turi Create](https://developer.apple.com/videos/play/wwdc2018/712/)

## Machine Learning 

### Getting started

- [A Thank You note to Towards Data Science](https://towardsdatascience.com/a-thank-you-note-to-towards-data-science-58b714a824f8)
- [This is why anyone can learn Machine Learning](https://medium.freecodecamp.org/this-is-why-anyone-can-learn-machine-learning-a5333ee64dff)

### Posts

- [A visual introduction to machine learning](http://www.r2d3.us/visual-intro-to-machine-learning-part-1/)
- [Machine Learning is Fun!](https://medium.com/@ageitgey/machine-learning-is-fun-80ea3ec3c471)
- [10 Machine Learning Terms Explained in Simple English](http://blog.aylien.com/10-machine-learning-terms-explained-in-simple/)
- [Machine Learning in a Year](https://medium.com/learning-new-stuff/machine-learning-in-a-year-cdb0b0ebd29c)
- [Machine Learning Self-study Resources](https://ragle.sanukcode.net/articles/machine-learning-self-study-resources/)
- [How to Learn Machine Learning](https://elitedatascience.com/learn-machine-learning)
- [Getting Started with Machine Learning](https://medium.com/@suffiyanz/getting-started-with-machine-learning-f15df1c283ea)
- [The Non-Technical Guide to Machine Learning & Artificial Intelligence](https://machinelearnings.co/a-humans-guide-to-machine-learning-e179f43b67a0)
- [Machine Learning: An In-Depth Guide - Overview, Goals, Learning Types, and Algorithms](http://www.innoarchitech.com/machine-learning-an-in-depth-non-technical-guide/)
- [A Tour of Machine Learning Algorithms](http://machinelearningmastery.com/a-tour-of-machine-learning-algorithms/)
- [Machine Learning for Hackers](https://www.youtube.com/playlist?list=PL2-dafEMk2A4ut2pyv0fSIXqOzXtBGkLj)
- [Machine Learning for Developers For absolute beginners and fifth graders](https://xyclade.github.io/MachineLearning/)
- [dive-into-machine-learning](https://github.com/hangtwenty/dive-into-machine-learning) Dive into Machine Learning with Python Jupyter notebook and scikit-learn
- [An introduction to machine learning with scikit-learn](http://scikit-learn.org/stable/tutorial/basic/tutorial.html)
- [Building powerful image classification models using very little data](https://blog.keras.io/building-powerful-image-classification-models-using-very-little-data.html)
- [How HBO’s Silicon Valley built “Not Hotdog” with mobile TensorFlow, Keras & React Nativ](https://medium.com/@timanglade/how-hbos-silicon-valley-built-not-hotdog-with-mobile-tensorflow-keras-react-native-ef03260747f3)
- [Hello World - Machine Learning Recipes #1](https://www.youtube.com/watch?v=cKxRvEZd3Mw)
- [An Intuitive Explanation of Convolutional Neural Networks](https://ujjwalkarn.me/2016/08/11/intuitive-explanation-convnets/) :rocket:
- [A Quick Introduction to Neural Networks](https://ujjwalkarn.me/2016/08/09/quick-intro-neural-networks/)
- [Machine Learning Algorithm for Flappy Bird using Neural Network and Genetic Algorithm](http://www.askforgametask.com/tutorial/machine-learning-algorithm-flappy-bird/)
- [Understanding How Machines Learn, Through Prototyping](https://medium.com/bigtomorrow/understanding-how-machines-learn-through-prototyping-9bdaa3ce7baa#.mura2rwy2) :rocket:
- [Training on the device](http://machinethink.net/blog/training-on-device/)
- [Machine Learning for iOS](https://www.invasivecode.com/weblog/machine-learning-swift-ios/)
- [The “hello world” of neural networks](http://machinethink.net/blog/the-hello-world-of-neural-networks/)
- [Convolutional Neural Networks in iOS 10 and macOS](https://www.invasivecode.com/weblog/convolutional-neural-networks-ios-10-macos-sierra/)
- [LearningMachineLearning](https://github.com/graceavery/LearningMachineLearning) Swift implementation of "Data Science From Scratch" and http://karpathy.github.io/neuralnets/
- [The “hello world” of neural networks](http://machinethink.net/blog/the-hello-world-of-neural-networks/) 👶
- [EmojiIntelligence](https://github.com/Luubra/EmojiIntelligence) Neural Network built in Apple Playground using Swift 👶
- [Machine Learning: End-to-end Classification](https://www.raywenderlich.com/5554-machine-learning-end-to-end-classification)
- [Machine Learning Zero to Hero (Google I/O'19)](https://www.youtube.com/watch?v=VwVg9jCtqaU&t=315s) :rocket:


### Convolution neural network

- [CS231n Winter 2016 Lecture 7 Convolutional Neural Networks](https://www.youtube.com/watch?v=AQirPKrAyDg)
- [How to build your own Neural Network from scratch in Python](https://towardsdatascience.com/how-to-build-your-own-neural-network-from-scratch-in-python-68998a08e4f6) :star:
- [How Convolutional Neural Networks work](https://www.youtube.com/watch?v=FmpDIaiMIeA) :star:

## Misc

### Blogs

- [Fritz Heartbeat](https://heartbeat.fritz.ai/) :star:

### Create ML

- [Introduction to Create ML: How to Train Your Own Machine Learning Model in Xcode 10](https://www.appcoda.com/create-ml/)

### ML Kit

- [Introducing ML Kit](https://developers.googleblog.com/2018/05/introducing-ml-kit.html)

### Vision

- [Vision](https://developer.apple.com/documentation/vision) Apply high-performance image analysis and computer vision techniques to identify faces, detect features, and classify scenes in images and video.
- [Blog-Getting-Started-with-Vision](https://github.com/jeffreybergier/Blog-Getting-Started-with-Vision)
- [Swift World: What’s new in iOS 11 — Vision](https://medium.com/compileswift/swift-world-whats-new-in-ios-11-vision-456ba4156bad)

### Natural Language Processing

- [NSLinguisticTagger](https://developer.apple.com/documentation/foundation/nslinguistictagger) Analyze natural language to tag part of speech and lexical class, identify proper names, perform lemmatization, and determine the language and script (orthography) of text.
- [Linguistic Tagging](https://www.objc.io/issues/7-foundation/linguistic-tagging/)
- [NSLinguisticTagger on NSHipster](http://nshipster.com/nslinguistictagger/)
- [CoreLinguistics](https://github.com/rxwei/CoreLinguistics) This repository contains some fundamental data structures for NLP.
- [SwiftVerbalExpressions](https://github.com/VerbalExpressions/SwiftVerbalExpressions) Swift Port of VerbalExpressions

### Metal

- [Metal](https://developer.apple.com/metal/)
- [MPSCNNHelloWorld: Simple Digit Detection Convolution Neural Networks (CNN)](https://developer.apple.com/library/content/samplecode/MPSCNNHelloWorld/Introduction/Intro.html)
- [MetalImageRecognition: Performing Image Recognition](https://developer.apple.com/library/content/samplecode/MetalImageRecognition/Introduction/Intro.html)
- [Apple’s deep learning frameworks: BNNS vs. Metal CNN](http://machinethink.net/blog/apple-deep-learning-bnns-versus-metal-cnn/)
- [Forge](https://github.com/hollance/Forge) A neural network toolkit for Metal

### GamePlayKit

- [GamePlayKit](https://developer.apple.com/documentation/gameplaykit)
- [Project 34: Four in a Row](https://www.hackingwithswift.com/read/34/overview)
- [GKMinmaxStrategist: What does it take to build a TicTacToe AI?](http://tilemapkit.com/2015/07/gkminmaxstrategist-build-tictactoe-ai/)
- [GameplayKit Tutorial: Artificial Intelligence](https://www.raywenderlich.com/146407/gameplaykit-tutorial-artificial-intelligence)
- [Gems of GameplayKit](https://vimeo.com/album/4786409/video/235143936)
- [GameplayKit: Beyond Games](https://academy.realm.io/posts/sash-zats-gameplaykit-beyond-games/)

### Courses

- [6.S191: Introduction to Deep Learning](http://introtodeeplearning.com/index.html)
- [Machine Learning](http://introtodeeplearning.com/index.html)
- [Introduction - Intro to Machine Learning on Udacity](https://www.youtube.com/watch?v=ICKBWIkfeJ8&list=PLAwxTw4SYaPkQXg8TkVdIvYv4HfLG7SiH)
- [Machine Learning & Deep Learning Fundamentals by deeplizard](https://www.youtube.com/watch?v=hfK_dvC-avg&list=PLZbbT5o_s2xq7LwI2y8_QtvuXZedL6tQU) :star: :star:

### Interview

- [41 Essential Machine Learning Interview Questions](https://www.springboard.com/blog/machine-learning-interview-questions/)

### Other ML frameworks

- [TensorSwift](https://github.com/qoncept/TensorSwift) A lightweight library to calculate tensors in Swift, which has similar APIs to TensorFlow's
- [Swift-AI](https://github.com/Swift-AI/Swift-AI) The Swift machine learning library.
- [Swift-Brain](https://github.com/vlall/Swift-Brain) Artificial intelligence/machine learning data structures and Swift algorithms for future iOS development. bayes theorem, neural networks, and more AI.
- [Bender](https://github.com/xmartlabs/Bender) Easily craft fast Neural Networks on iOS! Use TensorFlow models. Metal under the hood.
- [BrainCore](https://github.com/aleph7/BrainCore) The iOS and OS X neural network framework
- [AIToolbox](https://github.com/KevinCoble/AIToolbox) A toolbox of AI modules written in Swift: Graphs/Trees, Support Vector Machines, Neural Networks, PCA, K-Means, Genetic Algorithms
- [brain](https://github.com/harthur/brain) Neural networks in JavaScript
- [TensorFlow](https://www.tensorflow.org/get_started/mnist/beginners) An open-source software library for Machine Intelligence
- [incubator-predictionio](https://github.com/apache/incubator-predictionio) PredictionIO, a machine learning server for developers and ML engineers. Built on Apache Spark, HBase and Spray.
- [Caffe](http://caffe.berkeleyvision.org/) Deep learning framework by BAIR
- [Torch](http://torch.ch/) A SCIENTIFIC COMPUTING FRAMEWORK FOR LUAJIT
- [Theano](http://www.deeplearning.net/software/theano/) Theano is a Python library that allows you to define, optimize, and evaluate mathematical expressions involving multi-dimensional arrays efficiently
- [CNTK](https://github.com/Microsoft/CNTK) Microsoft Cognitive Toolkit (CNTK), an open source deep-learning toolkit
- [MXNet](http://mxnet.io/) Lightweight, Portable, Flexible Distributed/Mobile Deep Learning

### Accelerate

- [Accelerate-in-Swift](https://github.com/hyperjeff/Accelerate-in-Swift) Swift example codes for the Accelerate.framework
- [Surge](https://github.com/mattt/Surge) A Swift library that uses the Accelerate framework to provide high-performance functions for matrix math, digital signal processing, and image manipulation.

### Statistics

- [SigmaSwiftStatistics](https://github.com/evgenyneu/SigmaSwiftStatistics) A collection of functions for statistical calculation written in Swift

### Services

- [Watson](https://www.ibm.com/watson/developercloud/) Enable cognitive computing features in your app using IBM Watson's Language, Vision, Speech and Data APIs.
- [wit.ai](https://wit.ai/) Natural Language for Developers
- [Cloud Machine Learning Engine](https://cloud.google.com/ml-engine/) Machine Learning on any data, any size
- [Cloud Vision API](https://cloud.google.com/vision/) Derive insight from images with our powerful Cloud Vision API
- [Amazon Machine Learning](https://aws.amazon.com/documentation/machine-learning/) Amazon Machine Learning makes it easy for developers to build smart applications, including applications for fraud detection, demand forecasting, targeted marketing, and click prediction
- [api.ai](https://api.ai/) Build brand-unique, natural language interactions for bots, applications, services, and devices.
- [clarifai](https://developer.clarifai.com/) Build amazing apps with the world’s best image and video recognition API.
- [openml](https://www.openml.org/) Exploring machine learning together
- [Lobe](https://lobe.ai/) Deep learning made simple
- [Comparing Machine Learning (ML) Services from Various Cloud ML Service Providers](https://medium.com/@tanyathakur6/comparing-machine-learning-ml-services-from-various-cloud-ml-service-providers-63c8a2626cb6)

### Text Recognition

- [Tesseract OCR Tutorial](https://www.raywenderlich.com/93276/implementing-tesseract-ocr-ios)
- [Tesseract-OCR-iOS](https://github.com/gali8/Tesseract-OCR-iOS) Tesseract OCR iOS is a Framework for iOS7+, compiled also for armv7s and arm64.
- [tesseract.js](https://github.com/naptha/tesseract.js) Pure Javascript OCR for 62 Languages

### Speech Recognition

- [Speech](https://developer.apple.com/documentation/speech)
- [Using the Speech Recognition API in iOS 10](https://code.tutsplus.com/tutorials/using-the-speech-recognition-api-in-ios-10--cms-28032)
- [Speech Recognition Tutorial for iOS](https://www.raywenderlich.com/155752/speech-recognition-tutorial-ios)
- [CeedVocal](https://github.com/creaceed/CeedVocal) Speech Recognition Library for iOS

### Speech Synthesizer

- [AVSpeechSynthesizer](https://developer.apple.com/documentation/avfoundation/avspeechsynthesizer) An object that produces synthesized speech from text utterances and provides controls for monitoring or controlling ongoing speech.

### Artificial Intelligence

- [The classic ELIZA chat bot in Swift.](https://gist.github.com/hollance/be70d0d7952066cb3160d36f33e5636f)
- [Introduction to AI Programming for Games](https://www.raywenderlich.com/24824/introduction-to-ai-programming-for-games)

### Google Cloud Platform for Machine Learning

- [Machine Learning](https://cloud.google.com/products/machine-learning/)
- [Machine Learning APIs by Example (Google I/O '17)](https://www.youtube.com/watch?v=ETeeSYMGZn0)
- [Adding Computer Vision to your iOS App](https://medium.com/@srobtweets/adding-computer-vision-to-your-ios-app-66d6f540cdd2)

### Others

- [NotHotdog-Classifier](https://github.com/kmather73/NotHotdog-Classifier) What would you say if I told you there is a app on the market that tell you if you have a hotdog or not a hotdog.
- [How HBO’s Silicon Valley built “Not Hotdog” with mobile TensorFlow, Keras & React Native](https://hackernoon.com/how-hbos-silicon-valley-built-not-hotdog-with-mobile-tensorflow-keras-react-native-ef03260747f3)
