Attribute VB_Name = "Module4"

Function StrToBool(Text$) As Boolean
    
    'returns boolean True if given string True
    
    If Text = "True" Then StrToBool = True
    
End Function

Function AutoMatch(ComboObj As ComboBox)
    
    'Provides closest list match in combo while user inputs

    Dim MarkA%
    Dim A%
    If Len(ComboObj.Text) <= Len(ComboObj.Tag) Then
        If ComboObj.Text <> Mid(ComboObj.Tag, 1, Len(ComboObj.Text)) Then ComboObj.Tag = ""
    End If
    If Len(ComboObj.Text) > Len(ComboObj.Tag) Then
        If ComboObj.ListCount > 0 Then
            MarkA = Len(ComboObj.Text)
            For A = 0 To ComboObj.ListCount - 1
                If Mid(ComboObj.List(A), 1, Len(ComboObj.Text)) = ComboObj.Text Then
                    ComboObj.ListIndex = A
                    ComboObj.SelStart = MarkA
                    ComboObj.SelLength = Len(ComboObj.Text) - MarkA
                    Exit For
                End If
            Next A
        End If
    End If
    ComboObj.Tag = Mid(ComboObj.Text, 1, ComboObj.SelStart)

End Function
Function GetLine$(Text$, InsPt%)

    'Gets the line where the insert point is in Text
    
    Dim A%
    Dim MarkA%
    Dim MarkB%
    
    For A = InsPt To 1 Step -1
        If Mid(Text, A, 1) = Chr(10) Then Exit For
    Next A
    MarkA = A + 1
    For A = InsPt To Len(Text) Step 1
        If Mid(Text, A, 1) = Chr(13) Then Exit For
    Next A
    MarkB = A - 1
    GetLine = Mid(Text, MarkA, MarkB - MarkA + 1)
    
End Function
Function GetIndex%(ComboObj As ComboBox, Text$)

    'Gets the index of a matching item in a combobox

    Dim A%
    
    If ComboObj.ListCount > 0 Then
        For A = 1 To ComboObj.ListCount - 1
            If ComboObj.List(A) = Text Then
                GetIndex = A
                Exit For
            End If
        Next A
        If GetIndex = 0 Then GetIndex = -1
    Else
        GetIndex = -1
    End If
    
End Function

Function RepStr$(Text$, OldStr$, NewStr$)

    'Replaces certain string in Text
    
    Dim A%
    Dim BufferA$
    
    For A = 1 To Len(Text)
        If Mid(Text, A, Len(OldStr)) = OldStr Then
             BufferA = BufferA + NewStr
            A = A + Len(OldStr) - 1
        Else
            BufferA = BufferA + Mid(Text, A, 1)
        End If
    Next A
    RepStr = BufferA

End Function

Function GetSeg$(Text$, SepStr$, SegNum%)
    
    'Gets segments divided by the same string in Text
    
    Dim A%
    Dim B%
    Dim MarkA%
    Dim BufferA$
    
    BufferA = SepStr + Text + SepStr
    For A = 1 To Len(BufferA)
        If Mid(BufferA, A, Len(SepStr)) = SepStr Then MarkA = MarkA + 1
        If MarkA = SegNum Then
            For B = 1 To Len(BufferA) - A
                If Mid(BufferA, A + B, Len(SepStr)) = SepStr Then
                    GetSeg = Mid(BufferA, A + Len(SepStr), B - Len(SepStr))
                    Exit Function
                End If
            Next B
        End If
    Next A
    
End Function
Function CntStr%(Text$, Str$)
    
    'Counts certain string in Text
    
    Dim A%
    Dim MarkA%
    
    For A = 1 To Len(Text)
        If Mid(Text, A, Len(Str)) = Str Then MarkA = MarkA + 1
    Next A
    CntStr = MarkA
    
End Function
Function Edit$(Action$, TextObj As Object)
    
    'Performs basic Edit Menu functions (submit action type as Action)
    
    Dim BufferA$
    
    BufferA = TextObj.SelStart
    If Action = "Cut" Then
        If TextObj.SelLength <> 0 Then Clipboard.SetText (Mid(TextObj.Text, TextObj.SelStart + 1, TextObj.SelLength))
        TextObj.Text = Mid(TextObj.Text, 1, TextObj.SelStart) _
        + Mid(TextObj.Text, TextObj.SelStart + TextObj.SelLength + 1, Len(TextObj.Text) - (TextObj.SelStart + TextObj.SelLength))
        TextObj.SelStart = BufferA
        TextObj.SelLength = 0
    End If
    If Action = "Copy" Then
        If TextObj.SelLength <> 0 Then Clipboard.SetText (Mid(TextObj.Text, TextObj.SelStart + 1, TextObj.SelLength))
    End If
    If Action = "Paste" Then
        TextObj.Text = Mid(TextObj.Text, 1, TextObj.SelStart) _
        + Clipboard.GetText _
        + Mid(TextObj.Text, TextObj.SelStart + TextObj.SelLength + 1, Len(TextObj.Text) - (TextObj.SelStart + TextObj.SelLength))
        TextObj.SelStart = BufferA + Len(Clipboard.GetText)
        TextObj.SelLength = 0
    End If
    If Action = "Delete" Then
        TextObj.Text = Mid(TextObj.Text, 1, TextObj.SelStart) _
        + Mid(TextObj.Text, TextObj.SelStart + TextObj.SelLength + 1, Len(TextObj.Text) - (TextObj.SelStart + TextObj.SelLength))
        TextObj.SelStart = BufferA
        TextObj.SelLength = 0
    End If
    If Action = "Select All" Then
        TextObj.SelStart = 0
        TextObj.SelLength = Len(TextObj.Text)
    End If
    TextObj.SetFocus
    
End Function
Function GetBtw$(Text$, StrBefore$, StrAfter$, BtwNum%)
    
    'Gets charactors between two known strings in Text
    
    Dim A%
    Dim B%
    Dim MarkA%
    
    If StrBefore = "" And StrAfter = "" Then
        GetBtw = Text
    ElseIf StrBefore = "" Then
        GetBtw = Mid(Text, 1, LocStr(Text, StrAfter, BtwNum) - 1)
    ElseIf StrAfter = "" Then
        GetBtw = Mid(Text, LocStr(Text, StrBefore, BtwNum) + Len(StrBefore), Len(Text) - LocStr(Text, StrBefore, BtwNum) + 1)
    Else
        For A = 1 To Len(Text)
            If Mid(Text, A, Len(StrBefore)) = StrBefore Then
                MarkA = MarkA + 1
                For B = 1 To Len(Text) - A
                    If Mid(Text, A + B, Len(StrAfter)) = StrAfter Then
                        If MarkA = BtwNum Then
                            GetBtw = Mid(Text, A + Len(StrBefore), B - Len(StrBefore))
                            Exit Function
                        End If
                    End If
                Next B
            End If
        Next A
    End If
    
End Function
Function LocStr%(Text$, Str$, StrNum%)
    
    'Locates certain string in Text
    
    Dim A%
    Dim MarkA%
    
    For A = 1 To Len(Text)
        If Mid(Text, A, Len(Str)) = Str Then
            MarkA = MarkA + 1
            If MarkA = StrNum Then
                LocStr = A
                Exit Function
            End If
        End If
    Next A
    
End Function
Function Access%(Action$, FileName$, Text$, Filter$, CmnDlgObj As Object)
    
    'Accesses Text files (prompt displayeded when "Prompt" is submitted as FileName)
    
    Dim FilNum As Variant
    Dim SinLine$
    Dim AllData$
    
    Access = 0
    FilNum = FreeFile
    CmnDlgObj.CancelError = True
    CmnDlgObj.Filter = Filter
    If Action = "Open" Then
        If FileName = "Prompt" Then
            On Error Resume Next
                CmnDlgObj.Action = 1
            If Err = 0 Then
                Open CmnDlgObj.FileName For Input As FilNum
                    Do Until EOF(FilNum)
                        Line Input #FilNum, SinLine
                        AllData = AllData + SinLine + vbCrLf
                    Loop
                    AllData = Mid(AllData, 1, Len(AllData) - 2)
                Close FilNum
            Else
                Access = -1
            End If
        End If
        If FileName <> "Prompt" Then
            Open FileName For Input As FilNum
                Do Until EOF(FilNum)
                    Line Input #FilNum, SinLine
                    AllData = AllData + SinLine + vbCrLf
                Loop
                AllData = Mid(AllData, 1, Len(AllData) - 2)
            Close FilNum
        End If
        Text = AllData
    End If
    If Action = "Save" Then
        If FileName = "Prompt" Then
            On Error Resume Next
                CmnDlgObj.Action = 2
            If Err = 0 Then
                Open CmnDlgObj.FileName For Output As FilNum
                    Print #FilNum, Text
                Close FilNum
            Else
                Access = -1
            End If
        End If
        If FileName <> "Prompt" Then
            Open FileName For Output As FilNum
                Print #FilNum, Text
            Close FilNum
        End If
    End If
    
End Function
Function GetPath$(FullPath$, Part$)
    
    'Gets certain parts of a FullPath
    
    Dim A%
    
    If Part = "Drive" Then
        For A = 1 To Len(FullPath)
            If Mid(FullPath, A, 1) = "\" Then
                GetPath = Mid(FullPath, 1, A - 2)
                Exit Function
            End If
        Next A
    End If
    If Part = "Path" Then
        For A = 1 To Len(FullPath)
            If Mid(FullPath, A, 1) = "\" Then
                GetPath = Mid(FullPath, 1, A)
            End If
        Next A
    End If
    If Part = "File" Then
        For A = 1 To Len(FullPath)
            If Mid(FullPath, A, 1) = "\" Then
                GetPath = Mid(FullPath, A + 1, Len(FullPath) - A)
            End If
        Next A
    End If
    If Part = "Filename" Then
        For A = 1 To Len(FullPath)
            If Mid(FullPath, A, 1) = "\" Then
                GetPath = Mid(FullPath, A + 1, Len(FullPath) - A)
            End If
        Next A
        For A = 1 To Len(GetPath)
            If Mid(GetPath, A, 1) = "." Then GetPath = Mid(GetPath, 1, A - 1)
        Next A
    End If
    If Part = "Extension" Then
        For A = 1 To Len(FullPath)
            If Mid(FullPath, A, 1) = "\" Then
                GetPath = Mid(FullPath, A + 1, Len(FullPath) - A)
            End If
        Next A
        For A = 1 To Len(GetPath)
            If Mid(GetPath, A, 1) = "." Then GetPath = Mid(GetPath, A + 1, Len(GetPath) - A)
        Next A
    End If
    
End Function
Function ScrollTxt$(Text$, CharNum%)
    
    'Returns Text scRolled CharNum of characters (+ as right, - as left)
    
    Dim MarkA%
    
    If Text <> "" Then
        MarkA = Abs(CharNum) Mod Len(Text)
        If CharNum > 0 Then ScrollTxt = Mid(Text, Len(Text) - MarkA + 1, MarkA) + _
            Mid(Text, 1, Len(Text) - MarkA)
        If CharNum = 0 Then ScrollTxt = Text
        If CharNum < 0 Then ScrollTxt = Mid(Text, MarkA + 1, Len(Text) - MarkA) + _
            Mid(Text, 1, MarkA)
    End If
    
End Function
                                                                                                                                                                                                                                                                                                                                                                             5?5?h8D       r?衾~-D       衾r?I         ?     D   6X(>    Q|?qX?   Q|?    6X(>ֺ   ?    G?UC   G?    ?\2       衾r?\       G?D   6X(    Q|?C   }>    _?
I   p	?    +W?O     ?          >    ;p&v?    ڻ#D     ?              T:    s}?*5C     ?              T:    s}?tNB     ?              p    ^X?6C   <    +d?ZHC     ?                    ?      B         ?      0C     ?                  r?>9D@C       衾r?rB       >r?
C         ?      $C     ?                    ?      ,C       r?衾bJB         ?      B   y|?4>    V*   p&v?;>    E#     ?               <>    +d?       ,E^?D   [?    c}   =&^B?    #^D   <+d?    Lh?D     ?          h    a9?;0    FC   hl?Tƾ    ΂\   y|?4    d   q?;4>    ,]   q?;4    ,]   m?&    ׃   L?              ?      0D         ?      HD         ?      `D   ɾMk?    qYD   <+d?     lD       5?50F       +d?<㺫        ?;U?C       ;U? ?iB       <>+d?PkC       5?5?C         ?      D   մ}?    YE             ?  B   6X(>    Q|?>   6X(    Q|?vzD   ?    G?Lu       G?[5D   Q|?    6X(>/`   G?    e   Q|?    6X(   *t?ۙ         ?                 r?>&D       >r?I$D   FBs?    q   l@佶g~?    	D         ?           ?                    ?              ?           ?          !          ?            ?          XC      ?          C          ?     @$         ?           ?                    ?          ?                    ?        ]n>    n?,       3j1y?C       ?aԺy?C   ]n>    n??         ?           ?          pB        @4>H4i?       @4>H4i?         ?        3    jd?   3    jd?x         ?           ?                    ?      8         ?     @         ?               ?         ^    rd?	bC   ^    rd?NҪC         ?        5Ը    Ǽn?҃C         ?     @         ?         5Ը    Ǽn?eNC       B>Nl?No       B>Nl?	         ?     (         ?     %     ?                ?               ?               ?                ?                   ?     2     ?                    ?     9   =&^B?    r   5?5?    K+   *>?    &     ?                ?                    ?      <         ?      X     ?          C          ?      \         ?      M         ?     H     ?                   ?      L         ?      I     ?          J      ?          :      ?          r          ?      Z   E>v?    <ܦ   <?e\?        5?5?    =-   +d?<>    Z=   +d?<    
ѕD     ?          C          ?               ?           ?                    ?      n     ?                ?          ^          ?     {             ?  B         ?           ?                    ?          ?          8C      ?          C              ?           ?              ?          ?          _      ?                ?          g          ?     @'         ?      1             ?  B     ?                ?                    ?      D     ?          D          ?     D     ?          @      ?                    ?     D         ?     D     ?          ]D      ?          ~D      ?          eD          ?     @&E         ?      0E     ?          D      ?          D          ?                   ?  B             ?  p     ?          D              ?  B     ?          :D          ?      D     ?                ?          <              ?               ?       ?          j          ?     f         ?     c     ?          hD      ?          D          ?     bE         ?     eE         ?           ?          tD          ?      nE         ?     yE     ?          D              ?       ?          D      ?         D          ?     7E     ?          D          ?     #E         ?     0E     ?         D              ?  B         ?     (E     ?         D      ?         D    5?5?    r+E   =&^B?    xfD   *>?    :D   *?>?    .=E     ?          `D          ?      6E     ?          <D      ?          DD          ?      GE     ?          D          ?      E         ?     HE     ?          @A      ?                    ?      VE     ?          p          ?     @"E     ?          C          ?      <E         ?       E     ?                ?          m          ?      D     ?          D      ?          D              ?  B         ?      XD         ?      E     ?         D          ?      D         ?      D       BľNl?;l         ?     @E         ?     E   5Ը>    Ǽn?C   5Ը>    Ǽn?#aC     ?          MD          ?     D   ^>    rd?-0C   ^>    rd? C         ?     E         ?      E             ?           ?      D     ?          D      ?          @C          ?      D         ?      D             ?           ?      D         ?      tD         ?      D     ?          C              ?       ?          B          ?      cD       衾r?z=             ?  B     ?                ?                ?          t          ?      D     ?              Ev?    KBD         ?      D     ?          B          ?     D         ?     D     ?          H      ?                ?                ?          Y          ?      D         ?      D   E>v?    0uD   <?e\?    CvD   5?5?    d D   +d?<>    C   +d?<       5?5    q   <e\?    D   Ev?    SD   <e\?    D   +d?<    Gč   Ev?    D   5?5    ۽   5?5?    9D   +d?<>    ݴoC   E>v?    D   <?e\?    D   5?5    a   <e\?    D     ?          l          ?      C        ;U?         ?       D   [{?H    KeB       "D?#?MC   [{?H    5   [{?H>    _U   [{?H>    `EB     ?                    ?      C             ?  o     ?              +d?<       +d?<>    kC   E>v?    >6D   <?e\?    j-zD   5?5?    wW#D     ?                    ?      D         ?      	E     ?                ?          kD      ?          D          ?               ?      
         ?               ?              ?      \     ?          C        >r?        ?;U?6         ?               ?         [{?H>    E<       "D?#   [{?H>    ^B   [{?H    KB   [{?H    AO         ?           ?          O          ?      w     ?          dC          ?      g         ?              ?              ?          ?          FD      ?          WD          ?               ?           ?          D      ?          D          ?           ?                    ?           ?          B      ?          C          ?         Ev?         ?          C      ?          lC      ?          hC      ?                ?          H          ?               ?               ?          ?                ?                   ?         ^    rd?C         ?        5Ը    Ǽn?&dC         ?         ^    rd?RC         ?     @   5Ը    Ǽn?1C       B>Nl?m   <?e\?    z   5?5?    $   +d?<>    4    +d?<    D   5?5    &D   <e\?       Ev?       E>v?       E>v?    C:   <?e\?    F   5?5    f@D   <e\?    l   5?5?    36>   Ev?       +d?<    GčD   5?5    D   +d?<>    o~   <e\?    {         ?         E>v?    g   <?e\?    z~   5?5?    '   +d?<>    &(   +d?<    D     ?          C          ?           ?                ?                    ?      =         ?      !     ?          C          ?     @#     ?                    ?      W         ?     I     ?          F          ?      7         ?           ?                    ?      H     ?          >          ?     )         ?     $     ?               ?               ?                   ?     1     ?               ?                    ?     8   5?5?    ,   =&^B?    D   *>?    ;   *?>?    B>     ?                    ?      o     ?               ?          v      ?                ?          b          ?     z         ?          ?          C          ?              ?          ?          |      ?          k          ?     @&         ?      2     ?                   ?           ?                    ?     D     ?                    ?     D         ?     D     ?          zD      ?          iD          ?     @%E         ?      1E     ?         D          ?      D     ?          D          ?               ?                   ?       ?          D      ?          6D          ?      D         ?      E     ?                ?          8              ?       ?          f          ?     g         ?     b     ?          dD      ?          D          ?     aE         ?     fE                               `<          
<0           `          @Xd            
<0
(      (   
<, 
0      /   tP  T >      6   \
 D( E      ?   \
 ( J      H   D\
 ( O      R   D	 D\
 S      `   0<
_      i   <s 	     p    l
<t |       w   <0
 	        <0 
        0<         	<         , h<         0h<, 
 
        	<h 
        0<, h         0	<D
 
        P
<0
         
DP
         
<0
D        <0
        	<0	        DP	 D	          DP	 D	 (     
  @	 P	T 3         @	T 7!     1  $@	X     >  $P@	^     K  $P@	b     X  T	@	  h     i  T	@	  n     u  T	P@	s       T$P	  z       TP$	       TP         TP         TP         PT@	       \		
       \	P	       `P\	 
       Ph     0     T      E  8P  tT      L  8  8      V  T   8pT 	     d  T  8T $     n  p  TT /       dp  T >         dT T        p  dT X     @  pT c      | $   tT i     | tT m=   %  PT     @  d  (   ]  d      z  d        X d (     4 X (       ( 4 (        ( (       X      4 X     :  ( 4       R   (     o   (     (                       d     !  X d    ;  4 X    W  ( 4    t   (                 (     (         %       E     b             d       X d      4 X      ( 4    	   (    %       A  d \    [  X \d $   u  4 \X %     ( \4 )      \( *     \ .     /     3     4   <  8   X  \:   t  \>     \?     P \C     d , PF          (K       d   ,N     	  d    P     *	  d   U     B	  d  W   \	  d  ]   v	  d  _   	  X d Pe   	  4 ,X Pf   	  ( ,4 Pj   	   ,( Pk   	  , Po   
  ,Pp   3
   X ,t   N
  X  u   i
  Py   
  ,Pz   
   ,   
       
        
       
     
     %   pPT    F   P T   e  P x     P      Pt      0hd        Ph       xP,      xPx
   !  d\	t	\     *  d\	t	      3  d\	 
     <  ,`	<	     G  P	<,	     Q  ,<,P	     [  d<	+     d  d ,0	     j  d <,9	     t  d ,B     z  dhd F       TxPxN       PTxT       HT@PY       8T@H]       x(Tb
       xT(o     

  xTs     
   xw     
  xT~     6
  xT     A
  x     M
  dxx     f
  xTx     p
  xTx     z
  d x     
  dx     
  dx      
  dx      
  dx      
  Tx     
  Tx	     
  Tx     
  Tx     
   XTx     
  dx     
  dxx     
  dhxx       dXxh        8TxX        (Tx8       d HxX     (  Tx     3  xTx     @  dxx     L  xT
     Y  x     f  dx     r  xT
       xT
       x       dx
"      dx
)       xtx1      d x5      d x8      d xx=      dx E      xtL       dxQ       dxY     	  dxx^        dhd a     %  Txx8e
    /  hTxxr    9  XTxhu    C  HTxXz    M  8TxH    W   8xx    a  dHxx
    k  d8xH    u  dxhx       dxXh        Tx8
       Tx       Tx      T 8      Tx      Tx      T       x8      d(x8      dx(      d x      d8      dxT8
      xx    
  xx      @d  T     '    dT    9  ,      A      
   V   P   y   `  
     L` %
       L` 2        L 5      PL9      L` @   !   L` K   D   D    P   V      D W   h      t [   z  0     t i      0  t u       0 t w     p  t |     `D  p        `      hP    
                2  p  H    E  p  H    W  4 p    i  4     ~  4       4       4       ` 4       4`        4      P4     4` 	   4  4`    U  `    u  p , )"     ,$p  K	     T ,p T     ,T $\     ,T k     ,$ }     ,   .  ,$   ]      f        o  H ,    x  H,H       ,H       d            l hd        | d       l@|d        p@lh        p 4 &
       d 0
       h@d :
     
  h`4 D
        N     $  , c   D  , g   W  , j   v  P n	     |d w      4d        d        `d      `      ` ,       \p,       p\,       p\,    :  Dp ,    M  pD,    l  pD,      p,      \D` p       D \p       `\p       D  \P       D  p         D 	
       `   	   2  xP  pH 	   D  xD  PH 	   V  x`  Dt "	   h  9    D .	   y    9 D 4	     `    7	     x`  D <	
     DD xp F	     D  hD K	     P Dp O	     `Dp S	       DP V	     `  x ]	   $  @` p c	   7  `  @ f		   J   DP\po	   k   D\pPv	      PPDy	     DPP D	     @PDp	     @DpP	     XPPD@	   /    T 	   C  \P  T 	   U  d 	     b    	     q  ||d PT 	8     h|  |T 

     \  PT 
     @  hT 
     ,  T 
       8@  T $
     1  ,  8T 6
     H  @PH PA
   f  0 $\ @E
     0 \ J
      0 \ N
     0 \ R
     $ @V
       $ Z
   	  ^
   '  b
   D  0 p\ f
   `  0 @\ dj
       p$ n
       @$ dr
     pv
     pz
     @d~
     @d
   3  0 \ 4
   P    $ 4
   m  0 \ 
     0 \ 
       $ 
       $ 
     4
     4
     
   9  
   U  
   s  
       \ @
&     @
     p$@
     p$
     p
   !  p
    :  p
    S  t
    l  t
      t
      pt       tp      tdp     t@d
   
  t4@   &  t4   B  t   `  t   ~  t     t      x$        x/        x6        x;        x>       <x B        <xxI        x<Q     )   HxX     =   (xH^     Q   x(f     [   xj     d   8Hn     v   xPs        <xw        x|        h xPx      h Ph @      hxPh  
    !  XPh    !  <x     (!  <xx     8!   <xx     G!  xx     W!  <x     d!  <xx     q!  <xhx     ~!  <xXh     !  xX<     !  xHX     !  x8X     !  x(8     !  x     !  x     !  x     !   ,P8x   "  8@PX	   ("  ,P8#
     B"    \T -
     R"    T 7	     e"  `   @     u"    P U     "  8d Z     "   P8,b   "   P8d j     "  0,  `,T x     "  0P,d      "  8P      "  ,  ,d      "  0,\      "  0, \	     #  0,      #  h 
     #  h<      #  h      %#  , < h     +#  <     6#  <l     C#  l<     M#   P<P
     V#   p<P
     _#  PDp
     h#  P<pD
     q#   P<p
     z#  l<  
     #   < P,
     #  l <8
     #  p<l@

     #   <lpM
	     #  l`<V
     #  8`<``
     #  P<  j
     #    8,T r
     #  P8,~
     #  P,T 
     $  P,T 
     $$   PT 
     >$  0   T 
     M$  0P 
     \$  0PT 
     k$  0T 
     z$  0T 
     $  0P
     $    0 T 
     $  0 
     $  P0 
     $  P0 
     $   0T 
     $  `<8`      $  P<(`	     $  p       $  p       %   p  
     %   p -     #%    2     .%  T< 5     ;%  hP<PM     H%  P<hT\     V%  P<, k	     a%   xt     r%  < x     %  P {     %   x     %  <      %        %        %  P     %    P      %  <xx     %   x     &  x     &  x     "&   x     2&   x     B&   x     Q&  <hxx     ^&  <Xxh     k&  <x    y&  <x    &  <xH    &  x    &  xx    &  xx    &  xHx    &  xhx    &  xXh    &  xHX    &  <8H    &  8H    '  x8H    '   x8	    '  < 8    %'  <x(8    3'  <x(    A'  x<8    O'  x    ]'   8$    f'  x8'    t'  x/    '  x3    '   5    '  x:    '  x=    '  X xx8@    '  X x8xL    '  X x8xQ    '    xV    '  xxj    '  H x8xq    '  HxH x    '   <P     '   <HP     '  d      
(    0      (  0<H      &(  h8<0     hT l        T        T        T      h  T      h        P     8P      8      8             pP     |T tl      |\  tT        \T      |  \T      |  T      |t       hT l        T        T        T      h  T      h       \T tl      \\  tT        \T      \  t\T      \  T      \t       |,      h |,        h|,       h|       |,       ,      h      P h        P        P             h      hl      hT l        T      h  T      h       hl      T Pl      p  PT      8   PpT         (pT         P T      P       hH     0Hh     0h     0h     h     H     <|T |l 	     <  |T 
     d  |T      <  TT      <|  |T 
     <||       T @l      p  @T      (   @pT         pT        @ T      @       L|T l      L  T        T      L  dT      L|  T      L|       x
,      t

,      t
 
,      t

      xt

,      x\
t
,        `l !      PT `l "     HP  `T #      P  8T $      P`  %      8`Pl &     0l '     0PT l (     xP  T )     0P  HT *     0P  +     08Pl ,     `xL -     4 `L .     `4 /     `4 0     `1     L 2     `0xL 3     4 0`L 4     0`4 5     `4 6     `7     0L 8     |8x| 9     8d |x| :     `|xd ;     8|Pd <     8|x=     8x| >      X8L ?     4 X L @     @X 4 A     0 4 B     X C     xXL D      H8L E     4 H L F     0H 4 G     H H      4 I     xHL J      x| K     |xd  | L     | d M     |x d N     |x O     dx|| P     H$`Q     HR     <HS     <HT     $H<U     $V     0$<HdW     $0dX     L<0dY     $<0<Z     $<d[     $$Hd<\       XD  lE    XD  lE    lD  lE    lD  lE    D  lE    D  lE    D  lE    D  lE    D  lE    D  lE    XD  zE    XD mE    XD mE    XD  zE    XD {E    XD {E    D  zE    D mE    D mE    D  zE    D {E    D {E    D {E    D {E    D mE    D mE     m     m      m      m    Z  m    Z  m    n  m    n  m    D  D   C  D  D   C  D  D   C  D  D      D  D      D  D      D  D      D  D   C                               C       C       C       C             C      C     C    C   $  C   $  C  %  C   2  C   2  C  3  C  3  C    C     C   $  C   2  C  %  C  3  C D 2E  C D 2E  C  D 2E  C D 2E  C D %E  C D $E  C D $E  C D  E  C D E  C D E  C D  E  C D  E  C D %E  C D 2E  C D $E  C D E  C D  E  C D  E  C  B     B     B  A   8  A   8     B  n   B    8    8  B   B     B          8     8     0C  D   0C  D     D     D     D   0C  D   0C  >D     >D     D   0C  8D   0C  C     C     8D     ]E      ]E      ]E      ]E      ]E      ]E      ]E    P  ]E    p  ]E      ]E    0B  ]E    0B  ]E    lD  ]E    lD  ]E    D  ]E    D  ]E    ,C  ^    P  ^    P  ^    C  ^    ,C  ^    C  ^    C  ^    C  ^    C  ^    C  ^    D  ^    D  ^    D  D      D  D  B  D  D  B  D  D      D  D  B  D  D      D  D      D  D  B  D  D  B  D  D   C  D  D   C  D  D   C  D  D   C  D  D      D    B  D    B  D      D      D    B  D    B  D      D      D      D       D       D    B  D     B  D     B                      B       C       C       C       C      B      B      B       C                    ZE      ZE      ZE      ZE    lD  ZE    lD  ZE    4D  ZE    4D  ZE    LD  ZE    lD  ZE    D  ZE   D  ZE   D  ZE    D  ZE    D  ZE    D  ZE    D  ZE    D  ZE    D  ZE   D  ZE    0B  ZE    0B  ZE    lD  [E    D  [E    lD  [E    D  [E      ZE      ZE      ZE      ZE      ZE    p  ZE    P  ZE     [      [     [     [     [     [      [     [     [    S  [    n  [    n  [    S  [    6  [    6  [    N  [    n  [    N  [    6  [    C  [    C  [    C  [    C  [        _  8    _  8  B  _  8  q  _    q  _  8    _  8   _     _  8    _      _      _  B    _  B    _  B    _  B  n  _  B    _   B    _  B  q  _  B    _   B    _  8    _  B    _  B    _  B  D  _  B  D  _    D  _    D  _    nD  _  B  nD  _    8D  _    C  _  B  C  _  B  >D  _    C  _  B  C  _  B  D  _    D  _    D  _  0C  D  _  0C  D  _  0C  >D  _  0C  D  _  C  C  _  0C  C  _  0C  8D  _      \      4      4      \  B      B      B      B                        B                        B      C      C    p  C    p  B    p  C      C                  8            B      C      C      B    4  B    \  B    \  B    4   B    
  B    
  8    
  8    B   B    B  B    B      p      p                  p  e D  B  e D  B  e D  B  e D  B  e D    e D    e  E  C  e  D  C  e  D  C  e  D  B  e  E  B  e E  B  e E  C  e E  B  e  D  B D 3E  @ D 2E  @ D ,E  @ D ,E  \ D 3E  \ D ,E   D 3E    D  D      D  D  B D  D     D  D  B  D  D  B  D  D     D  D     D  D  B  @  D  B  @  D  B  @  D    @ D    @  D    @  D  B  @  D  B  @ D    @  D    @  D  B  @  D  B  @ D    @  D    @ D    @ D  B  @  D  B  8  D  0    D  0    D    8  D       D       D        D  0    D       D       D  0    D      D      D      D      D      D      D      D    C  D  0  4C  D  0  B  D  0  B  D     C  D     C  D     C  D     C  D     C  D  0   C  D    B  D     B  D    B  D     C  D    C  D    C  D    B  D      B  D  B  B  D  B    D  B    D      4C  D    C  D    C  D      D  "    D  "    D  "    D  "   D  "    D  "  '  D  "  '  D  "  '  D    '  D    '  D    '  D    '  D    '  D  "  '  D  "  '  D  "  '  D    '  D    '  D  
  '  D  
  '  D    '  D    '  D    '  D  
  '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D    '  D  8  '  D  8  '  D    '  D  8  '  D  8  '  D    '  D     '  D     '  D     '  D     '  D     '  D  0   D      D      D      D      D      D      D  
    D  
   D  
    D  
    D  
    D  
    D      D      D      D      E    P  E      E      E    P  E      E    B  E    A  E    A  E    B  E    C  E    pC  E    pC  E    C  E    C  E    C  E      HE      <E      :E      :E      >E      HE      VE      JE      LE      VE      XE   D %E  @ D  E  @ D  E  @  D @"E  @D0O"E  @ D %E  @  D %E  @  D\"E  @ D  E  @ D %E  @  D %E  @  D @!E  @ D  E  @  D %E  @ D 2E  @ D 2E  @ D-*E  @ D 3E  @  D 3E  @  D 2E  @ D 2E  @ D$I5E  @ D 3E  @  D 9E  @  D 9E  @ D 3E  @  D 3E  @  D 3E  @ D 3E  @ D 3E  @ D-6E  @ D 9E  @  D &E  @ D &E  @ D 2E  @  D 2E  @ D 2E  @  D ,E  @ D *E  @  D &E  @ D %E  A D %E  A  D %E  A D %E  A  D 2E  A D 2E  A D 2E  A D 2E  A D  E   C D  E   C D &E  \ D &E  é*D +E    4D  LE    4D  WE    lD  LE    lD  JE    LD  JE    4D  JE    D  LE    D  JE    D  JE   D UE   D  LE   D  JE    D GE   D GE   D  <E    D  <E   D 9E    D 9E    D 9E    DD  IE    4D  IE    LD  IE    DD EE    #D EE    D EE    D  FE    D  IE    LD  GE    LD EE    C @@E    C FE    C  ME    C  ME    C  FE    C  ?E    C  ?E    C  8E    C  8E    C FE    0B FE    0B  LE    0B  ME    C  ME      LE      XE    0B  >E      >E      JE    0B  :E    A  :E      :E      <E    D 3E    D +E    D +E    D ,E    D &E    D &E    LD  9E    #D  9E    #D  8E    D  8E    D  8E    C @2E    D  *E    C  *E    D  E    C @$E    #D  ,E    #D  *E    #D  E    P @$E    A @$E    pC @$E    P  XE      XE      XE      XE      JE      <E      :E      :E    P  :E    P @2E    P  ,E      ,E    LD  GE    LD EE    LD  9E    LD  JE    LD  IE   D 9E  \  D 9E  \ D 9E    D 9E   D GE   D  <E   D :E   D UE   D  LE   D  JE    D  JE    D  JE    LD  LE    D  LE    D  LE    D  JE    D GE    D  <E    D :E    D &E  \  D 3E  \  D ,E  \  P @2E    P  :E      :E      :E      ,E    P  ,E    P @$E    A @$E    pC @$E    C @$E    D  8E    D  8E    C  8E    C  8E    C @2E    C  *E    D  *E    D  E    D  E    #D  ,E    #D  8E    #D  *E    #D  E    #D  9E    #D EE    D EE    DD EE      LE      >E      LE      >E      :E    0B  LE    0B  ME    0B  >E    0B FE    A  :E    0B  :E    C  ME    C FE    C FE    C  ME    C  FE    C  ME    C @@E    C  ?E    C  ?E    DD  IE    4D  IE    D  IE    D  FE    4D  WE    4D  LE      XE      XE    D  D   C  D  D   C  D D   C  D  D   C  D  D   C  D D   C  D D   C  D D   C  D D   C  D  D   C  D  D   C  D D   C D  E   C D  E   C D  E   C   E     E     E     D     D      D  0   D  0    D  0    D     D      D     E  0   D  0   E  0    D  0    D    C E  vbKC E    C E    C  E    C  E    C  E    C  E    C  E    C  E    D  E    D  E    D  D    C  D    D  E    D E    D  E    D  D    C  E    D  E    D  E    #D  E    P E  |   E  |  ëE  |   @E  |  P @E  |  P E  $   E  $  ë	E  |  P«	E  |  hD E  0  0D E  0  0D  E  0  hD  E  0  D E  0 D  E  0  D  E  0 D  E  0 D E  0  D E  0  D E  0 D͌E  0  D͌E  0  D E  0 D E  0 D  D  0  D  D  0  D  D  0  0D D  0  0D D  0  0D D  0  0D E  0  hD D  0  hD  D  0  UD  D  0  0D  D  0  D D  0  D  D  0 D  D  0  D D  0  D  D  0  D  D  0úD  D  0 D D  0 D  D  0 D D  0  D D  0 D D  0  UD D  0úD D  0   D  0   D  0  T D  0   E  0   E  0   C D  0  B D  0  B E  0   C E  0  C D  0  C D  0  C E  0  C E  0  D D  0  D D  0  D E  0  D E  0  UD  D  0  PD  D  0  0D  D  0  0D D  0   C  D  0   C D  0   C  D  0  C  D  0  C  D  0   C  D  0  C  D  0   C  D  0  D  D  0  D  D  0  D  D  0  PD  D  0  PD  D  0  UD  D  0  UD  D  0  UD  D  0  B  D  0  C  D  0  C D  0  B D  0  B  D  0  C  D  0  B  D  0  B  D  0  B  D  0  C  D  0  C  D  0  B  D  0  C  D  0  B  D  0  B  D  0  B D  0  B  D  0  T  D  0  T D  0  T  D  0  T  D  0  T D  0   D  0  T  D  0    D  0  @A  D  0    D  0    D  0  @A  D  0    D  0    D  0     D  0    D  0    D  0   D  0   D  0    D  0   B  D  0    D  0    D       D       D     C D      C D      C D  B  C D  B  C D  B  C D  B  C D      C D      C D      C D  B  0D D  @  0D D     UD D     UD D  @ D D! D D  B  YD D  B  UD D  B  UD D     D D! D D   D D  B D D  B.D D    0D  D     0D  D  @  0D  D  @  0D D  @  0D D    0D D    0D E    0D E    0D  E  @  0D E  @  0D  E  @  0D  E    0D D      0D  D      0D D      0D D  B  0D D  B  0D D  B  0D @E      0D  E      0D D  B  0D E  B  0D @E  B  0D  E  B  0D  E     D  E  @ D  E  @ D  E  B D  E  B D  E  B D  E  B D  E  @ D  E  B  D  E  B D  E  B  D  E  @ D  E  @ D E  @ D E  @ D E  @ D  E  B D  E  @ D  
E  B D E  B D  D  B D  D     D  E     D  
E     D  E     D E   D  E   D  E  @ D E  @ D E   D E" D  E   D E   D  E  @ D @E  @ D  D  @ D  D   D D  B D D  B D D   D  D      UD  D      UD @E     D @E      D @E      D  D      UD  E      UD E      UD  E      UD  D      UD  D      UD  D      D @E      D  E      D  E      UD D  B  UD D  B  YD D  B  YD D  B  YD D  B  YD E  B D E  B  hD E  B D D  B  D E  B  D E  B  hD  E  B  D  E  B  D  E  B  hD  E      D  E     D  E      D  E  @  D  E    D  E  @ D  EZk D  E   D  E[k D  E   D  E    D  E    UD  E  @  hD  Ej%  UD E  @  UD  E  @  UD @E  @  UD  D  @  UD  D  @  UD  D  @  UD  D  @  D  D  @ D  D  @ D @E  @  D @E  @  D E    D E    D  E  @  D @E  @ D E   D E[k D E   D E   D EZk D  D  D  D!  C D  B  C D      C D      C D  B  C @E]_  C @E    C @E  (C @EB @E  ,C @E(C @EI  C @E     C @E   C @E  ,C E   E  $  ,C E  $  C E̓  C E    C E   /C E  $  C E    C E     CE̓  C @
EB  C E  C @
EB  C E
*B  C E

*B  C D  B  C D  B  C @
ER  C Ewx  C @
ER  C E,--  C E---  C D      C D      C E      E    B E    C E    D E    B D     D    C D    D D    C D      C D      C D  B  C D  B  C D  B  C D  B  C D      C D      C D  B  C D      UD D      UD D  B  UD  D  B  UD  D      UD D  B  UD D      UD  D      UD  D  B  UD  D     UD  D     UD D     UD  D     UD  D     UD  D      UD  D  B  UD  D  B  UD  D      D D  B  D D      D D      D  D  B  D  D      D D      D D  B  D D  B  D  D  B  D  D  B  D  D      D  D      D D      D D      D D  B  D  D      D  D  B  D  D      D  D      D  D  B  D D  B  D  D  B  D  D      D  D  B  D  D      D  D      D  D  B  D  D      D  D      D  D      YD  D      YD  D  B  D  D      D  D  B  YD  D      D  D      D  D  B  YD  D  B  YD D      UD  D      YD D      D D      D D      UD  D  B  YD D  B  YD D  B  D D  B  D D  B   D     D      D      D     D      D    `  D    ` D     D      D    `  D    ` D     D    ` D    `  D      D    0 D      D       D    0  D     D    ` D    `  D      D    0 D      D       D    0  D     D    ` D    `  D      D    @ D     B D     B  D    @  D    @ D     B D     B  D    @  D     D    ` D    `  D      D    0  D       D      D    0 D      D    `  D    ` D     D    0 D      D       D    0  D    `  D    ` D    `  D    0  D    0 D    0  D    0  D    `  D    0 D    0  D    0  D    `  D     D      D      D       D      D      D      D      D      D    @ D     B D     B  D    @  D    @  D     B  D     B D    @ D       D    @  D    @ D    @  D    @  D       D    @ D      D     B D     B  D     B  D    PB  D    PB D    PB  D    PB  D    PB D    PB D    PB  D    PB D    PB  D    PB D    PB  D    PB  D     B  D    PB D     B D    B  D    B  D    B  D    B D    B  D    B  D    B  D    B D    B D    B  D    B D    C  D    C D    C D    C  D    B  D    B  D    C  D    C  D    B D    B D    B  D    B D    B  D    B D    B  D    B  D    C D    C  D    B D    B D    B  D    B D    B  D    B D    B D    B  D    B  D    C  D    C D    B  D    B  D    B  D    B  D    C D    C  D    B D    B D    B D    B  D    B D    B D    C D    C D    B  D    B  D    B D    B  D    C  D    C  D    B D    B  D    B D    B D    B  D    B D    C D    C D    B  D    B  D    B  D    C  D    B D      D     D    C  D  B  C  D  B  C  D      C  D      C D      C D  B  C  D  B  C D  B  C D      C  D      C  D      C  D  B  LD  D      LD  D  B  'D  D  B  'D  D      C  D  B  C  D      D  D      D  D  B  C  D  B  C  D  B  D  D  B  D  D  B  D  D  B  LD  D  B  0D  D  B  LD  D  B  C  D  B  C  D  B  C  D  B  D  D  B  D  D  B  0D  D  B  C  D      C  D      C  D      C  D      D  D      D  D      D  D      D  D      0D  D      LD  D      LD  D      C  D      C  D      D  D      0D  D      D D  B  D D      D  D      D  D  B  'D D      'D D  B  'D  D  B  'D  D       D  B    D  B   D  B    D  B   D  B  B D      B D  B  B D  B  B D  B  B D  B  B  D  B  B D  B  B D  B  B D  B  B D  B  B D       C  D     C  D     D  D     'D  D     0D  D       D       D       D      D      D    `  D    C  D     B  D     C  D     B  D    0  D    B  D    C  D    B  D     D       D      D       D      D      D       D       D       D       D      D       D      D       D       D     C  D     C  D     C  D     C D     C D     C  D     C D     C  D     C D     C  D     C D     C  D     C  D     C  D     C  D     C  D      C  D      C  D     B  D       D     B  D     C  D     C  D     C D     C  D     C  D     C  D     C  D     C  D     C  D     C D     C D     C  D     C  D      C  D     C  D     D D     D  D     D  D     DD D     'D D     D  D     DD  D     PD  D     C D      C D     D D     C D     D  D     'D  D     'D D     D D     'D  D     C  D    B  D    B  D    PB  D     B  D    @  D    `  D      D       D    0  D    C  D    C D    C  D    C  D    C D    C D      D     D      D      D     D     D    B D    PB D    B D    @ D     B D    0 D      D    ` D    B  D    `  D    0  D       D    @  D     B  D    PB  D    B  D    0 D    0  D    0  D    0 D       D    @  D     B  D    B  D    B  D    PB  D    @  D    @ D    B  D    B D    B  D    B D     B D    PB D     B  D    PB  D       D      D      D     B D    @ D    B D    PB D    B D    ` D    `  D    `  D    ` D    C D    B D    B D    PB D    @ D     B D    0 D      D     D    ` D    @  D    @ D    C  D    C D    B D    PB D    B D     B D    B  D    B  D    PB  D     B  D      D       D    0 D     D    ` D      D    0  D    `  D     D      D     D      D      D      D     D    C D    C D    C  D    C  D    C  D    C  D    C  D    B  D    B  D    PB  D     B  D    @  D    `  D       D    0  D    0 D    0  D    B D    B  D    B D    B  D    B  D    B D    B  D    B D    C D    C  D    C  D    PB D    @ D     B D      D    `  D    `  D    ` D    `  D    ` D    ` D      D    T  D      D     T D    P D    P D    P D  B   D  B  P E    P E  B   E  B  P E    T  D    T D    T  D       D       D       D       D     ëE  $   @E  $   @E(L   E`u  ,C EA%  B @EҩM  P @E  $  B @ES  C @E̓  ,C @ED%bCEր  C  E    C  E    C E    C  E    C  E    C  E    C  E    C  E    C  D    D  D    D  D    D E    D  E    D  E    D  E    #D  E    C  E    D  E    D  E     E     E     EV  UE     E     E      E      E}}    E  N E    C E  vbKC E    P E    P E    PUE  ÕoVE    P  E    P  E    C  E    C  E  C  E    B  E  B  E    D  0    D  0    D       D  0    D       D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D    '  D    	  D      D    	  D     E  B  ' E  B  ' D  B   D  B   D    ' D    ' E     E     D      D      D      D      D      D      D       D       D       D       D       D       D       D       D  X    D  H    D  H    D  h    D  h    D  h    D  x    D  x    D  X    D  H    D      D  @    D  H    D  @    D  8    D  8    D  8    D  0    D  0    D  0    D      D    	  D    	  D      D      D      D      D      D  8    D      D      D    
  D    	  D      D      D      D      D      D      D      D      D  x    D  0    D  8    D  8    D  8    D  H    D  H    D  H    D  X    D  X    D  X   D  x    D  h   D  h    D  h    D      D    	  D      D      D      D     D      D      D      D      D      D      D    
  D     D      D     D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      D     D      D      D      D     D      D      D      D      D      D      D    
  D      D     D      D      D     D      D      D      D    
  D    	  D      D      D    	  D      D      D      D      D      D      D      D      D      D  
    D  
    D  
    D  
    D  
   D      D      D      D      D      D     D      D      D      D      D    	  D      D      D  "    D    
  D      D    	  D      D    
  D    	  D      D      D  "    D  "    D      D    	  D      D      D    
  D      D      D    
  D      D    	  D      D    	  D      D  "    D    	  D      D      D      D      D    	  D      D    @ D    @ E    @ E  B  @ D  B    D  Z    D  Z    D  2    D  2  '  D  2  '  D  2  '  D  V  '  D  V  '  D  2  '  D  6  '  D  6  '  D  2  '  D  &  '  D  *  '  D  *  '  D  *  '  D  &  '  D  &  '  D  .  '  D  2  '  D  .    D  Z    D  Z    D  F    D  V    D  V    D  J    D  F    D  >    D  B  	  D  B  	  D  >    D  :    D  >    D  :    D  2  '  D  :    D  B    D  F    D  B    D  2    D  2    D  &    D  *    D  .    D  2    D  2    D  2    D  V    D  V    D  V    D  2    D  2    D  V    D  V    D  V    D  V    D  V    D  V    D  V    D  V    D  V    D  N    D  J    D  R    D  R    D  N    D  2    D  .    D  .    D  *    D  *    D  &    D  2    D  2    D  2   D  2    D  2    D  2    D  &    D  &   D  &    D  .    D  .    D  .    D  *    D  *    D  *    D  2    D  .    D  &    D  *   D  *   D  &    D  .    D  .    D  *    D  2  	  D  2    D  J    D  N    D  R  	  D  B  	  D  >   D  J    D  J  	  D  :    D  :    D  B    D  >    D  >    D  F    D  F    D  R    D  R    D  N   D  N  
  D  :    D  :   D  6    D  6  
  D  >    D  _    D  _   D  C    D  C    D  B   D  B    D  C    `D  C    [D  C    #D  C    C  C    C  C    LC  C      C    t  C      C      C    D  @    D       D       D  @   D  B    kD  B    `D  B    kD              t      t  p      4            p    LC      LC  p    C      C  p    #D      #D  p    C  p    [D      [D  p    (D  p    `D      `D       `D  p          C      C            0            C      C      C    C  D  C  C D  C  C D  B  C D  B  C D  B  C D      C  D      C  t  C  C    C  C  LC  C  C  C  C  C  C  C  C  #D  C  C  [D  C  C  `D  C  C  kD  C  C D  C  C  D  C  C    C  C    C  C D  B  C D  B  C D  B  C    B  C  t  B  C    B  C  LC  B  C  C  B  C  #D  B  C  [D  B  C D  B  C    B  C  t  B  C    B  C  LC  B  C  C  B  C  #D  B  C  [D  B  C  `D  B  C  lD  B  C  lD      C D      C       C  t     C    4  C  t  p  C       C    p  C  LC     C  LC  p  C  C     C  C  p  C  #D     C  C  p  C  C  p  C  #D  p  C  [D     C  (D  p  C  [D  p  C  `D     C  `D  p  C      C  C    C  C    C      C  0    C      C  C    C  C    'D D  B  'D D  B  'D D      'D D      D D  B  D D      D D      D D  B  D D  B  D D      D D      D D  B    C      C      C    B  C    B  C    C  C    C  D  C  4C  D  C  C  D  C  C D  C  C  kD  C   C  kD  C   C  `D  C   C D  C   C  D  C  B  D  C  B D  C  B  kD  C  B  D  C  B  `D  C    `D  C    kD  C  B  kD  C  B  kD  C     `D  C    `D  C    C  C  0 D  C  0  D  C  B  D  C  0  D  C    D  C   D  C     D  C    D  C     D  C     kD  C    D  C    D  C      C    C  p  H  C  p    C  p    C      C    B  C      C      C    B  C      C  4    C  \    C  \    C  4  B  C    B  C    C  C  p  B  C  p  B  C  4  B  C  \  B  C  \  B  C  4    `D  p    (D  p    C  p    C  p  H  C  p    C  p    `D  p    @D  p    (D  p    D  p    C  p  L  @D  p  L  (D  p  L  D  p  L  C  p  A  C  p  B  C  p  B  C  p    C  p    C  p  B  C  pÚB  C  p  4C  C  p  C  C  p  C  C  p  H  C  p  A  C  p  A  C  p  L  `D  p  A  `D  p  A  (D  p  4C  `D  p  4C  @D  p  4C  (D  p  4C  D  p  C  @D  p  C  (D  p  C  D  p  C  `D  p  4C  hD  A  4C  dD  A  4C  `D  A  4C  `D  A  4C  hD  A  4C  kD  A  4C  kD  A  4C  kD      4C  hD      4C  hD    4C  kD    4C  kD     4C  dD     4C  dD    4C  `D     4C  kD  0  4C  hD  0  4C  dD  0  4C  `D  0  4C  `D    4C  `DUU5  4C  LD  P  C  lD    C  lD    C  lD  0  C  lD  0  C  lD      C  lD  B  C  lD  A  C  lD      4C  pD    4C  lD    C  D      4C  D      4C  D  B  4C  lD      4C D      4C  pD  0  4C  lD  0  C  `D  B  C  hD    C  dD    C  `D    C  `D     C  `D  0  C  dD  0  C  hD  0  C  hD      C  hD  A  C  dD  A  C  `D  A  C  `DUU5  C  LD  P    kD      kD      kD  0    kD  0  L  kD  A  L  kD         kD         kD  A  L  kD  A    kD        kD  A    kD  B    kD  B    kD  A    kD  A     kD  B    kD  B  A  kD    8  kD    L  kD    L  kD  0  8  kD  0  A  kD  0   B  kD  0   B  kD    C  kD  A  C  kD      B  kD  B  B  kD  A   C  kD  A   C  kD  B  B  kD  B  B  kD  B   C  kD  B  B  kD  A    kD  A    kD      @  kD      B  kD      B  kD       C  kD      B  kD  A   D      pD    8  pD     B  pD      D        D  B    D  B     D  B  B  D      @B  D      0  D         D      B  D  B  B  D  B   C  D  B  B  D       C  D  B  B  D  B    D      @  D      @  wD      @B  wD      B  wD      0 D      0  D       D      @B  D      B D      C D       C D       C D  B   D  B  @  wD  A  @  D  A  @B  D  A  @B  wD  A    D        kD       D  0    pD  0  8  pD  0   B  pD  0  B  C  L  L  hD      L  hD  A  L  `D  A  L  `D  A  L  dD  A  L  dD    L  `D    L  hD    L  `D    L  `D  0  L  dD  0  L  hD  0  L  `DUU5  L  LD  P    C  L    C  L  B  C  L  B  `D  A  PB  `D    PB  `D  A    `D    A  `D    B  `D  B    `D  B   C  `D  B     `D  A    `D  A     hD  A    hD  A    hD  A    hD  A  B  hD  A  B  hD  A   C  hD  A    hD  B   C  hD  B     hD  B  B  hD  B  B  hD  B    `D  B    `DUU5    LD  P    hD  0    dD  0    `D  0    `D       `D      dD      hD      hD  A    dD  A    `D  A    hD        t  p      p      p    t  \      p    T  p      \    LC  p    @A  p    LC  \    C  p    lC  p    C  \    t            t            T            LC      @A      LC      C      lC      C    B  t    B  t  \  B      B    \  B  LC    B  LC  \  B  C    B  C  \  B  t  \  B    \  B  LC  \  B  C  \  B    p  B    p  B  t  p  B  T  p  B    p  B  @A  p  B  LC  p  B  lC  p  B  C  p  B  t    B      B  t    B      B  T    B      B  LC    B  @A    B  LC    B  C    B  lC    B  C      t  \      \    LC  \    C  \    t            LC      C     B    
  8    
  8             B      B      B    
  8    B   B    B   B    _  8    _  B    B  B    _    C      C    C  C    HC  C    0C  C    C  C      C  >    C  
  C  C  >    C  B  0C  C  
  0C  C  >  0C  C  B  HC  C    C  C    HC  C    0C  C      C      C      C    C  C      0    C  0    C      0C  C  
  0C  C  B  0C  C  _    C  
    C  B    C  _  C  C  
  C  C  B  C  C  _   D  B   D  @   D    @ D  B  @ D      D  B    D  @    D    a D    e E    a D  B  a D    a  D  B  a  D  B  a D  B  a  D  B  a D  B  a  D  B  a D  B  a D    a  D    a D    a D    a D    a D    a  D    a D    e  D    e  D      D  PB    D      D      D      D  C    D  C    D  C   E      E      E  PB   E  PB   E  C  l E  C  l E    l  D  C  l  D    l  D    l  D  C    D      D  PB    D  PB    D      D  B    D  B    D  B    D  PB    E  PB    E  PB    E  B    E      E      D      D  PB    D      D  PB    E  PB    E      E  PB    E      D      E  B    E      D  B    D      D  B    D    D     D      D    PB  D   PB  D    PB  D    PB  D      D      D    PB  D    C  D    C  D   C  D    C  D    PB  D      D      D    PB  D    PB  D      D      D    PB  D    PB  D    B  D     B  D    B  D    B  D       D      D    PB  D      D    PB  D    PB  D      D    PB  D      D     D     B    Z  B    Z  C    Z  C    Z  cD    B  cD   B  cD   B  cD   B  cD   C  cD    C  cD    C  cD    C  cD    B  cD     cD    D      cD     D    C D   C  cD    D    D    C D    D     %D    
  D    
  D    
  %D    
  C   
  C    
  C    
  C    
      L      L  B    L  B    L     p  C   p  C    p     p      p     p  B    p      p  C    p  C    p  B    p  B   p     p  B    p  C   p  C   p  C   p  4  @  -  @  -  \  4  \  -    4    >D     >D      >D     >D   B  >D    B  >D   B  >D     >D     >D   B  >D   B  >D     >D     >D   B  >D   B  >D   B  >D    B  >D      >D     _D      _D    B  _D   B  _D     >D     >D   B  _D    B  _D   B  _D     _D      _D    B  _D   B  _D     _D      _D    B  _D   B  _D     _D      >D     >D   B  _D   B  _D     >D   B  >D     H                0  H    0  <    0      0              H                  B      B      B      A            B      B      B      B      B      B                B    B      B  C      xC      C      C      C      C      B    0  DC    0  C    0  C    0  C    @  C        C       C       C   @  C  o      C  o  B  C   B  C  ,  B  C  Q  B  C  d  B  C  d     C  ,     C  d  p  C 9  p  C  ,  p  C    B  C  Q  B  C  p  B  C   B  C    B  C  8  B  C     B  C  p  C  C   C  C    C  C    B  C  8  C  C  d  C  C  o  C  C     C  C    C  D     D   @  D   B  D    @  D    B  D         B                     B     C     B     B     B      C    p  B    p               p  B    d  B    d  C    d      ,  C    ,      ,  p   9  p    D  p    d  p    d         C  C  d  C  B  d  C    d  C    d  C  <  d  C    d  C  C   C  C  o  C  C  o  C  C    C  C   C  C    C  C    C     C    o  C      C      C     C      C    o  C  <  o  C    o  C     C     C  <   C      C      C  C 9  p  C  d  p  C  D  p   9  p    D  p    D  p   9  p    D  p  <  D  p  C 9  p  C  D  p  B  D  p  DC  D  p  B  d  p    d  p  <  d  p  DC  d  p  B  d  p    d  p    d       d      d  A    d  B    dUU5    d  H    d      d  A    d  A  <  d  A  <  d  A  <  d    <  d  0  <  dUU5  <  d  H  p  d    B  d    B  d  A  dB  d  A  p  d  A  DC  d  H  DC  dUU5  DC  d  0  DC  d    DC  d  A  DC  d  A  C  d  A  B  d  H    d  B  B  d  B  C  d  B  C  d  B  C  d  A  C  d    C  d     C  dUU5  <  P  P  DC  P  P  C  P  P    P  P    h      l    <  l    <  h    <  o      p      |    <  |      p      |          H      <      C  o    C  o    C  l    DC  l    DC  o    DC  h    C  h    A      xC      B      C      C      B  o    C  t    C  o    C   B  C    B  C  o  A  C  o  B  C  o  B  C       C        C  o      C  l  B  C  l  A  C       C  o  A  DC  o  A  DC  o      C  o      C  o  A  C  o  B  C  o      C  o      C  h  A  C  l      C  l  A  DC  l  A  DC  l  A  DC  l      DC  h  A  C       C       C        C                                    B  B    B          B          h  A    l  A    p  A    p  B    l        p        o  B    o  B    l  B    o  A    l  A    o                B    o  B    o  A    o      dB  o  A  B  o  A  B  o      B  o  B  B  o  B  B  o  B  B  l  A  dB  l  A    l  A  B  l  B    l  B  B  l  B  dB  |  A  dB    A      A    |  A  dB  |      B  |      B        dB          |        |                                    <  o  A  <  o      <  l      <  l  A  <  h  A  <  o  A    o  A    o      <              C    0  C  t  0  C  r  0  C  o  0    p  0      0  <  h  0  <  o  0  <  l  0  DC  h  0  DC  l  0  DC  o  0  C  o  0  C  oĬ&  C  l  0  C  h  0  C  r  0  DC    0  DC  r  0  B  o  0  B    0  <    0  <  r  0  B  r  0  B    0  <  p  0    p  0    h  0    l  0    r  0      0  )   B  )       )        )    B     B     B                   B      B             B  %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D      %D    
  %D    
  %D      %D      %D      %D    @  %D    @  %D      %D      %D      %D      %D      %D      %D      %D    @  %D    @  %D      %D       %D       %D       %D       %D    0  %D    0  %D       %D   B  %D   B  %D     %D     C      C      C     C          C      C       C      C      C       C       C       C      C      C       C  3   C  3   C  3   C      C       C      C  %   C     C  %   C     C  C     C      C      C      Ė{/                 @    B    B     0    0  W   B  W       v ľztp   0ú   0tp ļz  W   @  W      W   0  2      2   @     B                   B      B          p                 B  W    B  W        W   0  W    0  W    0  W       W       W      W       W    0  W   B  W       W        W    B  W       W   B  W    B  W                                                                                                                                                                                                                                                                                                                                                                                                                        p      @      @              B      @B      B      B      B          @      @      @     @     p     p      @     @     @      @      p      p     p     p      @     @     @      @      p     p      @     @     @      @      B      @B      @B     B     B                    B      B     @B     @B      B      B                     B     B     @B     @B      B      B                    B      B     @B     @B      B      B                    B      p     p      p     @     @      @     @     @      @                           B      B     B     B      B      @B      @B     @B      @B     @B      @B      @B     @B      @B     @B      B      B     B      B     B      B     B      B     B      B      B     B      B     B                        B      B     B                     B  B   B  B    B  B   B  B   B  B    B            B      B     B            B      B      B                                              B      B      B      B      B          )    B  )        )   B  )                 B              B      B                      B      B                      B      B      B      B  W    B      B  2    B      B      B  2    B  U   B  2   B                          W                        2                2        2       (       (    0  (   0  (      (    0  (       (       (    0  D    0  D       D      D      D      C    `  C      C    0  C    0  C    0  C       C       D      D      %D      C      C      D      D      D      D      C      C      C      C      C      C      C      C      B       B    `  LC    `  LC      C      C    0  B    0  LC    0  B                  0      0      0  B    0  B    0  B       C      C     C      D      D         0      0                          0              B    0  B       B       B    0  B      B      B    0  B      B            @B      B       B      B       B      B       B       B       B      B      B      B       B       
D       C       C       C       C       
D       D       D       D       D       D       C       C       B       B       B                                                                                                                                                                           (       B              p            B      @B      @      @                                                                                    B     B      B      B     B     B      B     B      B     B     B      B     B      B      B     B      p     p      @            @      @                      p      p     @     @      @      @     @     p     @     @      @      p                            @     @            p     p      @     @      @     p     @     @                     B     B      @B     @B      B      B     @B      @B     @B     B     @B      B      B     B      @B     @B      @B     @B      @B     @B      @B     @B      @B      @B     B      B     B      B     B      @B      p     @     @            p      @              @                                                                                                                                                                                                              B   0  B    0  B    0  D      D      D      C      C      D      C    x  C    h  C    H  C    @  C    8  C    0  D    0  C      C    0  C    0  C    X  C    H  C    h  C    h  C    x  C    H  C    H  C    @  C    X  C    8  C    8  C    0  D      C      D      D     C      C    x  D      C    8  C    H  C    X  C    h  D      D      D      D      D      D      D      D      D      D      D      D      D      D      D      C    8  C    0  C    8  C    H  C    H  C    h  C   h  C    X  C   x  C    X  D      D      D      C    0  C    0  B    0     0     0     0      0      0     0     0  (    0     0      0     0      0  B   0      0  C      C      C      C      C      C      C      C      C      C      D      D      D      D      C      C      C      C      C      D    ñD      D     D      D      C      D      D      D      D     D      D      D      D     D      C      C      C      C      D      C      D      D      C      D      D      C     C      C      LC      LC    0  LC   0  LC     C    0  C      C     C   0      0             0      0         <    0      0  <       2                                          <              <       2    0  2    0  2   0t8   0      0      0      0      0      0      0      0      0      0              B      B             B                   B      B     B      B                           B  [       [   B     B  [   B         [                  B      B  [    B  [    B          [        [                    B                                   B              B      B      B                                   B     B     B      B         HC @%    HC      C      C      C  -    HC  -    C  ;    HC  ;    4 @%     @%      %          4      0B @%    0B      C  Y    C  Y    C  N    C  N    C  N    C  Y    C  Y    D  N    D  [    C  I    C G    C  ;    ,C  ;    C  ;    C  I    D  ;    D  ?    D  I    D  M    C  [    C  [                   	     	     	           	     	    
 	    
  	    
                                          
      %      %        %    %  %      3    %  3    %  ,      9      9      9    %  9     +      3      9   ķ-+    '    '    5  3 5    :    :     '     -     4  ̇ 5     :    P  ;    @ G    P G      N      N     G     G     G    @  N    P  N    4 G    P  [      @     9      :      :    %  :    N  H    N  =    N  :    2  :      H      J    2  J    6  J    N  J      <      H      J    N  X    N  K    6  M    6  X    N  Y      Y      X      K    n  K    n  Y    H     ?      =     H      J     J     M     X      @    @  &  @  &  A  %  A    A    A     A     @  3  A     B  2    B  2    B  2    B  2        2 @	      2        2    B  2    B  2       2        2    B  2    @  2       2      2    0  2    0  2      2     2   0  2    @  2   @  2   @  2     2 @	  @  2    @  2    0  2    0  2   0  C   B  C   B  HC   B  HC   B  C   B  C   B  D   B  D   B        4      0B      HC      C      C      C      C     C     C     C   0  C   0  C    0  C   `  C     C     D     D     0B   |  C   |  C @  |  0B @  |   @     @     @Q`   @      @   i B @  $  $ @  $ÿ7 @  $   @ż~6i B @Ż~z  C @  $  0B @  $   @      @    $ @]   @x              w   ż~6  0B   $  C   $  C
  |  0B
  |     0  2    0     0     0     0      0      0  8C   0  8C   0  HC   0  LC   0  LC   0  HC   0  LC   0  LC   0  HC   `  HC     HC     HC   `  HC     HC     LC     LC     LC     p                   B  p   B     B             B       B                                          B      B     B  p    B      B      B  p        
*B   
*B   @B   @B         <--   %--   @R   @R                                         Zn                	     	                            C ō  C 	    CU    C 	    C     C      C    C  ~}  C       	Ŧ   	      	     	ō   	ō  0B 	    0B 	    0B      0B        ō    ť           Ō        0BU  ÕoBV    
            %      %            
                         	    
 	     	    
  	    D  M    D  W    D  [    D  ?    D  I    D  ;    HC @%    HC  -    C  -    HC  ;    C  ;     @%    4 @%    0B @%    ,C  ;    P  ;    P G    P  I    ,C  I    P  N    P  W    ,C  W    P  [    ,C  [    C  ;    C  I    C  W    C  [    %  ,    %  -      -    %  9      9      9      9      -     +      9     G     G     G      N      N    4 G     9      @      :    %  :      H      <    2  :    2  H      J    2  J    C  Y    C  Y       A     @     @      @      B     B     @     ͌  0    0     0         0    0                         0  @  0          @     @     @      @     0     0                                                @     @     @     @     @  @  B     B  @  B     B     B  v    0     0      0      0ú    0  v    0  >    0  W    0tp    0  >    0t8    0  W    0     0  W    0     0  @  0  W    0     0    0   @  0  ͌  0     0     0     B     B  W    B  U    B     B  W    B  @  B     B  W    B  @  B     B  |    B  W    B   @  B   @  B      B            @                   \k              @       |  J)e  ]  1  W        W    @  ]  ŒR  W        W       W         W     @  W   @  W    @  W    @  W        W @	  @  W @  @  W @      W @	      W       W   @                        @      @  |     @  |         v  l  v  ľztp  Ĺz                                @      @   @       @  @  | @  @  | @          ] ŖR  ] )          N  K    N  J    N  H    N  =    N  :    6  J    6  X    6  M    N  X    N  Y     :  @  :  @  :  \   :  \  :     :    3  @  '  @ ķ-+  @  4  @  4  @   4  @   3  @  4  @ Ķ-7  @ nK8  @   4  @  4  @   -  @  +  @   '  @   '  @   &  @   &  @  &  @0O#  @  \#  @   $  @   $  @  &  @    @   $  @  &  @  3  A   3  A  3  A  3  A   &  A  &  A  %  A    A    A  &  A   '  \  '  \   4  \   -  \ ķ-+  \ ĵ-7  \ ĵ-7      =     I      K     ;    n  K     W      Y    n  Y    ;     ?    I     M    W    C      C      C      D      D      C      C      C      C      C      C      C    
  C      C      C    
  D    
  C      C      C      C          B              B                  B    2  B    2  %D    2  %D    6  %D    6  %D    2  %D    .  %D      %D      %D      %D      %D      %D    2  %D      %D      %D    *  %D    .  %D    2  %D    2  %D    2  %D    V  %D    V  %D    "  %D    "  %D    &  %D    &  %D    *  %D      %D      %D      %D      %D    "  D      D      D      D      D    :  D    :  %D    :  D      D      C      C    "  C    2  C    >  D    >  D    >  D    >  D    B  C    B  C      C    "  C    "  C    &  C    *  C    .  C    2  C    2  C    B  C    B  C    B  C    F  C    F  C    J  C    V  C    V  C      C      C      D      C      D      D      D      C    2  C    2  C    2  D    2  D    V  C    V  C    V  D    V  D    V  D    V  C    V  C    V  C    V  C    V  C    V  C    V  C      C    &  C    *  C    .  C    *  C    2  C    .  C    N  C    J  C    R  C    R  C    N  C    2  C    2  D   2  D    2  D    2  D    2  C    .  C    .  D    .  D    .  D    *  D   "  D    "  D      D      D      D      D      D      D      D    "  D      C      C      C     D      D      D      D      D      D    &  D    &  D    *  D   &  D     D      D      D     D      D    "  D      D      D    .  D    "  C    "  D      D      D      D      D      C   *  C    *  C    .  C    *  C    &  C   &  D    2  D    2  C    2  C    J  C    N  C    R  D    B  D    >  D    :  D    :  D    6  D   6  D    :  D    >  C   J  C    J  C    F  C    B  D    B  D    F  C    >  C    :  C   N  C    R  C    R  C    N  C    _  C    _  0C  D     D     D     D     D     D     D   B     C          B     B     B     B     C     n  \    n  \    n  ^    n  ^     \     \     ^     ^      D  B    D      E  B    E      D      D      D  B    D  B   n      {     |     |      {     n    Z n    Z  {    Z |    Z |    Z  {    Z n    n |    n |    n  {    n  {        B      B      B      B                                  C     C   0  HC   0  HC     HC     HC   0  C   0  C     [   B  [   B  W   B  W   B  W       [       [       W           B      B      B      B                                  c   B  c   B  [   B  [   B  [       c       c       [         0  A    0  @   0  @   0  A  @(  A  @(  @   @(  @   @(  A                      B      B                      B      B                      B      B                      B      B  D  D  B  D  D  B  D  D  B  D  D  B  D  D      D  D      D  D      D  D       E     E  0  P E  0  P E    P D    P D  0   D  0   D    YD D  B  UD D  B  UD D  B  YD D  B  UD D      UD D      YD D      YD D      D  D  B  D  D  B  D  D  B  D  D  B  D  D      D  D      D  D      D  D      aD D  B  YD D  B  YD D  B  aD D  B  YD D      YD D      aD D      aD D      D  /E  A  D  /E  @ D  /E  @ D  /E  A D @'E  A D @'E  @  D @'E  @  D @'E  A  D  D      D  D      D  D  B  D  D  B  D  D      D  D      D  D  B  D  D  B  D  D      D  D      D  D  B  D  D  B  D  D      D  D      D  D  B  D  D  B  D      D      D    PB  D    PB  D      D      D    PB  D    PB  D      D      D    PB  D    PB  D      D      D    PB  D    PB  >D      >D      >D    B  >D    B  _D      _D      _D    B  _D    B    E      E      E  PB    E  PB    D      D      D  PB    D  PB    E      E      E  PB    E  PB    D      D      D  PB    D  PB  @  D  B  @  D    @  D    @  D  B  a  D  B  a  D    a  D    a  D  B  e    e    d    d    n d    n d    n e    n e    D dE    lD dE    lD cE    D cE    lD cE    lD dE    D dE    D cE        \0        \0       `\0       `\       `\      `<       d\0       0\0      	 0\   	   
 0\   
    0\ "       0 (     
 
 +      
 ,      
< -  
   
<.      `0
 /        
 2        
 6      
 7      ` 8     ` :        <        =      @ >      @ @     @d B      W 
 D      %  
 H      " 

 M      , 

 N       , 
<
 P  
   ! 
<
 R     
<0
 T     # 
, 
 V     $ 
, 
 W     
, 
Z     & O 
 _     ' AP
 e      ( P
 t  !   ) ,
   "   * . l,
   #   + t,
   $   , t,   %   - tP      tPT   &   / l,t
   '   0 1 ,t
   (   1  t
   )   2  xt
   *   3 dxt
   +   4 dt
   ,   5 dt
   -   6 h dt
      7 d	t
   .   8 D 	t
   /   9 B 	 t
   0   : ? \
 t
   1   ; > \
 t
   2   < \
 t
   3   = \
 t(   4   \
 t(   2   \
 
   2   @ \
 
   3   A \
 (   5   \
 (   4   C 	 t\
   5   	 D\
   6   E 	t
      F 	t
  * 7   G R 	<t
 
 8   H M 0	<t
  1   I 0<t
  9   J K 0<
     0<
     L 0<     0< :   N 0	<t ! ;   O 0l
<t # <   P  l
<t % =   Q  l
<t ' >    l
<t )    S 	<0
 + ?   T Z 	<0
G @   U V 	<0
I A   <0
J B   W X 	<0L C   	<0N D   Y 	<O E   <P F   [ b 	<
R G   \ ^ 0	<
T    ] 0h<
V H   , h<
W I   _ 0	<hY J   ` a 0	<h\    0<h^ K   0	<_ J   c g 	<0
b L   d <0
c M   e 
<0
d N   f 
<P
e O   
<P
Df P   	<0g    i l dt	 i 4   j d t	 m 5   k d D	 n Q   D D	 o R   m zdt	 q    n t	 v S   o e<t	 ~ T   p ^t	  U   q t	 - V   r SPt	  W   s  Pt	  X   t  Pt	 
 Q   u x Pt	  5   v P	Pt	  4   w DP	Pt	  .   DP	PD	  Y   y PtP	     z ~ PP	  %   {   P	 
 Z   |   P	T  .   } @	  P	T  [   @	 P	T  Z    PP	   \     P@	   ]     TP@	   ^     TP@	   [     T$P@	   _     $P@	   `   $@	   a    $P@	 b    $P@	 c   $P@	 d    T$P@	   b    T	P@	   e    T	@	   _    T	@	   f   T	@	   `   TP$   g    TP   h    TP   i   TP   `   PT@	   j     P	  k    P	  l     P	 ! m    \	P	 # n    \	P	 $ o    \	P	% _    \	P	' p   \	P	( q    P\	 * r     P\	 , s    P\	 . m   `P\	 0 t    P\	 4 u    Ph 8 v   Ph < w    P @ m     P B %     P D     PT H \     Pt L x     TPt Q y    8Pt V z    8Pt X {     8Pt Z $    8Pt ^ #    8PPt `     8PPt b %   8P  t c    8P8 e |     TP8 i     T P8 l %    T   8 m }   T   8T o     TP8  r %    T  8  t ~    T  8 T w    T  8 T z      PT }8      T        T  %     pT 
      pTT 
       p  TT  X    dp  TT     dp  T       p  dT        dT       Tp      @Tp  %    @p     @pT                %     t       tT      |  tT     |    tT       PT X    PT    PT     PPT     IPT      T     T             #      (       (.       (1       (5        (7      X  (9     d  (;     d  <    d   =    X d (>       X (?      X (A     ( X (B    ( 4 (C       X D      X F      X  G      4  H    ( 4  I       (J     (L     (M     N     O       P     T       U      (  V     X  W    X d X     ( X Y    ( 4 Z     ( [     ( \     ]      (^    (a      (b     (c     d     e     f    g     h    Ti    \Tn     \Tp    
 \ s      v    4  w    X  x    X d y    	 4 z    ( 4 {     \ |          
 \     4 \     X \     X \d      \4     ( \4     \     \     \                    \    \        \    \    \     T\    !T\ $   "$ \    #P \    P \    %> P    &5 P    '4X  P    (/d  P    )*d   P    d , P    +d   ,    ,.d   ,    -   ,       (    d   ,    02d       1d       d       3d      d      X d P    6X P    7= X P    8;,X P    9 ,X P    :( ,X P    ( ,4 P    <, P    , P     X ,    ?@P    P    ADP    ~B P    C| ,    } ,    EG     Fz     {     Hx    y    JKPT    w PT    LOP     MNP     v P     uP     tP     QPT    RPt     sPt     T\P	  u   UZxP	  v   VYP	     W	  t   X	d  F   rhd  t   qP	    [xP  v   pxP,     ]Px     oxPx     _t	  l   `ddt	   k   ad\	t	  o   bcd\	t	     nd\	t	  p   md\	t	     ldt\	 
    fo<t	    g,<t	    hk,<t	    i,<t	    j,<t	 B   k,`	<t	 Q   ln,<,	    m,P	<,	 I   j,P	<,	    i,<,P	    p<,	    qtd<,	     rd<,	# T   sd<	$    hd<	%    ud<,'    vd<,(    wyd <,-    xfd <,.    gd ,/    ed <,0    {d	 1    |dx	 9    }dx	d ; u   ~dx	d = t   dd	d ?    dx A    dx C    dxH    TxO U   cTxxP    dTxR    dxTxX    XdxTx[    xTx]    xTx^    xTxd U   bTxe    TxPf    aT@Pg    T@Hh    `8T@Hi    _xTj    xT(k    ^xT(l    xTm    ]xTn |   xxo    \ xq    xTxs    [xTxt    xTxu    YxTw    xTx    ZxTy    dxTxz    xTx{    WxTx|    VxTx} |   Udxx~    dx     dx     dx    Tdx    dx     Sdx     dx     Rdx     Qdx     dx    dxx    dxTx    dTx    dTx    Tx    OTx    PTx    Tx    NTx    Tx    MTx    dTx    dXTx |   LXTx    dXx    Kdxx    Jdxx    dXxx    Idhxx    HdXxh    dTxX |   dTxX    d TxX    G TxX     Tx8    F (Tx8    Ed xX    dxT    xT    T    DTx    CxT    Bdx    dt
    t
    t
    T
    AxT
    
    @x
    d
    ?d    dt
    t
    xt
    xT
    >xT
    =xT
    d
    
    <    d
    dx
    ;dx
    :dx
 |   dxt
    d xt
    d xtx     xtx    9 xtx    6d xx    d x    8d x    7d x    dxt     5dxt     dxt    dxxt    xxt    4xt    3dxx    dxx    2dx    1dxx     xd
      d
  t    d
d  u   0 dhd      t
x )    
x    .d
x    d
x    dxx    -dxxx     dxxx    /Txxx    dxTxx    dx8Txx!    x8Txx%    8Txx&    +8Txx)    
HTxx*    	XTxx+    .hTxx,    -XTxh-    ,HTxX. |   *8xx/    
dx8xx0    )d8xx1    (d8xH2    dx8x3    'dxhx4    dx8h5    &dxXh6    dxTx87    "dTx88    Tx89 |   Tx8:    % Tx8>     Tx?    $ Tx@    # TxA    "T 8B    TxC    TxF     TxG    !TxH    !TxI     TxJ    #,dx8K    $)dx8L    %&dx8M |   x8N    '(dx8O    d(x8P    dx(Q |   *dxR   +d xS    d xT    d8U R   dxxV    /d
W    0dxX R   dxxY    2 ,t Z   3;,t q&    4,t    58,     6d     7@d  %   @d      9,d     :d  %     d    <,    =?,    >,     ,   	  @, 	 
  A    BS    CH      DF     E         
  G  U       I     JK `    L`    LQ L`     MP L`    N L`     O L       L  U   
 L   R L`     L`    Tg      Ue     Vc     W`      X`  	   Y[`    '   
Z     )    	    D *   \b`    +   ]p    -   ^p   t /   _   t 0   `    t 1   a  0  t 2     0  t 3   `  p 4   d` 5    ` 7    f 9 U   h ; !   h  A "  iw  B #  js4  H   k4  J $  l4  Q   m4   Y   np   [   orp   ] %  pp   _ &  qp  H ` '  p  H a %  p   b (  t4  d )  u4  f *  v4  g +  4  h   x4 i ,  y4` j   z4` p    {~4` q   |4` s    }4 t     4 u U   4v   4` x   4` y   ` z    , |
 -  ,  .  ,p   /  ,p $
 0  T ,p $    ,T $ 
  ,T $ .  ,     ,$ 0  ,$ 1  , 	   ,    2        3    4  , ,   H , 5  ,H  ,   ,H 6   ,             `                 7  l, 
     l 
     l 
  t   l 
d  u   l hd  6  l,      l   8  l d     | d     l|d  9  l|d  :  ,l
  t   p,l
  9  p,lh     p@lh 
 ;  p@lh  <  ,p
  =  ,p
     p
     p   >  p   ?  ,
   @  , !     "    d $ 0   P, & A  P, *    hP, .    hP /    h@ 0    h@ 2 B  Ph, 4 C  Ph` 7 >  h` :    h`4 =    =P, > D  P, @ E  P, C F  P E ;   G     K +   P, Q G  P, S    P, U   P, V 
  P, W H  P, _ I  , a J  , b K  , c L  , d M  P, e N  P, g E  P, k O  , l P   m    | q    | u Q  P y     z    d { R  d |    P ~    Pd  F  Pd  S  :P, 
   P,  O  P,  T  P     `  `   `     `  U  `    2P, 
   P,  T  P ,    ` ,  
  P, 
 V  P, 
 W  p,  X  Dp,  Y   p,  Z   p\,  [   p\,  \  pD,  [  pD,  Z  pD,     "Pp 
    Pp  ]   Pp  ^   p  Y   Dp     \Dp  X   D\p     D\p  _   D\p      D\` 	 `   D  \` 
 $   D p  w     D      D 
     P  T   P    T  P p  \  ` p  a  ` p  ^  
x` p  $  xD p # `  	
xD  p ' %  xP  p ) %  xD  P + b  xD  PH , c  xD  PH -   x` D .   x`  D /    x` D 1 d  x`   D 8 e  `   D 9 f     D : g    9 D ; ]  `xp < W  xp = ^  Dxp @ $  DDxp B    DxD C h  D  xD D `  Dp E   PDp F _  PDp G    DP H    `x I i   !`p J   @p K    `@ L j  #PpM k  $PpO W  %-XPpP X  &+DPpR ^  '* PpT Y  ( DpU U   ) D\pW Z   D\pPY U    PDZ ^  ,DP p^ U   DP D` i  .1XPDpf \  /X@Dpg U   0@Dpi Z  @DpPk U   XPD@l l  3P, p m  4\P, q n  58\P r o  6P s %   7 t    T v    9\P w %   \P   x p  ;?PP y
    <PP     =PPd  Q  >PPd  F  Pd     @PP     AEPP  q  BP P  r  C P  s  D   t        FPP  u  GEPP  v  H4,P     Ib,P 5 h  JR,P     Kh,P  w  LNh,d P  x  M|,d P  %   ||d P  %   Oh,|P     Ph,|PT  x  Qh,  |PT  y  h|  |PT  z  SW,hP  l  ThP  n  U\hP     V\P  %   \  P  {  X^,h  |  Y\,h  }  Z,h  %   [@h     @hT     ],  %   ,    %   _,     `,T 	 ~  a,  T 
	 }  8,  T 	   c/,P	   d+X,P	    e
XxP!	   fjXxP#	   gX@P+	 4  h@P,	    i@H P-	 U   @H P.	    kXx@/	   lXx@@	    mX@F	   n@M	
    o\ @Z	   p\ @v	   q|\ @z	   rw$ \ @|	   st$ \ @}	   $ $\ @~	   u$ \ $	   v0 \ $	   0 \ $	   xz$ \ 	   y$ \ 	   0 \ 	   {$ \ 	   0 \ 	   }$ @	   ~$ 	   $ 	   $ 	     $ 	   	   	   	   	   	   	   \ 	   4\ 	     4\ 	   0 4\ 	   0 4\ p	   0 @\ p	     40 	     p0 	     40 p	     @0 p	     @$ p	   4  	   d  	   d  	   d	   d	   d	   4  d	   4  d	   @  d	   @  d	   4d	   \ 4	     \ 4	     \ 4	   0 \ 4	     0 4	     $ 4	     \ 	   0 \ 	   0 \ 	     0 	     0 	     $ 	     0 	     4	     4	     4	   4	   4	   4	     	     	     	     	   	     	     	   	   	    X@		    @	   X@	   Xd@	   X@	   p@	   p@	   p@	    p$	   ~p	    }p	   |p	   p	   t	    {t	   zt	    yt	   pt	    xpt	   Xd	   wXp	   Xdp	    vtdp	   Xd	   Xd	   uX@d	   X@	   X4@	    tt4@	   sX4	   X	   X	   X	    rt	   qX	   X 
   X
    pt
   oX
   Xx@
   h x@
   h xx
     xx
   xx
   xx
    n x
    x
    m x
     x
   l x
   k x
     x 
   j x!
   ix "
 U  xx$
   hxx&
   gx<x(
   xx*
    x+
   fHx,
   xH-
   xH.
   xH2
    exH3
    x(4
   dx(5
    x6
   cx7
    bH8
 U   x9
   axP:
   xx;
   x=
   `<x>
   _x?
 U   ^h xx@
 U   Xxh @D

   XxPh @N
 h  ]X Ph @O
 h  \	XxPh  Q
   [XxPh R
   XxPS
   XxxT
   
xxX
   x[
    x\
   xx_
    <xx`
   Z<xa
   Yxxb
   X<xxc
    Wxd
   &xe
    xf
   xXg
    V<xXj
    <xXk
    <xhl
   U<xxm
   T<xhxn
   S<xXho
   RxX<p
    xXq
   !#xXt
    "xXu
   QxHXv
    P$xXw
    %x8x
   Ox(8y
   'xz
    (Lx~
    )*x
   Nx
   Mx
   ,X,x
   - ,x
 v   . ,8x
 U   K ,8x
 z  0,XP
    1,X
	 U   2,X

 ~  3I,PX
 }  J8,PX
   5=,P 
   69,P 
 %   7P 
    8PT 
   H  PT 
 %   :, 
    ;,T 
   <,  T 
   G,  T 
   >,P 
   ?`P 
   @A` 
    F` 
   B` 
   C 
    D 
   E   
    FP, 
2 s  GP<, 
 ~  HP<, 	    I8P<, 
   J8P<,d    KN8<,d     L8<,d  F  M8,d  Q  D8,d  S   Om8<8,d    P88,d    Qf8,8,d #   Rd88,d % U   S88,d &   TX8P8,d - Q  UW P8,d /   V P8,d 3 v   C P8,d 5 F  B P8d 7   Y]8P ,d :   Z8,P ,d ; O   [8,P`,d = %   \0,P`,d ?    A0,P`,T D   ^8P ,d H   _a8P ,d J   `8P ,d L O   @8P,d N F  b8P ,d P Q  c8P ,d T v   ?8P d X    e88,d \   >, 8,d ]   g8,8d ^ O   h8, d _ n   i0, d b   jl0, c    k<0, e   =0,\ f _   ;0, h   ny8<8,i   o<8,l   pv< ,o    qh< ,s C  rh< ,t   suh< y    t9h< z   :h {    8h< |    w< h}   x, < h~   7, < h   z8<,   {8<    |l<   }l< r  6~<   5<   4l< U  8P<d     8P<d    8P<    P<   3 P<   2 P<P   / P<p N   1P<p   0P<pD   8P<    8 <    l <    .lP<     -l < P   ,l <P   8 <l   + <l   * <lp   8 <   )8`<   (8 <`    '8P<   r  P<8,    <8, 
 U   <8,  %   P8,    P8,T 	 v  P8,T  `   %P8,T     &8,T 	   P,T    " P,T    $P,T    #P,T    P T    0P T  `    0P T     !0 T    0PT  b   0PT     0T ! _   0T #   0T $ `   P0 T &    0 T ( _   P0 *   P0 + b   P0 ,   P0 - .   P8T .    8T /   P<8 0   P<8 2   `<8 3    `<8` 4    P<8` 6   P<8`8   P< : .   T< <
 q  T  I :    L 3   p  M t  p  N   p  Q t  p  R    p T    p U 3     V   T< W   T< Y   T< [   T< ]   T< _   T< a   P<T c   hP<T e    hP<P g    P<hT k   
P<hTo .   P<, r   P<, s   P<, u   PPw   PPz    P{   P |   
<P }   P< ~   	P    PP   PP    P   P    P    <P    P  ,            P   P   P,    ,                P, p  X P,   X P,   X x,    <X xx   ;X xx    !xx    x8x   xHx (   Hx   xx   xx *   xx   x   x    x    x   x   xx    xx     xx     xx    x      xx    x   Hxx    <Hxx   <hxx    <Hxh   <Xxh *   xH   x    	
<x   <x   <x   
xH   xH (   xH   xx   xx    xx    x   x    xx   xx   xHx   xHx    xHx    xXx   xhx   xXh   xHX   x8xH   x8H   8H    8H   <8H   "xx8   #.x 8   $%x 8    8    &+x8 
   '*x8
    ()<x8
   <x(8
   <x(
   x<8
   ,x
   -x
   x
    /5x 8	
   01x 8

    8
    2x8
    34x
   x
   x
   6x 
   7x 
   8x 
    9x
    :x
   x
    X xx
   X xx
   >P,
   ?x,
    @xx
   X xx 
 3  BHP
!
    C 
"
    DE x%
 2   x)
    F x,
 R   Gxx.
   xx/
   IP 0
 1  Jx 4
 4  KNx5
   LH x:
   MH xx<
   H x8x=
 5  xH >
    PS P A
 U  Q P B
    R P C
     <P H
   T P K
    U HP M
    V HP O
     HPQ
 @  X\ 
 S
 ?  Y
 T
    Z U
    [ W
   d Y
   ]  [
   ^ \
    _0 ]
    0 _
    a0  a
   b0  b
    c0H  c
    0<H  d
   e\00 e
   fh\00 g
   gh\0 i
    hh8\0 k
    h8\0o
   jhl s
   khT t
   lh  T u
 	  mh  T v
 
  n  T w
     T x
   p pPy
 
  q Pz
   r P{
   s P|
   t 8}
    8~
   v|tl 
   w|tT 
   x|  tT 
   y|  tT 
   z|  \T 
   |  \T 
   |hl 
   }hT 
   ~h  T 
   h  T 
     T 
     T 
   \tl 
   \tT 
    \  tT 
 !  \  tT 
 "  \  \T 
 #  \  \T 
 $  , 
 %   , 
 &   |, 
 '   h|, 
 (   h|, 
 )   h| 
 *  h 
 +  h 
 ,  h 
 -    h 
 .    P 
 /    P 
 0  hl 
 1  hl 
 2  hl 
 3  hT 
 4  h  T 
 5    T 
 6  Pl 
 7  PT 
 8    PT 
 9     PT 
 :     PpT 
 ;     8pT 
 <  H
 =  Hh
 >  Hh
 ?  0h
 @  0h
 A  0h
 B  <||l 
 C  <||T 
 D  <|  |T 
 E  <|  |T 
 F  <  |T 
 G  T  |T 
 H  @l 
 I  @T 
 J    @T 
 K     @T 
 L     @pT 
 M     (pT 
 N  L|l 
 O  L|T 
 P  L|  T 
 Q  L|  T 
 R  L  T 
 S  d  T 
 T  x\
, 
 U  x\

, 
 V  xt

, 
 W  t

, 
 X  t

, 
 Y  t

 
 Z  ~ 8`l 
 [  y 8`l 
 \  } P`l 
 ]  z P`T 
 ^  | P  `T 
 _  { P  HT 
 `  x08l 
 a  s08l 
 b  w0Pl 
 c  t0PT 
 d  v0P  T 
 e  u0P  xT 
 f  rxL 
 g  m`L 
 h  q`L 
 i  n`4 
 j  p`4 
 k  o`4 
 l  l0xL 
 m  g0`L 
 n  k0`L 
 o  j0`4 
 p  h`4 
 q  i`4 
 r  a8x| 
 s  f8x| 
 t  b8|x| 
 u  e8|x| 
 v  c8|xd 
 w  dP|xd 
 x  `xX8L 
 y  [xX L 
 z  _X L 
 {  \X 4 
 |  ]X 4 
 }  ^0X 4 
 ~  ZxH8L 
   UxH L 
   YH L 
   VH 4 
   WH 4 
   XH 4 
   Tdx| 
   Odx | 
   P|x | 
   S|x | 
   R|x d 
   Q|x d 
   I$`
   N$`
   J$H
   M<H
   K<H
   L<H
   C$$Hd
   D$<Hd
   H$<Hd
   G$<0d    E$<0d   F<<0d   ?          @             B         ?          @                           ?                              ?          @             B          ?                                      ?                              ?          @                        ?                       A         ?          @                           ?                              ?          @             B          ?                                       ?                              ?          @            0B         ?          @                           ?                              ?          @             B             ?         ?          @         ?          @                         ?                            ?          p             B         ?          p                           ?                                   ?                               ?                                   ?                       A         ?          @                           ?                              ?          @             B         ?          @             B         ?          @                           ?                              ?          @             B         ?          @                           ?                                  ?                            ?          @             B         ?          @                     ?          @                           ?                              ?          @             B	         ?          @              	             ?                     	         ?                               ?          @             B
             ?                     
         ?          @              
             ?                            ?                      A             ?                   	         ?                      `B	         ?          @                     ?          `             B	         ?          @        UUU             ?          @             B         ?          @                           ?                                  ?         ?          @         ?          @             B         ?          @                           ?                              ?          @            0B	             ?               UUU             ?          @            @B	         ?          @             B
         ?          @              
             ?                     
         ?          @             B        ?          @                          ?                                 ?                   @         ?          @             B         ?                  OD                 ?                              ?          @                       ?          @    OD      $B         ?              OD      $B         ?              OD                 ?                  OD             ?          @             B         ?          @                           ?                              ?                        B	         ?          @    OD      $B         ?          @        OD           *?                      A       *?          L                           ?                             ?                      A             ?                                ?                   
         ?          @            
             ?                   @          @                         B         ?          @                           ?      A                       ?          @                     ?          @        OD                  ?                     
             ?                  @         ?                      A         ?                      @         ?                      B             ?                             ?                                 ?                      @         ?                                    ?      @A                      ?                       B         ?                                    ?                           ?                       A             ?                  A         ?                       B             ?      A            B         ?                                ?                       A         ?                       @B             ?                  @B         ?                      A         ?                       B             ?                   B         ?          @                     ?          @             B             ?      A             B         ?                        B         ?                        B             ?                    B             ?                    B         ?                                   ?      A             B         ?                       B         ?                               ?                      @B             ?      A            @B         ?                        A         ?                       @A             ?                   @A         ?                        A         ?                       @A             ?                   @A         ?                        A         ?                        A         ?                       @A             ?                   @A         ?          @             B         ?                       @A             ?                   @A         ?                        A         ?          P            @A         ?                      B         ?                      B             ?                  B         ?                        A             ?                   @A         ?                       @A             ?                              ?          @                       ?          @            A         ?                        A         ?                       @A             ?                   A             ?                   @A         ?          @            A             ?                              ?                       A         ?          `            B         ?          @        UUU             ?                       @A             ?                   @A             ?        ?                    ?                        A
         ?                                  ?                       @A             ?                   @A         ?                        A         ?                       @A             ?                   @A             ?              UUU             ?          @            A           Qpy?Yf       611??  A           5k?
>       Q>D5   @        n?    |>   P$>    7  A         ?          h             B         ?                        A
         ?                       @A
             ?                   @A
         ?                       @A
             ?                   @A
         ?                        A         ?                        A        ?                       @A            ?                   @A        ?          `            @A         ?                        A         ?                   OD                 ?                   @A         ?                       @A         ?               OD      A         ?              UUU      A         ?                                 ?                  OD             ?              UUU       B         ?                        A         ?                       @A             ?                   @A         ?                       B       *?                       B         ?                       @A             ?                   @A         ?                       `A         ?                        A             ?                   A         ?          0             B          @                                   ?                        @A             ?                   @A         ?                         B         ?                  OD             ?                        A             ?      `            A         ?                        `B         ?                        @A         ?                   OD                 ?      @            @A         ?                        @A         ?          P            A         ?          P            0B             ?                  0B         ?                      @A         ?                      `B             ?      @            `B         ?               OD      A         ?                      A             ?      @            A         ?                      @A             ?                  @A         ?                      A         ?                      `B         ?                      pB             ?      `            pB         ?                        @         ?                        0B             ?                  0B             ?                  0B         ?                       0B         ?                      0B             ?                   0B         ?                      A             ?                  PB         ?                      PB         ?          P            A         ?          P            pB             ?                  pB         ?                                   ?                           ?                      @             ?      @              
         ?                      A         ?          P            A         ?          @        OD    
             ?                  @
         ?                      A
         ?                      @
         ?                        B
         ?                       A
             ?                  A
         ?                       B
         ?                       B
             ?      A            B
         ?                       
         ?          @                       ?          @            A         ?          @             B         ?          @                           ?                              ?          p                      ?          p            B         ?          @            @B             ?                  @B         ?          @            B         ?                       @A         ?                        A         ?                        A         ?                       @A             ?                   @A         ?          0            0B           .h?              OD             ?          0            @A         ?          p            pB             ?      @            pB           .h?              OD             ?          p            @A         ?                       B
         ?                       B
         ?                        
             ?                   @
         ?                       A             ?                            ?                                       ?                                                   8      
      x                      $                        "      X     &           +      t     1           6           :          ?          E      (    J          N    P      R    P      V      0    \           `    y  \     f    y    	  j    :  l  	  p    :  \	  	  u    :  L
  	  y    :  |
  	  ~    :  
  	      :  
  	           	           	         
  	        0
  	        p
  	        
  
         
  
         \  
           
           
         ,  
                   L                               D                     |  
                                         T         Q           Q           Q  `        Q          P           l       O         O                 %         *   ~       .   {       2    0     7        ;   t      @   t  8    D   y      J   y  (     N   Q       S   Q  !    Y   Q  D!    ]   Q  X!     b      f     !    l     H"    r     "    x     #    }     0#          l#          #          #          #  
      
             #         $          0$         l$         $         %          @%          %          %          %          &          ,&          &          '          d'          '       ^        4(         (         (         )         X)         )         8*    
     *         *         +         |+    "     +    '     +    ,     $,    2     d,      9     ,      =     ,      A     ,      H     ,      L     ,      Q     ,      W     ,-      ^     -      e     .      i     8.      m     D.      s     d.      w     d/      {     /           40           X0           x0  !       0  !       0  !       <1  !       T1  !       p1  "       1  "       2  #     P  2  #       2  $      P  2  $        3  %     O  H3  %       h3          3  &       84  &       4  &       x5  &       6  '       6  '       H7  '       l7  '      '       7  '       7  '       7  '      '       7  '     &  8  '     & '      '   $     08  '   )     8  '  0    '  7    (  ;    (   ?     8  )   C  
   9  )   M     D9  )   R     T9  )   V  
   `9  )   `      :  )   f     (:  )   j     8:  )   o     P:  )   t     p:  )   y     :  )        :  )        4;  )        ;  )        8<  *       d<  *        <  +       <  +        <  ,        (=  -        H=  -        >  -        >  -        ?          ?          @          PA  .        A  .        A  .        4B  .        B  .     ,  C  .     ,  PC  .       \C  .       hC  .       C  .        D  .  
     0D  .       8D  .       LD  .     ,  \D  .     ,  D  .  "     D  .  )     D  /  /     8E  /  3     LE  0   8     `E  1  =     E  2  B     E  3   G     E  4  K     <F  2  O     F  2  U     G  3   Y     @G  5   ]     G  4  a     H  5   h     `H  6   o     H  6   t     DI     y     I     ~     J          K          L          TL          L          M          M          M          M          $N          8N          N          N          hO          O          P          Q          Q          R          HS          S          T          T          0U          0V          W          PW          W          X          X          X     !     (Y     %     <Y     )     TY     0     TZ     5     T[     :     [     @     D\     E     \     J      ]     P     ]  7  U     ^  7  [     @_  8  a     |_  8  f     `  1  j     D`  1  q     a  1  y     a  9   ~     b  9        b         ,c         d         Xd         He         e         e         e         Pf         lf          f         :        Hg  :        g  ;        h  ;        i  <       i  <       j  =        j  =        (k  >       k  >       (l         l         Hm         m         `n          n         0o         0p         q         Pq         q    !     q    &     r    +     s    0     t    5     t    9     u    =     v    B     \w    G     w    L     x    Q     x    V     Xy    Z     y    a     (z    e     pz    l     z    q     z    v     <{  ?  |     `{  ?        |  @       |  A        }  A        }  B       ~  B       ~  C          D         E        X  E          F       T  F         G          G        L         ă  H       x  H       8  I          I          I        x  J       J             K       ؇  K         K       @  J        ĉ  L       l  M   	     t  N   
     |  O      P          P        X       O      "   O      '   O      ,   O  4  4  0     p  5   5       Q   :       Q   >       R   B       R   G       R   M       R   S       R   W     <     [     T     b          h          m     \     r          v     Ȓ     {                 S          T         U        d  U        H  U        ,  U       U        Ė  U          U          U          U          U          U        <  U        |  U          U          U        @  U          U          U        @  U        Ȝ  U        P  U        ؝  U        ,  U        p  U        T  U          U          U          U          U         `  U   %    U   )       U   .       U   4     Ԣ  U   ;        U   A     D  U   E     L  U   K     ̣  U   S     L  U   W       U   ^     t  U   d     إ  U   l     $  U   q     h  U   x        U        P  V        \  W          W        (  W        `  W          W        D  W        l  W        \  W        L  X        |  X          X          X          X          X          X        4  X          X          X          Q          Q          Q        @  Q        |  Q          5          4  	       .   
	     X  .   	       .   	     4  .   	     T  Y  	     t  Y  !	       Y  '	       Y  ,	     (  Y  1	       Y  4	     ܲ  Y  9	  	   8  Y  B	       Y  G	       Y  L	       Y  R	     D     V	   6  \     Z	   6       ^	   6       d	   6       l	   6  4     q	   6  ķ     w	   6     %  |	     P  %  	        %  	     D  %  	     t  %  	       %  	       %  	       %  	       %  	     ܼ  %  	       %  	       %  	     x  %  	     Կ  Z  	     4  Z  	       Z  	       Z  	    .   	     8  [   	    Z  	     L  Z  	     x  Z  	       Z  	     8  Z  	     @  Z  	       Z  	     P  \    
   8    \   
   8    \   
   8 ]  
        ]  
   7    ]  
   7  4  ^   
   7  L  ^    
   7  l  [  $
   8 [  (
   8 [  .
   8 _   2
   6    `  6
   6    `  <
   6     a   @
   6     b  E
   6 c  I
    d  M
   7  t  d  S
   7    d  V
   7    b  [
   6    e  _
   6  H  e  d
   6    _   h
   6    f   l
   6    f   p
   6  ,  `  t
   6  <  `  x
   6    `  |
   6    g   
   7    g   
   7  t  h   
   6    h   
   6    i  
   6  $  i  
   6 `  
   6  t  `  
   6    `  
   6    j  
     T  k  
       k  
       k  
     X  l   
       l   
     D  m  
   	    n  
        o  
     `  o  
       _   
     H  p   
       p   
       q  
        q  
       r   
       r   
     p  s   
   	    s      	    m  	   	    m     	    m     	  4  m     	    t       \  t          t  %     L  t  *       u   /       u   4       u   9       u   >     |  v  C       v  G     T  v  K       v  O     d  w   S   	    w   Y   	  0  m  ]   	  L  m  c   	    %  g       %  m       %  s       %  x          |                                   T  \       p  \         \      \         \         x      Q  @  x      Q    x      Q    x      Q  $  x      Q  0  y      P  H  y      P    z     P    z     P    {     Q    {     Q    {     Q  0  {     Q  l  $          $          #         #                    %       T  %       x                    |          `            |   "       |   &       |   *   P        .     8  %  6       %  <   O    }  @     (  }  D     8  }  H   P       L          Q       %  X        %  ]       %  a   O  T  ~   e     l  ~   i   P  x  ~   m         q         u         y   P  D     }                                                                                                                                                    
       
       
        
       $
       (
       @
       D
  	 $    M
       R
      Z
     \    ^
     h    b
     t     f
       j
       n
      r
          v
       z
       ~
      
          
       
      
          
       
      
          
      
          
          
         
          
         
          
           
     `     
          
          
     D     
       %  
       %         %       D  %       (  %       t  %       X  %         %  "       %  '       %  +       %  1     H  %  6       %  :          @          H          L          Q          V     <     [           `     l     g          l          p          v          {     H          l           X                          D                                       8         P           %                 0                                                  %       L  %       p  %         %         %         %                                   d                        #         '         +     $  X   0     l    4          8          =          A          F   &       K          P   &       T     $     X   &  ,    ^     4    j  	   T    s  
   l                                            $        4        <                h                              |                        h                                <        H        T        `        p        |   
                                         #         '         .         2         8         <         @         E         I         M        Q     ,   V  
   8   c     \   g     h   k     t   o         s         w         {                                                                                                             ,        8        D         T         `        l               x                                                                                               
      	        	        	        $	        0	   +     L	   /     X	    3      7     d	    ;      ?     p	   C     |	    G     	   K     	   O     	   S     	   W     	   [     	    g     	    k     	   o     	   s     
   w     
   {     ,
        8
         l
         x
         
         
         
         
         
        
        
        
         
         
         
                                               ,        8        D        P        \               |          
                                                 &         *        .         2        6         :         @     (    D     0   J     <   N     H   R     X   Z     p    ^     |   b         f         l         p         v         z                                                        
        
 $       
 $       
 $       (
 $       4
 $       D
        P
        X
         
         
        
        
                                     
                
        
                                             "      '     $   +      0     0   4     8   @     \    D       H       L       P     |   U         Z      _        c      h        l        t      x      }                                                                          0              @         L                         @                                               (                        x                       $          $   	     d u         u         u         v       T          t  $      t  (      F  ,     T t  2        7     <   =        A      v  E     $ v  K      v  O         S         W        [        a     p    f   	      k   	   l   p     @ l   u      k  y      k       l k        o               L p         p         p        T      	  \                  $                                                               D!         ! B       ! Q       l"        " I        P#        #        $        %        %       	  %       	  %       	  &        &        0'        p'      	  ' T        `(    $     x(    (     (   -      )    2     @)    5     h)    8     )    >     T*    D     *    I     +   O     |+   U     +    Z     L,   _     ,   e     -   i     |-   o     -   z     8.   ~     L.        .        .        .        p/         /         T0 u        0 u        H1 t       1 t       D2        2         2        2        3        4                                      D4                           T4 U        4 U        $5         D5         T5                p5      	   5    #      6   *     6   -     6    1      5     7   9     |7   ?   -    C     7    G     7    M     ,8    R     <8    W     H8    [     P8   `   .  \8 U   d     t8   h    8    l     8    p     8   t   .  8    y     9    }     ,9      .  \9         t9      . |        9 |        :         :        :               :                  -             -         ;        $;       d;       .  ; |        ; |        ;       ;                   -  ;        <        <        (<                D<       .  p<       .  <         <         <         4=        =   "     =   &     >   ,     0>   2     P>   9     >    >   .  >   B   .  >    F   .  ?   J   .   ?    N   -  8?    R     P?    W     \?    _     |?    d     ?    h     ?    m     ?   q     ?    u   .   @    y     @   }   .  H@         `@      .  @         @        @        @        @ |        @         A         DA       .  `A         xA       .  A       -  A       -  A |        A |        B |        B       -   B         8B         dB       -  B         B        B        C        PC         pC         |C         C         C        C        D        PD         \D        hD         D   #   .  D    '     D   +     D   /   .  D    3     D    7     E    ;     E   A     0E    E     @E   I   .  E   M   -  E   Q     E   V     E   Z     E   _     E    e     E    i     F   m      F   q   .  LF   u   .  dF |   y     |F |   ~     F |        F        F        F        F        F      -  F        G      -  8G        PG        tG      -  G      -  G        G        G        G        H        H         4H         HH         dH         pH         |H      -  H         H      -  H         H         I      -  DI       \I         tI        I t       J u        TJ        J        J )   #      K )   '     pK )   +     K )   0     K )   6     K )   >     K    B      F      J     K   O     L   S     $L   X  	   <L   a     L   f     L   n     M   v     <M    }     |M         ,N         N         N         O         O         O       -       -       -        P         P        8P        HP        P        Q         4Q        `Q        Q        Q        Q        Q       .  Q                             R        $R   
     TR       R       .  R       .  R |        R    &   .   S    *     S    .   .  4S    2     LS    6   .  xS    :     S    >   .  S   B     S    I   -    M     T |   Q     HT |   U     XT |   Y     dT |   ^     pT    c     |T    h     T    l   -  T    p   -   U    t  	     }                       .  U         0U      .  `U         xU      .  U      .  U          V        8V |        DV         TV       .  V       -  V |        V        V       -       R        V        W          W R        4W         HW      
       \         lW         W         W         X         Y    
     Z         8[         8\         \         ]         ^    #     _    (     H`    ,     Ha    1     a    6     (b    ;     Lb    A     b    H     c    N     c  T     c  [     j     $d  o     4d  s     td  w     d  {     d       4e       te       e       e       f       $f       Df       df       f       f       f       f       f        g       h       h       i        j       j       pk       `l       l       m       Pn       @o       o       o       p       hp       p  	     @q        q       r       r         <r    "     `r %  &     r   *     r    0   ,  s    4     $s %  :     |s %  >     s   D   C  V   C  h  	     q  	    z                                                                                                                                       
      
                      ,     	 0     s 	 6     t 	 ;     Xt 	 B     tt 	 F     |t 	 J    	 N     t 	 T     t 	 Y     t 
  ]      u 
  b     xu 
  i     u 
  m      v 
  q     8v 
  v     v 
  {     v 
       w 
       w 
       w 
       8x 
       hx 
       x 
       x 
       x 
       y 
       xz 
       ,{ 
       { 
       p| 
       | 
       l}        ~        $~        0~        <~        L~        ~       ~                    ~  
            t         Ā         ā 
      D U   $        +       /  	   T  8       <       @       F     ̄   I     M     ؄  S       Y         ]     L   a     p   f         j        o    U   s   $  ܆ U   w        |             D                        !                       p            !      !      !                                         	   D        D        t        $       H              Č  	     0       p              ȍ         ؍    $         *     L    /     l    4         ;         @          E     L    J     x   P       T   "  ȏ   Z       _     4  d        h   "    o      (  t        y     X   }                l                            H                           L        U         U         U        , U         U        L U         !        "      , "      8 "      D "   	   P "       "        #       ̙ #       ؙ                 @        ؚ        H                ț  $     $ $  )       x $  .        $  2        $  8        $  <        $  D       ܜ $  H        $  N         S        W         ]      4   a      D  g      d  k       % o     & u    "   '  y    "   % }     %      (         (         )       Н *        +                  ,       H ,     	   | ,         ,        Ğ ,         ,                                 0         T          x        U       $   U                  ̟                 h        (                    ġ    !         !     $    
!     T    !       !       !        !       %!    -  )!     ` -  /!      -  3!     ` -  7!      -  ;!     ` .  A!      .  E!      .  I!      .  M!      .  Q!     @ / U!     L / Z!     | / _!      / d!     ܥ / i!      / m!    / r!    / w!    / |!    / !    0 !    0 !    0 !    0 !    0 !      !      !      !      !      !    
  !   
   
  !   
  ̦ 
  !   
   
  !   
  4 
  !   
   .  !      .  !     < .  !     l .  !      .  !     ̩   !     ة   !     X   !     ت   !     X   !     ث 0 !    0 "    0 "    0 	"    0 
"    1 "      1 "     ( 1 "     4 1 "     4 1 ""     ĭ 1 &"      	 *"     ( 	 1"  	    	 :"      	 >"     4 	 D"     $ 	 J"      	 O"      ,   T"    ,   ["    ,   _"      ,   d"     , ,   j"     @ ,   n"      ,   s"      ,   x"      ,   }"      ,   "    ,   "    2 "   	 2 "      2 "     L    "   	      "     ܵ    "      3  "      3  "      3  "      3  "      3  "     ̸ 3  "      4 "   	   4 "     , 4 "     ܹ ,   "    5  "   	  @ 5  "     d 5  "      ,   "     x 6  "    6  "       "     `  "     |    "      `   "      "        #      #   \ 7 
#     \    #     ̾   #     0 t  #      u   #      6  #     t   ##        '#     <   ,#        2#     L   8#      8  >#      8  D#     8 8  J#      8  P#     x    U#         [#         a#     (    g#         l#     8    p#      9  u#      :  y#   B   :  #    $ :  #   B  H t  #      t  #     x 9  #      9  #     d    #         #     p    #         #      ; #      ; #      ; #     P ; #      < #   Q   < #   Q   < #   Q    < #   Q  d =  #   a   =  #   T   =  #       #   a     #   T      #    p    #  	  | > #   O   > #   G  ( > $   @   ? $   {   @  
$   ~  8   $   t     $   t  d    $         $     0  "$    P 0  &$   B  t 0  +$   B   0  2$   B   A  6$   Q  < A  :$   Q   A  >$   Q   A  D$   Q     I$   ~  T    N$   {      S$    \    X$        ]$   t     b$   t   B f$   a  < B j$   T  P B n$     C  r$   a   C  v$   T   C  z$      > ~$   O  4 > $   G  T > $   @      $        $   C    $   C D  $   B   D  $   B   D  $   Z   E $   [  , E $   [   F  $   [  0 F  $   [    ; $   ,  4 ; $   ,  $ ; $   ,   ; $   ,      $   ,      $   ,  h    $   ,      $   ,      $   ,      $   ,   +  $      +   $      G $      G $         $        %     8 
  %     T 
  %      
  
%      
  %      
  %     D 
  %     h 
  !%      
  '%      H -%      H 1%     ( I  6%     8 J ;%     H K  @%     X L E%     h M  J%   B  x M  N%   B   N  R%   Z   N  X%   Z  D N  ^%   Z   N  d%   Z   E j%   [   O n%   A   P r%   Z  l P x%   Z   P ~%   Z   P %   Z  4    %   ,      %   ,  8    %   ,      %   ,  x   %   ,     %   ,  |   %   ,     %   ,   Q %   [      %   ,      %   ,   R  %   [  X R  %   A     %   ,      %   ,  L F  %   [   S  %   %  , S  %   %   S  %   % S  %   % S  %   &  , S  %   %  P S  %     X S %   &  \ S &   !   S  	&   % S  &   % S  &   %   S  &   %      &   '  %&        )&     @  .&     $  3&       8&       =&       D&       J&     8  O&     P  U&       \&       a&       e&  
  O o&   [   O t&    T  z&   [   T  &   [      &   ,   `   &   $   &      &   ,  $ U  &   \    &         &         &         &     8    &     D    &     h    &     X    &           &          &      &      &       &      &      &       &      &       &       '       	'  	     '      '  	     '  	     ('      ,'       1'       6'       <'      @'       D'      I'       N'       S'      Z'     T  a'  
   k'     
  o'      
  t'     X 
  y'      
  ~'      
  '     ( 
  '     ( 
  '     h 
  '     h 
  '      
  '      
  '      
  '     P 
  '      V  '     4	 V  '     	 V  '  
 +  `
 V  '   +  
 V  '    
 V  '   +  @ V  '  
 +  h V  '   +   V  '   +   V  '   +  | V  '      V  '     P
 V  '   +  
 W  '   -  ( X (   -  X Y  (   - Z  (   ,   [  (   ,   \ (   -   [  (   ,  ( Z  (   ,  X   !(      %(   $     +(   $   /(   $     5(   $   :(      >(   $   B(   $     I(  	 $     R(   $   X(   $     ^(   $     d(   $    j(   F     o(   "      v(   "  `    |(   "  x ] (   ! ^ (   % ^  (   !   ^ (    Y (      Y (      Y (        (      X  (   #   X  (   #   X  (   #     (      _  (     $    (   $ ` (    $  (      H w   (   "  `    (   $      (   $      (   $      (   $  p T  (   !   T  (   !  T T  (   !   T  (   !  d T  (   !   T  )   !  l \  )      \  )      \  )      a )   "   a )   "   a  )   "   a $)   F  P ^ ()   % ^ .)   % ^ 5)   ! ^ :)   ! ^ ?)   % $  C)      \ $  I)      t $  M)      | $  T)       `  X)   +   `  \)   +   % `)     % e)     % j)     b p)   "   c  t)   "     x)   U    |)        )          )   $  l    )   $  |    )   $      )   $      )  
 $      )   $      )   $   d )   W   e )   V f  )   W   g  )   V   ] )   ! W )   #   W )   #   W )   #   ^ )   % ^  )   !   $  )      (    )   $  < h )   "  l ` )      )      _  )         )   $       )   $   i *      	*          
*   $  @  j *   #  ! j *   #  ! k   *   #  ! W (*   #  " W +*   #  " X  3*   #  " X  6*   #  " ^ >*    Y C*     " Y G*     " U   O*   $  # U   S*   (  0# Z  W*   ,  H# U   [*   (  `# U   _*   (  p# U   e*   (  D$ U   j*   (  `$ ^ n*   %  $ ^ r*   %  4% U   v*   (  % U   z*   (  & U   ~*   (  \' U   *   (  |' U   *   (  ' U   *   (  ' i *    \  *     ' \  *      ( U   *   $  $( U   *   (  <( Z  *   ,  T( U   *   (  l( U   *   (  ( U   *   (  ( U   *   (  ) l  *     ) m *     * n *     l* o  *     * %  *   ,  * %  *     *    *   ,  *    *   ,  ,+ %  *   ,  + p *   /  + p *   /  + p *   /  , p *  
 /  ,, p +   /  , p +   /  , p +   /  4- p +  
 /  @- p +   /  - p $+   /  8.   )+   ,  d.    -+   ,  . Q 1+   [  / F  5+   [  T/    9+     /   =+   O  /   B+   O  0   F+   O  1   K+   O  1 q  O+   5  2 q  S+   5  42 r W+   5  @2 r \+   5  `2 s  `+   >  |2 s  e+   >  2 s  j+   >  2 t n+   >  2 t s+   >  3 t x+   >  H3    |+     T3 u +     3 u +     4 u +     4 u +     5 u +     ,6 u +   .  6 u +     6 u +     6 v  +     ,7 v  +     `7 v  +    v  +      8 v  +     $8   +     @8   +     H8   +     P8   +     X8   +     `8    +   :    +   :    +   :    +   :   +     h8    +   :    +   :   +     p8    +   :    +   :   +     x8   +     8    ,   :    ,   :  8    ',  
 $  8    4,   :    8,   :    <,   :    @,   :    D,   :    H,   :    L,   :    P,   :    T,   :    X,   :    \,   :    `,   :    d,   :    h,   :    l,   :    p,   :    t,   :    x,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   :    ,   $    ,   $    
-   $ h -     9 h -     <9   -     9   #-     :   )-     : w  .-     : w  >-     0; w  J-   '  ; x  O-     ; %  T-   ,  (< %  Z-   ,  (= %  `-   ,  (> %  d-   ,  \>    j-   $  t> x  o-     > y s-     > z w-     > z -     ,? z -     ? l  -     ? l  -     @ n -     h@ n -     @    -   ,  @ %  -   ,  LA {  -     A | -     A }  -     A %  -   ,  ,B %  -   ,  B    -   $  B    -   $  |C    -   $  C    -   $  4D %  -   ,  |D %  -   ,  D %  -   ,  <E %  -   ,  E %  -   ,  F %  -   ,  F %  -   ,  $G %  -   ,  G %  -   ,  G %  .   ,  @H    .   $  H    .   $  I    .   $  XI    .   $  HJ    .   $  xJ    #.   $   K    '.   $  DK    -.   $  K ~ 2.     K }  6.     K }  :.     lL  @.     D.     L   H.     M   L.   3  M   S.     M   Z.  	 3  N   c.   3  N   j.   3  N   n.   3  O   r.   3  O   z.   3  XO   ~.     hO   .     O   .     O   .     O   .     P   .     P   .     P    .     Q  .   %  @Q  .   %  TQ  .   &  xQ  .   %  Q  .   %  Q  .   &  Q  .   &  Q  .   %  Q   .   #  Q 4 .   #  Q   .   $  R U   .   (  0R   .   $  LR   .   $  |R   .   ,  R   .   ,  S   .   ,   /   ,   /   ,  PS   /   ,  S   /   ,  T   /   $  ,U   "/   $  U   (/   $  U   -/   $  U   9/   $  U   A/   ,  V   F/   ,  V   J/   ,   V   P/   &  0V   T/   &  8V   X/   &  @V   d/   &  \V   h/   &  dV   l/   &  lV    r/   <  tV    v/   <  |V    |/   <  V    /   <  V    /   <  V    /   <  V    /   <  V  /   '  V  /   '  V  /   '  V  /   '  V  /   '  V  /   '  V  /   '  V  /   '  V  /   '  V  /   '  W  /   '  W  /   '  W  /   '   W   /   :  (W   /   :  0W   /   :  8W   /   :  @W   /   :  LW   /   :  `W   /   :  pW   0   :  W   0   :  W   0   :  W   0   :  W   0   :  W   0   :  W   &0   :  W   20   :  W   60   :  W   >0   :   X   F0   :  X   J0   :  X   N0   :   X   b0   :  @X   f0   :  HX   j0   :  PX   n0   :  XX   v0   :  lX   z0   :  tX   0   :  X   0   :  X  0   ;  X  0   ;  X  0   ;  X  0   ;  X  0   <  X  0   <  X  0   ;  X   0   ;   0   <   0   <   0   ;  0   ;  X  0   ;   0   <   0   ;  X   0   <   0   ;  X   0   ;  X  0   <  Y   0   ;  Y   0   <  0   ;  0   <  0   ;   0   <  Y   0   ;   Y  0   ;   0   ;  (Y  0   ;  0Y  1   ;  8Y  1   ;  @Y  
1   ;  HY   1   <  PY   1   <  XY   1   <  `Y   1   <  hY    1   ;  pY   $1   ;  xY  (1   ;  Y   ,1   ;  Y  01   <  Y   41   ;  Y  81   <  Y  >1   ;  Y  B1   ;  Y  F1   ;  Y  J1   <  N1   <  Y   R1   <  Y   V1   ;  Y   Z1   ;  Y  ^1   <   b1   ;  Y   f1   <  Y  j1   <  Y   n1   ;  Y   r1   <   v1   <   z1   <   Z  ~1   ;  Z  1   ;  Z   1   <  Z   1   ;   Z  1   <  (Z   1   ;  0Z   1   <  8Z   1   <  @Z  1   ;  HZ   1   ;  PZ  1   ;  XZ  1   <  `Z   1   ;  hZ  1   <  pZ  1   ;  xZ  1   ;  Z  1   <  1   <  Z   1   <  Z   1   ;  Z   1   ;  Z  1   <  1   <  1   ;  Z   1   <  Z  1   <  Z   1   ;  Z   1   <  Z  1   <  Z  1   ;  Z   1   ;  Z   1   <  Z   1   <   2   <   2   <   2   <   2   <   2   <   2   <   2   <    2   :  Z   42   :  [  D2   ;  ([  I2   ;  0[   N2  	 '  8[   W2   '  L[   [2   '  T[   _2   '  \[  c2   ;  d[  h2   ;  l[   m2   ;   r2   :  t[   v2   ;   {2   :  [   2   ;  [   2   '  [   2   '  [  2   ;   2   :  [   2   ;  [   2   :  [   2   &  [   2   :  [   2   ;  [   2   '  [   2   '  [   2   :  [   2   ;  [   2   ;  [   2   '  [  2   ;  [   2   '   \   2   :  \   2   '  \   2   ;  \  2   ;  \   2   '  $\   2   :  ,\   2   '  8\  2   ;  @\   2   '  H\   3   :  L\   3   '  T\  3     \\  3     \  3   3  ]  3   3  ]  3   3  D]  "3   3  d]  .3   0  ]  43   0  |^  :3   0  _   >3   /   D3   /   H3   /   N3   /   R3   1   V3   1   [3     l_    `3      d3   -   h3     _   t3      x3      }3       3      3   -    3       3      3   -  `   3   -  `    3      3   -   3     4`   3  	   ` U  3     ` U  3     a   3     8a   3     Xa  3     da  3     a   3   )  a    3     a  3     b   3   .  \b  3     tb  3     b  3     b  3     b   3   .  b    3     b    3     b   3   .  c    3     c   4   .    4     Tc U   
4   (  pc  4     c  4     c  4     c   4     c  !4   .  c   %4   -  d U   )4   (  (d U   /4   (  (e U   64   (  he U   ;4   (  e U   @4   (   f U   D4   (  f U   H4   (  0f U   P4   (  Pf U   V4   (  f U   \4   (  f U   a4   (  f U   f4   (  g U   k4  	 (  g U   t4   (  h  y4     h h  4     i h  4     i h  4     i   4     j  4   3  0j   4  	 /  j   4   /   k   4   /  k   4   /  4k   4   .  k  4   .  k  4   .  k  4     k   4     l   4     hl   4     pl   4     l    4     l  4   .  l   4     l   4     m   4     <m  4    m    4     m   4     m   4     m   4     m    4      n     5      n    5     `n  5   .  n  5   .  n  5   -  n  5     n   5     o  %5     o  *5      o  .5   -  ,o    25     Do  75   -  po    ;5     o    @5     o  D5   -  o  H5     o  M5  	   p  V5     (p  [5     4p   _5     <p   c5     Xp  g5   .  p  k5   .  p   o5   /  p   s5   Y  p  w5   /  p  {5   Y  ,q v  5   ,  Dq v  5     |q U   5   (  q z 5    z 5     q z 5     xr z 5     s   5   ,  8s   5   ,  \s   5   ,  Lt   5   ,  t   5   ,  u   5   ,  v   5   ,  w   5   ,  |w   5   ,  w U   5   4  w U   5   4  x U   5   4  dx U   5   4  Ty U   5   4  y U   5   4  8z U   5   4  \z U   5   4  L{ U   5   4  { U   5   4  (| ~ 5     \| }  6     || }  6     } }  6     }  6   Q  ~  6   Q  $~  6   Q  ~  "6   Q  ~  '6   Q      +6   P  $   /6   H  4   36   N   %  76   S   %  <6   K   %  @6   M      D6  	 L     M6   P  `  Q6   H  p  U6   N  Ā %  Y6   S  Ѐ %  ]6   M  ܀    d6  	 M  (  m6   a  x  q6   H    u6   N  ؁   y6   T     }6   H     6   N  D   6   P  P   6   P  ؂  6   P    6   P  |   6   Q     6   Q  Ѓ   6   Q     6   Q  H    6   R      6   R      6   R  d    6   R     6   T  Ć  6   T      6   R    6   G  0  6   O  X    6   ?  l    6   ?      6   ?      6   ?      6   ?      6   ?      6   ?      6   ?      6   ?  X    7   ?  H    7   ?      7   ?  P    7   ?      7   ?  č    7   (  ԍ    $7   ?  ,    *7   ?      /7   ?  0    47   ?      :7   ?  T    @7   ?  D    E7   ?  4    K7   ?      P7   ?      V7   ?      Z7   ,  8    a7   ,  8    e7   ,      k7   ,  4    o7   ?  l    t7   ?  @    y7   ?      7   ?  0    7   ?      7   ?  t    7   ?      7   ?      7   ?      7   ?      7   ?  P    7   ?  \    7   ?  Ԛ    7   ?      7   ?      7   ?      7   ?      7   (  ̜    7   (  \    7   ?  x    7   ?    s  7   >  $ s  7   >  T s  7   >  ` s  7   >  О s  7   >  @ ~ 7     X ~ 8     ğ ~ 8     0 ~ 8      ~ 8      ~ 8      ~ 8     d ~ !8     ġ ~ &8        -8   ,     38   ,  <  98       =8       A8       G8     X  K8   /    R8   /  (  V8   B      [8   ,  ̧    _8   ,  l F  c8   [  Ш F  h8   [  p Q l8   [  ԩ Q q8   [  t S   u8   (  ت   y8     ,   ~8     X   8     ȫ   8        8     Ȭ   8     4  8     <  8       8   ,   U   8   (  ( U   8   (  ȯ U   8   (  h U   8   (   U   8   (   U   8   (  ȱ U   8   (  X   8   B  ز   8   Z   Q 8   [  p Q 8   A  ̳ Q 8   [   Q 8   3     8   /     8   /   v  8   ,  ̴ v  8   ,  \ F  8   [   F  8   [   F  8   3      9     h  	9   	  ̶  9   	  < O   9   	  X O   9   	 %  9   ,  ȷ %  $9   ,  ` %  (9   ,   %  -9   ,   %  19   ,  ,    79   =  t    >9   =  X    C9   =      H9   =    L9   ,    R9   ,  x   V9   =     \9   =  X  `9   	    f9   	  ` O   j9   	   O   p9   	   F  t9   3   F  x9   3   F  |9   3   F  9   3   Q 9   3   Q 9   3   Q 9   3   Q 9   3   v  9   ,   v  9   ,   v  9   ,  X v  9   ,      9   	    9   	    9   	  l O   9   	   O   9   	   O   9   	   n  9   ,     9   (  @   9   (     9   ,  H  9   ,    9   ,  , _   9   (    9   	    9   	    9   	    9   	  ,  9   	    9   	     9        :         :     \   :        :   ,  p C :      C :      C :      C #:     H C &:        +:   (     1:   ,    7:   ,  d    =:   (      B:   	    G:   ,     K:   (     O:   (    T:     L  X:        \:   	  P   `:   
     e:   
  X   i:   
  |   o:   
  0   t:   
     z:   
  p   :   	     :   	  h r  :       :   	  l  :      U :   	  X U :   	   U :   	     :   
  $   :   
     :   
  T   :   
     :   
  T   :   
     :   
     :   
     :   
     :   
     :   
     :   
     :   
     :   
  D   :   
  x   :   
  h   :   
  8   :   
  t   :   
     ;   
      ;   
     ;   
     ;   
     ;   
     ;   	      ;   	    $;        *;   	    .;   	     2;   ^  T  6;   _  ` N   :;   ]  l   >;   _   B;        F;     L  J;   	    N;   	    V;   	    Z;     _;      c;        g;        k;         o;   	  s;     T  y;     $  };   	    ;   	  l   ;        ;   	     ;   	    ;        ;   	  `   ;   	  $   ;         ;   	  l r ;   5  $ r ;   5  t r ;   5     ;        ;        ;     t   ;        ;         ;     8   ;        ;     4   ;     T   ;     t   ;        <        <     h U   
<   4   U   <   4  ( U   <   4   U   <   4   U   #<   4   U   )<   4  < U   -<   4  L U   3<   4   U   8<   4  | U   =<   4  l  U   B<   4    U   H<   4  d U   M<   4   U   Q<   4  D U   Y<   4  4 U   `<   4   U   e<   4   U   i<   4  D %  n<   ,   %  s<   ,    %  y<   ,   %  }<   ,   %  <   ,   %  <   ,   %  <   ,  D %  <   ,   %  <   ,  	 %  <   ,  	 %  <   ,  
 %  <   ,  | %  <   ,   %  <   ,     <     8   <     d   <        <      <  	      <     
   <        <        <     P v <   8   v <   8   v <   8   `  <   6   `  <   6   `  =   6  H    =   6      =   6      =   6  8   =   7      =   7    &=   7    *=   7     /=   9     5=   9  $  9=   9  X  >=   9     B=   8   F=   8   L=   8  P=   7    T=   7   `  X=   9   `  ]=   9  \    a=   9      f=   9     j=   7     n=   7     r=   7   b  w=   9    {=   9    =   9  , _   =   9  @   =   9  p   =   9   `  =   6   `  =   6  0    =   6  `    =   6   _   =   6     =   6   b  =   6  =   6 .   =     `  =      =   	  l   =   	  0   =     d  =        =   
     =   
     =   
     =   
     =   	  @  =   	     =   A  8   =   A   .  =   6    .  >   ,  \ .  >   ,  x .  
>   ,   .  >   ,    .  >   6  H  .   >   :    .   !>   :    .   %>   :  D! .   )>   :  t! .   1>   :  d" .   6>   :  " .   ;>   :  " q  ?>   5  " q  E>   5  @# q  I>   5  \# : M>   8  x# 3   R>   6  # t W>   >  $ t \>   >  t$ t a>   >  $   e>   7  $ t j>   >  % t p>   >  @%   u>   7  L%   y>   8  `% 3   ~>   6  %  >   A  %  >   A  &  >   B  8'  >   B  '  >   A  d(  >   A  (  >   B  ,)  >   B  )   >   A  4*   >   A  *   >   A  *   >   A  +  >   	  >   	  (,  >     \,  >     ,-   >   
  -   >   
  .   >   
  .   >   
  h/   >   @  /   >   
  /   >   
  40   >   
  0   >   	  0   >   	  1   ?   	  |2 .  ?   ,  2  
?   A  3  ?   A  d3   ?   A  3   ?   A  4   ?   /  d4   !?   /  4   %?   /  4   )?     4  -?   3  4   1?     4   5?   .  4  9?     5   ??   .  5   C?   /  45   H?   /  T5   N?   /  x5   S?     5  Y?   3  5  _?     6  d?     6  i?     $6   n?     06   r?   .  D6   v?   .  l6 ,   z?     6   ~?   .  6    ?     6   ?   .  6   ?   T  6   ?   a  $7  ?   a  07  ?   T  <7    ?   R  t7  ?   G  7  ?   O  \8    ?     p8 p ?   /  8 p ?  	 /  8 p ?   /  9 p ?   /  9 p ?   /  H9 p ?   /  9 p ?   /  9 p ?  	 /  9   ?   3  $:   ?  	 3  8:   ?   3  :   ?  	 3  :   ?   3  :   ?   3  :   ?   3  :   @   3  :   @   3   ;   @   3  t;   @   3  ;   @     ;  #@   3  <  )@   3  H<  .@   3  p<  3@   3  <  7@   3  <  >@   3  T=  C@     =    H@   2  >    M@   2  D>    R@   2  p>    X@   2  >   ^@   /  8?   b@   /  H?   f@   /  X?   k@     p?  p@   -  u@   -  y@   -   ~@     ?    @     ?   @     @   @     \@   @     |@    @     @  @   .  @ (   @     @   @   -  A   @     (A   @  
   4A *   @     PA  @     A   @     A    @     A   @   .  A   @   -  A   @     B   @      B   @     ,B   @   -  8B    @     PB    @     |B   @   -  B    @     B   @   -  B   @     C   @     C    @     (C  A   .  XC    A     pC  	A   .  C *  
A     C   A     C   A     C   A      D   A   .  0D   "A   .  HD   &A   -  `D   *A  
   xD (  7A     ;A     D  @A     D  DA     D   IA   -  D   MA     D   RA     E   VA   -  HE   ZA     `E   _A   -  E  cA     hA     lA     E   sA     E   wA     E   {A   -   F  A   .  8F  A   .  PF  A   .  hF  A     F  A      A     F  A   .  F   A     F  A   -   A   .  F   A       A     TG   A     G    A     G  A   .  G  A   -  G  A     H  A     H   A     (H  A   -    A     TH  A     H  A     H  A     H  A     H  A  
     A     H    A     H   B   -  I  B    4I   B   .  LI  B     B     B      B   .  dI    B     |I    "B     I   &B   .  I   *B     I  1B     TJ   6B     tJ  :B     J    >B     J  BB     J 3  FB     J   KB      K   OB     PK   UB     K    YB     K    ]B     L    cB     L    iB     <M 2 oB     M 2 tB     $N 2 zB     N    B     \O    B     lO R   B     O   B     O   B     PP   B     P   B     P   B     P 1 B      Q 4 B     Q 4 B     Q 4 B     Q 4 B     tR 4 B     S  B     \S  B     tS  B     S   B     S 5  B     `T 5  B      U 5  B     U    B   	  @V U B   	  tV    B   ?  V    B   ?  V    B   ?  $W    B   ?  8W    C   ?  DW   C   
  XW   C   
  W   C   
  W  C   	   X  C   Q    C   Q    C   	   #C   
  X   (C   6  (X    ,C   ?  HX    0C   $  \X @  4C   ~  |X ? 8C   {  X    <C    X    AC    0Y   EC   t  tY   JC   t  Y   NC   y  Z   TC   y  Z   XC   ~  0[  \C   {  [   aC   t  P\   gC   t  @]    lC   R  ^    rC   R   _    wC   Q  _  {C   Q  p`    C   $  a   C   6  a   C   Q  Pb   C   Q  b  C   Q  c  C   Q  c   C   P  c   C   P  pd   C   6  d   C   6  e   C   6  e   C   6  Df    C   ?  \f    C   ?  Lg    C   ?  |g    C   ?  g   C    C     C   P 	 C   P 
 C   Q   h   C   Q  ,h  C   
  C    C     C    C     C    Xh   C     C     D      D      	D     h  
D     h   D    D     D    D    !D    i   %D    Hi   )D    -D     1D   !  5D   "  9D    ti # =D    i $ AD   7  i %  ED   7  i &  ID   8  j ' MD   8  0j (  QD   6  Lj ) UD   6  j * YD   +  ]D   , aD   -  eD   . iD   Q  j /  mD   Q  0k 0 qD   1  uD   2  yD   3 }D   4 D    lk 5  D    k 6  D   7 D   8 D   9  D   :  D   Q  l ; D   Q  8l <  D   = D   >  D   ? D   @ D   A  D    dl B  D    C D    D  D    E D    F D     l G  D     l H  D   I D   J D   K  D   L  D    m M D    Hm N  D   O D   P  D   Q D   R D    |m S  D    m T  E     m U E     m V 	E     n W  
E     4n X  E     Tn Y E     n Z  E   [ E   \  !E    ] %E    ^  )E    n _ -E   Q  8o `  1E   !a 5E   !b  9E   $c =E   $d  AE   # o e EE   " o f  IE   g ME   h  QE   i UE   j  YE   Q  p k ]E   Q  \p l  aE   m eE   n  iE   o  mE    p p qE   q uE    p r yE   B s  }E   B t E   %u  E   %v E   [ w  E   [  Dq x  E   y E   z  E   { E   | E   Q  q }  E   Q  q ~  E    E     E    E    8r  E     E    r   E   ( E   ( E   &  E   &  E   ' E     r  E   *  E   * E   )  E   ) E   + <s   E   + E   O  E   ,  E   ,  E   O  F   +  F   + s    ]                            	   
        
 ;                     W    (    !     ;                              J   "   #   $   % &     '     ) :    * 4   + 1   ,   - /   .     0     2   3   
   5   6   7   8   9   A   ;   <    = ?   >   W  @   A D   B >  C   $  E F >    G G  H S k  I N v   J K     L M       O   P   Q v   R     T V   U       X d   Y b   Z ]   [   \      ^   _ `     a     c   v   e m   f   g k   h   i   j     l     n r   o p     q     s }   t z   u x   v   w     y     {   |     ~  Z                                                                                                          4   3                    $         $   >     /    A     W   $        >     >              G   k     G     k                                                       $                     >   $     >   $        >   $                                                 $          >   $        $   >      2        >   $          	   >  $  $    >          

>  $     >       	        
                        "B    >  !$    #&>  $  %  
  '+  ()     *    ,-    .    0  1  2     4  5L  6H  7@  8;  9  :    <  =?  >      A   BE  C  D    F  G    I  J  K    M  N  O  PW  Q  R  ST>    U	  V    X  YZ>    [  \r  ]j  ^  _c   `b  a         dh!  ef  "  g  !  i"    k  ln   m#  "  oq!  p#  #    s{  tz  uw  v$    x$  y       |$  }  ~#      %             &  '      (     )  U   *  +       ,  +           '  -  .  /    0  (  1     2  3  (  4  5  0  6     '     7  '  (  (  '        (  4  '  5  '  8  9  :  *  ;  '  (  '  .  <          =  ,  6  ,  >  ,  ?  ,  0  @  A  B       C  D  E  F  G  H  I  ,  D  J  ,     >    (  K  &  L  -  M  
  N  O  P  &  &  =  Q  ?  (     &    &  V   R        S    R            S  '  $   	(  &  T  M  U  N  &  
V       
W    X  6  (           /  2     7        #Y  Z  3  5  [   !9  \  "*  W  ]  %r6  &O,  '>   (,  )  *  +(     -  .   /5   01^  _  23/  /  4E  `  6=   7<a  8:E  92  G  ;2  G  I  a  ?L   @  A  B(   CH   DEb     FGc  d  e  I_  JKJ  E    M`  NG  ,  P[f  Q+  Rg  SY&  TU  UXT  VWM  N  O  &  Z  &  \f  ]b   ^a  _*   `h    i  c  dj  eok  fk   gih  hQ  b  jQ     lnb  m?  ?  l  pq@  B     sw  t  u   vX  ,  x|W  y   z&  {+  &  }   ~W    m    n  o        p      q      q  r    4  s  t    3   u  v  w      '  N;  =x  y    z  {  B     $  >  B   6  $  >  |  }  ~  $     }      j            >       S            |  ~         $  X      $      $  {       %   -      %   S                     X    X      |  ~  $           |    \         \    $        \        z            S   
  Y                  	      W  
            S                  <    <    z     !   S  "/  #'   $  %  &     (.   )  *   +  ,  -     ,  0<  17  26   3  4  5       89     :;          >E  ?BS  @   A  S  C   D    FJ  G  H  Ix    K  L  M     OU~  P  Q$  RS     T  p  V  W  X[~  Y  Z    \    ^m  _id  `e  a  b  c  d    f  g3   h    j  kr  l    n  o};  p  q  r  s  t  u  v}  w  x{  y  z    |    ~           zz              |  z      $    U        $     T        T    |    $       V  i  V    w                     |          $     %   w      $    %   $                /    >    !                      !    !                                                                  
  /    >    !                                 	         
z          )  z  z  U       z                  !a<  "B  #/  $P  %&    '>  (+=  )*    0  ,-  A  .    0
  1:  27  36  4L  5  -  z  8-  9     ;>  <  =P    ?  @K  A    CH  DF  E   D  G    IO  J  KM   L     Nz     PSz  Q   R  :  T  UW0  Vz    X4  Y]   Z\z  [  z  z  ^8  _`       bd  c  U  emH  f  ghD    iC  jF  kl       np  o  0  qw  r  s   tu  1  v    x4  y    {  ||  }  ~'      "         h             $  %      $    i       V  $          $  h  %   $    $           O  >  $  O    >  $      >          >      >  $        >  $  >  $    T  "                          5                      a        a              $  >    >  $            $  >    >  $        $        $        $    c                             	   
      
                   I  /  +    >  $  v   $       	  !#  "
  $    %(  &  '    )  *    ,  -  .    0A  1   2;
  37  46  5      89    :    <  =  >@  ?      B   C  DF  E    G  H    J\  KU  Lv   MP  N  O    Q  RT  S      VZ  W  X  Y    [  n  ]a  ^  _  `    b    d  ei  f  g  h  '  j$  kl>    mq  n  o  p    r  sw  tu    v    xz  y  }  {  |  }  ~v     v          !     "  #    $  '  >    %  &    '    %  (      &     (    %  )  )  '  )    &    *  +  ,  -  .  /  *    -  .    ,        $      (    0  1                   
  2  3  4  5        6      7  8  9  :  n          ;  :  <  ;  =      =          8      /  (  =  (        qz  Oi      l        k  j      f    g    T          U              f      *   	  
j     
>     ?  @  l     @    A    (   A           (     '  #   W  !   "     $W  %  &    (3  )  *a  +1  ,.  -e    /_  0  `  2  ]  4K   5?a  6;  7_  89    :    <`  =>       @  A   BF  C   DEB      G   HI  `  J    L  MU  NX     PX  QT  RV  S  TU    U  W    Y  ZX  [e  \]     ^d   _b   `a       c       fgW  C  hpY  ilZ  jk    [  mn  \  o  W    r  sz  twR  u   v    xR  y    {  |  D  ~E  F  $    G  7  <      H  I  J         K  L      M    N  O  P  Q       K  R  S    T     K  L      U     K  R  S  v  V  W  X  H                Y  Z           K    [     K  \      ]    ^  _  `  Q       K  a  b    c     K  \    x   d     K  a  b  \   e  f  g    Y        #        K  h    #        K  {   i    j  k  l  m      j  k  l    k  l  n  o  D        p   k  l  q  $    p  k  l    	}  l  n  r  
!      ~  s  t  t  u  v  w  s  t  x  y  z  {  |  	  z}  Q   ,L   !)~  "&  #  $  %    '  (    *  +     -1   .  /  0    2Ll  3D  48  5  6  7    9?  :=  ;  <    >m    @  AB  m  C    E  Fy  G  H  I  J  K    M  N  O  P    RW~  S  T  U  V  '  X   Y  Zm   [i  \f  ]_  ^L     `d  ab    c    e    gh  U    jp  kl    m  n  o    qw  ru  st      v    x  y    {	o  |   }  ~    $       /	  	/  z         3       c    m  Q        v       Q    Q    Q            Q  _                  U         }     $             _          3       \    -  _     _     _   6       -  _           -            $  ~      2      $       $      $  >    >  $      $         y  }     y         2    2  $        >  $                                	  
      
        <  U   o    Q          ~  5  %           !3     "  #  $     &3  '.  (*6  )_     +,_   _   -     /|   0  1)  2    4    6H  7GV   8C  9<  :>  ;$     =A  >?>  $  @  >  B$  >  D$  E  F      IO_  JM$  K  L    N$    P    R  S  Ti  U^  V  W\   X[_   Y  Z   _   _   ]    _f   `c  a$  b    d  e    g  h    jl  k    m  n  	  pu  q  r   st    P  v  w  x   y  z~  {  |-  }    K    -  
  L             A        >  =    0                   1              0    	       1               0    C            F                    H        D           C         F              8  4            :         ;           g    U  T                 k    f         f            	        _          y  	     	$  	}    	    	  	  	    		  
	  		    
	!	  		   	  	  	     	  		  	  		   	  	  	    	  	  	    	   	  C  "	+	  #	)	   $	   %	'	   &	     (	     *	  ;  ,	   -	  .	    0	  1	  2	>	  3	8	  4	6	   5	     7	  R  9	  :	<	  ;	     =	    ?		  @	  A	C	W  B	   	  D	p	   E	X	  F	K	Y  G	I	   H	  [  J	  X  L	S	  M	O	   N	     P	R	   Q	       T	Z  U	  V	  W	     Y	k	   Z	a	   [	a  \	_	   ]	  ^	    `	     b	g	`  c	e	  d	    f	     h	]  i	  j	  _  l	n	   m	   a  o	  \  q	z	   r	y	  s	[  t	x	Y  u	w	   v	           {	}	  |	W     ~	W  _  			  		e  		  	   	    	   		  	    l  		   		j  		  	  	    	  	    	  	  (   		  	  	    	i  	  	    	  	   	W  	    		  	  	  	    	  	[  	  	  	    	  		   		  	  	i  	  	  	    	  	  	    	  	
;  		  		   		  		  	    	  	    		    		  	
  		  		    	  		   		  	  	  	  	
  	  	  	  	    		  	   	  	      		   		   			  		      	
  	  	
  	        		C  			  	   	  	    		  		  	C    		
  		   	  	        	  	   	    	
    
h  
	     
h  
    
j  

  
  	
  


  

  

  
!
  

  

$  

  

    

  
      
    

  
  O  
    
  
   
    "

   #
:
  $
  %
  &
,
  '
*
  (
  )
    +
    -
0
  .
  /
    1
3
_   2
    4
7
_   5
  6
  _   8
  9
    ;

  <
[
  =
F
  >
D
  ?
  @
$  A
B
    C
    E
$    G
Z
o  H
T
  I
K
O  J
$    L
R
  M
N
>     O
Q
$  P
!  $  >  S
$    U
W
$  V
  $  X
>  Y
    "  \
k
#  ]
b
_   ^
  _
a
  `
    )  c
h
_   d
  e
f
    g
    i
U   j
$    l
u
  m
  n
   o
  p
q
3      r
S  s
  t
E  E  v
x
   w
  _   y
{
  z

  4  |
~
  }
    %  
&  
  
    

'  
  %  
  

'      

  

  
o  

  

  

  

$  

  

  

  
  5  
    
  
    
  5  

>  
$  
(  $    
$    

  

  
  
      
  
    

  

>  
$  
  $  
    
  
  )  

  
  

  
3   
  
     

E  
_   

*  

V        
    
  

_   _   
  
L  +  
  
_   ;  

  
  
  ,  

_   
  Q  
  ;  
  
Q  ,  

  
  
-  
$  
  .  
  
T  

/  

0  1  

Q  2  3  

3   
/  
0  
4  q  

5  

Q  v   

3   
1  
6  1  
2  Q  
7  \  
fC  
(  
  
P  
  
   
    L  -      8  
  
  	9    K  :    A  ;      >  =  <  0  =  >    "  -  ?     D  %     $<  !"    #@      &  'A    )B  *.   +  ,#  -  "  /#  08  13   2  ;  46   5    7?  8  9?4  :=  ;   <B    >C    @:  A$     CFF  D  ED  "  GD  H  IS1  JM  K   LE    N   OQE  PF  0  RF     Ta   U[  VF  WY   XG  H  ZG    \  ]`H  ^I  _H  I    b1  cd  0  eF  J  g   h  i   %  k   l#  m}  n8  of  pz  qy  rs  g  t  uU  vxT  w9  :      {k  |;    ~   j       K  <    =  K  l    =  L  (     L  >    i  >  M      e     N  @  N        X        _  @  _    a  A       a     O  A  D  O  `  D  G       H  G  ]  I  H          I    "     E       "    Z  F    E      #  W  W    #  W  P  [  Y  B  C  \  $  W       R             h        Q    R  $    S  T  '  U       V       W  U  X  z  4         j  Y       Z   8  5  I[  \  ]          ^  	  
     8  
     O   _  1       ^            `  a  *b  !  c  d       e  "'d  #  $%  q  &  c  (  )  l  +6e  ,2  -0d  .f  /  f  1q  f  3c  4  5     7>g  8h  9i  :j  ;k  <l  =m  n  ?Ch  @  Aj  Bl  e  DE  g  F  Gk  Hm    JN`  Ke  L   M  o  OSp  Pq  Q  R  r  Ts  Ut  V  W  K  Y  Z  [  \  ]-    _u  `  av  b  cb   K  e  fw  gx  h#  i  K  k  l  m  n  oy  K  q  rw  sx  t  uz  {  w|  xr  y}  zl  {    }~  ~  Y  <      ~  K        K       z   M               b   K        S    K       z       K                    l         K    A  o       K            k            k    m  {   n                k    '        k    q    n    n         t      %      t                  
        
 	  , . - + 6 ; : 5 4 3 2 7 9 8   > ? @ A < = C B P Q U T R S O N V ^ ] \ [ Z Y X W M H * ) (                                         L K J I        #$            '(*)&%    "!   EFI KJ
INDC5   QP  4CMILMO3210       TU?@AXWHV=<:9  	GH[ZYBA10    \]^>=;:  	
a`_    /.-  69de6  fcb;:9876	
   RS hg,+mnpo!     

	 %&'# "!$!" )(%*+-,3210/.?>=<456789:;CBA@KJIHGFEDa`dcb_^QRSTUYXWVZ[\]ijklhgfeqpolmnkjivutsr|{zyxwPML  ~}O;)(:=3<9)>B8)*@)C?A6,)F4G7EIH5D2L).K)+MOJN/1TS$WXR#VYZQ%U\]0[&Pa)c-)^ebd _gf'`!"hrxtyswv{uzoq|ipj}k~nlm

	NO
  qtsrsu	~ 
|}{|zyxw
$&%#/-'"*+,+*) !v.-(0<;:9@?>=ECOQP11_^eCfN_gLM`ihHJLMNa`_jdEDCHclkmnbI32rqopGDEWVUts]yvTUxZuvSUw23ZWUS\[    DFG4|X4Kz}{~  Y6R  B A46 66 6 647857                          ,
+-&

'.*
(%)
/ 1#"!0

$24!356#>:;<=8
	?@=9A9 BGHEDJIFCDE
NLOP M
LQ
SRT	KU 7VWXYr[{zsq    zyx )'&
$*.-&%#"! (01("%
-.3--2/, !-!+48756^]Z@?>=<;            	9:AXW\[_TUV`acb]^SUWZYQRSHIPONMLKJGedhfg]gikimCsoButwvrqkExCDEpnmkklFEylkjihgj{ztuvwx|}~x y } u |}~v hgfedcba`_t w   nmhfdb`po| {     ~ { z oz \     	     

%$! #"/.-,+*3210987654=<;:PONMLK&'()JIHGFEBA@DCc[ZVYabUWXdUVWX\]^`_ponmjihglxwvutsrq}|kgz{y~TS 
	
'(#%&*),-$%+0/"! .:1233;59834567ABD@CF?>GHE?=<IKJLXWSUVYVRNMT]\[Z^_edcba`ghQjiPkgonmlfOqsvutxwrqp      			
										 	 					
	.	-	,	+	*	)	~	}	Y			X			|	W			V			L	z	(		{								H					w		T		R					x								v			y		I								G			P									N		D	M								@									J							C		F					A		K	B	M	O	P	Q	R	S	T	U	'	u	t	s	r	q	p	o	n	m	l	k	j	i	h	g	f	e	d	c	b	a	`	_	^	]	\	[	Z	B			%	$																																																					

 
E	
	




	
1	2	













!
 

#
"
~4	3			'
&
~4	3	4	)
(
$
%
		+
*
,

1	5	2




1
.
3
5
4

/
0

6
7
-
8


.
9
	:
5	"	>
=
~~;
<
?

			1	5	6	7	



					 	C
B
A
@
/	0	:	;	
'	&	$	#	P
O
M
L
J
I
G
E
0	8	9	<	Q
	 	K
J
H
G
F
D
F
?	>	=	<	N
R
a
}_
`
|b
S
X
\
]
^
\
c
S
[
W
d
S
	j
Y
h
{m
zg
l
	n
yi
k
		f
o
		f
p
		u
q
v
t
r
q
w
			y
s
x
	
!	U
}


T
z
e
Z
~
T
V
{
|
















		
































































3465+,*,
.-987210/:>=<;GFEDCBA@?HIKJONML*)('&[ZYXPQRSTUVW]\%gfc! $#a`_b^e#$cd_ah"{ysnmlrquvxwvuopqr
zytlmn|~}lijk

















































		

%$#"!   )(*'&+,-./

543201

67c b 980IJPONMHGFESRQCDEF
 TKIUBLVIWX[\_`ZYba^];:A@?>=<



efc b a ` _ jihg



qpocd_ ` klmn



efstvur

wz{|||}~yxwR||RQ



 
 




	










	












? 
>


#
"
+
*
)
' & % (
'
&
%
s r q p o n m !
#
$
-
,
.
p /
<
=
h ;
:
0
1
@
?
>
4
e f g h i j k l " # $ 9
8
7
6
5
3
2
1
1 0 / d A
J
I
H
G
F
E
D
C
B
R
Q
P
O
N
M
L
K
U
V
S
T
W
X
Z
Y
\
`
_
^
]
D E F G [
  b
a
d
c
r
q
p
o
n
m
l
k
e
f
  g
h
j
i
s
u
x
w
v
t
z
|
~
}
{
y































































































































 

                          	   
         
                                                             !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                       ~               x                           l            f            b         `   ]   _                  V                     R                              E               K   @      CF   ?      J:=A   <8B   I9   ;G   6                        2               .   *   4            0   $#!-(+   3& ,                                                                                                               e  	  
      
      ^        a      [  \n      m    g    c  kd   !  "  #  ph$  %  &  ij'  o(  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                      {      z                }      q                      b          \              ^c    Q          O  TN    JL            s  F                      ?        5      26@    >7                *L      $          H          D>#   %75  "                        
                                        	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                  d          _          Z                  Q          L                                EF  ;<    ?,                          2                &  7      B)/    !'      .  $  5  0      -6-(      %    4  C      8=     
                                H
  	>	  
  3    +
      (    
                               !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  '_  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  aev  w  x  \`y  z  W[{  |  }  ~        K  J      P    VO{      Uy  |  zu    xtwr          f  o              h+"            c                Z    V  g      S        T  ON    LQ    KYUJ  XGH  WFI      ^    ]C  `\A  @BD  R>E      <1          9  )  d&[a4  8  =6;2*b  :_?71              h    ,  )ib    &c]  X    $^                #                        !      j  IM    NR    	S  .           /                 	  
      
                                    ke  
   !  "  P#  fM$  %  &  '  (  )  	*  +  ,  
i-   .  +(/  mp0  1  0q2  3  4  5  6  7  8  9  s:  ;  '<  %=  "Tv>  ?  }@  A  
B  C  ~lg*D  n-E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                    {        w                            h              d        b        a\  X            k          O  Pg        KI  U    J`        FDEVY      C      B=    NG  @    7H                /          *          %      R               M8                            
                	                       	  
      
                    2                     !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  9M  N  5O  P  Q  R  S  T  U  V  W  X  ;Y  Z  [  \  ]  ^  _  `  a  b  c  TLd  Se  f  g  h  i  j  k  l  m  n  jQo  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                    }      z      x~    r  uws      q  n    9{  tp:j  ohkmlG|                    f  _            W    c      ^X          Z  V        <>  IN  b  H  MDG?            @            B      9      5    \`    a  ?  /          *    )    '  $+%        !&    #"  KEc        J             d]gy    <              ^0	    iev
Z                 
          T_e  	  
  i    f:
        8      46      7F    -  C    >A      =     !  W"  .,#  $  %   1&  ['  (  Y)  Q*  PUL[S+  ,  ]R-  .  /  0  1  2  3  4  5  6  7  8  9  ;:  ;  <  =  O>  ?  @  AA  B  3C  :D  E  6F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~              }    |~z,0      '+w    "&u    !s      4-    o.(    m)#    k$x  q  vhn  tgl  rfj            a            {  Z  _b    c    W^YV  ]STe`      dQ  X[  R\ON                              A                              2  6      .  1,    7        '    *-        "&      %      !                       !          
	4  )#        (8  
  $     G          5      	  
      
     0  ;    +                               !  "  #  /$  %  M9&  I'  (  3)  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                    w                                  i  m                [      a    o  k  U                                    B                    X  ?                                                    D                      F                  1           	        7    8  <  	  
      
          H      J                         !  "  #  L$  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  N:  c;  <  ~=  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  KM  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  F<g  h  LUi  j  k  l  m  n  o  p  q  r  s  t  =(u  v  w  x  y  z  {  |  }  ~                  {  :H  |  Jyx      u  P  t      ~p  w}o  2>  rm  ql  knj  vsi          h          b    ]ce  adz^_  gvq      X        U          Q  T  PO        K              FLMSV  HWY  DGAZC@N    EB:)5.&!  >  I=R  ?<;J      8        
6  4  2  @                -  .    9,)          =      %      (;                          0                           	  	  	  	  	  	  	  	  	  		  
	  	  	  
	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  	  "	  	  	   	  !	  "	  #	  $	  %	  &	  '	  (	  )	  *	  +	  ,	  -	  .	  /	  C0	  1	  2	  3	  4	  5	  6	  7	  8	  9	  :	  ;	  <	  =	  >	  9?	  @	  7A	  3B	  ?15C	  EDD	  E	  F	  G	  H	  I	  J	  K	  nL	  M	  N	  O	  P	  Q	  R	  S	  T	  U	  V	  W	  X	  Y	  Z	  [	  \	  ]	  ^	  _	  `	  a	  b	  c	  d	  e	  }f	  g	  h	  i	  j	  k	  |l	  m	  n	  {o	  p	  q	  r	  s	  t	  u	  v	  w	  x	  py	  z	  {	  |	  }	  ~	  	  	  	  	  	  	  	  	  	  	  	  z	  	  	  ~	  	  |	  xu	  	  	  	  	  	  	  	  	  m	  	  l	  	  	  	  	  	  	  e`	  s	  	  b	  	  bw	  	  	  d	  	  	  T	  	  VS	  RQUyX	  [	  W	  	  V\Y	  	  	  rOMv	  LM{J	  I	  ^T	  Z	  	  	  EPKHN	  G	  aKD	  FPf@	  AC	  	  eh	  td	  B]}<	  >	  _	  ;o	  l=8	  7:	  j	  	  	  j	  	  	  	  	  	  	  3	  /	  -cO`?g9i	  5	  1Q	  0	  ,%)&	  	  I.'	  #*	  4f	  _2!	   +	  q	  	  	  	  	  	  (n6p	  	  	  k	  	  	  	  	  	  	  	  $"	  	  	  	  	  	  	  	  	  	  	  	   
  
  
  
  ]
  
  
  ^
  
  	
   

  
  
  
  

  
  
  
  
  
  
  G
  
   

  
  R
  
  
  

  
  
  
   
  !
  "
  #
  $
  E	%
  &
  '
  (
  S)
  *
  g+
  ,
  -
  h.
  /
  0
  1
  2
  3
  4
  5
  6
  7
  8
  z9
  :
  ;
  y<
  =
  >
  ?
  @
  A
  B
  C
  D
  +rE
  F
  
(G
  H
  I
  J
  sK
  L
  M
  
N
  	O
  tP
  Q
  R
  uxS
  T
  U
  V
  W
  'X
  ,Y
  Z
  [
  \
  ]
  ^
  _
  $`
  a
  b
  c
  d
  e
  f
  g
  h
  i
  j
  k
  l
  m
  n
  o
  p
  q
  r
  s
  t
  u
  v
  
 w
  x
  y
  z
   {
  |
  }
  !~
  
  
  
  
  
  
  
  
  
  
  ~
  %
  "
  
  v#
  
  } 
  t
  q
  
  sonpu
  r6{
  -z+
  
  kwy4*
  
  ilh|jm
  
  x
  02
  
  
  
  3
  
  
  /
  `Y\>a
  A
  d@C\
  [W^
  ZY
  ]gcZbX_
  e
  
  
  
  
  
  
  
  
  
  &WS
  V
  Q
  N
  
  T
  R
  UGFL
  OP
  HDKM
  ECJ
  
  :
  A
  ?
  >
  B=B
  
  
  @;
  
  
  : 7#
  <6
  $
  */5fI'49
  
  82
  
  
  
  
  
  
  
  
  
  +
  -
  3p
  
  'i
  
  
  )
  
  
  
  
  "#*,$ 1%y
  
  
  
  &
  
  3.
  
  1
  
  
  
  /
  
  
  
  
s
  n
  
  
  
  r	
  
  
  
  
  
     q                	  
op 
      
  l                                       }!  "  ~#  z$  %  &  '  (  )  u*  yv+  ,  -  .  /  Yx|0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  mL  tM  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  0`  a  b  c  d  ~e  f  }g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                |  !          v  }  y  zru(w    tp{                      e          ha  c    ]    |                  WZ              YO        H              E`        B>A<            9            6  2TXKG  13    .@?_b0        +      8^                #    ,  g        f                              	      P    =C     D  J FI  Q  V  U  SR\"      	  [
  )-    $d


  !&             7%5/  4        N    *  lM(           !  "  #  $  %  &  '  (  ;:')  *  +  ,  i-  .  /  0  1  2  k3  4  5  6  7  8  9  :  ;  <  =  >  ?  j@  A  B  C  D  E  F  G  H  I  J  K  L  M  N  LmO  P  Q  R  S  T  U  V  jW  X  Y  kZ  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  op  q  nr  s  t  u  v  w  x  y  z  {  |  }  ~                  z|    {y~x              t    sq}w  r      ulo  jpkmnv                  h      c    e`]d\l  b^_f  Zi      g    [  q    o      STmQp    PU  YaWs  N    V      w    OD    RJ  C  HnBA  @Ex          ;  r      :8XI?u  7L    GM  4K  <  1t9=y0              /      *                                    (#+  ",'  $    z  %              5      	  
      6 
  .)&{>
  
  
  
  3
  
  
  2
  	
  F

  
  
  

  
  
  

  v
  
  
  
  
  
  x
  
  
  ~
  q
  s
  
  
  
   
  !
  "
  #
  $
  %
  &
  '
  (
  )
  *
  +
  ,
  -
  .
  /
  0
  1
  2
  3
  4
  5
  6
  7
  8
  9
  :
  ;
  <
  =
  >
  ?
  @
  A
  B
  C
  D
  E
  F
  G
  H
  I
  J
  K
   L
  M
  N
  O
  P
  Q
  R
  S
  T
  U
  V
  W
  !X
  Y
  Z
  [
  \
  ]
  ^
  _
  `
  a
  b
  c
  d
  e
  f
  g
  h
  i
  j
  k
  l
  m
  n
  o
  p
  q
  r
  s
  t
  u
  v
  w
  x
  y
  z
  {
  |
  }
  ~
  
  
  
  
  
  
  
  
  
  
  |
  
  
  
  
  v
  
  
  
  rw
  
  
  
   
  
  
  
  
  
  
  e
  l
  
  q
  
  g
  n}
  
  
  
  
  
  Z
  
  
  
  V
  
  \
  
  Q]~T
  {
  X
  y
  L
  YNxMPzOUW[K-kcf_
  
  Sd
  
  
  hG^Fp
  i
  jD
  HabECs
  
  
  
  
  
  
  
  
  
  
  
  
  I
  
  
  
  =
  
  7
  213
  
  
  
  4;-
  
  *.+
  )9mR60,(:
  B?
  
  
  &@
  
  
  #A'
  %
  
  !
   8$
  "t
  
  
  
  
  
  `
  
  
  5J
  
  o
  
  /<
  u>
  
  
  
  
  
  
  
  
  
  
  
  
                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  AG@  A  B  C  D  E  F  eG  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                {    y    w    u    s    q        ~m    n  |              hzg    c    bxa    _    ^v]    [    ZtY    W        VrU    Q      P  pO    JL  `dpj        TX\F    [              >            `          2        4  f5  ,[+  9\  7    k  %  .  3*6(#/-&  8)10"'              CGkl~xyrC;              fgh_`aZB                                           	             
  	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;   <  =  >  ?  @  A  B  C  
D  E  F  G  H  I  J  K  L  !M  N  O  P  Q   R  S  T  U  V  W  X  Y  Z  E[  D\  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~              S~      z        v          x{p        q      twoljm        ie  g    HM  R|dfaN                    Z          _  S              PT    L      n            j              C            3;      6  $l?.27@    -A    o    >                B  <    %          =(    "    c  $)K  b#I    Q  R&8  V'`    X  1W
M  !    + 
N  hEG	F                               	  
      
                    IU      [      Y         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  :B  9 C  D  E  F  G  H  I  J  K  L  M  N  O  P  5Q  R  S  T  U  4V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  0l  m  n  o  p  /q  r  s  t  u  v  w  x  y  z  {  |  }  ~          ~        {  }    xz        tvs      uq  r    om  ,  n*lk    }              f    c        ^          Y        s            j  ^OJ      rSVZ      KKHDkF            B_d      H[EG=  J  ?a      :8      >;  6      I<54    2    ]L1/\-  9    C  +,    '  A7*    .    (        0 #3$%)D  &"!@M  uiP  y  N  Q  O                                        
             `  \]  bywg   e  X  W
p  RUT	  	
      
                                  u       !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  im0  1  2  3  4  5  6  7  8  9  :  ;  h<  =  W>  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  wW  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  |g  h  i  j  k  l  m  n  vo  p  q  r  s  t  u  v  w  x  y  z  {  |  }  EB~            }    {  t  y  ~x  |w  zv              q    u        k      lo    hf              a  <  \    c]        W        X^    TQ  `[=        _N            IK  E  b  GH    s  ?  @CL      nr=;  :?  <M@  98    SJR5    P    O3    AY0ZU    V    .  -    +    )4  (  2$&  BF/*  6D"%S  p  !K  gI  e] :7AYt  R  m  Pi  M>d                |                  
  	
    =          1      ;            .  	  
      
                                  	  
     !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  408  9  :  ;  /8<  =  >  ?  @  A  <B  C  D  E  3F  :9G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                  |                  v          r  m  l  1  u  pw  /th)    'fx  eijn  %og"bs      `        ]      y      Y  V      Wqk_  TQ\[}SP^adcXUR      Z                                  >    C        =    {  4    A      ~  .  5;?    @1  +z2*  )-(    7  M  %3  8'  N  "$/  #  O,!                            U        e    H        
D            n   
   o              	  
      
        XV	                                 !  "  #  $  %  &  '  (  )  *  +  ,  6-  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  :O  P  Q  R  D<S  T  U  &V  9BW  X  Y  Z   0[  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                    {  }          x|t                                      e    d  i`  f]      j  g      Wh^      T_}        Z        M[U    IVR    GS                          iY  :  nq        5        <16m7  N4  8-092.;/                )            &  "'    (                                          =>?                         LHF    AB  	  
  QJ    
  K    @      P        C                     !  "  #  #$  %  
 &  '  (  	)  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  DD  E\aE  F  bG  H  I  
J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                      y          t  f            cm  wz      x      l  f  hdge    i  b`j  a          ]        X      WS                    L    Q      PE      C~  y      @  VODA  J  ;B=        N9>                    s            *  3    /        (12        k            o        p  Xq        !  ~    }        	G    
  |"'  $        lo      #  p   4  	  3O$*
      
                                         !  "  #  v$  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  ,5  6  7  8  9  :  );  <  =  &>  ?  @  {A  B  C  D  E  F  G  %H  I  J  K  uL  M  +rN  O  P  Q  R  S  T  U  50V  W  X  Y  Z  -[  \  ]  ^  _  `  a  b  c  d  .e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~        [      ~  !  z}|+   {8?zs          7v  RT      F    \Z      o    KI
j            6t    d  nHMca  kb  h  g^`  _]iceu    [sw      xru  Y  \ZW  m<  f  S:          N  X    Q  v  IMVO    T  ULER  rU          CY^Ak  @  >lF  ?n=B_    qD  G  9<p:  J7;8P                6            -  ,    )  2%'%1y(  0/$*  5&.3  ,                                                                                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                    b  Y  U  P  L                                        j  f  n  3*                                  ,              .      0              5                         	  
      
                                         !  "  #  7$  %  &  '  	(  )  *  +  ,  -  .   /  0  1  2  3  $4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  "F  G  H  I  J  9K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b   c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~              ;                                n    ka[udyp}hl          zDJHNTW`e    i  o    bmjdf  ql_g    p]  a\^        c        `XxWhTu[                  s    L            G    D  4P        >  +;?    CA#@B    =<"            v  2  ZrK    wY-  0tU    JVy/  +SI*    )3  5  (HM    .  4  1,#$N    "      8E                 O7                '    R%          F9             Q
  :            	  
    	6  
                                         !  !"  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  {^  _  `  Ca  b  c  d  e  f  g  h  i  j  k  l  |m  n  }o  ~p  q  r  ws  t  u  v  Hw  Kx  y  z  {  |  }  ~                                  u  t      n      w      x    {    j  id            ce|  ]                        Y      `      N        _G        EHB        D  !      %    \      ;      8    b  #  3    60    a    -        14      8      6      /    9+      :7}    -            ~        
  	                                   	  
      
               4                           !  "  #  $  %  2&  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  5W  X  Y  Z  
[  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                  ~          x            |  v      q      p    r            k`    _l^    a\  ][dzn    ob    mX{Wcy    }  ZTw  uYS VtU!                  g  h    IHG  JfF  L  EKD    #  e  i    j?>@A      ;CB<=
$    <    N  9    O4M  37  6,  128  5  /:=0    '  P  Q    R*)+
:  ,        .-  #$.&/%('(+    )    (      '        2&      @      ?      >      =    <  s"
  
          &        "1)%e    x  t\          	  
    X  R
    F    BO  SK  G	IA  ME  Q    V      Q      ^  _X    ]   ZP!  cr"  #  $  sRS%  &  gz'  (  ov)  *  T+  wq,  -  |U.  /  V0  {k~1  2  i3  4  W5  6  MJ7  m!8  9  K:  ;   L*<  =  >  ?  @  fA  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  gyU  V  zrW  sX  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  qvt  u  v  w  x  y  z  {  |  }  ~                    z      |w    uv  tx  }yrp    ~{s    ql      lop    n    jmi  mg  kf      d      c`  ka    ^\              X    WZ  R      SPY    VONU  TML]Q[    bhK_          He    Fho   BI              ?=@  J:A              5    7              26      91*,      +$>  (;'#&)3      % CI  -A"4OZ  ![  8^F>0                                                                           	  
  D    
	
    
                           C            !  "  #  $  %  &  '  (  )  GE*  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  <S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  @q  ?r  s  t  u  v  w  x  y  z  {  |  }  ~                  ~|  .  }/  yx    v  tz  ws{                  q        k  f    h          c_        \  dg^      X[  UZ      Y]`      OnW    SNVMTRi            K                 ?bJ    E>G=HDA  Lr<B  FI;C        pj7          el  24          :  3.  +    9,05        8(  &1mP  'Qa@o6$"  )          /    %#!       -*                              	                                  	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                    {                s  y  t  zpo              i    h  v    wq  c                  [  ]      W\T      ZS                K          F        @        u>                :  ?A  3;5                            &    
                                                        #'  
  "	  +$  %                     	  
      
                                         !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  )A  B  C  D  *E  F  G  
H  I  J  K  L  M  N  (O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  !&o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~              |}    z  ,    x    v    t9    q    o    m  r4y  pkw  nju  lis         g            a  d_{`b      \  e]  YZ^~[c                  S  X    f            I      NG  U          A  ?B        ;        DCH              7E3  .  0    +1R  -  8<2>  *)P@96,/'=(4FJ    :    hM5%  L#&K    $        Q                              W          OT  	  
  V
!                           	  
       
                                         !  "  #  $  %   &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  
b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  RYQx  y  z  {  |  }  ~                  }              y~t      |s          l              n  d      jm`  f        be[        _aX                  P        =  K  MQ    HLF  <JEqk  S  UN              A        >OI8  B-  ?7.  ;6T@<    {pC    4=8      z31  /  09  ,W      (      E
%  ')              "          D$&!  J  PI  O#*VY             Z\  ]  w              +    g                         	  	:
  /  5  N
                              2B    7    16   0!  CG"  HL#  $  M%  &  '  o(  )  *  +  ,  -  .  /  R0  1  2  3  4  D5  G6  27  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  ruZ  v
c[  ihx\  .]  -^  _  ^ 
~`  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  x|s  }t  u  v  w  x  y  z  {  |  }  ~                        y      x      }wt            _      k      X      `    o  c      d    a\U          V  ~  X  n    Sq    TWPUN    L      I  Q`Z  OKMG[]  HJF^^h    ElR  DCYVmr          As          <@    >  8pu;  B9?5{        3  =    :.        dfj  -    )ku*    n%  &            !$   (    '      ,      #+  "ba  mge  1l    |7  6  4  0      
    
                  	                        	   
   	      
                                                              !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   F0   1   2   3   4   5   6   7   8   9   :   ;   <   =   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   
O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                     G                        z         v      s                              k   E   h   f            jeb      i^               ~   ]w                  Q         P      }W            Y      JXG         m                     glB      ;            L               2               .            )            ,/            y                   &*   U   Tx   %      #         $         q      
rp+   o   ut
            "      	         -0 !   !  !  !  !  !  (!  !  !  '	!  
!  !  !  
!  !  !  !13!  !  !  !  !  !  !  !  !  !  !  !  !  !  !  !   !  !!  "!  #!  $!  %!  &!  '!  (!  )!  *!  +!  ,!  -!  O.!  /!  S0!  R7N@K51!  2!  3!  4!  5!  6!  67!  8!  >4=:9!  :!  ;!  <!  _=!  >!  ?!  @!  9A!  a8`B!  C!  D!  E!  F!  G!  H!  I!  <J!  K!  L!  M!  N!  O!  P!  Q!  R!  HS!  T!  U!  V!  W!  X!  Y!  Z!  [!  \!  ]!  ?^!  _!  `!  a!  b!  c!  Id!  [e!  f!  g!  h!  i!  j!  Zk!  Fl!  Cm!  EDMAnc|d\V{HKn!  o!  p!  q!  Ir!  s!  Lt!  Ju!  #'v!  sw!  {x!  y!  z!  {!  |!  }!  ~!  
|!  !  r,!  wq!  !  }v~1t!  |uy!  {z!  }!  !  y
!  !  w	zxv!  !  !  !  !  u!  !  r!  np!  d!  !  j!  !  !  o!  i!  fj!  e!  ld!  g!  !  b!  s!  `a_tqhcm!  ^!  k]!  Y!  !  O!  X\!  WX!  T!  MSW!  QVYPU[Z!  TU!  ZSN!  !  !  P!  !  !  !  !  !  !  !  L!  !  QGFI!  O!  HrRDM!  K!  !  !  !  !  !  !  >!  !  @!  ;?!  !  !  !  B6:9A57!  =<48!  !  !  !  1!  3/0!  2.!  !  J!  !  N*!  -C,!  +E!  !  !  !  !  !  !  "!  !  !  !  !  !  !  !  !  !  %!  !  !  !  ( #!  !  $!  !  '!)!  !  &
!  !  !  !  !  !  !  !  !  !  !  	!   "  "  
 "  "  "  "  "  "  "  	"  
"  "  "  
"  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "   "  !"  ""  #"  $"  %"  &"  '"  ("  )"  *"  +"  ,"  -"  ."  /"  0"  1"  2"  3"  4"  5"  6"  7"  8"  9"  :"  ;"  <"  ="  >"  ?"  @"  A"  B"  C"  D"  E"  F"  G"  H"  I"  J"  K"  L"  M"  N"  O"  P"  Q"  R"  S"  T"  U"  V"  W"  X"  Y"  Z"  ["  \"  ]"  ^"  _"  `"  a"  b"  c"  d"  e"  f"  g"  h"  i"  j"  k"  l"  m"  n"  o"  p"  q"  r"  s"  t"  u"  v"  w"  x"  y"  z"  {"  |"  }"  ~"  "  "  "  "  "  "  "  }|~{"  "  "  "  "  "  "  "  s"  x"  u"  z"  pvqytowr"  "  "  "  "  "  "  "  h"  n"  l"  j"  ekcgmfid"  "  "  "  "  "  "  "  \"  `"  "  ^"  bW[Ya]X_Z"  "  "  "  "  "  "  "  P"  T"  "  R"  VKOMUQLSN"  "  "  "  "  "  "  "  D"  H"  "  F"  J?CAIE@GB"  "  "  "  "  "  "  "  8"  <"  "  75="  :4>93;6"  "  "  "  "  "  "  "  2"  ."  0"  ,"  */'-)+(1"  "  "  "  "  "  "  "  "  $"   &"  ""  #!%"  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  "  	"  
"  "  "  
"  "   #  #  #  #  #  #  #  #  #  	#   
#  #  #  
#  #  #  #  #  #  #  #  #                         	 	  
        
 
 
    
 
     	                                                          ! !  " # # $ $ % % & & ' ' " ( ) ) " ' ( * + + , , - - . . / / * 0 1 1 * / 0 2 3 3 4 4 5 5 6 6 7 7 2 6 8 8 9 9 : : 7 9 ; ; < < : = > > 2 7 ? ? = : @ @ A A ? < B B @ C D D E E F F G G H H I I C H J J K K L L I K M M N N L O P P C I Q Q O L R R S S Q N T T R U V V W W X X Y Y U W Z Z [ [ \ \ ] ] X [ ^ ^ _ _ ` ` a a b b \ c d d e e f f g g c d h h i i j j k k e i l l m m n n o o j p q q r r s s t t p u v v w w x x p t y y u z { { u y z  | | } }   ~ ~ |   }   ~                                                             $   %  ) (   #   &                                                                                                                            z     {          | ~       }         r     s    t    y      v    q x  w                                                                                                                    		



	
  !!"##$$!%%&&""''((#)**++,,--)..//*) $##((00112233$.$34455.6//.5678899::7;<<42==;=>>??;> ?@<?@@ABBCCDDEEA0('DC0FGGHHIIJJKKFLMMNNOOHGPPLQRRLPQFSSQOTTIUVVWWXXYYUXZZ[[Y \\]] \^^__]`aa  `ba`ccb]`_cb^deeffgghhdijjdhkkllimnnilooppmqrrssmpqtuuvvwwtxyyzztwxy{{||}}z~{x~~|    		



	
VWUU  !!""#$$%%&&"#''(()) !**++#%$,,--)-..''*+((/00/1221133*+440P 5544D 5/O /3E 6F 36262G 7S 788J (99X9::;;Z<==  >><?@@AA<>? BB>CDD?BC EEFFBFGGCHCGIIJJKKHJLLMMNNKOPPA@QQORSSTTUUVVPORQWWXXRYZZ[[\\]]^^__Y^``aa_bccddeeffbZbf[ edgghh ciijjkkgillmmnnoojpNMqqrrsspqttuurL[;q:tXvvwwSwxxyyzzT{a`zy||}}{|~~}x|~  h konvW@&LIE DC   NH.9u,ps&UY.,     `]\PV=wzUcbZef{Yml  T 7M 8N   		





~  !""##$$!%!$&&''%())**++%'(),,--*.//0011.-.122+3445566"!773899::378%;;7<==8;<2>>;>??@@AA<0BBCC?CDDEE@FGG9=FAHHFIJJKK LLMMINOOIMPPQQNRSSNQTTUURVWWRUXXYYV5VY6GZZ[[\\]]:^__``aabbcc^bddeecaffggbghhdf\[iigijjhZkkllilmmjnooppqqrrnp_^ssttquvvtswwxxyyuxzz{{||}}y~~|{Kvru}~}}GFHDE:]45#6	(,0/B    		


	



&$  !!""#!#"#$$%$%&''.-&%(()))''(%&&*++,,--'&*,..-+.*+-.!#$"%/ 00/@/0A/ 012233441566775899::;;8<==57>>8;<?@@AA?BCCDD?AEEBF6=GGF<DDG9?:C7FCBHH>EHIJJGDKKLLMMIL11NNOOMPCFQQRRSSTTPSUUVV22TKPJWWGWQOURILXXYYPYZZTZ[[X[\]]JO\^\S^_^W__X]\Y^Z_[`aabbcc`3`c4deeffggdOdgUbhhNhheViiaifijkkllmmjnooppqqnrssttuumkrvvrwxxyyzzw{||}}{~~~{}bc^_|qp~pzzyyqjjoo|nkkn{  			



  !!""##$  %%&&$'!!((')**++,,)-..))//-011**$$023324..5566478844997:;;:<==>>??<@>>88AA@"32;:BBCC<?79-/10DD#DE==FFGGEHIIJJEECBHKLLKMJJNNOOMPQQMMRRPSQQTTUUSVWW
VXYYSSZZX[YY\\]][KWV^^__XZPRIHL`[]aa`b``_^
 ccddbeffgghhiijjekllmmnnooppkqmlrrssttqupovvuwxxuvwyejlkzzyuz{yz||{x}}|~{|~}srx~fy{mihnvwtqwgwxtscdijbl[>m`af\v{z(ut   sGCB	

	

a\TUONHI !! ""##_$%%&&''(())**#$^*)% &'
($%++,--,. .-//0110P223K443505'66377WV88*92Z9#::X:9:987326;;<<8;()<;<=5	=7>>
=>65>41=14/??@&@@?/0+@?,+,A.ABCCBLDDEEFFRACBEDF-.BDFE!AC!G$GHIIH"JJGIHJ" HGIJ

	KA7LLKM2NNMOPPOQRRQSTTSUOU
VVWW@KXXWFXY:ZZY<[[XV\\ZY[Y[\	\ZW]]?;^^__`U``_^]VU_NM^]LMLP`PNa
aRbbabROcacdeedececdfdfSfbgghfhhgThgQTQiiijjkjkkllmlmnoonnSmopp'q&%rrqssqrptt,+suut6vvww93xxyyz{{z|n|}~~}Kvv|~}{zyxw~x"#w-1/0s5turqp{zy}|lomjki^e_dhjsponw]KXE@>9H>H 
 	  		
	



  
  !!"""##$$%&&''((%())$%)'**++,,+"--..#//00/112233440566*5778997::88;;<<==9>??@@=<>A66BBCCADCB@?D<>7:8;
?DCA0EE4,,EE'FF5F1-32GG.HGFHG$H&IJJKKIIK+I,LLJ4MMNNOOLPQQPRQQ3-RR!STTNMUUSOTPUUTSVWWVXVWYYXZXY[[Z\]]^^Z[\_``aabb_`cc]\ddaceeff]_ggeh]fiihjjkkllmm\noognpqqrrssttpuvvwwontshhuxyyuixzmmrqzJyx _texaqpbzd{||{}~~}lO~|{v}~{wojkh^mrsVk[YW   		



  
!!"##$$%%"#&&''(($&))!''($%"" **)++,,--.//.0110233)*2.4455/56632/477886478180+-99:9,;;:<;0<9	
;<:=>>=?@@ ?@>=2?@=AA/ABBCCBCDEEFFGGDHEEDDIIJJKKLLMMNNOOPPQQRRHSTTUUVVSIDGWWXXYYIZXWUUZ[QQPP\\[]BB^^[\]POO__\`]_`ONNaa_b`abNMMLLccadbcdLKKeecfggdefKJJhheijjfhiYkkhJIkllmmin0`ngooppnqrrss10nnqpttuuvvqnpwxxyyzz{{||}}w~xxww~{z~~~xy++//6|{|ppwwEMEMQQHRog 	 									m				j										
			
						
	
						
																																	 									
				 	 				 			!	!	"	"	#	#		#		$	%	%	&	&	#	"	$	&	'	'		%	(	(	)	)	*	*	'	*		(	+	+	)	,	-	-	.	.	/	/	0	0	1	1	2	2	,	2	3	3	4	4	,	5	6	6	7	7	8	8	9	9	5	-	9	8	:	:	.	;	<	<	=	=	>	>	?	?	:	7	;	@	>	=	@	@	A	A	%	$	@	B	C	C	D	D	E	E	B	F	G	G	H	H	I	I	F	J	J	K	K	C	B	L	M	M	N	N	L	}L	I	O	O	P	P	M	L	F	E	Q	D	R	R	Q	S	S	G	C	T	T	U	U	V	V	W	W	X	X	Y	Y	Z	Z	D	[	I	H	\	\	[	U	]	]	^	^	V	S	^	]	\	X	_	_	Y	`	_	_	+	(	`	W	-	]	U	9	T	5	K	6	,	\	[	4	3	O	<	Z	Y	=	;	R	A	`	a	b	b	c	c	d	d	a	e	f	f	g	g	h	h	i	i	e	j	k	k	l	l	XZj	m	n	n	o	o	p	p	m	q	q	m	m	n	n	h	h	r	s	s	t	t	u	u	v	v	w	w	r	x	;	6	y	y	r	w	x	1	z	z	{	{	3	|	}	}	~	~			|		q	q	m	p									|				z	z	~	~					o	n											~	}						v						w	b	a	t	s					y			J	g																								N	M																																																					{			P																				q																					TTF				j			f					c			u	t			u	d		v					x	Q						 			f	e										i								t													u								!												/	?											"																				h		n													o					}							0		~	m																							|	p									
						l			Y																			a	d						k												j																					l																																				"&																		 
 
	
	 








 -99











	
	




	







	8









	





	8

























	


%!











 
 


!
!

"
#
#

!
$
$
"
"
$





!


$

#
	 
	
	

	
	
	
	
	%
%
	%
&
&
	&
'
'
	'
(
(
	(
E')
)
%
)
*
*
&
*
+
+
'
+
,
,
(
,
	)
	*
	+

,
-
.
.
/
/
0
0
1
1
-
2
3
3
-
1
2
4
.
-
5
5
4
6
7
7
4
5
6
3
8
8
5
8
9
9
6
:
;
;
t:
<
=
=
>
>
?
?
:
<
<
@
A
A
;
?
B
B
@
C
C
@
B
>
D
D
E
E
B
E
F
F
G
=
H
H
I
I
G
J
>
G
J
K
vuL
L
M
M
K
N
J
I
K
M
N
;
L
K
O
O
r/
sO
0
H
P
P
O
Q
2
P
Q
P
Q
J
R
R
D
R
S
S
F
S
T
T
A
U
U
L
C
V
V
U
W
W
V
X
U
V
Y
Y
X
W
Z
Z
Y
R
X
Y
S
Z
T
X
N
<3
2
4@8
9
.
=2/
4
>7
G[
[
\
\
V]
\
[
^
^
_
_
]
`
FSa
a
`
a
b
b
fe`
b
]
_
f\
a
[
`
e^
qc
c
JIrKKd
d
SFd
S^
e
e
f
f
_
eg
g
e
h
sTh
h
i
i
j
j
nj
k
k
l
l
jl
m
m
g
n
o
o
f
m
n
p
q
q
n
k
p
r
s
s
p
i
r
h
t
t
u
u
r
t
c
ou
ks
gq
fo
v
w
w
Jt
v
Tv
x
y
y
z
z
{
{
|
|
}
}
~
~
x








~




x







Rd


|
{



N

v
y




z


w

}






M











































x


y

















































































































  
 

  





 

























































































































































:



7B

^


+


A
E









	




-,
































  		





  !!"##!$$%%"&''"%(())&&)($ 
'#

**++
,
	,
---,+..

//*./0112233045566770348991087::86;;<<==>>??:@AABB=<@@CCDDAEAABB==>>??FFEGEFHHGIJJDCKKLLIMNNILM;OOPPQQKRMQRSTTUUVVWWSVXXYYZZV[\\]]^^__[^``aabb_cc[_b
deeffZY]\dghhdcgiigjkkllmmfejnooppjhnqniqqrrllkkjjppoonnqqssttuufutWSvvwwmmTvxxwxstvwuyzz{{||y}~~y|}~}Q[
Q}}Rookppkllra
`


]^98>JN   		



YX

U  T {!!""#$$"#%$#&&''%%' (())**++(,--*),..//001220/1/11334455../$55/66778839::
;;879<6.==<>><=:>?@@?9@?:7AAA22BB?ACC0CDDDB>BC6EFFGGHHE%=IJJKKLLIJ;	KIMMNN8MOOPPN&QQPOLQ4#4GOMHFLEI4RRSTTUUVVSWWXSVWXXYYZZTY1Y[TZRR[U,)V(W[\\-!\-+zR]]^^_``^_aabb2ccddeecfffgghh`iijjklljiklkgflih_mmi]nnoomPnohpd phpqrrssttqnqtou54rquOusvvdptwawxxxyyweyxcvwz{{bwzsz{r|}}~~|}|zy~

+./*; < B > 3 4 8 5 A =  
 















	
	






























































 
 
!
!
"
"
#
#

$




%
%
$
&
!
!
'
'
(
(
&
'
)
)
*
*
+
+
'
,
-
-
)
)
.
.
,
/
0
0
1
1
2
2
/
.
1
1
3
3
4
4
.
2
5
5
6
6
7
7
2

$
%
&
(
-
,
0
/
8
8
9
9
:
:
;
;
<
<
=
=
>
>
?
?
@
@
A
A

@
B
B
C
C
D
D
E
E
F
F
G
G
H
H
I
I






A
H
J
J
K
K
L
L
M
M
N
N
O
O
P
P
Q
Q
R
R
S
S


I
T
U
U
V
V
W
W
T
X
G
F
Y
Y
X
Z
[
[
\
\
]
]
Z
^
E
D
_
_
^
`
C
B
a
a
`
b
c
c
d
d
e
e
b
f
?
>
g
g
f
h
i
i
j
j
k
k
h
l
m
m
n
n
o
o
l
p
q
q
r
r
s
s
p
t
u
u
v
v
w
w
t
x
y
y
z
z
{
{
x
|
}
}
~
~


|

























=
<



Y
^
_
`
a
f
g










j
i
d
c
V
U
\
[
X
[
K
J
X






]
T
W
b
e
h
k














z
y
r
q
Z
q
M
L
Z







;
:
































~
}








n
m
v
u
O
N
p
s
x
{




































BA









Q
P
t
w
l
o


|





9
8
5
5
?




















R








G









 

H

S

























































 







~












































































































































  
		




  !!"##!"#$$	 %%&&"'(())**++,,'-%..',-/0011/22334556677489947::88
;;8:6
<==>>??<@AA=<BBCC@
DDEE9
CFF

@
A5986;CBO;EDFB9G>=HHIIJJKKLLGKMMNNOOPPQQRRLSTTUUVVWWXXSYZZSXYY[[\\\]]^WV__
^U``GRaa_a.bccddeeff('bQb6gghhii7jkkllmmnnooppqqihrrssjdttuusrvvwwexfwyyxvzzyz  {{

x|N
M
}}|~J
H
~Q|}~cL
K
P
O
I

dF
E
B
?
<
;
>
=
D
C
G
E:
Pt
l
w
ON
o
MJ|

IH

A






}~|FD























c
b
`






~

}



i
h
f
g
k
j
a
e
d
r
y
q
z
m
x
n
{
v
u
p
s
U
T
^
_
W
V
X
Y
[
Z
\
]







$

&
%
-
(
0
,
;/


i  : +
*
4
3
7
 qp#
"

		o	n	


m

lk




	
j
u

t
?G`  !""T!!Z#$$%%&&#''%$(())**#++(*,,,--..//001221344 35YW6677889943::;;5<==>>??<@AABB;:@C?>BAC:AC?<=1=@5DD[2EED]FFF/DGG\EHHGGFH/-IIJJ.,KKI^JK6)LLKLMM7NOO98PPNQ4OQRPMRM(+R#PN&%OQ'J
./0/SS/HTTS2UUT23"VVWWXXW	$&-XV.Y*)ZZY[\\]]^^[\__YZ

``]abbcc_[acdd+aeebXd^ff5Ber]gffZghhiigjjkkllmm1jlnnooppmipogqqrrsttsuonvvuwxxyyuuwz{{hyyzz||{|q}ttU2}}z~~rx~sT/wuv0ljk"&$#

{
`
     		

 


     !!""##$%%#"&&''$&(())**'(++,,--..)!&//00(011+2233445566577886499::;;<<5<==7>??@@>ABBCCDDEEAFGGAEHH@?FFIGIJ,1KKDCJ-LLMMNN.OPPQQRRNMSSOTUUVVWWOSTLXXYYSYZZT[\\WV]]^^[ __[^ `aabbccdd`   `d _dc\eff8=gghheijjehikjiballk lmnnooppqqrrmsttuumrspvvqswwtxyyzz{{||}}x~x}~
~
    	

	

	

	  !""##$$! !$"%%#% #&&&''&())()*%$++*,--*+..,/,./01122-/00
331(4423)#-40 5667758995
8::8;;<<==<>>??=@@AAABBB;CDDEEFFGGCFHHIIJJGIKKLLJM?>CGNNMJOONLPPO:MN9O6P7+QQRRSS.RTTUUVVWWSXYY@SXWZZX[\\]]^^__[E``[_HaZVbb]\acUTddceffcdgghheiehjji><;?=kllkk l ^BA_GH\DKa/Y@>DC	AB@E`HiZXf-U,VbJdNRgQ*jUIKmmnnooppqqqrrwrssutuuvvwwxxtyzz{{||}}y~y}~{|~srzuvw
yzqx{|{tpps\PQjVgh  ]   		





	noonnv  ! !	"""##!#$$$%%&&&m#%''p'(())(93)
**++*;:+),,2,+(--.88-.
 *=/0011bg/22/133c3144556635  667727889909::;;4; :k8f ,-.i<<==p=mx>>??~<?@@r@>ABBCCDDEEA<AEFFBGG

C>HHIIJJKK?GLMMIHNNLONO
JM
K

@NEDLCMOFPQQP QP RSS  RRS TT RPU

VVUWXXYYZZW[\\]]^^__``WZaa[\bbcc]d

b[eedfgghhiijjfkllmmnnkldoompqqrrsskttp_uuvv`vwwxxyyzz{{Xw||}}x}~~yz~V
sGrqpfj
Ui
aZgh[edtkpK
J
mno^]
bc_}|vu{zYX   		


	

  


 

 
m T
W
n c g Bf 
o k l h C 
 _ `  a 9
U Y 7
^   Z  V   b  ] I  K7         L P    !!"##$$%%" #" "% #!$
&&''
(

))(*)
++*'+(,,--
-&,* - ,  0   1 .  T+ $  % !   !    ! .//00112233. .3 455667788994 49 :10;;:6:;72<<! :<<5  ==/=;8=>??@@AA>BCCDDEEBB@?CD>AEFGGHHIIFJKKLLMMJHKJILGFMNOOPPQQNRSSTTUURTNQURPOSVWWXXYYVZ[[\\]]ZZXW[\VY]^__``aa^bccddeebd^aeb`_cfgghhiifjkkllmmjlgfmhkjinooppqqnrssttuurronsputqvwwxxyyvz{{||}}zx}|yzwv{~~~  p} ` D p|E  'C                          ,      s
      ?      B            i    X         s
       IC p  , C               o    ^         y
      Z `  ? @W   B            u    d         
         ?      B            {    j         
      b `  ? @[   B                p         
      ` /  @   P(  A                v         
         ?      B                |         
         ?      B                         
       D  D  ? D D  B                         
       D  ,  Q pE                           
      @UD D  ? XD `D  B                         
       D  D  ? D D  B                         
      @YD D  ? `D `D  B                         
       D P'E  @ `D .E  A                         
       D  D  ? D D  B                         
       D  D  ? D D  B                         
       D    D    LB                         
       D    D    LB                         
      @>D    ^D    B                         
        D     E  LB                         
        D     E  LB                         
      `  D   @@ D  B              
           
      ` e  @n d                          
      @lD cE  D dE                          
     X\aehj[^chkm]afjmp_chloq^chloq^bgjmp[_dhkmW[_cfiSUZ^ac  mljhea[pomjgc^rqomie`srpmjf`rqomie`pomkgc]mljgd_Zigec_[Vdb`]ZUP 45=EMT\cjpuwvsng56?GOW_gnv}zsk68@IQYbkt~zp68AIR[cmxs68AIRZcmxs67@HQYbku{q55>FNV^gox}tl33;CKRZahotwvrlf008?GNU[afjlkid_ng`skdzpgsisi{qgtldlf_d_Y 45=EMU\ckrx}}xqj67?GOW_fowwn78@IQYair}}r79AIQZbjt~s69AIQYair|{q68@HPW_gnv}}um56>FMU\ciotwwtnh33;CJQW^chlnnkhb108?FLSX]adeed`\qjbwne}rh~si{qhumenhbhb]`\W xz~~}}}}} {}|{yvq  ptx{|}}||||}}~~z|tvz}~~~}}|||}}}ikortuuuuuuuuuu_`ehjlmmmnnnmmlUW[^acdeeeeeeedLMQUWY[\]]]]\\[   GMQUWY[\]]]]\\[@DHKNPRSTTTTTSR;=ADG;IJKKLKK>K   ~~~|yt||}}|{wsutsqmilkjgd_db`]ZU[YWTPL  [YWTPLRPNKGCKIGD@<  pswyyyyxwvvvvvvz{~}{{zzz{|}|{{{|}tuy{{{zxwvvuuuuijnpqrrqqpooonn^`cfhiiiiihhggfUVZ]_`aabaaa`_^LMQTVXYYZZYYXWV   GMQTVXYYZZYYXWVADHKMOPQRRRQPON<>ADG;HIIJJIH<H   vwwvsn|}~~|w}~}xuuutqlnmljfbfec`]X^\ZWTPVTROKG  VTROKGNLIFC?HFC@=9  [^cfhkmn]]bfjlno__eilopr_`fjmpqs^`ejmoqr^^chknpq\[`ehkmnYW\`dgijTRW[_adeOQVZ]_bclkhec^Ynljgc^Zqomjfa]rqolhc^sqolhc_qpnkgb^omkhe`\kjhea\Xfeb_\WTec`^[WR  /4?IS[bgilsy~0/7BLU]diqx}108CNW_flt{019DOXagnv}.08CNW_flt{..6AKT\bhpv|.,2=FOV\aiouy{}|,(.7@HOUY_fkorss($(19AGLQU[`dfhg$!$+3:AFIMRW[]^^}wphed^VND:|unf`XPG<5xqhb[RH>6zrjc\SI?7xqhb[RH>6ztld^WOF<4}|{xsmf^YRJA81ssqnjd]WRLD<3-hgfc_YSOJD=5-(^^]ZVPKHC>70("56AJS[bhpw}68CMV^dlt{69DNW`fnv}59DNW_fmu|47AKT\ciry~34>GPW]ckrw{~~|0/9BJQW\cioruvus,*3;CIOSY_dhjkjh&$,4;AFIMSX[^^^\~ysle_XOF;1/}wohb[RH=21yrjd]TI?41yqid\SI>3/{umf`YPG<1.~|ytnga[TLC9..uspke^YTNF=4*+jhea[UQLF?7.&'^\YUOKHC>7/'!#   	
#%(*,-#&),/01	#'+/2578#',048;>?		!&+05:>BEG
$)/4:?DILN"',28>DJOTW$(-16;BIOV[^ %*.38<AFLT[ae!&+049=BGLQW^ej!',05:>BGLQV[`gl',16:?CGKPTY^bfj,16;?CGKORVZ^bef16;?CGKNQTX[^`ba6;@DHKNQSVXZ\]^\>;@DHKNQSVXZ\]^\C@EILOQSUVXYZZYWIFJMPRSUVVWWWVTRNKORTUVVVVUUTRPLTQTWXXXWVUTRPNKGZVZ[\[YXVTROMJFBb\_`_][XUROLIFB>eccca^[WSPLIEA=9fjheb^ZUQMIEA=84kmkfa\WRNIE@<83.nmkf_YSNIE@;72.)mjhc]UNID?;61-(#hcb^XRKD>940+'"b\[WSMF@:4.)%!ZSSPLGB<61+% NSSPLGB<61+% KKKHEA=82-(#IEEC@=84/*%!
,--00127789>>?@EEGGMLNOUTWX^[^`baegbejlhglnmfjlnefgkba`e^\Y^^\YTYWSNTRNIPLHCKGC>FB>9B>94=94184/03.),.)$'(#!"	
	
		#'*/48<@CE

"',16;?BEG %+05;@EIMO#(-39?EKPTW %).27<CJQW\_!&+/48=BGNU\bf%"',15:>CHMRX`fk*(-16:?CHMQW\ahm*-27;?DHLPUZ^cgk-27;@DHKOSW[_cef27<@DHKORUX[^aba7<AEHLNQTVXZ\]]\<AFILOQSUVXYZZYVAGKNPRTUVVWWWVTQGLPRTUVVVVUUSROLLQUWXXXWVUTRPMJGOLPRTUVVVVUUSROLUQUWXXXWVUTRPMJG[WZ[[[YWVTQOLIFBb]_`_]ZWUROLHEA=hcdca^ZVSOLHD@<8mjheb]YUPLHD@<73nmke`\WRMHD@;72-lmke^XRMHD?;62-(kjgb[TMHC>:51,'"hca]WPIB=84/+&!b\ZVQLE?93-)$ ZSROKFA;50*$QKJHE@<71,'"ICCA>:62-)$B<;:741-)% 
:5531/,($!7<;:741-)% 
25531/,($!1..-+)&# 
	DEEFEGGMMOOUTWX]\_`ebfgkfklmhmnmgklmefgkba`e]\Y]YVSVTQMPOLGJJGBEOLGBJGB=FB=8A=83<83.73.(2-(#-(#'"!	


	  
  
    
	                                                                                           	 
! 	!$! 	" 
 

  	                                          

  
 	! 
	!
!(*'%-/+"#+.*! $&#   	   	 
                      	 
   
 
	 
 !&% (-,& )/.'%*)#! 
 !   	                                       	   
 "   #" 
  	
  	      	                                                                         
 

"$!
!(*'
")+'$&#ýü¾{tmf`ZUQKE@:50~wpib\VPJD?94/{sle^XRLF@;50~vog`ZSMGA<61xqib[UNHB=72zrjc\UOIC=72{rkc\VOIC=82zrkc\VOIC=82yqjc\UOIC=72wpha[TNHB<71|umf`YSMGA;60yqkd]WQKE?:5/2-(#
	4/)$	50+% 
	61,&!
72,'"
72-'"82-("82-'"72,'"71,'"
60+&!
5/*% 	          	"          	#          	#          
#          	#          	"          
!                     
   ORSTTTTTS IJKKLKK>5ABCCCB"#89:::1/0111'(("
  	   
	                                                                        NPQRRRQPO HIIJJIH<5AABAA@!
#899990

01111	())# !!	 
  	
                                                                                "(         	$)         
%*         
 %+         
 %+         
 %*         
$)         	#(         
!&   	#()+05;@FK		$)/49?DJP
	
 %*05:@FKQ


!&+16;AGMS
"',17<BHNT"'-27=CIOU"(-28=CIOV"(-28=CIOV"'-27=CIOU
"',17<BHNT


!&+16;AGMS
	
 %*05:@FKQ	
!&*.39>DIONTZagnu{~JPV\bipw~KQX^dkrzMSY`gnu}NT[bipxOU\cjrzOV\ckrzOV\ckrzOU\cjrzNT[bipxMSY`gnu}KQX^dkrzLRY_flszüü  yqje^ULA7xqid]UKA6tmfaZRI?4nga\VNE;1e^ZUOH@6-[URMHA91(OKID?92*" )1<FOW^dlt)1;ENV]cls'/9CLT[`hp$,6?HOV[bj#(1:BJPTZb #,4<BHMQX%-4:@DGL  '/9BKSZ_gouz~)0;DMU\bjrx~)1<FOW^dlt{)1;ENV]clsz}ysle`YQH>4|vohc\TJ@6~yqje^ULA7~xqid]UKA6$%/8AIPUXXVQKB:0)%'1:CKSX[\YTME<2+%(2;DMTZ^^[VOF=3,$'1;DLTY]][VNF=3+#&/9BJQVYZWRLC:1)##,5>ELPSTQMG?7.'  (08?EILLJF@91)%#*18=ACCA>93+%"$*0489:851+%!   /8BLT\beefd_XPG=3/0;DNV^cef`ZRI@6.02<FPY`fhjd]UKA7003=GQZbhjme^VLB80.2<FPY`fhmd]UKA7/-0:CMU\adi`YQH?5-,,6?HOVZ\bZSLC;1+)(19AHNRSYQKE=5,'$"+3:@EHJOHC=6/'"&-49>ABG@<70)"  %#)/59=@AB?<72,&"+(/5<AFIPMHD>82+(1/6>EKQ`b^VOHA:2.75=ENVnvupg[RIA94<:CLVnxi[QH?9??HR]yveWMD>CCMXdp`SHAEFR_lzhZNFELXerpaTJJP]jwvfYONTan{»{j]RQVcq~ƶm`USXerѽoaWTXesԿpbXTWdq˺oaX RWdq˺oaWOUbo|ƿ~m_ULR^kwzj]RGNZfsufYOAIUamoaTJ=CNZfzh[OD;>HS^|q`TIA::CMVqxfYOE?76>GP`{xj]RI@:208@HP]opme[SJB:5-*29@GMU]ZTOHB:3/'$+17=BEIIFC>92,( #).37:<<;84/*$!   !'.38;=@>:61+$#'.5;@DINIC>82*#*/7>EKT`]XQIB;3*16?GO[oolf^TKC:16<FO_z||ysj`TJA7;BL_~uj]QG=?F\reWLABW}n^PDVwfVI~m\NsaRweUygWzgXygWygWvdUraR~}l\N?tveVI<Dt{m]PE9AKt|qdWMB6<FPr~{si\RH>17@IRmvwuph_TKB8+19BIPdigc\SKC;2%*29@FKXYUNHB;3+")07<@CHFA=82+#!',1578862.(#TLCB=3ZRI@6.]UKA70^VLB80]UKA7/YQH?5-SLC;1+KE=5,'C=6/'"<70)"MF>=8.RLC:1*UNE<2+VOF=3,UNE<2+QJB:0)KE>5-'D>80($<71*$!51+%!83.'!@;5.'#ME>7/*ZOG?61eZOF<6pdWLB;yl]QF?ufVJBo^ODvdUI{jYNn\Qp^Sq_Tp^T  p^Sm\Q{iYNudUI}n]OEteVKBwk]RG?ncWMC<dYOG=7XOG?61KE>7/+?;5.'#40+&!  <72,&"D>82+(OHA:2.[RIA94i[QH?9veWMD>p`SHAzhZNFpaTJvfYO{j]Rm`UoaWpbXoaX  oaW~m_Uzj]RufYOoaTJzh[ODq`TIAxfYOE?j]RI@:[SJB:5OHB:3/C>92,(84/*$!  0:DNW_eijov|01<GPY`fmu{13>IS[cipx~04?JT]djry/3>IS[cipx~.1;FOX_elsy~--8AKSZ_elrwz|}|*)2<DLRW\cimqssr&$,5=DJORX^beghg"!'/7>CHKOUY\^^^ztlfeaZRI?6~yric\TKB76|ule_VMC97}vnf`XND96|ule_VMC95}wpha[SJA64}|yupib\VNF=33srplg`YUOH@7./hgea\VPLGA91(*^^[XSMIFA;4,$%19CMU]cho3;EOX`fks4<GQZahmu3<FPYagmt1:DNV^diq06@IRY_cj,2;DLRX\b',5=DKPSW!&.5<BGJM   ov{~|xrkc\VOsy~{unf_YRu|}xpha[St{}wpg`ZSOG>4*RI@6+SJA7,SJ@6,wpg`ZSJ@6,sld]WPH>4*mf^YSLD;1'e^WRMF>6-$[TNKE?80' OIFB=71)!55431.*'&%$$#"!87642/,(&&%$#"!<;:863/+*)('&%$?>><962.-,+*)(&BA@?<840/.-,*)(CCB@>:620/.-+*)DDCA>;721/.-+*)DDCA>;620/.,+)(CBA@=951/-,+)('@@?=;73/,+*)'&$==<:851-)('&$#":98741.*&$#"! =AEIKHC?:62.*&%>CISXMFA<73.*&%>DKXlPGA<73/*&%=BHMPKE@;72.*&$;?CFGEA=951-)%$9<?AA@=:730,($$68:<<;9741-*&"#246777531.+'$!!.0233210-+(%"   "&)-1469;===;! !%)-047:=>>=;$##'+.26:>ACDB?&%%(,048=AEIKHC:741.+($";962.+'##?<840-)%$C?:62.*&$
         !        $(*/6=DJQ,                                    89 :: :: 99 88 55 22 .. **  9   :   :   9   8   5   2   .   *                   &(*-39?GP                                   {y{|uoic]WRNIC>83.xrke_YSMHB=82-}vohb[UOJD?94/zrkd^WQKF@:50}unf`YSMGA<611,'"
	2-($	4/*% 
	50+&!
61,'!
  GB=72-)%!
ID>94/*% 		KE@;60+&"
	MGA<72,'#	NHC=82-(#
 ysmgayslf`~wpjc{tmf  wohd^ZUf`ZTjc]Wmf_YohaZXRMJDZTOID]WQKE_YSMGaZTNH   x{}{   %%).26:>BFIHD@<%&*.37;@FLSPIC>%&*/37<AGPjYKD>%&*.37;@FLSPIC>$%).26:>BFIHD@<$$(,048;>ABB@=9##'*.158:<==;96!!%(+/246888753 "&),.0234431/#&)+.0123321/  #&*.158::<>>><96##'+/269;=>>=:74$$(,048;>ABB@=96$%).26:>BFIHD@<8%&*.37;@FLSPIC>951.*&" !!"#$$%&'740-)%! !"#$%&&(962.*&#"$%&'(()+<840+'$%&'()*+,.>950,(%&()*+,./0'+/133567&(,/24677)+/2589::,.259;=>=/048;>@A@   %&'()*+,.259;=>>&()*+,./048;>@AA')*+,./016:=@BCC()*+-./126;>ACDD'(*+,./026;>ACDD&'(*+-./16:=@BCC$%&()+,-/48;>@AA!"$%&()*-259;=>>!"#$%'*/2589:; !"$%')-046899                                         !	!$
"	


 
  	                                
    
  	   
   	!%$)#(!
  
!%$!$)("  !(#('!  "+!!(!
	
                                                         ! !$! "  
   
  	                                        




	

 		  

   

                    	           		
	

                                        	   
   
 "   #" 
  	  	                                                                               	

	
#,  !/#!  &(%,!  !')&##%"
		
		!(%)&%"

    
                               	" #" 
                                                     R           R  ҿLԾGԾ6<?ӿ-.--gϼ#"!ɹ:  R  R     #"!ɹ     :    
 RC                                 8           ɹ R~  $fz    =y               8      q	S"û|û
J
	J
g 
:aaa_]ZVRN  		   	

	    	

	    



  

   q 9ۡ8ľȿ¹ûRNI$	        
   R y|{vy|{vnnpolfcedb^Z[[YVRSRQNJKKIGEEEDB EKRZcmv~{rh_DEMT]foy}tjaXEFNV_hs~yncZEGOW`jv|pe[ZRKIG@aXPIB<cZRJC<e[SKD=yncZRJC<|pe[SKD={od[RKC= EFNV_hs~EGOW`jvEGNV`ju  #'!%)!%*.#'+/2$!&*/36:*',15:>A/-27<@DH427<AFJN47<AFKOS7<AFKOSV;@EJNRVY?DIMQUX[CHLPTWZ\IOQSVY[\PVWXXZ[\W]^]\Z[[[VWXXZ[\c]^]\Z[[kedc`\ZYumkhc^YWwsmf_YT{qg_XQrg^UN~odZRIuh]ULDtk`VME>rhbZQG>6g_ZSKC:1^VRLE=5-UNJE>70)MFB=81*&E>:61+%"c~x   {q~ti  h}   {q~ti  \SGbXNk_SrdWxhZyiZufYobUg\Q^UK  qqrstsqnh`Xvwyz|}|yri_{}uh~o~p|zlxz|~yoctuvwyyxtne\wwwvvuwxwtp~{{{|}~~~xxxxxxz{zwz#
    %     	*$   -' 
   0)"
   
0)"
   
/(!
   ,%	   '"
    
$    
"'*-.-,)% "'+.//-)% !&,15663.)##*06:<<83-& %+29>A@<6/(!%,3:?BA<6/("$+18<?>:5.'!"(.38:961+%$*.1320,'"
!&*,.-+(#


 %),--"'+.//'/7?EJL $/;FQ[bf!$0<HS]ei"#/:FR\dg!!,7CNX_b(3=GPWZ
#-6?GMP


(09@EI.-*'"
//-)% JLKIFB>:

bfhgeb_\eiiheb^[dghfc_\X_bca^[XTWZ[ZXURN
MPRRPNKHEIJKIHEB                                                                                                                                    
   	 	     	                                                '"  &!  $   #  "  !            	

	      <?ACEFFFFEDB@>; =@BDEFFEDCA><: ADGIJKKJIHEC@?  $JMOQRRRPNLIED  QTVXYZYWUROKG7N[^`aaa_\YUQ8NTB Iehiihfc`[ =P\_bccba^[VR *, 24444310-                 }[Z m/ g^/ |u\\]/ qPA..  M     SL2ŭL]TFrXŭxA?S?l\\^^WEA<62d^``_EA;62kfhigWD>95pmopndGA;6truutqRB<7vvxywugB<7xx}{zwtM;6xz~xuY:5xz~vs73xysR1vv~{.ss{onwkirzfdlu}`]fnv~]dlu}L]fnv~HP_gow~K?Yahnu|uy{zuprsroommlj KRy~|INuy{zvGKqrsrr   6=ELT{:<CKRy~}:;BHNuy{zy  #)/6=DL$*07>EM$*06=EL *07>EMUz.06=ELT{./6<CKRy~~  
"	
!$'!%)-
!%*.2$).37	"'-27<
%*06<A
!',39?F
"(.5;BI#)/6=DL  $*07>EM"%'()*+'*,./02-035678269;=>?7<?BDEG<AFILMQAGLPS[^FLR\mlgIPjtvvqLSv{~~zMUzLT{                                                            	


      
     	    

   
!"#  
"%'() 	
!$'*,./        



"#$"()*(./0.%      M&    N7:: S9: T: R NIED2     IP_FEE  _hi`EEC  fiih^CC  ehhgdXB  ceec`\Q `bb`]YSC
 ~zoed]@~ui]USy\QLkID=>==<+
VDA><IF3LbyjYU4]\||zwrml~}{wqlk~zupii, )42/+;9,<XVROw99}}{y9n}|xx                                                           

	      	
      	

      		                                                   

     
     
     $&%"    $),+'!    
&,.-)#    
%+-,("    "')(%     
!#"           
                                        "
         '!	         )#
         ("
         %	                  	          
                                                                   %(-28=CIO$).49?EKQ %*05;AFLS!&+16<BHNT
!',17=CIOU
"',28=CIPV
"'-28>DJPW
"'-28>CJPV
"',27=CIOV
!&,17<BHNU &+06;AGMS%*/5:@FLRLRX^dkqx|KQW]cjqx~LSY_fmt|NT[bhpwOU\cjryPV]dks{PW]dls|PV]dls{OV]dkrzNU[biqxMSZagnv}LRX^elszUVWXVVVV
VVUT
VUSQ62.*%<VSQNKHEA<7UQNKGD@<76SOKGC?;724PLGC?;62-/LGC?:61-(*GC>950,'"%+RTUVWXFUVVVVVWWWVVUTZYXVUSQ62][XVSQNKH_[XUQNKGD  AA@=#+RTUVWXEAA?=FUVVVVVNGGMVWWWVVUTYRXZZZYXVUSQ6_[^_^][XVSQNKabddb_[XUQNKGekjhd`[WSOKGCmqoje_ZUPLGC?rtqkc]WQLGC?:sqoiaXRMGC>95  #+RTUVWX=FUVVVVVVWWWVVUTZZYXVUSQ62^][XVSQNKHb_[XUQNKGDd`[WSOKGC?e_ZUPLGC?;c]WQLGC?:6aXRMGC>95072.)%2.*%!-)%!(%!# 

		  59>49>48=   ;0/83/50,     %KKKNQSUWW    7KKKNQSTWWW   5HJKMQTVWWXW  "EFHLPTWXYXWV  "DFJORVXYZXUT  "CGLPSVXYXWSP  /CHLPSUVWVTQL
+>DHLOQSTTSPMH@    WSNN WTPNK$VTPKGETQNIEEPNJFA@LIFB=8HDA=95 ERTVXZ+RTUVWX,FUVVVVV  9>D9>C  OQSTTSPMHDMOPQPNLHC>A;:A;6=8395050, 49>C38=B27<@/49=,159),14%',/$#&)#"!"""61,(2.)'.*%&>DHLOQ>CGJMO=AEHJL:?BEGH7;>ABC37:<=>.25678),.011#%()** !"#" HDA=95C>;850>8630,820-*'2,*(%"+&$" % 



	     !	 
	  TXWTPKQSROLGPNMKHD  &+/259?CGJLM6+%)-039?DHKMNO2#'*-28>CGKNOQQ  '# %! 	#
 $'*  GKNOPQGLOQRXMRVYZ^RX\_`bTZ_cccTZ_cccRX\_`cMTX[[^;?ACDH@DGIJQFKORS[LRX\]fQYafhqV_hpsy[cmwz|^fnwz|`flqsy_cgiiq]_ab_fZ[\[X\WWVTQUTSQOKN66778;=>>=;852/78889<>??><9520;<=>>AEGGEA=952>@ABCGMRRMGA<74@ACDFKVjjVKD>85@ACDFKVjjVKD>85>@ABCGMRRMGA<74;=>?@CGIIGC>:63!',15:@EI &,17=BGL#)/5;AGMR$*17>DKRX%+28?FMTZ%,28?FMTZ$05:>DKRX)48<@DHMT$36:>AD6;  
 
#
$
%
%
$
)


!"'$(-# %).2'%*/37(+/48<+/49=A/49=AE49>BEH9>BFIL>CGJMOCHLOQR66531/,(&"876530-*&"
=<:9741.*% @?=<9740,'"B@?=;851-)#B@?=;851-)#@?=<9740,'"=<;:852.*&!$(,/12456$(,/24578',/368:;<*.258;=>@+/37:<>@A+/37:<>@A*.258;=>@',/368:;=%)-0357
   >>=;97776?@?=:8887FGFC?>==<PSPJDBA@?^q^PHECB@^q^PHECB@PSPJDBA@?FGFC?>==<AAA?<::11    
  	  	
"
!#($').#"%*-/4.'*+,/358/366547:95?AA@<<>;@IKKJFAB?KSUUSNIECT[]]ZVPKF]ceda]VPKdjkjgc\UPkppomhaZUojkjgc\UWvppomhaZ\|wtsqle^`}yvtpicf}xusoim{wuwsz|xx{wwr~xssvqmysomkdizsnjgc\`yqmiea\UXqkgc_ZUNQjda]YTNHKc]YVRMGAD[TRNKF@:>+*)('%"  !#%%0++*)'$"!"$&(7210/-*'#"#$&')*>98752/,(&'((*+,E@?><951-)**++,-MGGEB?:61-,,,--.UOOMIE@;50.-----]XWTPKE?93/.----^`_[VPIC<60.-,++agfb\UMF?81-,+*)hlkf_XOH@92,*)'&lnlhaYQIA93,(&$#nnnjd]UJ@92,&"!nnnkf_WK?81+%mllje`YJ<6/)$jhihd_ZD93-'"illje`YJ<6/)$fhihd_ZD93-'"eefec_Z;50*% dbdcb^Z72-(#$       A\`ba_Z&(*/6=DJQX]`ba^Y)*,/5<CJPW\_a`]X+,./4;AHNTY\]\ZU,-.028?EKPTWXXUQ-.//16;AFKOQRQOL--../27<AEHJKKIF-----.37<?BDDDB@+++***.269;===<:*)(''&)-03567653'&%$#"$(*-/000/-$#! "%'()**)'!!"#$##!
	
		




			]WQJD@93-^YSLE>81,]XRKE>71,ZUPIC<6/*UQLF@:4.)OLGB=71+'IFB>93.)$B@<84/*%!<:73/+&"531.*&"/-+(%")'%# #! 
	
	

	    	
	                                                                                                                                                             	befec_Z;abdcb^ZY@`bba^[Y  

Occb^  
`bba^	
"^`a`^!$(]_``_!%)-\_`a`b^ZYa^[Z`^[[`_\[a`]\                       


   ""  ""  "!!## "##!"##!"##!"##!"#"!  "#"!!!"##! "&''&%#',--,+)-23332/39:::86  	
 
 
 ! 	 "#!	  
!"!	  	 
     	

              	       	       	     
    
          MGA<72,'#
NHC=82-(#OIC>83.)$PJD>94.)$PJD>94.)$PJD>94.)$OIC>83.)$
NHC=82-(#
MGA<72,'#
KE@;60+&"
	ID>94/*% 		GB<72-)$
E?:50,'"D=83.*% 
D;51,(#
D:2.*%! D;51,(#
 D:2.*%! B90+'#
	 @6-($   <3*%!
	  8/'"   2*#   ,$
	    %
                        
        
                                                                                                                                   
   
		   %".,)&%%$%&'''%%'0.,----012220/00024557:<===;99469<=>ADFGGGFCC8=@BDFKNPQQPOMK>BFIJOSVYZZYXVTCHLOQW[_abbb`^\GLPTW]bfhjjigecKPTX]cimoppomjhMRX\ainruvutrnmPUZ_emswzzzxuqqRX\ainruvutrnmZ_emswzzzxuqq 0agov{}~|zvts 3ehpw|}zvut 3fhow|~~|xvts hlosx{zxvtrp  opqtvvttrpm          
         "$   #')" '''''),/&0110/./249:;:97458CDDCB@=:9KLMLKIFA;TUUUTQNIB\\]\[YUQJccdcb_\WQhiiigda[Vmnmlkhd^[qqpomjea]mnmlkhdGqqpomjL srqpmP  trqom6  sqomm6  pnmmm6  mQ      !%)-\_`a`]^ %).2\_aba_`#(-2G[_bdcbc&,16I[`dffef).4:K[aehihj+17>L[agjlkl,39@MYaglnmm-4;BLW_flnnm.4;BKS[cimmm.4;BJQZagklm/39@HOV]cfgj037>DKRX\__e125:@FLQUWW]),27=BGLOQQU!		
 %#(

!&,#).%+1!&,3!'-4"'.4!(.4#,/3,.03-.012
./01,/00$72333221/,($./01=9:::8630,+/00$E@ABA?<95211*LGIIHFC?;62,'!SNQQPNJE@:5/*$ZVYZXUPKE>82,&!`]ab`\VPIB;5.(#dcghfb[TLD=60*$egkmje^VNF>71*$fglnkf_VNF?81+$fejkid]UME>70*%c`dec_YRJC=82-(#]Z]^\YSMHC?:51,&WRUUTQNKHD@<83/*PKMMLLKJGDA>:62-HCEFGHIHFDB?<850EKMMLLKJGDA>:62-=CEFGHIHFDB?<8507<>@CEFFEDC@>;73058<@BDDDDCB?=:6,059<?ACDDCCA?=9(,169=?ACDDDCA?<).27:=@BCDEEDB@
%+/48;>ACEFGGEC"',159<@CEGIIIH$).26;>BEHKLMO %*/48=AEILPTW"',16;@DJPV[_
#(.38?FMU\bf  &,29@HOX_fk01$!#$$$%(#,&!/*%!2-(%50,(2-(*50,-73/0:624=957?<9;B@<>ECA>IHGBMOOITWXQ[_`Zbfgafklh
         

        
                                         	
                   !!
     "#!
    "" 
        
                              
%         "                                    
           {tmf_YwohaZĽyqib\Ĺzrjc\_YSMGaZTNHb\UOIc\VPJĽĹƻĹĽ{~z{zxu{}zroty}~}|ylinruxz{|{zyz{zxgcgknprsssrtvxxwa^adgikklklprtvv[X[^`bcdddgjnpstVRUXZ[]]]]aehlnpSX[^`bcdddgjnpstNRUXZ[]]]]aehlnpHMPRTUVWWWZ^bfikCHJLNOPQQPSX[_bd>BEFHIJJKJLPTWY[9=?ABCDEEEEHKNPR48:<=>????>@CEGH0356889::998:<=>/.01234444432234-)+,-./////.-,+*(%&'()****))('&$# !"#$%%%%$$#"!     




	




							yqib\UOIzrjc\VPJ{rkd]VPJzrjc\VPJyqib\UOIwohaZTNH{tmf_YSMG~wpjc]WQKEzuohaZTOID}zupjc[TLGB|yuqkd]ULE?zxuqlf^VMD=xwurmf_VND;vvurmg_VMD:stsqlf^ULB9nppnjc[RI@6stsqlf^ULB9nppnjc[RI@6ikkje_WOE<3bddb_YRIA8/Y[[ZVQJC;2*PRRPMHB;4,$GHHFC?:3-%=>=<951+%3432/,'"+*)(%"&$#!! 
	



	  



	  
	           
	                                                                                                                                          	
	

	
 !"!!#" ! 

	

		                458:<==?ACEFHIJL758;=>>@CEGHIKLM;9=ADEFHJKLMNPQR>=BGKNOQQQRRSTUW@@FMTY[ZXWVVVWXZBBJS_kmf_[YXYYZ\BDLVgnc][ZZZ[]BCKUdwyka\ZYYZ[]AAHPYac`\YXWXXZ[?>DJOSTUUTTTUVWX<;?DGIJLNNOPQRSU97;>@BBDGHJKLMNPKLMNOLMOPQQRTVWUWX[]XZ\^aZ\^ad[]_be[]_beZ[]`cWXZ]_SUVXZNPQST/////0001312111215<:;;:877;DCDDCB?<AMLMNMLIDKTTVWXWUOW\\^acec\ebcfiouwlrehkpxtilot|ylnqtx~yznopqsvwrtnnnnqrqmommlmoomjkkjjkllkhihfgiiihefjjjkllkheffgiiihebabdefedb_^^`aba`^_XY[\]\[Z\STUVWWVTX  -               8              1
            *
            "             
                            
                                                                               "',158    
$).37:   !&+059=   "(-27<?   
#(.38=A   
#).38=A   
#(-38<@   "',16;>    %*/48<    	#(-158    
 %)-14    
"&*-07:=>??7:=?@A9=@BCD<?CEFG=ADFGH=ADGHH<@CFGG;>BDEF8<?ABC58;=>?14799;-0245694/*% 	<72,'"
	A;5/*$	
E?82,& 
HB;4.("
KC<6/)#
LD=60)#
KD=6/)#JC<5/("
	

G@:3-'!	C=71+% 
	>93.(#	


	
	


! "#$&'(+28?G#  !"$%&()-3:AI(%$%&'()*,.39AI.*()**+,-./28?F3/,,,---./016=C840///..//0139?=83110//////15;B<63210/.....16F@9420/.-,,++-1JB<520.-+*)('(,LD=61.,+)(&%$$'ME=60,*(&$#!"PD=6/*'$#!SB<5.(#!U@93-'!V<60+%
U@93-'!V<60+%
W83-("		
X50+& 
KT^gpuuqlbYPG?8IR[entuqj`VME>6IQZclqsoh_UME=6FNV_fklib[RJC<5CJQX^bb`[UNG@93?EKQUXYWSNIB<60;@EJMOPNKGC>83-6;?BEGGFDA=84/*159<>???=:73/+&,0357888641.*&"'*-/01110.,)&""%')*+++*(&$! "#$%%%$#! 





	
	50.60.60-5/,3-*0+'-(%*%"&""" 
	
 

 	                                                                                                                                    	         	 
 #               +               &                                                           
                                                                                           $+/49@F9 !*.147<1  +-0358,   ./246! 2246	889$>=.'%$"$A82221/,(.?>=>>=;840GHIJJHFC?6QTTUTSQNI@\_^^^]ZWSKfihggec`\Torqpnmjgc]wzyxvtqnkd~{yvrl{zyxvtqnkp~{yvrw}z}{x}}yvspvrqssqoligmcbeedca_`eUTWXXWWXX^HGJKLNOPPV!#&(#&)+!"'+.13($).269;.+16:>@C527=AEHJ>8>DHLOQGBFKOSVWIMRUXZ\^NX]acdccYcinppmjdnv{}|xrozzzzzr~{vpi~}xslg`{}xsmf^WyxsngaYQxsnhb[TLsmhb\UNFlfa[UOHAe^YTNHA;]VQLGA;4UMID?94-LD@<72,&431.+(#:530,(#@;951,'!"HB?:5/*$'SIE@93.*.bUME>:515tdXMFA<7;ueXNGB>@qbVMHDAwi]TMIDxlbYRNI}vnf^VRN|wtnhaZVRvrqnid]ZVpmnlie`]Zlijjhfb`^imnlie`]_eijjhfb`b`dgggecbeZ_bdddbdf%Z]_aaaefSWZ\]`ee.LQTWY^cc1EIMQU[a_+<AEJPW\]%38<CJPU[*/5<CIMT!'.5;@EL!',29>D '-39>
#).39$)-3
000/!$110/.,&,311221.37567755;;8;>>==F6<@DEHIP39EINRTQ7?HQX]_W?GOYahkcIRW`jrwnT\ahr{z^fjoxgosw|pwz}tosw||wz}~~y|xrxrl}rkjwleh|od^b~rf]W[vof\UPTrfbZRMHLcWTNHE@ETIGB@<8=&*/3579:)+047:<=138<@CEG8;@DHLOQ@BHLQTX[HJOTX\`dORW[`dhmWY^bfjot\aeilptycilnqtx|kprsuvy}w{yxwxy{}xwwxzvts|tpn|skh|tpn|skhzpgavlcZypg^T{|xrjaXOqspjcZRIhifa[SJAb`]XRJB9]XSOIA90VRLE?80'OKE>6.&HC>70'@;70) 
83/)"/+'!
	                                                                                                                                 			   			

	







                          
        
                                 
           
           
        	    	    	    
        
	               
                                             	                  :32332130.*(%-./A99::9752.+,./*H@@AA@>;7300-%OGGHHGEA=84/)$UNOPPOLGC=82-'"[UVXXVRMHB<60*$`[]__]XSLF?82,& a_beeb]WPHA:4-'!aaeiie`YRJC;5.("abfiifaZRJC<5.("badggd_XQIB;4.("a]_bb_[UNG@:5/*%^XY[[YUPJEA<73.)YRRTTROLIEB>:51,RKKLLKJIHEB?<84/LDCEEFGGFEC@=:62?GKLLKJIHEB?<84/9@CEEFGGFEC@=:6229<>@CEEEDCA?<95,369=@BCDDCB@>;8(-159=?ABCCBA@=;(-26:=?ABCCCB@>*/37:=@BCDDDCA &+048;>ACDEFED#(-169=@CEGHHG%*.37;?BEHJKM!&+059=BEILQT	#(-27<@EKQW[$)/4:AHOV\a "(.4;BJQY`e./'*
"$& '!("("("*% .)$1,'"4/+&62.)4/+(62.+951.;842=;75@>:8CA><EDA?HGGEKMNLQTVTW[]\\acb`ehg
!	 %"(%+
!'-"(.#)/#)0#*/(,/
',.0&-./1%-./'$%./*   "&*D]_``^\!&+/F\_aa`] %*/4H\`bcb`"(-38J\`cedb%+06<V\aegge'-39@U\bfiig(.5<BSZafjki)/6=DPX_eijh)06=EMU\cgji*/6=DLS[afhg,/5<BJQW]bdc.039@FMSX\]]/126<BHMRUVV'-.49?DILOPPƾƾ{{vy~|vprw|~|zqjlqtxz|}}|zyzzykefjmprtuutsuvwwe_`dfiklmmlmprtt[bfjmprtuutsuvwwU\`dfiklmmlmprttPVZ]`bdeffehknpqKQTWZ[]^__^aehkmFKOQSUVWXXX[_begAFILMOPQQQQTX[^`<ADFHIJKKKKLPTVX9<?@BCDEEEEEHKNO999;=>??@@??@BDF9446789::::989;<4//1234455443222/**,-.//////.-,*+%%'())****))('%&! "#$$%%%%$$#" !        

		

						zrkd^WQKF@:50}unf`YSMGA<61wohaZTNHB<71yqib[TNHB=72yqib[UNHC=72yqib[TNHB=72wohaZTNHB<71}unf`YSMGA<61zrkd^WQKF@:50}vohb[UOJD?94/yslf_YSMHB=82-|xsmg_XQKE@;61,|zwsnhaYQIC>94/*zyvsnibZRI@;62-(wwusoibZRI@84/+&tttrnibZQH?61-($wwusoibZRI@84/+&tttrnibZQH?61-($pqrpmhaYPF=4.*%!kmnmje^VMD:1+'#eghhe`ZRI@7.($ ^`aa^ZTLD;3*%!VXYXVRLE>6-&!NOPOMID>7/'!DFFEC@;5/(";<<;962-'!
2221/,)$ 
	,*)(&# 
	'%$" 	"  
  
   
  
   
     
       
	                    50+&!
61,'!71,'"72-'"72-("72-'"71,'"61,'!
50+&!
4/*% 
	2-($	1,'"/*%!	-(#
+&!($	+&!($	%! #
    
	  
       	    
	     
	      	                                                                                                         		 

 

    

   		       	

	       
       
              
      	          	                                        	

	
	          ! !  !!!!$&&&&%"#),--,+()023321./69::974  ,abb`  >`aa_ 
 ?^``_	
"%A]_`_"&*D]_`` `\X_\X_]Y_]Z`^\ )))('%"-++)(&#3110.+(:88641.A?>=:73HGFDA=8PNMKGB=XVURMHB\]\XSMFbdb]WQJghfa[SLijgc\UMijie_XPikjfaZShiifb\Ufggea\Vgiifb\Ueggea\Vcdec`\Wabcb`\XO`aa_\X /*% 1,'"4/)$ 71,&#"""""!!! :3-(&%%&&'(()'#;5/)'''(*+./0.(!<5/*((()+-0341+#<5/)((()+-/130*";4.('&''(*+,-+& 93-'$$$$$%%$%$ 60+%!   3-(#
           #
  (!	  +#
  *"	  & 	     	   
     	!%  
#' 
"&* $(, 
!&*. "'+0 	"',0 	"',0 
"&+/  %)- #'+  	 $(GFDB@=:998642/+(IGFDB@=::9752/+(NLKIHFC@?><952.*RPONMKJGEC@<840,USRRQQQPMJE@;62.WVUTTVY]ZQIC=83/XVVUVX_vsWKD>94/WVUUUW]ifUKC>84/VUTSSSUUSMGA<73.SRQPONMKIFC>:51-PNMLJIFCBA>;73/+LJHGEC@=<;9740-)*&#!+($ .*&" 0,($!2.)%"3/*&#4/+&#4/*&#3.*%"1-)$"/+'# -)%!87530-*(())))('&:9752/+))****)(&?><952.--....-,*EC@<8410111110/.MJE@;63333433320ZQIC=84555555432sWKD>95556665542fUKC>85555655542SMGA<74444444331IFC>:5222222210/BA>;73////00//.,<;9740-++,,,,+*)'%#   (&$"!! ,*(&$$#"!
/.,)'&&%#!20.,)((&%"320-*))(&# 421.+*)(&$!420.+*)(&$!31/-*)('%# 0/-+(''&$!.,*(%%%$"*)'$"""!#(-28=@CGJKK"'-27=BFJLMM%*06<BGMQTVU'-39?FMSX]^^(.5;BJQX_dff)06=ELT]djll*07>EMV^flon*07>EMU^flnm)/6<DKS[bgji(.4:AHOV\`bb&,17>DJPUXZZ$).4:?EIMPRQ>;740,@=950+EB>94/JFA<71MID?94PLFA;5QMGB<6PLGA;5OKF@:4LHC>83GD@;60C?;72-			


	

  	    	 
    
 
	   
  

	       
                   !
     !$%#
     #&'%!
     "%&$ 
      "#!	          	      
                                                                                                                                 

          
!##!
  
 %((%   
"'**'"  
"&))&"  	#&&#       		   

                            
      
      
      
      	            	       
       

	


	
				

	
   


   

  

  	
!!
 !&))&! %,11,% 
 '/55/'  &.44.& #)--)#  
"%%"    		             
             
            
	                                  
                                 
                        	             !$)-27:=ADFGFD "$(-27;@DGIIHE#$&'+05;@FKORRQM&')*-38?ELRX\][V(*+-/5;BIQZbijf^*+-/16=DLV`luxqf*,./17=ENXdq}xj*,-/17=EMWboz}ui)+,.05<CKT]goqlb')*,.4:@GOV]bd`Z$&'),17=CIOTWXVQ!"$%*/49>CGKMNLIEC?;72-)%"HEB=94/+&!QMHC=83-(#[VOHB;50*%"!!"""f^VME>82,'$$%%&'qf[QH@93-(&&'()+xj]RIA:4.(''()+-ui\RIA:3-(''()*-lbXOG?92-'%&&'()`ZRKD=71+&###$$%VQLF@:4/)$ LIE@;61,'"""! ! &'((('#)+-./-'!+-0120*#*-/01/)"()++,*%$%%$$#            	                               	                  
          !         !                            
          	
	    
	    
	     !!   "&)($	    &-0/*#
   !)043-%  !(/31,$  $*-,'!
   #%$!
   
                                                                                                                      		


	















x}  }xŴ      

	   	  
	  
 ##"	$'(&"	!&*+(#	 %)*'#
"%&$ 
 !  
  	
                             	                           	                                                 
                                                     %#%')*+,,-,,+*(&)&)+-./01100/-,*.+.024566665431/303579;<<<<;:864758:=?@BBBBA@><9<9=@BEGHIIHGFDA>A>BEHKMOPPONLJGCCCGKNQTVWWVUSPMICHLPUX[]__^\ZVSNGLQV[_cfghgda]YTLPV\agkoqqpmid_YPU[ahntx{{zvqke^TX_gnv}yrjcW[ckt}xogZ]fox}sj\]fox}sj]_gq{vl\_hq{vl[^gpzukY\dmv{riVZaiqy}umeRV]dkrx}{uohaQSY_ejosvvurmhb\PNTY^cgjllkiea\VLJOSX\_accb`]ZVQGEINQUXZ[[ZYVSPLC@DHKNPRSSSQOMJF><?BEHJKLLLKIGDA:7:=@BCEEFEDCA><5369;=?@AA@@><:8(&$#,*('1/,,6410<965A>;:GC@>MIEBSNJEYTOJ_YSNe^XRjc\Vog_Ysja[sja\vlc]vlc]ukb\ri`Zme]WhaZTb\VQ\VQNVQLJPLGEJFBADA=<><97:853 	" 	$"'  !%),0258;=!$(,047:=?#&*/37;?CF  ==<:840-*% >>><962.*% @CB@>:61,'"
	  
 +/35641,&&+/110-)$%&)+,*($ #"$%%$""    		!&+.110
#(-1331
 '-27997")06;??;#*18>AA>#*17=@@=
"(.49<<9
	%+046641.+&!$&''%"31-(#" ! 972-' !?;60)"A>81*#
@=71*#
			<94.("	640+%	     %"
		    



C@BBA?<9678KFHHGEA=;;;TNQQPLHC@??ZW[\YUOHECB[afhd]UMHFEajrtoe[QKHFjq{~vj^SLIFnq|wk_TLHF      
 &+16       !'-2,     	#).2    $*/    &+!  !'*"#$ #'%')*"&)+-/0	!#'+.1356'()+037:<=	,-./059=ACE"0134579>CGKM

+45689;<?DINRU-89:;<>@BDHOUZ];;<<=>@BDFIMTZ`d???@@ACEGILPW_ej;;<<=>@BDFIMTZ`d???@@ACEGILPW_ejCBBBCCEFIKNRYaglEDDDDEFGILORX`gkGEEDDEFGIKNQU]cgGEDDDDEFGIKNQX]aG)+-0259<@DHLRVY %+06<AFKNQ

#(-27<@DGI
 $).26:=@A
!%)-1479:16.2,2"#$$()**./0045675<=>9CEE@KMMGRUUOZ]^W`de_ejkg`deiejkmglnmgkmicghc]ab^VYZ]NQQWGIIO@ABG9::@
$*05::
 &+16.
!'-2,
#(.38?FMU\bf &,29@HOX_fk &,39AHPYahl &,29@HOX_fk
%+18?FMU\bf
$)/6<CIPV[_

"'-39?EKPTW %*05;@EIMO

$*05::?BEG
 &+16.6:=@Abfgkfklmhlnlfklhbfgb[_`aTWX^MOOUEGGM@ABEQVcqzsPS_m{{pMR\hsxshINV_fif^HIOUZ\ZXFCHMPQPP@>BEGHGH;8;>?@?@Y]`bbcb_XZ^acb`\XY]_``]ZWX[]^]ZWWXZ[[ZXTWWYZZXURXXYYYWTPXXZYXVROXZ[ZXUQNZ]]\YUQM]aa^[VPLbgfb\VOKhnkf^VNIpvqh^ULF	#)/6=CIN
%+18@GOT
 &,3;CKT[
 &-4;DMV^
 &,3;CKT[
%+18@GOT 	#)/5;BGK  &+16;@C 
"',158;  
#'+/13  "&)+,   
 #%&  



  	
   NONIC=6/)#	TVTOG@81+% [^[TKC;3,&$$##^a^VMD;4-'&%%%&[^[TKC;3,''&&&'TVTOG@81+'&&&''KMKGB;5/)%%%%&&CDC@;61+&""##$%;;;851,'"  !"3431/+'#,-,+)&"&&&%#    




   	                       &       '       '        &'        %%       "#       $       !                  
            
	

           
  

	 	 
   	
(%!

0,(#

		

83/*%

>:50+%	D?;60+$
	?D@;60)"
	7HE@;5.'!,?IE@:3+&!
48?FE?7/*% ;?AAEC;4/)$AEHHGD?93,&!FKNOMHC<6/)"JORSQLF?81*#LPTURMG@81*$KORSQLF?81*#LPTURMG@81*$JORSQLF?81*#FKNOMHC<6/)"AEHHGC>93,&!<?AA@=94/)$78::973/*% 113320-*&!
++,,+*'$!%$%%%#!
	
	   








	 !  
#()(#	!)/1/)!
#+363+#

#*151*#	 &+.+& 	 $%$ 







 






 

  

    	
   		        $
   
#(+    	!)/2    
#+36     
#*   


	






"##$'('+-,)22/+63/*,'
  
		






#"!'%")&#+&"   +&"*% #!
 

	
   
	    

	     
	      
                          #+363/#* 
                                       	       
  
  


 #'*++*'#"'+/11/+'" &,27::72,& ")07>CC>70)"$+3<DJJD<3+$$+3<FLLF<3+$#*2:BGGB:2*#!'.5;>>;5.'!%+058850+%            	                               
          
                                                       	#      "'      %+      
 &-      
!'.       &,      $)      !&  #%''%# #'*,,*)'$',144100,+29??9594-6ANNA6<;.7DSSD7:A,4>FF>4,F)/5995/)7&+/22/+&7   "$%%%#!




        	$*0      	$*0      
#)/      
"(.      !&,     
$*,   	!'<4) #>6$	 @3 	C&#

9(%"
%)'$!)'$!*'$    *'$  %*(&$$%$"  %)+-,,--,+($ !$).13245542/,&"'-2688:;;:852,$)/59;<>?>=<960%)05:<=?@?>=;71   07>EMU^eknmhbZQ07>EMU]ejmlhaYQ/6=DLS[bgjie_WO.4;BIPW]acc_ZSL,28>EKQVZ\[XTNH*/5;@FKORSSQMHC',16;@DHJKKIFB>#(-26:>ACCCB?<8 $)-147:;<<;963 $(+.13455420- #&)+-...-,*(!#%'((('&$" !"""!     
	&
,% 0(       1) 
          QIB:3-!
QIA:3-($ OH@93,&  LE>81+%
 HB;5/)#	  C=82,'!
  >94.)$  84/+&!	   3/+'"   -*&"
	   (%!
    "                 	          	       
         	                                                                                                                    YPHC;\TKB:`XOF>c[RJA`XOF>=c[RJA:d\TLD<d]VNF>c]VOG@c]VPICb]WPJ9a\WPJ%a\WPJa\VPJ`\WQJa\WQJa\WQKb]WQKc^XRKd_YRKf`YRKhaZTNle_XRskd\Uyph`X~tkbZvmd[ vmd[wmd\ulc[{riaYvnf^WohaZThb\VP hb\Wb\WW	

 !!   $&((&&#&*-//--'+058853)/6<@@<7,2;BHHB<-4<EKKE>-2;BHHB=+/6<@@<9'+058853#&*-//-- $&((&&!&*-//-) $&((&# !! 	
	



HWPJGEC3a[UNKIGEd_XROMKIfa[URPNNgb]XTSSTgd_ZVWXYgb]XTSSTgd_ZVWXYhea][\]^hfc^_`abigea\aefjigd_X^ikljgb\TWnonkf_WOpsspkcYO?=<:99=BHQYahmoCA?=<;:<CLT\dkopGECBABBCGPXahostKIHHIIIJNS[cjptvNNNOOOOPTX]dkptuSTTTTTTUY]aejorsXYYYYYXY]adfimpq]^^^]]\^adghilnoabbaa`_begijjjlmefeedbcfhjklkjkk^ihgfegikmmmmkjjTWkihikmnooonljiWORkklnopqqqpnkiYOGLnoqrssssroljnolhd]Topojd\Tstsnh`Xtvtpjc[tutpkd\rsrojd]pqpmic]nonkhc]lmljfb]kkjhea\jjigea\jiigd`\kiigda\ljihea\  psspkcYOGLnoqrsrvxvof[PGAJrstusy|zsh\RIB<Gtuvry}{sh]TKC;5Bvwnvzxqh^TKC;5.Qx ssssroljihea\uuuutqnkjifb]vwwwvtqmljgc^wxyyxvspolid_fknrtuusrokf`   vwxyyxvspolid_Zfknrtuusrokf`TW]dkptwwvsnhaX\biouy|}{wrle[`gov}zsk^dlt}yp`foy~tahq{vbhr|wagpzu`enw{r]bjrz~vnZ^elsy~{voh  jrz~vnelsy~{voh_fmrwyyvsnhb^djosttrnhb\[bjX^eVY_   einsvxxwuqlfcbimsw{}~|yupjgfmqw}ztnkipt{~xqnlqv}zsomqw~zsompu|yrnlnsy|vpkikouz~|xrlgegjptxzzyvrmhb`                                            		   
  	         
	          	
                   
          
          
          
                         	               
-,      +       +       +               
    !#"     $&%"
   !%'&#
   
#%$!    !     
  
  

 	   
  	     

         	
          	  	 #%''  
"%&''  !$'()*  
#&)++,   $(*,--  	 $(*,--  
 $'*+,,   #%(***!#$$%'((!$%&%$$$%	!$&''&$! !$')('%#"'**)'$!"&*,+)&"&*,,*'#$'+-+'#
&*,,*'# -+'#  '($  '%! 
 
"
"
"
! 	  


 #',0477899740,$(-15899851-(!&+15:=??=:51+$)/5;AFIIFA;5/ &,29AHOTTOHA92"'.4<ENX__XNE<4"(.5=GR]gg]RG=5"(.5=FQ\dd\QF=5!'-3;CLTZZTLC;3 %+17>EKNNKE>71#(-38=BDDB=83- %).36:;;:63.)92,<4.=5.=5.;3-71+3-(.)%*% 
	     -($
	      1+&!
     5/)$     92,&      <4.'"
                                                                                                 %+17>E.$)/6<CI/%+18@HP0 &,3;CMX0!&-4;DO[0 &,3;CMX/%+18@HPHMPSSRQPPPPPQRSTCINQTSRQPOPPRSSTHPV[\ZWTSRSSUVWXMXafe`[XVUUVWYZ[O[elic]YWVVVXY[\MXafe`[XVUTUVXYZHPVZ[YVTRRRRSTUUTSPKGB??:4-'!STROJFA;5/)#WXWSNID>71*$Z[ZWQLG@92+%[\[XRMG@92,%YZYVPKF?81+$UUTQKGB<60)# 
				
  ECB@>:61,'"GFEC@=84/)$GHGEB>:50*%  GFEC@=84/)HHGEB>:50*GHGEB>:50*FFEC@=84/)ECB@>:61,'B@?=;73/*%B>><962.*% DCB@>:61,'"
DFEC@=84/)$	
	"$(,047:=?#&*/37;?CF%(,05:?DJP%(-16;AGP^%(-16;AGP^%(,05:?DJP#&*/37;?CF"%)-148<?A 	$"'	%*

 &+

 &+	%*"' 

 %?:61-("950,'"4/+&!.)% '#$  rtqkc]WQLGC?:61-mqoiaXRMGC>950,'dkid\TMFB=84/+&![ba\WPIB;62.)% RYXTPJD>82,'#NPOLID?:4/*$MGGEB>:50+&"E@?>;840,(#>88752/+($
7210/,*&#0--,*(&# 
	 	

	:61-("50,'"/+&!)% #  
                                   
        
                       
                     
      %*/5;BGHKKE?82!&+06=DJLG@93."',28@JUYPE<5/"(-3:CPdnYH>60"'-39BM^dUG=60"&,17>FMPJB:4. %*.49>BC@;61,    %*.49>BC@-#'+0479  $(+./    !$)-,    !---            #'+.$         $'          "            "            "                          
!"""" 

	
  

"'+/22579863/#(,04799740,!%).37<??<73."'+16<DJJD<61#'-28@L\\L@82#(-29ANffNA92"',17?HRRH?71!&*/5:?DD?:5/ $(-158;;851-"%)-024420-)"&)+-..-+)&"$'())('$" "#$$#" 
	

	



 






-)%$"0,(#3.)%!61+'"82-'#92-(#71,'"5/*&!1-($ -)%")&"$" 		

	B;4-&      @:3,$
      ?81*#       >70(!
       <4-&	            	    

   
     !""!  !#&'(('&#!$&)+-..-+)&(*.245542.*-/48;==;84/14:?DGGD?:448?GMQQMG?85;DMV]]VMD;8@JT`hg^QG==ENYdmlbUH>@GPZchg`UJ?CIQX^b`[SI@DJPVZ\ZVPH@EJOTWWVRMF?   FJOTWWVRMF?GJORTUSPKE>GKORSSQNIC=ILPRSRPLGB;JMQSTRPKF@:LPTVVSPKE?8OSWZYUPKD>7QW]_]XQJC<4S[dgc[RIA92T^jng\PG>6.R\hmeXMC:2*OU^a[QF=5/(IMSTPIA:3-'BDHHFA<60*&;<>?=:61-*'   7<>?=:61-*'1466530-,+)+.///-++++*%())('(**++ "####%')*+"%'),!$&)+!$'*-!$'*-!$&)+ "%'&"%(!!$')                                                                                           	

U[ada[TLD<4U^fie]TJB91S]fie[QG>6.PYac^UKB91*KSXZVOF>60)DJOPMHA:4-'=BEFD@;50*%6:<=;950,)&134542/+*)(,,-.-+))**)&&'''%%'(**! !!! "%')+"%(*"%(*"&)+"%(*"&)+"%(*!$&) #'!"%(!$ !"""$&&  <4-91*6.&1*$0)#-'"*%!)&#)(&*)(***)+,(*-(*,)+-(*))+-(*)&) '!(&  EJQX]_^YRI@7FKQVY[YUOH@7GKPTWWVRMF?7HLPTUUSPKE>6JMQTUTRNIC=6KORUUTRMHB<4LQUWWURMGA:3NTXZYWRMG@91QW\^]YSMF>7/T[ada[TLD<4-U^fie]TJB91*@7.&     @7/&
     ?7/'
	      >6/'      =6.&	      <4-%
       :3+$        91*"
        7/( 	       4-%	      1*"	      .&	     
*$	     
)#	    
'"
    %!    
'"
    %!    
&#    	(&#  	)(&"	 	**(&! 	+,+)%
*--,("
*,.-*&!	
+-,-,("	 
*)(+*&!	 
) $&&"
  !                                                                      	    	
   
   		!"#!"%'))(
 $(+./0.
$)-14686
#(-27;>?= &,28=BFHF
"(/5<CINQO &,28=BFHJ
"(/5<CINQS$*18?GOVYZ%+29AJSZ^^%+29AJSZ^\$*18?GOVYW
"(/5<CINQO &,28=BFHG
#(-27;>?A
$)-14689
 $(+./02"%'))+	!"#% 	 	  !#%%%%#!"#&)+,,+)&# '(,/1221/,(% +-268::<==<:3*&/28<@CCCCB@=:6237=DILLKIFC?;725;CKRWWSNID@;627>GQ[aaZQJD?:50;CMWbji_SIB<72,?GPZdjiaUI?83.(BIQZaed^TJ@6.(#DJQX]_^YRI@7.&FKQVY[YUOH@7/&   	           
           
          
	                &!
    2.)#
    2.("    2,'!
    0*%
     ,'!      (#        #
                
                                                                                                       
  
   
                                                                   %(+.///..+(% #&),.//.,)&!$'+.0110.+'#%(,/1221/,($%(,/2332/,($%(+/1221/+(##&*-/00/-*&"   
          	          
        
     

      
     		    !                               #
   !&,%    # 
  
   FJJKL<BGJLL>DJMOO?FLOQP?EKOPP=CHLMM:?DFHH  *&"	    ,1/"
    .37:    
.37:       
.37:      
16:>?      
5;AEGFDBB!   !&,%  #)/5<2
$*18>D
%+29?F
$+18?E
#*07=C"(.4:?   $%  $        %       %        %       $
       "	           !%)    $),16 	$(,159 #(,159<
 &+16<AD	#(.5;BIN
$*18?HPX%+2:BLV` %,2:CMXb%+29AJT\
$)06>EMS	"'-39?EI=0       <>A?;;; DEDB>;:51 NONIB<62,)%X[XPH?81*%!`d`VLB:2+%bfbXMC:2,% \`\TJA92+%SUSME>60)$IJIE?93-'"      "$%    $'*,,%(*($
     $%$      -04676,/2555*-0234  (1-#	       $       
#',0 
!&*.  +&!                        

  -14677169<=>7<ADFD<CINPL@HQWZV  ,/2455047::<5:?BCE:@GLNP>FOW[\@JVafeAKWdje?HS]a]<CKQTV7=CGHJ27;>?@-14678(+-//1#%'))* "##$   "##"
  BJQWZZDMU\_^CLU\^\AHPUXT<CHMNK7<@CDB158;;9+.1234%(*++-!#$%&
"'-3:0
 %*/'   

  71+%	  	  "(#
 
   	       	                     
            
             

	   
   
   
   
     ))07>DJMMJE>70*#*+29AHNRROIA:2+$*,4;DLSWXTMD<4-&+-4<EMUZZUNE=5-&+,4;DLSWXTMD<4-&*#+$-&-&-&  %)-1#(-16!&,17<#)/5<C%+18@H  
     
    	    # 
	  '#   
	 
         	       
	     


     
   






  
     

	

	      ##0681)!	%*11/)"
//.,)$
/-+($
	-+(% 

*($ 		
'$  # 
  	
"   	$,2432$0<72/#/B6.* '+*'$ !     (/2.'

%+-*$	 %&$
	  	
):C3)!&38-%!'($ 
   
	         
	         
          	                          	%*-  
 &,.  
!'-/  "(.2  
!'-3  
 &,2  	$)/  !&+  
#'   
#   
    
     
      


   




$$%%%#!**+,+)'$ -12210-)%!4799863/*% :>@@?<84.)#@DGGFB=82,&EILMKGB<5/(IMPQOKE>70)JNRSPLF?81*   JNRSPLF?81*IMPQOKE>70)EILMKGB<5/(@DGGFB=82,&:>@@?<84.)#4799863/*% /12210-)%!**+,+)'$ $$%%$#!


	 BGMRRMGFD?:50,BCIOSRLF@;62-)DELVb\PHB<72.)DFN\~kTIB=73.)DELVb\PHB<72.)BBGMPOJE?:61-(@>BFGGD@<840+'  27;?BEFF27;?BDEE16:>ACDD/48<?ABB                          "          
"         "        !        	 	
 
,/158;?ABB!%(,059=@BCD"',16;?BDEE"'-27;?BEFF"'-27;?BDEF!&,16:>ACDE %*/48<?ABB$*047:=?AA (66)                             	        	        %%!       &&!
     4/)$
  '6C>82,& -WSMGA:4.("                                                                                                               
                                ?;73/-)%#@<840,($$D?:61-)%$E@;62.)%$E?;62-)%$B>951-)%$@;73/,($# !#&()*++#$')*+,.')+.0124,-13678:.269<>?>27;?CEGE6;@EJNPN:?ELRWZXk\PG?71+&"
n_SI@92,&!i\QH@82,& `VME>71+%[QIA;5/)$
VOE=72,'"	 SL=94/*% 
 PD951,'#  !$ #&  $(,   $(-1     "'-16       	 16;         
,A           #!$'(*++,"%')+,-/&),/1235+.2579:</37;>@A@38=AEGIG7=BGLPRPAGNTY\Z#	"& !%(   +     
 

 
	    	
           
      ;@FLRVY\@DKSZ`dgBGOXajorCIR\gqxzCJS]hs{{BIQ[eous@FNV_fkh=BIPW\_]:>DINRUU79>CGJKN248<?BCE./368:;=)*-02346$%(*,-.0  #%&'()!""$ #%&'(&!""!
	


                                       "*$7<AEHLNO8;AFKOQU;?FLSY]a>BJR[ekp?DMVbpz?ENXet>DMVboyw<BJR[djg:?ELSY\]8;@FKOQT47;?CFHJ0269<?@B,.14689:(),.0224#$')+,,. "$%&'(!$')+,,+ "$%&'& !" 


		
                            $,& 
                      	                  	!',       &+0      
"(-3      	$*06      
 &,28     !'-3:    


 '-4;      
")290*#        +29BIPRRT,,  -39?EJRTVZYYA06<BHNSVYYXWS28?ELRW[^^[WR3:AHOU[_bb_[U4;BIPV\acca\V6<AIOV\`cc`\V<AGMQWZ^``^YT %PVZ[\^_\VQ  A>=D@=  A?=D@<ID?ME@KE?GB>C@;                     		    
    

 
    !%
   	
 $'   
!%)   #'+    $(,   	
!%)-   	!%).      
#(-'!       $(-26:;<>  %),047;>?BBB'+/26:=?BBA@(,048<@DGGD@)-16:?DIOOID).26;@EMaaME*/26;?EKVVKE/159<@CHJJGB 
;?BBDHHE@"&*-//-*&""'+.00.+'"%+047740+%"(.49<<94.("#)07<??<70)##)07<??<70)#"(.49<<94.("%+047740+%          
          	          
                            
          	                            	                #        
!'        ")       #*        ")!#$$#%%#"%&&%'&$$(+--+-+)#).133130-'-2799773/)/6;>>;950*07<??<84/)/6;>>;61,#(,0110,(##(-1331-(#!'-38;;83-'!#*18?CC?81*#$+3;CHHC;3+$$+3;CHHC;3+$#*18?CC?81*#!'-38;;83-'!          	                                                                         	
                
!       
%       "(       $+       
$,       $+ #%&&%#  $&((&$ !&*-//-*&!%+057750+%(/6<??<6/(+2:AFFA:2+,3<DIID<3,+2:AFFA:2+#')++)'#"'+/00/+'" &+158851+& ")/6<??<6/)"$+29@DD@92+$$+3:AEEA:3+$#*18>BB>81*#!'.49<<94.'!%*046640*%           
          
                                                       
                    	                
"        	%        	 '        	!'        	 &        
$        !  #%''%%# #'*++*,*&"',/11/12.%+046643:6'-269962;<'-3799739A&,158851,D$).2442.)6!&+.00.+&5  #).338?FNW`i$*06=DLU^gm%+17>FNWaks%+18?FOXcmv%+17>FNWaks$*06=DLT]ek#(.4:AHOV]aloppgmptksvymvzyksvxekmt]ack     

      	
      

      

      

      	       


W]l||l]VMD=71  VZhxp`TKB;5/*$RXer|xk^SJB;5/)$MT]fkibXOG@93.)#GNTZ]\WQJC=72,'"AGLPRQNJD?:4/*%!;ADGHHFC?:61,(#8;>@A@?<962.)%!7579:98641-*&"30233321/,)&".+,-..-+*'%")&'((('&%# $!"###"! 
	
	


     *$)$
)#
'"%!#
!

	
   
       
                  ]cnw{wnc\SJB:4  \`kv{yqf[QH@92,&Y^irwvndYPG?82,&SZcjnmg^UME>71+%MT[`cb^WPIB;5/)$GMRVXWTPJD>82-'"@FJMNNLHD?:4/*% <?CEFEDA>950,'";9<=>><:740,($735677642/+($ 1-/0100.,*'# +()*+**('$"&"$$%%$#!!
	
	 

     
,&!,& 
+% 
)$'"% 
	"

	
     
       
                   Z^_cX\bgZ^dj\agm]ahn\agmZ^djwvutpvwvrj|}|xp}uw}u|}|xp        
                  
      
      
      
             
         :4.-*%?92,& A:4-'!C<5.("C<5/("C<5.("A:4-'!   >>DJQW]cinrvwx?@FLSY`flrwz||AAHNU\cjpv{ABIPW^elsyACJPX_fmt{ACJPX_fmt{ABIPW^elsyAAHNU\cjpv{?@FLSY`flrwz||  smf_YvpiaZxqjb[xqjb[vpiaZsmf_Yoic]V wxwtplf`ZTNGA;5/||{xtoic]VPIC=71}ysmf_YRKD>82|vpiaZSLF?935/*71+82,93-82,93-93-93-93-82,71+   GGLPTXZ\]]][YVRNJINSWZ]_``_^[XUPKKPUY]_accba^[WSLMRV[^aceedb`]YTLMRW[_bdffeca]YULMRW[_bdffeca]YULMRV[^aceedb`]YTKKPUY]_accba^[WSJINSWZ]_``_^[XUPRNJGUPLIWSNJYTOKYUPLYUPLYTOKWSNJUPLI559<?BDEFFFECA>;77;>ADFGHHGFEB@<88<@CEGIJJIHFDA>99=ADGIJKKKJHEB?9:>AEGIKLLKJHFC@9:>AEGIKLLKJHFC@99=ADGIJKKKJHEB?88<@CEGIJJIHFDA>77;>ADFGHHGFEB@<>;75@<96A>:8B?;9C@<9C@<9B?;9A>:8@<96AAHNU\cjpABIPW^elsACJPX_fmtACJPX_fmtABIPW^elsAAHNU\cjp?@FLSY`fl >>DJQW]cinrvwxwt?@FLSY`flrwz||{x?AHNU\cjpv{}@BIPW^elsywtplf`ZTNGA;5/*{xtoic]VPIC=71+}ysmf_YRKD>82,|vpiaZSLF?93-smf_YRKD>82,vpiaZSLF?93-xqjb[TMF@93-xqjb[TMF@93-vpiaZSLF?93-smf_YRKD>82,oic]VPIC=71+`   a   pyxww~}|{{~~~{zyxx  Ippqqquuvyyy{{{||||||zzzwwwsss]pp   ppqqtuvwyy{}||~|}~z{|vwxzrstu#$&()*+,,,,+*(''')+-655300/.,*I>>JGDA=965431/XUSPMJGC?;;:874][XVSPMIEBA?><:a_][YVSPLHGFDA?edb`^\YVRNMLJGDIhgedb`\YUTSPMJ>IT^dhfc`^]ZWSOIMRW\`hhghkiaYUMRY_bgknpsuvvpaUafgjotx{}|ijknqx~lmoswlnrv|   lnrv|jmqw^jouZbks~X_gpyV\cks|RX_fmsy~OTZ`fkpsuy{{zyqMPUZ_cgikmpqmbXIKPTX\_abcd`ZVRDFJNRUWYYYXVSPL@AEHKNPQRRQOMJG;=@CFHIKKKJIGDA78;=@BCDEDDBA?<3479<=?@@@?><;8   '%#*(&/-+42/:74?<9DA=JFBOKFUPKaUO|rf~   }{q_QXRMRMILHDGC?A>;<96863   NOIPMVQ[Q[MVV\ab_YUTOGA:4.PX^bb^XPIB<60*V_hnnh_VME>71+[gs{{sg[QH@93-[gs||sg[QH@93-V`inni`VME>81,-*1,3-'4.(4.(4.(3-'   vnmcVcb[WT~sfY]d]XUR{l^Q_a\ZWdSF>Yb`]obWME>7KecrwbggbZQIB;5/:gRY`cb]VQJC<60+X{ysfZdc[Vwj]_e\WSpbT``[XhWIAY`]pe[QH@9Kax|eiie]UME>719U]cfe`\UMF?82,   WTF[WT_\XW_\4U`3-b    unlbVnsnl~reYduoll{l^hxrnmrbkztonrbkysnm{l^gvokjllYmlcnnmpnnpnnnmlkjj   ;aa[_Z[WWSOR  \J!*5?GR_hjih`Z8* (3>JWdllji]XSOM<D?KXemnllZUQMJKPVX[]dhikVROKBGLQW\``bei bOfNc]`Z[VRV_L%/7>HQWZ[c\8)$-7BKTY\\a[UOJ7?9CMU[]^]WRMHGKPPQQWZ\YTOKABGKPTVUUX  YYPYYT\\[^^^]]^Y[\UXY   NNONRPURTRROOOJNONRRRVVUYWUXVTTSQ   NLJHFGJKKMOONMOMKIGFHJMOOOMMRPMKIILORUVVSRTROLJLOSW[]\YWTQOLJLPTX\^^ZWQOLJHIMPTWYYUT !  $-6:<ENV\a&09CLT[`d  )3=GQ[bgj  "+5@LYenoo "+5@M[jtsp )3=IUahjjfhddgkhkonoqqqrpopjjk   Oc_5d]3a\        /ZU-WSOc_5e_6e_6e_GZZ0\]2`]4b_<LL)NP+SQ  >0== ?A'KB=10012(4!$	 &	                        
   0                       
                                                                                          
!#" 
  "
!%
!"$(!#$&* "#%)
 "&

! tvwwwussqmgaZSqtvwwwurnic\TSwyz{{zxuqle^VU~~~}{xtnh`XV~|yuoiaXV~~~}{xtnh`XVwyz{{zxuqle^VU  
 %()))(%"!&)*(&#$),-,*&! #
%+/0/-)$$'%*.//-)$$'"'*+*)&!"%
"%%$#      "%,4:>?ACDHMQ!"&.5;@CDGLPU#%')29@DGHKPTY')+-5=DHKLOTX\'*,.6?FJMMQUY^%(*-6>EJLMPTX] #%*3;BFIIMQUY  #*18>E!! !'/6>EKQ %))(*29AHOV[%,1334;BIQX^c!)19=<<BHPW^ei!)3=EEEIPW^dim (2=EGJNU]djno'0:CGKQW`horr&.7@FKRY`ipss$+5>EKRY_fkon")2<DJQW\`cee '0:DKPTWXY\]$,8CLPQPNPRT
!(4@KPMHEFGK$-:EJHB<;<@   $-:EJHB<;<@
 '1;@>:4004	
#)/32/+''+"%&&%"!	
  EMRQNJD>6-($###Q[`^YSNG@82..--[dihb[TNID>8766ckonhaYTPMF?>>>iptrmga[WRKDCDDmswvrmg`ZVPJHHIouyxupjb\XSONMMrsvwupjb\YWTSRQspprqmha\[YWWWWnlijjie`^\[Z[[[eecacdda_^\]^_`]^^^`bca^]]_adgTWXY\ab`^^`cfimKNPRV\_^]`cfjnr@CFIMSVX[_cglqv   @CFIMSVX[_cglqv48;=BHNSW\aflry+.14:@GMQV\cjrz!$'+19AGKOV^enx %-5<BGKQYaju ###%-5<CIOU[`L1--,/7?GNU[`einr6658@IQY`gmqux{>==AIR[dlsy~DDDIR[enwIJKPZdnxMOPValvQRU]gr~WVZbmxý[[`hr}Ħ`cfmv}gjmszympsy~}trvz~vnv|}wpi   v|}wpiy|wqjcz}wqkd]xxrle_Wr{tngaZS 1/,0rV2q{~W|^Xoa\}pa^yph_tmfanic]id_Zid_Zc_[T]UMKWPHISLDE &	


 	

 &,%*07#*18>E+-01/,'# ,03540,&!7=CDB>92+$EMRQNJD>6-($###")/%,3$+3:###%-5<C"%(+$ !"""$&& 399.'''&'"#:@GMI7,+)'$CIOU[`L1/,( %+28?J!!!#)17>ELW %()(-4;BIOV`%+/126=DJQX^f!(/59:=DJQX^em!)08?ADJQW]djr '0:AEIOV]djnt&/9AFLQYaiosv%-7?ELSYbkrvv#+5>ELSZ`gnrq!(2<DJRX]`ehh&0:CJPUWX[^^#,7AIMPPORTV (3>GKIHGHIL
#,7@ED@==>B   
#,7@ED@==>B	 '08=<94226#(.22/+(),
"$&&%""
 JW\YRLFA:1+'%%%Wekf]UPKF@82///`lqme]WUVRG<877fpurkc^^b_QD?>>mvzwqjfceaUHDDDr}~wqkeb^VNIHIt{tmfa]WRONMv|~ysme`\YVTTSvuwwuqkd_][YXYXqnmnnlhc`_]\\]\hgddghgeb`_^_``^_^^afihdb_`abeVXXY^djjea`adgjLOQSX`ghcabdgkoBEGIOV\]^_beins   BEGIOV\]^_beins69<>CJOTW[_ciov,.14:@GLPTZ`gnw"%'+19@EJNT[ckv %-5;AEIOW_hr %%%&-4;BHMRX]I//..06>ELSX]aejn777:?GOW^dimqsv>>?BHPYahouz}DEFJPYbks{IJKPWajt~MOPU^hr}SSUZdoyXWX_jtŻ\\]dnxƥ|`acir|zegjnu~ujmptyyoosvz~}xrjsx}|wrld   sx}|wrldv~{wrlf_w}xrmgaZvzsmhb[To}~voic]WP /-+.nR0lvz~yTw[U|k]Xzl^Zukd[ohb^jd_Zd`\Xd`\X_\XRZRKITMFGPJBC



	
!!(. %+2:%+28?J',1453/+'#(.38974/)$2:DIIE@;5.&"?JW\YRLFA:1+'%%%!(/%+2$+28%%%%&-4;B #&)*#  !!#%(& 287-&&&'(!"8?EKG6+*(&#BHMRX]I/-+'                  =;%C.E/G0G0G0E/   ,14664/++'#'.25763.($-49>@>:5.)$2;BIJGB<5.)"5?GNOKF@92,%!   4>FMNKF@92,%!   08?EGEA<5/*# $%-6@"*4=G#,6?I$-7AK    $.8BK    $-7AK#,6?I 
	  	

	   3345689;AHS_j4334569?FP\hr665678;AHSamy87789:<CKWes98889;=CKXfu87789:<CKWes665678;AHSamy pwxhrzmysusmy   22111234:@FMT32111138>DKRY5433334:@GOXb7654456;BJS_m8765556<CKUbr7654456;BJS_m5433334:@GOXb W\\RY]Xbh_mzbr_mzXbh   oxer{^jwkValv|gaMW`ga\WDLTURRN=BHHIIF8;>@AA?568:;:;247898714677751367765136776414677642579875   mvbo}zZftiS]hsyd]JS\d]XSAIPQNNJ;@EEFEB69<=>><3478988136776503566540256654035665313566531468764                                                                  J SV, [[Y *RN7 LR]` bbH \X? RAE Kg jj4b^Q                                                                               7 <7 
$   E8
,2	    Q:	9                                          

                                                                                     
               			 	
      " ' 

        ! +%  =& "B) $F 7    .,*    .,*=_[VS`\WTa]XTa\XT`[WS^YUR[WRPWTOMSPLJPMIF                              				  	            	                           !"# %$$#  $&() **)(  )+-/ 00/.  
 
                              >ACE #HGFD!   CGJK (PONL%  >ACE #HGFD!   CGJK (PONL%  "HKNP *TTRP&  $LORU ,XWVT)  ')+, .-,+                +-/1222210., *X]`dfggfeb_[ +Z^behiihfd`\ +Z_cfhjjigda] +Z_cfhijigda\ *Y^adghhhfc`[ *W\_bdffeda^Y (UY\_accb`^[W 'RUY\^__^]ZWT %NRUWYZZZXVSP 'RUY\^__^]ZWT %NRUWYZZZXVSP $KNQTUVWVUSPM                        ::=?ACDDDCB ,96?;>@BDEEEEC  =:6DADGIKLLLK% "B?;IFJMPRSSSR( KHD!JLPSVYZ[[Y *RN79                . 4 6620 (  b26n8rr8Ri2Z2741 " :63 	#
  ?;+' D! ;/   7<7
$          (     Z4M/1C#% 
   


         #       $     	
!%     	
"&     
"&     
"&     	
!&     	
!%      #      !  #'*.158:<==;963$(,037:=@AA?<95%)-159=AEGFC?;7&*.27;@EKPMHB=9&*/37<AGPlXKD>:&*.37<AFMXSIC>9&*.26:?CHKIEA=8%)-048<?BDCA>:6#'+.269;=>>=:74!%),/2579:98641  30,(%!51.*&"73/+'#950,($ :51-($ 951,($ 840,($62.+'#40-)%!1.*'#   




	  


	#(#
   ]\`[_e^cjafnbhqcjscjsbhqafn^cj[_f   ZU\[\^  _\`__e  Y^K^djTWTb[Uf_XjbZmd\ne]ne]md\jbZf_Xc\U   RmprsrokfJquy||{wsmgWTb[U  VR4`ZTYY]^`bdfhikloprrtuvwxyfzIXTYX^  Z^]b`eagbhah`f^d[`X\TX  PIPJQKRKRLSLSMTMUNUNVPZT^WaYOKAPI2PJ'   ?BJS^iu~~ti]SIBFMWamyxmaVMHJQZdozyodZPNOT\enw~}wne\STTX]elsxzxsld\TYY]`djostsojc\U  I@8MD;PG?SJBTLDUNF  PIPJQKRKRLSLSMTMUNUNVPZT^WaYc[d\c[d\d[bZ`X\UXRUONFOHOKPIA)&# 
2+)&#&+)'#),*'#,-+'$%%$#""  %)//,-..-,)'$ %*/245677642.)#)/49;=??>=<:61&+29>ADEEDCA@<7',4;ADHIHFEDC@:',4;@DHHHFEEC@;   !$&(*+++*!#$%%%$  $!)$
1)!
7/%
:2'
    ;2(
                                                          ?   #B:   	
 D<5(F?7!

HB,$!KA)&# 
I2+)&#   #(-38>CGKNPOMJE %*/48=ADFGGEB?"&+/37:=???><9"&*.146888753"&),.01110/-!$&(*+++*)'!#$%%%$#"   E@;50+?;61,(951-)$30,($ -*'$ '%""   *)'%"$#" 


	

	                

"(.      
$*0      	$)0      	#)/      
"'-       %+    #(:   	
 %28?GPYbkpuupg^T06>EMV`jqutne[R06=EMU_hosqlcZQ/5<CJR[bilkf_VN-39@GNU[`bb^XQJ+06<BINSWYXUQKE(-38>CGKNPOMJE@%*/48=ADFGGEB?;PGA<5RIA:3QIA93NF?82JC=60E?93.@;50+;61,(82+

	:3-*(#
 93,'#   82,&    60*$   3.(#
    0+& 
    ,(#    )$ 	    $       
	     
      
       
        
                   
                                                                       * NNM[VQN+*HG[Bec_[ //2cbIihgeO&(RQUK
Rbppo // 6ad onli+T__N   E^/^__  9[N8E4^^_   \]^^-[[>M<HR__^^Q^]`__   +abQ   _D#`0``aabQ 8#!`aa    9 N2]aa``S`^baa      %$.!531-  #
	#"-)%"    44&7775    02 1357    $#'  $%)-1     	$,*'$(+30//2%0.+*'%104201233210.,*'%      10.,     0123    3321	    ' '0420  ,cdT    9$"`ac   9 (1<````     AD AEHJ    #FE3JKJH  /
0/=82/    21=,HEA= 0RRR    #
RRD     :$"cde    -efU                ( )5E?95
 ' 
'4=:74>95N]WPN]WQOA>9b]Wb]Wa\W     )))(WXWT    &&$"TPKE (
\]N   IGDmkg    !!!!EEED   DB@=IIIGDA>mnmkgb]llkifb]    5!Z[\   mkgkifjhe    GIIkmnjllijk     %&( KPTW # ! IFDECEGIghkmiijl    ,PQ \ZWU    )RQ<UVUT    <;L7TROL  AAALHDAkjijkjhea\WQPmljjjjhea]WRP  6 %.8ZZZZ;  ) 2>cccca\Wa]Wa]Xb^Xjhejhejhejif          1 ")3QQQRijkjjjljjnkk      
       
       

DCEfghhiikkjnmlponrrp#    204+ 238=A     8! 89?EK 
 7$7DMKI SE?DCSS]fgSS_hi 2    ECG?
ET`^\ TTakkTTbnm  VUdponljjjhea]XRQVVfrrpnkkjifb^XSQVVgutrpmlljgc^YSQ               	    				     		            E?D7NOPP?.
=.PPQQ__YI/[Xhdcb[`^cba  !]]KJ5QJba`_
 


  
 


 ! R;$M:fedcb^Xc^Yd`Zfa[I5"E4\[[Zjifljgmkhpnj[VWVf`ZV3`[RPfJuqlf ii3:qpSzxwuonmkhd`ZTSrqpnjfa[USutspmhb\US  ^R[Fljhffa[hb\jd]le^RIP?`^]\pnjspmwtp{xs            nkkpmlronurqxutuwxy|}       	
      N8$I7ba``rrputrwvuyyxR:	 KM@dcba]c`edc  _RK[Hkfed1gh <nq|||zWTY1[Z^S[jxz| YXiwvuroYYjyyxurYYl{{zxu        YNVCgedbyyx{{zflqhouAE KcbNQdhnskqnsKh npVswz   qxwwz{   kk5YssVz{{y5c_TSjMyupkyYSjgf{yupkfadegaafhbejomnoknposu   jlnqtjosuv  qqqprqqpuvvtqrvt[UVUg`YU4`[SQgJytng kj4;tsU~}yVSX1[Y^K []cjq 1fi 7nr qw{~igbnhd  ][`flquwxwtpjd]VU^]ahouy|}{xsle^WW^`fmsz|wpib[X 2]YQOdIwrlg=W[_befe2.\bgknooSaciotxzzw 5c^USjM|wrlA\aehjlk51bhmqtutWahntz}~| EBB@LIEAnkkhomifurnhMHIFVQLGsmurMJOJb]d^og_^sjb]vmd^UOQMaZTOwne_wme^ulc]qiaZle]Yle^pibvog|sjvmwnwm~ulyqislemf`f`[)UWXYXVTPM.[^``_]ZV>]bfiihd`[V  %GE;:K7SQNN.VRJH\Clhb`{xs|w~y|}z~vo|sv  houmszrzw{||yu}pw}jpudjpCAD%FDG8 FGJNR IGK)MKO? MNSX] ifkrziiowijq{ QNS.UTXF UW^dj klr|kkr|kjpy dfmu}dchpw  ,+*'$10.+'#6540+& ::84.(";<:50)#;;95/)#9862-'!431.)$.-+)% (&%#   "$%(*+,+*(&""%(*./000/-*&!%*.256655431,#(.5>?<:988883 $)0;TL@<;::;B> #)/8HF?<:99:<8"',17:98776540 $(+.1333210-) #%'*,---,*'# !#%&'&%$!  "
       &!      ,&
      3+"      >.$      8-$      0)!
      )$
	      #                /)0*2,2,2,2,0*.(+&(#WTPM[XTQ^\XT`^ZVa^ZV_]YU\ZURXUQNSPKIMIEC259?EJNQRQNID>857<BHNSXYXSMHA;7:?ELSZbgbZRKD>8;@GNV_oo_UMF?9<AGNV`pp_VNG@8;@FMT[chc[SLF?69>DJPVZ\ZUPJC=36;AGLPRSROKF@:/28=BFJLLLIFA<7*.49=ADEFEC@<83  82,;4.>70?81@91?81=60:4.71+3-'  cfkorstspmic__^finsvxxwtqlgcbaimsw{}}|yupjgfdlpv{~}xsmjhgmrx}zunkihmrx}{uokigmqw|~ztnihfkoty}~{wrlgechkquxz{zwsnica`dglpsuutrnje_\[  ^]\\\[[a`__^^^dcbaaaagedccbbhfedcccgfedcbbfecbaa`cba`_^^`^]\[[Z[ZYXWVU  Xad[ah_fmbiqeltfmufmueltbiq_fm\ci   ]cdbehiknmptqtxsvzsvzqtxnqtiloegj   aflrvxxvsoic]X^cinrssqmgb]XXCA?<9657ECA>;878FDA?;989ECA>;888DB?=:766A?=:7433=;9630./8742/+)*HFB@?>=;963002LIECCA@><96325OLHFFECA?<9657QMJHHGECA>;878#)07=AA=!&,26996"',/11/"%(**(!##!!#$$#"%&&% $(,--,$*/3553!(.5:==:#*29@EE@$,3<DIID$+3;BGGB#)07=AA= &,26996+ $#  	      
   
          
 "%&&%"&)**)!&+.00.$).2442 &+15775 &,15775%+04664#(-0220!%*-..-!'.38;;8$*/3553!%)-..- $&((& !!  !"#"!#$$##')++)#(,0220 &,16886"(/5:==:#)07<??<#)06;>>;!'.38;;8$*/3553!""" # "$$#!(%(*+*'#.+/231-(#207<=:4-'55?GJC:1*58CPTJ=3+57BMPG<2*43;BC?7/(0.37850+%+(,./-*&!&$'''&$! !#!!    "%())(	 "##"  
 	
 


	

	
        	!&+0231(
$).3553(!'.4;??;'
#*1:BHHB&
$+3<FNNF$
$+3<ELLE"")07?CC? %+17::720+&!53.)$ ?;4.'!$HB:1*# NF<3+$LE<3+$C?70)":71+% 
IK(K(I'G&C$?":		!#$$##!#'*++*)%(-13310(-38;;84+18>BB>8-3;BFFB<-3;BFFB=,18>BB>:)-38;;86%(-13310!#'*++*)#(-1331,#'*++*&!#$$# 		


GFDA=830-*'$$KJHEA;62/,(&&OONKF@952.*))STSPKD<840,**VYZWOG?:51-++W\heSH@;62.++V[gdRG@;62.+*RUVSLC>:51-))LMMJE@<840,(&FFEB><952.*&#  $$&&)(**++++**)(&&##]TLHEDB@?=<:;?`XPKIGFDBA??@Bc\TPNLJHFFFGGHe^XSQOMLMMNNNNe`ZUTRRSSTTTTTfa]XVWXYYZZZYYfc_Z[\^____^^]gda]_acdddcba`hfc`^fhhhhgfddihfc^_lllkjighkkifb]Yionmkjkmnmjf`ZUjqomnooqpnic[UOhppqrqstqmf]TMFfsttruvtog^TJD@gvv  ruvtog^TJD@gvvquvtog]SJC>:gxnrtrme[SKC<62f             :PSW      %%%KNPRVY      IJJKMPSW[_      IIJMPSVZ_d     #HJMORUX\af   "FHJMOQSVY]ae !DGIKLNPRTVY\VRUX\]_acVY]_acj[_dgiko_dimppqafkorrraegiknqVRZagim   TOIC>82,& WSMGA:4.(" \WQJC=6/)#   ^YSLE>70+     _ZSLE>6.,     ]XRLB+     [VN#              YYXWQ][XSMb`[VOca\VPa^ZTN]ZVQK              #         1+%! BA?>=92.*&"89=@BBA?:73/,($ :9=@CDC@=951.*&":;@DIKID@;73/+'#;=BHPYPHB=840+'#<=BISjSIB=840,)&<<AFLPLFA<852/,;;?CGIGCA>;85  	 	!
 

 "    $ 
	      &"
      '#      '#	           89=@ABB@:9=@CDC@:;@DIKID;=BHPYPHk\PG?:4.("n_SI@92,&!i\QH@82,& `VME>71+%[QIA;5/)$VOE=72,'"SL=94/*% PD951,'#U[fqw{yqTXcnw{wnSV`jrvrjTU^ejlicTU\aeeb\TUZ^``]XSTX[\\YTSTWZZYWKuui\QG?82-'"nul_SJA92,& dnh\RH@92+% _d`WNF>71*%
_]XQIB;5/)#	]TOJD>82,'!
UKGC>94/*$LDA>:61,'"

 

 
	    	
           
                   %J      (:MKK      QQQNNMOP      QQQQQRST     +TUTTTUVW   -ZZYYXWWWWX -]^_^]\ZYXXXX  
                  
      	             	         
  
  
   
 
                                                  	
	

	


		


"&).37;>@
!&+059=@B	$)/49>BEG &,17<AFJL"(.49?DIMP	#)/5;AFLPS		
#)/6<BGMQT		
#)/5;AGLPT	"(.4:@FKOR!'-38>CHLN
%+06;@DGJ	#(-27;?CE?ABB@BCEEGIJJLNOMPRSPSTUQTVVPTUVORSTLNPQGJKMCEFG&),/2578888641.&),/3589::8641.)+/369<>??=;841*-159=ADFEC?;73,/38<AFKNMID?:5,049>DKT\XOGA<7-05:?FN\{jTIB<7-05:?EMXjaRIB<7,/48=CIOTRLF@;6+.26;?DGIIFA=94*,048;?ABB@=:62(*-147:<<<;963/,)%"
	.*'#1-)%!
	3/+'#
51,($ 72-)% 73.)%!72.)%!61-)$ 40,(#2.*&"
/,($ 
	AHOV\aceBJQY`ehiCKRZafijBJQY`ehgAHOV\acb>EKQW[]^;AGLQTVX7<AFJMNP69<@CEGI677;>@AB49=ACEGG49=AEGIJ8=BGKNOQ;AGLPSUW>DJPUXZ\?FMSX\^_@GNTY]``@GMSY]_`?ELQVZ\]<CINSVXY9?EINQRT6;@DHJLN*+/2467898,+/2579::9/.259<>??>0048<@CEEC226;@EJMMJ238=CIQZZQ349>DKWssW348>CKUffU237<AGMSSM115:>CFIIF0/37;>ABBA--0479;<<;                                                                                       $)/4:AH

"(.4;BJ

"(.5<CK
"(.4;BJ!'-3:AH %+18>E#)/5;A	
!&,17<	%+169	!',26+	"(.2!	
	






	
       	!',2       	"(.2      $*/+      %+*    	!',   	#($"# $%&() #'),./
 $(,/246
$(-158;<
#(-16:>AC!&+06;@DHK
#).4:@EJOR	%+17=DJPUY!&-39@GNU[_
"'.4;BIQX_d
!&-39@GNU[_

"'.4;BIQX_d

"(.5<CJRZaf
"(.5;CJRY`e!'-4:AHPW]b &,28?FLSX]$*06<BHMRV

"'-28=CGLO
$)/48=AEG	!&*/37;>@"&*.2579,26.2!/+*"##%())+./014666;<=<ACECHKLKORTRUY[Z[_ba_dgf[_bd_dghafij`eih]bedX]_^RVXYLOPREGHK>@AC79:<;?AC:>BF<AFL DBBCDFHJMOQSVY];?BDBDGIKLNPRTVY.:>BFGIJKLMOPQ=  <AFLPNMMMMG+    =BISjTNJE87     =BHPYPHB<:8     ;@DIKJE=;;+      :>ADI#          +/359=+.26:>,/38<A-048=B,048=B,/37;@+.26:>  "'-39?EKQUZ\\ #)/6<BIOTY\\[   +18>ELRX]_`^     (9?GNT[_bca     >@GNU[`cdb     ?DGMTZ^ab`      2FFHQW[]^\          %>X[\[[XTOMLKI\[WSMKIH`^[UPMKIca]XQNLJdb^XRNLIb`\WPLJH^\YTNIGE\ZVQMIGE                         	((
      '(     	"'+      %*05    "'-39?E%  #)/6<BIO?[Z[[ZZZYYXWWWWXY[[]^_^]\ZYXXX,Z]_bcca_]\ZD  ]abeeecaW6    _bdefb[LI%     ^bcc^YRKJ%     \_``\*%$$     X[_/           tnkf^VNH{vqh^ULE|}vk_UKE ""! !&""! ,('&%#! 2.-,+(&%94320.+*A;:9630.ICB?<953MLJGC?:6OWTPJD>9ZeaYQIB<jvnbWME?{xgZOF@}seYNF@zlf]TKC?rzsh]SJDenjaXOGCYa_YRKDBRVTPKEA@QLKHD@=>JDCA>:9:B=<:8546;7753113XVURNJHFXXVTOMKHWWVSPNLJWUTQNNLJTSQOKFGI@DEDBA?<99>BEED@=99:AEIKHC?;:;CISXMFA<;<DKXlPGA<;;BHMPKE@;9:SRQNJECA@@@    VTRPLGEBA@?>>  XVURNJHFCA?>=<,XXVTOMKHFCA><;:9VWVSPNLJGEB@>;:9UUTQNNLJHECA?=;9TSQOKFGIGECA?><:SRPLHEJ9D8A?><;     $F./7=<;          (14:            +1:8            ;977!""""!   <:978?DEEEC@<99<;:9:>BEED@=99:<;:9=AEIKHC?;:;4:9:>CISXMFA<;<.16:>DKXlPGA<;;0369=BHMPKE@;9:69<>@CFGEA=978  >?@CEEDA>:77  ::$9:0:;<;<<;;<9::788677
$).38=@CE!&,17<AFIL
#)/5;BHMQU	%+28?GNU[_
!'-4;CKT]df"(.5=EOYdmp"(/6>GP[hsw"(/6>GQ\htz>@BBA?<9998CFHHGEA>=<<JNQQPLHDBA@RW[\YUOIGECYafhd]UNKHE`jrtoe[RMJGdq{~vj^TNJGeq|wk_TNJGQ
!%).259NQOL,-$"',159=KOMKHFDBA5779>CJKJHGEDBBAAAADJJHGEDCBBAAABDHQHDBBAA@@@@ACELWD>=====>>?@BEO[?99::;;;<=>@EO\rwqg\RI!enjaXOG@Ya_YRKD=RVTPKE@:QLKHD@;6JDCA>:62B=<:851-;77531-*-,/37;?CIMNMKH--048=AHOSSQOL-.159>DNZc[VSO-.15:>EPay_XTQ--059=ENW][WTQ-,/37;BJPTUTSP,+.159?EKOPPON+),/26;AFIKLKJ)'),/26<@CFGGF'%&),.16:>@AAA            
		


	




 !"###" ! !"###""%"$%''''&&(&(*+,,+**,*,./000//--02455432.1468::9851:;;=??><9;DLUWUFDA=BHR\fovm`O  ?:62/+'%O<83/*&&]G0+'&pZ(o{ux{~mqtvv~gjmcmtw}tvv~xEcmtwsECfmpr  EDLUWUFDA?=HHR\fovm`O<KLVbo~LNYeuLOZfuLNYdp|KLV`jszIIR\dlsy}FENW_flrw{BBKSZ_fkpux  _flrw{\_fkpux[[afknq   kpuxhimqhCgj                                                                         	              	              	                                
    
      
   	    	       
                                                                               	              	              	                                  	     "  
$  
$  
#  !                                 	              
             
             
             
             	                                             
   
   
   
  !  #  
$  $  #  !                                                                                                                                                                 
      
   
    "  #  #   
!   	  6;@EN]\f9?EK]lkX;BIQhoW 3L*                   ,036797(,.0232'')+-..%$&*+,-88>ENXdrsg]78=EMWetvj`57<DLWdr}~ulc35:AKVbluywrke138AKU^gmqqnje117@JR[bhklkif107?HPX^cgiihf006>FNU[`dghhg0/5=DLSY^beghh/-3;BJPV\adgii-,19@GNTZ_dgjk+(/6>ELRX^cgkm        19@GN         /6>EL        $,4;BI       	")18?G       &-5<C       "*18@       &-4;GNTZ_dgjkELRX^cgkmBIPW]bhlo?GNT[agmq<CKRY`flr8@GNV]dkq4;CJQY`gn  .kD"H_}r~ 49=ADEGG7;@CFIJK9>BFJLNO:?DHLOQS;@EIMPSV:@DIMPTW9>CGKORV6<@EILOR38=AEHJL/49<@CEF\bfhhfc^[bgiigc]^ejmmkga_fknnlid^ejmnmjf]dhlmljg[afikkjgY_dgijihV\aehiihSY^cfhiiPV\adgijMTY_cgjkJQW]bgknGNTZaflpCJQX_elr?FMT\dlsCJQX_elr?FMT\dls:AIPX`ir6>ELT]fn
     
             
		
		  	
    

	    

        $*/
 	
                                      #)/49       %+17;       	 '-39>       
!(.4:?       
!(/5;@       
 '.4:@       	&-39>       $+16<       !(.38    $*/4 
( ZPG?;5/!]RIA:4" \RIA:5  XOG?99  RKD=99  LF@;:+  EA     j]Rj]Rf[Q^VMVOHMHCGC@                              	
	



 "!$&!$'*!$'*-#&*-0!$'*-#&*-0!%(,03"&*.26#'+048 JNQRSLPSUVNRUWXNSVXXMQUVVKORSTHKNOPCFIJL>ACDF9;=>@  69<>ACEJ9<?ADFHL;?ADGIJN=@CFHJLN>ADFHJLM=@CEGIJK<?ACEFGH9<>@ABBC68:;===>24567779,.00(3224567,.00&() ,.00&()	     &() 	     	
  		    	      :;AHLRX_9:?FMT[b99?FMU^e99=DMV_f97;DNW^e     	  2 
 9229BKSJG229AJREF217@HP?D106>FN9>       

   (03 "0/*- 	!		

  	                 "%                     	     
  
  
                                                                                          


	
%%%$!+++*'2210-88863?@?=:GGFD@OONKGGGFDDOONKJWWVSP_`^ZTfgd`Y                   	
!#$%% $'(**+%*,.001*/24677/47:<>>49>ADEF:?DHLNN<9>ADEFA?DHLNNDDJPTWXDIPW^bcHMU^gmn   	   
   	  
               
   	
                                 P  26:=?ADD26:>AEF<6;@DHR@:@FK@ >DK(    A5                      [ZVQKB:]\XRJA:`_\ULC;aa]VMC<aa]VMC<          ,)&#<  VRKD=<ZUS`YTd\We^Wd\V`YR  _`^ZVfgd`Yklid\mnke^klid\fgd`Y  &.7'09        "   
$            $(,059'(-15:'),059  (-15:),059*,048 "&*.26#'+048$(,059#%(-15:%(*,-.-!$&()) "#$$  !!  !!    #$+29@E#$+3:AF#$+2:AF   57=CHMP56=BHMO56<BGLO   CDHJLNOJEILNPQQMQTWZ\XTX\lrx^Z_c~a`ehaglphotwpw{~w}}   NONMJEPQQOLFZ\][WPrx~}uƫ}y  HC<751-,LF@951--WPH@83/@}ume^WRqxrnunk}qhkylbf{sf[_{tm_TX}ysmfWLQNMLJGEA<6gRNNLIEAMn_SSQgs|i{}z|yx{}|vsvwwy|}|{plopoprrqpidfggffffYa[]^^]S]Y.  |wpuqlhmiV`<Wn|{xuqpmlfgeWS[yB9z~TW~}|  ~{vyp{rlzsje|wpiX^uqlib7@ Q"H_}+9z~~   IJR^gvIIO[i{IHOu35:?B4 54:?D# 77=CH& 89?EK' 9:AGM( 9:AGM( 9:@FL( 88>DJ& 66<AF% 438=B" 1/49=     FHNSWYYEGLQTWWDEJORTU     %FA<62  "B=831   >:500IORQbTLCGIIZMI?ACCTHH   EHII>@A@89;?jmm1ill_ehhZ_aaSWYYLOQQEHII>@AChjPhjmmeill>@A899146        PRm          ;     =]  RR[a  )S\n  )Sl  )` ]Mu;;@Yqz<<ARduw<<@FNYcq<;?DJPS]       
  $!4  %F@:44      7i  Xvvsi  uvur  um WHY5:?Znh`X559Sf_XT534M`YRS Byyywtx HTyyw~ DT2Ba(+.mhc]W'(*fb]WT'&'a\WRSEbny Hlw  qy  yy  yz~  \}}   >>^Qj126113001   ,059,048-026048126113   klid\Ufgd`YR_`^ZTNWWVSNIUQNKHCRMHDA=[`lyS]htAOXgw~AAFKNQQ?AEEGHK0EEFFFF  9>CGKMM59=@CED547:<=?1035789QU[_`_\ORWZ[[XONRUWVU   ]dp|_an{_bo|]anz\_jv^eiqy2inqbQR TqqXMhp}sa]WejukYVQddoeSPN   JmvgYEe~wl_TB_voeYP   4~zuog1zvrmg`/tplga\   ?DA=.;-9   DA=;7(1) LNKHCFFDA=ED0;7  UQMHB= OLHD>: KHE@;8   3F73:7;:;<<?>0fz    3@@jwxu FCPzzy %GFt %JY %J| $[ 6f  VWVSNH OPOLHC IJIGC@   ~aCDDD fvi                -   3
  9-  >B DI: ^WT mxd/RVYZYVSW[\[WX^bcb^]chjhc_fkmkf_fkmkf]chjhcX^bcb^SW[\[WLPSSSPEHKKKH    
0-*&)  63/+-  @<84/. 7GB>83/8;>@2589,/1'   O 1iQX_eMTZ_HNSWCHLO=BEH8;>@=BEH8;>@25892589,/1
'), HLOPOKGB>835NRUVURNIC=78gkmmd[UNGA::|{n[SKD=;}uiXNF?<{uhZPG?=x~}reYOG?=)+/24) -+/36 1/48<@538>BGK77=CINR8OU[agkXcjpv|a`hov}^]dls{ZYahpx~  ^WT mxd/s|,/1')(!'   \dfggffX[]^^]SVQTUPWE   {tm_TM}ysmfWLIuqke^OCH  NKGC=9  GEB>97  CA>:56}yxuq  LPSSSPEHKKKH?ACCCA  /38=B" -/49=  -+048    }   ')!	   }ysmfWLDuqke^OC=lhc]VG5<c_[:87!(S[]^^NQTUBMJMC8 GC2    IQDBAA/ VsgOA?=:tttqc>:7uutqlgM7ttrojd^Urqokf`Z\nnkgb]VW"IKJHD?9!CDCA=97!??><95627=BEEC/27;=></.36887   |gik   be|g  mxd/s|wyEHKKKH?ACCCA8:<<<<245569}yxuqplh~gc_O(     iORRR; lURON VNN öuHŲxR  b`\UPHBieaYPGBkyqtiJD   kpusncYmovumaXnrzyvcY   ic[TNjc\SMgaZRJ e_ZVic[Ujc\S_]Ze_Zic\   yl`K950.gQ4/.}qg\@4OGC?ylC?hty|zfKylà[FJMMty|z PW_ejnnOjflopP~   >:52/+@;62.!?;62.>951/;730/851//52/0$   Y\\\YTOY[]\XSNXxldU   {fYQIl[OH{iYNGf^TKEWSMGCLJFB?DC@<; biw~Y aftyq]dr}}rg1Y^ippib0XW]bb][0SNSVVSN*KGJLLJGGeloleZTdkolcWTcimjaVT   8=CINUW8msy8   ,--&'!&	   8:<<<24555,-.03 2455,-..&'!-wyxvx}z~kizplh~gc_|w^\X  |~wd`lhc]c_ZV\XMR~g|w\d`\X~|~wuabbQ .06=C$ .06<C$ ./5<B#    ??0# gCBFFt`FG#}eG#|}{t\#vwvsc0pqpncZ  OV]d;96LOW^420KKRY0.,   |yW9:zxudIwvurottsunpqqrmlmmlkhijig y}xSrx{{ywe+lqtvutG*jknqqbb8heikmBD8b_cfY14\Z^aG.1 PTao{o-OS`mzl,J=CJOS*   UYgxUWdtUUap~   /'	 5- 7#	 &!*$
-& 	.' 	.' 	,&
	  "	 &!*$
-& 	.' 	.' 	,&  4-
 I>3	 I>3
 H=2
 E:/
 @6+	 :0' 5,"
  "'!
	*$
,%
-&
+%
("	% 
!	$))$                                    

 	$))$  IIIGDB?:51KJJHFC>:51MLLKHE@<62MNNLJFB<73LNNLJFB<73LLLKHE@<62KJJHFC>:51IFFEC?<72/EBB@><84/,@<<<:740,);888630-)&  y}~}xGgrpmFVigg u|nrw|jdopuy  gow~ghnu|gThnrw| y~fuy}~}~?nqgrpq  w|ipuyhgmr$	  
    	                      9GA: 93  3-b_ZUOHASUQLGA:J=JE@:3   àgQ4}qg\wlbX}xof]T{y{{xtng_WNvnoomid^WPHkXddb_ZUOHA>0\\ZUQLGA::@7.'!  11*$	  ,'!
   WNRTJ?3	  PHMQG<1   HAGLC8.$	  A:AG=4*#
  93:@7.'!  3-511*$	  Q4/    g\@%bXXXM8*0]TUVLA52WNRTJ?42PHMQG<1/                                  
 

 "  )+/49=BGJMNLGB=9**.38=BHMQQMHB=8*+05:?FMV__VMF?:*,05;AHQ_ww_QHA;*,05;AHQ_ww_QHA;*+05:?FMV__VMF?:**.38=BHMQQMHB=8)(-15:>BFHHFB>:5''+.26:=?AA?=:62%$(,/258:;;:852/#"&),/24677642/,;62-)&"=83.*&!?:50+'"A;50,'"A;50,'"?:50+'"=83.*&!:51-($ 62.+'"2/,($ /,)&"                
      	
                       
   
  
  
  "
  &"D;9740 &"JC@>;84/+&!NJGEA=94/)$PPNKGB=82-'!VVTQMGA;5/)$\\ZVQKE>81+%aa^ZTNG@:3-& cca\VPHA:4-'!cca\VPHA:4-'!  =GJLNNBGKNPPGMQTVVKQVZ\\NTZ^aaPV\accPV\acc  $#',  '&+/4 *)/49=--28=BG./5;AGM/18>EKQ03:@GNT24:AHPV24:AHPV   2&CMOG =OLHQJCOSPMJFKE=    ? %FKIF2MJNOHC      -1 <>FKID                         !      +$
      5,#	     >3)     F9-"     J;.#     F8+ 
     #$(,"  &$(,$  )(,15+ ++05:?4--38>DJ.05<BIP/17>EMV029@GPZ139@HQ\139@HQ[  ?EIMOODJOSVVIPW]aaMV_hnnPZeqyyQ\hu~~Q[gs{{  `t|N`Y   531/+(G/<:740,NFC@=951OMKGC?:5VVSOJD>8aa]WPIB<nnh_VME>yyqeZPG@~~uh\QH@{{sg[QH@}}|  y~w{y}{z{~ }wy}ueq                       	  *)(%#                                                                    	
                                                          >(%"!ROZPE2,          
  # +  D>82++                 4.)#jc\SLFgaZRJCb]VOHA[WQKD>SPKF@:LIE@;6~}z   V\]\YTNRUVURNIQOPOMIF   Zw uu yqwwu pk:<<   |x}ww      PW^addOW^cffR[bhllT\dkooS\djnnQY`fiiMT[_bbIOTXZZCHMPQQ>BEHII=ADFGG              

    (!  $3,$  +=6/(  2G@92*  @JC<5-KF@:E@;6>;62951-51 , +   >;62751-5%,(51-,(

#  OIDE  RIFD  UKKJ  WMOP  WMYU  V?YI  4/QK    (+$  2+$   ,7/(!   H=3,$   6MA7/(   TG@92*  OIC<5-     
            3*" 2)! 0(    DIJGD?;5CDDB>;62CA?=:73.        ''#  ('%!'$  ()26.'  1@@91)  7;C<4,  =6/(!  :4-&   81+% &10/+'! 441/-*% 
76>7/) ><;93.  E@;50*  A<72-'  =94/*%.06</  //5<   017=!  028>!  /28>!  /17=!  //5<   --39  ++05  )'-2  %%*.     Bz Oy  j}  [j~  [Zg~  DYY`|   ,,?V^Fx}8Fq77^   SPKFLIE@GC>;C?:5iWXWYXi,XWUSoz AUUNGQXXVQJDLOOMID?KHIGD?<   5;AEGEA26;>?>;0369:98   :>;775762   qupg iwof *zri  ftj  &tj   [i   G       

    
 "   	
      

  Ĺĺźź      :4.                                        mbWLncXModYNN   ?   >   >   =   <   :=83.)#        ùxźyƼzHC=83.)#xmbynczod)#ƼzHC=83.)#zod)#cHC=8                                             þÿ¿ý   ýȼù  斛Еm                               ȼùĽ                r                  .38:99987540/49:997643439?A?><97556?FHFD@<:768AHLIFA=:866?FHFD@<:7439?A?><975   ),(.,3.7/8-5+2  # !$#(%+ '.!'/ '.%+ 7655476544=;976C?<:8EA=:9C?<:8=;976 13566532468764358997547;<<965:?A?;75=CFD>8  24677642579875469;:8648<==:76;?A@<86=CEC>9  !'-2458973#)/489841%,28=?=85 '.6=CEC=8!(/7?EHE?9 '.6=CEC=8%,28=?=85
  %,4:?A?;7$+3=CFD>8 &-6?IMI@9 '.7BLQLB: &-6?HLH?9$+29?B?95!'-26762/"',13541- 
 !!  &-5;?A@<8%,4=CEC>9 '.6?FIF?9!(/8AHLHA: '.6?FHF?9%,39?A?96"(.368630#(-24652.  T               T             T  ] 	
K˿  sƻ      1  ]    IHE  >@395. "ŽûûqjOJE>,9IIKKLLNNO{qtjqjOJEKLEF>@,9   L   1a^[{  2b_  Lc_  ec  e}÷ dƻcɽcc˿c»ļĽŽŽŽ ŽĽļü»ļûǿ¹Ž   ž   |     y   M  m  žm M  m  ! _ ~}zxwusqRonljhigfdbba`^\\[ZXVVVUTR \[ZVUTTTT                                                                     
               1              -)	             (%!            $!                                       
         	          
                                        ¾mprtuuunqsuvvvoqtuvwwoqsuvwwnqstuvvmoqstuuknpqrssiknopqqgjlmnoovmd[Twne\Uxof\Uxof]Ixof\Dwne\Dvmd[D}ulbYC{rj`WAyqh_V@DEFGGGGGGF_ea]YTEFGHIIIIHGjfb^ZUJLMNNOONNMsokgb]PQSTTUUTTS}yttlfUWXZZ[[ZZexo[]_`aaaa`zacefghhggjlmnoonynprtuvvzrktwz|}z&{~/¼u#qE    RUWYZZYWU)     VRMGD?:5ZUPKE@:$b]XTMH* lfa_^Oxojh`zrq.}J
yQ
rk
z&			
/		
                                                                                        B=8&         B<72,'"        A;61,&!      @:50+%       ?94/*$      =83.)#      <72-'"      ;61+&!        :50*%             
                                 	$!&          (%" .        .,)&#!*'     520-*'%&#   -9641.+(" !@=:852/,GDA><963
BLHEB@=: 
VPLIGDA.  HGECAz ~~~}9~~~z  "~~    }vpjd]WQJD=63{uohb[UNHA;6zsmf`YRLE>:~wqjd]VPIB<|unhaZSMF@   ` {          ˿ɽƺ÷οɻĶͿǹƺ̿ƺ̿ĸȼʿqqAø =<\}  87n}x                                                                      T   q RUWYZZYWU)                "~~}       
 $%).14554   !',145642   %,26:;<:7  #+28=ACCA>  '/6=CHJJHD  !*2:BHMOOMH  "+4<DKPSSPK  #+4=ELQSSPK  "*3;CJOQQNJ   (08?EJLLJF  %,4:@DFFD@  	!)06;>@A?;2/+%	42.)$
 :73.("
A>93-&	HD>81*"MHB;4-%
PKE=6.&
PKE>6.&NJC<5-%
JF@92+#D@;5/( 	?;71+%                                                                                                                                                
                                        	            	                                                                                                       Z`fjlnmkg    RY_dhjkkhe   JQX^cgiiifb  3IPW]bfhhgea  +?GOV\aeggfc_ #5=EMT[`dfgeb] 
*3;CKSY_cffd`['08@HPW]bddb]X$,4=EMTZ^aa^ZT (08@HOUZ\\YUO#+3:BINSUURNI%,4;AFJLLJFA%,38=ABB@=8 	$*/368863/%,38=ABB@=8 	$*/368863/  #(,.00.,(                 kgb\UPL   he`ZSLGB  fb^XQJB=9
 ea[UOG@951c_YSLE=50-)b]WQJB:3,(%`[UNG?7/($!]XRJC;4,$ ZTMF?70( UOHA:2+#NIB;4-&FA;5.' =83-' 
3/*%=83-' 
3/*%,($
     {ɿ   rlf`ZTNH    ?           ?           >           =   G~{;    ~{݋:    E}zۉ8                0dhloq   0dhkoq   0dgknq{xumo{wtknzwtik   gj dgjmpdhknqdhloqdhkoq   j?            @            ?            ?              c  0d  0d  0dPPSTVW,]VXZ\]/ym^`bd2gij5:q9"x|                }} "%                             "FGIJK8%KKMOPQ) NPSTVW, SVXZ\]/ i'%	     l)&	     ^.       rlG=>?@AA:Z@BCEEFF?"FGIJK8%17KMOPQ)              ?=<:DCA?$6FE &LJ )RO ,WU /]Z 2c` lw}'                     AAAA@@?FFGFFED8%%%%$$)      ,      /       XY[]^_acddgjijnpoqtwuw{~x}~ch  q   RFEB@LJHGROQOWUWW]Z^^c`iew}um|[              ->?ACD  ?ACEF   DFHJL<:8[NPQA?=;nSUWFEB@+Y[]LJH4_acle^XRLG   +SMH   ,SMI                                                      $GDB?<9    @k~xrmg   Uxrlg  Ӝg   
mwmcZPGyrkd{tmf|umf}ung}ung|tmfzslexqjd(}vohb  Jztmf`  Ĺ   B<6   B<6                                                                            @xU5      ><tg*'   ,8YSMHr!            O$             U             "                                                                                                                                                                                                  7  :   .                                                   &JGEB?        Ġ   Xz䣨§uĨ G;?CFJMPSUWXY        TVWX        RTVW        QRTU        NPRS        MNPQ       2344y        &456        :;;      MRV     

V[_͹    	Ldhĺ    @mr   
Fv{¹   
    	
"] %c   #'J      
%).        
!0                l^r:ĺ?C¹hH][YVTQNa_\YVSeb_[Xhea]Ǳjfb̦|xtpQ ׯ{X                                                                                              
              &             "                                                                    YXXXWWVVUTS     \\\\[[ZYYXW     baaa``_^^]\     gfffeedccba     lkkkjjihhgf     qqppoonmmll     vvuuutssrqs     {{{zzyxxww@     ~~}|}Z   JK   ;Qa   *Va
-a`      	ATSR   1djosttrnXWV  Gchloqpnj]\- B[afjmnmkhba0<TZ`eiklkiegfLSZ`ehkkjhdllCKRY_ehkkjgbqs9AIQX_eikljfaw@/7?HPX_ejlljf`}Z,4=ENV^ejmmje^ejohKT\djmmic\afka>GPX`gjjf_XafZ1:BKS[add`YRae$,4<DLSX[ZWQK`*&-5<CIMPOMHB&-39>BDDA>9&-39>BDDA>9
$*/368863/ 
#),035541.rnhb\W     nje_XR9    khc]VNH2   ie`[TME?,  hd_YRKC;6& gb]WPIA92. fa[UNF?7/*'f`YRKC<4,&#e^WPH@91)"c\TLD=5-%_XPH@81)!YRJC;3,$QKD<5.&SMHGHB<5.' 4~~>93-' )~~   >93-' )~~3/*%
"~0+'!
_   444..-'''"!           } ʡ   VXZ[[[ZXWRMOPPQQPOMIGHHHHGGFDBABBBBAA@>>==>>==<;:9  |WSOJUQMHRNJF  :512              p      ½üž       zO    (   DEEE;<<<2233())*&'''LJHBA?976/.,-+*      $(!%!    r 9¸¹~w|tnytmh|xtzut    ٬                                          0ׯ{X                        `^[XUQNLMMMNPQRRSQNLJHFFGGGFFGHHOMKIGEDEEEEEDDEFRRRQPNLJGD@<852/HHHGFECA>;740+'#EFEECB@><963/*&!2/,($ '# 



# 
	 	
   


	    



]{{|~1[knqsuwxxxxwvtr01^adfhjkkkkjige0-QTWY[\]^^]][ZX-(7GJLNOPQQPONMM($+<=?ABCCCCBBCD%! 32245666678:;trqqswz|~~gebbfiloqrsttsrqZXWWY\_aceffffecMMNNNORTVWXYYXWVCDDEEDEGIJKKKJJH:;;<<;;:;<=>==<;ztpmhd_}xsmifb^ZU~|zwsokfa_\XTPLrqolifb^YWTQNKGBeca_\YUQNLJGDA=9WVTQOKHFDB@=:73/JHFDA><;:8630-)&<;974321/.+)&# d_ZTNHA;851.+'#!ZUPKE?9520-)&#PLGB<620-+(%"GB=93/-+(&# =94/+*(&#!3/+'&$" )&#"!
 
#!  


  
	        	

	
	
	
	
	
	
	

  $!(&,+0055:9@;F?KCQFVHZK^MaNaOdPgPhPjPjQjRkRlRlRlQlQmTqWuYu[x\{          	


	  	

	      	    	


	 	

	



 """ 
#&()(&#$)-/0/-)$"(.36763.("%,28<><82,% '.5<ACA<5.'  '.6<BDB<6.'  &-4:?A?:4-& $*069;960*$!&+03430+&!"&),-,)&" #%%%# "&),-,)&" #%%%# 	   

  

 		


  	
"%' ' & $!
	
 
 	
T  T       sƻ           1             SD                                      8           ƻ S  $h|    >{             :       >        m       :5       ՝    =g   	3  Aď  

\  C¼* ½z 

l&	
b
 		U
 		U       F|         }zw         ?}zxur          xuspm          Vpnki          lifd      Rhd`                                   &    i !!~{|yvwtrrpmmkhifcda_`]Z                                                                                                                                                                                                                                                                                                                                                     

	     

	    
	    	    
    	    

    
     			      g   j    j       "}        `}{x        =xvs         sqp         6lk    gf II     



    
   


    
       &$$"
+**'$ 10/,)$	5430,'!6763.)#7873/)#6652-("321/*% 
.-,*&")''%"#!!

	  !!
 
	 
	  
   	

	                                             


	



!"#"  #&(('%"#(,//-*%!!&,2895/)$"(/8EK>3+% #(/9KUA4,% "'-5>A91*$ %*/341,'""%)+,*'$ !$%%$" 
  	  	
	

	




	 				  	   	


	  



    



	
	
	
			            
 


	 	

	
                                                  j	


	:
IO߲!S#!Ԭ&%# þQ&%# ß$%$"I"#" <z<lz%.%


                  	


                                           


	

   !"! !"!  ! 



	 	


	                           



 #        &!        *$	        .'!
       1)"       1*#       0)"       -& 
        (#
	        $           sG6;?                   "	         $  	G)#
  ).26;,& 	        .'!	        /(!
        -' 	        *$        &!        #
         	         #        '"
        ,%	        /(!
        0)"
        0)"
        -' 
        *$        '"         	         #        '"
        ,%	        /(!
        0)"
        0)"
        -' 
        *$        '"        








	
	  IKMMLJGC=6/QSUUUSOKE=5[]_``^[VOF7dgikkjf`X4&mpsuvuq^60*tx{}~O?:4-{~`BDB<6.oI<ACA<5.,39>@>93,     #%%%# "&),-,)&"!&+03430+&$*069;960* &-4:?A?:4- '.6<BDB<6. '.5<ACA<5.&,39>@>93, n0"$&'&$"p\HIJ'('%"qsttrojcO<4qstutqlf]TIoqstsqmf^TIknpqpnjd\RHehjlkjf`XOE^acedc_YRI@VY[\\ZWQKC:PSTUUSPKD=5  "'*,-,*'""'+./.+'"!',26862,'$*19@D@91*%,5?JPJ?5,&-5@MTM@5-%+3<FJF<3+"(/5;=;5/( %*.232.*%!&),-,)&!  &$(,.//-*&*&(-011.*&-*-37:950*/-29?BA<5.//5=DHFA91//5>EIHB:1/.4;BED?70.,06;>=93-,(+04552-(($'+.//-)$#"$%%$!'#%)+,,*'#+'*/2431,'-+/49;:72,.-29>A@<5/..4;ACB>70..3:@BA=70.,17<>=94-,),25774/*)(-14653/*	





 #%%%# "&),-,)&"!&+03430+&$*069;960*  4:?A?:4-  -*069;960*//4:?A?:4-.06<BDB<6.,/5<ACA<5.(,28<><82,$).36763.($)-/0/-)$#&()(&# """ 


$ #%%%# )$&),-,)&"-)+03430+&/,069;960*0/4:?A?:4-006<BDB<6.005<ACA<5.0.28<><82,.+.36763.(+&)-/0/-)$'!#&()(&#" """  """ 	


	


	                                    



	"$%%$! %)+,,*'#  *'*-.-*'# /)+.//-)% 2.15663.)#
426:<<83-& 	549>A@<6/(!
55:?BA<6/("
548<?>:5.'!
4038:961+%	1,.1320,'",'*,.-+(#    
 %),    	#',/   !',25	   $*17<
   
%,3:@
   
%,4;A
   
$+29>	   ")/49    
%*/2    	"&*-+-.-+'#

,/00-*% 25774/*$7<>=94-' :@BA=70)";ACB>70)"9>A@<5/(!49;:72,%/2431,'"

*-..,($#'),..,#',/00-!',25774$*17<>=9%,3:@BA=%,4;ACB>$+29>A@<")/49;:7%*/2431"&*-..,  P

h9


khe`74"lkhd_YSKD'mljgc]WOG?mmlifa[SKBlmmlie_WNDjlmnlhbZQFgkmonke]RH>Dlnomg^SG:0[lmke\QE>0@fgf`WMA0.2T^]XPF<.+.;SQMF>4+&)-AEA<4,'!#&-:61+#$)-AEA<4,#&-:61+# "++&!  #%%%# !&),-,)&" &+03430+&%+069;960*).4:?A?:4-/,069;960*//4:?A?:4-.06<BDB<6.,/5<ACA<5.(,28<><82,#).36763.($)-/0/-)$#&()(&# """ 



	


		                                                  	
	



	
"$%%$! %)+,,*'#  #"$%%$!'#%)+,,*'#+'*/2431,'-+/49;:72,.-29>A@<5/..4;ACB>70..3:@BA=70.,17<>=94-,),25774/*)(-14653/*fegjh9lkhmlkmmllmmjlmgjlTgkA>D  f1 eI.d_Z`\X\XTWTPQNKKIEEC@A><  159>AE26:?CF36;?CG26;?CG26:?CF049=AD/37;?B-058<?+-259;(*.257%'*.13!$'+-0>:51,(;73/*&840,'#41-)%"0-)&!,)&"EGIJKJIFC@<72-*FIKLLKJGDA<83.*GIKMMLKHEA=94/+GIKMMLKHEA=94/+FIKLLKJGDA<83.*DGIJJIHFC?;72-)BDFGHGEC@=950+(   )/5;@FKNNRVY[]]&+06<BGMQUY[]^['+17=CHNRWZ]_d_',27=CINSX[^chk',17=CINSW[_ejn&+17<BHMRVY_ejn%*/5;@FKOSW]din$(.39>CHLPTZafk#&,16;@EILPV]bg $).38<ADHKQW]a!&+/48<@CEKQVZ#',047;=@CINS $)-0479;>CHL YXX[YW_ZXkiInp\nqsnqskoqgknaehZ^aSVYLPS -3:@FLSVV[`dfhg+/5;AHNTZ_cfggf+06<BIOU[`ehiih+06<CIPV\afikki+06<CIPV\aeijji*/5;BHNUZ_dghhg).4:@FLRX\`ceec(,28>DIOTX\_``_'*05;AFKPTWY[[Y$(-28=BFKNQSUUS"%*/49=BEIKMNNM"'+049<@CEGHHG$(-159<>ABCCB dbbfc`hebifJieIgd_c`\_\XYWTSQNMKIGECBA> "&*-0367:?CF!%)-158:<@EJN %).2:==@CINSW #(-;DEDDFJQW\`-&:IJJKKKLRY_diLMNNOPPQQQX`flpQQRSSTUVWW^flrwTTUVWXZ[[\cjqw{VWWXZ[]^__fnuz~XXYZ[]^`abgovsmXXYZ\]_abcgjkkiWWXZ[]^`abeijjjUVWXY[]^_`dghjlRSTUWXZ[\]`cfjlE>PQSTUVWY\_eil   1>PQSTUVWY\_eil&*0ANOPQQTW\bfj#(-28DJKKNRY^cg"%*/49=CEIKMT[d"'+049<@CEGHHG$(-159<>ABCCB  FIKNQSW[]`dgimpptxw{~{~{meaifbjjgllklmllmm   lmmjlmgjldgjGTgBA>  !$'+.03567887#'*.1469:<=<< "&*.258;>@BFBB#%)-26:=ADFINIH%(,059>BFJMQWQO'*/38=BGLPTZaYW),16;@FKQW\ckc`*-28=CIPV^enwok+/49?ELS[dny~w+/5:@GNV_iv,05;AGOW`lz,05;AGNV`ky+/4:@FMU]gr~~+.39>DKQYaiqvvq)-27<BGNTZ`fiif   )-27<BGNTZ`fiif'+05:?DINSX\_^\%)-27;@DIMQSXUS$&+/37<@CGJLOML!$(,047;>ACEFFE"%)-147:=?@AA@  766<:;B@@HFFOMLWTS`\Zke`wnevkzoyo~rkqief`^   f`Z\XSSQMLJIECC@?>  4<GQZahmu3;FPY`flt09CMU]cho-5?HPW]bh*0:BJQVZ_%+3;BHMQU &.5<BGJM 7BKT\chklsy}2:DNV^diqw|4;FPY`fltz4<GQZahmu|4;FPY`fltz ~zunf_\[VNE<2~ysld]WPH>4*|vog`ZRI@6,~xqha[SJA7,|vog`ZRI@6,   xqha[SJA7,vog`ZRI@6,rkc\VOG>4*kd]WQKC:0'b\UPKD=5,#XRLHC=6.&OIFB=71)!  QSj}|ssppV]beeb]YRKD=6jlople`YRJCDG|tic]a^[Y|}|tmhd`\YWsvxwtlfb_[XURrtutohca^ZWTR  3:GNYWWURPQOTSmxwutV]beeb]YRKD=6mopple`YRJCDG|tic]a^[Y|tlgc_\YWwvxwtlda]ZWTRttutoga`\YVTQ  3:GOYXWURQPOa_^\WQKKKKKKKKske`YRQPOONNO{oe\YWUSSRR~qf`\YWVUU{me_\YXWW~of`\ZYXXxkc_[YXWW{mb^[YWVVVri_YWVTTSSTria_ZSOPOOOOPP  >DCIGOKTMWNXLVIQEL@FDIMOPNKGB<72-IOTWXVQLF@:4/OV]bd`ZRKD=71T]goqlbXOG?92Wboz}ui\RIA:3Xdq}xj]RIA:4V`luxqf[QH@93QZbijf^VME>82LRX\][VOHB;50FKORRQMHC=83-  -(/)1+2-3-4.3-2,0*-(QVYZWSROH?6-LRWZYVQJB9/&NUZ]\YSLD:1'OV[^^ZUME;2(NUZ]\YSLD:1'JQVXXUPIA8/%EKPRQOJD<4+">DHJIGC=6/'7<?AA?;60)!158:9840*$X_dfd`_\TLB8RZ`fec^VND;0U]djhf`YPF<2V^emjhbZQG=3U]dmhf`YPF<2QY`ida\UMC:0LSZb\ZVOH?6,EKQYSRNHA91(=CHOJHE@:3+"7<@GBA>94-&25899751,'!9=@BB@<83-' CIMRSLGB<5.'NU]cfcRKD=5-XbowzxhULD;3aqu]SJA8kfZOE<vocWK@~vj^RF|pdWKui\Pzm`Sˮ}pcVմreWضseXضseXѲrdWǬ}obUyl_Rth[N~|obUIuvh[ODj}m`UKA`o}dZOF=Vbozo[RI@8MU^gkm\QIA:2CIOUYRKF@93+:>BEFC@<71+%-145530,'"5:=@><94/("@EJPPGD>81*"JQY^a^NHA:1)T^flopiRJA8/^iry|}{pQH?5gs|sND:o|tH>ytAtzTp~ZCht^I?_ku|~`ND:U`iptvu^OG>4JS\bfhXMG?7.@FNSWOHC=6/'6;?DC@=93-&').38<%',159"%*.26""'+/3!$(+/ $'+FC?;72C@=950@>:72.=:73/+9630,(42/,)%1/,)&"  *+059>AEGIJKJIFC+,16:?CFIKLLKJGD+,16;?CGIKMMLKHE+,16;?CGIKMMLKHE+,16:?CFIKLLKJGD**/49=ADGIJJIHFC)).37;?BDFGHGEC@FC@<72GDA<83HEA=94HEA=94GDA<83FC?;72C@=950  )1<FOW^dlt(1;ENV]cks&/9BKSZ_go$+5>GNTY`h"'09AHNSX_"*2:AFKOU%-4:@DGL  yqje^ULA7wpid]TKA6sle`YQH>4le_ZTLD:0c\XSMF>5,XSOKF?7/&OKID?92*! -7AJRY_bcjrx}(/9CLT[`hpv{)1;ENV]cksy~)1<FOW^dlt{)1;ENV]cksy~ {vohee`XPG<~ztmfaZRI?5}wpid]TKA6yqje^ULA7}wpid]TKA6   /8BLT\_`dfd_X/0;DNV^cef`ZR02<FPY`fhjd]U03=GQZbhjme^V.2<FPY`fhmd]U-0:CMU\adi`YQ,,6?HOVZ\bZSL)(19AHNRSYQKE$"+3:@EHJOHC=&-49>ABG@<7  %-6?HORSWZYVQ$&/9BJQVYZWRL%'1:DLSY\]ZUN%(2;EMUZ^^[VO$'1:DLSY\]ZUN#%/8AIPUXXVQJ""+4<DJOQRPKE '/6=CGIJHD>!)06;?AA?<7$*0489:851  $+16:=>A<83&#*28>BENLF@;-*3;BHN]_[UME41:CKRiomibZO97AJSq|}{voeZ==GQvzpdAALwylBDwuBu Q=R}:?Wt8<F[wk87AK]|~wnc42<EN]uwvsldY.,5>FMYiie`XO(%.5=CIQZWRKE"&-39>BFHC?;$*/3688740   %#)/59=@AB?<7+(/5<AFIPMHD>1/6>EKQ`b^VOH75=ENVhvupg[R<:CLV`wxi[??HR]iveCCMXdrpEFR_lyzELXerJP]jwNTan{»QVcq~ƶSXerѽTXesԿTWdq˺ RWdq˺OUbo|ƿLR^kwGNZfs~AIUamy=CNZfsz;>HS^kq::CMVa{xf76>GPYoxj]208@HP]opme[S-*29@GMU]ZTOH'$+17=BEIIFC> #).37:<<;84   YSQlj}|}vssspp  ;6=DKRY]beeb]VNGDCJRY`elpoljWY[^a]cit|UWY\`dhmt|}|PRUX[_bfltwxvsPRTWZ^achotutr1:3XNGVWYSUWOPRNOQ  YSTomvwxttu  ;6=DKRY]beeb]VOGDCJRY`elppomXY[^a]cit|UWY\_cglt|QRTWZ]adltwxvwPQTVY\`agotutt2:3YOGWXYTUWOQRNOP  ID>OICVOG]TKbWMdXN`VLZQIRLEKF@  (-27<BGKNPOMID)/4:@FLQVXWTOI+17=DKRZ`db]VO-29?GOXblqog]T-3:AIR\iu}zobW.4:AIR]jx}qdX-39@HQ[fqxul`V,28>EMV^fjibZQ*05;BHOV[]\XRL(-38=CHMQRROKF(-$)/&+1'-2(-3(.4(-3',2%*0#(-  GOONNNNNMQW\^_`SRRQQRSSTY`epzVUUUUWX[]fs~WWWWXZ]agsXXXXZ\`em|XXXXZ\`fo~WVVWX[^cjwTTTTUWZ]akxQQPQQRTUW_gpxMLLLLMMMNSZ_abr:;BHPX`ir{~wne;<CJQZcmw|rh;=DKR[ep{uj;=DKR[ep{ujne\TLErh^UMFuj`WNGuj`WNG|{vnv{|yflopn^bdecVY[[ZNQRSRGIKKJBDEEE  `beghfd`_]XSLF@:b`cfggfc_ZTNHA;5Jbehiihe`[UOIB<6 Jfikkifa\VPIC<6.Ieijjiea\VPIC<6Z_dghhgd_ZUNHB;5X\`ceec`\XRLF@:4TX\_``_\XTOID>82PTWY[[YWTPKFA;50KNQSUUSQNKFB=82-EIKMNNMKIEB=94/*@CEGHHGEC@<940+'<>ABCCBA><951-($710-;5/+<60+<60+<60+;5/*:4.)82,(50*'2-($/*%"+'"($WX[]][YWUTPKF@;5XWY[^][YUQMGB<60IXZ_d_]ZWRNHC=71Iikhc^[XSNIC=72H\pnje_[WSNIC=71tsqnje_YVRMHB<71tsqnid]WSOKF@;5/sqokfaZTPLHC>93.pnkgb]VPLIE@;61,jhea]WQKHDA<83.)ca^ZVQKEC@<84/+&[YVSNIC@=;740,'#TSPLHC>;9740-)$ 2-+)60+&71+'72,'71,'71+&5/*%3.($1,&#.)$ +&!'#$ D>?@AA@?=:741-)%JCCEFFECA>;740,(PIJLMOLJGC@<73/+WPQSUXSQMID@;72-^VX\^_\XSNID?:50e^`fiif`ZTNGB<72jeiqvvqiaYQKD>93kjr~~rg]UMF@:4kmyyk`VNGA;5mozzl`WOGA;5omvvi_VNG@:5mhnw~ynd[SLE?94haekowne^VPIC=82bZ\`ckc\WQKF@;61[STWYaZTPLGB=83/IPTWYaZTPLGB=83/CIMOQWQMJFB>950,BCFHINIFDA=:62-)B@@BBFB@>;852.*&@;:<<=<:9641.*'#;6678876530.+'$!)%",($!/+&$2-)&50+(72-)93.+:4/+;50,;50,:5/,94/+82-*61,)3/*'3/*&0,($-)%!*&" '#$!S>ABCCBA><951-($kgTGHHGEC@<940+'ljgd[TMKIEC=94/*mljgc^YRNKKJD82-mmljfb\WTQQPONA0lmmlie_\YWVUTSQPklmljfc`]\[ZXWUThklljhgd`_^][YXW9hjjjjieba`^][ZX($+'"/*%"2-($A0*&QP>1UTSRXWVUZXWWhklljhgd`_^][YXWdgjjjjieba`^][ZXbcfikkjgcba_]\ZYbbemsvogba`^][ZYTr~zunf__^][ZXWXWVUZXWWZYXXZYXXXWWVeaemsvogba`^][ZY,{~zunf__^][ZXWo{wqjc\[[ZXWVU~{wrlf^WWVUTSSR{xtplf`XQQQPPONNspmid_YRLKKKJJI:igd`\WQJFDDED;-(_][WSNIC@==:2.)%USQNJE@<:851-)%!MKIFC?:7630-*&"ZYXXXWWVVUTTSRQQNNMBI:&#-(# )% %!"JUJPy QR\ix SY`gs|hhnty}jkqv{~llrwz}~lPdvyzoA5V;M\['V;==@6           {?  _]{__g^rm    !Pgb?bmf~f@CF68;--/$$#nty}bgkpUZ^bHLQUutthhg[ZZNMM  yyy  )&",)%!1,($ 71-)&">851-)$"E?<84/*%(LFC?:50+.QLID@;613RQNJE@;64TVRNJE@:6WYURMID?:Z[XTQLHC>\\ZWSOKGB]\[XUROMG]\[YWVVTN\[[Z[\\[V[\[YWVVTYZ[[Z[\\[aXZZ\_acciUXY^bfjkrRUY_ekquNRX`gpyJOV^grEKS[epBENV_jwA?GOXbmw<8@HR[dkv42;DLT\aj/.7?FMTX`,*19@FLPW(',39?DHO%#&,28<@G"#&,159=@   
 %(+-.-*'" %)-//.+'"

:>BFIKLJE?7/'\_beghfb[QF;/[^behiie]SH<0X\_cfhgd\RF:/TX[^acb_XNC7,
NRUXZ[ZWPG=3(HKNPRRPMG?6-#BEHIKJIE@90( 

"'*-" %)-//'#).36;/$ &-38<<0$!(/6<@:/#"(/6<A7,!!'.5:>3(%+169-#
"',02(

#(+-,--,)% 
   -//.+'"	   36651,&!  8<<:60*#  <@A>92+%
  <AB?:3,%
  :>?<81+$  69:83.("  0231.*$
   +-.,*&!
             $   
 '   
")   
")   
!(   	%   
"     1+.IUZ_RX\OTXKPTFKNBEI<@C9<>  $)-0111/+'!&*.110-(%$)/47751,)'-4:?@=71-)08@EGC<4/*1:BHIE>5/)08@EGC<4/'-4:?@=71-$)/47751,)!&*.110-(%,..,)% -00/,'#47752,'!9=><71*$=AB@:3,%>BCA;4,%<@A>92+$7:;94/)"1342/*%

,..-*&"   %),..-+'# %*-00/,'#$*/47752,'! '-49=><71*$")07=AB@:3,%")07>BCA;4,%!(/5<@A>92+$%,27:;94/)""',1342/*%$(,..-*&"       
	       
   	 
   
!
   
"
   
!   	
    	       %),-.-*' %)-//.+)#).36651. &-38<<:62!(/6<@A>94"(/6<AB?:5!'.5:>?<84%+169:830"',0231.,#(+-.,*'$*/35641-($*/47752,)'-49=><71,)07=AB@:3.)07>BCA;4.(/5<@A>92,%,27:;94/)"',1342/*%#'*,,+)%"!$%%$"	




                                    		


	




 """ #&()(&#$)-/0/-)$$(.36763.)(,28<><82,+.5<ACA<5/,,28<><82.,.5<ACA<50,.6<BDB<60)-4:?A?:4.&*069;960+"&+03430+&"&),-,)&! #%%%# 

  !&++" (#+16:-&#!/,4<AEA-)&14>FMQS;.)4<FPX]^T2,:AMW`fgf@/@EQ\ekml[0CGS^gmonl>$*/35641-($*/47752,)'-49=><71,)07=AB@:3.)07>BCA;4.(/5<@A>92,%,27:;94/)"',1342/*%#'*,,+)%"!$%%$"	




                                    		


	




 """ #&()(&#$)-/0/-)$$(.36763.)(,28<><82,+.5<ACA<5/,,28<><82.,.5<ACA<50,.6<BDB<60)-4:?A?:4.&*069;960+"&+03430+&"&),-,)&! #%%%# 

 """ "#&()(&#!%$)-/0/-)&&(.36763.)(,28<><82,+.5<ACA<5/,.6<BDB<60,-4:?A?:4/"'*,-,*'""'+./.+'"!',26862,'!$*19@D@91*$%,5?JPJ?5,%&-5@MTM@5-&%+3<FJF<3+%"(/5;=;5/(" %*.232.*% !&),-,)&!  )-4:?A?:4 &*069;960*$"&+03430+&!"&),-,)&" #%%%# 



 EGS^gmonlD>DHR]eknomkgCFQZbhlnmlj@DNW_eilmml?BKS[afilmm>?GOW]cgjlm<'DKSY_dhkl"47`ehk


9i 








  +18=???=81+&,39>@>93,&'.5<ACA<5.''.6<BDB<6.'&-4:?A?:4-&$*069;960*$!&+03430+&!"&),-,)&" #%%%#      +18=???=81B&,39>@>93,'.5<ACA<Io'.6<BDB`~&-4:?O~}{x$*06^quvusp!&4X`fjkkig#7FOV[^``_]-5=EKOSUUUS'/6=CGJLMMK  "$&'&$"0"%'('JIH\-4<Ocjortts>IT]flqtuts>IT^fmqstsq=HR\djnpqpn:EOX`fjkljh6@IRY_cdeca0:CKQWZ\\[Y,5=DKPSUUTS                                                         E       D       C       C       B~}       A~}{       @~}|{z       ?~~}|{zyx                     ~  }  }|  }|z  ~}|zy  }{zyw  {zxwu  yxvus                   	

	            [`cfhiiheI BT                   :;>@BDEFFFFECA?<?:<>ACDEFFEDB@= D?@CEHIJKKJIGDA FDEILNPRRRQOMJ$  FGKORUWYZYXVTQ  G8QUY\_aaa`^[N78 [`cfhiiheI BTN                            	             	                        	           	           	                       	            	                                           
                        
      
      	      G-17"                                                  4<GR]it5=HS^iu5=HS^iu5=HS^iu         #         !&         	$*        
!'.        ")1        #*1        ")0         
 &-         	
#(          $  L# L3KC;                 	"3	  $C;62.)  
#)        	 &,        	!'.        
!(/        	 '-        $*         !&         
#           "'         $*         
 '-         
")0         
")0         
!(/         	%,         
"'         #            "'         $*         
 '-         
")0         
")0         
!(/         	%,         
"'         #   {}=  <  :  󐗡v[_dhmrv{R           v{                                             {      {      ˚ėƼȾɿtɿ\&˿'!|zw"uspHHHGGGEEDD    6941.=     øĸ÷np¶nS`_ʿTVTSnLOPRSSTTSFIJLMMMMMACDFFGGGG==>@@AAAA879::;;;;                                                   
      	           	          

                                           !$             !%(              	)-               1                
                                      LPU\bgkmnlj         ljf`Z                     !"%),/0/. 
$(,.00.,%*/368863
 '-38=@BBA= '.5;AFJLLJF&-4;BINRUUSN#+2:AHOUY\\ZU (07?FMTZ^aa^Z $,4;CJRX]bddb]!$(/7?GNU[`dffc_%(,3:BJQW]begfd`)-05=ELSY_cfggea159@GOU[aeghhfb 
9=BJQX^bfiiigc  BGLSZ`ehkkjhd   LPU\bgkmnljf,)$
      .,(#       63/*$	      A=83,%    JFA;4,%   SNIB:3+#	   ZUOH@80( 	    ^ZTME=4,$    b]WPH@80'     c_YSKC;3*
      d`[TME=5#      ea\VOG?+       fb]WPI3       gc^XQJ        hd_YR         jf`Z          26<B$'26<B                                                    247:=@C   Y^diotzA   X^cinL/  Xq;= EJPVsR9  ҸԹոոӷѶ     y ʾ˿_   νǹ  ն       IOU\gsIOV]htIPV]htIPV]htIOU\hsHNU[fr~GMSZdp|FLRXbnyDJPV_jvSBHNT[cflU +                                   X{Ǟ0!I Qptx|.)]bfjJ'Y]huzĿc%XXfkos]"VT\`eil QNRVZ^adKHKNQTVY[}vFGCFIKMOPR^~g2?ACFGIJLLVpp                    0!
       .)%
     J'#   c% ]"
	  
  vF
  g92,%
   p2,%  H!CFIKMOPR^~F"?ACFGIJLLVp@Z:<>@BCEFFGOm~GlB79;=>?@AAAGoq .024679:;;<<<JV&)+-/123456666CMg92,%
   p2,%  ~w+%
  oqj4 JVS3
CMJ:	  BCGJNQSUWYZ@CGKNQSVXYZ?CGKNQSVWYZ?CGJMPSUWXY>BFILORTVWXtKNQSUVrJLOQST~pHJMOQR{hjlXEHKMNPomligx}wpjb[SKE}wqjc\TLF~xqjc\TLF~xqjc\TLD}wqjc[SKC|vFA;5/)#zt~xr{vpgxsm  DDDHMRW\`dhloqDDHMRW[`dhknqDDGLQV[_cgjmpDCFKPUY^beilnCBEJOSX\`cgjlB@CHMQVZ^adgjddddcb`^I              d0             d0             d0             d0             c0   }{xuspmjgb/    ]zxurolif`.    zwtrolif^-     <;:87542 <=B  @C  ?C  ?C  >Bjgifif42Lhj     '                                                                             36{  )B^i{V DKU_hr|0  xsciMS,         {      ľ  HK      a  qq~ƺ                                                                                                                                                                                  (               q               ~               <              J                                                                                
+   (  "$8Oo|45i4 b \                   x"r|:ligd|b`^dy \ZXV]                                             %" {z}w uifN m]_0 dWY-    dWY-       \ZXVSRRT*       VTSPMJLN'       POMK7EFH7$%%%%%%JIGF"?ACDEFFGFFEECB@Z:<=?@@AAAA@?>=Gl               .             	&)            #   l[|fmu}eemub^emZW^dSOSRKGHJD@BE'GHJ+@BE;=?[8:D  ? tz_BE                  м(       R   q  hc~}x~{wuwtqopnjijgdd^X`fmtzL R             )UWYZZYWUR O󫨣q桞̍Я~{}|zwtvvutrpnnoonmljgw}ncw}E1nc+@YW;PQ[JLyDEFq?  ύƍ            R          O       #        

u		/
			&z
krz 
Gckry 
AU[cjpw} .POT[ahncLJILSY_YWDFEDFKONPQ &69>?ADFHJL !/258:=?ACEF                          &     6;AFK    &+05;@EK    %*/4:?DJ  
$).49>CI #(-38=BH#"',17<AF !&+06;@E
 %*/49?D
#).38=B               
          
                                                                                                                  	                                                              bgab  Z&}nzs{kszcjqx[bioSZ`g    }~}  w};t    	      1  t   Kko1adfi`^^_`w\C\ZXVXg8/\UMOQR`41[JHJLMn0-(!"#$$%Q]ZWT,)      
30.+(%        ,*'$!         (&#          	"                                                         	
Y} tKko    	"(,02432/ !',158:984%,28<@AA?<
")07=BFHHFB$,4;AGLNNLG
&.6=DJORRPJ&.6>ELQSTQL
&.5=DJORROJ$,3:AGKNNKG
!)06=BFHHFA%+17;?A@>;2/+%    840*$   ?<60)"
  FB<5.&
  LGA91)   PJD<4+"  QLE=4+#  OJC<3+"  KG@91)   FA<5-%
  >;60)!	  #(-035531
#)/48<>><9d$+18>CGIJHCk#+29@GMRUUSN")18@GOV\_`]W'.6>EMU]cghd^A+3;BJRZahllib`/7?FNV]djmmjea2:BJQX_ejmmje5=ELTZafjllie8@GOV\bfjkkiekQBJQX^cgjkkheZgiDLSZ_dhklkieUUcFNU\afjlmljfPPO_JPW^dimoonkg31,("	 t<94/("
KkHC>81*"KadSNG@81)!R`^^]WOG?7/7fa\Zd^VME<Ckfa\Uib[RIMoje`[Jje]UL\VOHA(!je^WOG>6-
 ie_XPI@8&  ie_YRJB.  he`YSK6   ie`ZSL	   jfa[T    kgb\     PPO_JPW^dimoonkgLKJITZ`glprrqnikgb\     nic2      G	!%&).14553#(-035531
#)/48<>><91.)#31,("	 r<94/("
Kktʺ{~y{  s   T.W}tx{             	0  f  Toq                                                                                 0       *TTTSSRQPP       (OOONNMLLK   0foq      ~}}  xxxw  ssrrq  nnmmllz  iihhggfn  ddccbba`k  G^^^]]\[Zg  -YYYXXWVUU  *TTTSSRQPP3568999:960345789::72.568:=?@@<6278;>BEHHB;579<?DHKKE<678;>BEHHB;5568:=?@@<62   13798542-'!5148984/)#858=?=82,%98=CEC=6.' 99?EHE?7/(!98=CEC=6.' 858=?=82,%4555634567668:<89;=A8:<?C89;=A668:< 0*%#!4.(#92+%?6.' B8/'!?6.' 92+%  0+&"3.("93,%?6.' A8/(!?6.' =4,%;1*&  "%' (!' %#
/*%!2-'!92+$?6-& B7.' ?6-& =3+$:0($
0-14541,5/26762-859?B?9299?HLH?699BLQLB799@IMI?698>DFC=387;?A?:4769<<;7465799853546786421.25652-6036863.969?A?93:9?FHF?69:AHLHA899?FIF?699>CEC=498<@A?;587:==<85768:;96465789752rx{zwnqssqljmmm y~|fNvx{zwbKuqssr^H   }hQIA:~hPIA:~~|fNG@9|x{zwbKE>9149>CK]^]\439>CS``__66<AGfhigg78>DRmopnn79?Efruuts79?Psvxywu78>gvyz|{v67=twy~x54Utw~x22r|}w/OzuIwqA:3-A:3.@92.500/-+)&"<76541.+'#C>=<:740,'#KEECA=950+'"ZMLKHD?:5/*%_]XRNJD>93-'ckmhUOIB<6/)muwvrZMF?81+v|~}yePHA93,}}hQIA:3-~hPIA:3-,& -'!-'! 	"	%'"
	)$
+%,& -'!                                                     



     
   
   $##" %*))'&#!+00/-+)&"                                    !'&,	 '.	 '.	 &-
$*!& 	"  	
!'&,	 '.	 '.	 &-
$*!& 	#7 -5 	'/ "	
!'
$*
%,
&-
%+	"(
 %!   
-4 	3>I 
3>I 
2=H 
/:E 	+6@ '0: 
",5fHW6oa vuu sqvvu ql:;;   368;=?@AAA@?><:569<>@ABBBB@?=::;>ADFGHIIHGEB@>@CGJLNOPPOMKHECEIMPSUVWWVTQNKGJNSVZ\^__][XUPLOTY]adghgfc_[VPSY_dimpqqokga\RX^ekqvz{{xtnhaV\cjry}vngY_gox}tk[ajs}xo\clv{q]clv{q\bkuzp[`ir{vm\bkuzpZ`ir{vmW]emu}yqiTZahou{}xrkdPV\bhmruvvsoje_LQV\aeiklljgc^YGLQVZ]`bcca_\XSCGLPSVYZ[[ZXUQN@BFJMOQSSSRPNKH<=ADGIKLLLKJHEB79<>ACDEFEECB@=3469;=>????=<:8./1457899998652)*,.013343321/-%%')+,-...--+*(   864:85@=9EB>KGCPLHVQL\VPa[Ug_Xkc[of]qg_qh_pg^md\pg^md\iaZd]V_YSYTNSOJNIEHD@B?<=:785220--+)(&$   PPOLHD?:61+& QRQOKGA<60+%TZYVRLF@:4-'"	
	
&+/368;<==&*/37:<>>>(-27;>ABC@   
$!&	#( .047:<>>=<:77765/047:=?@?=:88876037;?CFGFC?>==<:6531/,($!76530-*&"
<:9741.*% 
		   $(*-024567$(,/245788"',/368:;<=6778;=>>=;852.*'8889<>??><952.*&<=>>AEGGEA=951,()%#*&",($   ]Mu9= S) ^S) y`WR) uT?))  P     (''%# 	  *''&%"
  ,*)('$!  -,++)&#
  ---,*($   ,--,*($ 	  *,,+*'$ 
  (***(%#   ((('%$$#!(%$$$%&%$!%! !$&''&$!	"#%'()'$!$')**'""&)+,*&"#'*,,*&
#'+-+'$#'*,,*#'+-$('  !%'            
    "#!   
"%&$    
#&'%!   !$%#
    !   
  
	 

   
   
       		         
'%!   *($    +*'#     ,+*'"         ,,*'"          ,,*'"          ,,+'"          *,,	           (!                  	           	
     
                         

            		                                              "(,-17#)/5<$*07>%+18?%+29@%+18?$*07>                             
             
                                       
             	             
                          lsuuwfntwwktz}}pzr|pzktz}} f`^]id_Ymga[pjd]qke^pjd]mga[//0  %%	&   !4(21=BKA?  > QSPN``_b]`]\_e_e_e  \_\a]d_cSWUZ                                                                                                                                     	

 
	
 $!
&# 
)&#" +(%#"*'$#!'$! " 	                                                                        
    	 3 CD        !8:         !	 &                                                                ') ,-- +) CDRVD _`` ^[, :Q]a3hh eb D (, 3775/            ) , P DV/  "	   47:.   #   36:=    !& +:>A!  	.: /CGJ     16;6MP	   '$ (*                 	#15>X2g 2DEEEEEDB@=  CEEEEDB@>;! 6JJKJIGEB?J 'QQRQPNKHEP XYYXWURNK* .///.-+)'            2gP7pp7m52`                                       
                                
                                     JFIMPSUVWVUTQNK$ MJLPSVXZZZYWURN% PMOTWZ]^__^\YUR' RPRW[^`bcca_\YU( SRUY^adeffdb_\W* TSW[`cfhhhgda^Y* TTX\adgijihfc_Z+ TTX]adgijjhfc_Z+ TTW\`dfhiiheb^Z+ TSV[_befggfd`]X* S=*,.0122221/-+ =                  +,-. ,+)' H$ )TVWX, UROL$ 5D" &PRTT* PNKH"  <B" &PRTT* PNKH" =  %LNOP( KJGC   + !DFGH# ECA>                                  %
 
 
 !% ./00 /-+)  ! ()** )(&$   #$$% #"!                
             
	            	  				                       
              !!    !!    !    !    VQMHDCA==:4,%" YUPLGDC@;5.&"!]YTPKHGD@92)'%# a\XTOLKHD=5-+)'$c^YUQMMJF?6.,*'$b]XTPMLJE>6-*(%"^YUQMIIFB;3*%# "%())((% 
#&(*)&!# !&*,-,)$'$$)-/0/+%
'$$)-//.*%%"!&)*+*'"  #$%%"
   SZagmqssuwwwvST\cinruwwwvtUV^elquxz{{zyVX`hntx{}~~~VXaiouy|~VX`hntx{}~~~UV^elquxz{{zy ]\Z^\Vjf]|tf|j|tfjf]   WQJC=73311112\VOHA;5111123f]TKD=7333345tfYNF?8544557|j[PG?9655567tfYNF?8544557f]TKD=7333345 yxt}wm~sz|z~s   peYMD=9975443wmbVJB<754433~sgZME=976656zl^PG?;98778|n_QG?<:9888zl^PG?;98778~sgZME=976656 346786413356653143566530445665206456653095677631;8898743;<>>=<96<BEFEE@;BJNNQPIAISX]d\SJQ]dysh]S[itfZez}ob4578975244677641546776316567763175777641;7898742>;:;:865>?AA@>;8?FIIHHB=ENRRUTLDMW\ag`WMUag|vlaV_kwj^h{re 	 	 	 	        	    
	  
	&%"3/)#
	@;1' 
JE:-$PK@4(!
PLC8,$PKD:0' QJD<2)"RKE>5+$RKF@7.&QKGC:0'NJGE=2( IEEE=3)!B<<=91)! B<<=91)!;4331,%2*())% '! !!


	 
&$"
2.(#	=80' 
E@7,#
KG>3( MIA7,#PJC:0&RJD<2(!SLE>5+#SLE?7-%QLFA9/&OIEA:0' JDA?80)!D=:95/(! D=:95/(!=621/+%4-()(% )#!!!
	 ""%&&$,)(+/22.62249<=8B>==@DE@LIHGHIKGVTROPPMI^^[XWUPJhhe`]XRJqrng`ZSLvvrkbYSLvsoiaYQLtnjd]VOIrjd]WQJDme^XQJD=me^XQJD=f^XQJD=6`VOIB;4-WLE>71)#J?82+%:2+% .(!! !"%&&%+''+/23/4004:>@;@<;<BHJEKGFEHMPKTRPNPQPL]\YXWTPKeec`\WQJnokf_YRKsspi`YRKrroh`WQKonjd]UNJmid^WPIEie^WPHB<ie^WPHB<c^XQIB;4[VOHA92*QKE>6/'!E>81*#70*%,&  B<5-% GA91+'$!MG@:41.+'SNHB=;840XVSMIFC@<^_\VRPNKG`ba\YXWTRacb`^^^]\addcaceee`eijjilnoahmqrppssbjpuwvsrrbjpuxyuon`gmrvwsmi[agmrtpie [agmrtpieTYahnokc^NT[bhid[VGNSY^`[QK>DJNQRME>29>BDC=70&,04530,& EDLSZagnt{JHPW_elrxSMU]dkqw}V[_cjqw|Z_dipw}]cinv~z_fmt}~ysOhpyzsmOap}vmf^aoù}rh`]^|xmbZZ~~rg]UvlaVPxndZPKwne[RIDwne[RID~ysld[RIA={xuqmg`YQI@85rjaYQKGBxne^VOKGzrjc\VQMyrlfa\WS|vqlgc_[Xzvrnjfc`]^yspmifc`^^`smjgda_]]^amfc`_^]\^_ah`[[[[Z[\^`bZVWWWWY[\a]URQRSTWY\bVPOMMNOSX\bPKJIHHJPVZ`IDDDDCDKRW[   IDDDDCDKRW[A==>>>?FMPT8566678>DIN   `YQI@8566678>DINUNG?7/,---..28@GIC<5-%#####$(-6>@:3+$$+293,%!&^{xuqmg`Y-2Vrnie`[UN(,/1L`[UOIC'')+,7IMG@:%"'&'''.993 &&$"""! $+(%"   A;5-% E@91+'%"LG@:41.,)TOJC><962]\VOIGEB>hg`XSQOLIjjd^YXXVThifa^^_^^eghgddghhchlnnmnqrdkquwwuvvemsy~|vsfmt{tnekqw~}rjcfjqwzvme cfjqwzvme^^ckrupf^UW]emql`VKPU]fkeWLAFLRY\WJ?5;@EIID:2)/47983.( CBJPW]ciov~HFMT[bhmszQKRZagmrx}TX\_flrw{X\`dlrw|}Z_djrx}~zv\bhoyytpMdku~unjL^lz|ricZ]k|Ÿxnd]Y[wötj_XVyyodZU}rh^UP~tjaWPK{skbYPJF{skbYPJF}zuohaYPHB?~zvsqmid^WOG?:7}oh_WOIEAvkc[TNJEwng`ZTPL~voic_[WT}xsnieb_^]zvsokgdbachtpmjgda`aejnjgeba`_bdhica``_^_`bed]\\]\\]_`c_XWXYXY[]_dZUSSTTVY\`eUPOMNORW]afPKJIHINV^beJFEDDDHUaec   JFEDDDHUaecB?>>>?DQ_b^:77778<GRVU   ^WOG?:77778<GRVUSLE>60..///28@FKHB;4-&%%%%%'+1:A?82+$"&.582+%$)Z~zvsqmid^W+0Rnjea]XSL'+-/I]XRMHB&&(*+6GKE?8$!('&&&-782 &(%#!!  #*)&#    4;>@B BB@   I@6-# %OG=4*"$(RI?6,#$).TKA7-$").5TKB8.$     !%,29TKA7-$     !%,29RI?6,##*/5',2577641,$(.36752.').5:>@>94-.5<BGJIB;229@FKONG?529@FKNMF>4/5<AEGE?80  "&)++ %)-/0#).255%+169: &-38;< &,27:;$*0478"',023#'*,-"$&&              

	


		




 "###"!   '""###"! !+&&''''%$"%/**+,,+*(&(3//000/.,*,633455420-/6689::8641069<>??=;;:19=ADFEWULD;=AFKbof\RHBAEX~obVLGDvueYNJ   HKMNMIC?;73/,LOQSSOHA=840-OSV[cZND>951.QTX_yaPE>:51.QTW[]WNE=950-PSTUTPJB;73/,NOPPOKE?951.+JKLKIFA;62/,)FGGFC@<62/,)'AAA@>:61.,)&%  ~obVLKueYNLufZOL|pdYNJzsj`VLJysld\RIIrlf_WNEFkf_ZSKBBUXz}ys{wrl{xupkftqmjfa  rlf_kf_\fa[[{xuptqmimjgC&)-oo(Zp~{x~vvtq}wtmcmj  x~vvswtmcrpmfC 200369;=>?@BFHK52369<>@ACCEILO7569<?ACEFFHLOS   <>@ACCEILO?ACEFFHLOSACEGHHJMQT  LOSMQTNQTMPSKNOHJKDFG?AA52369<>7569<?A878;>AC989;?AD888;>AC667:=?B3347:=?/.0369;*)+/247 +,28>DINQRQNJE?9..4;AHMSXYXSNHB</07>DKRZbgbZSLE?018?FMU_oo_VNG@/19@GNV_pp`VNGA/18?FLS[chc[TMF@/06=CJPUZ\ZVPJD>-.4:@FKORSRPLGA;++17<AFILLLJFB=8('-38<@CEFEDA=94?952B<75E?:7G@;8GA<9F@;8D>96A;63=82/94.*                         &F  OIB GLHC>MJDA=9ICB?<95      
  !!  !!  !"!  
''%$"
+,+*(&#TTWWYZ[\[][][\Z[XXVUSVTZ`W^eZai\dl]en]en\em[ckX`gU\c   RVTZ`4d^Zib]me`phbricsjcricogakc_f_[  K^[jd^pibumeyph|ri|sj{riwogskcmf_   JfkorsrpmRgmsw{||yuqK^YTjd^^Yd^J`f`lephskumumtlrjngic  cagcmirowszvzvyuurpmjg  @UZ`fkoqqpmhbGX[`fkosuuspjd_?TZ`glprrqnicIWZ_ejptvvtqke_^XTb\Xg`[ld^of`qhbrhbpgane`jb]e^ZaYV_XS{zoyyx   yyxwwvuutsrrppomlkjihgfddb``^]]YY   kd]VNG@84.&	ng`YQJC;4-&qkd]VNG@81*"rlf`YRKC<5-&qmga[TNG?81)"	olhb]WPIB;4,$ mkgc^XRLE>6/                              	                        mkgc^XRLE>6/(kjgd_ZTNG@91,iigda\VPJB;3-hhgeb^YSLD=5/ghhgd`[UNF>60fhiigc^XPH?70fiklkhb[RJ@71ejnqqmg^UKA83ekrwyulbVKA:5clu~}rdWLD<7`jvteWME=8]gsrdXNE>8XA27>EMUZajpsrnhzf26<CKS[emrtrngyxg:>CJS]gotvuqkwvvg@DJT^gotvurluttsfFMT]fmqtsqmrrqpphOU[cinpqolponmoqjUZ`fjmnmklkjkmnoiY]bfikkjihgijklll_^cfhiifddfghhhhf^`cfhhb`abcdddca_]adgh^]^^____^\[Z_cfhYYYZZZYYXWVX]afiTTTTTTSSRRTUZ`ejONNNNMMLMOQSX^ekJHGGFFFHJLNPT\clONNNNMMLMOQSX^ekJHGGFFFHJLNPT\clFB@??ABDFGIKPX`jB?;:<=?@BDEHLT]gBHOU\bhlopolhec`?FNU\cjostsojd`]<DLT\dlsxzxsle]X:BJS\enw}~wne\T;?GPZdoyzodZQ<;DMVamxymaWM88@IS]it~~ui^SJc`^]`]YY]XTT\TONZQJHWMFBSJB?POSRVUXXXZY[Z\Z[YY  X[cVYaSW^PTZLPVLNULNULMTLMSKLSKLRJKRJKQIJP  'JP2IPAKOBHO?FN BH?F<D:B;@  'J2IAKBH?F  &'+2)A,B7?5<:9 &10/,.00),.110#/(),.0122210/11,1222 #11+%	%&)+:UcV  H;1[cd<LhRTjpuwSZbgh7=%7LbbBCeRVrrqokf`y||{wrmf/?``8R`S  _!D^```__  Q$V___`@__`O:Y`abb0abcWZJcdegdinUUqqvtqlgeioswyyxuqlfLhQTjosuUqqwyy  qUnQxwuqO2aolf  ]bfi]bgkllnmII jjkjll  ]aeh]aeh\aehgjfiehehehfigkDG  ^cgjllm^bfijkk  tuqrnolmkkjjjj  bhmpafjnw|sxptmpjnhkgj  }|xwtuiklljiikmnmkhg  ih_Sgf]Shjjjlnohjjjjlmhjkjijk   rtprnolmjkiihgEC  opdUmnbTkkaTmprtugVknprrfV  pstuxz{npqruxy  {{lYyyjYypj|rkpjup}w}zzsuoqlz{xy  xyuvrt  {qjwoismf`oha]vs|~w|ipw|zselsx{}|yuopjc_wphc}umf			      Qlmlie`[twwvrmgaHcMPejpq7GD<MJFEWSNb\W>NKEWRNJ]XSib\=TX[]^^\ZCUZ^begfd`]6J9:MNPQ olQ]ytpBZGI]afgTpr;wz|zIe4Rflrt5666-034 
$-)% (531        
   M]Y_yrcFTPVoiZ 
	 nmP[zztNV]bd6 a`GNjmhE8/W_`:    
?DLON*IOW\]2Rno9suwwIe4QejoqHab2dfggA5,RZZ7:/'JPP0BZ.HZ^bc       0<72 "  7GDA
(#"H]YL;$6J__@ ()(?VYV 	
        7D>9 8JH> '%%@SOK9S`S      3DEE
BcP""##GIII!<@DE3.?QP78"3FYY=(())STUT%&(KNQR((()SVWU5MZN  
0FQF  !!!!CDED

=[I6QA!#&EJOQ =?BB      [``feliqlumwnwmvjsgobi^e]d\b[a  [aZ`Y^X^X]W]W\W]W]9>  
       qqssoljidrrttsqmid  noortt  pnljssqnM2`kid  @BADH&LPNSY0UY`fY]elZaiq]clu^emwEHGKP+bdhkpcglps  ehknglpr^dmv]bjsTTUX_3X[biWW^eJLJN^d]bUUVY_3WX.Iaace/_``SU\bSU[a@0 ACG&MMNPU-IGJ^_``"	 #%)>]^^QSY^QSX^R6M]]^^4'
 46:/# /27.\J]]]  PRX]PRW]PQW\47^]]  5( 58>".\^^OQW]NPW]S=^^bcdinsvxxwuqlfefhmsw{}~|yupjhjlqw}ztnkmot{~xqlnqv}zslnqw~zsjmou|yrhjmsy|vpdfiouz~|xrl_`ejptxzzyvrmh$$&&&(()****++*++)**'()%&&"##        
        	
      
          
          /*$     
 
		       	          
          	
          

 $$$'*-038=ADFGGE&&&(,/26;AEHJKJI())*.259@FKNOONL***,048<DKPSTSQO+++-15:?GOWZYVSP+++.26;@HSeh\WTP**+.26;@GRdg[VRO())-15:>CLSVUROL&&(,048<@EJMMLJH##&*.259<>BEFFECGEDA=94/)# JIFC@;71+% NLJFB>93-' 	 QOLHD?:4.(!
 SPMIE@;5/(!
 TPMID@:4.' 
 ROKGC>93-&	 OLIE@<61+$ JHEA=83.(! EC@<94/*$                                                                        '6  22369  01259=  0038Mp  /04m 
,Bzz{}	',stvwy
  	  
       
 	                              !          :3*";4+#                      	


	# &$!)&# ,)&" ,)&"/,($!1.*&"3/+'#50,($51-(              	

		
 ###" %))('%#*//.-+(155430-7<<;963>DCB?<8FLLJFB=   SLLJFB=]UURNHCd`_[UOHfkjd]TLmutlcXOw{ypeZQ      	
!%#)&,)/,  /,2/517395:5         	


 "#$ &()*%,.00*2567$8;=>?BDE EJLM PIJLMUOQTUWUX\^WY^ceY]chk\^ekn     	    ;6ME=5/A<OG?70EBQIA81FHSKB92J&/)#& LHCB@=:7NJGEB@=:PLJHEC@=PLKIGDB?OLKIGEB?MJIHFDB?IGFEDB@=EBBB@?=;@===<;97:7777643323'0/-!  

	       77643'0/-")'  )'           '0/-
")'   
    	             "           	  
  
   	                                                                                     +(./* 0-11 (		     
d^VMD;5f_WND<8e^VME>9c\TMF?:aZTMF?: TSRPLWUTRNXWWTPWXWTPUWVSOUTSPMSOOMINJJHEIDDB@C>><:  XX\XX^XV]   X]chkX^eknV]djm 950,($:51-('951,('  FE@92+$#FFA:3+$#FFA:2+$#<AKSY^a<>HRZ`a<>HQZ_a   U>06=EMV\eowzwqhwc/5;CKT^hry{wpgwvd6;BJS]hs{}zskutsd=AHQ\gqxzxsltsrpcAFPZdmsuuqlrqonlaHOXahnpqokonlkijcOU]dilmljmkigghjdTZ`eijkijhedefggg[]bfhiigdaabcddcb\_dghic`^^_```_^^^behi_\Z[[\\[[ZY[`dhj[WVWWWWWVUUY^cgjVRRRRRQQPQSV\bfjQMLLLLKKLNPTZ`ejJFFEEEEGIKMPW]chQMLLLLKKLNPTZ`ejJFFEEEEGIKMPW]chE?>>>?ACEGILSY`eB;99;<>1%&'),0Hbfjmmlid^ejmnnkf_chlnmke^`eikkic\\bfhhfaZlc[SNG?8pg^VNF?8skbZRKD=sle]VOHAqlf`YSLEokga\VOHljgc^XRLkigd`[UOiiheb]XRhihgd`[Uhiihfb]Whjkjhe`Zgjllkgb\fjmmlid^>CK<@H;<E99APTZLPVILSIKRIKRIKRIKQIKQIJQIJQHJP   #%JP(0IP'?JP*AHO7?GN5=EM:CK<AHTZahPV\cLSZaKRY_KRX^KRX]KQW]KQW\JQW\JQW\JPV\IPW\JPW]HOV]GNV]EMU]GNV]EMU]CKS\@HQY<EMV9AJRhov{~ysle^Xciouxzyvrlf_YTaglqtuurnic\UQ_ejnpruxyzzywmaglqtuurnic\UG_ejnpruxyzzywc^chkmoruwxxxwv]bfikloruvvvut]aehjkmprtttts\adgijknqrrrrq\`dgiijmopppon\adgijilmnnnmk\aehjjjjlmlkjh\afiklkjkkjigd]bgjmnmkjihfc`]chlopomigec_\]dinqrqnjeb_[W]djpstspkd_[VR\cjptvtqkd\VQMYbiptutpjbZQJF\cjptvtqkd\VQMYbiptutpjbZQJFV^fmqsqmf_VNE?R[bimonic[SJB;POUZ_ejptvvtqke^SRX_elrwz||yuoibVU\dksz}vogXX`hpy}tlYZbkt~yoZ[dmv{qZ\dmw|rZ[cluzpYYair{wnWW^fnv~zrjTTZahov{~ysleQPV\ciouxzyvrlf_e^XTib\Xog`[tld^yof`{qhb|rhbzpgawne`rjb]le^Zf_YV#)/$*0&,2&,2&,2&,2$*0#(.!&+#(  [[[\\]^^_afkors^^^^_`abcdinsvxaaaabcdefhmsw{}bbbcdefgikpv{~cccddeghjlrx}bbccdeghjlrx}`aabcdegikqw|]^^_`acdfioty}ZZ[\]^_abfkquxzUVVWXY[\]bglpsu  stspmicxxwtqlg}}|yupj}xsmzun{uo~ztn~{wrlz{zwsniuutrnje  ONSVSRVZUUZ]VW\_UX\`UV[^TSX[PNSWLINQFBGK


  ,-159?EJMNONMJHDC--159@FLOQQPNLIEJ@/38@HPW[]\ZWTQMQrRW^emu}~xrl\XTWqrx~c_ZXpnuƩhe`[khq}plgafblywtoh~mV58; ~e|y~tztu~pnwifnv}aUemty~S5Lekos  |J }mV53} d{eUxKŸ~swz|S9>CFIKMMe>CGKMNOf\RSTtr|}{|}|zxz||}|vwwts  4B?:53  #D?:45  &HC=77  'KE?98  (MGA:8  (MGA:9  (LF@:9  &JD>88WYYWSNHFVWWTQLGEVUTROJEDvg^RJ{i[OIuOH   l  kM/ gb\U`\WPYUQKPNJFIGD@A?=:iu~}yrjb[Xfs~yqibZ\iu|umf__ct~}vpibaXcs~~{vpjdaQVZ[ZVQKE?9XJNQRQNJE@;56KMJEI6C?}vpibb~{vpjdBZVQKE?95QNJE@;53N7C?;6127 .951-/  51.*+1-(1,)0,)    !,+*'$$ --+*'%& /0/.,)'$46531.*OPMHC=75OOMHB=65OOLGB<65                       
   ,   APTWXWTQUYZYUW\`b`\\bghgb_fkmkf`glnlg^dikidZ`ded`=AIQVbo=?GPYfs<?GOZiu:>EMUct8<BJQXc89?EKQV65;@EJN316;?C7/-159. +),03   HO[[RQLHITSIHEHFNMCB?   KM<     k}}  ~|y  yy  xw  xm wk_ 840621411   :51-951,840,62/,624110  <8875310A<:97414AAA?=:65BGIGD@;7NLE88  NOOiqpP limpkgb|sib\xl`\{ob^|ob_zm`^HFFFFE"NGFFFEC?NNLJGD?@jgbUICA{qf[Hwk^YX\_`_[UQWX[[ZWROWUVWURNOQW]as}phPQVYkujePNPSeoddV_o|NSXfr{GRS_ksyB    B^ekn&@]djmKSZafhHOU[_aDJPTXZ?DIMPR:?CFIL  ?DIMP:?CFG59<@C :?CF59<=/3*59</3
*    ;?EJOS*9<AFKN(99>CGJ&   EHFD" "DDDB~  ckrx|\_cjptxV^]djnrR   WA@>;951 Sk6J%kJ%GI%~}bDG$zvxx@BE EKPUWW*CEJNPO'BAEHJJ$     i ln6   lnlNkmkMghgb`b`\YZYUPQPNJIIGDBA?iQilnlhkmkg   i  VSOIF@<iXSLE?<tu`PGA<v[A<                   & 3ETKCttjNG@ocdWHB=        <#&), <=DKRV    
      4!$ 44:@F%    
	




	8HHGDA=7	
						
	
	
			


	
		  #!


 $CEGILSY`%&'),0




          

        !        
&        "+        $.        $-        
!)        	
$                  "&(*+,+*(%$"!&*-/000/.*(%"&,134556652.*%!"+388889:<?>5.(#$.>B;::;<@LT;0)$$-8<:99:<?FH8/)#!)04567789:71,'"$)-0123331.+($ #'*,---,*'%# !$%&'&%#! "%!(#)$ )# '"$    
#(#	


                                                                                          	
          
         
        

       
      
"     	
 $'      $(,    	 $)-1    #(,16    #(,16    
 &+05;    
#(.39?   $*06=C    &,28?F   #',39AI 
#(*-3:AI         
(2         
'2     
%/ 
!)	

$	

!
  "#$%%%$#!"%')*+++*(&$!$'*-/01110.,)&"(,0357888641.*&"-159<>???=:73/+&16;?BEGGFDA=84/*16;?BEGGFDA=84/*5;@EJMOPNKGC>83-9?EKQUXYWSNIB<60=CJQX^bb`[UNG@93?FNV_fklib[RJC<5AIQZclqsoh_UME=6AIR[entuqj`VME>6(2;@CEEFHHHD@;4,'2:@CDEFHIHDA;4,%/7<@ACDEEDA>92+!)16:<=>??=;94/)$).246776542/*%!$'),-..-,//)%  ""#$%%$'+-,#'*,)#')+&#&)+
 #&)"!$,&"
!7+&"(5/*% 
	   /*% 
	   3-(#   60+%      93-'"
     <5/)#	     =60)$	     >60*$
     4,'4,'2+&/)#*% % )+&)+5&)A$,B!7?(5<:   *                            !    
#    	$   $) 	


    %+17=CINSVWWUPK!'-3:@GNTZ^`_\WQ#)/5<CJRY`dgfb\U$)06=EMU\dilkg`Y)*07>EMU^eknmhbZ                                                                                          	           	
         

                       !      
"%      
"&*     "&+/     
 %*/4     
 %*/4     
#(.38     %+17=          
          
          	  	


	

	


!"$%%%$#"!#&(*+++*)'"%),.01221/-&*.146888753+/37;=?@?><9/49=ADFGGEC?/49=ADFGGEC?38>CHKNOOMJE7=CINSVWWUPK
%.49<>?@@?<
%-49<>?@@?<	#+169;<==<:&,14678875

 &*-/111/0"%'))(()   "$ #")'%"

/-*'$ 

530,($ 

<951-)$
C?;62-(#
 C?;62-(#
 JE@;60+%  PKF@:4.("	 WQJD=60*$
 \UNG?82,& `YPIA:3-&!bZQIB:3-'!?<;83-&?<;83-&<:961+%7552.)#/0/-)% ()*)$ "$'*" $')!$')"%')"%/
 #8
+;19   +      +                                 	

	
  !%(,0369;==<:8"&*.159<?AA@=:#'+/37;?CFGEA= $(,059=BHMPKE@ $(-15:>DKXlPGA $(,159>CISXMFA$(,048=AEIKHC?#'+.26:>ACDB?<!%)-047:=>>=;9 #'*.14689:975:851.*'#=:730,($ A=951-)%!
	E@;72.*&"
	GA<73/*&"
FA<73.*&"
C?:62.*&!
	?<840-)%!
	;962.+'#752/,)%!            	     	     
     
     	     	                 +/5+06,06,06+06+/5*.4   }ysmf_YRKD@|vpiaZSLFA~xqjb[TMFA~xqjb[TMFA|vpiaZSLFA}ysmf_YRKD@||{xtoic]VPIC?  )-28>DJQW]cinrv*.4:@FLSY`flrwz*/5;AHNU\cjpv{+06<BIPW^elsyvwxwtplf`ZTNGA=z||{xtoic]VPIC>}ysmf_YRKD?|vpiaZSLFAU\cjpW^elsX_fmtX_fmtW^elsU\cjpSY`fl dhkgokqorqpokj  fb]WPG>:80&iea\VNE<2) nkhd]TJ?5+"qpooh\OC8-# pprtn_PC8-#kjjicXL@5+!    TWWW\[^^\]XZUTSROKIHEA????WTTSQNJFA????>[YVVQUPKGEINSX^][WPGDBLHLQW\]]\XQH=3)*4EY_ZZYUNE;1(`EUIWW\Y`:b,ahea_]ZVQONID@?>=lgd`_]YUPJEA??>Hnkhea`][UOJHKOSWomllkeZMNEOLMQV[lkkmoi\NB6,.6SX^fgghhcXK?4*!:_JONORRUVUWTVQS  NMNOONLKJHFGIKNNMNOOMKHFGIKMRRRUVUSPMJHKMOUWX\][XTPMJLNQUWY]^]YUQMJKNQRSUXYXUQNJHILNNNMOOQQSQSNP6+Y-_U[^UYFTU06<DKS[agjidlb<5;BJS\eloy^aM=EMWa}Y\_ZJUk{SVZbcXer iY.4:@HPV\dhg`heg<39@GOXajmv}`bdL;BJS^{Y\^aYGQgwRUW[baTan|*+'-(.(.'-+17=DKRUW\ab_Y'-39?FMT[`b`[T).4;BIR[dlold[*/6<DLVamx}xma*/6<DLVamx}xma).4;BIR[dlold[POTM[RaVaV[RXlblmnnommjjllpv\\hmp{llmrxS_lxmnou{Wesnoqw~[izmnpv}[jzjklryWet57;>ACEFFFEDB?<69<@BEFGHHGFDA>8:>ADFHIJJIGEC@9;?BEHJKKKJIGDA9<@CFHJKLLKIGEA9<@CFHJKLLKIGEA9;?BEHJKKKJIGDA8:>ADFHIJJIGEC@69<@BEFGHHGFDA> <95>;7@<8A=9A>:A>:A=9@<8>;7 GJNRVY[]]]\ZXTPILPUX[^_``_]ZWSJNSW[^abcca_]YUKOTY]`bdeeca^[VLPUY]aceffdb_[WLPUY]aceffdb_[WKOTY]`bdeeca^[VJNSW[^abcca_]YUILPUX[^_``_]ZWS PLGSNIUPKVRMWRMWRMVRMUPKSNI vpiaZSLFAxqjb[TMFAxqjb[TMFAvpiaZSLFAsmf_YRKD@oic]VPIC?  )-28>DJQW]cinrv*.4:@FLSY`flrwz*/5;AHNU\cjpv{+06<BIPW^elsyvwxwtplf`ZTNGA=z||{xtoic]VPIC?}ysmf_YRKD@|vpiaZSLFA+06<BIPW^els,06<CJPX_fmt,06<CJPX_fmt+06<BIPW^els+/5;AHNU\cjp*.4:@FLSY`fl258:<>?@@@?>=;9458;=?@AAAA?><:9:=@CEFGHHGFDA?=?BFHKMNNNMLJGDBDHKOQSUVUTSPMJFIMQUX[^]]\ZWSOKMRW\fkigfda^YUNRXivvvtqomie`Z[h{|~}ywrlf`}{tle{riwmypzszt~wszt~wsxroq|~|wpljOTiyz{{zwtrnidcKPUZhqpolkhea]XFKPTX\cdbehgcVRBFJNRUWYZ^adfgh@AEHKNPQSW[^`bd;=@CFHIKMQUXZ]_78;=@BCDFKNRUWZ2368:<=>@DHLORT-.135678:>BFILO)*,.012348<?>:4$%')*,--.0-,+*(   853:74?<9DA=JFBOKFUPKZUO`YSe^WiaZmd\pk_snjtpmsomtpmsomomkjhgc]QXRMRMIhYWdef_acZ\^TWYOQT4+((&$         wwwxy{{{|}~~~~xxyy{  poonusrrzxvu~{yx}{z~{z|zy|zxwwvttrqponnrquuxxzyzzyywvtsoo               		


		!!!#"!""


	
   	
                                                                                                                                                    
                                  $            '             *              
  

 

""!"#!	 !!
 	 
                                      	       
       	       	         8AJS\dkptwxxwuss;AJS[cjptwyz{zy{=BIRZbiotx{}~@EJQY`gnsx|BGLRX_flsx~CIOTZagnu|EKPV]cjqxFLRX^elt|GMSY`gnv~HMTZahowHNTZahpxHMTZahowsssssqoy{||{yv~º¶oliecvsoki~zvqo}wt}z-          		    	

  

 	
	


  "#$$% "$%'())*!$')*++-../!&*.134432334")/48;=>><:899#*17=BEGHGFDA>?")19@FKOQRQOLIFD'/7@HOUY[[ZXUQNJ+4=FNV]addc`]YUQ+4=FNV]addc`]YUQ/9BKT\chkkjgd`\X3<FOXahmppomjfb^5?HQ[cjpstsqolhe7@JS\dkptvvusqnk8AJS\dkptwxxwuss						




	
    $%%%%$$#" !)****))('%%.////..-+*(344443320/,99::9987541>????>=<;96FDEEDDCA@>;NJKKJIHGEC@UQQQPONMKIE   UQQQPONMKIH\XWWVVTRPNMb^]]]\ZYVTShedddca_\YVnkllkjheb_[sssssqoliea  HMTZahowGMSY`gnv~FLRX^elt|ɺ² *FHLT_kw|qEFILS^jv~{qEFHKQ[eotrjDEFHMU]dhfaBBCEHOUY\[W???@CHLPQQN<;;;=AEGHHF78769<?ABB@=987530,)&"
D<:9852.+'"LCA@>;84/+&!TKIHEB=94/*% \SQOLHC>83-("b\YWSNIEA>:731.,cba_ZTNLJHFEDDDDcghe_XROLJHFEDDDgllic[TPMJHFEDDDlnmjc\TPLIGEDCBBnljgaZRMJHECBA@?lgeb]VOJGDB@?>=<g`][WQKEC@>=;:98

	
.,*7DDEFDDEFDDDEBBBB@???=<<;987-B@?>=<<;>=;:987:87643
4321)
	.-,'('#
	!
	 
	  	            
      Zceb]VOJGDB@R\][WQKEC@>=JSUSPKF@=;:8CKMLIE@;7643;CEDB>;62/.-5<>=;851-)('/57642/,($!-/0/.,*'# -+*)(&&%+%$#"$)$&-(" *,&!,0+%"3.)$
72-("	KBA@>;8+72-("RIGFC@<:72,& ZQONKFB=72,'"bZWURMGA;5/)$ib_]XSLE?82,& mhfc^WPHA:4-'!nmkhb[SKC<5.("nnmjc\SKC<5/("nmkhb[SKC<5.("mhfc^WPHA;50*% hb_]XSLFA=83.)$bZWURNJGC>:61,'"ZQONLKIFC@<84/+&RIGIIIHFDA>:62.)JBBEFGFEDB?<951,:?BEFGFEDB?<951,7;?ACDEEDB@>;84047;>ABCDDCB@>;73048;>@BCDDCB@>:6-159<?ACDDDDCA>:*.269=?BDEFFFDA>'*/37;>ADFGHHHFE''+059<@CFIKLLMM'%(-26;?CGJMPSUU%"%*/48=BFKQW[]]"!&+06;AHOV]bee#(.4;CJRZagjj"(.5<CKS\cjmm"(.5<CKS[cill!'-4;BIQX_ehh!'-4;BIQX_ehh &,29?FMTZ_aa$*06<BHNSWYY"(-38>CHLOQQ %*049=BEHII%.1148;>@AA*0/-,.2589::	

 $'"+& .)$1,'1,'$40+(73.+:620>:66A>==FEDDMMLKUUSO]][Veeb]jjgbmmjelliehhebhhe`aa_ZYYWSQQOLIIHHAA@A::9:     lllnprtuvv    6mllmprttvvt   Rnmmnprtvxz{x  Plmnoqstvx|~~| Mikloqrtuvz}|aegjmpqrstvz|~}{]aejmopqqquxzzzw[^dhklmnmnrtuvurZ[adgiiihjmoppomYW\_bcdccegijjhfTQUY[\]\\^`bbba_MINQTUUUTVXYZZYVFAFIKLMLKMOPQQPN>:=@BCDDCCFGGGFD85479:;:99;===<:42/./0110/022210'479:;:99;===<: #./0110/022210  '''''%%'''&%       		   
     uq      vto     {xslgf  ~|woheb |wphc_\}{voga\XTzwsme_ZUPurnia\XRMomic]XTPKhfb]WTPLIa_[WQOLHEYVSOJIFB@PNKFDB@=;FDA>=<965<:755420010----,.0<:75542$10----! &%$%%      	                                                                                         
          	         	        

       

      	
     	
#    ")    !'/        
      

     	
	             
                         
    		    ""  
 "" 
 !!

    ")   !'/  	
!%+4   $(/9 
#'+3< !%*.5?	$(,17@!&*/38A!&*/38A
#(-16;A
!%*/38=B	"',15:@E
	#(-27<BG


 %*/49>CI
!&+05:?EK!&+16;AFL"',16<AGM"',27<BHM"',27<BHN"',27<BHM"',16<AGM!&+16;AFL  489::96.133330(+,--,*"%&''&$ "##!  "#"! "#"  "#" "#" "#"!"!!#!!#! 
*0/&(0/.&UQQPMID?:4.$(0/.\WWVSNIC=7320/-&d_`^ZTNG@:41/-'ifgd`YRJC<50-)lklid\UME=60*#kmnkf^VNE>70*$klomhbZRE=60)#klnmic\UC<5/)#jjlkhc]V@:3-'!hgiigc]W=71+% edffeb]K83.(#bacdca]I4/*% _^aba`]F/+&"]\_aa`]D*&"
[[^```^B%"
Y[^```^B%"
XZ]`aa_@!XY]`aba>/.&-&
'




   OY]`aba`5X]acdcb8X]beffe=W]cgiih@V]chklkCU\cimnmERZbhmomENV^fknmEMU\dillCJRY`dgh@GNTZ^`a=CINSVWY8>CHKNOQ49=ADFGI/37;=?@A/37;=?@>*.146887%),.0123!#&(*++-				 



	


!"#$##"  '()**)'&# !"$,.000/-+)&""#%&'25676541.+'&'(()9;===<:740+***++?BCDDC@=950---,-EHJKKIFC>940/..-JNQRRPLHC=820/.-OTWXXURMGA;50/.-SX\]]ZVPJD=71.-+SX\]]ZVPJD=71.-+V[_a`]YSLF?81-+)W\`ba^ZTMF?82,('
!&+05X#(.38X %+17=W!'-3:@V#)/5<CU "$)06=ER"$%'*07>EN&'()+06=EM()*+-/5<CJ++,-./3:@G,---./17=C.----..38>.--,,,,/49.-,+**)+/3-+*)('&&*.  -+*)('&&*.+)(&%$""%)('%#! !#  	
                                                                                                                                                                     
	

!""$'( $'*,.!%),025 %).259; #)-27;?B#',17<@EH&)/5;@FJN(+28>DJOT ++28>DJOT,-3:@GMSX,.5;BIPV[-.5<CJPW\@?=<9740,'"$<:9741.*% 
	"641/+'#
	1047:=?@?=:88876337;?CFGFC?>==<:55:?DJPSPJDBA@?=56;AGP^q^PHECB@?56;AGP^q^PHECB@?55:?DJPSPJDBA@?=338<AEHJHEA??><:76530-*&"
<:9741.*% 
	?=<9740,'"@?=;851-)#@?=;851-)#?=<9740,'"<:9741.*% 
			   $*17=BEEIMQSTS &,28>DHLQSTSR!'-4;AGLQUWXWU"(/6=CJOUY[[ZX"(/6=DJOUZ\\ZY!(.5<BIMSXZZYW &,39?EINSUUUT   QPPPPQRSSTROKE>RQPPPPQSTSOLF@9UTSRSTUX[\YSLD<XVUUUWZ^cgd]RH?YWVVVX[`fkiaUI@WVUTUVY^cgd]RH?TSRRRSUXZ[XSLD<   4.("92,&!<5.("?70)#@70*$ ?70)#<5.(" ,'#/+&"3.)$
 3.)$82,'!=6/)#@81*$B92+%A92+%?70*$;4.("60+% 
0,'"  )/6=DLRURLD=*18@IS]a]SI@+29BLXchcXLB+29AKVaeaVKA*07?GPX[XPG?(.4;AHMOMHA;%+06;@CDC@;6"',058;;;850
  #',0479 "&+/3699 $).38<?@ 	!',28>DHI
#)/6=DLRU$*18@IS]a99765299963/?@?<83HIHD>8RURLD=]a]SI@                                                                                                   ,./-*&"
  .-..-*%!  20220-(#
  446640+%  457751,& 	  457751+& 	  32442.)$
  0.00.+&!  ,)**)&"
   '%&&%"
                                                 	               	               	                                                                                                                                                               	           
           
           	                                                    	  
  
	

!$$#
	 &)*(#
#)-.+&

#)-.+&
	 &)*(#
!$$#

 
	 
	                                                      
                  	

        

        
        	

                                                                	
	

	

		
	             $&''%"#( ! !# &+#*/
&,3		
 '.5			 &-4 %+1       "(-&+.110-*&!&+/232/+& */58:85/*#
,39=?=93,&.5;@B@;5.' -4:?A?:4-& +17;=;71+%
(-25652-("$'-25764/, $).1320,'!%),--+'% $&''%"$ ! !#            %        '!        *#
        +$
        +$
        )"        %         "	                                           	        	        	                                                     
                   #
         & 
         ("         )#        )#        '!
         %	                                                                                                    
          
          
         $
         (!        *#        ,$
        +$        )#        &!                                	       
       
       
       
        	                A99997536H@?@?>;8;PHGHGEB>@XPPQPMHCFYXZ\ZUOIHY^fif_VNI^hsxsh\RMhp{{m_SPnszqcVQ   BBA@=:DCB@=9EEDB?;FFEB?;FEDB?;EDCA>:BBA?<8  	
 $(,/37:>  "&*.159=@    
#'+/37;@D      %'+048=BH      &'+048=BI      	"28<AF            :?C:@BBA@=98=@CDC@=9:@DIKID@;;BHPYPHB=<BISjSIB=<AFLPLFA<<ACGIGC?;; ;83-          =950+%	     ?;61,'"
   ?;72-'"
  ?;72-'"  >:61,&! <84/*%  :62-($	 	"(% 
 
           

	
            

	           
     	!"     
 "     "&*    	
 $(,/3) 

"&*.159=@   >:61<84/                                                                                           
             	                        
            
                                    
	          	 
       !*003   
!&-26<@4$)/4;@FKP &,28>CIOT"(.4:AGMSW#)/6=CJQW\!%*07>ELSY^ %)/38>ELSZ_   %7::BLRX]     ENV[FEKU_kv}xHFLU^hqvpJINV^fknhLKOV\bfgbMLPV[^aa]NMQUY\]]ZONQUXZ[ZXOORVXYZXXOPTWYYYXXPRUXZZYWWRTXZ[[ZXWTWZ]^][XWVZ]``_]YXY\`bca^ZX  A%*.120-,*% J7&+/22/+&!F7)/5995/)$BF,4>FF>4,& =A:7DSSD7.'!
7;<6ANNA6-& 
04959??92+%(,001441,'"!$')*,,*'#	 #%''%#                                                  
            
                                    	                              	!&,1     %+05     !'.5;     #*2:B     
$+3<F     
$+3<D     ")07>      &,27      	"'+/      #'*47861,&!!	058850+%5;>>;5.'!:BGGB:2*#<FLLF<3+$
<DJJD<3+$
7>CC>70)"27::72,& +/11/+'"	  '*++*'#  	       



	$*##$$#!0)*++*'#!601331-(%869<<93-)8:@DD@91+9=DJJD<3-=>DJJD<3-><@DD@91,<69<<93-)701331-(%1)*++*'#!*##$$#!&*++*'# #$$#!


                           "',/10-)$"%())'$" """$"!   """!!#$$" #!#'*+*(%(%#(-132/+.''-4:=<702)*1:CJG?55)+3=JTPC85)*2<GPMB75((/7?CB;34&%+05873.0#!&*-/.,(+!$&'''$&##$$#!)%&&%"0,--,($ 73553/*$=:==:5.(!>@EE@92*#@DIID<3,$BBGGB;3+$@=AA=70)#:69962,&   +1331-(#'*++*'##$$#! 7=AA=70)#269962,&!1/11/,'"-(**(%"	* # 
!&+.1320+&!&!&,14541,&!#$*18=?=81*$" &-5>FIF>5-&!!'/8AKOKA8/' '.7@IMI@7.'%,3;ADA;3,%#(.48:84.(#$
&!
*$-& /'!.' ,%(#
		$*##$$#!0)*++*'#!501331-(%758;;83-)79>BB>81+9<BFFB;3-<=BFFB;3-=:>BB>81,:68;;83-)601331-(%0)*++*'#!*##$$#!&*++*'# #$$#!			  ""#"! '#$$#!.)++)'#30220,(#868861,& 8:==:5/(":<??<70)#;;>>;60)#:8;;83.'!63553/*$  38;;83.'!.3553/*$+-..-)%!*&((&$ 	 !!    	())(%" "##"

	

	       (,05:?DFGMRRMG$)-26;@FLRSOIC%).27<BHP\bVLE%).37=BITk~\NF%).27<BHP\bVLE$(-16:?EJOPMGB#'+048<@DGGFB>  rple\SJCA>81+& wqojbYQHA:3-'!ywuof\SJB;4.("xyyrh^TKB;4.("xwuof\SJB;4.("wpmhaXPH@93-'!pfb_YSKD=71+% 

                             
	    "&),/12
"&*-1468	!%).269<?

#(,16:?CF!%*/4:?DJN"',27=CJQW
#).39@GOXb
$)/5;BJS^k$*/5;BKT`p    03:AHR]l  23332089:975?@A@>;FHHGDANQRPLGW\]ZTNbikf]Tkx|reXpxhZtzl]               	   

    
	

	

 ! #%&"%'*+"&),/1
 !"###"!%&'((('&*+-..-,+/1233320       

         
       !#$% #&(*+
!%(+-01!%)-0367
 %)-159<>#(-16;?CF
!&+05;@EJN#(-39?ELRW$*06<CJRY`
 %+17>FNW`i   
 %+17>FNW`i
!&,29@GPZdo!&,29@HQZep   



 !!  %&&&%$+,,,*)12220/799874>@@?=;FGHGDANPQOLHWZZXTO`dec]Uiopld[  iopld[owytj_py{uk`  $*"                                       	


	
!""!&('&%# ,.-,*(%"34320-*'0.-,*(%$64320-*)=;:863/.ECB?<842NKJGC>97XURNID>;a_\WPIB>hkf_VNF@suoe[QIB{{sh]SJCzxqg\RICrojaXOGBgd`ZSKD@
 &+$                            

		


"#"! '(('%#!-.-,*(&"24320-*'64320-*)<:9852/-DB@>;731LJHEA=85WSQMGB<9d_[UMF@<ong]SJC>{}qcWME?teXNE?|wmaVLD?lgbYQIB=^ZWQKD>:SQOKFA;8      %%$!,5,&   ,@RMJJF=6.(#*XXZXURLHB<60*%PUYYZXTPKE?93-'!OUZ]^]ZUOIB<5/)#RX]aba]XRKD=70*$SZ_bdb_ZSLE>71*$SY^bcb^YSLE?92.)QW\_`_]XTNJC?9MTX^_]YVVS:#                          
	             #	      %
     '!     )#
     *$
     *$            "*%     /=9775/+%"AABA><962.+'# ;?AABA>;840-)%!:>BFGFB>:62.*&"<AFLPLFA<83/+'#=BISjSIB=840+'#=BHPYPHB=840-(&";@DIKIEA>:730,	9>AHHFB??=+                  	        
            !
	   "
   #
   #		      #%%#$$#!	!$&'%&&%"	%)+-+--+($(-031331.)#*/3779972-'!
+059;>>;6/)")/48<??<70*#',16;>>;6/)"              	                                        
                                                         $),      
"'+.      	%+04      
"(.49     #)07<     #)07<      
"(.49      	%+04*-/.,)$
  +.00.+'"
  "047740+%	 49<<94.("
 
7<??<70)#7<??<70)#	
49<<94.("
047740+%	    #%&&$#  $&((&$ !&*-//-*&!
%+057750+%
"(/6<??<6/("$+2:AFFA:2+$$,3<DIID<3,$
$+2:AFFA:2+$	                           
             
                                    
                             

!&*.      	#(-1     !'-38     #*18?     $+3;C     $+3;C     #*18?     !'-38,011.*&!
 -1331-(#	  #38;;83-'!8?CC?81*#;CHHC;3+$;CHHC;3+$8?CC?81*#38;;83-'!>%*-/0/,,*% F5&+.00.+&!C6).2442.)$
@D,158851,& 	<A9379973-'!	7<;269962-' 	16:346640+%	*.21/11/,'"
"&*,*++*'# #%%''%# 	                           
             	             	             	             	             
                          	                   

 &,1      
%*04     !'.49     #*18>     $+3:A     $+29@     ")/6<      
 &+15      
"'+/      #')36641,& 
  046640*%
  49<<94.'! 8>BB>81*# :AEEA:3+$  9@DD@92+$  6<??<6/)"  158851+& 
   +/00/+'"
   ')++)'#     J8&           LKLM' ((      QONNMPQQ(     VSRQQPQQ(     XVUTTTUU?    YXWWWXXYZZC  YXXXYZ[\^__^E  R;&           TQOL% $$      YUQNLJHH$     \XUQNKIH$     ^ZWTQNKI6    _[XURPNLIG4  ^[XUSQOMLJHF2  fa`^\ZWSPmfc`^[WTQqmjifb]YUqqpokfa\Xqrrqmhc^Zromjfhc_[pkid^VN^[ ##'+.159$#&*.26:$$'+/38<$$'+048=$$'+048=$$'+/37;$#&*.159:=:>:=:><A=B=B;@9>  dfbZRJC=XZWRLE?:NPNJE@;6EGEC?;72>?><962.:87631-,4210.+)'.,+*)'$#++*)(&#!$           1         
/+       ,(%!     
)&"	    	&#
 
"
 
!&+..27;?B"',16:>AD$*/49>CGK!',28>DJOT#)/5;BIQX]%*17>FNW`d %+29@HR\hn &,29AJS_lu"'-4:?GQ\iu   FVYZZZYWT@KWYZZWTSETY\\[XTSOX]``^ZUTT\beea\UT[cilje^UT`jrvrj`VScnw{wncXTfqy{wqf[U   4             C#           >A,
         
9;61 	       	661-'"     
51-($   1,($  +&# &$!
 
!$%)-26:#',159D
 %*/49=L	"',27=EO
$)/5;AIQ%+17>EMV &,28@HQ\!&,29@IS_
"(-17?GP\   _^ZUQJD>Z\YTNGAPRPLGB=7GIGEA=83@A@>;73/<:9752.+5321/,)&/-,+)'%",++*('$!               
       	            	
      
                  
      	
             	         
	
		

		

  _[XURPNLIGEDCBC2DXUSQOMLJHFCCC@  3HQONMLKJHGD@     @NMMMNOOID      77?FMPaaME      78:?ELVVKE      AHKJGB           7GC@B?;751-D@<840,ID?:61-ME@;62.KE?;62-GB>951-C@<840,   CB?;851-GD@<840,OID?:61-aME@;62.VKE?;62-+HE9IGIKHJLGILFHJCEGCEFIKMQVXY[\[HIKMSW[\\YIKMPU[^`_]JLNQX]acb_ILNRX^bdc`HJLPW\`ba^                             7-     -....-(F<50IKMQVZ\\\[UKE?93HIKMSW[\\YTOIB<6IKMPU[^`_]XRLE>8JLNQX]acb_[TNG?9ILNRX^bdc`[UNG@;HJLPW\`ba^ZTMHD?EGINTY\^][WTQLH!EGINTX[\\ZWVT<        	
  
% 	.)% 3-'"	50*% 93-'"<6/)#>81+$?92)"! @6+    73113577;;6458:<=B>:9:>ACDJ?>=@DHKLQ?@AEKPTVR@BDKRY_aYBCGOXajneCDJS]hszrCFHJNRUVXFHKMOTVXXGJLNPSVWWHJLNNQTUWGIGFKOQST                               8:     !""""!779;:99<@CEEED?879:<;:99=@DEEB>:9:;<<;:;?CHKIEA=9:;<<<;<AFMXSIC>:9:4<;;<AGPlXKD>:61.::9;@EKPMHB=96308879=AEGFC@><96777:>ADEEC@?>,      @@AACEJNQRS  >>?@ABEGLPRTV,<=>?ACFHJNRUVX9:;<>ACFHKMOTVXX9:;>@BEGJLNPSVWV9;=?ACEHJLNNQTUU:<>?ACEGIGFKOQST;<>?A8DGIJEHLPRS;<=7/.9$$$"    :41(          1+            :99<?ABDED;:99=@DEEB<;:;?CHKIE<<;<AFMXSI<;;<AGPlXK::9;@EKPMH$:;0:=<;=<<<<;;::988877zth\QG>6/("wsh[PG>6/("pmdYOE=5.("fd]TKC;4-'!_[UNG?82+%UQMHB;5/)#
LIFA<71,&!EC@=83.)$
)GJNT_kw|qEGJNT^jv~{qDGJMR[eotrjCEHKNU]dhfaACEGIOUY\[W?@ABDHLPQQN;<<=>AEGHHF78999<?ABB@\OE@>=<;;;::99[OEB@?>>=====>WLECA@@@@AABBDQHDBAAABBCDEGHJDAAAABBDEGHJKC>9775ABDFHKMO=951,'"$-,LOQ952.)%!
&*-13577;)-158:<=B-26:>ACDJ16;@DHKLQ4:@EKPTVR7=DKRY_aY9@GOXajne !IR\gqwrYXWWWXXYZZZZ[[[BXXYZ[\^__^\Z[  	7O[]^`bcb`^[     O_bdeecb_      JIT]efdca      JJNV\acc`      %$$(C_``^           G^ZEFKT^itz}EEKU_kv}|EELU^hqv{ !#%&'(# !""  >>DLSYagj@?CKT]flz@@FNYes}>@FOZgx{<?EMWbnvj9<BIQYaeZ79>DJPTWO76:?CGJLM6359<?BCI3.0369:;A/*+.02349*%&(+,-.2& !#%&'(,! !""&  ECB@>:620/*% IDCB@=950+&!
NIGFDA=83.)#RNLKIEA<61+& URQOLID>93-'"VUTROKFA;5/)#VVUTQLGB<5/)#VVUTQLGB<5/)#VUTROKFA;5/)#URQOLID>93-'"RNLKIEA<61+& NIGFDA=83.)#IFFDB>:62.)$	
	

	
	
		::987641.9::9752/+=>>=:841-BDDB?;840HKKHD?:62OVVOHB=83VmmVKD>84VmmVKD>84OVVOHB=83HKKHD?:62BDDB?;840=>>=:841-<<<;9741-   IBA@>;7+62,'!QIGEC@<961+%XPNMJFA<71,&!^XVTQLGA;5/)#_^][WQKE>81+% _bca\VOHA:3-'!bghe`YQJB;4.("gjifaZRKC<5.("iihe`YQJB;4.("	
	


Xab_[UNG@93-QZ[YUPJD=71+IRTROJE@:4.)BKLKHD@;60+&;CECA>:61-(#4<=<;851-($/56642/,($ -/0/.,)'# -+))(&%$+%##"$(#%,'! *+% +/*$!2.("	62,'!	3-&!1+%.)#
+&!(#
$
 
  	  	            	      =88753/,)&"D<:9752.*&"KCA@>;73/*&!SKHGEA=84/)$ZRPOLGC=82-'"`ZXVRMHB<60*$a`_]XSLF?82,& adeb]WPHA:4-'!dhie`YRJC;5.("hjifaZRJC<5.("jhgd_XQIB;4.'"hdb_[UNG@93-&!d][YUPJD=71+%
	



 !$(+/25#'*.146	
!%),047:
"&+/37;> $(,059>C %)-26;AF!%).27<BI!%).27<BI %)-26;AF $(,059>C
"&+/37;>	
!%),047:
!#'+.258 89:987652/+(68::9853/,)&:<>>=;852.*(>ACDC@<951-*CGKKIE@<73.+FMUWQJC>94/,ISfsZME?:50-ISfsZME?:50-FMUWQJC>94/,CGKKIE@<73.+>ACDC@<951-*:<>>=;852.*(9;<<;9852.+'                                                                                    









  KIHFEDA<PJIGEB=9VOMLIFA<[UTROKF@^ZYWTOIC`^][WRLF``_]YTMG``_]YTMG`^][WRLF^ZYWTOIC[UTROKF@VOMLIFA<PLLJHEA<}vo~xqj{sl~voyq{s{s{s{syq~vo{sl{tm e_XRLF@>=83-(#jc]WQKE?94.)$lf_XRLF@:5/*% ohaZTNGA<60+&!qjc\UOIC=71,&!skd]VPIC=72,'"sld]WPJD>82-'"sld]WPJD>82-'"skd]VPIC=72,'"qjc\UOIC=71,&!ohaZTNGA<60+&!lf_XRLF@:5/*% jc]VPJD?<60+&! 







                     






	
			   			                                                                                                                                                          	                                   #            &             )
               	
  
  

 	 	 	 
  

                                                                                                                                                             
                   	        	
       	
      	
!     	"(     !'/    
!&-6   	
!%*3;   	
!%*3;    $(.7@  
#'+1:D  !%*.4=F 	$(-16?H!&+/48@I
#(-26;@I	!%*/49>CI"',16;@EK$(-28=BHM	
 %*/49?DJO	

!&+05:@FKQ

!',16<AGMS
"',17<BHNT"'-27=BHNT"'-27=BHNT"(-27=CHNU"'-27=BHNT"',17<BHNT!',16<AGMS      		    	
  



   "#$$%% "$%'())** #&()*,-./// $),/122223445!'-269;<<;989::"(/5;@CEFFDB@??@'/7>DIMOPONKHEEE-6>ELRVXYXVTPLKK3;DLTZ^aa`^[XTQQ3;DLTZ^aa`^[XTQQ7@IRZ`ehhgeb_[XX:DMV^ejmnmkhea^_=FPYahmprqpnkhef?HQZbinrtttrpmlm@IRZbiosuwwvustu@IRZbinsvyzzyz|}CIQYahnswz|~EKQX_gmsx|HMSY_flsyJOU[bhov}KQW^dkrzMSY`fnu}NTZahowNT[biqyNT[biqyNU[biqyNT[biqyNTZahowMSY`fnu}				
		    %%%%$$#" !****))('%%/////.-,*(45544321/-::::987642?@@??>=;97EEEEDCB@?<KKKKJIHFDAQQQQPOMLIF  QQQQPOMLIIXXXWVUSQON^__^][ZWTTeffedb`]ZYlmmlkifd`_tuutrpmjfe|}}|zxtqlj|wro~ysx~ƾ  ƾƾ  aghe`YQJB;4.("[bca\VOHA:4/)$S\][WQKE@<72-(#LTVTQLIEB=950+&!DLNMKJHEB?;73.*%>EGGHHGEC@=961-(;>ADEFEDCA>;840+:;>ACDDDCB@=:73/:8:>@BCCCBA?=:62857;=@ABCCBA?=955248;>@BCDDCB@=92.159<?ACDEEEC@>.+.26:=@CEFGGFEE+(+/48<?BEHIJKLL($',15:>BEILORTT"',15:>BEILORTT$).37<AEJPUY[[ %*/5:@GNU[_bb"(.4;BIQX_dgg"(.5<CJRZafii"(.5;CJRY`eii!'-4:AHPW]bee &,28?FLSX]__$*06<BHMRVXX"'-28=CGLOPP$)/48=AEGHH%-0037;>@AA
*/.,+.2579::#&!*%-(#0+&3/*&62-(951-=963@><9EEC@LLKGTTRNTTRR[[YXbb_]ggdaiifbiieaeeb^__][XXVUPPONHHGGAA@@::99	                   	

	     	      
                          
             		  	

	     		  

    

 

 479::96.123320(+,--,)"%&&&&$!!!  !      */.%'/.-%
?94.$'/.-%B<621/.-&F@930.,'
JB<5/,(LD=6/*#ME=60)#PD=6/)#SB<5.("U@93-'!
V<60+%J83-("H4/*% 	F/+&!
D*&"A%"
	   A%"
	? 
 >                                                                                        	             
             
             	                                                       

 


	"$# 
 $&&#
 $&&#	"$# 


   




	









                                                                        	                                                               	                                          
 	  
 	 	 ""!%'&#
#(*)& 	#(*)& 	!%'&#
	 ""	 
 
  z|y      Ŀ                                          	            
           
                      
           
                      
            
            	              	

	 

  	

	 

 $''$
$*//*$'/55/'
'/55/'
$*//*$$''$


 	

	 	

	  "'!&+#(-  !   !%*/!%&&&&%$$$$&,1 &+--,*)'&&&'-3")/21/-+)(''(.3")/21/-+)(''(.3 &+--,*)'&&&'-3!%&&&&%$$$$&,1  !   !%*/#(-!&+).38<ADGGHIHFC?:&+/49=BEHIIGD@;7(-27<BGKNPOMID?:*/5;AGMSXZZVPJD>,17>ELT\cgf`XPHA-39@GPZdourj_ULD.3:AIR]jw|pcWME.3:AIR]jw|pcWME-39@GPZdourj_ULD,17>ELT\cgf`XPHA*/5;AGMSXZZVPJD>(-27<BGKNPOMID?:(-27<AFJLMMKHD?:83.*)'#!;72-($" ?:4/*&%#D>82-)('HA:4/,+)LD<60.-+ME=71/.,ME=71/.,LD<60.-+HA:4/,+)D>82-)('?:4/*&%#<72-*&$#              	             
                        
           	
           
                    
           

           	           
                          
 	
  

		#&'% 
"(-.+%
%,240(!%,240(!
"(-.+%
	#&'% 
	 
 
                                	                   
                           
                  	                                        	                        
       
 ""       	 $''       
"'**       
"'**       	 $''       
 ""       
                	
	       
 "" 
 ''$ 	 **'"
 **'"
 ''$ 	 "" 
 
   
       	  

  

     

   

   */456:&+059=).38=A+16<AE-39>DI/5;AFK/5<BGL/5<BGL/5;AFK-39>DI+16<AE).38=A).37:>             
  !  "%'&&&%  	 ',.-,+)  
#*1420-+  
#*1420-+  	 ',.-,+)  "%'&&&%  
  !       #("',$).!!!!"&+1%%%%%'-3)(''').5+)(((*/5+)(((*/5)(''').5%%%%%'-3!!!!"&+1$)."',9300+=72-(@;5/*E?82,IB;4.LD=6/ME>70ME>70LD=6/IB;4.E?82,@;5/*>830*     !!!#%' !!"$&(
 "###%(*+ "$%&&(+-."$&'((+.01 #&'))*-/13!$&()*+.024!$&()*+.024 #&'))*-/13"$&'((+.01 "$%&&(+-.
 "###%(*+
 !"""#&(* )****)))),/358()****))+/2579+,----,,-148:=./00000/048;?B1233333226:?DH3445554448=BHO4556665558>DKV4556665558>DKV3445554448=BHO1233333226:?DH./00000/048;?B+,----,,-148:=*+,,,,++,/369;  $  '#
  )%!
  ,(# .*%!
 /+'"
 0,'"	 0,'"	 /+'"
 .*%!
 ,(# )%!
  '#  



	

					
	

	
	  &*/37:<>>B(-27;>ABCE*/59=ADEFG+16;?CEGHH+16;?CEGHH*/59=ADEFG(-27;>ABCE&+048;>?@B!&	#(
%*
 &+



	
          /,)%!          &"                                                      >BC@;61,'"  ,852-)%!    "-*&"     ''"     '%#
      

   /5;BILIFE?82,'"-06=DJLG@93.)$.28@JUYPE<5/*$ .3:CPdnYH>60*% .39BM^dUG=60*% -17>FMPJB:4.)$+.49>BC@;61,'"   

	    %*/4;CMTMC;4/$(-27=BDB=72-"&*/37:;:73/* $'+.13431.+'!$'*,...,*'$ #&')))'&# !#$$$#!

	
	




/*% -($*&"'$ $! 	

	                          
 %*06=G 
 %*/4;C  GYnYG=60*% CMTMC;4/*%             	          	          	          
                                   "'+/   	
!%*.2  	
#',05  
 $).39  
 %*/5<  
 %*06=  
 %*/4;   5798630/-)$ 2589852.*%!5:>?>:50,'#9@GKG@93.)$ <ETaTE<5/*% =GYnYG=60*% ;CMTMC;4/*%   &+  
  %+055/' 
  (-144.&  (,//-)#  ')*)&"
   %%%#         	
   	
 !"   
 #&'(  !%),./  	!&*.246 %*/48;=  """!()('///-6653=><:                                                    
    %55/' 
         	
     
    	   	
  	
 !"""
""!   	 	


 !%$(!%(!$' #%    %	   
"(    	%+    
 &-	  
!'.
	
!'.

 &-
	%+!!
	
"())&!%11,%	!55/' 
44.&
--)#	
%%"
  	
%%"
  	

			








!"##"!"$'())('$"#'*-/00/-*'##',03677630,'!!"',16:=??=:61,$$%*06<AFHHFA<60&&'-3:AHNQQNHA:3&')/6=FNUZZUNF=6&')/6=FNUZZUNF=6&')07?HQZ__ZQH?7%&)07?HQZ__ZQH?7#$(/6=FNUZZUNF=6!'-3:AHNQQNHA:3%*/48;=><:"(.49>BDEC@%+17>CHKLJF&-3:AHMPQOJ'.4<CJPSTRM'.4<CJPSTRM&-3:AHMPQOJ%+17>CHKLJF"(.49ADDEC@%*/5=DG><:!&*19@EJ;3!&-4;@EID!(/6;@DH$*06;@D
%+05:?   
%+05:?	%*/49	

$).2


"&*

"


 


  "
  '#	 ,'# 1,'"	 60*$:3-'!=6/("
   =6/("
?70)#
?70)#
=6/("
:3-'!  #%%%# !! 
	






!!		!&))
	%,11
 '/55    &.44     #)-- 
"%%

"%%
	

 
 


  
	  

     !       #      %$#""!!    &%%$$$    ''&&&&    ''&&&'    &&&&'
                                                                               ''&&&'        &&&&'        $$%%&        """#$        ! 	  %	  +%#"!	 1+))'%" 310/.+($ 
368641-)$
6=?>;72-(#
=FHFB=82,& EOQNIC<5/("
    
"    (    !'  
"&&$ )& 	!&*+()*( 	"(,-,-+)
	!&*-.,*(
"(,--*(
%)+,+)&&$"""! $!(%"!'# )&$!*(%"+)&"*(%"*(%"+)'%" !!!  
%)+,+)	 !&(***	 	"&()*	  #&()	    #&)
    !%*    
"'-
    	#)0     	$*1     	&.6      	"*19      	%-4<       	 (/7>       
"*19@       $+3:A       $+3:A      
%-4<B     	&.6=C     '/6>E     	
'/7?F    
&/7@H    &.7@I    
#(.6@J    #(.38?I  !',27<BI 
%*05:?DJ
!',26;@DI"(.27;?CF
#).26:=@B
!&*3:<=
!&*3:<=     %(,    	
 #&      
!       
+)'%" !!! !**('%%'''&&)**))+-.-,,()*+/245433&),059;=<::%*05;@DFEBA'-4:AHMPOJH)06>FOVZXSM*19BKU^caYP.6>GQ[eif]S19BJT]eif^U4<DLT[ada[U7>FMSY]^\WR9@GMRWYZXTP:AGMRUWWUQM   :AGMRUWWUQL<BHMRTUUROJ=CINRTUTQMI>EKPSUUTPLH?FMRVWWTPKG@HOUY[YVQKF@IRY^_]XQJD@JT^deaZQIC?IUaijdZPGABIS_ijbWMC=DJQZaa[QG>9DINSWWRKC;6CFIKLLID=73@BCCCC@<82/<==<::862-+   <==<::862-)(,/1221/,($#&)+,,+)&# !#%%%%#! [SQNIC<5/("
^ZYVOG?81*$	\^^ZSJA92+%	V\^ZSJA92+%	NWYVOG?81*$	FOQNIC<5/("
>FHFB=82,& <>?>;72-(#
<98641-)$
920/.+($ 
2+))'%" +%#"!	 %	     
    
	     
    	                                                                                                                                                                                                   
                                                                                 
  

 

LLKJJFOLLJGBPOOMJDPPQOLFPPPOKEPMMLHCMHHFD?           $        %         %        %        
$         	"$%                                               

               
#	      %,&!   !<5/)#   D>81*$
   F?92+%
   E?81+$
   C=70*#
   ?:4.("    
#'  	!&)  
#'+  
$(,  $(,  
#(+  	"&*  
 %(         .*       
$      6,&    !@@A=81,($  -?AAA><951,(%5:=?BDEDA<61+&),26<BINONIB;5.&&*18?HPX[XPH?81%+2:BLV`d`VLB:2 %,2:CMXbfbXMC:2%+29AJT\`\TJA92$)06>EMSUSME>60"'-39?EIJIE?93-! $   ($	 ,(# 1+& 
5.(#	81*$
:2+%:2,% 92+%60)$
3-'"	(+.////.+(%&),.//.,)&#'+.0110.+'$(,/1221/,(%(,/2332/,(%(+/1221/+(%&*-/00/-*&#          
"'*       	"%  **'%%$  
&%# 
   ,,+)&"
   



 !""!!!$&(((''#'*,.//--#(,0356643"',169<==;7%+06;?BDCA='-4:@EIJJGB)/6=CIMOOLG*17?ELPRRNJ*17?ELPRRNJ)/6=CIMOOLI'-4:@EIJJGE)/6=CIMOOLG'-4:@EIJJGB%+06;?BDCA="',169<==;7#(,0356641#'*,.//-*!$&((('$ """!


	


       	         	            %!	   )%   -(#
  0+%	  3-'!
  4.("  0.("  /-'!
  .+%	   &(%#!!  # )&# "(%"+(&# ,*'$!-*'$!,)'$!,)&$!+*(&$!   ++*('%%&&%"*+++**+,,+()+,,-02331.(*,/369::84&*.39>ACC@;&,28?EKNMHB(.4<DMUZYQI&,28?EKNMHE(.4<DMUZYQL)07@IU`gdYQ,4<EO[gok^T08@HQ[ekh]T3;BJRY`c`YQ6=DJQW[\ZUO8>EKPTWWUQL9@FKPSUTRNK;AGLPRSSPMI<BHMPRSROKH=DJORTTROKG>ELQTVUSOJF?GNTXYXUPJE@IQX]^\WPID@JT]de`YQHC@IQX]^\WPID@JT]de`YQHB>IUajkdZPF?>GS`klcWLC;=EPZbc[QF=7:BJRWWRJB:46=CHLLHC=6127<@BB@<72/-15899851-+(+.1221.+(&#&(*++*(&#"!#$%%$#! 556530,'#
 54431.*&!
       	#-1(      $ 852.*$	
7530+& 


5431-(!
		3332/)# 02342,$
	  ,/27<0$	  '*.6B/#	  !$'*+' 
	   !    !)1860##")/11*%$),.//
$(+-/

 %(+-	 $(*!)%3-$C8( :3')&!


 
	
	
'$.*$2-&/+%(%                                                                                                 	  
	 
 	             
           !&+     
  
   
 





                                  	
	

 	


                                             

	&$#!-,*(&4310-;:874B@?>< 	  	%+1
 
#("  	   	         
         
          +17("  	   0:3-'"
 '/*% 
                 



   %$&&&++---224549:<=<@ADEDFIMNMJOTUTLRXZXMRWZWKNSUSFHLML?ADED99;<;2244459;<;.2444*+,-,()*++06<CH,17<@(-158$(,/1 #&)+!#%    	                 	
	   ##'     

!"!  "$&&%#$*,,*(*1320.08::747@CB?:/JNLG@&V[WOF  d\[WOFdefaVJ[ejdWKV\a]SHVTTQKCTJHGC=K@?>;7B87641
  

	                                                                                    	   P[_[TKHQUSMFDHKIE@DBA@=9B:9863  
$*#!! 1)((&$61//-+7776417=@?<8=FIHD?EPSQLFNX[YSKV]_]VM/]]ZTK

 

PONLKJHHHFEB@>>QPOMLKIHGEC@>>=VTSQPNMLKJHFDCB[YWVTSRQPPONLKI`^[YXVUUUVWXWVQc`^\ZYXXYZ]chf\eb_][ZYYZ]bm}feb_][ZYYZ]bm}fc`^\ZYXXYZ]chf\`^[YXVUUUVWXWVQ[YWVTSRQPPONLKIVTSQPNMLKJHFDCBTRQPNMLKJIGEBBA <997=;85B?<8IEA<QKE?\QIBfVKCfVKC\QIBQKE?IEA<B?<8@=;8'&%*'#,)%/,(1.*3/+40,40,3/+1.*/,(,)%+(% MMMJIHE@;QMMLJFB=7YSTROKF@;a\\[WQKE?hddb^WPIBmjkhc\TLDnnolf^VMEnnolf^VMEmjkhc\TLDhddb^WPIBa\\[WQKE?YSTROKF@;RQQPMJFA;   SPPOLID?9[VVURMHB<a]]\XSMF@fcdb]WQJBhghfa[SLDhijgc\UMEhhjie_XPDhikjfaZSBggiifb\U@feggea\V<cbdec`\J8a`bcb`\H4^]`aa_\F/\\^``_]D*ZZ]_`_]A% XZ]_`_]A%XY]_``^? XX\_aa`> OX\_aa`_5X\`bcba8W\`cedd<V\aeggf@U\bfiihBSZafjkiDPX_eijiEMU\cgjiDLS[afhiBJQW]bde@FMSX\]_<BHMRUVX8=BGKMNP48=ADFGH/37:=>?A/37:=>?=*.146886%(+.0112 #&()++-#'*.145689::=@ $(+/2579::=@B"&)-148:=>>ADF!#',048;?BDEHJK"%)-26:?DHKMOPP#&*.38=BHOVYWUT#&*/48>DKVmp^XV#&*/48>DKVmp^XV#&*.38=BHOVYWUT"%)-26:?DHKMOPP!#',048;?BDEHJK"&)-148:=>>ADF"&*-1479;<=?BD DEEFBDFGFHJKKMNOPQRSTTTUVUUVVUUVTTTUPQRSKMNOFHJKEGHJ12210122141211121295667898:?;<?ABBABHBFIKKKJKTLRTUUTRSaY_a`^\ZZphqqlgdaat{vojgex|snkh{|ytpnlvsyxtrponpnrsqooonlknpomlmnihkmmljklgfhjjjhgifhkmmljkkcfhjjjhgg`cefgfecb__abcba_^][]^^]\ZZYVWXXXWUT             	



 % "$&+"%(*,2'*-028,0368>058;>C59=ADH  8>CGJLMML>CHLNPQPODHMPSTTSQ 058;>CHLNPQPOMJG59=ADHMPSTTSQOLH8=BFILQTVWVUSPLH@AFJNPSWXYXVSPLGEEINQTUXZYXVROJFEGKPTVWXYXWTPLHFKNQTWXWWVTQMKJH QSUWWWTSQNKKK7JGC>94LHD>+
LHC?  LGB?  JFA@  H    !"#%###,)%$2.*'73/+;72.?:51A=73C>94D>94     "#"! **)(%#110.,)87652.>=<:73CBA>;7HGEB?:LJHEA=OMJGC>QOLHD>  TUVVWWWVVVVVUFXWVUTR+ $*/4#',28 %).26;!&+/48=B%"',059>CG*(-16:?CGL--26;?CGLP.27;?CGKOS27<@DGKNQU7<AEHKNQSV<%*.26QSUV
TUVV
VVVV  DGKNQUX[_HKNQSVX[]26QSUVXYZTUVVWWWVVVVVUF   	
 #&(*,-#&*,/01
$(+/2578#(,048;>?

"&+05:>BEG$*/4:?DILO#',28>DJPTX %).26;BIPW\a!&+/48=BFMT\di"',059>CGMRXaio"(-16:?CGLQW]ckq(-26;?CGLPUZ_ejo-27;?CGKOSW[`dhj27<@DGKNQUX[_bdd7<AEHKNQSVX[]^_^SVX[]^_^UVXYZZZXVVWWWVMGVVVUF=?A,--00127788>>?@EEGGNLOPVTXY`\abddikeioqmkqtrjoqshjkpddbi_^[`_^[TZXRKMGGJ?AAEXRQOKGA<60+%^ZYVRLF@:4-'"c`_[WQJC<6/)#dcb_YSLE>70*$dcb_YSLE>71+$c`_[WQJC=94/#^[ZWSLGC?;73%





WQJC=94/#)LGC?;73% 6C@=96- )+7LKIGC>963/+'')FNMKHD?941-)%+FPOMKHC>92.+(#   UUTQNHRQOLHCOMJGC>LIFB>9HEB>94EA=94/A=94/+<84/+(73/*%'2.)% #-($'"!


  
$(,/245788"',/368:;<=%*.258;=>@A &+/37:<>@AC &+/37:<>@AC%*.258;=>@A#(,0469;<<=8889<>??><952.*&<=>>AEGGEA=951,(@ABCGMRRMGA<73.*ACDFKVjjVKD>84/*ACDFKVjjVKD>84/*@ABCGMRRMGA<73.*<=>>AEGGEA=951,(*&",($.*%/*&/*&.*%,($   LQUXYUHMQSTQEIMOPQ  >@ABCGMRRMGA<73.5<=>>AEGGEA=951,./6::=@AA@=:63/+3.*%1,($/+'#	!
 	    #(  "&%" $   HEIMOQNKOQSTUQTVWW\X[\[Zf_ba_]qiigc_ysqlf`|zwnf^|zwmc[ysph_VqhfaYQf]\XRL[SROKFQJIGD@HDCA?;   :GA:4/+$"  2=841-((   ,8530,+ ,642/-


-5310
1866! "$7<<,%),../0;@0158:;;:<>3<@DFGGFEE>GKNQRRQQNHQUXZ\\\\YRZ^aceeffcZbfiklnopmbilprtvwxvjqtwz|~}nilprtvwxyuqtwz|~|x{~~z}xrux|oiloqtvwuugbbdfhhhff`ZZYZ[[ZXYXRRQPONMKKQPPOMLKJHE  +)'$#"/+)&#71/,)% ?9741,("&GA?<84/)-NHFC?;603UOMJGB=6;ZVTQNID?E\\[XUSOJI^baa`^ZULchkmmjf`Vipuyzxslaqxwlxw~zs|kt}cksy}Zbiotz~RY`hnty}{ORZbiouyyNMU\ciotyJHOV]cintEBIPW]chn?<CJPV[`g96<CHNSX_2/5;AFKOW,(.49>BFN&(.37:?CF   
	    
"($ .*('$,33330/:=?><3DGIIF>LPRRPHTY[[YR[`bca[afiihcgknooiafiihmgknootkprtu{osuw{ruw|uvzwx|xx|tuyopu{ikou{bfjns{\aeilsUZ^bflOSX[^eHLPTV]GLOQTV  
&0" (00)$&-.0011,01111293466446C;;=<:8:NFEDB?;:QQPLHD<3U][VNG=6`he_WME=ktoh_UOFwypf^ZQvmhd[{uqme|yun{uqmr|yuz}zty~msyjms~ifmyc`fq~]Y_iuVRW_iszNJOU]ejwGBGKQW[g?:?BEJMX89=@BEIL+/1245(,0358+0479?/49=@F28>DGP8=DKR^?DJU`pFLVbqLT`nR\gvXalx]enw`hntx~cinrsweimonqeikkjmeimonjeikkjfeghheadeec`[bba^[K^][YU)ZXURN'VSOKG3QLGC?-LE?:6&E>61,=7/)#4.(".("*$% #	  =<:8663/*B=<:740+(LDCA>:61/VNLJFB>96`XVRNJFA>ib^ZVRNHFrkfb^ZUPMxrmiea\WUzxsnkgc_[{|wspmjga}}yvtrqni~|ywwwwxt|yxxx{xtuvzsoqu|mims|joqu|dims|]chqzU\dmwEV_irzPYcltz} JS\dlrusCLT]dilj;DLT[_bc 2;DKQVZ_)2:BGMSX )18@GLQ
(19@EJ"+29=B	$+15:#)-2
 &*-      1   -   '   !    	    	                  
	

	
	





			

		


	
 %&(.38
"',27<#)/4:@ &+18>D"'-4:AH#)/5<CJ#)/6=DL#)/6=DL#)/5<CJ"'-4:AH &+18>D#)/4:@$(,28=  	
	


		
 #$%%%$#" !#(*+++*)'%"!#$&.01110/-*'$$%&()468887530,('()*+:=???><951-++,,-ADFGGEB?;61.....GKNPOMJE@;51////NSWYXUQKE?9310//U[`bb^XQJC=610/.[bilkf_VNF?82/.-[bilkf_VNF?82/.-_hosqlcZQIA93.,*`jqutne[RIA:3-)(
 &+05X"(-38W%+06<V!'-39@U!#(.5<BS!#$'*/6=DP$&(*,06=EM()+,.16=DL*+-.025<BJ,-./0249@F../01236<B////01138=//..///048/.---,,,/3.-,+**)(*.  .-,+**)(*.,*)('&%$%()(&%$"!  #  

 	   
  	                                                                                                                                     	

	

!#$!$&(*"&),.0"&*.146"&+/37:="%*/48=AD%(-38>CGK'+06<BINS*-39@GNU[++06<BINS--39@GNU[./5<CJR[b.06=EMU_h.06>EMV`j   @?>;84/-,(#A@?=:73.)$
DCB?=950+& FEDB?;72-'"HGFDA=83.(#
HHGDA=83.)#
GGFDA=83.(#
FEDB?;72-'"DCB?=950+& @?><962-)$
<;:852.*&!
76531.+'"5432/,)%#              
                                     
            
            
                                    
                                                           0    :  
3  ,   $       	                                 



 "%#'*#(,0#',05'*059).38=!13;A (A  	 &!-(&"2.,($731.*98633:=;:=>A@DGBDGLPEINTYJOU[`OTZafTX`gkVTZafZX`gk_]dkpdbhoskgmruvptuvwxuxxmuztukgmopb^eikZV]bfSPW\aLIPUZFCIOS?<BHL9<AEI   "#%)#(,! &+0%#)/4,(-283/48=96;?D?<AFLABGLTCHLR\HMQXaMQU]eQUY`hUY]ciY\_ei]_aei_\_eib_aeidbcegfdcdefebbbee`^]cd^ZX`a\VS]]XQL\WRLEVOKE>NGB=7F@:4.@:4.(:4/*$4/*% /,)%    |}|zvz||}|vwwtqoqrrqopomm  ~swz|kloqmty~hioshOgk^dikidZ`ded`TY\^\Y  chq}plgl`blywtop_[fs{~{wq    ,   A  %G  (LF@:7  &JD>86  %FA<66FIIGD@@AA?=:@=:864  X`hnZ?:TX_fS95SRY`M43   oqrrqopomi/Xfffghgeb/B]T\^_^\\  swz||}|vwwtphloqrrqopomjbZfXfffghgeeffghgeaA\^_^\Y6VWOUSS   Z`ded`TY\^\YNRUUURGJMMMJ@CEEEC  \blywtotU[fs{~{wzQT_mt{}}PLWfmsy}}ICO^ekqux   :864 &0. +(?A?=:8:86475&0. 00.()((&      A  %G  RN .bmo}  &JD>85  %FA<62  "B=831   =94/0  840+-26<AF% 138=B" 005:>     vv{~yy|~Jyw}}{l:b*.259=CGKN 79>BEG 65:>AC    rAaBzHGsvyymHW]chm.+TW]bf*(SRW\a'&   ~ vy~  {}   oruxxvvvvww}||{{~~{x{{yxxxxxR[cjnqrrqpoWajrwyyxvus]iu~|zxcq~{gv}gx~et|`mz|zZeox}~|ywvT]elqtttsrq  FRMWR]VcXgYgWeT`OZJT                                   

 $))$	  q|~~{koqqRjfhiD [2}jzx@||~~{wgxoqqgpU  ??T??zlFFn~zVħ~z|wsotpjf038=ACFHII227<ADGIJJ339>CGJLLL34:?DHKMNM24:?DHKMNM239>CGJLLL227<ADGIJJ0059>ADFFG.-26:=@ABC+).258;<=>''+/257899  zskxrkgqkZ`fOħx~zupsrmazswo{sk~vnfyqhbzrjb]zskc[Wxrke]GNbMMJF[z|yt  DKfz|ytClyǬ}woxgntx{{y^dimoonvUZ_bddXkLQUZ\\0>??CG??ClJh05:>Cl/4Qg@\gq}XXblwUT]foxRNW_gnMHPW^dGAHOUZA:AGLQ:390EJUZ_bLQUSEJ=JA:AG:395-3 ./3./44@\       /4%@\0*8MXXX25ALVUT24?JTRN/1<GQMH     	3?JTRN    1<GQMH   	$.8CLGA   
#*4=GA:   !'.7@:3   	$*115-!'.7@$*11!',    !'   	$    
    	                                                       

	   "!
 DLWfmsy}=CO^ekqux<5GV]chlp(!78:Z_cg~]chlpVZ_cg~RMX\^w| cg~Z\w|ZX\`dw~  ~]w~|WQbbm{  "&+/47;@EJMNL!&*.38=BHMQQM"'+05:?FMV__V"',05;AHQ_ww_"',05;AHQ_ww_"'+05:?FMV__V!&*.38=BHMQQM $(-15:>BFHHF"'+.26:=?AA? $(,/258:;;:"&),/246776MJE@;84/+)QMHB=83.**_VMF?:50+*w_QHA;50,*w_QHA;50,*_VMF?:50+*QMHB=83.**HFB>:51-()A?=:62.+'';:852/,($%7642/,)&"#       	                 
 



 YSLE>72ZSLE>72YRLD>72VPIC<60RLF@:4/LHB=71-H2>83.*84/*'  /+&$ bcb^YScdc_ZSaca^YR^_^[VPYZYVRLRSRPLHLNMKHC  $*07>ELSY^bc$*17>ELSZ_cd$*07>DLRY^ac#)/6<CIPV[^_"'-4:@FLRVYZ %+17=BHLPRS#(.38>BFILN %*/48=@CDJ"&+/37:<.C  "&+#" 	
 
 
  

   	               ^_^\X;OUSO:8MLK <   <.%?HIN= D.  EHIN1 EDLRILE   CHIN1    ADLRILE(  @>FMGJNPS9  BJS\dpy@HQ[gt}@HQ[gt}?GOXcmt=DKS[cg:@GMSX[6<AGKOQ37<@DGJ.36:=?B*.1468  |\tQZkra`Gmvu|ypdXRJB;41t}}tg[QH@931t}}tg[QH@931mttmcXOG?820cggc[SKD=600X[[XSMG@:4./OQQOKGA<61,-5A<61,)  <73.)'  
3.*&&   +'#$                       ~}~}z}       2     4c  ]]Sfw  /^[t{  /_  1 o^X|l[VwhXV   K.bmeo}weo}wz)JUZ\_ab 0UZ^acc  F^begf  CKehih  CDNiii  3EEOh`   ""4ME(    GJMMMJ@CEEEC;==>=<<87765UX^cfjmYX^dimo]\chmqsA`fkpsu79Smqtu8<>Lfst>@ACPg 1AACD9?DHJKI79=ACDC659<>??   AEED@:5;=><950788740.   :=>=<567655210/ *0/())(
$   4765./0/.,*)  G@:3.  F@93.  E?82.   igijihlijkkinlooonnntrsrnostuuocruwxb;Hfx{    $,Ub_[Z 
30Ic`\_ *42jifbe 8bRonlhi 8Frssqnj Wuwxwuo ,cx{}~|u  Zuh[Q WtgZP TQLG@@   YgnpqEdors*bvyz#Nq~#GOx#GEJ_ 5FA@ 37:PaZR/13JZSM,-/EUNI   ||w   |~      6h  Xxxsh  uvuz  u {|}xww b  ^j *s  +}  ;  ::  ::7   *3      2ed`geohw   jheokjwj2p 2Y  KO  NNSn  NQRSR  )))PPBBHPU\`bCBGPYaeiCDJitqykXYcnsupkXXamuvomXYcvyzrnSU`jnoiST]honfSS\fmle   ijwa{{yuMNT[bMMS\cKLS[b ZX\ZZ^Z[b   UUY^UU[bST\conlgc[SponiuQR   =9;>?AA=?CFHDADJNQDDIPX^DFMWdpFHO[lGHOZk  CDFHHFCH 9KNQQNKO /TX[[XRV 0_ciic[X 0dmwwnb[ 2kvtf`  t}teb mWRKF@:|vpQj    #1//03//26/048.16:.26;+.26; NQW[\\ZNPVZ\\ZN_h{Y   " :S\c "8S[b1HPW^8?ELSX5;AGMR                                      

                                                    	       - #')-.;K_LP   
      + # ++28>D                #).4                   	      8?ELSX5;AGMR27=BFK  {wtdv   INTY\]\VIINRUVURIFIMOPOQ`bb`\Vadda\VgkkgaZkookd\kookd\gkkgaZadda\VZ\\ZVPRTTRNJJKKJGCDEEDB?     /<60.    <5//   !=710   !>820   !>82/   !=71/    <5//   93--   50++   2-')   .*%%?C5     eztRYY  s}~XZ[  t~[[  s~[  q{ nxr {tGj6  HH=**  EXLTUWB eVXYXkYW|W?DJQVXXQ>?DIMOOL><?DGIHK>DFFC>8;=??=94:8::850   AGMR=BFK8<@D26;>8<@268-25   7;   L^=  `jh  `ktF  `jsp ]gqyJ [envh   .6=EE3 ,3;BHE )18?= &-54  #*+ !        %)-!%
    *.26%)-!% .38<*.26%)-&5;AG27=B.38<*.26LR#3 JP1E ObMV RPMW MMLV GIJT BEHQ  .6=DKP
 ,3;BHN
 )18@JO  &-5@K  #*1:;  &-4 #*0                &/
%-$,   !(/6=  &-4: %+18    5;?DGJI26;>BDD.37:=?A   -5=A9; +3:AB4 (07>2+ %-+&(( !&'( 	   05:=@B2,18=9; '.3635'"')/034*05;@E '-27<A %*/49=         (4B      +7F     *5C     
&1<      !*3      #)       
        
        
            

    "!
  	



   $))$	

      

	
$&#(250%"0>D;,"1@G<-*593'	!'*&
     	  
        	

		
	 !	
   
 " 	&)&	!),)!	
%(%  !" 
	                                                
         
         	        	                 
	         	
                                                      
        
	    
 	     
      

                                


%&"%-/*!(/1,"$+-("$      l         1         +        )       !$&"      %*,( (      	&+-)!	     "&($	            	                

       	     
$%      '-.)
    	*23-"   (/0*    !''#    	      
               

             
  #$!
 

#*,'
$,-) 

!')$

  


  	 	
 	

   	
     
  

     

 		

	     &)&&/3/'$)373+(&/3/)'&)&!  	  


  "!

%)(!'+*#$(& 
 	

 

	



 
	       	 
	




     

	!$"$.30&+:F>/!->LC1"(4<7+'+)"

 !  "  	
               

!"                        
       
      
"&%
    	!*/-%    ",1/(    
(-+$      $"                                                        
         	
        		       

        
                                         

 	 	"$#
$%$  "!      		  	
	   	



	
  

 	 	

	
    	
 	

  !%)'!&'(-31)&(+175, "$&-31)%)'!



 

             
    
!$# 
',*#


 )-,$$)'!

 



  
	 	                

       	       %$
    
).-'   "-32*
    *0/(    #''!
     	       
                      	         

       
        	        "               
	        	

          



!&+16;AFL

!&+05:?EK


 %*/49>CI
	#(-27<BGFLRX^elt|EKPV]cjqxCIOTZagnu|BGLRX^djpw}   ~}z

!',16<AGMS	

!&+05:@FKQ		
 %*/49?DJO		$(-28=BHMMSY`fnu}KQW^dkrzJOU[bhov}HMSY_ekrx{9 9 : 9 8 6 3 / +
*-PG?93-*(&       	       	                      -TMF?82,(%       
       
                      3=BCL.6@IR07AKU08BLV/7AKU-5?HQ+1;CL',5=E"'/6=")07  .8=>F*1:CL+2<EN,3=FO+2<EN)0:BJ'-5>E$(08>!$*17!%+1   $(- #*05'+3:@.3;CJ4:CLT:@JS^?EOZgBITaoCMZiyGRaqLWgxO[k}R]oT_pT_p T_pR^oP[l~LWgyGRarBLZjz@HSap=DOZh9?IS_49BKU-2;CJ&+2:@#*06   "(-2%(.49,/6=C26>FN8=FOX=BLVaAGQ]kDKXevGR^l~LWcsQ[hxT^l}V`nXbpXbp XbpVaoT^l}Q[hyLWcsGQ^l~BKWdu?FP[j<AKT`7<EMV16>EM+/6=C%(.4:   6?IRZahmntz67BKT\ciry~79CMV_elu|69DNX`fnv}59CMV_elu|46AJS[ahpw}33=FNV\bipuy|}|z/.7@HOUY`glprssq*(19AGLPV\aeghge%$,4;AFIMSX[^^^\|vohdc_WND:0{umf`YPG<10~xpic[SI>31yrjd]TJ?40~xpic[SI>3/~ysle_XOF;1.|zwrle_ZSKA8--sqmic\WRLD<2)*geb^XROJD=5,$&^\YUOKHC>7/'!".5?HQY_dda\UMD:0/7AKT\cige`XOF<208BLV^emjgbZQG=3/7BLU^emigaYPG=2.5?IRZajec^VND;0,2<EMU[d^\XQI@7-(.7?GMT[VTPJC;2)#(08?EJRLKGB<4,$")07<@GBA>94-&)0:BKQVXXUPIA8/%+2<EMTY\[XSKC:1',3=FOV[^^ZTMD;2(+3=FNV[]]YTLD;1')1:CLRWZYVQJB9/&'.7?GMQTSPLE>5,#%)19@FJLLIE?80( "%+39>ACCA=81*#!%+158:9840*$"(-25899751,'!%(.49=@BB@<83-' ,/6=CIMRSLGB<5.'26>FNU]cfcRKD=5-8=FOXbowzxhULD;3=BLVaqu]SJA8AGQ]kfZOE<DKXevocWK@GR^l~vj^RFLWcs|pdWKQ[hxui\PT^l}zm`SV`nˮ}pcVXbpմreWXbpضseXXbpضseXVaoѲrdWT^l}Ǭ}obUQ[hyyl_RLWcsth[NGQ^l~|obUIBKWduvh[OD?FP[j}m`UKA<AKT`o}dZOF=7<EMVbozo[RI@816>EMU^gkm\QIA:2+/6=CIOUYRKF@93+%(.4:>BEFC@<71+% $(-145530,'" #*05:=@><94/("'+3:@EJPPGD>81*".3;CJQY^a^NHA:1)4:CLT^flopiRJA8/:@JS^iry|}{pQH?5?EOZgs|sND:BITao|tH>CMZiytAGRaqyLWgxO[k}R]oT_pT_pT_pR^oP[l~LWgyGRarBLZjzT@HSap~ZC=DOZht^I?9?IS_ku|~`ND:49BKU`iptvu^OG>4-2;CJS\bfhXMG?7.&+2:@FNSWOHC=6/'#*06;?DC@=93-&&         '"
        (#	        )$	        )$	        )$	        (#	        '"
        &         $
        !
         "	         #	         #
         #	         "	         !
                   
         	                                                                                        
   	  
((('!1110/9:::98#,BCCCBA5#JKKLKKJI                                                                              	  
 	!! 	())(	!11110
899998#
+@AABAA5"GHIJJIIH bemu|yunf_WPH@edmu~~vmf^VNG?ghq{|ri`XPH@gis~tjbYQIAfir|}sjaYQIAefnwxog`XPH@dcjpvyzvqjd]UNF>`^dimppnje_YRKC<[Y^beggfc_ZTNG@9VX]adeeca^YTNGA9D=7G?6H@8IA9IA9H@8F>6C<4@91=62  `cjqvzyvsmf_WOG?dcjqx|}ztme^VNF>ffox|sjaYPH@gir~wlcZRIAgisxmd[RIAfhq}vlbYQI@eemv{qh_WOG>b`gnuyzwqjc[SLD<]Zafknnlhc]VOH@8XZ`eikkigb]VOHA9C<7F>6H@7IA8IA8I@8G>6D<4@81=61  ~zty|~~~~~qrwz||}}}}}}~}{|w  <9=@CFHGHIJJIIH;D?CFILNOPQRRRQPOLGKORTVWXYYZZYYXUPTWZ\^_`aaabaa`^X]`cefgghhiiiiihbfjlmnnooopqqrrslqtuuuuuuvvwxz{yx}~}|{{{|}{zvw|~~}|{zzz{{}~rnsvwwvvvvvvwxyyHIGDA><POMKHDCYXVTQMLa`_]ZVUiihfc`^rrqpnjiz{{{yut~   ~{wyyyywsp   @<@DGIKJKKLKKJI;ICGKNPRSTTTTTSRPRLPTWY[\\]]]]\[Y[UZ]`bdeeeeeeedce_dgjklmmnnnmmmloimqstuuuuuuuuuuxsw{|}}}}|||}}~~}|~}z|wty|~~~~}}||||}}IIGDA=;RPNKHDB[YWUQMLdca^[WUmljhe`_uutroki~~~}zvt}   |w}}|{xtp   5;AHNU6<BIPW6<CJPX6<CJPX6<BIPW5;AHNU4:@FLS  GIIIIGFHIIHEIJKKJGJLMMLIKLNNLJJLMMLIIJKKJG  478543.)#757750*%?;??;4.'!CBHHB:1*#DFNNF<3+$CELLE<3+$A?CC?70)";7::71+% 4/11/+&",)++)&#  wvsppmhwwurnid}}zvrmgzupj{vqkzupj}}zvrmg      9?EFI;6:AGN 6;AHN 6;AHN 6:AGN 59@FL 48>DJ   ]YWWVT[^VVUQ_bZZXTaf]][Wbg^^\Xaf]][W_bZZXT  Vjggd_kiea^pmhdaspkfcuqlgcspkfcpmhda   )*+,,-.))*,--.))+,-..))+,-..))*,--.)()+,,-('()*++    !""#$$#')+---,$,/246665/ #)/4:?D"'-28=1
  !'-3 $(+/26
 [bhjhb[SKU[_`_[UNG          WWWVUTRQO[ZXVUSQNL_]ZWTQNKHc_ZVROLHEf`ZUPLHDAf^XRMID@<c[TNID@<7_VNID?;62YQIC>951-       	   


 ""#&()*#'*-/01 %*.14678&+048;<=>   BEHKMMLJGBCFJMOPOLIDDHLOQQPNJFEHLPQRQNJFDGKOPQPMJEBEILNNMKGCsy|vt{~xt{~xsy|vpv{}yslrwz||{xtoPRX]`aa`]XRROTZ^aa^ZTOTRW]beeb]WRTTY`eiie`YTTTZafiifaZTTSX_dggd_XSSQU[_bb_[UQ   rty|~~|ytrruz}~~}zurrrv{~~{vrrrv{~~{vrrquy|~~|yuqqorvy{{yvroolnruvvurnl   YRKD>8ZSLF?9[TMF@9[TMF@9ZSLF?9YRKD>8VPIC=7  FHIIIHEGHIHGGIKKKIIKMMMKIKMNMKIKMMMKGIKKKI  #&)++)"&+/11/ %+17::7")07?CC?$+3<ELLE$+3<FNNF#*1:BHHB!'.4;??;%*05775fkopquwbglptvwdjotx|}gmrx|hnsy~gmrx|djotx|}       LFB<6  NGA:6  NHA;6  NHA;6  MG@:6  LE?95  JD>84   PQTUU[YSQUVV^[VUYZZc`VW[]]fbWX[^^gbVVZ\\eaUTXZZb^   ^]adgi*a^aeikcaeinqccglptccglqucbfkosb`dhmp   .---,+)..--,*)...-,+)...-,+).---+*)-,,+*)(-++*)('   %&&&$##%.///-+)57888641C?:4.)# <72,'! 
93,'!84	  CKRZaegeaZ #'*-/0/-*            '+/38>EL-159>CIQ26;?DINV7<@DINT[<@DIMRX^ADHLPUZ`EHLORVZ_HKNQTWZ]LNQSUVXZOQRTUVWWCCBA>;72>=<;840+87641.*%10/-*'#*)(&#"" 

  	    CHKLMMLJFB!AEIKMLJGCCEDGKNPOMJEEEEIMPRQOKGEEEHMPQQOKFE"CFJMNNLIDE  pv{}yssy|vt{~xt{~xsy|vpv{}yslrwz||{xto  &PW\_``^ZTN(MRX]__[VOPRQV]bed`ZSSRSY`fihd]USRRX`ehhc]US)PT[`cb^XQR  qtx|~~~|xtqrsx{~~{xsrrty}}ytrrsx||xsrqrwz}}}zwrqposwyzywsopmlptvvvtplm   RX]abcb_[UOSZ_bb`\VPQV]befd_YRRX_eiigb[TRX_eiigb[TQV]befd_YROSZ_bb`\VP                      #&(*+,,+*)!#%'(()('&!#$%%%$" !"""!  A?DIMNNMID?PA@EJMMJE@AOPVds{{uoVPOOVdvyoVOONTaptkTNNKOZcjmhbOKKFKTZ\_^[KF                         "#$%%$#! !""!     $(+--,*&"$),./-*&$#).25540+(&,27:;95/+'.5:>?<81-(/5;?@=82-'-49<=;60,$*058862-*!&+/120-)&#'*,-,)%"RX]abcb_[UOSZ_bb`\VPQV]befd_YRRX_eiigb[TRX_eiigb[TQV]befd_YROSZ_bb`\VP                       (*+,,+*)'%&'(()('&$"##$%%%$"   !"""!  A?DIMNNMID?PA@EJMMJE@AOPVou{{sdVPOOVoyvdVOONTktpaTNNKObhmjcZOKKFK[^_\ZTKF                        !!!#$%%$#" !  !""!     $"&*,--+($($&*-/.,)$+(+04552.)-+/59;:72,--18<?>:5.--28=@?;5/-,06;=<94-,*-268850**&)-021/+&&"%),-,*'#  
            
  	    
       
            
   	   
  8 DS  3D ~
 > #8 @  S  3   BD ~ >7  @7  @7   @7 `  5S 0 2  B?  BS 0 2S 8 2S 8 2W 8 2   8 3   B_ 8 2   B2 8 3   B   B   B   B    37 ȏ   5' ȏ`  5' ȏ`  5' x
  H  ( ` p 4 ` p 4 ` p 4 Ϗ`   ( `  5 `  5 ` p  ( ` p  ( `  H  ( ` >    H 1     H 1 p 
G 3 p 
G 3 p 
 3   p  2 p   1D ~ >D    ;D     ;D   >D 
  (D s   H  ( p   1D s  H 
  <( #@  @( #D   H 
  <( #D   H P  |( #     H 1 
  H 
  <( # 
  H 
  <( # 
  H 
  <( # 
  H 
  <( # 
 H 
  & 
 H 
  & 
 H P  @ $ 
 H P  @ $ 
 H 
  <( # 
 H 
  & 
 H P  @ $ 
 H P  @ $  
 H P  @ $ 
 H P  @ $  
 H P  @ $ 
 H P  |( #  H 
  <( #  H 
  <( # 
 H 
  <( # 
 H   @ $ 
 H P  @ $ 
 H P  @ $ 
 H P  @ $ 
 H P  @ $  
 H P  @ $ 
 H P  @ $  
 H P  @ $ 
 H P  @ $ 
 H P  @ $ 
 H P  |( #  H 
  <( #  H 
  <( #  H   |( #  H P  |( #  H P  @ $  H P  |( #  H 
  <( #  H 
  <( #  H P  |( #  H P  |( #  H P  |( #  H P  @ $ 
 H P  @ $ 
 H P  @ $ 
 H P  @ $  H P  @ $  H P  @ $  H P  @ $  H P  @ $  H P  |( #  H 
  < $     < $     < $     < $  8   < $  8 	  | $   	P  | $   	P  | $   P  | $   P  |( #   	P  |( #   	P  |( #   	P  |( #   	P  |( #   	P  |( #  x 	P  |( #  8 	P  |( #   	P  @ $  P  @ $  P  @ $  P  &  P  &  P  <( #  P  <( #    H 
 <( #  
  H 
 <( #  
 H p |( #  
 H p |( #   	p |( # ǉ   @ 	    ǉ   2 ǉ  { P  @ $  
 {< p  @ $ p  2 p  2 0  2 W 8 2W 8 2 W  2 0  2  2   2  2  p  @ 	    
 {< P  & @ { 0 @ { 0 @ { 0 
? {< /  {< /  {< / / - 
 {>x .  {>x /  {>x . 
@  / - o ,  , / ,  > .   .   .   .  , < , < , < , o , / - / - / - / - o , o , / - < + ? )  ) ? ) ? )  ) ÿ? ) Ç? ) ? ) /O ) O ) o ) O ) o ) o ) /O ) Ç? ) ? ) ? ) ? )   @ 	     ) o ) o ) o ) o ) o ) o ) o )  )  ) o ) o ) o ) o ) o ) o ) o ) o ) o ) o ) o )  p )  )  )  '  ` u܊(X " H` u܊(X "      /X#    	p/    	 /X#    	?X#   / #   u     	p/   
  	/X#    	./   +X#  }+X#  *X#  *#  h*#  * #  :X#  k*X#  >X#    	p`>    /X#  + #  : #  ;X#  :X#   ?X#  ?   *   >     >X#  >X#  ܎X   ! |? p`>   ! |? >X#  ! |? >   ! |? ?#   ?#?4     *#  >`= @  
   p}= @3  ! |?@  ?c    @ 4}= @y  ! |?@  = #    "  $  "    "     "  0  "     k]   k\  !   @ 	    kt\    #     @ 	     @ 	     @ 	   #8 @   #8 @   #8| @   ? @4    *   ? #    ? #    #8lZY0  #8l   #8 @   ߏ( oY0  !  l}A0      ?c?    /g?    + [    ?g>  >g?    > [    ?g?    /cc  /g  / '	     ߏ d}  +g  /g=0  /g0  ;g?2  ;-  ;g0    @ [  !   4Ќ $0  4Ќ $0  :>  :g`2  >?  > ?     >gk2  >g[0  >6  >g{2  /      /  	    /      0}( @w    >     >      >     ! @f[p0d  	 !@ d[p0d  	 #8 @   * 0   !@( @w #3 +    !@ @  #    !@ [ 0 
#    !@ @ ?  c
    +O  c
    *0   c
    *0 < #    !@( @w     !@ @w      %p      "( p      "( p     (  !@( @w   1   !@( @w    1   !@( @w @  3   !@( @w  3   "( p   #3 (  "( p   #3 8(  
 "( p   #3 (  "( p   #3 8(  
 !@( @s   !3   !@( @s    !3   "( p  @ !3 (  !@( @3   !3   "( p  #3 8(  
 "( p  #3 8(  
 "( p  3 8(  
 "( p  3 )  
 "( p  3 8(  
 "( p   3    
 "( p  @!3 8(  
 !@ @  !3 8(  
 "( p  3 8   
 "( p  3 8   
 !@ @  3 8   
 * 3 8   
 !@( @w #3 8(  
 !@( @w !3 8  
 "( w      "( w      "( 7  !   &  !   &  3   &  3   & !3   % !3   &  3   $@ !3   !@ @ !3   !@ @ !3   !@ @ !3   !@ @ !3   !@ @ 3 8  
 !@ @ 3 8  
 !@ @ 3 8  
 !@ @ 3 8  
 +;?8(  
 + ?   2  2  2  + 0ϓ    2 hG  2 h  +;??8(  
 +;??8 
 
 2?  2?  +;?? 8  +? 8  2    2 h  "( p ?8  
 !@( @w #3 8(  
 !@( @s 3 8(  
 !@ @ 3 8  
 2  4    3   2   2ϑ hG  2 hG  2 hG  2 hG  2 h  2 h  2 h  2 h  2 h  2 h  2 h  "( p ? 8  !@ @ ?3 8   * 
? 3 8   + 
@#    + ( #    +     + 
   #8 @   "( p   p 	 #8 @ 	  p 	 +O  `
 
 +8 ` 
 * 	 (   8  +8 ` 
 7@ 
 +8 ` 
 8  8h   8  8  8}   8 }   8 }   9 	@  9 	@  9 	@  9 	@  9 	@  9y   9 	@  9 	@  8 }   9  8 }   8 i   9 	@  *0 <    * 
?  0   * <    * 
?  0 p  * 
?  0   *| 
0   *| 
0 p  *| 
0   *d 
0   +d 
0 ~ 	 +d 
0 ~ 	 *| 
0   +| 
0 7 	 +d 
0 7 	 +d 
0 G 	 *d 
0   8 i   8 i   *   *   *d 
0   *   *   *   8 i   * @   *   2   4 	  2 h  2   4 	  2 h  2 h  2 h  + 
   4    3   2   2   3   4    3 2  4 	  4 	  4 	  4 	  4 	  4` 	0  4` 	0  4  	0  4` 	0  >  >  4  	  4 	  @  4 	  A  B  4 	p  4` 	0  4  	0  4` 	0  @  4  	0  4  	  >  @  @  @  >  @  D2    !    !  #  2  "@  2  9 	@  9i     @ 	   +{ 
   9i   =   {
"message" "         Fortr - Two Forts\n\n\n"
"classname" "worldspawn"
}
{
"origin" "-80 -60 108"
"display_item_status1" "1"
"n_s_c" " flag is carried by"
"display_item_status2" "2"
"b_n" "Fort: Capture the enemy flag!\n"
"t_s_h" "Your flag is at base."
"t_s_c" "Your flag is carried by"
"n_s_h" " flag is at base."
"hook_out" "1"
"b_t" "   \n Choose Your Team \n\n Blue Team\n  Team \n"
"b_b" "TeamFortress"
"n_s_m" " flag is down."
"t_s_m" "Your flag is down."
"classname" "info_tfdetect"
}
{
"origin" "-12 -1036 64"
"g_a" "1"
"target" "cap1"
"items_allowed" "2"
"owned_by" "2"
"message" "You captured their flag.\n"
"axhitme" "2"
"noise" "items/cap1.wav"
"n_b" "   \n"
"b_t" "Your team captured their flag.\n"
"g_e" "19"
"count" "10"
"b_o" "Your flag was captured.\n"
"frags" "10"
"classname" "i_t_g"
}
{
"origin" "444 -3488 -388"
"g_a" "4789"
"owned_by" "1"
"netname" "Blue Flag"
"message" "You have their flag.\nTake it home!\n"
"d_n_n" "   \n"
"noise" "shambler/ssight.wav"
"n_b" "   \n"
"d_n_t" "   \n"
"b_t" "Your team got their flag.\n"
"d_t" "The enemy lost your flag.\n"
"b_o" "Your flag was taken.\n"
"items" "131072"
"noise3" "Your flag returned.\n"
"goal_no" "1"
"noise4" "Their flag returned.\n"
"delay" "60"
"pausetime" "60"
"team_no" "2"
"skin" "1"
"d_n" "Your team lost their flag.\n"
"mdl" "progs/tf_flag.mdl"
"angle" "135"
"classname" "item_tfgoal"
}
{
"origin" "4 1020 64"
"g_a" "1"
"target" "cap2"
"owned_by" "1"
"items_allowed" "1"
"message" "You captured their flag.\n"
"axhitme" "1"
"noise" "items/cap2.wav"
"n_b" "   \n"
"b_t" "Your team captured their flag.\n"
"g_e" "19"
"count" "10"
"b_o" "Your flag was captured.\n"
"frags" "10"
"classname" "i_t_g"
}
{
"origin" "-444 3476 -388"
"g_a" "4789"
"owned_by" "2"
"message" "You have their flag.\nTake it home!\n"
"netname" "Red Flag"
"d_n_n" "   \n"
"n_b" "   \n"
"noise" "ogre/ogwake.wav"
"d_n_t" "   \n"
"b_t" "Your team got their flag.\n"
"d_t" "The enemy lost your flag.\n"
"b_o" "Your flag was taken.\n"
"goal_no" "2"
"noise3" "Your flag returned.\n"
"items" "262144"
"delay" "60"
"noise4" "Their flag returned.\n"
"team_no" "1"
"pausetime" "60"
"skin" "2"
"d_n" "Your team lost their flag.\n"
"mdl" "progs/tf_flag.mdl"
"angle" "315"
"classname" "item_tfgoal"
}
{
"origin" "0 0 0"
"ammo_shells" "200"
"armortype" "0.8"
"no_grenades_1" "4"
"no_grenades_2" "4"
"g_e" "1"
"ammo_nails" "200"
"ammo_medikit" "100"
"armorvalue" "300"
"health" "100"
"targetname" "cap1"
"ammo_cells" "200"
"ammo_rockets" "60"
"ammo_detpack" "1"
"classname" "i_t_g"
}
{
"origin" "0 0 0"
"ammo_shells" "200"
"no_grenades_1" "4"
"armortype" "0.8"
"no_grenades_2" "4"
"g_e" "1"
"ammo_medikit" "100"
"ammo_nails" "200"
"armorvalue" "300"
"health" "100"
"ammo_cells" "200"
"targetname" "cap2"
"ammo_detpack" "1"
"ammo_rockets" "60"
"classname" "i_t_g"
}
{
"origin" "319 178 -52"
"mangle" "3 116 0"
"classname" "info_intermission"
}
{
"speed" "500"
"sounds" "1"
"model" "*1"
"wait" "1"
"dmg" "50"
"targetname" "btarget1"
"angle" "-1"
"classname" "func_door"
}
{
"speed" "32"
"model" "*2"
"team_no" "2"
"angle" "-2"
"classname" "trigger_push"
}
{
"speed" "500"
"model" "*3"
"sounds" "1"
"wait" "1"
"dmg" "50"
"targetname" "btarget2"
"angle" "-1"
"classname" "func_door"
}
{
"target" "btarget1"
"model" "*4"
"team_no" "1"
"classname" "trigger_multiple"
}
{
"target" "btarget2"
"model" "*5"
"team_no" "1"
"classname" "trigger_multiple"
}
{
"speed" "500"
"sounds" "1"
"model" "*6"
"height" "464"
"team_no" "1"
"classname" "func_plat"
}
{
"speed" "500"
"model" "*7"
"sounds" "1"
"wait" "1"
"dmg" "50"
"targetname" "bd1"
"angle" "-1"
"classname" "func_door"
}
{
"target" "bd1"
"model" "*8"
"classname" "trigger_multiple"
}
{
"speed" "500"
"model" "*9"
"sounds" "1"
"wait" "1"
"dmg" "50"
"targetname" "rtarget1"
"angle" "-1"
"classname" "func_door"
}
{
"speed" "32"
"model" "*10"
"team_no" "1"
"angle" "-2"
"classname" "trigger_push"
}
{
"speed" "500"
"model" "*11"
"sounds" "1"
"wait" "1"
"dmg" "50"
"targetname" "rtarget2"
"angle" "-1"
"classname" "func_door"
}
{
"target" "rtarget1"
"model" "*12"
"team_no" "2"
"classname" "trigger_multiple"
}
{
"target" "rtarget2"
"model" "*13"
"team_no" "2"
"classname" "trigger_multiple"
}
{
"speed" "512"
"model" "*14"
"sounds" "1"
"height" "464"
"team_no" "2"
"classname" "func_plat"
}
{
"speed" "500"
"model" "*15"
"sounds" "1"
"wait" "1"
"dmg" "50"
"targetname" "rd1"
"angle" "-1"
"classname" "func_door"
}
{
"target" "rd1"
"model" "*16"
"team_no" "2"
"classname" "trigger_multiple"
}
{
"origin" "-1584 2176 30"
"team_no" "2"
"angle" "318"
"classname" "i_p_t"
}
{
"origin" "-1584 1984 30"
"team_no" "2"
"classname" "i_p_t"
}
{
"origin" "-1520 1920 24"
"team_no" "2"
"angle" "13"
"classname" "i_p_t"
}
{
"origin" "-1520 2112 24"
"team_no" "2"
"angle" "318"
"classname" "i_p_t"
}
{
"origin" "1512 -1936 24"
"team_no" "1"
"angle" "199"
"classname" "i_p_t"
}
{
"origin" "-1520 2048 24"
"team_no" "2"
"angle" "356"
"classname" "i_p_t"
}
{
"origin" "1512 -2128 24"
"team_no" "1"
"angle" "177"
"classname" "i_p_t"
}
{
"origin" "1512 -2064 24"
"team_no" "1"
"angle" "180"
"classname" "i_p_t"
}
{
"origin" "1752 1328 58"
"team_no" "2"
"angle" "162"
"classname" "i_p_t"
}
{
"origin" "-1760 -1536 58"
"team_no" "1"
"angle" "4"
"classname" "i_p_t"
}
{
"origin" "1752 1392 58"
"team_no" "2"
"angle" "171"
"classname" "i_p_t"
}
{
"origin" "-1584 2112 30"
"team_no" "2"
"angle" "338"
"classname" "i_p_t"
}
{
"origin" "-1584 2048 30"
"team_no" "2"
"angle" "356"
"classname" "i_p_t"
}
{
"origin" "-1520 1856 30"
"team_no" "2"
"angle" "45"
"classname" "i_p_t"
}
{
"origin" "-1584 1856 30"
"team_no" "2"
"angle" "43"
"classname" "i_p_t"
}
{
"origin" "1512 -2192 30"
"team_no" "1"
"angle" "147"
"classname" "i_p_t"
}
{
"origin" "1432 -2192 38"
"team_no" "1"
"angle" "95"
"classname" "i_p_t"
}
{
"origin" "-1520 2176 30"
"team_no" "2"
"angle" "303"
"classname" "i_p_t"
}
{
"origin" "1576 -2128 30"
"team_no" "1"
"angle" "174"
"classname" "i_p_t"
}
{
"origin" "1576 -2192 30"
"team_no" "1"
"angle" "162"
"classname" "i_p_t"
}
{
"origin" "1576 -2000 30"
"team_no" "1"
"angle" "184"
"classname" "i_p_t"
}
{
"origin" "1576 -2064 30"
"team_no" "1"
"angle" "182"
"classname" "i_p_t"
}
{
"origin" "1512 -1872 30"
"team_no" "1"
"angle" "226"
"classname" "i_p_t"
}
{
"origin" "1432 -1872 30"
"team_no" "1"
"angle" "242"
"classname" "i_p_t"
}
{
"origin" "1752 1456 58"
"team_no" "2"
"angle" "183"
"classname" "i_p_t"
}
{
"origin" "-1584 1920 30"
"team_no" "2"
"angle" "13"
"classname" "i_p_t"
}
{
"origin" "1576 -1936 30"
"team_no" "1"
"angle" "197"
"classname" "i_p_t"
}
{
"origin" "1752 1584 58"
"team_no" "2"
"angle" "213"
"classname" "i_p_t"
}
{
"origin" "-1760 -1344 58"
"team_no" "1"
"angle" "348"
"classname" "i_p_t"
}
{
"origin" "1752 1528 58"
"team_no" "2"
"angle" "194"
"classname" "i_p_t"
}
{
"origin" "1576 -1872 30"
"team_no" "1"
"angle" "224"
"classname" "i_p_t"
}
{
"origin" "-1440 1856 30"
"team_no" "2"
"angle" "62"
"classname" "i_p_t"
}
{
"origin" "-1760 -1472 58"
"team_no" "1"
"classname" "i_p_t"
}
{
"origin" "-1760 -1408 58"
"team_no" "1"
"angle" "357"
"classname" "i_p_t"
}
{
"origin" "-1760 -1600 58"
"team_no" "1"
"angle" "19"
"classname" "i_p_t"
}
{
"origin" "-1440 2176 38"
"team_no" "2"
"angle" "287"
"classname" "i_p_t"
}
{
"origin" "1752 1264 58"
"team_no" "2"
"angle" "155"
"classname" "i_p_t"
}
{
"origin" "0 256 28"
"angle" "270"
"classname" "info_player_start"
}
{
"origin" "-384 -712 20"
"angle" "90"
"classname" "info_player_deathmatch"
}
{
"origin" "260 -716 76"
"angle" "90"
"classname" "info_player_deathmatch"
}
{
"origin" "-12 -452 76"
"angle" "90"
"classname" "info_player_deathmatch"
}
{
"origin" "276 552 76"
"angle" "270"
"classname" "info_player_deathmatch"
}
{
"origin" "4 428 76"
"angle" "270"
"classname" "info_player_deathmatch"
}
{
"origin" "376 696 20"
"angle" "90"
"classname" "info_player_deathmatch"
}
{
"origin" "-268 700 76"
"angle" "270"
"classname" "info_player_deathmatch"
}
{
"speed" "500"
"sounds" "1"
"model" "*17"
"wait" "1"
"dmg" "50"
"targetname" "br1"
"angle" "-1"
"classname" "func_door"
}
{
"target" "br1"
"model" "*18"
"classname" "trigger_multiple"
}
{
"speed" "800"
"sounds" "1"
"model" "*19"
"wait" "1"
"dmg" "500"
"delay" "2"
"team_no" "1"
"angle" "-1"
"classname" "func_door"
}
{
"speed" "500"
"model" "*20"
"sounds" "1"
"wait" "1"
"dmg" "50"
"lip" "2"
"targetname" "rr1"
"angle" "-1"
"classname" "func_door"
}
{
"target" "rr1"
"model" "*21"
"classname" "trigger_multiple"
}
{
"speed" "800"
"sounds" "1"
"model" "*22"
"team_no" "2"
"wait" "1"
"dmg" "500"
"angle" "-1"
"classname" "func_door"
}
{
"speed" "500"
"sounds" "1"
"model" "*23"
"wait" "5"
"team_no" "1"
"angle" "-1"
"classname" "func_door"
}
{
"speed" "500"
"model" "*24"
"wait" "5"
"team_no" "2"
"angle" "-1"
"classname" "func_door"
}
{
"origin" "-1136 -1288 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-1136 -1320 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-1168 -1320 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-1168 -1288 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-1200 -1288 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-1200 -1320 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-1232 -1320 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-1232 -1288 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-1240 -1288 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "-1240 -1320 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "-1256 -1320 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "-1256 -1288 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "-1312 -1288 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1312 -1320 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1344 -1320 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1344 -1288 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1328 -1680 32"
"classname" "item_armorInv"
}
{
"origin" "-1280 -1696 32"
"classname" "item_health"
}
{
"origin" "-1248 -1696 32"
"classname" "item_health"
}
{
"origin" "-1216 -1696 32"
"classname" "item_health"
}
{
"origin" "-1140 -1680 32"
"classname" "item_armorInv"
}
{
"origin" "-1108 -1680 32"
"classname" "item_armorInv"
}
{
"origin" "-908 -4040 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-940 -4040 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-940 -4008 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-908 -4008 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-908 -3976 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-940 -3976 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-940 -3944 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-908 -3944 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-908 -3904 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-940 -3904 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-940 -3888 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-908 -3888 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-908 -3864 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-940 -3864 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-940 -3832 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-908 -3832 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1160 -4024 -416"
"classname" "item_armorInv"
}
{
"origin" "-1160 -3812 -416"
"classname" "item_armorInv"
}
{
"origin" "-1160 -3844 -416"
"classname" "item_armorInv"
}
{
"origin" "-1176 -3944 -416"
"classname" "item_health"
}
{
"origin" "-1176 -3912 -416"
"classname" "item_health"
}
{
"origin" "900 -2168 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "932 -2168 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "932 -2136 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "900 -2136 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "964 -2136 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "964 -2168 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "996 -2168 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "996 -2136 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "1028 -2136 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "1028 -2168 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "1060 -2168 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "1060 -2136 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "1092 -2136 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "1092 -2168 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "1124 -2168 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "1124 -2136 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "916 -2088 24"
"classname" "item_armorInv"
}
{
"origin" "948 -2088 24"
"classname" "item_armorInv"
}
{
"origin" "996 -2104 24"
"classname" "item_health"
}
{
"origin" "1028 -2104 24"
"classname" "item_health"
}
{
"origin" "1124 -2088 24"
"classname" "item_armorInv"
}
{
"origin" "-928 2068 24"
"classname" "item_armorInv"
}
{
"origin" "-960 2068 24"
"classname" "item_armorInv"
}
{
"origin" "-1040 2052 24"
"classname" "item_health"
}
{
"origin" "-1072 2052 24"
"classname" "item_health"
}
{
"origin" "-1136 2068 24"
"classname" "item_armorInv"
}
{
"origin" "-1168 2084 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1136 2084 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1104 2084 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-1008 2084 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-976 2084 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-944 2084 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-1040 2084 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-1072 2084 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-1072 2116 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-1104 2116 24"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "-1136 2116 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1168 2116 24"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "-1040 2116 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-1008 2116 24"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "-976 2116 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "-944 2116 24"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "1148 3796 -416"
"classname" "item_armorInv"
}
{
"origin" "1148 3828 -416"
"classname" "item_armorInv"
}
{
"origin" "1132 3860 -416"
"classname" "item_health"
}
{
"origin" "1132 3892 -416"
"classname" "item_health"
}
{
"origin" "1148 4004 -416"
"classname" "item_armorInv"
}
{
"origin" "896 3780 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "864 3780 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "896 3812 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "864 3812 -416"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "896 3852 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "864 3852 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "896 3868 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "864 3868 -416"
"spawnflags" "1"
"classname" "item_rockets"
}
{
"origin" "896 3892 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "864 3892 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "896 3924 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "864 3924 -416"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "896 3956 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "864 3956 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "896 3988 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "864 3988 -416"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "1288 1236 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "1256 1236 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "1248 1236 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "1232 1236 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "1176 1236 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "1144 1236 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "1112 1236 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "1080 1236 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "1080 1268 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "1112 1268 32"
"spawnflags" "1"
"classname" "item_shells"
}
{
"origin" "1144 1268 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "1176 1268 32"
"spawnflags" "1"
"classname" "item_spikes"
}
{
"origin" "1232 1268 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "1248 1268 32"
"spawnflags" "1"
"angle" "90"
"classname" "item_rockets"
}
{
"origin" "1256 1268 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "1288 1268 32"
"spawnflags" "1"
"classname" "item_cells"
}
{
"origin" "1316 1660 32"
"classname" "item_armorInv"
}
{
"origin" "1240 1644 32"
"classname" "item_health"
}
{
"origin" "1208 1644 32"
"classname" "item_health"
}
{
"origin" "1176 1644 32"
"classname" "item_health"
}
{
"origin" "1128 1660 32"
"classname" "item_armorInv"
}
{
"origin" "1096 1660 32"
"classname" "item_armorInv"
}
{
"origin" "-1520 1984 24"
"team_no" "2"
"angle" "356"
"classname" "i_p_t"
}
{
"origin" "1512 -2000 24"
"team_no" "1"
"angle" "195"
"classname" "i_p_t"
}
{
"origin" "-1233 -2781 58"
"classname" "ambient_suck_wind"
}
{
"origin" "-527 -2659 -397"
"classname" "ambient_drip"
}
{
"origin" "256 -3279 -397"
"classname" "ambient_drip"
}
{
"origin" "-278 3254 -397"
"classname" "ambient_drip"
}
{
"origin" "1219 2783 58"
"classname" "ambient_suck_wind"
}
{
"origin" "508 2637 -397"
"classname" "ambient_drip"
}
{
"origin" "1060 -2104 24"
"classname" "item_health"
}
{
"origin" "-1104 2052 24"
"classname" "item_health"
}
{
"origin" "1132 3924 -416"
"classname" "item_health"
}
{
"origin" "-1176 -3976 -416"
"classname" "item_health"
}
  "   h       `    ) ? T i P      X  ( * ? `U j 0 X * ? sky4 +v+v        (   (  (  (                                                                                                                                  ((((((((((((()(((()))()))))(())***)*)**)*)))())(()()*()**))(((((((((((((((((((((((((((((((()()()))*(()((((((((((((((((((((((((((                                                                                                                                (((((((((((((()(((((((()))))))*)*))*)*))))))))))))*)))**+))(((((((((((((((((((((((((((((((())))))*)*)()(((((((((((((((((((((((((                                                                                                                                ((((((((((())))((((((()))))**)*+++*)))))))*))))))*)))*)*+*)((((((((((((((((((((((()((()(()()))))))*))(()((((((((((((((((((((((((                                                                                                                                ((((((((((()**)((((()()))))*))+*+*+)))()))**)**)*)*)*)*+**))((((((((((((((((((()))))()()()(())()++))((((((((((((((((((((((((((((                                                                                                                                ((((((((((()++))(()))))****)*)++**++*)))()))))())))())+)))))(((((((((((((((()()())(()))(((((()))+*)(((((((((((((((((((((((((((((                                                                             +,,,,,+   **                                       (((((((((())++**))())***)**))*+****)+*((((())())())))**))())()))(((((((((((()((()))(()(((((()((*)))((((((((((((((((((((((()(((((                                                                          ,,+------,+++++**                                     (((((((((()*+**))()()****+)*)*+++**++)))()))()((()((+*+))()))(()(((((((((()(((((()(((()(((((((())(((((((((((((((((((((((((((((((                                                                      ++++,,,.///...-,,--,+                                     ((((((((())*+)))((())+*+*)*+)*++*)*))))()(()(()(((()))**(((((((()(((())()))((()((()(((((((((((((()((((((((((((((((((((((((((((((                                                                     *+++,,,..//.//.-,,,,+)                                     )(((((((())))))())())+))***+*+*)**)((()))()(((((((()*)))(((((((())))()((()((((((((((((((((((((((((((((((((((((((((((((((((((((((                                                                      **+,,-----,..----,+       )+ *)                           )((()((())()))()))))+)))+))*)*))))()(()))*)(((((((((*))((((((((()))))((()()(()((((((((((((((((((((((((((((((((((((((((((((((((((                                                                     +**++,,,--,,,,----,*      )*,,,+)                          ()()())))))))(*)))*)++)*++*)()(()()())++)++)))((((()***(()((((()())())((((()(((((((((((((((((((((((((((()(((((((((((((((((((((((                                                                     *+**++,,,,----,,-,+)       ++,,,*)                         )))))))*)))))))*)*)**)**+*)*)(*((()()*)++++***))))**+++**()()))()(())))(()((((((((((((((((((()(((((((()(((((((((((((((((((((((((               **                                                     **+***+++,,--,,,,*        *+,,,+*                         ))())()(*(**))))*)))**)**+*)+)**))))(*++++++++*)+***++++**)(*)))(())**))(((((((((((((((((((((((((()(((((((((((((((((((((((((((((              **,***                                                    *****+*+++,++,,+)       **,,,+*                         )()())())))**)*))*)*))*)++)**))())()()++*+++*++*)*+++++++++*)+)))(())()(((((((((((((((((((((((((((((((()(()(((((((((()()((((((((             )+---++**++++*+                                                )*++**+++*+,++***)  **+++**)                        )))))))(())(*))((()))))+))))))))()()))+++++,,+++*+*++,+,+++)+)))())()(((((((((((((((((((()((((((((((((((((((((((((()(((()()((()(             )*,-,,***+,+ *+                                                 )))))****++,,,,++**++*++**                         )+**))()(((((((((())))+**(()(((*()()++++,,,,,+,,++++,,,,++++)))*(((((((((((((((((((((((()(((((((((((((((((((((((((((((((((((((((              )**)) **                                                          )))))****++*+*)) *+***++                        )*)*+))()()((((((()()+)+))()()((*(**(*+++,,,,,,,,,,+,,,,,+***+)(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((                                                                               )))))*****+,,+*   ****))                         **)*+)))()(((((((((()))**)()((()()**+)++,,,,,,,,,,++,,,++)+)+(((((((((((((((((((((((((((((((((((((((((((((()(((((((((((((((()()*                                                                              )))********+*+*    ****)                          **)*++*())((((((((()))))))(()))))*)***+++,,,,,,,,++++**))))(()((((((((((((((((((((((((((()((()()(((((())(()((()))()((((()()))))*                                                                               ))**)* ***+**** * **+*)                          ))(*+**))(*)(((((((()**))()((()()((**+++,,+,,,++,+***)))(((((((((((((((((((((((((((((((((((((((()))()))))))))))))))()()))*)))))(                                                                                       *++** ****)**                            ))())+)++)++))(((((()**)((()((()(*)*++*++++++++*+)*))*(((()(((((((((((((((((((((((((((()(((((()()+))()))))*+*)))*+))))))**))*+*)                                                                                       )+))                                     ))(()++)+++++**)))(***+++*))))))(()***))***+**)*()()(()((((((((((((((((((((((((((((((())(()()))))+))))*))*++*+++)**)())*))))))))                                                                                         ))***)                                 ))((*+++++*++*+*)++**++++*+)))*))()())(()*+*+++()(((((((((((((((((((((((((((((((((((()())()()(()()))))***+*+++***))))))))*)))()*                                                                                         )*,,,,,**                              )()()+*+++++++++****+)+*++++*)+))(()(((()*+++*))()((((((((((((((((((((((((((((((((((())()(()((())())))**+++++**+))*))+)))))+)(()                                                                                         )+,-..-,,                              )**++++++*+++**++)++)(()))++)++)((((((((()*++**))((((((((()(((((((((((((((((((((((((()()(((((((()()(*)+++*+,+++++*++++,++****)*)                                                                                         )*)-.-**+                              **+*+****+++*)*))**))(((()())()((((((((()))***)(((((((()())()(((((((((((((((((((((()))))(((((((*))**+*++++++,++,+++++,,,,++*)**)                                                                                          ))*))                                 **)**)))*+*)+))())*)*(((((((((((((((()((()))*))((((((((())()()(((((((((((((((((((((()***((()())))+)++++++*++++,,,++++,,,,,+++**+                                                                                                                                )*******+****)())**)*()()((((((((()(()((()))*)))((((((())*()))(((((((((((((((((()(((***)))))*))**+*+*++++**++++,,,+,++,,,,,++**)                                                                                                                                *)*)***+++*)*)*)*)****)*))(((((((((())()())*+*)(((((()))+))()()(((((((((((((((((()())*++)))*+*+*)*+***++))*)+*+++++,+*+++,++++*)                                                                                                                                *)+**)**++*)***)**)*)***)*()())()()()((()***+*))((())(***+)*()(((((((((((((((((()))**++**)*+)++**)+))*+)))*)+++**++)++*+++++*+**                                              )**))                                                                             ))**)***++)+**)*)(****)**)**))())))))(())*))(*)*)))()*)*)*+()((((((((((((((((())+**)*+))+)+*+)+*+*)*+*))()))+++)*)+*)*+)***+++**                                             *,,+*)                                                                             )+*)+)*+)+****)()())+)*****)*))(()())))()))))*)))(()(*+*))*)())()(()(()(()(()(()))*+)+**)()())*))+***))()())*)*)*))))*+*++*+))+)                        --,         ++       )++)                                                                               )***)**)****++))()()*++)*)***))((())(())()))*))))((())))*))))*+*)*())((()))(()))**+))))+)))))+*)*+)**))))))))))*)+)))*)*+))))++*                    ,,,-..-+      +,--,      )*)                                                                    )**         **++)*))**++**+()()())****)***(())((((())())*)(()(()*())()*)+++++**(()()(()))(*()))*))))*()**++**++)*((())))))*)**)*)**)*+))+)*)                   +,-.///.,*    +.//.,+++*                                                                        *,,,*        +**)+*)*+*+*))))(())**)*)**)*))(()()(((()))*()()(((*)((())***+++**)()())*()()))))*))*()*))))**)*)++))))))*)))))*)+*))**)*)**)**)                  ++,,-....++,,,,.////.-./.,                                                                     * ***)         *++)**))++)*)))()()))****)*+))()()(((((())*))()()()((((()))*****)*))(())))*)()(())))**))*))*))*******)))))))))))*)+*)**))*)**+)*                    ++,,+,++,,...-....---//-,                                                                   **** )          +++*+*+)**)()())*))(*)*)**)**)*())))))())*))(((((((((((((()(*)*)*++)))()))**(*()(*(**)*)))*)*))*)++*)*)()())*)*++*)**)))*)))+*)*                      ****+*,---..-,.--,...-,                                                                  ***              ++++++++++))))**))))())+)*))))**))))*))*)*(((((((((()((((()))**)*)++))))*()()(*()())(*(*())*))))+)))*())))*))*++*++)))))++))))**                      *   * *,-----,++,,,+-,*                                                              **+                  ++++++*++*)()*)*())+)+*++)*******)***)))()(((((((()()(((()()())*)+*+))()(*+*)*()())((()())())))+*))()())*)****+)*+++)*))**)*+*++                            **,,,,,+*)*+,+,+-*                          ++++     + ++                     *,*+                  +++++++)))))()())***+*++++))**)*+***+)()((((((((((()()())))))*)*)***+))**)*)*+)())))((()()))()+**))()*)+*++)*)****)***+*+)+++*++                              *+*+++))*,,,-./.-++ ++++                +-./--++* +++,,,+                    ++                   ))*))+*)))*+*)*)**+)*)+++*+*)*()++)*+*)(())())(*))(())))()*)***)+**+*+**+*+)*+*)())()((()((((())+)()))*++++*)*)*+)+++++*+++++++)                                ***  *,,--.....--.//.,,,             +-////.-,+++-...,+-+                                       (((())*())+)+*****+*****+++++*)(+,,+,++()())()))))))(*)*))***)*++*++*++*+***++*)))()))((((((()*))()(((*)+*))*+++*++++*++++*+*+)(                                *     ,-----.-,,.//.--,,,+          +,//////-..,-///.-,+-+                                      (((((()))*+*++)**)***++))++,+++++,,,,++**)())))))**)+****))++)*)*++,+++++**)*+)*)()*)((((((()))*))()())))*))+*+*)*))*))(()*))*)(                                     *,-,,,,,,+,.,--++++,,,,,    ,,++,../////.-,./....-*++                                      (((())))(*+)**+**)))+))(()++,,,,,,,,,+,+**)()+)*))***+)+)***++)***+,,+*+**)()*+)+*)++)()((()()))*()))))()*))+*)))((())((((())*)(                                     ***,++,,+*+,--.-,+,,-/..,  ---,+,,-.///-..,-./---,*))                                      (()))**)))*+*+++)*))+*)(((+*++,,,,+,,,,+++*++++)*++***+*+*)+*+*)++,-,+**)))(()+***+,,+**))()))*))*+*)*)*)()()*))()((((((((())))(                                       )*+*+**)*+,,--,+,,-//.,,,,-..,-.--/./..-,,,,,++*))                                       ))**+++**+++++++*+**+++(((()*++++,*+,,-,+,,+,+++++++*+++***+++*++,-,,+*)()))()++++*++*+**)********)+)))*)*(**))()((((((((()))(((                                         * *  ))*++++*++,,--,,,,,,--.--,,,-.--,+,-.-**)+)                                       )***+++++*+,+,++*+++++**(()**+,,,+,,,-,-,,-,,-,++++*++)*)*++++++,,-,++**)()())*+*+*++++++)**+++++++++*)+*)))))))(((((((((()()(((                                                )))*+**+,,,,--++--......-,-.,--,+,-++)+-)                                       )*++++,,+++,,++++++*+)*()()+)+,,,,,,,,,,--,---,,,,+)*+*)*++*****+,,++*)*+)()))***+++,,,+++*++*++,+++**++*+)*))+*())(((()())*()((,+*)                                               ))*++++*++,---...-...-----,+,++++*+-,)                                       )*+*,++,+++++++*++****()*)++++,+,++,,,,------,,,,,++)*+*)*)**)*)+,,,+**+*))(*+)++++,,-,,+++*++,+,+++++++++*))))()(**)((()(*)(())+++***)                                             ))*****+*+-,,++..///..---,,++**))))))                                       ))*+,+,++++++*+*+*))))(*))*++++*+*++,,,,,-,,,,,,,+++*)*)***)*+*++,-,++****)****++,,,--,-,++++,+,,+,++*+++**)()()))*)))()()*()))( )**,,,,*                                         * ))+    **+,,,+,-./..-,..-++***)) ))                                         )))+++*++*++)*****)())*))*)++*+**)*+++,++++,,+++++*******)***)++++,+++)))*++))*++,,----,,,++++,,,,++,+++++++))*()+))()*)))))())(    ++,,+                           ,,++        * *+++,,+,-.,-----....--,,--++*))))                                             )))**+)+)*****)++*+))))*))(**++((*)+++)+++*++)++**++****)+*)**+*+++++**+***)*))+++,,----,,,+,,,,,,,,,++,++++*+*)))*))()(()()()((                                   ,---,+  +++,,,+,+,+++,-.-////..---,,*+++***))                                                )++*)*)+***+*)*+++++())))(*(*)(()()+*+***+)**+*)**+***+****))**+*++****)*+**+**++,+,,-,,,+,++,+,,,,,,,+*++)+)+*))))*)((((()(((((                             ++ ,,,..//.......//..-.-,+,-.//....-,,,+***))))) ))                                                )+++)++++++++*++)++))()()()()()(*(***)*)))))***++)*))+*)++)+))+)+*)**))+)*)*+*++*+,+,+,+++++,+,,,,,,++++*)+*+++))*)((((((()((())          ,,    ,+**        +,,+,,,./////////////...--,--..---,,,+**))))*))                                                     +++,,,+,+++++*+++)*((((()()(()()**)())*)*)(*))***)))++**+)*)*))*++)))***+*++**+*++++,,+++++*++*++++++*+*+)))*)*)))((((((()()))()    *,,-,,,,---.--,,,+++,,,,,,,--...///...///////.---,,,,-,,++**))))))  ))                                                      ++,,,+++++++++++)((()((()()*(*)*)**())*)*)*(**)*+))+*)***++)**)**+++*)))+)())*)++++,+,++++++*******)**))))()*))))((()(()))*)(**)    *+,,,++,,,--,,+++++,,,---..-.-.///..---..//.-,,++***++,,+*+,+)-++,,+                                                        ++++++))*)))*)*)*)((())))*)**)))*(*(*)*)**))+)**)**)******)+*)**++***()))*)*)()*++++,+*+*****)(**)+*)+)(())*+*))))()(*)))**++++)    *+++++*+,,,,,+****+,,-----..--.......---...-,++    **++++)*,,+,----,--,                                                     +++**)*)+*))****+)))))))(**)*())()))())**+*)**)**)**+)+*++)*+))++*+*)))))()))))**+++****))*)())(()))**))))++)+*)*))(*)+*++*++*++ )**+*)))*+*++**+**+***+,,,-,----,-..--,,,,,,--,,,,*******))** +,,-.///--..-,  **                                               +++++)*+++***+)***())))(()(**))()())**+**)**))*))()**))*++*+*+)*++***)*()))))******+**)))()()(((((()()+***+)**)))*(())*)*+++*+++*,,,*)) **++++*****+**++,,,,,,-,,,,,,++++,,--,,,,++*)*+**) )) )*+,.////////.++,,++*                                            )++++++++++*+*+)*+)))()())(*)))()(*))**++++)*)))+*)))*)*+++++++++++*+)*)))()(*(*))*+***(((((((()((()(())**+++)*))++)())))*+*+))**+,-,,,,,,,,,,,++++,,,,,,,++++,++++++++,,+++++-,,,,++*)         )*-.../..-//,,-,,-,++                                           )+,++++++,++**)***)**)))())()())))**)*+**+++)*******+)*+++++++*++**+))))*))))))))**++*(((((((((((()())*++)**+*)))+)*()))**+***++++,--.../....---,,--.///.-,,,,*           *+,,---,,+++*    )*****+,-/.....-----,-.-,,*                                        )**+++++++++++++*****(*)**)))+)**+*++)**)*)*)***+*+*+++++++*+++*****)*)))))*()()())***+*)((((((((((()(()*+**++*)+*)))()()+*+*++*++++,,-..///..-,,,,,,./////.-,++             +,--,,,,,+*)*+*+,,--,+,--.--.--,,--,-,-,**)                                   ++++*++*+++++*,+++,+++***)*()))())+*(**+++**)**+*++*+++++++++*)*******)*)))*)()())()(()()***)(((((((((())(*(**+)+*+)**)*())))*+++++++++++,,,---..-,,,+++,,........-+*             +....-,+*))****,---,++,-----,,++**)))++*)                                  **+,,,+*+*+++*++,,++,,,*+++**()))*()*(*)*))**)***++*++++++**+++*)*)))))))))))*)()()(((()(()()*))(((((((((()()**)***++**)*)*()()++,+++++*++*+++,,,--,,+++++,,,--...----,+       ++,,,,-.//.-+**)* * ++*,,--,,,,,++++**))((())))                             ++++++,+,,,,,+,+++++++++,+++,+++*)))))(()()(()))*)*+***)***)))))**+***)()())))())()(((((((((((((()))))(((((((())*)*+*))+)+*)*))))**+++,,+++++++++**+,,,,,+****+,,-----,,,..-,    ++++-.----.//.,++        +,+,++,,,,+*))))   ))                               *+--,...,-,,,---,,+*+)+*++)+++++*+*)(()()))()))))))*)***)*)))*()()()())*((((((())())(((((((((((((((()))))(()()*))()*)*++))++++*+))*++*++++++++*+++**+*++**+**+***+,,,-..--..----,,,,,--//.---...- +          )*+++*++**)                                   +   +-././///.,,,----,++))*+)**+***++++*()((())())))))**)**)))))((((()(()((*(()(((()())(((((((((((((((((()***))*))))***+*++)++)++*++**)+)+++++*++)++++*+*****) ))***))*+,,,,-----,-....-----..--,,,--,+            ),,*+++)                      ++           ++,,-,--////////.....-,,**)*)*())+)++*+))+)))))))())())))*((()(((((((((()((()))((((((()(((((((((((((((()((())******)*++*)++)+++*+++*+**)***)**)**)*)**+** )           *))++**+,,,,,,--.//.-,,----,,,,,-,+)          ++,,+**+                 ++,++++,++     +,,,+,,--,-..//////./----,**))*(+)(**)*+*)*)*+*)*)))**()))()(((((()((((()((((()(())(((()(((((((((((((((((()(()))***)*)*++*++++++++++++*)+)))))()(**()))))***(                 )))***,,++,,-./..-,,,-,++++-.-+          +,---+**+++  +++, ,--,,--,,----...-++*+,----+,,,,,,-..///////./...-+  )**)))))**)+*)*+++*)+***)*)()(((((((((((((((()((((()*)()()((((((((((((((((((())))***+*++**)++++**+++*)++*+)))(((())*)*()())*)+*)                   ))  ***+*,,--.--,,++++++,--,,+*         +,,+****,,,,+,,,,,,+--........///.-,,,-..-----,----...///./././...-+))*)+**)+*)*))*+++,+++++*))((((((((((((((((((((((()(()()()()((((((((((((((((()())*+++++++*++++++++++++++++*)*))()))))()()()*))+))                        *)*+++,,,,,+++*++,--.-,,,+        ++++++***+,,,,+++*+*+**,------././//..../.-..-..,-,---...//./.......,+))*****)*))*)*++,,,+++*+)()(((((((((((((((((((()((((((()()*))((((((((((((((()))*++,+,+,,+++,++,,,+++*+++***(*()))(*))**))))))))(                          )+++++++++++++***,--,+***     **,,+*+**++++++++             +,,--///...//.//...--,,,,--.-./../..----,+*++))*)*))*())*++,+++,)*)(((((((((((((((((((((((((((((())(()((((((((((()))())***+,,,,,+,++++++,--,+++,++***)*)**)***)***))()()))                            )*++++,,**)) **+,,+**+++*+*+++***++++++++                   ,---..---,-....---...--.----.------...,+*++)+)*()(()()**++++++*)((((((((((((((((((((((((((((((()))(((((()))(((*)***)***++-,,,,,+,,+,++,,,++,++++++)+)*++**)**)+)**))))))                              *+-//-,+)     ++****+****++**+*+*+,,--++++                +,,-..,-,------....-.----,,,,---------,*+++++**))()(*))**+)++))((((((((((((((((()(((((((((((((((()()((()***))))**++++*++,,---,,,,,,+,+,+,++++,++*++*++*++)****))*+*)**))                             **,-//-,+)           **)*) )))*+**,,,,-,,,,++               +---,,,-,,-----,,,---++,,,,,,--,,,,,,* *++*++**++)))*))+*+*)(((((((((((((((((((((((((((((((()((()))())*)*)*)))*++,+++,,,-----,,,+,++,+++,,+,+++++***+++++++)++++*++))**                            *+,,+--,+)             )   ) )*****++,,,,--,-+++            ++--+++,,,,,+++,,,,,,+**+,----..-,,,,*  *)+++++(*()((((()+))((((((((((((()((()(((((())(((*()()(((()))())***)*)*++,-,,,,,-------,+++++,+,+,+++++++**+*++,,++*+++)++++*)*)                          ))++++****))                 *)**))*+,,----....-++      ++++,,,+++    +-.--,-/...-,,++,-......----,*  +*)+**((()((((((((*(((((((()(((((*+(*(()())*)***)*+*)())()())*)**)*))**)++,+,,,,,------,,,+,,++++*++*++*+++++++,,++++*+++++)))))                      ))***+++*          ++               *)***,,--.//.//.-+,  ,,,,---.-,*+     +-.-.-////...-,,,-..///.....-,* *))*)(()*(((((((((((((((((((((()(***)****)))*+**+***+**)**)*)+**)****)))*+++,,,,,------,,,+,+++**)*)*)**++***+++++*++++++*+)()**                     *+*+*++*))        +-..+ ++                )+,,.//-..-,,,+++,,--...,+++      +,---...../......///////....-+*+**))()**)(((((()((((((()(((((()))*(*****+*)*)***)**++***+))*)*)*(*))**+++,+,,,,--,,--,,,,,+++*)()(((())*))((()***))++*++))(((+*                    *+******))         *.//.+--+              ))**+,..--,,++++++,,-----,+++       ,,--,,,--.....---..//..--...,,+++)))*++)))((*)()(((())(()()()()()()(*)**+*)**)**)*)**()*)()))()()(*+++++++,++,+,,,,,,,,,+++*+*((((((())(((((())((()*+*))(((()+                    )+)*)**)         *+--,.+,,,,+             )))**+,,,,,+*+*)*++,,--,,* ++           ++++---..-----.....--..-,,+++*++*++**+*)*))*()()()()*))))))()*()))*)*)+*))))))((*)))*))((*()()****)**+*+++++,++++,,++*)*)())(((((((((((((((()(((*))((((((*                  *********         ***++,,**)))*              )))+*****+**)    ))*,,,+*****              +++,,,,,,,++-------,,,)**+**+++*+***++**)*))())*)*)*))(*)*)))()())))))()(()())+)()))(()*())*)((())**)*++++*+*+++**()(()()((((((((((((((((((((((()))((*                 ++,,,++           ,++++)))*)                    )****)))          *+,+** **                 ++++++++ ++++++,,+*))*))))**++*+,+++***(*))))****)*(*())))*)*))))((()(()+()*+()()((()((())()((()()))****)**)*)((((((()()(((((((()(()((()()())(())((                 +*++,,           *+*)))  *))                                      *+++****                                 ++ )()()(((((*(+*+**)**++)*))**)+*)*()(*()()+*++*((((((()*++)+)))(((((((((((((((()(()*)((())(((()((((((((((((()((((((((()()))*())(((                  ***             ))) )   ))                                         *+*)                                       )()((((()(()(*+*))))+*()())))*()))()*()(*++++)(((((()+)**))(((((((((((((((((((((((((((((((((((((((((((((((((((()((((()*+++)+*()(               +*                   ))                                                                                          )())(()(()(())**+*)***)())*())(((()(()())***)((()((())***)()((((((((((((((((((((((((((((((((((((((((((((((((((())()()))++*++**)(              ***                 )                                                                                             **))*))*()(((*)))+*)*))(((()()((((((((((*)))(((())()(**++*()(((()((((((((((((((((((((((((((((((()(((((((((((((()())*))**++++++)(           ** +*                 ) )                                                                                            ***+*++*)()(**)()(()()(((((((((((((((((()()()(()+*())*)**)+*()()()(((((((((((((((((((((((((((((((((((((((((()()()))))()*)+++++))           *+                    **)                                                                                            +*++,++***))))((((((((((((((((((((((((((()))())))*)))++*)+***))+)*()(((((((((((((((((((((((((((((((((((()()(()())*)(()(**+++*+++                             )**+*                                                                                              ++,,,,++*****()(((((((((((((((((((((((((())))(+*+*+))*+++++**+***)*)()()))(((((((((((((((((((((((((()(()(((()()()((()())*)*+++++                             *,,+)                                                                                              ++,,,,+++)*)*))((((((((((((((((((((((((((*+)*)*+)+**)+*+******))**)))()*)))((((((((((((((((((()*)())())(((()()))()((())*))))*+++                            **+,*)                                                                                              +,,,,,++*)*(()()(((((((((((((((((((((((()*++))))*+*)))++*+**+)+)***)+*+*))*)())(()(()((((((())**))()*)()(()()(()()()))**)())*)++                              +))                                                                                               *++,++,+)*))(()((((((((((((((((((((((((()*)**+))**))())*+,++*)+**)+++*++*)*+)*))*)*)))()(())())*()**)*()()((()()((((()*(*)*())**                                                                                                                                +*++++++**)(((((((((((((((((((((((()))))))*+*++)))(*()))+++*++)**++++++++**+()))))+)*)))()()(()()))(*()()()((((((()()())+*)))*))                                                                                                                                )*)*++**+))(((((((((((((((((((((((())*****+++++*)**+**)*)+++++**+++++*++)+*()()*+++))+*(((((((((((()()((()(((()(((())()*)**+)))(                                                                                                                                )**+)*)+*))((((((((((((((((((((()()))****)+)++++++++*+++++++++*+*)+)*+)+*)((((()+*++)))()((((((((((()()()((((((((((())))*)+**)((                                                                                                                                ))*)*+)**+*(((((((((((((((((((()()())*)))*++**+++****+)*+*)+**+*)*)*++*)*((((((()*(++)))*((((((()()))()(())((((()(((()())))+))))                                                                                                                                *++*)*)+*++*((((((((((((((()(()()))(()(((++++*+++)+*****)+******+++++**+*)(((((((()***)**)())**)))())*)))()))(*)))))()())*))*)))                                                                                                                                *+***)*++*++)(((((((((((()((()(((((((((()++++*)++++++)*+*))*+++++++**++++()((((()+*+++++*++)(*)*())))()()(*)*))*)(*))())*))))***                                                                                                                                +**)*))*+++)*)((((((((((((((((((((((((((()*+++,++*,++*+++)+++++,,++++*++**)(()*()++*++++,++)*)*((()())(*))())**))))))())*()))***                                                                                                                                **)*))**++*)(*(((((((((((((((((((((((((()++,,,,,,,,,,,,+,,++++++++++++++**+))*))*)++++++,+++)))()()(((((())(*))))(()())))))()*)*                         +++**)                                                                                                 *)))*)+)++*))()(((((((((((((((((((((((((*++,---,,-,--,-,,+,++++*)++*++++++++*+***+++,++++++)))()((((((((((()()()(()))(*))))*)*+*                      ,,./...-,*                                       ++  ++)                                                  *)**))+++))(*(((((((((((((((((()(()()(()**+,,-,-,--,,-,+++++++*****))*+*+++++++++,,,,,,,,++)*)(((((((((((((((()()(()()()(())(++)                    *+-./.-./.-*                                      -.--//-,)                                                 ))))))****)))(()((((((((((((()))))()))***++,,--,--,,,++++*)++)**))(()**++++,,,,,,,-,,,,,++*))*(((((((((((((((((((((((()(((((()*)           ,,,,*  ,,,,,.--,-.-,,  )))                                +-//....-,*                                                *(()*++*+)(((((((((((((()()+)*))+)+*+*****++,+,+,++++++)))**)**+*)))*)*+*++,,,,,,-,,,,,+++)*)))((((((((((((((((((((((((((((((())       ,,,,-,,---,..--,,+,,,+,++*,..,*)                              +,-,,++,,*+*                                               )()()*++)(((((((((((((()***)(*)+)+******)***++++++)*)*))((()()(()(()((()+*+++++,+,,,+++++*))()(((((((((((((((((((((((((((((((()(      *,----,,--..-..-./,.-+,,,,,./.-,)                               ,,,,+*+***                                                ))((())))((((()((((((**())+)))))())*)*)())))(())*))())((((((((()((((((((())+))*++*++*****)*))(((((((((((((((((((((((((((((((((((      +,,--,,,,,,-----,+./.,/....-..,*))                             +,++** **                                                  ()(((((*()(((())())))())))(()((((()))))(()((((((((((((((((((((((((((((((()))(())))()))*))*(*)())((((((((((((((((((((((((((()((((        *********)))***),-,./---.,*,,*)))                                                                                       ))((()())))((()()()()))()((((((((((()(((((((((((((((((((((((((((((((((((((((((((((((()))((((()))))((((((((((((((((((((((((()((((         )))))))))))***))),..-,,,,+,,***)                                                                                       (((((()()+())(((()()((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((()))()(()))+*)((()(((((((((((((((((((((()(((               ))     )))+++-,++,,+++****)                                                                                      (((((((()(*()()()()))((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((()())())))*+)))((((((((((((((((((((((((((((                        )**********))))))                                                                                       ((((((((((()))()))(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((()()))()**+*+)()(((((((((((()((((((()()((((                        )))))+*+**)))                                                                                           ((((((((((())))(()(()((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((())**)*()*****(*(((()((((((((((((()((((()((                           ))))))*                                                                                              ((((((((((()))))()()()(()(((((((((((((((((((((((((((((((((((((((((((((((((((((((((()))))**+)()*++**+))()))(((((((((((((((((()()(                                                                                                                                (((((((((((()))))())()(((((((((((((((((((((((((((((((((((((((((((((((((((()()(((()()*+**++++*)++)*)+*(*))*)((()(((((((((((((()((                                                                                                                                ((((((((((())**)()()())(((((((((((((((((((((((((((((((((((((((((((())))()()*(*)()(**)+*+++*++++++++++**++)))))))))((((((((((()((                                                                                                                                ((((((((((()***)()())()(((((((((((((((((((((((((((((((((((((((((((((*(()()()))*)**))*+++*++*++*++*+**)**+*)))(())(((((((((((((((                                                                                                                                )((((((((()**++***)()()()(()((((((((((((((((((((((((((((((((((((((()(()((()()()))*(*)++++++++*+++*++++++++*))(((()((((((((((((((                                                                                                                                (((((((((((*++++**+**))))((()((((((((((((((((((((((((((((((((((((((((((()((()(((((((((*++*++**+*****++++++++))((((((((((((((((((                                                                                                                                (((((((((((*+++++++++++*))))()(((((((((((((((((((((((((((((((((((((((((((((((((((((((((()***+)))))))+++,,+++*(((((((((((((((((((                                                                                                                                ((((((((()()*+++++++,++*+**()((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((**)((((()++++++*+))((((((((((((((((((                                                                                                                                ((((((((((+**,,,+,,,+,++++))()(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((**++**+*)(((((((((((((((((()(                                                                                                                                (((((((()*)*+,,,,,,+,,++++*)*+(((((()(((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((***(((((((((((((((((((((((((                                                                                                                                ((((((()++++++,,,,,,++++****+)))()))*))()()((((((((((((((((((((((((((((((((((((((((((((((((((((((((((*((((((((((((((((((((((((((                                                                                                                                (((((((*++++++,,,,,+++*+++)*))+(*)(*))****+)(((((((((((((((((((((((((((((((((((((((((((((((((((((((((*((((((((((((((((((((((((((                                                                                                                                (((()**++++++++++++++)*)**)(+(*++++))*))+***)))((((((((((((((((((((((((((((((()(((((((((((((((((((((((((((((((((((((((((((((((((                                                                                                                                (((())*)*))*))++*)))))+*)+++)))+**)+)+*+)++))))()())()()())(((((((((((((((((((()((((((((((((((((((((((((((((((((((((((((((((((((                                                                ((((((((()()))(**)*))))))(*)*)'(((((((((((((())(*)()((((((((((((                                                                ((((((*((((*)))++))))*))*)***)'(((((((()()()(())*))(((((((((((((                                      "%%&                    ((((()+*())**)***+*(()))()*)))()((((((((*()(((()*)((((((((((((((                                   %%,,..-,,+%                  (((((**)()****)+***)()(()(**(()(((()()((((()((((((((((((((((((((                                 ++,....-,(  %@            )')(())))(*)****))())(((((*)(((())(()(((((((((((((((((((((((((((                                  %*+,,,-,-,$  +,+            ))(*))(*)***+))(())*+**())**)()()()()((((((((((((((()'((((((((((       ('%                         $**++,,,+   *,,$            )())))*))*)****))()++++***+++)*)()))((((((((((((((((()((((((((((      +-+*+(+                        &***+++++$+*+'            )*)()()(())*))())(*+,+,+++,+++)*(()'(((((((()(((((((((((((((()')       $$$                            ")))*+++%**'1           )**)((((())*))(()*)+,,,,,+,,+**(((((((((((((((((((((((((((((((()                                       ')*'*+*'"$**             )***()((((*))(()))+++,,,++*)()((((((((((((((((()(())()))()())))(                                          $*'"$$1             )(**++*()(***())(****++*))()((((((((((((((()((()*))))+***)))*)*)                                            $*+($               )(+*++++***++*)*)()()++)(((((((((((((((((()()(()(*)**++*)*)))*()                                            $+--+               **++*+****()(**)(((((+*)(((()(((((((((((()()((()(**+*,+++++,+**)                                             $!@               *)*****()*)(((((()(())))(((())(((((((((()()*)()***++*++,,++,,++*                                                                )***+**)**)*))((()()(*+)(((**))((((((((())**********)*+*+++*,+**                      "**$                                      **)+***)(****)*())())))*())*)*()(((()')(****)*)****)()+)**)*+***          &-)1  %,"  $*                                 $"    ***)**+))(***)*()(())))()())))+**)()()(*)*))))+***))))))*)*)+)**         (,..-(&(//,-)                                  +'2   ******))()**)**()((()))()()')**+*())))()))*)))****))))))***)*)**          %+*+,..-.,..&                                *ۼ     ++*+*)))*()**))*))))*(((((((()*)*+)(*)()))))))*)**)()*)+**))+))*            *-,,+++,(@            %%  "          (*         +++**))))**+***)***)((((()(())))***))**())(()))*))))**********++               *('+--.-)-,&      -/-,(+--("        ""         ())*)*******++*(+++)())))()*(****++***+*)()((((*)()*****++*++++)                " !-,-,,..,+,% "%,.//.-./.+,                   ((()*****)+))+,+,,++*)))*)+*)*+)++++*)**)*)(()(*))()*)**)(*(()*(                  "'+++*,-,,,/-%--,-/..---,*&                  (****+*+**+)'*++,+,,+++++*+*+*+*+,,*())*+++*)*)***)*)(*)((((())(                    " $***+,-,,,.-.,--,,-*+$                   )+++++,++*+)(*+,+,-,,--+,*+)*++*,,+)*()+*++,**+++++**))*((()()((,*$                     ")*+*+---./--,,+***$                   **,++++*+*)))+++++,,-,-,++***)**,,+**)**+,-,+++,+,*++*())))())()%+,1            %%    "'*)%)+-,-..,.+**&"                    )**+*****))*))+*)*++++++*+***)*++++*)+)*+--,,,+,,,++++*)*)(*())(              "&).-)*,.,-,+-/./-,,***')                        *+)+*+*+*+()())()****)******+)*********+++,,+,+,,,++*+**))((()((  &%,&&,+%%&,,-././///..-,--,+*))$*!                          +,+,++*+*((())(*))))*))**)+***)*+*)***)+++,++*+*+***)))*(()())))  *,++,,,+*,,--.-./.--/-,(%'+,*++,,,&                          ++*)*)***()))*)))(*)***)********+*))))))+++*)*))))*))***)(*)+*+*(+*&*++**+**,-,-,-,,,,,-++***'''+.//..()'"                     !+++*++***())()*())*+**)))*)*+++*+**)())****)(()((()**+))+())+**++------+,--.,++%%%&(+,-,+*  $$',....--,-,!                   ',+++++**)*)))))*********+*++*++***))))()*+)((((()(***+*))))**+*+,,-/.,,,,../.+%      ,--,***+,-+----,++++'"               %+,*++*+,+,+**))(*))*+)*+*+++++*)*)*))))()(())*((((()(*)*+**))(++++++*+,-,*++,-.---% ",,--/.*$"%+,,,,***$&&!             %,,,,,,-+++*+++++*()())()***)*))))*)()()()((((((()))((()))*+)+**)**+,++++**+')+)*,,.--------.---)"    *++*%          $     (&(.///.---+**)***+*))))())))))()(((())(((()((((((((()***)**+*+*+*+)**+***+*     "$'**,,,-..,--+,-+"    (,,*(""%"%&&%,,,-,%),,,,-.///...+$*)))****+)**))(((()'()((((*((((((((((()(******++++*+**)())))(**)         "**,,-,+++,.,+    (++*+,+,++,,-.-//.--..-----.//....+)***)*)+,+++)((((((((((()')()()((((((((*+++,*,++++++**)())))))*(            $*++,**(*-+*($%++*+++($@     %,.......-----...--.++**)())*++,)((((((((((((((())(((()()))**,,,+,++,,,++******)**())              *..,  %%$**'**+*,-,+%       (--,-------,,,--,-,(+*+**(*)+*)((((((((()(((((((()()**))++++--,,,,++,+,+*+*++***+*)*             $++++*       $'*)+,----+   %%%+,%%,-,--,,+,-..,-+ **+()((())(((((())()())))))(())*)*)*,,,,,---+,+++++++*+,+++*++))          )*+*   ")("     $%',-/..,)(,---+%  (.-./..--//./.-'**())((()'(()'()))***)****+**)**)*)*++,,-,-,,,+*)()**))+**++*)(+          **)*   !(..,,1     )*+-,,+*++--,'%   &&+,-..--...-.,+**+**)))(()(*()))()***)*))))))()(+*+*+,+,+,,***((()((((()(*)((*        +++!   "+*+*'"      '**)'%  #(,*(*       %(+,+(,,,,,)*)+*+*++))))**))))))))()())*()()())()))*+***)(()((((()((((()())        +("     )'' )                  "'+'                ()'())**)**)))*)))()*+*(((***()(((((((((()((((((((((()(((((*+))(       '1       $                                             ))))(()**)*)())(((((*))(()(+*((()((((((((((((((((((((((()))*++*)     $%        $'                                              *++*))))(((((((((((())()*))***)))((((((((((((((((((()(()))(**++*              $+*                                               +,,+**)((((((((((((()*)*+*)++***)*())(((((((((()()()((())((*)**+              +'                                               ++,+*)()'(((((((((((***)*))*++*****+)*))))()(()*(*))(()(()(*)))+                                                                **+**)((((((((((((*)**+**))**++**+++**))***()((()()()(((()(**)*(                                                                *****(((((((((()())*)+*+++**++*+)*+))(()**)))((((()()((((()))**(                                                                +*)+*+((((((()(()(((*+*+*+*****+++*+)(((******))))())))*(*()*))*                                                                *)*)+*)((((((((((((()+,,+,++++++,+*+**(*)+++,*))()()()*)())))(**           )-,'1                  ""$1                        *))+*))(((((((((()((*,-,-,-,+++***+*++++++,+,*)((((((()(()))()**     %% +.--.,1$!               ".-/-'1                       )))+*(()((((())))*)*++,,,,+*****)))+++,,,-,++*)((((((((((((((())   (-,,-.-.-,,,,,.,              ",,++*"                       )()*)'()'()(**))*)*)*))*+))((()(((())+*++++***((((((((((((((((((   +,++++++--..--+)!1            "%$"$                         )(())(()())()(((())(((((((((((((((((()(()()))())((((((((((((()((    $'&$%)*,-+,++*'                                           (((())()()((((((((((((((((((((((((((((((((())()**()'(((((((((()(            ))*+*)&$"                                           (((((())(()(((((((((((((((((((((((((((((((((*))**))((((((((()(((             "$$                                               ((((((*)()(()(((((((((((((((((((((((((((()*)+*)+**)))(()((((((((                                                               ((((((**()()(((((((((((((((((((((()())))))+*+++*++***)))(((((()(                                                                ((((()++*)))(()(((((((((((((((((((((()()())+*++*+*+++*)(((((((((                                                                ((((()++++++*()((((((((((((((((((((((((((((())*())++++)(((((((((                                                                (((((++,,+,++)*(((((((((((((((((((((((((((((((((((+*)(((((((((()                                                                ((((,++,,++++)*)))))*))(((((((((((((((((((((((((()(((((((((((((@                                                               (()****++*)***)*+*)***))()((()((((((((((((((((((((((((((((((((((                                ((()(()**))))*)(((((((()*(((((((                 ))&$         (((*))***))()))(((()((()((((((((                '+--- '#      ()))))*)))))(*(()()(((((((((((((   (%$          %)++&*)      )()))))))*++++**()((((((((((((((    !              ))+&''      )*(((*())*,,++))(((((((((()((())                      ''1      (++)***)(***()((((((((()))*+))))                      ("@      ****))()(())(()(((((())(*+*,+++*           #                   ****)*)()(*)(*)(((())*)***)**+*+    ),'*%                !&  ***)))*)()())()+)())))*)*))*)*)*     %,-,-#      1     #  +**))*)*)*(((())*)*)()))*))*****        (--,*$ "*/+-,   @    )(*****+++(*))***+**)((*()****)*         '++-+-----+         )+*++*(,+,,,*+**,*)**+**+*))(()(''         "*(,-.-,)&         *+*+)*)+*,+,+*)*,***+-+,+++)))() "$%""'*.,..,--+)(            *++**())))*)********+,+++***()()**,+*----,.*(*),-)#"          +***))))(***)*+**)))+*()))*)))+*,.-,,/,""'-+''(-.,,+       !%(+++*))*)***++***))()*((()***)**++**+,--((-,-$ ++&#"!   '-.,,*+*+)()))))())(()((((*(***+)*++*    &,,-,+-@#,)'')),.+*-,-//.)*)**+*)(((((()((((()*+*+++*)(*(*       (-)$(('*++)   ,--.-----+**))+*((((((((()()*+,,,+,+**+)*)     &)%$  ),.,#')*"+.-,..-(*)(()((()))*)*))*)+,--++***+*+*)    *&  (+)   )+)$),' !',,,-,****)))))))))))())**++*)((((()()     "$"1        "        !)())*)))((+((*)(((((()((((((()+)      #%                       ++*)(((((((*)*+))(((((()((()()*+                              ++)(((((()**)***++))))())()(()*)                                ***(((((()*++**+**)(*))())()()*)      $                       )**)((((((*,,,++*+**+++()(())()* &)(,-,(@      '-*            )))((())*)*++*))()++,+*(((((((((  '((),-,*                   ()()()((((((((((((((()))((((((((     '&                      ((())(((((((((((((((()**))((((((                               (((*))((((((((((()())*+*+**)((((                                (()++,)((((((((((((((()()+)(((((                                (**++***)**)(((((()'(((((((((((p        $    ()(**(*((()(((((@!    *,"(   )(*))**)((((((((         (   *))))+*(((()(*()           ݿ   **))()()(())**++  (*p  @    *))*)((*)))))*)*   )+')-,!    )+)++***+*))*)))"&&*+,)     *+))*+****,++*()*+,+',)(-)    #+*))****))*()*)+%)++-')%%&).,)+))()()(()*+)**  &'#)+$$)-,.+*(*(()()*+,++***  ڮ%#&!!$%&*))))))())))(((*               +)(((*)**()()()*               *)(((+++***)()(* -(   &      )()()))())*)((((              (()(((((((**))((                (++))((((((()(((wgrass1_1   ???K@   @   (   (  (  (  7;797;7749;96;9976;79777=79;;99979;99;7776779777797779797697699==697676977997997699;;;6;977=;=96663799;=9S6679476;763;76;9777763 76;7;79=974S7399677633;77966641;7797;999=94S96;7 T7;9677667694S4466637779967  7977699696S946=66;T;6=;;74976737;676933169;643;966;=79;77474;67;9499=X9;97314469;;9941;967969997777;377636677776947;677;V7 39;767949=3697777346777;9=97494=;97977497=2%;77;43 67477;7979;699=797;479279=677;69;;6;7499776;973=;977S26;9==76;793;7;7993977747;977649V62=799673;77973699=739;797;;9VT97397967;7673;77;964976;6=7936;3;76 46XT46;9;;6;67;6997=6974=79363949967SXS96;9497;;69=99796499=6977;=793733=X44974SX3646;9467=9=769=9994979797979469677 3;3;X39644T7 66;9467;;69;79;777967799996963 773X76164326976;46766;996967;9777V=9799;74696737=V464632 37696946496677979969X99976;766967 X9=9632 476;69;47696797X9977;9769=7 X6994T12 7;769;979966967776679==67797;746=7X634 7=79;9666977969699994=9443673S334;7=79;96396T99;;74;9777;;4=6;9667;733 347697=6;;97696;7w77976;77743634=7;74;97 V37796;;979;9766;7777666999774476633 ;=;7673T67946=;39376=76676663;76;;777497776341=6;X=9976774767946=9339399=67;6733796;73779=6;=967474 47763763937349T763794767 67;=;7;99767743 69;67713334;6=T337979793997764344;9=;9737;4976762393T;6=4676;77776697;647;;S931477W3676343377937=4976;79776677;9944;;46W6V;7697737=799394697679777;;6=69;4974;14764967 ;9=;69S947776767=77;74697476=;79449X;=;67477;999979;=;473343;99=S796699X9;;7969967997=66466433 36;9=97;79979;96;;677779=;79662442 46;997VT79999;67;797976;;=;7;;733 4916;67=W97VT9;;T779;7666977769769=6==6344;3667;999V7397;7S6;97;47;;76966;=7;64=346649W766;7773;67S67;769776%;664697;343;17644;7476;7766V93999;97696776999376733736;737;9467;97367976;666966977;39746334637;S4444=797=676776776699763236X139693764996=97;796776=96;769643432  37696673666979=;479967969647677769;343  V;7=7S666699;7997;99667;697337;67733  9669=934697;67=6769;67;774696;7999  69=;7;6779SV797997663;9;76;7=47766779 7 769;;9366V747777663397;777=7634676679734=37 7S9773794 96=S7763397;77676367669=77967;7=9737963799S=66642297=777632 6777;96799=3779;=36637;7669;6627396=962363699979379794;344796747X9696=663;9;999=S;7397;7S643779;76674;779396=66697;S99=S943=7674769;6=739767146=7796;S9==44;647693496;66=699;76=6;;;9=4=96=677;;76;9667;96=9769S496=;;97;9=47S=;77497;77;39V669;69;777;67S79669;7;7=4666;7777;497;6=7366799966;9S9969777S7799;S99796996=737X7S779;7999999789t;t:9s9sV7;:9s9sS9t8u::V8<8VV9rt9t9ut;986;768;sT7489:8S5trs5s8:u76rs9t689;4S9r9s8<9u;a87t989;9478s8t7969984r6t8;:T5:987t69967r79u9865;r9t86797V88;:959;598r587sr5898t89;r69895665969588t8;9;9r;879887 787V454s79$8899t6888;9968598r5268676788;78t9t79564498:86t;99VT897695246;8978899t98rr45=6746s77;87;8757;8r48r3;9<s67698666879496866r:;8S548:534896986s8:66u9T64V6783886687;VU868r768858<;ttT599;T:96387;8s89;9t778;<88826389V6S99W7t8987998767669867;U9T7796976764769665879Us8t77494r775S:69r77:499532@s8;8r7799s9;U9589t9t2 478;V9s8t8;s5:u99478756789r74rr96r6488U53r778t;688;765899T599449t9:5898476Sst56;798V8u9;;s5s84tS9<48=99t;t;9;S89t985s99;7t;T6999978998USs98t7;s989t8U9u;t99t;989rr98r888r7789t78t8t788:779r8t9678689t9:88t7884888;8874988t;64998768768696685868tt984597;V9899669ss9987s5658s7s778489s9896866977889!79676889s9;s799988898s8t9887t8976r98s888886887678896789789city6_8 3   ???K@   @   (   (  (  (  227544523233qb44333r`tsrbr99s8q47r88vu#4r#8ssr#us7r84s7#7#;u88utaqs`##ttqsssqs#stuss8;ts3csrr32;ssqstssrassss#rssstssr2ss7sssrrrr#r7ssss3##22#rbb8#rs#7rtss7bs2r#sq37ss#r8srrss3#s`ss8#sVsus#2#8rrrqq7##rr3su77s#bs#sVs7772W8pqss#7T4`u9srs 8;ts3p;q433333333  5wsusr33q55#s#s54r338Vssrqts333attsss4q3rsssrrrrs8;srs78ssss7qqr#ss77s22sssr#7:8;8#77srqq3s8s4p287qtr77548r#853r##4p2t7ssq74q47#r777r7arq5522ts#ssss43333qrrqq 23sss5sss33333333qq4q44q!u!822rrsss3ss3q788r54q!ss2t#25r###3ts#rrT88s#sss2ss223ss57as87##t2sr#!!22222222!21222223##q43     s q`#7#11111!!411233qr342 1222 22qr8#: #!33q#;sss3#r#r2qssssrr!###qTs:sbss7rwr2qsrtssr !5#3rsss$88rstr##2sq2qsrsssssr!##4!ss4sssrsr22bsss3qrsssssssrsas#4rrrs#2tssu$!qrrrrsssrrs3333333q2r#Tr#23rabssssr;tss33333qq!33q5sv`ss2222222222222ssssrssr##s! !!!#5q3rrqq2ss77ss##5sr`2!5!#;sr##srqpr##4#sr3`qq5`2q55r7#35stt23qq322q22p##r2`q`q2cssr124ssts7q#qq222qqq222ssq24r#sr8#t###r#T3sr#2#qrsr4s88$$sr3s4r!!rs9#7%s477757rr#rqr28$#88s7r#55#s424#s#s5s77#7rrr7`s#3234r757q88:rs8#sq#q4r223333443323322q34rqqr!21322!2323122!322222 2222222`sutr78cd7s221212122qq23r2`q333211 222ss88#stsssr#qqqq24<ut8ts7qs77#8qr774rr348#3s###338#ss7sr73ssss8#rs#assrs#7#5#s#r####s8#aq`qq333223q7s2rssr8rrq2222222222222222a5#ss#srssr2r#rsussssq3q#85:sVs79;ssbq2ss7###qs88Vsr87sr489sq33``qq`q347ssss4;8#87#8!78q2q88#78rs878sqqqqss8tt7s#7;brV#s88qscusss4sr#sbr4ssr8773bssus:b#s#rs78#sr7#s3ssscssr8sq878ssssq2#7ssrrbsbcb`!!qq#88##03qq57rssss3aq43332q7#rrr000332223333`qq3qq!r6q5rr`r6#t4s5bs6sq3srrsqs6!rtrrs 756rr3434`t4ru7s4r44r8s76rrr63rra41rss5q7`b4rsrr"q2pq43`#5s`3rrsrtrs334t8!3rstrbsuttsrssrq5q44st#4ru4#r#66ar2r57qr3323336att33qrr527qrrsr387t"ra`4rstrrrsrrV7r4`r`q6Ϋ7s5t8r7s8sb76qssr324!4rr36t4r47s635s4srrrrͬ3336b4rrrsbrrsrbsrrrrrrrrswbrick1_5  /???K@   @   (   (  (  (  22222sssssssssssssssssssssstssssssssssssssssssstssssssssssssstssssssssssssssssstsssssssssssssssssstssssstssssssssssssssssssssssssssssssssssssssss2ssssssssssssssssstssssstsssssssssstsssssssssssssstssssssssststssssssssstsststststsssssssssssssstssssssssssssssssssssststsssstssssssssssssssssssssssstsssssssssssssssssssssttssssssstssssssssssssss2sssssss122ssssstssssssusuussssssttsssssssstssssssssssssststsssssssssssssssstsssssrrsssstsssstsrrssstsssstssstsssssssssssssstsssssssssssssssssssssssssssssssssststssssssssssstssssssssusssssssssssssssssssttsssstsssstsssssssssstssssssssstsstssstsssssssssssssssssststsssssssstssssssssssssstssssssssssssttssssssssssssssssstsssssssssssssssss2r3r3rrsars`rrsrrrsrasrrrarrrqrrsrrqrrrssssssrr`rrasssrrr3tsrsarrqr`rarrs`rrrsarrs`rbsssrsasrsrrssrasssrrbrr`sssrarssssbrrrrrrbsrrrrrrrarr3`4q3rarrssbrsbsrsssbrrr`srs`ssrrsrsrrrsr`rrrrsrssrrrsrbsr`rrsarr`rrrr`ss`rrrsrr`rsr`rrrrbrrtr`rrrrsarrrsasr`rsrr``rrsrarrr`r3rrrrr`rrrrarrrrr`rrarrrrrrbrsrarrsrrarr`rrsssrarrrrrarrrbrrrrsrrarrrrrarrrrrrrrrarrrrrarrrrrrarrrlgmetal2    ???K@     (   (  (, (; qqqqq#qqqqqqqq#qqq#qqqqq#qqq$qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq#q#qqqq#qqq#qq#qqqqqqqqqqqqqqqqqqqqqqqqqq#q!q!$q#q#q#q#qqqqqqqqqqqqqqqqqq!##q!qqqqqq!#qqq#!qqq!qqq#qq$q#qq#qqqqqqqqqqqqq!q!!#q!q!q$qq!#qqqq##!q#qq##!q$q#q$qqq#qqq$qqqqqqqqqq#qq#q##q##q#qqq$$qq#$qq$$#$$qq$$qqqqqqqqqqq3#q#qqqqqq$qqqq3$qqq3$3qq3q3#3q3q3q3qq3#q3q$q3qq!qq!!#!qq#!!q#qqq!q#!qq#q!!q#q!qqq!qq3q#3qqq3qq3q!q3#qqqqr!q$q#!q#qqq$q#!qqq!!#q!#qq!$#$q3q!##3q!q#qq#q#q!#q$!q3$#!q!q$!q$$!qq$!q3q#qq#$qq##qq##qq#$#q$!$r$##q#q$!#qq#$#q#$$#qq#q!q##!qr#$!q#qq$$q$#q#!$#qq!q##qqqq#qqqq$qq3qqqqqqqqq#q#q$q!q#q#qq#qqrqqqq#qqq#qqq##qqq##!qqqq#q$!qq##qqq$#q#qqqqq3q#qqqq3qqqq3qqqqq3qq!q##$q#q#q!q#qqq#3qq#q3qq3qqq$3#qqqq3qq3qq3!qqq3qqqqqq3qq3qqqq3qqqq3#qqqqq###!#$#!qq#$$qq#$#!qq#$#!qqqqqqq3!!q#qqq#3!qq#q#qq$q3!qqq#qq#q3qqq#qqqq3qq#qqqqqqq!q$!#!!q!#$!!q!qqqq$3q$$qqq!qqq#$q##3#qqqqq!#$!qqq!!#qqqq!!qqqq!!!qqqq#!q#q#qqqq#qq#q#q!q$qqqqqqqqq3qqq#qqq!#q#q!q##qqqq##qq$qqq##q#qqq##qqq!#q##!$q#!##!qq!###!!#!q#!#!q#$#q#!#!#!#!qqqq#qq!qq!qqqq!!qq$qq!!qqq#qq!!!qqq#q$qq#$q#q#$$q##qq#qq3q!3q3q!qq3q#3q3qqq!q3qq!!3#q#qqq!#q#q#q!qqq!#q!#qqq#q#qqq$q#q!q!3q#!3$3$3q!q33q!#q!#3$3#!!3$qq!33#q$3q#!3!!3q#!#q$###!#!3%q#!#$q#q$!!$3q$q#!!$3q#!q#!##!##q##!$$$!q###!q!q$#$#!!##qqqqq#qq##qqq##q#q#qqq#qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq#qq#q##qq#qq##q!q#q!qqqqqqqqqqqqq#qqq!q#qq!q#!q#!!q##qqq#q#q!qqqqqqqqqqqqqqqqq#!#$#!#qqqq!qqqq$qqq#qqq#!$qqq#qq$qq#qqq#qqqqqqqqqq!qq!q!qq!!$qq##!q$q##!q$q#!#!q$q$qqqq$qqqqq$qqqq$#q#qq#qq###q$q#q$$q$$#qq$#q$$qq$$$#qq$qqq$qqq!qqqqq$qqqq3$#qqqq3qqqq3#qqq3$#3q#3q3qq#q3#!q3q3q#3#3#q3q#!qq!!!#qqq!qq$qq#q$qq!#!qq#!!#qqq!q3!q!$qq3q$qq3#q!qq$q##q##!qq##q!$q!#!#$q!#q!##q#q#3q!#q##q$!q3$$!q$!q3q$!q3q$!q3q#q#qq##qq##qq##qq$qq#$qq#q$#q$q$#q#$q#q!q#qq!qqq##q#$#q!q##q3qqqqqq#qqq$qqqqqq#q##q#q#q#q$#q$q$qqq#qqq#qqqqq#qqq$#qq#q#qqq$#$qqq#q###qqq###q#qqq3qqqq3qqqq3qqqqq3qqq3qqq##$$qq$qqqqqq3#q3qqqqqqqq3qq3q$qq3qqq33qqq3!qqq3qqqqqq3qqqqq3qqqqq#$!q##qq#$#!qqq##$q$#qqqqqq3qqqqq!#q#qqqq3!qq#qqq3!q!#qq$q3qqq#qq$qq#qq#q#$!#!q$q#q!!q!$qqqq#$#$q3qqqq#3qq3qqqq3$qqq#q$!!qq#q##!qqqqq!!qqq!qqq$qq!qq$qq!q#q#q!qqq#q#qqq$q#qqqq#q#q#qqq!q#qqqq!qqq#!qqqq$q##q$#qqqqq$!qq#qqqq#qqqq!#qqqqqq!#!q##$!qq$#!qq!$!qq!#!!!#!qq#!#!!!##!q!!q#$q#qq!!qq!!q$q!!qqq$q!qq#qq!!qq$q##q#q#q#q#q#$q!q##q##q!3q!3q#3#qqqqq#3q3#q!q3$q!3#q$q!$!q#qqq$!q$q##qq#q#qq!q3$##3$3#!#3$#$!3$#q#!qq###!$#$3#3q#$3q#$3q#!$$3q$##!3q###!##$#q##!#$3qq#q##!q#!q!##$!q!q##$##q#q$!##$#!#q!q##3qqq!q###$#qqqqqqq!qqqqqqqq##qq#qqqqq$qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq##qq#qqqqqq#q$!qq!q#qq$q$qqq$qqqqqqqqqqqq###$#q##q#$qqqqqq#qq#qqqqqqq#qqq$qq#qq#!!!!!$!!qq$qqqqq!qqqq!qqq#qqqqqqqqqqqqqqqqqqqqqq#qqq##qq#qqq$qq#qq#q#qqq#$q#qqqq####$#qqq#qqq#qqq$qqqq#qqqq#q#!###!q#qq#qq#qqq#qqqqqqq#qqqqqqqqqqqq#q$qq$q#q#3qqq#3qq$qq!#3q$qq3q$qq!$#$!$##$###$###$#$#!q#q#q$qq##qq#qqq$$q$#$$#$#$$##$$q!q3qq#q!##!#!q#!#!q$!#q#!#!q$$$#qq!$qq$3#$$qqq#q##qq#q#q!#qq!q!!q!q!!q!##qq!!q!!q!##qq#!!##q!q##q!qq3q!q3q!q3qq3qq3qq33qq#q#qq3qq#q#qq33qq#q#qq33qq#q#qq33qq#q#$qqqq!3!qqqqq!3!qqqq3!$qqqq3#qqqqq3qq#qqq#q##qqq#qq3#!3333#qq#qqqqqqqqq!qqqqq#$#$#$######$$####qq3qqq#3qqq3q#q3qqqq3$3qqq3qqq3#3qqqq3$qqqq3$!#qqq#qq!qq$qqqq$#qq!qq#qqq!!qqqq$!!qq!qqqq#!qqqqqqqqqqq#!qqqqqq#qqq#qq#!q#qq##!qq###qq#qq#$q$#q!q!q#$qq!q##qq#!##q!q##qqq#qqqq#q#qq!q#qq#q#q#qq#qqq$q$qq##q#q#qqq#q#q#qq!qq#qq#q#qq!q3qq!q!qq!q3qq!qqq!q3qq!qqq!q3qq!q!qqq3qq!q$#q#$33$q$33q##33q#$33q#$3#!##$3#qq!qq##3#qq!qq!##3#qqqq!##$3qqqq!#$3#qq!q#q$!qq$q$!q$qqq#!q!#!q#!qq!!q#qq#!q#3!qq!q#q!!!q$!q!#q#q#!qq#q#$q!#3!#!q#q3q$qq3q3q#qq3q$qq#q3q$qq3q3#qq3#qq#qqq#qq#qqq#3$qq#qqq#3##qqq#qqq$3##qq#$#qqqq$!q#q$!q#$!q#q$!q#q$!!q##q!#333#q##q!333$q##q!333#q##q!333#q#q!333#q3$q!q!!!!#q3#q!q!!!3#!#q3#q!q!!$!3!q3#q!q!!!3!q3q!#q!!!3!#qq!!$$q#q#q!!##q#q#q!##!q##q$q!!##q##qq!!##rrrr"!rr#!!rrrrr"r!4#5"4"r#r#r!4r#r!4"#r4rqrr4###rr"4###4rrr""r"r#4##r!r#rr"r"r#r"!r#r#4!""#4#r#`r##4#r`r!#!rr##r4##4#rr"""5##r#r#3#r#4#r#4#!r"4$#r#rrrrr"!#r4#r""r"r"r##rr""r#r#r"r!rr#rr###r#r##r4#!r#4#"r#r#r!#4#r""!r"#!r"r3#r#r#r"#"5#qr"3"r#q#4!r#r4`#r"r"#5"#r`r##rrr#"rr##r4!r#r#rr!!r!r`"5#r#r!r""rrr!r"r!rr#4##r!r"rr#4""r#rr"rr##r#rrrr#r5###5#r"r"#r#r!r5!r#q###5##!rr"r"#r!rrr""4##r"r"!r##5"`r#r!#4!#"rr"r"!r#r#r!#ar#rr#""rr##"r#4#"r!5"#4#"r5!`rr"r!rq"#rr"r#rq##r!r#3!#r#r!r#4q#`##4#r"!!rr#r#r!"rr!r#r!4#r#r#4r#q##4#!rrr#rr#5!!r!r#r#rr#3"#5!r#r"#r#r#r#rr#r!r"r#rrr""4r"r#r#r"rrrrqr"r##"rr"!r"r#rr"r"4#!rq##4"q#rq"rr#r!"r#r4#r#r"rr#rrr#r"r#r"#rr"#"r!r"rr!r"!r!"r#r"r""###rr!r"r!r##4r"#6""!#r"#r"r!r!#4rr!r!r!!r!5!#r#rrr#r!rr4!"rr!"#r4#r#r#4#3rr"3!"!4"#rr"""#4!##r#r###r##r!#!4"r#r#r"rrr##rr"r"##rr4"r!rr##4""#r"rr#5"4#rr#r#rrq#rr"rr#rr!5"4""r!rr#r`r"#r!#r#r"#r4"`"#q#rr"r#rq"r#!r#5#r#"4#"r#q##rrr"#qr#r#r#r##4"#r4!r#4#r#!#rrq#`r"#5""rr"r#r#rr#r#5###5##r"r""rr"rr"r##5##"r#`r#"!rr3##4""#rr#rr#"#rr#r##4#`"rrr"r#r##r#r!r#r#rr#r#4`"rrrq#``r#rr4#`!4#`r#r#"#4#qr"#4!r!#r###rqr#4#!"#4""#r#4#3##4#"rr#r5#r#r3!"#5##4r"#4rr"r"rr#rq#"r"r##rr!r#5#!#4#!"!r"#r"5##r"!4"r#r#"##r!r##r!r##rr!"#r!rr#r##rr!#r#4""3r"r"r!##rrr#r"4#!r"#r"rr"r#!r"#4"!r#4#4"q#q#4#!r#!r#rrr#!rrr"r##3r!rr#5###r#r`rr#r"r#r!rrr"r"r#r4r#"#4r"r!#4#r!r"rr"r#rr!rr#4##r#5"r#r#r#r3`rrr"r#r!rr##4#r#44##rrrq"#rr!rr!!r#"rr#r#r!"rrr#rr""r#4#!r#r##rr#4!#4#`"!rr"#r#4"!##4#r#r#r5"#rr"r##5"r##r!rr"#!r#r!r#r"#r""r"!r!#"r#!r#r"4r!!r!r##r#5"r!#!#r"5"4!#rr##4"r#!r#5"r!rr!!rr#4"#r"###4q##r4!r!!r!"#"5"""#4"#!#!r"#"#4#"4#r#4##"r!rrr#rr#r#5"#5"`"r"r#r#r#r3!#!r#4"#rrrr"r"3!r#r#r#r#r!rr3#r"4a`"4r!rr!r##5#arr##rr#rra"#rrrr#r##5"r!#rr###r!rr#rrr"!rr#rq"#r#r"r#rr"r##r"r#r#rr#r#rrr##!#5#r#!3"rr#r#4"!`#rr!r#`r#q!#q#r##rr##r!r4#r""rr#r"#rrrr#r#4#r"r"r!#rr"#r"4#5"q!r"r!rr#r#rr"rrr"q#4`r4"#r!r#4`q#qr#"r#q"rr"5`"#"r!r"r#r"r#`r"rr!"r#r"rr!"#4#rr!`#4r!q##5##r!4"r!#4#r##"!4q"r#q""r!#""#4"r#r"3##r"r##5"r##4"#"#r#q"r`"#r##r!##rr#4"#"4#`#r!r!r`"r##r#r##rr"4"#rr"r"r!r##4##r#r#r#r!r"r#r!r!r#rr!#r!r!r"q!r#r#rr#r!4"r!4#r!r#rr#r##5!#45##r#r#4!!r!r#rqrrr#rr"#r#r4"rr#r"r#r"!4##4#rr#q5#"!r##r#rr###rr"!rq#4q"r#rrr!"4#r"r#4!q#r"r##5##r"rr!r#rr!r"r"r!`rr#5#!r#r#r!r!"r""##r"4``!rr#r!4##4!4##4!!#r4#`r"#qr#3r#r!rr!r"r"r!r#r!6#!r!3r#rr!r#"r#4"#r!rr#rr"3""rr#r"!rr4#`#4r"r""!r!4"!r#4"#r#4!4"#r!####4#4#4"3r"r#5""r##5!"r#r#4#"r#r!4!r#4!!!5"#!"r4!r!#!r!r!r#!r!rr!r"!r#r!"rr#""!5!!"r"##!#rrrrrrr"r"rr"rrrrr"r#r"rr##rrr""rrrrrrr"rr#r!rr"r#rrrrrr!rrrrrrrrrrrr"rrrr""rrrrr!r"r"r"rr"r"!rrrr#rrr"#"rr"r"#rr#rr""rrr"r"rr""r"#rrr#r#rrr"rrr"##rr#"rrrrr"rrrr#rrrrrrrrrrr!rrrrrr"rrr!"r#!r!rrr"rrrr`""r#rr"r"rr"rrrr"rrrr#rrr#rrrr"r"rr"r"#rrr"rrr"rr"rrr#"rr#rrrrrrrr!r!rrrrrrr"rr!rrrrrrrrrrrrrrrrr"rrr"rrrr"r"rrrrrrrrrr"rr!rrrrrrrrrrrrrrrrrr!rr!rwswamp1_4   ???K@   @   (   (  (  (  b5a445S5444`r44r4q4r5q5bstrra7987r`b5`aar8998sbrSTbs888tuvutb87b4rasbb88ct88bbr997t9bbttbbbb65`ctrbbb59b9bb7tbt``89bbb5bbb7sb:bbbbbbs78cttbbr798bca5abb`564bt:tccbssb8utct799VcVbbr5rrb9bcbbbsbt;;ttcbb7bt99;9bt54srbbcbbbbt9;Vbtb7sbt898bb5sr`6`bbtbbbbscbs8tttcct8bst77b875rr6br`bbbab6bbb8bc97ttcb7`br88`b8btb8tTbbbcbb8bc97bbbtcbbb7bs8`58ttt9bbbbbs888887bStctbb7`rrbbbT6b8bcV8bbbbbbbb`bbst8;97bSSbr7Tbb8tbbbtVtbbrrbb787ctbb7`rsbtbtbbtVVbrb7bbb7cb7`r8brr``tt:8Vcb8ttbb7r`b44sr`tccu:8ss8tb9bbbbt8SS`r87rrbb7b`4sr4bt8sss896756b586r87bb`b77sb77brsr4`8b8cbbbs67898rrbb59:86r`r78stsbb78arb8bcbcs786rbb5686rrbbtcsb85b68ccctcb855bb57655bscbbrrb766ctcctbbt7675bbb57555bccbr`6`rrb9ttcbbt575btV`a755877br`4`bcctttVt8brr`5586bb7b7a44`8bcctctVt8ba`raaa75b6tb8b55`bb4897bs88t66bba565bb6s97bb88srr97sbbTb6Tt575`rb898bts`7rb4r8tbr575a767bbtsr6rrba6br44b565765a``4srr6a``44ar4456`7555555655643rr556476r55`55556`5`54q`55556654445r5r55arr5455r55543575554r`rrr`6865sbS5r653358Sb``5764bbaar78bs:9rsrr`44a55b7bb674`arb7ct8:tctsrbbrr44b87bba78bbb7tt89ucbcbbb5b89T68b78bb`btt9tcrbb87569b79bbttVbt69abcbrr97b889:9bbcstu:cc69bbbbrr5b9bb89abbb8u:tbbct9tb`r978c5bbtc788tcb789;88tttbbb7898889bbb6b78cVudc7;tuc8tVt`rb889:97b8984677t788V8cccb9ttcb8cb`rbbsb787779scbcbbc8r8b988b9ccbSb``bbt:8a8tbsb8b4688bbb9cVbrS77tt98ba`8bsbs87r46;bbcc8bbrbt:6999ttbrr8b89745rb98bbbb:97cbbbr9rrsbb787`5a8:8bcbbrt8bbbt8b`b85757776Sbbbrb8btVbb8985457ts78ctubbbrr`bb8cutb6r8b44bb98tttrrbbttt9t4`ccttt`7c4b94``b9tct9cVcttVtb68crb4b78b4``Tsbc8ctccb9ttbctbb67brr4rbb7bbb888tttctbr687b4`4bcb7b5rbbbb889tccbcbbba`7r`bbr4abbctbb97bb`788tbbbbbba`r4```4`b7b75566bb`tbbbb`4rar87r`r``b8bbb54`r`rbbrbbb```7`4`5rr8`abb````bbrbb``r`5a``r`54rr7bb`ab`4`ab`r`bbr`444`S5b!`5444````6a444!rab`44`r5r!44!4`rbr76rqr`67`Srsr8sstbsr5bc9b`6bsssb7c8sbbrrbs`r5tcsassb;cts9Vbrrbbbsb8css8rb76bsbrbrrbbssbTcbr7brr7c8bbab897btsbrrrb7atsbd8brbs8bbrsrsct9sb7rbssa7rbrs6`rUbs86rra68sr`srTb6a8ccs6rrbrS6rbbr6cbsrSsbra65rsc75ccts6sbrarSrb7brrUssTrrar5b88brsr6a4br656bqrrr5rq3567r5arr45rr64r545r5rarrrrSrrbrsqS87br4as7rbTbrsb9tbbarb866sbr7bts6bb8b89`bsbVba9ss8brb8cs8Vtsrasbs8s87bb97t78bcTtb`8bsssb758bbbt7bs79sb8b8rr7Ubbtsssbssa8s5r8rTtbbsctrrb4sb9c9tbtc6arrs5br`sb8cbbr6ab4bbs6bb7stbrbsbr6`arsssb64abrb`5`5arb`qbaar46`q4rssS7bs6bbss8c6asbrbssbs7brrrc8bssbs6asrTsras6asrra6crsarSsbrrrsb7ra7sbrrrr46`rr55ar56ra7b6rbsar8rasVbsb8ssb6r7bsb6sbsrsS8bbtrsars7abssbrr`sbsra6sa`5rqab6ssasbsra6b7a6arr6ra6sa7srbsTbrrbrsbrra6city2_5 3   ???K@   @   (   (  (  (  ##%#%%#%%%$%%%##%%#%#%######%$$%%%%#%%%######%##%##%'''%%%&'&&&%%&#%%%%%%%####%$&%#&&&&&&&%&&&&&%%##%%%%%%%#%#%%$%##$#$$$#$$#&#$$$!##!#%##$$$$$$$#%$$$!#%%&$##$$#$$##$$$#'$$$!$#!#%$%$$$#$%$$$#%$$$#$#%$&$%$##$##$&$$#%'$!%$!#%%%$$$$##$$#$$$$#$$$####$%$#%$$$$#!!!!%#$!#%$$$####$$$#$$###%%$%%##$%%$$&&%%#%###$!#%%%%$$###$###%$##$$$$%#!!!!!###!!1111!!!!!!!!!!!#!!!!!!!!##!!!##$%%%%$%%%$$$##$####%%%#%%%####$%##%%%###$#%#######$$##$#&&&&&&%&%&&%#$%%%$%%%&%&%'&'&&%&&&&%%&%&&'&'&&&'&%&$%%%$&'&&%&!#&!####$##%&$$$#####%'##%##%#%#%$##$###!&####$####&##$###$&######%$##$###$#%&$&$&$%&&%$$$$$%'%$%%$$%%%#!!#&###$##%$####$$$###%&$&&$%$&&$&&&$$%(&$&&$$%&%%$#!$&$$$%$$$#%$#$$$$$#%&%%%###%%$$$%'&&&$&$&&&%%%##%!#%&&&%%$#%$$$$&%$!!!!$#!!!!####%$$$$!!!!!!#!!!!1!!###!!#$$$##%%#$%#%$%%%%####%#$$%%%$%%%%%%%%%#########%$$$$%#$$$$%%%%%%'%%'&((''&''&&##(''''''&('&&&%%$$%%%%%%%&&%%$%$$&&&&&&&&&%&&&%%%%##%%$%###%%$#%'#$#$%%%%%$$$$####%&&&&%&%%%##&%#%&$#%%$$###%%%#%&%#%$$##$#%#$#$##!%&$$%$%$%$%%##%##!#%%#%&$#######%&###%$#!#%$#$$$%$$&$%$#%##!!###%%$&$$$%&##%#!#$$$##$$$%%$##%!!####$%#$$$$$$$$%%%$%&##!!#$#!#%!!!!!!!!$#%#!!!11!!!1!!!11!11111!!##$%$$%%##%%%%%$$%%%%%%%%#%#%######%####$####%%%%%&%%&&&$%$$%%&'(&&&$%%%&%%%&'&&%&'&%'&''&&%%%&&'&%&#&&&%&&&''(''&&&%(((('&'$$$###%$#####$##%&##########&###$&'&$%&$$$$$%$#$$#%#$$##$$$##%###%#%%%###%%##$&&&%#&$%$$$$%%#$$##%##$%%%%#&#####$%#$%#$$%&'&%##&$##%%####%###%%$%&&%%%#######$#$#$%$#$$#%&'&%$#%$#%#$$#$##%###%%&%$#&####$$&%$$$#&&&&###%%%$$%!!!!!!#!!!!!!!!!#!!!!!!!!!#!1!!!!!!!!!!!#!!!!!!!%%%%%%%%$$%$$%$$##########$$%%%$%%%%####################%%$&&&&&&&&&&&&'%&#'%%%%%$%%&%&&&$&&&&&&&'&&&%$#!####$$%$$$%&'&&%%'&%&%&'#$%$$$%$#&!!$%%$$$%$$%$$##$#$!##!!#$#!%&%%&%&&##$$$$%$#%!!$$$%$#%#%%$##$#!##$$##%&$#!%%$%&%&&$$%%&$%##%$$%%$$%#%&$$!#!#$#!&$$$$$$$&%%%%&$$&$$$%&%#$%%$$%$%!%$#$$#%&$$$#!!#$$$!&%$$$%$$%$%%%&&&&&&&&&&%&$$&%#%!##$$%%$%&%%%#!!!##!!#%#$%$$#####%!!##!!!!####!!!%##!11!!!!!!#!!!!!!11!%%%##%%####%$#########%%%%%%%%%%$%%#####%##$$%$%###########%%%%&'''&%#'%&&%%%$&%%%$%%%'&&&&&&&&&%&&%$%%%%&&&&%'&%&$%$#%%&%%&&###%!###!#%%%%#%%####%%%$$%$#!!!!#!!!!!!#####%##$###!&###########%$##$!!%#!!###!!$&!$$%$$%$&$!%'#########%$$#$#$%%%%$%%&$%$$%%#!&#!!!#%%%$$$&#!%&$###$#$#$####$#$#$$&%&$$%'&&&&%%###%#%'#!!!%%&%#$$#!$&$%##%$%%#%#$%$$$%%#$$%%(&&$&!!!!$$$$#!!$!!1!!#!#!!!!!!!!!!!%$$$#%%##%%%$$$#########%######%$#%%$#%%#%####%#%#%#'%&&'(&&(&()(&%&%%%%%%%%%$##&%%%&%%%%&''&%##%%%%%'%%%%&&''%#%#%%$!#&##$$##$#!#&$###$$$#!%&###%%%%##$$&$$%$$#$$%#!#$$#####!!#&##$%%&###%%%%#########'$%###'$$%$$$%$%($$%$$$$$$$########!%#####!#'###$%&%%%$$&($$&%&&&$%$$###%##%%%%##!###$$%&%$%$%%$%$##%#######%1!##!!!!#!!!!!!!1!!%!!$#!#%#!!!##!!%$$&%%&%%%%&%$%%%%%%%###$##%%$%%%%%%%%%%%##%%%%%%%%$%#%&$%%%%&&&&(&%&&&&&&((''''%%%%%%&$&&&%''&'((%%'''&&'%'%'&&'&#%&&&&'%#$#$#%&#####$$!!##%%####$$&$$%%%%$$%$#####%%%$$%(%%%$###$%%$$&$&$$$$!!$#$%###%%$$&%%%%$%%%%$%%$$%(%%##%%%%%&#%%$!!###%###$#%%%#&(%$%%#$%%%%%%##&$###!#%%%$%(#%%!!##$!%####$$$%%#%(&$%%$#%%%%$#%%$##$$%'###!!!#!#!!##%#########%%#%$$&!!!!!$#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!$!!!!!#&&$&%$%#%%$###$$%%&%%%$#%###$$##$#$%$#"$$##$$$$"#%%#$%##$$#!$$$#$$ݭ#$##$$$"#!!###"##"$"##%&%%%%#$$%%%&$%%$%%%%%$$$$%$#%"###"%##"#&##$ݭ#%"###&%%$&%%$&%&$%$#%#$"$####$$##$$%$$$$##"#!$$$"$$$%%%&&&%%&&&%&%$$$$$$%%%%%%%%%$%#$&#&##%$$#$###&%%%%&$#"$&$"#$##$"$$$%$#"!"$#####%""!!!!$&%&%%%&%%&%%%%$$&#$$%$&&&%&'&&#$#"$#%##$##ۻ#%&#%%$$%#$##$%%%"##$##$##%'##$"#"##$##!$"""$""#"#"%&%&%%&%$$$#$%&$%%%$%%##$$#$%%&%&&$$$$%!!$%$#$$###"##%#!%$%&$%$$$#$##&##"##$$$$%%%$%$$#$###"#$"$$#""!##"#"%%%%$$%$$$$$%&%&%%%$$%$&%$$$#$$&#%!#"#$$#$###$$##!!"#!$"$$%%"&#########$&$#&%%%"#%#"#$""$"!#"#"###%%$&$&&%$&#%$$#%#$$%#%%%#%$%$%&$###$$####"$##"#%#%$$#####!$#""!%#$%%$'#%%%$#$"$$#!ލ޺"%!#$#$""#"$%&&&%&&&&&#$$&%&%'%&&&%&%&%%##$&$###!#%##$%%%$%$##%$'%%%&#$#!#$###%$'$%#%%$%""%"""!!!"!##"""$"#$$$$$###$$##$###""#######$$##$%##%$##$"#$$$%$$"##%%$$%$%$$##%%$$##$#####"#$$$%#$$#$%$&%###$#"##%##"&%%$$#$$%#"$%$$$"$"%"##$##$###%$$#$%#$$###$#"##%$$$##$#$#$$$$$#"$$#$$#$%%$$#$$&%$%$%%"#$#!"#########$#$####$$#$##$#$#"$##$###$$%$##$"####$#$####$$##$###$$wall14_5 4  ???K@   @   (   (  (  (  !22222%%%%%%2%%%%ss%%%2%%%%72%9%%%%%%%%!%%%%7s%%%%%%%%%%7%Tt%29%%%%%%%7%%7s%7%%7%%%2%s%%%%%%%%2r%%%%u%%%u2%%%s6%%T%%ss2ss%%%%%%%24T%%#24%%%%%%22%%%%%r%%u%%2%%%%%%ru%%%%%2%%%%%%2r%%92r%%%%%%%%23222464346664!4244464422222%%%%%332%%%%%%%69%rs&%%%7r%u%T%%%s%%%s%%%%%%%%7%%%%%%%s%%%rr%%77&#%%%%%u%%u%%%%Tu%%%%r#&%%ruu%%%s%%u%%s%s%us#%%%%%%#%%u%%37#%%%T%%%%%%%%%%%u%&T%%9Tu7&r%%%%s%7%%%#u%%%%T%%%tsT%stT%%%%r22r%%`&sru$uusu`%t%t%$v%tΪ$$3ut&r4%qbt$ur`r5r43rruv%u&%t$t$$%$$tuvusu$usut$$tru$7auuturstuttmmetal1_2   ???K@   @   (   (  (  (  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!##"!!!!!!!##"!!!##"!!!!"#"!!!!#!!"!!!!#! !"!!!#! !"!!!!#! !"!!!"!!!"  !!!" !!!"  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"!!!!!!!"!!!!!!"!!!!!!!"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!a!Q!!!!!`a!!!!!!!!!!!!!baRQ!!!aa!!!!!!!!!``baRQ!!!aba!!!!!!!!`aRaaRQ!!!aa!!!!!!!!!!!!!!!aRaRQ!!!!!!aa!!!!!!!!!!!!!!!!aRQQRQ!!!abba!!!!!!!!!!!!!!!aQQQQ!baa!!!!!!!!!!!!!RQ!aaaaa!!!!!!!!!!!!!!!!!!RQ!!!!aa`!!!!!!!!!!!!!Q!a!!##"!!!!##"!!!!$#"a!!!!"""!!!#!!"#!!"$""!""!!"!"!!!!"!!!!#"!!!!"  !!!!!!!!!!!!!!!"!!!!!!!!!!!"!!!"!!!!"!!!"!!!!!!"!!!"!!"!!!!!""!!!""""!!!!!!!!!!!!!a!aa`!!!!!!aba!baba!!!!!!`!!aaaa!!!!!!!!!!!aaa!!!!!"!"abb!!!!!!!!!""bbcba!!!!!!#bab!!!!!!!!!!!!a"aaaa!!!##"!##"!"##"!`aa!!##"!#!!"#!!"#!!"ba#!!""!!!"!!""!!ab"!!!!!!!!!!a!!!!`a!!!!!!!!!!!!"!!!aba!!"!!!`!!"!!!!!!!aRSa"!!"!`"!!!!!a`Rba""!"a!""#"!!!!!!!!!!a`RSa!!"!aba!!"""!!!!!b`RSaa!aab`Rb"aba!!ab!a!!aa!abaRba!!!aba!!aa!!!aa!!!a!!!!!!!aa!!!"!!!!!!!!!abb!!!!!!!!!!!!!!!!!!!##"aaa!##"!!##"!""!!#""!!#!!"aaa!!a#!!"!#!!"!#!!"!"!!!aa`!!"!!!"!!!"!!!!!!!!!!!!!!!!!!!!!!!!!!"!!!"!!"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!`!a`!``!"!""ޮ"޽"!!` !!!!!q!!!!!!!!!!!!!!!!!r``a!r!!a5aa`45!a`!!!!4aa`r!!!!4!r``!!`"!#!r"!!!r! !!r!!!a!!```ar!`!a`r!a!bb!r`a"ޭޭa"!!!!!a!`!``!͍!!!!aͭ""!ar͍ar!ra!!`a!!`!΍!"a""!"!!`!!!޾!`!!`!`!`!!rrr!`!!!!!!!``!4!a!a``a!͍a!!!``!!``a``sfloor4_1   ???K@   @   (   (  (  (  "!"!!#!"##&&&$$#"#%$%$$"#$#$%'%$"$$&####$###$$##$##$#$$$$##$$%#$##$$###%$&#!!#!##a##!##!!#$#!##$##"#%`#######!! !! !!"#!!!######!!#####"#"$""###$###"#""#"##"!!"!#!!!!##!"#"!###"##!!"#!##"##"#####"#$#"##$#!!!#!`##! #!"!&#!##"""#!!"#"#""!"#"!!!#!!!!#!##"!!###!"!#!###"!"&"#!"######$"##"!###$"!#!!#!!!`""#q##!&!###"!!"#"!`##!""###"!#!####"$""!$$#"###%#!!r! # #!$"!"#r# %!"#"###"#""#####!!!!a!#!!!"!!!!##!#"!"!##"!#"#"!#######""#$%$###"!###"#$!##"!####!##""#!##$"$#"##"$"#$!%&$##"#$$#! "##!##""$$#!!%"#$!###"!"#""#!#$#!##!"!!"a!"#!!#!#"!##$"#""$#"##`!####"#"$#!"! !a"###"#!"######"""#$##$#!&#!##!!###!##!### &#"!!#""$##""#!##!!!#!##!#! #!#!#####""#!##!!#""#"#!##"$#####""#######"!#!##!!##!`##!"#######""!###!###"!""$""$#$#$"#$###!####!!##! ###%###$###""#$"!#"! "!!#!!#!#!!!!####!##"#!"!###!###!"#"#"#####"$"##$"# #!!"!#`#!!#!#!#!#"##"###`#""#!"####$"####$!!##!!###!"!!!#"#! ##! %#""!""##$"##"#"###!"!!## "#&#!!!#"!##"""##!`###!"####"#$#"!"#"#!##" !!#!!#!!"""!#!""#"#""!"!#"!##$##"###!!##"####"#!!r###  !"!!#"!! ####!!$"""$#""!!!  !!!!"!!!!"!"!"#!#"!!##!!!"!!###""!#"!#!#"!#!!#`#""#######$####""#ݭ#!##r"#!"#"#""""#"""#""#!!##"#!ދ#!"###!""#$#!"!"##2"#r$#""#""#"ݻ!!ޭ!`!#"#a#r##ޭ"#"####`!#"!##ެ#"#`"#r"###r##""""##s!##!"`#`#"###r""ݭ""###"##!#"!##s޻b!"##ޭ"#r#"""!!""#""!!!"ݭ#!!"#"ޭ"#!##!"!cop1_2 2_1  ???K@   @   (   (  (  (  b"5#5#`ޮ"ޮ#""5#""ޮ5#"#`#"5޽#555"#ޮ5q5###``qqqaqq#"#`#5`###5#`""#4"ޮ#`q#`#qq#q````q"ޮ`q`q```"ޮޭ`ޮq`a`q###"#"q`ޮ``#`q4`#```ab``q`ޮ`##`##5#`5#"!"4q`q#qbޮ"`qq5``##q"#"!#E```5##"`##޼"#""5!`#޽"޽#!q####"###q#"##"`#"#"#޽q޽޽#qޭ5q5##""5`4#ޭ##5#޽#"5###`r######`#"޼`#"5#5`#5#ޮͼq``"#qq``q#q#`55q5#޼#"`4#`###"#``#`#"```5qa``q"r`##`#޽#r5"#"aa`#q`޼#q#q``޼##`"#"ޮ``ޮ#`"q####"##q"`#5q4`#޽`޽"!`qq##q``qb"q4#``qqb`qޮ#q#ޮ``#`#5q"qq#4"#"#`5q""q####5#5b"޼####`r#ޮb#"###bq!!####5#####޽#5#ޭ""###޽!r!```5`3ra``!`a3```ar!``!`ra!ra``!"!ޮ!`r#"!!!`!``r`޼!`!r!!``!`4ޭ"r!!!#!``!q!`r!!`mmetal1_7   ???K@   @   (   (  (  (  !"###""###########$$#$########"!!"#####"###########!#a###!a##"$#!aa!#"#bba"!#a""#%a!a4a!abaaba#"#a!#aa#aaaaa!!!aaaaaaaaa#aaa"aa#!#!4baaa!#"!b"!a#bbaa!aa!!!!!a#aaaq!bbabb!a#aaa!a"!baa!!aa#a3a!#!aa!!#aaa!aaaab!!!!!"a!b#!bba"aa#aa#!#ab!!!a!a##!!4"!aa!!aa2#"!!!!aa!!!aa!a`aa!!##!!!4!"#aa!#a!"b!##`a4aabbbb"2!#!abb#aba!a`!##baaa!""b!ab!!aa!`!baa!`abbb#aabaabbaba!b!aa!a`!a!!!!#!#!aab"!`!#b#aaaaaa"baaa!aab#!aa`ab!"!!"bba#a!```a`!##abab!!!aa#b!ba`!bb!#!abaa!!!aaaabbaab"#aaa!!#!abc#aaba!!ab`"!`!a!!aabbaaaa#ab`baaaaaab#!aaa!ab#!#baaaa!#ab!##bb"aaa`b!#ab"ba`aaaa44a"!bb`4`aab!`a!ba"aa##!b"!`aaaaa5!!!baa#ba"b!aa!##abaa!a!##a#!a!a5a"!aa#!aba!aaaba!a!ba!!#!`aa!!!!#!"#a!ab"b!aaa!aaa!!a!aaa!!b#a#aa!b!aba!ba!aab!aaa!aabaa!!a`4a`#a`!a!a!aa!"""baaa!!!!!!!!!!!!!!!`!!!#!!!!!!!"###"#"#"##"#rrr#``a`ra`ar!araar`!r!rr!"`a!rrrr`a#aarar!"arar!r`rr`r!ara`r#aar`ar!rr`ra!a`baaa"`rrr!ra!`arar!ba``aar`a"rarra!`r`rr`ar!a!rr`aras!arar!!!!!!!#`aarrrr``rwizwood1_6  ???K@   @   (   (  (  (  cbc`bdca`````aabbb`abcbbca`acaaacbbabcaaa`p`abacabbaadcdcbcb`ac````bcdaaa`abbbccd`abcbbca`acaaacbb`bbaba`p`abbbcbbaaaa````````abbbbdcaa`acbabceaababaca`acaaadbcabcaba```bbbbcbbaa```abbaaaacccbdbbca`acatacea`ataaca`acabbdbcabcaba```cbbbcabaa``bddccbdcdcccd`cba``adbabcdaababaca`acabbdbcaccaba```cbabbabaaabdcddcbbbddcdcacbb`adcbdccaaacbaca`acbcbcbcacbaca``acabbabaa`bbabddccacabcccbcbc`aecbcbcaaacbaca`acbbbcbcaccacb`pacbcbba``aa`tbcdcbbadcdddbbbcaadcbcbcaa`db`ca`adbabcbcabcbcb``bbacbcca`bdbabbdbbbedcbbcdaacbadccbbdaa`db`ca`adaabcbcbbdadb``cabcacca`adeedccbbecbd`bcc`aac`accdcbdaa`cbaca`acacbdbcbbdadb``cabbacba`bdccdcbbdbaacacdb`bacaacbccbcaa`bbada`ac`cbdbcbbc`cb``cbabbcbaa`bdccbbdcatbcbccatd`bbacbccbbaa`bbada`abacbdbdbbc`bc`acbabbccab``bdcbbdcbaccbccbad`ab`adbccbbaa`bbaca`ab`abcbcbba`ad`acbbcbccbca`adcbbcccdcdbcccdc`adaacbbcbba`abb`ba`ab`bdbcba`t`c`accbbccbbbb``bdcbdbccddbcdcbb`adbacabcbba`abb`ca`acabbdbcba```a`bcbcbcccbcca`adcbcbccddcbcbbd`adcadabbbba`bbb`ba``cbbbcccca`````cbcccbcbbdcb``bdcdbcdddcbcacd`adcacabbbbaabbb`a```abbccbaa````ppdcbcbbcbbdcba`adcdbcdcdcbcacb`bcdbaabacaa`bcb`a`dd`adebdedccca`pdbccbbcbbcdcb``bddbcdcdcbcbbb`bcdcaabacab`bcb`b`dc`abdacdbbaeba`bbccabccbbdcca`acdbcdcdcccbbaabcddaabacab`bcb`b`dcsabdabcbasdca`dbccabbcbbccbaa`ccdccccbbcbbaabbcdaabac`b`bcb`b`cc`bbcabcbbadcaacbdcabbbbbbdbba`ccdcdcdabccbaabbcdb`cac`a`bcb`a`dc`cbcbbcbcdecaabccbaccabbbcbba`ccbcccdbcccbabbabdcacac`b`bcb`a`dcabbcabdbccdcabbccbacbabbccbb`accccdcdbcdcbabbbbdcabac`a`adb`a`dcabbcabcbccdbacbccbcbcccbcdbb`bccccdcdbcdbaabcbabcaaac`a`adbaa`dcabbcabcbccdcadbdccbbbbbccecb`ccccddcdccebaabccbbcba`c`b`adbaa`dcbcbcabdbcccbadacbdbbdacbcdbb`cddcddcdccebabbadcbcca`c`baacbaa`dcbbbcabdbcccaadbbccbadbccccba`cddcdccdccebabbddcbcca`c`baadbaa`cdbbbcabdcbcbaacbadcbadcbcccba`dcccdccdccdbabbbccbccaacab`acbaa`cdbbbcbbdcbcaaaaadbcbaccbcbba``dccbdcbccccaabbbcccbcbab`b`adba``cdbcbcbbdcbba```dbcccacccbbba`acddbccabcbc`bbbbbccbacabab`acba``cdbbbcbbccbba``dcbcccabcccbba`adcdbccdddacabbbbbbccacba`b`abba``bdbcbcbbccbba`dbbbcbcabcbcbaa`bdccbddcccbc`bbcbabbcbcca`b`acba``bdbdbcabdbbcaadbbbcbbabcbcbb``ccccbdccccbcabccb`abcbbca`b`acba``cdbcbcabdbbcbadbcbcbaabcbcbba`cddcbdccccbcacccba`bcbbcb`baacb```cdbcbcbbcbbcbccbcbbcaabcbcbba`ccdbbdccdcbcacdccbabccbbc`b`acb`a`ccbcbcbacbbcadcbbbbcaabcbcbba`ccdbbcdcddbcbcdccbbbbccbc`b`acb`a`bcbdbdbacbccadcbbbbcaabccbcba`ccdcccccdcccabcdccbbbccbcbb`adb`b`bdbcadbadbccadcabbbcaabbdbcba`ccccccccdcccabcddcbbbbccbcb`adb`b`bdbcadbacbbcbdbbbcbdaabbcbcba`dcdccbccdccdabcddccbbbccbcb`aeb`a`bdbcaccacbcbbdbbabbcaabbbbcb`ccdccbccccdcbbccdccbbbabbcbaaeb`b`bccdaccbcbcaccbbacbbabcbaacb`ccdcdcbcccdbbbbccddcbbabbcb`ada`b`bcbdaccbcbbacbbbabbaabccd`ab`dddcccbccddbbbbcdccdcbbabcc``db`a`bcbdadcbcbbacbbaacbbabcced`aacddcccbdccdacbbcdcbcdbbbbcca`cb`a`bcbdaccbcbaadcba`cbcbadbdbc`bdddcbccdccdabbbbcccbcbacbcbb`cb`a`acbcadcacbabdcba`cbdbbcbdbbcqcdddcccddcccabbbbccbddcabcbbc`bb`a`adbbbdcacbacdcbb`ccdbccbdcba`dccdccccccccabbbccbdcccbabbccbaa`a`acdbadcacbaccbcbacccbccbdcb``ddbccccccdccbcbcbdccdccbaabcc`````acdbabcbdbacbbbbacccbcdbcba``cccccccdcdcc`acbcdcdccccba`bcdb````acebabcbcabcbbcbacdcaddbcba`accdccdcdccbc``cbcccdcdcccbabcdc````abdbabcbdabdcbcbacdcaccbcbapbcdccccbccdcb``bbccccbddccbbbbcd````abdbabcbdacdcacbaddcbbbbcb`pccddccdcbbccb`acbcbccbdcccbabcdb```abccabcacbccbadabdcbcbcbcb`pdcccbccdcbabb``acbcbcdcbcccb`bccca``abccabbabbcba`dacdbcbbdbbbpdcccbcccccb`a`abbbbbccccccb`abcdb``addcabcaacda``dacdbdbccbba`ddccccccccdba`aabbbbbcdccccb`abcb``addcabbaaddb`dadcbdbcbabapaccbcccccccdd`qaabcbbbcdddccb`abcba`adecabbaadeb``cadcbdbacabapbccccdcccccdc``q``bcbbcccdddccaacba`adebabcaabdb``bbdbbbaacaa`pcccccdddbcdcc`qq`bccbbcbccddcb`ba``acebabcbbabb``ccdbbc`tdaa`pddccccccbccdc``qq`accbbcbcccdcca```adebabcaca````bbcaabbcd`aapddcccdddbcdcc`ba```bccbbbbcbcdcb``acdbabcabaaa```aa``abbb`a`pddccccccbbdccabcaq`bb`abbbcbcbaa`````addbabbbdaaa`a`````qpqdbabccccbcabcabda``aat`bbcbaa```aabcaaddbabbbdaab`aa``````dataccccbbtac`bbaa``baaccaa```aacbbcaaddbcacbbabbaba`p`````````dbabcccbbaabc`bcca``acaa```ab`abcbbcaabdbbacbbabbaba`pabbbbbbbadddcacbabbaacbaaacbcbababbabaaacbabbaaabbcc`bbbcabbabacbbba`acbba`acbbdcbcabcbcabbabbcbbbaEsbabaacdcbbdcba`cbcaacbbbcbbbcbbca`bbccbcbcabbdbc`caabbcbbccbbcaaddcbcbcbbbbcbbEsc`baccbbbabbbbabcbdbcbccaacbbbaabaacbbabacbcbb`cbcddbcc`ccabbbaabaccbaabccbcabcccdbbcadabbaac`abbccbbacbcbcbccdccbbadbbbaacabbaccbbacbbcbcabcccbcabbcbb`acababcbccbbcacbbbbacdcccabbdac`ac`bbbbcccbbcbcbbcabcdcccacbbabaacabbbcbccbbcccbbdaccddccbbdbbbaacaacbbccbaccbcbcc`cdccccabccbba`caaccbcb`bbcbcbbDdccbcbbbbcbab`baacbcbcbcbcacbbacccccbcabcba`c`accbcbbcbbbbbcabcccccbccabcbaababbcbcbbcbbbbbcabccccccccbbccacacbccbbdbbbaccabccccccbdcbbcbacaacbcbbbdabcabcbcccccbccccabbacracccbbbcabacbbabdcccdbbcccbbc`c`acbdbbbc`cbbdb`cdbcdcabcccbbbbba`cbcbbcc`cccbccdccdcabccccbbba`acbcbbcbaccccbqdccccc`bdcccbbcbacbbcbcbbcbdbb`ccdccb`bccbdcacbabbcbccbadcbbaaccdcba`acbcccabcaacbbacabcbccbbcccccbqabbccdbabb`dbbaebbbccbabccccda`cbcccdba`dbbbbaadbacaccdcccb``bbcbccbadaca`aaabbadccdbcaca`babca`b`dbbcaa````bbcccbba`bba`aacbaccbbaba`aaadbcbabcbbbabbaaac`bbcbabcaabcbEsbacbcbabcaabcbabbbcccbbbbaabbaacccccbbbbabacbacbcaccbbcababcbbcbbbcccbbFsbbcbbcbcbdcacbabacbbbbcGsccbbbbbabcbcabbcccbccbbabcbbcabcccbccbb`ccbabcacccbcbbbabcbbcbbcccaccbccbcbcbacccccbbacacbcbaccb`bccaabbbabbaccbbaaabacbaaacbbabbbabbcabacabccabbbbcbcbFscbbccbbacbbcbcbacbbcbcbacbbcabbG8aaccity2_6 gdA ?oB @   @   (   (  (  (  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!sr"rs!##޼!"!!s"strr""btb!tt!ttbr"!#"!!tr"rtt!ޫ!"!!b$tts!!!!!r!s!!"#ubt"br"st##!r"!!޻rttt$u$tts"r"!!"!!!"!!str޻!*water0 2   ???K@   @   (   (  (  (  !!#!!!###################!###!##!#######!#############!!#!#####!#!#!!###!!!!#!#########!!!!###!##!!!#####!###########################################!###################################################################################!#!####################!############################################!!!##!##!!###!!!#####################!####!!#####!!#####!!!!#!#############!####################!!###""##""##"######!##"!""###"##!"##""#####r#####ݭ##""#####"####ޭ"###""!#r##r####$###!#"#!!""#""#####"##!!###!!#########"#"##"##"#޻##""######"##""##"##"#""#"cop1_5 8    ???K@   @   (   (  (  (  cccabbbbaaarabbrbbacaaaaabbaaaaabaaaaaac`baa`aabababbaaababaabaa4a`bbbbaaebaaaaaabaaaaaaaaaaabaaba!!bbaabbaaaaac!b!abaaaaarb!!!!abbaaaaab!!abaa!bcaaaabaaa!bbbbaap!abaaabappaaaaaaaaa`bbaaappaaaacab`bbaaaabaabaaabaaaba`b!aaaaaaacaaaaaasa`baaaaaaaaab5aa`a`baaabaaaSbaaaaaaaaa`aaaaa5aaacab!abab`aaabb`aaarbsaaaaaaaabaaaaa5aba`a`aa`aacaaaaaaabaaaaaa``aaaabaaabaababa`aaaabaaba`a`aaaaabaabcacba`baabaaa`bcbcad`cb`abcba``daaaa`aabaabaaaaa`aaaa`abaaaaaaabaaaaaaabbaaaaaaaabaaaaaaaaaaabbbaaaabaabbbaba`acaa!abbaaaaabaaba`cabaaaa`!caaaaaaabbacaaaaa`aaaaabbbcaaabaaaaaaaaaaaabdaaaaaaabaababbaaaaaaabaa5aaaaaaaaa`aabacaaaaaaadabaaaabaa`aababaaaaaa!baaabcabacaa`aacaaaaabcaabbaaaa`baa```aaac``ac``rabbcbbbaaaabababaacbaabaacb`a`aabbbaabbaaaaabc`a`baaaaaabbaaabbbaaaaaaaaba`aabbaaaabbaaabaaaaaaabaaaaa!aaacaaababaaaabaaaababaaabcaaaaab!aaabcabaacbbab!!!aabbaaaaab`a!!ababbaaaacbaaa!b!badaaaaaaaaaaabb!!!aabaaaaabacaaabc!caabaaaabbaaba`abaaaaaaaaa!aaabaaaabaͭpaa`acbaaaaaaa`a!ppaa!!abappppppppabbaarabaararaabararaararaa`crarraaa`a!r`͜bbraa`bar`ra`ar`qaaarr`a`ar`aaraaaaaararra`aaarrraaarabbaabrar`aaa`baaar`ab`arrraaaar`baaba`bar`bbaaaaabaaarraaararaa`aa`ar`rrara`araabrrabacaaab`arbabaararaba``araarra!a͍`abarra`abarb!raaaabb`arraq`3`barraarar`ra`a͍ra`raarara`arbaar``ararra`r`ra`rwizwood1_2  ???K@   @   (   (  (  (  a```abcab`a`abcbaa`cbabca`abcaa`bcbabccbaa`abacba``bcbacbaaacba`a```abcabaa`abcbaa`cbabca`abbaa`bcbaabcba``ab`cba``bdbacbaaacca`````abb`baa`abdba``cbadba`abbaa`cbbaabcba``ab`bb```bdbabbaaabda`````abb`baa`abdba``bbacba`abbaaacba`abdca``ab`bb```bdbabbaabbea`````abb`baa`abdba``bbadba`abbaaacba`abecba`ab`bb```bdbabbababda`````abb`baa`abcba``bbacba`abbaabbaa`abecb``ab`bb```bdbabbabbbea`````abb`baa`abdba``bbadba`abbaabbaa``becba`ab`bb```bcbabbababea`````abb`baa`abcba``bbacba`abaaabbaa``bdcba`ab`bb```acbaababbbda`````abb`aaa`aadbba`bbacca`aba`aba`a`abdcaa`bbabc```abbaabbabbda````a`bb``ab`aacbba`baadca`aba`ab``a`abcbaa`bbabc```abb`abbacaca````a`bba`ab`aabbba`baacba`aba`ab`ba`abcbaaabbabd`a`abb`abbacaba````a`bca`ab``abcbabbaacba`aba`abaca`accaa`abbabd`b`abb``bbababa````a`bca`aba`abcbaabaacca`aba`aaac``bccaa`abaabc`b`abb``bbacaca`a``a`bca`aab`abdba`baabca`aba`aaab``bcba``ababbcab`aab``bbacacb`a``a`bcbaaab``bdb``b`abca`aca`aaab`abcba``ababababa`ab``bbacacb`aa`a`bbba`ab``beb``b`abb``acaaaaba`acca```abababababab``bbacabb`aa`a`abba`ab``bdba`a`aba``aca`aaca`acca```bbababaaaaaba`abacabcaaa`a`abcb``b``bdba`a`aba``bd```bc``acca```bbababaaababa`abababcbaa`a`abcb``a``bcba`a`aba``bd```bb``bcca``abbbbababababb`ababbacbca`a`abdb``a``bcba`aaaca``bc``aca`accba``ababbabababaab`ababbabbca`a`abdba`a``bcbb`aaaca``bcb`bca`accaa``ababcababbabab``caab`bbcb`a``bdba`a``bdbbaaaada``bbbacb``acca```bb`bcaaabbabab``caab`abbbaa``adca`b``bdbbaaabda`abbabcb``bdca```ba`bcaaabcbaab``b``c`abbcaa``acca`b``bdcba`abea`acbabcb`abdb``a`ba`bc`aabcba`b`ab`ac``bbcaaa`acda`b``bddba`abea`acb`bca`acca``aaba`cb`aabcba`b`ac`aca`abcbaa`acca`b``aceba`abeaabcb`bc``adba``aab``cbaaabcba`b`bcaaca`abbb`a`abca`b``aceba`abcaabbb`bc``bdca``abb``cb`abbdbb`b`bcaaba`abcb`a`aaca`b``acebaabbcaabcb`cb``bdc```abb`acbaabbdcbaa`bbaabb`abcb`a`aaca`b``abdbaabcbaabcb`ca``bcb```aca`bca`abcdcba``bba`ab`abcb`a`aaca`c``abdbaabdb`abca`caa`cca```aca`bca`abcdcbb``bcb`ac`abbbaa`aaca`c``abccabcda`abca`caa`dba```aca`cba`abccbcb``bcb`ab`aabba```aca`cb`aabcabcda`abbaacaaadba```acaacb``abccbcb``bcb``c`aacba```acaacb``abdbbdc``bcb``c`bacba```aca`cb`aabcbbcba`abbaacaa`dba```aca`cba`abdbbdb``bcb`ab`bacbaa`aaca`ca`abbcbbbca`abca`caa`cca```aca`bba`abdcddb``bcb`ac`badb`a`aada`c``abbcbabcb`abca`caa`bcb```aba`bca`abdccca``bba`ab`cadb`a`aada`b``abcba`acbaabdb`ca``bdc```aba`bcaaabdddbaa`bbaabb`cadb`a`aada`b``abcba``bcaabeb`cb``bdca``abb`acb`abdedb`b`bcaaba`cadb`a`abea`b``abcba``bcaabeb`bb``adba``aab``bbaabdeda`b`bcaaca`cbdbaa`acda`b``abcba`abcaabdb`bb``acca``aaba`cc`abdfca`b`ac`aca`cbcaaa`acda`b``bbcbaacbca`acb`ac``abdb``a`ba`bd`abdeca`b`ab`ac``bbcaa``acca`b``bccbacdbca`acb`ac```bdca```ba`bdaabdebaab``b``c`abbbaa``adca`b``bccbadcbca`abb`ac```acca```bb`bcaabddbaab``caab`abcb`a``bdba`a``bccbacbaca``bb`ac`a`abbaa``ab`bdaabcdbaab``caab`bbca`a`abdba`a``bccb`baaca``bc`ab`a`accaa``ababcaabdcbaab`ababbabbba`a`abdb``a``bcba`aaaca``bc`ab`a``bcba``abbbcabbcbbabb`ababbacbaa`a`abcb``a``bcba`a`aca``bc`ab`b``abca```bbababbcbaaba`abababcbaa`b`abcb``b``bcba`a`aba``bc`ab`ba`acba```bbababacbaaba`abacabcbaa`b`abcb`ab``bcba`a`aba``ac`aa`ba`acba```ababababa`ab``bbacabbaaa`b`abcb`ab``bcb``b`abb``ac`aa`ab`abcaa``ababababaaac``bbacacbabaabaabbbaab``bcb``b`abca`aca`a`ab``bcba``abababaa`aac``bbacacbababa`babaaab`abcba`baabca`aba`a`ac``bcbaa`abaabb`aaabc``bbacacbab`ba`cabaaba`abcbaabaacca`aba`a`aca`accba`abbabb`a`abd`abbababaab`a``babaab``abcbabbaacda`aba`a``ca`abcbaaabbabb`a`abdaabbacabaab`a`aaab`ab`aabbbabbaacda`aba`a``cc`abdbaa`bbabb```acdaabbacacaab`aabaab`ab`aacbbabbaabca`aba`a``bc`abccaa`bbabb```addabbbabbdaab`abcbaa`aa`aadbbabcaacca`abb`a``ac``bdc`a`ab`bb```addabbabbbcaab`abcbaa``a`abcba`bcaacda`abbaa``ac``bdc`a`ab`bb```bddabbababdaaaabcdcba``a`abdba`bcaabda`abbaa``a```bdc`a`ab`bb```addabbabbbcaa`abcdcba``a`abcba`bcaacda`abbaa``a```bdc`a`ab`bb```addabbabbbcaa`bccdcba``a`abcba`bcaacda`abcaa``a```bdc`a`ab`cb```bdcabbababdaa`bcbdcba``a`abdba`bcaabda`abcaa``a```bccaa`ab`cba``bdbacbabaccaa`ccbccba``a`abcba`acbabca`abcaa``a```bcca``abacba``bcbacbacacba`accbbccaa`a`bbcba`acbabca`abcaa``a```bbca``acacba``bcaacaacacba`acbbbccba`a`bbcba``cbabda`abdaa```bbaaacaabbaababbbc`aabaacbaacaq`baaaacabc`baababc`aab`acabac͍`aab`bc`abbaababaadb`ab`acbabcq`baaabbaaacaaabaadaabqacaabca``araaacaaad`b`aa`bcaaacqababac``aab`aabbaacb`baabbaabc`ab`bbaa`aab`b`cababab`ab`bbEsabb`b`bbbaa`ababDtaaab`baaaacaqbabaab`bbbaa`abaa`cb`aa`c`ab`cabbaabaaabacaa`ca`bb`ab`cbaac`abbabaaababbba`cb``cbaab`bac`bba`acababaaaabbaabba`cbabbabbbaca`aababbaaaaabbaabba`ccaacabbb`c`aaababbaabab`c`aaba`bdaabbbbaaca`bababcaabababaaabaacacabbaabb``bac`bdb`baaabaa`bbaacad`abbaca``bbaacbcCcb`bb``bbaacbc`caaabb`abaaacbbababaacabab`ccc`bababaaaca`acbbacaad`aaabacdb`c`bbbaaaca`ac`abbcbac`aa`c`ce`ac`bbca`bca`bbabbacaa`cb`a`cacd`abbaba`bc``cbcbbabaaaaba`acaccabaaac``cb``cbbab`baaaac``bcacbaababba`caa`bb`ab`c`aaaba`babbbaaabbbaaababcaa`b`ba`b`c``babaab`bbbaabababDaa`c`b`abcaaaabaab`bbbababaab`caaacaaa`b`bc`baba`cabbaaaaaaaaabbbacaaaabacaabbqadabbbaaaca`aacabacaaa`bacaab`adabacaabca`aacbad`baa``ad`aab``dbabca`cda`aac`bbcaab`a`aca`bb`adabacabbcb``bc`bbbaac```aca`bbaabbbbbFsbcba`bc`bacaaba`aac`babac`b`bbaaaababaaacaabbaaaaabbaaabab`bab`baaabaaabaaaabb`baaaab`ababaaabbaababGsbaabaabaababbbabaaacaaabaaabbbabEsacaaab`bacababaaabbbabaaadaabbab`bbbF7aabcaaabaabbbaaaaabbabbaaabaaaaaaabababaabFsa`bbab`bbaabaabbaErbab`cabac`bacaa`b`babbbbbEsbbaaaababaabaabaaaabaabaabaabababFsaabbbaabababababFababaaababbabacop3_4 8    ???K@   @   (   (  (  (  dcc͹cdcccc<ecddeUeccddfcacbvvwdcdufUuscseccͺuc4fbbeaeeccfct[acbbba4epcfeacduppbabaacccca4cdbppdacdb```deppa`pucwcebdasdbcpdacfbupp`f`pascfbecaeepbacfcbbaadacdabdccwct `eefbbeaadcfapppuYaccp`ebabcbfecdffbqqqqqpecuu `cccbafe8badffgeebpbeceUcppadubcc`cfbafcs4capapbgcfe4c pbdfdbdfeefccppccbpbgfeeffe pccsad4a$aca#apdeadubeccXfd pcdbcaeeacbddξesddecccedeeecdbcaeeddasafddceeufbda˪ctecccdcbcfbaccfccafeccccbccccfcba6cafcccadbececbecudcbacUcccaSeeccppeacabaccecccaaaca6ucdcecpfabaaebdvuba `abudcfpppbdppppppppp`v `ca4dccf#3bddpqqpr `eapcceesedeepgeebpfp`epp4sqedeefdapfcdpepeu `capdea5peccdcacpfbaddpepecppadξe#bpebdcpbcpfaaadpc#pcc pceeufbpbeccpbbdpeapbpe pcbbpbg̺bbbpcdcccpbeaaabppd pccccabpbgcb#cpbdccpbgbcccdcpd ccubebfbueaabcadbpccccccddccfgdceecabcabsabc#ctubaescabcccbaacacScccbabaaca$cdacaa#b```caefcca`pacccaacbbbcppcb`pp`abfddbcd`pdccccccadeppcb`pppdacpcebbaaadacefccddddddefea5bce`ppcfeaaadccbbdfbbdcascgbppdabbfbppddabbeacccc`acdgcpdbbafcfabbedbcdffcbacac#eepbac`cfbadffbbebdeddccdccadfdbdfeeedcdegcdffeab#deebatbac!bccccdccccdccacbbcbcbeccddaecdbaeccafacccbggdccdbgsSccagddff``aafdcdbfgdcfbggdaadacgcfbefdsafddecͬcfcbecaacabefabeddsafcuaebacbaaaecescccppbtbacbcccppedctvccccbbpp%cpfdcdecw5deppccfausbfcbcdffcppcbbbcaacacbbfcscfbabebcfebdcppedacccccaaabduceedaa#deebcfecdcccbbecdcccdccbcccddbbfdcccccbaecebcbccddaedebbadctcb̻3cdafaadggbcusdbgdebbafccb`ccd``aafdsdgfbdcfbggdccb`eeffacbbcSbcfbefdsceddfscbeccb`pppdccccafcbddafauaedcdefddtccaccdetcccabab4cdascaaaaaaaaaaaabbtcdstusbudtsctVbutcu`daccbcc bsb`dt3buacdbscccS8dVAbbc`dcrrarbdevcbcucbtbacddcbactb`tdtdbcdtcuccbscbbd`bbbddbbcrbtt`acuaa`c"rsbbbbrctbb`btabaaabbtaar`baAdtsr`tsccdbb`csbtcebcabsrbbrbbrds`bbbbadbab3bbbrcaadsrdabbtbbbraa2έebadcabdcbbccbbdtucascab`eabdast`ebubceabddcucattbttcsctars`racaab3cd5taaracbaa`cbbrbccq7ttdbctaabeccdtacbbbcersdtbsc`dbcstbcdcutbrarrrbsbtuabsbrabͬbaaatdabbrbdbbcbrrb`bcbbbbrabb`sbrabaaabbbscbsbbrs`bbrbbbcbrcrsbsbbbsbbbrabbscity2_2 3   ???K@   @   (   (  (  (  bbcbccbcccbcccbbccbcbcbbbbbbcbbccccbcccbbbbbbcbbcbbceeecccdedddccdbcccccccbbbbcbdcbdddddddcdddddccbbcccccccbcbccbcbbbbbbbbbbbdbbbb`bb`bcbbbbbbbbbbcbbb`bccdbbbbbbbbbbbbbbebbb`bb`bcbcbbbbbcbbbbcbbbbbbcbdbcbbbbbbbdbbbceb`cb`bcccbbbbbbbbbbbbbbbbbbbbbbcbbcbbbbb````cbb`bcbbbbbbbbbbbbbbbbccbccbbbccbbddccbcbbbb`bccccbbbbbbbbbcbbbbbbbcb`````bbb`````````````b````````bb```bbbccccbcccbbbbbbbbbbcccbcccbbbbbcbbcccbbbbbcbbbbbbbbbbbbbddddddcdcddcbbcccbcccdcdcededdcddddccdcddededddedcdbcccbdeddcd`bd`bbbbbbbcdbbbbbbbbcebbcbbcbcbcbbbbbbb`dbbbbbbbbbdbbbbbbbdbbbbbbcbbbbbbbbbcdbdbdbcddcbbbbbcecbccbbcccb``bdbbbbbbcbbbbbbbbbbbcdbddbcbddbdddbbcfdbddbbcdccbb`bdbbbcbbbbcbbbbbbbbcdcccbbbccbbbcedddbdbdddcccbbc`bcdddccbbcbbbbdcb````bb````bbbbcbbbb``````b``````bbb``bbbbbbccbbcbcbccccbbbbcbbbcccbcccccccccbbbbbbbbbcbbbbcbbbbbcccccceccedffeedeeddbbfeeeeeedfedddccbbcccccccddccbcbbdddddddddcdddccccbbccbcbbbccbbcebbbbcccccbbbbbbbbcddddcdcccbbdcbcdbbccbbbbbcccbcdcbcbbbbbbcbbbbbb`cdbbcbcbcbccbbcbb`bccbcdbbbbbbbbcdbbbcbb`bcbbbbbcbbdbcbbcbb``bbbccbdbbbcdbbcb`bbbbbbbbbccbbbc``bbbbbcbbbbbbbbbcccbcdbb``bbb`bc````````bbcb````````````bbbcbbccbbcccccbbccccccccbcbcbbbbbbcbbbbbbbbbcccccdccdddbcbbccdefdddbcccdcccdeddcdedcedeeddcccddedcdbdddcdddeefeedddcffffedebbbbbbcbbbbbbbbbcdbbbbbbbbbbdbbbbdedbcdbbbbbcbbbbbcbbbbbbbbbbcbbbcbcccbbbccbbbdddcbdbcbbbbccbbbbbcbbbccccbdbbbbbbcbbcbbbcdedcbbdbbbccbbbbcbbbccbcddcccbbbbbbbbbbbbcbbbbbcdedcbbcbbcbbbbbbbcbbbccdcbbdbbbbbbdcbbbbddddbbbcccbbc``````b`````````b`````````b````````````b```````ccccccccbbcbbcbbbbbbbbbbbbbbcccbccccbbbbbbbbbbbbbbbbbbbbccbddddddddddddecdbecccccbccdcdddbdddddddedddcbb`bbbbbbcbbbcdeddccedcdcdebbcbbbcbbd``bccbbbcbbcbbbbbbb`bb``bbb`cdccdcddbbbbbbcbbc``bbbcbbcbccbbbbb`bbbbbbcdbb`ccbcdcddbbccdbcbbcbbccbbcbcdbb`b`bbb`dbbbbbbbdccccdbbdbbbcdcbbccbbcbc`cbbbbbcdbbbb``bbbb`dcbbbcbbcbcccdddddeddddcdbbdcbc`bbbbccbcdcccb```bb``bcbbcbbbbbbbca``bb````bbbb```cbb```````b```````cccbbccbbbbcbbbbbbbbbbccccccccccbccbbbbbcbbbbcbcbbbbbbbbbbbccccdeeedcbecddcccbdcccbcccedddddddddcddcbccccddddcedcdbcbbccdccddbbbc`bbb`bccccbccbbbbcccbbcbb````b``````bbbbbcbbbbbb`dbbbbbbbbbbbcbbbb``cb``bbb``bd`bbcbbcbdb`cebbbbbbbbbcbbbbbbccccbccdbcbbccb`db```bcccbbbdb`cdbbbbbbbbbbbbbbbbbbbdcdbbceddddccbbbcbceb```ccdcbbbb`bdbcbbcbccbcbbcbbbccbbbccfddbd````bbbbb``b````b`b```````````cbbbbccbbcccbbbbbbbbbbbbcbbbbbbcbbccbbccbcbbbbcbcbcbecddefddfdfgfdcdcccccccccbbbdcccdccccdeedcbbccccceccccddeecbcbccb`bdbbbbbbbb`bdbbbbbbbb`cdbbbccccbbbbdbbcbbbbbcb`bbbbbbbb``bdbbbccdbbbccccbbbbbbbbbebcbbbebbcbbbcbcfbbcbbbbbbbbbbbbbbb`cbbbbb`bebbbbcdcccbbdfbbdcdddbcbbbbbcbbccccbb`bbbbbcdcbcbccbcbbbcbbbbbbbc`bb````b`````````qc``bb`bcb```bb``cbbdccdccccdcbcccccccbbbbbbccbcccccccccccbbccccccccbcbcdbccccddddfdcddddddffeeeeccccccdbdddceedeffcceeeddececeddedbcddddecbbbbbcdbbbbbbb``bbccbbbbbbdbbccccbbcbbbbbbcccbbcfcccbbbbbccbbdbdbbbb``bbbcbbbccbbdccccbccccbccbbcfccbbcccccdbccb``bbbcbbbbbcccbdfcbccbbccccccbbdbbbb`bcccbcfbcc``bbb`cbbbbbbbccbcfdbccbbccccbbccbbbbbcebbb``a`b`b``bbcbbbbbbbbbccbcbbd````a`aabbaa```a`````````````````````````````````b`````bdccdcbdbccbbbcbdcccdcacbbbbcbbabbbdbaabcabab`cbbbbcbabcabbaabacbbbbaabbbbbbaabbbb``aabbaaarbaababcdccccbbbcccdccccbdccctcbcaccacabbacbbaadacbacabbbdcbcdcbdccbdbb`cabbbbbb͍arcbaabbccbbbaab`abbcabbsbdbdddccccddcddcbccbbbcbcbdccccccscbbbcbdbacbbbbraaadcccbbcbbaacbcbbbbabbabbabbccb`aabbrabbcaa```bdcdbcccdccdccdcbcdbcccddddeddabrbbbabbacbbbbbacrbceacbbacacbbbccbcbabbbbbbcdbcbaaab``ababaa`abaabbabaabccdcccdscbcbcbdbcdccccbarbbbccdccddbbbcc`cbccbbb`rabacacbcdbcbcbrcabbcba`babbbcbcccbcbbbba`abbr`cc`a``babaacctcccbcbcbccdcdcccbccccccacbccaacbbcbbbbbacbba`b``a`c`bcbcadbbbbabbbbccbdcccabc`bc`bb`bbbaabaraaccaccddctcaccbbcbbccbccbbcbcbcdccbabbababbbcaaabcbbcbabrarab`cabacabccbebccsbbabbbb`aa`arcabbbc`abacddcdcdecdbbcbccddecdccddcbdccbabbccba`acbbbcccbcrbbacbeca`bccdca`bbbabrcbeccabccbcbaaacaa``a`a`aaar`abbaabcbbcaabcbcbbacabb`abbaaaabbcabbcbbcbbbbaacbbbdbcb`bbbccbccccbabbccbc`abbababaabcaccbcbbbdcccab`bbbaabrcabacdcbbbbcbbabbbccbbabbbaababbbbbbbcbcbbcbbbababbbbabbbcbcbcbbbabbbbcbcaba`basbcbabcccbbbccccbcdbbbb`aaraacbbbabbbbbbacbbbbbbbbbbabbbbbbacbccrbbabbbbbbbacrbbabcabcbbbcbsfloor4_6   ???K@   @   (   (  (  (  ``a````a``````a`````a`````````````a```a``aaacccbaca`caccaaaaccaaa``ccacacaaact`acaacaaca`aaaaaaccaaaaaaa``aaacaaaaaabcaaaacaaaaaat`aaaaaaaaaaaa```aaaa`aaaaaa`aaaaaaacaaaca`caaacaacaaca`aaaaaccaaͬcaaaccacaaaccaaaaccaaaaca`aa`aaacaac`c`accaaccaaa`aaaaaa``accacaaacaaacaa`aaacaa`acaa`aa`aaaaaaaaaaaaa`a`aaaaaaaaa`caa`caacaaa`ccaaaaccaaca``acca`a`acaaccaca`caacacaaacca`aa```aca``acaaaaaaaa`acca``ac`caaaaaac`aacaaacaaaaaca`aaacaa`acaaaaaccaaac`aaaaaaaaaaaaa`aaaaaaaaaaaaaccaaaacaaaacaaa`caaaaaaccaaacaa`aaaabaaacaaaaa`caaaccaaaacbaaa`acaaaacaacaacaaca`aaacaccacaca`aaabaaaaacaaaaacaaaaaa``aaaccaaaaacaaacaaaaaat`aaaaaaaaaaaaa``aaaaaaaaaa`caaaacaaacaaaacbc``aaacaaa``caaaaabcaaccaaaca`caaaacccaacaacca`acaacaaaccaaaaca`ccaaacaccaa`aaa``aacaa`aaccaa``aa`c`aca`accaa`aacca`aaaaaaaaacaaaaaa`aaa`aaaaaaaa`caaacaaaccaaaaccca```aaaacaaccaaaa``caaaca`aaa``acaa`aaaaaaaca``acca``caacaaccaaaccaaaca`aaaaaaccaaaccaac`acaaaaacaaaaaa```aaacaaa`acccaaa`aaccaaac`aacaaaaaaca`aaͬ````aa```````a```a````aa````````````````````a````a`ca```a```a```````aaaaacaabac``acaaaa`aa`aaaa`aaaaa```aaacaaaaaaaa``aaaacaaacca`acca``aaccaa`aca`caaa`baaaaaaacca``aacacaccaa`aaaca``aaaaccaacaccaaaccaacaacaaaaaaccaaaaaaaaaaaaaaccaaaaacaaaaaccaaaaaaaaaaaaa`aaaaaaaaaaaaaa`aaaaaaaaaccaaacaaͬaaacaacaaaca`caaaccaacaaca`a`caaaaacaaaaacc`aaaccaaacaaacaacaaccaaaacaacaaaa`accaaaaaccaaaaaaaaaaaa`aaacaaaaaaaacbaaaaaat`aaabaaaa`aaa``aaaaa`aaaa`aaaaaa`caaaccaacaaaaa`aaaacaaaccaa``caaaaccaaaccaaaccaa``caaccaacaacaa`aaccaa`aaaca`cca`acaaaaaaac``aa`aaccaaaccaa`aac``a`aacaaaaacaaacaaaa``aaaaaaaaaaaaaaaa`aaaaaaaaaa`caaaacccaaaaca``cca`caaacaaaa`caa`aaaacaaca`aca`caaaccaaca`aaca`acaacaaaccaaaaa````aaacca`accaaac`a`accaa``aacaa`aaccaaaaaa`aaaaaaaa`acaaaaaaaaaaaaaaaaaaaaaaaaaacaaaaaaaaaaccaacaaaaaaacbaaaccaaaacaaaaaccaacaaaaaaaaaab`aaccaaaaaccaaccaacaaac``caccaaaaccaact`acaaaaaaccaaaaaaaaaa```aaacaaaaacaaaa`baaaaat``aa`aaaaaaaaa`aaaa``aaaaaaaaaaaaaa``caccaaaacccaaccaacaaaaccaaaccaaacca``aa``aaaaaaa``aaa``aaaa`aattt``a```````````````````a```a`a```bsbsb`bbabaabababaaar``abaaaabbaba͛bbrbababbcb`a`bbab`aabb`baababb`aaaaba`a`bs`babaababbaabraaaab͜`babaraaababbbaabaabbabrbbaabaabababaa``abbbrb`abaababab``baabaabaabbabrbbabbaa`aabaaaab`ababaaababababc`aababb`sbraasbbabsaab`aba`ca`cba```a`ra`ra``b``ra``abasabaabaaababbasbbrbbasba`ba`bb`bababcbab`baabaabbr`basaasarabbbasabaabbarbrbbaabaaabaraaaabaaaaaacababbasaaababacababbbabbb`aarba`ababbab`bbb`aaab`babbaaraabbaaaba`aaabaaaaaabaaabbbbbrabbbabaabbbabbababbababab`babaabbaaababab`baa``asa```r`baaabbaraaaaabbaaabaaaaaabaaaaarabaaaaarb`aaababaaraaaaaabba`araraa`bararabaaabbaaarabaaababaaaabababaaaaraaaaabaaaarababaabaraabaaabaaaaaarabaaaaaaaraaaaaaaaaaaaaaacity3_2 3   ???K@   @   (   (  (  (  bbbbbbcbbccbcbabbbabbbbbbbbcba`aabaaaaabababbbbbbaabbbbbcccbbbbbccbcbacbccbbccbccbbcbabbbbbbaabbabbcbbbbbbbbcbbbbbaabbabbccbbccbbbabbap`cbabcbabca`cbbabbaabaa`b`aab``baba`bbbbbaa``acbb`bbbccabbaacba`p`cacc`a`bapcp`bbcbb`b`ap`````ababaababcbba``a`acacb`c`bbbbabaa`pp`bc`bbpaabca`b`bbabp`aaapb`aaabbbcaacabba`acabbbbaaccbbbabbacaa`paababcbacaabccbbbaa`a`a`bbaabbbabbaabacaaababbccpabbbbcbbbabbaaa`cabcbabbaabbcbbb`ppa```aababbaabbbccbbababccaac`bbbacbabaababaabaabbbabcabbab`aa` pabaabaaba`cacabbbbbbbba`pc`bacbbbccabbabbcaacbaababababbbbbaa``aaabaaaaa`bccbcbaaaabacba`b`abc`abcbbbaabcbabcaabbaabcabbbccbaaacabbabababbccccbabcbbcdbbababbcbbccabbbbcccccccabbbbbbabbccbbaaaabb`aacbbcccccdcccbbaabcddabbcbcbcccbcbbaccbcdcbbcbbbbbbbcbbbbbaabcbbabbbbcddcccacccbbccacccbcbbbcccccbcbbcbcccccbbccbbccccccbbbabcbbacbcbbbbdccbbbbcbcb`ababcbcccccccbb`cbcccbccaacaabbbbc`pcbbabcbbacbaabbcbcb`bbbbbbb``cbbbbbcccbbbbbbcabbcbbbabcabbbbc`padbbbbbbbbbabbcccbbbaabaabbbb`abbabaccbcbbcbcaacbbbbbaccbbabcb`bdaabbabbbbbacacbccbaa``bb`a`cbabcaaabbbbpaa`bacbbaaabccbbaabbcbcabbbcaaaabbabpcc`acb`pabbbaabcbabbbabbbbbbbbcbcbaaabbccbbbbabbbbaaaacabbbbbacbaabcba`abbbbbcbcbabbabcbbabcbcccb``acbcdcbbba`acababbbccbaabbabcccbbaabbbcbcccccbbccbccccbbbabccbp`bcbbbcbbaabcabbaaaacbbbc`abccbcbaabcbbcbccbcabccbbacbcbdaacbapbbb`bcccbbacbbaaba`bcbabbcbap`bbbbbbbbbacbcacc``ccbbcbcbacaabb``bbabbababaabbcabb`p`abaabac`ppcbbc`abaabbbccbb`dbbbccabbbabbbaabbbbabbbbbabbbbabba`bcabaccba`abbbaabaaabbbcbpcdbbbababbaabbbaababbbacbbabbbbaabb`aaacbbbbbcbabb`abaaaacbacb` bbbbbabbbababbbbbbbbbbabbba`abbb` paaabbbacaababaca`caaaaa`aba`abbbabbbcabbabbbcaaccca`babbabaab`a`bc`ba`acbaaaabcdaca``a`aa``aabbbbabbcbbaabcbcabcbaabbbabbbaabccbacabaabcbbbbabacdba``b`aa``bbcabbabcbbbbbbcccbabbcbbbca`cba`bbabaaaaabacacabbabcbcb``bba`acbbbaaccbbbabcbcccbbbbbbbbcb``cbbacbabba`bbbbcacabbabcccbp`cba`bccccaacbcbabcbbabbbcccbbaabc`abaabb`bcbbabaacbccaabbaccbbppbbaaacbbccaaacacbb`bccbbccbbbbcbbaabbbbaabbbbbaa`bbcba`abaaba`bpabbaababbbaaabbbba`bbbbbcbaaabbacabbaaaaabaaaabpaabcabababaabbb`baabbacbbbbbaba pbabccab`ccb`acacbbcabbbcbaaaabaabbbacbbcba``aacbbbbbabbbbc`bb pcbpbbcbccbaaabcaccaaabbaca`abbbbcbbabb`abbp`p`bbbbbbabcbaccba``cbb`abbbccbb`aaccdbcbcdbbb``abacacbbbbpabcabbpp`ababaabbbacbbcaacbbaa``bcbbaabcac`cbbcpaa``cbbba`caa`b``ccbabapa````ba`cacbcbaa`baa`aaacbcbabacbbpdbc`ppaaabbaa`abbcbabacbccbb`caaaccbbbbc`ccaa`aa`aacbbcbcaabcba`acbc`p`ccaca`babbb`aabbbbb`babaabbaaccbcacbaabba`bbbbcccaa`bababdacbc``dbcbaa`abb`aa``bbcbab`aabbbabcabccbaaabbpabbcbcccababbbaabcabacdbacbaacbbbbaabcabbbabbaaabcabbbbbcbaaabaabbc`bbccbbaabbaabbacaaaaa`abbcbba`bcbc`bbbaaa`pccbbcaaabbbbbbaaaabcbbbbbaabbbaaaabbbaabca`abcbbbbabbabcccbbbaabbbaacbaacbb`baabbbbbbccbcbbbbcbcbbbbccbcdca`cccbpbbacbbcbbcbcabbdcbabbcb`cabcbabbcbbcccdcbaabccbbcbcbbacdbccdcbcbacccbcb``bccbcdcbaabcbca`cabababcbbcccbcbabcabcbcbabbb`ccccaacabbcabbc`ppaccbcbbaaabbbcba`cbaabbbabcbbbbababacbcbabaabcccbbbbaaabcabbb``ababbabb``abbbcbababbb`bc`bbaaaabbabbbbababaabccabbbaaa`bcbbacbbcbbbbbbb`aababbbbbbababbbbaccacabbccbbabaa``accaaaabbbbbcbbaacbdbabbbbcbbabaabccbab`abbabababcba`abbbabba`b``bcba`aaaacbaaaabbccaaabbaacbbaaaccbaaa`bbbcaa`cbbc`aabbaabbaabap`ccabbbabcccbbbabcbabpaa``aaacaaabaaabaccbbbabbccbbbbbbcbccbaaappcbbccbbbbabbbcccccbacbcppb`acb`a``abaaacbccbccccbbbbbbbbcbbbbbacccabcbcbbccbaccccbbbcabppc`cca```aab``accbccbbbbbabcbbbbbaabbbcbb`abcaaabbccbcccbbababap`cccaaa```aa``acbacbcbbabbbcbbcbbaaaaabca``bbcbacbcacbcccbcaa``ccbbcaaa`aaba`aaabbcbababaabbbaacbaaaaaaca``aabbaa`pacccbbaba`aabbbcbbbaabb`ab`babbbbacaaaabbb`abcabaaabbba``a`baba`pacbdbaba`cacbb`b`bbbcaab`aababccbbb`aaaba```a`aa`aaabpaaaaaaaa`pacbcbaba``abacba`cbbc``b``abaacbccbaababaa`babbbbbabbaaabbbabbp`cbccbaabaabcacbbbbabapp`ba`bbcbbbbbabbabaabbbbccbacbabbabbbaabdcbcbbaaabbaaaaabbaaaaa`p`abbbccbacbbbaabbbabbbbabbbcbbbbbabbbbabcbcbbababba`aaaaabaaaaaaaabbbababcbbabbbbbbcbb``abbcabbbbbbbbcbbacbccbacaap`aaababa````aababcccbbbcb`abbaaccabaaa`bbabbcbcbbbbb`bbccaabc`p`cbbcba`a```bacbbcabaccaba`baa`bcbaaacabbababbbbbbcb`bbaababaa``bbabbbab`aaaaaaabaaacbcabaabbbbacb`acaaabb`baabcabbcbccbcacabab``bab`cbbbbaabcbbbbbbbcbbcaccbcbbbbbbbabababbbbbbabbbcbbbbabbbabaaacaa``a`baabbb`abbacabba`Cbaac`bbb```bababbababbbEbbbabaabbbabbbEaabaacbbbabababcbabcabababbbbaabaabaccabbcababbbbcbcccacabbcbaacbbcccccbbbcbcbcccaccbcbcacbbbacbbbbbcbbbbabbbccbbcabcabbbcaabbbbbaccbaaabaacabbaabcaabcbabbbbbabbbaac`ababcabbbbbcb`bbcbabbabbcaacbcabbccbbcbccbabDsacbabcaa`babbAbcabrbcbacbcbababbacabbbaaacacbbaaabbb`cbababbbbbabbaabbaacaaacba`aaaabbbbbacbbbbc`c`bbbaacbabbcaaa`bbbbbbbbcbcabcbbbbabacbabcb`aabcbbacbacbcabbbabbEba`bbabaab`babbbabCbcacabbbacbaabbbabbaCabbbbbcaaaabbbabcbcaaabbbabcaaaaabbbbabaacbbac`bcpabbaababbcababacbbbaaacbcaabacbbbcaabbaabbaabbbbbbabEsbbcaababbab`bbbacacbaaabcabbaabbbccbacbcbbdbcbbbbcabcbcbacabbbbbcbcabbbbbaccabacacCbbbaabcabababbabcbaaabcaabacabcbbbbbacbaabbacabababcaabcabacaaaababbaabcabcbbbcbbb`cacbbcbccaba`ac``aabcbcabbbcaabbabbabcbccaaabca`aa`bbbbaababbaabaaaaaccaaabbbbabaaabcbabaaaaaab`ababbcbaabbabbaaabbcabbabbbbcabbabcbbbab`abaaa`abcacababca`bbbbbbcabcabbaba``bbbbcaababbabababbbbcabbaDsabbaabbacbbabbbac`aabbabbbbFrabba`aabbabacacbabcaabbcbbbbcbbcacbabbbcFsabcabbbbabbbbabbcacaabbbaabbFsacabbbbbabaabacaaacacbbabababbaabbbFsbbbbabaabaabbaabbbabGbabbabcaabbbbbbbbbbGbbabbbbbacabbababbGsbbababbbbc`abaacabbabaaacbabaaacabbabaacaabaaababbabacacaaabacabaababbbbbGcabbbbabacacababababbbabababbbGsbbbababbbaabbabbF6btf1                   (   (@  (P  (T  444!4444444444444444    ή444!4444444444444444    4AAAAAAAAAAAAAAAAAAAAAA44AAAA444444AAAAAAAAAAAAAAAAAA4AAAAAAAAAAAAAAAAAA44AAAAAAAAAAAAAAAAAAA44444444444444444444444AA444444AA4	

		

		

	  ! !!  ! !  !! ! !  ! !!!  ! !! !! !  !!!  ! !! !!!!! ! !!! !    !! !!! !!!! !! !  !!!  !!! !!! !!  !!! !!!! !! !!  !! !! !! ! !$##"#"##"""##"##"##"""#""#"##"##"#"""##"##""##"##"#"#""#"#""""!!"#""#"#""#"#"##""##"##"#"##""##"#"##"#""##"##"##""##"#"#""""#" "$%$###$$%$%%%%%%%%$%%%$$%%$%%$$%%$%$%%$$%$%$%%%%%%%%%%%%%%$$%$###$%%$$$%$%%$%%%%%%%%$$%$%%$$%%$%$%$$%%$%$%%%%%%%%$%$$####$$%%#!!#%%$$###$$$$%$%$%%%$%%%%%%%%%%%%%%%%%%%%%%%%$%$%%$%%%$$$##$$#""""##$$#$$$$$$$$$%$%$%%%%%%%%%%%%%%%%%%%%$%$$%%$%$$$$####$$%%%$#!!#$%%%$$####$$$$$$$$%%$%%$$%%$%$%$$%%%$%$%%%$%$$$$$$#####$####$$$$$$$%$$%$%%$$%$%%$%%$%%%$%$$%$$$$$####$$$%%$%$#"!!##$%%%%$$#####$#$$$$$$$$$$$$%$$$%$$$%%$$$%$$$$$########$$$$$$$$$$$%$$$$%$$%%$$$$$$$$#$###$$$$%%%%%$$#"!!"#$$%$%%%$$$######$##$$$$$$$$$$$$$$$$$$$$$$$$####$$$$$$$$$$$$$$$$$$$$$$$$#$$$$$$$$$%%$%$%$$##"!!"##$$%%%$%%$$$$#$#######$##$$#$$$$$$$$$$$$######$$$%$$$$$$$$$$$$$$$$$$$$$$%$%$%%%%%%$$##""!!""##$$%%%%$%%%$$$$$$$$$$$$$$$$$$$$$$$$$$$##"""!""!!""#	$%$$%$$%$$%%$$$%$%$$%%$%%%$%%%%%%%$%$###"!!!"""#$$%$%%%%%$%$%$%$$%$$$$$$$$$$%$$$$$$##$$###$###""##"""#"######			$$%%%%$%%%$%%%$%%%%%%%$%%%%%%%%$%$$$$#"""!"!"###$$%$%%%%%$%$%%%%%%$$%$%$%%%$%$%%$$	$$$$$$$$####""#"#"#"###$$$$##$				$$%%%%%%%%%%%%%%%%%%%%%%%%%%$%$$#$##""!""!""##$$$$%$%%%%%%%%%%%$%%%%%%$%%%%%%$		$$%%%$$#$#$##"""##""""###$#$$$$$#$				$%%%%%%%%%%%%%%%%%%%%%%%$$%$$$$##"""!""!"""##$$$$$$%$%%%%%%%%%%%%%%%%%%%%$$			$$$$%$$$$$####""!""##"""#"##$$$$$$$###			$$%%%%%%%%%%%%%%%$%%$%$%$$$#$####"!""""""##$##$$$%$%$%%%%%%%%%%%%%%%%%%$					$$#$%$$$$$####"!""#""!""##$##$$$$###$%$%%%%%%%%%$%%%$%$$$$$$$$#$#"""!""""!""###$$$$$$$$%$$%$%%%%%%%%%%%%$$$$$##$$#$#####""!"###""""####$$#$##$$##$%$%$$%$%%$%$%$$$$$$$$##$###""""""""""#"###$#$$$$$$$%$%$$$%%$%%%%%$##$%%$$##$$#$##"#"!!"#$#"!"""#####$##$$$$$###%$$%$%$$%$$$$$$$$$$$$####"#""!""""!""###$#$$$$$$$$$$$$$%$$%%$%$##$$%%$%$########""!""###"!""#"##$#"#$$$$$$$##$$$$$$$$$$$$$$#$$#$####""""!!"""""!"#######$#$$$$$$$%$$%%$$%$##$$%$$%$$$#"######"!!!"#$##"!""""###"#$$$$$$$$$##$$$$$$$$$$$$$$$#$###"##""!!"#""#"!"""###$#$$$$$$$$$$$$$$$%$##$$$$$$$$$$#"###"""!!""###""!"""#"""#$#$$$$$$$$##$$$$$$$$$$$$#$##$###"""""!""""""!""#######$#$$$$$$$$$$%$$###$$$$$$$$$$$#"####""!!"##$#"!"!""""#""#$$$$$#$$$$###$#$#$$$#$#$$######"#"""!!"#""#""!"""#######$#$$#$$$$$$$##$$$$$$$$$$$$$""#"#""!!!""#$#""!!!""#"""###$#$$$$$$$$##$#$$#$$#$########"""""!""#""#"!!""#"#####$#$$#$$$$$$$##$$$$$$$$$$$$#""###"!"!!"#$$#""!!"""""!""####$#$$#$$$##$##$####$#####""""""!!!"#""#"!!!""##########$$##$#$##$$$$$$$$$$#""###"""!!!"##$#!""!!"""""!""######$#$##"#$#########"#"""""""!"#"""#""!"""#"###########$#$###$$$$$$$$##""##"""!"!!#$%#!"!!"""""!"""#$####$#""############"#"""!"!!""#""$#"!!""""#"#####$##$#$###$#$$$$$#""##"#""!!!!#$$#!"!!!"""""!""#######""#######"#"""""""""!!"##""##"!!""#"#############"#$#$$#$#""###"""!"!!#$%#!!!"!"""""!"#######""########"#""""""!!!"#"""$#"!!!"""#"#########$#""##$$###""###"""""!! #%$#!"!!"""""""!"#######""##"##"#""""""""!!!""#""$#""!!!"""##"########""#$##$#"""###"#"""!! #%%#!!!!"""""""!!"######"""##"#"#""""""""!!!"##"$##"!!"!"""##########""######"""###""#""!!! "$%$$" !!"!"""""""!""######""#"##""""""""""!!!"##""$#"""!!""""#"#######""#####""######"""""! #$%$$# !!""""""""""!"#####""#""#""""""""!!!!""##"$##"!!!!""#"#"#"###""#####""#####""""""! "$$%%$$" !!""""""""""!"#"###"!""""""""""!"!!!"###"$$#"!!!""""""######""#####""####""#"""""! "$%%%$$" !"!"!""""""""!"###"""!"""""""""""!!!"##$#"$##""!!!""""""#""##""#####""#####"#"""""! !#$%%%%$#" !!"""""""""""!!"#"#"!!"""""""""!"!!!!"#$#"$$#""!!!!!"""#"##"""####""###"#""""""!"! "#$$%%%$#" !!!!""""""""""!!"#""!!"""""""""!!!!!"##""#$#"!"!!"""""""#""!"#####"""##"""""""""! "$$%%%$$#" !!"""""""""""!!"""""!!"""""""""!!!!""#$#$$#""!!!!"!""""""!"#"#"""###"#""""""""! #$$%%$$# !!!"""""""""""!!""""!!""""""!!!!!"""#$##$##""!!!!"""""""!""#"##""#"""""""""""!! "#$%%$#" !!"!"!""""""""!!"""""!!"""""""!!!!!"##$#$$##""!"!!"""""""!"#"#"#"!"#""""""""!"!"! #$$# !!!!!""""""""""!!"""""!!""""!"!!!!!""#$$#$$$#""!!!!!!"""""!!""##"!""""""""""""!!!!  !!!!!!!"""""""""!!""""!!"""""!!!!!"""##$##$###""!!!!"!"""!!""#""!!"""""""""""!"!!!!!		!!!!!!!"!"""""""""!!"""""!!""!!!!!!!!"##$$##$$#""!"!!!!""!"!!""""#!!"""""""""""!!!!!!!		!!!!!!!!!"!"""""""!!"""""!!"""!!!!!!"""#$###$###""!!!!"!!""!!"""""!!""""""""!"!!   !!"!		!"!!   !!!!""""""""!!"""""!!!"!!!!!!!!"##$$###$###"!!!!!!"!"!!"""""!!""""""!""!!  !""!		""""  !!!!!""""""!!"""""!!"!!!!!!!"""#$$##%#$$$#"""!!!!!!""!!"""""!!""""""""!  !"!"#"		"#""!!  !!!""!"""!!"""""!!!"!!!!!"!""#$$$##$$$##"!"!!!!"!!!"""""!!"""""!"!  !"""#"		"##""!  !!!!"!"!!!"""""! !!!!!!!""###$$###$##"""!!!!!!!!!""""""!!"!""""!  !!"""###		###"""!!  !!"!"!"!!""""""! !!!!!!""""#$$$##$$$##"""!!!!!! !""""""!!""!"!!  !""#"###		#$##"!"!  !!!!!! !""""!"  !!!!!"!""##$$####$$###""!"!!!! !"""""""!!!"!!  !!"""#$#		#$$#"""!  !!!  !!"!"""!  !!!!!!""""#$$#"#$$#$##""!!!!!! !"""""""!    !!"""##$$#		#$$###"!!!    !"!"!!!!  !!!!!""#"###$$#%#$$$##""""!!!!! !!""""""! !""""#$$$#		#$#$#""""!  !!!!!"!  !!!!!!"""##$$$#%##$$$##"""!!"!! !"!""""""! !"!"###$##		#$$###""!!! !!!!!!!!  !!!!""""##$$$##%#$$$###""!"!!!!  !""""!""!!!"""##$$#		#$$#"##""! !!!!!!!!  !!!!"!"###$$$$###$$##"#""!!!!!  !!"!"""""!!"""##$$#			#$###"""! !!!!!!!!!  !!"!""""###$$###$#$$##""""!"!!  !!!!!""!"!!!"###$#			#$$##"!! !!!!!!!!!  !!!"""""##$$$$#T##$$$##"#"""!!!  !!!"!!!"!! !""##		##""" !!!!!!!!!!  !!!""""###$$$#"%##$$$$##"""!!!!  !!!!!!!!!"!  !!!!!!!!!!!  !!"!""""##$$$###$$$$####""""!!  !!!!!"!!!!! $%%$ !!!!!!!!!!!  !!"""#"##$$$$#"##$$$$##"""""!!!  !!!!!!!!!!!! $%&&%$ !!!!!!!!!!!!  !!"!""""##$$$#$#%#$#$$$##""""!"!!  !!!!!!!!!!!!!  #%%&&%%#  !!!!!!!!!!!!!  !!!"""####$$$$####$$$##"##""""!!  !!!!!!!!!!!!!!!  #%&&&%&#  !!!!!!!!!!!!!!!  !""""""##$$$$$#" ###$$$###""""!!!  !!!!!!!!!!!!!!!!! #%%&&&%# !!!!!!!!!!!!!!!!!  !!"""""##$$$$###A ##$$$$$##""""""!  !!!!!!!!!!!!!!!!!! #%&&&&%# !!!!!!!!!!!!!!!!!!  """"""####$$$$#""#$#$$####"""!"!!  !!!!!!!!!!!!!!!!!! $&&&%$ !!!!!!!!!!!!!!!!!!  !"""""#"##$$$$##" ###$$$$##"#"""""!  !!!!!!!!!!!!!!!!!! !"""$%%$"""! !!!!!!!!!!!!!!!!!! !"!"""""###$$$$$#"4 #$#$$$$###"#"""!"  !!!!!!!!!!!!!!!!!!! !"#"#"##"####!!"!"!!!!!!!!!!!!!!!! !!"""""###$#$$$##"4###$$$####"""""""  !!!!!!!!!!!!!!!!!!!!"####$##$#$###!!!"!!!!!!!!!!!!!!!! !"""""""###$$$$#""4!"##$$$$#####""""""  !!!!!!!!!!!!!!!!!""!!#"##$$$#				#$$$####!!""""!!"!!!!!!!!!!!! !"""""""###$$$$###"4####$$#$###"""""""! !!!!!!!!!!!!!!!!"!"!"####$$#				#$$$$##"!""""!"!!!!!!"!!!!!! !""""""#####$$$$#"""##$$$$####"#""""""! !!!!!!!!!!!!!"!"""""!""#$#$$#			#$$$$#""!""""""""""!"!!!!!!"! !""""""""####$$$##"" "##$$$$$####"""""""! !!!!!!!!!!!!!!!"!""""!!#$$$$$			$%$$$"!!"""""""""!""!!!"!!"!"!!"""""""####$$$$$##"4"###$$$$###""""""""! !!!!!!!!!!!!""""""""""!""""##$$%$				$$$$$#""""!""""""""""""""""!!""!"!!"""""#"###$$$$$$##"""##$$$######"""""""! !!!!!!!"!"!""""""""""#"####$$$$$			$%$$$$####"#"""""""""""""!"""!""!!"""""""#####$$$$#$#"4"##$#$$$####"#"""""""! !!"!!!!!""""""""""""#"####$$$$$%$			$%$$$$$###"#"""""""""""""""""""""!!"""""""""###$$$$$###" ""##$$$$#####""""""""! !!!"!""!""""""""""""####$#$$$%%$			$%%$$$#$#####"""""""""""""""""""!!""""""""#####$$$$$#""""##$$$#$#####"#""""""!!"!"!"""""""""""""""#####$$$$$$%$			$%%$$$$$####""#"""""""""""""""""!!""""""""#"###$$$$$###"4 "###$$$$$#####""""""""!!""""""""""""""""""#####$$$$%$%$			$%$%$$$##$####""#""""""""""""""!!""""""""#####$$$$$##"""##$#$$$#####"#""""""""!!""""""""""""""""#"###$#$$$$%%$		$%$$$$$$####"#""""""""""""""""!!""""""""#"###$#$$$#$#""4 ""###$$$$#$#####""""""""!!""""""""""""""""###$#$$$$$%%%$		$%%%$$$$#$####"##"""""""""""""!!""""""""######$$$$$$###"4"###$$$$$######"""""""""!!""""""""""""#"#####$$$$$%%%%$	$%%$%$$$$#######""#""""""""""!!"""""""""######$$$$####"4 "####$$$#$######"#"""""""!!"""""""""""""#"#####$$$$$%%%$		$%%%$$$$$$#####"#""""""""""""!!"""""""""######$$$$$$##""4 ""##$$$$$$######""""""""""!!""""""""""""####$#$$$$$%$%%$		$%%%%$$$$#$######"""""""""""!!"""""""#"#"####$$$$$$###""4 "##$#$$$$#$######""""""""""!!!"""""""#"######$$$$$%%%%%$	$%%%$$$$$$########""""""""!!!"""""""""""######$$$$$$#"#" ""###$$$$$#####"#"#"""""""""!!""""""""#"###$$$$$$$%%%%$		$%%$%$$$#$#######""#"""""!!""""""""""#######$$$$$$$##"" ""##$$$$$$########"#"""""""""!!""""""#####$$#$$$$$%%%%$	$%%%$%$$$$$########""#""!!""""""""#"#"#######$$$$$##""""####$$$$$$########"""""""""""!!""#"#"#####$$$$$$%$%%%$$%%%$$$$$$#######"##"""!!""""""""""#"######$$#$$$$#$#"" ""##$#$$$$#$######""#""""""""""!!!"""#####$#$$$$$$%%%%%$$%%%$%$$$$$$########"#!!!"""""""""""#########$$$$$####""4"####$$$$$$#########""""""""""""!!"####$#$$$$$%$%%%%%%$$%%%%%%$$$$#$#######""!"""""""""""#"######$#$$$$$$##"#"4 ""###$$$$$$########"#""""""""""""!"####$#$$$$$%%%%%%%$$%%%%%$$$$$$#$#####"!"""""""""#""##########$$$$$#$#"""4 "#####$$$$#$#########"#"#"""""""""!!"""#$$$$$$$%$%%%%%$$%%%%$%$$$$$####"""!!"""""""""""##"######$#$$$$$$$###""4 "#"##$$$$$$$#$#####"##""""""""""""""!"#$#$$$%%%%%%%%$$%%%%%%$%$$#$#"""""""""""#"""############$$$$$$####""A""####$$$$$$#########"#"#""""""""""#"!"###$$$%%%%%%%$$%%%%%$$$$$##"""##"#""#"""#"#"##########$$$$$$$###""" ""####$$$$$#$###########"""#""#"""#"###""##$$$$%%%%$$%%%%$#$###""###"#"#""#"#############$##$$$$$$$##"""4"#"#$#$$$$$$$##########"#"#"#"""#""##"#"#"$$$$$$$$$$$$"###########"##"#############$$$$$$$##"#"""""####$$$$$#$##############"#"""##"######""""""#########"##################$$$$$$$#$##"""""####$$$$$$$###########"#"##""##"#############							""###############"##############$#$$$$$#$###""""""####$$$$$$$#####################"########$#$####							###"#################################$$$$$$$$##"#""""#"##$$$$$$$##$############"##"#############$$$$$$#$$$$$#$##$$$##$############################$##$$$$$$$####"""""####$$$$$$$$############"######"########$#$$#$$$$%%%%%$$$$$$$$$$$$$$%$$$$$$#$################################$$$$$$$#$##"""""#"####$$$$$$$#$###########################$#$$$$$%%$%%%%%%%%%%%%%%%%%%%%$$$$$$$#############################$$#$$$$$$$####""""""##$#$$$$$$#$##$###########"#############$$$$$$%$%%%%%%%%%%$$$$%%%%%%%$%$$$$$##$##$##########################$$$$$$$$#$#"#""""#####$$$$$$$#$##########################$$$#$$$$%$%%%%%%$$$####$$$%%%%%$$$$$#$#############################$#$$$$$$$$###""""""#"####$$$$$$$#$#######################$#$#$$$$%$$%%%%%$$###%###$$%%$%$$$$$##$#$#$#####################$##$#$$$$$$#####""""""####$$$$$$$#$#########################$$$$$$$$$%%%$$$##S%##$$$$$$$$$$##############################$$$$$$$$$###"#""""####$#$$$$$$$$#$####################$#$$#$$$$$$$$$$#########$$$#$##$####$################$###$$$$$$$$$#$#""""""""####$$$$$$$$#$#########################$#$$$#####""""###$$#$##$###############$#####$$#$$$$$$$$$####"""""##"##$$$$$$$$$$#$#$##################$#$#$$##"""u"""#####$###################$####$$$$$$$$$$###"#"""""#####$$$$$$$$#$#################$#$##$####""u%%"""""###$##################$#$#$$$$$$$#$##"""""%"""#####$$$$$$$$$#$#$###$#################"""%%%%"""###############$####$#$$$$$$$$$$###""""""#"###$#$$$$$$$$$$##$##############""""""uu%%&"""####$#########$#$#$$$$$$$$$####""""""""######$$$$$$$#$#$###$##$##$####""%u%%%s""#######$#####$#$$$$$$$$$$$###"#"""""""##$#$#$$$$$$$$$#$##########"""%ss"""#######$#$#$$$$$$$$$$$#####""""""""####$$$$$$$$$$$#$#$#$###"""4s#%%%%u"""##$##$#$$$$$$$$$$$$$##"#"""""""####$#$$$$$$$$$#$#$#$##""%#%%u%%%""##$$$$$$$$$$$$$$$####"""""%""""####$$#$$$$$$$$$$##"""%3S#%%%3"""##$$$$$$$$$$$##$##"""""%"""####$#$$$$$$$$$$$#$"4T%%%%%%%4""#$$$$$$$$$$$###""#"""%""##"###$$#$$$$$$###"%4u%%%%%4"###$$$$$$$#####"""""""""###$$#$$$$$##"""4%4"""##$$$$#$###"""""""""#"#$#$#$$###""T4%4%9T&T4%4""###$$##"#""#"""T""#"########"""uS&r%%uS&r%"""###"#"#"""""%""""##""""""s%S4%%%%%s%S4%""""""""""""""""""#u%%4%%#u%%4%"""""""%%%tsT%st4T%%%T%%%tsT%st4T%%"%4%r44 A r%%4%r44 A r%%q```pp`qq`q````2r`r`r`r``rrr####$####$$$$####$#$##$###$$$$#$##"####$#$#$###$#$#####$$$$#####$"%%$#$$$$%%%%%%%%%%%%%%$%$$$$$$$%$$$$$%%%%%%%%%%%%$%$$$#$%%$""$%%%$###$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$%%%$##$%%%%$$$$$$$$$$$$$$$$$%$$$$$$$$$%%%%%%%#!"#$%%%%%%%%$$$%%$%$$$$#"#$$	%%%%%%%%%%%%%%%$$#""#$$$%%%%%%%%%%%%&%%%$$##"#"#$$$$	&%%%%%%%%%%%$$$##"##$$$$%%%%%%%%%%%$$$$##"#"##$$$$$%%%%%%%$$$$$$#"""#$$$$$$$$%%%$$$%$$###"!#"##$$$$$$$$$$$$$$$##""!"""###$$$$$$%$$$$$$$$##!#""$$$$$$$$$$$$$$$#"""###$$$$$$$$$$$$$##"!#$!""$$$$$$$$$$$$###""!"####$$$$$$$$$$$$##!#$!"####$$##$#####"""!""#"!""#####$$$$$$$###"!#$$#!"""$###########"""!"#!"######$$$####"" $$!!"""########""""!!##!"#####$####$#" $$$ ""####$#"""""!!###!"###########""!#$%$## """""#####"""""!###!""##$$#####"""!$#%%#!!""""""#"#""""!"$#$!!""####$$#"""!#$%%$# !"""""##"""""""!!#$"!!"""#""""" #%%# !""""$#"""!!!"$$$!!""##"##$""""!!""!!!"""$"""##""!!$$#!!""##"""""!!!!!!!"""##""!!!#$$#"!!!""##""" !"#! !"""##""!!!!!#$$$"!!"""#""!# # # !!#""!!!!"#$$#"!!!##"""#"!!"###!!!!"#""!!!"$$$$#"!!!#"""# !!!"#$$#"!!! !!"!!!""#$#$$#"!!""$ "#$$#" # !!!!!"#$$$$#"!!"!"""#$	$##"!!!!!!!"#$$$$#""!!!!!##"#$	$#"## !!!!!""#$$$$##"! !!!! ## !!!! !""#$$$$$"!  !!!!! %&&% !!!!!  !"#$$$!#$##""!  !!!!!!! #$&&$# !!!!!!!  ""#$$#!$$$#"" #!!!!!!!!! #%&&% !!!!!!!!!#""#$$#!#$$#""!!!!!!!!!!""##"!!!!!!!!!""##$$#!#$$##""" !!!!!!!!"##$$$#"$!!!!!!! """"##$$##$$##"""!!!!!!!!$#$$		$$$$"!!!!!"$"""##$$!#$$$#""""## !!!!!!""$#$$		$$#$"""""!$#"""#$$$##$$###"""$!!!!""""##$$$		%$$##""""""""#$"""##$$$#!!$$$##"""""!!""""""##$$$%	%$$$##""""""""""""""##$$$#!#$$$##"""$$""""""""##$$$%	%$$###"""""""$$"""##$$$##$$###""""$"""""""##$$$%%%%$$$###""""""$""""###$$## ##$$$##""""""""""""###$$$%%%%$$$###"""""""""""##$$$#ݮ ##$$$###""""""#"""##$$$%%%%%$$$####"""#""""""###$$$$!!##$$$####""""""$""###$$$%%%%%$$$#####"$"""""###$$$#"!!##$$$####""""""$""##$$$$%%%%%%$$$####""""""####$$$#ݮ ##$$$#####"""""""$#$$$%%%%%%%$$$##$""""""#####$$$#"#$$$$####"""""""#$#$%%%%%%%$$##$"""""#####$$$$#"!#$$$$#####""""##"%%%%%%############$$$$#"!"##$$$########"#####$##############$$$$$#""##$$$################$$$$#################$$$$##"###$$$$##############$$$$%%%%%%%%%%%$$$###############$$$$$##"#"##$$$$##############$$$%%%%%%$$%%%%$$$################$$$$#"#"##$$$$$############$$$$$%%$#$$$$$###############$$$$$##""##$$$$$############$$$$$##$$#############$$$$$$#"#"##$$$$$$##########$#$##############$$$$$#""#"##$$$$$$####################$$$$$$#"""###$$$$$$##########$$$$$$##""##$$$$$$$$$###u$utu##$$$$$$$##""#"##$$$$$$$#uu$$$$$$##""##"#$$$$$#rt$r#$$$$##""##"####t###""#""###ruru#""#````````###""#####$$$$$$$$%%$%%$$$$%%$$$$%"$%%$$$$$$##$%%%%%%%%$""#$%%%%%&$$#""$$&%%%%$$#""##$$$%%$$#"""#$$%$$$$#"""##$$%%$$$#""#$$$$##""###$$$"!$$!"#$#$##""!"#"##$#$#"$$""$#$"""!#""###""$$""""""$"!""""""!""#"""!""!""""!!!!"""!!"#!!#""##!""!##!""#"#$"##!!##"!"##"!!!!"#$"#!!!!!!#"$"$!!!#%%#!!!""#$"$#"!!!!##!!!""#$$#""!!!"$#$$#$""!"""#$"$#""!"""#$$$$#""""""""#$$$#""$""""#$%$$#""""$""#$$"$$#"""#""#$%%$##""#"""#$$"$$##""""#$$%%$##$"""##$$#$##"""$$%%$#$$"""###$##$###""#########$$#"##$$#######$$%$########$$####$$#######$$%$$$$$########$$#"##$$$###############$$$#""#$$$########$$$#""#$$$##$$$"######""####$$$$$%$$#"$%%$""$%$$""##$$""#$#""""$"$$###""##"!"$#!##!##"""""#!#!!"#"!!!!#"####"!"##""#####"""##"""###$#"$$&&$$"#$##$###$###$##$####$$####$"#$$$$"##tf2                   (   (@  (P  (T  igGGGHHHIIIIIIIIIIIIIIIIIIIIIHHHHHHHHGFeiDEFGGHHHHIIHIIIIIIIIIIHHIIIIIIHIHHHHHHHHHHGGFEieGHHHHHIIIIIIIIIIIIIIIIIIIIIIIHHHHHHHGgiejgFFGGGHHHHHHHHHHIHIHHHHHHHHHHHGGGGGFEgjCDEFGGGGHHHHHHHIHIIHHGgfGHHHHHHHGHGGGGGFFFFEDCjgFGGGHHHHHHHHHHIHIIIIIHHIIHIHHHHHGGGFgjeAehEFFFGGGGGGGHGHHHHHHHGGGGGGGGGGFFFFFDdhEGGHHHHHGGGGGHHHHHHHGghifFGGGGGGGGHHHGHHHHGGFEhcEFGGGGHGGGHGHHHHHHHHHHHHHHHHHGGGFFFEheABBBDEEFFFFGFGFGGGHGHGGGGGGFGFGFFFFFEEECA DFGGGGHGHHHIHHIIIIHGgijjigGHHHHHHHHHHHGHGGGFFEBAEFFFFGGGGGGGGGHHGHGGHGHGGGGGGGFFFEECA BCDEGFEEEFFFFFGFGGGGGGFGGFFFFFFFFFEEEEEDBBEEFFGGHHHHHHHHHHHHGgiijjjieGHHHGGHGHGGGGGGFFFEBADEEFFFFGFFGGGGGGGGGGGGGGFGFFFFFEEFFEDCDCEEFGFEEEEEFFFFFFFFGFFFFFFFEEFFEEEEFEDDCBDEEFGHHHGHGGGHGHHGfhihiiiihfGGGHGGGGGFGGFFFGFECBDDEEFGFFFFFFGFFFGFGFGGFFFFFFEEEEFFGFEDDCEFEFGFFEEEEEEFEFEFFFFFEFEEEFEEFEEEFEDCCCDEEFGHHGGGGGGGGGFfgiiihhhjihfFGGGGGGFGFFFFGFFEDCCDEEFFFEEFEFFFFFFFFFFFFFEEEEEEFFFGGFEDDDDEFFFGFFFEEEEEEEFEEEFEEEEEEEEEEEEFFEDDCDDDEFGGGGFGFFGGGFfhiiihfehiiiheFGFGGFFFFFGGGGFEDDDDEFFFEEEEFEFFFEEEFEFEFEFEEEFFFFGGEEEEDDDEEEFGGGFFFEEFEEEEEEEEEEEEEEEEEEEFFFEDDDDDEFGGFFGFFGFFEeghhhgeFFegghggdEFFFGFFGGGGGGFEEDDEEFFEFEEFEEEEEFEEEEEEEEEEFFFFGGGFEFEEEDDDEFFFGFGFFFFEEFEEEEEEEEEEEEEEEEFEFFFEEEEEFGFFGFFFFFFEegghhgeEFFEeghhhgeEFFFFGFFFGFGGFEEEFFEEEEEEEEEEEEEEEEEEEEEFEFFFGGGFEFFEEEDDDEEEFFGGGFFEFFEEEEEEEEEEEEEEEEEEEEFFFFFFFFFFFFFFFEFEdfegggeEFFFFEefhhgfdEFFFFFFFFFFFFFFFEEEFEEEEEEEEEEEEEFEEFEFFFFGGFGFFEFFEEEDEDEFEEFFGGGGFFFFFFEEEFEEEEEEEEEEEEEFEEEEFEFFFEFFFFFEdfgfgedEFFFFFFEdfgfgfdEFFEFEEFFEEFEFEFEEEEEEEEEEEFEEEEEFFFFFFGGGGGFFEFFEEFEEEDEEEEFFFGFGGGFFFEFFFEEEEEEEEEEEEEEEEEFEEFEEEFFEFEDceegffcEFFEFFFEFEdfgggecDEEEEFEEEEEFEEEEEEEEEEFEEEEEFFEFFFFFFGFGGGFFEEFFEEFEEEDDEFEEFGFGGGFGFFFFFEFFEFEEFEEEEEEEEEEEEEEEEFEEEEDcefffecDEEFFEEFFFFEcefeedcDEEEEEEEEEEEEEEEEEEEEEEFEEFFFFFFFFGGGGGGFFEEFEFEEEDEEEDEFFEEFFFGGGGGGFFFFFFFFEFEFEEFEEEFEEEEEEEEEEEEDbdeefecDEEFEEEFEEFEEDceffedbDEEEEEEEEEEEEEEEFEFFEFFFFEFFFFFGGFGGGFFFEEEFFEEEFDEEDDEEFEEFFFGFGGGFGGFFGFFFFFFEFFEFFEEEEEEEEEEEEEDbdeeedbDEEEEEEEEEEEEEEDbceeedbDEEEEEEEEEEFEFFEFFFFFFFFFFGFGGGGGGGFFFEEEFFFEEEFDEEEDEEFFEEFEFFFGGGGGGGFFFFFFFFFFFFFFFEFFEFEEEEEDcefdddDEEEEEEEEEEEEEEEEDbceeeebDEEEEEFEFEEFFFFFEFFFFFFFFGGGGGGGGFFFEEEEFFFEEEFDEFEEDEFEEEEFFFGFGGFGGGGGFGFGFFFFFFFEFFFFFEFFEEEbefefecDEEEEEEEEEEEEEEEEEEDcefffecEFEFEEFFFFFFFFFFFFFFGFGGGGGGGGFFFFEEEEFEFEFEFFDEFEDDEEFFEEEFFFFGFGGGGGGGFGFFGFFFFFFFFFFFFFFFEdfgfeecEEEEEEEEEEEEEEEEFEEEEEcefeffdEFEFFFEFFFFFFFFFFFGGGGGGGFGGFFFFEEEEEEFFEEEEFDEFEDDDEFFEEFEEFFFFFGGGGGGGGGGFFFFFFFFFFFFFFFEdfgggfdDEEFEFFEFEFEEFEFFEEFFEFEdfggffdEFFFFFFFFFFGFGFGGFGGGGGGGFFFFEFEEEEFFFFEDEFFDDFEDDEEFEFEEEEFEFFFGFGFGGGGGGGGGFGFFGFFGFFFEeghggfdEFEFFFEFFEFFEFEFEEFFFEFEFEcfggggeEFGFFFGFGGFGGGGGGGGGGGFFFFFEEEEEEFFFFEEEEFEDDFEEDDEEFFEEEEEFEFFFFFFGGFGGGGGFGGGGFFGFGFEfhihhgeEFFFFEFFFEFFFFFFEFFFFFFFFFFEegghhgeEFFGFFGGGGGGGGGGGGGFFFFFFEFEEEEEEFFEEEDEFEDDFFEEDEEFFFEEEEEFEFFFFFFFGGGGGGGGGGGGGGGFEfhiiiheEeEFFFFFFFFFFFFFFFFFFFEFFFFEeEeghiihfEGGGGGGGGGGGGGGFGFGFFFEEEEEEEEFFFFFEEDEEFDDFEEDDDEEFFFEEEEEFFEFFFFGFFGGGGGGGGGGGGGFgijighfEEffEFFFFFFGFFGFFFFFGFFFFFGEffEEfgiijigFGGGGGGGGGGGGFGFFFFFEFEEEEEEEFFFFEEDDEFFDDFFEDDEEFFFEEEEEEEEFEFFFFFFFFGFGGGGGGGGFghiijigFFfhhfEFFGFGFFFFFFGFFFFFGFFFehhfFFgijjjigFGGGGGGGGGFFGFFFFEEEEEEEEEEFEFFFEEDEEFEDDEFEEDDEEFFFFEEEEEEEFFFFFFFFFFGFGGFGGGFgijjjigFGFgiiifFGGGFGGGGFGFGGFFGGGFgijigFGFgijjjigFGGGGGFGFFFFFFFEFEEEEEEEFEFFFFEEDDEFFEDDFFFEDDEEEEFFFEEEEEFEEFEFFFFGFFGFFGGGFgijjjigFGFfhjijifFGGGGGGGGGGGGGGGGFgiijjhfFGFgiijhigFGFGFGFFFFFFEEFEEEEEEEEEFFFFEFEEDEFFEDDEFEEDEDEEFFFEEEEEEEEEEFFFFFFFFFFFGFEfijjjigFGGFgijjjiigFGGGGGGGGGGGGGGFfijjjjigFGGFfijjjhfEGFFFFEFFFEFEEEEEEEEEEFEFFFFEEDDEFEECCEFFEDDDEEEFFFFEFEEEEEEEEFFFFFFFFGFEfhiiihgFGGFfhijijjiigFGGGGGGGGGGGGFgijijijjheFGGFfhihihfEFFFFFFEEEEEEEEEEEEEFEFFFFEEEDDEFFECCEFFEEDDEEFEFFFEEEEEEEEEFEEFEFFFFFEfhiiihfEFFFFgijjjijjjigFGGFGGGGGFGFghjjjijjjigEFGFEfhiiihdEFFEEEFEEEEEEEEEFEFFFFFFFEEEDEFFEECCEFFFEDDEEEEEFFFFEEEEEEEEEEEFFFEFEegghihfEFFGEfhhiiiijijiigFGGGGGGGGFghiiiiiiihihfEFFFEfgihhgdEEFEEEEEEEEEEEEEEEFFFFFEFEDDEEFFECCEEFEEEDDEEEFFFFEFEEEEEEEEEEFEFFEeghhhgeEFGFEfhiiiihiiihiffEFGFGGFGFEfhhijiihiiiiheEFFFEeghhgfcDEEEEEEEEEEEEEEFFFFFFFEEEDDEFFEECCEEFFEEDDDEEEFFFFFEFEEEEEEEEEEEDdghhggeEFFFEfhiiihiiiiiiihfEGFFFFGFFEehiiihihhhhiihfEFFFEefgggfdDEEEEEEEEEEFEFFFFFFFEEEDDDEFFEECCEFFFEDDDEEEEFFFFFFEFEEEEEEEEEDdffghgeEFFFEeghhiiihiihiihhdEFFFGFFFGEfhihiihiihhhhhgeEFEEDdfggfecDEEEEEEEEEEFEFFFFFEFEEEDEFFEEDCCDEFFEEDDDEEFEEFFFFFEEEEEEEEEDdfghgfdDFEFEegghhhghhhgghiihfEFFFFFFFFEehihggggghihhhgedDEEEDdefffecDEEEEEEEEEEFFFFFFFEEEDDEEFEEDCCEEFFFEDDEEEEEFFFFFFEEFEEEEEDcegfgfdDEEEDdgghghghhhgeceghgdEFEFEFFFFEeghgedeghhhhggggfdDEEEDcefffecDEEEEFEFFFFFFFFFEEEEDDEFFFEDCDEFFEEEDDDEEEFEFFFFFFEEFEEDcefffedDEEEDdfgffghghhgeEEEeggeDEFFFFFEFEeggeEEEdfggggggggebDEEEDceeefecDEFEEEFFFFFFFFFEEEEDEEFFFEDCDEFFFEDDDEDEEEFFFFFFFFEEEDceefeecDEEDDdfggggggggfdDFFFEegeEFEFFEFFEEefdDEEFDdfggggffffdbDDEEDcefffedDEEFFFFFFFFFEEEEEDDEFFFEDDCDEEFFEEDDDEEEEEFFFFFFEFEDdfgffecDEDDcdfgfgfgfggfdDEEEFEDddDEFEDDEEFDddDEFEEEDbfffffffffeccDDEDcefggfdDFEFFFFFFFFFEEEDDDDEFFEEDCDEFFFEEDDDEEEEEFEFFFFFFEdfgggecDDDccdeffgfgffgffdDEEFEEDcdDEEDdcDEEDdcDEEEFEDceffffeeefeedccDDDdfggffeEFFFFFFFFEEEEEEDDEEFFFEDCDEEFFFEDDDDEEEFEFFFFFFEeghggfcDbbceeffffeffffgfecDEEEEFEDdDEEDcdDFEDcDEEEEEEDceeffffffffefeeccbDdfgghgeEFFFFFEFEFEEEDDEEFFFEEDCEDEEFFEEDDDDEEEEEFFFFEfhhihfdDEDcefefeffffffefdcDEFEEEEEDcDEEDccDEEDbDEEEEEEEDcefffeeffeeffgfdDEDcfhhhfeEFFFFFFEEEEEDDDEEFFEEDCDDEFFEEDDDDEDEEEEFEFEfhihhgdDEEEDdefffefffffffecDEEEEEEFEDEEDcddcDEEDEEEEEEEEDceeffffefffggfdDEEEDeghghhfEFFFEEEEEDEDDEFFFEEDDCDEEFFEEEDDDDEEEEFEFEfhiiiheEFEEEEDdfffffeffffeecDEEEEEEEEEEEDceecDEEEEEEEEEEEDcefffffffgggfcDEEFEFEeghiiheEFEFEEEEEDDDEFFFFEEDCDDEFFFEEDDDDDEEEEEEeghiigfEFEFEEEEDdffeffefffeecDEEEEEEEEEEDcdeedcDEEEEEEEEEEDceeffffggfgfdDEEEEFEFEehihiheEFEEEEEDDDEEFFFEEDDCDEEFFFFEEDDDEDEEEDdghhihfEFFFFFEFEEDdegfffffefdcDEEEEEEEEEEDceffecDEEEEEEEEEEDbefefgfgggfdDEEEFEEFFFEfhiihgeEEEEEDEDDEFEFFEEDCCDEEEFFEEDDDDDEDEDdfghggfEFFFFFEFFEEDdfgggggfffdcDEEEEEEEEEDcdeffedcDEEEEEEEEEDcefggggfggfdDEEFFFFFFFFEfhihhgdDEEDEDDDEFFFFEDDCCEDEEEFFEEDDDDDEDcfgghfeEFFFFFFFFEFEEDdfgfgfgfgecDEEEEEEEEEDcefggfecDEEEEEEEEEDcfgfgggggfdDEFFEFFFFFFFFEefhhgecDEEDDDEEEFFEEEDCCDDEEFFFEEEEDDDDbegggfeEFFFFFFFFFFFFEDdfgffgggffdDEEEEEEEEDceefggfeecDEEEEEEEEDdfgggggggfdEFEFFFFFFFFFFFEeghggecDDEDDDEFFFFEDDCCDDDEFFFEEDDDDCbdffgfdDFFFFFFFFFFFFEFEbegggfggffdDEEEEEEEDcecceffecbecDEEEEEEEDdfgggggfgecEFFFFFFFFFFFFEEEefgffebDDDDEEFFFEEEDCCDDEEFFFFEEDDCdeffedDEFEFFFFFFFFFFFFFEegggggggfdDEEEEEEEDdcDDdfgdDDcdDEEEEEEEDdfggfggggeEFEFFFFFFFFFFFFEEDdffefdbCDEEFEFFEEDDCCDEDEEFFEEEDCbceeeecDEEEFFFEFFFFFFFFFFEegghggggecDEFEEEEEDcDEDdeedDEDcDEEEEEEEDdfgggghhgeEFFFFFFFFFFFFFFEFEDcefeedbCDEEFFEEEDCCCDDDEEEFFEEECbdedeecDEEEEEFFFFFFFFFFFFEdghhhhfggfdDEEEEEEEDEEDdefdDEEDEEEEEFEDdfgghghhhfeEFFFFFFFFFFFFFEFEEDbefeedbCEEFFFFEEDDCCDDEEEFFEFEDDCbdeeeecDEEFEFFFFFFFFFFFFEfghhhghghfdDEEFEEFEEEEDdgfdDEEEEEEFEEEDdghhghhhggeEFFFFFFFFFFFFFFEEDbefeedbCDEEFFFEEDEDC%CDDDEEFFFFEEDDCdeefedDEEEEFEFFFFFFFFFEfhihhhhhhhgdEEEFEEEEEDdfggfdDEEFEFEFEEeghhghhhhhgeEFFFFFFFFFEFFEEEDceefecbCDEEFFFFFEDDDC%CDDEEEFFFEEEEDDCbdeffedDEEEFFFFEFFFFFFEfghiihgghghfeEEFFFEDDdfggggfdDDEFFFEEeghghhhhghggfEFFFFFFFFFFFFFEDceefddCDDDEFFFEEEEDDC%DDDEEFEFFEEDDDDCbdeeffdDEEEEEFFFFFFFFEfhiihiihghhhgedEEEEdefggfghgfedEEEEdegghhhghhhhhhfEFFFFFFFFFFEFEDdffffdbCDDDEEFFFFEEDDCCCDDEEEEFFEEEDDDDCbcfeffdDEEFEFFFFFFFFEehhiiiiihhhhhgfeedefgghfeeghggfeedefghhhghhhhiiiheEFFFFFFFFFFFEDdffefdbDDDDEEFEFFEEEEDCCDDEDEEFFFFEEEDDDDCbdefffcDEEEFEFFFFFFEfgiihhhihiiihggfgfgghhgdEEeghfgggggghhhihhiiihiihfEFFFFFFFFEFEDdeeffebDDDDEDEFFFFEEEDDDCTCDDEEEFFFEEEDDDDDDDbdfegfdDEEEFEFEFFFEfhihhihiiiiiiiihiihhhgeEFFEdghghhhhghihhiiiihihihfEFFFFFFFFFEDdffffebDEDDDDEEFFFEFEEDDCC%CDDEEEEFFFEEEDEDDDDDdffgecDEEEFEFFFFEfhihihiihiiihiiiihhiheEFGFGEdhihiiiiiiiiihiiiiiihfEFFFEFFFEEDdfgffecDEDDDDEEEEFFEEEDEDCCDDEDEEEEFFEEEEDDDDDEDbeffffdDEEEEFEFEEfghiiiiiiiihihiiiiihgFGFGGFGFghiiihiihiiiiiihihhhfEFFFFFEEEDdffffebDEDEDDEDEFFFFFEEDDDDCCDDDEEEFFFFEEEDDDDDDEDcecegfdDEEFEFEEdfhhihihihhhhhhhhhiihgFGGGGGGFghihiighhhghhiiiiiihgeEFFFFFEDdfgffecDEDDDDDDEEEFFFEEEEDDCC%DDDEEEEFFFEFEDEDDDDDEEDcdeffedDEEEEFEeghghihhhfffeffghhhihhfFGGGGFfhiighhgfffffghhhhihihfEFFEFEDdffffdcDEDDDDDEEEEFFFEEEEDDDCCCDEDEEEFFFFEEEDDDDDDDDEDbeffgfdDEEFEEdghhggffedEEEEEdeffhiihfFGGFfhhihgfedEEEEEdeffhhiihfEEFFEDdfgffecDEEEDEDDDEEEFFEFEEEEDDDC DDDEEEEEEFFEEEEDDDDDDEEEDbefegfdDEEEEdffgfedEEEFFFFFEEEeffighfFFfhiihfeEEEFFFFFEEEefghhgfEFEEDdfgfedcDEEDEDDDDEEEFEFFFEEEDDCDCA CDDDDEEEFFEFEEEDEDDDDDEDEDceefffcDEDdfgfedEEFFFFFFFFFFFEEfhiihffhhiheEEFFFFFFFFFFFEEefgggeEEDdfgffecDEEEEDEDDDDEEFFFFEEEDDDDCCDDEDEEEFFFFEEEEDDDDDEDEEEDceffgedDDdfedEEFFEFFFFFFFFFFFFEfhhhhhiigfEFFFFFFFFFFFFFFFEEeegeDDdfggfecDEEEEEDDDEDEEFEFFEFEEEDDDCC CCDDEEEEFFFFEEEEDDDDDDDEEDEDcefffedDddDDFFFFFFFFFFFFFFFFFFEfhihhihfEFFFFFFFFFFFFFFFFFFEEedDcfggfebDEEEDEDEDDDEEEFFFFFEEEDEDCDC4 CDDDDEEEEFFEFEEDEDDDDDDEEEEEDbfghgdbDDEEEFEFFFFFFFFFFFFFFFEeghiiggeEFFFFFFFFFFFFFFFFFFFEDDdffgfebDEEEEEEDDDDDEEEEFFFEEEEDDDDCC4CCDDEEEEEEFFFEEEEDDDDDEDEEEEEDcfhhfedDEEEEEFFEFFFFFFFFFFFFFEeghhgeEFFFFFFFFFFFFFEFFFFEEEDdffgfecDEEEEEEDDDDDEDEEFFFFEEDEEDDDC4!CDDDDEEEEFFFFEFEEDEDDDDDEDEEEEDdefhffdDEEEFEEFEFFFFFFFFFFFFEeghhgeEFFFFFFFFFFFFFFFEFEFEDdffffecDEEEEEDEEDDEDDEEFFFFEFEEEDDDCCC4CCDDEDEEEFEFFEEEEEDDDDDDDEEEEEEDbdfgdfdDEEEEEEEEFEFFFFFFFFFFEegheEFFFFFFFFFFFFFEFFEEEEDdffgfecDEEEEEEEDDDDDDEEEFFFFFEEEEDDDDCCDDDDDEEEFFFFFEEEEDDDDDDDDEEEEEEDceeggfdDEEEEEFEEFFEFFFFEFFFEeggeEFFFFFFFFFFFEFFEEEEEDdfggeecDEEEEEEEDDDDDDEEEFEFFFEEFEEDDDCCC CDDDDEEEEEFFFEEEEEEEDDDDDDEDEEEEEDbdffgfcDEEEEEEEEEFEEEFFFEFEeggdEFEFFEFFEFFEFEEFEEEDdfggfebDEEEEEEEEDEDDDDEEEEFFFFFEEEDEDDCC4CDEDDEEEEFFFFEFEEDDDDDDDEDEEEEEEEDceffgfdDEEEEEEEEEEEFEFEFEdfghfeEFEFFFEFFEEEEEEEEDcfgefdcDEEEEEEEDEDDDDDEDEEFFFFEFEEEEDDCDCCCCDDDEEEEEEFFFFEEEEDDDDDDDDDEDEEEEEDceffgedDEEEEEEEEEFEEEEEEeghhfdDEFFEEEEEFEEEEEEDdegefebDEEEEEEDEDDDDDDEDEEEFFFFFEEEEEDDDDC4CCDDDDEEEEFFFFFEEEEEDDDDDDDDEEEEEEEEDbeefgedDEEEEEEEEEEEEEDcfghggfdDEEEEFEEEEEEEEDdfgffdcDEEEEEEEEEEDDDDDDEEEEFFFFEEEEEDDDDCC CDDDEDEEEEFFFEEEEEEDEDDDDDDDEEEEEEEEDceffffdDEEEEEEEEEEDDdffghggffdDDEEEEEEEEEEDcffffecDEEEEEEEEEDDDDDDDEDEEFFFFEEEEEDEDDDDCCCCDDDEEEEEFFFFEEEEDEDDDDDDEDDDEEEEEEEDcdfffedDEEEEEEEEDccdfgghhggfdccDEEEEEEEEDdfgefecDEEEEEEEEDDDDDDDDDEEEEEFFFFEFEEEDDCDCC4 rCCDEDDEEEEEFFEFEEEEEDDDDDDDDDEEEEEEEEEDbefffedDEEEEEEEEDDDdfghggfdDDDEEEEEEEEDdefffecDEEEEEEEDEEDDDDDDDEDEEEFFFFEEEEEDDDDCCCDDDDEEEEEFFFFEFEEEEEDDDDDDDEDEEDEEEEEEDbeffeecDEEEEEEEEEEDdfggfcDEEEEEEEEEEDceeefecDEEEEEEEEEEDEDDDDEDDEEEFFFFEFEEEEEDDDDCC4 CCCDDDEEEEEEFFFFEEEEEDDDDDDDDDDDEEEEEEEEEDbefffecDEEEEEEEEEDdffffdDEEEEEEEEEDceffeecDEEEEEEEEDEDDDDDDDDEEEFEEFFFFEEEEEEDDDCCs45CCDDDDEEEEEFFFFFEEEEEDDEDDDDDDDDEEEEEEEEEDceeffdbDEEEEEEEEEDdffdDEEEEEEEEEDceefeecDEEEEEEEEEEDDDDDDDDDEEEEEFFFFFEEEDEDEDDDC4 CCCCDDEDEEEEFEFFFEEEEEEDDDDDDDDDEEDEEEEEEEEDcefffdcDEEEEEEEEDdgedDEEEEEEEEDcdfffecDEEEEEEEEEEEDDDDDDDDEDEEEFFFFFEEEEEEDDDDCCC4 4CCDDDDDEEEEEFFFFEEEEDEDDDDDDDDDDDEEEEEEEEEEDcefeeecDEEEEEEEDceebDEEEEEEEDcefefecDEEEEEEEEEEDEDDDDDDEDEEEEFEFFFEEFEEEEDDDCDCBC4 CCCCDDDEDEEEEFFFFFEEEEEEDDDDDDDDDDDDEEEEEEEEEDcefffecDEEEEEEDcdecDEEEEEEDbefffecDEEEEEEEEEDEDDDDDDDDDEEDEEEFFFFFEEEEEDEDDDDCC 4CCDDDDEEEEEEFFFFEFEEEEDDDEDDDDDDDEDEEEDEEEEEEDcefefecDEEEEEEDddDEEEEEEDceeffecDEEEEEEEEEDEDDDDDDDDDDDEEEEFFFFFEEEEEEEDDDDCCC CCCDEDDDEEEEFFFFFEEEEEEEDDDDDDDDDDDEDEEEEEEEEEDcefefecDEEEEEDddDEEEEEDbefffecDEEEEEEEEEEEDDEDDDDDDDEEEEEEEFFFEFEEEEEDDEDDCC4CBCCDDDDEEEEEEFFFFFEEEEEEDDDDDDDDDDDDDEEEEEEEEEEDcefffecDEEEEDccDEEEEDcefedecDEEEEEEEEEDEDDDDDDDDDDDEDEEEFEFFFFEEEEEEDDDDCCC% CCCCDDDDEEEEEEFFFFEEEEEEEEDDDDDDDDDDDDEDEEEEEEEEDcefffecDEEEDcdDEEEDceddfdcDEEEEEEEEEEEDEDDDDDDDEDDEEEEFFFFFFEEEEEDEDDDDDCCC4rCCDDDEEDEEEEFFFFFEEEEEEEDDDDDDDDDDDDEDEEEEEEEEEEDcefefecDEEDccDEEDcefffdcDEEEEEEEEDEEDEDDDDDDDDDDEEEEEEFFFFEEFEEEEEEDDCDCC4 CCCDDDEEEEEEFEFFEFEEEEEDEDEDDDDDDDDDDDDEDEEEEEEEEDbefffecDEDcbDEDcefefebDEEEEEEEEEEDDDDDDDDDDDDDEDEEEEFFFFEEEEEEEEEDDDDCC%4 rCCCDDDDDDEEEEEFFFFFEEEEEEEEDDDDDDDDDDDDDDEDEEEEEEEEDbeeffecDDbcDDbeeffeDEEEEEEEEDEEDDDDDDDDDDEDDEEEEEEFFFFFEEEEEEEDDEDDDCC4 rCDCDDEDEEEEEEEFFFFFEEEEEEEDDDDDDDDDDDDEDDEEEDEEEEEEDbeeffecDccDceeffdcDEEEEEEEDEEEDEDDDDDDDDDDDEEEEFEFEFFFEFEEEEEEDDDDDCCC4ACCCCCDDDDEEEEEFFFFFEEEEEEEDEEDDDDDDDDDDDDDEDEEEEEEEEEDcefefebDDcefefecDEEEEEEEEEDDDDDDDDDDDDDDEEDEEEEEFFFFFFEEEEEEEEDDDDCCC4 3 CCCDDDDEEEEEEEFFFFFEFEEEEEEDDDDDDDDDDDDDDDEDEDEEEEEEEDceeffdcceffeecDEEEDEEDEEEDEDDDDDDDDDDDDDEEEEEEFEFFFFEEEEEEDEDEDDCCC4 4CCCCDDDEDEEEEEEFFFFFFEEEEEEEEDDDDDDDDDDDDDDDDDDEEDEEEEEDbcfdfeeffeebDEEEEEEEEEDDEDDDDDDDDDDDDDEEEEEEFFFFFFEEFEEEEEEDDDDCCCC4CCCDCDDDEDEEEEEFEFFFEFEEEEEEDEDDDDDDDDDDDDDDDDEDDEEEEEEEDbdeeeeeedbDEEEEEEDEDEDDDDDDDDDDDDDDDDDEEEEEEFFFFFFEEEEEEEDDDDDDCCCCCCDDDDDEDEEEEEFFFFFFEEEEEEEEDEDDDDDDDDDDDDDDDDDEDEEDEEEDbddecedbDEEDEDEEDDDDDDDDDDDDDDDDDEDEEEEEEEFEFFEFEEEEEEEDEDDDDCCCBCCCCCDDDDEEEEEEFFFFFFFFEEEEEEEEDDDDDDDDDDDDDDDDDEDEDDEDEDEDbddedDEDEEDEDDEDDDDDDDDDDDDDDDDDEEEEEEEFFFFFEFEEEEEEEEDDDCDDCCC9CBCCCDDEDEEEEEEEFFFFFFEEEEEEEDEEDDDDDDDDDDDDDDDDDDDDEDDDDEEDbdcbDEDEDDDDDDDDDDDDDDDDDDDDDEDDEEEEEFEEFFFFFEEEEEEEEEDDDDDCCCsCCCCCDDDDEEEEEEEFFFFEFEEEEEEEEEDEDDDDDDDDDDDDDDDDDDDDEDEDDDCbbCDDDDEDDDDDDDDDDDDDDDDDDDDDEDDEEEEEEFFFFFEEFEEEEEEDDEDDDCCCCCCCCCDDDEDEEEEEEEFFFFFEEEEEEEEEDDDDDDDDDDDDDDDDDDDDDDDDDDDDDBBDDDDDDDDDDDDDDDDDDDDDDDDDDDEEEEEEEEFEFFFFFEEEEEEEEEDDDDCCCCCCCCCCDDDEDEEEEEEEFFFFFEEEEEEEEEDDDDDDDDDDDDDDDDDDDDDDDDDDDDCCCCDDDDDDDDDDDDDDDDDDDDDDDDDDEEEEEEEEFEFFFFFEEEEEEEEEDDDDCCCCCCBCCDDDDDEEEEEEEFEFFFFFEFEEEEEEEEDDEDDDDDDDDDDDDDDDDDDDDCCCCCCDDDDDDDDDDDDDDDDDDDDEDEEEEEEEEEFFFFFFEEEEEEEEEDDDDCDCCCsCCDCDDDEDEEEEEEEFFFFFFEEEEEEEEDEEDDDDDDDDDDDDDDDDDDDDCC%%CCDDDDDDDDDDDDDDDDDDDDDEEEEEEFEFFFFFEEEEEEEEEDEDDDDDCCCC%CCCCCCDDDEEEEEEEFFFFFFFFEEEEEEEEEEDDDDDDDDDDDDDDDDDCCCS%%CCCDDDDDDDDDDDDDDDDEEEEEEEEEFFFFFFEEEEEEEDEEDDDDDCCCCSCCCCDDEDDEEEEEEEFEFFFFFFEEEEEEEEDEEDDDDDDDDDDDDCCC&CCCDDDDDDDDDDEDDEDEEEEEEEFFFFFEEFEEEEEEEDDEDDCDCCCCCCCCDDDDDEEEEEEEEFFFFFFEEEEEEEEEEEDDDEDDDDDDCCCCCCDDDDDDDDEEEEEEEEEFFFFFFFFEEEEEEEEEDDDDDDCCCuCBCCCCDDDDEDEEEEEEFEFFFEFEEEEEEEEDEDEDDDDDDCCu%%CCDDDDDEEDEEEEEEEEFFFFEFEEFEEEEEEDDDDDDDCCCCCCCCCCDDEDEEEEEEEEFFFFFFEFEEEEEEEEEDEDDCCCu%%CCCDEDDEEEEEEEEFFFFFFEFEEEEEEEDEDDDCDCCCCC%CCCCDCDDDDDDEEEEEEFEFFFFFFEEFEEEEEEDEDDC%%%%DDDEDEEEEEFEFFFFFFEEEEEEEEEEDEDDDDDCCCCCCCCCDDDDEEEEEEEEFFFFFFFEEEEEEEEDDDCCCuu%%CCCDDDEEEEEFFFFFFEEFEEEEEEEEDDDDDDCCCCCCCCCDDDDEEDEEEEEEEFFFFFFFFEEEEDDCCCu%%%sCCCDDEEFFFFFFFFEEEEEEEDEDDDEDDCDCCCC%%CCCCCCDDDDDEEEEEEEEFEFFFFFEEDDDCC%ssCCDDEFFFFFFEFEEEDEEEEEDDDDDDCCCBCCCBCCCDDDEDDEEEEEEFEFFFFFEEDCCCs#%%%%uCCDEEEFFEFEEEEEEDEEDEDDCDDCCCC%CCCCDCDDDDEEDEEEEEEFFFEEDDC%#%%u%%%DDDEEEEEEEEEEEEDDDDDDDCCCCC%CCCCCDDDDDEDEEEEEEEEEEDD%3S#%%%3DDDDDEEEDEEDEDDEDDCDCCCC%%%CCCCCDCDDDEDEDEEEDDDDDD4T%%%%%%%4CCCDDDDDEEDDDDDDDCCCC%%%%CBCCCCDCDDDEEDDDCCC%4u%%%%%4CCCDDDDDEDDCDCDCCBCCCCCCCCDDDDDDCCC4%4CCCDDDDCDCDCCCCCBCCCCDCCCCCCT4%4%9T&T4%4CCCCCCDCCCBC9TCCCuS&r%%uS&r%CCCCCC%%%s%S4%%%%%s%S4%%%#u%%4%%#u%%4%%T%%%tsT%st4T%%%T%%%tsT%st4T%%%4%r44 A r%%4%r44 A r%%hGHIIIIIIIIIIHHHHGceEGHHIHIIIIIIHHHHHGGFecHHHIIIIIIIIIIIHHHh`bFGGGHHHGGGGFFaGHHHHHHIHiiHHHHHHHGbEGGGGHHHHHHHHGFa`DFFEFFGFFFFEEECCEHHHHHHhiihHGGGGGDCEFGGGGGFFEEDDFFEEEFFFEEEEEEFCDEHGGGGgihgihGGGDFFEFFFFFFFFEEFEDEFGFFEEEEEEEEEEFFEFGfhgGGfhfGFGGEFFEEEEEEEEEEFFGGFFEEFGGFFFEEEEEEEEEFFFFFFFFfffGFFGfgfFFFFFFFEEEEEEEEEFFFGFFEEEEEGFFFFEEEEEEEEEEEFEEefeFFFFFefdEEEEEEEEEEEEEEFFFGGGFEFEEEEFFFGGGFFFFFFEEEEEEEEdedEEEEEEEEdedEEEEEEEFFFFFFGGGFEFFEEEEEFEFFGGGFFFFFFFFEEeedEEEEEEEEEdedFEEFFFFFFFGGGGFEEFFEEFFFEFFGGGGGFFFFFFFfgeFEEEEEEEFEEFefeFFFFFGGGGFFEEFFEEEEEEFEEFFGGGGGghfFFFFFFFFFFFFFfggGGGGGGGFFFEEEFEEFEEEFFEEFFFFGGGGGGGhihdFFFFFFFFFdgihGGGGGGFEEEEFFEEEEFEFFEEEEFFFFGGGiiicieGFGeicijiGGGGFFFEEEEFFFEFEFEFFEEEEFFFFGijigjifGGGGGGGGfijghiiFFFEEEEEEFFFEFDFEDEFFFEEEEFFFFhihcijjifGGGGGGfjijicGhihFFFEEEEEEFFFEEFDDFEEEFFFEEEEEFFGghghiiiihcGGGGchiiiihGFghfFEEEEEEEFFFFEDEFDDFFEFFFFEEEEEFfhfGFGgiiiiihcciiiihigGFfgeEEEEEEFFFFEEFEDDFFEEFFFEEEEEegfFEfghhheghcFFFFchgfghhgeFEFefeEEEEFFFFFEFEaDFFEDEFFFFEEEdfeFEFfggggdFGfcFFFFcfEcgggfdEEEdfeFEFFFFFEEEFEDEFEDEEFFFFFfgeEEbefffgeEEabEFEEbaEEdffefdbEEegeFFFFFEEDEFEbDEFFDEEEFFghfEbeefffffcEEEaEaaEaEEEcefefefebFehfGFFFEEEFEbDEFEDEEFhigEEcfffffeaEEEEEddEEEEEaeffffgcEEghhGFEEEFFEaDEFFEDEEFgigFFEEcffffeaEEEEEaeeaEEEEEaeffgfcEEEFGhigGEEDEFFaDEEFEDDEfgfFFFFEFfggfeaEEEEdffdEEEEafgggfFFFFFFghfEEEFEDFFEDdgfFFFFFFEdgfgfbEEEEcdffdcEEEEbfgggdFFFFFFFfgeFFEaDEFEDceeFEFFFFFFFcgggfaEEEbeebEEEbfgggcFFFFFFFEFeedDEFFEDDEFFEDdedEEEFFFFFFcghggeEEEEeeEEEEegghgcFFFFFFFEEdedDEFFEDEFFEDdeeFEFFFFFFchihhgdEFEcggcFFEdghhhgcFFFFFFEEdecDFFFEDDEEFEDDceeFEEFFFFchiihhhecbegfggecbeghhhihcFFFFFFFefdDEFFEEDEFFEEDDdfeFEFFFFchhhiiihgghgGfgggghiiiiicFFFFFFefdEDEFFEDEEFFEDDdfeFEEFFchiiiiiiiihGhiiiiiiiihcFFFEFefdEDEFFEDDEEFFEDDEdfeFEEEehihhggghihGGhhiggghiiifFFFFefdEDEEFEEDBEEFFEEDDDEEdffFEEegfdbFFcfhghifcFFbdgigEFFffdEEEFFFEDBBDEFFFEDDEEdfeFbfdFFFFFFFeighheFFFFFFFGefcFffeEEEEFFEEDDADEEFFEDDDEEEegeaFEFFFFFFFFFfihfFFFFFFFFFFbegdEEEDEEFFEDΎDEEFFEEDEEEfgeFEEFFFFFFFFcggcFFFFFFFFFEFefeEEEEEFFFEEDC`DEFFEEDDDEEEEdffFEEEEFFFFFFffFFFFFFFFEEFffeEEEEDDEEFFEEDC`DEEFFEEEDDEEEEdfeFEEEEEEFFffGFFFFEEEEEffdEEEEEDEEFFFEDCDDEEEFFEEDDDEEEEdfeFEEEEEEEcggcEEEEEEEFefdEEEEEDDEFFFEEDCCDEEFFEEDDEEEEdfeFEEEEEcfggfcEEEEEFefeEEEEEDDDEEFFEEEDCCEEFFFEEDDDEEEEEdfeEEEEEcggcEEEEEefeEEEEEEDEEFFEEEDD`CDEEFFFEEDDDEEEEEefdEEEEEFeeFEEEEEdfdEEEEEDDDDEEEFFEEEDapCDEEFFEEEDDDDEEEEEefdEEEEedEEEEdfeEEEEEEDDEEFFEEEDDC`pCDDEEEFFFEEDDDEEEEEefeEEEEccEEEEdfeEEEEEDDDDEEEFFEEEDDCCDEEFFFEEEDDDDDEEEEEefeEEEaaEEEdeeEEEEEEDDDEEEFFEEEDCCDEEEFFEEEEDDDDDEEEEEefeEEaaEEeedEEEEEEDDDEEEFFEEEEDDraCDEEEFFFEEEDDDDDDEEEEEdfeEaaEdfdEEEEEEDDDDDEEFFFEEEEDC`CDEEEFFFEEEDDDDDEEEEEEdfeaaeedEEEEEDDDDEEEFFFEEEEDDC`qBCDEEEFFFFEEEDDDDDDEEEEdedefdEEEEEDDDDDDEEEFFFEEEEDCCDDEEEFFFEEEEDDDDDDDEEEEdeddEEEEDDDDDDEEEFFFEEEEDDC`CDEEEFFFEEEEEDDDDDDDDEccDDDDDDDDEEEEFFFEEEEDDDCaCCDEEEEFFFEEEEDDDDDDDDDDDDDDDDDDDDDDDDDEEEEFFFEEEEEDCCCCDEEEEFFFEEEEDDDDDDDDDDDDDDDDDDDDDDDEEEEFFFEEEEEDDCCCCDEEEEFFFEEEEEDDDDDDDDD`DDDDDDDDDEEEFFFFEEEEDDCCCCDEEEFFFFEEEEEDDDDa`DDDDEEEEFFFEEEEEDDC`CCCDEEEEFFFEEEEEDDDDEEEEFFFEEEEDDDCCCCCDDEEEEFFFFEEEEDDEEEFFFEEEEEDDC`CCDEEEFFFFEDaaDEFFFFEEEEDDCC`CCDEEEEFFED`$utuEEEEEEEDDCC`CCDDEEauaDEDDCC$CCCDDD`rt$raDDDDCCCt`C`atrurucHHHHHGGGHHIdHHHGGGHHHHHHGcEFEFFFFFEDGGGciicGGEDFFFFFFFFEEEEEEEFFgccgFFFEEEEEEFFEEEFGFFEEEEEaebEFeaEEEEFFFGFFEEEEFGGFFFFbeEEEEaeFFFFGFEFEEEFEFFGGGGchcFFFFFFcgcGGGGFEEFEEEFEEFFGcidgfGGGGfhdicGFFEEEFEEEEFEEEFchcciieGGeiicchEEEEFEEEEEEFFEEbfbchhheFFfghhbfaEEFFEEEEEFFbebbfgdFcFEcFcfebafbFFEFaDFDEFchbbfffFEEaaEEFfffcbgcFEFaDFbgcFEdffFEEddEEEfgdEFchbEEF`DFEaebFFFbgfFEaccaEFggFFFbeaEF`DEEadbEFFhgdEEddEEdhgFFFadaFE`aEFaebEFhihffeeffhhhFFbeaFE``EFEDaebEhhhhhGGhhhiicFbeaDEFE`CEFEDaebceFGefgeGFedbfaEEFCCEFEDEafbEFFFFffFFFFFbfaEFECCEFEDEaebEEFFccFFFEbfaEDEFED`CEFEDEaebEEFffFEEbeaEEDEFED`DEFEEDDEEaeaEEddEEaeaEEDEFFEDBDEFFEDDEEaeaEbbEaeaEEDEFEED``DEEFEEDDEEaeaFFaeaEEDDEEFED`DEFEEDDDEEaebbeaEEDDEFEEDDEFFEEDDDDEadeaEDDDEEFEECCEEFEEDDDDDaaDDDDDEEFFEEDCCDEEFFEEDDDDD`aDDDDEEFEEEDCCDEEFFEEDaDDEEFFEEDCCDEEFFEaaEFFEEDCDDEEEaEEEDDD``CGFHedGGFGGGEFEEEbccbFEEFFEEFccFFccEEEEEFdehhedFEFEEEFbcfeeecbFEEEcccfEaaEfcccEEEEcFGgGbbGgGFcEEEEbbGhheeghGcbEDEDbcFeeFcbEDDEbbEccEbbEEDCEEDEbbGGbbEDEE`CEFDEbbbbEDFE``EFEDDaaDDEE`EEEDDEFEDaDEEEEDtrigger    /???K@   @   (   (  (  (  uxutr
`
	u							
u			u
		`			!	uv		
	


	
		
	
ͫ
	
	vvu		

	v		v				t	
		

u		
tέ				
	
	
			
3	

	

		`3			t		`
		

		8
		

	
		7	
		


				
			

r	uu


	s	

		
				#s
			
t	

	r	
		


auuursecop1_1     ???K@   @   (   (  (  (  bbbνbbbbbb5bbbbbbbbbbbrbbbbbbbbbbbbbbbbbbμbbbbbbbbbbbbbbb5b`έbbbbaabbbbbbb!έbbbabbbbaca!bcbbbbbb`bbbcbbbaabbbaaabrbbbabccbbbaabrabbbbbrcabbbbadbbb`bac`bbaabbbabbrbrb`baqbrbab``b4b4bbaaaqbbaabbcrέabbbqbbaaabcbbbaabab`bbbaac`babbb#bbb``bbba`baaacbabrbrbbbbbbbcbbbbbabaabbaaaabbbbbbbbbccSbacaέba`abbaba`Sbb`bb`aab`a`ba`Sbb5bb`bbbbc`b``aacrcab`aSbcbb4bbbababaaabaabaaaa`abSbcbέbb``aaabaaa`abbbbbbbbbbba4aa`bccbbμbbbbcbQaab`cbbbbrbb`Qbb`cλbbbbcc`aab``bb4#bbrbbcaababbbbcdbccbbbbcbaaa`bbccbbbbbbbbcbba`abbbbabbμaaabbcccbbbbaaabcabbbbaaabbb#bcbbbb``babbbaabcb``bbabbbbbbbbbbbbbbca`bbacbbbbb!b`baabbbbbbέbaaaba4baaaaac`#bd`bbaaaababb`bb`bb``baaaabaaaabbbbabbbbbbb`b``baaaabbbcaa`bba``baabbacaa5bababaaba`bbbaaμab`ba`bb``a``bbb`bbνac`babb``abbaabb`a``aaa`4barbb4aabab!bab4ab`bcabbababbbabbbba`bac`bbrabbbbaaa`babbbbacbb`aabbbrbbbbcbba`aaabμbbbbb4bcbbbbcbbbbabbabbbab`bcba``aaabbbέbbabbbbb`abcbcca`ababaabbb`accacbbrabbba`aaaabbabbbrba`baba!bacrabbb`4bba`bbrbbba`bbbbcca`bbbbabbbbbabbbab4bbb`aaabbbbbba`bcbbb4c``bbaarccbbbbb`bbbebbbbbb`brtbbbcbc`aμ4bbbbacbbbbsrrbcbbbb``bbbbbbbbbcrbbrrbcea`b```a4bbbbr#b`bbbbbaa`a`abbbbbbbbbbba`bbbb4bbbbbbbab`bbbbbrbbbbbbbbbbbbbbbbbrarr`braa`brarabbbrarbaaarbbaba``abaraararbaraarararabaaabbarab`bar5brbrbaa`aab6arb`aasabra4aabarbbb`ab`!rbrbaarbbbabraarabrrrraaarrrr`abarrraabaaarrraaa`baaaa``b`baaaara`a`raabarbarabbaabrra`bcaaar`ba``b4rabbaarbraaabrb͍raasbbr`bbbba`arararabasa͍rrararararr`aar`baraabr`araarbr`raarrab`rr`rrraarr                                                                                                                                                                                                                                                                                                                                                                                                                     ֍UERMPQ\K  =@ ЍM׋4@ MӺ >@ ME   ֍UERMPQ"K  ЍM׍MӺ >@ ME   ֍UERMPQJ  ЍM׍MӍU܍ERMPQE     M@ UR8@  @ fZ@ EPxJ  fX@ 3MUQR}   M@ }h9o@ *EЍMPUQRj@ M0@ M@ Ë54@ M֍M֍M֍MËEPQME_^d
    [] Uh@ d    Pd%    ESV$WeE@ PMEREE    PQ;  M@ E    ho@ 
M@ ËEPQME_^d
    [] Uh@ d    Pd%    LESV$WeE@ PMER @ 3;ǉ}}}}Љ}uh @ h<8@ @ 5 @ MQVP;}jh,8@ VP@ E]S
   8ܹ PUĉSKM̉KW\3;}j\h:@ VP@ UM}@ UERMPQE     M4@ M0@ M@ }h3q@ &UERPj@ M0@ M@ ËEPQME_^d
    [] Uh@ d    Pd%    ESV$WeE@ PMER@ E    EPQME_^d
    [] Uh@ d    Pd%    ESV$WeE@ PMERf|@ E    f=< }Wf@   =rX@ p@ Qhd7@ \@ t)f|@ EfBh|@ pWPf|@   M@ f$@ E    hr@ 
M@ ËEPQME_^d
    [] @ Uh@ d    Pd%    SVuWƃe>E@ VEuW|  3VEEӍMPQ$@ EPWRh}jhh8@ WP@ 3f9MًM0@ fVtӍUPR$@ jWPl},ӍMPQ$@ j WRl}jlh8@ WP@ M0@ VPEP$@ URVQh}jhh8@ VP@ fEMf@ 0@ E    h t@ 
M0@ ËEPQME_^d
    [] Uh@ d    Pd%       ESV$WeE@ PMER3PPPuuuu܉u؉uԉuЉủuȉuĉuuuuuuudǅP     =@ ЍM׋@ jMjUQRE E
   EZ@ E@  ӋЍMjEjdPQE E
   ǅlX@ ǅd@  ӋЍMס@ ;uh@ h@$@ @ @ P   PEP$@ |7@ M@ MEU@Muu<u׋@ Ph >@ ӋЍM׋@PMPӋЍMPh >@ ӋЍM׋<PMPӋЍM׋=@ >@ M׺,>@ M׍MUQERMPUQRSF  EMPUQERMPUQREЍMPUQERMPUQERPj
@ 8M0@ MUQRj@ uhv@ \EMPUQERMPUQERMPUQERMPUQERPj
@ 8M0@ MUQRj@ ËEPQME_^d
    [] Uh@ d    Pd%    SVuWƃe>E(@ VEuWx  3VEEӍMPQ$@ EPWRh}jhh8@ WP@ 3f9MًM0@ fVtӍUPR$@ jWPl},ӍMPQ$@ j WRl}jlh8@ WP@ M0@ VPEP$@ URVQh}jhh8@ VP@ fEMf@ 0@ E    h@x@ 
M0@ ËEPQME_^d
    [] Uh@ d    Pd%    SVuWƃe>E8@ VEuWH  3VEEӍMPQ$@ EPWRh}jhh8@ WP@ 3f9MًM0@ fVtӍUPR$@ jWPl},ӍMPQ$@ j WRl}jlh8@ WP@ M0@ VPEP$@ URVQh}jhh8@ VP@ fEMf~@ 0@ f$@ E    hy@ 
M0@ ËEPQME_^d
    [] Uh@ d    Pd%    ESV$WeEH@ PMERf|@ E    f~!fHh|@ pYf|@ EP  M@ f$@ E    hdz@ 
M@ ËEPQME_^d
    [] @ Uh@ d    Pd%     SVuWƃe>EX@ VEuW]U3QREE@ E؍MPQ@ P8@  @ Mf`@ 4@ M@ f;u!V8  }@ h8  h2@ VP@ Uf:$uV$  }h$  h2@ VPӋEf8!uVP  }hP  h2@ VPӋMf9"uV<  }h<  h2@ VPӋUf:#uV(  }h(  h2@ VPӋEf8ufMf9XuV  }h  h2@ VPӋUf