#include <foundation.h>
#include <kernel/timer.h>

#include "aes.h"
#include <string.h>

static void example_aes()
{
	struct AES_ctx ctx;
	uint8_t key[] = { 0x7F, 0xDA, 0x3A, 0x93, 0x53, 0x01, 0x5F, 0x48, 0x7C, 0x63, 0x4F, 0x87, 0xA2, 0x02, 0x02, 0x52 };
	uint8_t iv[]  = { 0x49, 0x97, 0x89, 0x0D, 0x0D, 0xE7, 0x75, 0x9F, 0xE7, 0x17, 0x9A, 0x7E, 0x56, 0xA0, 0xFE, 0xDF };
	/* Plain text: Hello, World! */
	uint8_t in[]  = { 0x79, 0x69, 0xb8, 0xd1, 0x19, 0x68, 0xd3, 0xeb, 0xa0, 0x94, 0x1a, 0x12, 0xf9, 0xf7, 0xc5, 0x70 };

	AES_init_ctx_iv(&ctx, key, iv);
	AES_CBC_decrypt_buffer(&ctx, in, 16);

	sleep(2);
	printk("AES CBC decrypt:");
	for (int i = 0; i < 16; i++) {
		if (!(i % 16))
			printk("\n");
		printk("%02x ", in[i]);
	}
	putchar('\n');
}
REGISTER_TASK(example_aes, 0, DEFAULT_PRIORITY, STACK_SIZE_DEFAULT);
