---
title: Terms of Service
---

Effective date: **October 22, 2024**

Thank you for using onetimesecret.com! We're happy you're here. Please read this Terms of Service agreement carefully before accessing or using onetimesecret.com. Because it is such an important contract between us and our users, we have tried to make it as clear as possible. For your convenience, we have presented these terms in a short non-binding summary followed by the full legal terms.

## Summary

| Section | What can you find there? |
| --- | --- |
| [A. Definitions](#a-definitions) | Some basic terms, defined in a way that will help you understand this agreement. Refer back up to this section for clarification. |
| [B. Account Terms](#b-account-terms) | These are the basic requirements of having an account on onetimesecret.com.  |
| [C. Acceptable Use](#c-acceptable-use)| These are the basic rules you must follow when using your onetimesecret.com account. |
| [D. User-Generated Content](#d-user-generated-content) | You own the content you post on onetimesecret.com. However, you have some responsibilities regarding it, and we ask you to grant us some rights so we can provide services to you. |
| [E. Applications](#applications) | This section talks about how onetimesecret.com will treat content you store for your applications. |
| [F. Copyright & DMCA Policy](#f-copyright-infringement-and-dmca-policy) | This section talks about how onetimesecret.com will respond if you believe someone is infringing your copyrights on onetimesecret.com. |
| [G. Intellectual Property Notice](#g-intellectual-property-notice) | This describes onetimesecret.com's rights in the website and service. |
| [H. API Terms](#h-api-terms) | These are the rules for using onetimesecret.com's APIs, whether you are using the API for development or data collection. |
| [I. Payment](#i-payment) | You are responsible for payment. We are responsible for billing you accurately. |
| [J. Cancellation and Termination](#j-cancellation-and-termination) | You may cancel this agreement and close your account at any time. |
| [K. Communications with onetimesecret.com](#k-communications-with-onetimesecret.com) | We only use email and other electronic means to stay in touch with our users. We do not provide phone support. |
| [L. Disclaimer of Warranties](#l-disclaimer-of-warranties) | We provide our service as is, and we make no promises or guarantees about this service. **Please read this section carefully; you should understand what to expect.** |
| [M. Limitation of Liability](#m-limitation-of-liability) | We will not be liable for damages or losses arising from your use or inability to use the service or otherwise arising under this agreement. **Please read this section carefully; it limits our obligations to you.** |
| [N. Release and Indemnification](#n-release-and-indemnification) | You are fully responsible for your use of the service. |
| [O. Changes to these Terms of Service](#o-changes-to-these-terms) | We may modify this agreement, but we will give you 30 days' notice of changes that affect your rights. |
| [P. Miscellaneous](#p-miscellaneous) | Please see this section for legal details including our choice of law. |


## A. Definitions
**Short version:** *We use these basic terms throughout the agreement, and they have specific meanings. You should know what we mean when we use each of the terms. There's not going to be a test on it, but it's still useful information.*

1. The "Agreement" refers, collectively, to all the terms, conditions, notices contained or referenced in this document (the "Terms of Service" or the "Terms") and all other operating rules, policies (including the onetimesecret.com Privacy Statement, available at [onetimesecret.com/docs/privacy/](https://onetimesecret.com/site/privacy)) and procedures that we may publish from time to time on the Website.
2. The "Service" refers to the applications, software, products, and services provided by onetimesecret.com.
3. The "Website" refers to onetimesecret.com's website located at [onetimesecret.com](https://onetimesecret.com/), and all content, services, and products provided by onetimesecret.com at or through the Website. It also refers to onetimesecret.com-owned subdomains of onetimesecret.com, such as eu.onetimesecret.com and us.onetimesecret.com, which represent our European Union and United States data centers respectively. To protect against denial-of-service attacks and ensure service availability, we utilize CloudFlare's services for DDoS protection and content delivery. All traffic to onetimesecret.com and its subdomains (including eu.onetimesecret.com and us.onetimesecret.com) passes through CloudFlare's infrastructure by default. Users on our Global Elite plan have the option to bypass CloudFlare if requested, though this may impact service availability during attacks. These Terms also govern onetimesecret.com's product websites, such as [onetime.co](https://onetime.co/) and [onetime.dev](https://onetime.dev/). Occasionally, websites owned by onetimesecret.com may provide different or additional terms of service. If those additional terms conflict with this Agreement, the more specific terms apply to the relevant page or service.
4. "The User", "You", and "Your" refer to the individual person, company, or organization that has visited or is using the Website or Service; that accesses or uses any part of the account; or that directs the use of the account in the performance of its functions. A User must be at least 13 years of age.
5. "onetimesecret.com", "We", and "Us" refer to onetimesecret.com, as well as our affiliates, directors, subsidiaries, contractors, licensors, officers, agents, and employees.
6. "Content" refers to content featured or displayed through the Website, including without limitation text, data, articles, images, photographs, graphics, software, applications, designs, features, and other materials that are available on the Website or otherwise available through the Service. "Content" also includes Services. "User-Generated Content" is Content, written or otherwise, created or uploaded by our Users. "Your Content" is Content that you create or own.

## B. Account Terms
**Short version:** *A human must create your account; you must be 13 or over; you must provide a valid email address; and you may not have more than one trial account. You alone are responsible for your account and anything that happens while you are signed in to or using your account. You are responsible for keeping your account secure.*

### 1. Required Information
You must provide a valid email address in order to complete the signup process. Any other information requested, such as your real name, is optional, unless you are accepting these terms on behalf of a legal entity (in which case we need more information about the legal entity) or if you opt for a [paid account](#i-payment), in which case additional information will be necessary for billing purposes.

When creating an account, you will be asked to select your preferred data center region (European Union or United States). This selection determines where your data will be stored and processed. You can access your account through eu.onetimesecret.com or us.onetimesecret.com based on your selected region.

### 2. Account Requirements
We have a few simple rules for accounts on onetimesecret.com's Service.
- You must be a human to create an account. Accounts registered by "bots" or other automated methods are not permitted. We do permit machine accounts:
- A machine account is an account set up by an individual human who accepts the Terms on behalf of the account, provides a valid email address, and is responsible for its actions. A machine account is used exclusively for performing automated tasks. Multiple users may direct the actions of a machine account, but the owner of the account is ultimately responsible for the machine's actions. You may maintain no more than one free machine account.
- You may not maintain more than one free personal account.
- You must be age 13 or older. onetimesecret.com does not target our Service to children under 13, and we do not permit any Users under 13 on our Service. If we learn of any User under the age of 13, we will [terminate that User's account immediately](#j-cancellation-and-termination). If you are a resident of a country outside the United States, your country's minimum age may be older; in such a case, you are responsible for complying with your country's laws.
- Your login is intended for individual use and should not be shared among multiple people. This ensures secure use of our services and proper delivery of account-specific features. Paid organization accounts can request additional user accounts be associated with their custom domain(s). The number of separate logins allowed is determined by the subscription level. These additional accounts can be used by multiple people (like a team) with the understanding that all users of the shared account will have the same access to information within that account.
- Overall, the number of Users must not exceed the number of accounts you've ordered from us.

### 2.1 Data Retention and Security

We take your privacy and security seriously. The following policies govern how we handle your data:

- IP Address Retention: We retain IP addresses associated with service usage for a maximum of 30 days, after which they are permanently deleted from our systems.

- Secret Retrieval: Due to our security-first design, it is not possible for us to retrieve or recover secrets once they have been accessed or expired, except as outlined regarding backups. This ensures that your sensitive information remains truly private and temporary.

- Backups: We maintain encrypted backups of our databases for disaster recovery purposes. These backups are retained for a maximum of 14 days, after which they are permanently deleted on a rolling basis. When a secret is received or expires, it is immediately removed from the database. However, encrypted secrets can still exist in backups after they have been deleted from the database. These backups are stored in a secure, isolated environment and are only accessible by authorized personnel. We access backup files in only two scenarios:
  1. To restore service in the event of a catastrophic failure
  2. To test the integrity of the backups for the whole system

  We do not access backup files to retrieve individual secrets.



### 3. User Account Security
You are responsible for keeping your account secure while you use our Service. We offer tools such as two-factor authentication to help you maintain your account's security, but the content of your account and its security are up to you.
- You are responsible for all content posted and activity that occurs under your account (even when content is posted by others who have accounts under your account).
- You are responsible for maintaining the security of your account and password. onetimesecret.com cannot and will not be liable for any loss or damage from your failure to comply with this security obligation.
- You will promptly [notify onetimesecret.com](https://onetimesecret.com/contact) if you become aware of any unauthorized use of, or access to, our Service through your account, including any unauthorized use of your password or account.

### 4. Additional Terms
In some situations, third parties' terms may apply to your use of onetimesecret.com. For example, you may be a member of an organization on onetimesecret.com with its own terms or license agreements; you may download an application that integrates with onetimesecret.com; or you may use onetimesecret.com to authenticate to another service. Please be aware that while these Terms are our full agreement with you, other parties' terms govern their relationships with you.

## C. Acceptable Use
**Short version:** *onetimesecret.com hosts a wide variety of collaborative projects from all over the world, and that collaboration only works when our users are able to work together in good faith. While using the service, you must follow this Acceptable Use Policy, which includes some restrictions on content you can post, conduct on the service, and other limitations. In short, be excellent to each other.*

### 1. Compliance with Laws and Regulations
Your use of the Website and Service must not violate any applicable laws, including copyright or trademark laws, export control laws, or other laws in your jurisdiction. You are responsible for making sure that your use of the Service is in compliance with laws and any applicable regulations.

### 2. Content Restrictions
You agree that you will not under any circumstances upload, post, host, or transmit any content that:

- is unlawful or promotes unlawful activities;
- is or contains sexually obscene content;
- is libelous, defamatory, or fraudulent;
- is discriminatory or abusive toward any individual or group;
- contains or installs any active malware or exploits, or uses our platform for exploit delivery (such as part of a command and control system); or
- infringes on any proprietary right of any party, including patent, trademark, trade secret, copyright, right of publicity, or other rights.

### 3. Conduct Restrictions
While using onetimesecret.com, you agree that you will not under any circumstances:
- harass, abuse, threaten, or incite violence towards any individual or group, including onetimesecret.com employees, officers, and agents, or other onetimesecret.com Users;
- use our servers for any form of excessive automated bulk activity (for example, spamming), or relay any other form of unsolicited advertising or solicitation through our servers, such as get-rich-quick schemes;
- attempt to disrupt or tamper with onetimesecret.com's servers in ways that could harm our Website or Service, to place undue burden on onetimesecret.com's servers through automated means, or to access onetimesecret.com's Service in ways that exceed your authorization);
- impersonate any person or entity, including any of our employees or representatives, including through false association with onetimesecret.com, or by fraudulently misrepresenting your identity or site's purpose; or
- violate the privacy of any third party, such as by posting another person's personal information without consent.

### 4. Services Usage Limits
You agree not to reproduce, duplicate, copy, sell, resell or exploit any portion of the Service, use of the Service, or access to the Service without onetimesecret.com's express written permission.

### 5. Scraping
Scraping refers to extracting data from our Website via an automated process, such as a bot or webcrawler. It does not refer to the collection of information through onetimesecret.com's API. Please see [Section H](#h-api-terms) for our API Terms. You may scrape the website for the following reasons:
- Researchers may scrape public, non-personal information from onetimesecret.com for research purposes, only if any publications resulting from that research are open access.
- Archivists may scrape onetimesecret.com for public data for archival purposes.

You may not scrape onetimesecret.com for spamming purposes, including for the purposes of selling onetimesecret.com users' personal information, such as to recruiters, headhunters, and job boards.

All use of onetimesecret.com data gathered through scraping must comply with the [onetimesecret.com Privacy Statement](https://onetimesecret.com/site/privacy/).

### 6. Privacy
Misuse of onetimesecret.com Users' Personal Information is prohibited.

Any person, entity, or service collecting data from onetimesecret.com must comply with the [onetimesecret.com Privacy Statement](https://onetimesecret.com/site/privacy/), particularly in regards to the collection of our Users' Personal Information (as defined in the onetimesecret.com Privacy Statement). If you collect any onetimesecret.com User's Personal Information from onetimesecret.com, you agree that you will only use the Personal Information you gather for the purpose for which our User has authorized it. You agree that you will reasonably secure any Personal Information you have gathered from onetimesecret.com, and you will respond promptly to complaints, removal requests, and "do not contact" requests from onetimesecret.com or onetimesecret.com Users.

### 7. Excessive Use on Free Services
_For free onetimesecret.com services:_ If we determine your usage to be significantly excessive in relation to other onetimesecret.com customers, we reserve the right to suspend your account or throttle your service until you can reduce your bandwidth consumption.

### 8. User Protection
You agree not to engage in activity that significantly harms our Users. We will resolve disputes in favor of protecting our Users as a whole.

## D. User-Generated Content
**Short version:** *You own content you create, but you allow us certain rights to it, so that we can display and share the content you post. You still have control over your content, and responsibility for it, and the rights you grant us are limited to those we need to provide the service. We have the right to remove content or close accounts if we need to.*

### 1. Responsibility for User-Generated Content
You may create or upload User-Generated Content while using the Service. You are solely responsible for the content of, and for any harm resulting from, any User-Generated Content that you post, upload, link to or otherwise make available via the Service, regardless of the form of that Content. We are not responsible for any public display or misuse of your User-Generated Content.

### 2. onetimesecret.com May Remove Content
We do not pre-screen User-Generated Content, but we have the right (though not the obligation) to refuse or remove any User-Generated Content that, in our sole discretion, violates any onetimesecret.com terms or policies.

### 3. Ownership of Content, Right to Post, and License Grants
You retain ownership of and responsibility for Content you create or own ("Your Content"). If you're posting anything you did not create yourself or do not own the rights to, you agree that you are responsible for any Content you post; that you will only submit Content that you have the right to post; and that you will fully comply with any third party licenses relating to Content you post.

Because you retain ownership of and responsibility for Your Content, we need you to grant us — and other onetimesecret.com Users — certain legal permissions, listed in Sections D.4 — D.7. These license grants apply to Your Content. If you upload Content that already comes with a license granting onetimesecret.com the permissions we need to run our Service, no additional license is required. You understand that you will not receive any payment for any of the rights granted in Sections D.4 — D.7. The licenses you grant to us will end when you remove Your Content from our servers, unless other Users have forked it.

### 4. License Grant to Us
We need the legal right to do things like host Your Content, publish it, and share it. You grant us and our legal successors the right to store, parse, and display Your Content, and make incidental copies as necessary to serve application requests and provide the Service. This includes the right to do things like copy it to our database and make backups; show it to you and other users; parse it into a search index or otherwise analyze it on our servers; share it with other users; and perform it, in case Your Content is something like music or video.

This license does not grant onetimesecret.com the right to sell Your Content or otherwise distribute or use it outside of our provision of the Service.

### 5. License Grant to Other Users
Any Content you share with other users through the Service may be viewed, copied, and used by those users for collaboration purposes. You hereby grant to other users a non-exclusive, royalty-free, non-transferable license, with no right to sub-license, to use, display, perform, reproduce, modify, publish, distribute, list information regarding, edit, translate and analyze such Content as permitted by the relevant onetimesecret.com Services functionality or features for the sole purpose of collaboration.

### 6. Moral Rights
You retain all moral rights to Your Content that you upload, publish, or submit to any part of the Service, including the rights of integrity and attribution. However, you waive these rights and agree not to assert them against us, to enable us to reasonably exercise the rights granted in Section D.4, but not otherwise.

To the extent this agreement is not enforceable by applicable law, you grant onetimesecret.com the rights we need to use Your Content without attribution and to make reasonable adaptations of Your Content as necessary to render the Website and provide the Service.

### 7. Feedback
- Feedback is kept confidential and not shared with other Users or third parties. We use Feedback to improve our Services and provide better features. We treat all feedback like email communication. For example, we may delete feedback from our system after we have reviewed it, but it may still be stored in our backups or email archives.
- We do not reply to all feedback, but we do read it. For non-authenticated accounts, unless you provide an email address, we have no way to contact you about your feedback. For authenticated accounts, we may reply to your feedback using the email address associated with your account.
- Similar Features: We may be developing features similar to the ones you suggest through Feedback, or may decide to do so in the future. By submitting Feedback, you acknowledge and agree that:
  1. We may have similar features under development or may develop them in the future;
  2. We have no obligation to inform you of such similar features;
  3. We are free to use our own similar ideas, features, or functionality without any obligation to you.


## E. Applications
**Short version:** *You may have access to applications. We treat the content of applications as confidential, and we only access it for support reasons, with your consent, or if required to for security reasons.*

### 1. Control of Applications
Accounts may have applications, which allow the User to control access to Content.

### 2. Confidentiality of Applications.
onetimesecret.com considers the contents of private applications to be confidential to you. onetimesecret.com will protect the contents of private applications from unauthorized use, access, or disclosure in the same manner that we would use to protect our own confidential information of a similar nature and in no event with less than a reasonable degree of care.

### 3. Access.
onetimesecret.com employees may only access the content of your private applications in the following situations:
- With your consent and knowledge, for support reasons. If onetimesecret.com accesses an application for support reasons, we will only do so with the owner's consent and knowledge.
- When access is required for security reasons.

You may choose to enable additional access to your applications. For example:
- You may enable various onetimesecret.com services or features that require additional rights to Your Content in applications. These rights may vary depending on the service or feature, but onetimesecret.com will continue to treat your private application Content as confidential. If those services or features require rights in addition to those we need to provide the onetimesecret.com Service, we will provide an explanation of those rights.
- You may also grant a third-party application authorization to use, access, and disclose the contents of your applications. Your use of third-party applications is at your sole risk; onetimesecret.com is not liable for disclosures to third parties that you authorize to access a private application.

### 4. Exclusions.
If we have reason to believe the contents of an application are in violation of the law or of these Terms, we have the right to access, review, and remove them. Additionally, we may be [compelled by law](/info/privacy/#how-we-respond-to-compelled-disclosure) to disclose the contents of your applications.

## F. Copyright Infringement and DMCA Policy
If you believe that content on our website violates your copyright, please contact us by emailing support@onetimesecret.com. If you are a copyright owner and you believe that content on onetimesecret.com violates your rights, please contact us. There may be legal consequences for sending a false or frivolous takedown notice. Before sending a takedown request, you must consider legal uses such as fair use and licensed uses.

We will terminate the accounts of [repeat infringers](#e-repeated-infringement) of this policy.

## G. Intellectual Property Notice
**Short version:** *We own the service and all of our content. In order for you to use our content, we give you certain rights to it, but you may only use our content in the way we have allowed.*

### 1. onetimesecret.com's Rights to Content
onetimesecret.com and our licensors, vendors, agents, and/or our content providers retain ownership of all intellectual property rights of any kind related to the Website and Service. We reserve all rights that are not expressly granted to you under this Agreement or by law. The look and feel of the Website and Service is copyright © onetimesecret.com. All rights reserved. You may not duplicate, copy, or reuse any portion of the HTML/CSS, Javascript, or visual design elements or concepts without express written permission from onetimesecret.com.


### 2. onetimesecret.com Trademarks and Logos

The following variations of our name and logo are protected trademarks of onetimesecret.com:

- "Onetime Secret"
- "OnetimeSecret"
- "OneTime Secret"
- "OneTimeSecret"
- "Onetime.co"
- "Onetime.dev"

Use of any of our trademarks must adhere to our trademark guidelines. Any use that may cause confusion among customers or that disparages or discredits onetimesecret.com is prohibited. All other trademarks, product names, company names, and logos mentioned on the Website are the property of their respective owners. Reference to any products, services, processes, or other information by trade name, trademark, manufacturer, supplier, or otherwise does not constitute or imply endorsement, sponsorship, or recommendation by onetimesecret.com.


### 3. License to onetimesecret.com Policies
This Agreement is licensed under this [Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/). For details, see our [site-policy repository](https://github.com/onetimesecret/site-policy).

## H. API Terms
**Short version:** *You agree to these Terms of Service, plus this Section H, when using any of onetimesecret.com's APIs (Application Programming Interface), including use of the API through a third party product that accesses onetimesecret.com.*

### No Abuse or Overuse of the API
Abuse or excessively frequent requests to onetimesecret.com via the API may result in the temporary or permanent suspension of your account's access to the API. onetimesecret.com, in our sole discretion, will determine abuse or excessive usage of the API. We will make a reasonable attempt to warn you via email prior to suspension.

You may not share API tokens to exceed onetimesecret.com's rate limitations.

All use of the onetimesecret.com API is subject to these Terms of Service and the [onetimesecret.com Privacy Statement](https://onetimesecret.com/info/privacy/).

onetimesecret.com may offer subscription-based access to our API for those Users who require high-throughput access or access that would result in resale of onetimesecret.com's Service.

## I. Payment
**Short version:** *You are responsible for any fees associated with your use of onetimesecret.com. We are responsible for communicating those fees to you clearly and accurately, and letting you know well in advance if those prices change.*

### 1. Pricing
Our pricing and payment terms are available at [onetimesecret.com/pricing](https://onetimesecret.com/pricing/). If you agree to a subscription price, that will remain your price for the duration of the payment term; however, prices are subject to change at the end of a payment term.

### 2. Upgrades, Downgrades, and Changes
- We will immediately bill you when you provision a paid service, once any applicable "free trial" period expires.
- If you change from a monthly billing plan to a yearly billing plan, onetimesecret.com will bill you for a full year at the next monthly billing date.
- If you upgrade to a higher level of service, we will bill you for the upgraded plan immediately.
- You may change your level of service at any time by logging in and [modifying paid services](https://onetimesecret.com/account/) from your account or organization. If you choose to remove paid services, you may lose access to Content, features, or capacity of your account. Please see our section on [Cancellation](#j-cancellation-and-termination) for information on getting a copy of that Content.

### 3. Billing Schedule; No Refunds
- For monthly or yearly payment plans, the Service is billed in advance on a monthly or yearly basis respectively and is non-refundable. There will be no refunds or credits for partial months of service, downgrade refunds, or refunds for months unused with an open account; however, the service will remain active for the length of the paid billing period.
- In order to treat everyone equally, no exceptions will be made.

### 4. Authorization
By agreeing to these Terms, you are giving us permission to charge your on-file credit card, or other approved methods of payment for fees that you authorize for onetimesecret.com.

### 5. Responsibility for Payment
You are responsible for all fees, including taxes, associated with your use of the Service. By using the Service, you agree to pay onetimesecret.com any charge incurred in connection with your use of the Service.  If you dispute the matter, contact [onetimesecret.com Support](https://onetimesecret.com/docs/support/). You are responsible for providing us with a valid means of payment for paid accounts.

### 6. Payment Processing
- Payment Processing Service: We use Stripe.com as our payment processor. When you provide your payment information, you are providing it directly to Stripe.com, which operates under its own privacy policy and terms of service.
- Monthly Billing Cycle: We bill monthly based on the day you first signed up for a paid account. Your "billing day" is the day of the month that your first payment was processed. If you change your plan, your billing day will reset to the day of the month that you made the change.
- Credit Card Information: We do not store your complete credit card information on our servers. This information is securely stored by Stripe.com in accordance with PCI compliance standards. We only retain a payment token that allows us to process recurring charges to your card.

-
## J. Cancellation and Termination
**Short version:** *You may close your account at any time. If you do, we'll treat your information responsibly.*

### 1. Account Cancellation
It is your responsibility to properly cancel your account with onetimesecret.com. You can cancel your account at any time by emailing support@onetimesecret.com.

### 2. Upon Cancellation
We will retain and use your information as necessary to comply with our legal obligations, resolve disputes, and enforce our agreements, but barring legal requirements, we will delete your full profile and the Content of your applications within 90 days of cancellation or termination (though some information may remain in encrypted backups). This information can not be recovered once your account is cancelled.

We will not delete Content that you have contributed to other Users' applications.

Upon request, we will make a reasonable effort to provide an account owner with a copy of your lawful, non-infringing account contents after account cancellation, termination, or downgrade. You must make this request within 90 days of cancellation, termination, or downgrade.

### 3. onetimesecret.com May Terminate
onetimesecret.com has the right to suspend or terminate your access to all or any part of the Website at any time, with or without cause, with or without notice, effective immediately. onetimesecret.com reserves the right to refuse service to anyone for any reason at any time.

### 4. Survival
All provisions of this Agreement which by their nature should survive termination will survive termination, including, without limitation, ownership provisions, warranty disclaimers, indemnity, and limitations of liability.

## K. Communications with onetimesecret.com
**Short version:** *We use email and other electronic means to stay in touch with our users.*

### 1. Electronic Communication Required
For contractual purposes, you (1) consent to receive communications from us in an electronic form via the email address you have submitted or via the Service; and (2) agree that all Terms of Service, agreements, notices, disclosures, and other communications that we provide to you electronically satisfy any legal requirement that those communications would satisfy if they were on paper. This section does not affect your non-waivable rights.

### 2. Legal Notice to onetimesecret.com Must Be in Writing
Communications made through email or onetimesecret.com Support's messaging system will not constitute legal notice to onetimesecret.com or any of its officers, employees, agents or representatives in any situation where notice to onetimesecret.com is required by contract or any law or regulation. Legal notice to onetimesecret.com must be in writing.

### 3. No Phone Support
onetimesecret.com only offers support via email, in-Service communications, and electronic messages. We do not offer telephone support.

## L. Disclaimer of Warranties
**Short version:** *We provide our service as is, and we make no promises or guarantees about this service. Please read this section carefully; you should understand what to expect.*

onetimesecret.com provides the Website and the Service "as is" and "as available," without warranty of any kind. Without limiting this, we expressly disclaim all warranties, whether express, implied or statutory, regarding the Website and the Service including without limitation any warranty of merchantability, fitness for a particular purpose, title, security, accuracy and non-infringement.

onetimesecret.com does not warrant that the Service will meet your requirements; that the Service will be uninterrupted, timely, secure, or error-free; that the information provided through the Service is accurate, reliable or correct; that any defects or errors will be corrected; that the Service will be available at any particular time or location; or that the Service is free of viruses or other harmful components. You assume full responsibility and risk of loss resulting from your downloading and/or use of files, information, content or other material obtained from the Service.

## M. Limitation of Liability
**Short version:** *We will not be liable for damages or losses arising from your use or inability to use the service or otherwise arising under this agreement. Please read this section carefully; it limits our obligations to you.*

You understand and agree that we will not be liable to you or any third party for any loss of profits, use, goodwill, or data, or for any incidental, indirect, special, consequential or exemplary damages, however arising, that result from

- the use, disclosure, or display of your User-Generated Content;
- your use or inability to use the Service;
- any modification, price change, suspension or discontinuance of the Service;
- the Service generally or the software or systems that make the Service available;
- unauthorized access to or alterations of your transmissions or data;
- statements or conduct of any third party on the Service;
- any other user interactions that you input or receive through your use of the Service; or
- any other matter relating to the Service.

Our liability is limited whether or not we have been informed of the possibility of such damages, and even if a remedy set forth in this Agreement is found to have failed of its essential purpose. We will have no liability for any failure or delay due to matters beyond our reasonable control.

## N. Release and Indemnification
**Short version:** *You are responsible for your use of the service. If you harm someone else or get into a dispute with someone else, we will not be involved.*

If you have a dispute with one or more Users, you agree to release onetimesecret.com from any and all claims, demands and damages (actual and consequential) of every kind and nature, known and unknown, arising out of or in any way connected with such disputes.

You agree to indemnify us, defend us, and hold us harmless from and against any and all claims, liabilities, and expenses, including attorneys' fees, arising out of your use of the Website and the Service, including but not limited to your violation of this Agreement, provided that onetimesecret.com (1) promptly gives you written notice of the claim, demand, suit or proceeding; (2) gives you sole control of the defense and settlement of the claim, demand, suit or proceeding (provided that you may not settle any claim, demand, suit or proceeding unless the settlement unconditionally releases onetimesecret.com of all liability); and (3) provides to you all reasonable assistance, at your expense.

## O. Changes to These Terms
**Short version:** *We want our users to be informed of changes to our terms, but some changes aren't that important — we don't want to bother you every time we fix a typo. So while we may modify this agreement at any time, we will notify users of any substantial changes by email or by posting a prominent notice on our pages. If you continue to use the Website after any amendments are posted, you will be deemed to have accepted the changes.*


We may modify these Terms of Use from time to time and will post a copy of the amended Terms on the Website. We encourage you to review them periodically. If we make any substantial changes to the Terms of Use, we will notify you by sending a notice to the email address associated with your account or by posting a prominent notice on our pages. If you do not agree to, or cannot comply with, the amended Terms of Use, you are not authorized to use the Website. Your continued use of the Website after any amendments are posted will be deemed acceptance of the amended Terms of Use.

We reserve the right to refuse our Services to anyone at any time. Additionally, we reserve the right to modify or discontinue, temporarily or permanently, the Website (or any part of it) at any time, with or without notice.


## P. Miscellaneous

### 1. Governing Law
Except to the extent applicable law provides otherwise, this Agreement between you and onetimesecret.com, as well as any access to or use of the Website or the Service, are governed by the laws of the Province of British Columbia, Canada. You and onetimesecret.com agree to submit to the exclusive jurisdiction and venue of the courts located in Vancouver, British Columbia. This Agreement expressly excludes any rules of private international law or the conflict of laws that would lead to the application of any other laws.


### 2. Non-Assignability
onetimesecret.com may assign or delegate these Terms of Service and/or the [onetimesecret.com Privacy Statement](https://onetimesecret.com/info/privacy/), in whole or in part, to any person or entity at any time with or without your consent, including the license grant in Section D.4. You may not assign or delegate any rights or obligations under the Terms of Service or Privacy Statement without our prior written consent, and any unauthorized assignment and delegation by you is void.

### 3. Section Headings and Summaries
Throughout this Agreement, each section includes titles and brief summaries of the following terms and conditions. These section titles and brief summaries are not legally binding.

### 4. Severability, No Waiver, and Survival
If any part of this Agreement is held invalid or unenforceable, that portion of the Agreement will be construed to reflect the parties’ original intent. The remaining portions will remain in full force and effect. Any failure on the part of onetimesecret.com to enforce any provision of this Agreement will not be considered a waiver of our right to enforce such provision. Our rights under this Agreement will survive any termination of this Agreement.

### 5. Amendments; Complete Agreement
This Agreement may only be modified by a written amendment signed by an authorized representative of onetimesecret.com, or by the posting by onetimesecret.com of a revised version in accordance with [Section O. Changes to These Terms](#o-changes-to-these-terms). These Terms of Service, together with the onetimesecret.com Privacy Statement, represent the complete and exclusive statement of the agreement between you and us. This Agreement supersedes any proposal or prior agreement oral or written, and any other communications between you and onetimesecret.com relating to the subject matter of these terms including any confidentiality or nondisclosure agreements.

### 6. Questions
Questions about the Terms of Service? [Contact us](https://onetimesecret.com/feedback/).
