---
title: Privacy Statement
---

Effective date: **October 22, 2024**

Onetimesecret.com provides a service for securely sharing sensitive information. We understand that managing private data carries significant responsibility. This policy outlines how we handle information entrusted to our service.

## The short version
We collect your information only with your consent; we only collect the minimum amount of personal information that is necessary to fulfill the purpose of your interaction with us; we don't sell it to third parties; and we only use it as this Privacy Statement describes.

Of course, the short version doesn't tell you everything, so please read on for more details!

## What information onetimesecret.com collects and why

### Information from website browsers

If you're **just browsing the website**, we collect the same basic information that most websites collect. We use common internet technologies, such as cookies and web server logs. This is stuff we collect from everybody, whether they have an account or not.

The information we collect about all visitors to our website includes the visitor's browser type, language preference, preferred data center location (which you choose when accessing our service via eu.onetimesecret.com or us.onetimesecret.com), color mode (e.g. dark mode), and the date and time of each visitor request. We also collect potentially personally-identifying information like Internet Protocol (IP) addresses.

#### Why do we collect this?

We collect this information to better understand how our website visitors use onetimesecret.com and to monitor and protect the security of the website.

### Information from users with accounts

If you **create an account**, we require some basic information at the time of account creation. You will create your own user name and password, and we will ask you for a valid email account. You also have the option to give us more information if you want to, and this may include "User Personal Information."

"User Personal Information" is any information about one of our users which could, alone or together with other information, personally identify him or her. Information such as a user name and password, an email address, a real name, and a photograph are examples of "User Personal Information."

User Personal Information does not include aggregated, non-personally identifying information. We may use aggregated, non-personally identifying information to operate, improve, and optimize our website and service.

#### Why do we collect this?

- We need your User Personal Information to create your account, and to provide the services you request.
- We use your User Personal Information, specifically your user name and email address, to identify you on onetimesecret.com.
- We will use your email address to communicate with you, if you've said that's okay, **and only for the reasons you've said that's okay**. Please see our section on [email communication](#how-we-communicate-with-you) for more information.
- We limit our use of your User Personal Information to the purposes listed in this Privacy Statement. If we need to use your User Personal Information for other purposes, we will ask your permission first.

## What information onetimesecret.com does not collect

We do not intentionally collect **sensitive personal information**, such as social security numbers, genetic data, health information, or religious information. Although onetimesecret.com does not request or intentionally collect any sensitive personal information, we realize that you might store this kind of information in your account, such as in a secret. If you store any sensitive personal information on our servers, you are consenting to our storage of that information on our servers, which are located in the European Union (EU) or United States (US) data centers (accessible via eu.onetimesecret.com and us.onetimesecret.com respectively), subject to applicable data protection laws.

We do not intentionally collect information that is **stored in your secret** or other free-form content inputs. Information in your secret belongs to you, and you are responsible for it, as well as for making sure that your content complies with our [Terms of Service](/info/terms/). onetimesecret.com employees do not access secret unless required to for security or maintenance, or for support reasons, with the consent of the secret owner.

If you're a **child under the age of 13**, you may not have an account on onetimesecret.com. onetimesecret.com does not knowingly collect information from or direct any of our content specifically to children under 13. If we learn or have reason to suspect that you are a user who is under the age of 13, we will unfortunately have to close your account. We don't want to discourage you from learning to code, but those are the rules. Please see our [Terms of Service](/info/terms/) for information about account termination.

## How we share the information we collect

We **do not** share, sell, rent, or trade User Personal Information with third parties for their commercial purposes.

We do not disclose User Personal Information outside onetimesecret.com, except in the situations listed in this section or in the section below on [Compelled Disclosure](#how-we-respond-to-compelled-disclosure).

We **do** share certain aggregated, non-personally identifying information with others about how our users, collectively, use onetimesecret.com, or how our users respond to our other offerings, such as our conferences or events. For example, we may compile statistics on the usage of HTTP content types across onetimesecret.com. However, we do not sell this information to advertisers or marketers.

We do not host advertising on onetimesecret.com. We may occasionally embed content from third party sites, such as YouTube, and that content may include ads. While we try to minimize the amount of ads our embedded content contains, we can't always control what third parties show.

We may share User Personal Information with your permission, so we can perform services you have requested.

We may share User Personal Information with a limited number of third-party vendors who process it on our behalf to provide or improve our service, and who have agreed to privacy restrictions similar to our own Privacy Statement. Our vendors perform services such as:
- Payment processing
- Customer support ticketing
- Network data transmission
- DDoS protection and content delivery through CloudFlare
- Other similar services

We may share User Personal Information if we are involved in a merger, sale, or acquisition. If any such change of ownership happens, we will ensure that it is under terms that preserve the confidentiality of User Personal Information, and we will notify you on our website or by email before any transfer of your User Personal Information. The organization receiving any User Personal Information will have to honor any promises we have made in our Privacy Statement or in our Terms of Service.

## Our use of cookies and tracking

### Cookies

onetimesecret.com uses cookies to make interactions with our service easy and meaningful. We use cookies (and similar technologies, like HTML5 localStorage) to keep you logged in, remember your preferences, and provide information for future development of onetimesecret.com.

A cookie is a small piece of text that our web server stores on your computer or mobile device, which your browser sends to us when you return to our site. Cookies do not necessarily identify you if you are merely visiting onetimesecret.com; however, a cookie may store a unique identifier for each logged in user. The cookies onetimesecret.com sets are essential for the operation of the website, or are used for performance or functionality. By using our website, you agree that we can place these types of cookies on your computer or device. If you disable your browser or device's ability to accept cookies, you will not be able to log in or use our services.

### Third-party tracking services

While we do not use Google Analytics or similar third-party tracking services for any purpose, some embedded content from third-party providers (such as video players) may set their own cookies or similar tracking technologies. These are outside of our control and are not used for our own tracking purposes. We recommend reviewing the privacy policies of these third-party providers if you have concerns about their cookies.

### Tracking

<p class="prose dark:text-gray-300">
We respect user privacy and do not track your online browsing activity across other online services over time. While some browsers previously offered a "Do Not Track" setting, we handle all user data with privacy in mind regardless of browser settings.
</p>

## How onetimesecret.com secures your information

onetimesecret.com takes all measures reasonably necessary to protect User Personal Information from unauthorized access, alteration, or destruction; maintain data accuracy; and help ensure the appropriate use of User Personal Information. We follow generally accepted industry standards to protect the personal information submitted to us, both during transmission and once we receive it.

To enhance security and availability, we utilize CloudFlare's services for DDoS protection and content delivery. For users on our dedicated service plans, additional security features including enhanced CloudFlare protection are available upon request (depending on the feature, additional charges may apply).

No method of transmission, or method of electronic storage, is 100% secure. Therefore, we cannot guarantee its absolute security. For more information, see our [security disclosures](/info/security/).

## onetimesecret.com's global privacy practices
**Information that we collect will be stored and processed in either our European Union (EU) or United States (US) data centers**, accessible via eu.onetimesecret.com and us.onetimesecret.com respectively. Your data will be stored in the region you select when creating your account, in accordance with this Privacy Statement. We understand that we have users from different countries and regions with different privacy expectations, and we try to meet those needs.

We provide the same standard of privacy protection to all our users around the world, regardless of their country of origin or location, and we are proud of the levels of notice, choice, accountability, security, data integrity, access, and recourse we provide. We work hard to comply with the applicable data privacy laws wherever we do business. Additionally, we require that if our vendors or affiliates have access to User Personal Information, they must comply with our privacy policies and with applicable data privacy laws, including signing data transfer agreements such as Standard Contractual Clause agreements.

In particular:
-	onetimesecret.com provides clear methods of unambiguous, informed consent at the time of data collection, when we do collect your personal data.
-	We collect only the minimum amount of personal data necessary, unless you choose to provide more. We encourage you to only give us the amount of data you are comfortable sharing.
-	We offer you simple methods of accessing, correcting, or deleting the data we have collected.
-	We provide our users notice, choice, accountability, security, and access, and we limit the purpose for processing. We also provide our users a method of recourse and enforcement. These are the Privacy Shield Principles, but they are also just good practices.

## Resolving Complaints

If you have concerns about the way onetimesecret.com is handling your User Personal Information, please let us know immediately. We want to help. You may email us directly at support@onetimesecret.com with the subject line "Privacy  Concerns." We will respond within 45 days at the latest.

## How we respond to compelled disclosure
onetimesecret.com may disclose personally-identifying information or other information we collect about you to law enforcement in response to a valid subpoena, court order, warrant, or similar government order, or when we believe in good faith that disclosure is reasonably necessary to protect our property or rights, or those of third parties or the public at large.

In complying with court orders and similar legal processes, onetimesecret.com strives for transparency. When permitted, we will make a reasonable effort to notify users of any disclosure of their information, unless we are prohibited by law or court order from doing so, or in rare, exigent circumstances.

## How you can access and control the information we collect
If you're already a onetimesecret.com user, you may access, update, alter, or delete your basic user profile information by [editing your user profile](https://onetimesecret.com.com/account) or contacting support@onetimesecret.com.

### Data Retention and Deletion

onetimesecret.com will retain User Personal Information for as long as your account is active or as needed to provide you services.

We may retain certain User Personal Information indefinitely, unless you delete it or request its deletion. For example, we don't automatically delete inactive user accounts, so unless you choose to delete your account, we will retain your account information indefinitely.

If you would like to cancel your account or delete your User Personal Information, you may do so by emailing support@onetimesecret.com. We will retain and use your information as necessary to comply with our legal obligations, resolve disputes, and enforce our agreements, but barring legal requirements, we will delete your full profile (within reason) within 30 days.

## How we communicate with you

We will use your email address to communicate with you, if you've said that's okay, **and only for the reasons you've said that's okay**. You have a lot of control over how your email address is used and shared on and through onetimesecret.com.

Depending on your email settings, onetimesecret.com may occasionally send notification emails about new features, requests for feedback, important policy changes, or offer customer support. We also send marketing emails, but only with your consent. There's an unsubscribe link located at the bottom of each of the emails we send you.

Our emails might contain a pixel tag, which is a small, clear image that can tell us whether or not you have opened an email and what your IP address is. We use this pixel tag to make our email more effective for you and to make sure we're not sending you unwanted email. If you prefer not to receive pixel tags, please opt out of marketing emails.

## Changes to our Privacy Statement
Although most changes are likely to be minor, onetimesecret.com may change our Privacy Statement from time to time. We will provide notification to Users of material changes to this Privacy Statement through our Website at least 30 days prior to the change taking effect by posting a notice on our home page or sending email to the email address specified in your onetimesecret.com primary account. For changes to this Privacy Statement that do not affect your rights, we encourage visitors to check this page frequently.

## License
This Privacy Statement is licensed under this [Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/). For details, see our [site-policy repository](https://github.com/onetimesecret/site-policy).

## Contacting onetimesecret.com

Questions regarding onetimesecret.com's Privacy Statement or information practices should be directed to support@onetimesecret.com.
