# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `truemail` gem.
# Please instead update this file by running `bin/tapioca gem truemail`.


# source://truemail//lib/truemail/core.rb#3
module Truemail
  class << self
    # source://truemail//lib/truemail.rb#11
    def configuration(&block); end

    # source://truemail//lib/truemail.rb#20
    def configure(&block); end

    # source://truemail//lib/truemail.rb#37
    def host_audit(custom_configuration: T.unsafe(nil)); end

    # source://truemail//lib/truemail.rb#24
    def reset_configuration!; end

    # @return [Boolean]
    #
    # source://truemail//lib/truemail.rb#33
    def valid?(email, **options); end

    # source://truemail//lib/truemail.rb#28
    def validate(email, custom_configuration: T.unsafe(nil), **options); end

    private

    # source://truemail//lib/truemail.rb#47
    def check_argument_type(argument); end

    # source://truemail//lib/truemail.rb#51
    def determine_configuration(custom_configuration); end

    # @raise [error_class]
    #
    # source://truemail//lib/truemail.rb#43
    def raise_unless(condition, message, error_class = T.unsafe(nil)); end
  end
end

# source://truemail//lib/truemail/core.rb#15
class Truemail::ArgumentError < ::StandardError
  # source://truemail//lib/truemail/core.rb#16
  def initialize(arg_value, arg_name); end
end

# source://truemail//lib/truemail/core.rb#40
module Truemail::Audit; end

# source://truemail//lib/truemail/audit/base.rb#5
class Truemail::Audit::Base < ::Truemail::Worker
  private

  # source://truemail//lib/truemail/audit/base.rb#11
  def add_warning(message); end

  # source://truemail//lib/truemail/audit/base.rb#19
  def configuration; end

  # source://truemail//lib/truemail/audit/base.rb#15
  def current_host_ip; end

  # source://truemail//lib/truemail/audit/base.rb#23
  def verifier_domain; end
end

# source://truemail//lib/truemail/audit/dns.rb#5
class Truemail::Audit::Dns < ::Truemail::Audit::Base
  # source://truemail//lib/truemail/audit/dns.rb#8
  def run; end

  private

  # source://truemail//lib/truemail/audit/dns.rb#15
  def a_record; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/audit/dns.rb#21
  def verifier_domain_refer_to_current_host_ip?; end
end

# source://truemail//lib/truemail/audit/dns.rb#6
Truemail::Audit::Dns::VERIFIER_DOMAIN_NOT_REFER = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/audit/ip.rb#5
class Truemail::Audit::Ip < ::Truemail::Audit::Base
  # source://truemail//lib/truemail/audit/ip.rb#9
  def run; end

  private

  # source://truemail//lib/truemail/audit/ip.rb#21
  def detect_current_host_ip; end

  # source://truemail//lib/truemail/audit/ip.rb#17
  def detect_ip_via_ipify; end
end

# source://truemail//lib/truemail/audit/ip.rb#6
Truemail::Audit::Ip::GET_MY_IP_URL = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/audit/ip.rb#7
Truemail::Audit::Ip::IPIFY_ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/audit/ptr.rb#5
class Truemail::Audit::Ptr < ::Truemail::Audit::Base
  # source://truemail//lib/truemail/audit/ptr.rb#9
  def run; end

  private

  # source://truemail//lib/truemail/audit/ptr.rb#17
  def current_host_reverse_lookup; end

  # source://truemail//lib/truemail/audit/ptr.rb#21
  def ptr_records; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/audit/ptr.rb#30
  def ptr_refer_to_verifier_domain?; end
end

# source://truemail//lib/truemail/audit/ptr.rb#6
Truemail::Audit::Ptr::PTR_NOT_FOUND = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/audit/ptr.rb#7
Truemail::Audit::Ptr::PTR_NOT_REFER = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/auditor.rb#4
class Truemail::Auditor < ::Truemail::Executor
  # @return [Auditor] a new instance of Auditor
  #
  # source://truemail//lib/truemail/auditor.rb#11
  def initialize(configuration:); end

  # source://truemail//lib/truemail/auditor.rb#20
  def as_json; end

  # source://truemail//lib/truemail/auditor.rb#15
  def run; end
end

# source://truemail//lib/truemail/auditor.rb#5
class Truemail::Auditor::Result < ::Struct
  # @return [Result] a new instance of Result
  #
  # source://truemail//lib/truemail/auditor.rb#6
  def initialize(warnings: T.unsafe(nil), **args); end

  # Returns the value of attribute configuration
  #
  # @return [Object] the current value of configuration
  def configuration; end

  # Sets the attribute configuration
  #
  # @param value [Object] the value to set the attribute configuration to.
  # @return [Object] the newly set value
  def configuration=(_); end

  # Returns the value of attribute current_host_ip
  #
  # @return [Object] the current value of current_host_ip
  def current_host_ip; end

  # Sets the attribute current_host_ip
  #
  # @param value [Object] the value to set the attribute current_host_ip to.
  # @return [Object] the newly set value
  def current_host_ip=(_); end

  # Returns the value of attribute warnings
  #
  # @return [Object] the current value of warnings
  def warnings; end

  # Sets the attribute warnings
  #
  # @param value [Object] the value to set the attribute warnings to.
  # @return [Object] the newly set value
  def warnings=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://truemail//lib/truemail/configuration.rb#4
class Truemail::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://truemail//lib/truemail/configuration.rb#39
  def initialize(&block); end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/configuration.rb#67
  def argument_consistent?(method, argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def blacklisted_domains; end

  # source://truemail//lib/truemail/configuration.rb#76
  def blacklisted_domains=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def blacklisted_emails; end

  # source://truemail//lib/truemail/configuration.rb#76
  def blacklisted_emails=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def blacklisted_mx_ip_addresses; end

  # source://truemail//lib/truemail/configuration.rb#76
  def blacklisted_mx_ip_addresses=(argument); end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/configuration.rb#87
  def complete?; end

  # source://truemail//lib/truemail/configuration.rb#30
  def connection_attempts; end

  # source://truemail//lib/truemail/configuration.rb#76
  def connection_attempts=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def connection_timeout; end

  # source://truemail//lib/truemail/configuration.rb#76
  def connection_timeout=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def default_validation_type; end

  # source://truemail//lib/truemail/configuration.rb#57
  def default_validation_type=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def dns; end

  # source://truemail//lib/truemail/configuration.rb#76
  def dns=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def email_pattern; end

  # source://truemail//lib/truemail/configuration.rb#76
  def email_pattern=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def logger; end

  # source://truemail//lib/truemail/configuration.rb#82
  def logger=(options); end

  # Returns the value of attribute not_rfc_mx_lookup_flow.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def not_rfc_mx_lookup_flow; end

  # Sets the attribute not_rfc_mx_lookup_flow
  #
  # @param value the value to set the attribute not_rfc_mx_lookup_flow to.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def not_rfc_mx_lookup_flow=(_arg0); end

  # source://truemail//lib/truemail/configuration.rb#30
  def response_timeout; end

  # source://truemail//lib/truemail/configuration.rb#76
  def response_timeout=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def smtp_error_body_pattern; end

  # source://truemail//lib/truemail/configuration.rb#76
  def smtp_error_body_pattern=(argument); end

  # Returns the value of attribute smtp_fail_fast.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def smtp_fail_fast; end

  # Sets the attribute smtp_fail_fast
  #
  # @param value the value to set the attribute smtp_fail_fast to.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def smtp_fail_fast=(_arg0); end

  # source://truemail//lib/truemail/configuration.rb#30
  def smtp_port; end

  # source://truemail//lib/truemail/configuration.rb#76
  def smtp_port=(argument); end

  # Returns the value of attribute smtp_safe_check.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def smtp_safe_check; end

  # Sets the attribute smtp_safe_check
  #
  # @param value the value to set the attribute smtp_safe_check to.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def smtp_safe_check=(_arg0); end

  # source://truemail//lib/truemail/configuration.rb#30
  def validation_type_by_domain; end

  # source://truemail//lib/truemail/configuration.rb#62
  def validation_type_for=(settings); end

  # source://truemail//lib/truemail/configuration.rb#30
  def verifier_domain; end

  # source://truemail//lib/truemail/configuration.rb#52
  def verifier_domain=(domain); end

  # source://truemail//lib/truemail/configuration.rb#30
  def verifier_email; end

  # source://truemail//lib/truemail/configuration.rb#46
  def verifier_email=(email); end

  # Returns the value of attribute whitelist_validation.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def whitelist_validation; end

  # Sets the attribute whitelist_validation
  #
  # @param value the value to set the attribute whitelist_validation to.
  #
  # source://truemail//lib/truemail/configuration.rb#37
  def whitelist_validation=(_arg0); end

  # source://truemail//lib/truemail/configuration.rb#30
  def whitelisted_domains; end

  # source://truemail//lib/truemail/configuration.rb#76
  def whitelisted_domains=(argument); end

  # source://truemail//lib/truemail/configuration.rb#30
  def whitelisted_emails; end

  # source://truemail//lib/truemail/configuration.rb#76
  def whitelisted_emails=(argument); end

  private

  # source://truemail//lib/truemail/configuration.rb#144
  def check_validation_type(validation_type); end

  # source://truemail//lib/truemail/configuration.rb#129
  def default_verifier_domain; end

  # source://truemail//lib/truemail/configuration.rb#93
  def instance_initializer; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/configuration.rb#140
  def items_match_regex?(items, regex_pattern); end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/configuration.rb#120
  def match_regex?(regex_pattern, object); end

  # @raise [Truemail::ArgumentError]
  #
  # source://truemail//lib/truemail/configuration.rb#116
  def raise_unless(argument_context, argument_name, condition); end

  # source://truemail//lib/truemail/configuration.rb#133
  def regex_by_method(method); end

  # source://truemail//lib/truemail/configuration.rb#124
  def validate_arguments(argument, method); end

  # source://truemail//lib/truemail/configuration.rb#148
  def validate_validation_type(settings); end
end

# source://truemail//lib/truemail/configuration.rb#7
Truemail::Configuration::DEFAULT_CONNECTION_ATTEMPTS = T.let(T.unsafe(nil), Integer)

# source://truemail//lib/truemail/configuration.rb#5
Truemail::Configuration::DEFAULT_CONNECTION_TIMEOUT = T.let(T.unsafe(nil), Integer)

# source://truemail//lib/truemail/configuration.rb#10
Truemail::Configuration::DEFAULT_LOGGER_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://truemail//lib/truemail/configuration.rb#6
Truemail::Configuration::DEFAULT_RESPONSE_TIMEOUT = T.let(T.unsafe(nil), Integer)

# source://truemail//lib/truemail/configuration.rb#9
Truemail::Configuration::DEFAULT_SMTP_PORT = T.let(T.unsafe(nil), Integer)

# source://truemail//lib/truemail/configuration.rb#8
Truemail::Configuration::DEFAULT_VALIDATION_TYPE = T.let(T.unsafe(nil), Symbol)

# source://truemail//lib/truemail/configuration.rb#15
Truemail::Configuration::SETTERS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/core.rb#13
class Truemail::ConfigurationError < ::StandardError; end

# source://truemail//lib/truemail/core.rb#34
module Truemail::Dns; end

# source://truemail//lib/truemail/dns/punycode_representer.rb#5
class Truemail::Dns::PunycodeRepresenter
  class << self
    # source://truemail//lib/truemail/dns/punycode_representer.rb#8
    def call(email); end
  end
end

# source://truemail//lib/truemail/dns/resolver.rb#5
class Truemail::Dns::Resolver
  class << self
    # source://truemail//lib/truemail/dns/resolver.rb#10
    def a_record(argument, configuration:); end

    # source://truemail//lib/truemail/dns/resolver.rb#10
    def a_records(argument, configuration:); end

    # source://truemail//lib/truemail/dns/resolver.rb#10
    def cname_records(argument, configuration:); end

    # source://truemail//lib/truemail/dns/resolver.rb#10
    def dns_lookup(argument, configuration:); end

    # source://truemail//lib/truemail/dns/resolver.rb#10
    def mx_records(argument, configuration:); end

    # source://truemail//lib/truemail/dns/resolver.rb#10
    def ptr_records(argument, configuration:); end
  end
end

# source://truemail//lib/truemail/dns/resolver.rb#6
Truemail::Dns::Resolver::WORKER_ACTIONS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/dns/worker.rb#7
class Truemail::Dns::Worker < ::Resolv::DNS
  # @return [Worker] a new instance of Worker
  #
  # source://truemail//lib/truemail/dns/worker.rb#12
  def initialize(dns_servers); end

  # source://truemail//lib/truemail/dns/worker.rb#20
  def a_record(host_name); end

  # source://truemail//lib/truemail/dns/worker.rb#24
  def a_records(host_name); end

  # source://truemail//lib/truemail/dns/worker.rb#28
  def cname_records(host_name); end

  # Returns the value of attribute dns_gateway.
  #
  # source://truemail//lib/truemail/dns/worker.rb#10
  def dns_gateway; end

  # source://truemail//lib/truemail/dns/worker.rb#16
  def dns_lookup(host_address); end

  # source://truemail//lib/truemail/dns/worker.rb#32
  def mx_records(host_name); end

  # source://truemail//lib/truemail/dns/worker.rb#36
  def ptr_records(host_address); end

  private

  # source://truemail//lib/truemail/dns/worker.rb#47
  def config_info(dns_servers); end

  # source://truemail//lib/truemail/dns/worker.rb#42
  def nameserver_port(server); end
end

# source://truemail//lib/truemail/dns/worker.rb#8
Truemail::Dns::Worker::DEFAULT_DNS_PORT = T.let(T.unsafe(nil), Integer)

# source://truemail//lib/truemail/executor.rb#4
class Truemail::Executor
  # source://truemail//lib/truemail/executor.rb#9
  def as_json; end

  # Returns the value of attribute result.
  #
  # source://truemail//lib/truemail/executor.rb#5
  def result; end

  # source://truemail//lib/truemail/executor.rb#7
  def run; end
end

# source://truemail//lib/truemail.rb#6
Truemail::INCOMPLETE_CONFIG = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail.rb#8
Truemail::INVALID_TYPE = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/core.rb#58
module Truemail::Log; end

# source://truemail//lib/truemail/log/event.rb#5
class Truemail::Log::Event
  # @return [Event] a new instance of Event
  #
  # source://truemail//lib/truemail/log/event.rb#14
  def initialize(event, validator_instance); end

  # source://truemail//lib/truemail/log/event.rb#26
  def log_level; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/log/event.rb#22
  def valid?; end

  private

  # source://truemail//lib/truemail/log/event.rb#34
  def action_level_log; end

  # Returns the value of attribute event.
  #
  # source://truemail//lib/truemail/log/event.rb#32
  def event; end

  # Returns the value of attribute has_validation_errors.
  #
  # source://truemail//lib/truemail/log/event.rb#32
  def has_validation_errors; end

  # Returns the value of attribute successful_validation.
  #
  # source://truemail//lib/truemail/log/event.rb#32
  def successful_validation; end

  # Returns the value of attribute validation_smtp_debug.
  #
  # source://truemail//lib/truemail/log/event.rb#32
  def validation_smtp_debug; end
end

# source://truemail//lib/truemail/log/event.rb#6
Truemail::Log::Event::TRACKING_EVENTS = T.let(T.unsafe(nil), Hash)

# source://truemail//lib/truemail/log/serializer/base.rb#5
module Truemail::Log::Serializer; end

# source://truemail//lib/truemail/log/serializer/auditor_json.rb#6
class Truemail::Log::Serializer::AuditorJson < ::Truemail::Log::Serializer::Base
  # source://truemail//lib/truemail/log/serializer/auditor_json.rb#7
  def serialize; end

  private

  # source://truemail//lib/truemail/log/serializer/auditor_json.rb#13
  def result; end
end

# source://truemail//lib/truemail/log/serializer/base.rb#6
class Truemail::Log::Serializer::Base
  # @return [Base] a new instance of Base
  #
  # source://truemail//lib/truemail/log/serializer/base.rb#25
  def initialize(executor_instance); end

  # source://truemail//lib/truemail/log/serializer/base.rb#30
  def serialize; end

  private

  # source://truemail//lib/truemail/log/serializer/base.rb#44
  def blacklisted_domains; end

  # source://truemail//lib/truemail/log/serializer/base.rb#44
  def blacklisted_emails; end

  # source://truemail//lib/truemail/log/serializer/base.rb#44
  def blacklisted_mx_ip_addresses; end

  # source://truemail//lib/truemail/log/serializer/base.rb#62
  def configuration; end

  # source://truemail//lib/truemail/log/serializer/base.rb#44
  def dns; end

  # source://truemail//lib/truemail/log/serializer/base.rb#52
  def email_pattern; end

  # source://truemail//lib/truemail/log/serializer/base.rb#36
  def errors(executor_result_target); end

  # Returns the value of attribute executor_configuration.
  #
  # source://truemail//lib/truemail/log/serializer/base.rb#34
  def executor_configuration; end

  # Returns the value of attribute executor_result.
  #
  # source://truemail//lib/truemail/log/serializer/base.rb#34
  def executor_result; end

  # source://truemail//lib/truemail/log/serializer/base.rb#52
  def smtp_error_body_pattern; end

  # source://truemail//lib/truemail/log/serializer/base.rb#44
  def validation_type_by_domain; end

  # source://truemail//lib/truemail/log/serializer/base.rb#36
  def warnings(executor_result_target); end

  # source://truemail//lib/truemail/log/serializer/base.rb#44
  def whitelisted_domains; end

  # source://truemail//lib/truemail/log/serializer/base.rb#44
  def whitelisted_emails; end

  class << self
    # source://truemail//lib/truemail/log/serializer/base.rb#21
    def call(executor_instance); end
  end
end

# source://truemail//lib/truemail/log/serializer/base.rb#9
Truemail::Log::Serializer::Base::CONFIGURATION_ARRAY_ATTRS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/log/serializer/base.rb#18
Truemail::Log::Serializer::Base::CONFIGURATION_REGEX_ATTRS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/log/serializer/base.rb#19
Truemail::Log::Serializer::Base::DEFAULT_GEM_VALUE = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/log/serializer/validator_base.rb#6
class Truemail::Log::Serializer::ValidatorBase < ::Truemail::Log::Serializer::Base
  # @return [ValidatorBase] a new instance of ValidatorBase
  #
  # source://truemail//lib/truemail/log/serializer/validator_base.rb#7
  def initialize(executor_instance); end

  private

  # source://truemail//lib/truemail/log/serializer/validator_base.rb#16
  def replace_invalid_chars; end

  # source://truemail//lib/truemail/log/serializer/validator_base.rb#34
  def result; end

  # source://truemail//lib/truemail/log/serializer/validator_base.rb#20
  def smtp_debug; end

  # Returns the value of attribute validation_type.
  #
  # source://truemail//lib/truemail/log/serializer/validator_base.rb#14
  def validation_type; end
end

# source://truemail//lib/truemail/log/serializer/validator_json.rb#6
class Truemail::Log::Serializer::ValidatorJson < ::Truemail::Log::Serializer::ValidatorBase
  # source://truemail//lib/truemail/log/serializer/validator_json.rb#7
  def serialize; end
end

# source://truemail//lib/truemail/log/serializer/validator_text.rb#6
class Truemail::Log::Serializer::ValidatorText < ::Truemail::Log::Serializer::ValidatorBase
  # source://truemail//lib/truemail/log/serializer/validator_text.rb#9
  def serialize; end

  private

  # source://truemail//lib/truemail/log/serializer/validator_text.rb#31
  def collection_printer(collection); end

  # source://truemail//lib/truemail/log/serializer/validator_text.rb#19
  def data_composer(enumerable_object); end

  # source://truemail//lib/truemail/log/serializer/validator_text.rb#45
  def error_info; end

  # source://truemail//lib/truemail/log/serializer/validator_text.rb#37
  def printer(enumerable_object); end

  # source://truemail//lib/truemail/log/serializer/validator_text.rb#60
  def txt_info_configuration; end

  # source://truemail//lib/truemail/log/serializer/validator_text.rb#55
  def txt_info_debug; end

  # source://truemail//lib/truemail/log/serializer/validator_text.rb#50
  def txt_info_title; end
end

# source://truemail//lib/truemail/log/serializer/validator_text.rb#7
Truemail::Log::Serializer::ValidatorText::ATTEMPT = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/logger.rb#4
class Truemail::Logger
  # @return [Logger] a new instance of Logger
  #
  # source://truemail//lib/truemail/logger.rb#60
  def initialize(event, error_stdout, log_absolute_path, custom_logger); end

  # Returns the value of attribute custom_logger.
  #
  # source://truemail//lib/truemail/logger.rb#58
  def custom_logger; end

  # Returns the value of attribute event.
  #
  # source://truemail//lib/truemail/logger.rb#58
  def event; end

  # Returns the value of attribute file.
  #
  # source://truemail//lib/truemail/logger.rb#58
  def file; end

  # Returns the value of attribute file_logger.
  #
  # source://truemail//lib/truemail/logger.rb#58
  def file_logger; end

  # source://truemail//lib/truemail/logger.rb#68
  def push(validator_instance); end

  # Returns the value of attribute stdout.
  #
  # source://truemail//lib/truemail/logger.rb#58
  def stdout; end

  # Returns the value of attribute stdout_logger.
  #
  # source://truemail//lib/truemail/logger.rb#58
  def stdout_logger; end

  private

  # source://truemail//lib/truemail/logger.rb#94
  def create_logs(log_level, serialized_object); end

  # source://truemail//lib/truemail/logger.rb#83
  def init_builtin_loggers; end

  # source://truemail//lib/truemail/logger.rb#76
  def init_log_file; end
end

# source://truemail//lib/truemail/logger.rb#7
Truemail::Logger::BUILDER_ATTRS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/logger.rb#9
class Truemail::Logger::Builder < ::Struct
  # @return [Builder] a new instance of Builder
  #
  # source://truemail//lib/truemail/logger.rb#16
  def initialize(default_settings, **args); end

  # source://truemail//lib/truemail/logger.rb#27
  def build_instance; end

  def custom_logger; end
  def custom_logger=(_); end
  def log_absolute_path; end
  def log_absolute_path=(_); end
  def stdout; end
  def stdout=(_); end
  def tracking_event; end
  def tracking_event=(_); end

  # source://truemail//lib/truemail/logger.rb#20
  def validate_attributes; end

  private

  # @raise [Truemail::ArgumentError]
  #
  # source://truemail//lib/truemail/logger.rb#33
  def raise_unless(argument_context, argument_name, condition); end

  # source://truemail//lib/truemail/logger.rb#42
  def validate_logger_event; end

  # source://truemail//lib/truemail/logger.rb#37
  def validate_logger_instance; end

  # source://truemail//lib/truemail/logger.rb#46
  def validate_logger_output; end

  class << self
    def [](*_arg0); end

    # source://truemail//lib/truemail/logger.rb#12
    def call(default_settings, **logger_attributes); end

    def inspect; end
    def keyword_init?; end
    def members; end

    private

    def new(*_arg0); end
  end
end

# source://truemail//lib/truemail.rb#7
Truemail::NOT_CONFIGURED = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/core.rb#21
module Truemail::RegexConstant; end

# source://truemail//lib/truemail/core.rb#31
Truemail::RegexConstant::REGEX_DNS_SERVER_ADDRESS_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#22
Truemail::RegexConstant::REGEX_DOMAIN = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#26
Truemail::RegexConstant::REGEX_DOMAIN_FROM_EMAIL = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#25
Truemail::RegexConstant::REGEX_DOMAIN_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#24
Truemail::RegexConstant::REGEX_EMAIL_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#28
Truemail::RegexConstant::REGEX_IP_ADDRESS = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#29
Truemail::RegexConstant::REGEX_IP_ADDRESS_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#30
Truemail::RegexConstant::REGEX_PORT_NUMBER = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#23
Truemail::RegexConstant::REGEX_SIMPLE_EMAIL_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#27
Truemail::RegexConstant::REGEX_SMTP_ERROR_BODY_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://truemail//lib/truemail/core.rb#14
class Truemail::TypeError < ::StandardError; end

# source://truemail//lib/truemail/version.rb#4
Truemail::VERSION = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/core.rb#47
module Truemail::Validate; end

# source://truemail//lib/truemail/validate/base.rb#5
class Truemail::Validate::Base < ::Truemail::Worker
  private

  # source://truemail//lib/truemail/validate/base.rb#8
  def add_error(message); end

  # source://truemail//lib/truemail/validate/base.rb#16
  def configuration; end

  # source://truemail//lib/truemail/validate/base.rb#12
  def mail_servers; end
end

# source://truemail//lib/truemail/validate/list_match.rb#5
class Truemail::Validate::ListMatch < ::Truemail::Validate::Base
  # source://truemail//lib/truemail/validate/list_match.rb#8
  def run; end

  private

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/list_match.rb#39
  def blacklisted?; end

  # source://truemail//lib/truemail/validate/list_match.rb#17
  def email; end

  # source://truemail//lib/truemail/validate/list_match.rb#21
  def email_domain; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/list_match.rb#31
  def whitelist_validation?; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/list_match.rb#35
  def whitelist_validation_case?; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/list_match.rb#26
  def whitelisted?; end
end

# source://truemail//lib/truemail/validate/list_match.rb#6
Truemail::Validate::ListMatch::ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/mx.rb#5
class Truemail::Validate::Mx < ::Truemail::Validate::Base
  # source://truemail//lib/truemail/validate/mx.rb#9
  def run; end

  private

  # source://truemail//lib/truemail/validate/mx.rb#67
  def a_record(hostname); end

  # source://truemail//lib/truemail/validate/mx.rb#58
  def domain; end

  # source://truemail//lib/truemail/validate/mx.rb#42
  def domain_not_include_null_mx; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx.rb#18
  def email_domain_valid?; end

  # source://truemail//lib/truemail/validate/mx.rb#33
  def fetch_target_hosts(hosts); end

  # source://truemail//lib/truemail/validate/mx.rb#22
  def host_extractor_methods; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx.rb#83
  def host_from_a_record?; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx.rb#71
  def hosts_from_cname_records?; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx.rb#62
  def hosts_from_mx_records?; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx.rb#54
  def mail_servers_found?; end

  # source://truemail//lib/truemail/validate/mx.rb#27
  def mx_lookup; end

  # source://truemail//lib/truemail/validate/mx.rb#46
  def mx_records(hostname); end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx.rb#37
  def null_mx?(domain_mx_records); end
end

# source://truemail//lib/truemail/validate/mx.rb#6
Truemail::Validate::Mx::ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/mx.rb#7
Truemail::Validate::Mx::NULL_MX_RECORD = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/mx_blacklist.rb#5
class Truemail::Validate::MxBlacklist < ::Truemail::Validate::Base
  # source://truemail//lib/truemail/validate/mx_blacklist.rb#8
  def run; end

  private

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx_blacklist.rb#17
  def blacklisted_ip?; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/mx_blacklist.rb#21
  def not_blacklisted_mail_servers?; end
end

# source://truemail//lib/truemail/validate/mx_blacklist.rb#6
Truemail::Validate::MxBlacklist::ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/regex.rb#5
class Truemail::Validate::Regex < ::Truemail::Validate::Base
  # source://truemail//lib/truemail/validate/regex.rb#8
  def run; end

  private

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/regex.rb#16
  def match_regex_pattern?; end
end

# source://truemail//lib/truemail/validate/regex.rb#6
Truemail::Validate::Regex::ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/smtp.rb#5
class Truemail::Validate::Smtp < ::Truemail::Validate::Base
  # @return [Smtp] a new instance of Smtp
  #
  # source://truemail//lib/truemail/validate/smtp.rb#10
  def initialize(result); end

  # source://truemail//lib/truemail/validate/smtp.rb#15
  def run; end

  # Returns the value of attribute smtp_results.
  #
  # source://truemail//lib/truemail/validate/smtp.rb#8
  def smtp_results; end

  private

  # source://truemail//lib/truemail/validate/smtp.rb#35
  def attempts; end

  # source://truemail//lib/truemail/validate/smtp.rb#50
  def establish_smtp_connection; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/smtp.rb#27
  def fail_fast?; end

  # source://truemail//lib/truemail/validate/smtp.rb#31
  def filtered_mail_servers_by_fail_fast_scenario; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/smtp.rb#64
  def not_includes_user_not_found_errors?; end

  # source://truemail//lib/truemail/validate/smtp.rb#46
  def rcptto_error; end

  # source://truemail//lib/truemail/validate/smtp.rb#42
  def request; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/smtp.rb#60
  def success_response?; end
end

# source://truemail//lib/truemail/validate/smtp.rb#6
Truemail::Validate::Smtp::ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/smtp/response.rb#6
Truemail::Validate::Smtp::RESPONSE_ATTRS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/validate/smtp/request.rb#6
class Truemail::Validate::Smtp::Request
  # @return [Request] a new instance of Request
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#13
  def initialize(configuration:, host:, email:, attempts: T.unsafe(nil), port_open_status: T.unsafe(nil)); end

  # source://truemail//lib/truemail/validate/smtp/request.rb#22
  def check_port; end

  # Returns the value of attribute configuration.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#11
  def configuration; end

  # Returns the value of attribute email.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#11
  def email; end

  # Returns the value of attribute host.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#11
  def host; end

  # Returns the value of attribute response.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#11
  def response; end

  # source://truemail//lib/truemail/validate/smtp/request.rb#34
  def run; end

  private

  # source://truemail//lib/truemail/validate/smtp/request.rb#113
  def assign_error(attribute:, message:); end

  # Returns the value of attribute attempts.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#88
  def attempts; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#90
  def attempts_exist?; end

  # source://truemail//lib/truemail/validate/smtp/request.rb#104
  def compose_from(error); end

  # Returns the value of attribute port_open_status.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#88
  def port_open_status; end

  # source://truemail//lib/truemail/validate/smtp/request.rb#95
  def session; end

  # source://truemail//lib/truemail/validate/smtp/request.rb#132
  def session_actions; end

  # source://truemail//lib/truemail/validate/smtp/request.rb#118
  def session_data; end

  # source://truemail//lib/truemail/validate/smtp/request.rb#139
  def smtp_handshakes(smtp_request, smtp_response); end

  # source://truemail//lib/truemail/validate/smtp/request.rb#122
  def smtp_resolver(smtp_request, method, value); end

  # source://truemail//lib/truemail/validate/smtp/request.rb#128
  def verifier_domain; end
end

# source://truemail//lib/truemail/validate/smtp/request.rb#9
Truemail::Validate::Smtp::Request::CONNECTION_DROPPED = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/smtp/request.rb#7
Truemail::Validate::Smtp::Request::CONNECTION_TIMEOUT_ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/smtp/request.rb#43
class Truemail::Validate::Smtp::Request::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#46
  def initialize(configuration); end
end

# source://truemail//lib/truemail/validate/smtp/request.rb#44
Truemail::Validate::Smtp::Request::Configuration::REQUEST_PARAMS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/validate/smtp/request.rb#8
Truemail::Validate::Smtp::Request::RESPONSE_TIMEOUT_ERROR = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/smtp/request.rb#54
class Truemail::Validate::Smtp::Request::Session
  # @return [Session] a new instance of Session
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#59
  def initialize(host, port, connection_timeout, response_timeout, net_class = T.unsafe(nil)); end

  # source://truemail//lib/truemail/validate/smtp/request.rb#68
  def start(helo_domain, &block); end

  private

  # Returns the value of attribute net_class.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#76
  def net_class; end

  # Returns the value of attribute net_smtp.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#76
  def net_smtp; end

  # Returns the value of attribute net_smtp_version.
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#76
  def net_smtp_version; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validate/smtp/request.rb#83
  def old_net_smtp?; end

  # source://truemail//lib/truemail/validate/smtp/request.rb#78
  def resolve_net_smtp_version; end
end

# source://truemail//lib/truemail/validate/smtp/request.rb#57
Truemail::Validate::Smtp::Request::Session::UNDEFINED_VERSION = T.let(T.unsafe(nil), String)

# source://truemail//lib/truemail/validate/smtp/response.rb#8
class Truemail::Validate::Smtp::Response < ::Struct
  # @return [Response] a new instance of Response
  #
  # source://truemail//lib/truemail/validate/smtp/response.rb#9
  def initialize(errors: T.unsafe(nil), **args); end

  def connection; end
  def connection=(_); end
  def errors; end
  def errors=(_); end
  def helo; end
  def helo=(_); end
  def mailfrom; end
  def mailfrom=(_); end
  def port_opened; end
  def port_opened=(_); end
  def rcptto; end
  def rcptto=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://truemail//lib/truemail/validator.rb#4
class Truemail::Validator < ::Truemail::Executor
  # @raise [Truemail::ArgumentError]
  # @return [Validator] a new instance of Validator
  #
  # source://truemail//lib/truemail/validator.rb#21
  def initialize(email, configuration:, with: T.unsafe(nil)); end

  # source://truemail//lib/truemail/validator.rb#35
  def as_json; end

  # source://truemail//lib/truemail/validator.rb#28
  def run; end

  # Returns the value of attribute validation_type.
  #
  # source://truemail//lib/truemail/validator.rb#19
  def validation_type; end

  private

  # source://truemail//lib/truemail/validator.rb#46
  def constantize(symbol); end

  # source://truemail//lib/truemail/validator.rb#62
  def logger; end

  # @return [Boolean]
  #
  # source://truemail//lib/truemail/validator.rb#58
  def result_not_changed?; end

  # source://truemail//lib/truemail/validator.rb#54
  def result_status; end

  # source://truemail//lib/truemail/validator.rb#41
  def select_validation_type(email, current_validation_type); end

  # source://truemail//lib/truemail/validator.rb#50
  def update_validation_type; end
end

# source://truemail//lib/truemail/validator.rb#5
Truemail::Validator::RESULT_ATTRS = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/validator.rb#8
class Truemail::Validator::Result < ::Struct
  # @return [Result] a new instance of Result
  #
  # source://truemail//lib/truemail/validator.rb#9
  def initialize(mail_servers: T.unsafe(nil), errors: T.unsafe(nil), **args); end

  def configuration; end
  def configuration=(_); end
  def domain; end
  def domain=(_); end
  def email; end
  def email=(_); end
  def errors; end
  def errors=(_); end
  def mail_servers; end
  def mail_servers=(_); end

  # source://truemail//lib/truemail/validator.rb#13
  def punycode_email; end

  def smtp_debug; end
  def smtp_debug=(_); end
  def success; end
  def success=(_); end
  def valid?; end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://truemail//lib/truemail/validator.rb#6
Truemail::Validator::VALIDATION_TYPES = T.let(T.unsafe(nil), Array)

# source://truemail//lib/truemail/worker.rb#4
class Truemail::Worker
  # @return [Worker] a new instance of Worker
  #
  # source://truemail//lib/truemail/worker.rb#11
  def initialize(result); end

  # Returns the value of attribute result.
  #
  # source://truemail//lib/truemail/worker.rb#5
  def result; end

  private

  # source://truemail//lib/truemail/worker.rb#17
  def success(condition); end

  class << self
    # source://truemail//lib/truemail/worker.rb#7
    def check(result); end
  end
end

# source://truemail//lib/truemail/wrapper.rb#4
class Truemail::Wrapper
  # @return [Wrapper] a new instance of Wrapper
  #
  # source://truemail//lib/truemail/wrapper.rb#12
  def initialize(configuration); end

  # Returns the value of attribute attempts.
  #
  # source://truemail//lib/truemail/wrapper.rb#6
  def attempts; end

  # Sets the attribute attempts
  #
  # @param value the value to set the attribute attempts to.
  #
  # source://truemail//lib/truemail/wrapper.rb#6
  def attempts=(_arg0); end

  # source://truemail//lib/truemail/wrapper.rb#17
  def call(&block); end

  # Returns the value of attribute timeout.
  #
  # source://truemail//lib/truemail/wrapper.rb#5
  def timeout; end

  class << self
    # source://truemail//lib/truemail/wrapper.rb#8
    def call(configuration:, &block); end
  end
end
