# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `thin` gem.
# Please instead update this file by running `bin/tapioca gem thin`.


module ERB::Escape
  private

  def html_escape(_arg0); end

  class << self
    def html_escape(_arg0); end
  end
end

# source://thin//lib/thin/daemonizing.rb#4
module Process
  private

  # Returns +true+ the process identied by +pid+ is running.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/daemonizing.rb#6
  def running?(pid); end

  class << self
    # Returns +true+ the process identied by +pid+ is running.
    #
    # @return [Boolean]
    #
    # source://thin//lib/thin/daemonizing.rb#6
    def running?(pid); end
  end
end

# Adapter to run a Rails app with any supported Rack handler.
# By default it will try to load the Rails application in the
# current directory in the development environment.
#
# Options:
#  root: Root directory of the Rails app
#  environment: Rails environment to run in (development [default], production or test)
#  prefix: Set the relative URL root.
#
# Based on http://fuzed.rubyforge.org/ Rails adapter
#
# source://thin//lib/rack/adapter/loader.rb#1
module Rack
  class << self
    # source://rack/2.2.9/lib/rack/version.rb#26
    def release; end

    # source://rack/2.2.9/lib/rack/version.rb#19
    def version; end
  end
end

# Mapping used to guess which adapter to use in <tt>Adapter.for</tt>.
# Framework <name> => <file unique to this framework> in order they will
# be tested.
# +nil+ for value to never guess.
# NOTE: If a framework has a file that is not unique, make sure to place
# it at the end.
#
# source://thin//lib/rack/adapter/loader.rb#10
Rack::ADAPTERS = T.let(T.unsafe(nil), Array)

# source://thin//lib/rack/adapter/loader.rb#18
module Rack::Adapter
  class << self
    # Loads an adapter identified by +name+ using +options+ hash.
    #
    # source://thin//lib/rack/adapter/loader.rb#37
    def for(name, options = T.unsafe(nil)); end

    # Guess which adapter to use based on the directory structure
    # or file content.
    # Returns a symbol representing the name of the adapter to use
    # to load the application under <tt>dir/</tt>.
    #
    # @raise [AdapterNotFound]
    #
    # source://thin//lib/rack/adapter/loader.rb#23
    def guess(dir); end

    # Load a Rack application from a Rack config file (.ru).
    #
    # source://thin//lib/rack/adapter/loader.rb#31
    def load(config); end
  end
end

# source://thin//lib/rack/adapter/rails.rb#15
class Rack::Adapter::Rails
  # @return [Rails] a new instance of Rails
  #
  # source://thin//lib/rack/adapter/rails.rb#18
  def initialize(options = T.unsafe(nil)); end

  # source://thin//lib/rack/adapter/rails.rb#49
  def call(env); end

  # @return [Boolean]
  #
  # source://thin//lib/rack/adapter/rails.rb#44
  def file_exist?(path); end

  # source://thin//lib/rack/adapter/rails.rb#29
  def load_application; end

  class << self
    # @return [Boolean]
    #
    # source://thin//lib/rack/adapter/rails.rb#67
    def rack_based?; end
  end
end

# source://thin//lib/rack/adapter/rails.rb#90
class Rack::Adapter::Rails::CGIWrapper < ::CGI
  # @return [CGIWrapper] a new instance of CGIWrapper
  #
  # source://thin//lib/rack/adapter/rails.rb#91
  def initialize(request, response, *args); end

  # Used to wrap the normal args variable used inside CGI.
  #
  # source://thin//lib/rack/adapter/rails.rb#157
  def args; end

  # source://thin//lib/rack/adapter/rails.rb#148
  def cookies; end

  # Used to wrap the normal env_table variable used inside CGI.
  #
  # source://thin//lib/rack/adapter/rails.rb#162
  def env_table; end

  # source://thin//lib/rack/adapter/rails.rb#100
  def header(options = T.unsafe(nil)); end

  # source://thin//lib/rack/adapter/rails.rb#144
  def params; end

  # source://thin//lib/rack/adapter/rails.rb#152
  def query_string; end

  # Used to wrap the normal stdinput variable used inside CGI.
  #
  # source://thin//lib/rack/adapter/rails.rb#167
  def stdinput; end

  # source://thin//lib/rack/adapter/rails.rb#171
  def stdoutput; end
end

# For Rails pre Rack (2.3)
#
# source://thin//lib/rack/adapter/rails.rb#77
class Rack::Adapter::Rails::CgiApp
  # source://thin//lib/rack/adapter/rails.rb#78
  def call(env); end
end

# source://thin//lib/rack/adapter/rails.rb#16
Rack::Adapter::Rails::FILE_METHODS = T.let(T.unsafe(nil), Array)

# source://thin//lib/rack/adapter/loader.rb#2
class Rack::AdapterNotFound < ::RuntimeError; end

# source://thin//lib/rack/handler/thin.rb#9
module Rack::Handler
  class << self
    # source://rack/2.2.9/lib/rack/handler.rb#51
    def default; end

    # source://rack/2.2.9/lib/rack/handler.rb#13
    def get(server); end

    # source://rack/2.2.9/lib/rack/handler.rb#36
    def pick(server_names); end

    # source://rack/2.2.9/lib/rack/handler.rb#85
    def register(server, klass); end

    # source://rack/2.2.9/lib/rack/handler.rb#75
    def try_require(prefix, const_name); end
  end
end

# source://thin//lib/rack/handler/thin.rb#10
class Rack::Handler::Thin
  class << self
    # @yield [server]
    #
    # source://thin//lib/rack/handler/thin.rb#11
    def run(app, **options); end

    # source://thin//lib/rack/handler/thin.rb#25
    def valid_options; end
  end
end

# source://thin//lib/thin.rb#10
module Thin
  class << self
    # @return [Boolean]
    #
    # source://thin//lib/thin/version.rb#25
    def linux?; end

    # @return [Boolean]
    #
    # source://thin//lib/thin/version.rb#29
    def ruby_18?; end

    # @return [Boolean]
    #
    # source://thin//lib/thin/version.rb#21
    def win?; end
  end
end

# source://thin//lib/thin.rb#22
module Thin::Backends; end

# A Backend connects the server to the client. It handles:
# * connection/disconnection to the server
# * initialization of the connections
# * monitoring of the active connections.
#
# == Implementing your own backend
# You can create your own minimal backend by inheriting this class and
# defining the +connect+ and +disconnect+ method.
# If your backend is not based on EventMachine you also need to redefine
# the +start+, +stop+, <tt>stop!</tt> and +config+ methods.
#
# source://thin//lib/thin/backends/base.rb#13
class Thin::Backends::Base
  # @return [Base] a new instance of Base
  #
  # source://thin//lib/thin/backends/base.rb#47
  def initialize; end

  # Free up resources used by the backend.
  #
  # source://thin//lib/thin/backends/base.rb#114
  def close; end

  # Configure the backend. This method will be called before droping superuser privileges,
  # so you can do crazy stuff that require godlike powers here.
  #
  # source://thin//lib/thin/backends/base.rb#103
  def config; end

  # Called by a connection when it's unbinded.
  #
  # source://thin//lib/thin/backends/base.rb#127
  def connection_finished(connection); end

  # Returns +true+ if no active connection.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/backends/base.rb#136
  def empty?; end

  # Maximum number of file or socket descriptors that the server may open.
  #
  # source://thin//lib/thin/backends/base.rb#21
  def maximum_connections; end

  # Maximum number of file or socket descriptors that the server may open.
  #
  # source://thin//lib/thin/backends/base.rb#21
  def maximum_connections=(_arg0); end

  # Maximum number of connections that can be persistent
  #
  # source://thin//lib/thin/backends/base.rb#24
  def maximum_persistent_connections; end

  # Maximum number of connections that can be persistent
  #
  # source://thin//lib/thin/backends/base.rb#24
  def maximum_persistent_connections=(_arg0); end

  # Disable the use of epoll under Linux
  #
  # source://thin//lib/thin/backends/base.rb#45
  def no_epoll; end

  # Disable the use of epoll under Linux
  #
  # source://thin//lib/thin/backends/base.rb#45
  def no_epoll=(_arg0); end

  # Number of persistent connections currently opened
  #
  # source://thin//lib/thin/backends/base.rb#42
  def persistent_connection_count; end

  # Number of persistent connections currently opened
  #
  # source://thin//lib/thin/backends/base.rb#42
  def persistent_connection_count=(_arg0); end

  # Returns +true+ if the backend is connected and running.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/backends/base.rb#118
  def running?; end

  # Server serving the connections throught the backend
  #
  # source://thin//lib/thin/backends/base.rb#15
  def server; end

  # Server serving the connections throught the backend
  #
  # source://thin//lib/thin/backends/base.rb#15
  def server=(_arg0); end

  # Number of active connections.
  #
  # source://thin//lib/thin/backends/base.rb#141
  def size; end

  # Allow using SSL in the backend.
  #
  # source://thin//lib/thin/backends/base.rb#38
  def ssl=(_arg0); end

  # @return [Boolean]
  #
  # source://thin//lib/thin/backends/base.rb#39
  def ssl?; end

  # Allow using SSL in the backend.
  #
  # source://thin//lib/thin/backends/base.rb#38
  def ssl_options=(_arg0); end

  # Start the backend and connect it.
  #
  # source://thin//lib/thin/backends/base.rb#62
  def start; end

  # @return [Boolean]
  #
  # source://thin//lib/thin/backends/base.rb#122
  def started_reactor?; end

  # Stop of the backend from accepting new connections.
  #
  # source://thin//lib/thin/backends/base.rb#80
  def stop; end

  # Force stop of the backend NOW, too bad for the current connections.
  #
  # source://thin//lib/thin/backends/base.rb#92
  def stop!; end

  # Allow using threads in the backend.
  #
  # source://thin//lib/thin/backends/base.rb#34
  def threaded=(_arg0); end

  # @return [Boolean]
  #
  # source://thin//lib/thin/backends/base.rb#35
  def threaded?; end

  # allows setting of the eventmachine threadpool size
  #
  # source://thin//lib/thin/backends/base.rb#27
  def threadpool_size; end

  # source://thin//lib/thin/backends/base.rb#28
  def threadpool_size=(size); end

  # Maximum time for incoming data to arrive
  #
  # source://thin//lib/thin/backends/base.rb#18
  def timeout; end

  # Maximum time for incoming data to arrive
  #
  # source://thin//lib/thin/backends/base.rb#18
  def timeout=(_arg0); end

  protected

  # Initialize a new connection to a client.
  #
  # source://thin//lib/thin/backends/base.rb#147
  def initialize_connection(connection); end
end

# Backend to act as a Swiftiply client (http://swiftiply.swiftcore.org).
#
# source://thin//lib/thin/backends/swiftiply_client.rb#4
class Thin::Backends::SwiftiplyClient < ::Thin::Backends::Base
  # @return [SwiftiplyClient] a new instance of SwiftiplyClient
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#9
  def initialize(host, port, options = T.unsafe(nil)); end

  # Connect the server
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#17
  def connect; end

  # Stops the server
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#22
  def disconnect; end

  # Returns the value of attribute host.
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#7
  def host; end

  # Sets the attribute host
  #
  # @param value the value to set the attribute host to.
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#7
  def host=(_arg0); end

  # Returns the value of attribute key.
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#5
  def key; end

  # Sets the attribute key
  #
  # @param value the value to set the attribute key to.
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#5
  def key=(_arg0); end

  # Returns the value of attribute port.
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#7
  def port; end

  # Sets the attribute port
  #
  # @param value the value to set the attribute port to.
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#7
  def port=(_arg0); end

  # source://thin//lib/thin/backends/swiftiply_client.rb#26
  def to_s; end
end

# Backend to act as a TCP socket server.
#
# source://thin//lib/thin/backends/tcp_server.rb#4
class Thin::Backends::TcpServer < ::Thin::Backends::Base
  # @return [TcpServer] a new instance of TcpServer
  #
  # source://thin//lib/thin/backends/tcp_server.rb#8
  def initialize(host, port); end

  # Connect the server
  #
  # source://thin//lib/thin/backends/tcp_server.rb#15
  def connect; end

  # Stops the server
  #
  # source://thin//lib/thin/backends/tcp_server.rb#25
  def disconnect; end

  # Address and port on which the server is listening for connections.
  #
  # source://thin//lib/thin/backends/tcp_server.rb#6
  def host; end

  # Address and port on which the server is listening for connections.
  #
  # source://thin//lib/thin/backends/tcp_server.rb#6
  def host=(_arg0); end

  # Address and port on which the server is listening for connections.
  #
  # source://thin//lib/thin/backends/tcp_server.rb#6
  def port; end

  # Address and port on which the server is listening for connections.
  #
  # source://thin//lib/thin/backends/tcp_server.rb#6
  def port=(_arg0); end

  # source://thin//lib/thin/backends/tcp_server.rb#29
  def to_s; end
end

# Backend to act as a UNIX domain socket server.
#
# source://thin//lib/thin/backends/unix_server.rb#4
class Thin::Backends::UnixServer < ::Thin::Backends::Base
  # @raise [PlatformNotSupported]
  # @return [UnixServer] a new instance of UnixServer
  #
  # source://thin//lib/thin/backends/unix_server.rb#8
  def initialize(socket); end

  # Free up resources used by the backend.
  #
  # source://thin//lib/thin/backends/unix_server.rb#34
  def close; end

  # Connect the server
  #
  # source://thin//lib/thin/backends/unix_server.rb#15
  def connect; end

  # Stops the server
  #
  # source://thin//lib/thin/backends/unix_server.rb#29
  def disconnect; end

  # UNIX domain socket on which the server is listening for connections.
  #
  # source://thin//lib/thin/backends/unix_server.rb#6
  def socket; end

  # UNIX domain socket on which the server is listening for connections.
  #
  # source://thin//lib/thin/backends/unix_server.rb#6
  def socket=(_arg0); end

  # source://thin//lib/thin/backends/unix_server.rb#38
  def to_s; end

  protected

  # source://thin//lib/thin/backends/unix_server.rb#43
  def remove_socket_file; end
end

# Run a command through the +thin+ command-line script.
#
# source://thin//lib/thin/command.rb#5
class Thin::Command
  include ::Thin::Logging

  # @return [Command] a new instance of Command
  #
  # source://thin//lib/thin/command.rb#14
  def initialize(name, options = T.unsafe(nil)); end

  # Send the command to the +thin+ script
  #
  # source://thin//lib/thin/command.rb#24
  def run; end

  # Turn into a runnable shell command
  #
  # @raise [ArgumentError]
  #
  # source://thin//lib/thin/command.rb#35
  def shellify; end

  class << self
    # source://thin//lib/thin/command.rb#19
    def run(*args); end

    # Path to the +thin+ script used to control the servers.
    # Leave this to default to use the one in the path.
    #
    # source://thin//lib/thin/command.rb#11
    def script; end

    # Path to the +thin+ script used to control the servers.
    # Leave this to default to use the one in the path.
    #
    # source://thin//lib/thin/command.rb#11
    def script=(_arg0); end
  end
end

# Connection between the server and client.
# This class is instanciated by EventMachine on each new connection
# that is opened.
#
# source://thin//lib/thin/connection.rb#7
class Thin::Connection < ::EventMachine::Connection
  include ::Thin::Logging

  # Rack application (adapter) served by this connection.
  #
  # source://thin//lib/thin/connection.rb#14
  def app; end

  # Rack application (adapter) served by this connection.
  #
  # source://thin//lib/thin/connection.rb#14
  def app=(_arg0); end

  # Backend to the server
  #
  # source://thin//lib/thin/connection.rb#17
  def backend; end

  # Backend to the server
  #
  # source://thin//lib/thin/connection.rb#17
  def backend=(_arg0); end

  # Allows this connection to be persistent.
  #
  # source://thin//lib/thin/connection.rb#172
  def can_persist!; end

  # Return +true+ if this connection is allowed to stay open and be persistent.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/connection.rb#177
  def can_persist?; end

  # source://thin//lib/thin/connection.rb#139
  def close_request_response; end

  # Return +true+ if the connection is open but is not
  # processing any user requests
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/connection.rb#189
  def idle?; end

  # Return +true+ if the connection must be left open
  # and ready to be reused for another request.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/connection.rb#183
  def persistent?; end

  # Get the connection ready to process a request.
  #
  # source://thin//lib/thin/connection.rb#30
  def post_init; end

  # source://thin//lib/thin/connection.rb#95
  def post_process(result); end

  # source://thin//lib/thin/connection.rb#63
  def pre_process; end

  # Called when all data was received and the request
  # is ready to be processed.
  #
  # source://thin//lib/thin/connection.rb#47
  def process; end

  # Called when data is received from the client.
  #
  # source://thin//lib/thin/connection.rb#36
  def receive_data(data); end

  # IP Address of the remote client.
  #
  # source://thin//lib/thin/connection.rb#201
  def remote_address; end

  # Current request served by the connection
  #
  # source://thin//lib/thin/connection.rb#20
  def request; end

  # Current request served by the connection
  #
  # source://thin//lib/thin/connection.rb#20
  def request=(_arg0); end

  # Next response sent through the connection
  #
  # source://thin//lib/thin/connection.rb#23
  def response; end

  # Next response sent through the connection
  #
  # source://thin//lib/thin/connection.rb#23
  def response=(_arg0); end

  # source://thin//lib/thin/connection.rb#57
  def ssl_verify_peer(cert); end

  # Does request and response cleanup (closes open IO streams and
  # deletes created temporary files).
  # Re-initializes response and request if client supports persistent
  # connection.
  #
  # source://thin//lib/thin/connection.rb#149
  def terminate_request; end

  # Calling the application in a threaded allowing
  # concurrent processing of requests.
  #
  # source://thin//lib/thin/connection.rb#27
  def threaded=(_arg0); end

  # +true+ if <tt>app.call</tt> will be called inside a thread.
  # You can set all requests as threaded setting <tt>Connection#threaded=true</tt>
  # or on a per-request case returning +true+ in <tt>app.deferred?</tt>.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/connection.rb#196
  def threaded?; end

  # Called when the connection is unbinded from the socket
  # and can no longer be used to process requests.
  #
  # source://thin//lib/thin/connection.rb#165
  def unbind; end

  # Logs information about an unexpected exceptional condition
  #
  # source://thin//lib/thin/connection.rb#135
  def unexpected_error(e); end

  protected

  # Returns IP address of peer as a string.
  #
  # source://thin//lib/thin/connection.rb#210
  def socket_address; end
end

# This is a template async response. N.B. Can't use string for body on 1.9
#
# source://thin//lib/thin/connection.rb#11
Thin::Connection::AsyncResponse = T.let(T.unsafe(nil), Array)

# Build and control Thin servers.
# Hey Controller pattern is not only for web apps yo!
#
# source://thin//lib/thin.rb#29
module Thin::Controllers; end

# Control a set of servers.
# * Generate start and stop commands and run them.
# * Inject the port or socket number in the pid and log filenames.
# Servers are started throught the +thin+ command-line script.
#
# source://thin//lib/thin/controllers/cluster.rb#12
class Thin::Controllers::Cluster < ::Thin::Controllers::Controller
  # Create a new cluster of servers launched using +options+.
  #
  # @return [Cluster] a new instance of Cluster
  #
  # source://thin//lib/thin/controllers/cluster.rb#21
  def initialize(options); end

  # source://thin//lib/thin/controllers/cluster.rb#28
  def address; end

  # source://thin//lib/thin/controllers/cluster.rb#27
  def first_port; end

  # source://thin//lib/thin/controllers/cluster.rb#31
  def log_file; end

  # source://thin//lib/thin/controllers/cluster.rb#123
  def log_file_for(number); end

  # source://thin//lib/thin/controllers/cluster.rb#34
  def onebyone; end

  # source://thin//lib/thin/controllers/cluster.rb#33
  def only; end

  # source://thin//lib/thin/controllers/cluster.rb#30
  def pid_file; end

  # source://thin//lib/thin/controllers/cluster.rb#127
  def pid_file_for(number); end

  # source://thin//lib/thin/controllers/cluster.rb#135
  def pid_for(number); end

  # Stop and start the servers.
  #
  # source://thin//lib/thin/controllers/cluster.rb#66
  def restart; end

  # source://thin//lib/thin/controllers/cluster.rb#113
  def server_id(number); end

  # source://thin//lib/thin/controllers/cluster.rb#32
  def size; end

  # source://thin//lib/thin/controllers/cluster.rb#29
  def socket; end

  # source://thin//lib/thin/controllers/cluster.rb#131
  def socket_for(number); end

  # Start the servers
  #
  # source://thin//lib/thin/controllers/cluster.rb#42
  def start; end

  # Start a single server
  #
  # source://thin//lib/thin/controllers/cluster.rb#47
  def start_server(number); end

  # Stop the servers
  #
  # source://thin//lib/thin/controllers/cluster.rb#54
  def stop; end

  # Stop a single server
  #
  # source://thin//lib/thin/controllers/cluster.rb#59
  def stop_server(number); end

  # @return [Boolean]
  #
  # source://thin//lib/thin/controllers/cluster.rb#37
  def swiftiply?; end

  # source://thin//lib/thin/controllers/cluster.rb#82
  def test_socket(number); end

  # source://thin//lib/thin/controllers/cluster.rb#35
  def wait; end

  # Make sure the server is running before moving on to the next one.
  #
  # source://thin//lib/thin/controllers/cluster.rb#93
  def wait_until_server_started(number); end

  private

  # Add the server port or number in the filename
  # so each instance get its own file
  #
  # source://thin//lib/thin/controllers/cluster.rb#172
  def include_server_number(path, number); end

  # Send the command to the +thin+ script
  #
  # source://thin//lib/thin/controllers/cluster.rb#141
  def run(cmd, number); end

  # source://thin//lib/thin/controllers/cluster.rb#154
  def with_each_server; end
end

# Cluster only options that should not be passed in the command sent
# to the indiviual servers.
#
# source://thin//lib/thin/controllers/cluster.rb#15
Thin::Controllers::Cluster::CLUSTER_OPTIONS = T.let(T.unsafe(nil), Array)

# Maximum wait time for the server to be restarted
#
# source://thin//lib/thin/controllers/cluster.rb#18
Thin::Controllers::Cluster::DEFAULT_WAIT_TIME = T.let(T.unsafe(nil), Integer)

# Controls one Thin server.
# Allow to start, stop, restart and configure a single thin server.
#
# source://thin//lib/thin/controllers/controller.rb#22
class Thin::Controllers::Controller
  include ::Thin::Logging

  # @return [Controller] a new instance of Controller
  #
  # source://thin//lib/thin/controllers/controller.rb#28
  def initialize(options); end

  # source://thin//lib/thin/controllers/controller.rb#110
  def config; end

  # Command line options passed to the thin script
  #
  # source://thin//lib/thin/controllers/controller.rb#26
  def options; end

  # Command line options passed to the thin script
  #
  # source://thin//lib/thin/controllers/controller.rb#26
  def options=(_arg0); end

  # @raise [OptionRequired]
  #
  # source://thin//lib/thin/controllers/controller.rb#100
  def restart; end

  # source://thin//lib/thin/controllers/controller.rb#37
  def start; end

  # @raise [OptionRequired]
  #
  # source://thin//lib/thin/controllers/controller.rb#90
  def stop; end

  protected

  # Acts like GNU tail command. Taken from Rails.
  #
  # source://thin//lib/thin/controllers/controller.rb#143
  def tail(file); end

  # Tail the log file of server +number+ during the execution of the block.
  #
  # source://thin//lib/thin/controllers/controller.rb#132
  def tail_log(log_file); end

  # Wait for a pid file to either be created or deleted.
  #
  # source://thin//lib/thin/controllers/controller.rb#122
  def wait_for_file(state, file); end

  private

  # source://thin//lib/thin/controllers/controller.rb#167
  def load_adapter; end

  # source://thin//lib/thin/controllers/controller.rb#175
  def load_rackup_config; end
end

# System service controller to launch all servers which
# config files are in a directory.
#
# source://thin//lib/thin/controllers/service.rb#7
class Thin::Controllers::Service < ::Thin::Controllers::Controller
  # @raise [PlatformNotSupported]
  # @return [Service] a new instance of Service
  #
  # source://thin//lib/thin/controllers/service.rb#12
  def initialize(options); end

  # source://thin//lib/thin/controllers/service.rb#18
  def config_path; end

  # source://thin//lib/thin/controllers/service.rb#34
  def install(config_files_path = T.unsafe(nil)); end

  # source://thin//lib/thin/controllers/service.rb#30
  def restart; end

  # source://thin//lib/thin/controllers/service.rb#22
  def start; end

  # source://thin//lib/thin/controllers/service.rb#26
  def stop; end

  private

  # source://thin//lib/thin/controllers/service.rb#62
  def run(command); end

  # source://thin//lib/thin/controllers/service.rb#70
  def sh(cmd); end
end

# source://thin//lib/thin/controllers/service.rb#9
Thin::Controllers::Service::DEFAULT_CONFIG_PATH = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/controllers/service.rb#8
Thin::Controllers::Service::INITD_PATH = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/controllers/service.rb#10
Thin::Controllers::Service::TEMPLATE = T.let(T.unsafe(nil), String)

# Module included in classes that can be turned into a daemon.
# Handle stuff like:
# * storing the PID in a file
# * redirecting output to the log file
# * changing process privileges
# * killing the process gracefully
#
# source://thin//lib/thin/daemonizing.rb#27
module Thin::Daemonizable
  mixes_in_class_methods ::Thin::Daemonizable::ClassMethods

  # Change privileges of the process
  # to the specified user and group.
  #
  # source://thin//lib/thin/daemonizing.rb#72
  def change_privilege(user, group = T.unsafe(nil)); end

  # Turns the current script into a daemon process that detaches from the console.
  #
  # @raise [PlatformNotSupported]
  #
  # source://thin//lib/thin/daemonizing.rb#45
  def daemonize; end

  # source://thin//lib/thin/daemonizing.rb#38
  def kill(timeout = T.unsafe(nil)); end

  # Returns the value of attribute log_file.
  #
  # source://thin//lib/thin/daemonizing.rb#28
  def log_file; end

  # Sets the attribute log_file
  #
  # @param value the value to set the attribute log_file to.
  #
  # source://thin//lib/thin/daemonizing.rb#28
  def log_file=(_arg0); end

  # Register a proc to be called to restart the server.
  #
  # source://thin//lib/thin/daemonizing.rb#97
  def on_restart(&block); end

  # source://thin//lib/thin/daemonizing.rb#34
  def pid; end

  # Returns the value of attribute pid_file.
  #
  # source://thin//lib/thin/daemonizing.rb#28
  def pid_file; end

  # Sets the attribute pid_file
  #
  # @param value the value to set the attribute pid_file to.
  #
  # source://thin//lib/thin/daemonizing.rb#28
  def pid_file=(_arg0); end

  # Restart the server.
  #
  # source://thin//lib/thin/daemonizing.rb#102
  def restart; end

  protected

  # source://thin//lib/thin/daemonizing.rb#176
  def remove_pid_file; end

  # If PID file is stale, remove it.
  #
  # source://thin//lib/thin/daemonizing.rb#187
  def remove_stale_pid_file; end

  # source://thin//lib/thin/daemonizing.rb#180
  def write_pid_file; end

  class << self
    # @private
    #
    # source://thin//lib/thin/daemonizing.rb#30
    def included(base); end
  end
end

# source://thin//lib/thin/daemonizing.rb#112
module Thin::Daemonizable::ClassMethods
  # source://thin//lib/thin/daemonizing.rb#160
  def force_kill(pid, pid_file); end

  # Send a QUIT or INT (if timeout is +0+) signal the process which
  # PID is stored in +pid_file+.
  # If the process is still running after +timeout+, KILL signal is
  # sent.
  #
  # source://thin//lib/thin/daemonizing.rb#117
  def kill(pid_file, timeout = T.unsafe(nil)); end

  # source://thin//lib/thin/daemonizing.rb#130
  def monotonic_time; end

  # source://thin//lib/thin/daemonizing.rb#166
  def read_pid_file(file); end

  # Restart the server by sending HUP signal.
  #
  # source://thin//lib/thin/daemonizing.rb#126
  def restart(pid_file); end

  # Send a +signal+ to the process which PID is stored in +pid_file+.
  #
  # source://thin//lib/thin/daemonizing.rb#135
  def send_signal(signal, pid_file, timeout = T.unsafe(nil)); end
end

# Every standard HTTP code mapped to the appropriate message.
# Stolent from Mongrel.
#
# source://thin//lib/thin/statuses.rb#4
Thin::HTTP_STATUS_CODES = T.let(T.unsafe(nil), Hash)

# Store HTTP header name-value pairs direcly to a string
# and allow duplicated entries on some names.
#
# source://thin//lib/thin/headers.rb#8
class Thin::Headers
  # @return [Headers] a new instance of Headers
  #
  # source://thin//lib/thin/headers.rb#13
  def initialize; end

  # Add <tt>key: value</tt> pair to the headers.
  # Ignore if already sent and no duplicates are allowed
  # for this +key+.
  #
  # source://thin//lib/thin/headers.rb#21
  def []=(key, value); end

  # @return [Boolean]
  #
  # source://thin//lib/thin/headers.rb#39
  def has_key?(key); end

  # source://thin//lib/thin/headers.rb#43
  def to_s; end
end

# source://thin//lib/thin/headers.rb#10
Thin::Headers::ALLOWED_DUPLICATES = T.let(T.unsafe(nil), Array)

# source://thin//lib/thin/headers.rb#11
Thin::Headers::CR_OR_LF = T.let(T.unsafe(nil), Regexp)

# source://thin//lib/thin/headers.rb#9
Thin::Headers::HEADER_FORMAT = T.let(T.unsafe(nil), String)

class Thin::HttpParser
  def initialize; end

  def error?; end
  def execute(_arg0, _arg1, _arg2); end
  def finish; end
  def finished?; end
  def nread; end
  def reset; end
end

# Raised when an header is not valid
# and the server can not process it.
#
# source://thin//lib/thin/headers.rb#4
class Thin::InvalidHeader < ::StandardError; end

# Raised when an option is not valid.
#
# source://thin//lib/thin/controllers/controller.rb#15
class Thin::InvalidOption < ::Thin::RunnerError; end

# Raised when an incoming request is not valid
# and the server can not process it.
#
# source://thin//lib/thin/request.rb#6
class Thin::InvalidRequest < ::IOError; end

# To be included in classes to allow some basic logging
# that can be silenced (<tt>Logging.silent=</tt>) or made
# more verbose.
# <tt>Logging.trace=</tt>:  log all raw request and response and
#                           messages logged with +trace+.
# <tt>Logging.silent=</tt>: silence all log all log messages
#                           altogether.
#
# source://thin//lib/thin/logging.rb#11
module Thin::Logging
  # For backwards compatibility
  #
  # source://thin//lib/thin/logging.rb#167
  def log(msg); end

  # Log a message at DEBUG level
  #
  # source://thin//lib/thin/logging.rb#142
  def log_debug(msg = T.unsafe(nil)); end

  # Log a message at ERROR level (and maybe a backtrace)
  #
  # source://thin//lib/thin/logging.rb#156
  def log_error(msg, e = T.unsafe(nil)); end

  # Log a message at INFO level
  #
  # source://thin//lib/thin/logging.rb#149
  def log_info(msg); end

  # source://thin//lib/thin/logging.rb#126
  def silent; end

  # source://thin//lib/thin/logging.rb#130
  def silent=(value); end

  # Log a message if tracing is activated
  #
  # source://thin//lib/thin/logging.rb#135
  def trace(msg = T.unsafe(nil)); end

  class << self
    # source://thin//lib/thin/logging.rb#115
    def debug=(val); end

    # Provided for backwards compatibility.
    # Callers should be using the +level+ (on the +Logging+ module
    # or on the instance) to figure out what the log level is.
    #
    # @return [Boolean]
    #
    # source://thin//lib/thin/logging.rb#112
    def debug?; end

    # source://thin//lib/thin/logging.rb#50
    def level; end

    # source://thin//lib/thin/logging.rb#54
    def level=(value); end

    # Log a message at DEBUG level
    #
    # source://thin//lib/thin/logging.rb#142
    def log_debug(msg = T.unsafe(nil)); end

    # Log a message at ERROR level (and maybe a backtrace)
    #
    # source://thin//lib/thin/logging.rb#156
    def log_error(msg, e = T.unsafe(nil)); end

    # Log a message at INFO level
    #
    # source://thin//lib/thin/logging.rb#149
    def log_info(msg); end

    # source://thin//lib/thin/logging.rb#99
    def log_msg(msg, level = T.unsafe(nil)); end

    # Returns the value of attribute logger.
    #
    # source://thin//lib/thin/logging.rb#23
    def logger; end

    # Allow user to specify a custom logger to use.
    # This object must respond to:
    # +level+, +level=+ and +debug+, +info+, +warn+, +error+, +fatal+
    #
    # source://thin//lib/thin/logging.rb#63
    def logger=(custom_logger); end

    # source://thin//lib/thin/logging.rb#38
    def silent=(shh); end

    # @return [Boolean]
    #
    # source://thin//lib/thin/logging.rb#46
    def silent?; end

    # Log a message if tracing is activated
    #
    # source://thin//lib/thin/logging.rb#135
    def trace(msg = T.unsafe(nil)); end

    # source://thin//lib/thin/logging.rb#26
    def trace=(enabled); end

    # @return [Boolean]
    #
    # source://thin//lib/thin/logging.rb#34
    def trace?; end

    # Returns the value of attribute trace_logger.
    #
    # source://thin//lib/thin/logging.rb#24
    def trace_logger; end

    # source://thin//lib/thin/logging.rb#81
    def trace_logger=(custom_tracer); end

    # source://thin//lib/thin/logging.rb#104
    def trace_msg(msg); end
  end
end

# Simple formatter which only displays the message.
# Taken from ActiveSupport
#
# source://thin//lib/thin/logging.rb#14
class Thin::Logging::SimpleFormatter < ::Logger::Formatter
  # source://thin//lib/thin/logging.rb#15
  def call(severity, timestamp, progname, msg); end
end

# source://thin//lib/thin/version.rb#18
Thin::NAME = T.let(T.unsafe(nil), String)

# Raised when a mandatory option is missing to run a command.
#
# source://thin//lib/thin/controllers/controller.rb#8
class Thin::OptionRequired < ::Thin::RunnerError
  # @return [OptionRequired] a new instance of OptionRequired
  #
  # source://thin//lib/thin/controllers/controller.rb#9
  def initialize(option); end
end

# Raised when the pid file already exist starting as a daemon.
#
# source://thin//lib/thin/daemonizing.rb#18
class Thin::PidFileExist < ::RuntimeError; end

# source://thin//lib/thin/daemonizing.rb#19
class Thin::PidFileNotFound < ::RuntimeError; end

# Raised when a feature is not supported on the
# current platform.
#
# source://thin//lib/thin/version.rb#4
class Thin::PlatformNotSupported < ::RuntimeError; end

# A request sent by the client to the server.
#
# source://thin//lib/thin/request.rb#9
class Thin::Request
  # @return [Request] a new instance of Request
  #
  # source://thin//lib/thin/request.rb#53
  def initialize; end

  # source://thin//lib/thin/request.rb#136
  def async_callback=(callback); end

  # source://thin//lib/thin/request.rb#141
  def async_close; end

  # Request body
  #
  # source://thin//lib/thin/request.rb#51
  def body; end

  # Close any resource used by the request
  #
  # source://thin//lib/thin/request.rb#150
  def close; end

  # Expected size of the body
  #
  # source://thin//lib/thin/request.rb#108
  def content_length; end

  # Unparsed data of the request
  #
  # source://thin//lib/thin/request.rb#48
  def data; end

  # CGI-like request environment variables
  #
  # source://thin//lib/thin/request.rb#45
  def env; end

  # +true+ if headers and body are finished parsing
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/request.rb#103
  def finished?; end

  # @return [Boolean]
  #
  # source://thin//lib/thin/request.rb#145
  def head?; end

  # Parse a chunk of data into the request environment
  # Raises an +InvalidRequest+ if invalid.
  # Returns +true+ if the parsing is complete.
  #
  # source://thin//lib/thin/request.rb#77
  def parse(data); end

  # Returns +true+ if the client expects the connection to be persistent.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/request.rb#113
  def persistent?; end

  # source://thin//lib/thin/request.rb#128
  def remote_address=(address); end

  # source://thin//lib/thin/request.rb#132
  def threaded=(value); end

  private

  # source://thin//lib/thin/request.rb#155
  def move_body_to_tempfile; end
end

# source://thin//lib/thin/request.rb#41
Thin::Request::ASYNC_CALLBACK = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#42
Thin::Request::ASYNC_CLOSE = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#13
Thin::Request::BODY_TMPFILE = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#31
Thin::Request::CLOSE_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://thin//lib/thin/request.rb#29
Thin::Request::CONNECTION = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#28
Thin::Request::CONTENT_LENGTH = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#32
Thin::Request::HEAD = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#26
Thin::Request::HTTP_1_0 = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#25
Thin::Request::HTTP_VERSION = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#16
Thin::Request::INITIAL_BODY = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#30
Thin::Request::KEEP_ALIVE_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://thin//lib/thin/request.rb#24
Thin::Request::LOCALHOST = T.let(T.unsafe(nil), String)

# Maximum request body size before it is moved out of memory
# and into a tempfile for reading.
#
# source://thin//lib/thin/request.rb#12
Thin::Request::MAX_BODY = T.let(T.unsafe(nil), Integer)

# source://thin//lib/thin/request.rb#14
Thin::Request::MAX_HEADER = T.let(T.unsafe(nil), Integer)

# source://thin//lib/thin/request.rb#37
Thin::Request::RACK_ERRORS = T.let(T.unsafe(nil), String)

# Freeze some Rack header names
#
# source://thin//lib/thin/request.rb#35
Thin::Request::RACK_INPUT = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#39
Thin::Request::RACK_MULTIPROCESS = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#38
Thin::Request::RACK_MULTITHREAD = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#40
Thin::Request::RACK_RUN_ONCE = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#36
Thin::Request::RACK_VERSION = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#27
Thin::Request::REMOTE_ADDR = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#23
Thin::Request::REQUEST_METHOD = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/request.rb#22
Thin::Request::SERVER_NAME = T.let(T.unsafe(nil), String)

# Freeze some HTTP header names & values
#
# source://thin//lib/thin/request.rb#21
Thin::Request::SERVER_SOFTWARE = T.let(T.unsafe(nil), String)

# A response sent to the client.
#
# source://thin//lib/thin/response.rb#3
class Thin::Response
  # @return [Response] a new instance of Response
  #
  # source://thin//lib/thin/response.rb#26
  def initialize; end

  # Response body, must respond to +each+.
  #
  # source://thin//lib/thin/response.rb#21
  def body; end

  # Response body, must respond to +each+.
  #
  # source://thin//lib/thin/response.rb#21
  def body=(_arg0); end

  # Close any resource used by the response
  #
  # source://thin//lib/thin/response.rb#82
  def close; end

  # Yields each chunk of the response.
  # To control the size of each chunk
  # define your own +each+ method on +body+.
  #
  # @yield [head]
  #
  # source://thin//lib/thin/response.rb#89
  def each; end

  # Top header of the response,
  # containing the status code and response headers.
  #
  # source://thin//lib/thin/response.rb#45
  def head; end

  # Headers key-value hash
  #
  # source://thin//lib/thin/response.rb#24
  def headers; end

  # Ruby 1.9 doesn't have a String#each anymore.
  # Rack spec doesn't take care of that yet, for now we just use
  # +each+ but fallback to +each_line+ on strings.
  # I wish we could remove that condition.
  # To be reviewed when a new Rack spec comes out.
  #
  # source://thin//lib/thin/response.rb#68
  def headers=(key_value_pairs); end

  # String representation of the headers
  # to be sent in the response.
  #
  # source://thin//lib/thin/response.rb#35
  def headers_output; end

  # Tell the client the connection should stay open
  #
  # source://thin//lib/thin/response.rb#102
  def persistent!; end

  # Persistent connection must be requested as keep-alive
  # from the server and have a Content-Length, or the response
  # status must require that the connection remain open.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/response.rb#109
  def persistent?; end

  # source://thin//lib/thin/response.rb#113
  def skip_body!; end

  # Status code
  #
  # source://thin//lib/thin/response.rb#18
  def status; end

  # Status code
  #
  # source://thin//lib/thin/response.rb#18
  def status=(_arg0); end
end

# source://thin//lib/thin/response.rb#15
Thin::Response::BAD_REQUEST = T.let(T.unsafe(nil), Array)

# source://thin//lib/thin/response.rb#5
Thin::Response::CLOSE = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/response.rb#4
Thin::Response::CONNECTION = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/response.rb#8
Thin::Response::CONTENT_LENGTH = T.let(T.unsafe(nil), String)

# Error Responses
#
# source://thin//lib/thin/response.rb#13
Thin::Response::ERROR = T.let(T.unsafe(nil), Array)

# source://thin//lib/thin/response.rb#6
Thin::Response::KEEP_ALIVE = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/response.rb#14
Thin::Response::PERSISTENT_ERROR = T.let(T.unsafe(nil), Array)

# source://thin//lib/thin/response.rb#10
Thin::Response::PERSISTENT_STATUSES = T.let(T.unsafe(nil), Array)

# source://thin//lib/thin/response.rb#7
Thin::Response::SERVER = T.let(T.unsafe(nil), String)

# An exception class to handle the event that server didn't start on time
#
# source://thin//lib/thin/controllers/cluster.rb#5
class Thin::RestartTimeout < ::RuntimeError; end

# CLI runner.
# Parse options and send command to the correct Controller.
#
# source://thin//lib/thin/runner.rb#9
class Thin::Runner
  # @return [Runner] a new instance of Runner
  #
  # source://thin//lib/thin/runner.rb#32
  def initialize(argv); end

  # Arguments to be passed to the command.
  #
  # source://thin//lib/thin/runner.rb#23
  def arguments; end

  # Arguments to be passed to the command.
  #
  # source://thin//lib/thin/runner.rb#23
  def arguments=(_arg0); end

  # +true+ if we're controlling a cluster.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/runner.rb#213
  def cluster?; end

  # Name of the command to be runned.
  #
  # source://thin//lib/thin/runner.rb#20
  def command; end

  # Name of the command to be runned.
  #
  # source://thin//lib/thin/runner.rb#20
  def command=(_arg0); end

  # Parsed options
  #
  # source://thin//lib/thin/runner.rb#17
  def options; end

  # Parsed options
  #
  # source://thin//lib/thin/runner.rb#17
  def options=(_arg0); end

  # Parse the options.
  #
  # source://thin//lib/thin/runner.rb#149
  def parse!; end

  # source://thin//lib/thin/runner.rb#54
  def parser; end

  # Parse the current shell arguments and run the command.
  # Exits on error.
  #
  # source://thin//lib/thin/runner.rb#157
  def run!; end

  # Send the command to the controller: single instance or cluster.
  #
  # source://thin//lib/thin/runner.rb#170
  def run_command; end

  # +true+ if we're acting a as system service.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/runner.rb#218
  def service?; end

  private

  # source://thin//lib/thin/runner.rb#223
  def load_options_from_config_file!; end

  # source://thin//lib/thin/runner.rb#229
  def ruby_require(file); end

  class << self
    # Return all available commands
    #
    # source://thin//lib/thin/runner.rb#26
    def commands; end
  end
end

# source://thin//lib/thin/runner.rb#10
Thin::Runner::COMMANDS = T.let(T.unsafe(nil), Array)

# Commands that wont load options from the config file
#
# source://thin//lib/thin/runner.rb#14
Thin::Runner::CONFIGLESS_COMMANDS = T.let(T.unsafe(nil), Array)

# source://thin//lib/thin/runner.rb#11
Thin::Runner::LINUX_ONLY_COMMANDS = T.let(T.unsafe(nil), Array)

# Error raised that will abort the process and print not backtrace.
#
# source://thin//lib/thin/controllers/controller.rb#5
class Thin::RunnerError < ::RuntimeError; end

# source://thin//lib/thin/version.rb#19
Thin::SERVER = T.let(T.unsafe(nil), String)

# The utterly famous Thin HTTP server.
# It listens for incoming requests through a given +backend+
# and forwards all requests to +app+.
#
# == TCP server
# Create a new TCP server bound to <tt>host:port</tt> by specifiying +host+
# and +port+ as the first 2 arguments.
#
#   Thin::Server.start('0.0.0.0', 3000, app)
#
# == UNIX domain server
# Create a new UNIX domain socket bound to +socket+ file by specifiying a filename
# as the first argument. Eg.: /tmp/thin.sock. If the first argument contains a <tt>/</tt>
# it will be assumed to be a UNIX socket.
#
#   Thin::Server.start('/tmp/thin.sock', app)
#
# == Using a custom backend
# You can implement your own way to connect the server to its client by creating your
# own Backend class and passing it as the :backend option.
#
#   Thin::Server.start('galaxy://faraway', 1345, app, :backend => Thin::Backends::MyFancyBackend)
#
# == Rack application (+app+)
# All requests will be processed through +app+, which must be a valid Rack adapter.
# A valid Rack adapter (application) must respond to <tt>call(env#Hash)</tt> and
# return an array of <tt>[status, headers, body]</tt>.
#
# == Building an app in place
# If a block is passed, a <tt>Rack::Builder</tt> instance
# will be passed to build the +app+. So you can do cool stuff like this:
#
#   Thin::Server.start('0.0.0.0', 3000) do
#     use Rack::CommonLogger
#     use Rack::ShowExceptions
#     map "/lobster" do
#       use Rack::Lint
#       run Rack::Lobster.new
#     end
#   end
#
# == Controlling with signals
# * INT and TERM: Force shutdown (see Server#stop!)
# * TERM & QUIT calls +stop+ to shutdown gracefully.
# * HUP calls +restart+ to ... surprise, restart!
# * USR1 reopen log files.
# Signals are processed at one second intervals.
# Disable signals by passing <tt>:signals => false</tt>.
#
# source://thin//lib/thin/server.rb#51
class Thin::Server
  include ::Thin::Logging
  include ::Thin::Daemonizable
  extend ::Thin::Daemonizable::ClassMethods
  extend ::Forwardable

  # @return [Server] a new instance of Server
  #
  # source://thin//lib/thin/server.rb#100
  def initialize(*args, &block); end

  # Application (Rack adapter) called with the request that produces the response.
  #
  # source://thin//lib/thin/server.rb#64
  def app; end

  # Application (Rack adapter) called with the request that produces the response.
  #
  # source://thin//lib/thin/server.rb#64
  def app=(_arg0); end

  # Backend handling the connections to the clients.
  #
  # source://thin//lib/thin/server.rb#70
  def backend; end

  # Backend handling the connections to the clients.
  #
  # source://thin//lib/thin/server.rb#70
  def backend=(_arg0); end

  # == Configure the server
  # The process might need to have superuser privilege to configure
  # server with optimal options.
  #
  # source://thin//lib/thin/server.rb#211
  def config; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def host(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def maximum_connections(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def maximum_connections=(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def maximum_persistent_connections(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def maximum_persistent_connections=(*args, **_arg1, &block); end

  # Name of the server and type of backend used.
  # This is also the name of the process in which Thin is running as a daemon.
  #
  # source://thin//lib/thin/server.rb#217
  def name; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def no_epoll(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def no_epoll=(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def port(*args, **_arg1, &block); end

  # == Reopen log file.
  # Reopen the log file and redirect STDOUT and STDERR to it.
  #
  # source://thin//lib/thin/server.rb#201
  def reopen_log; end

  # Return +true+ if the server is running and ready to receive requests.
  # Note that the server might still be running and return +false+ when
  # shuting down and waiting for active connections to complete.
  #
  # @return [Boolean]
  #
  # source://thin//lib/thin/server.rb#225
  def running?; end

  # source://forwardable/1.3.3/forwardable.rb#231
  def socket(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def ssl=(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def ssl?(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def ssl_options=(*args, **_arg1, &block); end

  # Start the server and listen for connections.
  #
  # @raise [ArgumentError]
  #
  # source://thin//lib/thin/server.rb#152
  def start; end

  # Start the server and listen for connections.
  #
  # @raise [ArgumentError]
  #
  # source://thin//lib/thin/server.rb#152
  def start!; end

  # == Gracefull shutdown
  # Stops the server after processing all current connections.
  # As soon as this method is called, the server stops accepting
  # new requests and waits for all current connections to finish.
  # Calling twice is the equivalent of calling <tt>stop!</tt>.
  #
  # source://thin//lib/thin/server.rb#171
  def stop; end

  # == Force shutdown
  # Stops the server closing all current connections right away.
  # This doesn't wait for connection to finish their work and send data.
  # All current requests will be dropped.
  #
  # source://thin//lib/thin/server.rb#187
  def stop!; end

  # A tag that will show in the process listing
  #
  # source://thin//lib/thin/server.rb#67
  def tag; end

  # A tag that will show in the process listing
  #
  # source://thin//lib/thin/server.rb#67
  def tag=(_arg0); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def threaded=(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def threaded?(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def threadpool_size(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def threadpool_size=(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def timeout(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def timeout=(*args, **_arg1, &block); end

  # Name of the server and type of backend used.
  # This is also the name of the process in which Thin is running as a daemon.
  #
  # source://thin//lib/thin/server.rb#217
  def to_s; end

  protected

  # source://thin//lib/thin/server.rb#247
  def handle_signals; end

  # Taken from Mongrel cgi_multipart_eof_fix
  # Ruby 1.8.5 has a security bug in cgi.rb, we need to patch it.
  #
  # source://thin//lib/thin/server.rb#277
  def load_cgi_multipart_eof_fix; end

  # source://thin//lib/thin/server.rb#261
  def select_backend(host, port, options); end

  # source://thin//lib/thin/server.rb#230
  def setup_signals; end

  class << self
    # Lil' shortcut to turn this:
    #
    #   Server.new(...).start
    #
    # into this:
    #
    #   Server.start(...)
    #
    # source://thin//lib/thin/server.rb#147
    def start(*args, &block); end
  end
end

# sec
#
# source://thin//lib/thin/server.rb#58
Thin::Server::DEFAULT_HOST = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/server.rb#60
Thin::Server::DEFAULT_MAXIMUM_CONNECTIONS = T.let(T.unsafe(nil), Integer)

# source://thin//lib/thin/server.rb#61
Thin::Server::DEFAULT_MAXIMUM_PERSISTENT_CONNECTIONS = T.let(T.unsafe(nil), Integer)

# source://thin//lib/thin/server.rb#59
Thin::Server::DEFAULT_PORT = T.let(T.unsafe(nil), Integer)

# Default values
#
# source://thin//lib/thin/server.rb#57
Thin::Server::DEFAULT_TIMEOUT = T.let(T.unsafe(nil), Integer)

# source://thin//lib/thin/stats.rb#4
module Thin::Stats; end

# Rack adapter to log stats about a Rack application.
#
# source://thin//lib/thin/stats.rb#6
class Thin::Stats::Adapter
  include ::ERB::Escape
  include ::ERB::Util

  # @return [Adapter] a new instance of Adapter
  #
  # source://thin//lib/thin/stats.rb#9
  def initialize(app, path = T.unsafe(nil)); end

  # source://thin//lib/thin/stats.rb#20
  def call(env); end

  # source://thin//lib/thin/stats.rb#28
  def log(env); end

  # source://thin//lib/thin/stats.rb#41
  def serve(env); end
end

# source://thin//lib/thin/backends/swiftiply_client.rb#32
class Thin::SwiftiplyConnection < ::Thin::Connection
  # source://thin//lib/thin/backends/swiftiply_client.rb#33
  def connection_completed; end

  # @return [Boolean]
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#37
  def persistent?; end

  # source://thin//lib/thin/backends/swiftiply_client.rb#41
  def unbind; end

  protected

  # For some reason Swiftiply request the current host
  #
  # source://thin//lib/thin/backends/swiftiply_client.rb#52
  def host_ip; end

  # source://thin//lib/thin/backends/swiftiply_client.rb#47
  def swiftiply_handshake(key); end
end

# Connection through a UNIX domain socket.
#
# source://thin//lib/thin/backends/unix_server.rb#50
class Thin::UnixConnection < ::Thin::Connection
  protected

  # source://thin//lib/thin/backends/unix_server.rb#52
  def socket_address; end
end

# source://thin//lib/thin/version.rb#6
module Thin::VERSION; end

# source://thin//lib/thin/version.rb#13
Thin::VERSION::CODENAME = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/version.rb#7
Thin::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://thin//lib/thin/version.rb#8
Thin::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# Rack protocol version
#
# source://thin//lib/thin/version.rb#15
Thin::VERSION::RACK = T.let(T.unsafe(nil), Array)

# source://thin//lib/thin/version.rb#11
Thin::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://thin//lib/thin/version.rb#9
Thin::VERSION::TINY = T.let(T.unsafe(nil), Integer)
