# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `sysinfo` gem.
# Please instead update this file by running `bin/tapioca gem sysinfo`.


# = SysInfo
#
# A container for the platform specific system information.
# Portions of this code were originally from Amazon's EC2 AMI tools,
# specifically lib/platform.rb.
#
# source://sysinfo//lib/sysinfo.rb#11
class SysInfo < ::Storable
  # @return [SysInfo] a new instance of SysInfo
  #
  # source://sysinfo//lib/sysinfo.rb#78
  def initialize; end

  # source://storable/0.10.0/lib/storable.rb#105
  def arch; end

  # source://storable/0.10.0/lib/storable.rb#121
  def arch=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def architecture; end

  # Return the hostname for the local machine
  #
  # source://sysinfo//lib/sysinfo.rb#115
  def find_hostname; end

  # Return the local IP address which receives external traffic
  # from: http://coderrr.wordpress.com/2008/05/28/get-your-local-ip-address/
  # NOTE: This <em>does not</em> open a connection to the IP address.
  #
  # source://sysinfo//lib/sysinfo.rb#136
  def find_ipaddress_internal; end

  # Returns [hostname, ipaddr (internal), uptime]
  #
  # source://sysinfo//lib/sysinfo.rb#103
  def find_network_info; end

  # Returns [vm, os, impl, arch]
  #
  # source://sysinfo//lib/sysinfo.rb#87
  def find_platform_info; end

  # Returns the local uptime in hours. Use Win32API in Windows,
  # 'sysctl -b kern.boottime' os osx, and 'who -b' on unix.
  # Based on Ruby Quiz solutions by: Matthias Reitinger
  # On Windows, see also: net statistics server
  #
  # source://sysinfo//lib/sysinfo.rb#121
  def find_uptime; end

  # Returns the path to the current user's home directory
  #
  # source://sysinfo//lib/sysinfo.rb#153
  def home; end

  # source://storable/0.10.0/lib/storable.rb#121
  def home=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def hostname; end

  # source://storable/0.10.0/lib/storable.rb#121
  def hostname=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def impl; end

  # source://storable/0.10.0/lib/storable.rb#121
  def impl=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def implementation; end

  # source://storable/0.10.0/lib/storable.rb#105
  def ipaddress_internal; end

  # source://storable/0.10.0/lib/storable.rb#121
  def ipaddress_internal=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def os; end

  # source://storable/0.10.0/lib/storable.rb#121
  def os=(val); end

  # Returns the environment paths as an Array
  #
  # source://sysinfo//lib/sysinfo.rb#151
  def paths; end

  # source://storable/0.10.0/lib/storable.rb#121
  def paths=(val); end

  # Returns a String of the full platform descriptor in the format: VM-OS-IMPL-ARCH
  # e.g. <tt>java-unix-osx-x86_64</tt>
  #
  # source://sysinfo//lib/sysinfo.rb#146
  def platform; end

  # source://storable/0.10.0/lib/storable.rb#105
  def ruby; end

  # source://storable/0.10.0/lib/storable.rb#121
  def ruby=(val); end

  # Returns the name of the current shell
  #
  # source://sysinfo//lib/sysinfo.rb#155
  def shell; end

  # source://storable/0.10.0/lib/storable.rb#121
  def shell=(val); end

  # Returns the path to the current temp directory
  #
  # source://sysinfo//lib/sysinfo.rb#157
  def tmpdir; end

  # source://storable/0.10.0/lib/storable.rb#121
  def tmpdir=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def uptime; end

  # source://storable/0.10.0/lib/storable.rb#121
  def uptime=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def user; end

  # source://storable/0.10.0/lib/storable.rb#121
  def user=(val); end

  # source://storable/0.10.0/lib/storable.rb#105
  def vm; end

  # source://storable/0.10.0/lib/storable.rb#121
  def vm=(val); end

  private

  # Look for and execute a platform specific method.
  # The name of the method will be in the format: +dtype-VM-OS-IMPL+.
  # e.g. find_uptime_ruby_unix_osx
  #
  # source://sysinfo//lib/sysinfo.rb#165
  def execute_platform_specific(dtype); end

  # This should work for most unix flavours.
  #
  # source://sysinfo//lib/sysinfo.rb#224
  def find_uptime_java_unix_osx; end

  # Ya, this is kinda wack. Ruby -> Java -> Kernel32. See:
  # http://www.oreillynet.com/ruby/blog/2008/01/jruby_meets_the_windows_api_1.html
  # http://msdn.microsoft.com/en-us/library/ms724408(VS.85).aspx
  # Ruby 1.9.1: Win32API is now deprecated in favor of using the DL library.
  #
  # source://sysinfo//lib/sysinfo.rb#208
  def find_uptime_java_windows_windows; end

  # This should work for most unix flavours.
  #
  # source://sysinfo//lib/sysinfo.rb#224
  def find_uptime_ruby_unix; end

  # source://sysinfo//lib/sysinfo.rb#218
  def find_uptime_ruby_unix_osx; end

  # source://sysinfo//lib/sysinfo.rb#213
  def find_uptime_ruby_windows_windows; end

  # Returns a named attribute of the user's /etc/password entry, or nil.
  # As an example, `getpwdattr(:home)` will return the user's home directory
  # without relying on ENV['HOME'] being present.
  #
  # source://sysinfo//lib/sysinfo.rb#273
  def getpwattr(pwattr); end

  # Determine the values for vm, os, impl, and arch when running on Java.
  #
  # source://sysinfo//lib/sysinfo.rb#231
  def guess_java; end

  # source://sysinfo//lib/sysinfo.rb#196
  def home_java; end

  # source://sysinfo//lib/sysinfo.rb#194
  def home_ruby_unix; end

  # source://sysinfo//lib/sysinfo.rb#195
  def home_ruby_windows; end

  # Returns the local IP address based on the hostname.
  # According to coderrr (see comments on blog link above), this implementation
  # doesn't guarantee that it will return the address for the interface external
  # traffic goes through. It's also possible the hostname isn't resolvable to the
  # local IP.
  #
  # NOTE: This code predates the current ip_address_internal. It was just as well
  # but the other code is cleaner. I'm keeping this old version here for now.
  #
  # source://sysinfo//lib/sysinfo.rb#260
  def ip_address_internal_alt; end

  # source://sysinfo//lib/sysinfo.rb#177
  def paths_java; end

  # source://sysinfo//lib/sysinfo.rb#175
  def paths_ruby_unix; end

  # Not tested!
  #
  # source://sysinfo//lib/sysinfo.rb#176
  def paths_ruby_windows; end

  # source://sysinfo//lib/sysinfo.rb#189
  def shell_java_unix; end

  # source://sysinfo//lib/sysinfo.rb#190
  def shell_java_windows; end

  # source://sysinfo//lib/sysinfo.rb#189
  def shell_ruby_unix; end

  # source://sysinfo//lib/sysinfo.rb#190
  def shell_ruby_windows; end

  # source://sysinfo//lib/sysinfo.rb#184
  def tmpdir_java; end

  # source://sysinfo//lib/sysinfo.rb#182
  def tmpdir_ruby_unix; end

  # source://sysinfo//lib/sysinfo.rb#183
  def tmpdir_ruby_windows; end
end

# source://sysinfo//lib/sysinfo.rb#45
SysInfo::ARCHITECTURES = T.let(T.unsafe(nil), Array)

# source://sysinfo//lib/sysinfo.rb#14
SysInfo::IMPLEMENTATIONS = T.let(T.unsafe(nil), Array)

# source://sysinfo//lib/sysinfo.rb#13
SysInfo::VERSION = T.let(T.unsafe(nil), String)
