# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `sendgrid-ruby` gem.
# Please instead update this file by running `bin/tapioca gem sendgrid-ruby`.


# Initialize the HTTP client
#
# source://sendgrid-ruby//lib/sendgrid/base_interface.rb#5
class BaseInterface
  # * *Args* :
  #   - +auth+ -> authorization header value
  #   - +host+ -> the base URL for the API
  #   - +request_headers+ -> any headers that you want to be globally applied
  #   - +version+ -> the version of the API you wish to access,
  #                  currently only "v3" is supported
  #   - +impersonate_subuser+ -> the subuser to impersonate, will be passed
  #                              in the "On-Behalf-Of" header
  #   - +http_options+ -> http options that you want to be globally applied to each request
  #
  # @return [BaseInterface] a new instance of BaseInterface
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#19
  def initialize(auth:, host:, request_headers: T.unsafe(nil), version: T.unsafe(nil), impersonate_subuser: T.unsafe(nil), http_options: T.unsafe(nil)); end

  # Returns the value of attribute client.
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#6
  def client; end

  # Sets the attribute client
  #
  # @param value the value to set the attribute client to.
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#6
  def client=(_arg0); end

  # Returns the value of attribute host.
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#7
  def host; end

  # Returns the value of attribute http_options.
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#7
  def http_options; end

  # Returns the value of attribute impersonate_subuser.
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#7
  def impersonate_subuser; end

  # Returns the value of attribute request_headers.
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#7
  def request_headers; end

  # Client libraries contain setters for specifying region/edge.
  # This supports global and eu regions only. This set will likely expand in the future.
  # Global is the default residency (or region)
  # Global region means the message will be sent through https://api.sendgrid.com
  # EU region means the message will be sent through https://api.eu.sendgrid.com
  # Parameters:
  # - region(String) : specify the region. Currently supports "global" and "eu"
  #
  # @raise [ArgumentError]
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#48
  def sendgrid_data_residency(region:); end

  # Returns the value of attribute version.
  #
  # source://sendgrid-ruby//lib/sendgrid/base_interface.rb#7
  def version; end
end

# source://sendgrid-ruby//lib/rack/sendgrid_webhook_verification.rb#3
module Rack
  class << self
    # source://rack/2.2.9/lib/rack/version.rb#26
    def release; end

    # source://rack/2.2.9/lib/rack/version.rb#19
    def version; end
  end
end

# Middleware that verifies webhooks from SendGrid using the EventWebhook
# verifier.
#
# The middleware takes a public key with which to set up the request
# validator and any number of paths. When a path matches the incoming request
# path, the request will be verified using the signature and timestamp of the
# request.
#
# Example:
#
# require 'rack'
# use Rack::SendGridWebhookVerification, ENV['PUBLIC_KEY'], /\/emails/
#
# The above appends this middleware to the stack, using a public key saved in
# the ENV and only against paths that match /\/emails/. If the request
# validates then it gets passed on to the action as normal. If the request
# doesn't validate then the middleware responds immediately with a 403 status.
#
# source://sendgrid-ruby//lib/rack/sendgrid_webhook_verification.rb#21
class Rack::SendGridWebhookVerification
  # @return [SendGridWebhookVerification] a new instance of SendGridWebhookVerification
  #
  # source://sendgrid-ruby//lib/rack/sendgrid_webhook_verification.rb#22
  def initialize(app, public_key, *paths); end

  # source://sendgrid-ruby//lib/rack/sendgrid_webhook_verification.rb#28
  def call(env); end
end

# Quickly and easily access the Twilio SendGrid API.
#
# source://sendgrid-ruby//lib/sendgrid/version.rb#1
module SendGrid; end

# source://sendgrid-ruby//lib/sendgrid/sendgrid.rb#3
class SendGrid::API < ::BaseInterface
  # * *Args* :
  #   - +api_key+ -> your Twilio SendGrid API key
  #   - +host+ -> the base URL for the API
  #   - +request_headers+ -> any headers that you want to be globally applied
  #   - +version+ -> the version of the API you wish to access,
  #                  currently only "v3" is supported
  #   - +impersonate_subuser+ -> the subuser to impersonate, will be passed
  #                              in the "On-Behalf-Of" header
  #   - +http_options+ -> http options that you want to be globally applied to each request
  #
  # @return [API] a new instance of API
  #
  # source://sendgrid-ruby//lib/sendgrid/sendgrid.rb#14
  def initialize(api_key:, host: T.unsafe(nil), request_headers: T.unsafe(nil), version: T.unsafe(nil), impersonate_subuser: T.unsafe(nil), http_options: T.unsafe(nil)); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/asm.rb#4
class SendGrid::ASM
  # @return [ASM] a new instance of ASM
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/asm.rb#7
  def initialize(group_id: T.unsafe(nil), groups_to_display: T.unsafe(nil)); end

  # Returns the value of attribute group_id.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/asm.rb#5
  def group_id; end

  # Sets the attribute group_id
  #
  # @param value the value to set the attribute group_id to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/asm.rb#5
  def group_id=(_arg0); end

  # Returns the value of attribute groups_to_display.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/asm.rb#5
  def groups_to_display; end

  # Sets the attribute groups_to_display
  #
  # @param value the value to set the attribute groups_to_display to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/asm.rb#5
  def groups_to_display=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/asm.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#4
class SendGrid::Attachment
  # @return [Attachment] a new instance of Attachment
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#7
  def initialize; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#20
  def content; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#15
  def content=(content); end

  # Returns the value of attribute content_id.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def content_id; end

  # Sets the attribute content_id
  #
  # @param value the value to set the attribute content_id to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def content_id=(_arg0); end

  # Returns the value of attribute disposition.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def disposition; end

  # Sets the attribute disposition
  #
  # @param value the value to set the attribute disposition to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def disposition=(_arg0); end

  # Returns the value of attribute filename.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def filename; end

  # Sets the attribute filename
  #
  # @param value the value to set the attribute filename to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def filename=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#30
  def to_json(*_arg0); end

  # Returns the value of attribute type.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def type; end

  # Sets the attribute type
  #
  # @param value the value to set the attribute type to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#5
  def type=(_arg0); end

  private

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/attachment.rb#42
  def encode(io); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/bcc_settings.rb#4
class SendGrid::BccSettings
  # @return [BccSettings] a new instance of BccSettings
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bcc_settings.rb#7
  def initialize(enable: T.unsafe(nil), email: T.unsafe(nil)); end

  # Returns the value of attribute email.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bcc_settings.rb#5
  def email; end

  # Sets the attribute email
  #
  # @param value the value to set the attribute email to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bcc_settings.rb#5
  def email=(_arg0); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bcc_settings.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bcc_settings.rb#5
  def enable=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bcc_settings.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#4
class SendGrid::BypassListManagement
  # @return [BypassListManagement] a new instance of BypassListManagement
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#7
  def initialize(enable: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#5
  def enable=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#11
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/category.rb#2
class SendGrid::Category
  # @return [Category] a new instance of Category
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/category.rb#5
  def initialize(name: T.unsafe(nil)); end

  # Returns the value of attribute name.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/category.rb#3
  def category; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/category.rb#3
  def category=(_arg0); end

  # Returns the value of attribute name.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/category.rb#3
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/category.rb#3
  def name=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/category.rb#9
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/click_tracking.rb#4
class SendGrid::ClickTracking
  # @return [ClickTracking] a new instance of ClickTracking
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/click_tracking.rb#7
  def initialize(enable: T.unsafe(nil), enable_text: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/click_tracking.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/click_tracking.rb#5
  def enable=(_arg0); end

  # Returns the value of attribute enable_text.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/click_tracking.rb#5
  def enable_text; end

  # Sets the attribute enable_text
  #
  # @param value the value to set the attribute enable_text to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/click_tracking.rb#5
  def enable_text=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/click_tracking.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/content.rb#4
class SendGrid::Content
  # @return [Content] a new instance of Content
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/content.rb#7
  def initialize(type: T.unsafe(nil), value: T.unsafe(nil)); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/content.rb#12
  def to_json(*_arg0); end

  # Returns the value of attribute type.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/content.rb#5
  def type; end

  # Sets the attribute type
  #
  # @param value the value to set the attribute type to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/content.rb#5
  def type=(_arg0); end

  # Returns the value of attribute value.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/content.rb#5
  def value; end

  # Sets the attribute value
  #
  # @param value the value to set the attribute value to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/content.rb#5
  def value=(_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/custom_arg.rb#4
class SendGrid::CustomArg
  # @return [CustomArg] a new instance of CustomArg
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/custom_arg.rb#7
  def initialize(key: T.unsafe(nil), value: T.unsafe(nil)); end

  # Returns the value of attribute custom_arg.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/custom_arg.rb#5
  def custom_arg; end

  # Sets the attribute custom_arg
  #
  # @param value the value to set the attribute custom_arg to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/custom_arg.rb#5
  def custom_arg=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/custom_arg.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#92
class SendGrid::DuplicatePersonalizationError < ::StandardError; end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#4
class SendGrid::Email
  # @param email [String] required e-mail address
  # @param name [String] optionally personification
  # @return [Email] a new instance of Email
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#9
  def initialize(email:, name: T.unsafe(nil)); end

  # Returns the value of attribute email.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#5
  def email; end

  # Sets the attribute email
  #
  # @param value the value to set the attribute email to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#5
  def email=(_arg0); end

  # Returns the value of attribute name.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#5
  def name; end

  # Sets the attribute name
  #
  # @param value the value to set the attribute name to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#5
  def name=(_arg0); end

  # @raise [ArgumentError]
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#18
  def split_email(email); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/email.rb#25
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#4
class SendGrid::EmailStats
  # @return [EmailStats] a new instance of EmailStats
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#5
  def initialize(args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#9
  def by_day(start_date, end_date, categories = T.unsafe(nil), subusers = T.unsafe(nil)); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#17
  def by_month(start_date, end_date, categories = T.unsafe(nil), subusers = T.unsafe(nil)); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#13
  def by_week(start_date, end_date, categories = T.unsafe(nil), subusers = T.unsafe(nil)); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#21
  def get(aggregated_by, start_date, end_date, categories = T.unsafe(nil), subusers = T.unsafe(nil)); end

  private

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#41
  def build_response(response_body); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/email_stats.rb#30
  def query_params(aggregated_by, start_date, end_date, categories, subusers); end
end

# This class allows you to use the Event Webhook feature. Read the docs for
# more details: https://sendgrid.com/docs/for-developers/tracking-events/event
#
# source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#8
class SendGrid::EventWebhook
  # * *Args* :
  #   - +public_key+ -> verification key under Mail Settings
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#12
  def convert_public_key_to_ecdsa(public_key); end

  # @raise [NotSupportedError]
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#32
  def verify_engine; end

  # * *Args* :
  #   - +public_key+ -> elliptic curve public key
  #   - +payload+ -> event payload in the request body
  #   - +signature+ -> signature value obtained from the 'X-Twilio-Email-Event-Webhook-Signature' header
  #   - +timestamp+ -> timestamp value obtained from the 'X-Twilio-Email-Event-Webhook-Timestamp' header
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#22
  def verify_signature(public_key, payload, signature, timestamp); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#37
class SendGrid::EventWebhook::Error < ::RuntimeError; end

# source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#40
class SendGrid::EventWebhook::NotSupportedError < ::SendGrid::EventWebhook::Error; end

# This class lists headers that get posted to the webhook. Read the docs for
# more details: https://sendgrid.com/docs/for-developers/tracking-events/event
#
# source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#46
class SendGrid::EventWebhookHeader; end

# source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#47
SendGrid::EventWebhookHeader::SIGNATURE = T.let(T.unsafe(nil), String)

# source://sendgrid-ruby//lib/sendgrid/helpers/eventwebhook/eventwebhook.rb#48
SendGrid::EventWebhookHeader::TIMESTAMP = T.let(T.unsafe(nil), String)

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#4
class SendGrid::Footer
  # @return [Footer] a new instance of Footer
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#7
  def initialize(enable: T.unsafe(nil), text: T.unsafe(nil), html: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#5
  def enable=(_arg0); end

  # Returns the value of attribute html.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#5
  def html; end

  # Sets the attribute html
  #
  # @param value the value to set the attribute html to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#5
  def html=(_arg0); end

  # Returns the value of attribute text.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#5
  def text; end

  # Sets the attribute text
  #
  # @param value the value to set the attribute text to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#5
  def text=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/footer.rb#13
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#4
class SendGrid::Ganalytics
  # @return [Ganalytics] a new instance of Ganalytics
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#7
  def initialize(enable: T.unsafe(nil), utm_source: T.unsafe(nil), utm_medium: T.unsafe(nil), utm_term: T.unsafe(nil), utm_content: T.unsafe(nil), utm_campaign: T.unsafe(nil), utm_name: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def enable=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#17
  def to_json(*_arg0); end

  # Returns the value of attribute utm_campaign.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_campaign; end

  # Sets the attribute utm_campaign
  #
  # @param value the value to set the attribute utm_campaign to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_campaign=(_arg0); end

  # Returns the value of attribute utm_content.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_content; end

  # Sets the attribute utm_content
  #
  # @param value the value to set the attribute utm_content to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_content=(_arg0); end

  # Returns the value of attribute utm_medium.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_medium; end

  # Sets the attribute utm_medium
  #
  # @param value the value to set the attribute utm_medium to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_medium=(_arg0); end

  # Returns the value of attribute utm_name.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_name; end

  # Sets the attribute utm_name
  #
  # @param value the value to set the attribute utm_name to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_name=(_arg0); end

  # Returns the value of attribute utm_source.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_source; end

  # Sets the attribute utm_source
  #
  # @param value the value to set the attribute utm_source to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_source=(_arg0); end

  # Returns the value of attribute utm_term.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_term; end

  # Sets the attribute utm_term
  #
  # @param value the value to set the attribute utm_term to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/ganalytics.rb#5
  def utm_term=(_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/header.rb#4
class SendGrid::Header
  # @return [Header] a new instance of Header
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/header.rb#7
  def initialize(key: T.unsafe(nil), value: T.unsafe(nil)); end

  # Returns the value of attribute header.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/header.rb#5
  def header; end

  # Sets the attribute header
  #
  # @param value the value to set the attribute header to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/header.rb#5
  def header=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/header.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/ip_management/ip_management.rb#4
class SendGrid::IpManagement
  # @return [IpManagement] a new instance of IpManagement
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/ip_management/ip_management.rb#7
  def initialize(sendgrid_client:); end

  # Returns the value of attribute sendgrid_client.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/ip_management/ip_management.rb#5
  def sendgrid_client; end

  # Sets the attribute sendgrid_client
  #
  # @param value the value to set the attribute sendgrid_client to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/ip_management/ip_management.rb#5
  def sendgrid_client=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/ip_management/ip_management.rb#11
  def unassigned; end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#6
class SendGrid::Mail
  # We allow for all nil values here to create uninitialized Mail objects
  # (e.g. <project-root>/use-cases/transactional-templates.md)
  #
  # @return [Mail] a new instance of Mail
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#13
  def initialize(from_email = T.unsafe(nil), subj = T.unsafe(nil), to_email = T.unsafe(nil), cont = T.unsafe(nil)); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#61
  def add_attachment(attachment); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#65
  def add_category(category); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#50
  def add_content(content); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#79
  def add_custom_arg(custom_arg); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#74
  def add_header(header); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#46
  def add_personalization(personalization); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#69
  def add_section(section); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#84
  def asm; end

  # Sets the attribute asm
  #
  # @param value the value to set the attribute asm to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#9
  def asm=(_arg0); end

  # Returns the value of attribute attachments.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#8
  def attachments; end

  # Returns the value of attribute batch_id.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def batch_id; end

  # Sets the attribute batch_id
  #
  # @param value the value to set the attribute batch_id to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def batch_id=(_arg0); end

  # Returns the value of attribute categories.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#8
  def categories; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#54
  def check_for_secrets(patterns); end

  # Returns the value of attribute contents.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#8
  def contents; end

  # Returns the value of attribute custom_args.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#8
  def custom_args; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#42
  def from; end

  # Sets the attribute from
  #
  # @param value the value to set the attribute from to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#9
  def from=(_arg0); end

  # Returns the value of attribute headers.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#8
  def headers; end

  # Returns the value of attribute ip_pool_name.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def ip_pool_name; end

  # Sets the attribute ip_pool_name
  #
  # @param value the value to set the attribute ip_pool_name to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def ip_pool_name=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#88
  def mail_settings; end

  # Sets the attribute mail_settings
  #
  # @param value the value to set the attribute mail_settings to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#9
  def mail_settings=(_arg0); end

  # Returns the value of attribute personalizations.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#8
  def personalizations; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#96
  def reply_to; end

  # Sets the attribute reply_to
  #
  # @param value the value to set the attribute reply_to to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#9
  def reply_to=(_arg0); end

  # Returns the value of attribute sections.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#8
  def sections; end

  # Returns the value of attribute send_at.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def send_at; end

  # Sets the attribute send_at
  #
  # @param value the value to set the attribute send_at to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def send_at=(_arg0); end

  # Returns the value of attribute subject.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def subject; end

  # Sets the attribute subject
  #
  # @param value the value to set the attribute subject to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def subject=(_arg0); end

  # Returns the value of attribute template_id.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def template_id; end

  # Sets the attribute template_id
  #
  # @param value the value to set the attribute template_id to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#7
  def template_id=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#100
  def to_json(*_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#92
  def tracking_settings; end

  # Sets the attribute tracking_settings
  #
  # @param value the value to set the attribute tracking_settings to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail.rb#9
  def tracking_settings=(_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#4
class SendGrid::MailSettings
  # @return [MailSettings] a new instance of MailSettings
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#7
  def initialize; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#27
  def bcc; end

  # Sets the attribute bcc
  #
  # @param value the value to set the attribute bcc to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#5
  def bcc=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#19
  def bypass_list_management; end

  # Sets the attribute bypass_list_management
  #
  # @param value the value to set the attribute bypass_list_management to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#5
  def bypass_list_management=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#23
  def footer; end

  # Sets the attribute footer
  #
  # @param value the value to set the attribute footer to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#5
  def footer=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#15
  def sandbox_mode; end

  # Sets the attribute sandbox_mode
  #
  # @param value the value to set the attribute sandbox_mode to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#5
  def sandbox_mode=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#31
  def spam_check; end

  # Sets the attribute spam_check
  #
  # @param value the value to set the attribute spam_check to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#5
  def spam_check=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/mail_settings.rb#35
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#2
class SendGrid::MailSettingsDto
  # Returns the value of attribute address_whitelist.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def address_whitelist; end

  # Returns the value of attribute bcc.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def bcc; end

  # Returns the value of attribute bounce_purge.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def bounce_purge; end

  # Returns the value of attribute footer.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def footer; end

  # Returns the value of attribute forward_bounce.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def forward_bounce; end

  # Returns the value of attribute forward_spam.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def forward_spam; end

  # Returns the value of attribute plain_content.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def plain_content; end

  # Returns the value of attribute spam_check.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def spam_check; end

  # Returns the value of attribute template.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#3
  def template; end

  class << self
    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#5
    def fetch(sendgrid_client:, name:, query_params:); end

    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/mail_settings_dto.rb#9
    def update(sendgrid_client:, name:, request_body:); end
  end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#2
class SendGrid::Metrics
  # @return [Metrics] a new instance of Metrics
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#9
  def initialize(args = T.unsafe(nil)); end

  # Returns the value of attribute blocks.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def blocks; end

  # Returns the value of attribute bounce_drops.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def bounce_drops; end

  # Returns the value of attribute bounces.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def bounces; end

  # Returns the value of attribute clicks.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def clicks; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#29
  def date; end

  # Returns the value of attribute deferred.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def deferred; end

  # Returns the value of attribute delivered.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def delivered; end

  # Returns the value of attribute invalid_emails.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def invalid_emails; end

  # Returns the value of attribute opens.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def opens; end

  # Returns the value of attribute processed.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def processed; end

  # Returns the value of attribute requests.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def requests; end

  # Returns the value of attribute spam_report_drops.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def spam_report_drops; end

  # Returns the value of attribute spam_reports.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def spam_reports; end

  # Returns the value of attribute unique_clicks.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def unique_clicks; end

  # Returns the value of attribute unique_opens.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def unique_opens; end

  # Returns the value of attribute unsubscribe_drops.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def unsubscribe_drops; end

  # Returns the value of attribute unsubscribes.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/metrics.rb#3
  def unsubscribes; end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/open_tracking.rb#4
class SendGrid::OpenTracking
  # @return [OpenTracking] a new instance of OpenTracking
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/open_tracking.rb#7
  def initialize(enable: T.unsafe(nil), substitution_tag: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/open_tracking.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/open_tracking.rb#5
  def enable=(_arg0); end

  # Returns the value of attribute substitution_tag.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/open_tracking.rb#5
  def substitution_tag; end

  # Sets the attribute substitution_tag
  #
  # @param value the value to set the attribute substitution_tag to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/open_tracking.rb#5
  def substitution_tag=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/open_tracking.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/settings/partner_settings_dto.rb#2
class SendGrid::PartnerSettingsDto
  # Returns the value of attribute new_relic.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/partner_settings_dto.rb#3
  def new_relic; end

  class << self
    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/partner_settings_dto.rb#5
    def fetch(sendgrid_client:, name:, query_params:); end

    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/partner_settings_dto.rb#9
    def update(sendgrid_client:, name:, request_body:); end
  end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#4
class SendGrid::Personalization
  # @return [Personalization] a new instance of Personalization
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#10
  def initialize; end

  # @raise [DuplicatePersonalizationError]
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#39
  def add_bcc(bcc); end

  # @raise [DuplicatePersonalizationError]
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#33
  def add_cc(cc); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#55
  def add_custom_arg(custom_arg); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#60
  def add_dynamic_template_data(dynamic_template_data); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#29
  def add_from(from); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#45
  def add_header(header); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#50
  def add_substitution(substitution); end

  # @raise [DuplicatePersonalizationError]
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#23
  def add_to(to); end

  # Returns the value of attribute bccs.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def bccs; end

  # Returns the value of attribute ccs.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def ccs; end

  # Returns the value of attribute custom_args.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def custom_args; end

  # Returns the value of attribute dynamic_template_data.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def dynamic_template_data; end

  # Returns the value of attribute from.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def from; end

  # Returns the value of attribute headers.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def headers; end

  # Returns the value of attribute send_at.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#8
  def send_at; end

  # Sets the attribute send_at
  #
  # @param value the value to set the attribute send_at to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#8
  def send_at=(_arg0); end

  # Returns the value of attribute subject.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#8
  def subject; end

  # Sets the attribute subject
  #
  # @param value the value to set the attribute subject to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#8
  def subject=(_arg0); end

  # Returns the value of attribute substitutions.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def substitutions; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#64
  def to_json(*_arg0); end

  # Returns the value of attribute tos.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#5
  def tos; end

  private

  # @return [Boolean]
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/personalization.rb#81
  def duplicate?(addition); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#18
class SendGrid::SandBoxMode
  # @return [SandBoxMode] a new instance of SandBoxMode
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#21
  def initialize(enable: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#19
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#19
  def enable=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/bypass_list_management.rb#25
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#5
class SendGrid::Scope
  class << self
    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def access_settings_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def access_settings_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#9
    def admin_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def alerts_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def alerts_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def api_keys_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def api_keys_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def asm_groups_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def asm_groups_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def billing_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def billing_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def categories_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def categories_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def credentials_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def credentials_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def ips_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def ips_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def mail_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def mail_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def mail_settings_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def mail_settings_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def marketing_campaigns_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def marketing_campaigns_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def partner_settings_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def partner_settings_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#13
    def read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def scheduled_sends_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def scheduled_sends_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def stats_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def stats_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def subusers_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def subusers_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def suppression_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def suppression_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def teammates_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def teammates_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def templates_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def templates_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def tracking_settings_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def tracking_settings_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def user_settings_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def user_settings_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def webhooks_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def webhooks_read_only_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#22
    def whitelabel_full_access_permissions; end

    # source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#18
    def whitelabel_read_only_permissions; end
  end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/permissions/scope.rb#6
SendGrid::Scope::SCOPES = T.let(T.unsafe(nil), Hash)

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/section.rb#4
class SendGrid::Section
  # @return [Section] a new instance of Section
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/section.rb#7
  def initialize(key: T.unsafe(nil), value: T.unsafe(nil)); end

  # Returns the value of attribute section.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/section.rb#5
  def section; end

  # Sets the attribute section
  #
  # @param value the value to set the attribute section to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/section.rb#5
  def section=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/section.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#7
class SendGrid::Settings
  # @return [Settings] a new instance of Settings
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#13
  def initialize(sendgrid_client:); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def address_whitelist(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def bcc(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def bounce_purge(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def click(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def click_tracking(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def enforced_tls(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def footer(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def forward_bounce(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def forward_spam(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def google_analytics(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def new_relic(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def open(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def open_tracking(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def plain_content(**args); end

  # Returns the value of attribute sendgrid_client.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#8
  def sendgrid_client; end

  # Sets the attribute sendgrid_client
  #
  # @param value the value to set the attribute sendgrid_client to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#8
  def sendgrid_client=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def spam_check(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def subscription(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def subscription_tracking(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#19
  def template(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_address_whitelist(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_bcc(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_bounce_purge(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_click(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_click_tracking(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_enforced_tls(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_footer(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_forward_bounce(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_forward_spam(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_google_analytics(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_new_relic(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_open(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_open_tracking(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_plain_content(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_spam_check(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_subscription(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_subscription_tracking(**args); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#22
  def update_template(**args); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/settings/settings.rb#10
SendGrid::Settings::SETTING_TYPES = T.let(T.unsafe(nil), Array)

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#4
class SendGrid::SpamCheck
  # @return [SpamCheck] a new instance of SpamCheck
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#7
  def initialize(enable: T.unsafe(nil), threshold: T.unsafe(nil), post_to_url: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#5
  def enable=(_arg0); end

  # Returns the value of attribute post_to_url.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#5
  def post_to_url; end

  # Sets the attribute post_to_url
  #
  # @param value the value to set the attribute post_to_url to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#5
  def post_to_url=(_arg0); end

  # Returns the value of attribute threshold.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#5
  def threshold; end

  # Sets the attribute threshold
  #
  # @param value the value to set the attribute threshold to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#5
  def threshold=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/spam_check.rb#13
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/stats/stats_response.rb#2
class SendGrid::StatsResponse
  # @return [StatsResponse] a new instance of StatsResponse
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/stats_response.rb#3
  def initialize(args); end

  # @return [Boolean]
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/stats_response.rb#14
  def error?; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/stats_response.rb#8
  def errors; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/stats/stats_response.rb#18
  def metrics; end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#4
class SendGrid::SubscriptionTracking
  # @return [SubscriptionTracking] a new instance of SubscriptionTracking
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#7
  def initialize(enable: T.unsafe(nil), text: T.unsafe(nil), html: T.unsafe(nil), substitution_tag: T.unsafe(nil)); end

  # Returns the value of attribute enable.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def enable; end

  # Sets the attribute enable
  #
  # @param value the value to set the attribute enable to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def enable=(_arg0); end

  # Returns the value of attribute html.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def html; end

  # Sets the attribute html
  #
  # @param value the value to set the attribute html to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def html=(_arg0); end

  # Returns the value of attribute substitution_tag.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def substitution_tag; end

  # Sets the attribute substitution_tag
  #
  # @param value the value to set the attribute substitution_tag to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def substitution_tag=(_arg0); end

  # Returns the value of attribute text.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def text; end

  # Sets the attribute text
  #
  # @param value the value to set the attribute text to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#5
  def text=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/subscription_tracking.rb#14
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/substitution.rb#4
class SendGrid::Substitution
  # @return [Substitution] a new instance of Substitution
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/substitution.rb#7
  def initialize(key: T.unsafe(nil), value: T.unsafe(nil)); end

  # Returns the value of attribute substitution.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/substitution.rb#5
  def substitution; end

  # Sets the attribute substitution
  #
  # @param value the value to set the attribute substitution to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/substitution.rb#5
  def substitution=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/substitution.rb#12
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#4
class SendGrid::TrackingSettings
  # @return [TrackingSettings] a new instance of TrackingSettings
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#7
  def initialize; end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#14
  def click_tracking; end

  # Sets the attribute click_tracking
  #
  # @param value the value to set the attribute click_tracking to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#5
  def click_tracking=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#26
  def ganalytics; end

  # Sets the attribute ganalytics
  #
  # @param value the value to set the attribute ganalytics to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#5
  def ganalytics=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#18
  def open_tracking; end

  # Sets the attribute open_tracking
  #
  # @param value the value to set the attribute open_tracking to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#5
  def open_tracking=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#22
  def subscription_tracking; end

  # Sets the attribute subscription_tracking
  #
  # @param value the value to set the attribute subscription_tracking to.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#5
  def subscription_tracking=(_arg0); end

  # source://sendgrid-ruby//lib/sendgrid/helpers/mail/tracking_settings.rb#30
  def to_json(*_arg0); end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#2
class SendGrid::TrackingSettingsDto
  # Returns the value of attribute click.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#3
  def click; end

  # Returns the value of attribute click.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#3
  def click_tracking; end

  # Returns the value of attribute google_analytics.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#3
  def google_analytics; end

  # Returns the value of attribute open.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#3
  def open; end

  # Returns the value of attribute open.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#3
  def open_tracking; end

  # Returns the value of attribute subscription.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#3
  def subscription; end

  # Returns the value of attribute subscription.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#3
  def subscription_tracking; end

  class << self
    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#8
    def fetch(sendgrid_client:, name:, query_params:); end

    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#18
    def scrub_alias_names(name); end

    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/tracking_settings_dto.rb#13
    def update(sendgrid_client:, name:, request_body:); end
  end
end

# source://sendgrid-ruby//lib/sendgrid/helpers/settings/user_settings_dto.rb#2
class SendGrid::UserSettingsDto
  # Returns the value of attribute enforced_tls.
  #
  # source://sendgrid-ruby//lib/sendgrid/helpers/settings/user_settings_dto.rb#3
  def enforced_tls; end

  class << self
    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/user_settings_dto.rb#5
    def fetch(sendgrid_client:, name:, query_params:); end

    # source://sendgrid-ruby//lib/sendgrid/helpers/settings/user_settings_dto.rb#9
    def update(sendgrid_client:, name:, request_body:); end
  end
end

# source://sendgrid-ruby//lib/sendgrid/version.rb#2
SendGrid::VERSION = T.let(T.unsafe(nil), String)

# Quickly and easily access the Twilio Email API.
#
# source://sendgrid-ruby//lib/sendgrid/twilio_email.rb#2
module TwilioEmail; end

# source://sendgrid-ruby//lib/sendgrid/twilio_email.rb#3
class TwilioEmail::API < ::BaseInterface
  # * *Args* :
  #   - +username+ -> your Twilio Email API key SID or Account SID
  #   - +password+ -> your Twilio Email API key secret or Account Auth Token
  #   - +host+ -> the base URL for the API
  #   - +request_headers+ -> any headers that you want to be globally applied
  #   - +version+ -> the version of the API you wish to access,
  #                  currently only "v3" is supported
  #   - +impersonate_subuser+ -> the subuser to impersonate, will be passed
  #                              in the "On-Behalf-Of" header
  #
  # @return [API] a new instance of API
  #
  # source://sendgrid-ruby//lib/sendgrid/twilio_email.rb#14
  def initialize(username:, password:, host: T.unsafe(nil), request_headers: T.unsafe(nil), version: T.unsafe(nil), impersonate_subuser: T.unsafe(nil)); end
end
