# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `ruby_http_client` gem.
# Please instead update this file by running `bin/tapioca gem ruby_http_client`.


# Quickly and easily access any REST or REST-like API.
#
# source://ruby_http_client//lib/ruby_http_client.rb#2
module SendGrid; end

# A simple REST client.
#
# source://ruby_http_client//lib/ruby_http_client.rb#85
class SendGrid::Client
  # * *Args*    :
  #   - +host+ -> Base URL for the api. (e.g. https://api.sendgrid.com)
  #   - +request_headers+ -> A hash of the headers you want applied on
  #                          all calls
  #   - +version+ -> The version number of the API.
  #                  Subclass add_version for custom behavior.
  #                  Or just pass the version as part of the URL
  #                  (e.g. client._("/v3"))
  #   - +url_path+ -> A list of the url path segments
  #   - +proxy_options+ -> A hash of proxy settings.
  #                        (e.g. { host: '127.0.0.1', port: 8080 })
  #
  # @return [Client] a new instance of Client
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#99
  def initialize(host: T.unsafe(nil), request_headers: T.unsafe(nil), version: T.unsafe(nil), url_path: T.unsafe(nil), http_options: T.unsafe(nil), proxy_options: T.unsafe(nil)); end

  # Add variable values to the url.
  # (e.g. /your/api/{variable_value}/call)
  # Another example: if you have a ruby reserved word, such as true,
  # in your url, you must use this method.
  #
  # * *Args*    :
  #   - +name+ -> Name of the url segment
  # * *Returns* :
  #   - Client object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#274
  def _(name = T.unsafe(nil)); end

  # Add others http options to http object
  #
  # * *Args*    :
  #   - +http+ -> HTTP::NET object
  # * *Returns* :
  #   - HTTP::NET object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#257
  def add_http_options(http); end

  # Allow for https calls
  #
  # * *Args*    :
  #   - +http+ -> HTTP::NET object
  # * *Returns* :
  #   - HTTP::NET object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#242
  def add_ssl(http); end

  # Add the API version, subclass this function to customize
  #
  # * *Args*    :
  #   - +url+ -> An empty url string
  # * *Returns* :
  #   - The url string with the version pre-pended
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#141
  def add_version(url = T.unsafe(nil)); end

  # Set the query params, request headers and request body
  #
  # * *Args*    :
  #   - +args+ -> array of args obtained from method_missing
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#164
  def build_args(args); end

  # Build HTTP request object
  #
  # * *Returns* :
  #   - Request object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#227
  def build_http(host, port); end

  # Add query parameters to the url
  #
  # * *Args*    :
  #   - +url+ -> path to endpoint
  #   - +query_params+ -> hash of query parameters
  # * *Returns* :
  #   - The url string with the query parameters appended
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#154
  def build_query_params(url, query_params); end

  # Build the API request for HTTP::NET
  #
  # * *Args*    :
  #   - +name+ -> method name, received from method_missing
  #   - +args+ -> args passed to the method
  # * *Returns* :
  #   - A Response object from make_request
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#200
  def build_request(name, args); end

  # Build the final request headers
  #
  # * *Args*    :
  #   - +request+ -> HTTP::NET request object
  # * *Returns* :
  #   - HTTP::NET request object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#127
  def build_request_headers(request); end

  # Build the final url
  #
  # * *Args*    :
  #   - +query_params+ -> A hash of query parameters
  # * *Returns* :
  #   - The final url string
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#186
  def build_url(query_params: T.unsafe(nil)); end

  # Returns the value of attribute host.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#86
  def host; end

  # Returns the value of attribute http.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#86
  def http; end

  # Make the API call and return the response. This is separated into
  # it's own function, so we can mock it easily for testing.
  #
  # * *Args*    :
  #   - +http+ -> NET:HTTP request object
  #   - +request+ -> NET::HTTP request object
  # * *Returns* :
  #   - Response object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#218
  def make_request(http, request); end

  # Dynamically add segments to the url, then call a method.
  # (e.g. client.name.name.get())
  #
  # * *Args*    :
  #   - The args are automatically passed in
  # * *Returns* :
  #   - Client object or Response object
  #
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#291
  def method_missing(name, *args, &_block); end

  # Returns the value of attribute request.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#86
  def request; end

  # Returns the value of attribute request_headers.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#86
  def request_headers; end

  # Update the headers for the request
  #
  # * *Args*    :
  #   - +request_headers+ -> Hash of request header key/values
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#116
  def update_headers(request_headers); end

  # Returns the value of attribute url_path.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#86
  def url_path; end

  private

  # source://ruby_http_client//lib/ruby_http_client.rb#306
  def build_http_request(http_method); end

  # @return [Boolean]
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#330
  def content_type_json?; end

  # source://ruby_http_client//lib/ruby_http_client.rb#314
  def update_content_type(http_method); end
end

# Holds the response from an API call.
#
# source://ruby_http_client//lib/ruby_http_client.rb#8
class SendGrid::Response
  # @return [Response] a new instance of Response
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#57
  def initialize(response); end

  # * *Args*    :
  #   - +response+ -> A NET::HTTP response object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#55
  def body; end

  # * *Args*    :
  #   - +response+ -> A NET::HTTP response object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#55
  def headers; end

  # Returns the body as a hash
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#65
  def parsed_body; end

  # source://ruby_http_client//lib/ruby_http_client.rb#69
  def ratelimit; end

  # * *Args*    :
  #   - +response+ -> A NET::HTTP response object
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#55
  def status_code; end
end

# Provide useful functionality around API rate limiting.
#
# source://ruby_http_client//lib/ruby_http_client.rb#10
class SendGrid::Response::Ratelimit
  # * *Args*    :
  #   - +limit+ -> The total number of requests allowed within a rate limit window
  #   - +remaining+ -> The number of requests that have been processed within this current rate limit window
  #   - +reset+ -> The time (in seconds since Unix Epoch) when the rate limit will reset
  #
  # @return [Ratelimit] a new instance of Ratelimit
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#17
  def initialize(limit, remaining, reset); end

  # @return [Boolean]
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#23
  def exceeded?; end

  # Returns the value of attribute limit.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#11
  def limit; end

  # Returns the value of attribute remaining.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#11
  def remaining; end

  # Returns the value of attribute reset.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#11
  def reset; end

  # * *Returns* :
  #   - The number of requests that have been used out of this
  #     rate limit window
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#30
  def used; end

  # Sleep until the reset time arrives. If given a block, it will
  # be called after sleeping is finished.
  #
  # * *Returns* :
  #   - The amount of time (in seconds) that the rate limit slept
  #     for.
  #
  # source://ruby_http_client//lib/ruby_http_client.rb#40
  def wait!; end
end
