# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rack` gem.
# Please instead update this file by running `bin/tapioca gem rack`.


# The Rack main module, serving as a namespace for all core Rack
# modules and classes.
#
# All modules meant for use in your application are <tt>autoload</tt>ed here,
# so it should be enough just to <tt>require 'rack'</tt> in your code.
#
# source://rack//lib/rack/version.rb#14
module Rack
  class << self
    # Return the Rack release as a dotted string.
    #
    # source://rack//lib/rack/version.rb#26
    def release; end

    # Return the Rack protocol version as a dotted string.
    #
    # source://rack//lib/rack/version.rb#19
    def version; end
  end
end

# source://rack//lib/rack.rb#124
module Rack::Auth; end

# Rack::Auth::AbstractHandler implements common authentication functionality.
#
# +realm+ should be set for all handlers.
#
# source://rack//lib/rack/auth/abstract/handler.rb#9
class Rack::Auth::AbstractHandler
  # @return [AbstractHandler] a new instance of AbstractHandler
  #
  # source://rack//lib/rack/auth/abstract/handler.rb#13
  def initialize(app, realm = T.unsafe(nil), &authenticator); end

  # Returns the value of attribute realm.
  #
  # source://rack//lib/rack/auth/abstract/handler.rb#11
  def realm; end

  # Sets the attribute realm
  #
  # @param value the value to set the attribute realm to.
  #
  # source://rack//lib/rack/auth/abstract/handler.rb#11
  def realm=(_arg0); end

  private

  # source://rack//lib/rack/auth/abstract/handler.rb#29
  def bad_request; end

  # source://rack//lib/rack/auth/abstract/handler.rb#20
  def unauthorized(www_authenticate = T.unsafe(nil)); end
end

# source://rack//lib/rack/auth/abstract/request.rb#5
class Rack::Auth::AbstractRequest
  # @return [AbstractRequest] a new instance of AbstractRequest
  #
  # source://rack//lib/rack/auth/abstract/request.rb#7
  def initialize(env); end

  # source://rack//lib/rack/auth/abstract/request.rb#31
  def params; end

  # source://rack//lib/rack/auth/abstract/request.rb#23
  def parts; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/abstract/request.rb#15
  def provided?; end

  # source://rack//lib/rack/auth/abstract/request.rb#11
  def request; end

  # source://rack//lib/rack/auth/abstract/request.rb#27
  def scheme; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/abstract/request.rb#19
  def valid?; end

  private

  # source://rack//lib/rack/auth/abstract/request.rb#40
  def authorization_key; end
end

# source://rack//lib/rack/auth/abstract/request.rb#38
Rack::Auth::AbstractRequest::AUTHORIZATION_KEYS = T.let(T.unsafe(nil), Array)

# Rack::Auth::Basic implements HTTP Basic Authentication, as per RFC 2617.
#
# Initialize with the Rack application that you want protecting,
# and a block that checks if a username and password pair are valid.
#
# See also: <tt>example/protectedlobster.rb</tt>
#
# source://rack//lib/rack/auth/basic.rb#16
class Rack::Auth::Basic < ::Rack::Auth::AbstractHandler
  # source://rack//lib/rack/auth/basic.rb#18
  def call(env); end

  private

  # source://rack//lib/rack/auth/basic.rb#37
  def challenge; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/basic.rb#41
  def valid?(auth); end
end

# source://rack//lib/rack/auth/basic.rb#45
class Rack::Auth::Basic::Request < ::Rack::Auth::AbstractRequest
  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/basic.rb#46
  def basic?; end

  # source://rack//lib/rack/auth/basic.rb#50
  def credentials; end

  # source://rack//lib/rack/auth/basic.rb#54
  def username; end
end

# source://rack//lib/rack.rb#128
module Rack::Auth::Digest; end

# Rack::Auth::Digest::MD5 implements the MD5 algorithm version of
# HTTP Digest Authentication, as per RFC 2617.
#
# Initialize with the [Rack] application that you want protecting,
# and a block that looks up a plaintext password for a given username.
#
# +opaque+ needs to be set to a constant base64/hexadecimal string.
#
# source://rack//lib/rack/auth/digest/md5.rb#20
class Rack::Auth::Digest::MD5 < ::Rack::Auth::AbstractHandler
  # @return [MD5] a new instance of MD5
  #
  # source://rack//lib/rack/auth/digest/md5.rb#26
  def initialize(app, realm = T.unsafe(nil), opaque = T.unsafe(nil), &authenticator); end

  # source://rack//lib/rack/auth/digest/md5.rb#39
  def call(env); end

  # Returns the value of attribute opaque.
  #
  # source://rack//lib/rack/auth/digest/md5.rb#22
  def opaque; end

  # Sets the attribute opaque
  #
  # @param value the value to set the attribute opaque to.
  #
  # source://rack//lib/rack/auth/digest/md5.rb#22
  def opaque=(_arg0); end

  # Sets the attribute passwords_hashed
  #
  # @param value the value to set the attribute passwords_hashed to.
  #
  # source://rack//lib/rack/auth/digest/md5.rb#24
  def passwords_hashed=(_arg0); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/md5.rb#35
  def passwords_hashed?; end

  private

  # source://rack//lib/rack/auth/digest/md5.rb#114
  def A1(auth, password); end

  # source://rack//lib/rack/auth/digest/md5.rb#118
  def A2(auth); end

  # source://rack//lib/rack/auth/digest/md5.rb#104
  def H(data); end

  # source://rack//lib/rack/auth/digest/md5.rb#110
  def KD(secret, data); end

  # source://rack//lib/rack/auth/digest/md5.rb#79
  def challenge(hash = T.unsafe(nil)); end

  # source://rack//lib/rack/auth/digest/md5.rb#122
  def digest(auth, password); end

  # source://rack//lib/rack/auth/digest/md5.rb#104
  def md5(data); end

  # source://rack//lib/rack/auth/digest/md5.rb#68
  def params(hash = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/md5.rb#83
  def valid?(auth); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/md5.rb#99
  def valid_digest?(auth); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/md5.rb#95
  def valid_nonce?(auth); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/md5.rb#91
  def valid_opaque?(auth); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/md5.rb#87
  def valid_qop?(auth); end
end

# source://rack//lib/rack/auth/digest/md5.rb#66
Rack::Auth::Digest::MD5::QOP = T.let(T.unsafe(nil), String)

# Rack::Auth::Digest::Nonce is the default nonce generator for the
# Rack::Auth::Digest::MD5 authentication handler.
#
# +private_key+ needs to set to a constant string.
#
# +time_limit+ can be optionally set to an integer (number of seconds),
# to limit the validity of the generated nonces.
#
# source://rack//lib/rack/auth/digest/nonce.rb#17
class Rack::Auth::Digest::Nonce
  # @return [Nonce] a new instance of Nonce
  #
  # source://rack//lib/rack/auth/digest/nonce.rb#27
  def initialize(timestamp = T.unsafe(nil), given_digest = T.unsafe(nil)); end

  # source://rack//lib/rack/auth/digest/nonce.rb#35
  def digest; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/nonce.rb#47
  def fresh?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/nonce.rb#43
  def stale?; end

  # source://rack//lib/rack/auth/digest/nonce.rb#31
  def to_s; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/nonce.rb#39
  def valid?; end

  class << self
    # source://rack//lib/rack/auth/digest/nonce.rb#23
    def parse(string); end

    # Returns the value of attribute private_key.
    #
    # source://rack//lib/rack/auth/digest/nonce.rb#20
    def private_key; end

    # Sets the attribute private_key
    #
    # @param value the value to set the attribute private_key to.
    #
    # source://rack//lib/rack/auth/digest/nonce.rb#20
    def private_key=(_arg0); end

    # Returns the value of attribute time_limit.
    #
    # source://rack//lib/rack/auth/digest/nonce.rb#20
    def time_limit; end

    # Sets the attribute time_limit
    #
    # @param value the value to set the attribute time_limit to.
    #
    # source://rack//lib/rack/auth/digest/nonce.rb#20
    def time_limit=(_arg0); end
  end
end

# source://rack//lib/rack/auth/digest/params.rb#6
class Rack::Auth::Digest::Params < ::Hash
  # @return [Params] a new instance of Params
  # @yield [_self]
  # @yieldparam _self [Rack::Auth::Digest::Params] the object that the method was called on
  #
  # source://rack//lib/rack/auth/digest/params.rb#25
  def initialize; end

  # source://rack//lib/rack/auth/digest/params.rb#31
  def [](k); end

  # source://rack//lib/rack/auth/digest/params.rb#35
  def []=(k, v); end

  # From WEBrick::HTTPUtils
  #
  # source://rack//lib/rack/auth/digest/params.rb#47
  def quote(str); end

  # source://rack//lib/rack/auth/digest/params.rb#41
  def to_s; end

  class << self
    # From WEBrick::HTTPUtils
    #
    # source://rack//lib/rack/auth/digest/params.rb#15
    def dequote(str); end

    # source://rack//lib/rack/auth/digest/params.rb#8
    def parse(str); end

    # source://rack//lib/rack/auth/digest/params.rb#21
    def split_header_value(str); end
  end
end

# source://rack//lib/rack/auth/digest/params.rb#39
Rack::Auth::Digest::Params::UNQUOTED = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/auth/digest/request.rb#10
class Rack::Auth::Digest::Request < ::Rack::Auth::AbstractRequest
  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/request.rb#19
  def correct_uri?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/request.rb#15
  def digest?; end

  # source://rack//lib/rack/auth/digest/request.rb#11
  def method; end

  # @raise [ArgumentError]
  #
  # source://rack//lib/rack/auth/digest/request.rb#35
  def method_missing(sym, *args); end

  # source://rack//lib/rack/auth/digest/request.rb#23
  def nonce; end

  # source://rack//lib/rack/auth/digest/request.rb#27
  def params; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/auth/digest/request.rb#31
  def respond_to?(sym, *_arg1); end
end

# Proxy for response bodies allowing calling a block when
# the response body is closed (after the response has been fully
# sent to the client).
#
# source://rack//lib/rack/body_proxy.rb#7
class Rack::BodyProxy
  # Set the response body to wrap, and the block to call when the
  # response has been fully sent.
  #
  # @return [BodyProxy] a new instance of BodyProxy
  #
  # source://rack//lib/rack/body_proxy.rb#10
  def initialize(body, &block); end

  # If not already closed, close the wrapped body and
  # then call the block the proxy was initialized with.
  #
  # source://rack//lib/rack/body_proxy.rb#23
  def close; end

  # Whether the proxy is closed.  The proxy starts as not closed,
  # and becomes closed on the first call to close.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/body_proxy.rb#35
  def closed?; end

  # Delegate missing methods to the wrapped body.
  #
  # source://rack//lib/rack/body_proxy.rb#40
  def method_missing(method_name, *args, **_arg2, &block); end

  private

  # Return whether the wrapped body responds to the method.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/body_proxy.rb#17
  def respond_to_missing?(method_name, include_all = T.unsafe(nil)); end
end

# Rack::Builder implements a small DSL to iteratively construct Rack
# applications.
#
# Example:
#
#  require 'rack/lobster'
#  app = Rack::Builder.new do
#    use Rack::CommonLogger
#    use Rack::ShowExceptions
#    map "/lobster" do
#      use Rack::Lint
#      run Rack::Lobster.new
#    end
#  end
#
#  run app
#
# Or
#
#  app = Rack::Builder.app do
#    use Rack::CommonLogger
#    run lambda { |env| [200, {'Content-Type' => 'text/plain'}, ['OK']] }
#  end
#
#  run app
#
# +use+ adds middleware to the stack, +run+ dispatches to an application.
# You can use +map+ to construct a Rack::URLMap in a convenient way.
#
# source://rack//lib/rack/builder.rb#33
class Rack::Builder
  # Initialize a new Rack::Builder instance.  +default_app+ specifies the
  # default application if +run+ is not called later.  If a block
  # is given, it is evaluted in the context of the instance.
  #
  # @return [Builder] a new instance of Builder
  #
  # source://rack//lib/rack/builder.rb#123
  def initialize(default_app = T.unsafe(nil), &block); end

  # Call the Rack application generated by this builder instance. Note that
  # this rebuilds the Rack application and runs the warmup code (if any)
  # every time it is called, so it should not be used if performance is important.
  #
  # source://rack//lib/rack/builder.rb#243
  def call(env); end

  # Freeze the app (set using run) and all middleware instances when building the application
  # in to_app.
  #
  # source://rack//lib/rack/builder.rb#226
  def freeze_app; end

  # Creates a route within the application.  Routes under the mapped path will be sent to
  # the Rack application specified by run inside the block.  Other requests will be sent to the
  # default application specified by run outside the block.
  #
  #   Rack::Builder.app do
  #     map '/heartbeat' do
  #       run Heartbeat
  #     end
  #     run App
  #   end
  #
  # The +use+ method can also be used inside the block to specify middleware to run under a specific path:
  #
  #   Rack::Builder.app do
  #     map '/heartbeat' do
  #       use Middleware
  #       run Heartbeat
  #     end
  #     run App
  #   end
  #
  # This example includes a piece of middleware which will run before +/heartbeat+ requests hit +Heartbeat+.
  #
  # Note that providing a +path+ of +/+ will ignore any default application given in a +run+ statement
  # outside the block.
  #
  # source://rack//lib/rack/builder.rb#219
  def map(path, &block); end

  # Takes an argument that is an object that responds to #call and returns a Rack response.
  # The simplest form of this is a lambda object:
  #
  #   run lambda { |env| [200, { "Content-Type" => "text/plain" }, ["OK"]] }
  #
  # However this could also be a class:
  #
  #   class Heartbeat
  #     def self.call(env)
  #      [200, { "Content-Type" => "text/plain" }, ["OK"]]
  #     end
  #   end
  #
  #   run Heartbeat
  #
  # source://rack//lib/rack/builder.rb#176
  def run(app); end

  # Return the Rack application generated by this instance.
  #
  # source://rack//lib/rack/builder.rb#231
  def to_app; end

  # Specifies middleware to use in a stack.
  #
  #   class Middleware
  #     def initialize(app)
  #       @app = app
  #     end
  #
  #     def call(env)
  #       env["rack.some_header"] = "setting an example"
  #       @app.call(env)
  #     end
  #   end
  #
  #   use Middleware
  #   run lambda { |env| [200, { "Content-Type" => "text/plain" }, ["OK"]] }
  #
  # All requests through to this application will first be processed by the middleware class.
  # The +call+ method in this example sets an additional environment key which then can be
  # referenced in the application if required.
  #
  # source://rack//lib/rack/builder.rb#153
  def use(middleware, *args, **_arg2, &block); end

  # Takes a lambda or block that is used to warm-up the application. This block is called
  # before the Rack application is returned by to_app.
  #
  #   warmup do |app|
  #     client = Rack::MockRequest.new(app)
  #     client.get('/')
  #   end
  #
  #   use SomeMiddleware
  #   run MyApp
  #
  # source://rack//lib/rack/builder.rb#190
  def warmup(prc = T.unsafe(nil), &block); end

  private

  # Generate a URLMap instance by generating new Rack applications for each
  # map block in this instance.
  #
  # source://rack//lib/rack/builder.rb#251
  def generate_map(default_app, mapping); end

  class << self
    # Create a new Rack::Builder instance and return the Rack application
    # generated from it.
    #
    # source://rack//lib/rack/builder.rb#130
    def app(default_app = T.unsafe(nil), &block); end

    # Load the given file as a rackup file, treating the
    # contents as if specified inside a Rack::Builder block.
    #
    # Treats the first comment at the beginning of a line
    # that starts with a backslash as options similar to
    # options passed on a rackup command line.
    #
    # Ignores content in the file after +__END__+, so that
    # use of +__END__+ will not result in a syntax error.
    #
    # Example config.ru file:
    #
    #   $ cat config.ru
    #
    #   #\ -p 9393
    #
    #   use Rack::ContentLength
    #   require './app.rb'
    #   run App
    #
    # source://rack//lib/rack/builder.rb#93
    def load_file(path, opts = T.unsafe(nil)); end

    # Evaluate the given +builder_script+ string in the context of
    # a Rack::Builder block, returning a Rack application.
    #
    # source://rack//lib/rack/builder.rb#112
    def new_from_string(builder_script, file = T.unsafe(nil)); end

    # Parse the given config file to get a Rack application.
    #
    # If the config file ends in +.ru+, it is treated as a
    # rackup file and the contents will be treated as if
    # specified inside a Rack::Builder block, using the given
    # options.
    #
    # If the config file does not end in +.ru+, it is
    # required and Rack will use the basename of the file
    # to guess which constant will be the Rack application to run.
    # The options given will be ignored in this case.
    #
    # Examples:
    #
    #   Rack::Builder.parse_file('config.ru')
    #   # Rack application built using Rack::Builder.new
    #
    #   Rack::Builder.parse_file('app.rb')
    #   # requires app.rb, which can be anywhere in Ruby's
    #   # load path. After requiring, assumes App constant
    #   # contains Rack application
    #
    #   Rack::Builder.parse_file('./my_app.rb')
    #   # requires ./my_app.rb, which should be in the
    #   # process's current directory.  After requiring,
    #   # assumes MyApp constant contains Rack application
    #
    # source://rack//lib/rack/builder.rb#64
    def parse_file(config, opts = T.unsafe(nil)); end
  end
end

# https://stackoverflow.com/questions/2223882/whats-the-difference-between-utf-8-and-utf-8-without-bom
#
# source://rack//lib/rack/builder.rb#36
Rack::Builder::UTF_8_BOM = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#29
Rack::CACHE_CONTROL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#31
Rack::CONTENT_LENGTH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#32
Rack::CONTENT_TYPE = T.let(T.unsafe(nil), String)

# Rack::Cascade tries a request on several apps, and returns the
# first response that is not 404 or 405 (or in a list of configured
# status codes).  If all applications tried return one of the configured
# status codes, return the last response.
#
# source://rack//lib/rack/cascade.rb#9
class Rack::Cascade
  # Set the apps to send requests to, and what statuses result in
  # cascading.  Arguments:
  #
  # apps: An enumerable of rack applications.
  # cascade_for: The statuses to use cascading for.  If a response is received
  #              from an app, the next app is tried.
  #
  # @return [Cascade] a new instance of Cascade
  #
  # source://rack//lib/rack/cascade.rb#22
  def initialize(apps, cascade_for = T.unsafe(nil)); end

  # Append an app to the list of apps to cascade.  This app will
  # be tried last.
  #
  # source://rack//lib/rack/cascade.rb#57
  def <<(app); end

  # Append an app to the list of apps to cascade.  This app will
  # be tried last.
  #
  # source://rack//lib/rack/cascade.rb#57
  def add(app); end

  # An array of applications to try in order.
  #
  # source://rack//lib/rack/cascade.rb#14
  def apps; end

  # Call each app in order.  If the responses uses a status that requires
  # cascading, try the next app.  If all responses require cascading,
  # return the response from the last app.
  #
  # source://rack//lib/rack/cascade.rb#33
  def call(env); end

  # Whether the given app is one of the apps to cascade to.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/cascade.rb#62
  def include?(app); end
end

# deprecated, no longer used
#
# source://rack//lib/rack/cascade.rb#11
Rack::Cascade::NotFound = T.let(T.unsafe(nil), Array)

# Middleware that applies chunked transfer encoding to response bodies
# when the response does not include a Content-Length header.
#
# This supports the Trailer response header to allow the use of trailing
# headers in the chunked encoding.  However, using this requires you manually
# specify a response body that supports a +trailers+ method.  Example:
#
#   [200, { 'Trailer' => 'Expires'}, ["Hello", "World"]]
#   # error raised
#
#   body = ["Hello", "World"]
#   def body.trailers
#     { 'Expires' => Time.now.to_s }
#   end
#   [200, { 'Trailer' => 'Expires'}, body]
#   # No exception raised
#
# source://rack//lib/rack/chunked.rb#21
class Rack::Chunked
  include ::Rack::Utils

  # @return [Chunked] a new instance of Chunked
  #
  # source://rack//lib/rack/chunked.rb#78
  def initialize(app); end

  # If the rack app returns a response that should have a body,
  # but does not have Content-Length or Transfer-Encoding headers,
  # modify the response to use chunked Transfer-Encoding.
  #
  # source://rack//lib/rack/chunked.rb#97
  def call(env); end

  # Whether the HTTP version supports chunked encoding (HTTP 1.1 does).
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/chunked.rb#83
  def chunkable_version?(ver); end
end

# A body wrapper that emits chunked responses.
#
# source://rack//lib/rack/chunked.rb#25
class Rack::Chunked::Body
  # Store the response body to be chunked.
  #
  # @return [Body] a new instance of Body
  #
  # source://rack//lib/rack/chunked.rb#30
  def initialize(body); end

  # Close the response body if the response body supports it.
  #
  # source://rack//lib/rack/chunked.rb#50
  def close; end

  # For each element yielded by the response body, yield
  # the element in chunked encoding.
  #
  # @yield [TAIL]
  #
  # source://rack//lib/rack/chunked.rb#36
  def each(&block); end

  private

  # Do nothing as this class does not support trailer headers.
  #
  # source://rack//lib/rack/chunked.rb#57
  def yield_trailers; end
end

# source://rack//lib/rack/chunked.rb#27
Rack::Chunked::Body::TAIL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/chunked.rb#26
Rack::Chunked::Body::TERM = T.let(T.unsafe(nil), String)

# A body wrapper that emits chunked responses and also supports
# sending Trailer headers.  Note that the response body provided to
# initialize must have a +trailers+ method that returns a hash
# of trailer headers, and the rack response itself should have a
# Trailer header listing the headers that the +trailers+ method
# will return.
#
# source://rack//lib/rack/chunked.rb#67
class Rack::Chunked::TrailerBody < ::Rack::Chunked::Body
  private

  # Yield strings for each trailer header.
  #
  # source://rack//lib/rack/chunked.rb#71
  def yield_trailers; end
end

# Rack::CommonLogger forwards every request to the given +app+, and
# logs a line in the
# {Apache common log format}[http://httpd.apache.org/docs/1.3/logs.html#common]
# to the configured logger.
#
# source://rack//lib/rack/common_logger.rb#8
class Rack::CommonLogger
  # +logger+ can be any object that supports the +write+ or +<<+ methods,
  # which includes the standard library Logger.  These methods are called
  # with a single string argument, the log message.
  # If +logger+ is nil, CommonLogger will fall back <tt>env['rack.errors']</tt>.
  #
  # @return [CommonLogger] a new instance of CommonLogger
  #
  # source://rack//lib/rack/common_logger.rb#24
  def initialize(app, logger = T.unsafe(nil)); end

  # Log all requests in common_log format after a response has been
  # returned.  Note that if the app raises an exception, the request
  # will not be logged, so if exception handling middleware are used,
  # they should be loaded after this middleware.  Additionally, because
  # the logging happens after the request body has been fully sent, any
  # exceptions raised during the sending of the response body will
  # cause the request not to be logged.
  #
  # source://rack//lib/rack/common_logger.rb#36
  def call(env); end

  private

  # Attempt to determine the content length for the response to
  # include it in the logged data.
  #
  # source://rack//lib/rack/common_logger.rb#78
  def extract_content_length(headers); end

  # Log the request to the configured logger.
  #
  # source://rack//lib/rack/common_logger.rb#47
  def log(env, status, header, began_at); end
end

# Common Log Format: http://httpd.apache.org/docs/1.3/logs.html#common
#
#   lilith.local - - [07/Aug/2006 23:58:02 -0400] "GET / HTTP/1.1" 500 -
#
#   %{%s - %s [%s] "%s %s%s %s" %d %s\n} %
#
# The actual format is slightly different than the above due to the
# separation of SCRIPT_NAME and PATH_INFO, and because the elapsed
# time in seconds is included at the end.
#
# source://rack//lib/rack/common_logger.rb#18
Rack::CommonLogger::FORMAT = T.let(T.unsafe(nil), String)

# Middleware that enables conditional GET using If-None-Match and
# If-Modified-Since. The application should set either or both of the
# Last-Modified or Etag response headers according to RFC 2616. When
# either of the conditions is met, the response body is set to be zero
# length and the response status is set to 304 Not Modified.
#
# Applications that defer response body generation until the body's each
# message is received will avoid response body generation completely when
# a conditional GET matches.
#
# Adapted from Michael Klishin's Merb implementation:
# https://github.com/wycats/merb/blob/master/merb-core/lib/merb-core/rack/middleware/conditional_get.rb
#
# source://rack//lib/rack/conditional_get.rb#17
class Rack::ConditionalGet
  # @return [ConditionalGet] a new instance of ConditionalGet
  #
  # source://rack//lib/rack/conditional_get.rb#18
  def initialize(app); end

  # Return empty 304 response if the response has not been
  # modified since the last request.
  #
  # source://rack//lib/rack/conditional_get.rb#24
  def call(env); end

  private

  # Whether the ETag response header matches the If-None-Match request header.
  # If so, the request has not been modified.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/conditional_get.rb#59
  def etag_matches?(none_match, headers); end

  # Return whether the response has not been modified since the
  # last request.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/conditional_get.rb#48
  def fresh?(env, headers); end

  # Whether the Last-Modified response header matches the If-Modified-Since
  # request header.  If so, the request has not been modified.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/conditional_get.rb#65
  def modified_since?(modified_since, headers); end

  # Return a Time object for the given string (which should be in RFC2822
  # format), or nil if the string cannot be parsed.
  #
  # source://rack//lib/rack/conditional_get.rb#72
  def to_rfc2822(since); end
end

# Rack::Config modifies the environment using the block given during
# initialization.
#
# Example:
#     use Rack::Config do |env|
#       env['my-key'] = 'some-value'
#     end
#
# source://rack//lib/rack/config.rb#11
class Rack::Config
  # @return [Config] a new instance of Config
  #
  # source://rack//lib/rack/config.rb#12
  def initialize(app, &block); end

  # source://rack//lib/rack/config.rb#17
  def call(env); end
end

# Sets the Content-Length header on responses that do not specify
# a Content-Length or Transfer-Encoding header.  Note that this
# does not fix responses that have an invalid Content-Length
# header specified.
#
# source://rack//lib/rack/content_length.rb#9
class Rack::ContentLength
  include ::Rack::Utils

  # @return [ContentLength] a new instance of ContentLength
  #
  # source://rack//lib/rack/content_length.rb#12
  def initialize(app); end

  # source://rack//lib/rack/content_length.rb#16
  def call(env); end
end

# Sets the Content-Type header on responses which don't have one.
#
# Builder Usage:
#   use Rack::ContentType, "text/plain"
#
# When no content type argument is provided, "text/html" is the
# default.
#
# source://rack//lib/rack/content_type.rb#12
class Rack::ContentType
  include ::Rack::Utils

  # @return [ContentType] a new instance of ContentType
  #
  # source://rack//lib/rack/content_type.rb#15
  def initialize(app, content_type = T.unsafe(nil)); end

  # source://rack//lib/rack/content_type.rb#19
  def call(env); end
end

# source://rack//lib/rack.rb#43
Rack::DELETE = T.let(T.unsafe(nil), String)

# This middleware enables content encoding of http responses,
# usually for purposes of compression.
#
# Currently supported encodings:
#
# * gzip
# * identity (no transformation)
#
# This middleware automatically detects when encoding is supported
# and allowed. For example no encoding is made when a cache
# directive of 'no-transform' is present, when the response status
# code is one that doesn't allow an entity body, or when the body
# is empty.
#
# Note that despite the name, Deflater does not support the +deflate+
# encoding.
#
# source://rack//lib/rack/deflater.rb#23
class Rack::Deflater
  # Creates Rack::Deflater middleware. Options:
  #
  # :if :: a lambda enabling / disabling deflation based on returned boolean value
  #        (e.g <tt>use Rack::Deflater, :if => lambda { |*, body| sum=0; body.each { |i| sum += i.length }; sum > 512 }</tt>).
  #        However, be aware that calling `body.each` inside the block will break cases where `body.each` is not idempotent,
  #        such as when it is an +IO+ instance.
  # :include :: a list of content types that should be compressed. By default, all content types are compressed.
  # :sync :: determines if the stream is going to be flushed after every chunk.  Flushing after every chunk reduces
  #          latency for time-sensitive streaming applications, but hurts compression and throughput.
  #          Defaults to +true+.
  #
  # @return [Deflater] a new instance of Deflater
  #
  # source://rack//lib/rack/deflater.rb#36
  def initialize(app, options = T.unsafe(nil)); end

  # source://rack//lib/rack/deflater.rb#43
  def call(env); end

  private

  # Whether the body should be compressed.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/deflater.rb#122
  def should_deflate?(env, status, headers, body); end
end

# Body class used for gzip encoded responses.
#
# source://rack//lib/rack/deflater.rb#79
class Rack::Deflater::GzipStream
  # Initialize the gzip stream.  Arguments:
  # body :: Response body to compress with gzip
  # mtime :: The modification time of the body, used to set the
  #          modification time in the gzip header.
  # sync :: Whether to flush each gzip chunk as soon as it is ready.
  #
  # @return [GzipStream] a new instance of GzipStream
  #
  # source://rack//lib/rack/deflater.rb#85
  def initialize(body, mtime, sync); end

  # Close the original body if possible.
  #
  # source://rack//lib/rack/deflater.rb#114
  def close; end

  # Yield gzip compressed strings to the given block.
  #
  # source://rack//lib/rack/deflater.rb#92
  def each(&block); end

  # Call the block passed to #each with the the gzipped data.
  #
  # source://rack//lib/rack/deflater.rb#109
  def write(data); end
end

# Rack::Directory serves entries below the +root+ given, according to the
# path info of the Rack request. If a directory is found, the file's contents
# will be presented in an html based index. If a file is found, the env will
# be passed to the specified +app+.
#
# If +app+ is not specified, a Rack::Files of the same +root+ will be used.
#
# source://rack//lib/rack/directory.rb#13
class Rack::Directory
  # Set the root directory and application for serving files.
  #
  # @return [Directory] a new instance of Directory
  #
  # source://rack//lib/rack/directory.rb#77
  def initialize(root, app = T.unsafe(nil)); end

  # source://rack//lib/rack/directory.rb#83
  def call(env); end

  # Rack response to use for requests with invalid paths, or nil if path is valid.
  #
  # source://rack//lib/rack/directory.rb#103
  def check_bad_request(path_info); end

  # Rack response to use for requests with paths outside the root, or nil if path is inside the root.
  #
  # source://rack//lib/rack/directory.rb#113
  def check_forbidden(path_info); end

  # Rack response to use for unreadable and non-file, non-directory entries.
  #
  # source://rack//lib/rack/directory.rb#175
  def entity_not_found(path_info); end

  # Provide human readable file sizes
  #
  # source://rack//lib/rack/directory.rb#191
  def filesize_format(int); end

  # Internals of request handling.  Similar to call but does
  # not remove body for HEAD requests.
  #
  # source://rack//lib/rack/directory.rb#90
  def get(env); end

  # Rack response to use for directories under the root.
  #
  # source://rack//lib/rack/directory.rb#124
  def list_directory(path_info, path, script_name); end

  # Rack response to use for files and directories under the root.
  # Unreadable and non-file, non-directory entries will get a 404 response.
  #
  # source://rack//lib/rack/directory.rb#165
  def list_path(env, path, path_info, script_name); end

  # The root of the directory hierarchy.  Only requests for files and
  # directories inside of the root directory are supported.
  #
  # source://rack//lib/rack/directory.rb#74
  def root; end

  # File::Stat for the given path, but return nil for missing/bad entries.
  #
  # source://rack//lib/rack/directory.rb#157
  def stat(path); end
end

# source://rack//lib/rack/directory.rb#14
Rack::Directory::DIR_FILE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/directory.rb#37
Rack::Directory::DIR_PAGE_FOOTER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/directory.rb#15
Rack::Directory::DIR_PAGE_HEADER = T.let(T.unsafe(nil), String)

# Body class for directory entries, showing an index page with links
# to each file.
#
# source://rack//lib/rack/directory.rb#45
class Rack::Directory::DirectoryBody < ::Struct
  # Yield strings for each part of the directory entry
  #
  # @yield [DIR_PAGE_HEADER % [ show_path, show_path ]]
  #
  # source://rack//lib/rack/directory.rb#47
  def each; end

  private

  # Escape each element in the array of html strings.
  #
  # source://rack//lib/rack/directory.rb#67
  def DIR_FILE_escape(htmls); end
end

# Stolen from Ramaze
#
# source://rack//lib/rack/directory.rb#183
Rack::Directory::FILESIZE_FORMAT = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack.rb#36
Rack::ETAG = T.let(T.unsafe(nil), String)

# Automatically sets the ETag header on all String bodies.
#
# The ETag header is skipped if ETag or Last-Modified headers are sent or if
# a sendfile body (body.responds_to :to_path) is given (since such cases
# should be handled by apache/nginx).
#
# On initialization, you can pass two parameters: a Cache-Control directive
# used when Etag is absent and a directive when it is present. The first
# defaults to nil, while the second defaults to "max-age=0, private, must-revalidate"
#
# source://rack//lib/rack/etag.rb#16
class Rack::ETag
  # @return [ETag] a new instance of ETag
  #
  # source://rack//lib/rack/etag.rb#20
  def initialize(app, no_cache_control = T.unsafe(nil), cache_control = T.unsafe(nil)); end

  # source://rack//lib/rack/etag.rb#26
  def call(env); end

  private

  # source://rack//lib/rack/etag.rb#65
  def digest_body(body); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/etag.rb#57
  def etag_body?(body); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/etag.rb#53
  def etag_status?(status); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/etag.rb#61
  def skip_caching?(headers); end
end

# source://rack//lib/rack/etag.rb#18
Rack::ETag::DEFAULT_CACHE_CONTROL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/etag.rb#17
Rack::ETag::ETAG_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#30
Rack::EXPIRES = T.let(T.unsafe(nil), String)

# This middleware provides hooks to certain places in the request /
# response lifecycle.  This is so that middleware that don't need to filter
# the response data can safely leave it alone and not have to send messages
# down the traditional "rack stack".
#
# The events are:
#
# * on_start(request, response)
#
#   This event is sent at the start of the request, before the next
#   middleware in the chain is called.  This method is called with a request
#   object, and a response object.  Right now, the response object is always
#   nil, but in the future it may actually be a real response object.
#
# * on_commit(request, response)
#
#   The response has been committed.  The application has returned, but the
#   response has not been sent to the webserver yet.  This method is always
#   called with a request object and the response object.  The response
#   object is constructed from the rack triple that the application returned.
#   Changes may still be made to the response object at this point.
#
# * on_send(request, response)
#
#   The webserver has started iterating over the response body and presumably
#   has started sending data over the wire. This method is always called with
#   a request object and the response object.  The response object is
#   constructed from the rack triple that the application returned.  Changes
#   SHOULD NOT be made to the response object as the webserver has already
#   started sending data.  Any mutations will likely result in an exception.
#
# * on_finish(request, response)
#
#   The webserver has closed the response, and all data has been written to
#   the response socket.  The request and response object should both be
#   read-only at this point.  The body MAY NOT be available on the response
#   object as it may have been flushed to the socket.
#
# * on_error(request, response, error)
#
#   An exception has occurred in the application or an `on_commit` event.
#   This method will get the request, the response (if available) and the
#   exception that was raised.
#
# ## Order
#
# `on_start` is called on the handlers in the order that they were passed to
# the constructor.  `on_commit`, on_send`, `on_finish`, and `on_error` are
# called in the reverse order.  `on_finish` handlers are called inside an
# `ensure` block, so they are guaranteed to be called even if something
# raises an exception.  If something raises an exception in a `on_finish`
# method, then nothing is guaranteed.
#
# source://rack//lib/rack/events.rb#57
class Rack::Events
  # @return [Events] a new instance of Events
  #
  # source://rack//lib/rack/events.rb#102
  def initialize(app, handlers); end

  # source://rack//lib/rack/events.rb#107
  def call(env); end

  private

  # source://rack//lib/rack/events.rb#145
  def make_request(env); end

  # source://rack//lib/rack/events.rb#149
  def make_response(status, headers, body); end

  # source://rack//lib/rack/events.rb#133
  def on_commit(request, response); end

  # source://rack//lib/rack/events.rb#129
  def on_error(request, response, e); end

  # source://rack//lib/rack/events.rb#141
  def on_finish(request, response); end

  # source://rack//lib/rack/events.rb#137
  def on_start(request, response); end
end

# source://rack//lib/rack/events.rb#58
module Rack::Events::Abstract
  # source://rack//lib/rack/events.rb#62
  def on_commit(req, res); end

  # source://rack//lib/rack/events.rb#71
  def on_error(req, res, e); end

  # source://rack//lib/rack/events.rb#68
  def on_finish(req, res); end

  # source://rack//lib/rack/events.rb#65
  def on_send(req, res); end

  # source://rack//lib/rack/events.rb#59
  def on_start(req, res); end
end

# source://rack//lib/rack/events.rb#91
class Rack::Events::BufferedResponse < ::Rack::Response::Raw
  # @return [BufferedResponse] a new instance of BufferedResponse
  #
  # source://rack//lib/rack/events.rb#94
  def initialize(status, headers, body); end

  # Returns the value of attribute body.
  #
  # source://rack//lib/rack/events.rb#92
  def body; end

  # source://rack//lib/rack/events.rb#99
  def to_a; end
end

# source://rack//lib/rack/events.rb#75
class Rack::Events::EventedBodyProxy < ::Rack::BodyProxy
  # @return [EventedBodyProxy] a new instance of EventedBodyProxy
  #
  # source://rack//lib/rack/events.rb#78
  def initialize(body, request, response, handlers, &block); end

  # source://rack//lib/rack/events.rb#85
  def each; end

  # Returns the value of attribute request.
  #
  # source://rack//lib/rack/events.rb#76
  def request; end

  # Returns the value of attribute response.
  #
  # source://rack//lib/rack/events.rb#76
  def response; end
end

# source://rack//lib/rack/file.rb#6
Rack::File = Rack::Files

# Rack::Files serves files below the +root+ directory given, according to the
# path info of the Rack request.
# e.g. when Rack::Files.new("/etc") is used, you can access 'passwd' file
# as http://localhost:9292/passwd
#
# Handlers can detect if bodies are a Rack::Files, and use mechanisms
# like sendfile on the +path+.
#
# source://rack//lib/rack/files.rb#14
class Rack::Files
  # @return [Files] a new instance of Files
  #
  # source://rack//lib/rack/files.rb#29
  def initialize(root, headers = T.unsafe(nil), default_mime = T.unsafe(nil)); end

  # source://rack//lib/rack/files.rb#36
  def call(env); end

  # source://rack//lib/rack/files.rb#41
  def get(env); end

  # Returns the value of attribute root.
  #
  # source://rack//lib/rack/files.rb#27
  def root; end

  # source://rack//lib/rack/files.rb#70
  def serving(request, path); end

  private

  # source://rack//lib/rack/files.rb#192
  def fail(status, body, headers = T.unsafe(nil)); end

  # source://rack//lib/rack/files.rb#211
  def filesize(path); end

  # The MIME type for the contents of the file located at @path
  #
  # source://rack//lib/rack/files.rb#207
  def mime_type(path, default_mime); end

  class << self
    # @todo remove in 3.0
    #
    # source://rack//lib/rack/files.rb#20
    def method_added(name); end
  end
end

# source://rack//lib/rack/files.rb#15
Rack::Files::ALLOWED_VERBS = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/files.rb#16
Rack::Files::ALLOW_HEADER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/files.rb#123
class Rack::Files::BaseIterator
  # @return [BaseIterator] a new instance of BaseIterator
  #
  # source://rack//lib/rack/files.rb#126
  def initialize(path, ranges, options); end

  # source://rack//lib/rack/files.rb#146
  def bytesize; end

  # source://rack//lib/rack/files.rb#155
  def close; end

  # source://rack//lib/rack/files.rb#132
  def each; end

  # Returns the value of attribute options.
  #
  # source://rack//lib/rack/files.rb#124
  def options; end

  # Returns the value of attribute path.
  #
  # source://rack//lib/rack/files.rb#124
  def path; end

  # Returns the value of attribute ranges.
  #
  # source://rack//lib/rack/files.rb#124
  def ranges; end

  private

  # source://rack//lib/rack/files.rb#173
  def each_range_part(file, range); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/files.rb#159
  def multipart?; end

  # source://rack//lib/rack/files.rb#163
  def multipart_heading(range); end
end

# source://rack//lib/rack/files.rb#186
class Rack::Files::Iterator < ::Rack::Files::BaseIterator
  # source://rack//lib/rack/files.rb#124
  def to_path; end
end

# source://rack//lib/rack/files.rb#17
Rack::Files::MULTIPART_BOUNDARY = T.let(T.unsafe(nil), String)

# Rack::ForwardRequest gets caught by Rack::Recursive and redirects
# the current request to the app at +url+.
#
#   raise ForwardRequest.new("/not-found")
#
# source://rack//lib/rack/recursive.rb#12
class Rack::ForwardRequest < ::Exception
  # @return [ForwardRequest] a new instance of ForwardRequest
  #
  # source://rack//lib/rack/recursive.rb#15
  def initialize(url, env = T.unsafe(nil)); end

  # Returns the value of attribute env.
  #
  # source://rack//lib/rack/recursive.rb#13
  def env; end

  # Returns the value of attribute url.
  #
  # source://rack//lib/rack/recursive.rb#13
  def url; end
end

# HTTP method verbs
#
# source://rack//lib/rack.rb#39
Rack::GET = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#44
Rack::HEAD = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#20
Rack::HTTPS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#35
Rack::HTTP_COOKIE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#17
Rack::HTTP_HOST = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#18
Rack::HTTP_PORT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#19
Rack::HTTP_VERSION = T.let(T.unsafe(nil), String)

# *Handlers* connect web servers with Rack.
#
# Rack includes Handlers for Thin, WEBrick, FastCGI, CGI, SCGI
# and LiteSpeed.
#
# Handlers usually are activated by calling <tt>MyHandler.run(myapp)</tt>.
# A second optional hash can be passed to include server-specific
# configuration.
#
# source://rack//lib/rack/handler.rb#12
module Rack::Handler
  class << self
    # source://rack//lib/rack/handler.rb#51
    def default; end

    # source://rack//lib/rack/handler.rb#13
    def get(server); end

    # Select first available Rack handler given an `Array` of server names.
    # Raises `LoadError` if no handler was found.
    #
    #   > pick ['thin', 'webrick']
    #   => Rack::Handler::WEBrick
    #
    # @raise [LoadError]
    #
    # source://rack//lib/rack/handler.rb#36
    def pick(server_names); end

    # source://rack//lib/rack/handler.rb#85
    def register(server, klass); end

    # Transforms server-name constants to their canonical form as filenames,
    # then tries to require them but silences the LoadError if not found
    #
    # Naming convention:
    #
    #   Foo # => 'foo'
    #   FooBar # => 'foo_bar.rb'
    #   FooBAR # => 'foobar.rb'
    #   FOObar # => 'foobar.rb'
    #   FOOBAR # => 'foobar.rb'
    #   FooBarBaz # => 'foo_bar_baz.rb'
    #
    # source://rack//lib/rack/handler.rb#75
    def try_require(prefix, const_name); end
  end
end

# source://rack//lib/rack/handler/cgi.rb#5
class Rack::Handler::CGI
  class << self
    # source://rack//lib/rack/handler/cgi.rb#6
    def run(app, **options); end

    # source://rack//lib/rack/handler/cgi.rb#51
    def send_body(body); end

    # source://rack//lib/rack/handler/cgi.rb#40
    def send_headers(status, headers); end

    # source://rack//lib/rack/handler/cgi.rb#11
    def serve(app); end
  end
end

# source://rack//lib/rack/handler.rb#48
Rack::Handler::SERVER_NAMES = T.let(T.unsafe(nil), Array)

# Rack::Head returns an empty body for all HEAD requests. It leaves
# all other requests unchanged.
#
# source://rack//lib/rack/head.rb#6
class Rack::Head
  # @return [Head] a new instance of Head
  #
  # source://rack//lib/rack/head.rb#7
  def initialize(app); end

  # source://rack//lib/rack/head.rb#11
  def call(env); end
end

# source://rack//lib/rack.rb#46
Rack::LINK = T.let(T.unsafe(nil), String)

# Rack::Lint validates your application and the requests and
# responses according to the Rack spec.
#
# source://rack//lib/rack/lint.rb#9
class Rack::Lint
  include ::Rack::Lint::Assertion

  # @return [Lint] a new instance of Lint
  #
  # source://rack//lib/rack/lint.rb#10
  def initialize(app); end

  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#41
  def _call(env); end

  # A Rack application is a Ruby object (not a class) that
  # responds to +call+.
  #
  # source://rack//lib/rack/lint.rb#37
  def call(env = T.unsafe(nil)); end

  # === The Content-Length
  #
  # source://rack//lib/rack/lint.rb#708
  def check_content_length(status, headers); end

  # === The Content-Type
  #
  # source://rack//lib/rack/lint.rb#694
  def check_content_type(status, headers); end

  # == The Environment
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#73
  def check_env(env); end

  # === The Error Stream
  #
  # source://rack//lib/rack/lint.rb#483
  def check_error(error); end

  # === The Headers
  #
  # source://rack//lib/rack/lint.rb#656
  def check_headers(header); end

  # === Hijacking
  #
  # AUTHORS: n.b. The trailing whitespace between paragraphs is important and
  # should not be removed. The whitespace creates paragraphs in the RDoc
  # output.
  #
  # ==== Request (before status)
  #
  # source://rack//lib/rack/lint.rb#548
  def check_hijack(env); end

  # ==== Response (after headers)
  # It is also possible to hijack a response after the status and headers
  # have been sent.
  #
  # source://rack//lib/rack/lint.rb#595
  def check_hijack_response(headers, env); end

  # === The Input Stream
  #
  # The input stream is an IO-like object which contains the raw HTTP
  # POST data.
  #
  # source://rack//lib/rack/lint.rb#365
  def check_input(input); end

  # === The Status
  #
  # source://rack//lib/rack/lint.rb#647
  def check_status(status); end

  # source://rack//lib/rack/lint.rb#781
  def close; end

  # === The Body
  #
  # source://rack//lib/rack/lint.rb#734
  def each; end

  # source://rack//lib/rack/lint.rb#721
  def verify_content_length(bytes); end
end

# source://rack//lib/rack/lint.rb#18
module Rack::Lint::Assertion
  # source://rack//lib/rack/lint.rb#19
  def assert(message); end
end

# source://rack//lib/rack/lint.rb#492
class Rack::Lint::ErrorWrapper
  include ::Rack::Lint::Assertion

  # @return [ErrorWrapper] a new instance of ErrorWrapper
  #
  # source://rack//lib/rack/lint.rb#495
  def initialize(error); end

  # * +close+ must never be called on the error stream.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#517
  def close(*args); end

  # * +flush+ must be called without arguments and must be called
  #   in order to make the error appear for sure.
  #
  # source://rack//lib/rack/lint.rb#512
  def flush; end

  # * +puts+ must be called with a single argument that responds to +to_s+.
  #
  # source://rack//lib/rack/lint.rb#500
  def puts(str); end

  # * +write+ must be called with a single argument that is a String.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#505
  def write(str); end
end

# source://rack//lib/rack/lint.rb#522
class Rack::Lint::HijackWrapper
  include ::Rack::Lint::Assertion
  extend ::Forwardable

  # @return [HijackWrapper] a new instance of HijackWrapper
  #
  # source://rack//lib/rack/lint.rb#533
  def initialize(io); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def close(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def close_read(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def close_write(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def closed?(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def flush(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def read(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def read_nonblock(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def write(*args, **_arg1, &block); end

  # source://forwardable/1.3.3/forwardable.rb#231
  def write_nonblock(*args, **_arg1, &block); end
end

# source://rack//lib/rack/lint.rb#526
Rack::Lint::HijackWrapper::REQUIRED_METHODS = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/lint.rb#383
class Rack::Lint::InputWrapper
  include ::Rack::Lint::Assertion

  # @return [InputWrapper] a new instance of InputWrapper
  #
  # source://rack//lib/rack/lint.rb#386
  def initialize(input); end

  # * +close+ must never be called on the input stream.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#477
  def close(*args); end

  # * +each+ must be called without arguments and only yield Strings.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#451
  def each(*args); end

  # * +gets+ must be called without arguments and return a string,
  #   or +nil+ on EOF.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#392
  def gets(*args); end

  # * +read+ behaves like IO#read.
  #   Its signature is <tt>read([length, [buffer]])</tt>.
  #
  #   If given, +length+ must be a non-negative Integer (>= 0) or +nil+,
  #   and +buffer+ must be a String and may not be nil.
  #
  #   If +length+ is given and not nil, then this method reads at most
  #   +length+ bytes from the input stream.
  #
  #   If +length+ is not given or nil, then this method reads
  #   all data until EOF.
  #
  #   When EOF is reached, this method returns nil if +length+ is given
  #   and not nil, or "" if +length+ is not given or is nil.
  #
  #   If +buffer+ is given, then the read data will be placed
  #   into +buffer+ instead of a newly created String object.
  #
  # source://rack//lib/rack/lint.rb#418
  def read(*args); end

  # * +rewind+ must be called without arguments. It rewinds the input
  #   stream back to the beginning. It must not raise Errno::ESPIPE:
  #   that is, it may not be a pipe or a socket. Therefore, handler
  #   developers must buffer the input data into some rewindable object
  #   if the underlying input stream is not rewindable.
  #
  # @raise [LintError]
  #
  # source://rack//lib/rack/lint.rb#466
  def rewind(*args); end
end

# :stopdoc:
#
# source://rack//lib/rack/lint.rb#17
class Rack::Lint::LintError < ::RuntimeError; end

# Rack::Lock locks every request inside a mutex, so that every request
# will effectively be executed synchronously.
#
# source://rack//lib/rack/lock.rb#8
class Rack::Lock
  # @return [Lock] a new instance of Lock
  #
  # source://rack//lib/rack/lock.rb#9
  def initialize(app, mutex = T.unsafe(nil)); end

  # source://rack//lib/rack/lock.rb#13
  def call(env); end

  private

  # source://rack//lib/rack/lock.rb#27
  def unlock; end
end

# Sets up rack.logger to write to rack.errors stream
#
# source://rack//lib/rack/logger.rb#7
class Rack::Logger
  # @return [Logger] a new instance of Logger
  #
  # source://rack//lib/rack/logger.rb#8
  def initialize(app, level = T.unsafe(nil)); end

  # source://rack//lib/rack/logger.rb#12
  def call(env); end
end

# Rack::MediaType parse media type and parameters out of content_type string
#
# source://rack//lib/rack/media_type.rb#6
class Rack::MediaType
  class << self
    # The media type parameters provided in CONTENT_TYPE as a Hash, or
    # an empty Hash if no CONTENT_TYPE or media-type parameters were
    # provided.  e.g., when the CONTENT_TYPE is "text/plain;charset=utf-8",
    # this method responds with the following Hash:
    #   { 'charset' => 'utf-8' }
    #
    # source://rack//lib/rack/media_type.rb#30
    def params(content_type); end

    # The media type (type/subtype) portion of the CONTENT_TYPE header
    # without any media type parameters. e.g., when CONTENT_TYPE is
    # "text/plain;charset=utf-8", the media-type is "text/plain".
    #
    # For more information on the use of media types in HTTP, see:
    # http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.7
    #
    # source://rack//lib/rack/media_type.rb#16
    def type(content_type); end

    private

    # source://rack//lib/rack/media_type.rb#43
    def strip_doublequotes(str); end
  end
end

# source://rack//lib/rack/media_type.rb#7
Rack::MediaType::SPLIT_PATTERN = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/method_override.rb#4
class Rack::MethodOverride
  # @return [MethodOverride] a new instance of MethodOverride
  #
  # source://rack//lib/rack/method_override.rb#11
  def initialize(app); end

  # source://rack//lib/rack/method_override.rb#15
  def call(env); end

  # source://rack//lib/rack/method_override.rb#27
  def method_override(env); end

  private

  # source://rack//lib/rack/method_override.rb#40
  def allowed_methods; end

  # source://rack//lib/rack/method_override.rb#44
  def method_override_param(req); end
end

# source://rack//lib/rack/method_override.rb#9
Rack::MethodOverride::ALLOWED_METHODS = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/method_override.rb#5
Rack::MethodOverride::HTTP_METHODS = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/method_override.rb#8
Rack::MethodOverride::HTTP_METHOD_OVERRIDE_HEADER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/method_override.rb#7
Rack::MethodOverride::METHOD_OVERRIDE_PARAM_KEY = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/mime.rb#4
module Rack::Mime
  private

  # Returns true if the given value is a mime match for the given mime match
  # specification, false otherwise.
  #
  #    Rack::Mime.match?('text/html', 'text/*') => true
  #    Rack::Mime.match?('text/plain', '*') => true
  #    Rack::Mime.match?('text/html', 'application/json') => false
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/mime.rb#30
  def match?(value, matcher); end

  # Returns String with mime type if found, otherwise use +fallback+.
  # +ext+ should be filename extension in the '.ext' format that
  #       File.extname(file) returns.
  # +fallback+ may be any object
  #
  # Also see the documentation for MIME_TYPES
  #
  # Usage:
  #     Rack::Mime.mime_type('.foo')
  #
  # This is a shortcut for:
  #     Rack::Mime::MIME_TYPES.fetch('.foo', 'application/octet-stream')
  #
  # source://rack//lib/rack/mime.rb#18
  def mime_type(ext, fallback = T.unsafe(nil)); end

  class << self
    # Returns true if the given value is a mime match for the given mime match
    # specification, false otherwise.
    #
    #    Rack::Mime.match?('text/html', 'text/*') => true
    #    Rack::Mime.match?('text/plain', '*') => true
    #    Rack::Mime.match?('text/html', 'application/json') => false
    #
    # @return [Boolean]
    #
    # source://rack//lib/rack/mime.rb#30
    def match?(value, matcher); end

    # Returns String with mime type if found, otherwise use +fallback+.
    # +ext+ should be filename extension in the '.ext' format that
    #       File.extname(file) returns.
    # +fallback+ may be any object
    #
    # Also see the documentation for MIME_TYPES
    #
    # Usage:
    #     Rack::Mime.mime_type('.foo')
    #
    # This is a shortcut for:
    #     Rack::Mime::MIME_TYPES.fetch('.foo', 'application/octet-stream')
    #
    # source://rack//lib/rack/mime.rb#18
    def mime_type(ext, fallback = T.unsafe(nil)); end
  end
end

# List of most common mime-types, selected various sources
# according to their usefulness in a webserving scope for Ruby
# users.
#
# To amend this list with your local mime.types list you can use:
#
#     require 'webrick/httputils'
#     list = WEBrick::HTTPUtils.load_mime_types('/etc/mime.types')
#     Rack::Mime::MIME_TYPES.merge!(list)
#
# N.B. On Ubuntu the mime.types file does not include the leading period, so
# users may need to modify the data before merging into the hash.
#
# source://rack//lib/rack/mime.rb#51
Rack::Mime::MIME_TYPES = T.let(T.unsafe(nil), Hash)

# Rack::MockRequest helps testing your Rack application without
# actually using HTTP.
#
# After performing a request on a URL with get/post/put/patch/delete, it
# returns a MockResponse with useful helper methods for effective
# testing.
#
# You can pass a hash with additional configuration to the
# get/post/put/patch/delete.
# <tt>:input</tt>:: A String or IO-like to be used as rack.input.
# <tt>:fatal</tt>:: Raise a FatalWarning if the app writes to rack.errors.
# <tt>:lint</tt>:: If true, wrap the application in a Rack::Lint.
#
# source://rack//lib/rack/mock.rb#22
class Rack::MockRequest
  # @return [MockRequest] a new instance of MockRequest
  #
  # source://rack//lib/rack/mock.rb#52
  def initialize(app); end

  # Make a DELETE request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock.rb#65
  def delete(uri, opts = T.unsafe(nil)); end

  # Make a GET request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock.rb#57
  def get(uri, opts = T.unsafe(nil)); end

  # Make a HEAD request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock.rb#67
  def head(uri, opts = T.unsafe(nil)); end

  # Make an OPTIONS request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock.rb#69
  def options(uri, opts = T.unsafe(nil)); end

  # Make a PATCH request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock.rb#63
  def patch(uri, opts = T.unsafe(nil)); end

  # Make a POST request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock.rb#59
  def post(uri, opts = T.unsafe(nil)); end

  # Make a PUT request and return a MockResponse. See #request.
  #
  # source://rack//lib/rack/mock.rb#61
  def put(uri, opts = T.unsafe(nil)); end

  # Make a request using the given request method for the given
  # uri to the rack application and return a MockResponse.
  # Options given are passed to MockRequest.env_for.
  #
  # source://rack//lib/rack/mock.rb#74
  def request(method = T.unsafe(nil), uri = T.unsafe(nil), opts = T.unsafe(nil)); end

  class << self
    # Return the Rack environment used for a request to +uri+.
    # All options that are strings are added to the returned environment.
    # Options:
    # :fatal :: Whether to raise an exception if request outputs to rack.errors
    # :input :: The rack.input to set
    # :method :: The HTTP request method to use
    # :params :: The params to use
    # :script_name :: The SCRIPT_NAME to set
    #
    # source://rack//lib/rack/mock.rb#105
    def env_for(uri = T.unsafe(nil), opts = T.unsafe(nil)); end

    # For historical reasons, we're pinning to RFC 2396.
    # URI::Parser = URI::RFC2396_Parser
    #
    # source://rack//lib/rack/mock.rb#92
    def parse_uri_rfc2396(uri); end
  end
end

# source://rack//lib/rack/mock.rb#43
Rack::MockRequest::DEFAULT_ENV = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/mock.rb#26
class Rack::MockRequest::FatalWarner
  # source://rack//lib/rack/mock.rb#35
  def flush; end

  # @raise [FatalWarning]
  #
  # source://rack//lib/rack/mock.rb#27
  def puts(warning); end

  # source://rack//lib/rack/mock.rb#38
  def string; end

  # @raise [FatalWarning]
  #
  # source://rack//lib/rack/mock.rb#31
  def write(warning); end
end

# source://rack//lib/rack/mock.rb#23
class Rack::MockRequest::FatalWarning < ::RuntimeError; end

# Rack::MockResponse provides useful helpers for testing your apps.
# Usually, you don't create the MockResponse on your own, but use
# MockRequest.
#
# source://rack//lib/rack/mock.rb#173
class Rack::MockResponse < ::Rack::Response
  # @return [MockResponse] a new instance of MockResponse
  #
  # source://rack//lib/rack/mock.rb#184
  def initialize(status, headers, body, errors = T.unsafe(nil)); end

  # source://rack//lib/rack/mock.rb#194
  def =~(other); end

  # source://rack//lib/rack/mock.rb#202
  def body; end

  # source://rack//lib/rack/mock.rb#226
  def cookie(name); end

  # Headers
  #
  # source://rack//lib/rack/mock.rb#179
  def cookies; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/mock.rb#222
  def empty?; end

  # Errors
  #
  # source://rack//lib/rack/mock.rb#182
  def errors; end

  # Errors
  #
  # source://rack//lib/rack/mock.rb#182
  def errors=(_arg0); end

  # source://rack//lib/rack/mock.rb#198
  def match(other); end

  # Headers
  #
  # source://rack//lib/rack/mock.rb#179
  def original_headers; end

  private

  # source://rack//lib/rack/mock.rb#253
  def identify_cookie_attributes(cookie_filling); end

  # source://rack//lib/rack/mock.rb#232
  def parse_cookies_from_header; end

  class << self
    def [](*_arg0); end
  end
end

# A multipart form data parser, adapted from IOWA.
#
# Usually, Rack::Request#POST takes care of calling this.
#
# source://rack//lib/rack/multipart/parser.rb#6
module Rack::Multipart
  class << self
    # source://rack//lib/rack/multipart.rb#58
    def build_multipart(params, first = T.unsafe(nil)); end

    # source://rack//lib/rack/multipart.rb#44
    def extract_multipart(req, params = T.unsafe(nil)); end

    # source://rack//lib/rack/multipart.rb#40
    def parse_multipart(env, params = T.unsafe(nil)); end
  end
end

# source://rack//lib/rack/multipart.rb#25
Rack::Multipart::ATTRIBUTE = T.let(T.unsafe(nil), Regexp)

# Updated definitions from RFC 2231
#
# source://rack//lib/rack/multipart.rb#24
Rack::Multipart::ATTRIBUTE_CHAR = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#19
Rack::Multipart::BROKEN = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#17
Rack::Multipart::CONDISP = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#36
Rack::Multipart::DISPPARM = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#13
Rack::Multipart::EOL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/multipart.rb#32
Rack::Multipart::EXTENDED_INITIAL_NAME = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#34
Rack::Multipart::EXTENDED_INITIAL_PARAMETER = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#33
Rack::Multipart::EXTENDED_INITIAL_VALUE = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#29
Rack::Multipart::EXTENDED_OTHER_NAME = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#31
Rack::Multipart::EXTENDED_OTHER_PARAMETER = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#30
Rack::Multipart::EXTENDED_OTHER_VALUE = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#35
Rack::Multipart::EXTENDED_PARAMETER = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart/generator.rb#5
class Rack::Multipart::Generator
  # @return [Generator] a new instance of Generator
  #
  # source://rack//lib/rack/multipart/generator.rb#6
  def initialize(params, first = T.unsafe(nil)); end

  # source://rack//lib/rack/multipart/generator.rb#14
  def dump; end

  private

  # source://rack//lib/rack/multipart/generator.rb#87
  def content_for_other(file, name); end

  # source://rack//lib/rack/multipart/generator.rb#75
  def content_for_tempfile(io, file, name); end

  # source://rack//lib/rack/multipart/generator.rb#50
  def flattened_params; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/generator.rb#35
  def multipart?; end
end

# source://rack//lib/rack/multipart.rb#15
Rack::Multipart::MULTIPART = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#14
Rack::Multipart::MULTIPART_BOUNDARY = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/multipart.rb#21
Rack::Multipart::MULTIPART_CONTENT_DISPOSITION = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#22
Rack::Multipart::MULTIPART_CONTENT_ID = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#20
Rack::Multipart::MULTIPART_CONTENT_TYPE = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart/parser.rb#7
class Rack::Multipart::MultipartPartLimitError < ::Errno::EMFILE; end

# source://rack//lib/rack/multipart/parser.rb#8
class Rack::Multipart::MultipartTotalPartLimitError < ::StandardError; end

# source://rack//lib/rack/multipart/parser.rb#10
class Rack::Multipart::Parser
  # @return [Parser] a new instance of Parser
  #
  # source://rack//lib/rack/multipart/parser.rb#180
  def initialize(boundary, tempfile, bufsize, query_parser); end

  # source://rack//lib/rack/multipart/parser.rb#199
  def on_read(content); end

  # source://rack//lib/rack/multipart/parser.rb#205
  def result; end

  # Returns the value of attribute state.
  #
  # source://rack//lib/rack/multipart/parser.rb#178
  def state; end

  private

  # source://rack//lib/rack/multipart/parser.rb#302
  def consume_boundary; end

  # source://rack//lib/rack/multipart/parser.rb#300
  def full_boundary; end

  # source://rack//lib/rack/multipart/parser.rb#312
  def get_filename(head); end

  # source://rack//lib/rack/multipart/parser.rb#248
  def handle_consume_token; end

  # source://rack//lib/rack/multipart/parser.rb#377
  def handle_empty_content!(content); end

  # source://rack//lib/rack/multipart/parser.rb#234
  def handle_fast_forward; end

  # source://rack//lib/rack/multipart/parser.rb#281
  def handle_mime_body; end

  # source://rack//lib/rack/multipart/parser.rb#258
  def handle_mime_head; end

  # source://rack//lib/rack/multipart/parser.rb#217
  def run_parser; end

  # source://rack//lib/rack/multipart/parser.rb#349
  def tag_multipart_encoding(filename, content_type, name, body); end

  class << self
    # source://rack//lib/rack/multipart/parser.rb#66
    def parse(io, content_length, content_type, tmpfile, bufsize, qp); end

    # source://rack//lib/rack/multipart/parser.rb#59
    def parse_boundary(content_type); end
  end
end

# source://rack//lib/rack/multipart/parser.rb#21
Rack::Multipart::Parser::BOUNDARY_REGEX = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart/parser.rb#13
Rack::Multipart::Parser::BUFSIZE = T.let(T.unsafe(nil), Integer)

# source://rack//lib/rack/multipart/parser.rb#23
class Rack::Multipart::Parser::BoundedIO
  # @return [BoundedIO] a new instance of BoundedIO
  #
  # source://rack//lib/rack/multipart/parser.rb#24
  def initialize(io, content_length); end

  # source://rack//lib/rack/multipart/parser.rb#30
  def read(size, outbuf = T.unsafe(nil)); end

  # source://rack//lib/rack/multipart/parser.rb#51
  def rewind; end
end

# source://rack//lib/rack/multipart/parser.rb#347
Rack::Multipart::Parser::CHARSET = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/multipart/parser.rb#87
class Rack::Multipart::Parser::Collector
  include ::Enumerable

  # @return [Collector] a new instance of Collector
  #
  # source://rack//lib/rack/multipart/parser.rb#123
  def initialize(tempfile); end

  # source://rack//lib/rack/multipart/parser.rb#129
  def each; end

  # source://rack//lib/rack/multipart/parser.rb#149
  def on_mime_body(mime_index, content); end

  # source://rack//lib/rack/multipart/parser.rb#153
  def on_mime_finish(mime_index); end

  # source://rack//lib/rack/multipart/parser.rb#133
  def on_mime_head(mime_index, head, filename, content_type, name); end

  private

  # source://rack//lib/rack/multipart/parser.rb#158
  def check_part_limits; end
end

# source://rack//lib/rack/multipart/parser.rb#111
class Rack::Multipart::Parser::Collector::BufferPart < ::Rack::Multipart::Parser::Collector::MimePart
  # source://rack//lib/rack/multipart/parser.rb#113
  def close; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/parser.rb#112
  def file?; end
end

# source://rack//lib/rack/multipart/parser.rb#88
class Rack::Multipart::Parser::Collector::MimePart < ::Struct
  # @yield [data]
  #
  # source://rack//lib/rack/multipart/parser.rb#89
  def get_data; end
end

# source://rack//lib/rack/multipart/parser.rb#116
class Rack::Multipart::Parser::Collector::TempfilePart < ::Rack::Multipart::Parser::Collector::MimePart
  # source://rack//lib/rack/multipart/parser.rb#118
  def close; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/parser.rb#117
  def file?; end
end

# source://rack//lib/rack/multipart/parser.rb#57
Rack::Multipart::Parser::EMPTY = T.let(T.unsafe(nil), Rack::Multipart::Parser::MultipartInfo)

# source://rack//lib/rack/multipart/parser.rb#56
class Rack::Multipart::Parser::MultipartInfo < ::Struct
  # Returns the value of attribute params
  #
  # @return [Object] the current value of params
  def params; end

  # Sets the attribute params
  #
  # @param value [Object] the value to set the attribute params to.
  # @return [Object] the newly set value
  def params=(_); end

  # Returns the value of attribute tmp_files
  #
  # @return [Object] the current value of tmp_files
  def tmp_files; end

  # Sets the attribute tmp_files
  #
  # @param value [Object] the value to set the attribute tmp_files to.
  # @return [Object] the newly set value
  def tmp_files=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://rack//lib/rack/multipart/parser.rb#15
Rack::Multipart::Parser::TEMPFILE_FACTORY = T.let(T.unsafe(nil), Proc)

# source://rack//lib/rack/multipart/parser.rb#14
Rack::Multipart::Parser::TEXT_PLAIN = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/multipart.rb#28
Rack::Multipart::REGULAR_PARAMETER = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#27
Rack::Multipart::REGULAR_PARAMETER_NAME = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#37
Rack::Multipart::RFC2183 = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#26
Rack::Multipart::SECTION = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart.rb#16
Rack::Multipart::TOKEN = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/multipart/uploaded_file.rb#5
class Rack::Multipart::UploadedFile
  # @return [UploadedFile] a new instance of UploadedFile
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#12
  def initialize(filepath = T.unsafe(nil), ct = T.unsafe(nil), bin = T.unsafe(nil), path: T.unsafe(nil), content_type: T.unsafe(nil), binary: T.unsafe(nil), filename: T.unsafe(nil), io: T.unsafe(nil)); end

  # The content type of the "uploaded" file
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#10
  def content_type; end

  # The content type of the "uploaded" file
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#10
  def content_type=(_arg0); end

  # source://rack//lib/rack/multipart/uploaded_file.rb#27
  def local_path; end

  # source://rack//lib/rack/multipart/uploaded_file.rb#36
  def method_missing(method_name, *args, &block); end

  # The filename, *not* including the path, of the "uploaded" file
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#7
  def original_filename; end

  # source://rack//lib/rack/multipart/uploaded_file.rb#27
  def path; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/multipart/uploaded_file.rb#32
  def respond_to?(*args); end
end

# source://rack//lib/rack/multipart.rb#18
Rack::Multipart::VALUE = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/null_logger.rb#4
class Rack::NullLogger
  # @return [NullLogger] a new instance of NullLogger
  #
  # source://rack//lib/rack/null_logger.rb#5
  def initialize(app); end

  # source://rack//lib/rack/null_logger.rb#37
  def <<(msg); end

  # source://rack//lib/rack/null_logger.rb#36
  def add(severity, message = T.unsafe(nil), progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#9
  def call(env); end

  # source://rack//lib/rack/null_logger.rb#35
  def close; end

  # source://rack//lib/rack/null_logger.rb#27
  def datetime_format; end

  # source://rack//lib/rack/null_logger.rb#32
  def datetime_format=(datetime_format); end

  # source://rack//lib/rack/null_logger.rb#15
  def debug(progname = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#21
  def debug?; end

  # source://rack//lib/rack/null_logger.rb#17
  def error(progname = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#23
  def error?; end

  # source://rack//lib/rack/null_logger.rb#18
  def fatal(progname = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#24
  def fatal?; end

  # source://rack//lib/rack/null_logger.rb#28
  def formatter; end

  # source://rack//lib/rack/null_logger.rb#33
  def formatter=(formatter); end

  # source://rack//lib/rack/null_logger.rb#14
  def info(progname = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#20
  def info?; end

  # source://rack//lib/rack/null_logger.rb#25
  def level; end

  # source://rack//lib/rack/null_logger.rb#30
  def level=(level); end

  # source://rack//lib/rack/null_logger.rb#26
  def progname; end

  # source://rack//lib/rack/null_logger.rb#31
  def progname=(progname); end

  # source://rack//lib/rack/null_logger.rb#29
  def sev_threshold; end

  # source://rack//lib/rack/null_logger.rb#34
  def sev_threshold=(sev_threshold); end

  # source://rack//lib/rack/null_logger.rb#19
  def unknown(progname = T.unsafe(nil), &block); end

  # source://rack//lib/rack/null_logger.rb#16
  def warn(progname = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/null_logger.rb#22
  def warn?; end
end

# source://rack//lib/rack.rb#45
Rack::OPTIONS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#42
Rack::PATCH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#21
Rack::PATH_INFO = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#40
Rack::POST = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#41
Rack::PUT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#25
Rack::QUERY_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/query_parser.rb#4
class Rack::QueryParser
  # @return [QueryParser] a new instance of QueryParser
  #
  # source://rack//lib/rack/query_parser.rb#29
  def initialize(params_class, key_space_limit, param_depth_limit); end

  # Returns the value of attribute key_space_limit.
  #
  # source://rack//lib/rack/query_parser.rb#27
  def key_space_limit; end

  # source://rack//lib/rack/query_parser.rb#128
  def make_params; end

  # source://rack//lib/rack/query_parser.rb#136
  def new_depth_limit(param_depth_limit); end

  # source://rack//lib/rack/query_parser.rb#132
  def new_space_limit(key_space_limit); end

  # normalize_params recursively expands parameters into structural types. If
  # the structural types represented by two different parameter names are in
  # conflict, a ParameterTypeError is raised.
  #
  # @raise [ParamsTooDeepError]
  #
  # source://rack//lib/rack/query_parser.rb#87
  def normalize_params(params, name, v, depth); end

  # Returns the value of attribute param_depth_limit.
  #
  # source://rack//lib/rack/query_parser.rb#27
  def param_depth_limit; end

  # parse_nested_query expands a query string into structural types. Supported
  # types are Arrays, Hashes and basic value types. It is possible to supply
  # query strings with parameters of conflicting types, in this case a
  # ParameterTypeError is raised. Users are encouraged to return a 400 in this
  # case.
  #
  # source://rack//lib/rack/query_parser.rb#68
  def parse_nested_query(qs, d = T.unsafe(nil)); end

  # Stolen from Mongrel, with some small modifications:
  # Parses a query string by breaking it up at the '&'
  # and ';' characters.  You can also use this to parse
  # cookies by changing the characters used in the second
  # parameter (which defaults to '&;').
  #
  # source://rack//lib/rack/query_parser.rb#40
  def parse_query(qs, d = T.unsafe(nil), &unescaper); end

  private

  # @return [Boolean]
  #
  # source://rack//lib/rack/query_parser.rb#146
  def params_hash_has_key?(hash, key); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/query_parser.rb#142
  def params_hash_type?(obj); end

  # source://rack//lib/rack/query_parser.rb#158
  def unescape(s); end

  class << self
    # source://rack//lib/rack/query_parser.rb#23
    def make_default(key_space_limit, param_depth_limit); end
  end
end

# source://rack//lib/rack/query_parser.rb#8
Rack::QueryParser::COMMON_SEP = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/query_parser.rb#7
Rack::QueryParser::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)

# InvalidParameterError is the error that is raised when incoming structural
# parameters (parsed by parse_nested_query) contain invalid format or byte
# sequence.
#
# source://rack//lib/rack/query_parser.rb#17
class Rack::QueryParser::InvalidParameterError < ::ArgumentError; end

# ParameterTypeError is the error that is raised when incoming structural
# parameters (parsed by parse_nested_query) contain conflicting types.
#
# source://rack//lib/rack/query_parser.rb#12
class Rack::QueryParser::ParameterTypeError < ::TypeError; end

# source://rack//lib/rack/query_parser.rb#162
class Rack::QueryParser::Params
  # @return [Params] a new instance of Params
  #
  # source://rack//lib/rack/query_parser.rb#163
  def initialize(limit); end

  # source://rack//lib/rack/query_parser.rb#169
  def [](key); end

  # @raise [ParamsTooDeepError]
  #
  # source://rack//lib/rack/query_parser.rb#173
  def []=(key, value); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/query_parser.rb#179
  def key?(key); end

  # Recursively unwraps nested `Params` objects and constructs an object
  # of the same shape, but using the objects' internal representations
  # (Ruby hashes) in place of the objects. The result is a hash consisting
  # purely of Ruby primitives.
  #
  #   Mutation warning!
  #
  #   1. This method mutates the internal representation of the `Params`
  #      objects in order to save object allocations.
  #
  #   2. The value you get back is a reference to the internal hash
  #      representation, not a copy.
  #
  #   3. Because the `Params` object's internal representation is mutable
  #      through the `#[]=` method, it is not thread safe. The result of
  #      getting the hash representation while another thread is adding a
  #      key to it is non-deterministic.
  #
  # source://rack//lib/rack/query_parser.rb#201
  def to_h; end

  # Recursively unwraps nested `Params` objects and constructs an object
  # of the same shape, but using the objects' internal representations
  # (Ruby hashes) in place of the objects. The result is a hash consisting
  # purely of Ruby primitives.
  #
  #   Mutation warning!
  #
  #   1. This method mutates the internal representation of the `Params`
  #      objects in order to save object allocations.
  #
  #   2. The value you get back is a reference to the internal hash
  #      representation, not a copy.
  #
  #   3. Because the `Params` object's internal representation is mutable
  #      through the `#[]=` method, it is not thread safe. The result of
  #      getting the hash representation while another thread is adding a
  #      key to it is non-deterministic.
  #
  # source://rack//lib/rack/query_parser.rb#201
  def to_params_hash; end
end

# ParamsTooDeepError is the error that is raised when params are recursively
# nested over the specified limit.
#
# source://rack//lib/rack/query_parser.rb#21
class Rack::QueryParser::ParamsTooDeepError < ::RangeError; end

# source://rack//lib/rack.rb#53
Rack::RACK_ERRORS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#63
Rack::RACK_HIJACK = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#65
Rack::RACK_HIJACK_IO = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#55
Rack::RACK_INPUT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#64
Rack::RACK_IS_HIJACK = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#54
Rack::RACK_LOGGER = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#76
Rack::RACK_METHODOVERRIDE_ORIGINAL_METHOD = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#67
Rack::RACK_MULTIPART_BUFFER_SIZE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#68
Rack::RACK_MULTIPART_TEMPFILE_FACTORY = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#60
Rack::RACK_MULTIPROCESS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#59
Rack::RACK_MULTITHREAD = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#66
Rack::RACK_RECURSIVE_INCLUDE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#72
Rack::RACK_REQUEST_COOKIE_HASH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#73
Rack::RACK_REQUEST_COOKIE_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#70
Rack::RACK_REQUEST_FORM_HASH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#69
Rack::RACK_REQUEST_FORM_INPUT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#71
Rack::RACK_REQUEST_FORM_VARS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#74
Rack::RACK_REQUEST_QUERY_HASH = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#75
Rack::RACK_REQUEST_QUERY_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#61
Rack::RACK_RUNONCE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#56
Rack::RACK_SESSION = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#57
Rack::RACK_SESSION_OPTIONS = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#77
Rack::RACK_SESSION_UNPACKED_COOKIE_DATA = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#58
Rack::RACK_SHOWSTATUS_DETAIL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#52
Rack::RACK_TEMPFILES = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#62
Rack::RACK_URL_SCHEME = T.let(T.unsafe(nil), String)

# Rack environment variables
#
# source://rack//lib/rack.rb#51
Rack::RACK_VERSION = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/version.rb#23
Rack::RELEASE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#22
Rack::REQUEST_METHOD = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#23
Rack::REQUEST_PATH = T.let(T.unsafe(nil), String)

# Rack::Recursive allows applications called down the chain to
# include data from other applications (by using
# <tt>rack['rack.recursive.include'][...]</tt> or raise a
# ForwardRequest to redirect internally.
#
# source://rack//lib/rack/recursive.rb#34
class Rack::Recursive
  # @return [Recursive] a new instance of Recursive
  #
  # source://rack//lib/rack/recursive.rb#35
  def initialize(app); end

  # source://rack//lib/rack/recursive.rb#43
  def _call(env); end

  # source://rack//lib/rack/recursive.rb#39
  def call(env); end

  # source://rack//lib/rack/recursive.rb#50
  def include(env, path); end
end

# High performant source reloader
#
# This class acts as Rack middleware.
#
# What makes it especially suited for use in a production environment is that
# any file will only be checked once and there will only be made one system
# call stat(2).
#
# Please note that this will not reload files in the background, it does so
# only when actively called.
#
# It is performing a check/reload cycle at the start of every request, but
# also respects a cool down time, during which nothing will be done.
#
# source://rack//lib/rack/reloader.rb#24
class Rack::Reloader
  # @return [Reloader] a new instance of Reloader
  #
  # source://rack//lib/rack/reloader.rb#27
  def initialize(app, cooldown = T.unsafe(nil), backend = T.unsafe(nil)); end

  # source://rack//lib/rack/reloader.rb#38
  def call(env); end

  # source://rack//lib/rack/reloader.rb#52
  def reload!(stderr = T.unsafe(nil)); end

  # A safe Kernel::load, issuing the hooks depending on the results
  #
  # source://rack//lib/rack/reloader.rb#60
  def safe_load(file, mtime, stderr = T.unsafe(nil)); end
end

# source://rack//lib/rack/reloader.rb#70
module Rack::Reloader::Stat
  # Takes a relative or absolute +file+ name, a couple possible +paths+ that
  # the +file+ might reside in. Returns the full path and File::Stat for the
  # path.
  #
  # source://rack//lib/rack/reloader.rb#90
  def figure_path(file, paths); end

  # source://rack//lib/rack/reloader.rb#71
  def rotation; end

  # source://rack//lib/rack/reloader.rb#105
  def safe_stat(file); end
end

# Rack::Request provides a convenient interface to a Rack
# environment.  It is stateless, the environment +env+ passed to the
# constructor will be directly modified.
#
#   req = Rack::Request.new(env)
#   req.post?
#   req.params["data"]
#
# source://rack//lib/rack/request.rb#12
class Rack::Request
  include ::Rack::Request::Env
  include ::Rack::Request::Helpers

  # @return [Request] a new instance of Request
  #
  # source://rack//lib/rack/request.rb#26
  def initialize(env); end

  # source://rack//lib/rack/request.rb#40
  def delete_param(k); end

  # source://rack//lib/rack/request.rb#31
  def params; end

  # source://rack//lib/rack/request.rb#31
  def query; end

  # source://rack//lib/rack/request.rb#35
  def update_param(k, v); end

  # source://yard/0.9.36/lib/yard/server/rack_adapter.rb#94
  def version_supplied; end

  # source://yard/0.9.36/lib/yard/server/rack_adapter.rb#94
  def version_supplied=(_arg0); end

  # source://yard/0.9.36/lib/yard/server/rack_adapter.rb#96
  def xhr?; end

  class << self
    # Returns the value of attribute ip_filter.
    #
    # source://rack//lib/rack/request.rb#16
    def ip_filter; end

    # Sets the attribute ip_filter
    #
    # @param value the value to set the attribute ip_filter to.
    #
    # source://rack//lib/rack/request.rb#16
    def ip_filter=(_arg0); end
  end
end

# source://rack//lib/rack/request.rb#20
Rack::Request::ALLOWED_SCHEMES = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/request.rb#46
module Rack::Request::Env
  # source://rack//lib/rack/request.rb#50
  def initialize(env); end

  # Add a header that may have multiple values.
  #
  # Example:
  #   request.add_header 'Accept', 'image/png'
  #   request.add_header 'Accept', '*/*'
  #
  #   assert_equal 'image/png,*/*', request.get_header('Accept')
  #
  # http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2
  #
  # source://rack//lib/rack/request.rb#91
  def add_header(key, v); end

  # Delete a request specific value for `name`.
  #
  # source://rack//lib/rack/request.rb#102
  def delete_header(name); end

  # Loops through each key / value pair in the request specific data.
  #
  # source://rack//lib/rack/request.rb#73
  def each_header(&block); end

  # The environment of the request.
  #
  # source://rack//lib/rack/request.rb#48
  def env; end

  # If a block is given, it yields to the block if the value hasn't been set
  # on the request.
  #
  # source://rack//lib/rack/request.rb#68
  def fetch_header(name, &block); end

  # Get a request specific value for `name`.
  #
  # source://rack//lib/rack/request.rb#62
  def get_header(name); end

  # Predicate method to test to see if `name` has been set as request
  # specific data
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#57
  def has_header?(name); end

  # Set a request specific value for `name` to `v`
  #
  # source://rack//lib/rack/request.rb#78
  def set_header(name, v); end

  private

  # source://rack//lib/rack/request.rb#106
  def initialize_copy(other); end
end

# source://rack//lib/rack/request.rb#111
module Rack::Request::Helpers
  # Returns the data received in the query string.
  #
  # source://rack//lib/rack/request.rb#426
  def GET; end

  # Returns the data received in the request body.
  #
  # This method support both application/x-www-form-urlencoded and
  # multipart/form-data.
  #
  # source://rack//lib/rack/request.rb#440
  def POST; end

  # shortcut for <tt>request.params[key]</tt>
  #
  # source://rack//lib/rack/request.rb#532
  def [](key); end

  # shortcut for <tt>request.params[key] = value</tt>
  #
  # Note that modifications will not be persisted in the env. Use update_param or delete_param if you want to destructively modify params.
  #
  # source://rack//lib/rack/request.rb#543
  def []=(key, value); end

  # source://rack//lib/rack/request.rb#519
  def accept_encoding; end

  # source://rack//lib/rack/request.rb#523
  def accept_language; end

  # The authority of the incoming request as defined by RFC3976.
  # https://tools.ietf.org/html/rfc3986#section-3.2
  #
  # In HTTP/1, this is the `host` header.
  # In HTTP/2, this is the `:authority` pseudo-header.
  #
  # source://rack//lib/rack/request.rb#227
  def authority; end

  # source://rack//lib/rack/request.rb#502
  def base_url; end

  # source://rack//lib/rack/request.rb#150
  def body; end

  # The character set of the request body if a "charset" media type
  # parameter was given, or nil if no "charset" was specified. Note
  # that, per RFC2616, text/* media types that specify no explicit
  # charset are to be considered ISO-8859-1.
  #
  # source://rack//lib/rack/request.rb#400
  def content_charset; end

  # source://rack//lib/rack/request.rb#159
  def content_length; end

  # source://rack//lib/rack/request.rb#271
  def content_type; end

  # source://rack//lib/rack/request.rb#256
  def cookies; end

  # Checks the HTTP request method (or verb) to see if it was of type DELETE
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#181
  def delete?; end

  # Destructively delete a parameter, whether it's in GET or POST. Returns the value of the deleted parameter.
  #
  # If the parameter is in both GET and POST, the POST value takes precedence since that's how #params works.
  #
  # <tt>env['rack.input']</tt> is not touched.
  #
  # source://rack//lib/rack/request.rb#497
  def delete_param(k); end

  # Determine whether the request body contains form-data by checking
  # the request Content-Type for one of the media-types:
  # "application/x-www-form-urlencoded" or "multipart/form-data". The
  # list of form-data media types can be modified through the
  # +FORM_DATA_MEDIA_TYPES+ array.
  #
  # A request body is also assumed to contain form-data when no
  # Content-Type header is provided and the request_method is POST.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#412
  def form_data?; end

  # source://rack//lib/rack/request.rb#344
  def forwarded_authority; end

  # source://rack//lib/rack/request.rb#330
  def forwarded_for; end

  # source://rack//lib/rack/request.rb#338
  def forwarded_port; end

  # source://rack//lib/rack/request.rb#515
  def fullpath; end

  # Checks the HTTP request method (or verb) to see if it was of type GET
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#184
  def get?; end

  # Checks the HTTP request method (or verb) to see if it was of type HEAD
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#187
  def head?; end

  # Returns a formatted host, suitable for being used in a URI.
  #
  # source://rack//lib/rack/request.rb#296
  def host; end

  # The `HTTP_HOST` header.
  #
  # source://rack//lib/rack/request.rb#281
  def host_authority; end

  # source://rack//lib/rack/request.rb#285
  def host_with_port(authority = T.unsafe(nil)); end

  # Returns an address suitable for being to resolve to an address.
  # In the case of a domain name or IPv4 address, the result is the same
  # as +host+. In the case of IPv6 or future address formats, the square
  # brackets are removed.
  #
  # source://rack//lib/rack/request.rb#304
  def hostname; end

  # source://rack//lib/rack/request.rb#354
  def ip; end

  # Checks the HTTP request method (or verb) to see if it was of type LINK
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#193
  def link?; end

  # source://rack//lib/rack/request.rb#160
  def logger; end

  # The media type (type/subtype) portion of the CONTENT_TYPE header
  # without any media type parameters. e.g., when CONTENT_TYPE is
  # "text/plain;charset=utf-8", the media-type is "text/plain".
  #
  # For more information on the use of media types in HTTP, see:
  # http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.7
  #
  # source://rack//lib/rack/request.rb#383
  def media_type; end

  # The media type parameters provided in CONTENT_TYPE as a Hash, or
  # an empty Hash if no CONTENT_TYPE or media-type parameters were
  # provided.  e.g., when the CONTENT_TYPE is "text/plain;charset=utf-8",
  # this method responds with the following Hash:
  #   { 'charset' => 'utf-8' }
  #
  # source://rack//lib/rack/request.rb#392
  def media_type_params; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#162
  def multithread?; end

  # Checks the HTTP request method (or verb) to see if it was of type OPTIONS
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#190
  def options?; end

  # The union of GET and POST data.
  #
  # Note that modifications will not be persisted in the env. Use update_param or delete_param if you want to destructively modify params.
  #
  # source://rack//lib/rack/request.rb#468
  def params; end

  # Determine whether the request body contains data by checking
  # the request media_type against registered parse-data media-types
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#421
  def parseable_data?; end

  # Checks the HTTP request method (or verb) to see if it was of type PATCH
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#196
  def patch?; end

  # source://rack//lib/rack/request.rb#511
  def path; end

  # source://rack//lib/rack/request.rb#154
  def path_info; end

  # source://rack//lib/rack/request.rb#155
  def path_info=(s); end

  # source://rack//lib/rack/request.rb#308
  def port; end

  # Checks the HTTP request method (or verb) to see if it was of type POST
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#199
  def post?; end

  # Checks the HTTP request method (or verb) to see if it was of type PUT
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#202
  def put?; end

  # source://rack//lib/rack/request.rb#158
  def query_string; end

  # the referer of the client
  #
  # source://rack//lib/rack/request.rb#165
  def referer; end

  # the referer of the client
  #
  # source://rack//lib/rack/request.rb#165
  def referrer; end

  # source://rack//lib/rack/request.rb#157
  def request_method; end

  # source://rack//lib/rack/request.rb#210
  def scheme; end

  # source://rack//lib/rack/request.rb#151
  def script_name; end

  # source://rack//lib/rack/request.rb#152
  def script_name=(s); end

  # The authority as defined by the `SERVER_NAME` and `SERVER_PORT`
  # variables.
  #
  # source://rack//lib/rack/request.rb#233
  def server_authority; end

  # source://rack//lib/rack/request.rb#246
  def server_name; end

  # source://rack//lib/rack/request.rb#250
  def server_port; end

  # source://rack//lib/rack/request.rb#168
  def session; end

  # source://rack//lib/rack/request.rb#174
  def session_options; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#350
  def ssl?; end

  # Checks the HTTP request method (or verb) to see if it was of type TRACE
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#205
  def trace?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#527
  def trusted_proxy?(ip); end

  # Checks the HTTP request method (or verb) to see if it was of type UNLINK
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#208
  def unlink?; end

  # Destructively update a parameter, whether it's in GET and/or POST. Returns nil.
  #
  # The parameter is updated wherever it was previous defined, so GET, POST, or both. If it wasn't previously defined, it's inserted into GET.
  #
  # <tt>env['rack.input']</tt> is not touched.
  #
  # source://rack//lib/rack/request.rb#477
  def update_param(k, v); end

  # Tries to return a remake of the original request URL as a string.
  #
  # source://rack//lib/rack/request.rb#507
  def url; end

  # source://rack//lib/rack/request.rb#161
  def user_agent; end

  # like Hash#values_at
  #
  # source://rack//lib/rack/request.rb#552
  def values_at(*keys); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/request.rb#276
  def xhr?; end

  private

  # source://rack//lib/rack/request.rb#641
  def allowed_scheme(header); end

  # source://rack//lib/rack/request.rb#558
  def default_session; end

  # source://rack//lib/rack/request.rb#645
  def extract_proto_header(header); end

  # source://rack//lib/rack/request.rb#636
  def forwarded_scheme; end

  # source://rack//lib/rack/request.rb#574
  def parse_http_accept_header(header); end

  # source://rack//lib/rack/request.rb#593
  def parse_multipart; end

  # source://rack//lib/rack/request.rb#589
  def parse_query(qs, d = T.unsafe(nil)); end

  # source://rack//lib/rack/request.rb#585
  def query_parser; end

  # source://rack//lib/rack/request.rb#632
  def reject_trusted_ip_addresses(ip_addresses); end

  # source://rack//lib/rack/request.rb#619
  def split_authority(authority); end

  # source://rack//lib/rack/request.rb#597
  def split_header(value); end

  # Assist with compatibility when processing `X-Forwarded-For`.
  #
  # source://rack//lib/rack/request.rb#561
  def wrap_ipv6(host); end
end

# source://rack//lib/rack/request.rb#601
Rack::Request::Helpers::AUTHORITY = T.let(T.unsafe(nil), Regexp)

# Default ports depending on scheme. Used to decide whether or not
# to include the port in a generated URI.
#
# source://rack//lib/rack/request.rb#130
Rack::Request::Helpers::DEFAULT_PORTS = T.let(T.unsafe(nil), Hash)

# The set of form-data media-types. Requests that do not indicate
# one of the media types present in this list will not be eligible
# for form-data / param parsing.
#
# source://rack//lib/rack/request.rb#115
Rack::Request::Helpers::FORM_DATA_MEDIA_TYPES = T.let(T.unsafe(nil), Array)

# The address of the client which connected to the proxy.
#
# source://rack//lib/rack/request.rb#133
Rack::Request::Helpers::HTTP_X_FORWARDED_FOR = T.let(T.unsafe(nil), String)

# The contents of the host/:authority header sent to the proxy.
#
# source://rack//lib/rack/request.rb#136
Rack::Request::Helpers::HTTP_X_FORWARDED_HOST = T.let(T.unsafe(nil), String)

# The port used to connect to the proxy.
#
# source://rack//lib/rack/request.rb#145
Rack::Request::Helpers::HTTP_X_FORWARDED_PORT = T.let(T.unsafe(nil), String)

# The protocol used to connect to the proxy.
#
# source://rack//lib/rack/request.rb#142
Rack::Request::Helpers::HTTP_X_FORWARDED_PROTO = T.let(T.unsafe(nil), String)

# The value of the scheme sent to the proxy.
#
# source://rack//lib/rack/request.rb#139
Rack::Request::Helpers::HTTP_X_FORWARDED_SCHEME = T.let(T.unsafe(nil), String)

# Another way for specifing https scheme was used.
#
# source://rack//lib/rack/request.rb#148
Rack::Request::Helpers::HTTP_X_FORWARDED_SSL = T.let(T.unsafe(nil), String)

# The set of media-types. Requests that do not indicate
# one of the media types present in this list will not be eligible
# for param parsing like soap attachments or generic multiparts
#
# source://rack//lib/rack/request.rb#123
Rack::Request::Helpers::PARSEABLE_DATA_MEDIA_TYPES = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/request.rb#21
Rack::Request::SCHEME_WHITELIST = T.let(T.unsafe(nil), Array)

# Rack::Response provides a convenient interface to create a Rack
# response.
#
# It allows setting of headers and cookies, and provides useful
# defaults (an OK response with empty headers and body).
#
# You can use Response#write to iteratively generate your response,
# but note that this is buffered by Rack::Response until you call
# +finish+.  +finish+ however can take a block inside which calls to
# +write+ are synchronous with the Rack response.
#
# Your application's +call+ should end returning Response#finish.
#
# source://rack//lib/rack/response.rb#18
class Rack::Response
  include ::Rack::Response::Helpers

  # Initialize the response object with the specified body, status
  # and headers.
  #
  # HTTP protocol RFCs.
  # conform to the HTTP protocol RFCs.
  #
  # Providing a body which responds to #to_str is legacy behaviour.
  #
  # @param body [nil, #each, #to_str] the response body.
  # @param status [Integer] the integer status as defined by the
  # @param headers [#each] a list of key-value header pairs which
  # @return [Response] a new instance of Response
  # @yield [_self]
  # @yieldparam _self [Rack::Response] the object that the method was called on
  #
  # source://rack//lib/rack/response.rb#42
  def initialize(body = T.unsafe(nil), status = T.unsafe(nil), headers = T.unsafe(nil)); end

  # source://rack//lib/rack/response.rb#127
  def [](key); end

  # source://rack//lib/rack/response.rb#128
  def []=(key, v); end

  # Returns the value of attribute body.
  #
  # source://rack//lib/rack/response.rb#26
  def body; end

  # Sets the attribute body
  #
  # @param value the value to set the attribute body to.
  #
  # source://rack//lib/rack/response.rb#26
  def body=(_arg0); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#73
  def chunked?; end

  # source://rack//lib/rack/response.rb#118
  def close; end

  # source://rack//lib/rack/response.rb#129
  def delete_header(key); end

  # source://rack//lib/rack/response.rb#98
  def each(&callback); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#122
  def empty?; end

  # Generate a response array consistent with the requirements of the SPEC.
  # which is suitable to be returned from the middleware `#call(env)` method.
  #
  # @return [Array] a 3-tuple suitable of `[status, headers, body]`
  #
  # source://rack//lib/rack/response.rb#80
  def finish(&block); end

  # source://rack//lib/rack/response.rb#127
  def get_header(key); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#126
  def has_header?(key); end

  # Returns the value of attribute headers.
  #
  # @deprecated Use {#headers} instead.
  #
  # source://rack//lib/rack/response.rb#27
  def header; end

  # Returns the value of attribute headers.
  #
  # source://rack//lib/rack/response.rb#27
  def headers; end

  # Returns the value of attribute length.
  #
  # source://rack//lib/rack/response.rb#26
  def length; end

  # Sets the attribute length
  #
  # @param value the value to set the attribute length to.
  #
  # source://rack//lib/rack/response.rb#26
  def length=(_arg0); end

  # source://rack//lib/rack/response.rb#68
  def redirect(target, status = T.unsafe(nil)); end

  # source://rack//lib/rack/response.rb#128
  def set_header(key, v); end

  # Returns the value of attribute status.
  #
  # source://rack//lib/rack/response.rb#26
  def status; end

  # Sets the attribute status
  #
  # @param value the value to set the attribute status to.
  #
  # source://rack//lib/rack/response.rb#26
  def status=(_arg0); end

  # Generate a response array consistent with the requirements of the SPEC.
  # which is suitable to be returned from the middleware `#call(env)` method.
  # For *response
  #
  # @return [Array] a 3-tuple suitable of `[status, headers, body]`
  #
  # source://rack//lib/rack/response.rb#80
  def to_a(&block); end

  # Append to body and update Content-Length.
  #
  # NOTE: Do not mix #write and direct #body access!
  #
  # source://rack//lib/rack/response.rb#112
  def write(chunk); end

  class << self
    # source://rack//lib/rack/response.rb#19
    def [](status, headers, body); end
  end
end

# source://rack//lib/rack/response.rb#23
Rack::Response::CHUNKED = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/response.rb#134
module Rack::Response::Helpers
  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#145
  def accepted?; end

  # Add a header that may have multiple values.
  #
  # Example:
  #   response.add_header 'Vary', 'Accept-Encoding'
  #   response.add_header 'Vary', 'Cookie'
  #
  #   assert_equal 'Accept-Encoding,Cookie', response.get_header('Vary')
  #
  # http://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2
  #
  # source://rack//lib/rack/response.rb#171
  def add_header(key, v); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#148
  def bad_request?; end

  # Specify that the content should be cached.
  #
  # @option directive
  # @param duration [Integer] The number of seconds until the cache expires.
  # @param directive [Hash] a customizable set of options
  #
  # source://rack//lib/rack/response.rb#246
  def cache!(duration = T.unsafe(nil), directive: T.unsafe(nil)); end

  # source://rack//lib/rack/response.rb#229
  def cache_control; end

  # source://rack//lib/rack/response.rb#233
  def cache_control=(v); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#140
  def client_error?; end

  # source://rack//lib/rack/response.rb#199
  def content_length; end

  # Get the content type of the response.
  #
  # source://rack//lib/rack/response.rb#182
  def content_type; end

  # Set the content type of the response.
  #
  # source://rack//lib/rack/response.rb#187
  def content_type=(content_type); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#144
  def created?; end

  # source://rack//lib/rack/response.rb#217
  def delete_cookie(key, value = T.unsafe(nil)); end

  # Specifies that the content shouldn't be cached. Overrides `cache!` if already called.
  #
  # source://rack//lib/rack/response.rb#238
  def do_not_cache!; end

  # source://rack//lib/rack/response.rb#253
  def etag; end

  # source://rack//lib/rack/response.rb#257
  def etag=(v); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#150
  def forbidden?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#158
  def include?(header); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#137
  def informational?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#135
  def invalid?; end

  # source://rack//lib/rack/response.rb#204
  def location; end

  # source://rack//lib/rack/response.rb#208
  def location=(location); end

  # source://rack//lib/rack/response.rb#191
  def media_type; end

  # source://rack//lib/rack/response.rb#195
  def media_type_params; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#152
  def method_not_allowed?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#147
  def moved_permanently?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#146
  def no_content?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#151
  def not_found?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#143
  def ok?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#153
  def precondition_failed?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#156
  def redirect?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#139
  def redirection?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#141
  def server_error?; end

  # source://rack//lib/rack/response.rb#212
  def set_cookie(key, value); end

  # source://rack//lib/rack/response.rb#221
  def set_cookie_header; end

  # source://rack//lib/rack/response.rb#225
  def set_cookie_header=(v); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#138
  def successful?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#149
  def unauthorized?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#154
  def unprocessable?; end

  protected

  # source://rack//lib/rack/response.rb#287
  def append(chunk); end

  # source://rack//lib/rack/response.rb#263
  def buffered_body!; end
end

# source://rack//lib/rack/response.rb#301
class Rack::Response::Raw
  include ::Rack::Response::Helpers

  # @return [Raw] a new instance of Raw
  #
  # source://rack//lib/rack/response.rb#307
  def initialize(status, headers); end

  # source://rack//lib/rack/response.rb#315
  def delete_header(key); end

  # source://rack//lib/rack/response.rb#313
  def get_header(key); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/response.rb#312
  def has_header?(key); end

  # Returns the value of attribute headers.
  #
  # source://rack//lib/rack/response.rb#304
  def headers; end

  # source://rack//lib/rack/response.rb#314
  def set_header(key, v); end

  # Returns the value of attribute status.
  #
  # source://rack//lib/rack/response.rb#305
  def status; end

  # Sets the attribute status
  #
  # @param value the value to set the attribute status to.
  #
  # source://rack//lib/rack/response.rb#305
  def status=(_arg0); end
end

# source://rack//lib/rack/response.rb#24
Rack::Response::STATUS_WITH_NO_ENTITY_BODY = T.let(T.unsafe(nil), Hash)

# Class which can make any IO object rewindable, including non-rewindable ones. It does
# this by buffering the data into a tempfile, which is rewindable.
#
# rack.input is required to be rewindable, so if your input stream IO is non-rewindable
# by nature (e.g. a pipe or a socket) then you can wrap it in an object of this class
# to easily make it rewindable.
#
# Don't forget to call #close when you're done. This frees up temporary resources that
# RewindableInput uses, though it does *not* close the original IO object.
#
# source://rack//lib/rack/rewindable_input.rb#16
class Rack::RewindableInput
  # @return [RewindableInput] a new instance of RewindableInput
  #
  # source://rack//lib/rack/rewindable_input.rb#17
  def initialize(io); end

  # Closes this RewindableInput object without closing the originally
  # wrapped IO object. Cleans up any temporary resources that this RewindableInput
  # has created.
  #
  # This method may be called multiple times. It does nothing on subsequent calls.
  #
  # source://rack//lib/rack/rewindable_input.rb#48
  def close; end

  # source://rack//lib/rack/rewindable_input.rb#33
  def each(&block); end

  # source://rack//lib/rack/rewindable_input.rb#23
  def gets; end

  # source://rack//lib/rack/rewindable_input.rb#28
  def read(*args); end

  # source://rack//lib/rack/rewindable_input.rb#38
  def rewind; end

  private

  # @return [Boolean]
  #
  # source://rack//lib/rack/rewindable_input.rb#90
  def filesystem_has_posix_semantics?; end

  # source://rack//lib/rack/rewindable_input.rb#61
  def make_rewindable; end
end

# Sets an "X-Runtime" response header, indicating the response
# time of the request, in seconds
#
# You can put it right before the application to see the processing
# time, or before all the other middlewares to include time for them,
# too.
#
# source://rack//lib/rack/runtime.rb#10
class Rack::Runtime
  # @return [Runtime] a new instance of Runtime
  #
  # source://rack//lib/rack/runtime.rb#14
  def initialize(app, name = T.unsafe(nil)); end

  # source://rack//lib/rack/runtime.rb#20
  def call(env); end
end

# source://rack//lib/rack/runtime.rb#11
Rack::Runtime::FORMAT_STRING = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/runtime.rb#12
Rack::Runtime::HEADER_NAME = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#24
Rack::SCRIPT_NAME = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#27
Rack::SERVER_NAME = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#28
Rack::SERVER_PORT = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#26
Rack::SERVER_PROTOCOL = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#33
Rack::SET_COOKIE = T.let(T.unsafe(nil), String)

# = Sendfile
#
# The Sendfile middleware intercepts responses whose body is being
# served from a file and replaces it with a server specific X-Sendfile
# header. The web server is then responsible for writing the file contents
# to the client. This can dramatically reduce the amount of work required
# by the Ruby backend and takes advantage of the web server's optimized file
# delivery code.
#
# In order to take advantage of this middleware, the response body must
# respond to +to_path+ and the request must include an X-Sendfile-Type
# header. Rack::Files and other components implement +to_path+ so there's
# rarely anything you need to do in your application. The X-Sendfile-Type
# header is typically set in your web servers configuration. The following
# sections attempt to document
#
# === Nginx
#
# Nginx supports the X-Accel-Redirect header. This is similar to X-Sendfile
# but requires parts of the filesystem to be mapped into a private URL
# hierarchy.
#
# The following example shows the Nginx configuration required to create
# a private "/files/" area, enable X-Accel-Redirect, and pass the special
# X-Sendfile-Type and X-Accel-Mapping headers to the backend:
#
#   location ~ /files/(.*) {
#     internal;
#     alias /var/www/$1;
#   }
#
#   location / {
#     proxy_redirect     off;
#
#     proxy_set_header   Host                $host;
#     proxy_set_header   X-Real-IP           $remote_addr;
#     proxy_set_header   X-Forwarded-For     $proxy_add_x_forwarded_for;
#
#     proxy_set_header   X-Sendfile-Type     X-Accel-Redirect;
#     proxy_set_header   X-Accel-Mapping     /var/www/=/files/;
#
#     proxy_pass         http://127.0.0.1:8080/;
#   }
#
# Note that the X-Sendfile-Type header must be set exactly as shown above.
# The X-Accel-Mapping header should specify the location on the file system,
# followed by an equals sign (=), followed name of the private URL pattern
# that it maps to. The middleware performs a simple substitution on the
# resulting path.
#
# See Also: https://www.nginx.com/resources/wiki/start/topics/examples/xsendfile
#
# === lighttpd
#
# Lighttpd has supported some variation of the X-Sendfile header for some
# time, although only recent version support X-Sendfile in a reverse proxy
# configuration.
#
#   $HTTP["host"] == "example.com" {
#      proxy-core.protocol = "http"
#      proxy-core.balancer = "round-robin"
#      proxy-core.backends = (
#        "127.0.0.1:8000",
#        "127.0.0.1:8001",
#        ...
#      )
#
#      proxy-core.allow-x-sendfile = "enable"
#      proxy-core.rewrite-request = (
#        "X-Sendfile-Type" => (".*" => "X-Sendfile")
#      )
#    }
#
# See Also: http://redmine.lighttpd.net/wiki/lighttpd/Docs:ModProxyCore
#
# === Apache
#
# X-Sendfile is supported under Apache 2.x using a separate module:
#
# https://tn123.org/mod_xsendfile/
#
# Once the module is compiled and installed, you can enable it using
# XSendFile config directive:
#
#   RequestHeader Set X-Sendfile-Type X-Sendfile
#   ProxyPassReverse / http://localhost:8001/
#   XSendFile on
#
# === Mapping parameter
#
# The third parameter allows for an overriding extension of the
# X-Accel-Mapping header. Mappings should be provided in tuples of internal to
# external. The internal values may contain regular expression syntax, they
# will be matched with case indifference.
#
# source://rack//lib/rack/sendfile.rb#100
class Rack::Sendfile
  # @return [Sendfile] a new instance of Sendfile
  #
  # source://rack//lib/rack/sendfile.rb#101
  def initialize(app, variation = T.unsafe(nil), mappings = T.unsafe(nil)); end

  # source://rack//lib/rack/sendfile.rb#109
  def call(env); end

  private

  # source://rack//lib/rack/sendfile.rb#149
  def map_accel_path(env, path); end

  # source://rack//lib/rack/sendfile.rb#143
  def variation(env); end
end

# source://rack//lib/rack/server.rb#8
class Rack::Server
  # Options may include:
  # * :app
  #     a rack application to run (overrides :config and :builder)
  # * :builder
  #     a string to evaluate a Rack::Builder from
  # * :config
  #     a rackup configuration file path to load (.ru)
  # * :environment
  #     this selects the middleware that will be wrapped around
  #     your application. Default options available are:
  #       - development: CommonLogger, ShowExceptions, and Lint
  #       - deployment: CommonLogger
  #       - none: no extra middleware
  #     note: when the server is a cgi server, CommonLogger is not included.
  # * :server
  #     choose a specific Rack::Handler, e.g. cgi, fcgi, webrick
  # * :daemonize
  #     if true, the server will daemonize itself (fork, detach, etc)
  # * :pid
  #     path to write a pid file after daemonize
  # * :Host
  #     the host address to bind to (used by supporting Rack::Handler)
  # * :Port
  #     the port to bind to (used by supporting Rack::Handler)
  # * :AccessLog
  #     webrick access log options (or supporting Rack::Handler)
  # * :debug
  #     turn on debug output ($DEBUG = true)
  # * :warn
  #     turn on warnings ($-w = true)
  # * :include
  #     add given paths to $LOAD_PATH
  # * :require
  #     require the given libraries
  #
  # Additional options for profiling app initialization include:
  # * :heapfile
  #     location for ObjectSpace.dump_all to write the output to
  # * :profile_file
  #     location for CPU/Memory (StackProf) profile output (defaults to a tempfile)
  # * :profile_mode
  #     StackProf profile mode (cpu|wall|object)
  #
  # @return [Server] a new instance of Server
  #
  # source://rack//lib/rack/server.rb#215
  def initialize(options = T.unsafe(nil)); end

  # source://rack//lib/rack/server.rb#248
  def app; end

  # source://rack//lib/rack/server.rb#234
  def default_options; end

  # source://rack//lib/rack/server.rb#282
  def middleware; end

  # source://rack//lib/rack/server.rb#229
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://rack//lib/rack/server.rb#171
  def options=(_arg0); end

  # source://rack//lib/rack/server.rb#330
  def server; end

  # source://rack//lib/rack/server.rb#286
  def start(&block); end

  private

  # source://rack//lib/rack/server.rb#411
  def build_app(app); end

  # source://rack//lib/rack/server.rb#344
  def build_app_and_options_from_config; end

  # source://rack//lib/rack/server.rb#392
  def build_app_from_string; end

  # source://rack//lib/rack/server.rb#440
  def check_pid!; end

  # source://rack//lib/rack/server.rb#425
  def daemonize_app; end

  # source://rack//lib/rack/server.rb#354
  def handle_profiling(heapfile, profile_mode, filename); end

  # source://rack//lib/rack/server.rb#382
  def make_profile_name(filename); end

  # source://rack//lib/rack/server.rb#407
  def opt_parser; end

  # source://rack//lib/rack/server.rb#396
  def parse_options(args); end

  # source://rack//lib/rack/server.rb#450
  def pidfile_process_status; end

  # source://rack//lib/rack/server.rb#421
  def wrapped_app; end

  # source://rack//lib/rack/server.rb#432
  def write_pid; end

  class << self
    # source://rack//lib/rack/server.rb#259
    def default_middleware_by_environment; end

    # source://rack//lib/rack/server.rb#253
    def logging_middleware; end

    # source://rack//lib/rack/server.rb#277
    def middleware; end

    # Start a new rack server (like running rackup). This will parse ARGV and
    # provide standard ARGV rackup options, defaulting to load 'config.ru'.
    #
    # Providing an options hash will prevent ARGV parsing and will not include
    # any default options.
    #
    # This method can be used to very easily launch a CGI application, for
    # example:
    #
    #  Rack::Server.start(
    #    :app => lambda do |e|
    #      [200, {'Content-Type' => 'text/html'}, ['hello world']]
    #    end,
    #    :server => 'cgi'
    #  )
    #
    # Further options available here are documented on Rack::Server#initialize
    #
    # source://rack//lib/rack/server.rb#167
    def start(options = T.unsafe(nil)); end
  end
end

# source://rack//lib/rack/server.rb#11
class Rack::Server::Options
  # source://rack//lib/rack/server.rb#127
  def handler_opts(options); end

  # source://rack//lib/rack/server.rb#12
  def parse!(args); end
end

# source://rack//lib/rack.rb#136
module Rack::Session; end

# source://rack//lib/rack/session/abstract/id.rb#41
module Rack::Session::Abstract; end

# source://rack//lib/rack/session/abstract/id.rb#487
class Rack::Session::Abstract::ID < ::Rack::Session::Abstract::Persisted
  # All thread safety and session destroy procedures should occur here.
  # Should return a new session id or nil if options[:drop]
  #
  # source://rack//lib/rack/session/abstract/id.rb#517
  def delete_session(req, sid, options); end

  # All thread safety and session retrieval procedures should occur here.
  # Should return [session_id, session].
  # If nil is provided as the session id, generation of a new valid id
  # should occur within.
  #
  # source://rack//lib/rack/session/abstract/id.rb#502
  def find_session(req, sid); end

  # All thread safety and session storage procedures should occur here.
  # Must return the session id if the session was saved successfully, or
  # false if the session could not be saved.
  #
  # source://rack//lib/rack/session/abstract/id.rb#510
  def write_session(req, sid, session, options); end

  class << self
    # @private
    #
    # source://rack//lib/rack/session/abstract/id.rb#488
    def inherited(klass); end
  end
end

# ID sets up a basic framework for implementing an id based sessioning
# service. Cookies sent to the client for maintaining sessions will only
# contain an id reference. Only #find_session, #write_session and
# #delete_session are required to be overwritten.
#
# All parameters are optional.
# * :key determines the name of the cookie, by default it is
#   'rack.session'
# * :path, :domain, :expire_after, :secure, and :httponly set the related
#   cookie options as by Rack::Response#set_cookie
# * :skip will not a set a cookie in the response nor update the session state
# * :defer will not set a cookie in the response but still update the session
#   state if it is used with a backend
# * :renew (implementation dependent) will prompt the generation of a new
#   session id, and migration of data to be referenced at the new id. If
#   :defer is set, it will be overridden and the cookie will be set.
# * :sidbits sets the number of bits in length that a generated session
#   id will be.
#
# These options can be set on a per request basis, at the location of
# <tt>env['rack.session.options']</tt>. Additionally the id of the
# session can be found within the options hash at the key :id. It is
# highly not recommended to change its value.
#
# Is Rack::Utils::Context compatible.
#
# Not included by default; you must require 'rack/session/abstract/id'
# to use.
#
# source://rack//lib/rack/session/abstract/id.rb#233
class Rack::Session::Abstract::Persisted
  # @return [Persisted] a new instance of Persisted
  #
  # source://rack//lib/rack/session/abstract/id.rb#250
  def initialize(app, options = T.unsafe(nil)); end

  # source://rack//lib/rack/session/abstract/id.rb#259
  def call(env); end

  # Acquires the session from the environment and the session id from
  # the session options and passes them to #write_session. If successful
  # and the :defer option is not true, a cookie will be added to the
  # response with the session's id.
  #
  # source://rack//lib/rack/session/abstract/id.rb#373
  def commit_session(req, res); end

  # source://rack//lib/rack/session/abstract/id.rb#263
  def context(env, app = T.unsafe(nil)); end

  # Returns the value of attribute default_options.
  #
  # source://rack//lib/rack/session/abstract/id.rb#248
  def default_options; end

  # Returns the value of attribute key.
  #
  # source://rack//lib/rack/session/abstract/id.rb#248
  def key; end

  # Returns the value of attribute sid_secure.
  #
  # source://rack//lib/rack/session/abstract/id.rb#248
  def sid_secure; end

  private

  # Session should be committed if it was loaded, any of specific options like :renew, :drop
  # or :expire_after was given and the security permissions match. Skips if skip is given.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#342
  def commit_session?(req, session, options); end

  # source://rack//lib/rack/session/abstract/id.rb#408
  def cookie_value(data); end

  # Returns the current session id from the SessionHash.
  #
  # source://rack//lib/rack/session/abstract/id.rb#328
  def current_session_id(req); end

  # All thread safety and session destroy procedures should occur here.
  # Should return a new session id or nil if options[:drop]
  #
  # source://rack//lib/rack/session/abstract/id.rb#448
  def delete_session(req, sid, options); end

  # Extract session id from request object.
  #
  # source://rack//lib/rack/session/abstract/id.rb#320
  def extract_session_id(request); end

  # All thread safety and session retrieval procedures should occur here.
  # Should return [session_id, session].
  # If nil is provided as the session id, generation of a new valid id
  # should occur within.
  #
  # source://rack//lib/rack/session/abstract/id.rb#433
  def find_session(env, sid); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#359
  def force_options?(options); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#355
  def forced_session_update?(session, options); end

  # Generate a new session id using Ruby #rand.  The size of the
  # session id is controlled by the :sidbits option.
  # Monkey patch this to use custom methods for session id generation.
  #
  # source://rack//lib/rack/session/abstract/id.rb#288
  def generate_sid(secure = T.unsafe(nil)); end

  # source://rack//lib/rack/session/abstract/id.rb#278
  def initialize_sid; end

  # Extracts the session id from provided cookies and passes it and the
  # environment to #find_session.
  #
  # source://rack//lib/rack/session/abstract/id.rb#312
  def load_session(req); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#351
  def loaded_session?(session); end

  # source://rack//lib/rack/session/abstract/id.rb#274
  def make_request(env); end

  # Sets the lazy session at 'rack.session' and places options and session
  # metadata into 'rack.session.options'.
  #
  # source://rack//lib/rack/session/abstract/id.rb#301
  def prepare_session(req); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#363
  def security_matches?(request, options); end

  # Allow subclasses to prepare_session for different Session classes
  #
  # source://rack//lib/rack/session/abstract/id.rb#424
  def session_class; end

  # Check if the session exists or not.
  #
  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#334
  def session_exists?(req); end

  # Sets the cookie back to the client with session id. We skip the cookie
  # setting if the value didn't change (sid is the same) or expires was given.
  #
  # source://rack//lib/rack/session/abstract/id.rb#415
  def set_cookie(request, res, cookie); end

  # All thread safety and session storage procedures should occur here.
  # Must return the session id if the session was saved successfully, or
  # false if the session could not be saved.
  #
  # source://rack//lib/rack/session/abstract/id.rb#441
  def write_session(req, sid, session, options); end
end

# source://rack//lib/rack/session/abstract/id.rb#234
Rack::Session::Abstract::Persisted::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/session/abstract/id.rb#453
class Rack::Session::Abstract::PersistedSecure < ::Rack::Session::Abstract::Persisted
  # source://rack//lib/rack/session/abstract/id.rb#471
  def extract_session_id(*_arg0); end

  # source://rack//lib/rack/session/abstract/id.rb#465
  def generate_sid(*_arg0); end

  private

  # source://rack//lib/rack/session/abstract/id.rb#482
  def cookie_value(data); end

  # source://rack//lib/rack/session/abstract/id.rb#478
  def session_class; end
end

# source://rack//lib/rack/session/abstract/id.rb#454
class Rack::Session::Abstract::PersistedSecure::SecureSessionHash < ::Rack::Session::Abstract::SessionHash
  # source://rack//lib/rack/session/abstract/id.rb#455
  def [](key); end
end

# SessionHash is responsible to lazily load the session from store.
#
# source://rack//lib/rack/session/abstract/id.rb#44
class Rack::Session::Abstract::SessionHash
  include ::Enumerable

  # @return [SessionHash] a new instance of SessionHash
  #
  # source://rack//lib/rack/session/abstract/id.rb#62
  def initialize(store, req); end

  # source://rack//lib/rack/session/abstract/id.rb#82
  def [](key); end

  # source://rack//lib/rack/session/abstract/id.rb#108
  def []=(key, value); end

  # source://rack//lib/rack/session/abstract/id.rb#114
  def clear; end

  # source://rack//lib/rack/session/abstract/id.rb#140
  def delete(key); end

  # source://rack//lib/rack/session/abstract/id.rb#119
  def destroy; end

  # source://rack//lib/rack/session/abstract/id.rb#87
  def dig(key, *keys); end

  # source://rack//lib/rack/session/abstract/id.rb#77
  def each(&block); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#163
  def empty?; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#153
  def exists?; end

  # source://rack//lib/rack/session/abstract/id.rb#92
  def fetch(key, default = T.unsafe(nil), &block); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#101
  def has_key?(key); end

  # source://rack//lib/rack/session/abstract/id.rb#68
  def id; end

  # Sets the attribute id
  #
  # @param value the value to set the attribute id to.
  #
  # source://rack//lib/rack/session/abstract/id.rb#46
  def id=(_arg0); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#101
  def include?(key); end

  # source://rack//lib/rack/session/abstract/id.rb#145
  def inspect; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#101
  def key?(key); end

  # source://rack//lib/rack/session/abstract/id.rb#168
  def keys; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#159
  def loaded?; end

  # source://rack//lib/rack/session/abstract/id.rb#129
  def merge!(hash); end

  # source://rack//lib/rack/session/abstract/id.rb#73
  def options; end

  # source://rack//lib/rack/session/abstract/id.rb#135
  def replace(hash); end

  # source://rack//lib/rack/session/abstract/id.rb#108
  def store(key, value); end

  # source://rack//lib/rack/session/abstract/id.rb#124
  def to_hash; end

  # source://rack//lib/rack/session/abstract/id.rb#129
  def update(hash); end

  # source://rack//lib/rack/session/abstract/id.rb#173
  def values; end

  private

  # source://rack//lib/rack/session/abstract/id.rb#188
  def load!; end

  # source://rack//lib/rack/session/abstract/id.rb#180
  def load_for_read!; end

  # source://rack//lib/rack/session/abstract/id.rb#184
  def load_for_write!; end

  # source://rack//lib/rack/session/abstract/id.rb#194
  def stringify_keys(other); end

  class << self
    # source://rack//lib/rack/session/abstract/id.rb#50
    def find(req); end

    # source://rack//lib/rack/session/abstract/id.rb#54
    def set(req, session); end

    # source://rack//lib/rack/session/abstract/id.rb#58
    def set_options(req, options); end
  end
end

# source://rack//lib/rack/session/abstract/id.rb#48
Rack::Session::Abstract::SessionHash::Unspecified = T.let(T.unsafe(nil), Object)

# Rack::Session::Cookie provides simple cookie based session management.
# By default, the session is a Ruby Hash stored as base64 encoded marshalled
# data set to :key (default: rack.session).  The object that encodes the
# session data is configurable and must respond to +encode+ and +decode+.
# Both methods must take a string and return a string.
#
# When the secret key is set, cookie data is checked for data integrity.
# The old secret key is also accepted and allows graceful secret rotation.
#
# Example:
#
#     use Rack::Session::Cookie, :key => 'rack.session',
#                                :domain => 'foo.com',
#                                :path => '/',
#                                :expire_after => 2592000,
#                                :secret => 'change_me',
#                                :old_secret => 'also_change_me'
#
#     All parameters are optional.
#
#
#   Rack::Session::Cookie.new(application, {
#     :coder => Rack::Session::Cookie::Identity.new
#   })
#
#
#   Rack::Session::Cookie.new(application, {
#     :coder => Class.new {
#       def encode(str); str.reverse; end
#       def decode(str); str.reverse; end
#     }.new
#   })
#
# source://rack//lib/rack/session/cookie.rb#50
class Rack::Session::Cookie < ::Rack::Session::Abstract::PersistedSecure
  # @return [Cookie] a new instance of Cookie
  #
  # source://rack//lib/rack/session/cookie.rb#108
  def initialize(app, options = T.unsafe(nil)); end

  # Returns the value of attribute coder.
  #
  # source://rack//lib/rack/session/cookie.rb#106
  def coder; end

  private

  # source://rack//lib/rack/session/cookie.rb#181
  def delete_session(req, session_id, options); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/cookie.rb#186
  def digest_match?(data, digest); end

  # source://rack//lib/rack/session/cookie.rb#133
  def extract_session_id(request); end

  # source://rack//lib/rack/session/cookie.rb#127
  def find_session(req, sid); end

  # source://rack//lib/rack/session/cookie.rb#193
  def generate_hmac(data, secret); end

  # source://rack//lib/rack/session/cookie.rb#150
  def persistent_session_id!(data, sid = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/cookie.rb#197
  def secure?(options); end

  # source://rack//lib/rack/session/cookie.rb#137
  def unpacked_cookie_data(request); end

  # source://rack//lib/rack/session/cookie.rb#165
  def write_session(req, session_id, session, options); end
end

# Encode session cookies as Base64
#
# source://rack//lib/rack/session/cookie.rb#52
class Rack::Session::Cookie::Base64
  # source://rack//lib/rack/session/cookie.rb#57
  def decode(str); end

  # source://rack//lib/rack/session/cookie.rb#53
  def encode(str); end
end

# N.B. Unlike other encoding methods, the contained objects must be a
# valid JSON composite type, either a Hash or an Array.
#
# source://rack//lib/rack/session/cookie.rb#75
class Rack::Session::Cookie::Base64::JSON < ::Rack::Session::Cookie::Base64
  # source://rack//lib/rack/session/cookie.rb#80
  def decode(str); end

  # source://rack//lib/rack/session/cookie.rb#76
  def encode(obj); end
end

# Encode session cookies as Marshaled Base64 data
#
# source://rack//lib/rack/session/cookie.rb#62
class Rack::Session::Cookie::Base64::Marshal < ::Rack::Session::Cookie::Base64
  # source://rack//lib/rack/session/cookie.rb#67
  def decode(str); end

  # source://rack//lib/rack/session/cookie.rb#63
  def encode(str); end
end

# source://rack//lib/rack/session/cookie.rb#86
class Rack::Session::Cookie::Base64::ZipJSON < ::Rack::Session::Cookie::Base64
  # source://rack//lib/rack/session/cookie.rb#91
  def decode(str); end

  # source://rack//lib/rack/session/cookie.rb#87
  def encode(obj); end
end

# Use no encoding for session cookies
#
# source://rack//lib/rack/session/cookie.rb#101
class Rack::Session::Cookie::Identity
  # source://rack//lib/rack/session/cookie.rb#103
  def decode(str); end

  # source://rack//lib/rack/session/cookie.rb#102
  def encode(str); end
end

# source://rack//lib/rack/session/cookie.rb#156
class Rack::Session::Cookie::SessionId
  # @return [SessionId] a new instance of SessionId
  #
  # source://rack//lib/rack/session/cookie.rb#159
  def initialize(session_id, cookie_value); end

  # Returns the value of attribute cookie_value.
  #
  # source://rack//lib/rack/session/cookie.rb#157
  def cookie_value; end
end

# Rack::Session::Pool provides simple cookie based session management.
# Session data is stored in a hash held by @pool.
# In the context of a multithreaded environment, sessions being
# committed to the pool is done in a merging manner.
#
# The :drop option is available in rack.session.options if you wish to
# explicitly remove the session from the session cache.
#
# Example:
#   myapp = MyRackApp.new
#   sessioned = Rack::Session::Pool.new(myapp,
#     :domain => 'foo.com',
#     :expire_after => 2592000
#   )
#   Rack::Handler::WEBrick.run sessioned
#
# source://rack//lib/rack/session/pool.rb#29
class Rack::Session::Pool < ::Rack::Session::Abstract::PersistedSecure
  # @return [Pool] a new instance of Pool
  #
  # source://rack//lib/rack/session/pool.rb#33
  def initialize(app, options = T.unsafe(nil)); end

  # source://rack//lib/rack/session/pool.rb#63
  def delete_session(req, session_id, options); end

  # source://rack//lib/rack/session/pool.rb#46
  def find_session(req, sid); end

  # source://rack//lib/rack/session/pool.rb#39
  def generate_sid; end

  # Returns the value of attribute mutex.
  #
  # source://rack//lib/rack/session/pool.rb#30
  def mutex; end

  # Returns the value of attribute pool.
  #
  # source://rack//lib/rack/session/pool.rb#30
  def pool; end

  # source://rack//lib/rack/session/pool.rb#71
  def with_lock(req); end

  # source://rack//lib/rack/session/pool.rb#56
  def write_session(req, session_id, new_session, options); end

  private

  # source://rack//lib/rack/session/pool.rb#80
  def get_session_with_fallback(sid); end
end

# source://rack//lib/rack/session/pool.rb#31
Rack::Session::Pool::DEFAULT_OPTIONS = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/session/abstract/id.rb#15
class Rack::Session::SessionId
  # @return [SessionId] a new instance of SessionId
  #
  # source://rack//lib/rack/session/abstract/id.rb#20
  def initialize(public_id); end

  # Returns the value of attribute public_id.
  #
  # source://rack//lib/rack/session/abstract/id.rb#18
  def cookie_value; end

  # @return [Boolean]
  #
  # source://rack//lib/rack/session/abstract/id.rb#31
  def empty?; end

  # source://rack//lib/rack/session/abstract/id.rb#32
  def inspect; end

  # source://rack//lib/rack/session/abstract/id.rb#24
  def private_id; end

  # Returns the value of attribute public_id.
  #
  # source://rack//lib/rack/session/abstract/id.rb#18
  def public_id; end

  # Returns the value of attribute public_id.
  #
  # source://rack//lib/rack/session/abstract/id.rb#18
  def to_s; end

  private

  # source://rack//lib/rack/session/abstract/id.rb#36
  def hash_sid(sid); end
end

# source://rack//lib/rack/session/abstract/id.rb#16
Rack::Session::SessionId::ID_VERSION = T.let(T.unsafe(nil), Integer)

# Rack::ShowExceptions catches all exceptions raised from the app it
# wraps.  It shows a useful backtrace with the sourcefile and
# clickable context, the whole Rack environment and the request
# data.
#
# Be careful when you use this on public-facing sites as it could
# reveal information helpful to attackers.
#
# source://rack//lib/rack/show_exceptions.rb#15
class Rack::ShowExceptions
  # @return [ShowExceptions] a new instance of ShowExceptions
  #
  # source://rack//lib/rack/show_exceptions.rb#18
  def initialize(app); end

  # source://rack//lib/rack/show_exceptions.rb#22
  def call(env); end

  # source://rack//lib/rack/show_exceptions.rb#57
  def dump_exception(exception); end

  # source://rack//lib/rack/show_exceptions.rb#103
  def h(obj); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/show_exceptions.rb#48
  def prefers_plaintext?(env); end

  # source://rack//lib/rack/show_exceptions.rb#63
  def pretty(env, exception); end

  # source://rack//lib/rack/show_exceptions.rb#99
  def template; end

  private

  # @return [Boolean]
  #
  # source://rack//lib/rack/show_exceptions.rb#52
  def accepts_html?(env); end
end

# source://rack//lib/rack/show_exceptions.rb#16
Rack::ShowExceptions::CONTEXT = T.let(T.unsafe(nil), Integer)

# source://rack//lib/rack/show_exceptions.rb#118
Rack::ShowExceptions::TEMPLATE = T.let(T.unsafe(nil), ERB)

# Rack::ShowStatus catches all empty responses and replaces them
# with a site explaining the error.
#
# Additional details can be put into <tt>rack.showstatus.detail</tt>
# and will be shown as HTML.  If such details exist, the error page
# is always rendered, even if the reply was not empty.
#
# source://rack//lib/rack/show_status.rb#13
class Rack::ShowStatus
  # @return [ShowStatus] a new instance of ShowStatus
  #
  # source://rack//lib/rack/show_status.rb#14
  def initialize(app); end

  # source://rack//lib/rack/show_status.rb#19
  def call(env); end

  # source://rack//lib/rack/show_status.rb#44
  def h(obj); end
end

# source://rack//lib/rack/show_status.rb#59
Rack::ShowStatus::TEMPLATE = T.let(T.unsafe(nil), String)

# The Rack::Static middleware intercepts requests for static files
# (javascript files, images, stylesheets, etc) based on the url prefixes or
# route mappings passed in the options, and serves them using a Rack::Files
# object. This allows a Rack stack to serve both static and dynamic content.
#
# Examples:
#
# Serve all requests beginning with /media from the "media" folder located
# in the current directory (ie media/*):
#
#     use Rack::Static, :urls => ["/media"]
#
# Same as previous, but instead of returning 404 for missing files under
# /media, call the next middleware:
#
#     use Rack::Static, :urls => ["/media"], :cascade => true
#
# Serve all requests beginning with /css or /images from the folder "public"
# in the current directory (ie public/css/* and public/images/*):
#
#     use Rack::Static, :urls => ["/css", "/images"], :root => "public"
#
# Serve all requests to / with "index.html" from the folder "public" in the
# current directory (ie public/index.html):
#
#     use Rack::Static, :urls => {"/" => 'index.html'}, :root => 'public'
#
# Serve all requests normally from the folder "public" in the current
# directory but uses index.html as default route for "/"
#
#     use Rack::Static, :urls => [""], :root => 'public', :index =>
#     'index.html'
#
# Set custom HTTP Headers for based on rules:
#
#     use Rack::Static, :root => 'public',
#         :header_rules => [
#           [rule, {header_field => content, header_field => content}],
#           [rule, {header_field => content}]
#         ]
#
#  Rules for selecting files:
#
#  1) All files
#     Provide the :all symbol
#     :all => Matches every file
#
#  2) Folders
#     Provide the folder path as a string
#     '/folder' or '/folder/subfolder' => Matches files in a certain folder
#
#  3) File Extensions
#     Provide the file extensions as an array
#     ['css', 'js'] or %w(css js) => Matches files ending in .css or .js
#
#  4) Regular Expressions / Regexp
#     Provide a regular expression
#     %r{\.(?:css|js)\z} => Matches files ending in .css or .js
#     /\.(?:eot|ttf|otf|woff2|woff|svg)\z/ => Matches files ending in
#       the most common web font formats (.eot, .ttf, .otf, .woff2, .woff, .svg)
#       Note: This Regexp is available as a shortcut, using the :fonts rule
#
#  5) Font Shortcut
#     Provide the :fonts symbol
#     :fonts => Uses the Regexp rule stated right above to match all common web font endings
#
#  Rule Ordering:
#    Rules are applied in the order that they are provided.
#    List rather general rules above special ones.
#
#  Complete example use case including HTTP header rules:
#
#     use Rack::Static, :root => 'public',
#         :header_rules => [
#           # Cache all static files in public caches (e.g. Rack::Cache)
#           #  as well as in the browser
#           [:all, {'Cache-Control' => 'public, max-age=31536000'}],
#
#           # Provide web fonts with cross-origin access-control-headers
#           #  Firefox requires this when serving assets using a Content Delivery Network
#           [:fonts, {'Access-Control-Allow-Origin' => '*'}]
#         ]
#
# source://rack//lib/rack/static.rb#88
class Rack::Static
  # @return [Static] a new instance of Static
  #
  # source://rack//lib/rack/static.rb#91
  def initialize(app, options = T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://rack//lib/rack/static.rb#107
  def add_index_root?(path); end

  # Convert HTTP header rules to HTTP headers
  #
  # source://rack//lib/rack/static.rb#166
  def applicable_rules(path); end

  # source://rack//lib/rack/static.rb#123
  def call(env); end

  # source://rack//lib/rack/static.rb#119
  def can_serve(path); end

  # source://rack//lib/rack/static.rb#111
  def overwrite_file_path(path); end

  # source://rack//lib/rack/static.rb#115
  def route_file(path); end
end

# source://rack//lib/rack.rb#48
Rack::TRACE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack.rb#34
Rack::TRANSFER_ENCODING = T.let(T.unsafe(nil), String)

# Middleware tracks and cleans Tempfiles created throughout a request (i.e. Rack::Multipart)
# Ideas/strategy based on posts by Eric Wong and Charles Oliver Nutter
# https://groups.google.com/forum/#!searchin/rack-devel/temp/rack-devel/brK8eh-MByw/sw61oJJCGRMJ
#
# source://rack//lib/rack/tempfile_reaper.rb#8
class Rack::TempfileReaper
  # @return [TempfileReaper] a new instance of TempfileReaper
  #
  # source://rack//lib/rack/tempfile_reaper.rb#9
  def initialize(app); end

  # source://rack//lib/rack/tempfile_reaper.rb#13
  def call(env); end
end

# source://rack//lib/rack.rb#47
Rack::UNLINK = T.let(T.unsafe(nil), String)

# Rack::URLMap takes a hash mapping urls or paths to apps, and
# dispatches accordingly.  Support for HTTP/1.1 host names exists if
# the URLs start with <tt>http://</tt> or <tt>https://</tt>.
#
# URLMap modifies the SCRIPT_NAME and PATH_INFO such that the part
# relevant for dispatch is in the SCRIPT_NAME, and the rest in the
# PATH_INFO.  This should be taken care of when you need to
# reconstruct the URL in order to create links.
#
# URLMap dispatches in such a way that the longest paths are tried
# first, since they are most specific.
#
# source://rack//lib/rack/urlmap.rb#18
class Rack::URLMap
  # @return [URLMap] a new instance of URLMap
  #
  # source://rack//lib/rack/urlmap.rb#19
  def initialize(map = T.unsafe(nil)); end

  # source://rack//lib/rack/urlmap.rb#46
  def call(env); end

  # source://rack//lib/rack/urlmap.rb#23
  def remap(map); end

  private

  # @return [Boolean]
  #
  # source://rack//lib/rack/urlmap.rb#85
  def casecmp?(v1, v2); end
end

# Rack::Utils contains a grab-bag of useful methods for writing web
# applications adopted from all kinds of Ruby libraries.
#
# source://rack//lib/rack/utils.rb#16
module Rack::Utils
  private

  # source://rack//lib/rack/utils.rb#237
  def add_cookie_to_header(header, key, value); end

  # Adds a cookie that will *remove* a cookie from the client.  Hence the
  # strange method name.
  #
  # source://rack//lib/rack/utils.rb#320
  def add_remove_cookie_to_header(header, key, value = T.unsafe(nil)); end

  # Return best accept value to use, based on the algorithm
  # in RFC 2616 Section 14.  If there are multiple best
  # matches (same specificity and quality), the value returned
  # is arbitrary.
  #
  # source://rack//lib/rack/utils.rb#159
  def best_q_match(q_value_header, available_mimes); end

  # source://rack//lib/rack/utils.rb#126
  def build_nested_query(value, prefix = T.unsafe(nil)); end

  # source://rack//lib/rack/utils.rb#116
  def build_query(params); end

  # Parses the "Range:" header, if present, into an array of Range objects.
  # Returns nil if the header is missing or syntactically invalid.
  # Returns an empty array if none of the ranges are satisfiable.
  #
  # source://rack//lib/rack/utils.rb#352
  def byte_ranges(env, size); end

  # source://rack//lib/rack/utils.rb#609
  def clean_path_info(path_info); end

  # :nocov:
  #
  # source://rack//lib/rack/utils.rb#97
  def clock_time; end

  # source://rack//lib/rack/utils.rb#313
  def delete_cookie_header!(header, key, value = T.unsafe(nil)); end

  # URI escapes. (CGI style space to +)
  #
  # source://rack//lib/rack/utils.rb#38
  def escape(s); end

  # Escape ampersands, brackets and quotes to their HTML/XML entities.
  #
  # source://rack//lib/rack/utils.rb#184
  def escape_html(string); end

  # Like URI escaping, but with %20 instead of +. Strictly speaking this is
  # true URI escaping.
  #
  # source://rack//lib/rack/utils.rb#44
  def escape_path(s); end

  # source://rack//lib/rack/utils.rb#357
  def get_byte_ranges(http_range, size); end

  # source://rack//lib/rack/utils.rb#283
  def make_delete_cookie_header(header, key, value); end

  # source://rack//lib/rack/utils.rb#220
  def parse_cookies(env); end

  # source://rack//lib/rack/utils.rb#224
  def parse_cookies_header(header); end

  # source://rack//lib/rack/utils.rb#112
  def parse_nested_query(qs, d = T.unsafe(nil)); end

  # source://rack//lib/rack/utils.rb#108
  def parse_query(qs, d = T.unsafe(nil), &unescaper); end

  # source://rack//lib/rack/utils.rb#144
  def q_values(q_value_header); end

  # Modified version of stdlib time.rb Time#rfc2822 to use '%d-%b-%Y' instead
  # of '% %b %Y'.
  # It assumes that the time is in GMT to comply to the RFC 2109.
  #
  # NOTE: I'm not sure the RFC says it requires GMT, but is ambiguous enough
  # that I'm certain someone implemented only that option.
  # Do not use %a and %b from Time.strptime, it would use localized names for
  # weekday and month.
  #
  # source://rack//lib/rack/utils.rb#343
  def rfc2109(time); end

  # source://rack//lib/rack/utils.rb#330
  def rfc2822(time); end

  # Constant time string comparison.
  #
  # NOTE: the values compared should be of fixed length, such as strings
  # that have already been processed by HMAC. This should not be used
  # on variable length plaintext strings because it could leak length info
  # via timing attacks.
  #
  # source://rack//lib/rack/utils.rb#395
  def secure_compare(a, b); end

  # source://rack//lib/rack/utils.rb#188
  def select_best_encoding(available_encodings, accept_encoding); end

  # source://rack//lib/rack/utils.rb#278
  def set_cookie_header!(header, key, value); end

  # source://rack//lib/rack/utils.rb#599
  def status_code(status); end

  # Unescapes a URI escaped string with +encoding+. +encoding+ will be the
  # target encoding of the string returned, and it defaults to UTF-8
  #
  # source://rack//lib/rack/utils.rb#56
  def unescape(s, encoding = T.unsafe(nil)); end

  # Unescapes the **path** component of a URI.  See Rack::Utils.unescape for
  # unescaping query parameters or form components.
  #
  # source://rack//lib/rack/utils.rb#50
  def unescape_path(s); end

  # source://rack//lib/rack/utils.rb#626
  def valid_path?(path); end

  class << self
    # source://rack//lib/rack/utils.rb#237
    def add_cookie_to_header(header, key, value); end

    # Adds a cookie that will *remove* a cookie from the client.  Hence the
    # strange method name.
    #
    # source://rack//lib/rack/utils.rb#320
    def add_remove_cookie_to_header(header, key, value = T.unsafe(nil)); end

    # Return best accept value to use, based on the algorithm
    # in RFC 2616 Section 14.  If there are multiple best
    # matches (same specificity and quality), the value returned
    # is arbitrary.
    #
    # source://rack//lib/rack/utils.rb#159
    def best_q_match(q_value_header, available_mimes); end

    # source://rack//lib/rack/utils.rb#126
    def build_nested_query(value, prefix = T.unsafe(nil)); end

    # source://rack//lib/rack/utils.rb#116
    def build_query(params); end

    # Parses the "Range:" header, if present, into an array of Range objects.
    # Returns nil if the header is missing or syntactically invalid.
    # Returns an empty array if none of the ranges are satisfiable.
    #
    # source://rack//lib/rack/utils.rb#352
    def byte_ranges(env, size); end

    # source://rack//lib/rack/utils.rb#609
    def clean_path_info(path_info); end

    # source://rack//lib/rack/utils.rb#97
    def clock_time; end

    # Returns the value of attribute default_query_parser.
    #
    # source://rack//lib/rack/utils.rb#29
    def default_query_parser; end

    # Sets the attribute default_query_parser
    #
    # @param value the value to set the attribute default_query_parser to.
    #
    # source://rack//lib/rack/utils.rb#29
    def default_query_parser=(_arg0); end

    # source://rack//lib/rack/utils.rb#313
    def delete_cookie_header!(header, key, value = T.unsafe(nil)); end

    # URI escapes. (CGI style space to +)
    #
    # source://rack//lib/rack/utils.rb#38
    def escape(s); end

    # Escape ampersands, brackets and quotes to their HTML/XML entities.
    #
    # source://rack//lib/rack/utils.rb#184
    def escape_html(string); end

    # Like URI escaping, but with %20 instead of +. Strictly speaking this is
    # true URI escaping.
    #
    # source://rack//lib/rack/utils.rb#44
    def escape_path(s); end

    # source://rack//lib/rack/utils.rb#357
    def get_byte_ranges(http_range, size); end

    # source://rack//lib/rack/utils.rb#88
    def key_space_limit; end

    # source://rack//lib/rack/utils.rb#92
    def key_space_limit=(v); end

    # source://rack//lib/rack/utils.rb#283
    def make_delete_cookie_header(header, key, value); end

    # Returns the value of attribute multipart_file_limit.
    #
    # source://rack//lib/rack/utils.rb#63
    def multipart_file_limit; end

    # Sets the attribute multipart_file_limit
    #
    # @param value the value to set the attribute multipart_file_limit to.
    #
    # source://rack//lib/rack/utils.rb#63
    def multipart_file_limit=(_arg0); end

    # Returns the value of attribute multipart_file_limit.
    # multipart_part_limit is the original name of multipart_file_limit, but
    # the limit only counts parts with filenames.
    #
    # source://rack//lib/rack/utils.rb#63
    def multipart_part_limit; end

    # Sets the attribute multipart_file_limit
    #
    # @param value the value to set the attribute multipart_file_limit to.
    #
    # source://rack//lib/rack/utils.rb#63
    def multipart_part_limit=(_arg0); end

    # Returns the value of attribute multipart_total_part_limit.
    #
    # source://rack//lib/rack/utils.rb#61
    def multipart_total_part_limit; end

    # Sets the attribute multipart_total_part_limit
    #
    # @param value the value to set the attribute multipart_total_part_limit to.
    #
    # source://rack//lib/rack/utils.rb#61
    def multipart_total_part_limit=(_arg0); end

    # source://rack//lib/rack/utils.rb#80
    def param_depth_limit; end

    # source://rack//lib/rack/utils.rb#84
    def param_depth_limit=(v); end

    # source://rack//lib/rack/utils.rb#220
    def parse_cookies(env); end

    # source://rack//lib/rack/utils.rb#224
    def parse_cookies_header(header); end

    # source://rack//lib/rack/utils.rb#112
    def parse_nested_query(qs, d = T.unsafe(nil)); end

    # source://rack//lib/rack/utils.rb#108
    def parse_query(qs, d = T.unsafe(nil), &unescaper); end

    # source://rack//lib/rack/utils.rb#144
    def q_values(q_value_header); end

    # Modified version of stdlib time.rb Time#rfc2822 to use '%d-%b-%Y' instead
    # of '% %b %Y'.
    # It assumes that the time is in GMT to comply to the RFC 2109.
    #
    # NOTE: I'm not sure the RFC says it requires GMT, but is ambiguous enough
    # that I'm certain someone implemented only that option.
    # Do not use %a and %b from Time.strptime, it would use localized names for
    # weekday and month.
    #
    # source://rack//lib/rack/utils.rb#343
    def rfc2109(time); end

    # source://rack//lib/rack/utils.rb#330
    def rfc2822(time); end

    # Constant time string comparison.
    #
    # NOTE: the values compared should be of fixed length, such as strings
    # that have already been processed by HMAC. This should not be used
    # on variable length plaintext strings because it could leak length info
    # via timing attacks.
    #
    # source://rack//lib/rack/utils.rb#395
    def secure_compare(a, b); end

    # source://rack//lib/rack/utils.rb#188
    def select_best_encoding(available_encodings, accept_encoding); end

    # source://rack//lib/rack/utils.rb#278
    def set_cookie_header!(header, key, value); end

    # source://rack//lib/rack/utils.rb#599
    def status_code(status); end

    # Unescapes a URI escaped string with +encoding+. +encoding+ will be the
    # target encoding of the string returned, and it defaults to UTF-8
    #
    # source://rack//lib/rack/utils.rb#56
    def unescape(s, encoding = T.unsafe(nil)); end

    # Unescapes the **path** component of a URI.  See Rack::Utils.unescape for
    # unescaping query parameters or form components.
    #
    # source://rack//lib/rack/utils.rb#50
    def unescape_path(s); end

    # @return [Boolean]
    #
    # source://rack//lib/rack/utils.rb#626
    def valid_path?(path); end
  end
end

# source://rack//lib/rack/utils.rb#22
Rack::Utils::COMMON_SEP = T.let(T.unsafe(nil), Hash)

# Context allows the use of a compatible middleware at different points
# in a request handling stack. A compatible middleware must define
# #context which should take the arguments env and app. The first of which
# would be the request environment. The second of which would be the rack
# application that the request would be forwarded to.
#
# source://rack//lib/rack/utils.rb#410
class Rack::Utils::Context
  # @return [Context] a new instance of Context
  #
  # source://rack//lib/rack/utils.rb#413
  def initialize(app_f, app_r); end

  # Returns the value of attribute app.
  #
  # source://rack//lib/rack/utils.rb#411
  def app; end

  # source://rack//lib/rack/utils.rb#418
  def call(env); end

  # source://rack//lib/rack/utils.rb#426
  def context(env, app = T.unsafe(nil)); end

  # Returns the value of attribute for.
  #
  # source://rack//lib/rack/utils.rb#411
  def for; end

  # source://rack//lib/rack/utils.rb#422
  def recontext(app); end
end

# source://rack//lib/rack/utils.rb#21
Rack::Utils::DEFAULT_SEP = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/utils.rb#172
Rack::Utils::ESCAPE_HTML = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/utils.rb#181
Rack::Utils::ESCAPE_HTML_PATTERN = T.let(T.unsafe(nil), Regexp)

# Every standard HTTP code mapped to the appropriate message.
# Generated with:
#   curl -s https://www.iana.org/assignments/http-status-codes/http-status-codes-1.csv | \
#     ruby -ne 'm = /^(\d{3}),(?!Unassigned|\(Unused\))([^,]+)/.match($_) and \
#               puts "#{m[1]} => \x27#{m[2].strip}\x27,"'
#
# source://rack//lib/rack/utils.rb#526
Rack::Utils::HTTP_STATUS_CODES = T.let(T.unsafe(nil), Hash)

# A case-insensitive Hash that preserves the original case of a
# header when set.
#
# @api private
#
# source://rack//lib/rack/utils.rb#435
class Rack::Utils::HeaderHash < ::Hash
  # @api private
  # @return [HeaderHash] a new instance of HeaderHash
  #
  # source://rack//lib/rack/utils.rb#444
  def initialize(hash = T.unsafe(nil)); end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#474
  def [](k); end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#478
  def []=(k, v); end

  # on clear, we need to clear @names hash
  #
  # @api private
  #
  # source://rack//lib/rack/utils.rb#457
  def clear; end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#485
  def delete(k); end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#462
  def each; end

  # @api private
  # @return [Boolean]
  #
  # source://rack//lib/rack/utils.rb#491
  def has_key?(k); end

  # @api private
  # @return [Boolean]
  #
  # source://rack//lib/rack/utils.rb#491
  def include?(k); end

  # @api private
  # @return [Boolean]
  #
  # source://rack//lib/rack/utils.rb#491
  def key?(k); end

  # @api private
  # @return [Boolean]
  #
  # source://rack//lib/rack/utils.rb#491
  def member?(k); end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#504
  def merge(other); end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#499
  def merge!(other); end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#509
  def replace(other); end

  # @api private
  #
  # source://rack//lib/rack/utils.rb#468
  def to_hash; end

  protected

  # @api private
  #
  # source://rack//lib/rack/utils.rb#516
  def names; end

  private

  # on dup/clone, we need to duplicate @names hash
  #
  # @api private
  #
  # source://rack//lib/rack/utils.rb#451
  def initialize_copy(other); end

  class << self
    # @api private
    #
    # source://rack//lib/rack/utils.rb#436
    def [](headers); end
  end
end

# source://rack//lib/rack/utils.rb#20
Rack::Utils::InvalidParameterError = Rack::QueryParser::InvalidParameterError

# source://rack//lib/rack/utils.rb#23
Rack::Utils::KeySpaceConstrainedParams = Rack::QueryParser::Params

# source://rack//lib/rack/utils.rb#624
Rack::Utils::NULL_BYTE = T.let(T.unsafe(nil), String)

# source://rack//lib/rack/utils.rb#607
Rack::Utils::PATH_SEPS = T.let(T.unsafe(nil), Regexp)

# source://rack//lib/rack/utils.rb#19
Rack::Utils::ParameterTypeError = Rack::QueryParser::ParameterTypeError

# source://rack//lib/rack/utils.rb#25
Rack::Utils::RFC2822_DAY_NAME = T.let(T.unsafe(nil), Array)

# source://rack//lib/rack/utils.rb#26
Rack::Utils::RFC2822_MONTH_NAME = T.let(T.unsafe(nil), Array)

# Responses with HTTP status codes that should not have an entity body
#
# source://rack//lib/rack/utils.rb#593
Rack::Utils::STATUS_WITH_NO_ENTITY_BODY = T.let(T.unsafe(nil), Hash)

# source://rack//lib/rack/utils.rb#595
Rack::Utils::SYMBOL_TO_STATUS_CODE = T.let(T.unsafe(nil), Hash)

# The Rack protocol version number implemented.
#
# source://rack//lib/rack/version.rb#16
Rack::VERSION = T.let(T.unsafe(nil), Array)
