# typed: false

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `net-imap` gem.
# Please instead update this file by running `bin/tapioca gem net-imap`.


# Net::IMAP implements Internet Message Access Protocol (\IMAP) client
# functionality.  The protocol is described in
# [IMAP4rev1[https://tools.ietf.org/html/rfc3501]].
# --
# TODO: and [IMAP4rev2[https://tools.ietf.org/html/rfc9051]].
# ++
#
# == \IMAP Overview
#
# An \IMAP client connects to a server, and then authenticates
# itself using either #authenticate or #login.  Having
# authenticated itself, there is a range of commands
# available to it.  Most work with mailboxes, which may be
# arranged in an hierarchical namespace, and each of which
# contains zero or more messages.  How this is implemented on
# the server is implementation-dependent; on a UNIX server, it
# will frequently be implemented as files in mailbox format
# within a hierarchy of directories.
#
# To work on the messages within a mailbox, the client must
# first select that mailbox, using either #select or #examine
# (for read-only access).  Once the client has successfully
# selected a mailbox, they enter the "_selected_" state, and that
# mailbox becomes the _current_ mailbox, on which mail-item
# related commands implicitly operate.
#
# === Sequence numbers and UIDs
#
# Messages have two sorts of identifiers: message sequence
# numbers and UIDs.
#
# Message sequence numbers number messages within a mailbox
# from 1 up to the number of items in the mailbox.  If a new
# message arrives during a session, it receives a sequence
# number equal to the new size of the mailbox.  If messages
# are expunged from the mailbox, remaining messages have their
# sequence numbers "shuffled down" to fill the gaps.
#
# To avoid sequence number race conditions, servers must not expunge messages
# when no command is in progress, nor when responding to #fetch, #store, or
# #search.  Expunges _may_ be sent during any other command, including
# #uid_fetch, #uid_store, and #uid_search.  The #noop and #idle commands are
# both useful for this side-effect: they allow the server to send all mailbox
# updates, including expunges.
#
# UIDs, on the other hand, are permanently guaranteed not to
# identify another message within the same mailbox, even if
# the existing message is deleted.  UIDs are required to
# be assigned in ascending (but not necessarily sequential)
# order within a mailbox; this means that if a non-IMAP client
# rearranges the order of mail items within a mailbox, the
# UIDs have to be reassigned.  An \IMAP client thus cannot
# rearrange message orders.
#
# === Server capabilities and protocol extensions
#
# Net::IMAP <em>does not modify its behavior</em> according to server
# #capability.  Users of the class must check for required capabilities before
# issuing commands.  Special care should be taken to follow all #capability
# requirements for #starttls, #login, and #authenticate.
#
# See the #capability method for more information.
#
# == Examples of Usage
#
# === List sender and subject of all recent messages in the default mailbox
#
#   imap = Net::IMAP.new('mail.example.com')
#   imap.authenticate('LOGIN', 'joe_user', 'joes_password')
#   imap.examine('INBOX')
#   imap.search(["RECENT"]).each do |message_id|
#     envelope = imap.fetch(message_id, "ENVELOPE")[0].attr["ENVELOPE"]
#     puts "#{envelope.from[0].name}: \t#{envelope.subject}"
#   end
#
# === Move all messages from April 2003 from "Mail/sent-mail" to "Mail/sent-apr03"
#
#   imap = Net::IMAP.new('mail.example.com')
#   imap.authenticate('LOGIN', 'joe_user', 'joes_password')
#   imap.select('Mail/sent-mail')
#   if not imap.list('Mail/', 'sent-apr03')
#     imap.create('Mail/sent-apr03')
#   end
#   imap.search(["BEFORE", "30-Apr-2003", "SINCE", "1-Apr-2003"]).each do |message_id|
#     imap.copy(message_id, "Mail/sent-apr03")
#     imap.store(message_id, "+FLAGS", [:Deleted])
#   end
#   imap.expunge
#
# == Thread Safety
#
# Net::IMAP supports concurrent threads. For example,
#
#   imap = Net::IMAP.new("imap.foo.net", "imap2")
#   imap.authenticate("cram-md5", "bar", "password")
#   imap.select("inbox")
#   fetch_thread = Thread.start { imap.fetch(1..-1, "UID") }
#   search_result = imap.search(["BODY", "hello"])
#   fetch_result = fetch_thread.value
#   imap.disconnect
#
# This script invokes the FETCH command and the SEARCH command concurrently.
#
# == Errors
#
# An \IMAP server can send three different types of responses to indicate
# failure:
#
# NO:: the attempted command could not be successfully completed.  For
#      instance, the username/password used for logging in are incorrect;
#      the selected mailbox does not exist; etc.
#
# BAD:: the request from the client does not follow the server's
#       understanding of the \IMAP protocol.  This includes attempting
#       commands from the wrong client state; for instance, attempting
#       to perform a SEARCH command without having SELECTed a current
#       mailbox.  It can also signal an internal server
#       failure (such as a disk crash) has occurred.
#
# BYE:: the server is saying goodbye.  This can be part of a normal
#       logout sequence, and can be used as part of a login sequence
#       to indicate that the server is (for some reason) unwilling
#       to accept your connection.  As a response to any other command,
#       it indicates either that the server is shutting down, or that
#       the server is timing out the client connection due to inactivity.
#
# These three error response are represented by the errors
# Net::IMAP::NoResponseError, Net::IMAP::BadResponseError, and
# Net::IMAP::ByeResponseError, all of which are subclasses of
# Net::IMAP::ResponseError.  Essentially, all methods that involve
# sending a request to the server can generate one of these errors.
# Only the most pertinent instances have been documented below.
#
# Because the IMAP class uses Sockets for communication, its methods
# are also susceptible to the various errors that can occur when
# working with sockets.  These are generally represented as
# Errno errors.  For instance, any method that involves sending a
# request to the server and/or receiving a response from it could
# raise an Errno::EPIPE error if the network connection unexpectedly
# goes down.  See the socket(7), ip(7), tcp(7), socket(2), connect(2),
# and associated man pages.
#
# Finally, a Net::IMAP::DataFormatError is thrown if low-level data
# is found to be in an incorrect format (for instance, when converting
# between UTF-8 and UTF-16), and Net::IMAP::ResponseParseError is
# thrown if a server response is non-parseable.
#
# == What's here?
#
# * {Connection control}[rdoc-ref:Net::IMAP@Connection+control+methods]
# * {Core IMAP commands}[rdoc-ref:Net::IMAP@Core+IMAP+commands]
#   * {...for any state}[rdoc-ref:Net::IMAP@IMAP+commands+for+any+state]
#   * {...for the "not authenticated" state}[rdoc-ref:Net::IMAP@IMAP+commands+for+the+-22Not+Authenticated-22+state]
#   * {...for the "authenticated" state}[rdoc-ref:Net::IMAP@IMAP+commands+for+the+-22Authenticated-22+state]
#   * {...for the "selected" state}[rdoc-ref:Net::IMAP@IMAP+commands+for+the+-22Selected-22+state]
#   * {...for the "logout" state}[rdoc-ref:Net::IMAP@IMAP+commands+for+the+-22Logout-22+state]
# * {Supported IMAP extensions}[rdoc-ref:Net::IMAP@Supported+IMAP+extensions]
# * {Handling server responses}[rdoc-ref:Net::IMAP@Handling+server+responses]
#
# === Connection control methods
#
# - Net::IMAP.new: A new client connects immediately and waits for a
#   successful server greeting before returning the new client object.
# - #starttls: Asks the server to upgrade a clear-text connection to use TLS.
# - #logout: Tells the server to end the session. Enters the "_logout_" state.
# - #disconnect: Disconnects the connection (without sending #logout first).
# - #disconnected?: True if the connection has been closed.
#
# === Core \IMAP commands
#
# The following commands are defined either by
# the [IMAP4rev1[https://tools.ietf.org/html/rfc3501]] base specification, or
# by one of the following extensions:
# [IDLE[https://tools.ietf.org/html/rfc2177]],
# [NAMESPACE[https://tools.ietf.org/html/rfc2342]],
# [UNSELECT[https://tools.ietf.org/html/rfc3691]],
# --
# TODO: [ENABLE[https://tools.ietf.org/html/rfc5161]],
# TODO: [LIST-EXTENDED[https://tools.ietf.org/html/rfc5258]],
# TODO: [LIST-STATUS[https://tools.ietf.org/html/rfc5819]],
# ++
# [MOVE[https://tools.ietf.org/html/rfc6851]].
# These extensions are widely supported by modern IMAP4rev1 servers and have
# all been integrated into [IMAP4rev2[https://tools.ietf.org/html/rfc9051]].
# <em>Note: Net::IMAP doesn't fully support IMAP4rev2 yet.</em>
#
# --
# TODO: When IMAP4rev2 is supported, add the following to the each of the
# appropriate commands below.
#   Note:: CHECK has been removed from IMAP4rev2.
#   Note:: LSUB is obsoleted by +LIST-EXTENDED and has been removed from IMAP4rev2.
#   <em>Some arguments require the +LIST-EXTENDED+ or +IMAP4rev2+ capability.</em>
#   <em>Requires either the +ENABLE+    or +IMAP4rev2+ capability.</em>
#   <em>Requires either the +NAMESPACE+ or +IMAP4rev2+ capability.</em>
#   <em>Requires either the +IDLE+      or +IMAP4rev2+ capability.</em>
#   <em>Requires either the +UNSELECT+  or +IMAP4rev2+ capability.</em>
#   <em>Requires either the +UIDPLUS+   or +IMAP4rev2+ capability.</em>
#   <em>Requires either the +MOVE+      or +IMAP4rev2+ capability.</em>
# ++
#
# ==== \IMAP commands for any state
#
# - #capability: Returns the server's capabilities as an array of strings.
#
#   <em>Capabilities may change after</em> #starttls, #authenticate, or #login
#   <em>and cached capabilities must be reloaded.</em>
# - #noop: Allows the server to send unsolicited untagged #responses.
# - #logout: Tells the server to end the session. Enters the "_logout_" state.
#
# ==== \IMAP commands for the "Not Authenticated" state
#
# In addition to the universal commands, the following commands are valid in
# the "<em>not authenticated</em>" state:
#
# - #starttls: Upgrades a clear-text connection to use TLS.
#
#   <em>Requires the +STARTTLS+ capability.</em>
# - #authenticate: Identifies the client to the server using a {SASL
#   mechanism}[https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml].
#   Enters the "_authenticated_" state.
#
#   <em>Requires the <tt>AUTH=#{mechanism}</tt> capability for the chosen
#   mechanism.</em>
# - #login: Identifies the client to the server using a plain text password.
#   Using #authenticate is generally preferred.  Enters the "_authenticated_"
#   state.
#
#   <em>The +LOGINDISABLED+ capability</em> <b>must NOT</b> <em>be listed.</em>
#
# ==== \IMAP commands for the "Authenticated" state
#
# In addition to the universal commands, the following commands are valid in
# the "_authenticated_" state:
#
# --
# - #enable: <em>Not implemented by Net::IMAP, yet.</em>
#
#   <em>Requires the +ENABLE+ capability.</em>
# ++
# - #select:  Open a mailbox and enter the "_selected_" state.
# - #examine: Open a mailbox read-only, and enter the "_selected_" state.
# - #create: Creates a new mailbox.
# - #delete: Permanently remove a mailbox.
# - #rename: Change the name of a mailbox.
# - #subscribe: Adds a mailbox to the "subscribed" set.
# - #unsubscribe: Removes a mailbox from the "subscribed" set.
# - #list: Returns names and attributes of mailboxes matching a given pattern.
# - #namespace: Returns mailbox namespaces, with path prefixes and delimiters.
#
#   <em>Requires the +NAMESPACE+ capability.</em>
# - #status: Returns mailbox information, e.g. message count, unseen message
#   count, +UIDVALIDITY+ and +UIDNEXT+.
# - #append: Appends a message to the end of a mailbox.
# - #idle: Allows the server to send updates to the client, without the client
#   needing to poll using #noop.
#
#   <em>Requires the +IDLE+ capability.</em>
# - #lsub: Lists mailboxes the user has declared "active" or "subscribed".
# --
#   <em>Replaced by</em> <tt>LIST-EXTENDED</tt> <em>and removed from</em>
#   +IMAP4rev2+.  <em>However, Net::IMAP hasn't implemented</em>
#   <tt>LIST-EXTENDED</tt> _yet_.
# ++
#
# ==== \IMAP commands for the "Selected" state
#
# In addition to the universal commands and the "authenticated" commands, the
# following commands are valid in the "_selected_" state:
#
# - #close: Closes the mailbox and returns to the "_authenticated_" state,
#   expunging deleted messages, unless the mailbox was opened as read-only.
# - #unselect: Closes the mailbox and returns to the "_authenticated_" state,
#   without expunging any messages.
#
#   <em>Requires the +UNSELECT+ capability.</em>
# - #expunge: Permanently removes messages which have the Deleted flag set.
# - #uid_expunge: Restricts #expunge to only remove the specified UIDs.
#
#   <em>Requires the +UIDPLUS+ capability.</em>
# - #search, #uid_search: Returns sequence numbers or UIDs of messages that
#   match the given searching criteria.
# - #fetch, #uid_fetch: Returns data associated with a set of messages,
#   specified by sequence number or UID.
# - #store, #uid_store: Alters a message's flags.
# - #copy, #uid_copy: Copies the specified messages to the end of the
#   specified destination mailbox.
# - #move, #uid_move: Moves the specified messages to the end of the
#   specified destination mailbox, expunging them from the current mailbox.
#
#   <em>Requires the +MOVE+ capability.</em>
# - #check: Mostly obsolete.  Can be replaced with #noop or #idle.
# --
#   <em>Removed from IMAP4rev2.</em>
# ++
#
# ==== \IMAP commands for the "Logout" state
#
# No \IMAP commands are valid in the +logout+ state.  If the socket is still
# open, Net::IMAP will close it after receiving server confirmation.
# Exceptions will be raised by \IMAP commands that have already started and
# are waiting for a response, as well as any that are called after logout.
#
# === Supported \IMAP extensions
#
# ==== RFC9051: +IMAP4rev2+
#
# Although IMAP4rev2[https://tools.ietf.org/html/rfc9051] is <em>not supported
# yet</em>, Net::IMAP supports several extensions that have been folded into
# it: +IDLE+, +MOVE+, +NAMESPACE+, +UIDPLUS+, and +UNSELECT+.
# --
# TODO: RFC4466, ABNF extensions (automatic support for other extensions)
# TODO: +ESEARCH+, ExtendedSearchData
# TODO: +SEARCHRES+,
# TODO: +ENABLE+,
# TODO: +SASL-IR+,
# TODO: +LIST-EXTENDED+,
# TODO: +LIST-STATUS+,
# TODO: +LITERAL-+,
# TODO: +BINARY+ (only the FETCH side)
# TODO: +SPECIAL-USE+
# implicitly supported, but we can do better: Response codes: RFC5530, etc
# implicitly supported, but we can do better: <tt>STATUS=SIZE</tt>
# implicitly supported, but we can do better: <tt>STATUS DELETED</tt>
# ++
# Commands for these extensions are included with the {Core IMAP
# commands}[rdoc-ref:Net::IMAP@Core+IMAP+commands], above.  Other supported
# extensons are listed below.
#
# ==== RFC2087: +QUOTA+
# - #getquota: returns the resource usage and limits for a quota root
# - #getquotaroot: returns the list of quota roots for a mailbox, as well as
#   their resource usage and limits.
# - #setquota: sets the resource limits for a given quota root.
#
# ==== RFC2177: +IDLE+
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051], so it is also
# listed with {Core IMAP commands}[rdoc-ref:Net::IMAP@Core+IMAP+commands].
# - #idle: Allows the server to send updates to the client, without the client
#   needing to poll using #noop.
#
# ==== RFC2342: +NAMESPACE+
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051], so it is also
# listed with {Core IMAP commands}[rdoc-ref:Net::IMAP@Core+IMAP+commands].
# - #namespace: Returns mailbox namespaces, with path prefixes and delimiters.
#
# ==== RFC2971: +ID+
# - #id: exchanges client and server implementation information.
#
# --
# ==== RFC3502: +MULTIAPPEND+
# TODO...
# ++
#
# --
# ==== RFC3516: +BINARY+
# TODO...
# ++
#
# ==== RFC3691: +UNSELECT+
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051], so it is also
# listed with {Core IMAP commands}[rdoc-ref:Net::IMAP@Core+IMAP+commands].
# - #unselect: Closes the mailbox and returns to the "_authenticated_" state,
#   without expunging any messages.
#
# ==== RFC4314: +ACL+
# - #getacl: lists the authenticated user's access rights to a mailbox.
# - #setacl: sets the access rights for a user on a mailbox
# --
# TODO: #deleteacl, #listrights, #myrights
# ++
# - *_Note:_* +DELETEACL+, +LISTRIGHTS+, and +MYRIGHTS+ are not supported yet.
#
# ==== RFC4315: +UIDPLUS+
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051], so it is also
# listed with {Core IMAP commands}[rdoc-ref:Net::IMAP@Core+IMAP+commands].
# - #uid_expunge: Restricts #expunge to only remove the specified UIDs.
# - Updates #select, #examine with the +UIDNOTSTICKY+ ResponseCode
# - Updates #append with the +APPENDUID+ ResponseCode
# - Updates #copy, #move with the +COPYUID+ ResponseCode
#
# --
# ==== RFC4466: Collected Extensions to IMAP4 ABNF
# TODO...
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051], this RFC updates
# the protocol to enable new optional parameters to many commands: #select,
# #examine, #create, #rename, #fetch, #uid_fetch, #store, #uid_store, #search,
# #uid_search, and #append.  However, specific parameters are not defined.
# Extensions to these commands use this syntax whenever possible.  Net::IMAP
# may be partially compatible with extensions to these commands, even without
# any explicit support.
# ++
#
# --
# ==== RFC4731 +ESEARCH+
# TODO...
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051].
# - Updates #search, #uid_search to accept result options: +MIN+, +MAX+,
#   +ALL+, +COUNT+, and to return ExtendedSearchData.
# ++
#
# --
# ==== RFC4959: +SASL-IR+
# TODO...
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051].
# - Updates #authenticate to reduce round-trips for supporting mechanisms.
# ++
#
# --
# ==== RFC4978: COMPRESS=DEFLATE
# TODO...
# ++
#
# --
# ==== RFC5182 +SEARCHRES+
# TODO...
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051].
# - Updates #search, #uid_search with the +SAVE+ result option.
# - Updates #copy, #uid_copy, #fetch, #uid_fetch, #move, #uid_move, #search,
#   #uid_search, #store, #uid_store, and #uid_expunge with ability to
#   reference the saved result of a previous #search or #uid_search command.
# ++
#
# ==== RFC5256: +SORT+
# - #sort, #uid_sort: An alternate version of #search or #uid_search which
#   sorts the results by specified keys.
# ==== RFC5256: +THREAD+
# - #thread, #uid_thread: An alternate version of #search or #uid_search,
#   which arranges the results into ordered groups or threads according to a
#   chosen algorithm.
#
# --
# ==== RFC5258 +LIST-EXTENDED+
# TODO...
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051], this updates the
# protocol with new optional parameters to the #list command, adding a few of
# its own.  Net::IMAP may be forward-compatible with future #list extensions,
# even without any explicit support.
# - Updates #list to accept selection options: +SUBSCRIBED+, +REMOTE+, and
#   +RECURSIVEMATCH+, and return options: +SUBSCRIBED+ and +CHILDREN+.
# ++
#
# --
# ==== RFC5819 +LIST-STATUS+
# TODO...
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051].
# - Updates #list with +STATUS+ return option.
# ++
#
# ==== +XLIST+ (non-standard, deprecated)
# - #xlist: replaced by +SPECIAL-USE+ attributes in #list responses.
#
# --
# ==== RFC6154 +SPECIAL-USE+
# TODO...
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051].
# - Updates #list with the +SPECIAL-USE+ selection and return options.
# ++
#
# ==== RFC6851: +MOVE+
# Folded into IMAP4rev2[https://tools.ietf.org/html/rfc9051], so it is also
# listed with {Core IMAP commands}[rdoc-ref:Net::IMAP@Core+IMAP+commands].
# - #move, #uid_move: Moves the specified messages to the end of the
#   specified destination mailbox, expunging them from the current mailbox.
#
# --
# ==== RFC6855: UTF8=ACCEPT
# TODO...
# ==== RFC6855: UTF8=ONLY
# TODO...
# ++
#
# --
# ==== RFC7888: <tt>LITERAL+</tt>, +LITERAL-+
# TODO...
# ==== RFC7162: +QRESYNC+
# TODO...
# ==== RFC7162: +CONDSTORE+
# TODO...
# ==== RFC8474: +OBJECTID+
# TODO...
# ==== RFC9208: +QUOTA+
# TODO...
# ++
#
# === Handling server responses
#
# - #greeting: The server's initial untagged response, which can indicate a
#   pre-authenticated connection.
# - #responses: A hash with arrays of unhandled <em>non-+nil+</em>
#   UntaggedResponse and ResponseCode +#data+, keyed by +#name+.
# - #add_response_handler: Add a block to be called inside the receiver thread
#   with every server response.
# - #remove_response_handler: Remove a previously added response handler.
#
#
# == References
# --
# TODO: Consider moving references list to REFERENCES.md or REFERENCES.rdoc.
# ++
#
# [{IMAP4rev1}[https://www.rfc-editor.org/rfc/rfc3501.html]]::
#   Crispin, M., "INTERNET MESSAGE ACCESS PROTOCOL - \VERSION 4rev1",
#   RFC 3501, DOI 10.17487/RFC3501, March 2003,
#   <https://www.rfc-editor.org/info/rfc3501>.
#
# [IMAP-ABNF-EXT[https://www.rfc-editor.org/rfc/rfc4466.html]]::
#   Melnikov, A. and C. Daboo, "Collected Extensions to IMAP4 ABNF",
#   RFC 4466, DOI 10.17487/RFC4466, April 2006,
#   <https://www.rfc-editor.org/info/rfc4466>.
#
#   <em>Note: Net::IMAP cannot parse the entire RFC4466 grammar yet.</em>
#
# [{IMAP4rev2}[https://www.rfc-editor.org/rfc/rfc9051.html]]::
#   Melnikov, A., Ed., and B. Leiba, Ed., "Internet Message Access Protocol
#   (\IMAP) - Version 4rev2", RFC 9051, DOI 10.17487/RFC9051, August 2021,
#   <https://www.rfc-editor.org/info/rfc9051>.
#
#   <em>Note: Net::IMAP is not fully compatible with IMAP4rev2 yet.</em>
#
# [IMAP-IMPLEMENTATION[https://www.rfc-editor.org/info/rfc2683]]::
#   Leiba, B., "IMAP4 Implementation Recommendations",
#   RFC 2683, DOI 10.17487/RFC2683, September 1999,
#   <https://www.rfc-editor.org/info/rfc2683>.
#
# [IMAP-MULTIACCESS[https://www.rfc-editor.org/info/rfc2180]]::
#   Gahrns, M., "IMAP4 Multi-Accessed Mailbox Practice", RFC 2180, DOI
#   10.17487/RFC2180, July 1997, <https://www.rfc-editor.org/info/rfc2180>.
#
# [UTF7[https://tools.ietf.org/html/rfc2152]]::
#   Goldsmith, D. and M. Davis, "UTF-7 A Mail-Safe Transformation Format of
#   Unicode", RFC 2152, DOI 10.17487/RFC2152, May 1997,
#   <https://www.rfc-editor.org/info/rfc2152>.
#
# === Message envelope and body structure
#
# [RFC5322[https://tools.ietf.org/html/rfc5322]]::
#   Resnick, P., Ed., "Internet Message Format",
#   RFC 5322, DOI 10.17487/RFC5322, October 2008,
#   <https://www.rfc-editor.org/info/rfc5322>.
#
#   <em>Note: obsoletes</em>
#   RFC-2822[https://tools.ietf.org/html/rfc2822]<em> (April 2001) and</em>
#   RFC-822[https://tools.ietf.org/html/rfc822]<em> (August 1982).</em>
#
# [CHARSET[https://tools.ietf.org/html/rfc2978]]::
#   Freed, N. and J. Postel, "IANA Charset Registration Procedures", BCP 19,
#   RFC 2978, DOI 10.17487/RFC2978, October 2000,
#   <https://www.rfc-editor.org/info/rfc2978>.
#
# [DISPOSITION[https://tools.ietf.org/html/rfc2183]]::
#    Troost, R., Dorner, S., and K. Moore, Ed., "Communicating Presentation
#    Information in Internet Messages: The Content-Disposition Header
#    Field", RFC 2183, DOI 10.17487/RFC2183, August 1997,
#    <https://www.rfc-editor.org/info/rfc2183>.
#
# [MIME-IMB[https://tools.ietf.org/html/rfc2045]]::
#    Freed, N. and N. Borenstein, "Multipurpose Internet Mail Extensions
#    (MIME) Part One: Format of Internet Message Bodies",
#    RFC 2045, DOI 10.17487/RFC2045, November 1996,
#    <https://www.rfc-editor.org/info/rfc2045>.
#
# [MIME-IMT[https://tools.ietf.org/html/rfc2046]]::
#    Freed, N. and N. Borenstein, "Multipurpose Internet Mail Extensions
#    (MIME) Part Two: Media Types", RFC 2046, DOI 10.17487/RFC2046,
#    November 1996, <https://www.rfc-editor.org/info/rfc2046>.
#
# [MIME-HDRS[https://tools.ietf.org/html/rfc2047]]::
#    Moore, K., "MIME (Multipurpose Internet Mail Extensions) Part Three:
#    Message Header Extensions for Non-ASCII Text",
#    RFC 2047, DOI 10.17487/RFC2047, November 1996,
#    <https://www.rfc-editor.org/info/rfc2047>.
#
# [RFC2231[https://tools.ietf.org/html/rfc2231]]::
#    Freed, N. and K. Moore, "MIME Parameter Value and Encoded Word
#    Extensions: Character Sets, Languages, and Continuations",
#    RFC 2231, DOI 10.17487/RFC2231, November 1997,
#    <https://www.rfc-editor.org/info/rfc2231>.
#
# [I18n-HDRS[https://tools.ietf.org/html/rfc6532]]::
#    Yang, A., Steele, S., and N. Freed, "Internationalized Email Headers",
#    RFC 6532, DOI 10.17487/RFC6532, February 2012,
#    <https://www.rfc-editor.org/info/rfc6532>.
#
# [LANGUAGE-TAGS[https://www.rfc-editor.org/info/rfc3282]]::
#    Alvestrand, H., "Content Language Headers",
#    RFC 3282, DOI 10.17487/RFC3282, May 2002,
#    <https://www.rfc-editor.org/info/rfc3282>.
#
# [LOCATION[https://www.rfc-editor.org/info/rfc2557]]::
#    Palme, J., Hopmann, A., and N. Shelness, "MIME Encapsulation of
#    Aggregate Documents, such as HTML (MHTML)",
#    RFC 2557, DOI 10.17487/RFC2557, March 1999,
#    <https://www.rfc-editor.org/info/rfc2557>.
#
# [MD5[https://tools.ietf.org/html/rfc1864]]::
#    Myers, J. and M. Rose, "The Content-MD5 Header Field",
#    RFC 1864, DOI 10.17487/RFC1864, October 1995,
#    <https://www.rfc-editor.org/info/rfc1864>.
#
# --
# TODO: Document IMAP keywords.
#
# [RFC3503[https://tools.ietf.org/html/rfc3503]]
#   Melnikov, A., "Message Disposition Notification (MDN)
#   profile for Internet Message Access Protocol (IMAP)",
#   RFC 3503, DOI 10.17487/RFC3503, March 2003,
#   <https://www.rfc-editor.org/info/rfc3503>.
# ++
#
# === Supported \IMAP Extensions
#
# [QUOTA[https://tools.ietf.org/html/rfc2087]]::
#   Myers, J., "IMAP4 QUOTA extension", RFC 2087, DOI 10.17487/RFC2087,
#   January 1997, <https://www.rfc-editor.org/info/rfc2087>.
# --
# TODO: test compatibility with updated QUOTA extension:
# [QUOTA[https://tools.ietf.org/html/rfc9208]]::
#   Melnikov, A., "IMAP QUOTA Extension", RFC 9208, DOI 10.17487/RFC9208,
#   March 2022, <https://www.rfc-editor.org/info/rfc9208>.
# ++
# [IDLE[https://tools.ietf.org/html/rfc2177]]::
#   Leiba, B., "IMAP4 IDLE command", RFC 2177, DOI 10.17487/RFC2177,
#   June 1997, <https://www.rfc-editor.org/info/rfc2177>.
# [NAMESPACE[https://tools.ietf.org/html/rfc2342]]::
#   Gahrns, M. and C. Newman, "IMAP4 Namespace", RFC 2342,
#   DOI 10.17487/RFC2342, May 1998, <https://www.rfc-editor.org/info/rfc2342>.
# [ID[https://tools.ietf.org/html/rfc2971]]::
#   Showalter, T., "IMAP4 ID extension", RFC 2971, DOI 10.17487/RFC2971,
#   October 2000, <https://www.rfc-editor.org/info/rfc2971>.
# [ACL[https://tools.ietf.org/html/rfc4314]]::
#   Melnikov, A., "IMAP4 Access Control List (ACL) Extension", RFC 4314,
#   DOI 10.17487/RFC4314, December 2005,
#   <https://www.rfc-editor.org/info/rfc4314>.
# [UIDPLUS[https://www.rfc-editor.org/rfc/rfc4315.html]]::
#   Crispin, M., "Internet Message Access Protocol (\IMAP) - UIDPLUS
#   extension", RFC 4315, DOI 10.17487/RFC4315, December 2005,
#   <https://www.rfc-editor.org/info/rfc4315>.
# [SORT[https://tools.ietf.org/html/rfc5256]]::
#   Crispin, M. and K. Murchison, "Internet Message Access Protocol - SORT and
#   THREAD Extensions", RFC 5256, DOI 10.17487/RFC5256, June 2008,
#   <https://www.rfc-editor.org/info/rfc5256>.
# [THREAD[https://tools.ietf.org/html/rfc5256]]::
#   Crispin, M. and K. Murchison, "Internet Message Access Protocol - SORT and
#   THREAD Extensions", RFC 5256, DOI 10.17487/RFC5256, June 2008,
#   <https://www.rfc-editor.org/info/rfc5256>.
# [RFC5530[https://www.rfc-editor.org/rfc/rfc5530.html]]::
#   Gulbrandsen, A., "IMAP Response Codes", RFC 5530, DOI 10.17487/RFC5530,
#   May 2009, <https://www.rfc-editor.org/info/rfc5530>.
# [MOVE[https://tools.ietf.org/html/rfc6851]]::
#   Gulbrandsen, A. and N. Freed, Ed., "Internet Message Access Protocol
#   (\IMAP) - MOVE Extension", RFC 6851, DOI 10.17487/RFC6851, January 2013,
#   <https://www.rfc-editor.org/info/rfc6851>.
#
# === IANA registries
#
# * {IMAP Capabilities}[http://www.iana.org/assignments/imap4-capabilities]
# * {IMAP Response Codes}[https://www.iana.org/assignments/imap-response-codes/imap-response-codes.xhtml]
# * {IMAP Mailbox Name Attributes}[https://www.iana.org/assignments/imap-mailbox-name-attributes/imap-mailbox-name-attributes.xhtml]
# * {IMAP and JMAP Keywords}[https://www.iana.org/assignments/imap-jmap-keywords/imap-jmap-keywords.xhtml]
# * {IMAP Threading Algorithms}[https://www.iana.org/assignments/imap-threading-algorithms/imap-threading-algorithms.xhtml]
# --
# * {IMAP Quota Resource Types}[http://www.iana.org/assignments/imap4-capabilities#imap-capabilities-2]
# * [{LIST-EXTENDED options and responses}[https://www.iana.org/assignments/imap-list-extended/imap-list-extended.xhtml]
# * {IMAP METADATA Server Entry and Mailbox Entry Registries}[https://www.iana.org/assignments/imap-metadata/imap-metadata.xhtml]
# * {IMAP ANNOTATE Extension Entries and Attributes}[https://www.iana.org/assignments/imap-annotate-extension/imap-annotate-extension.xhtml]
# * {IMAP URLAUTH Access Identifiers and Prefixes}[https://www.iana.org/assignments/urlauth-access-ids/urlauth-access-ids.xhtml]
# * {IMAP URLAUTH Authorization Mechanism Registry}[https://www.iana.org/assignments/urlauth-authorization-mechanism-registry/urlauth-authorization-mechanism-registry.xhtml]
# ++
# * {SASL Mechanisms and SASL SCRAM Family Mechanisms}[https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml]
# * {Service Name and Transport Protocol Port Number Registry}[https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xml]:
#   +imap+: tcp/143, +imaps+: tcp/993
# * {GSSAPI/Kerberos/SASL Service Names}[https://www.iana.org/assignments/gssapi-service-names/gssapi-service-names.xhtml]:
#   +imap+
# * {Character sets}[https://www.iana.org/assignments/character-sets/character-sets.xhtml]
#
# source://net-imap//lib/net/imap.rb#701
class Net::IMAP < ::Net::Protocol
  include ::MonitorMixin
  include ::OpenSSL
  include ::OpenSSL::SSL
  extend ::Net::IMAP::Authenticators
  extend ::Net::IMAP::SASL

  # :call-seq:
  #    Net::IMAP.new(host, options = {})
  #
  # Creates a new Net::IMAP object and connects it to the specified
  # +host+.
  #
  # +options+ is an option hash, each key of which is a symbol.
  #
  # The available options are:
  #
  # port::  Port number (default value is 143 for imap, or 993 for imaps)
  # ssl::   If +options[:ssl]+ is true, then an attempt will be made
  #         to use SSL (now TLS) to connect to the server.
  #         If +options[:ssl]+ is a hash, it's passed to
  #         OpenSSL::SSL::SSLContext#set_params as parameters.
  # open_timeout:: Seconds to wait until a connection is opened
  # idle_response_timeout:: Seconds to wait until an IDLE response is received
  #
  # The most common errors are:
  #
  # Errno::ECONNREFUSED:: Connection refused by +host+ or an intervening
  #                       firewall.
  # Errno::ETIMEDOUT:: Connection timed out (possibly due to packets
  #                    being dropped by an intervening firewall).
  # Errno::ENETUNREACH:: There is no route to that network.
  # SocketError:: Hostname not known or other socket error.
  # Net::IMAP::ByeResponseError:: The connected to the host was successful, but
  #                               it immediately said goodbye.
  #
  # @return [IMAP] a new instance of IMAP
  #
  # source://net-imap//lib/net/imap.rb#2009
  def initialize(host, port_or_options = T.unsafe(nil), usessl = T.unsafe(nil), certs = T.unsafe(nil), verify = T.unsafe(nil)); end

  # Adds a response handler. For example, to detect when
  # the server sends a new EXISTS response (which normally
  # indicates new messages being added to the mailbox),
  # add the following handler after selecting the
  # mailbox:
  #
  #   imap.add_response_handler { |resp|
  #     if resp.kind_of?(Net::IMAP::UntaggedResponse) and resp.name == "EXISTS"
  #       puts "Mailbox now has #{resp.data} messages"
  #     end
  #   }
  #
  # @raise [ArgumentError]
  #
  # source://net-imap//lib/net/imap.rb#1963
  def add_response_handler(handler = T.unsafe(nil), &block); end

  # Sends an {APPEND command [IMAP4rev1 §6.3.11]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.11]
  # to append the +message+ to the end of the +mailbox+. The optional +flags+
  # argument is an array of flags initially passed to the new message.  The
  # optional +date_time+ argument specifies the creation time to assign to the
  # new message; it defaults to the current time.
  #
  # For example:
  #
  #   imap.append("inbox", <<EOF.gsub(/\n/, "\r\n"), [:Seen], Time.now)
  #   Subject: hello
  #   From: shugo@ruby-lang.org
  #   To: shugo@ruby-lang.org
  #
  #   hello world
  #   EOF
  #
  # A Net::IMAP::NoResponseError is raised if the mailbox does
  # not exist (it is not created automatically), or if the flags,
  # date_time, or message arguments contain errors.
  #
  # ===== Capabilities
  #
  # If +UIDPLUS+ [RFC4315[https://www.rfc-editor.org/rfc/rfc4315.html]] is
  # supported and the destination supports persistent UIDs, the server's
  # response should include an +APPENDUID+ response code with UIDPlusData.
  # This will report the UIDVALIDITY of the destination mailbox and the
  # assigned UID of the appended message.
  #
  # --
  # TODO: add MULTIAPPEND support
  # ++
  #
  # source://net-imap//lib/net/imap.rb#1487
  def append(mailbox, message, flags = T.unsafe(nil), date_time = T.unsafe(nil)); end

  # :call-seq:
  #   authenticate(mechanism, ...)                               -> ok_resp
  #   authenticate(mech, *creds, **props) {|prop, auth| val }    -> ok_resp
  #   authenticate(mechanism, authnid, credentials, authzid=nil) -> ok_resp
  #   authenticate(mechanism, **properties)                      -> ok_resp
  #   authenticate(mechanism) {|propname, authctx| prop_value }  -> ok_resp
  #
  # Sends an {AUTHENTICATE command [IMAP4rev1 §6.2.2]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.2.2]
  # to authenticate the client.  If successful, the connection enters the
  # "_authenticated_" state.
  #
  # +mechanism+ is the name of the \SASL authentication mechanism to be used.
  # All other arguments are forwarded to the authenticator for the requested
  # mechanism.  The listed call signatures are suggestions.  <em>The
  # documentation for each individual mechanism must be consulted for its
  # specific parameters.</em>
  #
  # An exception Net::IMAP::NoResponseError is raised if authentication fails.
  #
  # Related: #login, #starttls
  #
  # ==== Supported SASL Mechanisms
  #
  # +PLAIN+::     See PlainAuthenticator.
  #               Login using clear-text username and password.
  #
  # +XOAUTH2+::   See XOauth2Authenticator.
  #               Login using a username and OAuth2 access token.
  #               Non-standard and obsoleted by +OAUTHBEARER+, but widely
  #               supported.
  #
  # >>>
  #   *Deprecated:*  <em>Obsolete mechanisms are available for backwards
  #   compatibility.</em>
  #
  #   For +DIGEST-MD5+ see DigestMD5Authenticator.
  #
  #   For +LOGIN+, see LoginAuthenticator.
  #
  #   For +CRAM-MD5+, see CramMD5Authenticator.
  #
  #   <em>Using a deprecated mechanism will print a warning.</em>
  #
  # See Net::IMAP::Authenticators for information on plugging in
  # authenticators for other mechanisms.  See the {SASL mechanism
  # registry}[https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml]
  # for information on these and other SASL mechanisms.
  #
  # ===== Capabilities
  #
  # Clients MUST NOT attempt to authenticate with a mechanism unless
  # <tt>"AUTH=#{mechanism}"</tt> for that mechanism is a server capability.
  #
  # Server capabilities may change after #starttls, #login, and #authenticate.
  # Cached capabilities _must_ be invalidated after this method completes.
  # The TaggedResponse to #authenticate may include updated capabilities in
  # its ResponseCode.
  #
  # ===== Example
  # If the authenticators ignore unhandled keyword arguments, the same config
  # can be used for multiple mechanisms:
  #
  #    password  = nil # saved locally, so we don't ask more than once
  #    accesstok = nil # saved locally...
  #    creds = {
  #      authcid:      username,
  #      password:     proc { password  ||= ui.prompt_for_password },
  #      oauth2_token: proc { accesstok ||= kms.fresh_access_token },
  #    }
  #    capa = imap.capability
  #    if    capa.include? "AUTH=OAUTHBEARER"
  #      imap.authenticate "OAUTHBEARER",   **creds # authcid, oauth2_token
  #    elsif capa.include? "AUTH=XOAUTH2"
  #      imap.authenticate "XOAUTH2",       **creds # authcid, oauth2_token
  #    elsif capa.include? "AUTH=SCRAM-SHA-256"
  #      imap.authenticate "SCRAM-SHA-256", **creds # authcid, password
  #    elsif capa.include? "AUTH=PLAIN"
  #      imap.authenticate "PLAIN",         **creds # authcid, password
  #    elsif capa.include? "AUTH=DIGEST-MD5"
  #      imap.authenticate "DIGEST-MD5",    **creds # authcid, password
  #    elsif capa.include? "LOGINDISABLED"
  #      raise "the server has disabled login"
  #    else
  #      imap.login username, password
  #    end
  #
  # source://net-imap//lib/net/imap.rb#1040
  def authenticate(mechanism, *args, **props, &cb); end

  # Sends a {CAPABILITY command [IMAP4rev1 §6.1.1]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.1.1]
  # and returns an array of capabilities that the server supports.  Each
  # capability is a string.
  #
  # See the {IANA IMAP4 capabilities
  # registry}[http://www.iana.org/assignments/imap4-capabilities] for a list
  # of all standard capabilities, and their reference RFCs.
  #
  # >>>
  #   <em>*Note* that Net::IMAP does not currently modify its
  #   behaviour according to the capabilities of the server;
  #   it is up to the user of the class to ensure that
  #   a certain capability is supported by a server before
  #   using it.</em>
  #
  # Capability requirements—other than +IMAP4rev1+—are listed in the
  # documentation for each command method.
  #
  # ===== Basic IMAP4rev1 capabilities
  #
  # All IMAP4rev1 servers must include +IMAP4rev1+ in their capabilities list.
  # All IMAP4rev1 servers must _implement_ the +STARTTLS+,
  # <tt>AUTH=PLAIN</tt>, and +LOGINDISABLED+ capabilities, and clients must
  # respect their presence or absence.  See the capabilites requirements on
  # #starttls, #login, and #authenticate.
  #
  # ===== Using IMAP4rev1 extensions
  #
  # IMAP4rev1 servers must not activate incompatible behavior until an
  # explicit client action invokes a capability, e.g. sending a command or
  # command argument specific to that capability.  Extensions with backward
  # compatible behavior, such as response codes or mailbox attributes, may
  # be sent at any time.
  #
  # Invoking capabilities which are unknown to Net::IMAP may cause unexpected
  # behavior and errors, for example ResponseParseError is raised when unknown
  # response syntax is received.  Invoking commands or command parameters that
  # are unsupported by the server may raise NoResponseError, BadResponseError,
  # or cause other unexpected behavior.
  #
  # ===== Caching +CAPABILITY+ responses
  #
  # Servers may send their capability list, unsolicited, using the
  # +CAPABILITY+ response code or an untagged +CAPABILITY+ response.  These
  # responses can be retrieved and cached using #responses or
  # #add_response_handler.
  #
  # But cached capabilities _must_ be discarded after #starttls, #login, or
  # #authenticate.  The OK TaggedResponse to #login and #authenticate may
  # include +CAPABILITY+ response code data, but the TaggedResponse for
  # #starttls is sent clear-text and cannot be trusted.
  #
  # source://net-imap//lib/net/imap.rb#849
  def capability; end

  # Sends a {CHECK command [IMAP4rev1 §6.4.1]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.1]
  # to request a checkpoint of the currently selected mailbox.  This performs
  # implementation-specific housekeeping; for instance, reconciling the
  # mailbox's in-memory and on-disk state.
  #
  # Related: #idle, #noop
  #
  # source://net-imap//lib/net/imap.rb#1503
  def check; end

  # source://net-imap//lib/net/imap.rb#737
  def client_thread; end

  # source://net-imap//lib/net/imap.rb#737
  def client_thread=(_arg0); end

  # Sends a {CLOSE command [IMAP4rev1 §6.4.2]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.2]
  # to close the currently selected mailbox.  The CLOSE command permanently
  # removes from the mailbox all messages that have the <tt>\\Deleted</tt>
  # flag set.
  #
  # Related: #unselect
  #
  # source://net-imap//lib/net/imap.rb#1513
  def close; end

  # Sends a {COPY command [IMAP4rev1 §6.4.7]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.7]
  # to copy the specified message(s) to the end of the specified destination
  # +mailbox+. The +set+ parameter is a number, an array of numbers, or a
  # Range object.  The number is a message sequence number.
  #
  # Related: #uid_copy
  #
  # ===== Capabilities
  #
  # If +UIDPLUS+ [RFC4315[https://www.rfc-editor.org/rfc/rfc4315.html]] is
  # supported, the server's response should include a +COPYUID+ response code
  # with UIDPlusData.  This will report the UIDVALIDITY of the destination
  # mailbox, the UID set of the source messages, and the assigned UID set of
  # the moved messages.
  #
  # source://net-imap//lib/net/imap.rb#1749
  def copy(set, mailbox); end

  # Sends a {CREATE command [IMAP4rev1 §6.3.3]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.3]
  # to create a new +mailbox+.
  #
  # A Net::IMAP::NoResponseError is raised if a mailbox with that name
  # cannot be created.
  #
  # Related: #rename, #delete
  #
  # source://net-imap//lib/net/imap.rb#1129
  def create(mailbox); end

  # Sends a {DELETE command [IMAP4rev1 §6.3.4]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.4]
  # to remove the +mailbox+.
  #
  # A Net::IMAP::NoResponseError is raised if a mailbox with that name
  # cannot be deleted, either because it does not exist or because the
  # client does not have permission to delete it.
  #
  # Related: #create, #rename
  #
  # source://net-imap//lib/net/imap.rb#1141
  def delete(mailbox); end

  # Disconnects from the server.
  #
  # Related: #logout
  #
  # source://net-imap//lib/net/imap.rb#768
  def disconnect; end

  # Returns true if disconnected from the server.
  #
  # Related: #logout, #disconnect
  #
  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap.rb#793
  def disconnected?; end

  # Sends a {EXAMINE command [IMAP4rev1 §6.3.2]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.2]
  # to select a +mailbox+ so that messages in the +mailbox+ can be accessed.
  # Behaves the same as #select, except that the selected +mailbox+ is
  # identified as read-only.
  #
  # A Net::IMAP::NoResponseError is raised if the mailbox does not
  # exist or is for some reason non-examinable.
  #
  # Related: #select
  #
  # source://net-imap//lib/net/imap.rb#1115
  def examine(mailbox); end

  # Sends an {EXPUNGE command [IMAP4rev1 §6.4.3]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.3]
  # Sends a EXPUNGE command to permanently remove from the currently
  # selected mailbox all messages that have the \Deleted flag set.
  #
  # Related: #uid_expunge
  #
  # source://net-imap//lib/net/imap.rb#1538
  def expunge; end

  # Sends a {FETCH command [IMAP4rev1 §6.4.5]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.5]
  # to retrieve data associated with a message in the mailbox.
  #
  # The +set+ parameter is a number or a range between two numbers,
  # or an array of those.  The number is a message sequence number,
  # where -1 represents a '*' for use in range notation like 100..-1
  # being interpreted as '100:*'.  Beware that the +exclude_end?+
  # property of a Range object is ignored, and the contents of a
  # range are independent of the order of the range endpoints as per
  # the protocol specification, so 1...5, 5..1 and 5...1 are all
  # equivalent to 1..5.
  #
  # +attr+ is a list of attributes to fetch; see the documentation
  # for FetchData for a list of valid attributes.
  #
  # The return value is an array of FetchData or nil
  # (instead of an empty array) if there is no matching message.
  #
  # Related: #uid_search, FetchData
  #
  # ===== For example:
  #
  #   p imap.fetch(6..8, "UID")
  #   #=> [#<Net::IMAP::FetchData seqno=6, attr={"UID"=>98}>, \\
  #        #<Net::IMAP::FetchData seqno=7, attr={"UID"=>99}>, \\
  #        #<Net::IMAP::FetchData seqno=8, attr={"UID"=>100}>]
  #   p imap.fetch(6, "BODY[HEADER.FIELDS (SUBJECT)]")
  #   #=> [#<Net::IMAP::FetchData seqno=6, attr={"BODY[HEADER.FIELDS (SUBJECT)]"=>"Subject: test\r\n\r\n"}>]
  #   data = imap.uid_fetch(98, ["RFC822.SIZE", "INTERNALDATE"])[0]
  #   p data.seqno
  #   #=> 6
  #   p data.attr["RFC822.SIZE"]
  #   #=> 611
  #   p data.attr["INTERNALDATE"]
  #   #=> "12-Oct-2000 22:40:59 +0900"
  #   p data.attr["UID"]
  #   #=> 98
  #
  # source://net-imap//lib/net/imap.rb#1681
  def fetch(set, attr, mod = T.unsafe(nil)); end

  # Sends a {GETACL command [RFC4314 §3.3]}[https://www.rfc-editor.org/rfc/rfc4314#section-3.3]
  # along with a specified +mailbox+.  If this mailbox exists, an array
  # containing objects of MailboxACLItem will be returned.
  #
  # Related: #setacl, MailboxACLItem
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +ACL+
  # [RFC4314[https://tools.ietf.org/html/rfc4314]].
  #
  # source://net-imap//lib/net/imap.rb#1410
  def getacl(mailbox); end

  # Sends a {GETQUOTA command [RFC2087 §4.2]}[https://www.rfc-editor.org/rfc/rfc2087#section-4.2]
  # along with specified +mailbox+.  If this mailbox exists, then an array
  # containing a MailboxQuota object is returned.  This command is generally
  # only available to server admin.
  #
  # Related: #getquotaroot, #setquota, MailboxQuota
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +QUOTA+
  # [RFC2087[https://tools.ietf.org/html/rfc2087]].
  #
  # source://net-imap//lib/net/imap.rb#1354
  def getquota(mailbox); end

  # Sends a {GETQUOTAROOT command [RFC2087 §4.3]}[https://www.rfc-editor.org/rfc/rfc2087#section-4.3]
  # along with the specified +mailbox+.  This command is generally available
  # to both admin and user.  If this mailbox exists, it returns an array
  # containing objects of type MailboxQuotaRoot and MailboxQuota.
  #
  # Related: #getquota, #setquota, MailboxQuotaRoot, MailboxQuota
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +QUOTA+
  # [RFC2087[https://tools.ietf.org/html/rfc2087]].
  #
  # source://net-imap//lib/net/imap.rb#1333
  def getquotaroot(mailbox); end

  # Returns the initial greeting the server, an UntaggedResponse.
  #
  # source://net-imap//lib/net/imap.rb#711
  def greeting; end

  # Sends an {ID command [RFC2971 §3.1]}[https://www.rfc-editor.org/rfc/rfc2971#section-3.1]
  # and returns a hash of the server's response, or nil if the server does not
  # identify itself.
  #
  # Note that the user should first check if the server supports the ID
  # capability. For example:
  #
  #    capabilities = imap.capability
  #    if capabilities.include?("ID")
  #      id = imap.id(
  #        name: "my IMAP client (ruby)",
  #        version: MyIMAP::VERSION,
  #        "support-url": "mailto:bugs@example.com",
  #        os: RbConfig::CONFIG["host_os"],
  #      )
  #    end
  #
  # See [ID[https://tools.ietf.org/html/rfc2971]] for field definitions.
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +ID+
  # [RFC2971[https://tools.ietf.org/html/rfc2971]]
  #
  # source://net-imap//lib/net/imap.rb#879
  def id(client_id = T.unsafe(nil)); end

  # Sends an {IDLE command [RFC2177 §3]}[https://www.rfc-editor.org/rfc/rfc6851#section-3]
  # {[IMAP4rev2 §6.3.13]}[https://www.rfc-editor.org/rfc/rfc9051#section-6.3.13]
  # that waits for notifications of new or expunged messages.  Yields
  # responses from the server during the IDLE.
  #
  # Use #idle_done to leave IDLE.
  #
  # If +timeout+ is given, this method returns after +timeout+ seconds passed.
  # +timeout+ can be used for keep-alive.  For example, the following code
  # checks the connection for each 60 seconds.
  #
  #   loop do
  #     imap.idle(60) do |res|
  #       ...
  #     end
  #   end
  #
  # Related: #idle_done, #noop, #check
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +IDLE+
  # [RFC2177[https://tools.ietf.org/html/rfc2177]].
  #
  # @raise [LocalJumpError]
  #
  # source://net-imap//lib/net/imap.rb#1910
  def idle(timeout = T.unsafe(nil), &response_handler); end

  # Leaves IDLE.
  #
  # Related: #idle
  #
  # source://net-imap//lib/net/imap.rb#1942
  def idle_done; end

  # Seconds to wait until an IDLE response is received.
  #
  # source://net-imap//lib/net/imap.rb#735
  def idle_response_timeout; end

  # Sends a {LIST command [IMAP4rev1 §6.3.8]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.8]
  # and returns a subset of names from the complete set of all names available
  # to the client.  +refname+ provides a context (for instance, a base
  # directory in a directory-based mailbox hierarchy).  +mailbox+ specifies a
  # mailbox or (via wildcards) mailboxes under that context.  Two wildcards
  # may be used in +mailbox+: '*', which matches all characters *including*
  # the hierarchy delimiter (for instance, '/' on a UNIX-hosted
  # directory-based mailbox hierarchy); and '%', which matches all characters
  # *except* the hierarchy delimiter.
  #
  # If +refname+ is empty, +mailbox+ is used directly to determine
  # which mailboxes to match.  If +mailbox+ is empty, the root
  # name of +refname+ and the hierarchy delimiter are returned.
  #
  # The return value is an array of MailboxList.
  #
  # Related: #lsub, MailboxList
  #
  # ===== For example:
  #
  #   imap.create("foo/bar")
  #   imap.create("foo/baz")
  #   p imap.list("", "foo/%")
  #   #=> [#<Net::IMAP::MailboxList attr=[:Noselect], delim="/", name="foo/">, \\
  #        #<Net::IMAP::MailboxList attr=[:Noinferiors, :Marked], delim="/", name="foo/bar">, \\
  #        #<Net::IMAP::MailboxList attr=[:Noinferiors], delim="/", name="foo/baz">]
  #
  # --
  # TODO: support LIST-EXTENDED extension [RFC5258].  Needed for IMAP4rev2.
  # ++
  #
  # source://net-imap//lib/net/imap.rb#1213
  def list(refname, mailbox); end

  # Sends a {LOGIN command [IMAP4rev1 §6.2.3]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.2.3]
  # to identify the client and carries the plaintext +password+ authenticating
  # this +user+.  If successful, the connection enters the "_authenticated_"
  # state.
  #
  # Using #authenticate is generally preferred over #login.  The LOGIN command
  # is not the same as #authenticate with the "LOGIN" +mechanism+.
  #
  # A Net::IMAP::NoResponseError is raised if authentication fails.
  #
  # Related: #authenticate, #starttls
  #
  # ==== Capabilities
  # Clients MUST NOT call #login if +LOGINDISABLED+ is listed with the
  # capabilities.
  #
  # Server capabilities may change after #starttls, #login, and #authenticate.
  # Cached capabilities _must_ be invalidated after this method completes.
  # The TaggedResponse to #login may include updated capabilities in its
  # ResponseCode.
  #
  # source://net-imap//lib/net/imap.rb#1073
  def login(user, password); end

  # Sends a {LOGOUT command [IMAP4rev1 §6.1.3]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.1.3]
  # to inform the command to inform the server that the client is done with
  # the connection.
  #
  # Related: #disconnect
  #
  # source://net-imap//lib/net/imap.rb#907
  def logout; end

  # Sends a {LSUB command [IMAP4rev1 §6.3.9]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.9]
  # and returns a subset of names from the set of names that the user has
  # declared as being "active" or "subscribed."  +refname+ and +mailbox+ are
  # interpreted as for #list.
  #
  # The return value is an array of MailboxList objects.
  #
  # Related: #subscribe, #unsubscribe, #list, MailboxList
  #
  # source://net-imap//lib/net/imap.rb#1425
  def lsub(refname, mailbox); end

  # Sends a {MOVE command [RFC6851 §3.1]}[https://www.rfc-editor.org/rfc/rfc6851#section-3.1]
  # {[IMAP4rev2 §6.4.8]}[https://www.rfc-editor.org/rfc/rfc9051#section-6.4.8]
  # to move the specified message(s) to the end of the specified destination
  # +mailbox+. The +set+ parameter is a number, an array of numbers, or a
  # Range object. The number is a message sequence number.
  #
  # Related: #uid_move
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +MOVE+
  # [RFC6851[https://tools.ietf.org/html/rfc6851]].
  #
  # If +UIDPLUS+ [RFC4315[https://www.rfc-editor.org/rfc/rfc4315.html]] is
  # supported, the server's response should include a +COPYUID+ response code
  # with UIDPlusData.  This will report the UIDVALIDITY of the destination
  # mailbox, the UID set of the source messages, and the assigned UID set of
  # the moved messages.
  #
  # source://net-imap//lib/net/imap.rb#1785
  def move(set, mailbox); end

  # Sends a {NAMESPACE command [RFC2342 §5]}[https://www.rfc-editor.org/rfc/rfc2342#section-5]
  # and returns the namespaces that are available.  The NAMESPACE command
  # allows a client to discover the prefixes of namespaces used by a server
  # for personal mailboxes, other users' mailboxes, and shared mailboxes.
  #
  # The return value is a Namespaces object which has +personal+, +other+, and
  # +shared+ fields, each an array of Namespace objects.  These arrays will be
  # empty when the server responds with +nil+.
  #
  # Many \IMAP servers are configured with the default personal namespaces as
  # <tt>("" "/")</tt>: no prefix and the "+/+" hierarchy delimiter. In that
  # common case, the naive client may not have any trouble naming mailboxes.
  # But many servers are configured with the default personal namespace as
  # e.g.  <tt>("INBOX." ".")</tt>, placing all personal folders under INBOX,
  # with "+.+" as the hierarchy delimiter. If the client does not check for
  # this, but naively assumes it can use the same folder names for all
  # servers, then folder creation (and listing, moving, etc) can lead to
  # errors.
  #
  # From RFC2342:
  #
  #    Although typically a server will support only a single Personal
  #    Namespace, and a single Other User's Namespace, circumstances exist
  #    where there MAY be multiples of these, and a client MUST be prepared
  #    for them.  If a client is configured such that it is required to create
  #    a certain mailbox, there can be circumstances where it is unclear which
  #    Personal Namespaces it should create the mailbox in.  In these
  #    situations a client SHOULD let the user select which namespaces to
  #    create the mailbox in.
  #
  # Related: #list, Namespaces, Namespace
  #
  # ===== For example:
  #
  #    capabilities = imap.capability
  #    if capabilities.include?("NAMESPACE")
  #      namespaces = imap.namespace
  #      if namespace = namespaces.personal.first
  #        prefix = namespace.prefix  # e.g. "" or "INBOX."
  #        delim  = namespace.delim   # e.g. "/" or "."
  #        # personal folders should use the prefix and delimiter
  #        imap.create(prefix + "foo")
  #        imap.create(prefix + "bar")
  #        imap.create(prefix + %w[path to my folder].join(delim))
  #      end
  #    end
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +NAMESPACE+
  # [RFC2342[https://tools.ietf.org/html/rfc2342]].
  #
  # source://net-imap//lib/net/imap.rb#1271
  def namespace; end

  # Sends a {NOOP command [IMAP4rev1 §6.1.2]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.1.2]
  # to the server.
  #
  # This allows the server to send unsolicited untagged EXPUNGE #responses,
  # but does not execute any client request.  \IMAP servers are permitted to
  # send unsolicited untagged responses at any time, except for `EXPUNGE`.
  #
  # * +EXPUNGE+ can only be sent while a command is in progress.
  # * +EXPUNGE+ must _not_ be sent during #fetch, #store, or #search.
  # * +EXPUNGE+ may be sent during #uid_fetch, #uid_store, or #uid_search.
  #
  # Related: #idle, #check
  #
  # source://net-imap//lib/net/imap.rb#898
  def noop; end

  # Seconds to wait until a connection is opened.
  # If the IMAP object cannot open a connection within this time,
  # it raises a Net::OpenTimeout exception. The default value is 30 seconds.
  #
  # source://net-imap//lib/net/imap.rb#732
  def open_timeout; end

  # Removes the response handler.
  #
  # source://net-imap//lib/net/imap.rb#1969
  def remove_response_handler(handler); end

  # Sends a {RENAME command [IMAP4rev1 §6.3.5]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.5]
  # to change the name of the +mailbox+ to +newname+.
  #
  # A Net::IMAP::NoResponseError is raised if a mailbox with the
  # name +mailbox+ cannot be renamed to +newname+ for whatever
  # reason; for instance, because +mailbox+ does not exist, or
  # because there is already a mailbox with the name +newname+.
  #
  # Related: #create, #delete
  #
  # source://net-imap//lib/net/imap.rb#1154
  def rename(mailbox, newname); end

  # Returns all response handlers.
  #
  # source://net-imap//lib/net/imap.rb#727
  def response_handlers; end

  # Returns a hash with arrays of unhandled <em>non-+nil+</em>
  # UntaggedResponse#data keyed by UntaggedResponse#name, and
  # ResponseCode#data keyed by ResponseCode#name.
  #
  # For example:
  #
  #   imap.select("inbox")
  #   p imap.responses["EXISTS"][-1]
  #   #=> 2
  #   p imap.responses["UIDVALIDITY"][-1]
  #   #=> 968263756
  #
  # source://net-imap//lib/net/imap.rb#724
  def responses; end

  # Sends a {SEARCH command [IMAP4rev1 §6.4.4]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.4]
  # to search the mailbox for messages that match the given searching
  # criteria, and returns message sequence numbers.  +keys+ can either be a
  # string holding the entire search string, or a single-dimension array of
  # search keywords and arguments.
  #
  # Related: #uid_search
  #
  # ===== Search criteria
  #
  # For a full list of search criteria,
  # see [{IMAP4rev1 §6.4.4}[https://www.rfc-editor.org/rfc/rfc3501.html#section-6.4.4]],
  # or  [{IMAP4rev2 §6.4.4}[https://www.rfc-editor.org/rfc/rfc9051.html#section-6.4.4]],
  # in addition to documentation for
  # any [CAPABILITIES[https://www.iana.org/assignments/imap-capabilities/imap-capabilities.xhtml]]
  # reported by #capability which may define additional search filters, e.g:
  # +CONDSTORE+, +WITHIN+, +FILTERS+, <tt>SEARCH=FUZZY</tt>, +OBJECTID+, or
  # +SAVEDATE+.  The following are some common search criteria:
  #
  # <message set>:: a set of message sequence numbers.  "<tt>,</tt>" indicates
  #                 an interval, "+:+" indicates a range.  For instance,
  #                 "<tt>2,10:12,15</tt>" means "<tt>2,10,11,12,15</tt>".
  #
  # BEFORE <date>:: messages with an internal date strictly before
  #                 <b><date></b>.  The date argument has a format similar
  #                 to <tt>8-Aug-2002</tt>, and can be formatted using
  #                 Net::IMAP.format_date.
  #
  # BODY <string>:: messages that contain <string> within their body.
  #
  # CC <string>:: messages containing <string> in their CC field.
  #
  # FROM <string>:: messages that contain <string> in their FROM field.
  #
  # NEW:: messages with the \Recent, but not the \Seen, flag set.
  #
  # NOT <search-key>:: negate the following search key.
  #
  # OR <search-key> <search-key>:: "or" two search keys together.
  #
  # ON <date>:: messages with an internal date exactly equal to <date>,
  #             which has a format similar to 8-Aug-2002.
  #
  # SINCE <date>:: messages with an internal date on or after <date>.
  #
  # SUBJECT <string>:: messages with <string> in their subject.
  #
  # TO <string>:: messages with <string> in their TO field.
  #
  # ===== For example:
  #
  #   p imap.search(["SUBJECT", "hello", "NOT", "NEW"])
  #   #=> [1, 6, 7, 8]
  #
  # source://net-imap//lib/net/imap.rb#1631
  def search(keys, charset = T.unsafe(nil)); end

  # Sends a {SELECT command [IMAP4rev1 §6.3.1]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.1]
  # to select a +mailbox+ so that messages in the +mailbox+ can be accessed.
  #
  # After you have selected a mailbox, you may retrieve the number of items in
  # that mailbox from <tt>imap.responses["EXISTS"][-1]</tt>, and the number of
  # recent messages from <tt>imap.responses["RECENT"][-1]</tt>.  Note that
  # these values can change if new messages arrive during a session or when
  # existing messages are expunged; see #add_response_handler for a way to
  # detect these events.
  #
  # A Net::IMAP::NoResponseError is raised if the mailbox does not
  # exist or is for some reason non-selectable.
  #
  # Related: #examine
  #
  # ===== Capabilities
  #
  # If [UIDPLUS[https://www.rfc-editor.org/rfc/rfc4315.html]] is supported,
  # the server may return an untagged "NO" response with a "UIDNOTSTICKY"
  # response code indicating that the mailstore does not support persistent
  # UIDs:
  #   @responses["NO"].last.code.name == "UIDNOTSTICKY"
  #
  # source://net-imap//lib/net/imap.rb#1099
  def select(mailbox); end

  # Sends a {SETACL command [RFC4314 §3.1]}[https://www.rfc-editor.org/rfc/rfc4314#section-3.1]
  # along with +mailbox+, +user+ and the +rights+ that user is to have on that
  # mailbox.  If +rights+ is nil, then that user will be stripped of any
  # rights to that mailbox.
  #
  # Related: #getacl
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +ACL+
  # [RFC4314[https://tools.ietf.org/html/rfc4314]].
  #
  # source://net-imap//lib/net/imap.rb#1392
  def setacl(mailbox, user, rights); end

  # Sends a {SETQUOTA command [RFC2087 §4.1]}[https://www.rfc-editor.org/rfc/rfc2087#section-4.1]
  # along with the specified +mailbox+ and +quota+.  If +quota+ is nil, then
  # +quota+ will be unset for that mailbox.  Typically one needs to be logged
  # in as a server admin for this to work.
  #
  # Related: #getquota, #getquotaroot
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +QUOTA+
  # [RFC2087[https://tools.ietf.org/html/rfc2087]].
  #
  # source://net-imap//lib/net/imap.rb#1372
  def setquota(mailbox, quota); end

  # Sends a {SORT command [RFC5256 §3]}[https://www.rfc-editor.org/rfc/rfc5256#section-3]
  # to search a mailbox for messages that match +search_keys+ and return an
  # array of message sequence numbers, sorted by +sort_keys+.  +search_keys+
  # are interpreted the same as for #search.
  #
  # --
  # TODO: describe +sort_keys+
  # ++
  #
  # Related: #uid_sort, #search, #uid_search, #thread, #uid_thread
  #
  # ===== For example:
  #
  #   p imap.sort(["FROM"], ["ALL"], "US-ASCII")
  #   #=> [1, 2, 3, 5, 6, 7, 8, 4, 9]
  #   p imap.sort(["DATE"], ["SUBJECT", "hello"], "US-ASCII")
  #   #=> [6, 7, 8, 1]
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +SORT+
  # [RFC5256[https://tools.ietf.org/html/rfc5256]].
  #
  # source://net-imap//lib/net/imap.rb#1829
  def sort(sort_keys, search_keys, charset); end

  # Sends a {STARTTLS command [IMAP4rev1 §6.2.1]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.2.1]
  # to start a TLS session.
  #
  # Any +options+ are forwarded to OpenSSL::SSL::SSLContext#set_params.
  #
  # This method returns after TLS negotiation and hostname verification are
  # both successful.  Any error indicates that the connection has not been
  # secured.
  #
  # *Note:*
  # >>>
  #   Any #response_handlers added before STARTTLS should be aware that the
  #   TaggedResponse to STARTTLS is sent clear-text, _before_ TLS negotiation.
  #   TLS negotiation starts immediately after that response.
  #
  # Related: Net::IMAP.new, #login, #authenticate
  #
  # ===== Capability
  #
  # The server's capabilities must include +STARTTLS+.
  #
  # Server capabilities may change after #starttls, #login, and #authenticate.
  # Cached capabilities _must_ be invalidated after this method completes.
  #
  # The TaggedResponse to #starttls is sent clear-text, so the server <em>must
  # *not*</em> send capabilities in the #starttls response and clients <em>must
  # not</em> use them if they are sent.  Servers will generally send an
  # unsolicited untagged response immeditely _after_ #starttls completes.
  #
  # source://net-imap//lib/net/imap.rb#940
  def starttls(options = T.unsafe(nil), verify = T.unsafe(nil)); end

  # Sends a {STATUS commands [IMAP4rev1 §6.3.10]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.10]
  # and returns the status of the indicated +mailbox+. +attr+ is a list of one
  # or more attributes whose statuses are to be requested.  Supported
  # attributes include:
  #
  #   MESSAGES:: the number of messages in the mailbox.
  #   RECENT:: the number of recent messages in the mailbox.
  #   UNSEEN:: the number of unseen messages in the mailbox.
  #
  # The return value is a hash of attributes. For example:
  #
  #   p imap.status("inbox", ["MESSAGES", "RECENT"])
  #   #=> {"RECENT"=>0, "MESSAGES"=>44}
  #
  # A Net::IMAP::NoResponseError is raised if status values
  # for +mailbox+ cannot be returned; for instance, because it
  # does not exist.
  #
  # source://net-imap//lib/net/imap.rb#1449
  def status(mailbox, attr); end

  # Sends a {STORE command [IMAP4rev1 §6.4.6]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.6]
  # to alter data associated with messages in the mailbox, in particular their
  # flags. The +set+ parameter is a number, an array of numbers, or a Range
  # object. Each number is a message sequence number.  +attr+ is the name of a
  # data item to store: 'FLAGS' will replace the message's flag list with the
  # provided one, '+FLAGS' will add the provided flags, and '-FLAGS' will
  # remove them.  +flags+ is a list of flags.
  #
  # The return value is an array of FetchData
  #
  # Related: #uid_store
  #
  # ===== For example:
  #
  #   p imap.store(6..8, "+FLAGS", [:Deleted])
  #   #=> [#<Net::IMAP::FetchData seqno=6, attr={"FLAGS"=>[:Seen, :Deleted]}>, \\
  #        #<Net::IMAP::FetchData seqno=7, attr={"FLAGS"=>[:Seen, :Deleted]}>, \\
  #        #<Net::IMAP::FetchData seqno=8, attr={"FLAGS"=>[:Seen, :Deleted]}>]
  #
  # source://net-imap//lib/net/imap.rb#1719
  def store(set, attr, flags); end

  # Sends a {SUBSCRIBE command [IMAP4rev1 §6.3.6]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.6]
  # to add the specified +mailbox+ name to the server's set of "active" or
  # "subscribed" mailboxes as returned by #lsub.
  #
  # A Net::IMAP::NoResponseError is raised if +mailbox+ cannot be
  # subscribed to; for instance, because it does not exist.
  #
  # Related: #unsubscribe, #lsub, #list
  #
  # source://net-imap//lib/net/imap.rb#1166
  def subscribe(mailbox); end

  # Sends a {THREAD command [RFC5256 §3]}[https://www.rfc-editor.org/rfc/rfc5256#section-3]
  # to search a mailbox and return message sequence numbers in threaded
  # format, as a ThreadMember tree.  +search_keys+ are interpreted the same as
  # for #search.
  #
  # The supported algorithms are:
  #
  # ORDEREDSUBJECT:: split into single-level threads according to subject,
  #                  ordered by date.
  # REFERENCES:: split into threads by parent/child relationships determined
  #              by which message is a reply to which.
  #
  # Unlike #search, +charset+ is a required argument.  US-ASCII
  # and UTF-8 are sample values.
  #
  # Related: #uid_thread, #search, #uid_search, #sort, #uid_sort
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +THREAD+
  # [RFC5256[https://tools.ietf.org/html/rfc5256]].
  #
  # source://net-imap//lib/net/imap.rb#1869
  def thread(algorithm, search_keys, charset); end

  # Sends a {UID COPY command [IMAP4rev1 §6.4.8]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.8]
  # to copy the specified message(s) to the end of the specified destination
  # +mailbox+.
  #
  # Similar to #copy, but +set+ contains unique identifiers.
  #
  # ===== Capabilities
  #
  # +UIDPLUS+ affects #uid_copy the same way it affects #copy.
  #
  # source://net-imap//lib/net/imap.rb#1762
  def uid_copy(set, mailbox); end

  # Sends a {UID EXPUNGE command [RFC4315 §2.1]}[https://www.rfc-editor.org/rfc/rfc4315#section-2.1]
  # {[IMAP4rev2 §6.4.9]}[https://www.rfc-editor.org/rfc/rfc9051#section-6.4.9]
  # to permanently remove all messages that have both the <tt>\\Deleted</tt>
  # flag set and a UID that is included in +uid_set+.
  #
  # By using #uid_expunge instead of #expunge when resynchronizing with
  # the server, the client can ensure that it does not inadvertantly
  # remove any messages that have been marked as <tt>\\Deleted</tt> by other
  # clients between the time that the client was last connected and
  # the time the client resynchronizes.
  #
  # *Note:*
  # >>>
  #        Although the command takes a set of UIDs for its argument, the
  #        server still returns regular EXPUNGE responses, which contain
  #        a <em>sequence number</em>. These will be deleted from
  #        #responses and this method returns them as an array of
  #        <em>sequence number</em> integers.
  #
  # Related: #expunge
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +UIDPLUS+
  # [RFC4315[https://www.rfc-editor.org/rfc/rfc4315.html]].
  #
  # source://net-imap//lib/net/imap.rb#1570
  def uid_expunge(uid_set); end

  # Sends a {UID FETCH command [IMAP4rev1 §6.4.8]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.8]
  # to retrieve data associated with a message in the mailbox.
  #
  # Similar to #fetch, but the +set+ parameter contains unique identifiers
  # instead of message sequence numbers.
  #
  # >>>
  #   *Note:* Servers _MUST_ implicitly include the +UID+ message data item as
  #   part of any +FETCH+ response caused by a +UID+ command, regardless of
  #   whether a +UID+ was specified as a message data item to the +FETCH+.
  #
  # Related: #fetch, FetchData
  #
  # source://net-imap//lib/net/imap.rb#1697
  def uid_fetch(set, attr, mod = T.unsafe(nil)); end

  # Sends a {UID MOVE command [RFC6851 §3.2]}[https://www.rfc-editor.org/rfc/rfc6851#section-3.2]
  # {[IMAP4rev2 §6.4.9]}[https://www.rfc-editor.org/rfc/rfc9051#section-6.4.9]
  # to move the specified message(s) to the end of the specified destination
  # +mailbox+.
  #
  # Similar to #move, but +set+ contains unique identifiers.
  #
  # Related: #move
  #
  # ===== Capabilities
  #
  # Same as #move: The server's capabilities must include +MOVE+
  # [RFC6851[https://tools.ietf.org/html/rfc6851]].  +UIDPLUS+ also affects
  # #uid_move the same way it affects #move.
  #
  # source://net-imap//lib/net/imap.rb#1803
  def uid_move(set, mailbox); end

  # Sends a {UID SEARCH command [IMAP4rev1 §6.4.8]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.8]
  # to search the mailbox for messages that match the given searching
  # criteria, and returns unique identifiers (<tt>UID</tt>s).
  #
  # See #search for documentation of search criteria.
  #
  # source://net-imap//lib/net/imap.rb#1640
  def uid_search(keys, charset = T.unsafe(nil)); end

  # Sends a {UID SORT command [RFC5256 §3]}[https://www.rfc-editor.org/rfc/rfc5256#section-3]
  # to search a mailbox for messages that match +search_keys+ and return an
  # array of unique identifiers, sorted by +sort_keys+.  +search_keys+ are
  # interpreted the same as for #search.
  #
  # Related: #sort, #search, #uid_search, #thread, #uid_thread
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +SORT+
  # [RFC5256[https://tools.ietf.org/html/rfc5256]].
  #
  # source://net-imap//lib/net/imap.rb#1844
  def uid_sort(sort_keys, search_keys, charset); end

  # Sends a {UID STORE command [IMAP4rev1 §6.4.8]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.4.8]
  # to alter data associated with messages in the mailbox, in particular their
  # flags.
  #
  # Similar to #store, but +set+ contains unique identifiers instead of
  # message sequence numbers.
  #
  # Related: #store
  #
  # source://net-imap//lib/net/imap.rb#1731
  def uid_store(set, attr, flags); end

  # Sends a {UID THREAD command [RFC5256 §3]}[https://www.rfc-editor.org/rfc/rfc5256#section-3]
  # Similar to #thread, but returns unique identifiers instead of
  # message sequence numbers.
  #
  # Related: #thread, #search, #uid_search, #sort, #uid_sort
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +THREAD+
  # [RFC5256[https://tools.ietf.org/html/rfc5256]].
  #
  # source://net-imap//lib/net/imap.rb#1883
  def uid_thread(algorithm, search_keys, charset); end

  # Sends an {UNSELECT command [RFC3691 §2]}[https://www.rfc-editor.org/rfc/rfc3691#section-3]
  # {[IMAP4rev2 §6.4.2]}[https://www.rfc-editor.org/rfc/rfc9051#section-6.4.2]
  # to free the session resources for a mailbox and return to the
  # "_authenticated_" state.  This is the same as #close, except that
  # <tt>\\Deleted</tt> messages are not removed from the mailbox.
  #
  # Related: #close
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +UNSELECT+
  # [RFC3691[https://tools.ietf.org/html/rfc3691]].
  #
  # source://net-imap//lib/net/imap.rb#1529
  def unselect; end

  # Sends an {UNSUBSCRIBE command [IMAP4rev1 §6.3.7]}[https://www.rfc-editor.org/rfc/rfc3501#section-6.3.7]
  # to remove the specified +mailbox+ name from the server's set of "active"
  # or "subscribed" mailboxes.
  #
  # A Net::IMAP::NoResponseError is raised if +mailbox+ cannot be
  # unsubscribed from; for instance, because the client is not currently
  # subscribed to it.
  #
  # Related: #subscribe, #lsub, #list
  #
  # source://net-imap//lib/net/imap.rb#1179
  def unsubscribe(mailbox); end

  # Sends a XLIST command, and returns a subset of names from
  # the complete set of all names available to the client.
  # +refname+ provides a context (for instance, a base directory
  # in a directory-based mailbox hierarchy).  +mailbox+ specifies
  # a mailbox or (via wildcards) mailboxes under that context.
  # Two wildcards may be used in +mailbox+: '*', which matches
  # all characters *including* the hierarchy delimiter (for instance,
  # '/' on a UNIX-hosted directory-based mailbox hierarchy); and '%',
  # which matches all characters *except* the hierarchy delimiter.
  #
  # If +refname+ is empty, +mailbox+ is used directly to determine
  # which mailboxes to match.  If +mailbox+ is empty, the root
  # name of +refname+ and the hierarchy delimiter are returned.
  #
  # The XLIST command is like the LIST command except that the flags
  # returned refer to the function of the folder/mailbox, e.g. :Sent
  #
  # The return value is an array of MailboxList objects. For example:
  #
  #   imap.create("foo/bar")
  #   imap.create("foo/baz")
  #   p imap.xlist("", "foo/%")
  #   #=> [#<Net::IMAP::MailboxList attr=[:Noselect], delim="/", name="foo/">, \\
  #        #<Net::IMAP::MailboxList attr=[:Noinferiors, :Marked], delim="/", name="foo/bar">, \\
  #        #<Net::IMAP::MailboxList attr=[:Noinferiors], delim="/", name="foo/baz">]
  #
  # Related: #list, MailboxList
  #
  # ===== Capabilities
  #
  # The server's capabilities must include +XLIST+,
  # a deprecated Gmail extension (replaced by +SPECIAL-USE+).
  # --
  # TODO: Net::IMAP doesn't yet have full SPECIAL-USE support.  Supporting
  # servers MAY return SPECIAL-USE attributes, but are not *required* to
  # unless the SPECIAL-USE return option is supplied.
  # ++
  #
  # source://net-imap//lib/net/imap.rb#1315
  def xlist(refname, mailbox); end

  private

  # source://net-imap//lib/net/imap.rb#2301
  def copy_internal(cmd, set, mailbox); end

  # source://net-imap//lib/net/imap.rb#2340
  def create_ssl_params(certs = T.unsafe(nil), verify = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap.rb#2269
  def fetch_internal(cmd, set, attr, mod = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap.rb#2233
  def generate_tag; end

  # source://net-imap//lib/net/imap.rb#2178
  def get_response; end

  # source://net-imap//lib/net/imap.rb#2151
  def get_tagged_response(tag, cmd, timeout = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap.rb#2329
  def normalize_searching_criteria(keys); end

  # source://net-imap//lib/net/imap.rb#2238
  def put_string(str); end

  # source://net-imap//lib/net/imap.rb#2080
  def receive_responses; end

  # source://net-imap//lib/net/imap.rb#2198
  def record_response(name, data); end

  # source://net-imap//lib/net/imap.rb#2253
  def search_internal(cmd, keys, charset); end

  # source://net-imap//lib/net/imap.rb#2205
  def send_command(cmd, *args, &block); end

  # source://net-imap//lib/net/imap/command_data.rb#33
  def send_data(data, tag = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap/command_data.rb#108
  def send_date_data(date); end

  # source://net-imap//lib/net/imap/command_data.rb#94
  def send_list_data(list, tag = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap/command_data.rb#73
  def send_literal(str, tag = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap/command_data.rb#90
  def send_number_data(num); end

  # source://net-imap//lib/net/imap/command_data.rb#69
  def send_quoted_string(str); end

  # source://net-imap//lib/net/imap/command_data.rb#54
  def send_string_data(str, tag = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap/command_data.rb#111
  def send_symbol_data(symbol); end

  # source://net-imap//lib/net/imap/command_data.rb#109
  def send_time_data(time); end

  # source://net-imap//lib/net/imap.rb#2305
  def sort_internal(cmd, sort_keys, search_keys, charset); end

  # source://net-imap//lib/net/imap.rb#2357
  def start_tls_session(params = T.unsafe(nil)); end

  # source://net-imap//lib/net/imap.rb#2290
  def store_internal(cmd, set, attr, flags); end

  # source://net-imap//lib/net/imap.rb#2071
  def tcp_socket(host, port); end

  # source://net-imap//lib/net/imap.rb#2318
  def thread_internal(cmd, algorithm, search_keys, charset); end

  # source://net-imap//lib/net/imap/command_data.rb#12
  def validate_data(data); end

  class << self
    # Returns the debug mode.
    #
    # source://net-imap//lib/net/imap.rb#740
    def debug; end

    # Sets the debug mode.
    #
    # source://net-imap//lib/net/imap.rb#745
    def debug=(val); end

    # :call-seq: decode_date(string) -> Date
    #
    # Decodes +string+ as an IMAP formatted "date".
    #
    # Double quotes are optional.  Day of month may be padded with zero or
    # space.  See STRFDATE.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#89
    def decode_date(string); end

    # :call-seq: decode_datetime(string) -> DateTime
    #
    # Decodes +string+ as an IMAP4 formatted "date-time".
    #
    # Note that double quotes are not optional.  See STRFTIME.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#106
    def decode_datetime(string); end

    # :call-seq: decode_time(string) -> Time
    #
    # Decodes +string+ as an IMAP4 formatted "date-time".
    #
    # Same as +decode_datetime+, but returning a Time instead.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#115
    def decode_time(string); end

    # Decode a string from modified UTF-7 format to UTF-8.
    #
    # UTF-7 is a 7-bit encoding of Unicode [UTF7].  IMAP uses a
    # slightly modified version of this to encode mailbox names
    # containing non-ASCII characters; see [IMAP] section 5.1.3.
    #
    # Net::IMAP does _not_ automatically encode and decode
    # mailbox names to and from UTF-7.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#56
    def decode_utf7(s); end

    # The default port for IMAP connections, port 143
    #
    # source://net-imap//lib/net/imap.rb#750
    def default_imap_port; end

    # The default port for IMAPS connections, port 993
    #
    # source://net-imap//lib/net/imap.rb#755
    def default_imaps_port; end

    # The default port for IMAP connections, port 143
    #
    # source://net-imap//lib/net/imap.rb#750
    def default_port; end

    # The default port for IMAPS connections, port 993
    #
    # source://net-imap//lib/net/imap.rb#755
    def default_ssl_port; end

    # The default port for IMAPS connections, port 993
    #
    # source://net-imap//lib/net/imap.rb#755
    def default_tls_port; end

    # Formats +time+ as an IMAP4 date.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#79
    def encode_date(date); end

    # :call-seq: encode_datetime(time) -> string
    #
    # Formats +time+ as an IMAP4 date-time.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#97
    def encode_datetime(time); end

    # :call-seq: encode_datetime(time) -> string
    #
    # Formats +time+ as an IMAP4 date-time.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#97
    def encode_time(time); end

    # Encode a string from UTF-8 format to modified UTF-7.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#67
    def encode_utf7(s); end

    # Formats +time+ as an IMAP4 date.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#79
    def format_date(date); end

    # DEPRECATED:: The original version returned incorrectly formatted strings.
    #              Strings returned by encode_datetime or format_time use the
    #              correct IMAP4rev1 syntax for "date-time".
    #
    # This invalid format has been temporarily retained for backward
    # compatibility.  A future release will change this method to return the
    # correct format.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#137
    def format_datetime(time); end

    # :call-seq: encode_datetime(time) -> string
    #
    # Formats +time+ as an IMAP4 date-time.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#97
    def format_time(time); end

    # :call-seq: decode_date(string) -> Date
    #
    # Decodes +string+ as an IMAP formatted "date".
    #
    # Double quotes are optional.  Day of month may be padded with zero or
    # space.  See STRFDATE.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#89
    def parse_date(string); end

    # :call-seq: decode_datetime(string) -> DateTime
    #
    # Decodes +string+ as an IMAP4 formatted "date-time".
    #
    # Note that double quotes are not optional.  See STRFTIME.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#106
    def parse_datetime(string); end

    # :call-seq: decode_time(string) -> Time
    #
    # Decodes +string+ as an IMAP4 formatted "date-time".
    #
    # Same as +decode_datetime+, but returning a Time instead.
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#115
    def parse_time(string); end
  end
end

# Mailbox attribute indicating that this mailbox presents all messages in
# the user's message store. Implementations MAY omit some messages, such as,
# perhaps, those in \Trash and \Junk. When this special use is supported, it
# is almost certain to represent a virtual mailbox
#
# source://net-imap//lib/net/imap/flags.rb#218
Net::IMAP::ALL = T.let(T.unsafe(nil), Symbol)

# Mailbox attribute indicating that this mailbox is used to archive
# messages. The meaning of an "archival" mailbox is server dependent;
# typically, it will be used to get messages out of the inbox, or otherwise
# keep them out of the user's way, while still making them accessible
#
# source://net-imap//lib/net/imap/flags.rb#224
Net::IMAP::ARCHIVE = T.let(T.unsafe(nil), Symbol)

# source://net-imap//lib/net/imap/command_data.rb#130
class Net::IMAP::Atom
  # @return [Atom] a new instance of Atom
  #
  # source://net-imap//lib/net/imap/command_data.rb#140
  def initialize(data); end

  # source://net-imap//lib/net/imap/command_data.rb#131
  def send_data(imap, tag); end

  # source://net-imap//lib/net/imap/command_data.rb#135
  def validate; end
end

# Registry for SASL authenticators used by Net::IMAP.
#
# source://net-imap//lib/net/imap/authenticators.rb#4
module Net::IMAP::Authenticators
  # Adds an authenticator for Net::IMAP#authenticate to use.  +mechanism+ is the
  # {SASL mechanism}[https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml]
  # implemented by +authenticator+ (for instance, <tt>"PLAIN"</tt>).
  #
  # The +authenticator+ must respond to +#new+ (or #call), receiving the
  # authenticator configuration and return a configured authentication session.
  # The authenticator session must respond to +#process+, receiving the server's
  # challenge and returning the client's response.
  #
  # See PlainAuthenticator, XOauth2Authenticator, and DigestMD5Authenticator for
  # examples.
  #
  # source://net-imap//lib/net/imap/authenticators.rb#17
  def add_authenticator(auth_type, authenticator); end

  # :call-seq:
  #   authenticator(mechanism, ...)                            -> authenticator
  #   authenticator(mech, *creds, **props) {|prop, auth| val } -> authenticator
  #   authenticator(mechanism, authnid, creds, authzid=nil)    -> authenticator
  #   authenticator(mechanism, **properties)                   -> authenticator
  #   authenticator(mechanism) {|propname, authctx| value }    -> authenticator
  #
  # Builds a new authentication session context for +mechanism+.
  #
  # [Note]
  #   This method is intended for internal use by connection protocol code only.
  #   Protocol client users should see refer to their client's documentation,
  #   e.g. Net::IMAP#authenticate for Net::IMAP.
  #
  # The call signatures documented for this method are recommendations for
  # authenticator implementors.  All arguments (other than +mechanism+) are
  # forwarded to the registered authenticator's +#new+ (or +#call+) method, and
  # each authenticator must document its own arguments.
  #
  # The returned object represents a single authentication exchange and <em>must
  # not</em> be reused for multiple authentication attempts.
  #
  # source://net-imap//lib/net/imap/authenticators.rb#42
  def authenticator(mechanism, *authargs, **properties, &callback); end

  private

  # source://net-imap//lib/net/imap/authenticators.rb#55
  def authenticators; end
end

# Net::IMAP::BodyStructure is included by all of the structs that can be
# returned from a <tt>"BODYSTRUCTURE"</tt> or <tt>"BODY"</tt>
# FetchData#attr value.  Although these classes don't share a base class,
# this module can be used to pattern match all of them.
#
# See {[IMAP4rev1] §7.4.2}[https://www.rfc-editor.org/rfc/rfc3501.html#section-7.4.2]
# and {[IMAP4rev2] §7.5.2}[https://www.rfc-editor.org/rfc/rfc9051.html#section-7.5.2-4.9]
# for full description of all +BODYSTRUCTURE+ fields, and also
# Net::IMAP@Message+envelope+and+body+structure for other relevant RFCs.
#
# === Classes that include BodyStructure
# BodyTypeBasic:: Represents any message parts that are not handled by
#                 BodyTypeText, BodyTypeMessage, or BodyTypeMultipart.
# BodyTypeText:: Used by <tt>text/*</tt> parts.  Contains all of the
#                BodyTypeBasic fields.
# BodyTypeMessage:: Used by <tt>message/rfc822</tt> and
#                   <tt>message/global</tt> parts.  Contains all of the
#                   BodyTypeBasic fields.  Other <tt>message/*</tt> types
#                   should use BodyTypeBasic.
# BodyTypeMultipart:: for <tt>multipart/*</tt> parts
#
# ==== Deprecated BodyStructure classes
# The following classes represent invalid server responses or parser bugs:
# BodyTypeExtension:: parser bug: used for <tt>message/*</tt> where
#                     BodyTypeBasic should have been used.
# BodyTypeAttachment:: server bug: some servers sometimes return the
#                      "Content-Disposition: attachment" data where the
#                      entire body structure for a message part is expected.
#
# source://net-imap//lib/net/imap/response_data.rb#901
module Net::IMAP::BodyStructure; end

# === WARNING
# BodyTypeAttachment represents a <tt>body-fld-dsp</tt> that is
# incorrectly in a position where the IMAP4rev1 grammar expects a nested
# +body+ structure.
#
# >>>
#   \IMAP body structures are parenthesized lists and assign their fields
#   positionally, so missing fields change the intepretation of all
#   following fields.  Buggy \IMAP servers sometimes leave fields missing
#   rather than empty, which inevitably confuses parsers.
#   BodyTypeAttachment was an attempt to parse a common type of buggy body
#   structure without crashing.
#
#   Currently, when Net::IMAP::ResponseParser sees "attachment" as the first
#   entry in a <tt>body-type-1part</tt>, which is where the MIME type should
#   be, it uses BodyTypeAttachment to capture the rest.  "attachment" is not
#   a valid MIME type, but _is_ a common <tt>Content-Disposition</tt>.  What
#   might have happened was that buggy server could not parse the message
#   (which might have been incorrectly formatted) and output a
#   <tt>body-type-dsp</tt> where a Net::IMAP::ResponseParser expected to see
#   a +body+.
#
# A future release will replace this, probably with a ContentDisposition
# nested inside another body structure object, maybe BodyTypeBasic, or
# perhaps a new body structure class that represents any unparsable body
# structure.
#
# source://net-imap//lib/net/imap/response_data.rb#1156
class Net::IMAP::BodyTypeAttachment < ::Struct
  include ::Net::IMAP::BodyStructure

  # *invalid for BodyTypeAttachment*
  #
  # source://net-imap//lib/net/imap/response_data.rb#1160
  def media_type; end

  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap/response_data.rb#1188
  def multipart?; end

  # *invalid for BodyTypeAttachment*
  #
  # source://net-imap//lib/net/imap/response_data.rb#1168
  def subtype; end
end

# Net::IMAP::BodyTypeBasic represents basic body structures of messages and
# message parts, unless they have a <tt>Content-Type</tt> that is handled by
# BodyTypeText, BodyTypeMessage, or BodyTypeMultipart.
#
# See {[IMAP4rev1] §7.4.2}[https://www.rfc-editor.org/rfc/rfc3501.html#section-7.4.2]
# and {[IMAP4rev2] §7.5.2}[https://www.rfc-editor.org/rfc/rfc9051.html#section-7.5.2-4.9]
# for full description of all +BODYSTRUCTURE+ fields, and also
# Net::IMAP@Message+envelope+and+body+structure for other relevant RFCs.
#
# source://net-imap//lib/net/imap/response_data.rb#917
class Net::IMAP::BodyTypeBasic < ::Struct
  include ::Net::IMAP::BodyStructure

  # :call-seq: media_subtype -> subtype
  #
  # >>>
  #   [Obsolete]
  #     Use +subtype+ instead.  Calling this will generate a warning message
  #     to +stderr+, then return the value of +subtype+.
  # --
  # TODO: why not just keep this as an alias?  Would "media_subtype" be used
  # for something else?
  # ++
  #
  # source://net-imap//lib/net/imap/response_data.rb#1028
  def media_subtype; end

  # :call-seq: multipart? -> false
  #
  # BodyTypeBasic is not used for multipart MIME parts.
  #
  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap/response_data.rb#1014
  def multipart?; end
end

# === WARNING:
# >>>
#   BodyTypeExtension is (incorrectly) used for <tt>message/*</tt> parts
#   (besides <tt>message/rfc822</tt>, which correctly uses BodyTypeMessage).
#
# A future release will replace this class with:
# * BodyTypeMessage for <tt>message/rfc822</tt> and <tt>message/global</tt>
# * BodyTypeBasic for any other <tt>message/*</tt>
#
# source://net-imap//lib/net/imap/response_data.rb#1278
class Net::IMAP::BodyTypeExtension < ::Struct
  include ::Net::IMAP::BodyStructure

  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap/response_data.rb#1281
  def multipart?; end
end

# Net::IMAP::BodyTypeMessage represents the body structures of messages and
# message parts, when <tt>Content-Type</tt> is <tt>message/rfc822</tt> or
# <tt>message/global</tt>.
#
# BodyTypeMessage contains all of the fields of BodyTypeBasic.  See
# BodyTypeBasic for documentation of the following fields:
# * {media_type}[rdoc-ref:BodyTypeBasic#media_type]
# * subtype[rdoc-ref:BodyTypeBasic#subtype]
# * param[rdoc-ref:BodyTypeBasic#param]
# * {content_id}[rdoc-ref:BodyTypeBasic#content_id]
# * description[rdoc-ref:BodyTypeBasic#description]
# * encoding[rdoc-ref:BodyTypeBasic#encoding]
# * size[rdoc-ref:BodyTypeBasic#size]
#
# source://net-imap//lib/net/imap/response_data.rb#1097
class Net::IMAP::BodyTypeMessage < ::Struct
  include ::Net::IMAP::BodyStructure

  # Obsolete: use +subtype+ instead.  Calling this will
  # generate a warning message to +stderr+, then return
  # the value of +subtype+.
  #
  # source://net-imap//lib/net/imap/response_data.rb#1123
  def media_subtype; end

  # :call-seq: multipart? -> false
  #
  # BodyTypeMessage is not used for multipart MIME parts.
  #
  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap/response_data.rb#1116
  def multipart?; end
end

# Net::IMAP::BodyTypeMultipart represents body structures of messages and
# message parts, when <tt>Content-Type</tt> is <tt>multipart/*</tt>.
#
# source://net-imap//lib/net/imap/response_data.rb#1198
class Net::IMAP::BodyTypeMultipart < ::Struct
  include ::Net::IMAP::BodyStructure

  # Obsolete: use +subtype+ instead.  Calling this will
  # generate a warning message to +stderr+, then return
  # the value of +subtype+.
  #
  # source://net-imap//lib/net/imap/response_data.rb#1262
  def media_subtype; end

  # :call-seq: multipart? -> true
  #
  # BodyTypeMultipart is used for multipart MIME parts.
  #
  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap/response_data.rb#1254
  def multipart?; end
end

# Net::IMAP::BodyTypeText represents the body structures of messages and
# message parts, when <tt>Content-Type</tt> is <tt>text/*</tt>.
#
# BodyTypeText contains all of the fields of BodyTypeBasic.  See
# BodyTypeBasic for documentation of the following:
# * {media_type}[rdoc-ref:BodyTypeBasic#media_type]
# * subtype[rdoc-ref:BodyTypeBasic#subtype]
# * param[rdoc-ref:BodyTypeBasic#param]
# * {content_id}[rdoc-ref:BodyTypeBasic#content_id]
# * description[rdoc-ref:BodyTypeBasic#description]
# * encoding[rdoc-ref:BodyTypeBasic#encoding]
# * size[rdoc-ref:BodyTypeBasic#size]
#
# source://net-imap//lib/net/imap/response_data.rb#1052
class Net::IMAP::BodyTypeText < ::Struct
  include ::Net::IMAP::BodyStructure

  # Obsolete: use +subtype+ instead.  Calling this will
  # generate a warning message to +stderr+, then return
  # the value of +subtype+.
  #
  # source://net-imap//lib/net/imap/response_data.rb#1072
  def media_subtype; end

  # :call-seq: multipart? -> false
  #
  # BodyTypeText is not used for multipart MIME parts.
  #
  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap/response_data.rb#1065
  def multipart?; end
end

# source://net-imap//lib/net/imap/command_data.rb#231
class Net::IMAP::ClientID
  # @return [ClientID] a new instance of ClientID
  #
  # source://net-imap//lib/net/imap/command_data.rb#243
  def initialize(data); end

  # source://net-imap//lib/net/imap/command_data.rb#233
  def send_data(imap, tag); end

  # source://net-imap//lib/net/imap/command_data.rb#237
  def validate; end

  private

  # source://net-imap//lib/net/imap/command_data.rb#257
  def format_internal(client_id); end

  # source://net-imap//lib/net/imap/command_data.rb#247
  def validate_internal(client_id); end
end

# Authenticator for the "+CRAM-MD5+" SASL mechanism, specified in
# RFC2195[https://tools.ietf.org/html/rfc2195].  See Net::IMAP#authenticate.
#
# == Deprecated
#
# +CRAM-MD5+ is obsolete and insecure.  It is included for compatibility with
# existing servers.
# {draft-ietf-sasl-crammd5-to-historic}[https://tools.ietf.org/html/draft-ietf-sasl-crammd5-to-historic-00.html]
# recommends using +SCRAM-*+ or +PLAIN+ protected by TLS instead.
#
# Additionally, RFC8314[https://tools.ietf.org/html/rfc8314] discourage the use
# of cleartext and recommends TLS version 1.2 or greater be used for all
# traffic.  With TLS +CRAM-MD5+ is okay, but so is +PLAIN+
#
# source://net-imap//lib/net/imap/authenticators/cram_md5.rb#16
class Net::IMAP::CramMD5Authenticator
  # @return [CramMD5Authenticator] a new instance of CramMD5Authenticator
  #
  # source://net-imap//lib/net/imap/authenticators/cram_md5.rb#24
  def initialize(user, password, warn_deprecation: T.unsafe(nil), **_ignored); end

  # source://net-imap//lib/net/imap/authenticators/cram_md5.rb#17
  def process(challenge); end

  private

  # source://net-imap//lib/net/imap/authenticators/cram_md5.rb#33
  def hmac_md5(text, key); end
end

# Mailbox attribute indicating that this mailbox is used to hold draft
# messages -- typically, messages that are being composed but have not yet
# been sent. In some server implementations, this might be a virtual
# mailbox, containing messages from other mailboxes that are marked with the
# "\Draft" message flag. Alternatively, this might just be advice that a
# client put drafts here
#
# source://net-imap//lib/net/imap/flags.rb#232
Net::IMAP::DRAFTS = T.let(T.unsafe(nil), Symbol)

# Net::IMAP authenticator for the "`DIGEST-MD5`" SASL mechanism type, specified
# in RFC2831(https://tools.ietf.org/html/rfc2831).  See Net::IMAP#authenticate.
#
# == Deprecated
#
# "+DIGEST-MD5+" has been deprecated by
# {RFC6331}[https://tools.ietf.org/html/rfc6331] and should not be relied on for
# security.  It is included for compatibility with existing servers.
#
# source://net-imap//lib/net/imap/authenticators/digest_md5.rb#11
class Net::IMAP::DigestMD5Authenticator
  # @return [DigestMD5Authenticator] a new instance of DigestMD5Authenticator
  #
  # source://net-imap//lib/net/imap/authenticators/digest_md5.rb#77
  def initialize(user, password, authname = T.unsafe(nil), warn_deprecation: T.unsafe(nil)); end

  # source://net-imap//lib/net/imap/authenticators/digest_md5.rb#12
  def process(challenge); end

  private

  # source://net-imap//lib/net/imap/authenticators/digest_md5.rb#94
  def nc(nonce); end

  # some responses need quoting
  #
  # source://net-imap//lib/net/imap/authenticators/digest_md5.rb#104
  def qdval(k, v); end
end

# Alias for HAS_CHILDREN, to match the \IMAP spelling.
#
# source://net-imap//lib/net/imap/flags.rb#183
Net::IMAP::HASCHILDREN = T.let(T.unsafe(nil), Symbol)

# Alias for HAS_NO_CHILDREN, to match the \IMAP spelling.
#
# source://net-imap//lib/net/imap/flags.rb#185
Net::IMAP::HASNOCHILDREN = T.let(T.unsafe(nil), Symbol)

# The presence of this attribute indicates that the mailbox has child
# mailboxes. A server SHOULD NOT set this attribute if there are child
# mailboxes and the user does not have permission to access any of them.  In
# this case, +\HasNoChildren+ SHOULD be used. In many cases, however, a
# server may not be able to efficiently compute whether a user has access to
# any child mailboxes. Note that even though the +\HasChildren+ attribute
# for a mailbox must be correct at the time of processing the mailbox, a
# client must be prepared to deal with a situation when a mailbox is marked
# with the +\HasChildren+ attribute, but no child mailbox appears in the
# response to the #list command. This might happen, for example, due to child
# mailboxes being deleted or made inaccessible to the user (using access
# control) by another client before the server is able to list them.
#
# It is an error for the server to return both a +\HasChildren+ and a
# +\HasNoChildren+ attribute in the same #list response. A client that
# encounters a #list response with both +\HasChildren+ and +\HasNoChildren+
# attributes present should act as if both are absent in the #list response.
#
# source://net-imap//lib/net/imap/flags.rb#136
Net::IMAP::HAS_CHILDREN = T.let(T.unsafe(nil), Symbol)

# The presence of this attribute indicates that the mailbox has NO child
# mailboxes that are accessible to the currently authenticated user.
#
# It is an error for the server to return both a +\HasChildren+ and a
# +\HasNoChildren+ attribute in the same #list response. A client that
# encounters a #list response with both +\HasChildren+ and +\HasNoChildren+
# attributes present should act as if both are absent in the #list response.
#
# Note: the +\HasNoChildren+ attribute should not be confused with the
# +\NoInferiors+ attribute, which indicates that no child mailboxes exist
# now and none can be created in the future.
#
# source://net-imap//lib/net/imap/flags.rb#149
Net::IMAP::HAS_NO_CHILDREN = T.let(T.unsafe(nil), Symbol)

# Net::IMAP::IgnoredResponse represents intentionally ignored responses.
#
# This includes untagged response "NOOP" sent by eg. Zimbra to avoid some
# clients to close the connection.
#
# It matches no IMAP standard.
#
# source://net-imap//lib/net/imap/response_data.rb#63
class Net::IMAP::IgnoredResponse < ::Struct; end

# Mailbox attribute indicating that this mailbox is where messages deemed to
# be junk mail are held. Some server implementations might put messages here
# automatically.  Alternatively, this might just be advice to a client-side
# spam filter.
#
# source://net-imap//lib/net/imap/flags.rb#242
Net::IMAP::JUNK = T.let(T.unsafe(nil), Symbol)

# source://net-imap//lib/net/imap/command_data.rb#160
class Net::IMAP::Literal
  # @return [Literal] a new instance of Literal
  #
  # source://net-imap//lib/net/imap/command_data.rb#170
  def initialize(data); end

  # source://net-imap//lib/net/imap/command_data.rb#161
  def send_data(imap, tag); end

  # source://net-imap//lib/net/imap/command_data.rb#165
  def validate; end
end

# Authenticator for the "+LOGIN+" SASL mechanism.  See Net::IMAP#authenticate.
#
# +LOGIN+ authentication sends the password in cleartext.
# RFC3501[https://tools.ietf.org/html/rfc3501] encourages servers to disable
# cleartext authentication until after TLS has been negotiated.
# RFC8314[https://tools.ietf.org/html/rfc8314] recommends TLS version 1.2 or
# greater be used for all traffic, and deprecate cleartext access ASAP.  +LOGIN+
# can be secured by TLS encryption.
#
# == Deprecated
#
# The {SASL mechanisms
# registry}[https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml]
# marks "LOGIN" as obsoleted in favor of "PLAIN".  It is included here for
# compatibility with existing servers.  See
# {draft-murchison-sasl-login}[https://www.iana.org/go/draft-murchison-sasl-login]
# for both specification and deprecation.
#
# source://net-imap//lib/net/imap/authenticators/login.rb#20
class Net::IMAP::LoginAuthenticator
  # @return [LoginAuthenticator] a new instance of LoginAuthenticator
  #
  # source://net-imap//lib/net/imap/authenticators/login.rb#36
  def initialize(user, password, warn_deprecation: T.unsafe(nil), **_ignored); end

  # source://net-imap//lib/net/imap/authenticators/login.rb#21
  def process(data); end
end

# source://net-imap//lib/net/imap/command_data.rb#175
class Net::IMAP::MessageSet
  # @return [MessageSet] a new instance of MessageSet
  #
  # source://net-imap//lib/net/imap/command_data.rb#186
  def initialize(data); end

  # source://net-imap//lib/net/imap/command_data.rb#176
  def send_data(imap, tag); end

  # source://net-imap//lib/net/imap/command_data.rb#180
  def validate; end

  private

  # source://net-imap//lib/net/imap/command_data.rb#190
  def format_internal(data); end

  # source://net-imap//lib/net/imap/command_data.rb#211
  def validate_internal(data); end
end

# The +\NonExistent+ attribute indicates that a mailbox name does not refer
# to an existing mailbox. Note that this attribute is not meaningful by
# itself, as mailbox names that match the canonical #list pattern but don't
# exist must not be returned unless one of the two conditions listed below
# is also satisfied:
#
# 1. The mailbox name also satisfies the selection criteria (for example,
#    it is subscribed and the "SUBSCRIBED" selection option has been
#    specified).
#
# 2. "RECURSIVEMATCH" has been specified, and the mailbox name has at least
#    one descendant mailbox name that does not match the #list pattern and
#    does match the selection criteria.
#
# In practice, this means that the +\NonExistent+ attribute is usually
# returned with one or more of +\Subscribed+, +\Remote+, +\HasChildren+, or
# the CHILDINFO extended data item.
#
# The client must treat the presence of the +\NonExistent+ attribute as if the
# +\NoSelect+ attribute was also sent by the server
#
# source://net-imap//lib/net/imap/flags.rb#105
Net::IMAP::NONEXISTENT = T.let(T.unsafe(nil), Symbol)

# Mailbox attribute indicating it is not possible for any child levels of
# hierarchy to exist under this name; no child levels exist now and none can
# be created in the future children.
#
# The client must treat the presence of the +\NoInferiors+ attribute as if the
# +\HasNoChildren+ attribute was also sent by the server
#
# source://net-imap//lib/net/imap/flags.rb#113
Net::IMAP::NO_INFERIORS = T.let(T.unsafe(nil), Symbol)

# Mailbox attribute indicating it is not possible to use this name as a
# selectable mailbox.
#
# source://net-imap//lib/net/imap/flags.rb#117
Net::IMAP::NO_SELECT = T.let(T.unsafe(nil), Symbol)

# Net::IMAP::Namespace represents a single namespace contained inside a
# NAMESPACE response.
#
# Returned by Net::IMAP#namespace, contained inside a Namespaces object.
#
# source://net-imap//lib/net/imap/response_data.rb#387
class Net::IMAP::Namespace < ::Struct; end

# Net::IMAP::Namespaces represents a +NAMESPACE+ server response, which
# contains lists of #personal, #shared, and #other namespaces.
#
# Net::IMAP#namespace returns a Namespaces object.
#
# source://net-imap//lib/net/imap/response_data.rb#413
class Net::IMAP::Namespaces < ::Struct; end

# Common validators of number and nz_number types
#
# source://net-imap//lib/net/imap/data_encoding.rb#145
module Net::IMAP::NumValidator
  private

  # Ensure argument is 'mod_sequence_value' or raise DataFormatError
  #
  # source://net-imap//lib/net/imap/data_encoding.rb#192
  def ensure_mod_sequence_value(num); end

  # Ensure argument is 'number' or raise DataFormatError
  #
  # source://net-imap//lib/net/imap/data_encoding.rb#176
  def ensure_number(num); end

  # Ensure argument is 'nz_number' or raise DataFormatError
  #
  # source://net-imap//lib/net/imap/data_encoding.rb#184
  def ensure_nz_number(num); end

  # Check is passed argument valid 'mod_sequence_value' in RFC 4551 terminology
  #
  # source://net-imap//lib/net/imap/data_encoding.rb#167
  def valid_mod_sequence_value?(num); end

  # Check is passed argument valid 'number' in RFC 3501 terminology
  #
  # source://net-imap//lib/net/imap/data_encoding.rb#149
  def valid_number?(num); end

  # Check is passed argument valid 'nz_number' in RFC 3501 terminology
  #
  # source://net-imap//lib/net/imap/data_encoding.rb#158
  def valid_nz_number?(num); end

  class << self
    # Ensure argument is 'mod_sequence_value' or raise DataFormatError
    #
    # @raise [DataFormatError]
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#192
    def ensure_mod_sequence_value(num); end

    # Ensure argument is 'number' or raise DataFormatError
    #
    # @raise [DataFormatError]
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#176
    def ensure_number(num); end

    # Ensure argument is 'nz_number' or raise DataFormatError
    #
    # @raise [DataFormatError]
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#184
    def ensure_nz_number(num); end

    # Check is passed argument valid 'mod_sequence_value' in RFC 4551 terminology
    #
    # @return [Boolean]
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#167
    def valid_mod_sequence_value?(num); end

    # Check is passed argument valid 'number' in RFC 3501 terminology
    #
    # @return [Boolean]
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#149
    def valid_number?(num); end

    # Check is passed argument valid 'nz_number' in RFC 3501 terminology
    #
    # @return [Boolean]
    #
    # source://net-imap//lib/net/imap/data_encoding.rb#158
    def valid_nz_number?(num); end
  end
end

# Authenticator for the "+PLAIN+" SASL mechanism, specified in
# RFC4616[https://tools.ietf.org/html/rfc4616].  See Net::IMAP#authenticate.
#
# +PLAIN+ authentication sends the password in cleartext.
# RFC3501[https://tools.ietf.org/html/rfc3501] encourages servers to disable
# cleartext authentication until after TLS has been negotiated.
# RFC8314[https://tools.ietf.org/html/rfc8314] recommends TLS version 1.2 or
# greater be used for all traffic, and deprecate cleartext access ASAP.  +PLAIN+
# can be secured by TLS encryption.
#
# source://net-imap//lib/net/imap/authenticators/plain.rb#12
class Net::IMAP::PlainAuthenticator
  # +username+ is the authentication identity, the identity whose +password+ is
  # used.  +username+ is referred to as +authcid+ by
  # RFC4616[https://tools.ietf.org/html/rfc4616].
  #
  # +authzid+ is the authorization identity (identity to act as).  It can
  # usually be left blank. When +authzid+ is left blank (nil or empty string)
  # the server will derive an identity from the credentials and use that as the
  # authorization identity.
  #
  # @raise [ArgumentError]
  # @return [PlainAuthenticator] a new instance of PlainAuthenticator
  #
  # source://net-imap//lib/net/imap/authenticators/plain.rb#31
  def initialize(username, password, authzid: T.unsafe(nil)); end

  # source://net-imap//lib/net/imap/authenticators/plain.rb#14
  def process(data); end
end

# source://net-imap//lib/net/imap/authenticators/plain.rb#19
Net::IMAP::PlainAuthenticator::NULL = T.let(T.unsafe(nil), String)

# source://net-imap//lib/net/imap/command_data.rb#145
class Net::IMAP::QuotedString
  # @return [QuotedString] a new instance of QuotedString
  #
  # source://net-imap//lib/net/imap/command_data.rb#155
  def initialize(data); end

  # source://net-imap//lib/net/imap/command_data.rb#146
  def send_data(imap, tag); end

  # source://net-imap//lib/net/imap/command_data.rb#150
  def validate; end
end

# The mailbox is a remote mailbox.
#
# source://net-imap//lib/net/imap/flags.rb#176
Net::IMAP::REMOTE = T.let(T.unsafe(nil), Symbol)

# source://net-imap//lib/net/imap/errors.rb#54
Net::IMAP::RESPONSE_ERRORS = T.let(T.unsafe(nil), Hash)

# source://net-imap//lib/net/imap/command_data.rb#115
class Net::IMAP::RawData
  # @return [RawData] a new instance of RawData
  #
  # source://net-imap//lib/net/imap/command_data.rb#125
  def initialize(data); end

  # source://net-imap//lib/net/imap/command_data.rb#116
  def send_data(imap, tag); end

  # source://net-imap//lib/net/imap/command_data.rb#120
  def validate; end
end

# Superclass of all errors used to encapsulate "fail" responses
# from the server.
#
# source://net-imap//lib/net/imap/errors.rb#20
class Net::IMAP::ResponseError < ::Net::IMAP::Error
  # @return [ResponseError] a new instance of ResponseError
  #
  # source://net-imap//lib/net/imap/errors.rb#25
  def initialize(response); end

  # The response that caused this error
  #
  # source://net-imap//lib/net/imap/errors.rb#23
  def response; end

  # The response that caused this error
  #
  # source://net-imap//lib/net/imap/errors.rb#23
  def response=(_arg0); end
end

# Parses an \IMAP server response.
#
# source://net-imap//lib/net/imap/response_parser.rb#9
class Net::IMAP::ResponseParser
  # :call-seq: Net::IMAP::ResponseParser.new -> Net::IMAP::ResponseParser
  #
  # @return [ResponseParser] a new instance of ResponseParser
  #
  # source://net-imap//lib/net/imap/response_parser.rb#11
  def initialize; end

  # :call-seq:
  #   parse(str) -> ContinuationRequest
  #   parse(str) -> UntaggedResponse
  #   parse(str) -> TaggedResponse
  #
  # Raises ResponseParseError for unparsable strings.
  #
  # source://net-imap//lib/net/imap/response_parser.rb#24
  def parse(str); end

  private

  # like match, but does not raise error on failure.
  #
  # returns and shifts token on successful match
  # returns nil and leaves @token unshifted on no match
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1440
  def accept(*args); end

  # This advances @pos directly so it's safe before changing @lex_state.
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1397
  def accept_space; end

  # The RFC is very strict about this and usually we should be too.
  # But skipping spaces is usually a safe workaround for buggy servers.
  #
  # This advances @pos directly so it's safe before changing @lex_state.
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1409
  def accept_spaces; end

  # source://net-imap//lib/net/imap/response_parser.rb#1223
  def address; end

  # source://net-imap//lib/net/imap/response_parser.rb#1193
  def address_list; end

  # source://net-imap//lib/net/imap/response_parser.rb#1279
  def astring; end

  # source://net-imap//lib/net/imap/response_parser.rb#1332
  def astring_chars; end

  # source://net-imap//lib/net/imap/response_parser.rb#1324
  def atom; end

  # source://net-imap//lib/net/imap/response_parser.rb#336
  def body; end

  # source://net-imap//lib/net/imap/response_parser.rb#317
  def body_data; end

  # source://net-imap//lib/net/imap/response_parser.rb#523
  def body_ext_1part; end

  # source://net-imap//lib/net/imap/response_parser.rb#559
  def body_ext_mpart; end

  # source://net-imap//lib/net/imap/response_parser.rb#649
  def body_extension; end

  # source://net-imap//lib/net/imap/response_parser.rb#635
  def body_extensions; end

  # source://net-imap//lib/net/imap/response_parser.rb#485
  def body_fields; end

  # source://net-imap//lib/net/imap/response_parser.rb#595
  def body_fld_dsp; end

  # source://net-imap//lib/net/imap/response_parser.rb#609
  def body_fld_lang; end

  # source://net-imap//lib/net/imap/response_parser.rb#498
  def body_fld_param; end

  # source://net-imap//lib/net/imap/response_parser.rb#356
  def body_type_1part; end

  # source://net-imap//lib/net/imap/response_parser.rb#442
  def body_type_attachment; end

  # source://net-imap//lib/net/imap/response_parser.rb#372
  def body_type_basic; end

  # source://net-imap//lib/net/imap/response_parser.rb#449
  def body_type_mixed; end

  # source://net-imap//lib/net/imap/response_parser.rb#456
  def body_type_mpart; end

  # source://net-imap//lib/net/imap/response_parser.rb#401
  def body_type_msg; end

  # source://net-imap//lib/net/imap/response_parser.rb#387
  def body_type_text; end

  # source://net-imap//lib/net/imap/response_parser.rb#977
  def capability_data; end

  # source://net-imap//lib/net/imap/response_parser.rb#970
  def capability_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#1304
  def case_insensitive_string; end

  # See https://www.rfc-editor.org/errata/rfc3501
  #
  # charset = atom / quoted
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1351
  def charset; end

  # source://net-imap//lib/net/imap/response_parser.rb#1152
  def charset_list; end

  # source://net-imap//lib/net/imap/response_parser.rb#1336
  def combine_adjacent(*tokens); end

  # source://net-imap//lib/net/imap/response_parser.rb#118
  def continue_req; end

  # source://net-imap//lib/net/imap/response_parser.rb#248
  def envelope; end

  # source://net-imap//lib/net/imap/response_parser.rb#241
  def envelope_data; end

  # source://net-imap//lib/net/imap/response_parser.rb#1254
  def flag_list; end

  # source://net-imap//lib/net/imap/response_parser.rb#283
  def flags_data; end

  # source://net-imap//lib/net/imap/response_parser.rb#746
  def flags_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#699
  def format_string(str); end

  # source://net-imap//lib/net/imap/response_parser.rb#824
  def getacl_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#774
  def getquota_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#807
  def getquotaroot_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#993
  def id_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#732
  def ignored_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#290
  def internaldate_data; end

  # source://net-imap//lib/net/imap/response_parser.rb#753
  def list_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#1448
  def lookahead; end

  # source://net-imap//lib/net/imap/response_parser.rb#760
  def mailbox_list; end

  # source://net-imap//lib/net/imap/response_parser.rb#1416
  def match(*args, lex_state: T.unsafe(nil)); end

  # source://net-imap//lib/net/imap/response_parser.rb#474
  def media_type; end

  # source://net-imap//lib/net/imap/response_parser.rb#722
  def modseq_data; end

  # source://net-imap//lib/net/imap/response_parser.rb#203
  def msg_att(n); end

  # source://net-imap//lib/net/imap/response_parser.rb#1056
  def namespace; end

  # source://net-imap//lib/net/imap/response_parser.rb#1022
  def namespace_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#1066
  def namespace_response_extensions; end

  # source://net-imap//lib/net/imap/response_parser.rb#1038
  def namespaces; end

  # source://net-imap//lib/net/imap/response_parser.rb#1456
  def next_token; end

  # source://net-imap//lib/net/imap/response_parser.rb#1389
  def nil_atom; end

  # source://net-imap//lib/net/imap/response_parser.rb#1269
  def nstring; end

  # source://net-imap//lib/net/imap/response_parser.rb#1359
  def number; end

  # source://net-imap//lib/net/imap/response_parser.rb#187
  def numeric_response; end

  # @raise [ResponseParseError]
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1575
  def parse_error(fmt, *args); end

  # already matched:  "APPENDUID"
  #
  # +UIDPLUS+ ABNF:: https://www.rfc-editor.org/rfc/rfc4315.html#section-4
  #   resp-code-apnd  = "APPENDUID" SP nz-number SP append-uid
  #   append-uid      = uniqueid
  #   append-uid      =/ uid-set
  #                     ; only permitted if client uses [MULTIAPPEND]
  #                     ; to append multiple messages.
  #
  # n.b, uniqueid ⊂ uid-set.  To avoid inconsistent return types, we always
  # match uid_set even if that returns a single-member array.
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1177
  def resp_code_apnd__data; end

  # already matched:  "COPYUID"
  #
  # resp-code-copy  = "COPYUID" SP nz-number SP uid-set SP uid-set
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1186
  def resp_code_copy__data; end

  # resp-text       = ["[" resp-text-code "]" SP] text
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1092
  def resp_text; end

  # See https://www.rfc-editor.org/errata/rfc3501
  #
  # resp-text-code  = "ALERT" /
  #                   "BADCHARSET" [SP "(" charset *(SP charset) ")" ] /
  #                   capability-data / "PARSE" /
  #                   "PERMANENTFLAGS" SP "("
  #                   [flag-perm *(SP flag-perm)] ")" /
  #                   "READ-ONLY" / "READ-WRITE" / "TRYCREATE" /
  #                   "UIDNEXT" SP nz-number / "UIDVALIDITY" SP nz-number /
  #                   "UNSEEN" SP nz-number /
  #                   atom [SP 1*<any TEXT-CHAR except "]">]
  #
  # +UIDPLUS+ ABNF:: https://www.rfc-editor.org/rfc/rfc4315.html#section-4
  #   resp-text-code  =/ resp-code-apnd / resp-code-copy / "UIDNOTSTICKY"
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1119
  def resp_text_code; end

  # source://net-imap//lib/net/imap/response_parser.rb#99
  def response; end

  # source://net-imap//lib/net/imap/response_parser.rb#180
  def response_cond; end

  # source://net-imap//lib/net/imap/response_parser.rb#171
  def response_tagged; end

  # source://net-imap//lib/net/imap/response_parser.rb#129
  def response_untagged; end

  # source://net-imap//lib/net/imap/response_parser.rb#310
  def rfc822_size; end

  # source://net-imap//lib/net/imap/response_parser.rb#298
  def rfc822_text; end

  # source://net-imap//lib/net/imap/response_parser.rb#850
  def search_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#664
  def section; end

  # source://net-imap//lib/net/imap/response_parser.rb#1452
  def shift_token; end

  # source://net-imap//lib/net/imap/response_parser.rb#943
  def status_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#1288
  def string; end

  # @return [Boolean]
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1300
  def string_token?(token); end

  # text            = 1*TEXT-CHAR
  # TEXT-CHAR       = <any CHAR except CR and LF>
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1087
  def text; end

  # source://net-imap//lib/net/imap/response_parser.rb#739
  def text_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#908
  def thread_branch(token); end

  # source://net-imap//lib/net/imap/response_parser.rb#881
  def thread_response; end

  # source://net-imap//lib/net/imap/response_parser.rb#715
  def uid_data; end

  # RFC-4315 (UIDPLUS) or RFC9051 (IMAP4rev2):
  #      uid-set         = (uniqueid / uid-range) *("," uid-set)
  #      uid-range       = (uniqueid ":" uniqueid)
  #                          ; two uniqueid values and all values
  #                          ; between these two regardless of order.
  #                          ; Example: 2:4 and 4:2 are equivalent.
  #      uniqueid        = nz-number
  #                          ; Strictly ascending
  #
  # source://net-imap//lib/net/imap/response_parser.rb#1377
  def uid_set; end
end

# ASTRING-CHAR    = ATOM-CHAR / resp-specials
# resp-specials   = "]"
#
# source://net-imap//lib/net/imap/response_parser.rb#1330
Net::IMAP::ResponseParser::ASTRING_CHARS_TOKENS = T.let(T.unsafe(nil), Array)

# source://net-imap//lib/net/imap/response_parser.rb#1394
Net::IMAP::ResponseParser::SPACES_REGEXP = T.let(T.unsafe(nil), Regexp)

# Pluggable authentication mechanisms for protocols which support SASL
# (Simple Authentication and Security Layer), such as IMAP4, SMTP, LDAP, and
# XMPP.  {RFC-4422}[https://tools.ietf.org/html/rfc4422] specifies the
# common SASL framework and the +EXTERNAL+ mechanism, and the
# {SASL mechanism registry}[https://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml]
# lists the specification for others.
#
# "SASL is conceptually a framework that provides an abstraction layer
# between protocols and mechanisms as illustrated in the following diagram."
#
#               SMTP    LDAP    XMPP   Other protocols ...
#                  \       |    |      /
#                   \      |    |     /
#                  SASL abstraction layer
#                   /      |    |     \
#                  /       |    |      \
#           EXTERNAL   GSSAPI  PLAIN   Other mechanisms ...
#
# source://net-imap//lib/net/imap/sasl.rb#24
module Net::IMAP::SASL
  extend ::Net::IMAP::SASL

  # See SASLprep#saslprep.
  #
  # source://net-imap//lib/net/imap/sasl.rb#69
  def saslprep(string, **opts); end
end

# StringPrepError raised when +string+ contains bidirectional characters
# which violate the StringPrep requirements.
#
# source://net-imap//lib/net/imap/sasl.rb#59
class Net::IMAP::SASL::BidiStringError < ::Net::IMAP::SASL::StringPrepError; end

# StringPrepError raised when +string+ contains a codepoint prohibited by
# +table+.
#
# source://net-imap//lib/net/imap/sasl.rb#45
class Net::IMAP::SASL::ProhibitedCodepoint < ::Net::IMAP::SASL::StringPrepError
  # @return [ProhibitedCodepoint] a new instance of ProhibitedCodepoint
  #
  # source://net-imap//lib/net/imap/sasl.rb#48
  def initialize(table, *args, **kwargs); end

  # Returns the value of attribute table.
  #
  # source://net-imap//lib/net/imap/sasl.rb#46
  def table; end
end

# SASLprep#saslprep can be used to prepare a string according to [RFC4013].
#
# \SASLprep maps characters three ways: to nothing, to space, and Unicode
# normalization form KC.  \SASLprep prohibits codepoints from nearly all
# standard StringPrep tables (RFC3454, Appendix "C"), and uses \StringPrep's
# standard bidirectional characters requirements (Appendix "D").  \SASLprep
# also uses \StringPrep's definition of "Unassigned" codepoints (Appendix "A").
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#9
module Net::IMAP::SASL::SASLprep
  private

  # Prepares a UTF-8 +string+ for comparison, using the \SASLprep profile
  # RFC4013 of the StringPrep algorithm RFC3454.
  #
  # By default, prohibited strings will return +nil+.  When +exception+ is
  # +true+, a StringPrepError describing the violation will be raised.
  #
  # When +stored+ is +true+, "unassigned" codepoints will be prohibited. For
  # \StringPrep and the \SASLprep profile, "unassigned" refers to Unicode 3.2,
  # and not later versions.  See RFC3454 §7 for more information.
  #
  # source://net-imap//lib/net/imap/sasl/saslprep.rb#31
  def saslprep(str, stored: T.unsafe(nil), exception: T.unsafe(nil)); end

  class << self
    # Prepares a UTF-8 +string+ for comparison, using the \SASLprep profile
    # RFC4013 of the StringPrep algorithm RFC3454.
    #
    # By default, prohibited strings will return +nil+.  When +exception+ is
    # +true+, a StringPrepError describing the violation will be raised.
    #
    # When +stored+ is +true+, "unassigned" codepoints will be prohibited. For
    # \StringPrep and the \SASLprep profile, "unassigned" refers to Unicode 3.2,
    # and not later versions.  See RFC3454 §7 for more information.
    #
    # source://net-imap//lib/net/imap/sasl/saslprep.rb#31
    def saslprep(str, stored: T.unsafe(nil), exception: T.unsafe(nil)); end
  end
end

# Used to short-circuit strings that don't need preparation.
#
# source://net-imap//lib/net/imap/sasl/saslprep.rb#17
Net::IMAP::SASL::SASLprep::ASCII_NO_CTRLS = T.let(T.unsafe(nil), Regexp)

# Bidirectional Characters [StringPrep, §6]
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#68
Net::IMAP::SASL::SASLprep::BIDI_FAILURE = T.let(T.unsafe(nil), Regexp)

# RFC4013 §2.1 Mapping - mapped to nothing
#   the "commonly mapped to nothing" characters (\StringPrep\[\"B.1\"])
#   that can be mapped to nothing.
#
# Equal to \StringPrep\[\"B.1\"].
# Redefined here to avoid loading the StringPrep module.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#25
Net::IMAP::SASL::SASLprep::MAP_TO_NOTHING = T.let(T.unsafe(nil), Regexp)

# RFC4013 §2.1 Mapping - mapped to space
# * non-ASCII space characters (\StringPrep\[\"C.1.2\"]) that can be
#   mapped to SPACE (U+0020), and
#
# Equal to \StringPrep\[\"C.1.2\"].
# Redefined here to avoid loading the StringPrep module.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#17
Net::IMAP::SASL::SASLprep::MAP_TO_SPACE = T.let(T.unsafe(nil), Regexp)

# Matches strings prohibited by RFC4013 §2.3 and §2.4.
#
# This checks prohibited output and bidirectional characters.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#85
Net::IMAP::SASL::SASLprep::PROHIBITED = T.let(T.unsafe(nil), Regexp)

# Matches codepoints prohibited by RFC4013 §2.3.
#
# See TABLES_PROHIBITED.
#
# Equal to +Regexp.union+ of the TABLES_PROHIBITED tables.  Redefined
# here to avoid loading the StringPrep module unless necessary.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#53
Net::IMAP::SASL::SASLprep::PROHIBITED_OUTPUT = T.let(T.unsafe(nil), Regexp)

# Matches codepoints prohibited by RFC4013 §2.3 and §2.5.
#
# See TABLES_PROHIBITED_STORED.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#63
Net::IMAP::SASL::SASLprep::PROHIBITED_OUTPUT_STORED = T.let(T.unsafe(nil), Regexp)

# Matches strings prohibited by RFC4013 §2.3, §2.4, and §2.5.
#
# This checks prohibited output, bidirectional characters, and
# unassigned codepoints.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#93
Net::IMAP::SASL::SASLprep::PROHIBITED_STORED = T.let(T.unsafe(nil), Regexp)

# RFC4013 §2.3 Prohibited Output::
# * Non-ASCII space characters — \StringPrep\[\"C.1.2\"]
# * ASCII control characters — \StringPrep\[\"C.2.1\"]
# * Non-ASCII control characters — \StringPrep\[\"C.2.2\"]
# * Private Use characters — \StringPrep\[\"C.3\"]
# * Non-character code points — \StringPrep\[\"C.4\"]
# * Surrogate code points — \StringPrep\[\"C.5\"]
# * Inappropriate for plain text characters — \StringPrep\[\"C.6\"]
# * Inappropriate for canonical representation characters — \StringPrep\[\"C.7\"]
# * Change display properties or deprecated characters — \StringPrep\[\"C.8\"]
# * Tagging characters — \StringPrep\[\"C.9\"]
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#38
Net::IMAP::SASL::SASLprep::TABLES_PROHIBITED = T.let(T.unsafe(nil), Array)

# Adds unassigned (by Unicode 3.2) codepoints to TABLES_PROHIBITED.
#
# RFC4013 §2.5 Unassigned Code Points::
#   This profile specifies the \StringPrep\[\"A.1\"] table as its list of
#   unassigned code points.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#45
Net::IMAP::SASL::SASLprep::TABLES_PROHIBITED_STORED = T.let(T.unsafe(nil), Array)

# RFC4013 §2.5 Unassigned Code Points::
#   This profile specifies the \StringPrep\[\"A.1\"] table as its list of
#   unassigned code points.
#
# source://net-imap//lib/net/imap/sasl/saslprep_tables.rb#58
Net::IMAP::SASL::SASLprep::UNASSIGNED = T.let(T.unsafe(nil), Regexp)

# Regexps and utility methods for implementing stringprep profiles.  The
# \StringPrep algorithm is defined by
# {RFC-3454}[https://www.rfc-editor.org/rfc/rfc3454.html].  Each
# codepoint table defined in the RFC-3454 appendices is matched by a Regexp
# defined in this module.
# --
# TODO: generic StringPrep mapping (not needed for SASLprep implementation)
# ++
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#9
module Net::IMAP::SASL::StringPrep
  private

  # Checks that +string+ obeys all of the "Bidirectional Characters"
  # requirements in RFC-3454, §6:
  #
  # * The characters in \StringPrep\[\"C.8\"] MUST be prohibited
  # * If a string contains any RandALCat character, the string MUST NOT
  #   contain any LCat character.
  # * If a string contains any RandALCat character, a RandALCat
  #   character MUST be the first character of the string, and a
  #   RandALCat character MUST be the last character of the string.
  #
  # This is usually combined with #check_prohibited!, so table "C.8" is only
  # checked when <tt>c_8: true</tt>.
  #
  # Raises either ProhibitedCodepoint or BidiStringError unless all
  # requirements are met.  +profile+ is an optional string which will be
  # added to any exception that is raised (it does not affect behavior).
  #
  # source://net-imap//lib/net/imap/sasl/stringprep.rb#58
  def check_bidi!(string, c_8: T.unsafe(nil), profile: T.unsafe(nil)); end

  # Checks +string+ for any codepoint in +tables+. Raises a
  # ProhibitedCodepoint describing the first matching table.
  #
  # Also checks bidirectional characters, when <tt>bidi: true</tt>, which may
  # raise a BidiStringError.
  #
  # +profile+ is an optional string which will be added to any exception that
  # is raised (it does not affect behavior).
  #
  # source://net-imap//lib/net/imap/sasl/stringprep.rb#32
  def check_prohibited!(string, *tables, bidi: T.unsafe(nil), profile: T.unsafe(nil)); end

  class << self
    # Returns a Regexp matching the given +table+ name.
    #
    # source://net-imap//lib/net/imap/sasl/stringprep.rb#18
    def [](table); end

    # Checks that +string+ obeys all of the "Bidirectional Characters"
    # requirements in RFC-3454, §6:
    #
    # * The characters in \StringPrep\[\"C.8\"] MUST be prohibited
    # * If a string contains any RandALCat character, the string MUST NOT
    #   contain any LCat character.
    # * If a string contains any RandALCat character, a RandALCat
    #   character MUST be the first character of the string, and a
    #   RandALCat character MUST be the last character of the string.
    #
    # This is usually combined with #check_prohibited!, so table "C.8" is only
    # checked when <tt>c_8: true</tt>.
    #
    # Raises either ProhibitedCodepoint or BidiStringError unless all
    # requirements are met.  +profile+ is an optional string which will be
    # added to any exception that is raised (it does not affect behavior).
    #
    # source://net-imap//lib/net/imap/sasl/stringprep.rb#58
    def check_bidi!(string, c_8: T.unsafe(nil), profile: T.unsafe(nil)); end

    # Checks +string+ for any codepoint in +tables+. Raises a
    # ProhibitedCodepoint describing the first matching table.
    #
    # Also checks bidirectional characters, when <tt>bidi: true</tt>, which may
    # raise a BidiStringError.
    #
    # +profile+ is an optional string which will be added to any exception that
    # is raised (it does not affect behavior).
    #
    # @raise [ProhibitedCodepoint]
    #
    # source://net-imap//lib/net/imap/sasl/stringprep.rb#32
    def check_prohibited!(string, *tables, bidi: T.unsafe(nil), profile: T.unsafe(nil)); end
  end
end

# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#66
Net::IMAP::SASL::StringPrep::BIDI_DESC_REQ2 = T.let(T.unsafe(nil), String)

# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#79
Net::IMAP::SASL::StringPrep::BIDI_DESC_REQ3 = T.let(T.unsafe(nil), String)

# Bidirectional Characters [StringPrep, §6], Requirement 2::
#   If a string contains any RandALCat character, the string MUST NOT
#   contain any LCat character.
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#71
Net::IMAP::SASL::StringPrep::BIDI_FAILS_REQ2 = T.let(T.unsafe(nil), Regexp)

# Bidirectional Characters [StringPrep, §6], Requirement 3::
#   If a string contains any RandALCat character, a RandALCat
#   character MUST be the first character of the string, and a
#   RandALCat character MUST be the last character of the string.
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#85
Net::IMAP::SASL::StringPrep::BIDI_FAILS_REQ3 = T.let(T.unsafe(nil), Regexp)

# Bidirectional Characters [StringPrep, §6]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#94
Net::IMAP::SASL::StringPrep::BIDI_FAILURE = T.let(T.unsafe(nil), Regexp)

# Unassigned code points in Unicode 3.2 \StringPrep\[\"A.1\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#12
Net::IMAP::SASL::StringPrep::IN_A_1 = T.let(T.unsafe(nil), Regexp)

# Commonly mapped to nothing \StringPrep\[\"B.1\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#15
Net::IMAP::SASL::StringPrep::IN_B_1 = T.let(T.unsafe(nil), Regexp)

# Mapping for case-folding used with NFKC \StringPrep\[\"B.2\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#18
Net::IMAP::SASL::StringPrep::IN_B_2 = T.let(T.unsafe(nil), Regexp)

# Mapping for case-folding used with no normalization \StringPrep\[\"B.3\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#21
Net::IMAP::SASL::StringPrep::IN_B_3 = T.let(T.unsafe(nil), Regexp)

# ASCII space characters \StringPrep\[\"C.1.1\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#24
Net::IMAP::SASL::StringPrep::IN_C_1_1 = T.let(T.unsafe(nil), Regexp)

# Non-ASCII space characters \StringPrep\[\"C.1.2\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#27
Net::IMAP::SASL::StringPrep::IN_C_1_2 = T.let(T.unsafe(nil), Regexp)

# ASCII control characters \StringPrep\[\"C.2.1\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#30
Net::IMAP::SASL::StringPrep::IN_C_2_1 = T.let(T.unsafe(nil), Regexp)

# Non-ASCII control characters \StringPrep\[\"C.2.2\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#33
Net::IMAP::SASL::StringPrep::IN_C_2_2 = T.let(T.unsafe(nil), Regexp)

# Private use \StringPrep\[\"C.3\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#36
Net::IMAP::SASL::StringPrep::IN_C_3 = T.let(T.unsafe(nil), Regexp)

# Non-character code points \StringPrep\[\"C.4\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#39
Net::IMAP::SASL::StringPrep::IN_C_4 = T.let(T.unsafe(nil), Regexp)

# Surrogate codes \StringPrep\[\"C.5\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#42
Net::IMAP::SASL::StringPrep::IN_C_5 = T.let(T.unsafe(nil), Regexp)

# Inappropriate for plain text \StringPrep\[\"C.6\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#45
Net::IMAP::SASL::StringPrep::IN_C_6 = T.let(T.unsafe(nil), Regexp)

# Inappropriate for canonical representation \StringPrep\[\"C.7\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#48
Net::IMAP::SASL::StringPrep::IN_C_7 = T.let(T.unsafe(nil), Regexp)

# Change display properties or are deprecated \StringPrep\[\"C.8\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#51
Net::IMAP::SASL::StringPrep::IN_C_8 = T.let(T.unsafe(nil), Regexp)

# Tagging characters \StringPrep\[\"C.9\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#54
Net::IMAP::SASL::StringPrep::IN_C_9 = T.let(T.unsafe(nil), Regexp)

# Characters with bidirectional property "R" or "AL" \StringPrep\[\"D.1\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#57
Net::IMAP::SASL::StringPrep::IN_D_1 = T.let(T.unsafe(nil), Regexp)

# Used to check req3 of bidirectional checks
# Matches the negation of the D.1 table
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#61
Net::IMAP::SASL::StringPrep::IN_D_1_NEGATED = T.let(T.unsafe(nil), Regexp)

# Characters with bidirectional property "L" \StringPrep\[\"D.2\"]
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#64
Net::IMAP::SASL::StringPrep::IN_D_2 = T.let(T.unsafe(nil), Regexp)

# Regexps matching each codepoint table in the RFC-3454 appendices
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#132
Net::IMAP::SASL::StringPrep::TABLE_REGEXPS = T.let(T.unsafe(nil), Hash)

# Names of each codepoint table in the RFC-3454 appendices
#
# source://net-imap//lib/net/imap/sasl/stringprep_tables.rb#109
Net::IMAP::SASL::StringPrep::TABLE_TITLES = T.let(T.unsafe(nil), Hash)

# ArgumentError raised when +string+ is invalid for the stringprep
# +profile+.
#
# source://net-imap//lib/net/imap/sasl.rb#33
class Net::IMAP::SASL::StringPrepError < ::ArgumentError
  # @return [StringPrepError] a new instance of StringPrepError
  #
  # source://net-imap//lib/net/imap/sasl.rb#36
  def initialize(*args, string: T.unsafe(nil), profile: T.unsafe(nil)); end

  # Returns the value of attribute profile.
  #
  # source://net-imap//lib/net/imap/sasl.rb#34
  def profile; end

  # Returns the value of attribute string.
  #
  # source://net-imap//lib/net/imap/sasl.rb#34
  def string; end
end

# Mailbox attribute indicating that this mailbox is used to hold copies of
# messages that have been sent. Some server implementations might put
# messages here automatically. Alternatively, this might just be advice that
# a client save sent messages here.
#
# source://net-imap//lib/net/imap/flags.rb#248
Net::IMAP::SENT = T.let(T.unsafe(nil), Symbol)

# strftime/strptime format for an IMAP4 +date+, excluding optional dquotes.
# Use via the encode_date and decode_date methods.
#
#   date            = date-text / DQUOTE date-text DQUOTE
#   date-text       = date-day "-" date-month "-" date-year
#
#   date-day        = 1*2DIGIT
#                       ; Day of month
#   date-month      = "Jan" / "Feb" / "Mar" / "Apr" / "May" / "Jun" /
#                     "Jul" / "Aug" / "Sep" / "Oct" / "Nov" / "Dec"
#   date-year       = 4DIGIT
#
# source://net-imap//lib/net/imap/data_encoding.rb#21
Net::IMAP::STRFDATE = T.let(T.unsafe(nil), String)

# strftime/strptime format for an IMAP4 +date-time+, including dquotes.
# See the encode_datetime and decode_datetime methods.
#
#   date-time       = DQUOTE date-day-fixed "-" date-month "-" date-year
#                     SP time SP zone DQUOTE
#
#   date-day-fixed  = (SP DIGIT) / 2DIGIT
#                       ; Fixed-format version of date-day
#   date-month      = "Jan" / "Feb" / "Mar" / "Apr" / "May" / "Jun" /
#                     "Jul" / "Aug" / "Sep" / "Oct" / "Nov" / "Dec"
#   date-year       = 4DIGIT
#   time            = 2DIGIT ":" 2DIGIT ":" 2DIGIT
#                       ; Hours minutes seconds
#   zone            = ("+" / "-") 4DIGIT
#                       ; Signed four-digit value of hhmm representing
#                       ; hours and minutes east of Greenwich (that is,
#                       ; the amount that the given time differs from
#                       ; Universal Time).  Subtracting the timezone
#                       ; from the given time will give the UT form.
#                       ; The Universal Time zone is "+0000".
#
# Note that Time.strptime <tt>"%d"</tt> flexibly parses either space or zero
# padding.  However, the DQUOTEs are *not* optional.
#
# source://net-imap//lib/net/imap/data_encoding.rb#46
Net::IMAP::STRFTIME = T.let(T.unsafe(nil), String)

# The mailbox name was subscribed to using the #subscribe command.
#
# source://net-imap//lib/net/imap/flags.rb#173
Net::IMAP::SUBSCRIBED = T.let(T.unsafe(nil), Symbol)

# source://net-imap//lib/net/imap/command_data.rb#266
module Net::IMAP::StringFormatter
  private

  # coerces non-nil using +to_s+
  #
  # source://net-imap//lib/net/imap/command_data.rb#293
  def nstring(str); end

  # coerces using +to_s+
  #
  # source://net-imap//lib/net/imap/command_data.rb#283
  def string(str); end

  # Allows nil, symbols, and strings
  #
  # source://net-imap//lib/net/imap/command_data.rb#278
  def valid_nstring?(str); end

  # Allows symbols in addition to strings
  #
  # source://net-imap//lib/net/imap/command_data.rb#273
  def valid_string?(str); end

  class << self
    # coerces non-nil using +to_s+
    #
    # source://net-imap//lib/net/imap/command_data.rb#293
    def nstring(str); end

    # coerces using +to_s+
    #
    # source://net-imap//lib/net/imap/command_data.rb#283
    def string(str); end

    # Allows nil, symbols, and strings
    #
    # @return [Boolean]
    #
    # source://net-imap//lib/net/imap/command_data.rb#278
    def valid_nstring?(str); end

    # Allows symbols in addition to strings
    #
    # @return [Boolean]
    #
    # source://net-imap//lib/net/imap/command_data.rb#273
    def valid_string?(str); end
  end
end

# source://net-imap//lib/net/imap/command_data.rb#268
Net::IMAP::StringFormatter::LITERAL_REGEX = T.let(T.unsafe(nil), Regexp)

# Mailbox attribute indicating that this mailbox is used to hold messages
# that have been deleted or marked for deletion. In some server
# implementations, this might be a virtual mailbox, containing messages from
# other mailboxes that are marked with the +\Deleted+ message flag.
# Alternatively, this might just be advice that a client that chooses not to
# use the \IMAP +\Deleted+ model should use as its trash location. In server
# implementations that strictly expect the \IMAP +\Deleted+ model, this
# special use is likely not to be supported.
#
# source://net-imap//lib/net/imap/flags.rb#258
Net::IMAP::TRASH = T.let(T.unsafe(nil), Symbol)

# Net::IMAP::UIDPlusData represents the ResponseCode#data that accompanies
# the +APPENDUID+ and +COPYUID+ response codes.
#
# See [[UIDPLUS[https://www.rfc-editor.org/rfc/rfc4315.html]].
#
# ==== Capability requirement
#
# The +UIDPLUS+ capability[rdoc-ref:Net::IMAP#capability] must be supported.
# A server that supports +UIDPLUS+ should send a UIDPlusData object inside
# every TaggedResponse returned by the append[rdoc-ref:Net::IMAP#append],
# copy[rdoc-ref:Net::IMAP#copy], move[rdoc-ref:Net::IMAP#move], {uid
# copy}[rdoc-ref:Net::IMAP#uid_copy], and {uid
# move}[rdoc-ref:Net::IMAP#uid_move] commands---unless the destination
# mailbox reports +UIDNOTSTICKY+.
#
# --
# TODO: support MULTIAPPEND
# ++
#
# source://net-imap//lib/net/imap/response_data.rb#237
class Net::IMAP::UIDPlusData < ::Struct
  # :call-seq: uid_mapping -> nil or a hash
  #
  # Returns a hash mapping each source UID to the newly assigned destination
  # UID.
  #
  # Note:: Returns +nil+ for Net::IMAP#append.
  #
  # source://net-imap//lib/net/imap/response_data.rb#267
  def uid_mapping; end
end

# Error raised upon an unknown response from the server.
#
# source://net-imap//lib/net/imap/errors.rb#51
class Net::IMAP::UnknownResponseError < ::Net::IMAP::ResponseError; end

# source://net-imap//lib/net/imap.rb#702
Net::IMAP::VERSION = T.let(T.unsafe(nil), String)

# source://net-imap//lib/net/imap/authenticators/xoauth2.rb#3
class Net::IMAP::XOauth2Authenticator
  # @return [XOauth2Authenticator] a new instance of XOauth2Authenticator
  #
  # source://net-imap//lib/net/imap/authenticators/xoauth2.rb#10
  def initialize(user, oauth2_token, **_); end

  # source://net-imap//lib/net/imap/authenticators/xoauth2.rb#4
  def process(_data); end

  private

  # source://net-imap//lib/net/imap/authenticators/xoauth2.rb#15
  def build_oauth2_string(user, oauth2_token); end
end
