# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `httparty` gem.
# Please instead update this file by running `bin/tapioca gem httparty`.


# @see HTTParty::ClassMethods
#
# source://httparty//lib/httparty/module_inheritable_attributes.rb#3
module HTTParty
  include ::HTTParty::ModuleInheritableAttributes

  mixes_in_class_methods ::HTTParty::ClassMethods
  mixes_in_class_methods ::HTTParty::ModuleInheritableAttributes::ClassMethods

  class << self
    # source://httparty//lib/httparty.rb#679
    def build_request(*args, &block); end

    # source://httparty//lib/httparty.rb#667
    def copy(*args, &block); end

    # source://httparty//lib/httparty.rb#659
    def delete(*args, &block); end

    # source://httparty//lib/httparty.rb#643
    def get(*args, &block); end

    # source://httparty//lib/httparty.rb#671
    def head(*args, &block); end

    # @private
    #
    # source://httparty//lib/httparty.rb#21
    def included(base); end

    # source://httparty//lib/httparty.rb#663
    def move(*args, &block); end

    # source://httparty//lib/httparty.rb#628
    def normalize_base_uri(url); end

    # source://httparty//lib/httparty.rb#675
    def options(*args, &block); end

    # source://httparty//lib/httparty.rb#651
    def patch(*args, &block); end

    # source://httparty//lib/httparty.rb#647
    def post(*args, &block); end

    # source://httparty//lib/httparty.rb#655
    def put(*args, &block); end
  end
end

# source://httparty//lib/httparty.rb#639
class HTTParty::Basement
  include ::HTTParty
  include ::HTTParty::ModuleInheritableAttributes
  extend ::HTTParty::ClassMethods
  extend ::HTTParty::ModuleInheritableAttributes::ClassMethods

  class << self
    # source://httparty//lib/httparty/module_inheritable_attributes.rb#32
    def default_cookies; end

    # source://httparty//lib/httparty/module_inheritable_attributes.rb#32
    def default_cookies=(_arg0); end

    # source://httparty//lib/httparty/module_inheritable_attributes.rb#32
    def default_options; end

    # source://httparty//lib/httparty/module_inheritable_attributes.rb#32
    def default_options=(_arg0); end
  end
end

# == Common Request Options
# Request methods (get, post, patch, put, delete, head, options) all take a common set of options. These are:
#
# [:+body+:] Body of the request. If passed an object that responds to #to_hash, will try to normalize it first, by default passing it to ActiveSupport::to_params. Any other kind of object will get used as-is.
# [:+http_proxyaddr+:] Address of proxy server to use.
# [:+http_proxyport+:]  Port of proxy server to use.
# [:+http_proxyuser+:] User for proxy server authentication.
# [:+http_proxypass+:] Password for proxy server authentication.
# [:+limit+:] Maximum number of redirects to follow. Takes precedences over :+no_follow+.
# [:+query+:] Query string, or an object that responds to #to_hash representing it. Normalized according to the same rules as :+body+. If you specify this on a POST, you must use an object which responds to #to_hash. See also HTTParty::ClassMethods.default_params.
# [:+timeout+:] Timeout for opening connection and reading data.
# [:+local_host+:] Local address to bind to before connecting.
# [:+local_port+:] Local port to bind to before connecting.
# [:+body_stream+:] Allow streaming to a REST server to specify a body_stream.
# [:+stream_body+:] Allow for streaming large files without loading them into memory.
# [:+multipart+:] Force content-type to be multipart
#
# There are also another set of options with names corresponding to various class methods. The methods in question are those that let you set a class-wide default, and the options override the defaults on a request-by-request basis. Those options are:
# * :+base_uri+: see HTTParty::ClassMethods.base_uri.
# * :+basic_auth+: see HTTParty::ClassMethods.basic_auth. Only one of :+basic_auth+ and :+digest_auth+ can be used at a time; if you try using both, you'll get an ArgumentError.
# * :+debug_output+: see HTTParty::ClassMethods.debug_output.
# * :+digest_auth+: see HTTParty::ClassMethods.digest_auth. Only one of :+basic_auth+ and :+digest_auth+ can be used at a time; if you try using both, you'll get an ArgumentError.
# * :+format+: see HTTParty::ClassMethods.format.
# * :+headers+: see HTTParty::ClassMethods.headers. Must be a an object which responds to #to_hash.
# * :+maintain_method_across_redirects+: see HTTParty::ClassMethods.maintain_method_across_redirects.
# * :+no_follow+: see HTTParty::ClassMethods.no_follow.
# * :+parser+: see HTTParty::ClassMethods.parser.
# * :+uri_adapter+: see HTTParty::ClassMethods.uri_adapter
# * :+connection_adapter+: see HTTParty::ClassMethods.connection_adapter.
# * :+pem+: see HTTParty::ClassMethods.pem.
# * :+query_string_normalizer+: see HTTParty::ClassMethods.query_string_normalizer
# * :+ssl_ca_file+: see HTTParty::ClassMethods.ssl_ca_file.
# * :+ssl_ca_path+: see HTTParty::ClassMethods.ssl_ca_path.
#
# source://httparty//lib/httparty.rb#64
module HTTParty::ClassMethods
  # Allows setting a base uri to be used for each request.
  # Will normalize uri to include http, etc.
  #
  #   class Foo
  #     include HTTParty
  #     base_uri 'twitter.com'
  #   end
  #
  # source://httparty//lib/httparty.rb#107
  def base_uri(uri = T.unsafe(nil)); end

  # Allows setting basic authentication username and password.
  #
  #   class Foo
  #     include HTTParty
  #     basic_auth 'username', 'password'
  #   end
  #
  # source://httparty//lib/httparty.rb#118
  def basic_auth(u, p); end

  # source://httparty//lib/httparty.rb#589
  def build_request(http_method, path, options = T.unsafe(nil)); end

  # Allows setting of SSL ciphers to use.  This only works in Ruby 1.9+.
  # You can get a list of valid specific ciphers from OpenSSL::Cipher.ciphers.
  # You also can specify a cipher suite here, listed here at openssl.org:
  # http://www.openssl.org/docs/apps/ciphers.html#CIPHER_SUITE_NAMES
  #
  #   class Foo
  #     include HTTParty
  #     ciphers "RC4-SHA"
  #   end
  #
  # source://httparty//lib/httparty.rb#424
  def ciphers(cipher_names); end

  # Allows setting a custom connection_adapter for the http connections
  #
  # @example
  #   class Foo
  #   include HTTParty
  #   connection_adapter Proc.new {|uri, options| ... }
  #   end
  # @example provide optional configuration for your connection_adapter
  #   class Foo
  #   include HTTParty
  #   connection_adapter Proc.new {|uri, options| ... }, {foo: :bar}
  #   end
  # @see HTTParty::ConnectionAdapter
  #
  # source://httparty//lib/httparty.rb#499
  def connection_adapter(custom_adapter = T.unsafe(nil), options = T.unsafe(nil)); end

  # @raise [ArgumentError]
  #
  # source://httparty//lib/httparty.rb#241
  def cookies(h = T.unsafe(nil)); end

  # Perform a COPY request to a path
  #
  # source://httparty//lib/httparty.rb#561
  def copy(path, options = T.unsafe(nil), &block); end

  # Set an output stream for debugging, defaults to $stderr.
  # The output stream is passed on to Net::HTTP#set_debug_output.
  #
  #   class Foo
  #     include HTTParty
  #     debug_output $stderr
  #   end
  #
  # source://httparty//lib/httparty.rb#221
  def debug_output(stream = T.unsafe(nil)); end

  # Returns the value of attribute default_options.
  #
  # source://httparty//lib/httparty.rb#596
  def default_options; end

  # Allows setting default parameters to be appended to each request.
  # Great for api keys and such.
  #
  #   class Foo
  #     include HTTParty
  #     default_params api_key: 'secret', another: 'foo'
  #   end
  #
  # @raise [ArgumentError]
  #
  # source://httparty//lib/httparty.rb#161
  def default_params(h = T.unsafe(nil)); end

  # Allows setting a default timeout for all HTTP calls
  # Timeout is specified in seconds.
  #
  #   class Foo
  #     include HTTParty
  #     default_timeout 10
  #   end
  #
  # source://httparty//lib/httparty.rb#174
  def default_timeout(value); end

  # Perform a DELETE request to a path
  #
  # source://httparty//lib/httparty.rb#551
  def delete(path, options = T.unsafe(nil), &block); end

  # Allows setting digest authentication username and password.
  #
  #   class Foo
  #     include HTTParty
  #     digest_auth 'username', 'password'
  #   end
  #
  # source://httparty//lib/httparty.rb#128
  def digest_auth(u, p); end

  # Do not send rails style query strings.
  # Specifically, don't use bracket notation when sending an array
  #
  # For a query:
  #   get '/', query: {selected_ids: [1,2,3]}
  #
  # The default query string looks like this:
  #   /?selected_ids[]=1&selected_ids[]=2&selected_ids[]=3
  #
  # Call `disable_rails_query_string_format` to transform the query string
  # into:
  #   /?selected_ids=1&selected_ids=2&selected_ids=3
  #
  # @example
  #   class Foo
  #   include HTTParty
  #   disable_rails_query_string_format
  #   end
  #
  # source://httparty//lib/httparty.rb#150
  def disable_rails_query_string_format; end

  # Proceed to the location header when an HTTP response dictates a redirect.
  # Redirects are always followed by default.
  #
  # @example
  #   class Foo
  #   include HTTParty
  #   base_uri 'http://google.com'
  #   follow_redirects true
  #   end
  #
  # source://httparty//lib/httparty.rb#255
  def follow_redirects(value = T.unsafe(nil)); end

  # Allows setting the format with which to parse.
  # Must be one of the allowed formats ie: json, xml
  #
  #   class Foo
  #     include HTTParty
  #     format :json
  #   end
  #
  # source://httparty//lib/httparty.rb#266
  def format(f = T.unsafe(nil)); end

  # Allows making a get request to a url.
  #
  #   class Foo
  #     include HTTParty
  #   end
  #
  #   # Simple get with full url
  #   Foo.get('http://foo.com/resource.json')
  #
  #   # Simple get with full url and query parameters
  #   # ie: http://foo.com/resource.json?limit=10
  #   Foo.get('http://foo.com/resource.json', query: {limit: 10})
  #
  # source://httparty//lib/httparty.rb#520
  def get(path, options = T.unsafe(nil), &block); end

  # Perform a HEAD request to a path
  #
  # source://httparty//lib/httparty.rb#566
  def head(path, options = T.unsafe(nil), &block); end

  # Allows setting HTTP headers to be used for each request.
  #
  #   class Foo
  #     include HTTParty
  #     headers 'Accept' => 'text/html'
  #   end
  #
  # source://httparty//lib/httparty.rb#231
  def headers(h = T.unsafe(nil)); end

  # Allows setting http proxy information to be used
  #
  #   class Foo
  #     include HTTParty
  #     http_proxy 'http://foo.com', 80, 'user', 'pass'
  #   end
  #
  # source://httparty//lib/httparty.rb#93
  def http_proxy(addr = T.unsafe(nil), port = T.unsafe(nil), user = T.unsafe(nil), pass = T.unsafe(nil)); end

  # source://httparty//lib/httparty.rb#581
  def lock(path, options = T.unsafe(nil), &block); end

  # Turns on logging
  #
  #   class Foo
  #     include HTTParty
  #     logger Logger.new('http_logger'), :info, :apache
  #   end
  #
  # source://httparty//lib/httparty.rb#71
  def logger(logger, level = T.unsafe(nil), format = T.unsafe(nil)); end

  # Declare that you wish to maintain the chosen HTTP method across redirects.
  # The default behavior is to follow redirects via the GET method, except
  # if you are making a HEAD request, in which case the default is to
  # follow all redirects with HEAD requests.
  # If you wish to maintain the original method, you can set this option to true.
  #
  # @example
  #   class Foo
  #   include HTTParty
  #   base_uri 'http://google.com'
  #   maintain_method_across_redirects true
  #   end
  #
  # source://httparty//lib/httparty.rb#312
  def maintain_method_across_redirects(value = T.unsafe(nil)); end

  # Perform a MKCOL request to a path
  #
  # source://httparty//lib/httparty.rb#577
  def mkcol(path, options = T.unsafe(nil), &block); end

  # Perform a MOVE request to a path
  #
  # source://httparty//lib/httparty.rb#556
  def move(path, options = T.unsafe(nil), &block); end

  # Declare whether or not to follow redirects.  When true, an
  # {HTTParty::RedirectionTooDeep} error will raise upon encountering a
  # redirect. You can then gain access to the response object via
  # HTTParty::RedirectionTooDeep#response.
  #
  # @example
  #   class Foo
  #   include HTTParty
  #   base_uri 'http://google.com'
  #   no_follow true
  #   end
  #
  #   begin
  #   Foo.get('/')
  #   rescue HTTParty::RedirectionTooDeep => e
  #   puts e.response.body
  #   end
  # @see HTTParty::ResponseError#response
  #
  # source://httparty//lib/httparty.rb#295
  def no_follow(value = T.unsafe(nil)); end

  # Allows setting a default open_timeout for all HTTP calls in seconds
  #
  #   class Foo
  #     include HTTParty
  #     open_timeout 10
  #   end
  #
  # source://httparty//lib/httparty.rb#185
  def open_timeout(value); end

  # Perform an OPTIONS request to a path
  #
  # source://httparty//lib/httparty.rb#572
  def options(path, options = T.unsafe(nil), &block); end

  # Allows setting a custom parser for the response.
  #
  #   class Foo
  #     include HTTParty
  #     parser Proc.new {|data| ...}
  #   end
  #
  # source://httparty//lib/httparty.rb#464
  def parser(custom_parser = T.unsafe(nil)); end

  # Perform a PATCH request to a path
  #
  # source://httparty//lib/httparty.rb#541
  def patch(path, options = T.unsafe(nil), &block); end

  # Allows setting a PEM file to be used
  #
  #   class Foo
  #     include HTTParty
  #     pem File.read('/home/user/my.pem'), "optional password"
  #   end
  #
  # source://httparty//lib/httparty.rb#340
  def pem(pem_contents, password = T.unsafe(nil)); end

  # Allows setting a PKCS12 file to be used
  #
  #   class Foo
  #     include HTTParty
  #     pkcs12 File.read('/home/user/my.p12'), "password"
  #   end
  #
  # source://httparty//lib/httparty.rb#351
  def pkcs12(p12_contents, password); end

  # Allows making a post request to a url.
  #
  #   class Foo
  #     include HTTParty
  #   end
  #
  #   # Simple post with full url and setting the body
  #   Foo.post('http://foo.com/resources', body: {bar: 'baz'})
  #
  #   # Simple post with full url using :query option,
  #   # which appends the parameters to the URI.
  #   Foo.post('http://foo.com/resources', query: {bar: 'baz'})
  #
  # source://httparty//lib/httparty.rb#536
  def post(path, options = T.unsafe(nil), &block); end

  # Perform a PUT request to a path
  #
  # source://httparty//lib/httparty.rb#546
  def put(path, options = T.unsafe(nil), &block); end

  # Override the way query strings are normalized.
  # Helpful for overriding the default rails normalization of Array queries.
  #
  # For a query:
  #   get '/', query: {selected_ids: [1,2,3]}
  #
  # The default query string normalizer returns:
  #   /?selected_ids[]=1&selected_ids[]=2&selected_ids[]=3
  #
  # Let's change it to this:
  #  /?selected_ids=1&selected_ids=2&selected_ids=3
  #
  # Pass a Proc to the query normalizer which accepts the yielded query.
  #
  # @example Modifying Array query strings
  #   class ServiceWrapper
  #   include HTTParty
  #
  #   query_string_normalizer proc { |query|
  #   query.map do |key, value|
  #   value.map {|v| "#{key}=#{v}"}
  #   end.join('&')
  #   }
  #   end
  # @param normalizer [Proc] custom query string normalizer.
  # @yield [Hash, String] query string
  # @yieldreturn [Array] an array that will later be joined with '&'
  #
  # source://httparty//lib/httparty.rb#384
  def query_string_normalizer(normalizer); end

  # Raises HTTParty::ResponseError if response's code matches this statuses
  #
  #   class Foo
  #     include HTTParty
  #     raise_on [404, 500, '5[0-9]*']
  #   end
  #
  # source://httparty//lib/httparty.rb#83
  def raise_on(codes = T.unsafe(nil)); end

  # Allows setting a default read_timeout for all HTTP calls in seconds
  #
  #   class Foo
  #     include HTTParty
  #     read_timeout 10
  #   end
  #
  # source://httparty//lib/httparty.rb#196
  def read_timeout(value); end

  # Declare that you wish to resend the full HTTP request across redirects,
  # even on redirects that should logically become GET requests.
  # A 303 redirect in HTTP signifies that the redirected url should normally
  # retrieved using a GET request, for instance, it is the output of a previous
  # POST. maintain_method_across_redirects respects this behavior, but you
  # can force HTTParty to resend_on_redirect even on 303 responses.
  #
  # @example
  #   class Foo
  #   include HTTParty
  #   base_uri 'http://google.com'
  #   resend_on_redirect
  #   end
  #
  # source://httparty//lib/httparty.rb#330
  def resend_on_redirect(value = T.unsafe(nil)); end

  # Deactivate automatic decompression of the response body.
  # This will require you to explicitly handle body decompression
  # by inspecting the Content-Encoding response header.
  #
  # Refer to docs/README.md "HTTP Compression" section for
  # further details.
  #
  # @example
  #   class Foo
  #   include HTTParty
  #   skip_decompression
  #   end
  #
  # source://httparty//lib/httparty.rb#411
  def skip_decompression(value = T.unsafe(nil)); end

  # Allows setting an OpenSSL certificate authority file.  The file
  # should contain one or more certificates in PEM format.
  #
  # Setting this option enables certificate verification.  All
  # certificates along a chain must be available in ssl_ca_file or
  # ssl_ca_path for verification to succeed.
  #
  #
  #   class Foo
  #     include HTTParty
  #     ssl_ca_file '/etc/ssl/certs/ca-certificates.crt'
  #   end
  #
  # source://httparty//lib/httparty.rb#440
  def ssl_ca_file(path); end

  # Allows setting an OpenSSL certificate authority path (directory).
  #
  # Setting this option enables certificate verification.  All
  # certificates along a chain must be available in ssl_ca_file or
  # ssl_ca_path for verification to succeed.
  #
  #   class Foo
  #     include HTTParty
  #     ssl_ca_path '/etc/ssl/certs/'
  #   end
  #
  # source://httparty//lib/httparty.rb#454
  def ssl_ca_path(path); end

  # Allows setting of SSL version to use. This only works in Ruby 1.9+.
  # You can get a list of valid versions from OpenSSL::SSL::SSLContext::METHODS.
  #
  #   class Foo
  #     include HTTParty
  #     ssl_version :SSLv3
  #   end
  #
  # source://httparty//lib/httparty.rb#395
  def ssl_version(version); end

  # source://httparty//lib/httparty.rb#585
  def unlock(path, options = T.unsafe(nil), &block); end

  # Allows setting a custom URI adapter.
  #
  #   class Foo
  #     include HTTParty
  #     uri_adapter Addressable::URI
  #   end
  #
  # @raise [ArgumentError]
  #
  # source://httparty//lib/httparty.rb#479
  def uri_adapter(uri_adapter); end

  # Allows setting a default write_timeout for all HTTP calls in seconds
  # Supported by Ruby > 2.6.0
  #
  #   class Foo
  #     include HTTParty
  #     write_timeout 10
  #   end
  #
  # source://httparty//lib/httparty.rb#208
  def write_timeout(value); end

  private

  # source://httparty//lib/httparty.rb#604
  def ensure_method_maintained_across_redirects(options); end

  # source://httparty//lib/httparty.rb#610
  def perform_request(http_method, path, options, &block); end

  # source://httparty//lib/httparty.rb#614
  def process_cookies(options); end

  # source://httparty//lib/httparty.rb#620
  def validate_format; end

  # @raise [ArgumentError]
  #
  # source://httparty//lib/httparty.rb#600
  def validate_timeout_argument(timeout_type, value); end
end

# Default connection adapter that returns a new Net::HTTP each time
#
# == Custom Connection Factories
#
# If you like to implement your own connection adapter, subclassing
# HTTParty::ConnectionAdapter will make it easier. Just override
# the #connection method. The uri and options attributes will have
# all the info you need to construct your http connection. Whatever
# you return from your connection method needs to adhere to the
# Net::HTTP interface as this is what HTTParty expects.
#
# === Configuration
# There is lots of configuration data available for your connection adapter
# in the #options attribute. It is up to you to interpret them within your
# connection adapter. Take a look at the implementation of
# HTTParty::ConnectionAdapter#connection for examples of how they are used.
# The keys used in options are
# * :+timeout+: timeout in seconds
# * :+open_timeout+: http connection open_timeout in seconds, overrides timeout if set
# * :+read_timeout+: http connection read_timeout in seconds, overrides timeout if set
# * :+write_timeout+: http connection write_timeout in seconds, overrides timeout if set (Ruby >= 2.6.0 required)
# * :+debug_output+: see HTTParty::ClassMethods.debug_output.
# * :+cert_store+: contains certificate data. see method 'attach_ssl_certificates'
# * :+pem+: contains pem client certificate data. see method 'attach_ssl_certificates'
# * :+p12+: contains PKCS12 client client certificate data.  see method 'attach_ssl_certificates'
# * :+verify+: verify the server’s certificate against the ca certificate.
# * :+verify_peer+: set to false to turn off server verification but still send client certificate
# * :+ssl_ca_file+: see HTTParty::ClassMethods.ssl_ca_file.
# * :+ssl_ca_path+: see HTTParty::ClassMethods.ssl_ca_path.
# * :+ssl_version+: SSL versions to allow. see method 'attach_ssl_certificates'
# * :+ciphers+: The list of SSL ciphers to support
# * :+connection_adapter_options+: contains the hash you passed to HTTParty.connection_adapter when you configured your connection adapter
# * :+local_host+: The local address to bind to
# * :+local_port+: The local port to bind to
# * :+http_proxyaddr+: HTTP Proxy address
# * :+http_proxyport+: HTTP Proxy port
# * :+http_proxyuser+: HTTP Proxy user
# * :+http_proxypass+: HTTP Proxy password
#
# === Inherited methods
# * :+clean_host+: Method used to sanitize host names
#
# @example log the uri and options
#   class LoggingConnectionAdapter < HTTParty::ConnectionAdapter
#   def connection
#   puts uri
#   puts options
#   Net::HTTP.new(uri)
#   end
#   end
# @example count number of http calls
#   class CountingConnectionAdapter < HTTParty::ConnectionAdapter
#   @@count = 0
#
#   self.count
#   @@count
#   end
#
#   def connection
#   self.count += 1
#   super
#   end
#   end
#
# source://httparty//lib/httparty/connection_adapter.rb#69
class HTTParty::ConnectionAdapter
  # @raise [ArgumentError]
  # @return [ConnectionAdapter] a new instance of ConnectionAdapter
  #
  # source://httparty//lib/httparty/connection_adapter.rb#91
  def initialize(uri, options = T.unsafe(nil)); end

  # source://httparty//lib/httparty/connection_adapter.rb#99
  def connection; end

  # Returns the value of attribute options.
  #
  # source://httparty//lib/httparty/connection_adapter.rb#89
  def options; end

  # Returns the value of attribute uri.
  #
  # source://httparty//lib/httparty/connection_adapter.rb#89
  def uri; end

  private

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/connection_adapter.rb#169
  def add_max_retries?(max_retries); end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/connection_adapter.rb#165
  def add_timeout?(timeout); end

  # source://httparty//lib/httparty/connection_adapter.rb#189
  def attach_ssl_certificates(http, options); end

  # source://httparty//lib/httparty/connection_adapter.rb#173
  def clean_host(host); end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/connection_adapter.rb#181
  def ssl_implied?(uri); end

  # source://httparty//lib/httparty/connection_adapter.rb#177
  def strip_ipv6_brackets(host); end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/connection_adapter.rb#185
  def verify_ssl_certificate?; end

  class << self
    # Public
    #
    # source://httparty//lib/httparty/connection_adapter.rb#79
    def call(uri, options); end

    # source://httparty//lib/httparty/connection_adapter.rb#83
    def default_cert_store; end
  end
end

# source://httparty//lib/httparty/connection_adapter.rb#73
HTTParty::ConnectionAdapter::OPTION_DEFAULTS = T.let(T.unsafe(nil), Hash)

# Private: Regex used to strip brackets from IPv6 URIs.
#
# source://httparty//lib/httparty/connection_adapter.rb#71
HTTParty::ConnectionAdapter::StripIpv6BracketsRegex = T.let(T.unsafe(nil), Regexp)

# source://httparty//lib/httparty/cookie_hash.rb#3
class HTTParty::CookieHash < ::Hash
  # source://httparty//lib/httparty/cookie_hash.rb#6
  def add_cookies(data); end

  # source://httparty//lib/httparty/cookie_hash.rb#20
  def to_cookie_string; end
end

# source://httparty//lib/httparty/cookie_hash.rb#4
HTTParty::CookieHash::CLIENT_COOKIES = T.let(T.unsafe(nil), Array)

# Decompresses the response body based on the Content-Encoding header.
#
# Net::HTTP automatically decompresses Content-Encoding values "gzip" and "deflate".
# This class will handle "br" (Brotli) and "compress" (LZW) if the requisite
# gems are installed. Otherwise, it returns nil if the body data cannot be
# decompressed.
#
# @abstract Read the HTTP Compression section for more information.
#
# source://httparty//lib/httparty/decompressor.rb#12
class HTTParty::Decompressor
  # @param body [String] - the response body of the request
  # @param encoding [Symbol] - the Content-Encoding algorithm used to encode the body
  # @return [Decompressor] a new instance of Decompressor
  #
  # source://httparty//lib/httparty/decompressor.rb#34
  def initialize(body, encoding); end

  # The response body of the request
  #
  # @return [String]
  #
  # source://httparty//lib/httparty/decompressor.rb#26
  def body; end

  # Perform decompression on the response body
  #
  # @return [String] the decompressed body
  # @return [nil] when the response body is nil or cannot decompressed
  #
  # source://httparty//lib/httparty/decompressor.rb#42
  def decompress; end

  # The Content-Encoding algorithm used to encode the body
  #
  # @return [Symbol] e.g. :gzip
  #
  # source://httparty//lib/httparty/decompressor.rb#30
  def encoding; end

  protected

  # source://httparty//lib/httparty/decompressor.rb#72
  def brotli; end

  # source://httparty//lib/httparty/decompressor.rb#59
  def decompress_supported_encoding; end

  # source://httparty//lib/httparty/decompressor.rb#81
  def lzw; end

  # source://httparty//lib/httparty/decompressor.rb#68
  def none; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/decompressor.rb#55
  def supports_encoding?; end

  # source://httparty//lib/httparty/decompressor.rb#93
  def zstd; end
end

# "gzip" and "deflate" are handled by Net::HTTP
# hence they do not need to be handled by HTTParty
#
# source://httparty//lib/httparty/decompressor.rb#16
HTTParty::Decompressor::SupportedEncodings = T.let(T.unsafe(nil), Hash)

# Exception that is raised when request redirects and location header is present more than once
#
# source://httparty//lib/httparty/exceptions.rb#34
class HTTParty::DuplicateLocationHeader < ::HTTParty::ResponseError; end

# @abstract Exceptions raised by HTTParty inherit from Error
#
# source://httparty//lib/httparty/exceptions.rb#5
class HTTParty::Error < ::StandardError; end

# source://httparty//lib/httparty/hash_conversions.rb#6
module HTTParty::HashConversions
  class << self
    # source://httparty//lib/httparty/hash_conversions.rb#36
    def normalize_keys(key, value); end

    # @example normalize_param(:name, "Bob Jones") #=> "name=Bob%20Jones&"
    # @param key [Object] The key for the param.
    # @param value [Object] The value for the param.
    # @return [String] This key value pair as a param
    #
    # source://httparty//lib/httparty/hash_conversions.rb#28
    def normalize_param(key, value); end

    # @example
    #   { name: "Bob",
    #   address: {
    #   street: '111 Ruby Ave.',
    #   city: 'Ruby Central',
    #   phones: ['111-111-1111', '222-222-2222']
    #   }
    #   }.to_params
    #   #=> "name=Bob&address[city]=Ruby Central&address[phones][]=111-111-1111&address[phones][]=222-222-2222&address[street]=111 Ruby Ave."
    # @return [String] This hash as a query string
    #
    # source://httparty//lib/httparty/hash_conversions.rb#18
    def to_params(hash); end
  end
end

# source://httparty//lib/httparty/headers_processor.rb#4
class HTTParty::HeadersProcessor
  # @return [HeadersProcessor] a new instance of HeadersProcessor
  #
  # source://httparty//lib/httparty/headers_processor.rb#7
  def initialize(headers, options); end

  # source://httparty//lib/httparty/headers_processor.rb#12
  def call; end

  # Returns the value of attribute headers.
  #
  # source://httparty//lib/httparty/headers_processor.rb#5
  def headers; end

  # Returns the value of attribute options.
  #
  # source://httparty//lib/httparty/headers_processor.rb#5
  def options; end

  private

  # source://httparty//lib/httparty/headers_processor.rb#21
  def process_dynamic_headers; end
end

# source://httparty//lib/httparty/logger/apache_formatter.rb#4
module HTTParty::Logger
  class << self
    # @raise [HTTParty::Error]
    #
    # source://httparty//lib/httparty/logger/logger.rb#17
    def add_formatter(name, formatter); end

    # source://httparty//lib/httparty/logger/logger.rb#22
    def build(logger, level, formatter); end

    # source://httparty//lib/httparty/logger/logger.rb#9
    def formatters; end
  end
end

# source://httparty//lib/httparty/logger/apache_formatter.rb#5
class HTTParty::Logger::ApacheFormatter
  # @return [ApacheFormatter] a new instance of ApacheFormatter
  #
  # source://httparty//lib/httparty/logger/apache_formatter.rb#10
  def initialize(logger, level); end

  # source://httparty//lib/httparty/logger/apache_formatter.rb#15
  def format(request, response); end

  # Returns the value of attribute level.
  #
  # source://httparty//lib/httparty/logger/apache_formatter.rb#8
  def level; end

  # Sets the attribute level
  #
  # @param value the value to set the attribute level to.
  #
  # source://httparty//lib/httparty/logger/apache_formatter.rb#8
  def level=(_arg0); end

  # Returns the value of attribute logger.
  #
  # source://httparty//lib/httparty/logger/apache_formatter.rb#8
  def logger; end

  # Sets the attribute logger
  #
  # @param value the value to set the attribute logger to.
  #
  # source://httparty//lib/httparty/logger/apache_formatter.rb#8
  def logger=(_arg0); end

  private

  # source://httparty//lib/httparty/logger/apache_formatter.rb#42
  def content_length; end

  # source://httparty//lib/httparty/logger/apache_formatter.rb#30
  def current_time; end

  # source://httparty//lib/httparty/logger/apache_formatter.rb#34
  def http_method; end

  # source://httparty//lib/httparty/logger/apache_formatter.rb#26
  def message; end

  # source://httparty//lib/httparty/logger/apache_formatter.rb#38
  def path; end

  # Returns the value of attribute request.
  #
  # source://httparty//lib/httparty/logger/apache_formatter.rb#24
  def request; end

  # Returns the value of attribute response.
  #
  # source://httparty//lib/httparty/logger/apache_formatter.rb#24
  def response; end
end

# source://httparty//lib/httparty/logger/apache_formatter.rb#6
HTTParty::Logger::ApacheFormatter::TAG_NAME = T.let(T.unsafe(nil), String)

# source://httparty//lib/httparty/logger/curl_formatter.rb#5
class HTTParty::Logger::CurlFormatter
  # @return [CurlFormatter] a new instance of CurlFormatter
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#12
  def initialize(logger, level); end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#18
  def format(request, response); end

  # Returns the value of attribute level.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#10
  def level; end

  # Sets the attribute level
  #
  # @param value the value to set the attribute level to.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#10
  def level=(_arg0); end

  # Returns the value of attribute logger.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#10
  def logger; end

  # Sets the attribute logger
  #
  # @param value the value to set the attribute logger to.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#10
  def logger=(_arg0); end

  private

  # source://httparty//lib/httparty/logger/curl_formatter.rb#88
  def current_time; end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#84
  def log(direction, line = T.unsafe(nil)); end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#80
  def log_hash(hash); end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#59
  def log_headers; end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#66
  def log_query; end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#33
  def log_request; end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#41
  def log_response; end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#73
  def log_response_headers; end

  # source://httparty//lib/httparty/logger/curl_formatter.rb#48
  def log_url; end

  # Returns the value of attribute messages.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#31
  def messages; end

  # Sets the attribute messages
  #
  # @param value the value to set the attribute messages to.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#31
  def messages=(_arg0); end

  # Returns the value of attribute request.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#30
  def request; end

  # Returns the value of attribute response.
  #
  # source://httparty//lib/httparty/logger/curl_formatter.rb#30
  def response; end
end

# source://httparty//lib/httparty/logger/curl_formatter.rb#8
HTTParty::Logger::CurlFormatter::IN = T.let(T.unsafe(nil), String)

# source://httparty//lib/httparty/logger/curl_formatter.rb#7
HTTParty::Logger::CurlFormatter::OUT = T.let(T.unsafe(nil), String)

# source://httparty//lib/httparty/logger/curl_formatter.rb#6
HTTParty::Logger::CurlFormatter::TAG_NAME = T.let(T.unsafe(nil), String)

# source://httparty//lib/httparty/logger/logstash_formatter.rb#5
class HTTParty::Logger::LogstashFormatter
  # @return [LogstashFormatter] a new instance of LogstashFormatter
  #
  # source://httparty//lib/httparty/logger/logstash_formatter.rb#10
  def initialize(logger, level); end

  # source://httparty//lib/httparty/logger/logstash_formatter.rb#15
  def format(request, response); end

  # Returns the value of attribute level.
  #
  # source://httparty//lib/httparty/logger/logstash_formatter.rb#8
  def level; end

  # Sets the attribute level
  #
  # @param value the value to set the attribute level to.
  #
  # source://httparty//lib/httparty/logger/logstash_formatter.rb#8
  def level=(_arg0); end

  # Returns the value of attribute logger.
  #
  # source://httparty//lib/httparty/logger/logstash_formatter.rb#8
  def logger; end

  # Sets the attribute logger
  #
  # @param value the value to set the attribute logger to.
  #
  # source://httparty//lib/httparty/logger/logstash_formatter.rb#8
  def logger=(_arg0); end

  private

  # source://httparty//lib/httparty/logger/logstash_formatter.rb#57
  def content_length; end

  # source://httparty//lib/httparty/logger/logstash_formatter.rb#45
  def current_time; end

  # source://httparty//lib/httparty/logger/logstash_formatter.rb#49
  def http_method; end

  # source://httparty//lib/httparty/logger/logstash_formatter.rb#26
  def logstash_message; end

  # source://httparty//lib/httparty/logger/logstash_formatter.rb#41
  def message; end

  # source://httparty//lib/httparty/logger/logstash_formatter.rb#53
  def path; end

  # Returns the value of attribute request.
  #
  # source://httparty//lib/httparty/logger/logstash_formatter.rb#24
  def request; end

  # Returns the value of attribute response.
  #
  # source://httparty//lib/httparty/logger/logstash_formatter.rb#24
  def response; end
end

# source://httparty//lib/httparty/logger/logstash_formatter.rb#6
HTTParty::Logger::LogstashFormatter::TAG_NAME = T.let(T.unsafe(nil), String)

# source://httparty//lib/httparty/module_inheritable_attributes.rb#4
module HTTParty::ModuleInheritableAttributes
  mixes_in_class_methods ::HTTParty::ModuleInheritableAttributes::ClassMethods

  class << self
    # borrowed from Rails 3.2 ActiveSupport
    #
    # source://httparty//lib/httparty/module_inheritable_attributes.rb#10
    def hash_deep_dup(hash); end

    # @private
    #
    # source://httparty//lib/httparty/module_inheritable_attributes.rb#5
    def included(base); end
  end
end

# source://httparty//lib/httparty/module_inheritable_attributes.rb#26
module HTTParty::ModuleInheritableAttributes::ClassMethods
  # source://httparty//lib/httparty/module_inheritable_attributes.rb#38
  def inherited(subclass); end

  # source://httparty//lib/httparty/module_inheritable_attributes.rb#27
  def mattr_inheritable(*args); end
end

# The default parser used by HTTParty, supports xml, json, html, csv and
# plain text.
#
# == Custom Parsers
#
# If you'd like to do your own custom parsing, subclassing HTTParty::Parser
# will make that process much easier. There are a few different ways you can
# utilize HTTParty::Parser as a superclass.
#
# @abstract Read the Custom Parsers section for more information.
# @example Intercept the parsing for all formats
#   class SimpleParser < HTTParty::Parser
#   def parse
#   perform_parsing
#   end
#   end
# @example Add the atom format and parsing method to the default parser
#   class AtomParsingIncluded < HTTParty::Parser
#   SupportedFormats.merge!(
#   {"application/atom+xml" => :atom}
#   )
#
#   def atom
#   perform_atom_parsing
#   end
#   end
# @example Only support the atom format
#   class ParseOnlyAtom < HTTParty::Parser
#   SupportedFormats = {"application/atom+xml" => :atom}
#
#   def atom
#   perform_atom_parsing
#   end
#   end
#
# source://httparty//lib/httparty/parser.rb#41
class HTTParty::Parser
  # @return [Parser] a new instance of Parser
  #
  # source://httparty//lib/httparty/parser.rb#97
  def initialize(body, format); end

  # The response body of the request
  #
  # @return [String]
  #
  # source://httparty//lib/httparty/parser.rb#60
  def body; end

  # The intended parsing format for the request
  #
  # @return [Symbol] e.g. :json
  #
  # source://httparty//lib/httparty/parser.rb#64
  def format; end

  # @return [Object] the parsed body
  # @return [nil] when the response body is nil, an empty string, spaces only or "null"
  #
  # source://httparty//lib/httparty/parser.rb#104
  def parse; end

  protected

  # source://httparty//lib/httparty/parser.rb#132
  def csv; end

  # source://httparty//lib/httparty/parser.rb#137
  def html; end

  # source://httparty//lib/httparty/parser.rb#127
  def json; end

  # source://httparty//lib/httparty/parser.rb#149
  def parse_supported_format; end

  # source://httparty//lib/httparty/parser.rb#141
  def plain; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/parser.rb#145
  def supports_format?; end

  # source://httparty//lib/httparty/parser.rb#120
  def xml; end

  class << self
    # Instantiate the parser and call {#parse}.
    #
    # @param body [String] the response body
    # @param format [Symbol] the response format
    # @return parsed response
    #
    # source://httparty//lib/httparty/parser.rb#70
    def call(body, format); end

    # @param mimetype [String] response MIME type
    # @return [Symbol]
    # @return [nil] mime type not supported
    #
    # source://httparty//lib/httparty/parser.rb#82
    def format_from_mimetype(mimetype); end

    # @return [Hash] the SupportedFormats hash
    #
    # source://httparty//lib/httparty/parser.rb#75
    def formats; end

    # @return [Array<Symbol>] list of supported formats
    #
    # source://httparty//lib/httparty/parser.rb#87
    def supported_formats; end

    # @param format [Symbol] e.g. :json, :xml
    # @return [Boolean]
    #
    # source://httparty//lib/httparty/parser.rb#93
    def supports_format?(format); end
  end
end

# source://httparty//lib/httparty/parser.rb#42
HTTParty::Parser::SupportedFormats = T.let(T.unsafe(nil), Hash)

# source://httparty//lib/httparty/parser.rb#125
HTTParty::Parser::UTF8_BOM = T.let(T.unsafe(nil), String)

# Exception that is raised when request has redirected too many times.
# Calling {#response} returns the Net:HTTP response object.
#
# source://httparty//lib/httparty/exceptions.rb#31
class HTTParty::RedirectionTooDeep < ::HTTParty::ResponseError; end

# source://httparty//lib/httparty/request/multipart_boundary.rb#6
class HTTParty::Request
  # @return [Request] a new instance of Request
  #
  # source://httparty//lib/httparty/request.rb#61
  def initialize(http_method, path, o = T.unsafe(nil)); end

  # source://httparty//lib/httparty/request.rb#187
  def _dump(_level); end

  # source://httparty//lib/httparty/request.rb#128
  def base_uri; end

  # source://httparty//lib/httparty/request.rb#146
  def connection_adapter; end

  # source://httparty//lib/httparty/request.rb#138
  def format; end

  # source://httparty//lib/httparty/request.rb#176
  def handle_unauthorized(&block); end

  # Returns the value of attribute http_method.
  #
  # source://httparty//lib/httparty/request.rb#58
  def http_method; end

  # Sets the attribute http_method
  #
  # @param value the value to set the attribute http_method to.
  #
  # source://httparty//lib/httparty/request.rb#58
  def http_method=(_arg0); end

  # Returns the value of attribute last_response.
  #
  # source://httparty//lib/httparty/request.rb#58
  def last_response; end

  # Sets the attribute last_response
  #
  # @param value the value to set the attribute last_response to.
  #
  # source://httparty//lib/httparty/request.rb#58
  def last_response=(_arg0); end

  # Returns the value of attribute last_uri.
  #
  # source://httparty//lib/httparty/request.rb#58
  def last_uri; end

  # Sets the attribute last_uri
  #
  # @param value the value to set the attribute last_uri to.
  #
  # source://httparty//lib/httparty/request.rb#58
  def last_uri=(_arg0); end

  # Returns the value of attribute options.
  #
  # source://httparty//lib/httparty/request.rb#58
  def options; end

  # Sets the attribute options
  #
  # @param value the value to set the attribute options to.
  #
  # source://httparty//lib/httparty/request.rb#58
  def options=(_arg0); end

  # source://httparty//lib/httparty/request.rb#142
  def parser; end

  # Returns the value of attribute path.
  #
  # source://httparty//lib/httparty/request.rb#59
  def path; end

  # source://httparty//lib/httparty/request.rb#79
  def path=(uri); end

  # source://httparty//lib/httparty/request.rb#150
  def perform(&block); end

  # source://httparty//lib/httparty/request.rb#183
  def raw_body; end

  # Returns the value of attribute redirect.
  #
  # source://httparty//lib/httparty/request.rb#58
  def redirect; end

  # Sets the attribute redirect
  #
  # @param value the value to set the attribute redirect to.
  #
  # source://httparty//lib/httparty/request.rb#58
  def redirect=(_arg0); end

  # source://httparty//lib/httparty/request.rb#92
  def request_uri(uri); end

  # source://httparty//lib/httparty/request.rb#100
  def uri; end

  private

  # source://httparty//lib/httparty/request.rb#292
  def assume_utf16_is_big_endian; end

  # source://httparty//lib/httparty/request.rb#380
  def capture_cookies(response); end

  # source://httparty//lib/httparty/request.rb#348
  def check_duplicate_location_header; end

  # Some Web Application Firewalls reject incoming GET requests that have a body
  # if we redirect, and the resulting verb is GET then we will clear the body that
  # may be left behind from the initiating request
  #
  # source://httparty//lib/httparty/request.rb#375
  def clear_body; end

  # source://httparty//lib/httparty/request.rb#200
  def credentials; end

  # source://httparty//lib/httparty/request.rb#421
  def decompress(body, encoding); end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request.rb#261
  def decompress_content?; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request.rb#257
  def digest_auth?; end

  # source://httparty//lib/httparty/request.rb#425
  def encode_text(text, content_type); end

  # Uses the HTTP Content-Type header to determine the format of the
  # response It compares the MIME type returned to the types stored in the
  # SupportedFormats hash
  #
  # source://httparty//lib/httparty/request.rb#393
  def format_from_mimetype(mimetype); end

  # source://httparty//lib/httparty/request.rb#341
  def handle_host_redirection; end

  # source://httparty//lib/httparty/request.rb#317
  def handle_redirection(&block); end

  # source://httparty//lib/httparty/request.rb#296
  def handle_response(raw_body, &block); end

  # source://httparty//lib/httparty/request.rb#196
  def http; end

  # source://httparty//lib/httparty/request.rb#212
  def normalize_query(query); end

  # source://httparty//lib/httparty/request.rb#368
  def parse_response(body); end

  # source://httparty//lib/httparty/request.rb#208
  def password; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request.rb#409
  def post?; end

  # source://httparty//lib/httparty/request.rb#277
  def query_string(uri); end

  # source://httparty//lib/httparty/request.rb#220
  def query_string_normalizer; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request.rb#269
  def response_has_digest_auth_challenge?; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request.rb#359
  def response_redirects?; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request.rb#265
  def response_unauthorized?; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request.rb#355
  def send_authorization_header?; end

  # source://httparty//lib/httparty/request.rb#413
  def set_basic_auth_from_uri; end

  # source://httparty//lib/httparty/request.rb#273
  def setup_digest_auth; end

  # source://httparty//lib/httparty/request.rb#224
  def setup_raw_request; end

  # source://httparty//lib/httparty/request.rb#204
  def username; end

  # @raise [HTTParty::RedirectionTooDeep.new(last_response)]
  #
  # source://httparty//lib/httparty/request.rb#399
  def validate; end

  class << self
    # source://httparty//lib/httparty/request.rb#49
    def _load(data); end
  end
end

# source://httparty//lib/httparty/request/body.rb#7
class HTTParty::Request::Body
  # @return [Body] a new instance of Body
  #
  # source://httparty//lib/httparty/request/body.rb#11
  def initialize(params, query_string_normalizer: T.unsafe(nil), force_multipart: T.unsafe(nil)); end

  # source://httparty//lib/httparty/request/body.rb#25
  def boundary; end

  # source://httparty//lib/httparty/request/body.rb#17
  def call; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request/body.rb#29
  def multipart?; end

  private

  # source://httparty//lib/httparty/request/body.rb#83
  def content_body(object); end

  # source://httparty//lib/httparty/request/body.rb#92
  def content_type(object); end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request/body.rb#71
  def file?(object); end

  # source://httparty//lib/httparty/request/body.rb#99
  def file_name(object); end

  # Returns the value of attribute force_multipart.
  #
  # source://httparty//lib/httparty/request/body.rb#103
  def force_multipart; end

  # source://httparty//lib/httparty/request/body.rb#42
  def generate_multipart; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/request/body.rb#61
  def has_file?(value); end

  # source://httparty//lib/httparty/request/body.rb#75
  def normalize_query(query); end

  # Returns the value of attribute params.
  #
  # source://httparty//lib/httparty/request/body.rb#103
  def params; end

  # Returns the value of attribute query_string_normalizer.
  #
  # source://httparty//lib/httparty/request/body.rb#103
  def query_string_normalizer; end
end

# https://html.spec.whatwg.org/#multipart-form-data
#
# source://httparty//lib/httparty/request/body.rb#36
HTTParty::Request::Body::MULTIPART_FORM_DATA_REPLACEMENT_TABLE = T.let(T.unsafe(nil), Hash)

# source://httparty//lib/httparty/request/body.rb#8
HTTParty::Request::Body::NEWLINE = T.let(T.unsafe(nil), String)

# source://httparty//lib/httparty/request.rb#36
HTTParty::Request::JSON_API_QUERY_STRING_NORMALIZER = T.let(T.unsafe(nil), Proc)

# source://httparty//lib/httparty/request/multipart_boundary.rb#7
class HTTParty::Request::MultipartBoundary
  class << self
    # source://httparty//lib/httparty/request/multipart_boundary.rb#8
    def generate; end
  end
end

# source://httparty//lib/httparty/request.rb#24
HTTParty::Request::NON_RAILS_QUERY_STRING_NORMALIZER = T.let(T.unsafe(nil), Proc)

# source://httparty//lib/httparty/request.rb#7
HTTParty::Request::SupportedHTTPMethods = T.let(T.unsafe(nil), Array)

# source://httparty//lib/httparty/request.rb#22
HTTParty::Request::SupportedURISchemes = T.let(T.unsafe(nil), Array)

# source://httparty//lib/httparty/response.rb#4
class HTTParty::Response
  # @return [Response] a new instance of Response
  #
  # source://httparty//lib/httparty/response.rb#17
  def initialize(request, response, parsed_block, options = T.unsafe(nil)); end

  # source://httparty//lib/httparty/response.rb#119
  def _dump(_level); end

  # source://httparty//lib/httparty/response.rb#64
  def accepted?; end

  # source://httparty//lib/httparty/response.rb#64
  def already_reported?; end

  # source://httparty//lib/httparty/response.rb#64
  def bad_gateway?; end

  # source://httparty//lib/httparty/response.rb#64
  def bad_request?; end

  # Returns the value of attribute body.
  #
  # source://httparty//lib/httparty/response.rb#15
  def body; end

  # source://httparty//lib/httparty/response.rb#64
  def client_error?; end

  # source://httparty//lib/httparty/response.rb#40
  def code; end

  # source://httparty//lib/httparty/response.rb#64
  def conflict?; end

  # source://httparty//lib/httparty/response.rb#64
  def continue?; end

  # source://httparty//lib/httparty/response.rb#64
  def created?; end

  # source://httparty//lib/httparty/response.rb#104
  def display(port = T.unsafe(nil)); end

  # source://httparty//lib/httparty/response.rb#64
  def early_hints?; end

  # source://httparty//lib/httparty/response.rb#64
  def expectation_failed?; end

  # source://httparty//lib/httparty/response.rb#64
  def failed_dependency?; end

  # source://httparty//lib/httparty/response.rb#64
  def forbidden?; end

  # source://httparty//lib/httparty/response.rb#64
  def found?; end

  # source://httparty//lib/httparty/response.rb#64
  def gateway_time_out?; end

  # source://httparty//lib/httparty/response.rb#64
  def gateway_timeout?; end

  # source://httparty//lib/httparty/response.rb#64
  def gone?; end

  # Returns the value of attribute headers.
  #
  # source://httparty//lib/httparty/response.rb#15
  def headers; end

  # source://httparty//lib/httparty/response.rb#44
  def http_version; end

  # source://httparty//lib/httparty/response.rb#64
  def im_used?; end

  # source://httparty//lib/httparty/response.rb#64
  def information?; end

  # source://httparty//lib/httparty/response.rb#53
  def inspect; end

  # source://httparty//lib/httparty/response.rb#64
  def insufficient_storage?; end

  # source://httparty//lib/httparty/response.rb#64
  def internal_server_error?; end

  # source://httparty//lib/httparty/response.rb#64
  def length_required?; end

  # source://httparty//lib/httparty/response.rb#64
  def locked?; end

  # source://httparty//lib/httparty/response.rb#64
  def loop_detected?; end

  # source://httparty//lib/httparty/response.rb#64
  def method_not_allowed?; end

  # source://httparty//lib/httparty/response.rb#64
  def misdirected_request?; end

  # source://httparty//lib/httparty/response.rb#64
  def moved_permanently?; end

  # source://httparty//lib/httparty/response.rb#64
  def multi_status?; end

  # source://httparty//lib/httparty/response.rb#64
  def multiple_choice?; end

  # source://httparty//lib/httparty/response.rb#64
  def multiple_choices?; end

  # source://httparty//lib/httparty/response.rb#64
  def network_authentication_required?; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/response.rb#83
  def nil?; end

  # source://httparty//lib/httparty/response.rb#64
  def no_content?; end

  # source://httparty//lib/httparty/response.rb#64
  def non_authoritative_information?; end

  # source://httparty//lib/httparty/response.rb#64
  def not_acceptable?; end

  # source://httparty//lib/httparty/response.rb#64
  def not_extended?; end

  # source://httparty//lib/httparty/response.rb#64
  def not_found?; end

  # source://httparty//lib/httparty/response.rb#64
  def not_implemented?; end

  # source://httparty//lib/httparty/response.rb#64
  def not_modified?; end

  # source://httparty//lib/httparty/response.rb#64
  def ok?; end

  # source://httparty//lib/httparty/response.rb#36
  def parsed_response; end

  # source://httparty//lib/httparty/response.rb#64
  def partial_content?; end

  # source://httparty//lib/httparty/response.rb#64
  def payload_too_large?; end

  # source://httparty//lib/httparty/response.rb#64
  def payment_required?; end

  # source://httparty//lib/httparty/response.rb#64
  def permanent_redirect?; end

  # source://httparty//lib/httparty/response.rb#64
  def precondition_failed?; end

  # source://httparty//lib/httparty/response.rb#64
  def precondition_required?; end

  # source://httparty//lib/httparty/response.rb#96
  def pretty_print(pp); end

  # source://httparty//lib/httparty/response.rb#64
  def processing?; end

  # source://httparty//lib/httparty/response.rb#64
  def proxy_authentication_required?; end

  # source://httparty//lib/httparty/response.rb#64
  def range_not_satisfiable?; end

  # source://httparty//lib/httparty/response.rb#64
  def redirection?; end

  # Returns the value of attribute request.
  #
  # source://httparty//lib/httparty/response.rb#15
  def request; end

  # source://httparty//lib/httparty/response.rb#64
  def request_entity_too_large?; end

  # source://httparty//lib/httparty/response.rb#64
  def request_header_fields_too_large?; end

  # source://httparty//lib/httparty/response.rb#64
  def request_time_out?; end

  # source://httparty//lib/httparty/response.rb#64
  def request_timeout?; end

  # source://httparty//lib/httparty/response.rb#64
  def request_uri_too_long?; end

  # source://httparty//lib/httparty/response.rb#64
  def requested_range_not_satisfiable?; end

  # source://httparty//lib/httparty/response.rb#64
  def reset_content?; end

  # Returns the value of attribute response.
  #
  # source://httparty//lib/httparty/response.rb#15
  def response; end

  # source://httparty//lib/httparty/response.rb#64
  def see_other?; end

  # source://httparty//lib/httparty/response.rb#64
  def server_error?; end

  # source://httparty//lib/httparty/response.rb#64
  def service_unavailable?; end

  # source://httparty//lib/httparty/response.rb#64
  def success?; end

  # source://httparty//lib/httparty/response.rb#64
  def switch_protocol?; end

  # @yield [_self]
  # @yieldparam _self [HTTParty::Response] the object that the method was called on
  #
  # source://httparty//lib/httparty/response.rb#48
  def tap; end

  # source://httparty//lib/httparty/response.rb#64
  def temporary_redirect?; end

  # source://httparty//lib/httparty/response.rb#88
  def to_s; end

  # source://httparty//lib/httparty/response.rb#64
  def too_many_requests?; end

  # source://httparty//lib/httparty/response.rb#64
  def unauthorized?; end

  # source://httparty//lib/httparty/response.rb#64
  def unavailable_for_legal_reasons?; end

  # source://httparty//lib/httparty/response.rb#64
  def unprocessable_entity?; end

  # source://httparty//lib/httparty/response.rb#64
  def unsupported_media_type?; end

  # source://httparty//lib/httparty/response.rb#64
  def upgrade_required?; end

  # source://httparty//lib/httparty/response.rb#64
  def uri_too_long?; end

  # source://httparty//lib/httparty/response.rb#64
  def use_proxy?; end

  # source://httparty//lib/httparty/response.rb#64
  def variant_also_negotiates?; end

  # source://httparty//lib/httparty/response.rb#64
  def version_not_supported?; end

  protected

  # source://httparty//lib/httparty/response.rb#125
  def method_missing(name, *args, &block); end

  # source://httparty//lib/httparty/response.rb#135
  def throw_exception; end

  private

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/response.rb#114
  def respond_to_missing?(name, *args); end

  # source://httparty//lib/httparty/response.rb#143
  def warn_about_nil_deprecation; end

  class << self
    # source://httparty//lib/httparty/response.rb#9
    def _load(data); end

    # source://httparty//lib/httparty/response.rb#5
    def underscore(string); end
  end
end

# source://httparty//lib/httparty/response.rb#58
HTTParty::Response::CODES_TO_OBJ = T.let(T.unsafe(nil), Hash)

# source://httparty//lib/httparty/response/headers.rb#7
class HTTParty::Response::Headers < ::SimpleDelegator
  include ::Net::HTTPHeader

  # @return [Headers] a new instance of Headers
  #
  # source://httparty//lib/httparty/response/headers.rb#10
  def initialize(header_values = T.unsafe(nil)); end

  # source://httparty//lib/httparty/response/headers.rb#26
  def ==(other); end
end

# response object accessible via the {#response} method.
#
# @abstract Exceptions which inherit from ResponseError contain the Net::HTTP
#
# source://httparty//lib/httparty/exceptions.rb#15
class HTTParty::ResponseError < ::HTTParty::Error
  # Instantiate an instance of ResponseError with a Net::HTTPResponse object
  #
  # @param [Net::HTTPResponse]
  # @return [ResponseError] a new instance of ResponseError
  #
  # source://httparty//lib/httparty/exceptions.rb#23
  def initialize(response); end

  # Returns the response of the last request
  # Net::HTTPOK
  #
  # @return [Net::HTTPResponse] A subclass of Net::HTTPResponse, e.g.
  #
  # source://httparty//lib/httparty/exceptions.rb#19
  def response; end
end

# Allow access to http_response and code by delegation on fragment
#
# source://httparty//lib/httparty/response_fragment.rb#7
class HTTParty::ResponseFragment < ::SimpleDelegator
  # @return [ResponseFragment] a new instance of ResponseFragment
  #
  # source://httparty//lib/httparty/response_fragment.rb#14
  def initialize(fragment, http_response, connection); end

  # source://httparty//lib/httparty/response_fragment.rb#10
  def code; end

  # Returns the value of attribute connection.
  #
  # source://httparty//lib/httparty/response_fragment.rb#8
  def connection; end

  # Returns the value of attribute http_response.
  #
  # source://httparty//lib/httparty/response_fragment.rb#8
  def http_response; end
end

# source://httparty//lib/httparty/text_encoder.rb#4
class HTTParty::TextEncoder
  # @return [TextEncoder] a new instance of TextEncoder
  #
  # source://httparty//lib/httparty/text_encoder.rb#7
  def initialize(text, assume_utf16_is_big_endian: T.unsafe(nil), content_type: T.unsafe(nil)); end

  # Returns the value of attribute assume_utf16_is_big_endian.
  #
  # source://httparty//lib/httparty/text_encoder.rb#5
  def assume_utf16_is_big_endian; end

  # source://httparty//lib/httparty/text_encoder.rb#13
  def call; end

  # Returns the value of attribute content_type.
  #
  # source://httparty//lib/httparty/text_encoder.rb#5
  def content_type; end

  # Returns the value of attribute text.
  #
  # source://httparty//lib/httparty/text_encoder.rb#5
  def text; end

  private

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/text_encoder.rb#23
  def can_encode?; end

  # source://httparty//lib/httparty/text_encoder.rb#60
  def charset; end

  # source://httparty//lib/httparty/text_encoder.rb#35
  def encode_utf_16; end

  # source://httparty//lib/httparty/text_encoder.rb#51
  def encode_with_ruby_encoding; end

  # source://httparty//lib/httparty/text_encoder.rb#27
  def encoded_text; end
end

# Exception raised when you attempt to set a non-existent format
#
# source://httparty//lib/httparty/exceptions.rb#8
class HTTParty::UnsupportedFormat < ::HTTParty::Error; end

# Exception raised when using a URI scheme other than HTTP or HTTPS
#
# source://httparty//lib/httparty/exceptions.rb#11
class HTTParty::UnsupportedURIScheme < ::HTTParty::Error; end

# source://httparty//lib/httparty/utils.rb#4
module HTTParty::Utils
  class << self
    # source://httparty//lib/httparty/utils.rb#5
    def stringify_keys(hash); end
  end
end

# source://httparty//lib/httparty/version.rb#4
HTTParty::VERSION = T.let(T.unsafe(nil), String)

# source://httparty//lib/httparty/net_digest_auth.rb#7
module Net::HTTPHeader
  # source://httparty//lib/httparty/net_digest_auth.rb#8
  def digest_auth(username, password, response); end
end

# source://httparty//lib/httparty/net_digest_auth.rb#26
class Net::HTTPHeader::DigestAuthenticator
  # @return [DigestAuthenticator] a new instance of DigestAuthenticator
  #
  # source://httparty//lib/httparty/net_digest_auth.rb#27
  def initialize(username, password, method, path, response_header); end

  # source://httparty//lib/httparty/net_digest_auth.rb#36
  def authorization_header; end

  # source://httparty//lib/httparty/net_digest_auth.rb#58
  def cookie_header; end

  private

  # source://httparty//lib/httparty/net_digest_auth.rb#121
  def a1; end

  # source://httparty//lib/httparty/net_digest_auth.rb#130
  def a2; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/net_digest_auth.rb#113
  def algorithm_present?; end

  # source://httparty//lib/httparty/net_digest_auth.rb#109
  def md5(str); end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/net_digest_auth.rb#91
  def opaque_present?; end

  # source://httparty//lib/httparty/net_digest_auth.rb#64
  def parse(response_header); end

  # source://httparty//lib/httparty/net_digest_auth.rb#78
  def parse_cookies(response_header); end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/net_digest_auth.rb#95
  def qop_present?; end

  # source://httparty//lib/httparty/net_digest_auth.rb#99
  def random; end

  # source://httparty//lib/httparty/net_digest_auth.rb#103
  def request_digest; end

  # @return [Boolean]
  #
  # source://httparty//lib/httparty/net_digest_auth.rb#117
  def use_md5_sess?; end
end
