# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `eventmachine` gem.
# Please instead update this file by running `bin/tapioca gem eventmachine`.


# BufferedTokenizer takes a delimiter upon instantiation, or acts line-based
# by default.  It allows input to be spoon-fed from some outside source which
# receives arbitrary length datagrams which may-or-may-not contain the token
# by which entities are delimited.  In this respect it's ideally paired with
# something like EventMachine (http://rubyeventmachine.com/).
#
# source://eventmachine//lib/em/buftok.rb#6
class BufferedTokenizer
  # New BufferedTokenizers will operate on lines delimited by a delimiter,
  # which is by default the global input delimiter $/ ("\n").
  #
  # The input buffer is stored as an array.  This is by far the most efficient
  # approach given language constraints (in C a linked list would be a more
  # appropriate data structure).  Segments of input data are stored in a list
  # which is only joined when a token is reached, substantially reducing the
  # number of objects required for the operation.
  #
  # @return [BufferedTokenizer] a new instance of BufferedTokenizer
  #
  # source://eventmachine//lib/em/buftok.rb#15
  def initialize(delimiter = T.unsafe(nil)); end

  # Extract takes an arbitrary string of input data and returns an array of
  # tokenized entities, provided there were any available to extract.  This
  # makes for easy processing of datagrams using a pattern like:
  #
  #   tokenizer.extract(data).map { |entity| Decode(entity) }.each do ...
  #
  # Using -1 makes split to return "" if the token is at the end of
  # the string, meaning the last element is the start of the next chunk.
  #
  # source://eventmachine//lib/em/buftok.rb#30
  def extract(data); end

  # Flush the contents of the input buffer, i.e. return the input buffer even though
  # a token has not yet been encountered
  #
  # source://eventmachine//lib/em/buftok.rb#52
  def flush; end
end

# Alias for {EventMachine}
#
# source://eventmachine//lib/eventmachine.rb#1599
EM = EventMachine

# Top-level EventMachine namespace. If you are looking for EventMachine examples, see {file:docs/GettingStarted.md EventMachine tutorial}.
#
# ## Key methods ##
# ### Starting and stopping the event loop ###
#
# * {EventMachine.run}
# * {EventMachine.stop_event_loop}
#
# ### Implementing clients ###
#
# * {EventMachine.connect}
#
# ### Implementing servers ###
#
# * {EventMachine.start_server}
#
# ### Working with timers ###
#
# * {EventMachine.add_timer}
# * {EventMachine.add_periodic_timer}
# * {EventMachine.cancel_timer}
#
# ### Working with blocking tasks ###
#
# * {EventMachine.defer}
# * {EventMachine.next_tick}
#
# ### Efficient proxying ###
#
# * {EventMachine.enable_proxy}
# * {EventMachine.disable_proxy}
#
# source://eventmachine//lib/em/version.rb#1
module EventMachine
  private

  def add_oneshot_timer(_arg0); end
  def attach_fd(_arg0, _arg1); end
  def attach_sd(_arg0); end
  def bind_connect_server(_arg0, _arg1, _arg2, _arg3); end
  def close_connection(_arg0, _arg1); end
  def connect_server(_arg0, _arg1); end
  def connect_unix_server(_arg0); end
  def connection_paused?(_arg0); end
  def current_time; end
  def detach_fd(_arg0); end
  def epoll; end
  def epoll=(_arg0); end
  def epoll?; end
  def get_cipher_bits(_arg0); end
  def get_cipher_name(_arg0); end
  def get_cipher_protocol(_arg0); end
  def get_comm_inactivity_timeout(_arg0); end
  def get_connection_count; end
  def get_file_descriptor(_arg0); end
  def get_heartbeat_interval; end
  def get_idle_time(_arg0); end
  def get_max_timer_count; end
  def get_peer_cert(_arg0); end
  def get_peername(_arg0); end
  def get_pending_connect_timeout(_arg0); end
  def get_proxied_bytes(_arg0); end
  def get_simultaneous_accept_count; end
  def get_sni_hostname(_arg0); end
  def get_sock_opt(_arg0, _arg1, _arg2); end
  def get_sockname(_arg0); end
  def get_subprocess_pid(_arg0); end
  def get_subprocess_status(_arg0); end
  def initialize_event_machine; end
  def invoke_popen(_arg0); end
  def is_notify_readable(_arg0); end
  def is_notify_writable(_arg0); end
  def kqueue; end
  def kqueue=(_arg0); end
  def kqueue?; end
  def library_type; end
  def num_close_scheduled; end
  def open_udp_socket(_arg0, _arg1); end
  def pause_connection(_arg0); end
  def read_keyboard; end
  def release_machine; end
  def report_connection_error_status(_arg0); end
  def resume_connection(_arg0); end
  def run_machine; end
  def run_machine_once; end
  def run_machine_without_threads; end
  def send_data(_arg0, _arg1, _arg2); end
  def send_datagram(_arg0, _arg1, _arg2, _arg3, _arg4); end
  def send_file_data(_arg0, _arg1); end
  def set_comm_inactivity_timeout(_arg0, _arg1); end
  def set_heartbeat_interval(_arg0); end
  def set_max_timer_count(_arg0); end
  def set_notify_readable(_arg0, _arg1); end
  def set_notify_writable(_arg0, _arg1); end
  def set_pending_connect_timeout(_arg0, _arg1); end
  def set_rlimit_nofile(_arg0); end
  def set_simultaneous_accept_count(_arg0); end
  def set_sock_opt(_arg0, _arg1, _arg2, _arg3); end
  def set_timer_quantum(_arg0); end
  def set_tls_parms(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9); end
  def setuid_string(_arg0); end
  def signal_loopbreak; end
  def ssl?; end
  def start_proxy(_arg0, _arg1, _arg2, _arg3); end
  def start_tcp_server(_arg0, _arg1); end
  def start_tls(_arg0); end
  def start_unix_server(_arg0); end
  def stop; end
  def stop_proxy(_arg0); end
  def stop_tcp_server(_arg0); end
  def stopping?; end
  def unwatch_filename(_arg0); end
  def unwatch_pid(_arg0); end
  def watch_filename(_arg0); end
  def watch_pid(_arg0); end

  class << self
    # Utility method for coercing arguments to an object that responds to :call.
    # Accepts an object and a method name to send to, or a block, or an object
    # that responds to :call.
    #
    # @example EventMachine.Callback used with an object (to be more specific, class object) and a method name, returns an object that responds to #call
    #
    #   cb = EventMachine.Callback(Object, :puts)
    #   # returned object is a callable that delegates to Kernel#puts (in this case Object.puts)
    #   cb.call('hello world')
    # @example EventMachine.Callback used with a block. Returns that block.
    #
    #   cb = EventMachine.Callback do |msg|
    #   puts(msg)
    #   end
    #   # returned object is a callable
    #   cb.call('hello world')
    # @example EventMachine.Callback used with an object that responds to #call. Returns the argument.
    #
    #   cb = EventMachine.Callback(proc{ |msg| puts(msg) })
    #   # returned object is a callable
    #   cb.call('hello world')
    # @overload Callback
    # @overload Callback
    # @overload Callback
    # @raise [ArgumentError] When argument doesn't respond to #call, method name is missing or when invoked without arguments and block isn't given
    # @return [<#call>]
    #
    # source://eventmachine//lib/em/callback.rb#47
    def Callback(object = T.unsafe(nil), method = T.unsafe(nil), &blk); end

    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#1563
    def _open_file_for_writing(filename, handler = T.unsafe(nil)); end

    # Changed 04Oct06: intervals from the caller are now in milliseconds, but our native-ruby
    # processor still wants them in seconds.
    #
    # @private
    def add_oneshot_timer(_arg0); end

    # Adds a periodic timer to the event loop.
    # It takes the same parameters as the one-shot timer method, {EventMachine.add_timer}.
    # This method schedules execution of the given block repeatedly, at intervals
    # of time *at least* as great as the number of seconds given in the first
    # parameter to the call.
    #
    # @example Write a dollar-sign to stderr every five seconds, without blocking
    #
    #   EventMachine.run {
    #   EventMachine.add_periodic_timer( 5 ) { $stderr.write "$" }
    #   }
    # @param delay [Integer] Delay in seconds
    # @see EventMachine::PeriodicTimer
    # @see EventMachine.add_timer
    #
    # source://eventmachine//lib/eventmachine.rb#351
    def add_periodic_timer(*args, &block); end

    # Adds a block to call as the reactor is shutting down.
    #
    # These callbacks are called in the _reverse_ order to which they are added.
    #
    # @example Scheduling operations to be run when EventMachine event loop is stopped
    #
    #   EventMachine.run do
    #   EventMachine.add_shutdown_hook { puts "b" }
    #   EventMachine.add_shutdown_hook { puts "a" }
    #   EventMachine.stop
    #   end
    #
    #   # Outputs:
    #   #   a
    #   #   b
    #
    # source://eventmachine//lib/eventmachine.rb#291
    def add_shutdown_hook(&block); end

    # Adds a one-shot timer to the event loop.
    # Call it with one or two parameters. The first parameters is a delay-time
    # expressed in *seconds* (not milliseconds). The second parameter, if
    # present, must be an object that responds to :call. If 2nd parameter is not given, then you
    # can also simply pass a block to the method call.
    #
    # This method may be called from the block passed to {EventMachine.run}
    # or from any callback method. It schedules execution of the proc or block
    # passed to it, after the passage of an interval of time equal to
    # *at least* the number of seconds specified in the first parameter to
    # the call.
    #
    # {EventMachine.add_timer} is a non-blocking method. Callbacks can and will
    # be called during the interval of time that the timer is in effect.
    # There is no built-in limit to the number of timers that can be outstanding at
    # any given time.
    #
    # @example Setting a one-shot timer with EventMachine
    #
    #   EventMachine.run {
    #   puts "Starting the run now: #{Time.now}"
    #   EventMachine.add_timer 5, proc { puts "Executing timer event: #{Time.now}" }
    #   EventMachine.add_timer(10) { puts "Executing timer event: #{Time.now}" }
    #   }
    # @param delay [Integer] Delay in seconds
    # @see EventMachine::Timer
    # @see EventMachine.add_periodic_timer
    #
    # source://eventmachine//lib/eventmachine.rb#323
    def add_timer(*args, &block); end

    # Attaches an IO object or file descriptor to the eventloop as a regular connection.
    # The file descriptor will be set as non-blocking, and EventMachine will process
    # receive_data and send_data events on it as it would for any other connection.
    #
    # To watch a fd instead, use {EventMachine.watch}, which will not alter the state of the socket
    # and fire notify_readable and notify_writable events instead.
    #
    # source://eventmachine//lib/eventmachine.rb#741
    def attach(io, handler = T.unsafe(nil), *args, &blk); end

    # @private
    def attach_fd(_arg0, _arg1); end

    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#746
    def attach_io(io, watch_mode, handler = T.unsafe(nil), *args); end

    def attach_sd(_arg0); end

    # Attach to an existing socket's file descriptor. The socket may have been
    # started with {EventMachine.start_server}.
    #
    # source://eventmachine//lib/eventmachine.rb#541
    def attach_server(sock, handler = T.unsafe(nil), *args, &block); end

    # This method is like {EventMachine.connect}, but allows for a local address/port
    # to bind the connection to.
    #
    # @see EventMachine.connect
    #
    # source://eventmachine//lib/eventmachine.rb#661
    def bind_connect(bind_addr, bind_port, server, port = T.unsafe(nil), handler = T.unsafe(nil), *args); end

    # @private
    def bind_connect_server(_arg0, _arg1, _arg2, _arg3); end

    # Cancel a timer (can be a callback or an {EventMachine::Timer} instance).
    #
    # @param timer_or_sig [#cancel, #call] A timer to cancel
    # @see EventMachine::Timer#cancel
    #
    # source://eventmachine//lib/eventmachine.rb#363
    def cancel_timer(timer_or_sig); end

    # Clean up Ruby space following a release_machine
    #
    # source://eventmachine//lib/eventmachine.rb#261
    def cleanup_machine; end

    # @private
    def close_connection(_arg0, _arg1); end

    # Initiates a TCP connection to a remote server and sets up event handling for the connection.
    # {EventMachine.connect} requires event loop to be running (see {EventMachine.run}).
    #
    # {EventMachine.connect} takes the IP address (or hostname) and
    # port of the remote server you want to connect to.
    # It also takes an optional handler (a module or a subclass of {EventMachine::Connection}) which you must define, that
    # contains the callbacks that will be invoked by the event loop on behalf of the connection.
    #
    # Learn more about connection lifecycle callbacks in the {file:docs/GettingStarted.md EventMachine tutorial} and
    # {file:docs/ConnectionLifecycleCallbacks.md Connection lifecycle guide}.
    #
    # @example
    #
    #   # Here's a program which connects to a web server, sends a naive
    #   # request, parses the HTTP header of the response, and then
    #   # (antisocially) ends the event loop, which automatically drops the connection
    #   # (and incidentally calls the connection's unbind method).
    #   module DumbHttpClient
    #   def post_init
    #   send_data "GET / HTTP/1.1\r\nHost: _\r\n\r\n"
    #   @data = ""
    #   @parsed = false
    #   end
    #
    #   def receive_data data
    #   @data << data
    #   if !@parsed and @data =~ /[\n][\r]*[\n]/m
    #   @parsed = true
    #   puts "RECEIVED HTTP HEADER:"
    #   $`.each {|line| puts ">>> #{line}" }
    #
    #   puts "Now we'll terminate the loop, which will also close the connection"
    #   EventMachine::stop_event_loop
    #   end
    #   end
    #
    #   def unbind
    #   puts "A connection has terminated"
    #   end
    #   end
    #
    #   EventMachine.run {
    #   EventMachine.connect "www.bayshorenetworks.com", 80, DumbHttpClient
    #   }
    #   puts "The event loop has ended"
    # @example Defining protocol handler as a class
    #
    #   class MyProtocolHandler < EventMachine::Connection
    #   def initialize *args
    #   super
    #   # whatever else you want to do here
    #   end
    #
    #   # ...
    #   end
    # @param server [String] Host to connect to
    # @param port [Integer] Port to connect to
    # @param handler [Module, Class] A module or class that implements connection lifecycle callbacks
    # @see EventMachine.start_server
    # @see file:docs/GettingStarted.md EventMachine tutorial
    #
    # source://eventmachine//lib/eventmachine.rb#631
    def connect(server, port = T.unsafe(nil), handler = T.unsafe(nil), *args, &blk); end

    # @private
    def connect_server(_arg0, _arg1); end

    # Make a connection to a Unix-domain socket. This method is simply an alias for {.connect},
    # which can connect to both TCP and Unix-domain sockets. Make sure that your process has sufficient
    # permissions to open the socket it is given.
    #
    # @note UNIX sockets, as the name suggests, are not available on Microsoft Windows.
    # @param socketname [String] Unix domain socket (local fully-qualified path) you want to connect to.
    #
    # source://eventmachine//lib/eventmachine.rb#813
    def connect_unix_domain(socketname, *args, &blk); end

    # @private
    def connect_unix_server(_arg0); end

    # Returns the total number of connections (file descriptors) currently held by the reactor.
    # Note that a tick must pass after the 'initiation' of a connection for this number to increment.
    # It's usually accurate, but don't rely on the exact precision of this number unless you really know EM internals.
    #
    # @example
    #
    #   EventMachine.run {
    #   EventMachine.connect("rubyeventmachine.com", 80)
    #   # count will be 0 in this case, because connection is not
    #   # established yet
    #   count = EventMachine.connection_count
    #   }
    # @example
    #
    #   EventMachine.run {
    #   EventMachine.connect("rubyeventmachine.com", 80)
    #
    #   EventMachine.next_tick {
    #   # In this example, count will be 1 since the connection has been established in
    #   # the next loop of the reactor.
    #   count = EventMachine.connection_count
    #   }
    #   }
    # @return [Integer] Number of connections currently held by the reactor.
    #
    # source://eventmachine//lib/eventmachine.rb#955
    def connection_count; end

    # @return [Boolean]
    def connection_paused?(_arg0); end

    def current_time; end

    # EventMachine.defer is used for integrating blocking operations into EventMachine's control flow.
    # The action of {.defer} is to take the block specified in the first parameter (the "operation")
    # and schedule it for asynchronous execution on an internal thread pool maintained by EventMachine.
    # When the operation completes, it will pass the result computed by the block (if any) back to the
    # EventMachine reactor. Then, EventMachine calls the block specified in the second parameter to
    # {.defer} (the "callback"), as part of its normal event handling loop. The result computed by the
    # operation block is passed as a parameter to the callback. You may omit the callback parameter if
    # you don't need to execute any code after the operation completes. If the operation raises an
    # unhandled exception, the exception will be passed to the third parameter to {.defer} (the
    # "errback"), as part of its normal event handling loop. If no errback is provided, the exception
    # will be allowed to blow through to the main thread immediately.
    #
    # ## Caveats ##
    #
    # Note carefully that the code in your deferred operation will be executed on a separate
    # thread from the main EventMachine processing and all other Ruby threads that may exist in
    # your program. Also, multiple deferred operations may be running at once! Therefore, you
    # are responsible for ensuring that your operation code is threadsafe.
    #
    # Don't write a deferred operation that will block forever. If so, the current implementation will
    # not detect the problem, and the thread will never be returned to the pool. EventMachine limits
    # the number of threads in its pool, so if you do this enough times, your subsequent deferred
    # operations won't get a chance to run.
    #
    # The threads within the EventMachine's thread pool have abort_on_exception set to true. As a result,
    # if an unhandled exception is raised by the deferred operation and an errback is not provided, it
    # will blow through to the main thread immediately. If the main thread is within an indiscriminate
    # rescue block at that time, the exception could be handled improperly by the main thread.
    #
    # @example
    #
    #   operation = proc {
    #   # perform a long-running operation here, such as a database query.
    #   "result" # as usual, the last expression evaluated in the block will be the return value.
    #   }
    #   callback = proc {|result|
    #   # do something with result here, such as send it back to a network client.
    #   }
    #   errback = proc {|error|
    #   # do something with error here, such as re-raising or logging.
    #   }
    #
    #   EventMachine.defer(operation, callback, errback)
    # @param op [#call] An operation you want to offload to EventMachine thread pool
    # @param callback [#call] A callback that will be run on the event loop thread after `operation` finishes.
    # @param errback [#call] An errback that will be run on the event loop thread after `operation` raises an exception.
    # @see EventMachine.threadpool_size
    #
    # source://eventmachine//lib/eventmachine.rb#1043
    def defer(op = T.unsafe(nil), callback = T.unsafe(nil), errback = T.unsafe(nil), &blk); end

    # Returns +true+ if all deferred actions are done executing and their
    # callbacks have been fired.
    #
    # @return [Boolean]
    #
    # source://eventmachine//lib/eventmachine.rb#1095
    def defers_finished?; end

    def detach_fd(_arg0); end

    # Takes just one argument, a {Connection} that has proxying enabled via {EventMachine.enable_proxy}.
    # Calling this method will remove that functionality and your connection will begin receiving
    # data via {Connection#receive_data} again.
    #
    # @param from [EventMachine::Connection] Source of data that is being proxied
    # @see EventMachine.enable_proxy
    #
    # source://eventmachine//lib/eventmachine.rb#1440
    def disable_proxy(from); end

    # This method allows for direct writing of incoming data back out to another descriptor, at the C++ level in the reactor.
    # This is very efficient and especially useful for proxies where high performance is required. Propogating data from a server response
    # all the way up to Ruby, and then back down to the reactor to be sent back to the client, is often unnecessary and
    # incurs a significant performance decrease.
    #
    # The two arguments are instance of {EventMachine::Connection} subclasses, 'from' and 'to'. 'from' is the connection whose inbound data you want
    # relayed back out. 'to' is the connection to write it to.
    #
    # Once you call this method, the 'from' connection will no longer get receive_data callbacks from the reactor,
    # except in the case that 'to' connection has already closed when attempting to write to it. You can see
    # in the example, that proxy_target_unbound will be called when this occurs. After that, further incoming
    # data will be passed into receive_data as normal.
    #
    # Note also that this feature supports different types of descriptors: TCP, UDP, and pipes. You can relay
    # data from one kind to another, for example, feed a pipe from a UDP stream.
    #
    # @example
    #
    #   module ProxyConnection
    #   def initialize(client, request)
    #   @client, @request = client, request
    #   end
    #
    #   def post_init
    #   EM::enable_proxy(self, @client)
    #   end
    #
    #   def connection_completed
    #   send_data @request
    #   end
    #
    #   def proxy_target_unbound
    #   close_connection
    #   end
    #
    #   def unbind
    #   @client.close_connection_after_writing
    #   end
    #   end
    #
    #   module ProxyServer
    #   def receive_data(data)
    #   (@buf ||= "") << data
    #   if @buf =~ /\r\n\r\n/ # all http headers received
    #   EventMachine.connect("10.0.0.15", 80, ProxyConnection, self, data)
    #   end
    #   end
    #   end
    #
    #   EventMachine.run {
    #   EventMachine.start_server("127.0.0.1", 8080, ProxyServer)
    #   }
    # @param from [EventMachine::Connection] Source of data to be proxies/streamed.
    # @param to [EventMachine::Connection] Destination of data to be proxies/streamed.
    # @param bufsize [Integer] Buffer size to use
    # @param length [Integer] Maximum number of bytes to proxy.
    # @see EventMachine.disable_proxy
    #
    # source://eventmachine//lib/eventmachine.rb#1430
    def enable_proxy(from, to, bufsize = T.unsafe(nil), length = T.unsafe(nil)); end

    # This method is a harmless no-op in the pure-Ruby implementation. This is intended to ensure
    # that user code behaves properly across different EM implementations.
    #
    # @private
    def epoll; end

    # Epoll is a no-op for Java.
    # The latest Java versions run epoll when possible in NIO.
    def epoll=(_arg0); end

    # @return [Boolean]
    def epoll?; end

    # Catch-all for errors raised during event loop callbacks.
    #
    # @example
    #
    #   EventMachine.error_handler{ |e|
    #   puts "Error raised during event loop: #{e.message}"
    #   }
    # @param cb [#call] Global catch-all errback
    #
    # source://eventmachine//lib/eventmachine.rb#1363
    def error_handler(cb = T.unsafe(nil), &blk); end

    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#1463
    def event_callback(conn_binding, opcode, data); end

    # Forks a new process, properly stops the reactor and then calls {EventMachine.run} inside of it again, passing your block.
    #
    # source://eventmachine//lib/eventmachine.rb#243
    def fork_reactor(&block); end

    def get_cipher_bits(_arg0); end
    def get_cipher_name(_arg0); end
    def get_cipher_protocol(_arg0); end
    def get_comm_inactivity_timeout(_arg0); end
    def get_connection_count; end
    def get_file_descriptor(_arg0); end
    def get_heartbeat_interval; end
    def get_idle_time(_arg0); end
    def get_max_timer_count; end

    # Gets the current maximum number of allowed timers
    #
    # @return [Integer] Maximum number of timers that may be outstanding at any given time
    #
    # source://eventmachine//lib/eventmachine.rb#924
    def get_max_timers; end

    def get_peer_cert(_arg0); end

    # @private
    def get_peername(_arg0); end

    def get_pending_connect_timeout(_arg0); end
    def get_proxied_bytes(_arg0); end
    def get_simultaneous_accept_count; end
    def get_sni_hostname(_arg0); end

    # @private
    def get_sock_opt(_arg0, _arg1, _arg2); end

    # @private
    def get_sockname(_arg0); end

    def get_subprocess_pid(_arg0); end
    def get_subprocess_status(_arg0); end

    # Retrieve the heartbeat interval. This is how often EventMachine will check for dead connections
    # that have had an inactivity timeout set via {Connection#set_comm_inactivity_timeout}.
    # Default is 2 seconds.
    #
    # @return [Integer] Heartbeat interval, in seconds
    #
    # source://eventmachine//lib/eventmachine.rb#1449
    def heartbeat_interval; end

    # Set the heartbeat interval. This is how often EventMachine will check for dead connections
    # that have had an inactivity timeout set via {Connection#set_comm_inactivity_timeout}.
    # Takes a Numeric number of seconds. Default is 2.
    #
    # @param time [Integer] Heartbeat interval, in seconds
    #
    # source://eventmachine//lib/eventmachine.rb#1458
    def heartbeat_interval=(time); end

    # class Connection < com.rubyeventmachine.Connection
    #   def associate_callback_target sig
    #     # No-op for the time being.
    #   end
    # end
    def initialize_event_machine; end

    def invoke_popen(_arg0); end
    def is_notify_readable(_arg0); end
    def is_notify_writable(_arg0); end

    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#1574
    def klass_from_handler(klass = T.unsafe(nil), handler = T.unsafe(nil), *args); end

    def kqueue; end
    def kqueue=(_arg0); end

    # @return [Boolean]
    def kqueue?; end

    # This is mostly useful for automated tests.
    # Return a distinctive symbol so the caller knows whether he's dealing
    # with an extension or with a pure-Ruby library.
    #
    # @private
    def library_type; end

    # Schedules a proc for execution immediately after the next "turn" through the reactor
    # core. An advanced technique, this can be useful for improving memory management and/or
    # application responsiveness, especially when scheduling large amounts of data for
    # writing to a network connection.
    #
    # This method takes either a single argument (which must be a callable object) or a block.
    #
    # @param pr [#call] A callable object to run
    # @raise [ArgumentError]
    #
    # source://eventmachine//lib/eventmachine.rb#1121
    def next_tick(pr = T.unsafe(nil), &block); end

    def num_close_scheduled; end

    # Used for UDP-based protocols. Its usage is similar to that of {EventMachine.start_server}.
    #
    # This method will create a new UDP (datagram) socket and
    # bind it to the address and port that you specify.
    # The normal callbacks (see {EventMachine.start_server}) will
    # be called as events of interest occur on the newly-created
    # socket, but there are some differences in how they behave.
    #
    # {Connection#receive_data} will be called when a datagram packet
    # is received on the socket, but unlike TCP sockets, the message
    # boundaries of the received data will be respected. In other words,
    # if the remote peer sent you a datagram of a particular size,
    # you may rely on {Connection#receive_data} to give you the
    # exact data in the packet, with the original data length.
    # Also observe that Connection#receive_data may be called with a
    # *zero-length* data payload, since empty datagrams are permitted in UDP.
    #
    # {Connection#send_data} is available with UDP packets as with TCP,
    # but there is an important difference. Because UDP communications
    # are *connectionless*, there is no implicit recipient for the packets you
    # send. Ordinarily you must specify the recipient for each packet you send.
    # However, EventMachine provides for the typical pattern of receiving a UDP datagram
    # from a remote peer, performing some operation, and then sending
    # one or more packets in response to the same remote peer.
    # To support this model easily, just use {Connection#send_data}
    # in the code that you supply for {Connection#receive_data}.
    #
    # EventMachine will provide an implicit return address for any messages sent to
    # {Connection#send_data} within the context of a {Connection#receive_data} callback,
    # and your response will automatically go to the correct remote peer.
    #
    # Observe that the port number that you supply to {EventMachine.open_datagram_socket}
    # may be zero. In this case, EventMachine will create a UDP socket
    # that is bound to an [ephemeral port](http://en.wikipedia.org/wiki/Ephemeral_port).
    # This is not appropriate for servers that must publish a well-known
    # port to which remote peers may send datagrams. But it can be useful
    # for clients that send datagrams to other servers.
    # If you do this, you will receive any responses from the remote
    # servers through the normal {Connection#receive_data} callback.
    # Observe that you will probably have issues with firewalls blocking
    # the ephemeral port numbers, so this technique is most appropriate for LANs.
    #
    # If you wish to send datagrams to arbitrary remote peers (not
    # necessarily ones that have sent data to which you are responding),
    # then see {Connection#send_datagram}.
    #
    # DO NOT call send_data from a datagram socket outside of a {Connection#receive_data} method. Use {Connection#send_datagram}.
    # If you do use {Connection#send_data} outside of a {Connection#receive_data} method, you'll get a confusing error
    # because there is no "peer," as #send_data requires (inside of {EventMachine::Connection#receive_data},
    # {EventMachine::Connection#send_data} "fakes" the peer as described above).
    #
    # @param address [String] IP address
    # @param port [String] Port
    # @param handler [Class, Module] A class or a module that implements connection lifecycle callbacks.
    #
    # source://eventmachine//lib/eventmachine.rb#872
    def open_datagram_socket(address, port, handler = T.unsafe(nil), *args); end

    # (Experimental)
    #
    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#1235
    def open_keyboard(handler = T.unsafe(nil), *args); end

    # Currently a no-op for Java.
    def open_udp_socket(_arg0, _arg1); end

    def pause_connection(_arg0); end

    # Runs an external process.
    #
    # @example
    #
    #   module RubyCounter
    #   def post_init
    #   # count up to 5
    #   send_data "5\n"
    #   end
    #   def receive_data data
    #   puts "ruby sent me: #{data}"
    #   end
    #   def unbind
    #   puts "ruby died with exit status: #{get_status.exitstatus}"
    #   end
    #   end
    #
    #   EventMachine.run {
    #   EventMachine.popen("ruby -e' $stdout.sync = true; gets.to_i.times{ |i| puts i+1; sleep 1 } '", RubyCounter)
    #   }
    # @note This method is not supported on Microsoft Windows
    # @see EventMachine::DeferrableChildProcess
    # @see EventMachine.system
    # @yield [c]
    #
    # source://eventmachine//lib/eventmachine.rb#1198
    def popen(cmd, handler = T.unsafe(nil), *args); end

    # Tells you whether the EventMachine reactor loop is currently running.
    #
    # Useful when writing libraries that want to run event-driven code, but may
    # be running in programs that are already event-driven. In such cases, if {EventMachine.reactor_running?}
    # returns false, your code can invoke {EventMachine.run} and run your application code inside
    # the block passed to that method. If this method returns true, just
    # execute your event-aware code.
    #
    # @return [Boolean] true if the EventMachine reactor loop is currently running
    #
    # source://eventmachine//lib/eventmachine.rb#1227
    def reactor_running?; end

    # Exposed to allow joining on the thread, when run in a multithreaded
    # environment. Performing other actions on the thread has undefined
    # semantics (read: a dangerous endevor).
    #
    # @return [Thread]
    #
    # source://eventmachine//lib/eventmachine.rb#79
    def reactor_thread; end

    # @return [Boolean] true if the calling thread is the same thread as the reactor.
    #
    # source://eventmachine//lib/eventmachine.rb#227
    def reactor_thread?; end

    # @private
    def read_keyboard; end

    # Connect to a given host/port and re-use the provided {EventMachine::Connection} instance.
    # Consider also {EventMachine::Connection#reconnect}.
    #
    # @see EventMachine::Connection#reconnect
    #
    # source://eventmachine//lib/eventmachine.rb#781
    def reconnect(server, port, handler); end

    # @private
    def release_machine; end

    # @private
    def report_connection_error_status(_arg0); end

    def resume_connection(_arg0); end

    # Initializes and runs an event loop. This method only returns if code inside the block passed to this method
    # calls {EventMachine.stop_event_loop}. The block is executed after initializing its internal event loop but *before* running the loop,
    # therefore this block is the right place to call any code that needs event loop to run, for example, {EventMachine.start_server},
    # {EventMachine.connect} or similar methods of libraries that use EventMachine under the hood
    # (like `EventMachine::HttpRequest.new` or `AMQP.start`).
    #
    # Programs that are run for long periods of time (e.g. servers) usually start event loop by calling {EventMachine.run}, and let it
    # run "forever". It's also possible to use {EventMachine.run} to make a single client-connection to a remote server,
    # process the data flow from that single connection, and then call {EventMachine.stop_event_loop} to stop, in other words,
    # to run event loop for a short period of time (necessary to complete some operation) and then shut it down.
    #
    # Once event loop is running, it is perfectly possible to start multiple servers and clients simultaneously: content-aware
    # proxies like [Proxymachine](https://github.com/mojombo/proxymachine) do just that.
    #
    # ## Using EventMachine with Ruby on Rails and other Web application frameworks ##
    #
    # Standalone applications often run event loop on the main thread, thus blocking for their entire lifespan. In case of Web applications,
    # if you are running an EventMachine-based app server such as [Thin](http://code.macournoyer.com/thin/) or [Goliath](https://github.com/postrank-labs/goliath/),
    # they start event loop for you. Servers like Unicorn, Apache Passenger or Mongrel occupy main Ruby thread to serve HTTP(S) requests. This means
    # that calling {EventMachine.run} on the same thread is not an option (it will result in Web server never binding to the socket).
    # In that case, start event loop in a separate thread as demonstrated below.
    #
    # @example Starting EventMachine event loop in the current thread to run the "Hello, world"-like Echo server example
    #
    #   #!/usr/bin/env ruby
    #
    #   require 'rubygems' # or use Bundler.setup
    #   require 'eventmachine'
    #
    #   class EchoServer < EM::Connection
    #   def receive_data(data)
    #   send_data(data)
    #   end
    #   end
    #
    #   EventMachine.run do
    #   EventMachine.start_server("0.0.0.0", 10000, EchoServer)
    #   end
    # @example Starting EventMachine event loop in a separate thread
    #
    #   # doesn't block current thread, can be used with Ruby on Rails, Sinatra, Merb, Rack
    #   # and any other application server that occupies main Ruby thread.
    #   Thread.new { EventMachine.run }
    # @note This method blocks calling thread. If you need to start EventMachine event loop from a Web app
    #   running on a non event-driven server (Unicorn, Apache Passenger, Mongrel), do it in a separate thread like demonstrated
    #   in one of the examples.
    # @see file:docs/GettingStarted.md Getting started with EventMachine
    # @see EventMachine.stop_event_loop
    #
    # source://eventmachine//lib/eventmachine.rb#149
    def run(blk = T.unsafe(nil), tail = T.unsafe(nil), &block); end

    # Sugars a common use case. Will pass the given block to #run, but will terminate
    # the reactor loop and exit the function as soon as the code in the block completes.
    # (Normally, {EventMachine.run} keeps running indefinitely, even after the block supplied to it
    # finishes running, until user code calls {EventMachine.stop})
    #
    # source://eventmachine//lib/eventmachine.rb#218
    def run_block(&block); end

    # The is the responder for the loopback-signalled event.
    # It can be fired either by code running on a separate thread ({EventMachine.defer}) or on
    # the main thread ({EventMachine.next_tick}).
    # It will often happen that a next_tick handler will reschedule itself. We
    # consume a copy of the tick queue so that tick events scheduled by tick events
    # have to wait for the next pass through the reactor core.
    #
    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#967
    def run_deferred_callbacks; end

    # @private
    def run_machine; end

    def run_machine_once; end
    def run_machine_without_threads; end

    # Runs the given callback on the reactor thread, or immediately if called
    # from the reactor thread. Accepts the same arguments as {EventMachine::Callback}
    #
    # source://eventmachine//lib/eventmachine.rb#233
    def schedule(*a, &b); end

    # @private
    def send_data(_arg0, _arg1, _arg2); end

    # This is currently only for UDP!
    # We need to make it work with unix-domain sockets as well.
    #
    # @private
    def send_datagram(_arg0, _arg1, _arg2, _arg3, _arg4); end

    # @private
    def send_file_data(_arg0, _arg1); end

    # @private
    def set_comm_inactivity_timeout(_arg0, _arg1); end

    # Sets the maximum number of file or socket descriptors that your process may open.
    # If you call this method with no arguments, it will simply return
    # the current size of the descriptor table without attempting to change it.
    #
    # The new limit on open descriptors **only** applies to sockets and other descriptors
    # that belong to EventMachine. It has **no effect** on the number of descriptors
    # you can create in ordinary Ruby code.
    #
    # Not available on all platforms. Increasing the number of descriptors beyond its
    # default limit usually requires superuser privileges. (See {.set_effective_user}
    # for a way to drop superuser privileges while your program is running.)
    #
    # @param n_descriptors [Integer] The maximum number of file or socket descriptors that your process may open
    # @return [Integer] The new descriptor table size.
    #
    # source://eventmachine//lib/eventmachine.rb#1168
    def set_descriptor_table_size(n_descriptors = T.unsafe(nil)); end

    # A wrapper over the setuid system call. Particularly useful when opening a network
    # server on a privileged port because you can use this call to drop privileges
    # after opening the port. Also very useful after a call to {.set_descriptor_table_size},
    # which generally requires that you start your process with root privileges.
    #
    # This method is intended for use in enforcing security requirements, consequently
    # it will throw a fatal error and end your program if it fails.
    #
    # @note This method has no effective implementation on Windows or in the pure-Ruby
    #   implementation of EventMachine
    # @param username [String] The effective name of the user whose privilege-level your process should attain.
    #
    # source://eventmachine//lib/eventmachine.rb#1149
    def set_effective_user(username); end

    def set_heartbeat_interval(_arg0); end

    # This method is a harmless no-op in pure Ruby, which doesn't have a built-in limit
    # on the number of available timers.
    #
    # @private
    def set_max_timer_count(_arg0); end

    # Sets the maximum number of timers and periodic timers that may be outstanding at any
    # given time. You only need to call {.set_max_timers} if you need more than the default
    # number of timers, which on most platforms is 1000.
    #
    # @note This method has to be used *before* event loop is started.
    # @param ct [Integer] Maximum number of timers that may be outstanding at any given time
    # @see EventMachine.add_timer
    # @see EventMachine.add_periodic_timer
    # @see EventMachine::Timer
    #
    # source://eventmachine//lib/eventmachine.rb#917
    def set_max_timers(ct); end

    def set_notify_readable(_arg0, _arg1); end
    def set_notify_writable(_arg0, _arg1); end

    # @private
    def set_pending_connect_timeout(_arg0, _arg1); end

    # For advanced users. This function sets the default timer granularity, which by default is
    # slightly smaller than 100 milliseconds. Call this function to set a higher or lower granularity.
    # The function affects the behavior of {EventMachine.add_timer} and {EventMachine.add_periodic_timer}.
    # Most applications will not need to call this function.
    #
    # Avoid setting the quantum to very low values because that may reduce performance under some extreme conditions.
    # We recommend that you not use values lower than 10.
    #
    # This method only can be used if event loop is running.
    #
    # @param mills [Integer] New timer granularity, in milliseconds
    # @see EventMachine.add_timer
    # @see EventMachine.add_periodic_timer
    # @see EventMachine::Timer
    # @see EventMachine.run
    #
    # source://eventmachine//lib/eventmachine.rb#902
    def set_quantum(mills); end

    # This method is a no-op in the pure-Ruby implementation. We simply return Ruby's built-in
    # per-process file-descriptor limit.
    #
    # @private
    def set_rlimit_nofile(_arg0); end

    def set_simultaneous_accept_count(_arg0); end

    # @private
    def set_sock_opt(_arg0, _arg1, _arg2, _arg3); end

    # Sets reactor quantum in milliseconds. The underlying Reactor function wants a (possibly
    # fractional) number of seconds.
    #
    # @private
    def set_timer_quantum(_arg0); end

    # This method takes a series of positional arguments for specifying such
    # things as private keys and certificate chains. It's expected that the
    # parameter list will grow as we add more supported features. ALL of these
    # parameters are optional, and can be specified as empty or nil strings.
    #
    # @private
    def set_tls_parms(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9); end

    def setuid_string(_arg0); end

    # @private
    def signal_loopbreak; end

    # Spawn an erlang-style process
    #
    # source://eventmachine//lib/em/spawnable.rb#69
    def spawn(&block); end

    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#1065
    def spawn_threadpool; end

    # @private
    # @return [Boolean]
    def ssl?; end

    def start_proxy(_arg0, _arg1, _arg2, _arg3); end

    # Initiates a TCP server (socket acceptor) on the specified IP address and port.
    #
    # The IP address must be valid on the machine where the program
    # runs, and the process must be privileged enough to listen
    # on the specified port (on Unix-like systems, superuser privileges
    # are usually required to listen on any port lower than 1024).
    # Only one listener may be running on any given address/port
    # combination. start_server will fail if the given address and port
    # are already listening on the machine, either because of a prior call
    # to {.start_server} or some unrelated process running on the machine.
    # If {.start_server} succeeds, the new network listener becomes active
    # immediately and starts accepting connections from remote peers,
    # and these connections generate callback events that are processed
    # by the code specified in the handler parameter to {.start_server}.
    #
    # The optional handler which is passed to this method is the key
    # to EventMachine's ability to handle particular network protocols.
    # The handler parameter passed to start_server must be a Ruby Module
    # that you must define. When the network server that is started by
    # start_server accepts a new connection, it instantiates a new
    # object of an anonymous class that is inherited from {EventMachine::Connection},
    # *into which your handler module have been included*. Arguments passed into start_server
    # after the class name are passed into the constructor during the instantiation.
    #
    # Your handler module may override any of the methods in {EventMachine::Connection},
    # such as {EventMachine::Connection#receive_data}, in order to implement the specific behavior
    # of the network protocol.
    #
    # Callbacks invoked in response to network events *always* take place
    # within the execution context of the object derived from {EventMachine::Connection}
    # extended by your handler module. There is one object per connection, and
    # all of the callbacks invoked for a particular connection take the form
    # of instance methods called against the corresponding {EventMachine::Connection}
    # object. Therefore, you are free to define whatever instance variables you
    # wish, in order to contain the per-connection state required by the network protocol you are
    # implementing.
    #
    # {EventMachine.start_server} is usually called inside the block passed to {EventMachine.run},
    # but it can be called from any EventMachine callback. {EventMachine.start_server} will fail
    # unless the EventMachine event loop is currently running (which is why
    # it's often called in the block suppled to {EventMachine.run}).
    #
    # You may call start_server any number of times to start up network
    # listeners on different address/port combinations. The servers will
    # all run simultaneously. More interestingly, each individual call to start_server
    # can specify a different handler module and thus implement a different
    # network protocol from all the others.
    #
    # @example
    #
    #   require 'rubygems'
    #   require 'eventmachine'
    #
    #   # Here is an example of a server that counts lines of input from the remote
    #   # peer and sends back the total number of lines received, after each line.
    #   # Try the example with more than one client connection opened via telnet,
    #   # and you will see that the line count increments independently on each
    #   # of the client connections. Also very important to note, is that the
    #   # handler for the receive_data function, which our handler redefines, may
    #   # not assume that the data it receives observes any kind of message boundaries.
    #   # Also, to use this example, be sure to change the server and port parameters
    #   # to the start_server call to values appropriate for your environment.
    #   module LineCounter
    #   MaxLinesPerConnection = 10
    #
    #   def post_init
    #   puts "Received a new connection"
    #   @data_received = ""
    #   @line_count = 0
    #   end
    #
    #   def receive_data data
    #   @data_received << data
    #   while @data_received.slice!( /^[^\n]*[\n]/m )
    #   @line_count += 1
    #   send_data "received #{@line_count} lines so far\r\n"
    #   @line_count == MaxLinesPerConnection and close_connection_after_writing
    #   end
    #   end
    #   end
    #
    #   EventMachine.run {
    #   host, port = "192.168.0.100", 8090
    #   EventMachine.start_server host, port, LineCounter
    #   puts "Now accepting connections on address #{host}, port #{port}..."
    #   EventMachine.add_periodic_timer(10) { $stderr.write "*" }
    #   }
    # @note Don't forget that in order to bind to ports < 1024 on Linux, *BSD and Mac OS X your process must have superuser privileges.
    # @param server [String] Host to bind to.
    # @param port [Integer] Port to bind to.
    # @param handler [Module, Class] A module or class that implements connection callbacks
    # @see file:docs/GettingStarted.md EventMachine tutorial
    # @see EventMachine.stop_server
    #
    # source://eventmachine//lib/eventmachine.rb#517
    def start_server(server, port = T.unsafe(nil), handler = T.unsafe(nil), *args, &block); end

    # @private
    def start_tcp_server(_arg0, _arg1); end

    def start_tls(_arg0); end

    # Start a Unix-domain server.
    #
    # Note that this is an alias for {EventMachine.start_server}, which can be used to start both
    # TCP and Unix-domain servers.
    #
    # @see EventMachine.start_server
    #
    # source://eventmachine//lib/eventmachine.rb#561
    def start_unix_domain_server(filename, *args, &block); end

    # @private
    def start_unix_server(_arg0); end

    # @private
    def stop; end

    # Causes the processing loop to stop executing, which will cause all open connections and accepting servers
    # to be run down and closed. Connection termination callbacks added using {EventMachine.add_shutdown_hook}
    # will be called as part of running this method.
    #
    # When all of this processing is complete, the call to {EventMachine.run} which started the processing loop
    # will return and program flow will resume from the statement following {EventMachine.run} call.
    #
    # @example Stopping a running EventMachine event loop
    #
    #   require 'rubygems'
    #   require 'eventmachine'
    #
    #   module Redmond
    #   def post_init
    #   puts "We're sending a dumb HTTP request to the remote peer."
    #   send_data "GET / HTTP/1.1\r\nHost: www.microsoft.com\r\n\r\n"
    #   end
    #
    #   def receive_data data
    #   puts "We received #{data.length} bytes from the remote peer."
    #   puts "We're going to stop the event loop now."
    #   EventMachine::stop_event_loop
    #   end
    #
    #   def unbind
    #   puts "A connection has terminated."
    #   end
    #   end
    #
    #   puts "We're starting the event loop now."
    #   EventMachine.run {
    #   EventMachine.connect "www.microsoft.com", 80, Redmond
    #   }
    #   puts "The event loop has stopped."
    #
    #   # This program will produce approximately the following output:
    #   #
    #   # We're starting the event loop now.
    #   # We're sending a dumb HTTP request to the remote peer.
    #   # We received 1440 bytes from the remote peer.
    #   # We're going to stop the event loop now.
    #   # A connection has terminated.
    #   # The event loop has stopped.
    #
    # source://eventmachine//lib/eventmachine.rb#417
    def stop_event_loop; end

    def stop_proxy(_arg0); end

    # Stop a TCP server socket that was started with {EventMachine.start_server}.
    #
    # @see EventMachine.start_server
    #
    # source://eventmachine//lib/eventmachine.rb#551
    def stop_server(signature); end

    # @private
    def stop_tcp_server(_arg0); end

    # @return [Boolean]
    def stopping?; end

    # EM::system is a simple wrapper for EM::popen. It is similar to Kernel::system, but requires a
    # single string argument for the command and performs no shell expansion.
    #
    # The block or proc passed to EM::system is called with two arguments: the output generated by the command,
    # and a Process::Status that contains information about the command's execution.
    #
    #  EM.run{
    #    EM.system('ls'){ |output,status| puts output if status.exitstatus == 0 }
    #  }
    #
    # You can also supply an additional proc to send some data to the process:
    #
    #  EM.run{
    #    EM.system('sh', proc{ |process|
    #      process.send_data("echo hello\n")
    #      process.send_data("exit\n")
    #    }, proc{ |out,status|
    #      puts(out)
    #    })
    #  }
    #
    # Like EventMachine.popen, EventMachine.system currently does not work on windows.
    # It returns the pid of the spawned process.
    #
    # source://eventmachine//lib/em/processes.rb#112
    def system(cmd, *args, &cb); end

    # @private
    #
    # source://eventmachine//lib/eventmachine.rb#1105
    def threadpool; end

    # Size of the EventMachine.defer threadpool (defaults to 20)
    #
    # @return [Number]
    #
    # source://eventmachine//lib/eventmachine.rb#1109
    def threadpool_size; end

    # Size of the EventMachine.defer threadpool (defaults to 20)
    #
    # @return [Number]
    #
    # source://eventmachine//lib/eventmachine.rb#1109
    def threadpool_size=(_arg0); end

    # Creates and immediately starts an EventMachine::TickLoop
    #
    # source://eventmachine//lib/em/tick_loop.rb#3
    def tick_loop(*a, &b); end

    def unwatch_filename(_arg0); end
    def unwatch_pid(_arg0); end

    # {EventMachine.watch} registers a given file descriptor or IO object with the eventloop. The
    # file descriptor will not be modified (it will remain blocking or non-blocking).
    #
    # The eventloop can be used to process readable and writable events on the file descriptor, using
    # {EventMachine::Connection#notify_readable=} and {EventMachine::Connection#notify_writable=}
    #
    # {EventMachine::Connection#notify_readable?} and {EventMachine::Connection#notify_writable?} can be used
    # to check what events are enabled on the connection.
    #
    # To detach the file descriptor, use {EventMachine::Connection#detach}
    #
    # @author Riham Aldakkak (eSpace Technologies)
    # @example
    #
    #   module SimpleHttpClient
    #   def notify_readable
    #   header = @io.readline
    #
    #   if header == "\r\n"
    #   # detach returns the file descriptor number (fd == @io.fileno)
    #   fd = detach
    #   end
    #   rescue EOFError
    #   detach
    #   end
    #
    #   def unbind
    #   EM.next_tick do
    #   # socket is detached from the eventloop, but still open
    #   data = @io.read
    #   end
    #   end
    #   end
    #
    #   EventMachine.run {
    #   sock = TCPSocket.new('site.com', 80)
    #   sock.write("GET / HTTP/1.0\r\n\r\n")
    #   conn = EventMachine.watch(sock, SimpleHttpClient)
    #   conn.notify_readable = true
    #   }
    #
    # source://eventmachine//lib/eventmachine.rb#731
    def watch(io, handler = T.unsafe(nil), *args, &blk); end

    # EventMachine's file monitoring API. Currently supported are the following events
    # on individual files, using inotify on Linux systems, and kqueue for *BSD and Mac OS X:
    #
    # * File modified (written to)
    # * File moved/renamed
    # * File deleted
    #
    # EventMachine::watch_file takes a filename and a handler Module containing your custom callback methods.
    # This will setup the low level monitoring on the specified file, and create a new EventMachine::FileWatch
    # object with your Module mixed in. FileWatch is a subclass of {EventMachine::Connection}, so callbacks on this object
    # work in the familiar way. The callbacks that will be fired by EventMachine are:
    #
    # * file_modified
    # * file_moved
    # * file_deleted
    #
    # You can access the filename being monitored from within this object using {FileWatch#path}.
    #
    # When a file is deleted, {FileWatch#stop_watching} will be called after your file_deleted callback,
    # to clean up the underlying monitoring and remove EventMachine's reference to the now-useless {FileWatch} instance.
    # This will in turn call unbind, if you wish to use it.
    #
    # The corresponding system-level Errno will be raised when attempting to monitor non-existent files,
    # files with wrong permissions, or if an error occurs dealing with inotify/kqueue.
    #
    # @example
    #
    #   # Before running this example, make sure we have a file to monitor:
    #   # $ echo "bar" > /tmp/foo
    #
    #   module Handler
    #   def file_modified
    #   puts "#{path} modified"
    #   end
    #
    #   def file_moved
    #   puts "#{path} moved"
    #   end
    #
    #   def file_deleted
    #   puts "#{path} deleted"
    #   end
    #
    #   def unbind
    #   puts "#{path} monitoring ceased"
    #   end
    #   end
    #
    #   # for efficient file watching, use kqueue on Mac OS X
    #   EventMachine.kqueue = true if EventMachine.kqueue?
    #
    #   EventMachine.run {
    #   EventMachine.watch_file("/tmp/foo", Handler)
    #   }
    #
    #   # $ echo "baz" >> /tmp/foo    =>    "/tmp/foo modified"
    #   # $ mv /tmp/foo /tmp/oof      =>    "/tmp/foo moved"
    #   # $ rm /tmp/oof               =>    "/tmp/foo deleted"
    # @note The ability to pick up on the new filename after a rename is not yet supported.
    #   Calling #path will always return the filename you originally used.
    # @param filename [String] Local path to the file to watch.
    # @param handler [Class, Module] A class or module that implements event handlers associated with the file.
    #
    # source://eventmachine//lib/eventmachine.rb#1309
    def watch_file(filename, handler = T.unsafe(nil), *args); end

    def watch_filename(_arg0); end
    def watch_pid(_arg0); end

    # EventMachine's process monitoring API. On Mac OS X and *BSD this method is implemented using kqueue.
    #
    # @example
    #
    #   module ProcessWatcher
    #   def process_exited
    #   put 'the forked child died!'
    #   end
    #   end
    #
    #   pid = fork{ sleep }
    #
    #   EventMachine.run {
    #   EventMachine.watch_process(pid, ProcessWatcher)
    #   EventMachine.add_timer(1){ Process.kill('TERM', pid) }
    #   }
    # @param pid [Integer] PID of the process to watch.
    # @param handler [Class, Module] A class or module that implements event handlers associated with the file.
    #
    # source://eventmachine//lib/eventmachine.rb#1340
    def watch_process(pid, handler = T.unsafe(nil), *args); end

    # @private
    #
    # source://eventmachine//lib/em/spawnable.rb#76
    def yield(&block); end

    # @private
    #
    # source://eventmachine//lib/em/spawnable.rb#81
    def yield_and_notify(&block); end
  end
end

# Provides a simple thread-safe way to transfer data between (typically) long running
# tasks in {EventMachine.defer} and event loop thread.
#
# @example
#
#   channel = EventMachine::Channel.new
#   sid     = channel.subscribe { |msg| p [:got, msg] }
#
#   channel.push('hello world')
#   channel.unsubscribe(sid)
#
# source://eventmachine//lib/em/channel.rb#14
class EventMachine::Channel
  # @return [Channel] a new instance of Channel
  #
  # source://eventmachine//lib/em/channel.rb#15
  def initialize; end

  # Add items to the channel, which are pushed out to all subscribers.
  #
  # source://eventmachine//lib/em/channel.rb#46
  def <<(*items); end

  # Return the number of current subscribers.
  #
  # source://eventmachine//lib/em/channel.rb#21
  def num_subscribers; end

  # Fetches one message from the channel.
  #
  # source://eventmachine//lib/em/channel.rb#53
  def pop(*a, &b); end

  # Add items to the channel, which are pushed out to all subscribers.
  #
  # source://eventmachine//lib/em/channel.rb#46
  def push(*items); end

  # Takes any arguments suitable for EM::Callback() and returns a subscriber
  # id for use when unsubscribing.
  #
  # @return [Integer] Subscribe identifier
  # @see #unsubscribe
  #
  # source://eventmachine//lib/em/channel.rb#30
  def subscribe(*a, &b); end

  # Removes subscriber from the list.
  #
  # @param Subscriber [Integer] identifier
  # @see #subscribe
  #
  # source://eventmachine//lib/em/channel.rb#41
  def unsubscribe(name); end

  private

  # @private
  #
  # source://eventmachine//lib/em/channel.rb#65
  def gen_id; end
end

# source://eventmachine//lib/em/completion.rb#164
class EventMachine::Completion
  include ::EventMachine::Deferrable

  # @return [Completion] a new instance of Completion
  #
  # source://eventmachine//lib/em/completion.rb#171
  def initialize; end

  # Callbacks are called when you enter (or are in) a :succeeded state.
  #
  # source://eventmachine//lib/em/completion.rb#206
  def callback(*a, &b); end

  # Remove a callback. N.B. Some callbacks cannot be deleted. Usage is NOT
  # recommended, this is an anti-pattern.
  #
  # source://eventmachine//lib/em/completion.rb#272
  def cancel_callback(*a, &b); end

  # Remove an errback. N.B. Some errbacks cannot be deleted. Usage is NOT
  # recommended, this is an anti-pattern.
  #
  # source://eventmachine//lib/em/completion.rb#266
  def cancel_errback(*a, &b); end

  # Disable the timeout
  #
  # source://eventmachine//lib/em/completion.rb#257
  def cancel_timeout; end

  # Enter a new state, setting the result value if given. If the state is one
  # of :succeeded or :failed, then :completed callbacks will also be called.
  #
  # source://eventmachine//lib/em/completion.rb#224
  def change_state(state, *args); end

  # Indicates that we've reached some kind of completion state, by default
  # this is :succeeded or :failed. Due to these semantics, the :completed
  # state is reserved for internal use.
  #
  # @return [Boolean]
  #
  # source://eventmachine//lib/em/completion.rb#237
  def completed?; end

  # Completions are called when you enter (or are in) either a :failed or a
  # :succeeded state. They are stored as a special (reserved) state called
  # :completed.
  #
  # source://eventmachine//lib/em/completion.rb#218
  def completion(*a, &b); end

  # Completion states simply returns a list of completion states, by default
  # this is :succeeded and :failed.
  #
  # source://eventmachine//lib/em/completion.rb#243
  def completion_states; end

  # Errbacks are called when you enter (or are in) a :failed state.
  #
  # source://eventmachine//lib/em/completion.rb#211
  def errback(*a, &b); end

  # Enter the :failed state, setting the result value if given.
  #
  # source://eventmachine//lib/em/completion.rb#186
  def fail(*args); end

  # Enter the :failed state, setting the result value if given.
  # The old EM method:
  #
  # source://eventmachine//lib/em/completion.rb#186
  def set_deferred_failure(*args); end

  # Enter a new state, setting the result value if given. If the state is one
  # of :succeeded or :failed, then :completed callbacks will also be called.
  # The old EM method:
  #
  # source://eventmachine//lib/em/completion.rb#224
  def set_deferred_status(state, *args); end

  # Enter the :succeeded state, setting the result value if given.
  # The old EM method:
  #
  # source://eventmachine//lib/em/completion.rb#179
  def set_deferred_success(*args); end

  # Returns the value of attribute state.
  #
  # source://eventmachine//lib/em/completion.rb#169
  def state; end

  # Statebacks are called when you enter (or are in) the named state.
  #
  # source://eventmachine//lib/em/completion.rb#193
  def stateback(state, *a, &b); end

  # Enter the :succeeded state, setting the result value if given.
  #
  # source://eventmachine//lib/em/completion.rb#179
  def succeed(*args); end

  # Schedule a time which if passes before we enter a completion state, this
  # deferrable will be failed with the given arguments.
  #
  # source://eventmachine//lib/em/completion.rb#249
  def timeout(time, *args); end

  # Returns the value of attribute value.
  #
  # source://eventmachine//lib/em/completion.rb#169
  def value; end

  private

  # If we enter a completion state, clear other completion states after all
  # callback chains are completed. This means that operation specific
  # callbacks can't be dual-called, which is most common user error.
  #
  # source://eventmachine//lib/em/completion.rb#298
  def clear_dead_callbacks; end

  # Execute all callbacks for the current state. If in a completed state, then
  # call any statebacks associated with the completed state.
  #
  # source://eventmachine//lib/em/completion.rb#279
  def execute_callbacks; end

  # Iterate all callbacks for a given state, and remove then call them.
  #
  # source://eventmachine//lib/em/completion.rb#289
  def execute_state_callbacks(state); end
end

# @private
#
# source://eventmachine//lib/em/connection.rb#37
class EventMachine::Connection
  # Stubbed initialize so legacy superclasses can safely call super
  #
  # @private
  # @return [Connection] a new instance of Connection
  #
  # source://eventmachine//lib/em/connection.rb#67
  def initialize(*args); end

  def associate_callback_target(_arg0); end

  # EventMachine::Connection#close_connection is called only by user code, and never
  # by the event loop. You may call this method against a connection object in any
  # callback handler, whether or not the callback was made against the connection
  # you want to close. close_connection <i>schedules</i> the connection to be closed
  # at the next available opportunity within the event loop. You may not assume that
  # the connection is closed when close_connection returns. In particular, the framework
  # will callback the unbind method for the particular connection at a point shortly
  # after you call close_connection. You may assume that the unbind callback will
  # take place sometime after your call to close_connection completes. In other words,
  # the unbind callback will not re-enter your code "inside" of your call to close_connection.
  # However, it's not guaranteed that a future version of EventMachine will not change
  # this behavior.
  #
  # {#close_connection} will *silently discard* any outbound data which you have
  # sent to the connection using {EventMachine::Connection#send_data} but which has not
  # yet been sent across the network. If you want to avoid this behavior, use
  # {EventMachine::Connection#close_connection_after_writing}.
  #
  # source://eventmachine//lib/em/connection.rb#265
  def close_connection(after_writing = T.unsafe(nil)); end

  # A variant of {#close_connection}.
  # All of the descriptive comments given for close_connection also apply to
  # close_connection_after_writing, *with one exception*: if the connection has
  # outbound data sent using send_dat but which has not yet been sent across the network,
  # close_connection_after_writing will schedule the connection to be closed *after*
  # all of the outbound data has been safely written to the remote peer.
  #
  # Depending on the amount of outgoing data and the speed of the network,
  # considerable time may elapse between your call to close_connection_after_writing
  # and the actual closing of the socket (at which time the unbind callback will be called
  # by the event loop). During this time, you *may not* call send_data to transmit
  # additional data (that is, the connection is closed for further writes). In very
  # rare cases, you may experience a receive_data callback after your call to {#close_connection_after_writing},
  # depending on whether incoming data was in the process of being received on the connection
  # at the moment when you called {#close_connection_after_writing}. Your protocol handler must
  # be prepared to properly deal with such data (probably by ignoring it).
  #
  # @see #close_connection
  # @see #send_data
  #
  # source://eventmachine//lib/em/connection.rb#302
  def close_connection_after_writing; end

  # comm_inactivity_timeout returns the current value (float in seconds) of the inactivity-timeout
  # property of network-connection and datagram-socket objects. A nonzero value
  # indicates that the connection or socket will automatically be closed if no read or write
  # activity takes place for at least that number of seconds.
  # A zero value (the default) specifies that no automatic timeout will take place.
  #
  # source://eventmachine//lib/em/connection.rb#647
  def comm_inactivity_timeout; end

  # Allows you to set the inactivity-timeout property for
  # a network connection or datagram socket. Specify a non-negative float value in seconds.
  # If the value is greater than zero, the connection or socket will automatically be closed
  # if no read or write activity takes place for at least that number of seconds.
  # Specify a value of zero to indicate that no automatic timeout should take place.
  # Zero is the default value.
  #
  # source://eventmachine//lib/em/connection.rb#657
  def comm_inactivity_timeout=(value); end

  # Called by the event loop when a remote TCP connection attempt completes successfully.
  # You can expect to get this notification after calls to {EventMachine.connect}. Remember that EventMachine makes remote connections
  # asynchronously, just as with any other kind of network event. This method
  # is intended primarily to assist with network diagnostics. For normal protocol
  # handling, use #post_init to perform initial work on a new connection (such as sending initial set of data).
  # {Connection#post_init} will always be called. This method will only be called in case of a successful completion.
  # A connection attempt which fails will result a call to {Connection#unbind} after the failure.
  #
  # @see Connection#post_init
  # @see Connection#unbind
  # @see file:docs/GettingStarted.md EventMachine tutorial
  #
  # source://eventmachine//lib/em/connection.rb#362
  def connection_completed; end

  # Removes given connection from the event loop.
  # The connection's socket remains open and its file descriptor number is returned.
  #
  # source://eventmachine//lib/em/connection.rb#271
  def detach; end

  # Returns true if the connection is in an error state, false otherwise.
  #
  # In general, you can detect the occurrence of communication errors or unexpected
  # disconnection by the remote peer by handing the {#unbind} method. In some cases, however,
  # it's useful to check the status of the connection using {#error?} before attempting to send data.
  # This function is synchronous but it will return immediately without blocking.
  #
  # @return [Boolean] true if the connection is in an error state, false otherwise
  #
  # source://eventmachine//lib/em/connection.rb#339
  def error?; end

  # source://eventmachine//lib/em/connection.rb#534
  def get_cipher_bits; end

  # source://eventmachine//lib/em/connection.rb#538
  def get_cipher_name; end

  # source://eventmachine//lib/em/connection.rb#542
  def get_cipher_protocol; end

  # The number of seconds since the last send/receive activity on this connection.
  #
  # source://eventmachine//lib/em/connection.rb#638
  def get_idle_time; end

  # No-op for the time being
  def get_outbound_data_size; end

  # If [TLS](http://en.wikipedia.org/wiki/Transport_Layer_Security) is active on the connection, returns the remote [X509 certificate](http://en.wikipedia.org/wiki/X.509)
  # as a string, in the popular [PEM format](http://en.wikipedia.org/wiki/Privacy_Enhanced_Mail). This can then be used for arbitrary validation
  # of a peer's certificate in your code.
  #
  # This should be called in/after the {#ssl_handshake_completed} callback, which indicates
  # that SSL/TLS is active. Using this callback is important, because the certificate may not
  # be available until the time it is executed. Using #post_init or #connection_completed is
  # not adequate, because the SSL handshake may still be taking place.
  #
  # This method will return `nil` if:
  #
  # * EventMachine is not built with [OpenSSL](http://www.openssl.org) support
  # * [TLS](http://en.wikipedia.org/wiki/Transport_Layer_Security) is not active on the connection
  # * TLS handshake is not yet complete
  # * Remote peer for any other reason has not presented a certificate
  #
  #
  # You can do whatever you want with the certificate String, such as load it
  # as a certificate object using the OpenSSL library, and check its fields.
  #
  # @example Getting peer TLS certificate information in EventMachine
  #
  #   module Handler
  #   def post_init
  #   puts "Starting TLS"
  #   start_tls
  #   end
  #
  #   def ssl_handshake_completed
  #   puts get_peer_cert
  #   close_connection
  #   end
  #
  #   def unbind
  #   EventMachine::stop_event_loop
  #   end
  #   end
  #
  #   EventMachine.run do
  #   EventMachine.connect "mail.google.com", 443, Handler
  #   end
  #
  #   # Will output:
  #   # -----BEGIN CERTIFICATE-----
  #   # MIIDIjCCAougAwIBAgIQbldpChBPqv+BdPg4iwgN8TANBgkqhkiG9w0BAQUFADBM
  #   # MQswCQYDVQQGEwJaQTElMCMGA1UEChMcVGhhd3RlIENvbnN1bHRpbmcgKFB0eSkg
  #   # THRkLjEWMBQGA1UEAxMNVGhhd3RlIFNHQyBDQTAeFw0wODA1MDIxNjMyNTRaFw0w
  #   # OTA1MDIxNjMyNTRaMGkxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlh
  #   # MRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRMwEQYDVQQKEwpHb29nbGUgSW5jMRgw
  #   # FgYDVQQDEw9tYWlsLmdvb2dsZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJ
  #   # AoGBALlkxdh2QXegdElukCSOV2+8PKiONIS+8Tu9K7MQsYpqtLNC860zwOPQ2NLI
  #   # 3Zp4jwuXVTrtzGuiqf5Jioh35Ig3CqDXtLyZoypjZUQcq4mlLzHlhIQ4EhSjDmA7
  #   # Ffw9y3ckSOQgdBQWNLbquHh9AbEUjmhkrYxIqKXeCnRKhv6nAgMBAAGjgecwgeQw
  #   # KAYDVR0lBCEwHwYIKwYBBQUHAwEGCCsGAQUFBwMCBglghkgBhvhCBAEwNgYDVR0f
  #   # BC8wLTAroCmgJ4YlaHR0cDovL2NybC50aGF3dGUuY29tL1RoYXd0ZVNHQ0NBLmNy
  #   # bDByBggrBgEFBQcBAQRmMGQwIgYIKwYBBQUHMAGGFmh0dHA6Ly9vY3NwLnRoYXd0
  #   # ZS5jb20wPgYIKwYBBQUHMAKGMmh0dHA6Ly93d3cudGhhd3RlLmNvbS9yZXBvc2l0
  #   # b3J5L1RoYXd0ZV9TR0NfQ0EuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQEF
  #   # BQADgYEAsRwpLg1dgCR1gYDK185MFGukXMeQFUvhGqF8eT/CjpdvezyKVuz84gSu
  #   # 6ccMXgcPQZGQN/F4Xug+Q01eccJjRSVfdvR5qwpqCj+6BFl5oiKDBsveSkrmL5dz
  #   # s2bn7TdTSYKcLeBkjXxDLHGBqLJ6TNCJ3c4/cbbG5JhGvoema94=
  #   # -----END CERTIFICATE-----
  # @return [String] the remote [X509 certificate](http://en.wikipedia.org/wiki/X.509), in the popular [PEM format](http://en.wikipedia.org/wiki/Privacy_Enhanced_Mail),
  #   if TLS is active on the connection
  # @see Connection#start_tls
  # @see Connection#ssl_handshake_completed
  #
  # source://eventmachine//lib/em/connection.rb#530
  def get_peer_cert; end

  # This method is used with stream-connections to obtain the identity
  # of the remotely-connected peer. If a peername is available, this method
  # returns a sockaddr structure. The method returns nil if no peername is available.
  # You can use Socket.unpack_sockaddr_in and its variants to obtain the
  # values contained in the peername structure returned from #get_peername.
  #
  # @example How to get peer IP address and port with EventMachine
  #
  #   require 'socket'
  #
  #   module Handler
  #   def receive_data data
  #   port, ip = Socket.unpack_sockaddr_in(get_peername)
  #   puts "got #{data.inspect} from #{ip}:#{port}"
  #   end
  #   end
  #
  # source://eventmachine//lib/em/connection.rb#596
  def get_peername; end

  # Returns the PID (kernel process identifier) of a subprocess
  # associated with this Connection object. For use with {EventMachine.popen}
  # and similar methods. Returns nil when there is no meaningful subprocess.
  #
  # @return [Integer]
  #
  # source://eventmachine//lib/em/connection.rb#625
  def get_pid; end

  # The number of bytes proxied to another connection. Reset to zero when
  # EventMachine::Connection#proxy_incoming_to is called, and incremented whenever data is proxied.
  #
  # source://eventmachine//lib/em/connection.rb#243
  def get_proxied_bytes; end

  # source://eventmachine//lib/em/connection.rb#546
  def get_sni_hostname; end

  # source://eventmachine//lib/em/connection.rb#275
  def get_sock_opt(level, option); end

  # Used with stream-connections to obtain the identity
  # of the local side of the connection. If a local name is available, this method
  # returns a sockaddr structure. The method returns nil if no local name is available.
  # You can use {Socket.unpack_sockaddr_in} and its variants to obtain the
  # values contained in the local-name structure returned from this method.
  #
  # @example
  #
  #   require 'socket'
  #
  #   module Handler
  #   def receive_data data
  #   port, ip = Socket.unpack_sockaddr_in(get_sockname)
  #   puts "got #{data.inspect}"
  #   end
  #   end
  #
  # source://eventmachine//lib/em/connection.rb#616
  def get_sockname; end

  # Returns a subprocess exit status. Only useful for {EventMachine.popen}. Call it in your
  # {#unbind} handler.
  #
  # @return [Integer]
  #
  # source://eventmachine//lib/em/connection.rb#633
  def get_status; end

  # Watches connection for readability. Only possible if the connection was created
  # using {EventMachine.attach} and had {EventMachine.notify_readable}/{EventMachine.notify_writable} defined on the handler.
  #
  # @see #notify_readable?
  #
  # source://eventmachine//lib/em/connection.rb#729
  def notify_readable=(mode); end

  # @return [Boolean] true if the connection is being watched for readability.
  #
  # source://eventmachine//lib/em/connection.rb#734
  def notify_readable?; end

  # Watches connection for writeability. Only possible if the connection was created
  # using {EventMachine.attach} and had {EventMachine.notify_readable}/{EventMachine.notify_writable} defined on the handler.
  #
  # @see #notify_writable?
  #
  # source://eventmachine//lib/em/connection.rb#742
  def notify_writable=(mode); end

  # Returns true if the connection is being watched for writability.
  #
  # @return [Boolean]
  #
  # source://eventmachine//lib/em/connection.rb#747
  def notify_writable?; end

  # @private
  def original_method(_arg0); end

  # Pause a connection so that {#send_data} and {#receive_data} events are not fired until {#resume} is called.
  #
  # @see #resume
  #
  # source://eventmachine//lib/em/connection.rb#753
  def pause; end

  # @return [Boolean] true if the connect was paused using {EventMachine::Connection#pause}.
  # @see #pause
  # @see #resume
  #
  # source://eventmachine//lib/em/connection.rb#766
  def paused?; end

  # The duration after which a TCP connection in the connecting state will fail.
  # It is important to distinguish this value from {EventMachine::Connection#comm_inactivity_timeout},
  # which looks at how long since data was passed on an already established connection.
  # The value is a float in seconds.
  #
  # @return [Float] The duration after which a TCP connection in the connecting state will fail, in seconds.
  #
  # source://eventmachine//lib/em/connection.rb#668
  def pending_connect_timeout; end

  # Sets the duration after which a TCP connection in a
  # connecting state will fail.
  #
  # @param value [Float, #to_f] Connection timeout in seconds
  #
  # source://eventmachine//lib/em/connection.rb#676
  def pending_connect_timeout=(value); end

  # Called by the event loop immediately after the network connection has been established,
  # and before resumption of the network loop.
  # This method is generally not called by user code, but is called automatically
  # by the event loop. The base-class implementation is a no-op.
  # This is a very good place to initialize instance variables that will
  # be used throughout the lifetime of the network connection.
  #
  # @see #connection_completed
  # @see #unbind
  # @see #send_data
  # @see #receive_data
  #
  # source://eventmachine//lib/em/connection.rb#81
  def post_init; end

  # called when the reactor finished proxying all
  # of the requested bytes.
  #
  # source://eventmachine//lib/em/connection.rb#224
  def proxy_completed; end

  # EventMachine::Connection#proxy_incoming_to is called only by user code. It sets up
  # a low-level proxy relay for all data inbound for this connection, to the connection given
  # as the argument. This is essentially just a helper method for enable_proxy.
  #
  # @see EventMachine.enable_proxy
  #
  # source://eventmachine//lib/em/connection.rb#232
  def proxy_incoming_to(conn, bufsize = T.unsafe(nil)); end

  # Called by the reactor after attempting to relay incoming data to a descriptor (set as a proxy target descriptor with
  # {EventMachine.enable_proxy}) that has already been closed.
  #
  # @see EventMachine.enable_proxy
  #
  # source://eventmachine//lib/em/connection.rb#219
  def proxy_target_unbound; end

  # Called by the event loop whenever data has been received by the network connection.
  # It is never called by user code. {#receive_data} is called with a single parameter, a String containing
  # the network protocol data, which may of course be binary. You will
  # generally redefine this method to perform your own processing of the incoming data.
  #
  # Here's a key point which is essential to understanding the event-driven
  # programming model: <i>EventMachine knows absolutely nothing about the protocol
  # which your code implements.</i> You must not make any assumptions about
  # the size of the incoming data packets, or about their alignment on any
  # particular intra-message or PDU boundaries (such as line breaks).
  # receive_data can and will send you arbitrary chunks of data, with the
  # only guarantee being that the data is presented to your code in the order
  # it was collected from the network. Don't even assume that the chunks of
  # data will correspond to network packets, as EventMachine can and will coalesce
  # several incoming packets into one, to improve performance. The implication for your
  # code is that you generally will need to implement some kind of a state machine
  # in your redefined implementation of receive_data. For a better understanding
  # of this, read through the examples of specific protocol handlers in EventMachine::Protocols
  #
  # The base-class implementation (which will be invoked only if you didn't override it in your protocol handler)
  # simply prints incoming data packet size to stdout.
  #
  # @note Depending on the protocol, buffer sizes and OS networking stack configuration, incoming data may or may not be "a complete message".
  #   It is up to this handler to detect content boundaries to determine whether all the content (for example, full HTTP request)
  #   has been received and can be processed.
  # @param data [String] Opaque incoming data.
  # @see #post_init
  # @see #connection_completed
  # @see #unbind
  # @see #send_data
  # @see file:docs/GettingStarted.md EventMachine tutorial
  #
  # source://eventmachine//lib/em/connection.rb#116
  def receive_data(data); end

  # Reconnect to a given host/port with the current instance
  #
  # @param server [String] Hostname or IP address
  # @param port [Integer] Port to reconnect to
  #
  # source://eventmachine//lib/em/connection.rb#685
  def reconnect(server, port); end

  # Resume a connection's {#send_data} and {#receive_data} events.
  #
  # @see #pause
  #
  # source://eventmachine//lib/em/connection.rb#759
  def resume; end

  # Call this method to send data to the remote end of the network connection. It takes a single String argument,
  # which may contain binary data. Data is buffered to be sent at the end of this event loop tick (cycle).
  #
  # When used in a method that is event handler (for example, {#post_init} or {#connection_completed}, it will send
  # data to the other end of the connection that generated the event.
  # You can also call {#send_data} to write to other connections. For more information see The Chat Server Example in the
  # {file:docs/GettingStarted.md EventMachine tutorial}.
  #
  # If you want to send some data and then immediately close the connection, make sure to use {#close_connection_after_writing}
  # instead of {#close_connection}.
  #
  # @param data [String] Data to send asynchronously
  # @see file:docs/GettingStarted.md EventMachine tutorial
  # @see Connection#receive_data
  # @see Connection#post_init
  # @see Connection#unbind
  #
  # source://eventmachine//lib/em/connection.rb#324
  def send_data(data); end

  # Sends UDP messages.
  #
  # This method may be called from any Connection object that refers
  # to an open datagram socket (see EventMachine#open_datagram_socket).
  # The method sends a UDP (datagram) packet containing the data you specify,
  # to a remote peer specified by the IP address and port that you give
  # as parameters to the method.
  # Observe that you may send a zero-length packet (empty string).
  # However, you may not send an arbitrarily-large data packet because
  # your operating system will enforce a platform-specific limit on
  # the size of the outbound packet. (Your kernel
  # will respond in a platform-specific way if you send an overlarge
  # packet: some will send a truncated packet, some will complain, and
  # some will silently drop your request).
  # On LANs, it's usually OK to send datagrams up to about 4000 bytes in length,
  # but to be really safe, send messages smaller than the Ethernet-packet
  # size (typically about 1400 bytes). Some very restrictive WANs
  # will either drop or truncate packets larger than about 500 bytes.
  #
  # @param data [String] Data to send asynchronously
  # @param recipient_address [String] IP address of the recipient
  # @param recipient_port [String] Port of the recipient
  #
  # source://eventmachine//lib/em/connection.rb#572
  def send_datagram(data, recipient_address, recipient_port); end

  # Like {EventMachine::Connection#send_data}, this sends data to the remote end of
  # the network connection. {EventMachine::Connection#send_file_data} takes a
  # filename as an argument, though, and sends the contents of the file, in one
  # chunk.
  #
  # @author Kirk Haines
  # @param filename [String] Local path of the file to send
  # @see #send_data
  #
  # source://eventmachine//lib/em/connection.rb#699
  def send_file_data(filename); end

  # Allows you to set the inactivity-timeout property for
  # a network connection or datagram socket. Specify a non-negative float value in seconds.
  # If the value is greater than zero, the connection or socket will automatically be closed
  # if no read or write activity takes place for at least that number of seconds.
  # Specify a value of zero to indicate that no automatic timeout should take place.
  # Zero is the default value.
  #
  # source://eventmachine//lib/em/connection.rb#657
  def set_comm_inactivity_timeout(value); end

  # Sets the duration after which a TCP connection in a
  # connecting state will fail.
  #
  # @param value [Float, #to_f] Connection timeout in seconds
  #
  # source://eventmachine//lib/em/connection.rb#676
  def set_pending_connect_timeout(value); end

  # source://eventmachine//lib/em/connection.rb#279
  def set_sock_opt(level, optname, optval); end

  # @private
  #
  # source://eventmachine//lib/em/connection.rb#39
  def signature; end

  # @private
  #
  # source://eventmachine//lib/em/connection.rb#39
  def signature=(_arg0); end

  # Called by EventMachine when the SSL/TLS handshake has
  # been completed, as a result of calling #start_tls to initiate SSL/TLS on the connection.
  #
  # This callback exists because {#post_init} and {#connection_completed} are **not** reliable
  # for indicating when an SSL/TLS connection is ready to have its certificate queried for.
  #
  # @see #get_peer_cert
  #
  # source://eventmachine//lib/em/connection.rb#127
  def ssl_handshake_completed; end

  # Called by EventMachine when :verify_peer => true has been passed to {#start_tls}.
  # It will be called with each certificate in the certificate chain provided by the remote peer.
  #
  # The cert will be passed as a String in PEM format, the same as in {#get_peer_cert}. It is up to user defined
  # code to perform a check on the certificates. The return value from this callback is used to accept or deny the peer.
  # A return value that is not nil or false triggers acceptance. If the peer is not accepted, the connection
  # will be subsequently closed.
  #
  # @example This server always accepts all peers
  #
  #   module AcceptServer
  #   def post_init
  #   start_tls(:verify_peer => true)
  #   end
  #
  #   def ssl_verify_peer(cert)
  #   true
  #   end
  #
  #   def ssl_handshake_completed
  #   $server_handshake_completed = true
  #   end
  #   end
  # @example This server never accepts any peers
  #
  #   module DenyServer
  #   def post_init
  #   start_tls(:verify_peer => true)
  #   end
  #
  #   def ssl_verify_peer(cert)
  #   # Do not accept the peer. This should now cause the connection to shut down
  #   # without the SSL handshake being completed.
  #   false
  #   end
  #
  #   def ssl_handshake_completed
  #   $server_handshake_completed = true
  #   end
  #   end
  # @see #start_tls
  #
  # source://eventmachine//lib/em/connection.rb#174
  def ssl_verify_peer(cert); end

  # Call {#start_tls} at any point to initiate TLS encryption on connected streams.
  # The method is smart enough to know whether it should perform a server-side
  # or a client-side handshake. An appropriate place to call {#start_tls} is in
  # your redefined {#post_init} method, or in the {#connection_completed} handler for
  # an outbound connection.
  #
  #
  # for encrypted private keys.
  # just filenames.
  #
  # @example Using TLS with EventMachine
  #
  #   require 'rubygems'
  #   require 'eventmachine'
  #
  #   module Handler
  #   def post_init
  #   start_tls(:private_key_file => '/tmp/server.key', :cert_chain_file => '/tmp/server.crt', :verify_peer => false)
  #   end
  #   end
  #
  #   EventMachine.run do
  #   EventMachine.start_server("127.0.0.1", 9999, Handler)
  #   end
  # @option args
  # @option args
  # @option args
  # @option args
  # @option args
  # @option args
  # @option args
  # @option args
  # @param args [Hash]
  # @see #ssl_verify_peer
  # @todo support passing an encryption parameter, which can be string or Proc, to get a passphrase
  # @todo support passing key material via raw strings or Procs that return strings instead of
  #
  # source://eventmachine//lib/em/connection.rb#417
  def start_tls(args = T.unsafe(nil)); end

  # A helper method for {EventMachine.disable_proxy}
  #
  # source://eventmachine//lib/em/connection.rb#237
  def stop_proxying; end

  # Open a file on the filesystem and send it to the remote peer. This returns an
  # object of type {EventMachine::Deferrable}. The object's callbacks will be executed
  # on the reactor main thread when the file has been completely scheduled for
  # transmission to the remote peer. Its errbacks will be called in case of an error (such as file-not-found).
  # This method employs various strategies to achieve the fastest possible performance,
  # balanced against minimum consumption of memory.
  #
  # Warning: this feature has an implicit dependency on an outboard extension,
  # evma_fastfilereader. You must install this extension in order to use {#stream_file_data}
  # with files larger than a certain size (currently 8192 bytes).
  #
  # @option args
  # @param filename [String] Local path of the file to stream
  # @param args [Hash] Options
  # @return [EventMachine::Deferrable]
  #
  # source://eventmachine//lib/em/connection.rb#721
  def stream_file_data(filename, args = T.unsafe(nil)); end

  # called by the framework whenever a connection (either a server or client connection) is closed.
  # The close can occur because your code intentionally closes it (using {#close_connection} and {#close_connection_after_writing}),
  # because the remote peer closed the connection, or because of a network error.
  # You may not assume that the network connection is still open and able to send or
  # receive data when the callback to unbind is made. This is intended only to give
  # you a chance to clean up associations your code may have made to the connection
  # object while it was open.
  #
  # If you want to detect which peer has closed the connection, you can override {#close_connection} in your protocol handler
  # and set an @ivar.
  #
  # @example Overriding Connection#close_connection to distinguish connections closed on our side
  #
  #   class MyProtocolHandler < EventMachine::Connection
  #
  #   # ...
  #
  #   def close_connection(*args)
  #   @intentionally_closed_connection = true
  #   super(*args)
  #   end
  #
  #   def unbind
  #   if @intentionally_closed_connection
  #   # ...
  #   end
  #   end
  #
  #   # ...
  #
  #   end
  # @see #post_init
  # @see #connection_completed
  # @see file:docs/GettingStarted.md EventMachine tutorial
  #
  # source://eventmachine//lib/em/connection.rb#212
  def unbind; end

  class << self
    # Override .new so subclasses don't have to call super and can ignore
    # connection-specific arguments
    #
    # @private
    #
    # source://eventmachine//lib/em/connection.rb#48
    def new(sig, *args); end
  end
end

# @private
EventMachine::ConnectionAccepted = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::ConnectionCompleted = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::ConnectionData = T.let(T.unsafe(nil), Integer)

# Exceptions that are defined in rubymain.cpp
class EventMachine::ConnectionError < ::RuntimeError; end

# @private
class EventMachine::ConnectionNotBound < ::RuntimeError; end

# @private
EventMachine::ConnectionNotifyReadable = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::ConnectionNotifyWritable = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::ConnectionUnbound = T.let(T.unsafe(nil), Integer)

# source://eventmachine//lib/em/resolver.rb#2
module EventMachine::DNS; end

# source://eventmachine//lib/em/resolver.rb#157
class EventMachine::DNS::Request
  include ::EventMachine::Deferrable

  # @return [Request] a new instance of Request
  #
  # source://eventmachine//lib/em/resolver.rb#161
  def initialize(socket, hostname); end

  # Returns the value of attribute max_tries.
  #
  # source://eventmachine//lib/em/resolver.rb#159
  def max_tries; end

  # Sets the attribute max_tries
  #
  # @param value the value to set the attribute max_tries to.
  #
  # source://eventmachine//lib/em/resolver.rb#159
  def max_tries=(_arg0); end

  # source://eventmachine//lib/em/resolver.rb#187
  def receive_answer(msg); end

  # Returns the value of attribute retry_interval.
  #
  # source://eventmachine//lib/em/resolver.rb#159
  def retry_interval; end

  # Sets the attribute retry_interval
  #
  # @param value the value to set the attribute retry_interval to.
  #
  # source://eventmachine//lib/em/resolver.rb#159
  def retry_interval=(_arg0); end

  # source://eventmachine//lib/em/resolver.rb#176
  def tick; end

  private

  # source://eventmachine//lib/em/resolver.rb#211
  def id; end

  # source://eventmachine//lib/em/resolver.rb#222
  def packet; end

  # source://eventmachine//lib/em/resolver.rb#205
  def send; end
end

# source://eventmachine//lib/em/resolver.rb#79
class EventMachine::DNS::RequestIdAlreadyUsed < ::RuntimeError; end

# source://eventmachine//lib/em/resolver.rb#3
class EventMachine::DNS::Resolver
  class << self
    # source://eventmachine//lib/em/resolver.rb#60
    def hosts; end

    # source://eventmachine//lib/em/resolver.rb#56
    def nameserver; end

    # source://eventmachine//lib/em/resolver.rb#36
    def nameservers; end

    # source://eventmachine//lib/em/resolver.rb#32
    def nameservers=(ns); end

    # source://eventmachine//lib/em/resolver.rb#20
    def resolve(hostname); end

    # source://eventmachine//lib/em/resolver.rb#24
    def socket; end

    # @return [Boolean]
    #
    # source://eventmachine//lib/em/resolver.rb#5
    def windows?; end
  end
end

# source://eventmachine//lib/em/resolver.rb#14
EventMachine::DNS::Resolver::HOSTS_FILE = T.let(T.unsafe(nil), String)

# source://eventmachine//lib/em/resolver.rb#81
class EventMachine::DNS::Socket < ::EventMachine::Connection
  # @return [Socket] a new instance of Socket
  #
  # source://eventmachine//lib/em/resolver.rb#86
  def initialize; end

  # source://eventmachine//lib/em/resolver.rb#122
  def deregister_request(id, req); end

  # source://eventmachine//lib/em/resolver.rb#135
  def nameserver; end

  # source://eventmachine//lib/em/resolver.rb#131
  def nameserver=(ns); end

  # source://eventmachine//lib/em/resolver.rb#90
  def post_init; end

  # Decodes the packet, looks for the request and passes the
  # response over to the requester
  #
  # source://eventmachine//lib/em/resolver.rb#141
  def receive_data(data); end

  # source://eventmachine//lib/em/resolver.rb#112
  def register_request(id, req); end

  # source://eventmachine//lib/em/resolver.rb#127
  def send_packet(pkt); end

  # source://eventmachine//lib/em/resolver.rb#94
  def start_timer; end

  # source://eventmachine//lib/em/resolver.rb#98
  def stop_timer; end

  # source://eventmachine//lib/em/resolver.rb#106
  def tick; end

  # source://eventmachine//lib/em/resolver.rb#103
  def unbind; end

  class << self
    # source://eventmachine//lib/em/resolver.rb#82
    def open; end
  end
end

# DefaultDeferrable is an otherwise empty class that includes Deferrable.
# This is very useful when you just need to return a Deferrable object
# as a way of communicating deferred status to some other part of a program.
#
# source://eventmachine//lib/em/deferrable.rb#207
class EventMachine::DefaultDeferrable
  include ::EventMachine::Deferrable
end

# source://eventmachine//lib/em/deferrable.rb#27
module EventMachine::Deferrable
  # Specify a block to be executed if and when the Deferrable object receives
  # a status of :succeeded. See #set_deferred_status for more information.
  #
  # Calling this method on a Deferrable object whose status is not yet known
  # will cause the callback block to be stored on an internal list.
  # If you call this method on a Deferrable whose status is :succeeded, the
  # block will be executed immediately, receiving the parameters given to the
  # prior #set_deferred_status call.
  #
  # --
  # If there is no status, add a callback to an internal list.
  # If status is succeeded, execute the callback immediately.
  # If status is failed, do nothing.
  #
  # source://eventmachine//lib/em/deferrable.rb#44
  def callback(&block); end

  # Cancels an outstanding callback to &block if any. Undoes the action of #callback.
  #
  # source://eventmachine//lib/em/deferrable.rb#58
  def cancel_callback(block); end

  # Cancels an outstanding errback to &block if any. Undoes the action of #errback.
  #
  # source://eventmachine//lib/em/deferrable.rb#84
  def cancel_errback(block); end

  # Cancels an outstanding timeout if any. Undoes the action of #timeout.
  #
  # source://eventmachine//lib/em/deferrable.rb#179
  def cancel_timeout; end

  # Specify a block to be executed if and when the Deferrable object receives
  # a status of :failed. See #set_deferred_status for more information.
  # --
  # If there is no status, add an errback to an internal list.
  # If status is failed, execute the errback immediately.
  # If status is succeeded, do nothing.
  #
  # source://eventmachine//lib/em/deferrable.rb#70
  def errback(&block); end

  # Sugar for set_deferred_status(:failed, ...)
  #
  # source://eventmachine//lib/em/deferrable.rb#197
  def fail(*args); end

  # Sugar for set_deferred_status(:failed, ...)
  #
  # source://eventmachine//lib/em/deferrable.rb#197
  def set_deferred_failure(*args); end

  # Sets the "disposition" (status) of the Deferrable object. See also the large set of
  # sugarings for this method.
  # Note that if you call this method without arguments,
  # no arguments will be passed to the callback/errback.
  # If the user has coded these with arguments, then the
  # user code will throw an argument exception.
  # Implementors of deferrable classes <b>must</b>
  # document the arguments they will supply to user callbacks.
  #
  # OBSERVE SOMETHING VERY SPECIAL here: you may call this method even
  # on the INSIDE of a callback. This is very useful when a previously-registered
  # callback wants to change the parameters that will be passed to subsequently-registered
  # ones.
  #
  # You may give either :succeeded or :failed as the status argument.
  #
  # If you pass :succeeded, then all of the blocks passed to the object using the #callback
  # method (if any) will be executed BEFORE the #set_deferred_status method returns. All of the blocks
  # passed to the object using #errback will be discarded.
  #
  # If you pass :failed, then all of the blocks passed to the object using the #errback
  # method (if any) will be executed BEFORE the #set_deferred_status method returns. All of the blocks
  # passed to the object using # callback will be discarded.
  #
  # If you pass any arguments to #set_deferred_status in addition to the status argument,
  # they will be passed as arguments to any callbacks or errbacks that are executed.
  # It's your responsibility to ensure that the argument lists specified in your callbacks and
  # errbacks match the arguments given in calls to #set_deferred_status, otherwise Ruby will raise
  # an ArgumentError.
  #
  # --
  # We're shifting callbacks off and discarding them as we execute them.
  # This is valid because by definition callbacks are executed no more than
  # once. It also has the magic effect of permitting recursive calls, which
  # means that a callback can call #set_deferred_status and change the parameters
  # that will be sent to subsequent callbacks down the chain.
  #
  # Changed @callbacks and @errbacks from push/shift to unshift/pop, per suggestion
  # by Kirk Haines, to work around the memory leak bug that still exists in many Ruby
  # versions.
  #
  # Changed 15Sep07: after processing callbacks or errbacks, CLEAR the other set of
  # handlers. This gets us a little closer to the behavior of Twisted's "deferred,"
  # which only allows status to be set once. Prior to making this change, it was possible
  # to "succeed" a Deferrable (triggering its callbacks), and then immediately "fail" it,
  # triggering its errbacks! That is clearly undesirable, but it's just as undesirable
  # to raise an exception is status is set more than once on a Deferrable. The latter
  # behavior would invalidate the idiom of resetting arguments by setting status from
  # within a callback or errback, but more seriously it would cause spurious errors
  # if a Deferrable was timed out and then an attempt was made to succeed it. See the
  # comments under the new method #timeout.
  #
  # source://eventmachine//lib/em/deferrable.rb#141
  def set_deferred_status(status, *args); end

  # Sugar for set_deferred_status(:succeeded, ...)
  #
  # source://eventmachine//lib/em/deferrable.rb#190
  def set_deferred_success(*args); end

  # Sugar for set_deferred_status(:succeeded, ...)
  #
  # source://eventmachine//lib/em/deferrable.rb#190
  def succeed(*args); end

  # Setting a timeout on a Deferrable causes it to go into the failed state after
  # the Timeout expires (passing no arguments to the object's errbacks).
  # Setting the status at any time prior to a call to the expiration of the timeout
  # will cause the timer to be cancelled.
  #
  # source://eventmachine//lib/em/deferrable.rb#170
  def timeout(seconds, *args); end

  class << self
    # A future is a sugaring of a typical deferrable usage.
    # --
    # Evaluate arg (which may be an expression or a block).
    # What's the class of arg?
    # If arg is an ordinary expression, then return it.
    # If arg is deferrable (responds to :set_deferred_status),
    # then look at the arguments. If either callback or errback
    # are defined, then use them. If neither are defined, then
    # use the supplied block (if any) as the callback.
    # Then return arg.
    #
    # source://eventmachine//lib/em/future.rb#44
    def future(arg, cb = T.unsafe(nil), eb = T.unsafe(nil), &blk); end
  end
end

# source://eventmachine//lib/em/deferrable/pool.rb#2
EventMachine::Deferrable::Pool = EventMachine::Pool

# EM::DeferrableChildProcess is a sugaring of a common use-case
# involving EM::popen.
# Call the #open method on EM::DeferrableChildProcess, passing
# a command-string. #open immediately returns an EM::Deferrable
# object. It also schedules the forking of a child process, which
# will execute the command passed to #open.
# When the forked child terminates, the Deferrable will be signalled
# and execute its callbacks, passing the data that the child process
# wrote to stdout.
#
# source://eventmachine//lib/em/processes.rb#39
class EventMachine::DeferrableChildProcess < ::EventMachine::Connection
  include ::EventMachine::Deferrable

  # @private
  # @return [DeferrableChildProcess] a new instance of DeferrableChildProcess
  #
  # source://eventmachine//lib/em/processes.rb#43
  def initialize; end

  # @private
  #
  # source://eventmachine//lib/em/processes.rb#65
  def receive_data(data); end

  # @private
  #
  # source://eventmachine//lib/em/processes.rb#70
  def unbind; end

  class << self
    # Sugars a common use-case involving forked child processes.
    # #open takes a String argument containing an shell command
    # string (including arguments if desired). #open immediately
    # returns an EventMachine::Deferrable object, without blocking.
    #
    # It also invokes EventMachine#popen to run the passed-in
    # command in a forked child process.
    #
    # When the forked child terminates, the Deferrable that
    # #open calls its callbacks, passing the data returned
    # from the child process.
    #
    # source://eventmachine//lib/em/processes.rb#60
    def open(cmd); end
  end
end

# @private
EventMachine::EM_PROTO_SSLv2 = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::EM_PROTO_SSLv3 = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::EM_PROTO_TLSv1 = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::EM_PROTO_TLSv1_1 = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::EM_PROTO_TLSv1_2 = T.let(T.unsafe(nil), Integer)

# System errnos
#
# @private
#
# source://eventmachine//lib/eventmachine.rb#90
EventMachine::ERRNOS = T.let(T.unsafe(nil), Hash)

# source://eventmachine//lib/em/connection.rb#2
class EventMachine::FileNotFoundException < ::Exception; end

# Streams a file over a given connection. Streaming begins once the object is
# instantiated. Typically FileStreamer instances are not reused.
#
# Streaming uses buffering for files larger than 16K and uses so-called fast file reader (a C++ extension)
# if available (it is part of eventmachine gem itself).
#
# @author Francis Cianfrocca
# @example
#
#   module FileSender
#   def post_init
#   streamer = EventMachine::FileStreamer.new(self, '/tmp/bigfile.tar')
#   streamer.callback{
#   # file was sent successfully
#   close_connection_after_writing
#   }
#   end
#   end
#
# source://eventmachine//lib/em/streamer.rb#22
class EventMachine::FileStreamer
  include ::EventMachine::Deferrable

  # @option args
  # @param connection [EventMachine::Connection]
  # @param filename [String] File path
  # @param args [Hash] a customizable set of options
  # @return [FileStreamer] a new instance of FileStreamer
  #
  # source://eventmachine//lib/em/streamer.rb#36
  def initialize(connection, filename, args = T.unsafe(nil)); end

  # Used internally to stream one chunk at a time over multiple reactor ticks
  #
  # @private
  #
  # source://eventmachine//lib/em/streamer.rb#77
  def stream_one_chunk; end

  private

  # We use an outboard extension class to get memory-mapped files.
  # It's outboard to avoid polluting the core distro, but that means
  # there's a "hidden" dependency on it. The first time we get here in
  # any run, try to load up the dependency extension. User code will see
  # a LoadError if it's not available, but code that doesn't require
  # mapped files will work fine without it. This is a somewhat difficult
  # compromise between usability and proper modularization.
  #
  # @private
  #
  # source://eventmachine//lib/em/streamer.rb#112
  def ensure_mapping_extension_is_present; end

  # @private
  #
  # source://eventmachine//lib/em/streamer.rb#66
  def stream_with_mapping(filename); end

  # @private
  #
  # source://eventmachine//lib/em/streamer.rb#53
  def stream_without_mapping(filename); end
end

# Wait until next tick to send more data when 50k is still in the outgoing buffer
#
# source://eventmachine//lib/em/streamer.rb#28
EventMachine::FileStreamer::BackpressureLevel = T.let(T.unsafe(nil), Integer)

# Send 16k chunks at a time
#
# source://eventmachine//lib/em/streamer.rb#30
EventMachine::FileStreamer::ChunkSize = T.let(T.unsafe(nil), Integer)

# Use mapped streamer for files bigger than 16k
#
# source://eventmachine//lib/em/streamer.rb#26
EventMachine::FileStreamer::MappingThreshold = T.let(T.unsafe(nil), Integer)

# Utility class that is useful for file monitoring. Supported events are
#
# * File is modified
# * File is deleted
# * File is moved
#
# @note On Mac OS X, file watching only works when kqueue is enabled
# @see EventMachine.watch_file
#
# source://eventmachine//lib/em/file_watch.rb#11
class EventMachine::FileWatch < ::EventMachine::Connection
  # Will be called when the file is deleted. Supposed to be redefined by subclasses.
  # When the file is deleted, stop_watching will be called after this to make sure everything is
  # cleaned up correctly.
  #
  # @abstract
  # @note On Linux (with {http://en.wikipedia.org/wiki/Inotify inotify}), this method will not be called until *all* open file descriptors to
  #   the file have been closed.
  #
  # source://eventmachine//lib/em/file_watch.rb#56
  def file_deleted; end

  # Will be called when the file is modified. Supposed to be redefined by subclasses.
  #
  # @abstract
  #
  # source://eventmachine//lib/em/file_watch.rb#45
  def file_modified; end

  # Will be called when the file is moved or renamed. Supposed to be redefined by subclasses.
  #
  # @abstract
  #
  # source://eventmachine//lib/em/file_watch.rb#62
  def file_moved; end

  # Returns the path that is being monitored.
  #
  # @note Current implementation does not pick up on the new filename after a rename occurs.
  # @return [String]
  # @see EventMachine.watch_file
  #
  # source://eventmachine//lib/em/file_watch.rb#38
  def path; end

  # @private
  #
  # source://eventmachine//lib/em/file_watch.rb#21
  def receive_data(data); end

  # Discontinue monitoring of the file.
  #
  # This involves cleaning up the underlying monitoring details with kqueue/inotify, and in turn firing {EventMachine::Connection#unbind}.
  # This will be called automatically when a file is deleted. User code may call it as well.
  #
  # source://eventmachine//lib/em/file_watch.rb#69
  def stop_watching; end
end

# @private
#
# source://eventmachine//lib/em/file_watch.rb#15
EventMachine::FileWatch::Cdeleted = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/file_watch.rb#13
EventMachine::FileWatch::Cmodified = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/file_watch.rb#17
EventMachine::FileWatch::Cmoved = T.let(T.unsafe(nil), String)

class EventMachine::InvalidSignature < ::RuntimeError; end

# A simple iterator for concurrent asynchronous work.
#
# Unlike ruby's built-in iterators, the end of the current iteration cycle is signaled manually,
# instead of happening automatically after the yielded block finishes executing. For example:
#
#   (0..10).each{ |num| }
#
# becomes:
#
#   EM::Iterator.new(0..10).each{ |num,iter| iter.next }
#
# This is especially useful when doing asynchronous work via reactor libraries and
# functions. For example, given a sync and async http api:
#
#   response = sync_http_get(url); ...
#   async_http_get(url){ |response| ... }
#
# a synchronous iterator such as:
#
#   responses = urls.map{ |url| sync_http_get(url) }
#   ...
#   puts 'all done!'
#
# could be written as:
#
#   EM::Iterator.new(urls).map(proc{ |url,iter|
#     async_http_get(url){ |res|
#       iter.return(res)
#     }
#   }, proc{ |responses|
#     ...
#     puts 'all done!'
#   })
#
# Now, you can take advantage of the asynchronous api to issue requests in parallel. For example,
# to fetch 10 urls at a time, simply pass in a concurrency of 10:
#
#   EM::Iterator.new(urls, 10).each do |url,iter|
#     async_http_get(url){ iter.next }
#   end
#
# source://eventmachine//lib/em/iterator.rb#43
class EventMachine::Iterator
  # Create a new parallel async iterator with specified concurrency.
  #
  #   i = EM::Iterator.new(1..100, 10)
  #
  # will create an iterator over the range that processes 10 items at a time. Iteration
  # is started via #each, #map or #inject
  #
  # The list may either be an array-like object, or a proc that returns a new object
  # to be processed each time it is called.  If a proc is used, it must return
  # EventMachine::Iterator::Stop to signal the end of the iterations.
  #
  # @raise [ArgumentError]
  # @return [Iterator] a new instance of Iterator
  #
  # source://eventmachine//lib/em/iterator.rb#56
  def initialize(list, concurrency = T.unsafe(nil)); end

  # Returns the value of attribute concurrency.
  #
  # source://eventmachine//lib/em/iterator.rb#82
  def concurrency; end

  # Change the concurrency of this iterator. Workers will automatically be spawned or destroyed
  # to accomodate the new concurrency level.
  #
  # source://eventmachine//lib/em/iterator.rb#76
  def concurrency=(val); end

  # Iterate over a set of items using the specified block or proc.
  #
  #   EM::Iterator.new(1..100).each do |num, iter|
  #     puts num
  #     iter.next
  #   end
  #
  # An optional second proc is invoked after the iteration is complete.
  #
  #   EM::Iterator.new(1..100).each(
  #     proc{ |num,iter| iter.next },
  #     proc{ puts 'all done' }
  #   )
  #
  # @raise [ArgumentError]
  #
  # source://eventmachine//lib/em/iterator.rb#98
  def each(foreach = T.unsafe(nil), after = T.unsafe(nil), &blk); end

  # Inject the results of an asynchronous iteration onto a given object.
  #
  #   EM::Iterator.new(%w[ pwd uptime uname date ], 2).inject({}, proc{ |hash,cmd,iter|
  #     EM.system(cmd){ |output,status|
  #       hash[cmd] = status.exitstatus == 0 ? output.strip : nil
  #       iter.return(hash)
  #     }
  #   }, proc{ |results|
  #     p results
  #   })
  #
  # source://eventmachine//lib/em/iterator.rb#199
  def inject(obj, foreach, after); end

  # Collect the results of an asynchronous iteration into an array.
  #
  #   EM::Iterator.new(%w[ pwd uptime uname date ], 2).map(proc{ |cmd,iter|
  #     EM.system(cmd){ |output,status|
  #       iter.return(output)
  #     }
  #   }, proc{ |results|
  #     p results
  #   })
  #
  # source://eventmachine//lib/em/iterator.rb#160
  def map(foreach, after); end

  private

  # Return the next item from @list or @list_proc.
  # Once items have run out, will return EM::Iterator::Stop.  Procs must supply this themselves
  #
  # source://eventmachine//lib/em/iterator.rb#240
  def next_item; end

  # Spawn workers to consume items from the iterator's enumerator based on the current concurrency level.
  #
  # source://eventmachine//lib/em/iterator.rb#226
  def spawn_workers; end
end

# source://eventmachine//lib/em/iterator.rb#44
EventMachine::Iterator::Stop = T.let(T.unsafe(nil), String)

# @private
EventMachine::LoopbreakSignalled = T.let(T.unsafe(nil), Integer)

class EventMachine::NoHandlerForAcceptedConnection < ::RuntimeError; end

# Alias for {EventMachine::Protocols}
#
# source://eventmachine//lib/eventmachine.rb#1601
EventMachine::P = EventMachine::Protocols

# Creates a periodic timer
#
# @example
#   n = 0
#   timer = EventMachine::PeriodicTimer.new(5) do
#   puts "the time is #{Time.now}"
#   timer.cancel if (n+=1) > 5
#   end
#
# source://eventmachine//lib/em/timers.rb#30
class EventMachine::PeriodicTimer
  # Create a new periodic timer that executes every interval seconds
  #
  # @return [PeriodicTimer] a new instance of PeriodicTimer
  #
  # source://eventmachine//lib/em/timers.rb#32
  def initialize(interval, callback = T.unsafe(nil), &block); end

  # Cancel the periodic timer
  #
  # source://eventmachine//lib/em/timers.rb#41
  def cancel; end

  # @private
  #
  # source://eventmachine//lib/em/timers.rb#54
  def fire; end

  # Fire the timer every interval seconds
  #
  # source://eventmachine//lib/em/timers.rb#46
  def interval; end

  # Fire the timer every interval seconds
  #
  # source://eventmachine//lib/em/timers.rb#46
  def interval=(_arg0); end

  # @private
  #
  # source://eventmachine//lib/em/timers.rb#49
  def schedule; end
end

# A simple async resource pool based on a resource and work queue. Resources
# are enqueued and work waits for resources to become available.
#
# Resources are expected to be controlled by an object responding to a
# deferrable/completion style API with callback and errback blocks.
#
# @example
#   require 'em-http-request'
#
#   EM.run do
#   pool  = EM::Pool.new
#   spawn = lambda { pool.add EM::HttpRequest.new('http://example.org') }
#   10.times { spawn[] }
#   done, scheduled = 0, 0
#
#   check = lambda do
#   done += 1
#   if done >= scheduled
#   EM.stop
#   end
#   end
#
#   pool.on_error { |conn| spawn[] }
#
#   100.times do |i|
#   scheduled += 1
#   pool.perform do |conn|
#   req = conn.get :path => '/', :keepalive => true
#
#   req.callback do
#   p [:success, conn.object_id, i, req.response.size]
#   check[]
#   end
#
#   req.errback { check[] }
#
#   req
#   end
#   end
#   end
#
# source://eventmachine//lib/em/pool.rb#43
class EventMachine::Pool
  # @return [Pool] a new instance of Pool
  #
  # source://eventmachine//lib/em/pool.rb#45
  def initialize; end

  # source://eventmachine//lib/em/pool.rb#52
  def add(resource); end

  # Returns a list for introspection purposes only. You should *NEVER* call
  # modification or work oriented methods on objects in this list. A good
  # example use case is periodic statistics collection against a set of
  # connection resources.
  #
  # @example
  #   pool.contents.inject(0) { |sum, connection| connection.num_bytes }
  #
  # source://eventmachine//lib/em/pool.rb#69
  def contents; end

  # A peek at the number of enqueued jobs waiting for resources
  #
  # source://eventmachine//lib/em/pool.rb#107
  def num_waiting; end

  # Define a default catch-all for when the deferrables returned by work
  # blocks enter a failed state. By default all that happens is that the
  # resource is returned to the pool. If on_error is defined, this block is
  # responsible for re-adding the resource to the pool if it is still usable.
  # In other words, it is generally assumed that on_error blocks explicitly
  # handle the rest of the lifetime of the resource.
  #
  # source://eventmachine//lib/em/pool.rb#79
  def on_error(*a, &b); end

  # Perform a given #call-able object or block. The callable object will be
  # called with a resource from the pool as soon as one is available, and is
  # expected to return a deferrable.
  #
  # The deferrable will have callback and errback added such that when the
  # deferrable enters a finished state, the object is returned to the pool.
  #
  # If on_error is defined, then objects are not automatically returned to the
  # pool.
  #
  # source://eventmachine//lib/em/pool.rb#92
  def perform(*a, &b); end

  # source://eventmachine//lib/em/pool.rb#57
  def remove(resource); end

  # Removed will show resources in a partial pruned state. Resources in the
  # removed list may not appear in the contents list if they are currently in
  # use.
  #
  # @return [Boolean]
  #
  # source://eventmachine//lib/em/pool.rb#114
  def removed?(resource); end

  # Perform a given #call-able object or block. The callable object will be
  # called with a resource from the pool as soon as one is available, and is
  # expected to return a deferrable.
  #
  # The deferrable will have callback and errback added such that when the
  # deferrable enters a finished state, the object is returned to the pool.
  #
  # If on_error is defined, then objects are not automatically returned to the
  # pool.
  #
  # source://eventmachine//lib/em/pool.rb#92
  def reschedule(*a, &b); end

  protected

  # source://eventmachine//lib/em/pool.rb#134
  def completion(deferrable, resource); end

  # source://eventmachine//lib/em/pool.rb#123
  def failure(resource); end

  # source://eventmachine//lib/em/pool.rb#139
  def process(work, resource); end

  # source://eventmachine//lib/em/pool.rb#119
  def requeue(resource); end
end

# This is subclassed from EventMachine::Connection for use with the process monitoring API. Read the
# documentation on the instance methods of this class, and for a full explanation see EventMachine.watch_process.
#
# source://eventmachine//lib/em/process_watch.rb#5
class EventMachine::ProcessWatch < ::EventMachine::Connection
  # Returns the pid that EventMachine::watch_process was originally called with.
  #
  # source://eventmachine//lib/em/process_watch.rb#22
  def pid; end

  # Should be redefined with the user's custom callback that will be fired when the process exits.
  #
  # stop_watching is called automatically after this callback
  #
  # source://eventmachine//lib/em/process_watch.rb#35
  def process_exited; end

  # Should be redefined with the user's custom callback that will be fired when the prcess is forked.
  #
  # There is currently not an easy way to get the pid of the forked child.
  #
  # source://eventmachine//lib/em/process_watch.rb#29
  def process_forked; end

  # @private
  #
  # source://eventmachine//lib/em/process_watch.rb#12
  def receive_data(data); end

  # Discontinue monitoring of the process.
  # This will be called automatically when a process dies. User code may call it as well.
  #
  # source://eventmachine//lib/em/process_watch.rb#40
  def stop_watching; end
end

# @private
#
# source://eventmachine//lib/em/process_watch.rb#9
EventMachine::ProcessWatch::Cexit = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/process_watch.rb#7
EventMachine::ProcessWatch::Cfork = T.let(T.unsafe(nil), String)

# This module contains various protocol implementations, including:
# - HttpClient and HttpClient2
# - Stomp
# - Memcache
# - SmtpClient and SmtpServer
# - SASLauth and SASLauthclient
# - LineProtocol, LineAndTextProtocol and LineText2
# - HeaderAndContentProtocol
# - Postgres3
# - ObjectProtocol
#
# The protocol implementations live in separate files in the protocols/ subdirectory,
# but are auto-loaded when they are first referenced in your application.
#
# EventMachine::Protocols is also aliased to EM::P for easier usage.
#
# source://eventmachine//lib/em/protocols.rb#18
module EventMachine::Protocols; end

# === Usage
#
#  class RequestHandler < EM::P::HeaderAndContentProtocol
#    def receive_request headers, content
#      p [:request, headers, content]
#    end
#  end
#
#  EM.run{
#    EM.start_server 'localhost', 80, RequestHandler
#  }
#
# --
# Originally, this subclassed LineAndTextProtocol, which in
# turn relies on BufferedTokenizer, which doesn't gracefully
# handle the transitions between lines and binary text.
# Changed 13Sep08 by FCianfrocca.
#
# source://eventmachine//lib/em/protocols/header_and_content.rb#46
class EventMachine::Protocols::HeaderAndContentProtocol < ::EventMachine::Connection
  include ::EventMachine::Protocols::LineText2

  # @return [HeaderAndContentProtocol] a new instance of HeaderAndContentProtocol
  #
  # source://eventmachine//lib/em/protocols/header_and_content.rb#51
  def initialize(*args); end

  # Basically a convenience method. We might create a subclass that does this
  # automatically. But it's such a performance killer.
  #
  # source://eventmachine//lib/em/protocols/header_and_content.rb#119
  def headers_2_hash(hdrs); end

  # source://eventmachine//lib/em/protocols/header_and_content.rb#92
  def receive_binary_data(text); end

  # source://eventmachine//lib/em/protocols/header_and_content.rb#56
  def receive_line(line); end

  private

  # source://eventmachine//lib/em/protocols/header_and_content.rb#97
  def dispatch_request; end

  # source://eventmachine//lib/em/protocols/header_and_content.rb#105
  def init_for_request; end

  class << self
    # source://eventmachine//lib/em/protocols/header_and_content.rb#124
    def headers_2_hash(hdrs); end
  end
end

# source://eventmachine//lib/em/protocols/header_and_content.rb#49
EventMachine::Protocols::HeaderAndContentProtocol::ContentLengthPattern = T.let(T.unsafe(nil), Regexp)

# <b>Note:</b> This class is deprecated and will be removed. Please use EM-HTTP-Request instead.
#
# --
# TODO:
# Add streaming so we can support enormous POSTs. Current max is 20meg.
# Timeout for connections that run too long or hang somewhere in the middle.
# Persistent connections (HTTP/1.1), may need a associated delegate object.
# DNS: Some way to cache DNS lookups for hostnames we connect to. Ruby's
# DNS lookups are unbelievably slow.
# HEAD requests.
# Convenience methods for requests. get, post, url, etc.
# SSL.
# Handle status codes like 304, 100, etc.
# Refactor this code so that protocol errors all get handled one way (an exception?),
# instead of sprinkling set_deferred_status :failed calls everywhere.
#
# @example
#   EventMachine.run {
#   http = EventMachine::Protocols::HttpClient.request(
#   :host => server,
#   :port => 80,
#   :request => "/index.html",
#   :query_string => "parm1=value1&parm2=value2"
#   )
#   http.callback {|response|
#   puts response[:status]
#   puts response[:headers]
#   puts response[:content]
#   }
#   }
#
# source://eventmachine//lib/em/protocols/httpclient.rb#58
class EventMachine::Protocols::HttpClient < ::EventMachine::Connection
  include ::EventMachine::Deferrable

  # @return [HttpClient] a new instance of HttpClient
  #
  # source://eventmachine//lib/em/protocols/httpclient.rb#63
  def initialize; end

  # We send the request when we get a connection.
  # AND, we set an instance variable to indicate we passed through here.
  # That allows #unbind to know whether there was a successful connection.
  # NB: This naive technique won't work when we have to support multiple
  # requests on a single connection.
  #
  # source://eventmachine//lib/em/protocols/httpclient.rb#98
  def connection_completed; end

  # source://eventmachine//lib/em/protocols/httpclient.rb#280
  def dispatch_response; end

  # source://eventmachine//lib/em/protocols/httpclient.rb#87
  def post_init; end

  # source://eventmachine//lib/em/protocols/httpclient.rb#175
  def receive_data(data); end

  # source://eventmachine//lib/em/protocols/httpclient.rb#103
  def send_request(args); end

  # source://eventmachine//lib/em/protocols/httpclient.rb#291
  def unbind; end

  private

  # We get called here when we have received an HTTP response line.
  # It's an opportunity to throw an exception or trigger other exceptional
  # handling.
  #
  # source://eventmachine//lib/em/protocols/httpclient.rb#268
  def parse_response_line; end

  class << self
    # @option args
    # @option args
    # @option args
    # @option args
    # @option args
    # @option args
    # @option args
    # @option args
    # @option args
    # @option args
    # @param args [Hash] The request arguments
    #
    # source://eventmachine//lib/em/protocols/httpclient.rb#79
    def request(args = T.unsafe(nil)); end
  end
end

# <b>Note:</b> This class is deprecated and will be removed. Please use EM-HTTP-Request instead.
#
# === Usage
#
#  EM.run{
#    conn = EM::Protocols::HttpClient2.connect 'google.com', 80
#
#    req = conn.get('/')
#    req.callback{ |response|
#      p(response.status)
#      p(response.headers)
#      p(response.content)
#    }
#  }
#
# source://eventmachine//lib/em/protocols/httpclient2.rb#43
class EventMachine::Protocols::HttpClient2 < ::EventMachine::Connection
  include ::EventMachine::Protocols::LineText2

  # @return [HttpClient2] a new instance of HttpClient2
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#46
  def initialize; end

  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#309
  def connection_completed; end

  # Get a url
  #
  #  req = conn.get(:uri => '/')
  #  req.callback{|response| puts response.content }
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#265
  def get(args); end

  # --
  # Called by a Request object when it completes.
  #
  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#366
  def pop_request; end

  # Post to a url
  #
  #  req = conn.post('/data')
  #  req.callback{|response| puts response.content }
  # --
  # XXX there's no way to supply a POST body.. wtf?
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#279
  def post(args); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#303
  def post_init; end

  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#358
  def receive_binary_data(text); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#348
  def receive_line(ln); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#334
  def request(args); end

  # --
  # Compute and remember a string to be used as the host header in HTTP requests
  # unless the user overrides it with an argument to #request.
  #
  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#293
  def set_default_host_header(host, port, ssl); end

  # --
  # All pending requests, if any, must fail.
  # We might come here without ever passing through connection_completed
  # in case we can't connect to the server. We'll also get here when the
  # connection closes (either because the server closes it, or we close it
  # due to detecting an internal error or security violation).
  # In either case, run down all pending requests, if any, and signal failure
  # on them.
  #
  # Set and remember a flag (@closed) so we can immediately fail any
  # subsequent requests.
  #
  # @private
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#327
  def unbind; end

  class << self
    # Make a connection to a remote HTTP server.
    # Can take either a pair of arguments (which will be interpreted as
    # a hostname/ip-address and a port), or a hash.
    # If the arguments are a hash, then supported values include:
    #  :host => a hostname or ip-address
    #  :port => a port number
    #  :ssl => true to enable ssl
    #
    # source://eventmachine//lib/em/protocols/httpclient2.rb#246
    def connect(*args); end
  end
end

# @private
#
# source://eventmachine//lib/em/protocols/httpclient2.rb#55
class EventMachine::Protocols::HttpClient2::Request
  include ::EventMachine::Deferrable

  # @return [Request] a new instance of Request
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#65
  def initialize(conn, args); end

  # Returns the value of attribute content.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#62
  def content; end

  # Returns the value of attribute header_lines.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#60
  def header_lines; end

  # Returns the value of attribute headers.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#61
  def headers; end

  # Returns the value of attribute internal_error.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#63
  def internal_error; end

  # --
  # Cf RFC 2616 pgh 3.6.1 for the format of HTTP chunks.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#137
  def receive_chunk_header(ln); end

  # --
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#102
  def receive_chunk_trailer(ln); end

  # --
  # We get a single chunk. Append it to the incoming content and switch back to line mode.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#157
  def receive_chunked_text(text); end

  # --
  # Allow up to ten blank lines before we get a real response line.
  # Allow no more than 100 lines in the header.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#115
  def receive_header_line(ln); end

  # --
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#90
  def receive_line(ln); end

  # --
  # At the present time, we only handle contents that have a length
  # specified by the content-length header.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#232
  def receive_sized_text(text); end

  # source://eventmachine//lib/em/protocols/httpclient2.rb#224
  def receive_text(text); end

  # source://eventmachine//lib/em/protocols/httpclient2.rb#75
  def send_request; end

  # Returns the value of attribute status.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#59
  def status; end

  # Returns the value of attribute version.
  #
  # source://eventmachine//lib/em/protocols/httpclient2.rb#58
  def version; end

  private

  # source://eventmachine//lib/em/protocols/httpclient2.rb#173
  def process_header; end
end

# source://eventmachine//lib/em/protocols/httpclient2.rb#170
EventMachine::Protocols::HttpClient2::Request::ChunkedRE = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/httpclient2.rb#169
EventMachine::Protocols::HttpClient2::Request::ClenRE = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/httpclient2.rb#171
EventMachine::Protocols::HttpClient2::Request::ColonRE = T.let(T.unsafe(nil), Regexp)

# --
# TODO, inefficient how we're handling this. Part of it is done so as to
# make sure we don't have problems in detecting chunked-encoding, content-length,
# etc.
#
# source://eventmachine//lib/em/protocols/httpclient2.rb#168
EventMachine::Protocols::HttpClient2::Request::HttpResponseRE = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/httpclient.rb#61
EventMachine::Protocols::HttpClient::MaxPostContentLength = T.let(T.unsafe(nil), Integer)

# A protocol that handles line-oriented data with interspersed binary text.
#
# This version is optimized for performance. See EventMachine::Protocols::LineText2
# for a version which is optimized for correctness with regard to binary text blocks
# that can switch back to line mode.
#
# source://eventmachine//lib/em/protocols/line_and_text.rb#34
class EventMachine::Protocols::LineAndTextProtocol < ::EventMachine::Connection
  # @return [LineAndTextProtocol] a new instance of LineAndTextProtocol
  #
  # source://eventmachine//lib/em/protocols/line_and_text.rb#37
  def initialize(*args); end

  # source://eventmachine//lib/em/protocols/line_and_text.rb#42
  def receive_data(data); end

  # Set up to read the supplied number of binary bytes.
  # This recycles all the data currently waiting in the line buffer, if any.
  # If the limit is nil, then ALL subsequent data will be treated as binary
  # data and passed to the upstream protocol handler as we receive it.
  # If a limit is given, we'll hold the incoming binary data and not
  # pass it upstream until we've seen it all, or until there is an unbind
  # (in which case we'll pass up a partial).
  # Specifying nil for the limit (the default) means there is no limit.
  # Specifiyng zero for the limit will cause an immediate transition back to line mode.
  #
  # source://eventmachine//lib/em/protocols/line_and_text.rb#95
  def set_binary_mode(size = T.unsafe(nil)); end

  # source://eventmachine//lib/em/protocols/line_and_text.rb#77
  def unbind; end

  private

  # --
  # For internal use, establish protocol baseline for handling lines.
  #
  # source://eventmachine//lib/em/protocols/line_and_text.rb#118
  def lbp_init_line_state; end
end

# source://eventmachine//lib/em/protocols/line_and_text.rb#35
EventMachine::Protocols::LineAndTextProtocol::MaxBinaryLength = T.let(T.unsafe(nil), Integer)

# LineProtocol will parse out newline terminated strings from a receive_data stream
#
#  module Server
#    include EM::P::LineProtocol
#
#    def receive_line(line)
#      send_data("you said: #{line}")
#    end
#  end
#
# source://eventmachine//lib/em/protocols/line_protocol.rb#13
module EventMachine::Protocols::LineProtocol
  # @private
  #
  # source://eventmachine//lib/em/protocols/line_protocol.rb#15
  def receive_data(data); end

  # Invoked with lines received over the network
  #
  # source://eventmachine//lib/em/protocols/line_protocol.rb#24
  def receive_line(line); end
end

# In the grand, time-honored tradition of re-inventing the wheel, we offer
# here YET ANOTHER protocol that handles line-oriented data with interspersed
# binary text. This one trades away some of the performance optimizations of
# EventMachine::Protocols::LineAndTextProtocol in order to get better correctness
# with regard to binary text blocks that can switch back to line mode. It also
# permits the line-delimiter to change in midstream.
# This was originally written to support Stomp.
#
# source://eventmachine//lib/em/protocols/linetext2.rb#35
module EventMachine::Protocols::LineText2
  # Stub. Should be subclassed by user code.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#166
  def receive_binary_data(data); end

  # --
  # Will loop internally until there's no data left to read.
  # That way the user-defined handlers we call can modify the
  # handling characteristics on a per-token basis.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#47
  def receive_data(data); end

  # Stub. Should be subclassed by user code.
  # This is called when transitioning internally from text mode
  # back to line mode. Useful when client code doesn't want
  # to keep track of how much data it's received.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#174
  def receive_end_of_binary_data; end

  # Stub. Should be subclassed by user code.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#161
  def receive_line(ln); end

  # Alias for #set_text_mode, added for back-compatibility with LineAndTextProtocol.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#146
  def set_binary_mode(size = T.unsafe(nil)); end

  # The line delimiter may be a regular expression or a string.  Anything
  # passed to set_delimiter other than a regular expression will be
  # converted to a string.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#114
  def set_delimiter(delim); end

  # Called internally but also exposed to user code, for the case in which
  # processing of binary data creates a need to transition back to line mode.
  # We support an optional parameter to "throw back" some data, which might
  # be an umprocessed chunk of the transmitted binary data, or something else
  # entirely.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#128
  def set_line_mode(data = T.unsafe(nil)); end

  # source://eventmachine//lib/em/protocols/linetext2.rb#134
  def set_text_mode(size = T.unsafe(nil)); end

  # In case of a dropped connection, we'll send a partial buffer to user code
  # when in sized text mode. User overrides of #receive_binary_data need to
  # be aware that they may get a short buffer.
  #
  # source://eventmachine//lib/em/protocols/linetext2.rb#153
  def unbind; end
end

# TODO! We're not enforcing the limits on header lengths and text-lengths.
# When we get around to that, call #receive_error if the user defined it, otherwise
# throw exceptions.
#
# source://eventmachine//lib/em/protocols/linetext2.rb#40
EventMachine::Protocols::LineText2::MaxBinaryLength = T.let(T.unsafe(nil), Integer)

# Implements the Memcache protocol (http://code.sixapart.com/svn/memcached/trunk/server/doc/protocol.txt).
# Requires memcached >= 1.2.4 w/ noreply support
#
# == Usage example
#
#   EM.run{
#     cache = EM::P::Memcache.connect 'localhost', 11211
#
#     cache.set :a, 'hello'
#     cache.set :b, 'hi'
#     cache.set :c, 'how are you?'
#     cache.set :d, ''
#
#     cache.get(:a){ |v| p v }
#     cache.get_hash(:a, :b, :c, :d){ |v| p v }
#     cache.get(:a,:b,:c,:d){ |a,b,c,d| p [a,b,c,d] }
#
#     cache.get(:a,:z,:b,:y,:d){ |a,z,b,y,d| p [a,z,b,y,d] }
#
#     cache.get(:missing){ |m| p [:missing=, m] }
#     cache.set(:missing, 'abc'){ p :stored }
#     cache.get(:missing){ |m| p [:missing=, m] }
#     cache.del(:missing){ p :deleted }
#     cache.get(:missing){ |m| p [:missing=, m] }
#   }
#
# source://eventmachine//lib/em/protocols/memcache.rb#29
module EventMachine::Protocols::Memcache
  include ::EventMachine::Deferrable

  # @private
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#134
  def initialize(host, port = T.unsafe(nil)); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#139
  def connection_completed; end

  # Delete the value associated with a key
  #
  #  cache.del :a
  #  cache.del(:b){ puts "deleted the value!" }
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#105
  def del(key, expires = T.unsafe(nil), &cb); end

  # Delete the value associated with a key
  #
  #  cache.del :a
  #  cache.del(:b){ puts "deleted the value!" }
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#105
  def delete(key, expires = T.unsafe(nil), &cb); end

  # Get the value associated with one or multiple keys
  #
  #  cache.get(:a){ |v| p v }
  #  cache.get(:a,:b,:c,:d){ |a,b,c,d| p [a,b,c,d] }
  #
  # @raise [ArgumentError]
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#61
  def get(*keys); end

  # Gets multiple values as a hash
  #
  #  cache.get_hash(:a, :b, :c, :d){ |h| puts h[:a] }
  #
  # @raise [ArgumentError]
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#92
  def get_hash(*keys); end

  # --
  # def receive_line line
  #
  # @private
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#175
  def process_cmd(line); end

  # --
  # 19Feb09 Switched to a custom parser, LineText2 is recursive and can cause
  #         stack overflows when there is too much data.
  # include EM::P::LineText2
  #
  # @private
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#158
  def receive_data(data); end

  # Set the value for a given key
  #
  #  cache.set :a, 'hello'
  #  cache.set(:missing, 'abc'){ puts "stored the value!" }
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#78
  def set(key, val, exptime = T.unsafe(nil), &cb); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/memcache.rb#221
  def unbind; end

  private

  # source://eventmachine//lib/em/protocols/memcache.rb#118
  def send_cmd(cmd, key, flags = T.unsafe(nil), exptime = T.unsafe(nil), bytes = T.unsafe(nil), noreply = T.unsafe(nil)); end

  class << self
    # Connect to a memcached server (must support NOREPLY, memcached >= 1.2.4)
    #
    # source://eventmachine//lib/em/protocols/memcache.rb#114
    def connect(host = T.unsafe(nil), port = T.unsafe(nil)); end
  end
end

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#41
EventMachine::Protocols::Memcache::Cdeleted = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#50
EventMachine::Protocols::Memcache::Cdelimiter = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#48
EventMachine::Protocols::Memcache::Cempty = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#39
EventMachine::Protocols::Memcache::Cend = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#45
EventMachine::Protocols::Memcache::Cerror = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#37
EventMachine::Protocols::Memcache::Cstored = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#43
EventMachine::Protocols::Memcache::Cunknown = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/protocols/memcache.rb#127
class EventMachine::Protocols::Memcache::ParserError < ::StandardError; end

# ObjectProtocol allows for easy communication using marshaled ruby objects
#
#  module RubyServer
#    include EM::P::ObjectProtocol
#
#    def receive_object obj
#      send_object({'you said' => obj})
#    end
#  end
#
# source://eventmachine//lib/em/protocols/object_protocol.rb#13
module EventMachine::Protocols::ObjectProtocol
  # @private
  #
  # source://eventmachine//lib/em/protocols/object_protocol.rb#21
  def receive_data(data); end

  # Invoked with ruby objects received over the network
  #
  # source://eventmachine//lib/em/protocols/object_protocol.rb#35
  def receive_object(obj); end

  # Sends a ruby object over the network
  #
  # source://eventmachine//lib/em/protocols/object_protocol.rb#40
  def send_object(obj); end

  # By default returns Marshal, override to return JSON or YAML, or any
  # other serializer/deserializer responding to #dump and #load.
  #
  # source://eventmachine//lib/em/protocols/object_protocol.rb#16
  def serializer; end
end

# Implements SASL authd.
# This is a very, very simple protocol that mimics the one used
# by saslauthd and pwcheck, two outboard daemons included in the
# standard SASL library distro.
# The only thing this is really suitable for is SASL PLAIN
# (user+password) authentication, but the SASL libs that are
# linked into standard servers (like imapd and sendmail) implement
# the other ones.
#
# SASL-auth is intended for reasonably fast operation inside a
# single machine, so it has no transport-security (although there
# have been multi-machine extensions incorporating transport-layer
# encryption).
#
# The standard saslauthd module generally runs privileged and does
# its work by referring to the system-account files.
#
# This feature was added to EventMachine to enable the development
# of custom authentication/authorization engines for standard servers.
#
# To use SASLauth, include it in a class that subclasses EM::Connection,
# and reimplement the validate method.
#
# The typical way to incorporate this module into an authentication
# daemon would be to set it as the handler for a UNIX-domain socket.
# The code might look like this:
#
#  EM.start_unix_domain_server( "/var/run/saslauthd/mux", MyHandler )
#  File.chmod( 0777, "/var/run/saslauthd/mux")
#
# The chmod is probably needed to ensure that unprivileged clients can
# access the UNIX-domain socket.
#
# It's also a very good idea to drop superuser privileges (if any), after
# the UNIX-domain socket has been opened.
# --
# Implementation details: assume the client can send us pipelined requests,
# and that the client will close the connection.
#
# The client sends us four values, each encoded as a two-byte length field in
# network order followed by the specified number of octets.
# The fields specify the username, password, service name (such as imap),
# and the "realm" name. We send back the barest minimum reply, a single
# field also encoded as a two-octet length in network order, followed by
# either "NO" or "OK" - simplicity itself.
#
# We enforce a maximum field size just as a sanity check.
# We do NOT automatically time out the connection.
#
# The code we use to parse out the values is ugly and probably slow.
# Improvements welcome.
#
# source://eventmachine//lib/em/protocols/saslauth.rb#82
module EventMachine::Protocols::SASLauth
  # source://eventmachine//lib/em/protocols/saslauth.rb#85
  def post_init; end

  # source://eventmachine//lib/em/protocols/saslauth.rb#91
  def receive_data(data); end

  # source://eventmachine//lib/em/protocols/saslauth.rb#109
  def validate(username, psw, sysname, realm); end
end

# source://eventmachine//lib/em/protocols/saslauth.rb#84
EventMachine::Protocols::SASLauth::MaxFieldSize = T.let(T.unsafe(nil), Integer)

# Implements the SASL authd client protocol.
# This is a very, very simple protocol that mimics the one used
# by saslauthd and pwcheck, two outboard daemons included in the
# standard SASL library distro.
# The only thing this is really suitable for is SASL PLAIN
# (user+password) authentication, but the SASL libs that are
# linked into standard servers (like imapd and sendmail) implement
# the other ones.
#
# You can use this module directly as a handler for EM Connections,
# or include it in a module or handler class of your own.
#
# First connect to a SASL server (it's probably a TCP server, or more
# likely a Unix-domain socket). Then call the #validate? method,
# passing at least a username and a password. #validate? returns
# a Deferrable which will either succeed or fail, depending
# on the status of the authentication operation.
#
# source://eventmachine//lib/em/protocols/saslauth.rb#136
module EventMachine::Protocols::SASLauthclient
  # source://eventmachine//lib/em/protocols/saslauth.rb#151
  def post_init; end

  # source://eventmachine//lib/em/protocols/saslauth.rb#156
  def receive_data(data); end

  # @return [Boolean]
  #
  # source://eventmachine//lib/em/protocols/saslauth.rb#139
  def validate?(username, psw, sysname = T.unsafe(nil), realm = T.unsafe(nil)); end
end

# source://eventmachine//lib/em/protocols/saslauth.rb#137
EventMachine::Protocols::SASLauthclient::MaxFieldSize = T.let(T.unsafe(nil), Integer)

# Simple SMTP client
#
# Sending generated emails (using Mail)
#
#   mail = Mail.new do
#     from    'alice@example.com'
#     to      'bob@example.com'
#     subject 'This is a test email'
#     body    'Hello, world!'
#   end
#
#   email = EM::P::SmtpClient.send(
#     :domain=>'example.com',
#     :from=>mail.from.first,
#     :to=>mail.to,
#     :message=>mail.to_s
#   )
#
# @example
#   email = EM::Protocols::SmtpClient.send(
#   :domain=>"example.com",
#   :host=>'localhost',
#   :port=>25, # optional, defaults 25
#   :starttls=>true, # use ssl
#   :from=>"sender@example.com",
#   :to=> ["to_1@example.com", "to_2@example.com"],
#   :header=> {"Subject" => "This is a subject line"},
#   :body=> "This is the body of the email"
#   )
#   email.callback{
#   puts 'Email sent!'
#   }
#   email.errback{ |e|
#   puts 'Email failed!'
#   }
#
# source://eventmachine//lib/em/protocols/smtpclient.rb#67
class EventMachine::Protocols::SmtpClient < ::EventMachine::Connection
  include ::EventMachine::Deferrable
  include ::EventMachine::Protocols::LineText2

  # @return [SmtpClient] a new instance of SmtpClient
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#71
  def initialize; end

  # Sets the attribute args
  #
  # @param value the value to set the attribute args to.
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#169
  def args=(_arg0); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#178
  def connection_completed; end

  # @private
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#172
  def post_init; end

  # @private
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#200
  def receive_line(ln); end

  # We can get here in a variety of ways, all of them being failures unless
  # the @succeeded flag is set. If a protocol success was recorded, then don't
  # set a deferred success because the caller will already have done it
  # (no need to wait until the connection closes to invoke the callbacks).
  #
  # @private
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#189
  def unbind; end

  private

  # source://eventmachine//lib/em/protocols/smtpclient.rb#335
  def escape_leading_dots(s); end

  # Perform an authentication. If the caller didn't request one, then fall through
  # to the mail-from state.
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#282
  def invoke_auth; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#339
  def invoke_data; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#271
  def invoke_ehlo_over_tls; end

  # We encountered an error from the server and will close the connection.
  # Use the error and message the server returned.
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#217
  def invoke_error; end

  # We encountered an error on our side of the protocol and will close the connection.
  # Use an extra-protocol error code (900) and use the message from the caller.
  #
  # source://eventmachine//lib/em/protocols/smtpclient.rb#230
  def invoke_internal_error(msg = T.unsafe(nil)); end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#305
  def invoke_mail_from; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#314
  def invoke_rcpt_to; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#255
  def invoke_starttls; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#300
  def receive_auth_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#343
  def receive_data_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#275
  def receive_ehlo_over_tls_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#249
  def receive_ehlo_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#309
  def receive_mail_from_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#381
  def receive_message_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#330
  def receive_rcpt_to_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#244
  def receive_signon; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#265
  def receive_starttls_response; end

  # source://eventmachine//lib/em/protocols/smtpclient.rb#240
  def send_ehlo; end

  class << self
    # :host => required String
    #   a string containing the IP address or host name of the SMTP server to connect to.
    # :port => optional
    #   defaults to 25.
    # :domain => required String
    #   This is passed as the argument to the EHLO command.
    # :starttls => optional Boolean
    #   If it evaluates true, then the client will initiate STARTTLS with
    #   the server, and abort the connection if the negotiation doesn't succeed.
    #   TODO, need to be able to pass certificate parameters with this option.
    # :auth => optional Hash of auth parameters
    #   If not given, then no auth will be attempted.
    #   (In that case, the connection will be aborted if the server requires auth.)
    #   Specify the hash value :type to determine the auth type, along with additional parameters
    #   depending on the type.
    #   Currently only :type => :plain is supported. Pass additional parameters :username (String),
    #   and :password (either a String or a Proc that will be called at auth-time).
    #
    #   @example
    #     :auth => {:type=>:plain, :username=>"mickey@disney.com", :password=>"mouse"}
    #
    # :from => required String
    #   Specifies the sender of the message. Will be passed as the argument
    #   to the MAIL FROM. Do NOT enclose the argument in angle-bracket (<>) characters.
    #   The connection will abort if the server rejects the value.
    # :to => required String or Array of Strings
    #   The recipient(s) of the message. Do NOT enclose
    #   any of the values in angle-brackets (<>) characters. It's NOT a fatal error if one or more
    #   recipients are rejected by the server. (Of course, if ALL of them are, the server will most
    #   likely trigger an error when we try to send data.) An array of codes containing the status
    #   of each requested recipient is available after the call completes. TODO, we should define
    #   an overridable stub that will be called on rejection of a recipient or a sender, giving
    #   user code the chance to try again or abort the connection.
    #
    # One of either :message, :content, or :header and :body is required:
    #
    # :message => String
    #   A valid RFC2822 Internet Message.
    # :content => String
    #   Raw data which MUST be in correct SMTP body format, with escaped leading dots and a trailing
    #   dot line.
    # :header => String or Hash of values to be transmitted in the header of the message.
    #   The hash keys are the names of the headers (do NOT append a trailing colon), and the values
    #   are strings containing the header values. TODO, support Arrays of header values, which would
    #   cause us to send that specific header line more than once.
    #
    #   @example
    #     :header => {"Subject" => "Bogus", "CC" => "myboss@example.com"}
    #
    # :body => Optional String or Array of Strings, defaults blank.
    #   This will be passed as the body of the email message.
    #   TODO, this needs to be significantly beefed up. As currently written, this requires the caller
    #   to properly format the input into CRLF-delimited lines of 7-bit characters in the standard
    #   SMTP transmission format. We need to be able to automatically convert binary data, and add
    #   correct line-breaks to text data.
    #
    # :verbose => Optional.
    #   If true, will cause a lot of information (including the server-side of the
    #   conversation) to be dumped to $>.
    #
    # source://eventmachine//lib/em/protocols/smtpclient.rb#138
    def send(args = T.unsafe(nil)); end
  end
end

# This is a protocol handler for the server side of SMTP.
# It's NOT a complete SMTP server obeying all the semantics of servers conforming to
# RFC2821. Rather, it uses overridable method stubs to communicate protocol states
# and data to user code. User code is responsible for doing the right things with the
# data in order to get complete and correct SMTP server behavior.
#
# Simple SMTP server example:
#
#  class EmailServer < EM::P::SmtpServer
#    def receive_plain_auth(user, pass)
#      true
#    end
#
#    def get_server_domain
#      "mock.smtp.server.local"
#    end
#
#    def get_server_greeting
#      "mock smtp server greets you with impunity"
#    end
#
#    def receive_sender(sender)
#      current.sender = sender
#      true
#    end
#
#    def receive_recipient(recipient)
#      current.recipient = recipient
#      true
#    end
#
#    def receive_message
#      current.received = true
#      current.completed_at = Time.now
#
#      p [:received_email, current]
#      @current = OpenStruct.new
#      true
#    end
#
#    def receive_ehlo_domain(domain)
#      @ehlo_domain = domain
#      true
#    end
#
#    def receive_data_command
#      current.data = ""
#      true
#    end
#
#    def receive_data_chunk(data)
#      current.data << data.join("\n")
#      true
#    end
#
#    def receive_transaction
#      if @ehlo_domain
#        current.ehlo_domain = @ehlo_domain
#        @ehlo_domain = nil
#      end
#      true
#    end
#
#    def current
#      @current ||= OpenStruct.new
#    end
#
#    def self.start(host = 'localhost', port = 1025)
#      require 'ostruct'
#      @server = EM.start_server host, port, self
#    end
#
#    def self.stop
#      if @server
#        EM.stop_server @server
#        @server = nil
#      end
#    end
#
#    def self.running?
#      !!@server
#    end
#  end
#
#  EM.run{ EmailServer.start }
#
# --
# Useful paragraphs in RFC-2821:
# 4.3.2: Concise list of command-reply sequences, in essence a text representation
# of the command state-machine.
#
# STARTTLS is defined in RFC2487.
# Observe that there are important rules governing whether a publicly-referenced server
# (meaning one whose Internet address appears in public MX records) may require the
# non-optional use of TLS.
# Non-optional TLS does not apply to EHLO, NOOP, QUIT or STARTTLS.
#
# source://eventmachine//lib/em/protocols/smtpserver.rb#125
class EventMachine::Protocols::SmtpServer < ::EventMachine::Connection
  include ::EventMachine::Protocols::LineText2

  # @return [SmtpServer] a new instance of SmtpServer
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#162
  def initialize(*args); end

  # Sent when the remote peer has ended the connection.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#629
  def connection_ended; end

  # The domain name returned in the first line of the response to a
  # successful EHLO or HELO command.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#589
  def get_server_domain; end

  # The greeting returned in the initial connection message to the client.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#584
  def get_server_greeting; end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#278
  def init_protocol_state; end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#168
  def parms=(parms = T.unsafe(nil)); end

  # In SMTP, the server talks first. But by a (perhaps flawed) axiom in EM,
  # #post_init will execute BEFORE the block passed to #start_server, for any
  # given accepted connection. Since in this class we'll probably be getting
  # a lot of initialization parameters, we want the guts of post_init to
  # run AFTER the application has initialized the connection object. So we
  # use a spawn to schedule the post_init to run later.
  # It's a little weird, I admit. A reasonable alternative would be to set
  # parameters as a class variable and to do that before accepting any connections.
  #
  # OBSOLETE, now we have @@parms. But the spawn is nice to keep as an illustration.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#183
  def post_init; end

  # --
  # So far, only AUTH PLAIN is supported but we should do at least LOGIN as well.
  # TODO, support clients that send AUTH PLAIN with no parameter, expecting a 3xx
  # response and a continuation of the auth conversation.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#348
  def process_auth(str); end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#366
  def process_auth_line(line); end

  # --
  # Unusually, we can deal with a Deferrable returned from the user application.
  # This was added to deal with a special case in a particular application, but
  # it would be a nice idea to add it to the other user-code callbacks.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#394
  def process_data; end

  # Send the incoming data to the application one chunk at a time, rather than
  # one line at a time. That lets the application be a little more flexible about
  # storing to disk, etc.
  # Since we clear the chunk array every time we submit it, the caller needs to be
  # aware to do things like dup it if he wants to keep it around across calls.
  #
  # Resets the transaction upon disposition of the incoming message.
  # RFC5321 says this about the MAIL FROM command:
  #  "This command tells the SMTP-receiver that a new mail transaction is
  #   starting and to reset all its state tables and buffers, including any
  #   recipients or mail data."
  #
  # Equivalent behaviour is implemented by resetting after a completed transaction.
  #
  # User-written code can return a Deferrable as a response from receive_message.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#542
  def process_data_line(ln); end

  # --
  # EHLO/HELO is always legal, per the standard. On success
  # it always clears buffers and initiates a mail "transaction."
  # Which means that a MAIL FROM must follow.
  #
  # Per the standard, an EHLO/HELO or a RSET "initiates" an email
  # transaction. Thereafter, MAIL FROM must be received before
  # RCPT TO, before DATA. Not sure what this specific ordering
  # achieves semantically, but it does make it easier to
  # implement. We also support user-specified requirements for
  # STARTTLS and AUTH. We make it impossible to proceed to MAIL FROM
  # without fulfilling tls and/or auth, if the user specified either
  # or both as required. We need to check the extension standard
  # for auth to see if a credential is discarded after a RSET along
  # with all the rest of the state. We'll behave as if it is.
  # Now clearly, we can't discard tls after its been negotiated
  # without dropping the connection, so that flag doesn't get cleared.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#301
  def process_ehlo(domain); end

  # TODO - implement this properly, the implementation is a stub!
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#248
  def process_expn; end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#320
  def process_helo(domain); end

  # TODO - implement this properly, the implementation is a stub!
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#232
  def process_help; end

  # --
  # Requiring TLS is touchy, cf RFC2784.
  # Requiring AUTH seems to be much more reasonable.
  # We don't currently support any notion of deriving an authentication from the TLS
  # negotiation, although that would certainly be reasonable.
  # We DON'T allow MAIL FROM to be given twice.
  # We DON'T enforce all the various rules for validating the sender or
  # the reverse-path (like whether it should be null), and notifying the reverse
  # path in case of delivery problems. All of that is left to the calling application.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#464
  def process_mail_from(sender); end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#335
  def process_noop; end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#330
  def process_quit; end

  # --
  # Since we require :mail_from to have been seen before we process RCPT TO,
  # we don't need to repeat the tests for TLS and AUTH.
  # Note that we don't remember or do anything else with the recipients.
  # All of that is on the user code.
  # TODO: we should enforce user-definable limits on the total number of
  # recipients per transaction.
  # We might want to make sure that a given recipient is only seen once, but
  # for now we'll let that be the user's problem.
  #
  # User-written code can return a deferrable from receive_recipient.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#493
  def process_rcpt_to(rcpt); end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#418
  def process_rset; end

  # --
  # STARTTLS may not be issued before EHLO, or unless the user has chosen
  # to support it.
  #
  # If :starttls_options is present and :starttls is set in the parms
  # pass the options in :starttls_options to start_tls. Do this if you want to use
  # your own certificate
  # e.g. {:cert_chain_file => "/etc/ssl/cert.pem", :private_key_file => "/etc/ssl/private/cert.key"}
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#437
  def process_starttls; end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#339
  def process_unknown; end

  # RFC2821, 3.5.3 Meaning of VRFY or EXPN Success Response:
  #   A server MUST NOT return a 250 code in response to a VRFY or EXPN
  #   command unless it has actually verified the address.  In particular,
  #   a server MUST NOT return 250 if all it has done is to verify that the
  #   syntax given is valid.  In that case, 502 (Command not implemented)
  #   or 500 (Syntax error, command unrecognized) SHOULD be returned.
  #
  # TODO - implement this properly, the implementation is a stub!
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#244
  def process_vrfy; end

  # Sent when data from the remote peer is available. The size can be controlled
  # by setting the :chunksize parameter. This call can be made multiple times.
  # The goal is to strike a balance between sending the data to the application one
  # line at a time, and holding all of a very large message in memory.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#646
  def receive_data_chunk(data); end

  # Called when the remote peer sends the DATA command.
  # Returning false will cause us to send a 550 error to the peer.
  # This can be useful for dealing with problems that arise from processing
  # the whole set of sender and recipients.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#637
  def receive_data_command; end

  # A false response from this user-overridable method will cause a
  # 550 error to be returned to the remote client.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#596
  def receive_ehlo_domain(domain); end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#193
  def receive_line(ln); end

  # Sent after a message has been completely received. User code
  # must return true or false to indicate whether the message has
  # been accepted for delivery.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#655
  def receive_message; end

  # Return true or false to indicate that the authentication is acceptable.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#601
  def receive_plain_auth(user, password); end

  # Receives the argument of a RCPT TO command. Can be given multiple
  # times per transaction. Return false to reject the recipient.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#616
  def receive_recipient(rcpt); end

  # Sent when the remote peer issues the RSET command.
  # Since RSET is not allowed to fail (according to the protocol),
  # we ignore any return value from user overrides of this method.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#624
  def receive_reset; end

  # Receives the argument of the MAIL FROM command. Return false to
  # indicate to the remote client that the sender is not accepted.
  # This can only be successfully called once per transaction.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#609
  def receive_sender(sender); end

  # This is called when the protocol state is reset. It happens
  # when the remote client calls EHLO/HELO or RSET.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#662
  def receive_transaction; end

  # --
  # This is called at several points to restore the protocol state
  # to a pre-transaction state. In essence, we "forget" having seen
  # any valid command except EHLO and STARTTLS.
  # We also have to callback user code, in case they're keeping track
  # of senders, recipients, and whatnot.
  #
  # We try to follow the convention of avoiding the verb "receive" for
  # internal method names except receive_line (which we inherit), and
  # using only receive_xxx for user-overridable stubs.
  #
  # init_protocol_state is called when we initialize the connection as
  # well as during reset_protocol_state. It does NOT call the user
  # override method. This enables us to promise the users that they
  # won't see the overridable fire except after EHLO and RSET, and
  # after a message has been received. Although the latter may be wrong.
  # The standard may allow multiple DATA segments with the same set of
  # senders and recipients.
  #
  # source://eventmachine//lib/em/protocols/smtpserver.rb#271
  def reset_protocol_state; end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#189
  def send_server_greeting; end

  # source://eventmachine//lib/em/protocols/smtpserver.rb#424
  def unbind; end

  class << self
    # source://eventmachine//lib/em/protocols/smtpserver.rb#156
    def parms=(parms = T.unsafe(nil)); end
  end
end

# source://eventmachine//lib/em/protocols/smtpserver.rb#140
EventMachine::Protocols::SmtpServer::AuthRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#133
EventMachine::Protocols::SmtpServer::DataRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#129
EventMachine::Protocols::SmtpServer::EhloRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#137
EventMachine::Protocols::SmtpServer::ExpnRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#128
EventMachine::Protocols::SmtpServer::HeloRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#138
EventMachine::Protocols::SmtpServer::HelpRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#131
EventMachine::Protocols::SmtpServer::MailFromRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#134
EventMachine::Protocols::SmtpServer::NoopRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#130
EventMachine::Protocols::SmtpServer::QuitRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#132
EventMachine::Protocols::SmtpServer::RcptToRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#135
EventMachine::Protocols::SmtpServer::RsetRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#139
EventMachine::Protocols::SmtpServer::StarttlsRegex = T.let(T.unsafe(nil), Regexp)

# source://eventmachine//lib/em/protocols/smtpserver.rb#136
EventMachine::Protocols::SmtpServer::VrfyRegex = T.let(T.unsafe(nil), Regexp)

# Basic SOCKS v4 client implementation
#
# Use as you would any regular connection:
#
# class MyConn < EM::P::Socks4
#   def post_init
#     send_data("sup")
#   end
#
#   def receive_data(data)
#     send_data("you said: #{data}")
#   end
# end
#
# EM.connect socks_host, socks_port, MyConn, host, port
#
# source://eventmachine//lib/em/protocols/socks4.rb#19
class EventMachine::Protocols::Socks4 < ::EventMachine::Connection
  # @return [Socks4] a new instance of Socks4
  #
  # source://eventmachine//lib/em/protocols/socks4.rb#20
  def initialize(host, port); end

  # source://eventmachine//lib/em/protocols/socks4.rb#35
  def restore_methods; end

  # source://eventmachine//lib/em/protocols/socks4.rb#28
  def setup_methods; end

  # source://eventmachine//lib/em/protocols/socks4.rb#42
  def socks_post_init; end

  # source://eventmachine//lib/em/protocols/socks4.rb#47
  def socks_receive_data(data); end
end

# Implements Stomp (http://docs.codehaus.org/display/STOMP/Protocol).
#
# == Usage example
#
#  module StompClient
#    include EM::Protocols::Stomp
#
#    def connection_completed
#      connect :login => 'guest', :passcode => 'guest'
#    end
#
#    def receive_msg msg
#      if msg.command == "CONNECTED"
#        subscribe '/some/topic'
#      else
#        p ['got a message', msg]
#        puts msg.body
#      end
#    end
#  end
#
#  EM.run{
#    EM.connect 'localhost', 61613, StompClient
#  }
#
# source://eventmachine//lib/em/protocols/stomp.rb#55
module EventMachine::Protocols::Stomp
  include ::EventMachine::Protocols::LineText2

  # ACK command, for acknowledging receipt of messages
  #
  #  module StompClient
  #    include EM::P::Stomp
  #
  #    def connection_completed
  #      connect :login => 'guest', :passcode => 'guest'
  #      # subscribe with ack mode
  #      subscribe '/some/topic', true
  #    end
  #
  #    def receive_msg msg
  #      if msg.command == "MESSAGE"
  #        ack msg.headers['message-id']
  #        puts msg.body
  #      end
  #    end
  #  end
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#198
  def ack(msgid); end

  # CONNECT command, for authentication
  #
  #  connect :login => 'guest', :passcode => 'guest'
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#159
  def connect(parms = T.unsafe(nil)); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#143
  def init_message_reader; end

  # @private
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#136
  def receive_binary_data(data); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#121
  def receive_line(line); end

  # Invoked with an incoming Stomp::Message received from the STOMP server
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#151
  def receive_msg(msg); end

  # SEND command, for publishing messages to a topic
  #
  #  send '/topic/name', 'some message here'
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#167
  def send(destination, body, parms = T.unsafe(nil)); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#106
  def send_frame(verb, headers = T.unsafe(nil), body = T.unsafe(nil)); end

  # SUBSCRIBE command, for subscribing to topics
  #
  #  subscribe '/topic/name', false
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#175
  def subscribe(dest, ack = T.unsafe(nil)); end
end

# source://eventmachine//lib/em/protocols/stomp.rb#58
class EventMachine::Protocols::Stomp::Message
  # @private
  # @return [Message] a new instance of Message
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#68
  def initialize; end

  # Body of the message
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#65
  def body; end

  # Body of the message
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#65
  def body=(_arg0); end

  # The command associated with the message, usually 'CONNECTED' or 'MESSAGE'
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#60
  def command; end

  # The command associated with the message, usually 'CONNECTED' or 'MESSAGE'
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#60
  def command=(_arg0); end

  # @private
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#74
  def consume_line(line); end

  # Hash containing headers such as destination and message-id
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#62
  def header; end

  # Hash containing headers such as destination and message-id
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#62
  def header=(_arg0); end

  # Hash containing headers such as destination and message-id
  #
  # source://eventmachine//lib/em/protocols/stomp.rb#62
  def headers; end
end

# @private
#
# source://eventmachine//lib/em/protocols/tcptest.rb#31
class EventMachine::Protocols::TcpConnectTester < ::EventMachine::Connection
  include ::EventMachine::Deferrable

  # source://eventmachine//lib/em/protocols/tcptest.rb#42
  def connection_completed; end

  # source://eventmachine//lib/em/protocols/tcptest.rb#38
  def post_init; end

  # source://eventmachine//lib/em/protocols/tcptest.rb#48
  def unbind; end

  class << self
    # source://eventmachine//lib/em/protocols/tcptest.rb#34
    def test(host, port); end
  end
end

# A cross thread, reactor scheduled, linear queue.
#
# This class provides a simple queue abstraction on top of the reactor
# scheduler. It services two primary purposes:
#
# * API sugar for stateful protocols
# * Pushing processing onto the reactor thread
#
# @example
#
#   q = EM::Queue.new
#   q.push('one', 'two', 'three')
#   3.times do
#   q.pop { |msg| puts(msg) }
#   end
#
# source://eventmachine//lib/em/queue.rb#18
class EventMachine::Queue
  # @return [Queue] a new instance of Queue
  #
  # source://eventmachine//lib/em/queue.rb#19
  def initialize; end

  # Push items onto the queue in the reactor thread. The items will not appear
  # in the queue immediately, but will be scheduled for addition during the
  # next reactor tick.
  #
  # source://eventmachine//lib/em/queue.rb#49
  def <<(*items); end

  # @note This is a peek, it's not thread safe, and may only tend toward accuracy.
  # @return [Boolean]
  #
  # source://eventmachine//lib/em/queue.rb#63
  def empty?; end

  # @note This is a peek at the number of jobs that are currently waiting on the Queue
  # @return [Integer] Waiting size
  #
  # source://eventmachine//lib/em/queue.rb#75
  def num_waiting; end

  # Pop items off the queue, running the block on the reactor thread. The pop
  # will not happen immediately, but at some point in the future, either in
  # the next tick, if the queue has data, or when the queue is populated.
  #
  # @return [NilClass] nil
  #
  # source://eventmachine//lib/em/queue.rb#30
  def pop(*a, &b); end

  # Push items onto the queue in the reactor thread. The items will not appear
  # in the queue immediately, but will be scheduled for addition during the
  # next reactor tick.
  #
  # source://eventmachine//lib/em/queue.rb#49
  def push(*items); end

  # @note This is a peek, it's not thread safe, and may only tend toward accuracy.
  # @return [Integer] Queue size
  #
  # source://eventmachine//lib/em/queue.rb#69
  def size; end
end

# Support for Erlang-style processes.
#
# source://eventmachine//lib/em/spawnable.rb#29
class EventMachine::SpawnedProcess
  # Send a message to the spawned process
  #
  # source://eventmachine//lib/em/spawnable.rb#31
  def notify(*x); end

  # Send a message to the spawned process
  #
  # source://eventmachine//lib/em/spawnable.rb#31
  def resume(*x); end

  # Send a message to the spawned process
  # for formulations like (EM.spawn {xxx}).run
  #
  # source://eventmachine//lib/em/spawnable.rb#31
  def run(*x); end

  # source://eventmachine//lib/em/spawnable.rb#49
  def set_receiver(blk); end
end

# @private
EventMachine::SslHandshakeCompleted = T.let(T.unsafe(nil), Integer)

# @private
EventMachine::SslVerify = T.let(T.unsafe(nil), Integer)

# @private
#
# source://eventmachine//lib/em/processes.rb#76
class EventMachine::SystemCmd < ::EventMachine::Connection
  # @return [SystemCmd] a new instance of SystemCmd
  #
  # source://eventmachine//lib/em/processes.rb#77
  def initialize(cb); end

  # source://eventmachine//lib/em/processes.rb#81
  def receive_data(data); end

  # source://eventmachine//lib/em/processes.rb#84
  def unbind; end
end

# = EventMachine::ThreadedResource
#
# A threaded resource is a "quick and dirty" wrapper around the concept of
# wiring up synchronous code into a standard EM::Pool. This is useful to keep
# interfaces coherent and provide a simple approach at "making an interface
# async-ish".
#
# General usage is to wrap libraries that do not support EventMachine, or to
# have a specific number of dedicated high-cpu worker resources.
#
# == Basic Usage example
#
# This example requires the cassandra gem. The cassandra gem contains an
# EventMachine interface, but it's sadly Fiber based and thus only works on
# 1.9. It also requires (potentially) complex stack switching logic to reach
# completion of nested operations. By contrast this approach provides a block
# in which normal synchronous code can occur, but makes no attempt to wire the
# IO into EventMachines C++ IO implementations, instead relying on the reactor
# pattern in rb_thread_select.
#
#    cassandra_dispatcher = ThreadedResource.new do
#      Cassandra.new('allthethings', '127.0.0.1:9160')
#    end
#
#    pool = EM::Pool.new
#
#    pool.add cassandra_dispatcher
#
#    # If we don't care about the result:
#    pool.perform do |dispatcher|
#      # The following block executes inside a dedicated thread, and should not
#      # access EventMachine things:
#      dispatcher.dispatch do |cassandra|
#        cassandra.insert(:Things, '10', 'stuff' => 'things')
#      end
#    end
#
#    # Example where we care about the result:
#    pool.perform do |dispatcher|
#      # The dispatch block is executed in the resources thread.
#      completion = dispatcher.dispatch do |cassandra|
#        cassandra.get(:Things, '10', 'stuff')
#      end
#
#      # This block will be yielded on the EM thread:
#      completion.callback do |result|
#        EM.do_something_with(result)
#      end
#
#      completion
#    end
#
# source://eventmachine//lib/em/threaded_resource.rb#53
class EventMachine::ThreadedResource
  # The block should return the resource that will be yielded in a dispatch.
  #
  # @return [ThreadedResource] a new instance of ThreadedResource
  #
  # source://eventmachine//lib/em/threaded_resource.rb#56
  def initialize; end

  # Called on the EM thread, generally in a perform block to return a
  # completion for the work.
  #
  # source://eventmachine//lib/em/threaded_resource.rb#68
  def dispatch; end

  # Kill the internal thread. should only be used to cleanup - generally
  # only required for tests.
  #
  # source://eventmachine//lib/em/threaded_resource.rb#83
  def shutdown; end
end

# A TickLoop is useful when one needs to distribute amounts of work
# throughout ticks in order to maintain response times. It is also useful for
# simple repeated checks and metrics.
#
# @example
#   # Here we run through an array one item per tick until it is empty,
#   # printing each element.
#   # When the array is empty, we return :stop from the callback, and the
#   # loop will terminate.
#   # When the loop terminates, the on_stop callbacks will be called.
#   EM.run do
#   array = (1..100).to_a
#
#   tickloop = EM.tick_loop do
#   if array.empty?
#   :stop
#   else
#   puts array.shift
#   end
#   end
#
#   tickloop.on_stop { EM.stop }
#   end
#
# source://eventmachine//lib/em/tick_loop.rb#30
class EventMachine::TickLoop
  # Arguments: A callback (EM::Callback) to call each tick. If the call
  # returns +:stop+ then the loop will be stopped. Any other value is
  # ignored.
  #
  # @return [TickLoop] a new instance of TickLoop
  #
  # source://eventmachine//lib/em/tick_loop.rb#35
  def initialize(*a, &b); end

  # Arguments: A callback (EM::Callback) to call once on the next stop (or
  # immediately if already stopped).
  #
  # source://eventmachine//lib/em/tick_loop.rb#43
  def on_stop(*a, &b); end

  # Start the tick loop, will raise argument error if the loop is already
  # running.
  #
  # @raise [ArgumentError]
  #
  # source://eventmachine//lib/em/tick_loop.rb#66
  def start; end

  # Stop the tick loop immediately, and call it's on_stop callbacks.
  #
  # source://eventmachine//lib/em/tick_loop.rb#52
  def stop; end

  # Query if the loop is stopped.
  #
  # @return [Boolean]
  #
  # source://eventmachine//lib/em/tick_loop.rb#60
  def stopped?; end

  private

  # source://eventmachine//lib/em/tick_loop.rb#73
  def schedule; end
end

# Creates a one-time timer
#
#  timer = EventMachine::Timer.new(5) do
#    # this will never fire because we cancel it
#  end
#  timer.cancel
#
# source://eventmachine//lib/em/timers.rb#9
class EventMachine::Timer
  # Create a new timer that fires after a given number of seconds
  #
  # @return [Timer] a new instance of Timer
  #
  # source://eventmachine//lib/em/timers.rb#11
  def initialize(interval, callback = T.unsafe(nil), &block); end

  # Cancel the timer
  #
  # source://eventmachine//lib/em/timers.rb#16
  def cancel; end
end

# TODO: These event numbers are defined in way too many places.
# DRY them up.
#
# @private
EventMachine::TimerFired = T.let(T.unsafe(nil), Integer)

# @private
class EventMachine::UnknownTimerFired < ::RuntimeError; end

# @private
class EventMachine::Unsupported < ::RuntimeError; end

# source://eventmachine//lib/em/version.rb#2
EventMachine::VERSION = T.let(T.unsafe(nil), String)

# @private
#
# source://eventmachine//lib/em/spawnable.rb#59
class EventMachine::YieldBlockFromSpawnedProcess
  # @return [YieldBlockFromSpawnedProcess] a new instance of YieldBlockFromSpawnedProcess
  #
  # source://eventmachine//lib/em/spawnable.rb#60
  def initialize(block, notify); end

  # source://eventmachine//lib/em/spawnable.rb#63
  def pull_out_yield_block; end
end

# @private
class StringIO
  include ::Enumerable
end
