# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `encryptor` gem.
# Please instead update this file by running `bin/tapioca gem encryptor`.


# A simple wrapper for the standard OpenSSL library
#
# source://encryptor//lib/encryptor/string.rb#1
module Encryptor
  extend ::Encryptor

  # Decrypts a <tt>:value</tt> with a specified <tt>:key</tt>
  #
  # Optionally accepts <tt>:iv</tt> and <tt>:algorithm</tt> options
  #
  # Example
  #
  #   decrypted_value = Encryptor.decrypt(:value => 'some encrypted string', :key => 'some secret key')
  #   # or
  #   decrypted_value = Encryptor.decrypt('some encrypted string', :key => 'some secret key')
  #
  # source://encryptor//lib/encryptor.rb#43
  def decrypt(*args, &block); end

  # The default options to use when calling the <tt>encrypt</tt> and <tt>decrypt</tt> methods
  #
  # Defaults to { :algorithm => 'aes-256-cbc' }
  #
  # Run 'openssl list-cipher-commands' in your terminal to view a list all cipher algorithms that are supported on your platform
  #
  # source://encryptor//lib/encryptor.rb#17
  def default_options; end

  # Encrypts a <tt>:value</tt> with a specified <tt>:key</tt>
  #
  # Optionally accepts <tt>:iv</tt> and <tt>:algorithm</tt> options
  #
  # Example
  #
  #   encrypted_value = Encryptor.encrypt(:value => 'some string to encrypt', :key => 'some secret key')
  #   # or
  #   encrypted_value = Encryptor.encrypt('some string to encrypt', :key => 'some secret key')
  #
  # source://encryptor//lib/encryptor.rb#30
  def encrypt(*args, &block); end

  protected

  # @raise [ArgumentError]
  # @yield [cipher, options]
  #
  # source://encryptor//lib/encryptor.rb#49
  def crypt(cipher_method, *args); end
end

# Adds <tt>encrypt</tt> and <tt>decrypt</tt> methods to strings
#
# source://encryptor//lib/encryptor/string.rb#3
module Encryptor::String
  # Returns a new string containing the decrypted version of itself
  #
  # source://encryptor//lib/encryptor/string.rb#15
  def decrypt(options = T.unsafe(nil)); end

  # Replaces the contents of a string with the decrypted version of itself
  #
  # source://encryptor//lib/encryptor/string.rb#20
  def decrypt!(options = T.unsafe(nil)); end

  # Returns a new string containing the encrypted version of itself
  #
  # source://encryptor//lib/encryptor/string.rb#5
  def encrypt(options = T.unsafe(nil)); end

  # Replaces the contents of a string with the encrypted version of itself
  #
  # source://encryptor//lib/encryptor/string.rb#10
  def encrypt!(options = T.unsafe(nil)); end
end

# Contains information about this gem's version
#
# source://encryptor//lib/encryptor/version.rb#3
module Encryptor::Version
  class << self
    # Returns a version string by joining <tt>MAJOR</tt>, <tt>MINOR</tt>, and <tt>PATCH</tt> with <tt>'.'</tt>
    #
    # Example
    #
    #   Version.to_s # '1.0.2'
    #
    # source://encryptor//lib/encryptor/version.rb#13
    def to_s; end
  end
end

# source://encryptor//lib/encryptor/version.rb#4
Encryptor::Version::MAJOR = T.let(T.unsafe(nil), Integer)

# source://encryptor//lib/encryptor/version.rb#5
Encryptor::Version::MINOR = T.let(T.unsafe(nil), Integer)

# source://encryptor//lib/encryptor/version.rb#6
Encryptor::Version::PATCH = T.let(T.unsafe(nil), Integer)

class String
  include ::Comparable
  include ::Encryptor::String
end
