# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `daemons` gem.
# Please instead update this file by running `bin/tapioca gem daemons`.


# source://daemons//lib/daemons/change_privilege.rb#3
class CurrentProcess
  class << self
    # source://daemons//lib/daemons/change_privilege.rb#4
    def change_privilege(user, group = T.unsafe(nil)); end
  end
end

# source://daemons//lib/daemons/daemonize.rb#1
module Daemonize
  private

  # Call a given block as a daemon
  #
  # source://daemons//lib/daemons/daemonize.rb#41
  def call_as_daemon(block, logfile_name = T.unsafe(nil), app_name = T.unsafe(nil)); end

  # source://daemons//lib/daemons/daemonize.rb#121
  def close_io; end

  # Transform the current process into a daemon
  #
  # source://daemons//lib/daemons/daemonize.rb#92
  def daemonize(logfile_name = T.unsafe(nil), app_name = T.unsafe(nil)); end

  # Free $stdin/$stdout/$stderr file descriptors and
  # point them somewhere sensible
  #
  # source://daemons//lib/daemons/daemonize.rb#140
  def redirect_io(logfile_name); end

  # Try to fork if at all possible retrying every 5 sec if the
  # maximum process limit for the system has been reached
  #
  # source://daemons//lib/daemons/daemonize.rb#4
  def safefork; end

  # Simulate the daemonization process (:ontop mode)
  # NOTE: $stdout and $stderr will not be redirected to the logfile,
  # because in :ontop mode, we normally want to see the output
  #
  # source://daemons//lib/daemons/daemonize.rb#24
  def simulate(logfile_name = T.unsafe(nil), app_name = T.unsafe(nil)); end

  class << self
    # Call a given block as a daemon
    #
    # source://daemons//lib/daemons/daemonize.rb#41
    def call_as_daemon(block, logfile_name = T.unsafe(nil), app_name = T.unsafe(nil)); end

    # source://daemons//lib/daemons/daemonize.rb#121
    def close_io; end

    # Transform the current process into a daemon
    #
    # source://daemons//lib/daemons/daemonize.rb#92
    def daemonize(logfile_name = T.unsafe(nil), app_name = T.unsafe(nil)); end

    # Free $stdin/$stdout/$stderr file descriptors and
    # point them somewhere sensible
    #
    # source://daemons//lib/daemons/daemonize.rb#140
    def redirect_io(logfile_name); end

    # Try to fork if at all possible retrying every 5 sec if the
    # maximum process limit for the system has been reached
    #
    # source://daemons//lib/daemons/daemonize.rb#4
    def safefork; end

    # Simulate the daemonization process (:ontop mode)
    # NOTE: $stdout and $stderr will not be redirected to the logfile,
    # because in :ontop mode, we normally want to see the output
    #
    # source://daemons//lib/daemons/daemonize.rb#24
    def simulate(logfile_name = T.unsafe(nil), app_name = T.unsafe(nil)); end
  end
end

# All functions and classes that Daemons provides reside in this module.
#
# Daemons is normally invoked by one of the following four ways:
#
# 1.  <tt>Daemons.run(script, options)</tt>:
#     This is used in wrapper-scripts that are supposed to control other ruby scripts or
#     external applications. Control is completely passed to the daemons library.
#     Such wrapper script need to be invoked with command line options like 'start' or 'stop'
#     to do anything useful.
#
# 2.  <tt>Daemons.run_proc(app_name, options) { (...) }</tt>:
#     This is used in wrapper-scripts that are supposed to control a proc.
#     Control is completely passed to the daemons library.
#     Such wrapper scripts need to be invoked with command line options like 'start' or 'stop'
#     to do anything useful.
#
# 3.  <tt>Daemons.call(options) { block }</tt>:
#     Execute the block in a new daemon. <tt>Daemons.call</tt> will return immediately
#     after spawning the daemon with the new Application object as a return value.
#
# 4.  <tt>Daemons.daemonize(options)</tt>:
#     Daemonize the currently runnig process, i.e. the calling process will become a daemon.
#
# == What does daemons internally do with my daemons?
# *or*:: why do my daemons crash when they try to open a file?
# *or*:: why can I not see any output from the daemon on the console (when using for example +puts+)?
#
# From a technical aspect of view, daemons does the following when creating a daemon:
#
# 1.  Forks a child (and exits the parent process, if needed)
# 2.  Becomes a session leader (which detaches the program from
#     the controlling terminal).
# 3.  Forks another child process and exits first child. This prevents
#     the potential of acquiring a controlling terminal.
# 4.  Changes the current working directory to "/".
# 5.  Clears the file creation mask (sets +umask+ to 0000).
# 6.  Closes file descriptors (reopens +$stdout+ and +$stderr+ to point to a logfile if
#     possible).
#
# So what does this mean for your daemons:
# - the current directory is '/'
# - you cannot receive any input from the console (for example no +gets+)
# - you cannot output anything from the daemons with +puts+/+print+ unless a logfile is used
#
# == How do PidFiles work? Where are they stored?
#
# Also, you are maybe interested in reading the documentation for the class PidFile.
# There you can find out about how Daemons works internally and how and where the so
# called <i>PidFiles</i> are stored.
#
# source://daemons//lib/daemons/version.rb#1
module Daemons
  private

  # Execute the block in a new daemon. <tt>Daemons.call</tt> will return immediately
  # after spawning the daemon with the new Application object as a return value.
  #
  # +app_name+::  The name of the application.
  #
  # +options+:: A hash that may contain one or more of the options listed below
  #
  # +block+::   The block to call in the daemon.
  #
  # === Options:
  # <tt>:multiple</tt>::  Specifies whether multiple instances of the same script are allowed to run at the
  #                       same time
  # <tt>:monitor</tt>::   Monitor the programs and restart crashed instances
  # <tt>:monitor_interval</tt>:: Interval in sesconds at which to check whether the instances are still running
  # <tt>:ontop</tt>::     When given, stay on top, i.e. do not daemonize the application
  # <tt>:backtrace</tt>:: Write a backtrace of the last exceptions to the file '[app_name].log' in the
  #                       pid-file directory if the application exits due to an uncaught exception
  # -----
  #
  # === Example:
  #   options = {
  #     :app_name   => "myproc",
  #     :backtrace  => true,
  #     :monitor    => true,
  #     :ontop      => true
  #   }
  #
  #   Daemons.call(options) begin
  #     # Server loop:
  #     loop {
  #       conn = accept_conn()
  #       serve(conn)
  #     }
  #   end
  #
  # source://daemons//lib/daemons.rb#242
  def call(options = T.unsafe(nil), &block); end

  # Return the internal Controller instance.
  #
  # source://daemons//lib/daemons.rb#321
  def controller; end

  # Daemonize the currently runnig process, i.e. the calling process will become a daemon.
  #
  # +options+:: A hash that may contain one or more of the options listed below
  #
  # === Options:
  # <tt>:ontop</tt>::     When given, stay on top, i.e. do not daemonize the application
  # <tt>:backtrace</tt>:: Write a backtrace of the last exceptions to the file '[app_name].log' in the
  #                       pid-file directory if the application exits due to an uncaught exception
  # <tt>:app_name</tt>::  The name of the application. This will be
  #                       used to contruct the name of the pid files
  #                       and log files. Defaults to the basename of
  #                       the script.
  # <tt>:dir_mode</tt>::  Either <tt>:script</tt> (the directory for writing files to
  #                       given by <tt>:dir</tt> is interpreted relative
  #                       to the script location given by +script+, the default) or <tt>:normal</tt> (the directory given by
  #                       <tt>:dir</tt> is interpreted as a (absolute or relative) path) or <tt>:system</tt>
  #                       (<tt>/var/run</tt> is used as the file directory)
  #
  # <tt>:dir</tt>::       Used in combination with <tt>:dir_mode</tt> (description above)
  # <tt>:log_dir</tt>::   A specific directory to put the log files into (when not given, resort to the default
  #                       location as derived from the :dir_mode and :dir options
  # <tt>:log_output</tt>:: When given (i.e. set to true), redirect both $stdout and $stdout to a logfile named '[app_name].output' in the pid-file directory
  # <tt>:log_output_syslog</tt>:: When set to true, redirect output into SYSLOG instead of the file. This overrides log_output setting.
  # -----
  #
  # === Example:
  #   options = {
  #     :backtrace  => true,
  #     :ontop      => true,
  #     :log_output => true
  #   }
  #
  #   Daemons.daemonize(options)
  #
  #   # Server loop:
  #   loop {
  #     conn = accept_conn()
  #     puts "some text which goes to the output logfile"
  #     serve(conn)
  #   }
  #
  # source://daemons//lib/daemons.rb#305
  def daemonize(options = T.unsafe(nil)); end

  # Return the internal ApplicationGroup instance.
  #
  # source://daemons//lib/daemons.rb#315
  def group; end

  # Create a new Daemon application, like <tt>Daemons.call</tt>, but will not start it automatically
  #
  # source://daemons//lib/daemons.rb#250
  def new(options = T.unsafe(nil), &block); end

  # Passes control to Daemons.
  # This is used in wrapper-scripts that are supposed to control other ruby scripts or
  # external applications. Control is completely passed to the daemons library.
  # Such wrapper script should be invoked with command line options like 'start' or 'stop'
  # to do anything useful.
  #
  # +script+::  This is the path to the script that should be run as a daemon.
  #             Please note that Daemons runs this script with <tt>load <script></tt>.
  #             Also note that Daemons cannot detect the directory in which the controlling
  #             script resides, so this has to be either an absolute path or you have to run
  #             the controlling script from the appropriate directory. Your script name should not
  #             end with _monitor because that name is reserved for a monitor process which is
  #             there to restart your daemon if it crashes.
  #
  # +options+:: A hash that may contain one or more of the options listed below
  #
  # === Options:
  # <tt>:app_name</tt>::  The name of the application. This will be
  #                       used to contruct the name of the pid files
  #                       and log files. Defaults to the basename of
  #                       the script.
  # <tt>:ARGV</tt>::      An array of strings containing parameters and switches for Daemons.
  #                       This includes both parameters for Daemons itself and the controlled scripted.
  #                       These are assumed to be separated by an array element '--', .e.g.
  #                       ['start', 'f', '--', 'param1_for_script', 'param2_for_script'].
  #                       If not given, ARGV (the parameters given to the Ruby process) will be used.
  # <tt>:dir_mode</tt>::  Either <tt>:script</tt> (the directory for writing the pid files to
  #                       given by <tt>:dir</tt> is interpreted relative
  #                       to the script location given by +script+, the default) or <tt>:normal</tt> (the directory given by
  #                       <tt>:dir</tt> is interpreted as a (absolute or relative) path) or <tt>:system</tt>
  #                       (<tt>/var/run</tt> is used as the pid file directory)
  #
  # <tt>:dir</tt>::       Used in combination with <tt>:dir_mode</tt> (description above)
  # <tt>:multiple</tt>::  Specifies whether multiple instances of the same script are allowed to run at the
  #                       same time
  # <tt>:pid_delimiter</tt>:: Specifies the separator used when enumerating multiple process names/pid-files. Default is '_num'.
  # <tt>:ontop</tt>::     When given (i.e. set to true), stay on top, i.e. do not daemonize the application
  #                       (but the pid-file and other things are written as usual)
  # <tt>:shush</tt>::     When given (i.e. set to true), turn on silent mode (no output to the terminal)
  # <tt>:mode</tt>::      <tt>:load</tt> Load the script with <tt>Kernel.load</tt>;
  #                       note that :stop_proc only works for the :load (and :proc) mode.
  #                       <tt>:exec</tt> Execute the script file with <tt>Kernel.exec</tt>
  # <tt>:backtrace</tt>:: Write a backtrace of the last exceptions to the file '[app_name].log' in the
  #                       pid-file directory if the application exits due to an uncaught exception
  # <tt>:monitor</tt>::   Monitor the programs and restart crashed instances
  # <tt>:monitor_interval</tt>:: Interval in sesconds at which to check whether the instances are still running
  # <tt>:log_dir</tt>::   A specific directory to put the log files into (when not given, resort to the default
  #                       location as derived from the :dir_mode and :dir options
  # <tt>:logfilename</tt>:: Specifiy a custom log file name
  # <tt>:log_output</tt>:: When given (i.e. set to true), redirect both $stdout and $stderr to a logfile named '[app_name].output' (or as given in :output_logfilename) in the pid-file directory
  # <tt>:output_logfilename</tt>:: Specifiy a custom output redirection file name
  # <tt>:log_output_syslog</tt>:: When set to true, redirect output into SYSLOG instead of the file. This overrides log_output setting.
  # <tt>:keep_pid_files</tt>:: When given do not delete lingering pid-files (files for which the process is no longer running).
  # <tt>:hard_exit</tt>:: When given use exit! to end a daemons instead of exit (this will for example
  #                       not call at_exit handlers).
  # <tt>:stop_proc</tt>:: A proc that will be called when the daemonized process receives a request to stop (works only for :load and :proc mode)
  #
  # -----
  #
  # === Example:
  #   options = {
  #     :app_name           => "my_app",
  #     :ARGV               => ['start', '-f', '--', 'param_for_myscript']
  #     :dir_mode           => :script,
  #     :dir                => 'pids',
  #     :multiple           => true,
  #     :pid_delimiter      => '.n',
  #     :ontop              => true,
  #     :shush              => false,
  #     :mode               => :exec,
  #     :backtrace          => true,
  #     :monitor            => true,
  #     :logfilename        => 'custom_logfile.log',
  #     :output_logfilename => 'custom_outputfile.txt'
  #   }
  #
  #   Daemons.run(File.join(File.dirname(__FILE__), 'myscript.rb'), options)
  #
  # source://daemons//lib/daemons.rb#145
  def run(script, options = T.unsafe(nil)); end

  # Passes control to Daemons.
  # This function does the same as Daemons.run except that not a script but a proc
  # will be run as a daemon while this script provides command line options like 'start' or 'stop'
  # and the whole pid-file management to control the proc.
  #
  # +app_name+::  The name of the application. This will be
  #               used to contruct the name of the pid files
  #               and log files. Defaults to the basename of
  #               the script.
  #
  # +options+::   A hash that may contain one or more of the options listed in the documentation for Daemons.run
  #
  # A block must be given to this function. The block will be used as the :proc entry in the options hash.
  #
  # -----
  #
  # === Example:
  #
  #   Daemons.run_proc('myproc.rb') do
  #     loop do
  #       accept_connection()
  #       read_request()
  #       send_response()
  #       close_connection()
  #     end
  #   end
  #
  # source://daemons//lib/daemons.rb#185
  def run_proc(app_name, options = T.unsafe(nil), &block); end

  class << self
    # Execute the block in a new daemon. <tt>Daemons.call</tt> will return immediately
    # after spawning the daemon with the new Application object as a return value.
    #
    # +app_name+::  The name of the application.
    #
    # +options+:: A hash that may contain one or more of the options listed below
    #
    # +block+::   The block to call in the daemon.
    #
    # === Options:
    # <tt>:multiple</tt>::  Specifies whether multiple instances of the same script are allowed to run at the
    #                       same time
    # <tt>:monitor</tt>::   Monitor the programs and restart crashed instances
    # <tt>:monitor_interval</tt>:: Interval in sesconds at which to check whether the instances are still running
    # <tt>:ontop</tt>::     When given, stay on top, i.e. do not daemonize the application
    # <tt>:backtrace</tt>:: Write a backtrace of the last exceptions to the file '[app_name].log' in the
    #                       pid-file directory if the application exits due to an uncaught exception
    # -----
    #
    # === Example:
    #   options = {
    #     :app_name   => "myproc",
    #     :backtrace  => true,
    #     :monitor    => true,
    #     :ontop      => true
    #   }
    #
    #   Daemons.call(options) begin
    #     # Server loop:
    #     loop {
    #       conn = accept_conn()
    #       serve(conn)
    #     }
    #   end
    #
    # source://daemons//lib/daemons.rb#242
    def call(options = T.unsafe(nil), &block); end

    # Return the internal Controller instance.
    #
    # source://daemons//lib/daemons.rb#321
    def controller; end

    # Daemonize the currently runnig process, i.e. the calling process will become a daemon.
    #
    # +options+:: A hash that may contain one or more of the options listed below
    #
    # === Options:
    # <tt>:ontop</tt>::     When given, stay on top, i.e. do not daemonize the application
    # <tt>:backtrace</tt>:: Write a backtrace of the last exceptions to the file '[app_name].log' in the
    #                       pid-file directory if the application exits due to an uncaught exception
    # <tt>:app_name</tt>::  The name of the application. This will be
    #                       used to contruct the name of the pid files
    #                       and log files. Defaults to the basename of
    #                       the script.
    # <tt>:dir_mode</tt>::  Either <tt>:script</tt> (the directory for writing files to
    #                       given by <tt>:dir</tt> is interpreted relative
    #                       to the script location given by +script+, the default) or <tt>:normal</tt> (the directory given by
    #                       <tt>:dir</tt> is interpreted as a (absolute or relative) path) or <tt>:system</tt>
    #                       (<tt>/var/run</tt> is used as the file directory)
    #
    # <tt>:dir</tt>::       Used in combination with <tt>:dir_mode</tt> (description above)
    # <tt>:log_dir</tt>::   A specific directory to put the log files into (when not given, resort to the default
    #                       location as derived from the :dir_mode and :dir options
    # <tt>:log_output</tt>:: When given (i.e. set to true), redirect both $stdout and $stdout to a logfile named '[app_name].output' in the pid-file directory
    # <tt>:log_output_syslog</tt>:: When set to true, redirect output into SYSLOG instead of the file. This overrides log_output setting.
    # -----
    #
    # === Example:
    #   options = {
    #     :backtrace  => true,
    #     :ontop      => true,
    #     :log_output => true
    #   }
    #
    #   Daemons.daemonize(options)
    #
    #   # Server loop:
    #   loop {
    #     conn = accept_conn()
    #     puts "some text which goes to the output logfile"
    #     serve(conn)
    #   }
    #
    # source://daemons//lib/daemons.rb#305
    def daemonize(options = T.unsafe(nil)); end

    # Return the internal ApplicationGroup instance.
    #
    # source://daemons//lib/daemons.rb#315
    def group; end

    # Create a new Daemon application, like <tt>Daemons.call</tt>, but will not start it automatically
    #
    # source://daemons//lib/daemons.rb#250
    def new(options = T.unsafe(nil), &block); end

    # Passes control to Daemons.
    # This is used in wrapper-scripts that are supposed to control other ruby scripts or
    # external applications. Control is completely passed to the daemons library.
    # Such wrapper script should be invoked with command line options like 'start' or 'stop'
    # to do anything useful.
    #
    # +script+::  This is the path to the script that should be run as a daemon.
    #             Please note that Daemons runs this script with <tt>load <script></tt>.
    #             Also note that Daemons cannot detect the directory in which the controlling
    #             script resides, so this has to be either an absolute path or you have to run
    #             the controlling script from the appropriate directory. Your script name should not
    #             end with _monitor because that name is reserved for a monitor process which is
    #             there to restart your daemon if it crashes.
    #
    # +options+:: A hash that may contain one or more of the options listed below
    #
    # === Options:
    # <tt>:app_name</tt>::  The name of the application. This will be
    #                       used to contruct the name of the pid files
    #                       and log files. Defaults to the basename of
    #                       the script.
    # <tt>:ARGV</tt>::      An array of strings containing parameters and switches for Daemons.
    #                       This includes both parameters for Daemons itself and the controlled scripted.
    #                       These are assumed to be separated by an array element '--', .e.g.
    #                       ['start', 'f', '--', 'param1_for_script', 'param2_for_script'].
    #                       If not given, ARGV (the parameters given to the Ruby process) will be used.
    # <tt>:dir_mode</tt>::  Either <tt>:script</tt> (the directory for writing the pid files to
    #                       given by <tt>:dir</tt> is interpreted relative
    #                       to the script location given by +script+, the default) or <tt>:normal</tt> (the directory given by
    #                       <tt>:dir</tt> is interpreted as a (absolute or relative) path) or <tt>:system</tt>
    #                       (<tt>/var/run</tt> is used as the pid file directory)
    #
    # <tt>:dir</tt>::       Used in combination with <tt>:dir_mode</tt> (description above)
    # <tt>:multiple</tt>::  Specifies whether multiple instances of the same script are allowed to run at the
    #                       same time
    # <tt>:pid_delimiter</tt>:: Specifies the separator used when enumerating multiple process names/pid-files. Default is '_num'.
    # <tt>:ontop</tt>::     When given (i.e. set to true), stay on top, i.e. do not daemonize the application
    #                       (but the pid-file and other things are written as usual)
    # <tt>:shush</tt>::     When given (i.e. set to true), turn on silent mode (no output to the terminal)
    # <tt>:mode</tt>::      <tt>:load</tt> Load the script with <tt>Kernel.load</tt>;
    #                       note that :stop_proc only works for the :load (and :proc) mode.
    #                       <tt>:exec</tt> Execute the script file with <tt>Kernel.exec</tt>
    # <tt>:backtrace</tt>:: Write a backtrace of the last exceptions to the file '[app_name].log' in the
    #                       pid-file directory if the application exits due to an uncaught exception
    # <tt>:monitor</tt>::   Monitor the programs and restart crashed instances
    # <tt>:monitor_interval</tt>:: Interval in sesconds at which to check whether the instances are still running
    # <tt>:log_dir</tt>::   A specific directory to put the log files into (when not given, resort to the default
    #                       location as derived from the :dir_mode and :dir options
    # <tt>:logfilename</tt>:: Specifiy a custom log file name
    # <tt>:log_output</tt>:: When given (i.e. set to true), redirect both $stdout and $stderr to a logfile named '[app_name].output' (or as given in :output_logfilename) in the pid-file directory
    # <tt>:output_logfilename</tt>:: Specifiy a custom output redirection file name
    # <tt>:log_output_syslog</tt>:: When set to true, redirect output into SYSLOG instead of the file. This overrides log_output setting.
    # <tt>:keep_pid_files</tt>:: When given do not delete lingering pid-files (files for which the process is no longer running).
    # <tt>:hard_exit</tt>:: When given use exit! to end a daemons instead of exit (this will for example
    #                       not call at_exit handlers).
    # <tt>:stop_proc</tt>:: A proc that will be called when the daemonized process receives a request to stop (works only for :load and :proc mode)
    #
    # -----
    #
    # === Example:
    #   options = {
    #     :app_name           => "my_app",
    #     :ARGV               => ['start', '-f', '--', 'param_for_myscript']
    #     :dir_mode           => :script,
    #     :dir                => 'pids',
    #     :multiple           => true,
    #     :pid_delimiter      => '.n',
    #     :ontop              => true,
    #     :shush              => false,
    #     :mode               => :exec,
    #     :backtrace          => true,
    #     :monitor            => true,
    #     :logfilename        => 'custom_logfile.log',
    #     :output_logfilename => 'custom_outputfile.txt'
    #   }
    #
    #   Daemons.run(File.join(File.dirname(__FILE__), 'myscript.rb'), options)
    #
    # source://daemons//lib/daemons.rb#145
    def run(script, options = T.unsafe(nil)); end

    # Passes control to Daemons.
    # This function does the same as Daemons.run except that not a script but a proc
    # will be run as a daemon while this script provides command line options like 'start' or 'stop'
    # and the whole pid-file management to control the proc.
    #
    # +app_name+::  The name of the application. This will be
    #               used to contruct the name of the pid files
    #               and log files. Defaults to the basename of
    #               the script.
    #
    # +options+::   A hash that may contain one or more of the options listed in the documentation for Daemons.run
    #
    # A block must be given to this function. The block will be used as the :proc entry in the options hash.
    #
    # -----
    #
    # === Example:
    #
    #   Daemons.run_proc('myproc.rb') do
    #     loop do
    #       accept_connection()
    #       read_request()
    #       send_response()
    #       close_connection()
    #     end
    #   end
    #
    # source://daemons//lib/daemons.rb#185
    def run_proc(app_name, options = T.unsafe(nil), &block); end
  end
end

# source://daemons//lib/daemons/application.rb#11
class Daemons::Application
  # @return [Application] a new instance of Application
  #
  # source://daemons//lib/daemons/application.rb#26
  def initialize(group, add_options = T.unsafe(nil), pid = T.unsafe(nil)); end

  # Returns the value of attribute app_argv.
  #
  # source://daemons//lib/daemons/application.rb#12
  def app_argv; end

  # Sets the attribute app_argv
  #
  # @param value the value to set the attribute app_argv to.
  #
  # source://daemons//lib/daemons/application.rb#12
  def app_argv=(_arg0); end

  # source://daemons//lib/daemons/application.rb#65
  def change_privilege; end

  # Returns the value of attribute controller_argv.
  #
  # source://daemons//lib/daemons/application.rb#13
  def controller_argv; end

  # Sets the attribute controller_argv
  #
  # @param value the value to set the attribute controller_argv to.
  #
  # source://daemons//lib/daemons/application.rb#13
  def controller_argv=(_arg0); end

  # source://daemons//lib/daemons/application.rb#438
  def default_show_status(daemon = T.unsafe(nil)); end

  # This is a nice little function for debugging purposes:
  # In case a multi-threaded ruby script exits due to an uncaught exception
  # it may be difficult to find out where the exception came from because
  # one cannot catch exceptions that are thrown in threads other than the main
  # thread.
  #
  # This function searches for all exceptions in memory and outputs them to $stderr
  # (if it is connected) and to a log file in the pid-file directory.
  #
  # source://daemons//lib/daemons/application.rb#341
  def exception_log; end

  # the ApplicationGroup the application belongs to
  #
  # source://daemons//lib/daemons/application.rb#19
  def group; end

  # source://daemons//lib/daemons/application.rb#82
  def logdir; end

  # source://daemons//lib/daemons/application.rb#103
  def logfile; end

  # source://daemons//lib/daemons/application.rb#99
  def logfilename; end

  # my private options
  #
  # source://daemons//lib/daemons/application.rb#22
  def options; end

  # source://daemons//lib/daemons/application.rb#91
  def output_logfile; end

  # source://daemons//lib/daemons/application.rb#87
  def output_logfilename; end

  # the Pid instance belonging to this application
  #
  # source://daemons//lib/daemons/application.rb#16
  def pid; end

  # source://daemons//lib/daemons/application.rb#78
  def pidfile_dir; end

  # source://daemons//lib/daemons/application.rb#319
  def reload; end

  # This function implements a (probably too simle) method to detect
  # whether the program with the pid found in the pid-file is still running.
  # It just searches for the pid in the output of <tt>ps ax</tt>, which
  # is probably not a good idea in some cases.
  # Alternatives would be to use a direct access method the unix process control
  # system.
  #
  # @return [Boolean]
  #
  # source://daemons//lib/daemons/application.rb#451
  def running?; end

  # source://daemons//lib/daemons/application.rb#74
  def script; end

  # source://daemons//lib/daemons/application.rb#434
  def show_status; end

  # source://daemons//lib/daemons/application.rb#56
  def show_status_callback=(function); end

  # source://daemons//lib/daemons/application.rb#291
  def start(restart = T.unsafe(nil)); end

  # source://daemons//lib/daemons/application.rb#152
  def start_exec; end

  # source://daemons//lib/daemons/application.rb#172
  def start_load; end

  # this function is only used to daemonize the currently running process (Daemons.daemonize)
  #
  # source://daemons//lib/daemons/application.rb#110
  def start_none; end

  # source://daemons//lib/daemons/application.rb#233
  def start_proc; end

  # source://daemons//lib/daemons/application.rb#313
  def started; end

  # source://daemons//lib/daemons/application.rb#372
  def stop(no_wait = T.unsafe(nil)); end

  # @param Hash remaing_signals
  # @param Boolean no_wait Send first Signal and return
  #
  # source://daemons//lib/daemons/application.rb#404
  def wait_and_retry_kill_harder(pid, remaining_signals, no_wait = T.unsafe(nil)); end

  # source://daemons//lib/daemons/application.rb#426
  def zap; end

  # source://daemons//lib/daemons/application.rb#430
  def zap!; end

  private

  # source://daemons//lib/daemons/application.rb#469
  def dir; end

  # source://daemons//lib/daemons/application.rb#465
  def dir_mode; end

  # @return [Boolean]
  #
  # source://daemons//lib/daemons/application.rb#457
  def log_output?; end

  # @return [Boolean]
  #
  # source://daemons//lib/daemons/application.rb#461
  def log_output_syslog?; end

  # source://daemons//lib/daemons/application.rb#473
  def parse_signals_and_waits(argv); end
end

# source://daemons//lib/daemons/application.rb#24
Daemons::Application::SIGNAL = T.let(T.unsafe(nil), String)

# source://daemons//lib/daemons/application_group.rb#3
class Daemons::ApplicationGroup
  # @return [ApplicationGroup] a new instance of ApplicationGroup
  #
  # source://daemons//lib/daemons/application_group.rb#22
  def initialize(app_name, options = T.unsafe(nil)); end

  # Returns the value of attribute app_argv.
  #
  # source://daemons//lib/daemons/application_group.rb#14
  def app_argv; end

  # Sets the attribute app_argv
  #
  # @param value the value to set the attribute app_argv to.
  #
  # source://daemons//lib/daemons/application_group.rb#14
  def app_argv=(_arg0); end

  # Returns the value of attribute app_name.
  #
  # source://daemons//lib/daemons/application_group.rb#4
  def app_name; end

  # Returns the value of attribute applications.
  #
  # source://daemons//lib/daemons/application_group.rb#11
  def applications; end

  # Returns the value of attribute controller_argv.
  #
  # source://daemons//lib/daemons/application_group.rb#13
  def controller_argv; end

  # Sets the attribute controller_argv
  #
  # @param value the value to set the attribute controller_argv to.
  #
  # source://daemons//lib/daemons/application_group.rb#13
  def controller_argv=(_arg0); end

  # source://daemons//lib/daemons/application_group.rb#143
  def create_monitor(an_app); end

  # Returns the value of attribute dir.
  #
  # source://daemons//lib/daemons/application_group.rb#17
  def dir; end

  # Sets the attribute dir
  #
  # @param value the value to set the attribute dir to.
  #
  # source://daemons//lib/daemons/application_group.rb#17
  def dir=(_arg0); end

  # Returns the value of attribute dir_mode.
  #
  # source://daemons//lib/daemons/application_group.rb#16
  def dir_mode; end

  # Sets the attribute dir_mode
  #
  # @param value the value to set the attribute dir_mode to.
  #
  # source://daemons//lib/daemons/application_group.rb#16
  def dir_mode=(_arg0); end

  # source://daemons//lib/daemons/application_group.rb#61
  def find_applications(dir); end

  # TODO: identifiy the monitor process
  #
  # source://daemons//lib/daemons/application_group.rb#70
  def find_applications_by_app_name(app_name); end

  # source://daemons//lib/daemons/application_group.rb#96
  def find_applications_by_pidfiles(dir); end

  # Returns the value of attribute monitor.
  #
  # source://daemons//lib/daemons/application_group.rb#7
  def monitor; end

  # true if the application is supposed to run in multiple instances
  #
  # source://daemons//lib/daemons/application_group.rb#20
  def multiple; end

  # source://daemons//lib/daemons/application_group.rb#111
  def new_application(add_options = T.unsafe(nil)); end

  # Returns the value of attribute options.
  #
  # source://daemons//lib/daemons/application_group.rb#9
  def options; end

  # source://daemons//lib/daemons/application_group.rb#57
  def pidfile_dir; end

  # source://daemons//lib/daemons/application_group.rb#188
  def reload_all; end

  # Check whether at least one of the applications in the group is running. If yes, return true.
  #
  # @return [Boolean]
  #
  # source://daemons//lib/daemons/application_group.rb#203
  def running?; end

  # Returns the value of attribute script.
  #
  # source://daemons//lib/daemons/application_group.rb#5
  def script; end

  # Setup the application group.
  # Currently this functions calls <tt>find_applications</tt> which finds
  # all running instances of the application and populates the application array.
  #
  # source://daemons//lib/daemons/application_group.rb#53
  def setup; end

  # source://daemons//lib/daemons/application_group.rb#198
  def show_status; end

  # source://daemons//lib/daemons/application_group.rb#157
  def start_all; end

  # source://daemons//lib/daemons/application_group.rb#170
  def stop_all(no_wait = T.unsafe(nil)); end

  # source://daemons//lib/daemons/application_group.rb#192
  def zap_all; end

  private

  # source://daemons//lib/daemons/application_group.rb#134
  def setup_app(app); end
end

# source://daemons//lib/daemons/exceptions.rb#8
class Daemons::CmdException < ::Daemons::Exception; end

# source://daemons//lib/daemons/cmdline.rb#103
class Daemons::Controller
  # @return [Controller] a new instance of Controller
  #
  # source://daemons//lib/daemons/controller.rb#12
  def initialize(options = T.unsafe(nil), argv = T.unsafe(nil)); end

  # Returns the value of attribute app_name.
  #
  # source://daemons//lib/daemons/controller.rb#4
  def app_name; end

  # source://daemons//lib/daemons/cmdline.rb#122
  def catch_exceptions(&block); end

  # Returns the value of attribute group.
  #
  # source://daemons//lib/daemons/controller.rb#6
  def group; end

  # Returns the value of attribute options.
  #
  # source://daemons//lib/daemons/controller.rb#8
  def options; end

  # source://daemons//lib/daemons/cmdline.rb#104
  def print_usage; end

  # source://daemons//lib/daemons/controller.rb#43
  def run; end

  # This function is used to do a final update of the options passed to the application
  # before they are really used.
  #
  # Note that this function should only update <tt>@options</tt> and no other variables.
  #
  # source://daemons//lib/daemons/controller.rb#40
  def setup_options; end

  class << self
    # Split an _argv_ array.
    # +argv+ is assumed to be in the following format:
    #   ['command', 'controller option 1', 'controller option 2', ..., '--', 'app option 1', ...]
    #
    # <tt>command</tt> must be one of the commands listed in <tt>COMMANDS</tt>
    #
    # *Returns*: the command as a string, the controller options as an array, the appliation options
    # as an array
    #
    # source://daemons//lib/daemons/controller.rb#99
    def split_argv(argv); end
  end
end

# source://daemons//lib/daemons/controller.rb#10
Daemons::Controller::COMMANDS = T.let(T.unsafe(nil), Array)

# source://daemons//lib/daemons/exceptions.rb#11
class Daemons::Error < ::Daemons::Exception; end

# source://daemons//lib/daemons/exceptions.rb#2
class Daemons::Exception < ::RuntimeError; end

# source://daemons//lib/daemons/monitor.rb#6
class Daemons::Monitor
  # @return [Monitor] a new instance of Monitor
  #
  # source://daemons//lib/daemons/monitor.rb#28
  def initialize(an_app, options = T.unsafe(nil)); end

  # source://daemons//lib/daemons/monitor.rb#89
  def start(application_group); end

  # source://daemons//lib/daemons/monitor.rb#99
  def stop; end

  private

  # source://daemons//lib/daemons/monitor.rb#61
  def start_with_pidfile(application_group); end

  # source://daemons//lib/daemons/monitor.rb#84
  def start_without_pidfile(application_group); end

  # source://daemons//lib/daemons/monitor.rb#40
  def watch(application_group); end

  class << self
    # source://daemons//lib/daemons/monitor.rb#7
    def find(dir, app_name); end
  end
end

# source://daemons//lib/daemons/cmdline.rb#2
class Daemons::Optparse
  # @return [Optparse] a new instance of Optparse
  #
  # source://daemons//lib/daemons/cmdline.rb#5
  def initialize(controller); end

  # Return a hash describing the options.
  #
  # source://daemons//lib/daemons/cmdline.rb#93
  def parse(args); end

  # Returns the value of attribute usage.
  #
  # source://daemons//lib/daemons/cmdline.rb#3
  def usage; end
end

# source://daemons//lib/daemons/pid.rb#4
class Daemons::Pid
  # Initialization method
  #
  # @return [Pid] a new instance of Pid
  #
  # source://daemons//lib/daemons/pid.rb#49
  def initialize; end

  # Cleanup method
  #
  # source://daemons//lib/daemons/pid.rb#66
  def cleanup; end

  # Exist? method
  #
  # @return [Boolean]
  #
  # source://daemons//lib/daemons/pid.rb#74
  def exist?; end

  # Get method
  #
  # source://daemons//lib/daemons/pid.rb#53
  def pid; end

  # Set method
  #
  # source://daemons//lib/daemons/pid.rb#57
  def pid=(p); end

  # Check whether the process is running
  #
  # @return [Boolean]
  #
  # source://daemons//lib/daemons/pid.rb#61
  def running?; end

  # Zap method
  #
  # source://daemons//lib/daemons/pid.rb#70
  def zap; end

  class << self
    # Returns the directory that should be used to write the pid file to
    # depending on the given mode.
    #
    # Some modes may require an additionaly hint, others may determine
    # the directory automatically.
    #
    # If no valid directory is found, returns nil.
    #
    # source://daemons//lib/daemons/pid.rb#32
    def dir(dir_mode, dir, script); end

    # @return [Boolean]
    #
    # source://daemons//lib/daemons/pid.rb#5
    def running?(pid); end
  end
end

# === What is a Pid-File?
# A <i>Pid-File</i> is a file containing the <i>process identification number</i>
# (pid) that is stored in a well-defined location of the filesystem thus allowing other
# programs to find out the pid of a running script.
#
# Daemons needs the pid of the scripts that are currently running in the background
# to send them so called _signals_. Daemons uses the +TERM+ signal to tell the script
# to exit when you issue a +stop+ command.
#
# === How does a Pid-File look like?
#
# Pid-Files generated by Daemons have to following format:
#   <scriptname>_num<number>.pid
# (Note that <tt>_num<number></tt> is omitted if only one instance of the script can
# run at any time)
#
# Each file just contains one line with the pid as string (for example <tt>6432</tt>).
#
# === Where are the Pid-Files stored?
#
# Daemons is configurable to store the Pid-Files relative to three different locations:
# 1.  in a directory relative to the directory where the script (the one that is supposed to run
#     as a daemon) resides (<tt>:script</tt> option for <tt>:dir_mode</tt>)
# 2.  in a directory given by <tt>:dir</tt> (<tt>:normal</tt> option for <tt>:dir_mode</tt>)
# 3.  in the preconfigured directory <tt>/var/run</tt> (<tt>:system</tt> option for <tt>:dir_mode</tt>)
#
# source://daemons//lib/daemons/pidfile.rb#30
class Daemons::PidFile < ::Daemons::Pid
  # @return [PidFile] a new instance of PidFile
  #
  # source://daemons//lib/daemons/pidfile.rb#66
  def initialize(dir, progname, multiple = T.unsafe(nil), pid_delimiter = T.unsafe(nil)); end

  # source://daemons//lib/daemons/pidfile.rb#101
  def cleanup; end

  # Returns the value of attribute dir.
  #
  # source://daemons//lib/daemons/pidfile.rb#32
  def dir; end

  # @return [Boolean]
  #
  # source://daemons//lib/daemons/pidfile.rb#90
  def exist?; end

  # source://daemons//lib/daemons/pidfile.rb#85
  def filename; end

  # Returns the value of attribute multiple.
  #
  # source://daemons//lib/daemons/pidfile.rb#32
  def multiple; end

  # Returns the value of attribute number.
  #
  # source://daemons//lib/daemons/pidfile.rb#32
  def number; end

  # source://daemons//lib/daemons/pidfile.rb#109
  def pid; end

  # source://daemons//lib/daemons/pidfile.rb#94
  def pid=(p); end

  # Returns the value of attribute pid_delimiter.
  #
  # source://daemons//lib/daemons/pidfile.rb#32
  def pid_delimiter; end

  # Returns the value of attribute progname.
  #
  # source://daemons//lib/daemons/pidfile.rb#32
  def progname; end

  # source://daemons//lib/daemons/pidfile.rb#105
  def zap; end

  class << self
    # source://daemons//lib/daemons/pidfile.rb#54
    def existing(path); end

    # source://daemons//lib/daemons/pidfile.rb#34
    def find_files(dir, progname, delete = T.unsafe(nil), pid_delimiter = T.unsafe(nil)); end
  end
end

# source://daemons//lib/daemons/pidfile.rb#31
Daemons::PidFile::DEFAULT_PID_DELIMITER = T.let(T.unsafe(nil), String)

# source://daemons//lib/daemons/pidmem.rb#4
class Daemons::PidMem < ::Daemons::Pid
  # Returns the value of attribute pid.
  #
  # source://daemons//lib/daemons/pidmem.rb#5
  def pid; end

  # Sets the attribute pid
  #
  # @param value the value to set the attribute pid to.
  #
  # source://daemons//lib/daemons/pidmem.rb#5
  def pid=(_arg0); end

  class << self
    # source://daemons//lib/daemons/pidmem.rb#7
    def existing(numeric_pid); end
  end
end

# source://daemons//lib/daemons/reporter.rb#2
class Daemons::Reporter
  # @return [Reporter] a new instance of Reporter
  #
  # source://daemons//lib/daemons/reporter.rb#5
  def initialize(options); end

  # source://daemons//lib/daemons/reporter.rb#31
  def backtrace_not_supported; end

  # source://daemons//lib/daemons/reporter.rb#40
  def cannot_stop_process(app_name, pid); end

  # source://daemons//lib/daemons/reporter.rb#19
  def changing_process_privilege(user, group = T.unsafe(nil)); end

  # source://daemons//lib/daemons/reporter.rb#23
  def deleted_found_pidfile(pid, f); end

  # Returns the value of attribute options.
  #
  # source://daemons//lib/daemons/reporter.rb#3
  def options; end

  # source://daemons//lib/daemons/reporter.rb#13
  def output_message(message); end

  # source://daemons//lib/daemons/reporter.rb#27
  def process_started(app_name, pid); end

  # source://daemons//lib/daemons/reporter.rb#50
  def status(app_name, running, pid_exists, pid); end

  # source://daemons//lib/daemons/reporter.rb#45
  def stopped_process(app_name, pid); end

  # source://daemons//lib/daemons/reporter.rb#35
  def stopping_process(app_name, pid, sig, wait); end
end

# source://daemons//lib/daemons/exceptions.rb#5
class Daemons::RuntimeException < ::Daemons::Exception; end

# source://daemons//lib/daemons/exceptions.rb#14
class Daemons::SystemError < ::Daemons::Error
  # @return [SystemError] a new instance of SystemError
  #
  # source://daemons//lib/daemons/exceptions.rb#17
  def initialize(msg, system_error); end

  # Returns the value of attribute system_error.
  #
  # source://daemons//lib/daemons/exceptions.rb#15
  def system_error; end
end

# source://daemons//lib/daemons/exceptions.rb#24
class Daemons::TimeoutError < ::Daemons::Error; end

# source://daemons//lib/daemons/version.rb#2
Daemons::VERSION = T.let(T.unsafe(nil), String)
