# Security Policy

We take the security of this project seriously and appreciate your efforts to responsibly disclose vulnerabilities. This document outlines our security policy and provides guidelines on how to report vulnerabilities.

## Supported Versions

We provide security updates for the following versions of our project:

```markdown
| Version   | Supported          | Support Level                 |
| -------   | ------------------ | ----------------------------- |
| 0.19.x+   | :white_check_mark: | Full support                  |
| 0.18.x    | :white_check_mark: | Security updates only         |
| <= 0.17.x | :x:                | End of life (not supported)   |
```


If you are using an unsupported version, we strongly recommend upgrading to one of the supported versions to ensure you receive the latest security updates.


## Reporting a Vulnerability

If you discover a security vulnerability within this project, we encourage you to report it as soon as possible. Here’s how you can do it:

### How to Report

1. **Email**: Send an email to `security@onetimesecret.com` with the subject line "Vulnerability Report: [Brief Description]".
2. **Details**: Include as much information as possible about the vulnerability. This should include:
   - A detailed description of the vulnerability.
   - Steps to reproduce the issue.
   - Any potential impact.
   - Your contact information for follow-up questions.

### What to Expect

1. **Acknowledgment**: You will receive an acknowledgment of your report within 5 business days.
2. **Initial Assessment**: We will conduct an initial assessment of the vulnerability within 14 business days.
3. **Updates**: You can expect to receive updates on the status of your report at least once every 7 days until the issue is resolved or a decision is made.

### Resolution Process

1. **Accepted Vulnerabilities**: If the vulnerability is accepted, we will work on a fix and aim to release it as soon as possible. You will be notified once the fix is deployed.
2. **Declined Vulnerabilities**: If the vulnerability is declined, we will provide a detailed explanation as to why it was not accepted.

### Confidentiality

We take your privacy seriously. All reports will be kept confidential, and we will work with you to ensure that any details of the vulnerability are not disclosed until a fix is in place.

Thank you for helping us keep Onetime Secret secure and excellent!
