/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.export;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.export.TemplateFile;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportGradleProject {
    private static final Logger LOG = LoggerFactory.getLogger(ExportGradleProject.class);
    private static final Set<String> IGNORE_CLS_NAMES = new HashSet<String>(Arrays.asList("R", "BuildConfig"));
    private final RootNode root;
    private final File outDir;
    private final File srcOutDir;
    private final File resOutDir;

    public ExportGradleProject(RootNode root, File outDir) {
        this.root = root;
        this.outDir = outDir;
        this.srcOutDir = new File(outDir, "src/main/java");
        this.resOutDir = new File(outDir, "src/main");
    }

    public void init() {
        try {
            FileUtils.makeDirs(this.srcOutDir);
            FileUtils.makeDirs(this.resOutDir);
            this.saveBuildGradle();
            this.skipGeneratedClasses();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Gradle export failed", e);
        }
    }

    private void saveBuildGradle() throws IOException {
        TemplateFile tmpl = TemplateFile.fromResources("/export/build.gradle.tmpl");
        String appPackage = this.root.getAppPackage();
        if (appPackage == null) {
            appPackage = "UNKNOWN";
        }
        tmpl.add("applicationId", appPackage);
        tmpl.add("minSdkVersion", 9);
        tmpl.add("targetSdkVersion", 21);
        tmpl.save(new File(this.outDir, "build.gradle"));
    }

    private void skipGeneratedClasses() {
        for (ClassNode cls : this.root.getClasses()) {
            String shortName = cls.getClassInfo().getShortName();
            if (!IGNORE_CLS_NAMES.contains(shortName)) continue;
            cls.add(AFlag.DONT_GENERATE);
            LOG.debug("Skip class: {}", (Object)cls);
        }
    }

    public File getSrcOutDir() {
        return this.srcOutDir;
    }

    public File getResOutDir() {
        return this.resOutDir;
    }
}

